/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * Copyright (C) 2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebPreferencesStore.h"

#include "WebPreferencesDefinitions.h"
#include "WebPreferencesKeys.h"
#include <variant>
#include <wtf/NeverDestroyed.h>

// FIXME: These should added via options in WebPreferences.yaml, rather than hardcoded.
#include <WebCore/DeprecatedGlobalSettings.h>
#include <WebCore/LibWebRTCProvider.h>
#include <WebCore/RealtimeMediaSourceCenter.h>
#include <WebCore/SecurityOrigin.h>
#include <WebCore/Settings.h>
#include <pal/text/TextEncodingRegistry.h>

namespace WebKit {
using namespace WebCore;

WebPreferencesStore::ValueMap& WebPreferencesStore::defaults()
{
    static NeverDestroyed<ValueMap> defaults;
    if (defaults.get().isEmpty()) {
#if USE(AVFOUNDATION)
        defaults.get().set(WebPreferencesKey::isAVFoundationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AVFoundationEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::acceleratedCompositingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AcceleratedCompositingEnabled)));
        defaults.get().set(WebPreferencesKey::acceleratedCompositingForFixedPositionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AcceleratedCompositingForFixedPositionEnabled)));
        defaults.get().set(WebPreferencesKey::acceleratedDrawingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AcceleratedDrawingEnabled)));
#if USE(CORE_IMAGE)
        defaults.get().set(WebPreferencesKey::acceleratedFiltersEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AcceleratedFiltersEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::accentColorEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AccentColorEnabled)));
        defaults.get().set(WebPreferencesKey::accessHandleEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AccessHandleEnabled)));
        defaults.get().set(WebPreferencesKey::accessibilityObjectModelEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AccessibilityObjectModelEnabled)));
        defaults.get().set(WebPreferencesKey::aggressiveTileRetentionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AggressiveTileRetentionEnabled)));
        defaults.get().set(WebPreferencesKey::allowContentSecurityPolicySourceStarToMatchAnyProtocolKey(), Value(bool(DEFAULT_VALUE_FOR_AllowContentSecurityPolicySourceStarToMatchAnyProtocol)));
        defaults.get().set(WebPreferencesKey::allowCrossOriginSubresourcesToAskForCredentialsKey(), Value(bool(DEFAULT_VALUE_FOR_AllowCrossOriginSubresourcesToAskForCredentials)));
        defaults.get().set(WebPreferencesKey::allowDisplayOfInsecureContentKey(), Value(bool(DEFAULT_VALUE_FOR_AllowDisplayOfInsecureContent)));
        defaults.get().set(WebPreferencesKey::allowFileAccessFromFileURLsKey(), Value(bool(DEFAULT_VALUE_FOR_AllowFileAccessFromFileURLs)));
        defaults.get().set(WebPreferencesKey::allowMediaContentTypesRequiringHardwareSupportAsFallbackKey(), Value(bool(DEFAULT_VALUE_FOR_AllowMediaContentTypesRequiringHardwareSupportAsFallback)));
        defaults.get().set(WebPreferencesKey::allowMultiElementImplicitSubmissionKey(), Value(bool(DEFAULT_VALUE_FOR_AllowMultiElementImplicitSubmission)));
        defaults.get().set(WebPreferencesKey::allowRunningOfInsecureContentKey(), Value(bool(DEFAULT_VALUE_FOR_AllowRunningOfInsecureContent)));
        defaults.get().set(WebPreferencesKey::allowSettingAnyXHRHeaderFromFileURLsKey(), Value(bool(DEFAULT_VALUE_FOR_AllowSettingAnyXHRHeaderFromFileURLs)));
        defaults.get().set(WebPreferencesKey::allowTopNavigationToDataURLsKey(), Value(bool(DEFAULT_VALUE_FOR_AllowTopNavigationToDataURLs)));
        defaults.get().set(WebPreferencesKey::allowUniversalAccessFromFileURLsKey(), Value(bool(DEFAULT_VALUE_FOR_AllowUniversalAccessFromFileURLs)));
#if PLATFORM(IOS_FAMILY)
        defaults.get().set(WebPreferencesKey::allowViewportShrinkToFitContentKey(), Value(bool(DEFAULT_VALUE_FOR_AllowViewportShrinkToFitContent)));
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        defaults.get().set(WebPreferencesKey::allowsAirPlayForMediaPlaybackKey(), Value(bool(DEFAULT_VALUE_FOR_AllowsAirPlayForMediaPlayback)));
#endif
        defaults.get().set(WebPreferencesKey::allowsInlineMediaPlaybackKey(), Value(bool(DEFAULT_VALUE_FOR_AllowsInlineMediaPlayback)));
        defaults.get().set(WebPreferencesKey::allowsInlineMediaPlaybackAfterFullscreenKey(), Value(bool(DEFAULT_VALUE_FOR_AllowsInlineMediaPlaybackAfterFullscreen)));
        defaults.get().set(WebPreferencesKey::allowsPictureInPictureMediaPlaybackKey(), Value(bool(DEFAULT_VALUE_FOR_AllowsPictureInPictureMediaPlayback)));
#if PLATFORM(IOS_FAMILY)
        defaults.get().set(WebPreferencesKey::alternateFormControlDesignEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AlternateFormControlDesignEnabled)));
#endif
#if PLATFORM(IOS_FAMILY)
        defaults.get().set(WebPreferencesKey::alternateFullScreenControlDesignEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AlternateFullScreenControlDesignEnabled)));
#endif
#if ENABLE(ALTERNATE_WEBM_PLAYER)
        defaults.get().set(WebPreferencesKey::alternateWebMPlayerEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AlternateWebMPlayerEnabled)));
#endif
#if PLATFORM(IOS_FAMILY)
        defaults.get().set(WebPreferencesKey::alwaysZoomOnDoubleTapKey(), Value(bool(DEFAULT_VALUE_FOR_AlwaysZoomOnDoubleTap)));
#endif
        defaults.get().set(WebPreferencesKey::animatedImageAsyncDecodingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AnimatedImageAsyncDecodingEnabled)));
#if ENABLE(APP_HIGHLIGHTS)
        defaults.get().set(WebPreferencesKey::appHighlightsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AppHighlightsEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::appleMailPaginationQuirkEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AppleMailPaginationQuirkEnabled)));
#if ENABLE(APPLE_PAY)
        defaults.get().set(WebPreferencesKey::applePayCapabilityDisclosureAllowedKey(), Value(bool(DEFAULT_VALUE_FOR_ApplePayCapabilityDisclosureAllowed)));
#endif
#if ENABLE(APPLE_PAY)
        defaults.get().set(WebPreferencesKey::applePayEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ApplePayEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::ariaReflectionForElementReferencesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AriaReflectionForElementReferencesEnabled)));
        defaults.get().set(WebPreferencesKey::aspectRatioEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AspectRatioEnabled)));
        defaults.get().set(WebPreferencesKey::aspectRatioOfImgFromWidthAndHeightEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AspectRatioOfImgFromWidthAndHeightEnabled)));
        defaults.get().set(WebPreferencesKey::asyncClipboardAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AsyncClipboardAPIEnabled)));
        defaults.get().set(WebPreferencesKey::asyncFrameScrollingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AsyncFrameScrollingEnabled)));
        defaults.get().set(WebPreferencesKey::asyncOverflowScrollingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AsyncOverflowScrollingEnabled)));
        defaults.get().set(WebPreferencesKey::asynchronousSpellCheckingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AsynchronousSpellCheckingEnabled)));
#if ENABLE(ATTACHMENT_ELEMENT)
        defaults.get().set(WebPreferencesKey::attachmentElementEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AttachmentElementEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::authorAndUserStylesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AuthorAndUserStylesEnabled)));
        defaults.get().set(WebPreferencesKey::automaticLiveResizeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_AutomaticLiveResizeEnabled)));
        defaults.get().set(WebPreferencesKey::backspaceKeyNavigationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_BackspaceKeyNavigationEnabled)));
        defaults.get().set(WebPreferencesKey::beaconAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_BeaconAPIEnabled)));
        defaults.get().set(WebPreferencesKey::blankAnchorTargetImpliesNoOpenerEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_BlankAnchorTargetImpliesNoOpenerEnabled)));
        defaults.get().set(WebPreferencesKey::blockIOKitInWebContentSandboxKey(), Value(bool(DEFAULT_VALUE_FOR_BlockIOKitInWebContentSandbox)));
        defaults.get().set(WebPreferencesKey::broadcastChannelEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_BroadcastChannelEnabled)));
        defaults.get().set(WebPreferencesKey::broadcastChannelOriginPartitioningEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_BroadcastChannelOriginPartitioningEnabled)));
#if ENABLE(BUILT_IN_NOTIFICATIONS)
        defaults.get().set(WebPreferencesKey::builtInNotificationsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_BuiltInNotificationsEnabled)));
#endif
#if HAVE(NETWORK_LOADER)
        defaults.get().set(WebPreferencesKey::cFNetworkNetworkLoaderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CFNetworkNetworkLoaderEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::css3DTransformInteroperabilityEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSS3DTransformInteroperabilityEnabled)));
        defaults.get().set(WebPreferencesKey::cssCascadeLayersEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSCascadeLayersEnabled)));
        defaults.get().set(WebPreferencesKey::cssColor4Key(), Value(bool(DEFAULT_VALUE_FOR_CSSColor4)));
        defaults.get().set(WebPreferencesKey::cssColorContrastEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSColorContrastEnabled)));
        defaults.get().set(WebPreferencesKey::cssColorMixEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSColorMixEnabled)));
        defaults.get().set(WebPreferencesKey::cssContainIntrinsicSizeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSContainIntrinsicSizeEnabled)));
        defaults.get().set(WebPreferencesKey::cssContainerQueriesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSContainerQueriesEnabled)));
        defaults.get().set(WebPreferencesKey::cssContainmentEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSContainmentEnabled)));
        defaults.get().set(WebPreferencesKey::cssCounterStyleAtRuleImageSymbolsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSCounterStyleAtRuleImageSymbolsEnabled)));
        defaults.get().set(WebPreferencesKey::cssCounterStyleAtRulesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSCounterStyleAtRulesEnabled)));
        defaults.get().set(WebPreferencesKey::cssCustomPropertiesAndValuesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSCustomPropertiesAndValuesEnabled)));
        defaults.get().set(WebPreferencesKey::cssGradientInterpolationColorSpacesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSGradientInterpolationColorSpacesEnabled)));
        defaults.get().set(WebPreferencesKey::cssGradientPremultipliedAlphaInterpolationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSGradientPremultipliedAlphaInterpolationEnabled)));
        defaults.get().set(WebPreferencesKey::cssIndividualTransformPropertiesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSIndividualTransformPropertiesEnabled)));
        defaults.get().set(WebPreferencesKey::cssInputSecurityEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSInputSecurityEnabled)));
        defaults.get().set(WebPreferencesKey::cssLogicalEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSLogicalEnabled)));
        defaults.get().set(WebPreferencesKey::cssMotionPathEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSMotionPathEnabled)));
        defaults.get().set(WebPreferencesKey::cssOMViewScrollingAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSOMViewScrollingAPIEnabled)));
        defaults.get().set(WebPreferencesKey::cssOMViewSmoothScrollingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSOMViewSmoothScrollingEnabled)));
#if ENABLE(CSS_PAINTING_API)
        defaults.get().set(WebPreferencesKey::cssPaintingAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSPaintingAPIEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::cssRelativeColorSyntaxEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSRelativeColorSyntaxEnabled)));
        defaults.get().set(WebPreferencesKey::cssScrollAnchoringEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSScrollAnchoringEnabled)));
        defaults.get().set(WebPreferencesKey::cssTextAlignLastEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSTextAlignLastEnabled)));
        defaults.get().set(WebPreferencesKey::cssTextJustifyEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSTextJustifyEnabled)));
#if ENABLE(CSS_TRANSFORM_STYLE_OPTIMIZED_3D)
        defaults.get().set(WebPreferencesKey::cssTransformStyleOptimized3DEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSTransformStyleOptimized3DEnabled)));
#endif
#if ENABLE(CSS_TYPED_OM)
        defaults.get().set(WebPreferencesKey::cssTypedOMEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CSSTypedOMEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::cacheAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CacheAPIEnabled)));
        defaults.get().set(WebPreferencesKey::canvasColorSpaceEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CanvasColorSpaceEnabled)));
        defaults.get().set(WebPreferencesKey::canvasUsesAcceleratedDrawingKey(), Value(bool(DEFAULT_VALUE_FOR_CanvasUsesAcceleratedDrawing)));
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::captureAudioInGPUProcessEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CaptureAudioInGPUProcessEnabled)));
#endif
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::captureAudioInUIProcessEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CaptureAudioInUIProcessEnabled)));
#endif
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::captureVideoInGPUProcessEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CaptureVideoInGPUProcessEnabled)));
#endif
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::captureVideoInUIProcessEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CaptureVideoInUIProcessEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::caretBrowsingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CaretBrowsingEnabled)));
        defaults.get().set(WebPreferencesKey::colorFilterEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ColorFilterEnabled)));
        defaults.get().set(WebPreferencesKey::compositingBordersVisibleKey(), Value(bool(DEFAULT_VALUE_FOR_CompositingBordersVisible)));
        defaults.get().set(WebPreferencesKey::compositingRepaintCountersVisibleKey(), Value(bool(DEFAULT_VALUE_FOR_CompositingRepaintCountersVisible)));
        defaults.get().set(WebPreferencesKey::compressionStreamEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CompressionStreamEnabled)));
        defaults.get().set(WebPreferencesKey::constantPropertiesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ConstantPropertiesEnabled)));
        defaults.get().set(WebPreferencesKey::contactPickerAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ContactPickerAPIEnabled)));
#if ENABLE(CONTENT_CHANGE_OBSERVER)
        defaults.get().set(WebPreferencesKey::contentChangeObserverEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ContentChangeObserverEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::contentDispositionAttachmentSandboxEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ContentDispositionAttachmentSandboxEnabled)));
        defaults.get().set(WebPreferencesKey::cookieConsentAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CookieConsentAPIEnabled)));
        defaults.get().set(WebPreferencesKey::cookieEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CookieEnabled)));
        defaults.get().set(WebPreferencesKey::coreMathMLEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CoreMathMLEnabled)));
        defaults.get().set(WebPreferencesKey::crossOriginEmbedderPolicyEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CrossOriginEmbedderPolicyEnabled)));
        defaults.get().set(WebPreferencesKey::crossOriginOpenerPolicyEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CrossOriginOpenerPolicyEnabled)));
        defaults.get().set(WebPreferencesKey::cursiveFontFamilyKey(), Value(makeString(DEFAULT_VALUE_FOR_CursiveFontFamily)));
        defaults.get().set(WebPreferencesKey::customPasteboardDataEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_CustomPasteboardDataEnabled)));
        defaults.get().set(WebPreferencesKey::dnsPrefetchingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DNSPrefetchingEnabled)));
        defaults.get().set(WebPreferencesKey::domPasteAccessRequestsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DOMPasteAccessRequestsEnabled)));
        defaults.get().set(WebPreferencesKey::domPasteAllowedKey(), Value(bool(DEFAULT_VALUE_FOR_DOMPasteAllowed)));
        defaults.get().set(WebPreferencesKey::domTimersThrottlingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DOMTimersThrottlingEnabled)));
#if ENABLE(DATA_DETECTION)
        defaults.get().set(WebPreferencesKey::dataDetectorTypesKey(), Value(uint32_t(DEFAULT_VALUE_FOR_DataDetectorTypes)));
#endif
#if ENABLE(DATALIST_ELEMENT)
        defaults.get().set(WebPreferencesKey::dataListElementEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DataListElementEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::dataTransferItemsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DataTransferItemsEnabled)));
        defaults.get().set(WebPreferencesKey::databasesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DatabasesEnabled)));
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        defaults.get().set(WebPreferencesKey::dateTimeInputsEditableComponentsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DateTimeInputsEditableComponentsEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::defaultFixedFontSizeKey(), Value(double(DEFAULT_VALUE_FOR_DefaultFixedFontSize)));
        defaults.get().set(WebPreferencesKey::defaultFontSizeKey(), Value(double(DEFAULT_VALUE_FOR_DefaultFontSize)));
        defaults.get().set(WebPreferencesKey::defaultTextEncodingNameKey(), Value(makeString(DEFAULT_VALUE_FOR_DefaultTextEncodingName)));
        defaults.get().set(WebPreferencesKey::developerExtrasEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DeveloperExtrasEnabled)));
        defaults.get().set(WebPreferencesKey::deviceHeightKey(), Value(uint32_t(DEFAULT_VALUE_FOR_DeviceHeight)));
#if ENABLE(DEVICE_ORIENTATION)
        defaults.get().set(WebPreferencesKey::deviceOrientationEventEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DeviceOrientationEventEnabled)));
#endif
#if ENABLE(DEVICE_ORIENTATION)
        defaults.get().set(WebPreferencesKey::deviceOrientationPermissionAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DeviceOrientationPermissionAPIEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::deviceWidthKey(), Value(uint32_t(DEFAULT_VALUE_FOR_DeviceWidth)));
        defaults.get().set(WebPreferencesKey::diagnosticLoggingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DiagnosticLoggingEnabled)));
        defaults.get().set(WebPreferencesKey::dialogElementEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DialogElementEnabled)));
        defaults.get().set(WebPreferencesKey::dirPseudoEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DirPseudoEnabled)));
        defaults.get().set(WebPreferencesKey::directoryUploadEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DirectoryUploadEnabled)));
#if HAVE(CELESTIAL)
        defaults.get().set(WebPreferencesKey::disableMediaExperiencePIDInheritanceKey(), Value(bool(DEFAULT_VALUE_FOR_DisableMediaExperiencePIDInheritance)));
#endif
#if PLATFORM(IOS_FAMILY)
        defaults.get().set(WebPreferencesKey::disableScreenSizeOverrideKey(), Value(bool(DEFAULT_VALUE_FOR_DisableScreenSizeOverride)));
#endif
        defaults.get().set(WebPreferencesKey::disabledAdaptationsMetaTagEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DisabledAdaptationsMetaTagEnabled)));
        defaults.get().set(WebPreferencesKey::disallowSyncXHRDuringPageDismissalEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DisallowSyncXHRDuringPageDismissalEnabled)));
        defaults.get().set(WebPreferencesKey::displayListDrawingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DisplayListDrawingEnabled)));
#if ENABLE(DOWNLOAD_ATTRIBUTE)
        defaults.get().set(WebPreferencesKey::downloadAttributeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_DownloadAttributeEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::editableLinkBehaviorKey(), Value(uint32_t(DEFAULT_VALUE_FOR_EditableLinkBehavior)));
        defaults.get().set(WebPreferencesKey::enableInheritURIQueryComponentKey(), Value(bool(DEFAULT_VALUE_FOR_EnableInheritURIQueryComponent)));
#if ENABLE(ENCRYPTED_MEDIA)
        defaults.get().set(WebPreferencesKey::encryptedMediaAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_EncryptedMediaAPIEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::enterKeyHintEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_EnterKeyHintEnabled)));
        defaults.get().set(WebPreferencesKey::enumeratingAllNetworkInterfacesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_EnumeratingAllNetworkInterfacesEnabled)));
        defaults.get().set(WebPreferencesKey::eventHandlerDrivenSmoothKeyboardScrollingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_EventHandlerDrivenSmoothKeyboardScrollingEnabled)));
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::exposeSpeakersEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ExposeSpeakersEnabled)));
#endif
#if HAVE(APP_SSO)
        defaults.get().set(WebPreferencesKey::isExtensibleSSOEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ExtensibleSSOEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::ftpDirectoryTemplatePathKey(), Value(makeString(DEFAULT_VALUE_FOR_FTPDirectoryTemplatePath)));
        defaults.get().set(WebPreferencesKey::ftpEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_FTPEnabled)));
        defaults.get().set(WebPreferencesKey::fantasyFontFamilyKey(), Value(makeString(DEFAULT_VALUE_FOR_FantasyFontFamily)));
#if PLATFORM(IOS_FAMILY)
        defaults.get().set(WebPreferencesKey::fasterClicksEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_FasterClicksEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::fetchAPIKeepAliveEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_FetchAPIKeepAliveEnabled)));
        defaults.get().set(WebPreferencesKey::fetchMetadataEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_FetchMetadataEnabled)));
        defaults.get().set(WebPreferencesKey::fileSystemAccessEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_FileSystemAccessEnabled)));
        defaults.get().set(WebPreferencesKey::fixedFontFamilyKey(), Value(makeString(DEFAULT_VALUE_FOR_FixedFontFamily)));
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        defaults.get().set(WebPreferencesKey::flexFormattingContextIntegrationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_FlexFormattingContextIntegrationEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::focusVisibleEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_FocusVisibleEnabled)));
#if PLATFORM(IOS_FAMILY)
        defaults.get().set(WebPreferencesKey::forceAlwaysUserScalableKey(), Value(bool(DEFAULT_VALUE_FOR_ForceAlwaysUserScalable)));
#endif
        defaults.get().set(WebPreferencesKey::forceCompositingModeKey(), Value(bool(DEFAULT_VALUE_FOR_ForceCompositingMode)));
        defaults.get().set(WebPreferencesKey::forceFTPDirectoryListingsKey(), Value(bool(DEFAULT_VALUE_FOR_ForceFTPDirectoryListings)));
        defaults.get().set(WebPreferencesKey::forceWebGLUsesLowPowerKey(), Value(bool(DEFAULT_VALUE_FOR_ForceWebGLUsesLowPower)));
        defaults.get().set(WebPreferencesKey::frameFlatteningEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_FrameFlatteningEnabled)));
#if ENABLE(FULLSCREEN_API)
        defaults.get().set(WebPreferencesKey::fullScreenEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_FullScreenEnabled)));
#endif
#if USE(GSTREAMER)
        defaults.get().set(WebPreferencesKey::isGStreamerEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_GStreamerEnabled)));
#endif
#if ENABLE(GAMEPAD)
        defaults.get().set(WebPreferencesKey::gamepadsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_GamepadsEnabled)));
#endif
#if ENABLE(VIDEO)
        defaults.get().set(WebPreferencesKey::genericCueAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_GenericCueAPIEnabled)));
#endif
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::getUserMediaRequiresFocusKey(), Value(bool(DEFAULT_VALUE_FOR_GetUserMediaRequiresFocus)));
#endif
        defaults.get().set(WebPreferencesKey::googleAntiFlickerOptimizationQuirkEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_GoogleAntiFlickerOptimizationQuirkEnabled)));
        defaults.get().set(WebPreferencesKey::hDRMediaCapabilitiesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_HDRMediaCapabilitiesEnabled)));
        defaults.get().set(WebPreferencesKey::httpEquivEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_HTTPEquivEnabled)));
        defaults.get().set(WebPreferencesKey::hasPseudoClassEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_HasPseudoClassEnabled)));
        defaults.get().set(WebPreferencesKey::hiddenPageCSSAnimationSuspensionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_HiddenPageCSSAnimationSuspensionEnabled)));
        defaults.get().set(WebPreferencesKey::hiddenPageDOMTimerThrottlingAutoIncreasesKey(), Value(bool(DEFAULT_VALUE_FOR_HiddenPageDOMTimerThrottlingAutoIncreases)));
        defaults.get().set(WebPreferencesKey::hiddenPageDOMTimerThrottlingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_HiddenPageDOMTimerThrottlingEnabled)));
        defaults.get().set(WebPreferencesKey::highlightAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_HighlightAPIEnabled)));
        defaults.get().set(WebPreferencesKey::hyperlinkAuditingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_HyperlinkAuditingEnabled)));
        defaults.get().set(WebPreferencesKey::iceCandidateFilteringEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ICECandidateFilteringEnabled)));
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
        defaults.get().set(WebPreferencesKey::iOSFormControlRefreshEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IOSFormControlRefreshEnabled)));
#endif
#if ENABLE(IPC_TESTING_API)
        defaults.get().set(WebPreferencesKey::ipcTestingAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IPCTestingAPIEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::imageAnalysisDuringFindInPageEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ImageAnalysisDuringFindInPageEnabled)));
        defaults.get().set(WebPreferencesKey::imageBitmapEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ImageBitmapEnabled)));
#if ENABLE(SERVICE_CONTROLS)
        defaults.get().set(WebPreferencesKey::imageControlsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ImageControlsEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::inProcessCookieCacheEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InProcessCookieCacheEnabled)));
        defaults.get().set(WebPreferencesKey::inactiveMediaCaptureSteamRepromptIntervalInMinutesKey(), Value(double(DEFAULT_VALUE_FOR_InactiveMediaCaptureSteamRepromptIntervalInMinutes)));
        defaults.get().set(WebPreferencesKey::incompleteImageBorderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IncompleteImageBorderEnabled)));
#if HAVE(INCREMENTAL_PDF_APIS)
        defaults.get().set(WebPreferencesKey::incrementalPDFLoadingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IncrementalPDFLoadingEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::incrementalRenderingSuppressionTimeoutKey(), Value(double(DEFAULT_VALUE_FOR_IncrementalRenderingSuppressionTimeout)));
        defaults.get().set(WebPreferencesKey::inertAttributeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InertAttributeEnabled)));
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        defaults.get().set(WebPreferencesKey::inlineFormattingContextIntegrationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InlineFormattingContextIntegrationEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::inlineMediaPlaybackRequiresPlaysInlineAttributeKey(), Value(bool(DEFAULT_VALUE_FOR_InlineMediaPlaybackRequiresPlaysInlineAttribute)));
#if ENABLE(INPUT_TYPE_COLOR)
        defaults.get().set(WebPreferencesKey::inputTypeColorEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InputTypeColorEnabled)));
#endif
#if ENABLE(INPUT_TYPE_DATE)
        defaults.get().set(WebPreferencesKey::inputTypeDateEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InputTypeDateEnabled)));
#endif
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        defaults.get().set(WebPreferencesKey::inputTypeDateTimeLocalEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InputTypeDateTimeLocalEnabled)));
#endif
#if ENABLE(INPUT_TYPE_MONTH)
        defaults.get().set(WebPreferencesKey::inputTypeMonthEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InputTypeMonthEnabled)));
#endif
#if ENABLE(INPUT_TYPE_TIME)
        defaults.get().set(WebPreferencesKey::inputTypeTimeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InputTypeTimeEnabled)));
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        defaults.get().set(WebPreferencesKey::inputTypeWeekEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InputTypeWeekEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::inspectorAttachedHeightKey(), Value(uint32_t(DEFAULT_VALUE_FOR_InspectorAttachedHeight)));
        defaults.get().set(WebPreferencesKey::inspectorAttachedWidthKey(), Value(uint32_t(DEFAULT_VALUE_FOR_InspectorAttachedWidth)));
        defaults.get().set(WebPreferencesKey::inspectorAttachmentSideKey(), Value(uint32_t(DEFAULT_VALUE_FOR_InspectorAttachmentSide)));
        defaults.get().set(WebPreferencesKey::inspectorStartsAttachedKey(), Value(bool(DEFAULT_VALUE_FOR_InspectorStartsAttached)));
        defaults.get().set(WebPreferencesKey::inspectorWindowFrameKey(), Value(makeString(DEFAULT_VALUE_FOR_InspectorWindowFrame)));
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
        defaults.get().set(WebPreferencesKey::interactionRegionsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InteractionRegionsEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::interactiveFormValidationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InteractiveFormValidationEnabled)));
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::interruptAudioOnPageVisibilityChangeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_InterruptAudioOnPageVisibilityChangeEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::intersectionObserverEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IntersectionObserverEnabled)));
        defaults.get().set(WebPreferencesKey::invisibleAutoplayNotPermittedKey(), Value(bool(DEFAULT_VALUE_FOR_InvisibleAutoplayNotPermitted)));
#if ENABLE(ACCESSIBILITY_ISOLATED_TREE)
        defaults.get().set(WebPreferencesKey::isAccessibilityIsolatedTreeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IsAccessibilityIsolatedTreeEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::isFirstPartyWebsiteDataRemovalDisabledKey(), Value(bool(DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalDisabled)));
        defaults.get().set(WebPreferencesKey::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled)));
        defaults.get().set(WebPreferencesKey::isFirstPartyWebsiteDataRemovalReproTestingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalReproTestingEnabled)));
        defaults.get().set(WebPreferencesKey::isLoggedInAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IsLoggedInAPIEnabled)));
#if HAVE(NSURLSESSION_WEBSOCKET)
        defaults.get().set(WebPreferencesKey::isNSURLSessionWebSocketEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IsNSURLSessionWebSocketEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::isSameSiteStrictEnforcementEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_IsSameSiteStrictEnforcementEnabled)));
        defaults.get().set(WebPreferencesKey::isThirdPartyCookieBlockingDisabledKey(), Value(bool(DEFAULT_VALUE_FOR_IsThirdPartyCookieBlockingDisabled)));
        defaults.get().set(WebPreferencesKey::itpDebugModeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ItpDebugModeEnabled)));
        defaults.get().set(WebPreferencesKey::javaScriptCanAccessClipboardKey(), Value(bool(DEFAULT_VALUE_FOR_JavaScriptCanAccessClipboard)));
        defaults.get().set(WebPreferencesKey::javaScriptCanOpenWindowsAutomaticallyKey(), Value(bool(DEFAULT_VALUE_FOR_JavaScriptCanOpenWindowsAutomatically)));
        defaults.get().set(WebPreferencesKey::javaScriptEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_JavaScriptEnabled)));
        defaults.get().set(WebPreferencesKey::javaScriptMarkupEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_JavaScriptMarkupEnabled)));
        defaults.get().set(WebPreferencesKey::javaScriptRuntimeFlagsKey(), Value(uint32_t(DEFAULT_VALUE_FOR_JavaScriptRuntimeFlags)));
        defaults.get().set(WebPreferencesKey::largeImageAsyncDecodingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LargeImageAsyncDecodingEnabled)));
#if ENABLE(LAYER_BASED_SVG_ENGINE)
        defaults.get().set(WebPreferencesKey::layerBasedSVGEngineEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LayerBasedSVGEngineEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::layoutFallbackWidthKey(), Value(uint32_t(DEFAULT_VALUE_FOR_LayoutFallbackWidth)));
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
        defaults.get().set(WebPreferencesKey::layoutFormattingContextEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LayoutFormattingContextEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::layoutViewportHeightExpansionFactorKey(), Value(double(DEFAULT_VALUE_FOR_LayoutViewportHeightExpansionFactor)));
        defaults.get().set(WebPreferencesKey::lazyIframeLoadingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LazyIframeLoadingEnabled)));
        defaults.get().set(WebPreferencesKey::lazyImageLoadingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LazyImageLoadingEnabled)));
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
        defaults.get().set(WebPreferencesKey::legacyEncryptedMediaAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LegacyEncryptedMediaAPIEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::legacyLineLayoutVisualCoverageEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LegacyLineLayoutVisualCoverageEnabled)));
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        defaults.get().set(WebPreferencesKey::legacyOverflowScrollingTouchEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LegacyOverflowScrollingTouchEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::lineHeightUnitsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LineHeightUnitsEnabled)));
        defaults.get().set(WebPreferencesKey::linkPreconnectKey(), Value(bool(DEFAULT_VALUE_FOR_LinkPreconnect)));
        defaults.get().set(WebPreferencesKey::linkPrefetchEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LinkPrefetchEnabled)));
        defaults.get().set(WebPreferencesKey::linkPreloadEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LinkPreloadEnabled)));
        defaults.get().set(WebPreferencesKey::linkPreloadResponsiveImagesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LinkPreloadResponsiveImagesEnabled)));
        defaults.get().set(WebPreferencesKey::linkSanitizerEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LinkSanitizerEnabled)));
        defaults.get().set(WebPreferencesKey::liveRangeSelectionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LiveRangeSelectionEnabled)));
        defaults.get().set(WebPreferencesKey::loadDeferringEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LoadDeferringEnabled)));
        defaults.get().set(WebPreferencesKey::loadsImagesAutomaticallyKey(), Value(bool(DEFAULT_VALUE_FOR_LoadsImagesAutomatically)));
        defaults.get().set(WebPreferencesKey::loadsSiteIconsIgnoringImageLoadingPreferenceKey(), Value(bool(DEFAULT_VALUE_FOR_LoadsSiteIconsIgnoringImageLoadingPreference)));
        defaults.get().set(WebPreferencesKey::localFileContentSniffingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LocalFileContentSniffingEnabled)));
        defaults.get().set(WebPreferencesKey::localStorageEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LocalStorageEnabled)));
        defaults.get().set(WebPreferencesKey::logsPageMessagesToSystemConsoleEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LogsPageMessagesToSystemConsoleEnabled)));
        defaults.get().set(WebPreferencesKey::longRunningMediaCaptureStreamRepromptIntervalInHoursKey(), Value(double(DEFAULT_VALUE_FOR_LongRunningMediaCaptureStreamRepromptIntervalInHours)));
        defaults.get().set(WebPreferencesKey::lowPowerVideoAudioBufferSizeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_LowPowerVideoAudioBufferSizeEnabled)));
        defaults.get().set(WebPreferencesKey::mainContentUserGestureOverrideEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MainContentUserGestureOverrideEnabled)));
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
        defaults.get().set(WebPreferencesKey::maskWebGLStringsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MaskWebGLStringsEnabled)));
#endif
#if ENABLE(MATHML)
        defaults.get().set(WebPreferencesKey::mathMLEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MathMLEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::maxParseDurationKey(), Value(double(DEFAULT_VALUE_FOR_MaxParseDuration)));
        defaults.get().set(WebPreferencesKey::mediaAudioCodecIDsAllowedInCaptivePortalModeKey(), Value(makeString(DEFAULT_VALUE_FOR_MediaAudioCodecIDsAllowedInCaptivePortalMode)));
        defaults.get().set(WebPreferencesKey::mediaCapabilitiesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaCapabilitiesEnabled)));
        defaults.get().set(WebPreferencesKey::mediaCapabilitiesExtensionsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaCapabilitiesExtensionsEnabled)));
        defaults.get().set(WebPreferencesKey::mediaCaptionFormatTypesAllowedInCaptivePortalModeKey(), Value(makeString(DEFAULT_VALUE_FOR_MediaCaptionFormatTypesAllowedInCaptivePortalMode)));
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::mediaCaptureRequiresSecureConnectionKey(), Value(bool(DEFAULT_VALUE_FOR_MediaCaptureRequiresSecureConnection)));
#endif
        defaults.get().set(WebPreferencesKey::mediaCodecTypesAllowedInCaptivePortalModeKey(), Value(makeString(DEFAULT_VALUE_FOR_MediaCodecTypesAllowedInCaptivePortalMode)));
        defaults.get().set(WebPreferencesKey::mediaContainerTypesAllowedInCaptivePortalModeKey(), Value(makeString(DEFAULT_VALUE_FOR_MediaContainerTypesAllowedInCaptivePortalMode)));
        defaults.get().set(WebPreferencesKey::mediaContentTypesRequiringHardwareSupportKey(), Value(makeString(DEFAULT_VALUE_FOR_MediaContentTypesRequiringHardwareSupport)));
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS)
        defaults.get().set(WebPreferencesKey::mediaControlsContextMenusEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaControlsContextMenusEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::mediaControlsScaleWithPageZoomKey(), Value(bool(DEFAULT_VALUE_FOR_MediaControlsScaleWithPageZoom)));
        defaults.get().set(WebPreferencesKey::mediaDataLoadsAutomaticallyKey(), Value(bool(DEFAULT_VALUE_FOR_MediaDataLoadsAutomatically)));
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::mediaDevicesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaDevicesEnabled)));
#endif
#if ENABLE(VIDEO)
        defaults.get().set(WebPreferencesKey::mediaEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::mediaPreloadingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaPreloadingEnabled)));
#if ENABLE(MEDIA_RECORDER)
        defaults.get().set(WebPreferencesKey::mediaRecorderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaRecorderEnabled)));
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        defaults.get().set(WebPreferencesKey::mediaSessionCoordinatorEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaSessionCoordinatorEnabled)));
#endif
#if ENABLE(MEDIA_SESSION)
        defaults.get().set(WebPreferencesKey::mediaSessionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaSessionEnabled)));
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        defaults.get().set(WebPreferencesKey::mediaSessionPlaylistEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaSessionPlaylistEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::mediaSourceEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaSourceEnabled)));
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        defaults.get().set(WebPreferencesKey::mediaSourceInlinePaintingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaSourceInlinePaintingEnabled)));
#endif
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::mediaStreamEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MediaStreamEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::mediaUserGestureInheritsFromDocumentKey(), Value(bool(DEFAULT_VALUE_FOR_MediaUserGestureInheritsFromDocument)));
        defaults.get().set(WebPreferencesKey::mediaVideoCodecIDsAllowedInCaptivePortalModeKey(), Value(makeString(DEFAULT_VALUE_FOR_MediaVideoCodecIDsAllowedInCaptivePortalMode)));
        defaults.get().set(WebPreferencesKey::menuItemElementEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MenuItemElementEnabled)));
        defaults.get().set(WebPreferencesKey::minimumFontSizeKey(), Value(double(DEFAULT_VALUE_FOR_MinimumFontSize)));
        defaults.get().set(WebPreferencesKey::minimumLogicalFontSizeKey(), Value(double(DEFAULT_VALUE_FOR_MinimumLogicalFontSize)));
#if ENABLE(TEXT_AUTOSIZING)
        defaults.get().set(WebPreferencesKey::minimumZoomFontSizeKey(), Value(double(DEFAULT_VALUE_FOR_MinimumZoomFontSize)));
#endif
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::mockCaptureDevicesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MockCaptureDevicesEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::mockCaptureDevicesPromptEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MockCaptureDevicesPromptEnabled)));
        defaults.get().set(WebPreferencesKey::mockScrollbarsControllerEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MockScrollbarsControllerEnabled)));
        defaults.get().set(WebPreferencesKey::mockScrollbarsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MockScrollbarsEnabled)));
#if ENABLE(MODEL_ELEMENT)
        defaults.get().set(WebPreferencesKey::modelDocumentEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ModelDocumentEnabled)));
#endif
#if ENABLE(MODEL_ELEMENT)
        defaults.get().set(WebPreferencesKey::modelElementEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ModelElementEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::momentumScrollingAnimatorEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MomentumScrollingAnimatorEnabled)));
#if ENABLE(TOUCH_EVENTS)
        defaults.get().set(WebPreferencesKey::mouseEventsSimulationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MouseEventsSimulationEnabled)));
#endif
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::muteCameraOnMicrophoneInterruptionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_MuteCameraOnMicrophoneInterruptionEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::needsAdobeFrameReloadingQuirkKey(), Value(bool(DEFAULT_VALUE_FOR_NeedsAdobeFrameReloadingQuirk)));
        defaults.get().set(WebPreferencesKey::needsFrameNameFallbackToIdQuirkKey(), Value(bool(DEFAULT_VALUE_FOR_NeedsFrameNameFallbackToIdQuirk)));
        defaults.get().set(WebPreferencesKey::needsInAppBrowserPrivacyQuirksKey(), Value(bool(DEFAULT_VALUE_FOR_NeedsInAppBrowserPrivacyQuirks)));
        defaults.get().set(WebPreferencesKey::needsKeyboardEventDisambiguationQuirksKey(), Value(bool(DEFAULT_VALUE_FOR_NeedsKeyboardEventDisambiguationQuirks)));
        defaults.get().set(WebPreferencesKey::needsSiteSpecificQuirksKey(), Value(bool(DEFAULT_VALUE_FOR_NeedsSiteSpecificQuirks)));
        defaults.get().set(WebPreferencesKey::needsStorageAccessFromFileURLsQuirkKey(), Value(bool(DEFAULT_VALUE_FOR_NeedsStorageAccessFromFileURLsQuirk)));
#if ENABLE(NOTIFICATION_EVENT)
        defaults.get().set(WebPreferencesKey::notificationEventEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_NotificationEventEnabled)));
#endif
#if ENABLE(NOTIFICATIONS)
        defaults.get().set(WebPreferencesKey::notificationsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_NotificationsEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::offlineWebApplicationCacheEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_OfflineWebApplicationCacheEnabled)));
#if ENABLE(OFFSCREEN_CANVAS)
        defaults.get().set(WebPreferencesKey::offscreenCanvasEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_OffscreenCanvasEnabled)));
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
        defaults.get().set(WebPreferencesKey::offscreenCanvasInWorkersEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_OffscreenCanvasInWorkersEnabled)));
#endif
#if ENABLE(OPUS)
        defaults.get().set(WebPreferencesKey::opusDecoderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_OpusDecoderEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::overflowClipEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_OverflowClipEnabled)));
        defaults.get().set(WebPreferencesKey::overscrollBehaviorEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_OverscrollBehaviorEnabled)));
#if PLATFORM(COCOA)
        defaults.get().set(WebPreferencesKey::pdfPluginEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PDFPluginEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::pageAtRuleSupportEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PageAtRuleSupportEnabled)));
        defaults.get().set(WebPreferencesKey::pageVisibilityBasedProcessSuppressionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PageVisibilityBasedProcessSuppressionEnabled)));
        defaults.get().set(WebPreferencesKey::paginateDuringLayoutEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PaginateDuringLayoutEnabled)));
        defaults.get().set(WebPreferencesKey::paintTimingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PaintTimingEnabled)));
        defaults.get().set(WebPreferencesKey::passiveTouchListenersAsDefaultOnDocumentKey(), Value(bool(DEFAULT_VALUE_FOR_PassiveTouchListenersAsDefaultOnDocument)));
        defaults.get().set(WebPreferencesKey::passiveWheelListenersAsDefaultOnDocumentKey(), Value(bool(DEFAULT_VALUE_FOR_PassiveWheelListenersAsDefaultOnDocument)));
        defaults.get().set(WebPreferencesKey::passwordEchoDurationKey(), Value(double(DEFAULT_VALUE_FOR_PasswordEchoDuration)));
        defaults.get().set(WebPreferencesKey::passwordEchoEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PasswordEchoEnabled)));
#if ENABLE(PDFJS)
        defaults.get().set(WebPreferencesKey::pdfJSViewerEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PdfJSViewerEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::peerConnectionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PeerConnectionEnabled)));
#endif
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::perElementSpeakerSelectionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PerElementSpeakerSelectionEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::performanceNavigationTimingAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PerformanceNavigationTimingAPIEnabled)));
        defaults.get().set(WebPreferencesKey::performanceResourceTimingSensitivePropertiesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PerformanceResourceTimingSensitivePropertiesEnabled)));
        defaults.get().set(WebPreferencesKey::permissionsAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PermissionsAPIEnabled)));
        defaults.get().set(WebPreferencesKey::pictographFontFamilyKey(), Value(makeString(DEFAULT_VALUE_FOR_PictographFontFamily)));
#if ENABLE(PICTURE_IN_PICTURE_API)
        defaults.get().set(WebPreferencesKey::pictureInPictureAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PictureInPictureAPIEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::pitchCorrectionAlgorithmKey(), Value(uint32_t(DEFAULT_VALUE_FOR_PitchCorrectionAlgorithm)));
        defaults.get().set(WebPreferencesKey::pluginsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PluginsEnabled)));
#if PLATFORM(IOS_FAMILY)
        defaults.get().set(WebPreferencesKey::preferFasterClickOverDoubleTapKey(), Value(bool(DEFAULT_VALUE_FOR_PreferFasterClickOverDoubleTap)));
#endif
        defaults.get().set(WebPreferencesKey::preferPageRenderingUpdatesNear60FPSEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PreferPageRenderingUpdatesNear60FPSEnabled)));
#if ENABLE(VIDEO)
        defaults.get().set(WebPreferencesKey::preferSandboxedMediaParsingKey(), Value(bool(DEFAULT_VALUE_FOR_PreferSandboxedMediaParsing)));
#endif
        defaults.get().set(WebPreferencesKey::privateClickMeasurementDebugModeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PrivateClickMeasurementDebugModeEnabled)));
        defaults.get().set(WebPreferencesKey::privateClickMeasurementEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PrivateClickMeasurementEnabled)));
        defaults.get().set(WebPreferencesKey::privateClickMeasurementFraudPreventionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PrivateClickMeasurementFraudPreventionEnabled)));
        defaults.get().set(WebPreferencesKey::processSwapOnCrossSiteNavigationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ProcessSwapOnCrossSiteNavigationEnabled)));
        defaults.get().set(WebPreferencesKey::punchOutWhiteBackgroundsInDarkModeKey(), Value(bool(DEFAULT_VALUE_FOR_PunchOutWhiteBackgroundsInDarkMode)));
#if ENABLE(SERVICE_WORKER)
        defaults.get().set(WebPreferencesKey::pushAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_PushAPIEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::readableByteStreamAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ReadableByteStreamAPIEnabled)));
        defaults.get().set(WebPreferencesKey::referrerPolicyAttributeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ReferrerPolicyAttributeEnabled)));
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        defaults.get().set(WebPreferencesKey::remotePlaybackEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_RemotePlaybackEnabled)));
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        defaults.get().set(WebPreferencesKey::removeBackgroundEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_RemoveBackgroundEnabled)));
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        defaults.get().set(WebPreferencesKey::replayCGDisplayListsIntoBackingStoreKey(), Value(bool(DEFAULT_VALUE_FOR_ReplayCGDisplayListsIntoBackingStore)));
#endif
        defaults.get().set(WebPreferencesKey::requestIdleCallbackEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_RequestIdleCallbackEnabled)));
        defaults.get().set(WebPreferencesKey::requestSubmitEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_RequestSubmitEnabled)));
        defaults.get().set(WebPreferencesKey::requestVideoFrameCallbackEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_RequestVideoFrameCallbackEnabled)));
        defaults.get().set(WebPreferencesKey::requiresPageVisibilityToPlayAudioKey(), Value(bool(DEFAULT_VALUE_FOR_RequiresPageVisibilityToPlayAudio)));
        defaults.get().set(WebPreferencesKey::requiresUserGestureForAudioPlaybackKey(), Value(bool(DEFAULT_VALUE_FOR_RequiresUserGestureForAudioPlayback)));
        defaults.get().set(WebPreferencesKey::requiresUserGestureForMediaPlaybackKey(), Value(bool(DEFAULT_VALUE_FOR_RequiresUserGestureForMediaPlayback)));
        defaults.get().set(WebPreferencesKey::requiresUserGestureForVideoPlaybackKey(), Value(bool(DEFAULT_VALUE_FOR_RequiresUserGestureForVideoPlayback)));
        defaults.get().set(WebPreferencesKey::requiresUserGestureToLoadVideoKey(), Value(bool(DEFAULT_VALUE_FOR_RequiresUserGestureToLoadVideo)));
        defaults.get().set(WebPreferencesKey::resizeObserverEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ResizeObserverEnabled)));
        defaults.get().set(WebPreferencesKey::resolutionMediaFeatureEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ResolutionMediaFeatureEnabled)));
        defaults.get().set(WebPreferencesKey::resourceLoadSchedulingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ResourceLoadSchedulingEnabled)));
#if ENABLE(RESOURCE_USAGE)
        defaults.get().set(WebPreferencesKey::resourceUsageOverlayVisibleKey(), Value(bool(DEFAULT_VALUE_FOR_ResourceUsageOverlayVisible)));
#endif
        defaults.get().set(WebPreferencesKey::restrictedHTTPResponseAccessKey(), Value(bool(DEFAULT_VALUE_FOR_RestrictedHTTPResponseAccess)));
#if HAVE(RUBBER_BANDING)
        defaults.get().set(WebPreferencesKey::rubberBandingForSubScrollableRegionsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_RubberBandingForSubScrollableRegionsEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::sKAttributionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SKAttributionEnabled)));
        defaults.get().set(WebPreferencesKey::safeBrowsingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SafeBrowsingEnabled)));
#if HAVE(AVCONTENTKEYSPECIFIER)
        defaults.get().set(WebPreferencesKey::sampleBufferContentKeySessionSupportEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SampleBufferContentKeySessionSupportEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::sampledPageTopColorMaxDifferenceKey(), Value(double(DEFAULT_VALUE_FOR_SampledPageTopColorMaxDifference)));
        defaults.get().set(WebPreferencesKey::sampledPageTopColorMinHeightKey(), Value(double(DEFAULT_VALUE_FOR_SampledPageTopColorMinHeight)));
        defaults.get().set(WebPreferencesKey::sansSerifFontFamilyKey(), Value(makeString(DEFAULT_VALUE_FOR_SansSerifFontFamily)));
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::screenCaptureEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ScreenCaptureEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::scrollAnimatorEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ScrollAnimatorEnabled)));
        defaults.get().set(WebPreferencesKey::scrollToTextFragmentEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ScrollToTextFragmentEnabled)));
        defaults.get().set(WebPreferencesKey::scrollingPerformanceTestingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ScrollingPerformanceTestingEnabled)));
        defaults.get().set(WebPreferencesKey::secureContextChecksEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SecureContextChecksEnabled)));
        defaults.get().set(WebPreferencesKey::selectTrailingWhitespaceEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SelectTrailingWhitespaceEnabled)));
        defaults.get().set(WebPreferencesKey::selectionFlippingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SelectionFlippingEnabled)));
        defaults.get().set(WebPreferencesKey::serifFontFamilyKey(), Value(makeString(DEFAULT_VALUE_FOR_SerifFontFamily)));
        defaults.get().set(WebPreferencesKey::serverTimingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ServerTimingEnabled)));
#if ENABLE(SERVICE_CONTROLS)
        defaults.get().set(WebPreferencesKey::serviceControlsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ServiceControlsEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::serviceWorkerEntitlementDisabledForTestingKey(), Value(bool(DEFAULT_VALUE_FOR_ServiceWorkerEntitlementDisabledForTesting)));
#if ENABLE(SERVICE_WORKER)
        defaults.get().set(WebPreferencesKey::serviceWorkerNavigationPreloadEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ServiceWorkerNavigationPreloadEnabled)));
#endif
#if ENABLE(SERVICE_WORKER)
        defaults.get().set(WebPreferencesKey::serviceWorkersEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ServiceWorkersEnabled)));
#endif
#if ENABLE(SERVICE_WORKER)
        defaults.get().set(WebPreferencesKey::serviceWorkersUserGestureEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ServiceWorkersUserGestureEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::sharedWorkerEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SharedWorkerEnabled)));
        defaults.get().set(WebPreferencesKey::shouldAllowUserInstalledFontsKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldAllowUserInstalledFonts)));
        defaults.get().set(WebPreferencesKey::shouldConvertInvalidURLsToBlankKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldConvertInvalidURLsToBlank)));
        defaults.get().set(WebPreferencesKey::shouldConvertPositionStyleOnCopyKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldConvertPositionStyleOnCopy)));
        defaults.get().set(WebPreferencesKey::shouldDecidePolicyBeforeLoadingQuickLookPreviewKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldDecidePolicyBeforeLoadingQuickLookPreview)));
        defaults.get().set(WebPreferencesKey::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaintKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint)));
#if ENABLE(VIDEO)
        defaults.get().set(WebPreferencesKey::shouldDisplayCaptionsKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldDisplayCaptions)));
#endif
#if ENABLE(VIDEO)
        defaults.get().set(WebPreferencesKey::shouldDisplaySubtitlesKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldDisplaySubtitles)));
#endif
#if ENABLE(VIDEO)
        defaults.get().set(WebPreferencesKey::shouldDisplayTextDescriptionsKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldDisplayTextDescriptions)));
#endif
#if ENABLE(TEXT_AUTOSIZING)
        defaults.get().set(WebPreferencesKey::shouldEnableTextAutosizingBoostKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldEnableTextAutosizingBoost)));
#endif
        defaults.get().set(WebPreferencesKey::shouldIgnoreMetaViewportKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldIgnoreMetaViewport)));
        defaults.get().set(WebPreferencesKey::shouldPrintBackgroundsKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldPrintBackgrounds)));
        defaults.get().set(WebPreferencesKey::shouldRespectImageOrientationKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldRespectImageOrientation)));
        defaults.get().set(WebPreferencesKey::shouldRestrictBaseURLSchemesKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldRestrictBaseURLSchemes)));
        defaults.get().set(WebPreferencesKey::shouldSuppressTextInputFromEditingDuringProvisionalNavigationKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldSuppressTextInputFromEditingDuringProvisionalNavigation)));
        defaults.get().set(WebPreferencesKey::shouldUseServiceWorkerShortTimeoutKey(), Value(bool(DEFAULT_VALUE_FOR_ShouldUseServiceWorkerShortTimeout)));
        defaults.get().set(WebPreferencesKey::showModalDialogEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ShowModalDialogEnabled)));
        defaults.get().set(WebPreferencesKey::showsToolTipOverTruncatedTextKey(), Value(bool(DEFAULT_VALUE_FOR_ShowsToolTipOverTruncatedText)));
        defaults.get().set(WebPreferencesKey::showsURLsInToolTipsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ShowsURLsInToolTipsEnabled)));
        defaults.get().set(WebPreferencesKey::shrinksStandaloneImagesToFitKey(), Value(bool(DEFAULT_VALUE_FOR_ShrinksStandaloneImagesToFit)));
        defaults.get().set(WebPreferencesKey::smartInsertDeleteEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SmartInsertDeleteEnabled)));
#if ENABLE(MEDIA_SOURCE)
        defaults.get().set(WebPreferencesKey::sourceBufferChangeTypeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SourceBufferChangeTypeEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::spatialNavigationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SpatialNavigationEnabled)));
#if ENABLE(MEDIA_STREAM)
        defaults.get().set(WebPreferencesKey::speakerSelectionRequiresUserGestureKey(), Value(bool(DEFAULT_VALUE_FOR_SpeakerSelectionRequiresUserGesture)));
#endif
        defaults.get().set(WebPreferencesKey::speechRecognitionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SpeechRecognitionEnabled)));
        defaults.get().set(WebPreferencesKey::springTimingFunctionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SpringTimingFunctionEnabled)));
        defaults.get().set(WebPreferencesKey::standaloneKey(), Value(bool(DEFAULT_VALUE_FOR_Standalone)));
        defaults.get().set(WebPreferencesKey::standardFontFamilyKey(), Value(makeString(DEFAULT_VALUE_FOR_StandardFontFamily)));
        defaults.get().set(WebPreferencesKey::storageAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_StorageAPIEnabled)));
        defaults.get().set(WebPreferencesKey::storageAccessAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_StorageAccessAPIEnabled)));
        defaults.get().set(WebPreferencesKey::storageBlockingPolicyKey(), Value(uint32_t(DEFAULT_VALUE_FOR_StorageBlockingPolicy)));
        defaults.get().set(WebPreferencesKey::subgridEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SubgridEnabled)));
        defaults.get().set(WebPreferencesKey::subpixelAntialiasedLayerTextEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SubpixelAntialiasedLayerTextEnabled)));
        defaults.get().set(WebPreferencesKey::suppressesIncrementalRenderingKey(), Value(bool(DEFAULT_VALUE_FOR_SuppressesIncrementalRendering)));
        defaults.get().set(WebPreferencesKey::syntheticEditingCommandsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SyntheticEditingCommandsEnabled)));
        defaults.get().set(WebPreferencesKey::systemLayoutDirectionKey(), Value(uint32_t(DEFAULT_VALUE_FOR_SystemLayoutDirection)));
#if USE(SYSTEM_PREVIEW)
        defaults.get().set(WebPreferencesKey::systemPreviewEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_SystemPreviewEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::tabsToLinksKey(), Value(bool(DEFAULT_VALUE_FOR_TabsToLinks)));
        defaults.get().set(WebPreferencesKey::telephoneNumberParsingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_TelephoneNumberParsingEnabled)));
        defaults.get().set(WebPreferencesKey::temporaryTileCohortRetentionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_TemporaryTileCohortRetentionEnabled)));
        defaults.get().set(WebPreferencesKey::textAreasAreResizableKey(), Value(bool(DEFAULT_VALUE_FOR_TextAreasAreResizable)));
#if ENABLE(TEXT_AUTOSIZING)
        defaults.get().set(WebPreferencesKey::textAutosizingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_TextAutosizingEnabled)));
#endif
#if ENABLE(TEXT_AUTOSIZING)
        defaults.get().set(WebPreferencesKey::textAutosizingUsesIdempotentModeKey(), Value(bool(DEFAULT_VALUE_FOR_TextAutosizingUsesIdempotentMode)));
#endif
        defaults.get().set(WebPreferencesKey::textInteractionEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_TextInteractionEnabled)));
#if ENABLE(IMAGE_ANALYSIS)
        defaults.get().set(WebPreferencesKey::textRecognitionInVideosEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_TextRecognitionInVideosEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::thirdPartyIframeRedirectBlockingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ThirdPartyIframeRedirectBlockingEnabled)));
        defaults.get().set(WebPreferencesKey::threadedScrollingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ThreadedScrollingEnabled)));
        defaults.get().set(WebPreferencesKey::tiledScrollingIndicatorVisibleKey(), Value(bool(DEFAULT_VALUE_FOR_TiledScrollingIndicatorVisible)));
        defaults.get().set(WebPreferencesKey::trackConfigurationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_TrackConfigurationEnabled)));
        defaults.get().set(WebPreferencesKey::transformStreamAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_TransformStreamAPIEnabled)));
        defaults.get().set(WebPreferencesKey::treatsAnyTextCSSLinkAsStylesheetKey(), Value(bool(DEFAULT_VALUE_FOR_TreatsAnyTextCSSLinkAsStylesheet)));
        defaults.get().set(WebPreferencesKey::undoManagerAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_UndoManagerAPIEnabled)));
        defaults.get().set(WebPreferencesKey::upgradeKnownHostsToHTTPSEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_UpgradeKnownHostsToHTTPSEnabled)));
#if ENABLE(ARKIT_INLINE_PREVIEW)
        defaults.get().set(WebPreferencesKey::useARKitForModelKey(), Value(bool(DEFAULT_VALUE_FOR_UseARKitForModel)));
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        defaults.get().set(WebPreferencesKey::useCGDisplayListOutOfLineSurfacesKey(), Value(bool(DEFAULT_VALUE_FOR_UseCGDisplayListOutOfLineSurfaces)));
#endif
#if ENABLE(CG_DISPLAY_LIST_BACKED_IMAGE_BUFFER)
        defaults.get().set(WebPreferencesKey::useCGDisplayListsForDOMRenderingKey(), Value(bool(DEFAULT_VALUE_FOR_UseCGDisplayListsForDOMRendering)));
#endif
#if ENABLE(GPU_PROCESS) && !(PLATFORM(GTK) || PLATFORM(WPE))
        defaults.get().set(WebPreferencesKey::useGPUProcessForCanvasRenderingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_UseGPUProcessForCanvasRenderingEnabled)));
#endif
#if ENABLE(GPU_PROCESS)
        defaults.get().set(WebPreferencesKey::useGPUProcessForDOMRenderingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_UseGPUProcessForDOMRenderingEnabled)));
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
        defaults.get().set(WebPreferencesKey::useGPUProcessForDisplayCaptureKey(), Value(bool(DEFAULT_VALUE_FOR_UseGPUProcessForDisplayCapture)));
#endif
#if ENABLE(GPU_PROCESS) && !USE(GSTREAMER)
        defaults.get().set(WebPreferencesKey::useGPUProcessForMediaEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_UseGPUProcessForMediaEnabled)));
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
        defaults.get().set(WebPreferencesKey::useGPUProcessForWebGLEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_UseGPUProcessForWebGLEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::useGeneralDirectoryForStorageKey(), Value(bool(DEFAULT_VALUE_FOR_UseGeneralDirectoryForStorage)));
        defaults.get().set(WebPreferencesKey::useGiantTilesKey(), Value(bool(DEFAULT_VALUE_FOR_UseGiantTiles)));
        defaults.get().set(WebPreferencesKey::useImageDocumentForSubframePDFKey(), Value(bool(DEFAULT_VALUE_FOR_UseImageDocumentForSubframePDF)));
        defaults.get().set(WebPreferencesKey::useLegacyBackgroundSizeShorthandBehaviorKey(), Value(bool(DEFAULT_VALUE_FOR_UseLegacyBackgroundSizeShorthandBehavior)));
        defaults.get().set(WebPreferencesKey::useLegacyTextAlignPositionedElementBehaviorKey(), Value(bool(DEFAULT_VALUE_FOR_UseLegacyTextAlignPositionedElementBehavior)));
        defaults.get().set(WebPreferencesKey::usePreHTML5ParserQuirksKey(), Value(bool(DEFAULT_VALUE_FOR_UsePreHTML5ParserQuirks)));
#if HAVE(SCENEKIT)
        defaults.get().set(WebPreferencesKey::useSceneKitForModelKey(), Value(bool(DEFAULT_VALUE_FOR_UseSceneKitForModel)));
#endif
        defaults.get().set(WebPreferencesKey::userGesturePromisePropagationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_UserGesturePromisePropagationEnabled)));
        defaults.get().set(WebPreferencesKey::userInterfaceDirectionPolicyKey(), Value(uint32_t(DEFAULT_VALUE_FOR_UserInterfaceDirectionPolicy)));
        defaults.get().set(WebPreferencesKey::usesBackForwardCacheKey(), Value(bool(DEFAULT_VALUE_FOR_UsesBackForwardCache)));
        defaults.get().set(WebPreferencesKey::usesEncodingDetectorKey(), Value(bool(DEFAULT_VALUE_FOR_UsesEncodingDetector)));
#if ENABLE(VP9)
        defaults.get().set(WebPreferencesKey::vp8DecoderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_VP8DecoderEnabled)));
#endif
#if ENABLE(VP9)
        defaults.get().set(WebPreferencesKey::vp9DecoderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_VP9DecoderEnabled)));
#endif
#if ENABLE(VP9)
        defaults.get().set(WebPreferencesKey::vp9SWDecoderEnabledOnBatteryKey(), Value(bool(DEFAULT_VALUE_FOR_VP9SWDecoderEnabledOnBattery)));
#endif
#if ENABLE(VIDEO)
        defaults.get().set(WebPreferencesKey::videoQualityIncludesDisplayCompositingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_VideoQualityIncludesDisplayCompositingEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::viewGestureDebuggingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_ViewGestureDebuggingEnabled)));
        defaults.get().set(WebPreferencesKey::visibleDebugOverlayRegionsKey(), Value(uint32_t(DEFAULT_VALUE_FOR_VisibleDebugOverlayRegions)));
#if ENABLE(IMAGE_ANALYSIS)
        defaults.get().set(WebPreferencesKey::visualTranslationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_VisualTranslationEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::visualViewportAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_VisualViewportAPIEnabled)));
        defaults.get().set(WebPreferencesKey::visualViewportEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_VisualViewportEnabled)));
#if ENABLE(VORBIS)
        defaults.get().set(WebPreferencesKey::vorbisDecoderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_VorbisDecoderEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::wantsBalancedSetDefersLoadingBehaviorKey(), Value(bool(DEFAULT_VALUE_FOR_WantsBalancedSetDefersLoadingBehavior)));
        defaults.get().set(WebPreferencesKey::webAPIStatisticsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAPIStatisticsEnabled)));
        defaults.get().set(WebPreferencesKey::webAPIsInShadowRealmEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAPIsInShadowRealmEnabled)));
        defaults.get().set(WebPreferencesKey::webAnimationsCompositeOperationsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAnimationsCompositeOperationsEnabled)));
        defaults.get().set(WebPreferencesKey::webAnimationsCustomEffectsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAnimationsCustomEffectsEnabled)));
        defaults.get().set(WebPreferencesKey::webAnimationsCustomFrameRateEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAnimationsCustomFrameRateEnabled)));
        defaults.get().set(WebPreferencesKey::webAnimationsIterationCompositeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAnimationsIterationCompositeEnabled)));
        defaults.get().set(WebPreferencesKey::webAnimationsMutableTimelinesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAnimationsMutableTimelinesEnabled)));
#if ENABLE(WEB_ARCHIVE)
        defaults.get().set(WebPreferencesKey::webArchiveDebugModeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebArchiveDebugModeEnabled)));
#endif
#if ENABLE(WEB_ARCHIVE)
        defaults.get().set(WebPreferencesKey::webArchiveTestingModeEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebArchiveTestingModeEnabled)));
#endif
#if ENABLE(WEBASSEMBLY)
        defaults.get().set(WebPreferencesKey::webAssemblyESMIntegrationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAssemblyESMIntegrationEnabled)));
#endif
#if ENABLE(WEB_AUDIO)
        defaults.get().set(WebPreferencesKey::webAudioEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAudioEnabled)));
#endif
#if ENABLE(WEB_AUTHN)
        defaults.get().set(WebPreferencesKey::webAuthenticationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebAuthenticationEnabled)));
#endif
#if ENABLE(WEBGL2)
        defaults.get().set(WebPreferencesKey::webGL2EnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebGL2Enabled)));
#endif
        defaults.get().set(WebPreferencesKey::webGLDraftExtensionsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebGLDraftExtensionsEnabled)));
        defaults.get().set(WebPreferencesKey::webGLEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebGLEnabled)));
#if ENABLE(WEBGL) && PLATFORM(COCOA)
        defaults.get().set(WebPreferencesKey::webGLUsingMetalKey(), Value(bool(DEFAULT_VALUE_FOR_WebGLUsingMetal)));
#endif
        defaults.get().set(WebPreferencesKey::webGPUKey(), Value(bool(DEFAULT_VALUE_FOR_WebGPU)));
        defaults.get().set(WebPreferencesKey::webLocksAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebLocksAPIEnabled)));
#if ENABLE(WEBM_FORMAT_READER)
        defaults.get().set(WebPreferencesKey::webMFormatReaderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebMFormatReaderEnabled)));
#endif
#if ENABLE(MEDIA_SOURCE)
        defaults.get().set(WebPreferencesKey::webMParserEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebMParserEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::webRTCAudioLatencyAdaptationEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCAudioLatencyAdaptationEnabled)));
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCDTMFEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCDTMFEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCEncodedTransformEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCEncodedTransformEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCH264HardwareEncoderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCH264HardwareEncoderEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCH264LowLatencyEncoderEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCH264LowLatencyEncoderEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCH264SimulcastEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCH264SimulcastEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCH265CodecEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCH265CodecEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCMDNSICECandidatesEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCMDNSICECandidatesEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCPlatformCodecsInGPUProcessEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCPlatformCodecsInGPUProcessEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCPlatformTCPSocketsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCPlatformTCPSocketsEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCPlatformUDPSocketsEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCPlatformUDPSocketsEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCRemoteVideoFrameEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCRemoteVideoFrameEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCSFrameTransformEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCSFrameTransformEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCSocketsProxyingEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCSocketsProxyingEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCVP9Profile0CodecEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCVP9Profile0CodecEnabled)));
#endif
#if ENABLE(WEB_RTC)
        defaults.get().set(WebPreferencesKey::webRTCVP9Profile2CodecEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebRTCVP9Profile2CodecEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::webSecurityEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebSecurityEnabled)));
        defaults.get().set(WebPreferencesKey::webShareEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebShareEnabled)));
        defaults.get().set(WebPreferencesKey::webShareFileAPIEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebShareFileAPIEnabled)));
#if ENABLE(WEBXR)
        defaults.get().set(WebPreferencesKey::webXRAugmentedRealityModuleEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebXRAugmentedRealityModuleEnabled)));
#endif
#if ENABLE(WEBXR)
        defaults.get().set(WebPreferencesKey::webXREnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebXREnabled)));
#endif
#if ENABLE(WEBXR)
        defaults.get().set(WebPreferencesKey::webXRGamepadsModuleEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebXRGamepadsModuleEnabled)));
#endif
#if ENABLE(WEBXR_HANDS)
        defaults.get().set(WebPreferencesKey::webXRHandInputModuleEnabledKey(), Value(bool(DEFAULT_VALUE_FOR_WebXRHandInputModuleEnabled)));
#endif
        defaults.get().set(WebPreferencesKey::wheelEventGesturesBecomeNonBlockingKey(), Value(bool(DEFAULT_VALUE_FOR_WheelEventGesturesBecomeNonBlocking)));
        defaults.get().set(WebPreferencesKey::windowFocusRestrictedKey(), Value(bool(DEFAULT_VALUE_FOR_WindowFocusRestricted)));
#if PLATFORM(IOS_FAMILY)
        defaults.get().set(WebPreferencesKey::zoomOnDoubleTapWhenRootKey(), Value(bool(DEFAULT_VALUE_FOR_ZoomOnDoubleTapWhenRoot)));
#endif
    }

    return defaults;
}

} // namespace WebKit
