/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouchEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSTouchList.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> TouchEvent::Init convertDictionary<TouchEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    TouchEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detailValue.isUndefined()) {
        result.detail = convert<IDLLong>(lexicalGlobalObject, detailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detail = 0;
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.view = nullptr;
    JSValue changedTouchesValue;
    if (isNullOrUndefined)
        changedTouchesValue = jsUndefined();
    else {
        changedTouchesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "changedTouches"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!changedTouchesValue.isUndefined()) {
        result.changedTouches = convert<IDLNullable<IDLInterface<TouchList>>>(lexicalGlobalObject, changedTouchesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.changedTouches = nullptr;
    JSValue targetTouchesValue;
    if (isNullOrUndefined)
        targetTouchesValue = jsUndefined();
    else {
        targetTouchesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetTouches"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetTouchesValue.isUndefined()) {
        result.targetTouches = convert<IDLNullable<IDLInterface<TouchList>>>(lexicalGlobalObject, targetTouchesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.targetTouches = nullptr;
    JSValue touchesValue;
    if (isNullOrUndefined)
        touchesValue = jsUndefined();
    else {
        touchesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "touches"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!touchesValue.isUndefined()) {
        result.touches = convert<IDLNullable<IDLInterface<TouchList>>>(lexicalGlobalObject, touchesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.touches = nullptr;
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsTouchEventPrototypeFunction_initTouchEvent);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsTouchEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsTouchEvent_touches);
static JSC_DECLARE_CUSTOM_GETTER(jsTouchEvent_targetTouches);
static JSC_DECLARE_CUSTOM_GETTER(jsTouchEvent_changedTouches);
static JSC_DECLARE_CUSTOM_GETTER(jsTouchEvent_ctrlKey);
static JSC_DECLARE_CUSTOM_GETTER(jsTouchEvent_shiftKey);
static JSC_DECLARE_CUSTOM_GETTER(jsTouchEvent_altKey);
static JSC_DECLARE_CUSTOM_GETTER(jsTouchEvent_metaKey);

class JSTouchEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTouchEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTouchEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSTouchEventPrototype>(vm)) JSTouchEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTouchEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTouchEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSTouchEventPrototype, JSTouchEventPrototype::Base);

using JSTouchEventDOMConstructor = JSDOMConstructor<JSTouchEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSTouchEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSTouchEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDict = convert<IDLDictionary<TouchEvent::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = TouchEvent::create(WTFMove(type), WTFMove(eventInitDict));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<TouchEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<TouchEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSTouchEventDOMConstructorConstruct, JSTouchEventDOMConstructor::construct);

template<> const ClassInfo JSTouchEventDOMConstructor::s_info = { "TouchEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTouchEventDOMConstructor) };

template<> JSValue JSTouchEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSTouchEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TouchEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSTouchEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSTouchEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "touches"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEvent_touches), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "targetTouches"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEvent_targetTouches), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "changedTouches"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEvent_changedTouches), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ctrlKey"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEvent_ctrlKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shiftKey"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEvent_shiftKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "altKey"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEvent_altKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "metaKey"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEvent_metaKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initTouchEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsTouchEventPrototypeFunction_initTouchEvent), (intptr_t) (0) } },
};

const ClassInfo JSTouchEventPrototype::s_info = { "TouchEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTouchEventPrototype) };

void JSTouchEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTouchEvent::info(), JSTouchEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSTouchEvent::s_info = { "TouchEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSTouchEvent) };

JSTouchEvent::JSTouchEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TouchEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

void JSTouchEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(info()));

    static_assert(!std::is_base_of<ActiveDOMObject, TouchEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSTouchEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSTouchEventPrototype::create(vm, &globalObject, JSTouchEventPrototype::createStructure(vm, &globalObject, JSUIEvent::prototype(vm, globalObject)));
}

JSObject* JSTouchEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSTouchEvent>(vm, globalObject);
}

JSValue JSTouchEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchEventDOMConstructor, DOMConstructorID::TouchEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsTouchEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSTouchEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSTouchEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsTouchEvent_touchesGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TouchList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.touches())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTouchEvent_touches, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEvent_touchesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTouchEvent_targetTouchesGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TouchList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.targetTouches())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTouchEvent_targetTouches, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEvent_targetTouchesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTouchEvent_changedTouchesGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TouchList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.changedTouches())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTouchEvent_changedTouches, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEvent_changedTouchesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTouchEvent_ctrlKeyGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ctrlKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTouchEvent_ctrlKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEvent_ctrlKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTouchEvent_shiftKeyGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.shiftKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTouchEvent_shiftKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEvent_shiftKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTouchEvent_altKeyGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.altKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTouchEvent_altKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEvent_altKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsTouchEvent_metaKeyGetter(JSGlobalObject& lexicalGlobalObject, JSTouchEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.metaKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsTouchEvent_metaKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSTouchEvent>::get<jsTouchEvent_metaKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsTouchEventPrototypeFunction_initTouchEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSTouchEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto touches = convert<IDLNullable<IDLInterface<TouchList>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "touches", "TouchEvent", "initTouchEvent", "TouchList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto targetTouches = convert<IDLNullable<IDLInterface<TouchList>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "targetTouches", "TouchEvent", "initTouchEvent", "TouchList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto changedTouches = convert<IDLNullable<IDLInterface<TouchList>>>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "changedTouches", "TouchEvent", "initTouchEvent", "TouchList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto type = argument3.value().isUndefined() ? nullAtom() : convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument3.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto view = convert<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, argument4.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 4, "view", "TouchEvent", "initTouchEvent", "WindowProxy"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto screenX = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument6 = callFrame->argument(6);
    auto screenY = convert<IDLLong>(*lexicalGlobalObject, argument6.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument7 = callFrame->argument(7);
    auto clientX = convert<IDLLong>(*lexicalGlobalObject, argument7.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument8 = callFrame->argument(8);
    auto clientY = convert<IDLLong>(*lexicalGlobalObject, argument8.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument9 = callFrame->argument(9);
    auto ctrlKey = convert<IDLBoolean>(*lexicalGlobalObject, argument9.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument10 = callFrame->argument(10);
    auto altKey = convert<IDLBoolean>(*lexicalGlobalObject, argument10.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument11 = callFrame->argument(11);
    auto shiftKey = convert<IDLBoolean>(*lexicalGlobalObject, argument11.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument12 = callFrame->argument(12);
    auto metaKey = convert<IDLBoolean>(*lexicalGlobalObject, argument12.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.initTouchEvent(WTFMove(touches), WTFMove(targetTouches), WTFMove(changedTouches), WTFMove(type), WTFMove(view), WTFMove(screenX), WTFMove(screenY), WTFMove(clientX), WTFMove(clientY), WTFMove(ctrlKey), WTFMove(altKey), WTFMove(shiftKey), WTFMove(metaKey)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsTouchEventPrototypeFunction_initTouchEvent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSTouchEvent>::call<jsTouchEventPrototypeFunction_initTouchEventBody>(*lexicalGlobalObject, *callFrame, "initTouchEvent");
}

JSC::GCClient::IsoSubspace* JSTouchEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSTouchEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForTouchEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForTouchEvent = WTFMove(space); },
        [] (auto& spaces) { return spaces.m_subspaceForTouchEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForTouchEvent = WTFMove(space); }
    );
}

void JSTouchEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSTouchEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TouchEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10TouchEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<TouchEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<TouchEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7TouchEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10TouchEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // TouchEvent has subclasses. If TouchEvent has subclasses that get passed
        // to toJS() we currently require TouchEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<TouchEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, TouchEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(TOUCH_EVENTS)
