/* settings_main.c generated by valac 0.56.3, the Vala compiler
 * generated from settings_main.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>
#include "budgie-private.h"
#include <glib/gi18n-lib.h>
#include <stdio.h>

#define BUDGIE_SETTINGS_DBUS_NAME "org.budgie_desktop.Settings"
#define BUDGIE_SETTINGS_DBUS_PATH "/org/budgie_desktop/Settings"
#define BUDGIE_SETTINGS_GROUP_PANEL "panel"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SETTINGS_IFACE (budgie_settings_iface_get_type ())
#define BUDGIE_SETTINGS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_IFACE, BudgieSettingsIface))
#define BUDGIE_SETTINGS_IFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_IFACE, BudgieSettingsIfaceClass))
#define BUDGIE_IS_SETTINGS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_IFACE))
#define BUDGIE_IS_SETTINGS_IFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_IFACE))
#define BUDGIE_SETTINGS_IFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_IFACE, BudgieSettingsIfaceClass))

typedef struct _BudgieSettingsIface BudgieSettingsIface;
typedef struct _BudgieSettingsIfaceClass BudgieSettingsIfaceClass;
typedef struct _BudgieSettingsIfacePrivate BudgieSettingsIfacePrivate;

#define BUDGIE_TYPE_SETTINGS_WINDOW (budgie_settings_window_get_type ())
#define BUDGIE_SETTINGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_WINDOW, BudgieSettingsWindow))
#define BUDGIE_SETTINGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_WINDOW, BudgieSettingsWindowClass))
#define BUDGIE_IS_SETTINGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_WINDOW))
#define BUDGIE_IS_SETTINGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_WINDOW))
#define BUDGIE_SETTINGS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_WINDOW, BudgieSettingsWindowClass))

typedef struct _BudgieSettingsWindow BudgieSettingsWindow;
typedef struct _BudgieSettingsWindowClass BudgieSettingsWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BudgieParamSpecSettingsIface BudgieParamSpecSettingsIface;
typedef struct _BudgieSettingsWindowPrivate BudgieSettingsWindowPrivate;

#define BUDGIE_TYPE_SETTINGS_PAGE (budgie_settings_page_get_type ())
#define BUDGIE_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage))
#define BUDGIE_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))
#define BUDGIE_IS_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_IS_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_SETTINGS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))

typedef struct _BudgieSettingsPage BudgieSettingsPage;
typedef struct _BudgieSettingsPageClass BudgieSettingsPageClass;

#define BUDGIE_TYPE_SETTINGS_ITEM (budgie_settings_item_get_type ())
#define BUDGIE_SETTINGS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_ITEM, BudgieSettingsItem))
#define BUDGIE_SETTINGS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_ITEM, BudgieSettingsItemClass))
#define BUDGIE_IS_SETTINGS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_ITEM))
#define BUDGIE_IS_SETTINGS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_ITEM))
#define BUDGIE_SETTINGS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_ITEM, BudgieSettingsItemClass))

typedef struct _BudgieSettingsItem BudgieSettingsItem;
typedef struct _BudgieSettingsItemClass BudgieSettingsItemClass;
enum  {
	BUDGIE_SETTINGS_WINDOW_0_PROPERTY,
	BUDGIE_SETTINGS_WINDOW_MANAGER_PROPERTY,
	BUDGIE_SETTINGS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* budgie_settings_window_properties[BUDGIE_SETTINGS_WINDOW_NUM_PROPERTIES];
#define _budgie_settings_iface_unref0(var) ((var == NULL) ? NULL : (var = (budgie_settings_iface_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BUDGIE_TYPE_STYLE_PAGE (budgie_style_page_get_type ())
#define BUDGIE_STYLE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_STYLE_PAGE, BudgieStylePage))
#define BUDGIE_STYLE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_STYLE_PAGE, BudgieStylePageClass))
#define BUDGIE_IS_STYLE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_STYLE_PAGE))
#define BUDGIE_IS_STYLE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_STYLE_PAGE))
#define BUDGIE_STYLE_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_STYLE_PAGE, BudgieStylePageClass))

typedef struct _BudgieStylePage BudgieStylePage;
typedef struct _BudgieStylePageClass BudgieStylePageClass;

#define BUDGIE_TYPE_DESKTOP_PAGE (budgie_desktop_page_get_type ())
#define BUDGIE_DESKTOP_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_DESKTOP_PAGE, BudgieDesktopPage))
#define BUDGIE_DESKTOP_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_DESKTOP_PAGE, BudgieDesktopPageClass))
#define BUDGIE_IS_DESKTOP_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_DESKTOP_PAGE))
#define BUDGIE_IS_DESKTOP_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_DESKTOP_PAGE))
#define BUDGIE_DESKTOP_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_DESKTOP_PAGE, BudgieDesktopPageClass))

typedef struct _BudgieDesktopPage BudgieDesktopPage;
typedef struct _BudgieDesktopPageClass BudgieDesktopPageClass;

#define BUDGIE_TYPE_FONT_PAGE (budgie_font_page_get_type ())
#define BUDGIE_FONT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_FONT_PAGE, BudgieFontPage))
#define BUDGIE_FONT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_FONT_PAGE, BudgieFontPageClass))
#define BUDGIE_IS_FONT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_FONT_PAGE))
#define BUDGIE_IS_FONT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_FONT_PAGE))
#define BUDGIE_FONT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_FONT_PAGE, BudgieFontPageClass))

typedef struct _BudgieFontPage BudgieFontPage;
typedef struct _BudgieFontPageClass BudgieFontPageClass;

#define BUDGIE_TYPE_WINDOWS_PAGE (budgie_windows_page_get_type ())
#define BUDGIE_WINDOWS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_WINDOWS_PAGE, BudgieWindowsPage))
#define BUDGIE_WINDOWS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_WINDOWS_PAGE, BudgieWindowsPageClass))
#define BUDGIE_IS_WINDOWS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_WINDOWS_PAGE))
#define BUDGIE_IS_WINDOWS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_WINDOWS_PAGE))
#define BUDGIE_WINDOWS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_WINDOWS_PAGE, BudgieWindowsPageClass))

typedef struct _BudgieWindowsPage BudgieWindowsPage;
typedef struct _BudgieWindowsPageClass BudgieWindowsPageClass;

#define BUDGIE_TYPE_AUTOSTART_PAGE (budgie_autostart_page_get_type ())
#define BUDGIE_AUTOSTART_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_AUTOSTART_PAGE, BudgieAutostartPage))
#define BUDGIE_AUTOSTART_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_AUTOSTART_PAGE, BudgieAutostartPageClass))
#define BUDGIE_IS_AUTOSTART_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_AUTOSTART_PAGE))
#define BUDGIE_IS_AUTOSTART_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_AUTOSTART_PAGE))
#define BUDGIE_AUTOSTART_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_AUTOSTART_PAGE, BudgieAutostartPageClass))

typedef struct _BudgieAutostartPage BudgieAutostartPage;
typedef struct _BudgieAutostartPageClass BudgieAutostartPageClass;

#define BUDGIE_TYPE_RAVEN_PAGE (budgie_raven_page_get_type ())
#define BUDGIE_RAVEN_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_PAGE, BudgieRavenPage))
#define BUDGIE_RAVEN_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN_PAGE, BudgieRavenPageClass))
#define BUDGIE_IS_RAVEN_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_PAGE))
#define BUDGIE_IS_RAVEN_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN_PAGE))
#define BUDGIE_RAVEN_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN_PAGE, BudgieRavenPageClass))

typedef struct _BudgieRavenPage BudgieRavenPage;
typedef struct _BudgieRavenPageClass BudgieRavenPageClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;

#define BUDGIE_TYPE_PANEL_PAGE (budgie_panel_page_get_type ())
#define BUDGIE_PANEL_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_PAGE, BudgiePanelPage))
#define BUDGIE_PANEL_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_PAGE, BudgiePanelPageClass))
#define BUDGIE_IS_PANEL_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_PAGE))
#define BUDGIE_IS_PANEL_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_PAGE))
#define BUDGIE_PANEL_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_PAGE, BudgiePanelPageClass))

typedef struct _BudgiePanelPage BudgiePanelPage;
typedef struct _BudgiePanelPageClass BudgiePanelPageClass;

struct _BudgieSettingsIface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieSettingsIfacePrivate * priv;
};

struct _BudgieSettingsIfaceClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieSettingsIface *self);
};

struct _BudgieSettingsIfacePrivate {
	BudgieSettingsWindow* settings_window;
};

struct _BudgieParamSpecSettingsIface {
	GParamSpec parent_instance;
};

struct _BudgieSettingsWindow {
	GtkWindow parent_instance;
	BudgieSettingsWindowPrivate * priv;
};

struct _BudgieSettingsWindowClass {
	GtkWindowClass parent_class;
};

struct _BudgieSettingsWindowPrivate {
	BudgieSettingsIface* iface;
	GDBusConnection* conn;
	guint* register_id;
	GtkHeaderBar* header;
	GtkListBox* sidebar;
	GtkStack* content;
	GtkBox* layout;
	GHashTable* group_map;
	GHashTable* page_map;
	GHashTable* sidebar_map;
	BudgieDesktopManager* _manager;
	BudgieSettingsItem* item_add_panel;
	gboolean new_panel_requested;
};

struct _Block5Data {
	int _ref_count_;
	BudgieSettingsWindow* self;
	gchar* content_id;
};

static gint BudgieSettingsIface_private_offset;
static gpointer budgie_settings_iface_parent_class = NULL;
static gint BudgieSettingsWindow_private_offset;
static gpointer budgie_settings_window_parent_class = NULL;

VALA_EXTERN gpointer budgie_settings_iface_ref (gpointer instance);
VALA_EXTERN void budgie_settings_iface_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_settings_iface (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void budgie_value_set_settings_iface (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void budgie_value_take_settings_iface (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_settings_iface (const GValue* value);
VALA_EXTERN GType budgie_settings_iface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsIface, budgie_settings_iface_unref)
VALA_EXTERN guint budgie_settings_iface_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType budgie_settings_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsWindow, g_object_unref)
VALA_EXTERN BudgieSettingsIface* budgie_settings_iface_new (BudgieSettingsWindow* win);
VALA_EXTERN BudgieSettingsIface* budgie_settings_iface_construct (GType object_type,
                                                      BudgieSettingsWindow* win);
VALA_EXTERN void budgie_settings_iface_Close (BudgieSettingsIface* self,
                                  GError** error);
VALA_EXTERN void budgie_settings_window_requested_close (BudgieSettingsWindow* self,
                                             GError** error);
static void budgie_settings_iface_finalize (BudgieSettingsIface * obj);
static GType budgie_settings_iface_get_type_once (void);
static void _dbus_budgie_settings_iface_Close (BudgieSettingsIface* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void budgie_settings_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* budgie_settings_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean budgie_settings_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _budgie_settings_iface_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_settings_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPage, g_object_unref)
VALA_EXTERN GType budgie_settings_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsItem, g_object_unref)
VALA_EXTERN BudgieSettingsWindow* budgie_settings_window_new (BudgieDesktopManager* manager);
VALA_EXTERN BudgieSettingsWindow* budgie_settings_window_construct (GType object_type,
                                                        BudgieDesktopManager* manager);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void budgie_settings_window_do_headers (BudgieSettingsWindow* self,
                                        GtkListBoxRow* before,
                                        GtkListBoxRow* after);
static void _budgie_settings_window_do_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                         GtkListBoxRow* before,
                                                                         gpointer self);
static gint budgie_settings_window_do_sort (BudgieSettingsWindow* self,
                                     GtkListBoxRow* before,
                                     GtkListBoxRow* after);
static gint _budgie_settings_window_do_sort_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                             GtkListBoxRow* row2,
                                                             gpointer self);
static void budgie_settings_window_on_row_activate (BudgieSettingsWindow* self,
                                             GtkListBoxRow* row);
static void _budgie_settings_window_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self);
static void budgie_settings_window_build_content (BudgieSettingsWindow* self);
VALA_EXTERN BudgieSettingsItem* budgie_settings_item_new (const gchar* group,
                                              const gchar* content_id,
                                              const gchar* label,
                                              const gchar* icon_name);
VALA_EXTERN BudgieSettingsItem* budgie_settings_item_construct (GType object_type,
                                                    const gchar* group,
                                                    const gchar* content_id,
                                                    const gchar* label,
                                                    const gchar* icon_name);
VALA_EXTERN BudgieDesktopManager* budgie_settings_window_get_manager (BudgieSettingsWindow* self);
static void budgie_settings_window_on_panel_added (BudgieSettingsWindow* self,
                                            const gchar* uuid,
                                            BudgieToplevel* toplevel);
static void _budgie_settings_window_on_panel_added_budgie_desktop_manager_panel_added (BudgieDesktopManager* _sender,
                                                                                const gchar* uuid,
                                                                                BudgieToplevel* toplevel,
                                                                                gpointer self);
static void budgie_settings_window_on_panel_deleted (BudgieSettingsWindow* self,
                                              const gchar* uuid);
static void _budgie_settings_window_on_panel_deleted_budgie_desktop_manager_panel_deleted (BudgieDesktopManager* _sender,
                                                                                    const gchar* uuid,
                                                                                    gpointer self);
static void budgie_settings_window_on_panels_changed (BudgieSettingsWindow* self);
static void _budgie_settings_window_on_panels_changed_budgie_desktop_manager_panels_changed (BudgieDesktopManager* _sender,
                                                                                      gpointer self);
static void budgie_settings_window_on_bus_acquired (BudgieSettingsWindow* self,
                                             GDBusConnection* c);
static void _budgie_settings_window_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                     const gchar* name,
                                                                     gpointer self);
VALA_EXTERN void budgie_settings_window_on_name_acquired (BudgieSettingsWindow* self,
                                              GDBusConnection* c,
                                              const gchar* name);
static void _budgie_settings_window_on_name_acquired_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                           const gchar* name,
                                                                           gpointer self);
VALA_EXTERN void budgie_settings_window_on_name_lost (BudgieSettingsWindow* self,
                                          GDBusConnection* c,
                                          const gchar* name);
static void _budgie_settings_window_on_name_lost_gbus_name_lost_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self);
static void __lambda21_ (BudgieSettingsWindow* self);
static void ___lambda21__gtk_widget_unrealize (GtkWidget* _sender,
                                        gpointer self);
static void budgie_settings_window_add_page (BudgieSettingsWindow* self,
                                      BudgieSettingsPage* page);
VALA_EXTERN BudgieStylePage* budgie_style_page_new (void);
VALA_EXTERN BudgieStylePage* budgie_style_page_construct (GType object_type);
VALA_EXTERN GType budgie_style_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieStylePage, g_object_unref)
VALA_EXTERN BudgieDesktopPage* budgie_desktop_page_new (void);
VALA_EXTERN BudgieDesktopPage* budgie_desktop_page_construct (GType object_type);
VALA_EXTERN GType budgie_desktop_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieDesktopPage, g_object_unref)
VALA_EXTERN BudgieFontPage* budgie_font_page_new (void);
VALA_EXTERN BudgieFontPage* budgie_font_page_construct (GType object_type);
VALA_EXTERN GType budgie_font_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieFontPage, g_object_unref)
VALA_EXTERN BudgieWindowsPage* budgie_windows_page_new (void);
VALA_EXTERN BudgieWindowsPage* budgie_windows_page_construct (GType object_type);
VALA_EXTERN GType budgie_windows_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieWindowsPage, g_object_unref)
VALA_EXTERN BudgieAutostartPage* budgie_autostart_page_new (void);
VALA_EXTERN BudgieAutostartPage* budgie_autostart_page_construct (GType object_type);
VALA_EXTERN GType budgie_autostart_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAutostartPage, g_object_unref)
VALA_EXTERN BudgieRavenPage* budgie_raven_page_new (void);
VALA_EXTERN BudgieRavenPage* budgie_raven_page_construct (GType object_type);
VALA_EXTERN GType budgie_raven_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRavenPage, g_object_unref)
static guint* _uint_dup (guint* self);
static gboolean __lambda20_ (BudgieSettingsWindow* self);
static gboolean ___lambda20__gsource_func (gpointer self);
VALA_EXTERN const gchar* budgie_settings_item_get_content_id (BudgieSettingsItem* self);
VALA_EXTERN const gchar* budgie_settings_page_get_group (BudgieSettingsPage* self);
VALA_EXTERN const gchar* budgie_settings_page_get_content_id (BudgieSettingsPage* self);
VALA_EXTERN const gchar* budgie_settings_page_get_title (BudgieSettingsPage* self);
VALA_EXTERN const gchar* budgie_settings_page_get_icon_name (BudgieSettingsPage* self);
VALA_EXTERN gboolean budgie_settings_page_get_want_scroll (BudgieSettingsPage* self);
static void budgie_settings_window_remove_page (BudgieSettingsWindow* self,
                                         const gchar* content_id);
VALA_EXTERN const gchar* budgie_settings_item_get_group (BudgieSettingsItem* self);
VALA_EXTERN gint budgie_settings_item_get_display_weight (BudgieSettingsItem* self);
static void budgie_settings_window_force_select_page (BudgieSettingsWindow* self,
                                               const gchar* content_id);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda19_ (Block5Data* _data5_);
static gboolean ___lambda19__gsource_func (gpointer self);
VALA_EXTERN BudgiePanelPage* budgie_panel_page_new (BudgieDesktopManager* manager,
                                        BudgieToplevel* toplevel);
VALA_EXTERN BudgiePanelPage* budgie_panel_page_construct (GType object_type,
                                              BudgieDesktopManager* manager,
                                              BudgieToplevel* toplevel);
VALA_EXTERN GType budgie_panel_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanelPage, g_object_unref)
VALA_EXTERN void budgie_settings_window_set_manager (BudgieSettingsWindow* self,
                                         BudgieDesktopManager* value);
static void budgie_settings_window_finalize (GObject * obj);
static GType budgie_settings_window_get_type_once (void);
static void _vala_budgie_settings_window_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_budgie_settings_window_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static const GDBusArgInfo * const _budgie_settings_iface_dbus_arg_info_Close_in[] = {NULL};
static const GDBusArgInfo * const _budgie_settings_iface_dbus_arg_info_Close_out[] = {NULL};
static const GDBusMethodInfo _budgie_settings_iface_dbus_method_info_Close = {-1, "Close", (GDBusArgInfo **) (&_budgie_settings_iface_dbus_arg_info_Close_in), (GDBusArgInfo **) (&_budgie_settings_iface_dbus_arg_info_Close_out), NULL};
static const GDBusMethodInfo * const _budgie_settings_iface_dbus_method_info[] = {&_budgie_settings_iface_dbus_method_info_Close, NULL};
static const GDBusSignalInfo * const _budgie_settings_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_settings_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_settings_iface_dbus_interface_info = {-1, "org.budgie_desktop.Settings", (GDBusMethodInfo **) (&_budgie_settings_iface_dbus_method_info), (GDBusSignalInfo **) (&_budgie_settings_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_settings_iface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_settings_iface_dbus_interface_vtable = {budgie_settings_iface_dbus_interface_method_call, budgie_settings_iface_dbus_interface_get_property, budgie_settings_iface_dbus_interface_set_property};

static inline gpointer
budgie_settings_iface_get_instance_private (BudgieSettingsIface* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieSettingsIface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgieSettingsIface*
budgie_settings_iface_construct (GType object_type,
                                 BudgieSettingsWindow* win)
{
	BudgieSettingsIface* self = NULL;
	BudgieSettingsWindow* _tmp0_;
	self = (BudgieSettingsIface*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (win);
	_g_object_unref0 (self->priv->settings_window);
	self->priv->settings_window = _tmp0_;
	return self;
}

BudgieSettingsIface*
budgie_settings_iface_new (BudgieSettingsWindow* win)
{
	return budgie_settings_iface_construct (BUDGIE_TYPE_SETTINGS_IFACE, win);
}

void
budgie_settings_iface_Close (BudgieSettingsIface* self,
                             GError** error)
{
	BudgieSettingsWindow* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings_window;
	budgie_settings_window_requested_close (_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
budgie_value_settings_iface_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_settings_iface_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_settings_iface_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_settings_iface_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_settings_iface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_settings_iface_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_settings_iface_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieSettingsIface * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_settings_iface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_settings_iface_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	BudgieSettingsIface ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_settings_iface_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_settings_iface (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	BudgieParamSpecSettingsIface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_SETTINGS_IFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_settings_iface (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_SETTINGS_IFACE), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_settings_iface (GValue* value,
                                 gpointer v_object)
{
	BudgieSettingsIface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_SETTINGS_IFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_SETTINGS_IFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_settings_iface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_settings_iface_unref (old);
	}
}

void
budgie_value_take_settings_iface (GValue* value,
                                  gpointer v_object)
{
	BudgieSettingsIface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_SETTINGS_IFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_SETTINGS_IFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_settings_iface_unref (old);
	}
}

static void
budgie_settings_iface_class_init (BudgieSettingsIfaceClass * klass,
                                  gpointer klass_data)
{
	budgie_settings_iface_parent_class = g_type_class_peek_parent (klass);
	((BudgieSettingsIfaceClass *) klass)->finalize = budgie_settings_iface_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieSettingsIface_private_offset);
}

static void
budgie_settings_iface_instance_init (BudgieSettingsIface * self,
                                     gpointer klass)
{
	self->priv = budgie_settings_iface_get_instance_private (self);
	self->priv->settings_window = NULL;
	self->ref_count = 1;
}

static void
budgie_settings_iface_finalize (BudgieSettingsIface * obj)
{
	BudgieSettingsIface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SETTINGS_IFACE, BudgieSettingsIface);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->settings_window);
}

static GType
budgie_settings_iface_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_settings_iface_init, budgie_value_settings_iface_free_value, budgie_value_settings_iface_copy_value, budgie_value_settings_iface_peek_pointer, "p", budgie_value_settings_iface_collect_value, "p", budgie_value_settings_iface_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSettingsIfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_settings_iface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSettingsIface), 0, (GInstanceInitFunc) budgie_settings_iface_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_settings_iface_type_id;
	budgie_settings_iface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieSettingsIface", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (budgie_settings_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_settings_iface_register_object);
	BudgieSettingsIface_private_offset = g_type_add_instance_private (budgie_settings_iface_type_id, sizeof (BudgieSettingsIfacePrivate));
	return budgie_settings_iface_type_id;
}

GType
budgie_settings_iface_get_type (void)
{
	static volatile gsize budgie_settings_iface_type_id__once = 0;
	if (g_once_init_enter (&budgie_settings_iface_type_id__once)) {
		GType budgie_settings_iface_type_id;
		budgie_settings_iface_type_id = budgie_settings_iface_get_type_once ();
		g_once_init_leave (&budgie_settings_iface_type_id__once, budgie_settings_iface_type_id);
	}
	return budgie_settings_iface_type_id__once;
}

gpointer
budgie_settings_iface_ref (gpointer instance)
{
	BudgieSettingsIface * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_settings_iface_unref (gpointer instance)
{
	BudgieSettingsIface * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_SETTINGS_IFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_dbus_budgie_settings_iface_Close (BudgieSettingsIface* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_settings_iface_Close (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_settings_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Close") == 0) {
		_dbus_budgie_settings_iface_Close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_settings_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_settings_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_settings_iface_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = budgie_settings_iface_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_settings_iface_dbus_interface_info), &_budgie_settings_iface_dbus_interface_vtable, data, _budgie_settings_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_settings_iface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	budgie_settings_iface_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_settings_window_get_instance_private (BudgieSettingsWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieSettingsWindow_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_budgie_settings_window_do_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                    GtkListBoxRow* before,
                                                                    gpointer self)
{
	budgie_settings_window_do_headers ((BudgieSettingsWindow*) self, row, before);
}

static gint
_budgie_settings_window_do_sort_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                        GtkListBoxRow* row2,
                                                        gpointer self)
{
	gint result;
	result = budgie_settings_window_do_sort ((BudgieSettingsWindow*) self, row1, row2);
	return result;
}

static void
_budgie_settings_window_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                    GtkListBoxRow* row,
                                                                    gpointer self)
{
	budgie_settings_window_on_row_activate ((BudgieSettingsWindow*) self, row);
}

static void
_budgie_settings_window_on_panel_added_budgie_desktop_manager_panel_added (BudgieDesktopManager* _sender,
                                                                           const gchar* uuid,
                                                                           BudgieToplevel* toplevel,
                                                                           gpointer self)
{
	budgie_settings_window_on_panel_added ((BudgieSettingsWindow*) self, uuid, toplevel);
}

static void
_budgie_settings_window_on_panel_deleted_budgie_desktop_manager_panel_deleted (BudgieDesktopManager* _sender,
                                                                               const gchar* uuid,
                                                                               gpointer self)
{
	budgie_settings_window_on_panel_deleted ((BudgieSettingsWindow*) self, uuid);
}

static void
_budgie_settings_window_on_panels_changed_budgie_desktop_manager_panels_changed (BudgieDesktopManager* _sender,
                                                                                 gpointer self)
{
	budgie_settings_window_on_panels_changed ((BudgieSettingsWindow*) self);
}

static void
_budgie_settings_window_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                const gchar* name,
                                                                gpointer self)
{
	budgie_settings_window_on_bus_acquired ((BudgieSettingsWindow*) self, connection);
}

static void
_budgie_settings_window_on_name_acquired_gbus_name_acquired_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      gpointer self)
{
	budgie_settings_window_on_name_acquired ((BudgieSettingsWindow*) self, connection, name);
}

static void
_budgie_settings_window_on_name_lost_gbus_name_lost_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self)
{
	budgie_settings_window_on_name_lost ((BudgieSettingsWindow*) self, connection, name);
}

static void
__lambda21_ (BudgieSettingsWindow* self)
{
	GDBusConnection* _tmp0_;
	_tmp0_ = self->priv->conn;
	if (_tmp0_ != NULL) {
		GDBusConnection* _tmp1_;
		guint* _tmp2_;
		_tmp1_ = self->priv->conn;
		_tmp2_ = self->priv->register_id;
		g_dbus_connection_unregister_object (_tmp1_, *_tmp2_);
	}
}

static void
___lambda21__gtk_widget_unrealize (GtkWidget* _sender,
                                   gpointer self)
{
	__lambda21_ ((BudgieSettingsWindow*) self);
}

BudgieSettingsWindow*
budgie_settings_window_construct (GType object_type,
                                  BudgieDesktopManager* manager)
{
	BudgieSettingsWindow * self = NULL;
	GtkHeaderBar* _tmp0_;
	GtkHeaderBar* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GHashFunc _tmp15_;
	GEqualFunc _tmp16_;
	GHashTable* _tmp17_;
	GHashFunc _tmp18_;
	GEqualFunc _tmp19_;
	GHashTable* _tmp20_;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp23_;
	GtkListBox* _tmp24_;
	GtkListBox* _tmp25_;
	GtkListBox* _tmp26_;
	GtkListBox* _tmp27_;
	GtkListBox* _tmp28_;
	GtkListBox* _tmp29_;
	GtkBox* _tmp30_;
	GtkStack* _tmp31_;
	GtkStack* _tmp32_;
	GtkBox* _tmp33_;
	GtkStack* _tmp34_;
	GtkStyleContext* _tmp35_;
	GtkListBox* _tmp36_;
	GtkStyleContext* _tmp37_;
	BudgieSettingsItem* _tmp38_;
	GtkListBox* _tmp39_;
	BudgieSettingsItem* _tmp40_;
	BudgieDesktopManager* _tmp41_;
	BudgieDesktopManager* _tmp42_;
	BudgieDesktopManager* _tmp43_;
	GtkBox* _tmp44_;
	GtkHeaderBar* _tmp45_;
	self = (BudgieSettingsWindow*) g_object_new (object_type, "type", GTK_WINDOW_TOPLEVEL, "icon-name", "preferences-desktop", "manager", manager, NULL);
	_tmp0_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp0_;
	_tmp1_ = self->priv->header;
	gtk_header_bar_set_show_close_button (_tmp1_, TRUE);
	_tmp2_ = self->priv->header;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->group_map);
	self->priv->group_map = _tmp5_;
	_tmp6_ = self->priv->group_map;
	_tmp7_ = g_strdup ("appearance");
	_tmp8_ = g_strdup (_ ("Appearance"));
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = self->priv->group_map;
	_tmp10_ = g_strdup ("panel");
	_tmp11_ = g_strdup (_ ("Panels"));
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->group_map;
	_tmp13_ = g_strdup ("session");
	_tmp14_ = g_strdup (_ ("Session"));
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = g_str_hash;
	_tmp16_ = g_str_equal;
	_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->page_map);
	self->priv->page_map = _tmp17_;
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->sidebar_map);
	self->priv->sidebar_map = _tmp20_;
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp21_;
	_tmp22_ = self->priv->layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp22_);
	gtk_window_set_icon_name ((GtkWindow*) self, "preferences-desktop");
	gtk_window_set_title ((GtkWindow*) self, _ ("Budgie Desktop Settings"));
	gtk_window_set_wmclass ((GtkWindow*) self, "budgie-desktop-settings", "budgie-desktop-settings");
	gtk_window_set_default_size ((GtkWindow*) self, 750, 550);
	_tmp23_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp23_);
	scroll = _tmp23_;
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp24_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->sidebar);
	self->priv->sidebar = _tmp24_;
	_tmp25_ = self->priv->sidebar;
	gtk_list_box_set_header_func (_tmp25_, _budgie_settings_window_do_headers_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp26_ = self->priv->sidebar;
	gtk_list_box_set_sort_func (_tmp26_, _budgie_settings_window_do_sort_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp27_ = self->priv->sidebar;
	g_signal_connect_object (_tmp27_, "row-activated", (GCallback) _budgie_settings_window_on_row_activate_gtk_list_box_row_activated, self, 0);
	_tmp28_ = self->priv->sidebar;
	gtk_list_box_set_activate_on_single_click (_tmp28_, TRUE);
	_tmp29_ = self->priv->sidebar;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->layout;
	gtk_box_pack_start (_tmp30_, (GtkWidget*) scroll, FALSE, FALSE, (guint) 0);
	gtk_widget_set_margin_end ((GtkWidget*) scroll, 24);
	_tmp31_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->content);
	self->priv->content = _tmp31_;
	_tmp32_ = self->priv->content;
	gtk_stack_set_transition_type (_tmp32_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp33_ = self->priv->layout;
	_tmp34_ = self->priv->content;
	gtk_box_pack_start (_tmp33_, (GtkWidget*) _tmp34_, TRUE, TRUE, (guint) 0);
	_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp35_, "budgie-settings-window");
	_tmp36_ = self->priv->sidebar;
	_tmp37_ = gtk_widget_get_style_context ((GtkWidget*) _tmp36_);
	gtk_style_context_add_class (_tmp37_, GTK_STYLE_CLASS_SIDEBAR);
	budgie_settings_window_build_content (self);
	_tmp38_ = budgie_settings_item_new (BUDGIE_SETTINGS_GROUP_PANEL, "x-add-panel", _ ("Create new panel"), "list-add-symbolic");
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->item_add_panel);
	self->priv->item_add_panel = _tmp38_;
	_tmp39_ = self->priv->sidebar;
	_tmp40_ = self->priv->item_add_panel;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->_manager;
	g_signal_connect_object (_tmp41_, "panel-added", (GCallback) _budgie_settings_window_on_panel_added_budgie_desktop_manager_panel_added, self, 0);
	_tmp42_ = self->priv->_manager;
	g_signal_connect_object (_tmp42_, "panel-deleted", (GCallback) _budgie_settings_window_on_panel_deleted_budgie_desktop_manager_panel_deleted, self, 0);
	_tmp43_ = self->priv->_manager;
	g_signal_connect_object (_tmp43_, "panels-changed", (GCallback) _budgie_settings_window_on_panels_changed_budgie_desktop_manager_panels_changed, self, G_CONNECT_AFTER);
	budgie_settings_window_on_panels_changed (self);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_SETTINGS_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT, (GClosure*) ((_budgie_settings_window_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_settings_window_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_budgie_settings_window_on_name_acquired_gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_settings_window_on_name_acquired_gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_budgie_settings_window_on_name_lost_gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_settings_window_on_name_lost_gbus_name_lost_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	g_signal_connect_object ((GtkWidget*) self, "unrealize", (GCallback) ___lambda21__gtk_widget_unrealize, self, 0);
	_tmp44_ = self->priv->layout;
	gtk_widget_show_all ((GtkWidget*) _tmp44_);
	_tmp45_ = self->priv->header;
	gtk_widget_show_all ((GtkWidget*) _tmp45_);
	_g_object_unref0 (scroll);
	return self;
}

BudgieSettingsWindow*
budgie_settings_window_new (BudgieDesktopManager* manager)
{
	return budgie_settings_window_construct (BUDGIE_TYPE_SETTINGS_WINDOW, manager);
}

/**
* Static pages that will always be part of the UI
*/
static void
budgie_settings_window_build_content (BudgieSettingsWindow* self)
{
	BudgieStylePage* _tmp0_;
	BudgieStylePage* _tmp1_;
	BudgieDesktopPage* _tmp2_;
	BudgieDesktopPage* _tmp3_;
	BudgieFontPage* _tmp4_;
	BudgieFontPage* _tmp5_;
	BudgieWindowsPage* _tmp6_;
	BudgieWindowsPage* _tmp7_;
	BudgieAutostartPage* _tmp8_;
	BudgieAutostartPage* _tmp9_;
	BudgieRavenPage* _tmp10_;
	BudgieRavenPage* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_style_page_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	budgie_settings_window_add_page (self, (BudgieSettingsPage*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = budgie_desktop_page_new ();
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	budgie_settings_window_add_page (self, (BudgieSettingsPage*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = budgie_font_page_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	budgie_settings_window_add_page (self, (BudgieSettingsPage*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = budgie_windows_page_new ();
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	budgie_settings_window_add_page (self, (BudgieSettingsPage*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = budgie_autostart_page_new ();
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	budgie_settings_window_add_page (self, (BudgieSettingsPage*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = budgie_raven_page_new ();
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	budgie_settings_window_add_page (self, (BudgieSettingsPage*) _tmp11_);
	_g_object_unref0 (_tmp11_);
}

void
budgie_settings_window_requested_close (BudgieSettingsWindow* self,
                                        GError** error)
{
	g_return_if_fail (self != NULL);
	gtk_widget_destroy ((GtkWidget*) self);
	gtk_window_close ((GtkWindow*) self);
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static void
budgie_settings_window_on_bus_acquired (BudgieSettingsWindow* self,
                                        GDBusConnection* c)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	{
		BudgieSettingsIface* _tmp0_;
		GDBusConnection* _tmp1_;
		guint _tmp2_ = 0U;
		GDBusConnection* _tmp3_;
		BudgieSettingsIface* _tmp4_;
		guint _tmp5_;
		guint* _tmp6_;
		_tmp0_ = budgie_settings_iface_new (self);
		_budgie_settings_iface_unref0 (self->priv->iface);
		self->priv->iface = _tmp0_;
		_tmp1_ = _g_object_ref0 (c);
		_g_object_unref0 (self->priv->conn);
		self->priv->conn = _tmp1_;
		_tmp3_ = self->priv->conn;
		_tmp4_ = self->priv->iface;
		_tmp5_ = budgie_settings_iface_register_object (_tmp4_, _tmp3_, BUDGIE_SETTINGS_DBUS_PATH, &_inner_error0_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = __uint_dup0 (&_tmp2_);
		_g_free0 (self->priv->register_id);
		self->priv->register_id = _tmp6_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "Error registering SettingsIface: %s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
budgie_settings_window_on_name_acquired (BudgieSettingsWindow* self,
                                         GDBusConnection* c,
                                         const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (name != NULL);
	g_message ("settings_main.vala:151: Acquired %s DBus connection", name);
}

void
budgie_settings_window_on_name_lost (BudgieSettingsWindow* self,
                                     GDBusConnection* c,
                                     const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (name != NULL);
	g_message ("settings_main.vala:155: Lost or replaced DBus connection");
}

/**
* Update the state of the add-panel button in relation to slots
*/
static gboolean
__lambda20_ (BudgieSettingsWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->sidebar;
	gtk_list_box_invalidate_sort (_tmp0_);
	_tmp1_ = self->priv->sidebar;
	gtk_list_box_invalidate_filter (_tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda20__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda20_ ((BudgieSettingsWindow*) self);
	return result;
}

static void
budgie_settings_window_on_panels_changed (BudgieSettingsWindow* self)
{
	BudgieSettingsItem* _tmp0_;
	BudgieDesktopManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->item_add_panel;
	_tmp1_ = self->priv->_manager;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, budgie_desktop_manager_slots_available (_tmp1_) >= ((guint) 1));
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda20__gsource_func, g_object_ref (self), g_object_unref);
}

/**
* Handle transition between various pages
*/
static void
budgie_settings_window_on_row_activate (BudgieSettingsWindow* self,
                                        GtkListBoxRow* row)
{
	BudgieSettingsItem* item = NULL;
	GtkWidget* _tmp0_;
	BudgieSettingsItem* _tmp1_;
	BudgieSettingsItem* _tmp2_;
	BudgieSettingsItem* _tmp3_;
	BudgieDesktopManager* _tmp8_;
	g_return_if_fail (self != NULL);
	if (row == NULL) {
		return;
	}
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = _g_object_ref0 (BUDGIE_IS_SETTINGS_ITEM (_tmp0_) ? ((BudgieSettingsItem*) _tmp0_) : NULL);
	item = _tmp1_;
	_tmp2_ = item;
	_tmp3_ = self->priv->item_add_panel;
	if (_tmp2_ != _tmp3_) {
		GtkStack* _tmp4_;
		BudgieSettingsItem* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = self->priv->content;
		_tmp5_ = item;
		_tmp6_ = budgie_settings_item_get_content_id (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_stack_set_visible_child_name (_tmp4_, _tmp7_);
		_g_object_unref0 (item);
		return;
	}
	self->priv->new_panel_requested = TRUE;
	_tmp8_ = self->priv->_manager;
	if (budgie_desktop_manager_slots_available (_tmp8_) >= ((guint) 1)) {
		BudgieDesktopManager* _tmp9_;
		_tmp9_ = self->priv->_manager;
		budgie_desktop_manager_create_new_panel (_tmp9_);
	}
	_g_object_unref0 (item);
}

/**
* Add a new page to our sidebar + stack
*/
static void
budgie_settings_window_add_page (BudgieSettingsWindow* self,
                                 BudgieSettingsPage* page)
{
	BudgieSettingsItem* settings_item = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	BudgieSettingsItem* _tmp8_;
	BudgieSettingsItem* _tmp9_;
	GtkListBox* _tmp10_;
	BudgieSettingsItem* _tmp11_;
	BudgieSettingsItem* _tmp12_;
	BudgieSettingsItem* _tmp13_;
	GHashTable* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	BudgieSettingsItem* _tmp18_;
	BudgieSettingsItem* _tmp19_;
	GHashTable* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	BudgieSettingsPage* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	GtkListBox* _tmp38_;
	GtkListBox* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_settings_page_get_group (page);
	_tmp1_ = _tmp0_;
	_tmp2_ = budgie_settings_page_get_content_id (page);
	_tmp3_ = _tmp2_;
	_tmp4_ = budgie_settings_page_get_title (page);
	_tmp5_ = _tmp4_;
	_tmp6_ = budgie_settings_page_get_icon_name (page);
	_tmp7_ = _tmp6_;
	_tmp8_ = budgie_settings_item_new (_tmp1_, _tmp3_, _tmp5_, _tmp7_);
	g_object_ref_sink (_tmp8_);
	settings_item = _tmp8_;
	_tmp9_ = settings_item;
	gtk_widget_show_all ((GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->sidebar;
	_tmp11_ = settings_item;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = settings_item;
	g_object_bind_property_with_closures ((GObject*) page, "title", (GObject*) _tmp12_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp13_ = settings_item;
	g_object_bind_property_with_closures ((GObject*) page, "display-weight", (GObject*) _tmp13_, "display-weight", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp14_ = self->priv->sidebar_map;
	_tmp15_ = budgie_settings_page_get_content_id (page);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup (_tmp16_);
	_tmp18_ = settings_item;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	g_hash_table_insert (_tmp14_, _tmp17_, _tmp19_);
	_tmp20_ = self->priv->page_map;
	_tmp21_ = budgie_settings_page_get_content_id (page);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup (_tmp22_);
	_tmp24_ = _g_object_ref0 (page);
	g_hash_table_insert (_tmp20_, _tmp23_, _tmp24_);
	_tmp25_ = budgie_settings_page_get_want_scroll (page);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		GtkScrolledWindow* scroll = NULL;
		GtkScrolledWindow* _tmp27_;
		GtkScrolledWindow* _tmp28_;
		GtkScrolledWindow* _tmp29_;
		GtkScrolledWindow* _tmp30_;
		GtkStack* _tmp31_;
		GtkScrolledWindow* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp27_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		g_object_ref_sink (_tmp27_);
		scroll = _tmp27_;
		_tmp28_ = scroll;
		gtk_scrolled_window_set_policy (_tmp28_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		_tmp29_ = scroll;
		gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) page);
		_tmp30_ = scroll;
		gtk_widget_show ((GtkWidget*) _tmp30_);
		_tmp31_ = self->priv->content;
		_tmp32_ = scroll;
		_tmp33_ = budgie_settings_page_get_content_id (page);
		_tmp34_ = _tmp33_;
		gtk_stack_add_named (_tmp31_, (GtkWidget*) _tmp32_, _tmp34_);
		_g_object_unref0 (scroll);
	} else {
		GtkStack* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gtk_widget_show ((GtkWidget*) page);
		_tmp35_ = self->priv->content;
		_tmp36_ = budgie_settings_page_get_content_id (page);
		_tmp37_ = _tmp36_;
		gtk_stack_add_named (_tmp35_, (GtkWidget*) page, _tmp37_);
	}
	_tmp38_ = self->priv->sidebar;
	gtk_list_box_invalidate_sort (_tmp38_);
	_tmp39_ = self->priv->sidebar;
	gtk_list_box_invalidate_headers (_tmp39_);
	_g_object_unref0 (settings_item);
}

/**
* Remove a page from the sidebar and content stack
*/
static void
budgie_settings_window_remove_page (BudgieSettingsWindow* self,
                                    const gchar* content_id)
{
	BudgieSettingsPage* page = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgieSettingsPage* _tmp2_;
	BudgieSettingsItem* item = NULL;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_;
	BudgieSettingsItem* _tmp5_;
	BudgieSettingsItem* _tmp6_;
	BudgieSettingsPage* _tmp9_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_id != NULL);
	_tmp0_ = self->priv->page_map;
	_tmp1_ = g_hash_table_lookup (_tmp0_, content_id);
	_tmp2_ = _g_object_ref0 ((BudgieSettingsPage*) _tmp1_);
	page = _tmp2_;
	_tmp3_ = self->priv->sidebar_map;
	_tmp4_ = g_hash_table_lookup (_tmp3_, content_id);
	_tmp5_ = _g_object_ref0 ((BudgieSettingsItem*) _tmp4_);
	item = _tmp5_;
	_tmp6_ = item;
	if (_tmp6_ != NULL) {
		BudgieSettingsItem* _tmp7_;
		GtkContainer* _tmp8_;
		_tmp7_ = item;
		_tmp8_ = gtk_widget_get_parent ((GtkWidget*) _tmp7_);
		gtk_widget_destroy ((GtkWidget*) _tmp8_);
	}
	_tmp9_ = page;
	if (_tmp9_ != NULL) {
		BudgieSettingsPage* _tmp10_;
		_tmp10_ = page;
		gtk_widget_destroy ((GtkWidget*) _tmp10_);
	}
	_tmp11_ = self->priv->sidebar;
	gtk_list_box_invalidate_sort (_tmp11_);
	_tmp12_ = self->priv->sidebar;
	gtk_list_box_invalidate_headers (_tmp12_);
	_g_object_unref0 (item);
	_g_object_unref0 (page);
}

/**
* Provide categorisation for our sidebar items
*/
static void
budgie_settings_window_do_headers (BudgieSettingsWindow* self,
                                   GtkListBoxRow* before,
                                   GtkListBoxRow* after)
{
	BudgieSettingsItem* child = NULL;
	gchar* prev = NULL;
	gchar* next = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	child = NULL;
	prev = NULL;
	next = NULL;
	if (before != NULL) {
		GtkWidget* _tmp0_;
		BudgieSettingsItem* _tmp1_;
		BudgieSettingsItem* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = gtk_bin_get_child ((GtkBin*) before);
		_tmp1_ = _g_object_ref0 (BUDGIE_IS_SETTINGS_ITEM (_tmp0_) ? ((BudgieSettingsItem*) _tmp0_) : NULL);
		_g_object_unref0 (child);
		child = _tmp1_;
		_tmp2_ = child;
		_tmp3_ = budgie_settings_item_get_group (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (prev);
		prev = _tmp5_;
	}
	if (after != NULL) {
		GtkWidget* _tmp6_;
		BudgieSettingsItem* _tmp7_;
		BudgieSettingsItem* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = gtk_bin_get_child ((GtkBin*) after);
		_tmp7_ = _g_object_ref0 (BUDGIE_IS_SETTINGS_ITEM (_tmp6_) ? ((BudgieSettingsItem*) _tmp6_) : NULL);
		_g_object_unref0 (child);
		child = _tmp7_;
		_tmp8_ = child;
		_tmp9_ = budgie_settings_item_get_group (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (next);
		next = _tmp11_;
	}
	if (after == NULL) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = prev;
		_tmp14_ = next;
		_tmp12_ = g_strcmp0 (_tmp13_, _tmp14_) != 0;
	}
	if (_tmp12_) {
		gchar* title = NULL;
		GHashTable* _tmp15_;
		const gchar* _tmp16_;
		gconstpointer _tmp17_;
		gchar* _tmp18_;
		GtkLabel* label = NULL;
		const gchar* _tmp19_;
		GtkLabel* _tmp20_;
		GtkLabel* _tmp21_;
		GtkStyleContext* _tmp22_;
		GtkLabel* _tmp23_;
		GtkLabel* _tmp24_;
		GtkLabel* _tmp25_;
		GtkLabel* _tmp26_;
		GtkLabel* _tmp27_;
		GtkLabel* _tmp28_;
		_tmp15_ = self->priv->group_map;
		_tmp16_ = prev;
		_tmp17_ = g_hash_table_lookup (_tmp15_, _tmp16_);
		_tmp18_ = g_strdup ((const gchar*) _tmp17_);
		title = _tmp18_;
		_tmp19_ = title;
		_tmp20_ = (GtkLabel*) gtk_label_new (_tmp19_);
		g_object_ref_sink (_tmp20_);
		label = _tmp20_;
		_tmp21_ = label;
		_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
		gtk_style_context_add_class (_tmp22_, GTK_STYLE_CLASS_DIM_LABEL);
		_tmp23_ = label;
		gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_START);
		_tmp24_ = label;
		gtk_label_set_use_markup (_tmp24_, TRUE);
		_tmp25_ = label;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp25_, 8);
		_tmp26_ = label;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp26_, 8);
		_tmp27_ = label;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp27_, 12);
		_tmp28_ = label;
		gtk_list_box_row_set_header (before, (GtkWidget*) _tmp28_);
		_g_object_unref0 (label);
		_g_free0 (title);
	} else {
		gtk_list_box_row_set_header (before, NULL);
	}
	_g_free0 (next);
	_g_free0 (prev);
	_g_object_unref0 (child);
}

/**
* Sort the sidebar items, enforcing clustering of the same groups
*/
static gint
budgie_settings_window_do_sort (BudgieSettingsWindow* self,
                                GtkListBoxRow* before,
                                GtkListBoxRow* after)
{
	BudgieSettingsItem* child_before = NULL;
	BudgieSettingsItem* child_after = NULL;
	GtkWidget* _tmp0_;
	BudgieSettingsItem* _tmp1_;
	GtkWidget* _tmp2_;
	BudgieSettingsItem* _tmp3_;
	BudgieSettingsItem* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	BudgieSettingsItem* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	BudgieSettingsItem* _tmp17_;
	BudgieSettingsItem* _tmp18_;
	BudgieSettingsItem* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	BudgieSettingsItem* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	child_before = NULL;
	child_after = NULL;
	_tmp0_ = gtk_bin_get_child ((GtkBin*) before);
	_tmp1_ = _g_object_ref0 (BUDGIE_IS_SETTINGS_ITEM (_tmp0_) ? ((BudgieSettingsItem*) _tmp0_) : NULL);
	_g_object_unref0 (child_before);
	child_before = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) after);
	_tmp3_ = _g_object_ref0 (BUDGIE_IS_SETTINGS_ITEM (_tmp2_) ? ((BudgieSettingsItem*) _tmp2_) : NULL);
	_g_object_unref0 (child_after);
	child_after = _tmp3_;
	_tmp4_ = child_before;
	_tmp5_ = budgie_settings_item_get_group (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = child_after;
	_tmp8_ = budgie_settings_item_get_group (_tmp7_);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp6_, _tmp9_) != 0) {
		GCompareFunc _tmp10_;
		BudgieSettingsItem* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		BudgieSettingsItem* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp10_ = ((GCompareFunc) g_strcmp0);
		_tmp11_ = child_before;
		_tmp12_ = budgie_settings_item_get_group (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = child_after;
		_tmp15_ = budgie_settings_item_get_group (_tmp14_);
		_tmp16_ = _tmp15_;
		result = _tmp10_ (_tmp13_, _tmp16_);
		_g_object_unref0 (child_after);
		_g_object_unref0 (child_before);
		return result;
	}
	_tmp17_ = child_after;
	_tmp18_ = self->priv->item_add_panel;
	if (_tmp17_ == _tmp18_) {
		result = -1;
		_g_object_unref0 (child_after);
		_g_object_unref0 (child_before);
		return result;
	} else {
		BudgieSettingsItem* _tmp19_;
		BudgieSettingsItem* _tmp20_;
		_tmp19_ = child_before;
		_tmp20_ = self->priv->item_add_panel;
		if (_tmp19_ == _tmp20_) {
			result = 1;
			_g_object_unref0 (child_after);
			_g_object_unref0 (child_before);
			return result;
		}
	}
	_tmp21_ = child_before;
	_tmp22_ = budgie_settings_item_get_display_weight (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = child_after;
	_tmp25_ = budgie_settings_item_get_display_weight (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp23_ > _tmp26_) {
		result = 1;
		_g_object_unref0 (child_after);
		_g_object_unref0 (child_before);
		return result;
	} else {
		BudgieSettingsItem* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		BudgieSettingsItem* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp27_ = child_before;
		_tmp28_ = budgie_settings_item_get_display_weight (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = child_after;
		_tmp31_ = budgie_settings_item_get_display_weight (_tmp30_);
		_tmp32_ = _tmp31_;
		if (_tmp29_ < _tmp32_) {
			result = -1;
			_g_object_unref0 (child_after);
			_g_object_unref0 (child_before);
			return result;
		}
	}
	result = 0;
	_g_object_unref0 (child_after);
	_g_object_unref0 (child_before);
	return result;
}

/**
* Emulate sidebar activation for the user
*/
static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BudgieSettingsWindow* self;
		self = _data5_->self;
		_g_free0 (_data5_->content_id);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda19_ (Block5Data* _data5_)
{
	BudgieSettingsWindow* self;
	GtkListBoxRow* row = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GtkContainer* _tmp2_;
	GtkListBoxRow* _tmp3_;
	GtkListBox* _tmp4_;
	GtkStack* _tmp5_;
	gboolean result;
	self = _data5_->self;
	_tmp0_ = self->priv->sidebar_map;
	_tmp1_ = g_hash_table_lookup (_tmp0_, _data5_->content_id);
	_tmp2_ = gtk_widget_get_parent ((GtkWidget*) ((BudgieSettingsItem*) _tmp1_));
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp2_) : NULL);
	row = _tmp3_;
	_tmp4_ = self->priv->sidebar;
	gtk_list_box_select_row (_tmp4_, row);
	gtk_widget_grab_focus ((GtkWidget*) row);
	_tmp5_ = self->priv->content;
	gtk_stack_set_visible_child_name (_tmp5_, _data5_->content_id);
	result = FALSE;
	_g_object_unref0 (row);
	return result;
}

static gboolean
___lambda19__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda19_ (self);
	return result;
}

static void
budgie_settings_window_force_select_page (BudgieSettingsWindow* self,
                                          const gchar* content_id)
{
	Block5Data* _data5_;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_id != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_strdup (content_id);
	_g_free0 (_data5_->content_id);
	_data5_->content_id = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda19__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

/**
* New panel added, let's make a page for it
*/
static void
budgie_settings_window_on_panel_added (BudgieSettingsWindow* self,
                                       const gchar* uuid,
                                       BudgieToplevel* toplevel)
{
	gchar* content_id = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	BudgieDesktopManager* _tmp3_;
	BudgiePanelPage* _tmp4_;
	BudgiePanelPage* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = g_strconcat ("panel-", uuid, NULL);
	content_id = _tmp0_;
	_tmp1_ = self->priv->page_map;
	_tmp2_ = content_id;
	if (g_hash_table_contains (_tmp1_, _tmp2_)) {
		_g_free0 (content_id);
		return;
	}
	_tmp3_ = self->priv->_manager;
	_tmp4_ = budgie_panel_page_new (_tmp3_, toplevel);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	budgie_settings_window_add_page (self, (BudgieSettingsPage*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	if (self->priv->new_panel_requested) {
		const gchar* _tmp6_;
		_tmp6_ = content_id;
		budgie_settings_window_force_select_page (self, _tmp6_);
	}
	_g_free0 (content_id);
}

/**
* A panel was destroyed, remove our knowledge of it
*/
static void
budgie_settings_window_on_panel_deleted (BudgieSettingsWindow* self,
                                         const gchar* uuid)
{
	gchar* content_id = NULL;
	gchar* _tmp0_;
	GtkStack* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = g_strconcat ("panel-", uuid, NULL);
	content_id = _tmp0_;
	_tmp1_ = self->priv->content;
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
	_tmp3_ = content_id;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		budgie_settings_window_force_select_page (self, "style");
	}
	_tmp4_ = g_strconcat ("panel-", uuid, NULL);
	_tmp5_ = _tmp4_;
	budgie_settings_window_remove_page (self, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (content_id);
}

BudgieDesktopManager*
budgie_settings_window_get_manager (BudgieSettingsWindow* self)
{
	BudgieDesktopManager* result;
	BudgieDesktopManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manager;
	result = _tmp0_;
	return result;
}

void
budgie_settings_window_set_manager (BudgieSettingsWindow* self,
                                    BudgieDesktopManager* value)
{
	BudgieDesktopManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_window_get_manager (self);
	if (old_value != value) {
		BudgieDesktopManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_manager);
		self->priv->_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_window_properties[BUDGIE_SETTINGS_WINDOW_MANAGER_PROPERTY]);
	}
}

static void
budgie_settings_window_class_init (BudgieSettingsWindowClass * klass,
                                   gpointer klass_data)
{
	budgie_settings_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieSettingsWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_settings_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_settings_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_settings_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_WINDOW_MANAGER_PROPERTY, budgie_settings_window_properties[BUDGIE_SETTINGS_WINDOW_MANAGER_PROPERTY] = g_param_spec_object ("manager", "manager", "manager", BUDGIE_TYPE_DESKTOP_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
budgie_settings_window_instance_init (BudgieSettingsWindow * self,
                                      gpointer klass)
{
	self->priv = budgie_settings_window_get_instance_private (self);
	self->priv->new_panel_requested = FALSE;
}

static void
budgie_settings_window_finalize (GObject * obj)
{
	BudgieSettingsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SETTINGS_WINDOW, BudgieSettingsWindow);
	_budgie_settings_iface_unref0 (self->priv->iface);
	_g_object_unref0 (self->priv->conn);
	_g_free0 (self->priv->register_id);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->sidebar);
	_g_object_unref0 (self->priv->content);
	_g_object_unref0 (self->priv->layout);
	_g_hash_table_unref0 (self->priv->group_map);
	_g_hash_table_unref0 (self->priv->page_map);
	_g_hash_table_unref0 (self->priv->sidebar_map);
	_g_object_unref0 (self->priv->_manager);
	_g_object_unref0 (self->priv->item_add_panel);
	G_OBJECT_CLASS (budgie_settings_window_parent_class)->finalize (obj);
}

static GType
budgie_settings_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSettingsWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_settings_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSettingsWindow), 0, (GInstanceInitFunc) budgie_settings_window_instance_init, NULL };
	GType budgie_settings_window_type_id;
	budgie_settings_window_type_id = g_type_register_static (gtk_window_get_type (), "BudgieSettingsWindow", &g_define_type_info, 0);
	BudgieSettingsWindow_private_offset = g_type_add_instance_private (budgie_settings_window_type_id, sizeof (BudgieSettingsWindowPrivate));
	return budgie_settings_window_type_id;
}

GType
budgie_settings_window_get_type (void)
{
	static volatile gsize budgie_settings_window_type_id__once = 0;
	if (g_once_init_enter (&budgie_settings_window_type_id__once)) {
		GType budgie_settings_window_type_id;
		budgie_settings_window_type_id = budgie_settings_window_get_type_once ();
		g_once_init_leave (&budgie_settings_window_type_id__once, budgie_settings_window_type_id);
	}
	return budgie_settings_window_type_id__once;
}

static void
_vala_budgie_settings_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	BudgieSettingsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SETTINGS_WINDOW, BudgieSettingsWindow);
	switch (property_id) {
		case BUDGIE_SETTINGS_WINDOW_MANAGER_PROPERTY:
		g_value_set_object (value, budgie_settings_window_get_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_settings_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	BudgieSettingsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SETTINGS_WINDOW, BudgieSettingsWindow);
	switch (property_id) {
		case BUDGIE_SETTINGS_WINDOW_MANAGER_PROPERTY:
		budgie_settings_window_set_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

