/* settings_raven.c generated by valac 0.56.3, the Vala compiler
 * generated from settings_raven.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "raven.h"
#include <glib/gi18n-lib.h>

#define BUDGIE_SETTINGS_GROUP_APPEARANCE "appearance"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SETTINGS_PAGE (budgie_settings_page_get_type ())
#define BUDGIE_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage))
#define BUDGIE_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))
#define BUDGIE_IS_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_IS_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_SETTINGS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))

typedef struct _BudgieSettingsPage BudgieSettingsPage;
typedef struct _BudgieSettingsPageClass BudgieSettingsPageClass;
typedef struct _BudgieSettingsPagePrivate BudgieSettingsPagePrivate;

#define BUDGIE_TYPE_RAVEN_PAGE (budgie_raven_page_get_type ())
#define BUDGIE_RAVEN_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_PAGE, BudgieRavenPage))
#define BUDGIE_RAVEN_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN_PAGE, BudgieRavenPageClass))
#define BUDGIE_IS_RAVEN_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_PAGE))
#define BUDGIE_IS_RAVEN_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN_PAGE))
#define BUDGIE_RAVEN_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN_PAGE, BudgieRavenPageClass))

typedef struct _BudgieRavenPage BudgieRavenPage;
typedef struct _BudgieRavenPageClass BudgieRavenPageClass;
typedef struct _BudgieRavenPagePrivate BudgieRavenPagePrivate;
enum  {
	BUDGIE_RAVEN_PAGE_0_PROPERTY,
	BUDGIE_RAVEN_PAGE_NUM_PROPERTIES
};
static GParamSpec* budgie_raven_page_properties[BUDGIE_RAVEN_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_SETTINGS_GRID (budgie_settings_grid_get_type ())
#define BUDGIE_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGrid))
#define BUDGIE_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))
#define BUDGIE_IS_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_IS_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_SETTINGS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))

typedef struct _BudgieSettingsGrid BudgieSettingsGrid;
typedef struct _BudgieSettingsGridClass BudgieSettingsGridClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_SETTINGS_ROW (budgie_settings_row_get_type ())
#define BUDGIE_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow))
#define BUDGIE_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))
#define BUDGIE_IS_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_IS_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_SETTINGS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))

typedef struct _BudgieSettingsRow BudgieSettingsRow;
typedef struct _BudgieSettingsRowClass BudgieSettingsRowClass;

struct _BudgieSettingsPage {
	GtkBox parent_instance;
	BudgieSettingsPagePrivate * priv;
};

struct _BudgieSettingsPageClass {
	GtkBoxClass parent_class;
};

struct _BudgieRavenPage {
	BudgieSettingsPage parent_instance;
	BudgieRavenPagePrivate * priv;
};

struct _BudgieRavenPageClass {
	BudgieSettingsPageClass parent_class;
};

struct _BudgieRavenPagePrivate {
	GtkComboBox* raven_position;
	GtkSwitch* enable_week_numbers;
	GtkSwitch* show_calendar_widget;
	GtkSwitch* show_sound_output_widget;
	GtkSwitch* show_mic_input_widget;
	GtkSwitch* show_mpris_widget;
	GtkSwitch* show_powerstrip;
	GSettings* raven_settings;
};

static gint BudgieRavenPage_private_offset;
static gpointer budgie_raven_page_parent_class = NULL;

VALA_EXTERN GType budgie_settings_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPage, g_object_unref)
VALA_EXTERN GType budgie_raven_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRavenPage, g_object_unref)
VALA_EXTERN BudgieRavenPage* budgie_raven_page_new (void);
VALA_EXTERN BudgieRavenPage* budgie_raven_page_construct (GType object_type);
VALA_EXTERN GType budgie_settings_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsGrid, g_object_unref)
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_new (void);
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_construct (GType object_type);
VALA_EXTERN GType budgie_settings_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsRow, g_object_unref)
VALA_EXTERN void budgie_settings_grid_add_row (BudgieSettingsGrid* self,
                                   BudgieSettingsRow* row);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_new (GtkWidget* widget,
                                            const gchar* label,
                                            const gchar* description);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_construct (GType object_type,
                                                  GtkWidget* widget,
                                                  const gchar* label,
                                                  const gchar* description);
static void budgie_raven_page_finalize (GObject * obj);
static GType budgie_raven_page_get_type_once (void);

static inline gpointer
budgie_raven_page_get_instance_private (BudgieRavenPage* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRavenPage_private_offset);
}

BudgieRavenPage*
budgie_raven_page_construct (GType object_type)
{
	BudgieRavenPage * self = NULL;
	BudgieSettingsGrid* grid = NULL;
	BudgieSettingsGrid* _tmp0_;
	BudgieSettingsGrid* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkCellRendererText* render = NULL;
	GtkCellRendererText* _tmp3_;
	GtkListStore* model = NULL;
	GtkListStore* _tmp4_;
	GtkTreeIter iter = {0};
	static const BudgieRavenPosition positions[3] = {BUDGIE_RAVEN_POSITION_AUTOMATIC, BUDGIE_RAVEN_POSITION_LEFT, BUDGIE_RAVEN_POSITION_RIGHT};
	GtkComboBox* _tmp12_;
	GtkListStore* _tmp13_;
	GtkComboBox* _tmp14_;
	GtkCellRendererText* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkCellRendererText* _tmp17_;
	GtkComboBox* _tmp18_;
	BudgieSettingsGrid* _tmp19_;
	GtkComboBox* _tmp20_;
	BudgieSettingsRow* _tmp21_;
	BudgieSettingsRow* _tmp22_;
	GtkSwitch* _tmp23_;
	BudgieSettingsGrid* _tmp24_;
	GtkSwitch* _tmp25_;
	BudgieSettingsRow* _tmp26_;
	BudgieSettingsRow* _tmp27_;
	GtkSwitch* _tmp28_;
	BudgieSettingsGrid* _tmp29_;
	GtkSwitch* _tmp30_;
	BudgieSettingsRow* _tmp31_;
	BudgieSettingsRow* _tmp32_;
	GtkSwitch* _tmp33_;
	BudgieSettingsGrid* _tmp34_;
	GtkSwitch* _tmp35_;
	BudgieSettingsRow* _tmp36_;
	BudgieSettingsRow* _tmp37_;
	GtkSwitch* _tmp38_;
	BudgieSettingsGrid* _tmp39_;
	GtkSwitch* _tmp40_;
	BudgieSettingsRow* _tmp41_;
	BudgieSettingsRow* _tmp42_;
	GtkSwitch* _tmp43_;
	BudgieSettingsGrid* _tmp44_;
	GtkSwitch* _tmp45_;
	BudgieSettingsRow* _tmp46_;
	BudgieSettingsRow* _tmp47_;
	GtkSwitch* _tmp48_;
	BudgieSettingsGrid* _tmp49_;
	GtkSwitch* _tmp50_;
	BudgieSettingsRow* _tmp51_;
	BudgieSettingsRow* _tmp52_;
	GSettings* _tmp53_;
	GSettings* _tmp54_;
	GtkComboBox* _tmp55_;
	GSettings* _tmp56_;
	GtkSwitch* _tmp57_;
	GSettings* _tmp58_;
	GtkSwitch* _tmp59_;
	GSettings* _tmp60_;
	GtkSwitch* _tmp61_;
	GSettings* _tmp62_;
	GtkSwitch* _tmp63_;
	GSettings* _tmp64_;
	GtkSwitch* _tmp65_;
	GSettings* _tmp66_;
	GtkSwitch* _tmp67_;
	self = (BudgieRavenPage*) g_object_new (object_type, "group", BUDGIE_SETTINGS_GROUP_APPEARANCE, "content-id", "raven", "title", "Raven", "display-weight", 3, "icon-name", "preferences-calendar-and-tasks", NULL);
	_tmp0_ = budgie_settings_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	_tmp1_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->raven_position);
	self->priv->raven_position = _tmp2_;
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp3_);
	render = _tmp3_;
	_tmp4_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, BUDGIE_TYPE_RAVEN_POSITION, -1);
	model = _tmp4_;
	{
		BudgieRavenPosition* pos_collection = NULL;
		gint pos_collection_length1 = 0;
		gint _pos_collection_size_ = 0;
		gint pos_it = 0;
		pos_collection = positions;
		pos_collection_length1 = G_N_ELEMENTS (positions);
		for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
			BudgieRavenPosition pos = 0;
			pos = pos_collection[pos_it];
			{
				GtkListStore* _tmp5_;
				GtkTreeIter _tmp6_ = {0};
				GtkListStore* _tmp7_;
				GtkTreeIter _tmp8_;
				GEnumValue* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp5_ = model;
				gtk_list_store_append (_tmp5_, &_tmp6_);
				iter = _tmp6_;
				_tmp7_ = model;
				_tmp8_ = iter;
				_tmp9_ = g_enum_get_value (g_type_class_ref (BUDGIE_TYPE_RAVEN_POSITION), pos);
				_tmp10_ = budgie_raven_position_get_display_name (pos);
				_tmp11_ = _tmp10_;
				gtk_list_store_set (_tmp7_, &_tmp8_, 0, (_tmp9_ != NULL) ? _tmp9_->value_name : NULL, 1, _tmp11_, 2, pos, -1, -1);
				_g_free0 (_tmp11_);
			}
		}
	}
	_tmp12_ = self->priv->raven_position;
	_tmp13_ = model;
	gtk_combo_box_set_model (_tmp12_, (GtkTreeModel*) _tmp13_);
	_tmp14_ = self->priv->raven_position;
	_tmp15_ = render;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp14_, (GtkCellRenderer*) _tmp15_, TRUE);
	_tmp16_ = self->priv->raven_position;
	_tmp17_ = render;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp16_, (GtkCellRenderer*) _tmp17_, "text", 1);
	_tmp18_ = self->priv->raven_position;
	gtk_combo_box_set_id_column (_tmp18_, 0);
	_tmp19_ = grid;
	_tmp20_ = self->priv->raven_position;
	_tmp21_ = budgie_settings_row_new ((GtkWidget*) _tmp20_, _ ("Set Raven position"), _ ("Set which side of the screen Raven will open on. If set to Automatic, " \
"Raven will open where its parent panel is."));
	_tmp22_ = _tmp21_;
	budgie_settings_grid_add_row (_tmp19_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->enable_week_numbers);
	self->priv->enable_week_numbers = _tmp23_;
	_tmp24_ = grid;
	_tmp25_ = self->priv->enable_week_numbers;
	_tmp26_ = budgie_settings_row_new ((GtkWidget*) _tmp25_, _ ("Enable display of week numbers in Calendar"), _ ("This setting enables the display of week numbers in the Calendar widge" \
"t."));
	_tmp27_ = _tmp26_;
	budgie_settings_grid_add_row (_tmp24_, _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->show_calendar_widget);
	self->priv->show_calendar_widget = _tmp28_;
	_tmp29_ = grid;
	_tmp30_ = self->priv->show_calendar_widget;
	_tmp31_ = budgie_settings_row_new ((GtkWidget*) _tmp30_, _ ("Show Calendar Widget"), _ ("Shows or hides the Calendar Widget in Raven's Applets section."));
	_tmp32_ = _tmp31_;
	budgie_settings_grid_add_row (_tmp29_, _tmp32_);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->show_sound_output_widget);
	self->priv->show_sound_output_widget = _tmp33_;
	_tmp34_ = grid;
	_tmp35_ = self->priv->show_sound_output_widget;
	_tmp36_ = budgie_settings_row_new ((GtkWidget*) _tmp35_, _ ("Show Sound Output Widget"), _ ("Shows or hides the Sound Output Widget in Raven's Applets section."));
	_tmp37_ = _tmp36_;
	budgie_settings_grid_add_row (_tmp34_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->show_mic_input_widget);
	self->priv->show_mic_input_widget = _tmp38_;
	_tmp39_ = grid;
	_tmp40_ = self->priv->show_mic_input_widget;
	_tmp41_ = budgie_settings_row_new ((GtkWidget*) _tmp40_, _ ("Show Microphone Input Widget"), _ ("Shows or hides the Microphone Input Widget in Raven's Applets section."));
	_tmp42_ = _tmp41_;
	budgie_settings_grid_add_row (_tmp39_, _tmp42_);
	_g_object_unref0 (_tmp42_);
	_tmp43_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->show_mpris_widget);
	self->priv->show_mpris_widget = _tmp43_;
	_tmp44_ = grid;
	_tmp45_ = self->priv->show_mpris_widget;
	_tmp46_ = budgie_settings_row_new ((GtkWidget*) _tmp45_, _ ("Show Media Playback Controls Widget"), _ ("Shows or hides the Media Playback Controls (MPRIS) Widget in Raven's A" \
"pplets section."));
	_tmp47_ = _tmp46_;
	budgie_settings_grid_add_row (_tmp44_, _tmp47_);
	_g_object_unref0 (_tmp47_);
	_tmp48_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->show_powerstrip);
	self->priv->show_powerstrip = _tmp48_;
	_tmp49_ = grid;
	_tmp50_ = self->priv->show_powerstrip;
	_tmp51_ = budgie_settings_row_new ((GtkWidget*) _tmp50_, _ ("Show Power Strip"), _ ("Shows or hides the Power Strip in the bottom of Raven."));
	_tmp52_ = _tmp51_;
	budgie_settings_grid_add_row (_tmp49_, _tmp52_);
	_g_object_unref0 (_tmp52_);
	_tmp53_ = g_settings_new ("com.solus-project.budgie-raven");
	_g_object_unref0 (self->priv->raven_settings);
	self->priv->raven_settings = _tmp53_;
	_tmp54_ = self->priv->raven_settings;
	_tmp55_ = self->priv->raven_position;
	g_settings_bind (_tmp54_, "raven-position", (GObject*) _tmp55_, "active-id", G_SETTINGS_BIND_DEFAULT);
	_tmp56_ = self->priv->raven_settings;
	_tmp57_ = self->priv->enable_week_numbers;
	g_settings_bind (_tmp56_, "enable-week-numbers", (GObject*) _tmp57_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp58_ = self->priv->raven_settings;
	_tmp59_ = self->priv->show_calendar_widget;
	g_settings_bind (_tmp58_, "show-calendar-widget", (GObject*) _tmp59_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp60_ = self->priv->raven_settings;
	_tmp61_ = self->priv->show_sound_output_widget;
	g_settings_bind (_tmp60_, "show-sound-output-widget", (GObject*) _tmp61_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp62_ = self->priv->raven_settings;
	_tmp63_ = self->priv->show_mic_input_widget;
	g_settings_bind (_tmp62_, "show-mic-input-widget", (GObject*) _tmp63_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp64_ = self->priv->raven_settings;
	_tmp65_ = self->priv->show_mpris_widget;
	g_settings_bind (_tmp64_, "show-mpris-widget", (GObject*) _tmp65_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp66_ = self->priv->raven_settings;
	_tmp67_ = self->priv->show_powerstrip;
	g_settings_bind (_tmp66_, "show-power-strip", (GObject*) _tmp67_, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (model);
	_g_object_unref0 (render);
	_g_object_unref0 (grid);
	return self;
}

BudgieRavenPage*
budgie_raven_page_new (void)
{
	return budgie_raven_page_construct (BUDGIE_TYPE_RAVEN_PAGE);
}

static void
budgie_raven_page_class_init (BudgieRavenPageClass * klass,
                              gpointer klass_data)
{
	budgie_raven_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieRavenPage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_raven_page_finalize;
}

static void
budgie_raven_page_instance_init (BudgieRavenPage * self,
                                 gpointer klass)
{
	self->priv = budgie_raven_page_get_instance_private (self);
}

static void
budgie_raven_page_finalize (GObject * obj)
{
	BudgieRavenPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RAVEN_PAGE, BudgieRavenPage);
	_g_object_unref0 (self->priv->raven_position);
	_g_object_unref0 (self->priv->enable_week_numbers);
	_g_object_unref0 (self->priv->show_calendar_widget);
	_g_object_unref0 (self->priv->show_sound_output_widget);
	_g_object_unref0 (self->priv->show_mic_input_widget);
	_g_object_unref0 (self->priv->show_mpris_widget);
	_g_object_unref0 (self->priv->show_powerstrip);
	_g_object_unref0 (self->priv->raven_settings);
	G_OBJECT_CLASS (budgie_raven_page_parent_class)->finalize (obj);
}

/**
* RavenPage shows options for configuring Raven
*/
static GType
budgie_raven_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRavenPage), 0, (GInstanceInitFunc) budgie_raven_page_instance_init, NULL };
	GType budgie_raven_page_type_id;
	budgie_raven_page_type_id = g_type_register_static (BUDGIE_TYPE_SETTINGS_PAGE, "BudgieRavenPage", &g_define_type_info, 0);
	BudgieRavenPage_private_offset = g_type_add_instance_private (budgie_raven_page_type_id, sizeof (BudgieRavenPagePrivate));
	return budgie_raven_page_type_id;
}

GType
budgie_raven_page_get_type (void)
{
	static volatile gsize budgie_raven_page_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_page_type_id__once)) {
		GType budgie_raven_page_type_id;
		budgie_raven_page_type_id = budgie_raven_page_get_type_once ();
		g_once_init_leave (&budgie_raven_page_type_id__once, budgie_raven_page_type_id);
	}
	return budgie_raven_page_type_id__once;
}

