/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.project.api.Project;
import org.gephi.project.impl.ProjectInformationImpl;
import org.gephi.project.impl.ProjectMetaDataImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ProjectImpl
implements Project,
Lookup.Provider,
Serializable {
    private final AtomicInteger workspaceIds;
    private final transient InstanceContent instanceContent = new InstanceContent();
    private final transient AbstractLookup lookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);

    public ProjectImpl(int id) {
        this(NbBundle.getMessage(ProjectImpl.class, (String)"Project.default.prefix") + " " + id);
    }

    public ProjectImpl(String name) {
        this.workspaceIds = new AtomicInteger(1);
        ProjectMetaDataImpl metaDataImpl = new ProjectMetaDataImpl();
        this.instanceContent.add((Object)metaDataImpl);
        ProjectInformationImpl projectInformationImpl = new ProjectInformationImpl(this, name);
        this.instanceContent.add((Object)projectInformationImpl);
        WorkspaceProviderImpl workspaceProviderImpl = new WorkspaceProviderImpl(this);
        this.instanceContent.add((Object)workspaceProviderImpl);
    }

    @Override
    public void add(Object instance) {
        this.instanceContent.add(instance);
    }

    @Override
    public void remove(Object instance) {
        this.instanceContent.remove(instance);
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    public String getName() {
        return ((ProjectInformationImpl)this.lookup.lookup(ProjectInformationImpl.class)).getName();
    }

    public int nextWorkspaceId() {
        return this.workspaceIds.getAndIncrement();
    }

    public int getWorkspaceIds() {
        return this.workspaceIds.get();
    }

    public void setWorkspaceIds(int ids) {
        this.workspaceIds.set(ids);
    }
}

