/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import org.gephi.ui.utils.UIUtils;

public class SnippetPanel
extends JPanel
implements MouseListener,
KeyListener,
FocusListener {
    private static Color lineColor;
    private static Color backgroundColor;
    private static Color focusedBackgroundColor;
    private JComponent content;
    private String snippetName;
    private final Title title;
    private boolean collapsed = false;

    public SnippetPanel(String snippetName, JComponent content) {
        this.snippetName = snippetName;
        this.content = content;
        this.setLayout(new BorderLayout());
        this.title = new Title(snippetName){

            @Override
            public AccessibleContext getAccessibleContext() {
                return SnippetPanel.this.getAccessibleContext();
            }
        };
        this.title.setFocusable(true);
        this.title.addKeyListener(this);
        this.title.addMouseListener(this);
        this.title.addFocusListener(this);
        this.title.setToolTipText(content.getToolTipText());
        content.setToolTipText(null);
        this.add((Component)this.title, "North");
        this.add((Component)content, "Center");
        this.getAccessibleContext().setAccessibleName(snippetName);
    }

    private static void initColors() {
        boolean inverseColors;
        Color systemBackgroundColor = UIUtils.getProfilerResultsBackground();
        int backgroundRed = systemBackgroundColor.getRed();
        int backgroundGreen = systemBackgroundColor.getGreen();
        int backgroundBlue = systemBackgroundColor.getBlue();
        boolean bl = inverseColors = backgroundRed < 41 || backgroundGreen < 32 || backgroundBlue < 25;
        if (inverseColors) {
            lineColor = UIUtils.getSafeColor((int)(backgroundRed + 41), (int)(backgroundGreen + 32), (int)(backgroundBlue + 8));
            backgroundColor = UIUtils.getSafeColor((int)(backgroundRed + 7), (int)(backgroundGreen + 7), (int)(backgroundBlue + 7));
            focusedBackgroundColor = UIUtils.getSafeColor((int)(backgroundRed + 25), (int)(backgroundGreen + 25), (int)(backgroundBlue + 25));
        } else {
            lineColor = UIUtils.getSafeColor((int)(backgroundRed - 41), (int)(backgroundGreen - 32), (int)(backgroundBlue - 8));
            backgroundColor = UIUtils.getSafeColor((int)(backgroundRed - 7), (int)(backgroundGreen - 7), (int)(backgroundBlue - 7));
            focusedBackgroundColor = UIUtils.getSafeColor((int)(backgroundRed - 25), (int)(backgroundGreen - 25), (int)(backgroundBlue - 25));
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.collapsed = collapsed;
        if (collapsed) {
            this.title.collapse();
        } else {
            this.title.expand();
        }
        this.content.setVisible(!collapsed);
        this.revalidate();
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setContent(JComponent content) {
        this.content = content;
    }

    public String getSnippetName() {
        return this.snippetName;
    }

    public void setSnippetName(String snippetName) {
        this.snippetName = snippetName;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.title.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.title.repaint();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 32) {
            this.setCollapsed(!this.isCollapsed());
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.title.setCursor(Cursor.getPredefinedCursor(12));
        this.title.setRollOver(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.title.setCursor(Cursor.getPredefinedCursor(0));
        this.title.setRollOver(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setCollapsed(!this.collapsed);
        this.requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void requestFocus() {
        if (this.title != null) {
            this.title.requestFocus();
        }
    }

    static {
        SnippetPanel.initColors();
    }

    private static class TitleUI
    extends ComponentUI {
        private final int TITLE_X_OFFSET = 5;
        private final int TITLE_Y_OFFSET = 2;
        private final ImageIcon collapsedIcon = new ImageIcon(TitleUI.class.getResource("resources/collapsedSnippet.png"));
        private final ImageIcon expandedIcon = new ImageIcon(TitleUI.class.getResource("resources/expandedSnippet.png"));
        private final JLabel plainPainter = new JLabel();
        private final JLabel boldPainter = new JLabel();
        private final Font plainFont = this.plainPainter.getFont().deriveFont(0);
        private final Font boldFont = this.boldPainter.getFont().deriveFont(1);
        private Dimension preferredSize;

        private TitleUI() {
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            return this.preferredSize;
        }

        @Override
        public void installUI(JComponent c) {
            this.plainPainter.setText(((Title)c).name);
            this.plainPainter.setIcon(this.collapsedIcon);
            this.plainPainter.setFont(this.plainFont);
            this.plainPainter.setIconTextGap(5);
            this.boldPainter.setText(((Title)c).name);
            this.boldPainter.setIcon(this.expandedIcon);
            this.boldPainter.setFont(this.boldFont);
            this.boldPainter.setIconTextGap(5);
            this.plainPainter.setSize(this.plainPainter.getPreferredSize());
            Dimension titlePreferredSize = this.boldPainter.getPreferredSize();
            this.boldPainter.setSize(titlePreferredSize);
            this.preferredSize = new Dimension(5 + titlePreferredSize.width, titlePreferredSize.height + 4);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Title title = (Title)c;
            g.setColor(lineColor);
            g.drawLine(0, 0, c.getWidth(), 0);
            if (title.collapsed) {
                if (title.rollOver || title.isFocusOwner()) {
                    g.setColor(focusedBackgroundColor);
                } else {
                    g.setColor(backgroundColor);
                }
            }
            g.drawLine(0, 1 + this.plainPainter.getHeight() + 2, c.getWidth(), 1 + this.plainPainter.getHeight() + 2);
            if (title.rollOver || title.isFocusOwner()) {
                g.setColor(focusedBackgroundColor);
            } else {
                g.setColor(backgroundColor);
            }
            g.fillRect(0, 1, c.getWidth(), this.plainPainter.getHeight() + 2);
            g.translate(5, 2);
            if (title.collapsed) {
                this.plainPainter.paint(g);
            } else {
                this.boldPainter.paint(g);
            }
            g.translate(-5, -2);
        }
    }

    private static class Title
    extends JComponent
    implements Accessible {
        String name;
        private boolean collapsed;
        private boolean rollOver;

        private Title(String name) {
            this.name = name;
            this.setUI(new TitleUI());
        }

        public void setRollOver(boolean rollOver) {
            if (rollOver == this.rollOver) {
                return;
            }
            this.rollOver = rollOver;
            this.repaint();
        }

        public void collapse() {
            this.collapsed = true;
            this.repaint();
        }

        public void expand() {
            this.collapsed = false;
            this.repaint();
        }
    }

    public static class Padding
    extends JPanel {
        public Padding() {
            this.setBackground(UIUtils.getProfilerResultsBackground());
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(lineColor);
            g.drawLine(0, 0, this.getWidth(), 0);
        }
    }
}

