/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.janitor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.janitor.Bundle;
import org.netbeans.modules.janitor.JanitorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.modules.Places;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public class Janitor {
    private static final int UNUSED_DAYS = 30;
    public static final String PROP_JANITOR_ENABLED = "janitorEnabled";
    public static final String PROP_UNUSED_DAYS = "UnusedDays";
    private static final String LOGFILE_NAME = "var/log/messages.log";
    private static final String ALL_CHECKSUM_NAME = "lastModified/all-checksum.txt";
    private static final String CLEAN_ICON = "org/netbeans/modules/janitor/resources/clean.gif";
    static final RequestProcessor JANITOR_RP = new RequestProcessor("janitor", 1);
    static final Map<ActionListener, Notification> CLEANUP_TASKS = new WeakHashMap<ActionListener, Notification>();
    static final Runnable SCAN_FOR_JUNK = () -> {
        CLEANUP_TASKS.values().forEach(nf -> nf.clear());
        CLEANUP_TASKS.clear();
        ImageIcon clean = ImageUtilities.loadImageIcon((String)CLEAN_ICON, (boolean)false);
        List<Pair<String, Integer>> otherVersions = Janitor.getOtherVersions();
        for (Pair<String, Integer> ver : otherVersions) {
            long toFree = Janitor.size(Janitor.getUserDir((String)ver.first())) + Janitor.size(Janitor.getCacheDir((String)ver.first()));
            toFree = toFree / 1000000L + 1L;
            ActionListener cleanupListener = Janitor.cleanupAction((String)ver.first());
            Notification nf2 = NotificationDisplayer.getDefault().notify(Bundle.TIT_ABANDONED_USERDIR(ver.first(), ver.second(), toFree), (Icon)clean, Bundle.DESC_ABANDONED_USERDIR(ver.first(), ver.second(), toFree), cleanupListener);
            CLEANUP_TASKS.put(cleanupListener, nf2);
        }
    };

    static ActionListener cleanupAction(final String name) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JanitorPanel panel = new JanitorPanel(Bundle.TXT_CONFIRM_CLEANUP(name));
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.TIT_CONFIRM_CLEANUP(), true, 0, DialogDescriptor.YES_OPTION, null);
                if (DialogDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor)) {
                    JANITOR_RP.post(() -> {
                        try (ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.LBL_CLEANUP(name));){
                            handle.start();
                            Janitor.deleteDir(Janitor.getUserDir(name));
                            Janitor.deleteDir(Janitor.getCacheDir(name));
                        }
                    });
                }
                Janitor.setEnabled(panel.isEnabledOnStartup());
                Notification nf = CLEANUP_TASKS.get(this);
                if (nf != null) {
                    nf.clear();
                }
            }
        };
    }

    public static final Preferences getPreferences() {
        return NbPreferences.forModule(Janitor.class);
    }

    static void runNow() {
        JANITOR_RP.post(SCAN_FOR_JUNK);
    }

    static File getUserDir(String version) {
        File ret = null;
        File userDir = Places.getUserDirectory();
        if (userDir != null) {
            ret = new File(userDir.getParentFile(), version);
            ret = ret.isDirectory() ? ret : null;
        }
        return ret;
    }

    static File getCacheDir(String version) {
        File ret = null;
        File cacheDir = Places.getCacheDirectory();
        if (cacheDir != null) {
            ret = new File(cacheDir.getParentFile(), version);
            ret = ret.isDirectory() ? ret : null;
        }
        return ret;
    }

    static void deleteDir(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        Path path = dir.toPath();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static long size(File f) {
        if (f == null) {
            return 0L;
        }
        Path path = f.toPath();
        final AtomicLong size = new AtomicLong(0L);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return size.get();
    }

    static List<Pair<String, Integer>> getOtherVersions() {
        File cacheDir;
        Integer age;
        Instant lastModified2;
        File userDir = Places.getUserDirectory();
        LinkedList<Pair<String, Integer>> ret = new LinkedList<Pair<String, Integer>>();
        HashSet<String> availableUserDirs = new HashSet<String>();
        Instant now = Instant.now();
        if (userDir != null) {
            File userParent = userDir.getParentFile();
            for (File f : userParent.listFiles()) {
                availableUserDirs.add(f.getName());
                Path logFile = new File(f, LOGFILE_NAME).toPath();
                if (f.equals(userDir) || !Files.isRegularFile(logFile, new LinkOption[0])) continue;
                try {
                    lastModified2 = Files.getLastModifiedTime(logFile, new LinkOption[0]).toInstant();
                    age = (int)Duration.between(lastModified2, now).toDays();
                    if (!lastModified2.plus((long)Janitor.getUnusedDays(), ChronoUnit.DAYS).isBefore(now)) continue;
                    ret.add((Pair<String, Integer>)Pair.of((Object)f.getName(), (Object)age));
                }
                catch (IOException lastModified2) {
                    // empty catch block
                }
            }
        }
        if ((cacheDir = Places.getCacheDirectory()) != null) {
            File cacheParent = cacheDir.getParentFile();
            for (File f : cacheParent.listFiles()) {
                if (!f.isDirectory() || availableUserDirs.contains(f.getName()) || !new File(f, ALL_CHECKSUM_NAME).exists() || cacheDir.equals(f)) continue;
                try {
                    lastModified2 = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]).toInstant();
                    age = (int)Duration.between(lastModified2, now).toDays();
                    ret.add((Pair<String, Integer>)Pair.of((Object)f.getName(), (Object)age));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    static void setEnabled(boolean b) {
        Janitor.getPreferences().putBoolean(PROP_JANITOR_ENABLED, b);
    }

    static boolean isEnabled() {
        return Janitor.getPreferences().getBoolean(PROP_JANITOR_ENABLED, true);
    }

    static void setUnusedDays(int days) {
        Janitor.getPreferences().putInt(PROP_UNUSED_DAYS, days);
    }

    static int getUnusedDays() {
        return Janitor.getPreferences().getInt(PROP_UNUSED_DAYS, 30);
    }

    public static final class PlatformOpenHook
    implements Runnable {
        @Override
        public void run() {
            if (Janitor.isEnabled()) {
                JANITOR_RP.post(SCAN_FOR_JUNK, 60000);
            }
        }
    }
}

