/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterPajek;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterPajekPanel;
import org.openide.util.NbBundle;

public class UIExporterPajek
implements ExporterUI {
    private final ExporterPajekSettings settings = new ExporterPajekSettings();
    private UIExporterPajekPanel panel;
    private ExporterPajek exporterPajek;

    public void setup(Exporter exporter) {
        this.exporterPajek = (ExporterPajek)exporter;
        this.settings.load(this.exporterPajek);
        this.panel.setup(this.exporterPajek);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterPajek);
            this.settings.save(this.exporterPajek);
        }
        this.panel = null;
        this.exporterPajek = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterPajekPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterPajek;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterPajek.class, (String)"UIExporterPajek.name");
    }

    private static class ExporterPajekSettings
    extends AbstractExporterSettings {
        private static final String EXPORT_POSITION = "Pajek_exportPosition";
        private static final String EXPORT_EDGE_WEIGHT = "Pajek_exportEdgeWeight";
        private static final ExporterPajek DEFAULT = new ExporterPajek();

        private ExporterPajekSettings() {
        }

        private void save(ExporterPajek exporterPajek) {
            this.put(EXPORT_POSITION, exporterPajek.isExportPosition());
            this.put(EXPORT_EDGE_WEIGHT, exporterPajek.isExportEdgeWeight());
        }

        private void load(ExporterPajek exporterPajek) {
            exporterPajek.setExportPosition(this.get(EXPORT_POSITION, DEFAULT.isExportPosition()));
            exporterPajek.setExportEdgeWeight(this.get(EXPORT_EDGE_WEIGHT, DEFAULT.isExportEdgeWeight()));
        }
    }
}

