/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import cern.colt.bitvector.BitVector;
import cern.colt.bitvector.QuickBitVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.UndirectedSubgraph;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.EdgeStore;
import org.gephi.graph.impl.GraphAttributesImpl;
import org.gephi.graph.impl.GraphModelImpl;
import org.gephi.graph.impl.GraphObserverImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphVersion;
import org.gephi.graph.impl.GraphViewDecorator;
import org.gephi.graph.impl.IndexStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.TimeIndexStore;

public class GraphViewImpl
implements GraphView {
    protected final GraphStore graphStore;
    protected final boolean nodeView;
    protected final boolean edgeView;
    protected final GraphAttributesImpl attributes;
    protected BitVector nodeBitVector;
    protected BitVector edgeBitVector;
    protected int storeId;
    protected final GraphVersion version;
    protected final List<GraphObserverImpl> observers;
    protected final GraphViewDecorator directedDecorator;
    protected final GraphViewDecorator undirectedDecorator;
    protected int nodeCount;
    protected int edgeCount;
    protected int[] typeCounts;
    protected int[] mutualEdgeTypeCounts;
    protected int mutualEdgesCount;
    protected Interval interval;

    public GraphViewImpl(GraphStore store, boolean nodes, boolean edges) {
        this.graphStore = store;
        this.nodeView = nodes;
        this.edgeView = edges;
        this.attributes = new GraphAttributesImpl();
        this.nodeBitVector = nodes ? new BitVector(store.nodeStore.maxStoreId()) : null;
        this.edgeBitVector = new BitVector(store.edgeStore.maxStoreId());
        this.typeCounts = new int[1];
        this.mutualEdgeTypeCounts = new int[1];
        this.directedDecorator = new GraphViewDecorator(this.graphStore, this, false);
        this.undirectedDecorator = new GraphViewDecorator(this.graphStore, this, true);
        this.version = this.graphStore.version != null ? new GraphVersion(this.directedDecorator) : null;
        this.observers = this.graphStore.version != null ? new ArrayList() : null;
        this.interval = Interval.INFINITY_INTERVAL;
    }

    public GraphViewImpl(GraphViewImpl view, boolean nodes, boolean edges) {
        this.graphStore = view.graphStore;
        this.nodeView = nodes;
        this.edgeView = edges;
        this.attributes = new GraphAttributesImpl();
        if (nodes) {
            this.nodeBitVector = view.nodeBitVector.copy();
            this.nodeCount = view.nodeCount;
        } else {
            this.nodeBitVector = null;
        }
        this.edgeCount = view.edgeCount;
        this.edgeBitVector = view.edgeBitVector.copy();
        this.typeCounts = new int[view.typeCounts.length];
        System.arraycopy(view.typeCounts, 0, this.typeCounts, 0, view.typeCounts.length);
        this.mutualEdgeTypeCounts = new int[view.mutualEdgeTypeCounts.length];
        System.arraycopy(view.mutualEdgeTypeCounts, 0, this.mutualEdgeTypeCounts, 0, view.mutualEdgeTypeCounts.length);
        this.directedDecorator = new GraphViewDecorator(this.graphStore, this, false);
        this.undirectedDecorator = new GraphViewDecorator(this.graphStore, this, true);
        this.version = this.graphStore.version != null ? new GraphVersion(this.directedDecorator) : null;
        this.observers = this.graphStore.version != null ? new ArrayList() : null;
        this.interval = view.interval;
    }

    protected DirectedSubgraph getDirectedGraph() {
        return this.directedDecorator;
    }

    protected UndirectedSubgraph getUndirectedGraph() {
        return this.undirectedDecorator;
    }

    public boolean addNode(Node node) {
        this.checkNodeView();
        NodeImpl nodeImpl = (NodeImpl)node;
        this.graphStore.nodeStore.checkNodeExists(nodeImpl);
        int id = nodeImpl.storeId;
        boolean isSet = this.nodeBitVector.get(id);
        if (!isSet) {
            TimeIndexStore timeIndexStore;
            this.nodeBitVector.set(id);
            ++this.nodeCount;
            this.incrementNodeVersion();
            IndexStore<NodeImpl> indexStore = this.graphStore.nodeTable.store.indexStore;
            if (indexStore != null) {
                indexStore.indexInView(nodeImpl, this);
            }
            if ((timeIndexStore = this.graphStore.timeStore.nodeIndexStore) != null) {
                timeIndexStore.indexInView(nodeImpl, this);
            }
            if (this.nodeView && !this.edgeView) {
                EdgeStore.EdgeInOutIterator itr = this.graphStore.edgeStore.edgeIterator(node);
                while (itr.hasNext()) {
                    int edgeid;
                    boolean edgeisSet;
                    EdgeImpl edge = itr.next();
                    NodeImpl opposite = edge.source == nodeImpl ? edge.target : edge.source;
                    if (!this.nodeBitVector.get(opposite.getStoreId()) || (edgeisSet = this.edgeBitVector.get(edgeid = edge.storeId))) continue;
                    this.incrementEdgeVersion();
                    this.addEdge(edge);
                }
            }
            return true;
        }
        return false;
    }

    public boolean addAllNodes(Collection<? extends Node> nodes) {
        this.checkNodeView();
        if (!nodes.isEmpty()) {
            Iterator<? extends Node> nodeItr = nodes.iterator();
            boolean changed = false;
            while (nodeItr.hasNext()) {
                Node node = nodeItr.next();
                this.checkValidNodeObject(node);
                if (!this.addNode(node)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    public boolean addEdge(Edge edge) {
        this.checkEdgeView();
        EdgeImpl edgeImpl = (EdgeImpl)edge;
        this.graphStore.edgeStore.checkEdgeExists(edgeImpl);
        int id = edgeImpl.storeId;
        boolean isSet = this.edgeBitVector.get(id);
        if (!isSet) {
            this.checkIncidentNodesExists(edgeImpl);
            this.addEdge(edgeImpl);
            return true;
        }
        return false;
    }

    public boolean addAllEdges(Collection<? extends Edge> edges) {
        this.checkEdgeView();
        if (!edges.isEmpty()) {
            Iterator<? extends Edge> edgeItr = edges.iterator();
            boolean changed = false;
            while (edgeItr.hasNext()) {
                Edge edge = edgeItr.next();
                this.checkValidEdgeObject(edge);
                if (!this.addEdge(edge)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    public boolean removeNode(Node node) {
        this.checkNodeView();
        NodeImpl nodeImpl = (NodeImpl)node;
        this.graphStore.nodeStore.checkNodeExists(nodeImpl);
        int id = nodeImpl.storeId;
        boolean isSet = this.nodeBitVector.get(id);
        if (isSet) {
            TimeIndexStore timeIndexStore;
            this.nodeBitVector.clear(id);
            --this.nodeCount;
            this.incrementNodeVersion();
            IndexStore<NodeImpl> indexStore = this.graphStore.nodeTable.store.indexStore;
            if (indexStore != null) {
                indexStore.clearInView(nodeImpl, this);
            }
            if ((timeIndexStore = this.graphStore.timeStore.nodeIndexStore) != null) {
                timeIndexStore.clearInView(nodeImpl, this);
            }
            EdgeStore.EdgeInOutIterator itr = this.graphStore.edgeStore.edgeIterator(node);
            while (itr.hasNext()) {
                EdgeImpl edgeImpl = itr.next();
                int edgeId = edgeImpl.storeId;
                boolean edgeSet = this.edgeBitVector.get(edgeId);
                if (!edgeSet) continue;
                this.removeEdge(edgeImpl);
            }
            return true;
        }
        return false;
    }

    public boolean removeNodeAll(Collection<? extends Node> nodes) {
        if (!nodes.isEmpty()) {
            Iterator<? extends Node> nodeItr = nodes.iterator();
            boolean changed = false;
            while (nodeItr.hasNext()) {
                Node node = nodeItr.next();
                this.checkValidNodeObject(node);
                if (!this.removeNode(node)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    public boolean removeEdge(Edge edge) {
        this.checkEdgeView();
        EdgeImpl edgeImpl = (EdgeImpl)edge;
        this.graphStore.edgeStore.checkEdgeExists(edgeImpl);
        int id = edgeImpl.storeId;
        boolean isSet = this.edgeBitVector.get(id);
        if (isSet) {
            this.removeEdge(edgeImpl);
            return true;
        }
        return false;
    }

    public boolean removeEdgeAll(Collection<? extends Edge> edges) {
        this.checkEdgeView();
        if (!edges.isEmpty()) {
            Iterator<? extends Edge> edgeItr = edges.iterator();
            boolean changed = false;
            while (edgeItr.hasNext()) {
                Edge edge = edgeItr.next();
                this.checkValidEdgeObject(edge);
                if (!this.removeEdge(edge)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    public void clear() {
        TimeIndexStore edgeTimeIndexStore;
        IndexStore edgeIndexStore;
        if (this.nodeCount > 0) {
            this.incrementNodeVersion();
        }
        if (this.edgeCount > 0) {
            this.incrementEdgeVersion();
        }
        if (this.nodeView) {
            this.nodeBitVector.clear();
        }
        this.edgeBitVector.clear();
        this.nodeCount = 0;
        this.edgeCount = 0;
        this.typeCounts = new int[1];
        this.mutualEdgeTypeCounts = new int[1];
        this.mutualEdgesCount = 0;
        if (this.nodeView) {
            TimeIndexStore nodeTimeIndexStore;
            IndexStore nodeIndexStore = this.graphStore.nodeTable.store.indexStore;
            if (nodeIndexStore != null) {
                nodeIndexStore.clear(this);
            }
            if ((nodeTimeIndexStore = this.graphStore.timeStore.nodeIndexStore) != null) {
                nodeTimeIndexStore.clear(this);
            }
        }
        if ((edgeIndexStore = this.graphStore.edgeTable.store.indexStore) != null) {
            edgeIndexStore.clear(this);
        }
        if ((edgeTimeIndexStore = this.graphStore.timeStore.edgeIndexStore) != null) {
            edgeTimeIndexStore.clear(this);
        }
    }

    public void clearEdges() {
        TimeIndexStore edgeTimeIndexStore;
        if (this.edgeCount > 0) {
            this.incrementEdgeVersion();
        }
        this.edgeBitVector.clear();
        this.edgeCount = 0;
        this.typeCounts = new int[1];
        this.mutualEdgeTypeCounts = new int[1];
        this.mutualEdgesCount = 0;
        IndexStore edgeIndexStore = this.graphStore.edgeTable.store.indexStore;
        if (edgeIndexStore != null) {
            edgeIndexStore.clear(this);
        }
        if ((edgeTimeIndexStore = this.graphStore.timeStore.edgeIndexStore) != null) {
            edgeTimeIndexStore.clear(this);
        }
    }

    public void fill() {
        TimeIndexStore edgeTimeIndexStore;
        IndexStore edgeIndexStore;
        if (this.nodeView) {
            if (this.nodeCount > 0) {
                this.nodeBitVector = new BitVector(this.graphStore.nodeStore.maxStoreId());
            }
            this.nodeBitVector.not();
            this.nodeCount = this.graphStore.nodeStore.size();
        }
        if (this.edgeCount > 0) {
            this.edgeBitVector = new BitVector(this.graphStore.edgeStore.maxStoreId());
        }
        this.edgeBitVector.not();
        this.edgeCount = this.graphStore.edgeStore.size();
        int typeLength = this.graphStore.edgeStore.longDictionary.length;
        this.typeCounts = new int[typeLength];
        for (int i = 0; i < typeLength; ++i) {
            int count;
            this.typeCounts[i] = count = this.graphStore.edgeStore.longDictionary[i].size();
        }
        this.mutualEdgeTypeCounts = new int[this.graphStore.edgeStore.mutualEdgesTypeSize.length];
        System.arraycopy(this.graphStore.edgeStore.mutualEdgesTypeSize, 0, this.mutualEdgeTypeCounts, 0, this.mutualEdgeTypeCounts.length);
        this.mutualEdgesCount = this.graphStore.edgeStore.mutualEdgesSize;
        if (this.edgeCount > 0) {
            this.incrementEdgeVersion();
        }
        if (this.nodeCount > 0) {
            this.incrementNodeVersion();
        }
        if (this.nodeView) {
            TimeIndexStore nodeTimeIndexStore;
            IndexStore nodeIndexStore = this.graphStore.nodeTable.store.indexStore;
            if (nodeIndexStore != null) {
                nodeIndexStore.indexView(this.directedDecorator);
            }
            if ((nodeTimeIndexStore = this.graphStore.timeStore.nodeIndexStore) != null) {
                nodeTimeIndexStore.indexView(this.directedDecorator);
            }
        }
        if ((edgeIndexStore = this.graphStore.edgeTable.store.indexStore) != null) {
            edgeIndexStore.indexView(this.directedDecorator);
        }
        if ((edgeTimeIndexStore = this.graphStore.timeStore.edgeIndexStore) != null) {
            edgeTimeIndexStore.indexView(this.directedDecorator);
        }
    }

    public boolean containsNode(NodeImpl node) {
        if (!this.nodeView) {
            return true;
        }
        return this.nodeBitVector.get(node.storeId);
    }

    public boolean containsEdge(EdgeImpl edge) {
        return this.edgeBitVector.get(edge.storeId);
    }

    public void intersection(GraphViewImpl otherView) {
        boolean o;
        boolean t;
        int i;
        BitVector nodeOtherBitVector = otherView.nodeBitVector;
        BitVector edgeOtherBitVector = otherView.edgeBitVector;
        if (this.nodeView) {
            int nodeSize = this.nodeBitVector.size();
            for (i = 0; i < nodeSize; ++i) {
                t = this.nodeBitVector.get(i);
                o = nodeOtherBitVector.get(i);
                if (!t || o) continue;
                this.removeNode(this.getNode(i));
            }
        }
        if (this.edgeView) {
            int edgeSize = this.edgeBitVector.size();
            for (i = 0; i < edgeSize; ++i) {
                t = this.edgeBitVector.get(i);
                o = edgeOtherBitVector.get(i);
                if (!t || o) continue;
                this.removeEdge(this.getEdge(i));
            }
        }
    }

    public void union(GraphViewImpl otherView) {
        boolean o;
        boolean t;
        int i;
        BitVector nodeOtherBitVector = otherView.nodeBitVector;
        BitVector edgeOtherBitVector = otherView.edgeBitVector;
        if (this.nodeView) {
            int nodeSize = this.nodeBitVector.size();
            for (i = 0; i < nodeSize; ++i) {
                t = this.nodeBitVector.get(i);
                o = nodeOtherBitVector.get(i);
                if (t || !o) continue;
                this.addNode(this.getNode(i));
            }
        }
        if (this.edgeView) {
            int edgeSize = this.edgeBitVector.size();
            for (i = 0; i < edgeSize; ++i) {
                t = this.edgeBitVector.get(i);
                o = edgeOtherBitVector.get(i);
                if (t || !o) continue;
                this.addEdge(this.getEdge(i));
            }
        }
    }

    public void not() {
        TimeIndexStore edgeTimeIndexStore;
        IndexStore edgeIndexStore;
        int i;
        if (this.nodeView) {
            this.nodeBitVector.not();
            this.nodeCount = this.graphStore.nodeStore.size() - this.nodeCount;
        }
        this.edgeBitVector.not();
        this.edgeCount = this.graphStore.edgeStore.size() - this.edgeCount;
        for (i = 0; i < this.typeCounts.length; ++i) {
            this.typeCounts[i] = this.graphStore.edgeStore.longDictionary[i].size() - this.typeCounts[i];
        }
        for (i = 0; i < this.mutualEdgeTypeCounts.length; ++i) {
            this.mutualEdgeTypeCounts[i] = this.graphStore.edgeStore.mutualEdgesTypeSize[i] - this.mutualEdgeTypeCounts[i];
        }
        this.mutualEdgesCount = this.graphStore.edgeStore.mutualEdgesSize - this.mutualEdgesCount;
        if (this.nodeView) {
            this.incrementNodeVersion();
        }
        this.incrementEdgeVersion();
        if (this.nodeView) {
            for (Edge e : this.graphStore.edgeStore) {
                boolean t = this.edgeBitVector.get(e.getStoreId());
                if (!t || this.nodeBitVector.get(e.getSource().getStoreId()) && this.nodeBitVector.get(e.getTarget().getStoreId())) continue;
                this.removeEdge((EdgeImpl)e);
            }
        }
        if (this.nodeView) {
            TimeIndexStore nodeTimeIndexStore;
            IndexStore nodeIndexStore = this.graphStore.nodeTable.store.indexStore;
            if (nodeIndexStore != null) {
                nodeIndexStore.clear(this.directedDecorator.view);
                nodeIndexStore.indexView(this.directedDecorator);
            }
            if ((nodeTimeIndexStore = this.graphStore.timeStore.nodeIndexStore) != null) {
                nodeTimeIndexStore.clear(this.directedDecorator.view);
                nodeTimeIndexStore.indexView(this.directedDecorator);
            }
        }
        if ((edgeIndexStore = this.graphStore.edgeTable.store.indexStore) != null) {
            edgeIndexStore.clear(this.directedDecorator.view);
            edgeIndexStore.indexView(this.directedDecorator);
        }
        if ((edgeTimeIndexStore = this.graphStore.timeStore.edgeIndexStore) != null) {
            edgeTimeIndexStore.clear(this.directedDecorator.view);
            edgeTimeIndexStore.indexView(this.directedDecorator);
        }
    }

    public void addEdgeInNodeView(EdgeImpl edge) {
        if (this.nodeBitVector.get(edge.source.getStoreId()) && this.nodeBitVector.get(edge.target.getStoreId())) {
            this.incrementEdgeVersion();
            this.addEdge(edge);
        }
    }

    public int getNodeCount() {
        if (this.nodeView) {
            return this.nodeCount;
        }
        return this.graphStore.nodeStore.size();
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    public int getUndirectedEdgeCount() {
        return this.edgeCount - this.mutualEdgesCount;
    }

    public int getEdgeCount(int type) {
        if (type < 0 || type >= this.typeCounts.length) {
            throw new IllegalArgumentException("Incorrect type=" + type);
        }
        return this.typeCounts[type];
    }

    public int getUndirectedEdgeCount(int type) {
        if (type < 0 || type >= this.typeCounts.length) {
            throw new IllegalArgumentException("Incorrect type=" + type);
        }
        return this.typeCounts[type] - this.mutualEdgeTypeCounts[type];
    }

    @Override
    public GraphModelImpl getGraphModel() {
        return this.graphStore.graphModel;
    }

    @Override
    public boolean isMainView() {
        return false;
    }

    @Override
    public boolean isNodeView() {
        return this.nodeView;
    }

    @Override
    public boolean isEdgeView() {
        return this.edgeView;
    }

    public void setTimeInterval(Interval interval) {
        if (interval == null) {
            interval = Interval.INFINITY_INTERVAL;
        }
        this.interval = interval;
    }

    @Override
    public Interval getTimeInterval() {
        return this.interval;
    }

    @Override
    public boolean isDestroyed() {
        return this.storeId == -1;
    }

    protected int getVersion() {
        return Objects.hash(this.version.nodeVersion, this.version.edgeVersion);
    }

    protected GraphObserverImpl createGraphObserver(Graph graph, boolean withDiff) {
        if (this.observers != null) {
            GraphObserverImpl observer = new GraphObserverImpl(this.graphStore, this.version, graph, withDiff);
            this.observers.add(observer);
            return observer;
        }
        return null;
    }

    protected void destroyGraphObserver(GraphObserverImpl observer) {
        if (this.observers != null) {
            this.observers.remove(observer);
            observer.destroyObserver();
        }
    }

    protected void destroyAllObservers() {
        if (this.observers != null) {
            for (GraphObserverImpl graphObserverImpl : this.observers) {
                graphObserverImpl.destroyObserver();
            }
            this.observers.clear();
        }
    }

    protected void ensureNodeVectorSize(NodeImpl node) {
        int sid = node.storeId;
        if (sid >= this.nodeBitVector.size()) {
            int newSize = Math.min(Math.max(sid + 1, (int)((double)sid * 1.1)), Integer.MAX_VALUE);
            this.nodeBitVector = this.growBitVector(this.nodeBitVector, newSize);
        }
    }

    private void ensureNodeVectorSize(int size) {
        if (size > this.nodeBitVector.size()) {
            this.nodeBitVector = this.growBitVector(this.nodeBitVector, size);
        }
    }

    private void ensureEdgeVectorSize(int size) {
        if (size > this.edgeBitVector.size()) {
            this.edgeBitVector = this.growBitVector(this.edgeBitVector, size);
        }
    }

    protected void ensureEdgeVectorSize(EdgeImpl edge) {
        int sid = edge.storeId;
        if (sid >= this.edgeBitVector.size()) {
            int newSize = Math.min(Math.max(sid + 1, (int)((double)sid * 1.1)), Integer.MAX_VALUE);
            this.edgeBitVector = this.growBitVector(this.edgeBitVector, newSize);
        }
    }

    private void addEdge(EdgeImpl edgeImpl) {
        TimeIndexStore timeIndexStore;
        IndexStore<EdgeImpl> indexStore;
        this.incrementEdgeVersion();
        this.edgeBitVector.set(edgeImpl.storeId);
        ++this.edgeCount;
        int type = edgeImpl.type;
        this.ensureTypeCountArrayCapacity(type);
        int n = type;
        this.typeCounts[n] = this.typeCounts[n] + 1;
        if (edgeImpl.isMutual() && edgeImpl.source.storeId < edgeImpl.target.storeId) {
            int n2 = type;
            this.mutualEdgeTypeCounts[n2] = this.mutualEdgeTypeCounts[n2] + 1;
            ++this.mutualEdgesCount;
        }
        if ((indexStore = this.graphStore.edgeTable.store.indexStore) != null) {
            indexStore.indexInView(edgeImpl, this);
        }
        if ((timeIndexStore = this.graphStore.timeStore.edgeIndexStore) != null) {
            timeIndexStore.indexInView(edgeImpl, this);
        }
    }

    private void removeEdge(EdgeImpl edgeImpl) {
        IndexStore<EdgeImpl> indexStore;
        this.incrementEdgeVersion();
        this.edgeBitVector.clear(edgeImpl.storeId);
        --this.edgeCount;
        int n = edgeImpl.type;
        this.typeCounts[n] = this.typeCounts[n] - 1;
        if (edgeImpl.isMutual() && edgeImpl.source.storeId < edgeImpl.target.storeId) {
            int n2 = edgeImpl.type;
            this.mutualEdgeTypeCounts[n2] = this.mutualEdgeTypeCounts[n2] - 1;
            --this.mutualEdgesCount;
        }
        if ((indexStore = this.graphStore.edgeTable.store.indexStore) != null) {
            indexStore.clearInView(edgeImpl, this);
        }
    }

    private BitVector growBitVector(BitVector bitVector, int size) {
        long[] elements = bitVector.elements();
        long[] newElements = QuickBitVector.makeBitVector((int)size, (int)1);
        System.arraycopy(elements, 0, newElements, 0, elements.length);
        return new BitVector(newElements, size);
    }

    private NodeImpl getNode(int id) {
        return this.graphStore.nodeStore.get(id);
    }

    private EdgeImpl getEdge(int id) {
        return this.graphStore.edgeStore.get(id);
    }

    private void ensureTypeCountArrayCapacity(int type) {
        if (type >= this.typeCounts.length) {
            int[] newArray = new int[type + 1];
            System.arraycopy(this.typeCounts, 0, newArray, 0, this.typeCounts.length);
            this.typeCounts = newArray;
            int[] newMutualArray = new int[type + 1];
            System.arraycopy(this.mutualEdgeTypeCounts, 0, newMutualArray, 0, this.mutualEdgeTypeCounts.length);
            this.mutualEdgeTypeCounts = newMutualArray;
        }
    }

    public int deepHashCode() {
        int hash = 5;
        hash = 17 * hash + (this.nodeView ? 1 : 0);
        hash = 17 * hash + (this.edgeView ? 1 : 0);
        hash = 11 * hash + (this.nodeBitVector != null ? this.nodeBitVector.hashCode() : 0);
        hash = 11 * hash + (this.edgeBitVector != null ? this.edgeBitVector.hashCode() : 0);
        hash = 11 * hash + this.nodeCount;
        hash = 11 * hash + this.edgeCount;
        hash = 11 * hash + Arrays.hashCode(this.typeCounts);
        hash = 11 * hash + Arrays.hashCode(this.mutualEdgeTypeCounts);
        hash = 11 * hash + this.mutualEdgesCount;
        hash = 11 * hash + (this.interval != null ? this.interval.hashCode() : 0);
        return hash;
    }

    public boolean deepEquals(GraphViewImpl obj) {
        if (obj == null) {
            return false;
        }
        if (!(this.nodeBitVector == obj.nodeBitVector || this.nodeBitVector != null && this.nodeBitVector.equals((Object)obj.nodeBitVector))) {
            return false;
        }
        if (!(this.edgeBitVector == obj.edgeBitVector || this.edgeBitVector != null && this.edgeBitVector.equals((Object)obj.edgeBitVector))) {
            return false;
        }
        if (this.nodeCount != obj.nodeCount) {
            return false;
        }
        if (this.edgeCount != obj.edgeCount) {
            return false;
        }
        if (this.nodeView != obj.nodeView) {
            return false;
        }
        if (this.edgeView != obj.edgeView) {
            return false;
        }
        if (!Arrays.equals(this.typeCounts, obj.typeCounts)) {
            return false;
        }
        if (!Arrays.equals(this.mutualEdgeTypeCounts, obj.mutualEdgeTypeCounts)) {
            return false;
        }
        if (this.mutualEdgesCount != obj.mutualEdgesCount) {
            return false;
        }
        return this.interval == obj.interval || this.interval != null && this.interval.equals(obj.interval);
    }

    private int incrementNodeVersion() {
        if (this.version != null) {
            return this.version.incrementAndGetNodeVersion();
        }
        return 0;
    }

    private int incrementEdgeVersion() {
        if (this.version != null) {
            return this.version.incrementAndGetEdgeVersion();
        }
        return 0;
    }

    private void checkNodeView() {
        if (!this.nodeView) {
            throw new RuntimeException("This method should only be used on a view with nodes enabled");
        }
    }

    private void checkEdgeView() {
        if (!this.edgeView) {
            throw new RuntimeException("This method should only be used on a view with edges enabled");
        }
    }

    private void checkIncidentNodesExists(EdgeImpl e) {
        if (!(!this.nodeView || this.nodeBitVector.get(e.source.storeId) && this.nodeBitVector.get(e.target.storeId))) {
            throw new RuntimeException("Both source and target nodes need to be in the view");
        }
    }

    private void checkValidEdgeObject(Edge n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (!(n instanceof EdgeImpl)) {
            throw new ClassCastException("Object must be a EdgeImpl object");
        }
        if (((EdgeImpl)n).storeId == -1) {
            throw new IllegalArgumentException("Edge should belong to a store");
        }
    }

    private void checkValidNodeObject(Node n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (!(n instanceof NodeImpl)) {
            throw new ClassCastException("Object must be a NodeImpl object");
        }
        if (((NodeImpl)n).storeId == -1) {
            throw new IllegalArgumentException("Node should belong to a store");
        }
    }
}

