/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class ArrowResizableIcon
implements ResizableIcon {
    private Dimension initialDim;
    protected int width;
    protected int height;
    protected int direction;

    public ArrowResizableIcon(Dimension initialDim, int direction) {
        this.initialDim = initialDim;
        this.width = initialDim.width;
        this.height = initialDim.height;
        this.direction = direction;
    }

    public ArrowResizableIcon(int initialDim, int direction) {
        this(new Dimension(initialDim, initialDim), direction);
    }

    public void revertToOriginalDimension() {
        this.width = this.initialDim.width;
        this.height = this.initialDim.height;
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    protected boolean toPaintEnabled(Component c) {
        return c.isEnabled();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        float strokeWidth = (float)this.width / 7.0f;
        if (strokeWidth < 1.0f) {
            strokeWidth = 1.0f;
        }
        BasicStroke stroke = new BasicStroke(strokeWidth, 0, 0);
        graphics.setStroke(stroke);
        GeneralPath gp = new GeneralPath();
        switch (this.direction) {
            case 5: {
                gp.moveTo(0.0f, 2.0f);
                gp.lineTo(0.5f * (float)(this.width - 1), this.height - 2);
                gp.lineTo(this.width - 1, 2.0f);
                break;
            }
            case 1: {
                gp.moveTo(0.0f, this.height - 2);
                gp.lineTo(0.5f * (float)(this.width - 1), 2.0f);
                gp.lineTo(this.width - 1, this.height - 2);
                break;
            }
            case 3: {
                gp.moveTo(2.0f, 0.0f);
                gp.lineTo(this.width - 2, 0.5f * (float)(this.height - 1));
                gp.lineTo(2.0f, this.height - 1);
                break;
            }
            case 7: {
                gp.moveTo(this.width - 2, 0.0f);
                gp.lineTo(2.0f, 0.5f * (float)(this.height - 1));
                gp.lineTo(this.width - 2, this.height - 1);
            }
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(x, y + 1);
        Color dropColor = this.toPaintEnabled(c) ? new Color(255, 255, 255, 196) : new Color(255, 255, 255, 32);
        graphics.setColor(dropColor);
        graphics.draw(gp);
        graphics.translate(0, -1);
        Color arrowColor = this.toPaintEnabled(c) ? Color.black : Color.gray;
        graphics.setColor(arrowColor);
        if (this.width < 9) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.draw(gp);
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.draw(gp);
        graphics.dispose();
    }

    public static class CommandButtonPopupIcon
    extends ArrowResizableIcon {
        public CommandButtonPopupIcon(int initialDim, int direction) {
            super(initialDim, direction);
        }

        @Override
        protected boolean toPaintEnabled(Component c) {
            JCommandButton jcb = (JCommandButton)c;
            return jcb.isEnabled() && jcb.getPopupModel().isEnabled();
        }
    }
}

