/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.swing;

import com.jogamp.common.nio.Buffers;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.lib.gleem.linalg.Vec3f;
import org.gephi.visualization.VizArchitecture;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.apiimpl.GraphIO;
import org.gephi.visualization.apiimpl.Scheduler;
import org.gephi.visualization.opengl.AbstractEngine;
import org.gephi.visualization.opengl.GraphicalConfiguration;
import org.openide.util.Exceptions;

public abstract class GLAbstractListener
implements GLEventListener,
VizArchitecture,
GraphDrawable {
    protected static final GLU GLU = new GLU();
    private static float rotateFactor = 15.0f;
    public final float viewField = 30.0f;
    public final float nearDistance = 1.0f;
    public final float farDistance = 150000.0f;
    public Component graphComponent;
    protected GLAutoDrawable drawable;
    protected VizController vizController;
    protected VizModel vizModel;
    protected GraphIO graphIO;
    protected float fps;
    protected float fpsAvg = 0.0f;
    protected float fpsCount = 0.0f;
    protected float globalScale = 1.0f;
    protected FloatBuffer projMatrix = Buffers.newDirectFloatBuffer((int)16);
    protected FloatBuffer modelMatrix = Buffers.newDirectFloatBuffer((int)16);
    protected IntBuffer viewport = Buffers.newDirectIntBuffer((int)4);
    protected GraphicalConfiguration graphicalConfiguration;
    protected GLWindow window;
    protected AbstractEngine engine;
    protected Scheduler scheduler;
    protected float[] cameraLocation;
    protected float[] cameraTarget;
    protected double[] draggingMarker = new double[2];
    protected Vec3f cameraVector = new Vec3f();
    protected MouseAdapter graphMouseAdapterNewt;
    protected java.awt.event.MouseAdapter graphMouseAdapterCanvas;
    protected GraphMouseAdapter graphMouseAdapter;
    private long startTime = 0L;
    private boolean showGLLog = true;
    private volatile boolean resizing = false;
    private double aspectRatio = 0.0;

    public GLAbstractListener() {
        this.vizController = VizController.getInstance();
    }

    protected void initDrawable(GLAutoDrawable drawable) {
        this.drawable = drawable;
        drawable.addGLEventListener((GLEventListener)this);
    }

    @Override
    public void initArchitecture() {
        this.engine = VizController.getInstance().getEngine();
        this.scheduler = VizController.getInstance().getScheduler();
        this.graphIO = VizController.getInstance().getGraphIO();
        this.cameraLocation = this.vizController.getVizConfig().getDefaultCameraPosition();
        this.cameraTarget = this.vizController.getVizConfig().getDefaultCameraTarget();
        if (this.vizController.getVizConfig().isReduceFpsWhenMouseOut() || this.vizController.getVizConfig().isPauseLoopWhenMouseOut()) {
            this.graphMouseAdapter = new GraphMouseAdapter();
            if (this.window != null) {
                this.graphMouseAdapterNewt = new MouseAdapter(){

                    public void mouseEntered(com.jogamp.newt.event.MouseEvent e) {
                        GLAbstractListener.this.graphMouseAdapter.mouseEntered();
                    }

                    public void mouseExited(com.jogamp.newt.event.MouseEvent e) {
                        GLAbstractListener.this.graphMouseAdapter.mouseExited();
                    }
                };
                this.window.addMouseListener((MouseListener)this.graphMouseAdapterNewt);
            } else {
                this.graphMouseAdapterCanvas = new java.awt.event.MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        GLAbstractListener.this.graphMouseAdapter.mouseEntered();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        GLAbstractListener.this.graphMouseAdapter.mouseExited();
                    }
                };
                this.graphComponent.addMouseListener(this.graphMouseAdapterCanvas);
            }
        }
    }

    protected abstract void init(GL2 var1);

    protected abstract void render3DScene(GL2 var1, GLU var2);

    protected abstract void reshape3DScene(GL2 var1);

    protected GLCapabilities getCaps() {
        GLProfile profile = GLProfile.get((String)"GL2");
        GLCapabilities caps = new GLCapabilities(profile);
        try {
            caps.setAlphaBits(8);
            caps.setDoubleBuffered(true);
            caps.setHardwareAccelerated(true);
            int antialisaing = this.vizController.getVizConfig().getAntialiasing();
            switch (antialisaing) {
                case 0: {
                    caps.setSampleBuffers(false);
                    break;
                }
                case 2: {
                    caps.setSampleBuffers(true);
                    caps.setNumSamples(2);
                    break;
                }
                case 4: {
                    caps.setSampleBuffers(true);
                    caps.setNumSamples(4);
                    break;
                }
                case 8: {
                    caps.setSampleBuffers(true);
                    caps.setNumSamples(8);
                    break;
                }
                case 16: {
                    caps.setSampleBuffers(true);
                    caps.setNumSamples(16);
                    break;
                }
            }
        }
        catch (GLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return caps;
    }

    @Override
    public void initConfig(GL2 gl) {
        gl.setSwapInterval(0);
        gl.glDisable(2929);
        gl.glDisable(2832);
        gl.glDisable(2848);
        gl.glClearDepth(1.0);
        float[] backgroundColor = this.vizController.getVizModel().getBackgroundColorComponents();
        gl.glClearColor(backgroundColor[0], backgroundColor[1], backgroundColor[2], 1.0f);
        if (this.vizController.getVizConfig().isBlending()) {
            gl.glEnable(3042);
            gl.glBlendFunc(770, 771);
        }
        gl.glDisable(2896);
        gl.glShadeModel(7424);
        if (this.vizController.getVizConfig().isWireFrame()) {
            gl.glPolygonMode(1032, 6913);
        }
    }

    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        this.graphicalConfiguration = new GraphicalConfiguration();
        this.graphicalConfiguration.checkGeneralCompatibility(gl);
        this.vizController.getTextManager().reinitRenderers();
        this.viewport = Buffers.newDirectIntBuffer((int)4);
        this.resizing = false;
        this.initConfig(gl);
        this.engine.initEngine(gl, GLU);
        this.init(gl);
    }

    public void refreshDraggingMarker() {
        float[] d = this.myGluProject(0.0f, 0.0f, 0.0f);
        float[] d2 = this.myGluProject(1.0f, 1.0f, 0.0f);
        this.draggingMarker[0] = d[0] - d2[0];
        this.draggingMarker[1] = d[1] - d2[1];
    }

    @Override
    public void setCameraPosition(GL2 gl, GLU glu) {
        gl.glLoadIdentity();
        glu.gluLookAt(this.cameraLocation[0], this.cameraLocation[1], this.cameraLocation[2], this.cameraTarget[0], this.cameraTarget[1], this.cameraTarget[2], 0.0f, 1.0f, 0.0f);
        gl.glScalef(this.globalScale, this.globalScale, 1.0f);
        gl.glGetFloatv(2982, this.modelMatrix);
        this.cameraVector.set(this.cameraTarget[0] - this.cameraLocation[0], this.cameraTarget[1] - this.cameraLocation[1], this.cameraTarget[2] - this.cameraLocation[2]);
        this.refreshDraggingMarker();
    }

    public void display(GLAutoDrawable drawable) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis() - 1L;
        }
        long endTime = System.currentTimeMillis();
        long delta = endTime - this.startTime;
        this.startTime = endTime;
        this.fps = 1000.0f / (float)delta;
        if (this.fps < 100.0f) {
            this.fpsAvg = (this.fpsAvg * this.fpsCount + this.fps) / (this.fpsCount += 1.0f);
        }
        GL2 gl = drawable.getGL().getGL2();
        gl.glClear(16384);
        this.render3DScene(gl, GLU);
        this.scheduler.display(gl, GLU);
    }

    @Override
    public void display() {
        this.drawable.display();
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        if (!this.resizing) {
            if (this.viewport.get(2) == width && this.viewport.get(3) == height) {
                return;
            }
            this.resizing = true;
            if (height == 0) {
                height = 1;
            }
            if (width == 0) {
                width = 1;
            }
            this.aspectRatio = (double)width / (double)height;
            int viewportH = height;
            int viewportW = (int)((double)height * this.aspectRatio);
            if (viewportW > width) {
                viewportW = width;
                viewportH = (int)((double)width * (1.0 / this.aspectRatio));
            }
            int viewportX = (width - viewportW) / 2;
            int viewportY = (height - viewportH) / 2;
            GL2 gl = drawable.getGL().getGL2();
            gl.glViewport(viewportX, viewportY, viewportW, viewportH);
            gl.glGetIntegerv(2978, this.viewport);
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            GLU.gluPerspective(30.0, this.aspectRatio, 1.0, 150000.0);
            gl.glGetFloatv(2983, this.projMatrix);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            this.setCameraPosition(gl, GLU);
            this.reshape3DScene(drawable.getGL().getGL2());
            if (this.showGLLog) {
                this.showGLLog = false;
                Logger logger = Logger.getLogger("");
                logger.log(Level.INFO, "GL_VENDOR: {0}", gl.glGetString(7936));
                logger.log(Level.INFO, "GL_RENDERER: {0}", gl.glGetString(7937));
                logger.log(Level.INFO, "GL_VERSION: {0}", gl.glGetString(7938));
                logger.log(Level.INFO, "GL_SURFACE_SCALE: {0}", Float.valueOf(this.globalScale));
            }
            this.resizing = false;
        }
    }

    @Override
    public void destroy() {
        if (this.graphMouseAdapterNewt != null) {
            this.window.removeMouseListener((MouseListener)this.graphMouseAdapterNewt);
        } else if (this.graphMouseAdapterCanvas != null) {
            this.graphComponent.removeMouseListener(this.graphMouseAdapterCanvas);
        }
        this.graphMouseAdapter = null;
        this.drawable.destroy();
    }

    public void renderTestCube(GL2 gl) {
        float cubeSize = 1.0f;
        gl.glClear(16640);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        GLU.gluLookAt(this.cameraLocation[0], this.cameraLocation[1], this.cameraLocation[2], this.cameraTarget[0], this.cameraTarget[1], this.cameraTarget[2], 0.0f, 1.0f, 0.0f);
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        float f = rotateFactor;
        rotateFactor = f + 1.0f;
        gl.glRotatef(f % 360.0f, 0.0f, 1.0f, 0.0f);
        gl.glRotatef(15.0f, 1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glColor3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(cubeSize, cubeSize, -cubeSize);
        gl.glVertex3f(-cubeSize, cubeSize, -cubeSize);
        gl.glVertex3f(-cubeSize, cubeSize, cubeSize);
        gl.glVertex3f(cubeSize, cubeSize, cubeSize);
        gl.glColor3f(1.0f, 0.5f, 0.0f);
        gl.glVertex3f(cubeSize, -cubeSize, cubeSize);
        gl.glVertex3f(-cubeSize, -cubeSize, cubeSize);
        gl.glVertex3f(-cubeSize, -cubeSize, -cubeSize);
        gl.glVertex3f(cubeSize, -cubeSize, -cubeSize);
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(cubeSize, cubeSize, cubeSize);
        gl.glVertex3f(-cubeSize, cubeSize, cubeSize);
        gl.glVertex3f(-cubeSize, -cubeSize, cubeSize);
        gl.glVertex3f(cubeSize, -cubeSize, cubeSize);
        gl.glColor3f(1.0f, 1.0f, 0.0f);
        gl.glVertex3f(cubeSize, -cubeSize, -cubeSize);
        gl.glVertex3f(-cubeSize, -cubeSize, -cubeSize);
        gl.glVertex3f(-cubeSize, cubeSize, -cubeSize);
        gl.glVertex3f(cubeSize, cubeSize, -cubeSize);
        gl.glColor3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(-cubeSize, cubeSize, cubeSize);
        gl.glVertex3f(-cubeSize, cubeSize, -cubeSize);
        gl.glVertex3f(-cubeSize, -cubeSize, -cubeSize);
        gl.glVertex3f(-cubeSize, -cubeSize, cubeSize);
        gl.glColor3f(1.0f, 0.0f, 1.0f);
        gl.glVertex3f(cubeSize, cubeSize, -cubeSize);
        gl.glVertex3f(cubeSize, cubeSize, cubeSize);
        gl.glVertex3f(cubeSize, -cubeSize, cubeSize);
        gl.glVertex3f(cubeSize, -cubeSize, -cubeSize);
        gl.glEnd();
    }

    @Override
    public double[] myGluProject(float x, float y) {
        return this.myGluProject(x, y);
    }

    @Override
    public float[] myGluProject(float x, float y, float z) {
        float[] res = new float[2];
        float o0 = this.modelMatrix.get(0) * x + this.modelMatrix.get(4) * y + this.modelMatrix.get(8) * z + this.modelMatrix.get(12) * 1.0f;
        float o1 = this.modelMatrix.get(1) * x + this.modelMatrix.get(5) * y + this.modelMatrix.get(9) * z + this.modelMatrix.get(13) * 1.0f;
        float o2 = this.modelMatrix.get(2) * x + this.modelMatrix.get(6) * y + this.modelMatrix.get(10) * z + this.modelMatrix.get(14) * 1.0f;
        float o3 = this.modelMatrix.get(3) * x + this.modelMatrix.get(7) * y + this.modelMatrix.get(11) * z + this.modelMatrix.get(15) * 1.0f;
        float p0 = this.projMatrix.get(0) * o0 + this.projMatrix.get(4) * o1 + this.projMatrix.get(8) * o2 + this.projMatrix.get(12) * o3;
        float p1 = this.projMatrix.get(1) * o0 + this.projMatrix.get(5) * o1 + this.projMatrix.get(9) * o2 + this.projMatrix.get(13) * o3;
        float p2 = this.projMatrix.get(2) * o0 + this.projMatrix.get(6) * o1 + this.projMatrix.get(10) * o2 + this.projMatrix.get(14) * o3;
        float p3 = this.projMatrix.get(3) * o0 + this.projMatrix.get(7) * o1 + this.projMatrix.get(11) * o2 + this.projMatrix.get(15) * o3;
        p2 /= p3;
        res[0] = (float)this.viewport.get(0) + ((p0 /= p3) + 1.0f) * (float)this.viewport.get(2) / 2.0f;
        res[1] = (float)this.viewport.get(1) + (float)this.viewport.get(3) * ((p1 /= p3) + 1.0f) / 2.0f;
        return res;
    }

    private double[] transformVect(double[] in, DoubleBuffer m) {
        double[] out = new double[]{m.get(0) * in[0] + m.get(4) * in[1] + m.get(8) * in[2] + m.get(12) * in[3], m.get(1) * in[0] + m.get(5) * in[1] + m.get(9) * in[2] + m.get(13) * in[3], m.get(2) * in[0] + m.get(6) * in[1] + m.get(10) * in[2] + m.get(14) * in[3], m.get(3) * in[0] + m.get(7) * in[1] + m.get(11) * in[2] + m.get(15) * in[3]};
        return out;
    }

    public GL2 getGL() {
        return this.drawable.getGL().getGL2();
    }

    public void setVizController(VizController vizController) {
        this.vizController = vizController;
    }

    public GLAutoDrawable getGLAutoDrawable() {
        return this.drawable;
    }

    @Override
    public GraphicalConfiguration getGraphicalConfiguration() {
        return this.graphicalConfiguration;
    }

    protected void resetFpsAverage() {
        this.fpsAvg = 0.0f;
        this.fpsCount = 0.0f;
    }

    protected float getFpsAverage() {
        return this.fpsAvg;
    }

    @Override
    public float[] getCameraLocation() {
        return this.cameraLocation;
    }

    @Override
    public void setCameraLocation(float[] cameraLocation) {
        this.cameraLocation = cameraLocation;
    }

    @Override
    public float[] getCameraTarget() {
        return this.cameraTarget;
    }

    @Override
    public void setCameraTarget(float[] cameraTarget) {
        this.cameraTarget = cameraTarget;
    }

    @Override
    public Component getGraphComponent() {
        return this.graphComponent;
    }

    @Override
    public Vec3f getCameraVector() {
        return this.cameraVector;
    }

    @Override
    public int getViewportHeight() {
        return this.viewport.get(3);
    }

    @Override
    public int getViewportWidth() {
        return this.viewport.get(2);
    }

    @Override
    public double getDraggingMarkerX() {
        return this.draggingMarker[0];
    }

    @Override
    public double getDraggingMarkerY() {
        return this.draggingMarker[1];
    }

    @Override
    public FloatBuffer getProjectionMatrix() {
        return this.projMatrix;
    }

    public FloatBuffer getModelMatrix() {
        return this.modelMatrix;
    }

    @Override
    public IntBuffer getViewport() {
        return this.viewport;
    }

    @Override
    public float getGlobalScale() {
        return this.globalScale;
    }

    public void dispose(GLAutoDrawable glad) {
        this.engine.stopDisplay();
        VizController.getInstance().getDataBridge().reset();
    }

    @Override
    public Point getLocationOnScreen() {
        return this.graphComponent.getLocationOnScreen();
    }

    private class GraphMouseAdapter {
        final boolean pause;
        final int minVal;
        final int maxVal = 30;
        private float lastTarget;

        private GraphMouseAdapter() {
            this.pause = GLAbstractListener.this.vizController.getVizConfig().isPauseLoopWhenMouseOut();
            this.minVal = GLAbstractListener.this.vizController.getVizConfig().getReduceFpsWhenMouseOutValue();
            this.maxVal = 30;
            this.lastTarget = 0.1f;
        }

        private void mouseEntered() {
            if (this.pause) {
                GLAbstractListener.this.engine.resumeDisplay();
            } else {
                if (!GLAbstractListener.this.scheduler.isAnimating()) {
                    GLAbstractListener.this.engine.resumeDisplay();
                }
                GLAbstractListener.this.scheduler.setFps(30.0f);
                GLAbstractListener.this.resetFpsAverage();
            }
        }

        private void mouseExited() {
            if (this.pause) {
                GLAbstractListener.this.engine.pauseDisplay();
            } else {
                float fps = GLAbstractListener.this.getFpsAverage();
                float target = (float)((double)fps / (1.0 / Math.sqrt(GLAbstractListener.this.getFpsAverage()) * 10.0));
                if (fps == 0.0f) {
                    target = this.lastTarget;
                }
                if (target <= 0.005f) {
                    GLAbstractListener.this.engine.pauseDisplay();
                } else if (target > (float)this.minVal) {
                    target = this.minVal;
                }
                this.lastTarget = target;
                GLAbstractListener.this.scheduler.setFps(target);
            }
        }
    }
}

