/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes;

import java.util.ArrayList;
import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.GeneralColumnsChooser;
import org.gephi.datalab.plugin.manipulators.nodes.BasicNodesManipulator;
import org.gephi.datalab.plugin.manipulators.ui.GeneralChooseColumnsUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClearNodesData
extends BasicNodesManipulator
implements GeneralColumnsChooser {
    private Node[] nodes;
    private Column[] columnsToClearData;

    public void setup(Node[] nodes, Node clickedNode) {
        this.nodes = nodes;
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        ArrayList<Column> columnsToClearDataList = new ArrayList<Column>();
        for (Column column : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable()) {
            if (!ac.canClearColumnData(column)) continue;
            columnsToClearDataList.add(column);
        }
        this.columnsToClearData = columnsToClearDataList.toArray(new Column[0]);
    }

    public void execute() {
        if (this.columnsToClearData.length >= 0) {
            AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
            ac.clearNodesData(this.nodes, this.columnsToClearData);
            ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).refreshCurrentTable();
        }
    }

    @Override
    public String getName() {
        if (this.nodes.length > 1) {
            return NbBundle.getMessage(ClearNodesData.class, (String)"ClearNodesData.name.multiple");
        }
        return NbBundle.getMessage(ClearNodesData.class, (String)"ClearNodesData.name.single");
    }

    public String getDescription() {
        return NbBundle.getMessage(ClearNodesData.class, (String)"ClearNodesData.description");
    }

    public boolean canExecute() {
        return true;
    }

    public ManipulatorUI getUI() {
        return new GeneralChooseColumnsUI(NbBundle.getMessage(ClearNodesData.class, (String)"ClearNodesData.ui.description"));
    }

    public int getType() {
        return 200;
    }

    public int getPosition() {
        return 100;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/gephi/datalab/plugin/manipulators/resources/clear-data.png", (boolean)true);
    }

    @Override
    public Column[] getColumns() {
        return this.columnsToClearData;
    }

    @Override
    public void setColumns(Column[] columnsToClearData) {
        this.columnsToClearData = columnsToClearData;
    }
}

