/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.config.ParamSet;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.compress.ClosePointsAlgorithm;
import tim.prune.function.compress.CompressionAlgorithm;
import tim.prune.function.compress.DouglasPeuckerAlgorithm;
import tim.prune.function.compress.DuplicatePointAlgorithm;
import tim.prune.function.compress.MarkAndDeleteFunction;
import tim.prune.function.compress.SingletonAlgorithm;
import tim.prune.function.compress.SummaryLabel;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.WackyPointAlgorithm;

public class CompressTrackFunction
extends MarkAndDeleteFunction {
    private final Track _track;
    private JDialog _dialog = null;
    private JButton _okButton = null;
    private CompressionAlgorithm[] _algorithms = null;
    private SummaryLabel _summaryLabel = null;

    public CompressTrackFunction(App app) {
        super(app);
        this._track = app.getTrackInfo().getTrack();
        this.makeAlgorithms();
    }

    @Override
    public String getNameKey() {
        return "function.compress";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
            this.initDialogFromConfig();
        }
        this.preview();
        this._dialog.setVisible(true);
    }

    private boolean[] preview() {
        int n = 0;
        boolean[] blArray = new boolean[this._track.getNumPoints()];
        int n2 = 0;
        while (n2 < this._algorithms.length) {
            n += this._algorithms[n2].preview(blArray);
            ++n2;
        }
        this._summaryLabel.setValue(n);
        this._okButton.setEnabled(n > 0);
        return blArray;
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        int n = 0;
        while (n < this._algorithms.length) {
            jPanel2.add(this._algorithms[n].getGuiComponents());
            jPanel2.add(Box.createRigidArea(new Dimension(0, 2)));
            ++n;
        }
        JPanel jPanel3 = new JPanel();
        this._summaryLabel = new SummaryLabel(this._track);
        jPanel3.add(this._summaryLabel);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.setEnabled(false);
        this._okButton.addActionListener(actionEvent -> this.finish());
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void makeAlgorithms() {
        ActionListener actionListener = actionEvent -> {
            boolean[] blArray = this.preview();
        };
        TrackDetails trackDetails = new TrackDetails(this._track);
        this._algorithms = new CompressionAlgorithm[]{new DuplicatePointAlgorithm(this._track, trackDetails, actionListener), new ClosePointsAlgorithm(this._track, trackDetails, actionListener), new WackyPointAlgorithm(this._track, trackDetails, actionListener), new SingletonAlgorithm(this._track, trackDetails, actionListener), new DouglasPeuckerAlgorithm(this._track, trackDetails, actionListener)};
    }

    private void finish() {
        boolean[] blArray = this.preview();
        int n = 0;
        int n2 = 0;
        while (n2 < blArray.length) {
            DataPoint dataPoint = this._track.getPoint(n2);
            boolean bl = blArray[n2] && !dataPoint.hasMedia();
            dataPoint.setMarkedForDeletion(bl);
            if (bl) {
                ++n;
            }
            ++n2;
        }
        Config.setConfigString("prune.compression", this.createConfigString());
        UpdateMessageBroker.informSubscribers();
        this._dialog.dispose();
        if (n > 0) {
            this.optionallyDeleteMarkedPoints(n);
        } else {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.compress.confirmnone"), I18nManager.getText(this.getNameKey()), 1);
        }
    }

    private String createConfigString() {
        StringBuilder stringBuilder = new StringBuilder();
        CompressionAlgorithm[] compressionAlgorithmArray = this._algorithms;
        int n = this._algorithms.length;
        int n2 = 0;
        while (n2 < n) {
            CompressionAlgorithm compressionAlgorithm = compressionAlgorithmArray[n2];
            stringBuilder.append(compressionAlgorithm.getSettingsString());
            stringBuilder.append(';');
            ++n2;
        }
        return stringBuilder.toString();
    }

    private void initDialogFromConfig() {
        String string = Config.getConfigString("prune.compression");
        if (string == null || string.isEmpty()) {
            return;
        }
        ParamSet paramSet = new ParamSet(string);
        CompressionAlgorithm[] compressionAlgorithmArray = this._algorithms;
        int n = this._algorithms.length;
        int n2 = 0;
        while (n2 < n) {
            CompressionAlgorithm compressionAlgorithm = compressionAlgorithmArray[n2];
            compressionAlgorithm.applySettingsString(paramSet.getNext());
            ++n2;
        }
    }
}

