/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import org.apiguardian.api.API;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="5.0")
public final class TestInstanceLifecycleUtils {
    private TestInstanceLifecycleUtils() {
    }

    static TestInstance.Lifecycle getTestInstanceLifecycle(Class<?> testClass, JupiterConfiguration configuration) {
        Preconditions.notNull(testClass, (String)"testClass must not be null");
        Preconditions.notNull((Object)configuration, (String)"configuration must not be null");
        return AnnotationUtils.findAnnotation(testClass, TestInstance.class).map(TestInstance::value).orElseGet(configuration::getDefaultTestInstanceLifecycle);
    }
}

