"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EphemeralMatrixRequest = exports.TimelineMatrixRequest = exports.MatrixRequest = void 0;
const request_1 = require("./request");
/**
 * Incoming event from the homeserver.
 */
class MatrixRequest extends request_1.Request {
    constructor(event) {
        super({ data: event }, "MatrixReq");
        this.event = event;
    }
}
exports.MatrixRequest = MatrixRequest;
/**
 * A timeline event, such as a room timeline message.
 */
class TimelineMatrixRequest extends MatrixRequest {
    constructor(event) {
        super(event);
        this.event = event;
    }
    sender() {
        return this.event.sender;
    }
    type() {
        return this.event.type;
    }
    stateKey() {
        return this.event.state_key;
    }
    roomId() {
        return this.event.room_id;
    }
    content() {
        return this.event.content;
    }
}
exports.TimelineMatrixRequest = TimelineMatrixRequest;
/**
 * Ephemeral event, such as a typing notification.
 */
class EphemeralMatrixRequest extends MatrixRequest {
    constructor(event) {
        super(event);
        this.event = event;
    }
    type() {
        return this.event.type;
    }
}
exports.EphemeralMatrixRequest = EphemeralMatrixRequest;
//# sourceMappingURL=matrix-request.js.map