/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.ugraphic.color.ColorChangerMonochrome;
import net.sourceforge.plantuml.ugraphic.color.ColorOrder;
import net.sourceforge.plantuml.ugraphic.color.ColorUtils;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorAbstract;
import net.sourceforge.plantuml.ugraphic.color.HSLColor;

public class HColorSimple
extends HColorAbstract
implements HColor {
    private final Color color;
    private final HColor dark;

    public int hashCode() {
        return this.color.hashCode();
    }

    public String toString() {
        boolean withDark = this != this.dark;
        StringBuilder sb = new StringBuilder();
        if (withDark) {
            sb.append("WITHDARK ");
        }
        sb.append(this.color.toString());
        sb.append(" \u03b1=");
        sb.append(this.color.getAlpha());
        if (this.isTransparent()) {
            sb.append(" transparent");
        }
        return sb.toString();
    }

    @Override
    public String asString() {
        if (this.isTransparent()) {
            return "transparent";
        }
        if (this.color.getAlpha() == 255) {
            return StringUtils.sharp000000(this.color.getRGB());
        }
        return "#" + Integer.toHexString(this.color.getRGB());
    }

    @Override
    public HColor lighten(int ratio) {
        float[] hsl = new HSLColor(this.color).getHSL();
        hsl[2] = (float)((double)hsl[2] + (double)hsl[2] * ((double)ratio / 100.0));
        return new HColorSimple(new HSLColor(hsl).getRGB());
    }

    @Override
    public HColor darken(int ratio) {
        float[] hsl = new HSLColor(this.color).getHSL();
        hsl[2] = (float)((double)hsl[2] - (double)hsl[2] * ((double)ratio / 100.0));
        return new HColorSimple(new HSLColor(hsl).getRGB());
    }

    @Override
    public HColor reverseHsluv() {
        return new HColorSimple(ColorUtils.reverseHsluv(this.color));
    }

    @Override
    public HColor reverse() {
        return new HColorSimple(ColorOrder.RGB.getReverse(this.color));
    }

    @Override
    public boolean isDark() {
        return ColorUtils.getGrayScale(this.color) < 128;
    }

    public boolean isTransparent() {
        return this.color.getAlpha() == 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HColorSimple)) {
            return false;
        }
        return this.color.equals(((HColorSimple)other).color);
    }

    HColorSimple(Color c) {
        this.color = c;
        this.dark = this;
    }

    private HColorSimple(Color c, HColor dark) {
        this.color = c;
        this.dark = dark;
    }

    public Color getColor999() {
        return this.color;
    }

    public HColor asMonochrome() {
        return new HColorSimple(new ColorChangerMonochrome().getChangedColor(this.color));
    }

    public HColor asMonochrome(HColorSimple colorForMonochrome, double minGray, double maxGray) {
        Color tmp = new ColorChangerMonochrome().getChangedColor(this.color);
        int gray = tmp.getGreen();
        assert (gray == tmp.getBlue());
        assert (gray == tmp.getRed());
        double coef = ((double)gray - minGray) / 256.0;
        Color result = ColorUtils.grayToColor(coef, colorForMonochrome.color);
        return new HColorSimple(result);
    }

    @Override
    public HColor opposite() {
        Color mono = new ColorChangerMonochrome().getChangedColor(this.color);
        int grayScale = 255 - mono.getGreen() > 127 ? 255 : 0;
        return new HColorSimple(new Color(grayScale, grayScale, grayScale));
    }

    public int distanceTo(HColorSimple other) {
        return ColorUtils.distance(this.color, other.color);
    }

    public boolean isGray() {
        return this.color.getRed() == this.color.getGreen() && this.color.getGreen() == this.color.getBlue();
    }

    public static HColorSimple unlinear(HColorSimple color1, HColorSimple color2, int completionInt) {
        HSLColor col1 = new HSLColor(color1.color);
        HSLColor col2 = new HSLColor(color2.color);
        float[] hsl1 = col1.getHSL();
        float[] hsl2 = col2.getHSL();
        if (completionInt > 100) {
            completionInt = 100;
        }
        float completion = (float)((double)completionInt / 100.0);
        completion = completion * completion * completion;
        float[] hsl = HColorSimple.linear(completion, hsl1, hsl2);
        HSLColor col = new HSLColor(hsl);
        return new HColorSimple(col.getRGB());
    }

    private static float[] linear(float factor, float[] hsl1, float[] hsl2) {
        float h = HColorSimple.linear(factor, hsl1[0], hsl2[0]);
        float s = HColorSimple.linear(factor, hsl1[1], hsl2[1]);
        float l = HColorSimple.linear(factor, hsl1[2], hsl2[2]);
        return new float[]{h, s, l};
    }

    private static float linear(float factor, float x, float y) {
        return x + (y - x) * factor;
    }

    @Override
    public HColor withDark(HColor dark) {
        return new HColorSimple(this.color, dark);
    }

    @Override
    public HColor darkSchemeTheme() {
        return this.dark;
    }
}

