# Copyright (c) 2022, Riverbank Computing Limited
# All rights reserved.
#
# This copy of SIP is licensed for use under the terms of the SIP License
# Agreement.  See the file LICENSE for more details.
#
# This copy of SIP may also used under the terms of the GNU General Public
# License v2 or v3 as published by the Free Software Foundation which can be
# found in the files LICENSE-GPL2 and LICENSE-GPL3 included in this package.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ('AS IS'
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.


from ..scoped_name import STRIP_GLOBAL, STRIP_NONE

from .scoped import ScopedFormatter
from .signature import SignatureFormatter


class TemplateFormatter(ScopedFormatter):
    """ This creates various string representations of a template. """

    def cpp_type(self, *, scope=None, strip=STRIP_NONE, as_xml=False):
        """ Return the C++ representation of the template type. """

        template = self.object

        s = ''

        if as_xml:
            strip = STRIP_GLOBAL

        s += template.cpp_name.cpp_stripped(strip)

        s += '&lt;' if as_xml else '<'

        s += SignatureFormatter(self.spec, template.types).cpp_arguments(
                strip=strip, as_xml=as_xml)

        if as_xml:
            s += '&gt;'
        else:
            if s.endswith('>'):
                s += ' '

            s += '>'

        return s
