/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.optimizations;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ELInterpreter;
import org.apache.jasper.compiler.JspUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ELInterpreterTagSetters
implements ELInterpreter {
    private final Log log = LogFactory.getLog(ELInterpreterTagSetters.class);
    private final Pattern PATTERN_BOOLEAN = Pattern.compile("[$][{]([\"']?)(true|false)\\1[}]");
    private final Pattern PATTERN_STRING_CONSTANT = Pattern.compile("[$][{]([\"'])(\\w+)\\1[}]");
    private final Pattern PATTERN_NUMERIC = Pattern.compile("[$][{]([\"'])([+-]?\\d+(\\.\\d+)?)\\1[}]");

    @Override
    public String interpreterCall(JspCompilationContext jspCompilationContext, boolean bl, String string, Class<?> clazz, String string2) {
        Object object;
        block66: {
            Matcher matcher;
            object = null;
            if (Boolean.TYPE == clazz) {
                Matcher matcher2 = this.PATTERN_BOOLEAN.matcher(string);
                if (matcher2.matches()) {
                    object = matcher2.group(2);
                }
            } else if (Boolean.class == clazz) {
                Matcher matcher3 = this.PATTERN_BOOLEAN.matcher(string);
                if (matcher3.matches()) {
                    object = "true".equals(matcher3.group(2)) ? "Boolean.TRUE" : "Boolean.FALSE";
                }
            } else if (Character.TYPE == clazz) {
                Matcher matcher4 = this.PATTERN_STRING_CONSTANT.matcher(string);
                if (matcher4.matches()) {
                    return "'" + matcher4.group(2).charAt(0) + "'";
                }
            } else if (Character.class == clazz) {
                Matcher matcher5 = this.PATTERN_STRING_CONSTANT.matcher(string);
                if (matcher5.matches()) {
                    return "Character.valueOf('" + matcher5.group(2).charAt(0) + "')";
                }
            } else if (BigDecimal.class == clazz) {
                Matcher matcher6 = this.PATTERN_NUMERIC.matcher(string);
                if (matcher6.matches()) {
                    try {
                        BigDecimal bigDecimal = new BigDecimal(matcher6.group(2));
                        object = "new java.math.BigDecimal(\"" + matcher6.group(2) + "\")";
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.debug((Object)("Failed to convert [" + matcher6.group(2) + "] to BigDecimal"), (Throwable)numberFormatException);
                    }
                }
            } else if (Long.TYPE == clazz || Long.class == clazz) {
                Matcher matcher7 = this.PATTERN_NUMERIC.matcher(string);
                if (matcher7.matches()) {
                    try {
                        Long l = Long.valueOf(matcher7.group(2));
                        if (clazz.isPrimitive()) {
                            object = matcher7.group(2) + "L";
                            break block66;
                        }
                        object = "Long.valueOf(\"" + matcher7.group(2) + "\")";
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.debug((Object)("Failed to convert [" + matcher7.group(2) + "] to Long"), (Throwable)numberFormatException);
                    }
                }
            } else if (Integer.TYPE == clazz || Integer.class == clazz) {
                Matcher matcher8 = this.PATTERN_NUMERIC.matcher(string);
                if (matcher8.matches()) {
                    try {
                        Integer n = Integer.valueOf(matcher8.group(2));
                        if (clazz.isPrimitive()) {
                            object = matcher8.group(2);
                            break block66;
                        }
                        object = "Integer.valueOf(\"" + matcher8.group(2) + "\")";
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.debug((Object)("Failed to convert [" + matcher8.group(2) + "] to Integer"), (Throwable)numberFormatException);
                    }
                }
            } else if (Short.TYPE == clazz || Short.class == clazz) {
                Matcher matcher9 = this.PATTERN_NUMERIC.matcher(string);
                if (matcher9.matches()) {
                    try {
                        Short s = Short.valueOf(matcher9.group(2));
                        if (clazz.isPrimitive()) {
                            object = "(short) " + matcher9.group(2);
                            break block66;
                        }
                        object = "Short.valueOf(\"" + matcher9.group(2) + "\")";
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.debug((Object)("Failed to convert [" + matcher9.group(2) + "] to Short"), (Throwable)numberFormatException);
                    }
                }
            } else if (Byte.TYPE == clazz || Byte.class == clazz) {
                Matcher matcher10 = this.PATTERN_NUMERIC.matcher(string);
                if (matcher10.matches()) {
                    try {
                        Byte by = Byte.valueOf(matcher10.group(2));
                        if (clazz.isPrimitive()) {
                            object = "(byte) " + matcher10.group(2);
                            break block66;
                        }
                        object = "Byte.valueOf(\"" + matcher10.group(2) + "\")";
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.debug((Object)("Failed to convert [" + matcher10.group(2) + "] to Byte"), (Throwable)numberFormatException);
                    }
                }
            } else if (Double.TYPE == clazz || Double.class == clazz) {
                Matcher matcher11 = this.PATTERN_NUMERIC.matcher(string);
                if (matcher11.matches()) {
                    try {
                        Double d = Double.valueOf(matcher11.group(2));
                        if (clazz.isPrimitive()) {
                            object = matcher11.group(2);
                            break block66;
                        }
                        object = "Double.valueOf(\"" + matcher11.group(2) + "\")";
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.debug((Object)("Failed to convert [" + matcher11.group(2) + "] to Double"), (Throwable)numberFormatException);
                    }
                }
            } else if (Float.TYPE == clazz || Float.class == clazz) {
                Matcher matcher12 = this.PATTERN_NUMERIC.matcher(string);
                if (matcher12.matches()) {
                    try {
                        Float f = Float.valueOf(matcher12.group(2));
                        if (clazz.isPrimitive()) {
                            object = matcher12.group(2) + "f";
                            break block66;
                        }
                        object = "Float.valueOf(\"" + matcher12.group(2) + "\")";
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.debug((Object)("Failed to convert [" + matcher12.group(2) + "] to Float"), (Throwable)numberFormatException);
                    }
                }
            } else if (BigInteger.class == clazz) {
                Matcher matcher13 = this.PATTERN_NUMERIC.matcher(string);
                if (matcher13.matches()) {
                    try {
                        BigInteger bigInteger = new BigInteger(matcher13.group(2));
                        object = "new java.math.BigInteger(\"" + matcher13.group(2) + "\")";
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log.debug((Object)("Failed to convert [" + matcher13.group(2) + "] to BigInteger"), (Throwable)numberFormatException);
                    }
                }
            } else if (clazz.isEnum()) {
                Matcher matcher14 = this.PATTERN_STRING_CONSTANT.matcher(string);
                if (matcher14.matches()) {
                    try {
                        Object obj = Enum.valueOf(clazz, matcher14.group(2));
                        object = clazz.getName() + "." + ((Enum)obj).name();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.log.debug((Object)("Failed to convert [" + matcher14.group(2) + "] to Enum type [" + clazz.getName() + "]"), (Throwable)illegalArgumentException);
                    }
                }
            } else if (String.class == clazz && (matcher = this.PATTERN_STRING_CONSTANT.matcher(string)).matches()) {
                object = "\"" + matcher.group(2) + "\"";
            }
        }
        if (object == null) {
            object = JspUtil.interpreterCall(bl, string, clazz, string2);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Expression [" + string + "], type [" + clazz.getName() + "], returns [" + (String)object + "]"));
        }
        return object;
    }
}

