/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.ObjectPool;

public class PoolingDriver
implements Driver {
    private static final DriverPropertyInfo[] EMPTY_DRIVER_PROPERTY_INFO_ARRAY = new DriverPropertyInfo[0];
    protected static final HashMap<String, ObjectPool<? extends Connection>> pools;
    public static final String URL_PREFIX = "jdbc:apache:commons:dbcp:";
    protected static final int URL_PREFIX_LEN;
    protected static final int MAJOR_VERSION = 1;
    protected static final int MINOR_VERSION = 0;
    private final boolean accessToUnderlyingConnectionAllowed;

    public PoolingDriver() {
        this(true);
    }

    protected PoolingDriver(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return string != null && string.startsWith(URL_PREFIX);
    }

    public synchronized void closePool(String string) throws SQLException {
        ObjectPool<? extends Connection> objectPool = pools.get(string);
        if (objectPool != null) {
            pools.remove(string);
            try {
                objectPool.close();
            }
            catch (Exception exception) {
                throw new SQLException("Error closing pool " + string, exception);
            }
        }
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        if (this.acceptsURL(string)) {
            ObjectPool<? extends Connection> objectPool = this.getConnectionPool(string.substring(URL_PREFIX_LEN));
            try {
                Connection connection = objectPool.borrowObject();
                if (connection == null) {
                    return null;
                }
                return new PoolGuardConnectionWrapper(objectPool, connection);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SQLException("Cannot get a connection, pool error: " + noSuchElementException.getMessage(), noSuchElementException);
            }
            catch (RuntimeException | SQLException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new SQLException("Cannot get a connection, general error: " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    public synchronized ObjectPool<? extends Connection> getConnectionPool(String string) throws SQLException {
        ObjectPool<? extends Connection> objectPool = pools.get(string);
        if (null == objectPool) {
            throw new SQLException("Pool not registered: " + string);
        }
        return objectPool;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public synchronized String[] getPoolNames() {
        return pools.keySet().toArray(Utils.EMPTY_STRING_ARRAY);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return EMPTY_DRIVER_PROPERTY_INFO_ARRAY;
    }

    public void invalidateConnection(Connection connection) throws SQLException {
        if (!(connection instanceof PoolGuardConnectionWrapper)) {
            throw new SQLException("Invalid connection class");
        }
        PoolGuardConnectionWrapper poolGuardConnectionWrapper = (PoolGuardConnectionWrapper)connection;
        ObjectPool objectPool = poolGuardConnectionWrapper.pool;
        try {
            objectPool.invalidateObject(poolGuardConnectionWrapper.getDelegateInternal());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public synchronized void registerPool(String string, ObjectPool<? extends Connection> objectPool) {
        pools.put(string, objectPool);
    }

    static {
        try {
            DriverManager.registerDriver(new PoolingDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        pools = new HashMap();
        URL_PREFIX_LEN = URL_PREFIX.length();
    }

    private class PoolGuardConnectionWrapper
    extends DelegatingConnection<Connection> {
        private final ObjectPool<? extends Connection> pool;

        PoolGuardConnectionWrapper(ObjectPool<? extends Connection> objectPool, Connection connection) {
            super(connection);
            this.pool = objectPool;
        }

        @Override
        public Connection getDelegate() {
            if (PoolingDriver.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        @Override
        public Connection getInnermostDelegate() {
            if (PoolingDriver.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

