/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.res.StringManager;

public final class Parameters {
    private static final Log log = LogFactory.getLog(Parameters.class);
    private static final UserDataHelper userDataLog = new UserDataHelper(log);
    private static final UserDataHelper maxParamCountLog = new UserDataHelper(log);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.http");
    private final Map<String, ArrayList<String>> paramHashValues = new LinkedHashMap<String, ArrayList<String>>();
    private boolean didQueryParameters = false;
    private MessageBytes queryMB;
    private UDecoder urlDec;
    private final MessageBytes decodedQuery = MessageBytes.newInstance();
    private Charset charset = StandardCharsets.ISO_8859_1;
    private Charset queryStringCharset = StandardCharsets.UTF_8;
    private int limit = -1;
    private int parameterCount = 0;
    private FailReason parseFailedReason = null;
    private final ByteChunk tmpName = new ByteChunk();
    private final ByteChunk tmpValue = new ByteChunk();
    private final ByteChunk origName = new ByteChunk();
    private final ByteChunk origValue = new ByteChunk();
    private static final Charset DEFAULT_BODY_CHARSET = StandardCharsets.ISO_8859_1;
    private static final Charset DEFAULT_URI_CHARSET = StandardCharsets.UTF_8;

    public void setQuery(MessageBytes messageBytes) {
        this.queryMB = messageBytes;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset == null) {
            charset = DEFAULT_BODY_CHARSET;
        }
        this.charset = charset;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set encoding to " + charset.name()));
        }
    }

    public void setQueryStringCharset(Charset charset) {
        if (charset == null) {
            charset = DEFAULT_URI_CHARSET;
        }
        this.queryStringCharset = charset;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set query string encoding to " + charset.name()));
        }
    }

    public boolean isParseFailed() {
        return this.parseFailedReason != null;
    }

    public FailReason getParseFailedReason() {
        return this.parseFailedReason;
    }

    public void setParseFailedReason(FailReason failReason) {
        if (this.parseFailedReason == null) {
            this.parseFailedReason = failReason;
        }
    }

    public void recycle() {
        this.parameterCount = 0;
        this.paramHashValues.clear();
        this.didQueryParameters = false;
        this.charset = DEFAULT_BODY_CHARSET;
        this.decodedQuery.recycle();
        this.parseFailedReason = null;
    }

    public String[] getParameterValues(String string) {
        this.handleQueryParameters();
        ArrayList<String> arrayList = this.paramHashValues.get(string);
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    public Enumeration<String> getParameterNames() {
        this.handleQueryParameters();
        return Collections.enumeration(this.paramHashValues.keySet());
    }

    public String getParameter(String string) {
        this.handleQueryParameters();
        ArrayList<String> arrayList = this.paramHashValues.get(string);
        if (arrayList != null) {
            if (arrayList.size() == 0) {
                return "";
            }
            return arrayList.get(0);
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryMB == null || this.queryMB.isNull()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decoding query " + this.decodedQuery + " " + this.queryStringCharset.name()));
        }
        try {
            this.decodedQuery.duplicate(this.queryMB);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.processParameters(this.decodedQuery, this.queryStringCharset);
    }

    public void addParameter(String string, String string2) throws IllegalStateException {
        if (string == null) {
            return;
        }
        ++this.parameterCount;
        if (this.limit > -1 && this.parameterCount > this.limit) {
            this.setParseFailedReason(FailReason.TOO_MANY_PARAMETERS);
            throw new IllegalStateException(sm.getString("parameters.maxCountFail", new Object[]{this.limit}));
        }
        ArrayList<String> arrayList = this.paramHashValues.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList(1);
            this.paramHashValues.put(string, arrayList);
        }
        arrayList.add(string2);
    }

    public void setURLDecoder(UDecoder uDecoder) {
        this.urlDec = uDecoder;
    }

    public void processParameters(byte[] byArray, int n, int n2) {
        this.processParameters(byArray, n, n2, this.charset);
    }

    private void processParameters(byte[] byArray, int n, int n2, Charset charset) {
        UserDataHelper.Mode mode;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("parameters.bytes", new Object[]{new String(byArray, n, n2, DEFAULT_BODY_CHARSET)}));
        }
        int n3 = 0;
        int n4 = n;
        int n5 = n + n2;
        while (n4 < n5) {
            block58: {
                String string;
                Object object;
                Object object2;
                int n6 = n4;
                int n7 = -1;
                int n8 = -1;
                int n9 = -1;
                boolean bl = true;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                do {
                    switch (byArray[n4]) {
                        case 61: {
                            if (bl) {
                                n7 = n4++;
                                bl = false;
                                n8 = n4;
                                break;
                            }
                            ++n4;
                            break;
                        }
                        case 38: {
                            if (bl) {
                                n7 = n4;
                            } else {
                                n9 = n4;
                            }
                            bl4 = true;
                            ++n4;
                            break;
                        }
                        case 37: 
                        case 43: {
                            if (bl) {
                                bl2 = true;
                            } else {
                                bl3 = true;
                            }
                            ++n4;
                            break;
                        }
                        default: {
                            ++n4;
                        }
                    }
                } while (!bl4 && n4 < n5);
                if (n4 == n5) {
                    if (n7 == -1) {
                        n7 = n4;
                    } else if (n8 > -1 && n9 == -1) {
                        n9 = n4;
                    }
                }
                if (log.isDebugEnabled() && n8 == -1) {
                    log.debug((Object)sm.getString("parameters.noequal", new Object[]{n6, n7, new String(byArray, n6, n7 - n6, DEFAULT_BODY_CHARSET)}));
                }
                if (n7 <= n6) {
                    if (n8 == -1) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)sm.getString("parameters.emptyChunk"));
                        continue;
                    }
                    object2 = userDataLog.getNextMode();
                    if (object2 != null) {
                        object = n9 > n6 ? new String(byArray, n6, n9 - n6, DEFAULT_BODY_CHARSET) : "";
                        string = sm.getString("parameters.invalidChunk", new Object[]{n6, n9, object});
                        switch (object2) {
                            case INFO_THEN_DEBUG: {
                                string = string + sm.getString("parameters.fallToDebug");
                            }
                            case INFO: {
                                log.info((Object)string);
                                break;
                            }
                            case DEBUG: {
                                log.debug((Object)string);
                            }
                        }
                    }
                    this.setParseFailedReason(FailReason.NO_NAME);
                    continue;
                }
                this.tmpName.setBytes(byArray, n6, n7 - n6);
                if (n8 >= 0) {
                    this.tmpValue.setBytes(byArray, n8, n9 - n8);
                } else {
                    this.tmpValue.setBytes(byArray, 0, 0);
                }
                if (log.isDebugEnabled()) {
                    try {
                        this.origName.append(byArray, n6, n7 - n6);
                        if (n8 >= 0) {
                            this.origValue.append(byArray, n8, n9 - n8);
                        } else {
                            this.origValue.append(byArray, 0, 0);
                        }
                    }
                    catch (IOException iOException) {
                        log.error((Object)sm.getString("parameters.copyFail"), (Throwable)iOException);
                    }
                }
                try {
                    if (bl2) {
                        this.urlDecode(this.tmpName);
                    }
                    this.tmpName.setCharset(charset);
                    object2 = this.tmpName.toString();
                    if (n8 >= 0) {
                        if (bl3) {
                            this.urlDecode(this.tmpValue);
                        }
                        this.tmpValue.setCharset(charset);
                        object = this.tmpValue.toString();
                    } else {
                        object = "";
                    }
                    try {
                        this.addParameter((String)object2, (String)object);
                    }
                    catch (IllegalStateException illegalStateException) {
                        UserDataHelper.Mode mode2 = maxParamCountLog.getNextMode();
                        if (mode2 == null) break;
                        String string2 = illegalStateException.getMessage();
                        switch (mode2) {
                            case INFO_THEN_DEBUG: {
                                string2 = string2 + sm.getString("parameters.maxCountFail.fallToDebug");
                            }
                            case INFO: {
                                log.info((Object)string2);
                                break;
                            }
                            case DEBUG: {
                                log.debug((Object)string2);
                            }
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    this.setParseFailedReason(FailReason.URL_DECODING);
                    if (++n3 != 1 && !log.isDebugEnabled()) break block58;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("parameters.decodeFail.debug", new Object[]{this.origName.toString(), this.origValue.toString()}), (Throwable)iOException);
                    }
                    if (!log.isInfoEnabled() || (object = userDataLog.getNextMode()) == null) break block58;
                    string = sm.getString("parameters.decodeFail.info", new Object[]{this.tmpName.toString(), this.tmpValue.toString()});
                    switch (1.$SwitchMap$org$apache$tomcat$util$log$UserDataHelper$Mode[((Enum)object).ordinal()]) {
                        case 1: {
                            string = string + sm.getString("parameters.fallToDebug");
                        }
                        case 2: {
                            log.info((Object)string);
                            break;
                        }
                        case 3: {
                            log.debug((Object)string);
                        }
                    }
                }
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
            if (!log.isDebugEnabled()) continue;
            this.origName.recycle();
            this.origValue.recycle();
        }
        if (n3 > 1 && !log.isDebugEnabled() && (mode = userDataLog.getNextMode()) != null) {
            String string = sm.getString("parameters.multipleDecodingFail", new Object[]{n3});
            switch (mode) {
                case INFO_THEN_DEBUG: {
                    string = string + sm.getString("parameters.fallToDebug");
                }
                case INFO: {
                    log.info((Object)string);
                    break;
                }
                case DEBUG: {
                    log.debug((Object)string);
                }
            }
        }
    }

    private void urlDecode(ByteChunk byteChunk) throws IOException {
        if (this.urlDec == null) {
            this.urlDec = new UDecoder();
        }
        this.urlDec.convert(byteChunk, true);
    }

    public void processParameters(MessageBytes messageBytes, Charset charset) {
        if (messageBytes == null || messageBytes.isNull() || messageBytes.getLength() <= 0) {
            return;
        }
        if (messageBytes.getType() != 2) {
            messageBytes.toBytes();
        }
        ByteChunk byteChunk = messageBytes.getByteChunk();
        this.processParameters(byteChunk.getBytes(), byteChunk.getOffset(), byteChunk.getLength(), charset);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, ArrayList<String>> entry : this.paramHashValues.entrySet()) {
            stringBuilder.append(entry.getKey()).append('=');
            StringUtils.join((Iterable)entry.getValue(), (char)',', (StringBuilder)stringBuilder);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static enum FailReason {
        CLIENT_DISCONNECT,
        MULTIPART_CONFIG_INVALID,
        INVALID_CONTENT_TYPE,
        IO_ERROR,
        NO_NAME,
        POST_TOO_LARGE,
        REQUEST_BODY_INCOMPLETE,
        TOO_MANY_PARAMETERS,
        UNKNOWN,
        URL_DECODING;

    }
}

