/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler;

import java.util.Timer;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.openide.util.NbBundle;

public abstract class AbstractSamplerSupport {
    public abstract DataViewComponent.DetailsView[] getDetailsView();

    public abstract boolean startSampling(ProfilingSettings var1, int var2, int var3);

    public abstract void takeSnapshot(boolean var1);

    public abstract void stopSampling();

    public abstract void terminate();

    protected abstract Timer getTimer();

    protected final void checkCPUSamplingRate(int samplingRate) {
        if (samplingRate < 20) {
            ProfilerDialogs.displayWarningDNSA((String)NbBundle.getMessage(AbstractSamplerSupport.class, (String)"MSG_High_Sampling_Frequency"), (String)NbBundle.getMessage(AbstractSamplerSupport.class, (String)"CAP_High_Sampling_Frequency"), null, (String)"org.graalvm.visualvm.sampler.AbstractSamplerSupport.checkCPUSamplingRate", (boolean)false);
        }
    }

    public static abstract class Refresher {
        private static final long REFRESH_THRESHOLD = 100L;
        private long lastRefresh;

        public final synchronized void refresh() {
            long currentTime;
            if (this.checkRefresh() && (currentTime = System.currentTimeMillis()) - this.lastRefresh >= 100L) {
                this.lastRefresh = currentTime;
                this.doRefresh();
            }
        }

        public abstract void setRefreshRate(int var1);

        public abstract int getRefreshRate();

        protected abstract boolean checkRefresh();

        protected abstract void doRefresh();
    }
}

