/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.python;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.Type;
import org.graalvm.visualvm.lib.jfluid.heap.Value;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

class PythonObject
extends TruffleObject.InstanceBased {
    static final String PYTHON_OBJECT_FQN = "com.oracle.graal.python.builtins.objects.object.PythonObject";
    static final String PYTHON_LIST_FQN = "com.oracle.graal.python.builtins.objects.list.PList";
    static final String TREEMAP_ENTRY_FQN = "java.util.TreeMap$Entry";
    static final String TREEMAP_FQN = "java.util.TreeMap";
    private final Instance instance;
    private final Instance storage;
    private final Instance store;
    private final Instance dictStorage;
    private final ObjectArrayInstance array;
    private final Instance map;
    private final Instance set;
    private final Instance pythonClass;
    private String listType;
    private boolean isPrimitiveList;
    private String type;

    PythonObject(Instance instance) {
        this(null, instance);
    }

    PythonObject(String type, Instance instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        this.instance = instance;
        this.type = type;
        Object[] values = HeapUtils.getValuesOfFields((Instance)instance, (String[])new String[]{"storage", "pythonClass", "storedPythonClass", "initialPythonClass", "store", "array", "map", "set", "dictStorage"});
        this.storage = PythonObject.computeStorage((Instance)values[0], instance);
        this.pythonClass = PythonObject.computePythonClass((Instance)values[1], (Instance)values[2], (Instance)values[3], this.storage);
        this.store = (Instance)values[4];
        this.array = (ObjectArrayInstance)values[5];
        this.map = (Instance)values[6];
        this.set = (Instance)values[7];
        this.dictStorage = (Instance)values[8];
    }

    private static Instance computeStorage(Instance storage, Instance pythonInstance) {
        if (storage != null) {
            return storage;
        }
        if (DynamicObject.isDynamicObject(pythonInstance)) {
            return pythonInstance;
        }
        return null;
    }

    private static Instance computePythonClass(Instance pythonClass, Instance storedPythonClass, Instance initialPythonClass, Instance storage) {
        Object lazyPythonClass;
        Object objectType;
        Object shape;
        if (pythonClass != null) {
            return pythonClass;
        }
        if (storedPythonClass != null) {
            return storedPythonClass;
        }
        if (initialPythonClass != null) {
            return initialPythonClass;
        }
        if (storage != null && (shape = storage.getValueOfField("shape")) instanceof Instance && (objectType = ((Instance)shape).getValueOfField("objectType")) instanceof Instance && (lazyPythonClass = ((Instance)objectType).getValueOfField("lazyPythonClass")) instanceof Instance) {
            return (Instance)lazyPythonClass;
        }
        return null;
    }

    static boolean isPythonObject(Instance rObj) {
        return PythonObject.isSubClassOf(rObj, PYTHON_OBJECT_FQN);
    }

    List<FieldValue> getItems() {
        if (this.store != null || this.array != null) {
            return this.getListFields();
        }
        return Collections.EMPTY_LIST;
    }

    List<FieldValue> getAttributes() {
        if (this.map != null) {
            return this.getMapFields();
        }
        if (this.set != null) {
            return this.getSetFields();
        }
        if (this.dictStorage != null) {
            return this.getDictFields();
        }
        return new DynamicObject(this.storage).getFieldValues();
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public String getType() {
        if (this.type == null) {
            String string = this.type = this.pythonClass == null ? null : DetailsUtils.getInstanceString((Instance)this.pythonClass);
            if (this.type == null) {
                this.type = "<unknown type>";
            }
        }
        return this.type;
    }

    @Override
    public long getTypeId() {
        return this.pythonClass == null ? Long.MIN_VALUE : this.pythonClass.getInstanceId();
    }

    @Override
    public long getSize() {
        long size = this.instance.getSize();
        if (this.storage != null) {
            size += this.storage.getSize();
        }
        if (this.store != null) {
            size += this.store.getSize();
        }
        if (this.array != null) {
            size += this.array.getSize();
        }
        return size;
    }

    @Override
    public long getRetainedSize() {
        return this.instance.getRetainedSize();
    }

    List<FieldValue> getReferences() {
        List refs = this.instance.getReferences();
        ArrayList<FieldValue> robjRefs = new ArrayList<FieldValue>();
        for (Value ref : refs) {
            Instance defInstance = ref.getDefiningInstance();
            if (ref instanceof ArrayItemValue && defInstance instanceof ObjectArrayInstance) {
                List arrRefs = defInstance.getReferences();
                for (Value arrRef : arrRefs) {
                    Instance pInstance = arrRef.getDefiningInstance();
                    if (PythonObject.isPythonObject(pInstance)) {
                        this.addItem(pInstance, ref, robjRefs);
                    } else {
                        Instance store = this.getReference(pInstance, PYTHON_OBJECT_FQN, "store");
                        if (PythonObject.isPythonObject(store)) {
                            this.addItem(store, ref, robjRefs);
                        }
                    }
                    this.addAttribute(pInstance, robjRefs);
                }
            }
            if (defInstance != null && defInstance.getJavaClass().getName().equals(TREEMAP_ENTRY_FQN)) {
                FieldValue rootReference = this.findRootPMap(defInstance);
                robjRefs.add(rootReference);
            }
            this.addAttribute(defInstance, robjRefs);
        }
        return robjRefs;
    }

    private void addItem(Instance pInstance, Value ref, List<FieldValue> robjRefs) {
        ObjectFieldValue ofv;
        FieldValue fv;
        List<FieldValue> items;
        PythonObject pobject = new PythonObject(pInstance);
        int index = ((ArrayItemValue)ref).getIndex();
        if (index < (items = pobject.getItems()).size() && (fv = items.get(index)) instanceof ObjectFieldValue && this.instance.equals((ofv = (ObjectFieldValue)fv).getInstance())) {
            robjRefs.add(fv);
        }
    }

    private FieldValue findRootPMap(Instance mapEntry) {
        Instance parent = this.getParentTreeEntry(mapEntry);
        while (parent != null) {
            mapEntry = parent;
            parent = this.getParentTreeEntry(parent);
        }
        Instance treeMap = this.getReference(mapEntry, TREEMAP_FQN, "root");
        Instance pythonObject = this.getReference(treeMap, PYTHON_OBJECT_FQN, "map");
        if (PythonObject.isPythonObject(pythonObject)) {
            for (FieldValue fv : new PythonObject(pythonObject).getAttributes()) {
                ObjectFieldValue ofv;
                if (!(fv instanceof ObjectFieldValue) || !this.instance.equals((ofv = (ObjectFieldValue)fv).getInstance())) continue;
                return fv;
            }
        }
        return null;
    }

    private Instance getParentTreeEntry(Instance treeEntry) {
        return (Instance)treeEntry.getValueOfField("parent");
    }

    private Instance getReference(Instance instance, String definingClass, String fieldName) {
        if (instance == null) {
            return null;
        }
        List refs = instance.getReferences();
        for (Value ref : refs) {
            if (!(ref instanceof ObjectFieldValue)) continue;
            ObjectFieldValue fval = (ObjectFieldValue)ref;
            Instance parent = fval.getDefiningInstance();
            if (!fval.getField().getName().equals(fieldName) || !PythonObject.isSubClassOf(parent, definingClass)) continue;
            return parent;
        }
        return null;
    }

    private void addAttribute(Instance dynObjInstance, List<FieldValue> robjRefs) {
        if (DynamicObject.isDynamicObject(dynObjInstance)) {
            if (PythonObject.isPythonObject(dynObjInstance)) {
                this.findAndAddAttribute(dynObjInstance, dynObjInstance, robjRefs);
            } else {
                List refs = dynObjInstance.getReferences();
                for (Value ref : refs) {
                    Instance defInstance = ref.getDefiningInstance();
                    if (!PythonObject.isPythonObject(defInstance)) continue;
                    this.findAndAddAttribute(defInstance, dynObjInstance, robjRefs);
                }
            }
        }
    }

    private void findAndAddAttribute(Instance defInstance, Instance dynObjInstance, List<FieldValue> robjRefs) {
        PythonObject pobject = new PythonObject(defInstance);
        if (pobject.storage.equals(dynObjInstance)) {
            for (FieldValue fv : pobject.getAttributes()) {
                ObjectFieldValue ofv;
                if (!(fv instanceof ObjectFieldValue) || !(ofv = (ObjectFieldValue)fv).getInstance().equals(this.instance)) continue;
                robjRefs.add(fv);
            }
        }
    }

    private List getValues() {
        Instance vals = null;
        if (this.store != null) {
            vals = (Instance)this.store.getValueOfField("values");
        }
        if (this.array != null) {
            vals = this.array;
        }
        if (vals != null) {
            this.listType = vals.getJavaClass().getName().replace("[]", "");
            if (vals instanceof ObjectArrayInstance) {
                return ((ObjectArrayInstance)vals).getValues();
            }
            if (vals instanceof PrimitiveArrayInstance) {
                this.isPrimitiveList = true;
                return ((PrimitiveArrayInstance)vals).getValues();
            }
        }
        return Collections.emptyList();
    }

    private int getLength() {
        if (this.store != null) {
            Integer len = (Integer)this.store.getValueOfField("length");
            if (len != null) {
                return len;
            }
            return 0;
        }
        if (this.array != null) {
            return this.array.getLength();
        }
        return 0;
    }

    private static boolean isSubClassOf(Instance i, String superClassName) {
        if (i != null) {
            for (JavaClass superCls = i.getJavaClass(); superCls != null; superCls = superCls.getSuperClass()) {
                if (!superCls.getName().equals(superClassName)) continue;
                return true;
            }
        }
        return false;
    }

    private List<FieldValue> getListFields() {
        return new LazyFieldValues(this.getValues());
    }

    private List<FieldValue> getMapFields() {
        return this.getEntriesFromTreeMap(false, this.map);
    }

    private List<FieldValue> getDictFields() {
        Instance fastStore = (Instance)this.dictStorage.getValueOfField("store");
        if (DynamicObject.isDynamicObject(fastStore)) {
            return new DynamicObject(fastStore).getFieldValues();
        }
        Instance keywords = (Instance)this.dictStorage.getValueOfField("keywords");
        if (keywords instanceof ObjectArrayInstance) {
            return this.getEntriesFromKeywords((ObjectArrayInstance)keywords);
        }
        return this.getEntriesFromEconomicMapStorage(false, this.dictStorage);
    }

    private List<FieldValue> getSetFields() {
        Instance m = (Instance)this.set.getValueOfField("m");
        if (m != null) {
            return this.getEntriesFromTreeMap(true, m);
        }
        return this.getEntriesFromEconomicMapStorage(true, this.set);
    }

    private List<FieldValue> getEntriesFromKeywords(ObjectArrayInstance keywords) {
        ArrayList<FieldValue> fields = new ArrayList<FieldValue>();
        for (Instance keyword : keywords.getValues()) {
            if (keyword == null) continue;
            fields.add((FieldValue)new PythonKeywordEntryFieldValue(false, keyword));
        }
        return fields;
    }

    private List<FieldValue> getEntriesFromEconomicMapStorage(boolean isSet, Instance economicMapStorage) {
        ArrayList<FieldValue> fields = new ArrayList<FieldValue>();
        Instance entries = (Instance)economicMapStorage.getValueOfField("entries");
        if (entries instanceof ObjectArrayInstance) {
            ObjectArrayInstance entriesArr = (ObjectArrayInstance)entries;
            String mapClassName = economicMapStorage.getJavaClass().getName();
            int size = entriesArr.getLength();
            List entriesList = entriesArr.getValues();
            for (int i = 0; i < size; i += 2) {
                Instance ival;
                Instance linkValue;
                Instance key = (Instance)entriesList.get(i);
                Instance value = (Instance)entriesList.get(i + 1);
                if (key == null) continue;
                if (isSet) {
                    fields.add((FieldValue)new PythonEconomicEntryFieldValue(key));
                    continue;
                }
                if (value != null && value instanceof Instance && (linkValue = (Instance)(ival = value).getValueOfField("value")) != null && ival.getJavaClass().getName().startsWith(mapClassName)) {
                    value = linkValue;
                }
                fields.add((FieldValue)new PythonEconomicEntryFieldValue(key, value));
            }
        }
        return fields;
    }

    private List<FieldValue> getEntriesFromTreeMap(boolean isSet, Instance treeMap) {
        ArrayList<FieldValue> fields = new ArrayList<FieldValue>();
        Instance rootEntry = (Instance)treeMap.getValueOfField("root");
        this.getEntries(isSet, rootEntry, fields);
        return fields;
    }

    private void getEntries(boolean isSet, Instance entry, List fields) {
        if (entry != null) {
            this.getEntries(isSet, (Instance)entry.getValueOfField("left"), fields);
            fields.add(new PythonMapEntryFieldValue(isSet, entry));
            this.getEntries(isSet, (Instance)entry.getValueOfField("right"), fields);
        }
    }

    private class LazyFieldValues
    extends AbstractList<FieldValue> {
        List values;

        private LazyFieldValues(List vals) {
            this.values = vals;
        }

        @Override
        public FieldValue get(int index) {
            if (PythonObject.this.isPrimitiveList) {
                return new PythonFieldValue(index, this.values.get(index));
            }
            return new PythonObjectFieldValue(index, (Instance)this.values.get(index));
        }

        @Override
        public int size() {
            return PythonObject.this.getLength();
        }
    }

    private static class PFieldType
    implements Type {
        private final String name;

        PFieldType(String n) {
            this.name = n;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PFieldType) {
                return this.getName().equals(((PFieldType)obj).getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }

    private class PythonField
    implements Field {
        private int index;

        private PythonField(int i) {
            this.index = i;
        }

        public JavaClass getDeclaringClass() {
            return PythonObject.this.instance.getJavaClass();
        }

        public String getName() {
            return "[" + this.index + "]";
        }

        public boolean isStatic() {
            return false;
        }

        public Type getType() {
            return new PFieldType(PythonObject.this.listType);
        }
    }

    private class PythonObjectFieldValue
    extends PythonFieldValue
    implements ObjectFieldValue {
        private PythonObjectFieldValue(int i, Instance val) {
            super(i, val);
        }

        @Override
        public String getValue() {
            return String.valueOf(this.getInstance().getInstanceId());
        }

        public Instance getInstance() {
            return (Instance)this.value;
        }
    }

    private class PythonFieldValue
    implements FieldValue {
        private int index;
        Object value;

        private PythonFieldValue(int i, Object val) {
            this.index = i;
            this.value = val;
        }

        public Field getField() {
            return new PythonField(this.index);
        }

        public String getValue() {
            return (String)this.value;
        }

        public Instance getDefiningInstance() {
            return PythonObject.this.instance;
        }
    }

    private class PythonMapEntryField
    extends PythonField {
        String name;

        private PythonMapEntryField(String n) {
            super(0);
            this.name = n;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private abstract class AbstractPythonMapEntryFieldValue
    implements ObjectFieldValue {
        boolean isSet;

        private AbstractPythonMapEntryFieldValue(boolean set) {
            this.isSet = set;
        }

        abstract Instance getEntryKey();

        abstract Instance getEntryValue();

        public Instance getInstance() {
            if (this.isSet) {
                return this.getEntryKey();
            }
            return this.getEntryValue();
        }

        public Field getField() {
            if (this.isSet) {
                return new PythonMapEntryField("item");
            }
            Instance key = this.getEntryKey();
            String name = DetailsUtils.getInstanceString((Instance)key);
            return new PythonMapEntryField(name);
        }

        public String getValue() {
            return String.valueOf(this.getInstance().getInstanceId());
        }

        public Instance getDefiningInstance() {
            return PythonObject.this.instance;
        }
    }

    private class PythonMapEntryFieldValue
    extends AbstractPythonMapEntryFieldValue {
        Instance entry;

        private PythonMapEntryFieldValue(boolean set, Instance e) {
            super(set);
            this.entry = e;
        }

        @Override
        Instance getEntryKey() {
            return (Instance)this.entry.getValueOfField("key");
        }

        @Override
        Instance getEntryValue() {
            return (Instance)this.entry.getValueOfField("value");
        }
    }

    private class PythonKeywordEntryFieldValue
    extends AbstractPythonMapEntryFieldValue {
        Instance keyword;

        private PythonKeywordEntryFieldValue(boolean set, Instance k) {
            super(set);
            this.keyword = k;
        }

        @Override
        Instance getEntryKey() {
            return (Instance)this.keyword.getValueOfField("name");
        }

        @Override
        Instance getEntryValue() {
            return (Instance)this.keyword.getValueOfField("value");
        }
    }

    private class PythonEconomicEntryFieldValue
    extends AbstractPythonMapEntryFieldValue {
        Instance key;
        Instance value;

        private PythonEconomicEntryFieldValue(Instance k) {
            super(true);
            this.key = k;
        }

        private PythonEconomicEntryFieldValue(Instance k, Instance v) {
            super(false);
            this.key = k;
            this.value = v;
        }

        @Override
        Instance getEntryKey() {
            return this.key;
        }

        @Override
        Instance getEntryValue() {
            return this.value;
        }
    }
}

