/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.MissingResourceException;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CLIOptions
extends CLIHandler {
    static final String DIR_MODULES = "modules";
    static boolean defaultsLoaded = false;
    protected static boolean noLogging = false;
    private static boolean noSplash;
    protected static Class uiClass;
    private static int uiFontSize;
    private static boolean fallbackToMemory;
    private static String homeDir;
    private static String userDir;
    private static String systemDir;
    private static File cacheDir;
    private static boolean gui;

    public CLIOptions() {
        super(1);
    }

    protected int cli(CLIHandler.Args args) {
        return this.cli(args.getArguments());
    }

    static boolean isFallbackToMemory() {
        return fallbackToMemory;
    }

    static void fallbackToMemory() {
        fallbackToMemory = true;
    }

    public static boolean isGui() {
        return gui && !GraphicsEnvironment.isHeadless();
    }

    private static boolean isOption(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("--") && string2.length() > 1) {
            return string.substring(2).equals(string2);
        }
        if (string.startsWith("-") && string2.length() == 1) {
            return string.substring(1).contains(string2);
        }
        return false;
    }

    public final int cli(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            boolean bl = true;
            if (CLIOptions.isOption(stringArray[i], "nogui")) {
                gui = false;
            } else if (CLIOptions.isOption(stringArray[i], "nosplash")) {
                noSplash = true;
            } else if (!CLIOptions.isOption(stringArray[i], "noinfo")) {
                String string;
                if (CLIOptions.isOption(stringArray[i], "nologging")) {
                    noLogging = true;
                } else if (CLIOptions.isOption(stringArray[i], "userdir")) {
                    stringArray[i] = null;
                    try {
                        string = stringArray[++i];
                        if (!string.equals("memory")) {
                            string = FileUtil.normalizeFile((File)new File(string)).getPath();
                        }
                        userDir = string;
                        System.setProperty("netbeans.user", string);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.err.println(CLIOptions.getString("ERR_UserDirExpected"));
                        return 2;
                    }
                } else if (CLIOptions.isOption(stringArray[i], "cachedir")) {
                    stringArray[i] = null;
                    try {
                        cacheDir = FileUtil.normalizeFile((File)new File(stringArray[++i]));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.err.println(CLIOptions.getString("ERR_UserDirExpected"));
                        return 2;
                    }
                } else if (CLIOptions.isOption(stringArray[i], "ui") || CLIOptions.isOption(stringArray[i], "laf")) {
                    stringArray[i] = null;
                    try {
                        string = stringArray[++i];
                        if ("Metal".equals(string)) {
                            string = "javax.swing.plaf.metal.MetalLookAndFeel";
                        } else if ("GTK".equals(string)) {
                            string = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                        } else if ("Nimbus".equals(string)) {
                            string = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
                        } else if ("Windows".equals(string)) {
                            string = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                        } else if ("Aqua".equals(string)) {
                            string = "com.apple.laf.AquaLookAndFeel";
                        }
                        uiClass = Class.forName(string);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.err.println(CLIOptions.getString("ERR_UIExpected"));
                        return 2;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println(CLIOptions.getString("ERR_UINotFound"));
                    }
                } else if (CLIOptions.isOption(stringArray[i], "fontsize")) {
                    stringArray[i] = null;
                    try {
                        uiFontSize = Integer.parseInt(stringArray[++i]);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.err.println(CLIOptions.getString("ERR_FontSizeExpected"));
                        return 2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println(CLIOptions.getString("ERR_BadFontSize"));
                        return 1;
                    }
                } else if (CLIOptions.isOption(stringArray[i], "locale")) {
                    stringArray[i] = null;
                    try {
                        String string2;
                        string = stringArray[++i];
                        String string3 = "";
                        String string4 = "";
                        int n = string.indexOf(":");
                        if (n == -1) {
                            string2 = string;
                        } else {
                            string2 = string.substring(0, n);
                            int n2 = string.indexOf(":", n + 1);
                            if (n2 != -1) {
                                string3 = string.substring(n + 1, n2);
                                string4 = string.substring(n2 + 1);
                            } else {
                                string3 = string.substring(n + 1);
                            }
                        }
                        Locale.setDefault(new Locale(string2, string3, string4));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.err.println(CLIOptions.getString("ERR_LocaleExpected"));
                        return 2;
                    }
                } else if (CLIOptions.isOption(stringArray[i], "branding")) {
                    stringArray[i] = null;
                    if (++i == stringArray.length) {
                        System.err.println(CLIOptions.getString("ERR_BrandingNeedsArgument"));
                        return 2;
                    }
                    string = stringArray[i];
                    if (string.equals("-")) {
                        string = null;
                    }
                    try {
                        NbBundle.setBranding((String)string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                        return 1;
                    }
                } else {
                    bl = false;
                }
            }
            if (!bl) continue;
            stringArray[i] = null;
        }
        return 0;
    }

    public static void initialize() {
        TopLogging.initialize();
        StartLog.logProgress("TopLogging initialized");
    }

    protected void usage(PrintWriter printWriter) {
        printWriter.println("Core options:");
        printWriter.println("  --laf <LaF classname> use given LookAndFeel class instead of the default");
        printWriter.println("  --fontsize <size>     set the base font size of the user interface, in points");
        printWriter.println("  --locale <language[:country[:variant]]> use specified locale");
        printWriter.println("  --userdir <path>      use specified directory to store user settings");
        printWriter.println("  --cachedir <path>     use specified directory to store user cache, must be different from userdir");
        printWriter.println("  --nosplash            do not show the splash screen");
        printWriter.println("");
    }

    private static String getString(String string) {
        return NbBundle.getMessage(CLIOptions.class, (String)string);
    }

    public static String getLogDir() {
        return new File(new File(CLIOptions.getUserDir(), "var"), "log").toString();
    }

    static final void clearForTests() {
        homeDir = null;
        userDir = null;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            homeDir = System.getProperty("netbeans.home");
        }
        return homeDir;
    }

    public static String getUserDir() {
        if (userDir == null || !userDir.equals(System.getProperty("netbeans.user"))) {
            File file;
            userDir = System.getProperty("netbeans.user");
            if ("memory".equals(userDir)) {
                return "memory";
            }
            if (userDir == null) {
                if (homeDir == null) {
                    return "memory";
                }
                System.err.println(NbBundle.getMessage(CLIOptions.class, (String)"ERR_no_user_directory"));
                Thread.dumpStack();
                TopLogging.exit(1);
            }
            File file2 = FileUtil.normalizeFile((File)new File(userDir));
            String string = CLIOptions.getHomeDir();
            if (string != null) {
                file = FileUtil.normalizeFile((File)new File(string));
                if ((file2.getAbsolutePath() + File.separatorChar).startsWith(file.getParentFile().getAbsolutePath() + File.separatorChar)) {
                    System.err.println(NbBundle.getMessage(CLIOptions.class, (String)"ERR_user_dir_is_inside_home", (Object)file2, (Object)file.getParentFile()));
                    TopLogging.exit(1);
                }
            }
            userDir = file2.getPath();
            System.setProperty("netbeans.user", userDir);
            file = new File(file2, "config");
            CLIOptions.makedir(file);
            systemDir = file.getAbsolutePath();
        }
        return userDir;
    }

    public static File getCacheDir() {
        return cacheDir;
    }

    private static void makedir(File file) {
        Object[] objectArray;
        if (file.isFile()) {
            objectArray = new Object[]{file};
            System.err.println(NbBundle.getMessage(CLIOptions.class, (String)"CTL_CannotCreate_text", (Object[])objectArray));
            TopSecurityManager.exit((int)6);
        }
        if (!file.exists() && !file.mkdirs()) {
            objectArray = new Object[]{file};
            System.err.println(NbBundle.getMessage(CLIOptions.class, (String)"CTL_CannotCreateSysDir_text", (Object[])objectArray));
            TopSecurityManager.exit((int)7);
        }
    }

    protected static String getSystemDir() {
        CLIOptions.getUserDir();
        return systemDir;
    }

    private static void initDefaults() {
        if (!defaultsLoaded) {
            String string;
            if (uiFontSize == 0) {
                string = "";
                try {
                    string = NbBundle.getMessage(Main.class, (String)"CTL_globalFontSize");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (string.length() > 0) {
                    try {
                        uiFontSize = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (!noSplash) {
                string = NbBundle.getMessage(CLIOptions.class, (String)"SplashOnByDefault");
                noSplash = !Boolean.parseBoolean(string);
            }
            defaultsLoaded = true;
        }
    }

    public static int getFontSize() {
        CLIOptions.initDefaults();
        return uiFontSize;
    }

    static boolean isNoSplash() {
        CLIOptions.initDefaults();
        return noSplash;
    }

    static {
        uiFontSize = 0;
        gui = true;
    }
}

