/* Icon.c generated by valac 0.56.3, the Vala compiler
 * generated from Icon.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2017-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include "icontasklistapplet.h"
#include "plugin.h"
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#define MAX_CYCLES 12

enum  {
	ICON_0_PROPERTY,
	ICON_BOUNCE_PROPERTY,
	ICON_ATTENTION_PROPERTY,
	ICON_ICON_OPACITY_PROPERTY,
	ICON_NUM_PROPERTIES
};
static GParamSpec* icon_properties[ICON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _IconPrivate {
	gint widget_width;
	gint widget_height;
	BudgiePanelPosition panel_position;
	gint wait_cycle_counter;
	gint attention_cycle_counter;
	gdouble bounce_amount;
	gdouble attention_amount;
};

struct _Block11Data {
	int _ref_count_;
	Icon* self;
	BudgieTaskListAnimation* wait_animation;
	BudgieTaskListAnimation* wait_animation1;
};

static gint Icon_private_offset;
static gpointer icon_parent_class = NULL;
static GType icon_type_id = 0;

static void _icon_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                      GtkAllocation* allocation,
                                                      gpointer self);
static gdouble _budgie_task_list_sine_ease_in_budgie_task_list_tween_func (gdouble factor,
                                                                    gpointer self);
static void _vala_BudgieTaskListPropChange_array_free (BudgieTaskListPropChange * array,
                                                gssize array_length);
static void __lambda4_ (Icon* self,
                 BudgieTaskListAnimation* a);
static void ___lambda4__budgie_task_list_anim_completion_func (BudgieTaskListAnimation* src,
                                                        gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda5_ (Icon* self);
static void ___lambda5__budgie_task_list_anim_completion_func (BudgieTaskListAnimation* src,
                                                        gpointer self);
static gboolean __lambda6_ (Block11Data* _data11_);
static void __lambda7_ (Icon* self,
                 BudgieTaskListAnimation* a);
static void ___lambda7__budgie_task_list_anim_completion_func (BudgieTaskListAnimation* src,
                                                        gpointer self);
static gboolean ___lambda6__gsource_func (gpointer self);
static gdouble _budgie_task_list_elastic_ease_out_budgie_task_list_tween_func (gdouble factor,
                                                                        gpointer self);
static void __lambda8_ (Icon* self,
                 BudgieTaskListAnimation* a);
static void ___lambda8__budgie_task_list_anim_completion_func (BudgieTaskListAnimation* src,
                                                        gpointer self);
static gboolean icon_real_draw (GtkWidget* base,
                         cairo_t* cr);
static void icon_finalize (GObject * obj);
static void _vala_icon_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_icon_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);

static inline gpointer
icon_get_instance_private (Icon* self)
{
	return G_STRUCT_MEMBER_P (self, Icon_private_offset);
}

static void
_icon_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                 GtkAllocation* allocation,
                                                 gpointer self)
{
	icon_on_size_allocate ((Icon*) self, allocation);
}

Icon*
icon_construct (GType object_type)
{
	Icon * self = NULL;
	self = (Icon*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _icon_on_size_allocate_gtk_widget_size_allocate, self, 0);
	return self;
}

Icon*
icon_new (void)
{
	return icon_construct (TYPE_ICON);
}

void
icon_on_size_allocate (Icon* self,
                       GtkAllocation* allocation)
{
	GtkAllocation _tmp0_;
	GtkAllocation _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	self->priv->widget_width = _tmp0_.width;
	_tmp1_ = *allocation;
	self->priv->widget_height = _tmp1_.height;
}

static gdouble
_budgie_task_list_sine_ease_in_budgie_task_list_tween_func (gdouble factor,
                                                            gpointer self)
{
	gdouble result;
	result = budgie_task_list_sine_ease_in (factor);
	return result;
}

static void
_vala_BudgieTaskListPropChange_array_free (BudgieTaskListPropChange * array,
                                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			budgie_task_list_prop_change_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
__lambda4_ (Icon* self,
            BudgieTaskListAnimation* a)
{
	icon_animate_attention (self, NULL);
}

static void
___lambda4__budgie_task_list_anim_completion_func (BudgieTaskListAnimation* src,
                                                   gpointer self)
{
	__lambda4_ ((Icon*) self, src);
}

void
icon_animate_attention (Icon* self,
                        BudgiePanelPosition* position)
{
	gint _tmp0_;
	BudgieTaskListAnimation* attention_animation = NULL;
	BudgieTaskListAnimation* _tmp1_;
	BudgieTaskListAnimation* _tmp2_;
	BudgieTaskListAnimation* _tmp3_;
	BudgieTaskListAnimation* _tmp4_;
	BudgieTaskListAnimation* _tmp24_;
	g_return_if_fail (self != NULL);
	if (position != NULL) {
		self->priv->panel_position = *position;
	}
	if (self->priv->attention_cycle_counter == 6) {
		self->priv->attention_amount = (gdouble) 0;
		self->priv->attention_cycle_counter = 0;
		return;
	}
	_tmp0_ = self->priv->attention_cycle_counter;
	self->priv->attention_cycle_counter = _tmp0_ + 1;
	_tmp1_ = budgie_task_list_animation_new ();
	attention_animation = _tmp1_;
	_tmp2_ = attention_animation;
	_tmp2_->widget = (GtkWidget*) self;
	_tmp3_ = attention_animation;
	_tmp3_->length = 50 * BUDGIE_TASK_LIST_MSECOND;
	_tmp4_ = attention_animation;
	_tmp4_->tween = _budgie_task_list_sine_ease_in_budgie_task_list_tween_func;
	_tmp4_->tween_target = NULL;
	if ((self->priv->attention_cycle_counter % 2) == 0) {
		BudgieTaskListAnimation* _tmp5_;
		gchar* _tmp6_;
		GValue _tmp7_ = {0};
		GValue _tmp8_ = {0};
		BudgieTaskListPropChange _tmp9_ = {0};
		BudgieTaskListPropChange* _tmp10_;
		_tmp5_ = attention_animation;
		_tmp6_ = g_strdup ("attention");
		g_value_init (&_tmp7_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp7_, -5.0);
		g_value_init (&_tmp8_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp8_, 5.0);
		memset (&_tmp9_, 0, sizeof (BudgieTaskListPropChange));
		_g_free0 (_tmp9_.property);
		_tmp9_.property = _tmp6_;
		G_IS_VALUE (&_tmp9_.old) ? (g_value_unset (&_tmp9_.old), NULL) : NULL;
		_tmp9_.old = _tmp7_;
		G_IS_VALUE (&_tmp9_.new) ? (g_value_unset (&_tmp9_.new), NULL) : NULL;
		_tmp9_.new = _tmp8_;
		_tmp10_ = g_new0 (BudgieTaskListPropChange, 1);
		_tmp10_[0] = _tmp9_;
		_tmp5_->changes = (_vala_BudgieTaskListPropChange_array_free (_tmp5_->changes, _tmp5_->changes_length1), NULL);
		_tmp5_->changes = _tmp10_;
		_tmp5_->changes_length1 = 1;
	} else {
		if (self->priv->attention_cycle_counter == 5) {
			BudgieTaskListAnimation* _tmp11_;
			gchar* _tmp12_;
			GValue _tmp13_ = {0};
			GValue _tmp14_ = {0};
			BudgieTaskListPropChange _tmp15_ = {0};
			BudgieTaskListPropChange* _tmp16_;
			_tmp11_ = attention_animation;
			_tmp12_ = g_strdup ("attention");
			g_value_init (&_tmp13_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp13_, 5.0);
			g_value_init (&_tmp14_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp14_, 0.0);
			memset (&_tmp15_, 0, sizeof (BudgieTaskListPropChange));
			_g_free0 (_tmp15_.property);
			_tmp15_.property = _tmp12_;
			G_IS_VALUE (&_tmp15_.old) ? (g_value_unset (&_tmp15_.old), NULL) : NULL;
			_tmp15_.old = _tmp13_;
			G_IS_VALUE (&_tmp15_.new) ? (g_value_unset (&_tmp15_.new), NULL) : NULL;
			_tmp15_.new = _tmp14_;
			_tmp16_ = g_new0 (BudgieTaskListPropChange, 1);
			_tmp16_[0] = _tmp15_;
			_tmp11_->changes = (_vala_BudgieTaskListPropChange_array_free (_tmp11_->changes, _tmp11_->changes_length1), NULL);
			_tmp11_->changes = _tmp16_;
			_tmp11_->changes_length1 = 1;
		} else {
			gdouble _tmp17_ = 0.0;
			BudgieTaskListAnimation* _tmp18_;
			gchar* _tmp19_;
			GValue _tmp20_ = {0};
			GValue _tmp21_ = {0};
			BudgieTaskListPropChange _tmp22_ = {0};
			BudgieTaskListPropChange* _tmp23_;
			if (self->priv->attention_cycle_counter == 1) {
				_tmp17_ = 0.0;
			} else {
				_tmp17_ = 5.0;
			}
			_tmp18_ = attention_animation;
			_tmp19_ = g_strdup ("attention");
			g_value_init (&_tmp20_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp20_, _tmp17_);
			g_value_init (&_tmp21_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp21_, -5.0);
			memset (&_tmp22_, 0, sizeof (BudgieTaskListPropChange));
			_g_free0 (_tmp22_.property);
			_tmp22_.property = _tmp19_;
			G_IS_VALUE (&_tmp22_.old) ? (g_value_unset (&_tmp22_.old), NULL) : NULL;
			_tmp22_.old = _tmp20_;
			G_IS_VALUE (&_tmp22_.new) ? (g_value_unset (&_tmp22_.new), NULL) : NULL;
			_tmp22_.new = _tmp21_;
			_tmp23_ = g_new0 (BudgieTaskListPropChange, 1);
			_tmp23_[0] = _tmp22_;
			_tmp18_->changes = (_vala_BudgieTaskListPropChange_array_free (_tmp18_->changes, _tmp18_->changes_length1), NULL);
			_tmp18_->changes = _tmp23_;
			_tmp18_->changes_length1 = 1;
		}
	}
	_tmp24_ = attention_animation;
	budgie_task_list_animation_start (_tmp24_, ___lambda4__budgie_task_list_anim_completion_func, self);
	_g_object_unref0 (attention_animation);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		Icon* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->wait_animation1);
		_g_object_unref0 (_data11_->wait_animation);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda5_ (Icon* self)
{
	icon_set_icon_opacity (self, 0.3);
}

static void
___lambda5__budgie_task_list_anim_completion_func (BudgieTaskListAnimation* src,
                                                   gpointer self)
{
	__lambda5_ ((Icon*) self);
}

static void
__lambda7_ (Icon* self,
            BudgieTaskListAnimation* a)
{
	icon_set_icon_opacity (self, 1.0);
	icon_animate_wait (self);
}

static void
___lambda7__budgie_task_list_anim_completion_func (BudgieTaskListAnimation* src,
                                                   gpointer self)
{
	__lambda7_ ((Icon*) self, src);
}

static gboolean
__lambda6_ (Block11Data* _data11_)
{
	Icon* self;
	BudgieTaskListAnimation* _tmp2_;
	gboolean result;
	self = _data11_->self;
	if (!self->waiting) {
		BudgieTaskListAnimation* _tmp0_;
		BudgieTaskListAnimation* _tmp1_;
		_tmp0_ = _data11_->wait_animation;
		budgie_task_list_animation_stop (_tmp0_);
		_tmp1_ = _data11_->wait_animation1;
		budgie_task_list_animation_stop (_tmp1_);
		icon_set_icon_opacity (self, 1.0);
		result = FALSE;
		return result;
	}
	_tmp2_ = _data11_->wait_animation1;
	budgie_task_list_animation_start (_tmp2_, ___lambda7__budgie_task_list_anim_completion_func, self);
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ (self);
	return result;
}

void
icon_animate_wait (Icon* self)
{
	Block11Data* _data11_;
	gint _tmp0_;
	BudgieTaskListAnimation* _tmp1_;
	BudgieTaskListAnimation* _tmp2_;
	BudgieTaskListAnimation* _tmp3_;
	BudgieTaskListAnimation* _tmp4_;
	BudgieTaskListAnimation* _tmp5_;
	gchar* _tmp6_;
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	BudgieTaskListPropChange _tmp9_ = {0};
	BudgieTaskListPropChange* _tmp10_;
	BudgieTaskListAnimation* _tmp11_;
	BudgieTaskListAnimation* _tmp12_;
	BudgieTaskListAnimation* _tmp13_;
	BudgieTaskListAnimation* _tmp14_;
	BudgieTaskListAnimation* _tmp15_;
	gchar* _tmp16_;
	GValue _tmp17_ = {0};
	GValue _tmp18_ = {0};
	BudgieTaskListPropChange _tmp19_ = {0};
	BudgieTaskListPropChange* _tmp20_;
	BudgieTaskListAnimation* _tmp21_;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	if (!self->waiting) {
		self->priv->wait_cycle_counter = 0;
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return;
	}
	if (self->priv->wait_cycle_counter == MAX_CYCLES) {
		self->priv->wait_cycle_counter = 0;
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return;
	}
	_tmp0_ = self->priv->wait_cycle_counter;
	self->priv->wait_cycle_counter = _tmp0_ + 1;
	_tmp1_ = budgie_task_list_animation_new ();
	_data11_->wait_animation = _tmp1_;
	_tmp2_ = _data11_->wait_animation;
	_tmp2_->widget = (GtkWidget*) self;
	_tmp3_ = _data11_->wait_animation;
	_tmp3_->length = 700 * BUDGIE_TASK_LIST_MSECOND;
	_tmp4_ = _data11_->wait_animation;
	_tmp4_->tween = _budgie_task_list_sine_ease_in_budgie_task_list_tween_func;
	_tmp4_->tween_target = NULL;
	_tmp5_ = _data11_->wait_animation;
	_tmp6_ = g_strdup ("icon_opacity");
	g_value_init (&_tmp7_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp7_, 1.0);
	g_value_init (&_tmp8_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp8_, 0.3);
	memset (&_tmp9_, 0, sizeof (BudgieTaskListPropChange));
	_g_free0 (_tmp9_.property);
	_tmp9_.property = _tmp6_;
	G_IS_VALUE (&_tmp9_.old) ? (g_value_unset (&_tmp9_.old), NULL) : NULL;
	_tmp9_.old = _tmp7_;
	G_IS_VALUE (&_tmp9_.new) ? (g_value_unset (&_tmp9_.new), NULL) : NULL;
	_tmp9_.new = _tmp8_;
	_tmp10_ = g_new0 (BudgieTaskListPropChange, 1);
	_tmp10_[0] = _tmp9_;
	_tmp5_->changes = (_vala_BudgieTaskListPropChange_array_free (_tmp5_->changes, _tmp5_->changes_length1), NULL);
	_tmp5_->changes = _tmp10_;
	_tmp5_->changes_length1 = 1;
	_tmp11_ = budgie_task_list_animation_new ();
	_data11_->wait_animation1 = _tmp11_;
	_tmp12_ = _data11_->wait_animation1;
	_tmp12_->widget = (GtkWidget*) self;
	_tmp13_ = _data11_->wait_animation1;
	_tmp13_->length = 700 * BUDGIE_TASK_LIST_MSECOND;
	_tmp14_ = _data11_->wait_animation1;
	_tmp14_->tween = _budgie_task_list_sine_ease_in_budgie_task_list_tween_func;
	_tmp14_->tween_target = NULL;
	_tmp15_ = _data11_->wait_animation1;
	_tmp16_ = g_strdup ("icon_opacity");
	g_value_init (&_tmp17_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp17_, 0.3);
	g_value_init (&_tmp18_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp18_, 1.0);
	memset (&_tmp19_, 0, sizeof (BudgieTaskListPropChange));
	_g_free0 (_tmp19_.property);
	_tmp19_.property = _tmp16_;
	G_IS_VALUE (&_tmp19_.old) ? (g_value_unset (&_tmp19_.old), NULL) : NULL;
	_tmp19_.old = _tmp17_;
	G_IS_VALUE (&_tmp19_.new) ? (g_value_unset (&_tmp19_.new), NULL) : NULL;
	_tmp19_.new = _tmp18_;
	_tmp20_ = g_new0 (BudgieTaskListPropChange, 1);
	_tmp20_[0] = _tmp19_;
	_tmp15_->changes = (_vala_BudgieTaskListPropChange_array_free (_tmp15_->changes, _tmp15_->changes_length1), NULL);
	_tmp15_->changes = _tmp20_;
	_tmp15_->changes_length1 = 1;
	_tmp21_ = _data11_->wait_animation;
	budgie_task_list_animation_start (_tmp21_, ___lambda5__budgie_task_list_anim_completion_func, self);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 700, ___lambda6__gsource_func, block11_data_ref (_data11_), block11_data_unref);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static gdouble
_budgie_task_list_elastic_ease_out_budgie_task_list_tween_func (gdouble factor,
                                                                gpointer self)
{
	gdouble result;
	result = budgie_task_list_elastic_ease_out (factor);
	return result;
}

static void
__lambda8_ (Icon* self,
            BudgieTaskListAnimation* a)
{
	icon_set_bounce (self, 0.0);
}

static void
___lambda8__budgie_task_list_anim_completion_func (BudgieTaskListAnimation* src,
                                                   gpointer self)
{
	__lambda8_ ((Icon*) self, src);
}

void
icon_animate_launch (Icon* self,
                     BudgiePanelPosition position)
{
	gdouble old_value = 0.0;
	gboolean _tmp0_ = FALSE;
	BudgieTaskListAnimation* launch_animation = NULL;
	BudgieTaskListAnimation* _tmp5_;
	gchar* _tmp6_;
	GValue _tmp7_ = {0};
	gdouble _tmp8_;
	gdouble _tmp9_;
	GValue _tmp10_ = {0};
	BudgieTaskListPropChange _tmp11_ = {0};
	BudgieTaskListPropChange* _tmp12_;
	g_return_if_fail (self != NULL);
	self->priv->panel_position = position;
	if (position == BUDGIE_PANEL_POSITION_TOP) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_BOTTOM;
	}
	if (_tmp0_) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = gtk_image_get_pixel_size ((GtkImage*) self);
		_tmp2_ = _tmp1_;
		old_value = (gdouble) ((self->priv->widget_height - _tmp2_) / 2);
	} else {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = gtk_image_get_pixel_size ((GtkImage*) self);
		_tmp4_ = _tmp3_;
		old_value = (gdouble) ((self->priv->widget_width - _tmp4_) / 2);
	}
	_tmp5_ = budgie_task_list_animation_new ();
	launch_animation = _tmp5_;
	launch_animation->widget = (GtkWidget*) self;
	launch_animation->length = 1200 * BUDGIE_TASK_LIST_MSECOND;
	launch_animation->tween = _budgie_task_list_elastic_ease_out_budgie_task_list_tween_func;
	launch_animation->tween_target = NULL;
	_tmp6_ = g_strdup ("bounce");
	g_value_init (&_tmp7_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp7_, old_value);
	_tmp8_ = icon_get_bounce (self);
	_tmp9_ = _tmp8_;
	g_value_init (&_tmp10_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp10_, _tmp9_);
	memset (&_tmp11_, 0, sizeof (BudgieTaskListPropChange));
	_g_free0 (_tmp11_.property);
	_tmp11_.property = _tmp6_;
	G_IS_VALUE (&_tmp11_.old) ? (g_value_unset (&_tmp11_.old), NULL) : NULL;
	_tmp11_.old = _tmp7_;
	G_IS_VALUE (&_tmp11_.new) ? (g_value_unset (&_tmp11_.new), NULL) : NULL;
	_tmp11_.new = _tmp10_;
	_tmp12_ = g_new0 (BudgieTaskListPropChange, 1);
	_tmp12_[0] = _tmp11_;
	launch_animation->changes = (_vala_BudgieTaskListPropChange_array_free (launch_animation->changes, launch_animation->changes_length1), NULL);
	launch_animation->changes = _tmp12_;
	launch_animation->changes_length1 = 1;
	budgie_task_list_animation_start (launch_animation, ___lambda8__budgie_task_list_anim_completion_func, self);
	_g_object_unref0 (launch_animation);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
icon_real_draw (GtkWidget* base,
                cairo_t* cr)
{
	Icon * self;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	GdkWindow* window = NULL;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	cairo_surface_t* buffer = NULL;
	GdkWindow* _tmp4_;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	cairo_surface_t* _tmp13_;
	cairo_t* cr2 = NULL;
	cairo_surface_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	gint x = 0;
	gint y = 0;
	cairo_surface_t* _tmp17_;
	gboolean result;
	self = (Icon*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	window = _tmp2_;
	_tmp3_ = window;
	if (_tmp3_ == NULL) {
		result = GDK_EVENT_STOP;
		_g_object_unref0 (window);
		return result;
	}
	_tmp4_ = window;
	_tmp5_ = alloc;
	_tmp6_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = alloc;
	_tmp9_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = gdk_window_create_similar_image_surface (_tmp4_, CAIRO_FORMAT_ARGB32, _tmp5_.width * _tmp7_, _tmp8_.height * _tmp10_, _tmp12_);
	buffer = _tmp13_;
	_tmp14_ = buffer;
	_tmp15_ = cairo_create (_tmp14_);
	cr2 = _tmp15_;
	_tmp16_ = cr2;
	GTK_WIDGET_CLASS (icon_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_image_get_type (), GtkImage), _tmp16_);
	x = 0;
	y = 0;
	if (self->priv->panel_position == BUDGIE_PANEL_POSITION_LEFT) {
		x += (gint) self->priv->bounce_amount;
		y += (gint) self->priv->attention_amount;
	} else {
		if (self->priv->panel_position == BUDGIE_PANEL_POSITION_RIGHT) {
			x -= (gint) self->priv->bounce_amount;
			y += (gint) self->priv->attention_amount;
		} else {
			if (self->priv->panel_position == BUDGIE_PANEL_POSITION_TOP) {
				y += (gint) self->priv->bounce_amount;
				x += (gint) self->priv->attention_amount;
			} else {
				y -= (gint) self->priv->bounce_amount;
				x += (gint) self->priv->attention_amount;
			}
		}
	}
	_tmp17_ = buffer;
	cairo_set_source_surface (cr, _tmp17_, (gdouble) x, (gdouble) y);
	cairo_paint (cr);
	result = TRUE;
	_cairo_destroy0 (cr2);
	_cairo_surface_destroy0 (buffer);
	_g_object_unref0 (window);
	return result;
}

gdouble
icon_get_bounce (Icon* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->bounce_amount;
	return result;
}

void
icon_set_bounce (Icon* self,
                 gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->bounce_amount = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, icon_properties[ICON_BOUNCE_PROPERTY]);
}

gdouble
icon_get_attention (Icon* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->attention_amount;
	return result;
}

void
icon_set_attention (Icon* self,
                    gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->attention_amount = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, icon_properties[ICON_ATTENTION_PROPERTY]);
}

gdouble
icon_get_icon_opacity (Icon* self)
{
	gdouble result;
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = gtk_widget_get_opacity ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

void
icon_set_icon_opacity (Icon* self,
                       gdouble value)
{
	g_return_if_fail (self != NULL);
	if (self->waiting) {
		gtk_widget_set_opacity ((GtkWidget*) self, value);
	} else {
		gtk_widget_set_opacity ((GtkWidget*) self, 1.0);
	}
	g_object_notify_by_pspec ((GObject *) self, icon_properties[ICON_ICON_OPACITY_PROPERTY]);
}

static void
icon_class_init (IconClass * klass,
                 gpointer klass_data)
{
	icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Icon_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) icon_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_icon_set_property;
	G_OBJECT_CLASS (klass)->finalize = icon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_BOUNCE_PROPERTY, icon_properties[ICON_BOUNCE_PROPERTY] = g_param_spec_double ("bounce", "bounce", "bounce", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_ATTENTION_PROPERTY, icon_properties[ICON_ATTENTION_PROPERTY] = g_param_spec_double ("attention", "attention", "attention", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_ICON_OPACITY_PROPERTY, icon_properties[ICON_ICON_OPACITY_PROPERTY] = g_param_spec_double ("icon-opacity", "icon-opacity", "icon-opacity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
icon_instance_init (Icon * self,
                    gpointer klass)
{
	self->priv = icon_get_instance_private (self);
	self->priv->widget_width = 36;
	self->priv->widget_height = 30;
	self->priv->panel_position = BUDGIE_PANEL_POSITION_BOTTOM;
	self->waiting = FALSE;
	self->priv->wait_cycle_counter = 0;
	self->priv->attention_cycle_counter = 0;
	self->priv->bounce_amount = 0.0;
	self->priv->attention_amount = 0.0;
}

static void
icon_finalize (GObject * obj)
{
	Icon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON, Icon);
	G_OBJECT_CLASS (icon_parent_class)->finalize (obj);
}

GType
icon_get_type (void)
{
	return icon_type_id;
}

GType
icon_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Icon), 0, (GInstanceInitFunc) icon_instance_init, NULL };
	icon_type_id = g_type_module_register_type (module, gtk_image_get_type (), "Icon", &g_define_type_info, 0);
	Icon_private_offset = sizeof (IconPrivate);
	return icon_type_id;
}

static void
_vala_icon_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Icon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON, Icon);
	switch (property_id) {
		case ICON_BOUNCE_PROPERTY:
		g_value_set_double (value, icon_get_bounce (self));
		break;
		case ICON_ATTENTION_PROPERTY:
		g_value_set_double (value, icon_get_attention (self));
		break;
		case ICON_ICON_OPACITY_PROPERTY:
		g_value_set_double (value, icon_get_icon_opacity (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_icon_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Icon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON, Icon);
	switch (property_id) {
		case ICON_BOUNCE_PROPERTY:
		icon_set_bounce (self, g_value_get_double (value));
		break;
		case ICON_ATTENTION_PROPERTY:
		icon_set_attention (self, g_value_get_double (value));
		break;
		case ICON_ICON_OPACITY_PROPERTY:
		icon_set_icon_opacity (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

