/* MountHelper.c generated by valac 0.56.3, the Vala compiler
 * generated from MountHelper.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "placesindicator.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

enum  {
	MOUNT_HELPER_0_PROPERTY,
	MOUNT_HELPER_NUM_PROPERTIES
};
static GParamSpec* mount_helper_properties[MOUNT_HELPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	MOUNT_HELPER_SEND_MESSAGE_SIGNAL,
	MOUNT_HELPER_PASSWORD_ASKED_SIGNAL,
	MOUNT_HELPER_REQUEST_MOUNT_SIGNAL,
	MOUNT_HELPER_NUM_SIGNALS
};
static guint mount_helper_signals[MOUNT_HELPER_NUM_SIGNALS] = {0};

struct _MountHelperPrivate {
	GtkRevealer* revealer;
	GtkEntry* password_entry;
	GtkButton* unlock_button;
};

static gint MountHelper_private_offset;
static gpointer mount_helper_parent_class = NULL;
static GType mount_helper_type_id = 0;

static void mount_helper_handle_password (MountHelper* self,
                                   const gchar* message,
                                   const gchar* default_user,
                                   const gchar* default_domain,
                                   GAskPasswordFlags flags);
static void _mount_helper_handle_password_g_mount_operation_ask_password (GMountOperation* _sender,
                                                                   const gchar* message,
                                                                   const gchar* default_user,
                                                                   const gchar* default_domain,
                                                                   GAskPasswordFlags flags,
                                                                   gpointer self);
static void mount_helper_handle_block (MountHelper* self);
static void _mount_helper_handle_block_g_mount_operation_show_processes (GMountOperation* _sender,
                                                                  const gchar* message,
                                                                  GArray* processes,
                                                                  gchar** choices,
                                                                  gpointer self);
static void mount_helper_handle_aborted (MountHelper* self);
static void _mount_helper_handle_aborted_g_mount_operation_aborted (GMountOperation* _sender,
                                                             gpointer self);
static void mount_helper_on_entry_changed (MountHelper* self);
static void _mount_helper_on_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                          gpointer self);
static void mount_helper_do_unlock (MountHelper* self);
static void _mount_helper_do_unlock_gtk_entry_activate (GtkEntry* _sender,
                                                 gpointer self);
static void _mount_helper_do_unlock_gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self);
static void mount_helper_finalize (GObject * obj);

static inline gpointer
mount_helper_get_instance_private (MountHelper* self)
{
	return G_STRUCT_MEMBER_P (self, MountHelper_private_offset);
}

static void
_mount_helper_handle_password_g_mount_operation_ask_password (GMountOperation* _sender,
                                                              const gchar* message,
                                                              const gchar* default_user,
                                                              const gchar* default_domain,
                                                              GAskPasswordFlags flags,
                                                              gpointer self)
{
	mount_helper_handle_password ((MountHelper*) self, message, default_user, default_domain, flags);
}

static void
_mount_helper_handle_block_g_mount_operation_show_processes (GMountOperation* _sender,
                                                             const gchar* message,
                                                             GArray* processes,
                                                             gchar** choices,
                                                             gpointer self)
{
	mount_helper_handle_block ((MountHelper*) self);
}

static void
_mount_helper_handle_aborted_g_mount_operation_aborted (GMountOperation* _sender,
                                                        gpointer self)
{
	mount_helper_handle_aborted ((MountHelper*) self);
}

MountHelper*
mount_helper_construct (GType object_type)
{
	MountHelper * self = NULL;
	self = (MountHelper*) g_object_new (object_type, NULL);
	g_mount_operation_set_password_save ((GMountOperation*) self, G_PASSWORD_SAVE_FOR_SESSION);
	g_signal_connect_object ((GMountOperation*) self, "ask-password", (GCallback) _mount_helper_handle_password_g_mount_operation_ask_password, self, 0);
	g_signal_connect_object ((GMountOperation*) self, "show-processes", (GCallback) _mount_helper_handle_block_g_mount_operation_show_processes, self, 0);
	g_signal_connect_object ((GMountOperation*) self, "aborted", (GCallback) _mount_helper_handle_aborted_g_mount_operation_aborted, self, 0);
	return self;
}

MountHelper*
mount_helper_new (void)
{
	return mount_helper_construct (TYPE_MOUNT_HELPER);
}

static void
mount_helper_handle_password (MountHelper* self,
                              const gchar* message,
                              const gchar* default_user,
                              const gchar* default_domain,
                              GAskPasswordFlags flags)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	g_signal_emit (self, mount_helper_signals[MOUNT_HELPER_PASSWORD_ASKED_SIGNAL], 0);
	g_mount_operation_reply ((GMountOperation*) self, G_MOUNT_OPERATION_HANDLED);
}

static void
mount_helper_handle_block (MountHelper* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, mount_helper_signals[MOUNT_HELPER_SEND_MESSAGE_SIGNAL], 0, _ ("Volume is in use by other processes"));
	g_mount_operation_reply ((GMountOperation*) self, G_MOUNT_OPERATION_HANDLED);
}

static void
mount_helper_handle_aborted (MountHelper* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, mount_helper_signals[MOUNT_HELPER_SEND_MESSAGE_SIGNAL], 0, _ ("Operation aborted"));
	g_mount_operation_reply ((GMountOperation*) self, G_MOUNT_OPERATION_HANDLED);
}

static void
_mount_helper_on_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                     gpointer self)
{
	mount_helper_on_entry_changed ((MountHelper*) self);
}

static void
_mount_helper_do_unlock_gtk_entry_activate (GtkEntry* _sender,
                                            gpointer self)
{
	mount_helper_do_unlock ((MountHelper*) self);
}

static void
_mount_helper_do_unlock_gtk_button_clicked (GtkButton* _sender,
                                            gpointer self)
{
	mount_helper_do_unlock ((MountHelper*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkRevealer*
mount_helper_get_encryption_form (MountHelper* self)
{
	GtkRevealer* _tmp0_;
	GtkBox* unlock_box = NULL;
	GtkBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkRevealer* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkRevealer* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	GtkButton* _tmp15_;
	GtkRevealer* _tmp16_;
	GtkRevealer* _tmp17_;
	GtkRevealer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	unlock_box = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) unlock_box);
	gtk_style_context_add_class (_tmp2_, "unlock-area");
	_tmp3_ = self->priv->revealer;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) unlock_box);
	_tmp4_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp4_;
	_tmp5_ = self->priv->password_entry;
	gtk_entry_set_placeholder_text (_tmp5_, _ ("Type your password"));
	_tmp6_ = self->priv->password_entry;
	gtk_entry_set_input_purpose (_tmp6_, GTK_INPUT_PURPOSE_PASSWORD);
	_tmp7_ = self->priv->password_entry;
	gtk_entry_set_visibility (_tmp7_, FALSE);
	_tmp8_ = self->priv->password_entry;
	gtk_box_pack_start (unlock_box, (GtkWidget*) _tmp8_, TRUE, TRUE, (guint) 0);
	_tmp9_ = (GtkButton*) gtk_button_new_from_icon_name ("changes-allow-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->unlock_button);
	self->priv->unlock_button = _tmp9_;
	_tmp10_ = self->priv->unlock_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
	_tmp11_ = self->priv->unlock_button;
	gtk_box_pack_end (unlock_box, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
	_tmp12_ = self->priv->revealer;
	gtk_widget_show_all ((GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->password_entry;
	g_signal_connect_object ((GtkEditable*) _tmp13_, "changed", (GCallback) _mount_helper_on_entry_changed_gtk_editable_changed, self, 0);
	_tmp14_ = self->priv->password_entry;
	g_signal_connect_object (_tmp14_, "activate", (GCallback) _mount_helper_do_unlock_gtk_entry_activate, self, 0);
	_tmp15_ = self->priv->unlock_button;
	g_signal_connect_object (_tmp15_, "clicked", (GCallback) _mount_helper_do_unlock_gtk_button_clicked, self, 0);
	_tmp16_ = self->priv->revealer;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	result = _tmp17_;
	_g_object_unref0 (unlock_box);
	return result;
}

static void
mount_helper_on_entry_changed (MountHelper* self)
{
	GtkButton* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unlock_button;
	_tmp1_ = self->priv->password_entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp4_ > 0);
}

static void
mount_helper_do_unlock (MountHelper* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	GtkRevealer* _tmp2_;
	GtkEntry* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->password_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	if (g_strcmp0 (_tmp1_, "") == 0) {
		return;
	}
	_tmp2_ = self->priv->revealer;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = self->priv->password_entry;
	_tmp4_ = gtk_entry_get_text (_tmp3_);
	g_mount_operation_set_password ((GMountOperation*) self, _tmp4_);
	g_signal_emit (self, mount_helper_signals[MOUNT_HELPER_REQUEST_MOUNT_SIGNAL], 0);
}

GtkEntry*
mount_helper_get_password_entry (MountHelper* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->password_entry;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
mount_helper_class_init (MountHelperClass * klass,
                         gpointer klass_data)
{
	mount_helper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MountHelper_private_offset);
	G_OBJECT_CLASS (klass)->finalize = mount_helper_finalize;
	mount_helper_signals[MOUNT_HELPER_SEND_MESSAGE_SIGNAL] = g_signal_new ("send-message", TYPE_MOUNT_HELPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	mount_helper_signals[MOUNT_HELPER_PASSWORD_ASKED_SIGNAL] = g_signal_new ("password-asked", TYPE_MOUNT_HELPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	mount_helper_signals[MOUNT_HELPER_REQUEST_MOUNT_SIGNAL] = g_signal_new ("request-mount", TYPE_MOUNT_HELPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
mount_helper_instance_init (MountHelper * self,
                            gpointer klass)
{
	self->priv = mount_helper_get_instance_private (self);
}

static void
mount_helper_finalize (GObject * obj)
{
	MountHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOUNT_HELPER, MountHelper);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->password_entry);
	_g_object_unref0 (self->priv->unlock_button);
	G_OBJECT_CLASS (mount_helper_parent_class)->finalize (obj);
}

GType
mount_helper_get_type (void)
{
	return mount_helper_type_id;
}

GType
mount_helper_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (MountHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mount_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MountHelper), 0, (GInstanceInitFunc) mount_helper_instance_init, NULL };
	mount_helper_type_id = g_type_module_register_type (module, g_mount_operation_get_type (), "MountHelper", &g_define_type_info, 0);
	MountHelper_private_offset = sizeof (MountHelperPrivate);
	return mount_helper_type_id;
}

