/* notification.c generated by valac 0.56.3, the Vala compiler
 * generated from notification.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2018-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgie-private.h"
#include <gio/gdesktopappinfo.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>

enum  {
	BUDGIE_NOTIFICATION_0_PROPERTY,
	BUDGIE_NOTIFICATION_APP_INFO_PROPERTY,
	BUDGIE_NOTIFICATION_APP_ID_PROPERTY,
	BUDGIE_NOTIFICATION_URGENCY_PROPERTY,
	BUDGIE_NOTIFICATION_ID_PROPERTY,
	BUDGIE_NOTIFICATION_APP_NAME_PROPERTY,
	BUDGIE_NOTIFICATION_HINTS_PROPERTY,
	BUDGIE_NOTIFICATION_ACTIONS_PROPERTY,
	BUDGIE_NOTIFICATION_APP_ICON_PROPERTY,
	BUDGIE_NOTIFICATION_BODY_PROPERTY,
	BUDGIE_NOTIFICATION_SUMMARY_PROPERTY,
	BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY,
	BUDGIE_NOTIFICATION_CATEGORY_PROPERTY,
	BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY,
	BUDGIE_NOTIFICATION_IMAGE_PROPERTY,
	BUDGIE_NOTIFICATION_NUM_PROPERTIES
};
static GParamSpec* budgie_notification_properties[BUDGIE_NOTIFICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BudgieNotificationPrivate {
	GDesktopAppInfo* _app_info;
	gchar* _app_id;
	BudgieNotificationUrgency _urgency;
	guint32 _id;
	gchar* _app_name;
	GHashTable* _hints;
	gchar** _actions;
	gint _actions_length1;
	gint __actions_size_;
	gchar* _app_icon;
	gchar* _body;
	gchar* _summary;
	guint _expire_timeout;
	gchar* _category;
	gint64 _timestamp;
	GtkImage* _image;
};

static gint BudgieNotification_private_offset;
static gpointer budgie_notification_parent_class = NULL;
static GRegex* budgie_notification_entity_regex;
static GRegex* budgie_notification_entity_regex = NULL;
static GRegex* budgie_notification_tag_regex;
static GRegex* budgie_notification_tag_regex = NULL;

static GdkPixbuf* budgie_notification_decode_image (BudgieNotification* self,
                                             GVariant* img);
static gchar* budgie_notification_fix_markup (BudgieNotification* self,
                                       const gchar* markup);
static void budgie_notification_set_app_info (BudgieNotification* self,
                                       GDesktopAppInfo* value);
static void budgie_notification_set_app_id (BudgieNotification* self,
                                     const gchar* value);
static void budgie_notification_set_urgency (BudgieNotification* self,
                                      BudgieNotificationUrgency value);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static GObject * budgie_notification_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void budgie_notification_finalize (GObject * obj);
static GType budgie_notification_get_type_once (void);
static void _vala_budgie_notification_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_budgie_notification_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
 * Enumeration of why a notification was closed.
 */
static GType
budgie_notification_close_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED, "BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED", "expired"}, {BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED, "BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED", "dismissed"}, {BUDGIE_NOTIFICATION_CLOSE_REASON_CLOSED, "BUDGIE_NOTIFICATION_CLOSE_REASON_CLOSED", "closed"}, {BUDGIE_NOTIFICATION_CLOSE_REASON_UNDEFINED, "BUDGIE_NOTIFICATION_CLOSE_REASON_UNDEFINED", "undefined"}, {0, NULL, NULL}};
	GType budgie_notification_close_reason_type_id;
	budgie_notification_close_reason_type_id = g_enum_register_static ("BudgieNotificationCloseReason", values);
	return budgie_notification_close_reason_type_id;
}

GType
budgie_notification_close_reason_get_type (void)
{
	static volatile gsize budgie_notification_close_reason_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_close_reason_type_id__once)) {
		GType budgie_notification_close_reason_type_id;
		budgie_notification_close_reason_type_id = budgie_notification_close_reason_get_type_once ();
		g_once_init_leave (&budgie_notification_close_reason_type_id__once, budgie_notification_close_reason_type_id);
	}
	return budgie_notification_close_reason_type_id__once;
}

/**
 * Enumeration of where notification popups will be shown.
 */
static GType
budgie_notification_position_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_NOTIFICATION_POSITION_TOP_LEFT, "BUDGIE_NOTIFICATION_POSITION_TOP_LEFT", "top-left"}, {BUDGIE_NOTIFICATION_POSITION_TOP_RIGHT, "BUDGIE_NOTIFICATION_POSITION_TOP_RIGHT", "top-right"}, {BUDGIE_NOTIFICATION_POSITION_BOTTOM_LEFT, "BUDGIE_NOTIFICATION_POSITION_BOTTOM_LEFT", "bottom-left"}, {BUDGIE_NOTIFICATION_POSITION_BOTTOM_RIGHT, "BUDGIE_NOTIFICATION_POSITION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
	GType budgie_notification_position_type_id;
	budgie_notification_position_type_id = g_enum_register_static ("BudgieNotificationPosition", values);
	return budgie_notification_position_type_id;
}

GType
budgie_notification_position_get_type (void)
{
	static volatile gsize budgie_notification_position_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_position_type_id__once)) {
		GType budgie_notification_position_type_id;
		budgie_notification_position_type_id = budgie_notification_position_get_type_once ();
		g_once_init_leave (&budgie_notification_position_type_id__once, budgie_notification_position_type_id);
	}
	return budgie_notification_position_type_id__once;
}

/**
 * Enumeration of notification priorities.
 */
static GType
budgie_notification_urgency_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_NOTIFICATION_URGENCY_LOW, "BUDGIE_NOTIFICATION_URGENCY_LOW", "low"}, {BUDGIE_NOTIFICATION_URGENCY_NORMAL, "BUDGIE_NOTIFICATION_URGENCY_NORMAL", "normal"}, {BUDGIE_NOTIFICATION_URGENCY_CRITICAL, "BUDGIE_NOTIFICATION_URGENCY_CRITICAL", "critical"}, {0, NULL, NULL}};
	GType budgie_notification_urgency_type_id;
	budgie_notification_urgency_type_id = g_enum_register_static ("BudgieNotificationUrgency", values);
	return budgie_notification_urgency_type_id;
}

GType
budgie_notification_urgency_get_type (void)
{
	static volatile gsize budgie_notification_urgency_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_urgency_type_id__once)) {
		GType budgie_notification_urgency_type_id;
		budgie_notification_urgency_type_id = budgie_notification_urgency_get_type_once ();
		g_once_init_leave (&budgie_notification_urgency_type_id__once, budgie_notification_urgency_type_id);
	}
	return budgie_notification_urgency_type_id__once;
}

static inline gpointer
budgie_notification_get_instance_private (BudgieNotification* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotification_private_offset);
}

BudgieNotification*
budgie_notification_construct (GType object_type,
                               guint32 id,
                               const gchar* app_name,
                               const gchar* app_icon,
                               const gchar* summary,
                               const gchar* body,
                               gchar** actions,
                               gint actions_length1,
                               GHashTable* hints,
                               guint expire_timeout)
{
	BudgieNotification * self = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (app_icon != NULL, NULL);
	g_return_val_if_fail (summary != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (hints != NULL, NULL);
	self = (BudgieNotification*) g_object_new (object_type, "id", id, "app-name", app_name, "app-icon", app_icon, "summary", summary, "body", body, "actions", actions, "hints", hints, "expire-timeout", expire_timeout, NULL);
	return self;
}

BudgieNotification*
budgie_notification_new (guint32 id,
                         const gchar* app_name,
                         const gchar* app_icon,
                         const gchar* summary,
                         const gchar* body,
                         gchar** actions,
                         gint actions_length1,
                         GHashTable* hints,
                         guint expire_timeout)
{
	return budgie_notification_construct (BUDGIE_TYPE_NOTIFICATION, id, app_name, app_icon, summary, body, actions, actions_length1, hints, expire_timeout);
}

static GdkPixbuf*
budgie_notification_decode_image (BudgieNotification* self,
                                  GVariant* img)
{
	gint width = 0;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gint _tmp2_;
	gint height = 0;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	gint _tmp5_;
	gint rowstride = 0;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	gint _tmp8_;
	gboolean has_alpha = FALSE;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	gboolean _tmp11_;
	gint bits_per_sample = 0;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	gint _tmp14_;
	guint8* raw = NULL;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	void* _tmp17_;
	guint8* _tmp18_;
	gint _tmp18__length1;
	gint raw_length1;
	gint _raw_size_;
	GdkPixbuf* pixbuf = NULL;
	guint8* _tmp19_;
	gint _tmp19__length1;
	GdkPixbuf* _tmp20_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (img != NULL, NULL);
	_tmp0_ = g_variant_get_child_value (img, (gsize) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = (gint) g_variant_get_int32 (_tmp1_);
	_g_variant_unref0 (_tmp1_);
	width = _tmp2_;
	_tmp3_ = g_variant_get_child_value (img, (gsize) 1);
	_tmp4_ = _tmp3_;
	_tmp5_ = (gint) g_variant_get_int32 (_tmp4_);
	_g_variant_unref0 (_tmp4_);
	height = _tmp5_;
	_tmp6_ = g_variant_get_child_value (img, (gsize) 2);
	_tmp7_ = _tmp6_;
	_tmp8_ = (gint) g_variant_get_int32 (_tmp7_);
	_g_variant_unref0 (_tmp7_);
	rowstride = _tmp8_;
	_tmp9_ = g_variant_get_child_value (img, (gsize) 3);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_get_boolean (_tmp10_);
	_g_variant_unref0 (_tmp10_);
	has_alpha = _tmp11_;
	_tmp12_ = g_variant_get_child_value (img, (gsize) 4);
	_tmp13_ = _tmp12_;
	_tmp14_ = (gint) g_variant_get_int32 (_tmp13_);
	_g_variant_unref0 (_tmp13_);
	bits_per_sample = _tmp14_;
	_tmp15_ = g_variant_get_child_value (img, (gsize) 6);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_variant_get_data (_tmp16_);
	_tmp18_ = (guint8*) _tmp17_;
	_tmp18__length1 = -1;
	_g_variant_unref0 (_tmp16_);
	raw = _tmp18_;
	raw_length1 = _tmp18__length1;
	_raw_size_ = raw_length1;
	_tmp19_ = raw;
	_tmp19__length1 = raw_length1;
	_tmp20_ = gdk_pixbuf_new_from_data (_tmp19_, GDK_COLORSPACE_RGB, has_alpha, bits_per_sample, width, height, rowstride, (GdkPixbufDestroyNotify) NULL, NULL);
	pixbuf = _tmp20_;
	if (height != 48) {
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
		_tmp21_ = pixbuf;
		_tmp22_ = gdk_pixbuf_scale_simple (_tmp21_, 48, 48, GDK_INTERP_BILINEAR);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp22_;
	}
	_tmp23_ = pixbuf;
	_tmp24_ = gdk_pixbuf_copy (_tmp23_);
	result = _tmp24_;
	_g_object_unref0 (pixbuf);
	return result;
}

/**
 * Taken from gnome-shell. Notification markup is always a mess, and this is cleaner
 * than our previous solution.
 */
static gchar*
budgie_notification_fix_markup (BudgieNotification* self,
                                const gchar* markup)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (markup != NULL, NULL);
	_tmp0_ = g_strdup (markup);
	text = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		GRegex* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp2_ = budgie_notification_entity_regex;
		_tmp3_ = strlen (markup);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_replace (_tmp2_, markup, (gssize) _tmp4_, 0, "&amp;", 0, &_inner_error0_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (text);
		text = _tmp6_;
		_tmp8_ = budgie_notification_tag_regex;
		_tmp9_ = text;
		_tmp10_ = text;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_regex_replace (_tmp8_, _tmp9_, (gssize) _tmp12_, 0, "&lt;", 0, &_inner_error0_);
		_tmp7_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp7_;
		_tmp7_ = NULL;
		_g_free0 (text);
		text = _tmp14_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("notification.vala:248: Invalid regex: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = text;
	return result;
}

GDesktopAppInfo*
budgie_notification_get_app_info (BudgieNotification* self)
{
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_notification_set_app_info (BudgieNotification* self,
                                  GDesktopAppInfo* value)
{
	GDesktopAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_app_info (self);
	if (old_value != value) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_INFO_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_app_id (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_id;
	result = _tmp0_;
	return result;
}

static void
budgie_notification_set_app_id (BudgieNotification* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_app_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_id);
		self->priv->_app_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_ID_PROPERTY]);
	}
}

BudgieNotificationUrgency
budgie_notification_get_urgency (BudgieNotification* self)
{
	BudgieNotificationUrgency result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_urgency;
	return result;
}

static void
budgie_notification_set_urgency (BudgieNotification* self,
                                 BudgieNotificationUrgency value)
{
	BudgieNotificationUrgency old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_urgency (self);
	if (old_value != value) {
		self->priv->_urgency = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_URGENCY_PROPERTY]);
	}
}

guint32
budgie_notification_get_id (BudgieNotification* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_id;
	return result;
}

static void
budgie_notification_set_id (BudgieNotification* self,
                            guint32 value)
{
	guint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_id (self);
	if (old_value != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_ID_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_app_name (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_name;
	result = _tmp0_;
	return result;
}

static void
budgie_notification_set_app_name (BudgieNotification* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_app_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_name);
		self->priv->_app_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_NAME_PROPERTY]);
	}
}

GHashTable*
budgie_notification_get_hints (BudgieNotification* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hints;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
budgie_notification_set_hints (BudgieNotification* self,
                               GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_hints (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_hints);
		self->priv->_hints = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_HINTS_PROPERTY]);
	}
}

gchar**
budgie_notification_get_actions (BudgieNotification* self,
                                 gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions;
	_tmp0__length1 = self->priv->_actions_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
budgie_notification_set_actions (BudgieNotification* self,
                                 gchar** value,
                                 gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_actions (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_actions = (_vala_array_free (self->priv->_actions, self->priv->_actions_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_actions = _tmp0_;
		self->priv->_actions_length1 = _tmp0__length1;
		self->priv->__actions_size_ = self->priv->_actions_length1;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_ACTIONS_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_app_icon (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_icon;
	result = _tmp0_;
	return result;
}

static void
budgie_notification_set_app_icon (BudgieNotification* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_app_icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_icon);
		self->priv->_app_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_ICON_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_body (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

void
budgie_notification_set_body (BudgieNotification* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_body (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_body);
		self->priv->_body = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_BODY_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_summary (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_summary;
	result = _tmp0_;
	return result;
}

void
budgie_notification_set_summary (BudgieNotification* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_summary (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_summary);
		self->priv->_summary = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_SUMMARY_PROPERTY]);
	}
}

guint
budgie_notification_get_expire_timeout (BudgieNotification* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_expire_timeout;
	return result;
}

void
budgie_notification_set_expire_timeout (BudgieNotification* self,
                                        guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_expire_timeout (self);
	if (old_value != value) {
		self->priv->_expire_timeout = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_category (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category;
	result = _tmp0_;
	return result;
}

void
budgie_notification_set_category (BudgieNotification* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_category (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_category);
		self->priv->_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_CATEGORY_PROPERTY]);
	}
}

gint64
budgie_notification_get_timestamp (BudgieNotification* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_timestamp;
	return result;
}

void
budgie_notification_set_timestamp (BudgieNotification* self,
                                   gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_timestamp (self);
	if (old_value != value) {
		self->priv->_timestamp = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY]);
	}
}

GtkImage*
budgie_notification_get_image (BudgieNotification* self)
{
	GtkImage* result;
	GtkImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image;
	result = _tmp0_;
	return result;
}

void
budgie_notification_set_image (BudgieNotification* self,
                               GtkImage* value)
{
	GtkImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_image (self);
	if (old_value != value) {
		GtkImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_image);
		self->priv->_image = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_IMAGE_PROPERTY]);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static GObject *
budgie_notification_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotification * self;
	GVariant* variant = NULL;
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_;
	GVariant* _tmp7_;
	gboolean _tmp11_ = FALSE;
	GHashTable* _tmp12_;
	gconstpointer _tmp13_;
	GVariant* _tmp14_;
	gboolean _tmp19_ = FALSE;
	GHashTable* _tmp20_;
	gconstpointer _tmp21_;
	GVariant* _tmp22_;
	gboolean image_found = FALSE;
	gboolean _tmp35_ = FALSE;
	GHashTable* _tmp36_;
	gconstpointer _tmp37_;
	GVariant* _tmp38_;
	gboolean _tmp100_ = FALSE;
	const gchar* _tmp112_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (budgie_notification_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATION, BudgieNotification);
	variant = NULL;
	_tmp0_ = g_time_zone_new_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_now (_tmp1_);
	_tmp3_ = _tmp2_;
	budgie_notification_set_timestamp (self, g_date_time_to_unix (_tmp3_));
	_g_date_time_unref0 (_tmp3_);
	_g_time_zone_unref0 (_tmp1_);
	_tmp5_ = self->priv->_hints;
	_tmp6_ = g_hash_table_lookup (_tmp5_, "urgency");
	variant = (GVariant*) _tmp6_;
	_tmp7_ = variant;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_;
		const GVariantType* _tmp9_;
		_tmp8_ = variant;
		_tmp9_ = G_VARIANT_TYPE_BYTE;
		_tmp4_ = g_variant_is_of_type (_tmp8_, _tmp9_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GVariant* _tmp10_;
		_tmp10_ = variant;
		budgie_notification_set_urgency (self, (BudgieNotificationUrgency) g_variant_get_byte (_tmp10_));
	}
	_tmp12_ = self->priv->_hints;
	_tmp13_ = g_hash_table_lookup (_tmp12_, "category");
	variant = (GVariant*) _tmp13_;
	_tmp14_ = variant;
	if (_tmp14_ != NULL) {
		GVariant* _tmp15_;
		const GVariantType* _tmp16_;
		_tmp15_ = variant;
		_tmp16_ = G_VARIANT_TYPE_STRING;
		_tmp11_ = g_variant_is_of_type (_tmp15_, _tmp16_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GVariant* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = variant;
		_tmp18_ = g_variant_get_string (_tmp17_, NULL);
		budgie_notification_set_category (self, _tmp18_);
	}
	_tmp20_ = self->priv->_hints;
	_tmp21_ = g_hash_table_lookup (_tmp20_, "desktop-entry");
	variant = (GVariant*) _tmp21_;
	_tmp22_ = variant;
	if (_tmp22_ != NULL) {
		GVariant* _tmp23_;
		const GVariantType* _tmp24_;
		_tmp23_ = variant;
		_tmp24_ = G_VARIANT_TYPE_STRING;
		_tmp19_ = g_variant_is_of_type (_tmp23_, _tmp24_);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		GVariant* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GDesktopAppInfo* _tmp33_;
		GDesktopAppInfo* _tmp34_;
		_tmp25_ = variant;
		_tmp26_ = g_variant_get_string (_tmp25_, NULL);
		budgie_notification_set_app_id (self, _tmp26_);
		_tmp27_ = self->priv->_app_id;
		_tmp28_ = string_replace (_tmp27_, ".desktop", "");
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp29_);
		_tmp30_ = self->priv->_app_id;
		_tmp31_ = g_strdup_printf ("%s.desktop", _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_desktop_app_info_new (_tmp32_);
		_tmp34_ = _tmp33_;
		budgie_notification_set_app_info (self, _tmp34_);
		_g_object_unref0 (_tmp34_);
		_g_free0 (_tmp32_);
	}
	image_found = FALSE;
	_tmp36_ = self->priv->_hints;
	_tmp37_ = g_hash_table_lookup (_tmp36_, "image-data");
	variant = (GVariant*) _tmp37_;
	_tmp38_ = variant;
	if (_tmp38_ != NULL) {
		_tmp35_ = TRUE;
	} else {
		GHashTable* _tmp39_;
		gconstpointer _tmp40_;
		GVariant* _tmp41_;
		_tmp39_ = self->priv->_hints;
		_tmp40_ = g_hash_table_lookup (_tmp39_, "image_data");
		variant = (GVariant*) _tmp40_;
		_tmp41_ = variant;
		_tmp35_ = _tmp41_ != NULL;
	}
	if (_tmp35_) {
		GdkPixbuf* pixbuf = NULL;
		GVariant* _tmp42_;
		GdkPixbuf* _tmp43_;
		GdkPixbuf* _tmp44_;
		_tmp42_ = variant;
		_tmp43_ = budgie_notification_decode_image (self, _tmp42_);
		pixbuf = _tmp43_;
		_tmp44_ = pixbuf;
		if (_tmp44_ != NULL) {
			GdkPixbuf* _tmp45_;
			GtkImage* _tmp46_;
			GtkImage* _tmp47_;
			_tmp45_ = pixbuf;
			_tmp46_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp45_);
			g_object_ref_sink (_tmp46_);
			_tmp47_ = _tmp46_;
			budgie_notification_set_image (self, _tmp47_);
			_g_object_unref0 (_tmp47_);
			image_found = TRUE;
		}
		_g_object_unref0 (pixbuf);
	}
	if (!image_found) {
		gboolean _tmp48_ = FALSE;
		GHashTable* _tmp49_;
		gconstpointer _tmp50_;
		GVariant* _tmp51_;
		_tmp49_ = self->priv->_hints;
		_tmp50_ = g_hash_table_lookup (_tmp49_, "image-path");
		variant = (GVariant*) _tmp50_;
		_tmp51_ = variant;
		if (_tmp51_ != NULL) {
			_tmp48_ = TRUE;
		} else {
			GHashTable* _tmp52_;
			gconstpointer _tmp53_;
			GVariant* _tmp54_;
			_tmp52_ = self->priv->_hints;
			_tmp53_ = g_hash_table_lookup (_tmp52_, "image_path");
			variant = (GVariant*) _tmp53_;
			_tmp54_ = variant;
			_tmp48_ = _tmp54_ != NULL;
		}
		if (_tmp48_) {
			gchar* path = NULL;
			GVariant* _tmp55_;
			const gchar* _tmp56_;
			gchar* _tmp57_;
			gboolean _tmp58_ = FALSE;
			GtkIconTheme* _tmp59_;
			const gchar* _tmp60_;
			_tmp55_ = variant;
			_tmp56_ = g_variant_get_string (_tmp55_, NULL);
			_tmp57_ = g_strdup (_tmp56_);
			path = _tmp57_;
			_tmp59_ = gtk_icon_theme_get_default ();
			_tmp60_ = path;
			if (gtk_icon_theme_has_icon (_tmp59_, _tmp60_)) {
				const gchar* _tmp61_;
				const gchar* _tmp62_;
				_tmp61_ = path;
				_tmp62_ = self->priv->_app_icon;
				_tmp58_ = g_strcmp0 (_tmp61_, _tmp62_) != 0;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				GThemedIcon* icon = NULL;
				const gchar* _tmp63_;
				GThemedIcon* _tmp64_;
				GThemedIcon* _tmp65_;
				GtkImage* _tmp66_;
				GtkImage* _tmp67_;
				_tmp63_ = path;
				_tmp64_ = (GThemedIcon*) g_themed_icon_new (_tmp63_);
				icon = _tmp64_;
				_tmp65_ = icon;
				_tmp66_ = (GtkImage*) gtk_image_new_from_gicon ((GIcon*) _tmp65_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
				g_object_ref_sink (_tmp66_);
				_tmp67_ = _tmp66_;
				budgie_notification_set_image (self, _tmp67_);
				_g_object_unref0 (_tmp67_);
				image_found = TRUE;
				_g_object_unref0 (icon);
			} else {
				gboolean _tmp68_ = FALSE;
				const gchar* _tmp69_;
				_tmp69_ = path;
				if (g_str_has_prefix (_tmp69_, "/")) {
					_tmp68_ = TRUE;
				} else {
					const gchar* _tmp70_;
					_tmp70_ = path;
					_tmp68_ = g_str_has_prefix (_tmp70_, "file://");
				}
				if (_tmp68_) {
					{
						GdkPixbuf* pixbuf = NULL;
						const gchar* _tmp71_;
						GdkPixbuf* _tmp72_;
						GdkPixbuf* _tmp73_;
						GtkImage* _tmp74_;
						GtkImage* _tmp75_;
						_tmp71_ = path;
						_tmp72_ = gdk_pixbuf_new_from_file_at_size (_tmp71_, 48, 48, &_inner_error0_);
						pixbuf = _tmp72_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp73_ = pixbuf;
						_tmp74_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp73_);
						g_object_ref_sink (_tmp74_);
						_tmp75_ = _tmp74_;
						budgie_notification_set_image (self, _tmp75_);
						_g_object_unref0 (_tmp75_);
						image_found = TRUE;
						_g_object_unref0 (pixbuf);
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						GError* _tmp76_;
						const gchar* _tmp77_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp76_ = e;
						_tmp77_ = _tmp76_->message;
						g_critical ("notification.vala:159: Unable to get pixbuf from path: %s", _tmp77_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (path);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
					}
				}
			}
			_g_free0 (path);
		}
	}
	if (!image_found) {
		gboolean _tmp78_ = FALSE;
		const gchar* _tmp79_;
		_tmp79_ = self->priv->_app_icon;
		if (g_strcmp0 (_tmp79_, "") != 0) {
			const gchar* _tmp80_;
			_tmp80_ = self->priv->_app_icon;
			_tmp78_ = !string_contains (_tmp80_, "/");
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			const gchar* _tmp81_;
			GtkImage* _tmp82_;
			GtkImage* _tmp83_;
			_tmp81_ = self->priv->_app_icon;
			_tmp82_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp81_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
			g_object_ref_sink (_tmp82_);
			_tmp83_ = _tmp82_;
			budgie_notification_set_image (self, _tmp83_);
			_g_object_unref0 (_tmp83_);
			image_found = TRUE;
		} else {
			gboolean _tmp84_ = FALSE;
			const gchar* _tmp85_;
			_tmp85_ = self->priv->_app_icon;
			if (g_strcmp0 (_tmp85_, "") == 0) {
				GDesktopAppInfo* _tmp86_;
				_tmp86_ = self->priv->_app_info;
				_tmp84_ = _tmp86_ != NULL;
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				GDesktopAppInfo* _tmp87_;
				GIcon* _tmp88_;
				GtkImage* _tmp89_;
				GtkImage* _tmp90_;
				_tmp87_ = self->priv->_app_info;
				_tmp88_ = g_app_info_get_icon ((GAppInfo*) _tmp87_);
				_tmp89_ = (GtkImage*) gtk_image_new_from_gicon (_tmp88_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
				g_object_ref_sink (_tmp89_);
				_tmp90_ = _tmp89_;
				budgie_notification_set_image (self, _tmp90_);
				_g_object_unref0 (_tmp90_);
				image_found = TRUE;
			} else {
				const gchar* _tmp91_;
				_tmp91_ = self->priv->_app_icon;
				if (string_contains (_tmp91_, "/")) {
					GFile* file = NULL;
					const gchar* _tmp92_;
					GFile* _tmp93_;
					GFile* _tmp94_;
					_tmp92_ = self->priv->_app_icon;
					_tmp93_ = g_file_new_for_uri (_tmp92_);
					file = _tmp93_;
					_tmp94_ = file;
					if (g_file_query_exists (_tmp94_, NULL)) {
						GFileIcon* icon = NULL;
						GFile* _tmp95_;
						GFileIcon* _tmp96_;
						GFileIcon* _tmp97_;
						GtkImage* _tmp98_;
						GtkImage* _tmp99_;
						_tmp95_ = file;
						_tmp96_ = (GFileIcon*) g_file_icon_new (_tmp95_);
						icon = _tmp96_;
						_tmp97_ = icon;
						_tmp98_ = (GtkImage*) gtk_image_new_from_gicon ((GIcon*) _tmp97_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
						g_object_ref_sink (_tmp98_);
						_tmp99_ = _tmp98_;
						budgie_notification_set_image (self, _tmp99_);
						_g_object_unref0 (_tmp99_);
						image_found = TRUE;
						_g_object_unref0 (icon);
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	if (!image_found) {
		GHashTable* _tmp101_;
		gconstpointer _tmp102_;
		GVariant* _tmp103_;
		_tmp101_ = self->priv->_hints;
		_tmp102_ = g_hash_table_lookup (_tmp101_, "icon_data");
		variant = (GVariant*) _tmp102_;
		_tmp103_ = variant;
		_tmp100_ = _tmp103_ != NULL;
	} else {
		_tmp100_ = FALSE;
	}
	if (_tmp100_) {
		GdkPixbuf* pixbuf = NULL;
		GVariant* _tmp104_;
		GdkPixbuf* _tmp105_;
		GdkPixbuf* _tmp106_;
		_tmp104_ = variant;
		_tmp105_ = budgie_notification_decode_image (self, _tmp104_);
		pixbuf = _tmp105_;
		_tmp106_ = pixbuf;
		if (_tmp106_ != NULL) {
			GdkPixbuf* _tmp107_;
			GtkImage* _tmp108_;
			GtkImage* _tmp109_;
			_tmp107_ = pixbuf;
			_tmp108_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp107_);
			g_object_ref_sink (_tmp108_);
			_tmp109_ = _tmp108_;
			budgie_notification_set_image (self, _tmp109_);
			_g_object_unref0 (_tmp109_);
			image_found = TRUE;
		}
		_g_object_unref0 (pixbuf);
	}
	if (!image_found) {
		GtkImage* _tmp110_;
		GtkImage* _tmp111_;
		_tmp110_ = (GtkImage*) gtk_image_new_from_icon_name ("mail-unread-symbolic", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
		g_object_ref_sink (_tmp110_);
		_tmp111_ = _tmp110_;
		budgie_notification_set_image (self, _tmp111_);
		_g_object_unref0 (_tmp111_);
	}
	_tmp112_ = self->priv->_body;
	if (g_strcmp0 (_tmp112_, "") == 0) {
		const gchar* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		const gchar* _tmp116_;
		_tmp113_ = self->priv->_summary;
		_tmp114_ = budgie_notification_fix_markup (self, _tmp113_);
		_tmp115_ = _tmp114_;
		budgie_notification_set_body (self, _tmp115_);
		_g_free0 (_tmp115_);
		_tmp116_ = self->priv->_app_name;
		budgie_notification_set_summary (self, _tmp116_);
	} else {
		const gchar* _tmp117_;
		gchar* _tmp118_;
		gchar* _tmp119_;
		const gchar* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		_tmp117_ = self->priv->_body;
		_tmp118_ = budgie_notification_fix_markup (self, _tmp117_);
		_tmp119_ = _tmp118_;
		budgie_notification_set_body (self, _tmp119_);
		_g_free0 (_tmp119_);
		_tmp120_ = self->priv->_summary;
		_tmp121_ = budgie_notification_fix_markup (self, _tmp120_);
		_tmp122_ = _tmp121_;
		budgie_notification_set_summary (self, _tmp122_);
		_g_free0 (_tmp122_);
	}
	return obj;
}

static void
budgie_notification_class_init (BudgieNotificationClass * klass,
                                gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	budgie_notification_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotification_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notification_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notification_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notification_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notification_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_APP_INFO_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_APP_ID_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_ID_PROPERTY] = g_param_spec_string ("app-id", "app-id", "app-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_URGENCY_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_URGENCY_PROPERTY] = g_param_spec_enum ("urgency", "urgency", "urgency", BUDGIE_TYPE_NOTIFICATION_URGENCY, BUDGIE_NOTIFICATION_URGENCY_NORMAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_ID_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_ID_PROPERTY] = g_param_spec_uint ("id", "id", "id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_APP_NAME_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_HINTS_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_HINTS_PROPERTY] = g_param_spec_boxed ("hints", "hints", "hints", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_ACTIONS_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_ACTIONS_PROPERTY] = g_param_spec_boxed ("actions", "actions", "actions", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_APP_ICON_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_ICON_PROPERTY] = g_param_spec_string ("app-icon", "app-icon", "app-icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_BODY_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_BODY_PROPERTY] = g_param_spec_string ("body", "body", "body", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_SUMMARY_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_SUMMARY_PROPERTY] = g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY] = g_param_spec_uint ("expire-timeout", "expire-timeout", "expire-timeout", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_CATEGORY_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_CATEGORY_PROPERTY] = g_param_spec_string ("category", "category", "category", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY] = g_param_spec_int64 ("timestamp", "timestamp", "timestamp", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_IMAGE_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_IMAGE_PROPERTY] = g_param_spec_object ("image", "image", "image", gtk_image_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		_tmp1_ = g_regex_new ("&(?!amp;|quot;|apos;|lt;|gt;|#39;|nbsp;)", 0, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (budgie_notification_entity_regex);
		budgie_notification_entity_regex = _tmp2_;
		_tmp4_ = g_regex_new ("<(?!\\/?[biu]>)", 0, 0, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_regex_unref0 (budgie_notification_tag_regex);
		budgie_notification_tag_regex = _tmp5_;
		_g_regex_unref0 (_tmp3_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("notification.vala:102: Invalid notificiation regex: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
budgie_notification_instance_init (BudgieNotification * self,
                                   gpointer klass)
{
	self->priv = budgie_notification_get_instance_private (self);
	self->priv->_app_info = NULL;
	self->priv->_urgency = BUDGIE_NOTIFICATION_URGENCY_NORMAL;
	self->priv->_image = NULL;
}

static void
budgie_notification_finalize (GObject * obj)
{
	BudgieNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATION, BudgieNotification);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_app_id);
	_g_free0 (self->priv->_app_name);
	_g_hash_table_unref0 (self->priv->_hints);
	self->priv->_actions = (_vala_array_free (self->priv->_actions, self->priv->_actions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_app_icon);
	_g_free0 (self->priv->_body);
	_g_free0 (self->priv->_summary);
	_g_free0 (self->priv->_category);
	_g_object_unref0 (self->priv->_image);
	G_OBJECT_CLASS (budgie_notification_parent_class)->finalize (obj);
}

/**
 * This is our wrapper class for a FreeDesktop notification.
 */
static GType
budgie_notification_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notification_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotification), 0, (GInstanceInitFunc) budgie_notification_instance_init, NULL };
	GType budgie_notification_type_id;
	budgie_notification_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieNotification", &g_define_type_info, 0);
	BudgieNotification_private_offset = g_type_add_instance_private (budgie_notification_type_id, sizeof (BudgieNotificationPrivate));
	return budgie_notification_type_id;
}

GType
budgie_notification_get_type (void)
{
	static volatile gsize budgie_notification_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_type_id__once)) {
		GType budgie_notification_type_id;
		budgie_notification_type_id = budgie_notification_get_type_once ();
		g_once_init_leave (&budgie_notification_type_id__once, budgie_notification_type_id);
	}
	return budgie_notification_type_id__once;
}

static void
_vala_budgie_notification_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BudgieNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATION, BudgieNotification);
	switch (property_id) {
		case BUDGIE_NOTIFICATION_APP_INFO_PROPERTY:
		g_value_set_object (value, budgie_notification_get_app_info (self));
		break;
		case BUDGIE_NOTIFICATION_APP_ID_PROPERTY:
		g_value_set_string (value, budgie_notification_get_app_id (self));
		break;
		case BUDGIE_NOTIFICATION_URGENCY_PROPERTY:
		g_value_set_enum (value, budgie_notification_get_urgency (self));
		break;
		case BUDGIE_NOTIFICATION_ID_PROPERTY:
		g_value_set_uint (value, budgie_notification_get_id (self));
		break;
		case BUDGIE_NOTIFICATION_APP_NAME_PROPERTY:
		g_value_set_string (value, budgie_notification_get_app_name (self));
		break;
		case BUDGIE_NOTIFICATION_HINTS_PROPERTY:
		g_value_set_boxed (value, budgie_notification_get_hints (self));
		break;
		case BUDGIE_NOTIFICATION_ACTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, budgie_notification_get_actions (self, &length));
		}
		break;
		case BUDGIE_NOTIFICATION_APP_ICON_PROPERTY:
		g_value_set_string (value, budgie_notification_get_app_icon (self));
		break;
		case BUDGIE_NOTIFICATION_BODY_PROPERTY:
		g_value_set_string (value, budgie_notification_get_body (self));
		break;
		case BUDGIE_NOTIFICATION_SUMMARY_PROPERTY:
		g_value_set_string (value, budgie_notification_get_summary (self));
		break;
		case BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY:
		g_value_set_uint (value, budgie_notification_get_expire_timeout (self));
		break;
		case BUDGIE_NOTIFICATION_CATEGORY_PROPERTY:
		g_value_set_string (value, budgie_notification_get_category (self));
		break;
		case BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY:
		g_value_set_int64 (value, budgie_notification_get_timestamp (self));
		break;
		case BUDGIE_NOTIFICATION_IMAGE_PROPERTY:
		g_value_set_object (value, budgie_notification_get_image (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notification_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BudgieNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATION, BudgieNotification);
	switch (property_id) {
		case BUDGIE_NOTIFICATION_APP_INFO_PROPERTY:
		budgie_notification_set_app_info (self, g_value_get_object (value));
		break;
		case BUDGIE_NOTIFICATION_APP_ID_PROPERTY:
		budgie_notification_set_app_id (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_URGENCY_PROPERTY:
		budgie_notification_set_urgency (self, g_value_get_enum (value));
		break;
		case BUDGIE_NOTIFICATION_ID_PROPERTY:
		budgie_notification_set_id (self, g_value_get_uint (value));
		break;
		case BUDGIE_NOTIFICATION_APP_NAME_PROPERTY:
		budgie_notification_set_app_name (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_HINTS_PROPERTY:
		budgie_notification_set_hints (self, g_value_get_boxed (value));
		break;
		case BUDGIE_NOTIFICATION_ACTIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			budgie_notification_set_actions (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case BUDGIE_NOTIFICATION_APP_ICON_PROPERTY:
		budgie_notification_set_app_icon (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_BODY_PROPERTY:
		budgie_notification_set_body (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_SUMMARY_PROPERTY:
		budgie_notification_set_summary (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY:
		budgie_notification_set_expire_timeout (self, g_value_get_uint (value));
		break;
		case BUDGIE_NOTIFICATION_CATEGORY_PROPERTY:
		budgie_notification_set_category (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY:
		budgie_notification_set_timestamp (self, g_value_get_int64 (value));
		break;
		case BUDGIE_NOTIFICATION_IMAGE_PROPERTY:
		budgie_notification_set_image (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

