/* sound.c generated by valac 0.56.3, the Vala compiler
 * generated from sound.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <gio/gio.h>
#include <glib.h>
#include <pulse/pulseaudio.h>
#include <gvc-mixer-control.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gvc-mixer-stream.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gvc-mixer-card.h>
#include <gvc-mixer-ui-device.h>
#include <pango/pango.h>
#include <gvc-channel-map.h>

#define BUDGIE_SOUND_WIDGET_MAX_KEY "allow-volume-overdrive"

enum  {
	BUDGIE_SOUND_WIDGET_0_PROPERTY,
	BUDGIE_SOUND_WIDGET_NUM_PROPERTIES
};
static GParamSpec* budgie_sound_widget_properties[BUDGIE_SOUND_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block7Data Block7Data;
enum  {
	BUDGIE_SOUND_WIDGET_DEVICES_STATE_CHANGED_SIGNAL,
	BUDGIE_SOUND_WIDGET_NUM_SIGNALS
};
static guint budgie_sound_widget_signals[BUDGIE_SOUND_WIDGET_NUM_SIGNALS] = {0};

struct _BudgieSoundWidgetPrivate {
	GSettings* budgie_settings;
	GSettings* gnome_desktop_settings;
	GSettings* raven_settings;
	gulong scale_id;
	GvcMixerControl* mixer;
	GHashTable* apps;
	GHashTable* derpers;
	GHashTable* devices;
	gulong primary_notify_id;
	GvcMixerStream* primary_stream;
	GSettings* settings;
	gchar* widget_type;
	BudgieHeaderWidget* header;
	GtkBox* apps_area;
	GtkListBox* apps_listbox;
	GtkRevealer* apps_list_revealer;
	GtkListBox* devices_list;
	BudgieStartListening* listening_box;
	GtkRevealer* listening_box_revealer;
	GtkBox* main_layout;
	GtkStack* widget_area;
	GtkStackSwitcher* widget_area_switch;
	GtkScale* volume_slider;
};

struct _Block7Data {
	int _ref_count_;
	BudgieSoundWidget* self;
	BudgieAppSoundControl* control;
};

static gint BudgieSoundWidget_private_offset;
static gpointer budgie_sound_widget_parent_class = NULL;

static void __lambda23_ (BudgieSoundWidget* self,
                  guint id);
static void ___lambda23__gvc_mixer_control_card_added (GvcMixerControl* _sender,
                                                guint id,
                                                gpointer self);
static void __lambda24_ (BudgieSoundWidget* self,
                  guint id);
static void ___lambda24__gvc_mixer_control_card_removed (GvcMixerControl* _sender,
                                                  guint id,
                                                  gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void budgie_sound_widget_on_device_selected (BudgieSoundWidget* self,
                                             GtkListBoxRow* list_item);
static void _budgie_sound_widget_on_device_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self);
static void budgie_sound_widget_on_scale_change (BudgieSoundWidget* self);
static void _budgie_sound_widget_on_scale_change_gtk_range_value_changed (GtkRange* _sender,
                                                                   gpointer self);
static void budgie_sound_widget_on_device_changed (BudgieSoundWidget* self,
                                            guint id);
static void _budgie_sound_widget_on_device_changed_gvc_mixer_control_default_source_changed (GvcMixerControl* _sender,
                                                                                      guint id,
                                                                                      gpointer self);
static void budgie_sound_widget_on_state_changed (BudgieSoundWidget* self,
                                           guint id);
static void _budgie_sound_widget_on_state_changed_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                            guint new_state,
                                                                            gpointer self);
static void budgie_sound_widget_on_device_added (BudgieSoundWidget* self,
                                          guint id);
static void _budgie_sound_widget_on_device_added_gvc_mixer_control_input_added (GvcMixerControl* _sender,
                                                                         guint id,
                                                                         gpointer self);
static void budgie_sound_widget_on_device_removed (BudgieSoundWidget* self,
                                            guint id);
static void _budgie_sound_widget_on_device_removed_gvc_mixer_control_input_removed (GvcMixerControl* _sender,
                                                                             guint id,
                                                                             gpointer self);
static void _budgie_sound_widget_on_device_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender,
                                                                                    guint id,
                                                                                    gpointer self);
static void _budgie_sound_widget_on_device_added_gvc_mixer_control_output_added (GvcMixerControl* _sender,
                                                                          guint id,
                                                                          gpointer self);
static void _budgie_sound_widget_on_device_removed_gvc_mixer_control_output_removed (GvcMixerControl* _sender,
                                                                              guint id,
                                                                              gpointer self);
static void budgie_sound_widget_on_stream_added (BudgieSoundWidget* self,
                                          guint id);
static void _budgie_sound_widget_on_stream_added_gvc_mixer_control_stream_added (GvcMixerControl* _sender,
                                                                          guint id,
                                                                          gpointer self);
static void budgie_sound_widget_on_stream_removed (BudgieSoundWidget* self,
                                            guint id);
static void _budgie_sound_widget_on_stream_removed_gvc_mixer_control_stream_removed (GvcMixerControl* _sender,
                                                                              guint id,
                                                                              gpointer self);
static void budgie_sound_widget_on_volume_safety_changed (BudgieSoundWidget* self);
static void _budgie_sound_widget_on_volume_safety_changed_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self);
static void budgie_sound_widget_update_input_draw_markers (BudgieSoundWidget* self);
static void _budgie_sound_widget_update_input_draw_markers_g_settings_changed (GSettings* _sender,
                                                                        const gchar* key,
                                                                        gpointer self);
static gint ___lambda27_ (BudgieSoundWidget* self,
                   GtkListBoxRow* row1,
                   GtkListBoxRow* row2);
static gint ____lambda27__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                           GtkListBoxRow* row2,
                                           gpointer self);
static void budgie_sound_widget_set_slider_range_on_max (BudgieSoundWidget* self,
                                                  gboolean allow_overdrive);
static void budgie_sound_widget_toggle_start_listening (BudgieSoundWidget* self);
static void __lambda25_ (BudgieSoundWidget* self,
                  GObject* n,
                  GParamSpec* p);
static void budgie_sound_widget_update_volume (BudgieSoundWidget* self);
static void ___lambda25__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static BudgieAppSoundControl* budgie_sound_widget_get_control_for_app (BudgieSoundWidget* self,
                                                                guint id);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _____lambda26_ (Block7Data* _data7_);
static void ______lambda26__gvc_channel_map_volume_changed (GvcChannelMap* _sender,
                                                     gboolean set,
                                                     gpointer self);
static void budgie_sound_widget_finalize (GObject * obj);
static GType budgie_sound_widget_get_type_once (void);

static inline gpointer
budgie_sound_widget_get_instance_private (BudgieSoundWidget* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieSoundWidget_private_offset);
}

static void
__lambda23_ (BudgieSoundWidget* self,
             guint id)
{
	g_signal_emit (self, budgie_sound_widget_signals[BUDGIE_SOUND_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
}

static void
___lambda23__gvc_mixer_control_card_added (GvcMixerControl* _sender,
                                           guint id,
                                           gpointer self)
{
	__lambda23_ ((BudgieSoundWidget*) self, id);
}

static void
__lambda24_ (BudgieSoundWidget* self,
             guint id)
{
	g_signal_emit (self, budgie_sound_widget_signals[BUDGIE_SOUND_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
}

static void
___lambda24__gvc_mixer_control_card_removed (GvcMixerControl* _sender,
                                             guint id,
                                             gpointer self)
{
	__lambda24_ ((BudgieSoundWidget*) self, id);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_budgie_sound_widget_on_device_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self)
{
	budgie_sound_widget_on_device_selected ((BudgieSoundWidget*) self, row);
}

static void
_budgie_sound_widget_on_scale_change_gtk_range_value_changed (GtkRange* _sender,
                                                              gpointer self)
{
	budgie_sound_widget_on_scale_change ((BudgieSoundWidget*) self);
}

static void
_budgie_sound_widget_on_device_changed_gvc_mixer_control_default_source_changed (GvcMixerControl* _sender,
                                                                                 guint id,
                                                                                 gpointer self)
{
	budgie_sound_widget_on_device_changed ((BudgieSoundWidget*) self, id);
}

static void
_budgie_sound_widget_on_state_changed_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                       guint new_state,
                                                                       gpointer self)
{
	budgie_sound_widget_on_state_changed ((BudgieSoundWidget*) self, new_state);
}

static void
_budgie_sound_widget_on_device_added_gvc_mixer_control_input_added (GvcMixerControl* _sender,
                                                                    guint id,
                                                                    gpointer self)
{
	budgie_sound_widget_on_device_added ((BudgieSoundWidget*) self, id);
}

static void
_budgie_sound_widget_on_device_removed_gvc_mixer_control_input_removed (GvcMixerControl* _sender,
                                                                        guint id,
                                                                        gpointer self)
{
	budgie_sound_widget_on_device_removed ((BudgieSoundWidget*) self, id);
}

static void
_budgie_sound_widget_on_device_changed_gvc_mixer_control_default_sink_changed (GvcMixerControl* _sender,
                                                                               guint id,
                                                                               gpointer self)
{
	budgie_sound_widget_on_device_changed ((BudgieSoundWidget*) self, id);
}

static void
_budgie_sound_widget_on_device_added_gvc_mixer_control_output_added (GvcMixerControl* _sender,
                                                                     guint id,
                                                                     gpointer self)
{
	budgie_sound_widget_on_device_added ((BudgieSoundWidget*) self, id);
}

static void
_budgie_sound_widget_on_device_removed_gvc_mixer_control_output_removed (GvcMixerControl* _sender,
                                                                         guint id,
                                                                         gpointer self)
{
	budgie_sound_widget_on_device_removed ((BudgieSoundWidget*) self, id);
}

static void
_budgie_sound_widget_on_stream_added_gvc_mixer_control_stream_added (GvcMixerControl* _sender,
                                                                     guint id,
                                                                     gpointer self)
{
	budgie_sound_widget_on_stream_added ((BudgieSoundWidget*) self, id);
}

static void
_budgie_sound_widget_on_stream_removed_gvc_mixer_control_stream_removed (GvcMixerControl* _sender,
                                                                         guint id,
                                                                         gpointer self)
{
	budgie_sound_widget_on_stream_removed ((BudgieSoundWidget*) self, id);
}

static void
_budgie_sound_widget_on_volume_safety_changed_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self)
{
	budgie_sound_widget_on_volume_safety_changed ((BudgieSoundWidget*) self);
}

static void
_budgie_sound_widget_update_input_draw_markers_g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self)
{
	budgie_sound_widget_update_input_draw_markers ((BudgieSoundWidget*) self);
}

static gint
___lambda27_ (BudgieSoundWidget* self,
              GtkListBoxRow* row1,
              GtkListBoxRow* row2)
{
	gchar* app_1 = NULL;
	GtkWidget* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* app_2 = NULL;
	GtkWidget* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_ = 0;
	GCompareFunc _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint result;
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BUDGIE_TYPE_APP_SOUND_CONTROL, BudgieAppSoundControl)->app_name;
	_tmp2_ = g_strdup (_tmp1_);
	app_1 = _tmp2_;
	_tmp3_ = gtk_bin_get_child ((GtkBin*) row2);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BUDGIE_TYPE_APP_SOUND_CONTROL, BudgieAppSoundControl)->app_name;
	_tmp5_ = g_strdup (_tmp4_);
	app_2 = _tmp5_;
	_tmp7_ = ((GCompareFunc) g_strcmp0);
	_tmp8_ = app_1;
	_tmp9_ = app_2;
	if (_tmp7_ (_tmp8_, _tmp9_) <= 0) {
		_tmp6_ = -1;
	} else {
		_tmp6_ = 1;
	}
	result = _tmp6_;
	_g_free0 (app_2);
	_g_free0 (app_1);
	return result;
}

static gint
____lambda27__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                      GtkListBoxRow* row2,
                                      gpointer self)
{
	gint result;
	result = ___lambda27_ ((BudgieSoundWidget*) self, row1, row2);
	return result;
}

BudgieSoundWidget*
budgie_sound_widget_construct (GType object_type,
                               const gchar* c_widget_type)
{
	BudgieSoundWidget * self = NULL;
	GtkStyleContext* _tmp0_;
	gchar* _tmp1_;
	GvcMixerControl* _tmp2_;
	GvcMixerControl* _tmp3_;
	GvcMixerControl* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GHashTable* _tmp16_;
	GtkListBox* _tmp17_;
	GtkListBox* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkListBox* _tmp20_;
	GtkStyleContext* _tmp21_;
	GtkListBox* _tmp22_;
	GtkListBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkScale* _tmp25_;
	GtkScale* _tmp26_;
	GtkScale* _tmp27_;
	const gchar* _tmp28_;
	GvcMixerControl* _tmp101_;
	BudgieRavenExpander* expander = NULL;
	BudgieHeaderWidget* _tmp102_;
	BudgieRavenExpander* _tmp103_;
	BudgieRavenExpander* _tmp104_;
	const gchar* _tmp105_;
	BudgieRavenExpander* _tmp106_;
	GtkEventBox* ebox = NULL;
	GtkEventBox* _tmp107_;
	GtkEventBox* _tmp108_;
	GtkStyleContext* _tmp109_;
	BudgieRavenExpander* _tmp110_;
	GtkEventBox* _tmp111_;
	GtkEventBox* _tmp112_;
	GtkBox* _tmp113_;
	const gchar* _tmp114_;
	g_return_val_if_fail (c_widget_type != NULL, NULL);
	self = (BudgieSoundWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "audio-widget");
	_tmp1_ = g_strdup (c_widget_type);
	_g_free0 (self->priv->widget_type);
	self->priv->widget_type = _tmp1_;
	_tmp2_ = gvc_mixer_control_new ("Budgie Volume Control");
	_g_object_unref0 (self->priv->mixer);
	self->priv->mixer = _tmp2_;
	_tmp3_ = self->priv->mixer;
	g_signal_connect_object (_tmp3_, "card-added", (GCallback) ___lambda23__gvc_mixer_control_card_added, self, 0);
	_tmp4_ = self->priv->mixer;
	g_signal_connect_object (_tmp4_, "card-removed", (GCallback) ___lambda24__gvc_mixer_control_card_removed, self, 0);
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->derpers);
	self->priv->derpers = _tmp7_;
	_tmp8_ = self->priv->derpers;
	_tmp9_ = g_strdup ("Vivaldi");
	_tmp10_ = g_strdup ("vivaldi");
	g_hash_table_insert (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = self->priv->derpers;
	_tmp12_ = g_strdup ("Vivaldi Snapshot");
	_tmp13_ = g_strdup ("vivaldi-snapshot");
	g_hash_table_insert (_tmp11_, _tmp12_, _tmp13_);
	_tmp14_ = g_direct_hash;
	_tmp15_ = g_direct_equal;
	_tmp16_ = g_hash_table_new_full (_tmp14_, _tmp15_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->devices);
	self->priv->devices = _tmp16_;
	_tmp17_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->devices_list);
	self->priv->devices_list = _tmp17_;
	_tmp18_ = self->priv->devices_list;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, "devices-list");
	_tmp20_ = self->priv->devices_list;
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
	gtk_style_context_add_class (_tmp21_, "sound-devices");
	_tmp22_ = self->priv->devices_list;
	gtk_list_box_set_selection_mode (_tmp22_, GTK_SELECTION_SINGLE);
	_tmp23_ = self->priv->devices_list;
	g_signal_connect_object (_tmp23_, "row-selected", (GCallback) _budgie_sound_widget_on_device_selected_gtk_list_box_row_selected, self, 0);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->main_layout);
	self->priv->main_layout = _tmp24_;
	_tmp25_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 100, (gdouble) 10);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->volume_slider);
	self->priv->volume_slider = _tmp25_;
	_tmp26_ = self->priv->volume_slider;
	gtk_scale_set_draw_value (_tmp26_, FALSE);
	_tmp27_ = self->priv->volume_slider;
	g_signal_connect_object ((GtkRange*) _tmp27_, "value-changed", (GCallback) _budgie_sound_widget_on_scale_change_gtk_range_value_changed, self, 0);
	_tmp28_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp28_, "input") == 0) {
		GvcMixerControl* _tmp29_;
		GvcMixerControl* _tmp30_;
		GvcMixerControl* _tmp31_;
		GvcMixerControl* _tmp32_;
		GtkScale* _tmp33_;
		BudgieHeaderWidget* _tmp34_;
		GtkBox* _tmp35_;
		GtkListBox* _tmp36_;
		GtkListBox* _tmp37_;
		GtkListBox* _tmp38_;
		_tmp29_ = self->priv->mixer;
		g_signal_connect_object (_tmp29_, "default-source-changed", (GCallback) _budgie_sound_widget_on_device_changed_gvc_mixer_control_default_source_changed, self, 0);
		_tmp30_ = self->priv->mixer;
		g_signal_connect_object (_tmp30_, "state-changed", (GCallback) _budgie_sound_widget_on_state_changed_gvc_mixer_control_state_changed, self, 0);
		_tmp31_ = self->priv->mixer;
		g_signal_connect_object (_tmp31_, "input-added", (GCallback) _budgie_sound_widget_on_device_added_gvc_mixer_control_input_added, self, 0);
		_tmp32_ = self->priv->mixer;
		g_signal_connect_object (_tmp32_, "input-removed", (GCallback) _budgie_sound_widget_on_device_removed_gvc_mixer_control_input_removed, self, 0);
		_tmp33_ = self->priv->volume_slider;
		_tmp34_ = budgie_header_widget_new ("", "microphone-sensitivity-muted-symbolic", FALSE, (GtkWidget*) _tmp33_, NULL);
		g_object_ref_sink (_tmp34_);
		_g_object_unref0 (self->priv->header);
		self->priv->header = _tmp34_;
		_tmp35_ = self->priv->main_layout;
		_tmp36_ = self->priv->devices_list;
		gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
		_tmp37_ = self->priv->devices_list;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp37_, 10);
		_tmp38_ = self->priv->devices_list;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp38_, 10);
	} else {
		GSettings* _tmp39_;
		GHashFunc _tmp40_;
		GEqualFunc _tmp41_;
		GHashTable* _tmp42_;
		GSettings* _tmp43_;
		GSettings* _tmp44_;
		GSettings* _tmp45_;
		GvcMixerControl* _tmp46_;
		GvcMixerControl* _tmp47_;
		GvcMixerControl* _tmp48_;
		GvcMixerControl* _tmp49_;
		GvcMixerControl* _tmp50_;
		GvcMixerControl* _tmp51_;
		GSettings* _tmp52_;
		gchar* _tmp53_;
		GSettings* _tmp54_;
		GSettings* _tmp55_;
		GtkBox* _tmp56_;
		GtkListBox* _tmp57_;
		GtkListBox* _tmp58_;
		GtkStyleContext* _tmp59_;
		GtkListBox* _tmp60_;
		GtkStyleContext* _tmp61_;
		GtkListBox* _tmp62_;
		GtkListBox* _tmp63_;
		GtkRevealer* _tmp64_;
		GtkRevealer* _tmp65_;
		GtkRevealer* _tmp66_;
		GtkRevealer* _tmp67_;
		GtkListBox* _tmp68_;
		GtkRevealer* _tmp69_;
		GtkRevealer* _tmp70_;
		GtkRevealer* _tmp71_;
		BudgieStartListening* _tmp72_;
		GtkRevealer* _tmp73_;
		BudgieStartListening* _tmp74_;
		GtkBox* _tmp75_;
		GtkRevealer* _tmp76_;
		GtkBox* _tmp77_;
		GtkRevealer* _tmp78_;
		GtkStack* _tmp79_;
		GtkStack* _tmp80_;
		GtkStack* _tmp81_;
		GtkStack* _tmp82_;
		GtkStack* _tmp83_;
		GtkStack* _tmp84_;
		GtkBox* _tmp85_;
		GtkStack* _tmp86_;
		GtkListBox* _tmp87_;
		GtkStackSwitcher* _tmp88_;
		GtkStackSwitcher* _tmp89_;
		GtkStack* _tmp90_;
		GtkStackSwitcher* _tmp91_;
		GSettings* _tmp92_;
		GtkScale* _tmp93_;
		BudgieHeaderWidget* _tmp94_;
		GtkBox* _tmp95_;
		GtkStack* _tmp96_;
		GtkBox* _tmp97_;
		GtkStackSwitcher* _tmp98_;
		GtkRevealer* _tmp99_;
		GtkRevealer* _tmp100_;
		_tmp39_ = g_settings_new ("org.gnome.desktop.sound");
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp39_;
		_tmp40_ = g_direct_hash;
		_tmp41_ = g_direct_equal;
		_tmp42_ = g_hash_table_new_full (_tmp40_, _tmp41_, NULL, _g_object_unref0_);
		_g_hash_table_unref0 (self->priv->apps);
		self->priv->apps = _tmp42_;
		_tmp43_ = g_settings_new ("com.solus-project.budgie-panel");
		_g_object_unref0 (self->priv->budgie_settings);
		self->priv->budgie_settings = _tmp43_;
		_tmp44_ = g_settings_new ("com.solus-project.budgie-raven");
		_g_object_unref0 (self->priv->raven_settings);
		self->priv->raven_settings = _tmp44_;
		_tmp45_ = g_settings_new ("org.gnome.desktop.interface");
		_g_object_unref0 (self->priv->gnome_desktop_settings);
		self->priv->gnome_desktop_settings = _tmp45_;
		_tmp46_ = self->priv->mixer;
		g_signal_connect_object (_tmp46_, "default-sink-changed", (GCallback) _budgie_sound_widget_on_device_changed_gvc_mixer_control_default_sink_changed, self, 0);
		_tmp47_ = self->priv->mixer;
		g_signal_connect_object (_tmp47_, "output-added", (GCallback) _budgie_sound_widget_on_device_added_gvc_mixer_control_output_added, self, 0);
		_tmp48_ = self->priv->mixer;
		g_signal_connect_object (_tmp48_, "output-removed", (GCallback) _budgie_sound_widget_on_device_removed_gvc_mixer_control_output_removed, self, 0);
		_tmp49_ = self->priv->mixer;
		g_signal_connect_object (_tmp49_, "state-changed", (GCallback) _budgie_sound_widget_on_state_changed_gvc_mixer_control_state_changed, self, 0);
		_tmp50_ = self->priv->mixer;
		g_signal_connect_object (_tmp50_, "stream-added", (GCallback) _budgie_sound_widget_on_stream_added_gvc_mixer_control_stream_added, self, 0);
		_tmp51_ = self->priv->mixer;
		g_signal_connect_object (_tmp51_, "stream-removed", (GCallback) _budgie_sound_widget_on_stream_removed_gvc_mixer_control_stream_removed, self, 0);
		_tmp52_ = self->priv->raven_settings;
		_tmp53_ = g_strconcat ("changed::", BUDGIE_SOUND_WIDGET_MAX_KEY, NULL);
		g_signal_connect_object (_tmp52_, _tmp53_, (GCallback) _budgie_sound_widget_on_volume_safety_changed_g_settings_changed, self, 0);
		_g_free0 (_tmp53_);
		_tmp54_ = self->priv->budgie_settings;
		g_signal_connect_object (_tmp54_, "changed::builtin-theme", (GCallback) _budgie_sound_widget_update_input_draw_markers_g_settings_changed, self, 0);
		_tmp55_ = self->priv->gnome_desktop_settings;
		g_signal_connect_object (_tmp55_, "changed::gtk-theme", (GCallback) _budgie_sound_widget_update_input_draw_markers_g_settings_changed, self, 0);
		_tmp56_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp56_);
		_g_object_unref0 (self->priv->apps_area);
		self->priv->apps_area = _tmp56_;
		_tmp57_ = (GtkListBox*) gtk_list_box_new ();
		g_object_ref_sink (_tmp57_);
		_g_object_unref0 (self->priv->apps_listbox);
		self->priv->apps_listbox = _tmp57_;
		_tmp58_ = self->priv->apps_listbox;
		_tmp59_ = gtk_widget_get_style_context ((GtkWidget*) _tmp58_);
		gtk_style_context_add_class (_tmp59_, "apps-list");
		_tmp60_ = self->priv->apps_listbox;
		_tmp61_ = gtk_widget_get_style_context ((GtkWidget*) _tmp60_);
		gtk_style_context_remove_class (_tmp61_, GTK_STYLE_CLASS_LIST);
		_tmp62_ = self->priv->apps_listbox;
		gtk_list_box_set_selection_mode (_tmp62_, GTK_SELECTION_NONE);
		_tmp63_ = self->priv->apps_listbox;
		gtk_list_box_set_sort_func (_tmp63_, ____lambda27__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
		_tmp64_ = (GtkRevealer*) gtk_revealer_new ();
		g_object_ref_sink (_tmp64_);
		_g_object_unref0 (self->priv->apps_list_revealer);
		self->priv->apps_list_revealer = _tmp64_;
		_tmp65_ = self->priv->apps_list_revealer;
		gtk_revealer_set_transition_duration (_tmp65_, (guint) 250);
		_tmp66_ = self->priv->apps_list_revealer;
		gtk_revealer_set_transition_type (_tmp66_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
		_tmp67_ = self->priv->apps_list_revealer;
		_tmp68_ = self->priv->apps_listbox;
		gtk_container_add ((GtkContainer*) _tmp67_, (GtkWidget*) _tmp68_);
		_tmp69_ = (GtkRevealer*) gtk_revealer_new ();
		g_object_ref_sink (_tmp69_);
		_g_object_unref0 (self->priv->listening_box_revealer);
		self->priv->listening_box_revealer = _tmp69_;
		_tmp70_ = self->priv->listening_box_revealer;
		gtk_revealer_set_transition_duration (_tmp70_, (guint) 250);
		_tmp71_ = self->priv->listening_box_revealer;
		gtk_revealer_set_transition_type (_tmp71_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
		_tmp72_ = budgie_start_listening_new ();
		g_object_ref_sink (_tmp72_);
		_g_object_unref0 (self->priv->listening_box);
		self->priv->listening_box = _tmp72_;
		_tmp73_ = self->priv->listening_box_revealer;
		_tmp74_ = self->priv->listening_box;
		gtk_container_add ((GtkContainer*) _tmp73_, (GtkWidget*) _tmp74_);
		_tmp75_ = self->priv->apps_area;
		_tmp76_ = self->priv->listening_box_revealer;
		gtk_box_pack_start (_tmp75_, (GtkWidget*) _tmp76_, TRUE, TRUE, (guint) 0);
		_tmp77_ = self->priv->apps_area;
		_tmp78_ = self->priv->apps_list_revealer;
		gtk_box_pack_end (_tmp77_, (GtkWidget*) _tmp78_, TRUE, TRUE, (guint) 0);
		_tmp79_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp79_);
		_g_object_unref0 (self->priv->widget_area);
		self->priv->widget_area = _tmp79_;
		_tmp80_ = self->priv->widget_area;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp80_, 10);
		_tmp81_ = self->priv->widget_area;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp81_, 10);
		_tmp82_ = self->priv->widget_area;
		gtk_stack_set_transition_duration (_tmp82_, (guint) 125);
		_tmp83_ = self->priv->widget_area;
		gtk_stack_set_transition_type (_tmp83_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
		_tmp84_ = self->priv->widget_area;
		_tmp85_ = self->priv->apps_area;
		gtk_stack_add_titled (_tmp84_, (GtkWidget*) _tmp85_, "apps", _ ("Apps"));
		_tmp86_ = self->priv->widget_area;
		_tmp87_ = self->priv->devices_list;
		gtk_stack_add_titled (_tmp86_, (GtkWidget*) _tmp87_, "devices", _ ("Devices"));
		_tmp88_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
		g_object_ref_sink (_tmp88_);
		_g_object_unref0 (self->priv->widget_area_switch);
		self->priv->widget_area_switch = _tmp88_;
		_tmp89_ = self->priv->widget_area_switch;
		_tmp90_ = self->priv->widget_area;
		gtk_stack_switcher_set_stack (_tmp89_, _tmp90_);
		_tmp91_ = self->priv->widget_area_switch;
		gtk_box_set_homogeneous ((GtkBox*) _tmp91_, TRUE);
		_tmp92_ = self->priv->raven_settings;
		budgie_sound_widget_set_slider_range_on_max (self, g_settings_get_boolean (_tmp92_, BUDGIE_SOUND_WIDGET_MAX_KEY));
		_tmp93_ = self->priv->volume_slider;
		_tmp94_ = budgie_header_widget_new ("", "audio-volume-muted-symbolic", FALSE, (GtkWidget*) _tmp93_, NULL);
		g_object_ref_sink (_tmp94_);
		_g_object_unref0 (self->priv->header);
		self->priv->header = _tmp94_;
		_tmp95_ = self->priv->main_layout;
		_tmp96_ = self->priv->widget_area;
		gtk_box_pack_start (_tmp95_, (GtkWidget*) _tmp96_, FALSE, FALSE, (guint) 0);
		_tmp97_ = self->priv->main_layout;
		_tmp98_ = self->priv->widget_area_switch;
		gtk_box_pack_start (_tmp97_, (GtkWidget*) _tmp98_, TRUE, FALSE, (guint) 0);
		_tmp99_ = self->priv->listening_box_revealer;
		gtk_revealer_set_reveal_child (_tmp99_, FALSE);
		_tmp100_ = self->priv->apps_list_revealer;
		gtk_revealer_set_reveal_child (_tmp100_, FALSE);
	}
	_tmp101_ = self->priv->mixer;
	gvc_mixer_control_open (_tmp101_);
	_tmp102_ = self->priv->header;
	_tmp103_ = budgie_raven_expander_new (_tmp102_);
	g_object_ref_sink (_tmp103_);
	expander = _tmp103_;
	_tmp104_ = expander;
	_tmp105_ = self->priv->widget_type;
	budgie_raven_expander_set_expanded (_tmp104_, g_strcmp0 (_tmp105_, "input") != 0);
	_tmp106_ = expander;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp106_, TRUE, TRUE, (guint) 0);
	_tmp107_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp107_);
	ebox = _tmp107_;
	_tmp108_ = ebox;
	_tmp109_ = gtk_widget_get_style_context ((GtkWidget*) _tmp108_);
	gtk_style_context_add_class (_tmp109_, "raven-background");
	_tmp110_ = expander;
	_tmp111_ = ebox;
	gtk_container_add ((GtkContainer*) _tmp110_, (GtkWidget*) _tmp111_);
	_tmp112_ = ebox;
	_tmp113_ = self->priv->main_layout;
	gtk_container_add ((GtkContainer*) _tmp112_, (GtkWidget*) _tmp113_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp114_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp114_, "output") == 0) {
		budgie_sound_widget_on_volume_safety_changed (self);
		budgie_sound_widget_toggle_start_listening (self);
	}
	_g_object_unref0 (ebox);
	_g_object_unref0 (expander);
	return self;
}

BudgieSoundWidget*
budgie_sound_widget_new (const gchar* c_widget_type)
{
	return budgie_sound_widget_construct (BUDGIE_TYPE_SOUND_WIDGET, c_widget_type);
}

/**
 * has_devices will check if we have devices associated with this type
 */
gboolean
budgie_sound_widget_has_devices (BudgieSoundWidget* self)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->devices;
	if (g_hash_table_size (_tmp1_) != ((guint) 0)) {
		GvcMixerControl* _tmp2_;
		GSList* _tmp3_;
		GSList* _tmp4_;
		_tmp2_ = self->priv->mixer;
		_tmp3_ = gvc_mixer_control_get_cards (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_slist_length (_tmp4_) != ((guint) 0);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_slist_free (_tmp4_), NULL));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * on_device_added will handle when an input or output device has been added
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
budgie_sound_widget_on_device_added (BudgieSoundWidget* self,
                                     guint id)
{
	GHashTable* _tmp0_;
	GvcMixerUIDevice* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GvcMixerUIDevice* device = NULL;
	GvcMixerUIDevice* _tmp7_;
	GvcMixerUIDevice* _tmp8_;
	GvcMixerUIDevice* _tmp9_;
	void* _tmp10_;
	void* _tmp11_;
	GvcMixerCard* card = NULL;
	GvcMixerUIDevice* _tmp12_;
	void* _tmp13_;
	void* _tmp14_;
	GvcMixerCard* _tmp15_;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	GtkBox* box = NULL;
	GtkBox* _tmp22_;
	GtkLabel* label = NULL;
	GvcMixerUIDevice* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GvcMixerCard* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkBox* _tmp38_;
	GtkLabel* _tmp39_;
	GtkListBoxRow* list_item = NULL;
	GtkListBoxRow* _tmp40_;
	GtkListBoxRow* _tmp41_;
	GtkListBoxRow* _tmp42_;
	GtkBox* _tmp43_;
	GtkListBoxRow* _tmp44_;
	GtkListBox* _tmp45_;
	GtkListBoxRow* _tmp46_;
	GHashTable* _tmp47_;
	GtkListBoxRow* _tmp48_;
	GtkListBoxRow* _tmp49_;
	GtkListBoxRow* _tmp50_;
	GtkListBox* _tmp51_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices;
	if (g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) id))) {
		return;
	}
	_tmp2_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp2_, "input") == 0) {
		GvcMixerControl* _tmp3_;
		GvcMixerUIDevice* _tmp4_;
		_tmp3_ = self->priv->mixer;
		_tmp4_ = gvc_mixer_control_lookup_input_id (_tmp3_, id);
		_tmp1_ = _tmp4_;
	} else {
		GvcMixerControl* _tmp5_;
		GvcMixerUIDevice* _tmp6_;
		_tmp5_ = self->priv->mixer;
		_tmp6_ = gvc_mixer_control_lookup_output_id (_tmp5_, id);
		_tmp1_ = _tmp6_;
	}
	_tmp7_ = _g_object_ref0 (_tmp1_);
	device = _tmp7_;
	_tmp8_ = device;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp9_ = device;
	g_object_get (_tmp9_, "card", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp12_ = device;
	g_object_get (_tmp12_, "card", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, gvc_mixer_card_get_type ()) ? ((GvcMixerCard*) _tmp14_) : NULL);
	card = _tmp15_;
	_tmp17_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp17_, "output") == 0) {
		GvcMixerUIDevice* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp18_ = device;
		g_object_get (_tmp18_, "description", &_tmp19_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp16_ = string_contains (_tmp21_, "Digital Output");
		_g_free0 (_tmp21_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		_g_object_unref0 (card);
		_g_object_unref0 (device);
		return;
	}
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp22_);
	box = _tmp22_;
	_tmp23_ = device;
	g_object_get (_tmp23_, "description", &_tmp24_, NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp27_ = card;
	g_object_get (_tmp27_, "name", &_tmp28_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup_printf ("%s - %s", _tmp26_, _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = (GtkLabel*) gtk_label_new (_tmp32_);
	g_object_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp26_);
	label = _tmp34_;
	_tmp35_ = label;
	gtk_label_set_justify (_tmp35_, GTK_JUSTIFY_LEFT);
	_tmp36_ = label;
	gtk_label_set_max_width_chars (_tmp36_, 30);
	_tmp37_ = label;
	gtk_label_set_ellipsize (_tmp37_, PANGO_ELLIPSIZE_END);
	_tmp38_ = box;
	_tmp39_ = label;
	gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, FALSE, TRUE, (guint) 0);
	_tmp40_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp40_);
	list_item = _tmp40_;
	_tmp41_ = list_item;
	g_object_set ((GtkWidget*) _tmp41_, "height-request", 32, NULL);
	_tmp42_ = list_item;
	_tmp43_ = box;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = list_item;
	g_object_set_data_full ((GObject*) _tmp44_, "device_id", (gpointer) ((guintptr) id), NULL);
	_tmp45_ = self->priv->devices_list;
	_tmp46_ = list_item;
	gtk_list_box_insert (_tmp45_, (GtkWidget*) _tmp46_, -1);
	_tmp47_ = self->priv->devices;
	_tmp48_ = list_item;
	_tmp49_ = _g_object_ref0 (_tmp48_);
	g_hash_table_insert (_tmp47_, (gpointer) ((guintptr) id), _tmp49_);
	_tmp50_ = list_item;
	gtk_widget_show_all ((GtkWidget*) _tmp50_);
	_tmp51_ = self->priv->devices_list;
	gtk_widget_queue_draw ((GtkWidget*) _tmp51_);
	g_signal_emit (self, budgie_sound_widget_signals[BUDGIE_SOUND_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (list_item);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	_g_object_unref0 (card);
	_g_object_unref0 (device);
}

/**
 * on_device_changed will handle when a Gvc.MixerUIDevice has been changed
 */
static void
__lambda25_ (BudgieSoundWidget* self,
             GObject* n,
             GParamSpec* p)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (p != NULL);
	_tmp1_ = p->name;
	if (g_strcmp0 (_tmp1_, "volume") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = p->name;
		_tmp0_ = g_strcmp0 (_tmp2_, "is-muted") == 0;
	}
	if (_tmp0_) {
		budgie_sound_widget_update_volume (self);
	}
}

static void
___lambda25__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda25_ ((BudgieSoundWidget*) self, _sender, pspec);
}

static void
budgie_sound_widget_on_device_changed (BudgieSoundWidget* self,
                                       guint id)
{
	GvcMixerStream* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GvcMixerStream* stream = NULL;
	GvcMixerStream* _tmp6_;
	GvcMixerStream* _tmp7_;
	GvcMixerStream* _tmp8_;
	GvcMixerStream* _tmp9_;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp10_;
	GvcMixerStream* _tmp11_;
	GvcMixerUIDevice* _tmp12_;
	GvcMixerUIDevice* _tmp13_;
	GtkListBoxRow* list_item = NULL;
	GHashTable* _tmp14_;
	GvcMixerUIDevice* _tmp15_;
	gconstpointer _tmp16_;
	GtkListBoxRow* _tmp17_;
	GtkListBoxRow* _tmp18_;
	GvcMixerStream* _tmp21_;
	GvcMixerStream* _tmp23_;
	gulong _tmp24_;
	GvcMixerStream* _tmp25_;
	GvcMixerStream* _tmp26_;
	GtkListBox* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp1_, "input") == 0) {
		GvcMixerControl* _tmp2_;
		GvcMixerStream* _tmp3_;
		_tmp2_ = self->priv->mixer;
		_tmp3_ = gvc_mixer_control_get_default_source (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		GvcMixerControl* _tmp4_;
		GvcMixerStream* _tmp5_;
		_tmp4_ = self->priv->mixer;
		_tmp5_ = gvc_mixer_control_get_default_sink (_tmp4_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp0_);
	stream = _tmp6_;
	_tmp7_ = stream;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (stream);
		return;
	}
	_tmp8_ = stream;
	_tmp9_ = self->priv->primary_stream;
	if (_tmp8_ == _tmp9_) {
		_g_object_unref0 (stream);
		return;
	}
	_tmp10_ = self->priv->mixer;
	_tmp11_ = stream;
	_tmp12_ = gvc_mixer_control_lookup_device_from_stream (_tmp10_, _tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	device = _tmp13_;
	_tmp14_ = self->priv->devices;
	_tmp15_ = device;
	_tmp16_ = g_hash_table_lookup (_tmp14_, (gpointer) ((guintptr) gvc_mixer_ui_device_get_id (_tmp15_)));
	_tmp17_ = _g_object_ref0 ((GtkListBoxRow*) _tmp16_);
	list_item = _tmp17_;
	_tmp18_ = list_item;
	if (_tmp18_ != NULL) {
		GtkListBox* _tmp19_;
		GtkListBoxRow* _tmp20_;
		_tmp19_ = self->priv->devices_list;
		_tmp20_ = list_item;
		gtk_list_box_select_row (_tmp19_, _tmp20_);
	}
	_tmp21_ = self->priv->primary_stream;
	if (_tmp21_ != NULL) {
		GvcMixerStream* _tmp22_;
		_tmp22_ = self->priv->primary_stream;
		g_signal_handler_disconnect ((GObject*) _tmp22_, self->priv->primary_notify_id);
		self->priv->primary_notify_id = (gulong) 0;
	}
	_tmp23_ = stream;
	_tmp24_ = g_signal_connect_object ((GObject*) _tmp23_, "notify", (GCallback) ___lambda25__g_object_notify, self, 0);
	self->priv->primary_notify_id = _tmp24_;
	_tmp25_ = stream;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (self->priv->primary_stream);
	self->priv->primary_stream = _tmp26_;
	budgie_sound_widget_update_volume (self);
	_tmp27_ = self->priv->devices_list;
	gtk_widget_queue_draw ((GtkWidget*) _tmp27_);
	g_signal_emit (self, budgie_sound_widget_signals[BUDGIE_SOUND_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (list_item);
	_g_object_unref0 (device);
	_g_object_unref0 (stream);
}

/**
 * on_device_removed will handle when a Gvc.MixerUIDevice has been removed
 */
static void
budgie_sound_widget_on_device_removed (BudgieSoundWidget* self,
                                       guint id)
{
	GtkListBoxRow* list_item = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	GHashTable* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GtkListBox* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) id));
	_tmp2_ = _g_object_ref0 ((GtkListBoxRow*) _tmp1_);
	list_item = _tmp2_;
	_tmp3_ = list_item;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (list_item);
		return;
	}
	_tmp4_ = self->priv->devices;
	g_hash_table_steal (_tmp4_, (gpointer) ((guintptr) id));
	_tmp5_ = list_item;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->devices_list;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
	g_signal_emit (self, budgie_sound_widget_signals[BUDGIE_SOUND_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (list_item);
}

/**
 * get_control_for_app will get the respective inner AppSoundControl of a ListBoxRow associated with the id
 */
static BudgieAppSoundControl*
budgie_sound_widget_get_control_for_app (BudgieSoundWidget* self,
                                         guint id)
{
	BudgieAppSoundControl* control = NULL;
	GHashTable* _tmp0_;
	BudgieAppSoundControl* result;
	g_return_val_if_fail (self != NULL, NULL);
	control = NULL;
	_tmp0_ = self->priv->apps;
	if (g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) id))) {
		GtkListBoxRow* row = NULL;
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		_tmp1_ = self->priv->apps;
		_tmp2_ = g_hash_table_lookup (_tmp1_, (gpointer) ((guintptr) id));
		_tmp3_ = _g_object_ref0 ((GtkListBoxRow*) _tmp2_);
		row = _tmp3_;
		_tmp4_ = row;
		if (_tmp4_ != NULL) {
			GtkListBoxRow* _tmp5_;
			GtkWidget* _tmp6_;
			BudgieAppSoundControl* _tmp7_;
			_tmp5_ = row;
			_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BUDGIE_TYPE_APP_SOUND_CONTROL, BudgieAppSoundControl));
			_g_object_unref0 (control);
			control = _tmp7_;
		}
		_g_object_unref0 (row);
	}
	result = control;
	return result;
}

/**
 * on_device_selected will handle when a checkbox related to an input or output device is selected
 */
static void
budgie_sound_widget_on_device_selected (BudgieSoundWidget* self,
                                        GtkListBoxRow* list_item)
{
	GtkListBox* _tmp0_;
	guint id = 0U;
	gconstpointer _tmp1_;
	GvcMixerUIDevice* _tmp2_ = NULL;
	const gchar* _tmp3_;
	GvcMixerUIDevice* device = NULL;
	GvcMixerUIDevice* _tmp8_;
	GvcMixerUIDevice* _tmp9_;
	GtkListBox* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices_list;
	g_signal_handlers_block_by_func ((void*) _tmp0_, (void*) budgie_sound_widget_on_device_selected, self);
	_tmp1_ = g_object_get_data ((GObject*) list_item, "device_id");
	id = (guint) ((guintptr) _tmp1_);
	_tmp3_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp3_, "input") == 0) {
		GvcMixerControl* _tmp4_;
		GvcMixerUIDevice* _tmp5_;
		_tmp4_ = self->priv->mixer;
		_tmp5_ = gvc_mixer_control_lookup_input_id (_tmp4_, id);
		_tmp2_ = _tmp5_;
	} else {
		GvcMixerControl* _tmp6_;
		GvcMixerUIDevice* _tmp7_;
		_tmp6_ = self->priv->mixer;
		_tmp7_ = gvc_mixer_control_lookup_output_id (_tmp6_, id);
		_tmp2_ = _tmp7_;
	}
	_tmp8_ = _g_object_ref0 (_tmp2_);
	device = _tmp8_;
	_tmp9_ = device;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		_tmp10_ = self->priv->widget_type;
		if (g_strcmp0 (_tmp10_, "input") == 0) {
			GvcMixerControl* _tmp11_;
			GvcMixerUIDevice* _tmp12_;
			_tmp11_ = self->priv->mixer;
			_tmp12_ = device;
			gvc_mixer_control_change_input (_tmp11_, _tmp12_);
		} else {
			GvcMixerControl* _tmp13_;
			GvcMixerUIDevice* _tmp14_;
			_tmp13_ = self->priv->mixer;
			_tmp14_ = device;
			gvc_mixer_control_change_output (_tmp13_, _tmp14_);
		}
	}
	_tmp15_ = self->priv->devices_list;
	g_signal_handlers_unblock_by_func ((void*) _tmp15_, (void*) budgie_sound_widget_on_device_selected, self);
	_g_object_unref0 (device);
}

/**
 * When our volume slider has changed
 */
static void
budgie_sound_widget_on_scale_change (BudgieSoundWidget* self)
{
	GvcMixerStream* _tmp0_;
	GvcMixerStream* _tmp1_;
	GtkScale* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_stream;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->primary_stream;
	_tmp2_ = self->priv->volume_slider;
	if (gvc_mixer_stream_set_volume (_tmp1_, (guint32) gtk_range_get_value ((GtkRange*) _tmp2_))) {
		GvcMixerStream* _tmp3_;
		_tmp3_ = self->priv->primary_stream;
		gvc_mixer_stream_push_volume (_tmp3_);
	}
}

/**
 * on_state_changed will handle when the state of our Mixer or its streams have changed
 */
static void
budgie_sound_widget_on_state_changed (BudgieSoundWidget* self,
                                      guint id)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp0_, "output") == 0) {
		GvcMixerStream* stream = NULL;
		GvcMixerControl* _tmp1_;
		GvcMixerStream* _tmp2_;
		GvcMixerStream* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GvcMixerStream* _tmp5_;
		_tmp1_ = self->priv->mixer;
		_tmp2_ = gvc_mixer_control_lookup_stream_id (_tmp1_, id);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		stream = _tmp3_;
		_tmp5_ = stream;
		if (_tmp5_ != NULL) {
			GvcMixerStream* _tmp6_;
			_tmp6_ = stream;
			_tmp4_ = gvc_mixer_stream_get_card_index (_tmp6_) == -1;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GHashTable* _tmp7_;
			_tmp7_ = self->priv->apps;
			if (g_hash_table_contains (_tmp7_, (gpointer) ((guintptr) id))) {
				BudgieAppSoundControl* control = NULL;
				BudgieAppSoundControl* _tmp8_;
				BudgieAppSoundControl* _tmp9_;
				_tmp8_ = budgie_sound_widget_get_control_for_app (self, id);
				control = _tmp8_;
				_tmp9_ = control;
				if (_tmp9_ != NULL) {
					GvcMixerStream* _tmp10_;
					_tmp10_ = stream;
					if (gvc_mixer_stream_is_running (_tmp10_)) {
						BudgieAppSoundControl* _tmp11_;
						_tmp11_ = control;
						budgie_app_sound_control_refresh (_tmp11_);
					} else {
						BudgieAppSoundControl* _tmp12_;
						GHashTable* _tmp13_;
						_tmp12_ = control;
						gtk_widget_destroy ((GtkWidget*) _tmp12_);
						_tmp13_ = self->priv->apps;
						g_hash_table_steal (_tmp13_, (gpointer) ((guintptr) id));
					}
				}
				budgie_sound_widget_toggle_start_listening (self);
				_g_object_unref0 (control);
			}
		}
		_g_object_unref0 (stream);
	}
	g_signal_emit (self, budgie_sound_widget_signals[BUDGIE_SOUND_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
}

/**
 * on_stream_added will handle when a stream (like an application) has been added
 */
static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BudgieSoundWidget* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->control);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_____lambda26_ (Block7Data* _data7_)
{
	BudgieSoundWidget* self;
	BudgieAppSoundControl* _tmp0_;
	self = _data7_->self;
	_tmp0_ = _data7_->control;
	budgie_app_sound_control_refresh_volume (_tmp0_);
}

static void
______lambda26__gvc_channel_map_volume_changed (GvcChannelMap* _sender,
                                                gboolean set,
                                                gpointer self)
{
	_____lambda26_ (self);
}

static void
budgie_sound_widget_on_stream_added (BudgieSoundWidget* self,
                                     guint id)
{
	GvcMixerStream* stream = NULL;
	GvcMixerControl* _tmp0_;
	GvcMixerStream* _tmp1_;
	GvcMixerStream* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GvcMixerStream* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mixer;
	_tmp1_ = gvc_mixer_control_lookup_stream_id (_tmp0_, id);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	stream = _tmp2_;
	_tmp4_ = stream;
	if (_tmp4_ != NULL) {
		GvcMixerStream* _tmp5_;
		_tmp5_ = stream;
		_tmp3_ = gvc_mixer_stream_get_card_index (_tmp5_) == -1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Block7Data* _data7_;
		gchar* name = NULL;
		GvcMixerStream* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* icon = NULL;
		GvcMixerStream* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		GvcMixerStream* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		GvcMixerStream* _tmp16_;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_;
		const gchar* _tmp20_;
		GvcMixerUIDevice* device = NULL;
		GvcMixerControl* _tmp21_;
		GvcMixerStream* _tmp22_;
		GvcMixerUIDevice* _tmp23_;
		GvcMixerUIDevice* _tmp24_;
		gboolean _tmp25_ = FALSE;
		GvcMixerUIDevice* _tmp26_;
		GHashTable* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp34_;
		GvcMixerControl* _tmp40_;
		GvcMixerStream* _tmp41_;
		GvcMixerStream* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		BudgieAppSoundControl* _tmp45_;
		BudgieAppSoundControl* _tmp46_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->self = g_object_ref (self);
		_tmp6_ = stream;
		_tmp7_ = gvc_mixer_stream_get_name (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		name = _tmp8_;
		_tmp9_ = stream;
		_tmp10_ = gvc_mixer_stream_get_icon_name (_tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		icon = _tmp11_;
		_tmp12_ = name;
		if (_tmp12_ == NULL) {
			_g_free0 (icon);
			_g_free0 (name);
			block7_data_unref (_data7_);
			_data7_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp13_ = stream;
		g_object_get (_tmp13_, "is-event-stream", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		if (_tmp15_) {
			_g_free0 (icon);
			_g_free0 (name);
			block7_data_unref (_data7_);
			_data7_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp16_ = stream;
		if (gvc_mixer_stream_get_volume (_tmp16_) == ((guint32) 100)) {
			_g_free0 (icon);
			_g_free0 (name);
			block7_data_unref (_data7_);
			_data7_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp18_ = icon;
		if (g_strcmp0 (_tmp18_, "") != 0) {
			const gchar* _tmp19_;
			_tmp19_ = icon;
			_tmp17_ = string_contains (_tmp19_, "audio-input-");
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			_g_free0 (icon);
			_g_free0 (name);
			block7_data_unref (_data7_);
			_data7_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp20_ = name;
		if (g_strcmp0 (_tmp20_, "System Sounds") == 0) {
			_g_free0 (icon);
			_g_free0 (name);
			block7_data_unref (_data7_);
			_data7_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp21_ = self->priv->mixer;
		_tmp22_ = stream;
		_tmp23_ = gvc_mixer_control_lookup_device_from_stream (_tmp21_, _tmp22_);
		_tmp24_ = _g_object_ref0 (_tmp23_);
		device = _tmp24_;
		_tmp26_ = device;
		if (_tmp26_ != NULL) {
			GvcMixerUIDevice* _tmp27_;
			_tmp27_ = device;
			_tmp25_ = !gvc_mixer_ui_device_is_output (_tmp27_);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			_g_object_unref0 (device);
			_g_free0 (icon);
			_g_free0 (name);
			block7_data_unref (_data7_);
			_data7_ = NULL;
			_g_object_unref0 (stream);
			return;
		}
		_tmp28_ = self->priv->derpers;
		_tmp29_ = name;
		if (g_hash_table_contains (_tmp28_, _tmp29_)) {
			GHashTable* _tmp30_;
			const gchar* _tmp31_;
			gconstpointer _tmp32_;
			gchar* _tmp33_;
			_tmp30_ = self->priv->derpers;
			_tmp31_ = name;
			_tmp32_ = g_hash_table_lookup (_tmp30_, _tmp31_);
			_tmp33_ = g_strdup ((const gchar*) _tmp32_);
			_g_free0 (icon);
			icon = _tmp33_;
		}
		_tmp34_ = name;
		if (g_strcmp0 (_tmp34_, "AudioIPC Server") == 0) {
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp35_ = g_strdup ("firefox");
			_g_free0 (icon);
			icon = _tmp35_;
			_tmp36_ = g_strdup ("Firefox");
			_g_free0 (name);
			name = _tmp36_;
		} else {
			const gchar* _tmp37_;
			_tmp37_ = name;
			if (g_strcmp0 (_tmp37_, "WEBRTC VoiceEngine") == 0) {
				gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp38_ = g_strdup ("discord");
				_g_free0 (icon);
				icon = _tmp38_;
				_tmp39_ = g_strdup ("Discord");
				_g_free0 (name);
				name = _tmp39_;
			}
		}
		_tmp40_ = self->priv->mixer;
		_tmp41_ = self->priv->primary_stream;
		_tmp42_ = stream;
		_tmp43_ = icon;
		_tmp44_ = name;
		_tmp45_ = budgie_app_sound_control_new (_tmp40_, _tmp41_, _tmp42_, _tmp43_, _tmp44_);
		g_object_ref_sink (_tmp45_);
		_data7_->control = _tmp45_;
		_tmp46_ = _data7_->control;
		if (_tmp46_ != NULL) {
			GtkListBoxRow* list_row = NULL;
			GtkListBoxRow* _tmp47_;
			GtkListBoxRow* _tmp48_;
			BudgieAppSoundControl* _tmp49_;
			GtkListBox* _tmp50_;
			GtkListBoxRow* _tmp51_;
			GHashTable* _tmp52_;
			GtkListBoxRow* _tmp53_;
			GtkListBoxRow* _tmp54_;
			GtkListBox* _tmp55_;
			GvcChannelMap* channel_map = NULL;
			GvcMixerStream* _tmp56_;
			GvcChannelMap* _tmp57_;
			GvcChannelMap* _tmp58_;
			GvcChannelMap* _tmp59_;
			_tmp47_ = (GtkListBoxRow*) gtk_list_box_row_new ();
			g_object_ref_sink (_tmp47_);
			list_row = _tmp47_;
			_tmp48_ = list_row;
			_tmp49_ = _data7_->control;
			gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
			_tmp50_ = self->priv->apps_listbox;
			_tmp51_ = list_row;
			gtk_list_box_insert (_tmp50_, (GtkWidget*) _tmp51_, -1);
			_tmp52_ = self->priv->apps;
			_tmp53_ = list_row;
			_tmp54_ = _g_object_ref0 (_tmp53_);
			g_hash_table_insert (_tmp52_, (gpointer) ((guintptr) id), _tmp54_);
			_tmp55_ = self->priv->apps_listbox;
			gtk_widget_show_all ((GtkWidget*) _tmp55_);
			budgie_sound_widget_toggle_start_listening (self);
			_tmp56_ = stream;
			_tmp57_ = gvc_mixer_stream_get_channel_map (_tmp56_);
			_tmp58_ = _g_object_ref0 (_tmp57_);
			channel_map = _tmp58_;
			_tmp59_ = channel_map;
			if (_tmp59_ != NULL) {
				GvcChannelMap* _tmp60_;
				_tmp60_ = channel_map;
				g_signal_connect_data (_tmp60_, "volume-changed", (GCallback) ______lambda26__gvc_channel_map_volume_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
			}
			_g_object_unref0 (channel_map);
			_g_object_unref0 (list_row);
		}
		_g_object_unref0 (device);
		_g_free0 (icon);
		_g_free0 (name);
		block7_data_unref (_data7_);
		_data7_ = NULL;
	}
	_g_object_unref0 (stream);
}

/**
 * on_stream_removed will handle when a stream (like an application) has been removed
 */
static void
budgie_sound_widget_on_stream_removed (BudgieSoundWidget* self,
                                       guint id)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->apps;
	if (g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) id))) {
		GtkListBoxRow* row = NULL;
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		GHashTable* _tmp7_;
		_tmp1_ = self->priv->apps;
		_tmp2_ = g_hash_table_lookup (_tmp1_, (gpointer) ((guintptr) id));
		_tmp3_ = _g_object_ref0 ((GtkListBoxRow*) _tmp2_);
		row = _tmp3_;
		_tmp4_ = row;
		if (_tmp4_ != NULL) {
			GtkListBox* _tmp5_;
			GtkListBoxRow* _tmp6_;
			_tmp5_ = self->priv->apps_listbox;
			_tmp6_ = row;
			gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
		}
		_tmp7_ = self->priv->apps;
		g_hash_table_steal (_tmp7_, (gpointer) ((guintptr) id));
		budgie_sound_widget_toggle_start_listening (self);
		_g_object_unref0 (row);
	}
}

/**
 * on_volume_safety_changed will listen to changes to our above 100 percent key
 * If the volume is allowed to go over 100%, we'll update the slider range. Otherwise, we'll change or keep it at 100%
 */
static void
budgie_sound_widget_on_volume_safety_changed (BudgieSoundWidget* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven_settings;
	budgie_sound_widget_set_slider_range_on_max (self, g_settings_get_boolean (_tmp0_, BUDGIE_SOUND_WIDGET_MAX_KEY));
}

static void
budgie_sound_widget_set_slider_range_on_max (BudgieSoundWidget* self,
                                             gboolean allow_overdrive)
{
	gdouble current_volume = 0.0;
	GtkScale* _tmp0_;
	gdouble vol_max = 0.0;
	GvcMixerControl* _tmp1_;
	gdouble vol_max_above = 0.0;
	GvcMixerControl* _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble step_size = 0.0;
	gint slider_start = 0;
	gint slider_end = 0;
	GtkScale* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_slider;
	current_volume = gtk_range_get_value ((GtkRange*) _tmp0_);
	_tmp1_ = self->priv->mixer;
	vol_max = gvc_mixer_control_get_vol_max_norm (_tmp1_);
	_tmp2_ = self->priv->mixer;
	vol_max_above = gvc_mixer_control_get_vol_max_amplified (_tmp2_);
	if (allow_overdrive) {
		_tmp3_ = vol_max_above / 20;
	} else {
		_tmp3_ = vol_max / 20;
	}
	step_size = _tmp3_;
	slider_start = 0;
	slider_end = 0;
	_tmp4_ = self->priv->volume_slider;
	gtk_range_get_slider_range ((GtkRange*) _tmp4_, &_tmp5_, &_tmp6_);
	slider_start = _tmp5_;
	slider_end = _tmp6_;
	if (allow_overdrive) {
		_tmp7_ = ((gdouble) slider_end) != vol_max_above;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GtkScale* _tmp8_;
		GtkScale* _tmp9_;
		GtkScale* _tmp10_;
		_tmp8_ = self->priv->volume_slider;
		gtk_range_set_increments ((GtkRange*) _tmp8_, step_size, step_size);
		_tmp9_ = self->priv->volume_slider;
		gtk_range_set_range ((GtkRange*) _tmp9_, (gdouble) 0, vol_max_above);
		_tmp10_ = self->priv->volume_slider;
		gtk_range_set_value ((GtkRange*) _tmp10_, current_volume);
	} else {
		gboolean _tmp11_ = FALSE;
		if (!allow_overdrive) {
			_tmp11_ = ((gdouble) slider_end) != vol_max;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GtkScale* _tmp12_;
			GtkScale* _tmp13_;
			GtkScale* _tmp14_;
			_tmp12_ = self->priv->volume_slider;
			gtk_range_set_increments ((GtkRange*) _tmp12_, step_size, step_size);
			_tmp13_ = self->priv->volume_slider;
			gtk_range_set_range ((GtkRange*) _tmp13_, (gdouble) 0, vol_max);
			_tmp14_ = self->priv->volume_slider;
			gtk_range_set_value ((GtkRange*) _tmp14_, current_volume);
		}
	}
	budgie_sound_widget_update_input_draw_markers (self);
}

/**
 * toggle_start_listening will handle showing or hiding our Start Listening box if needed
 */
static void
budgie_sound_widget_toggle_start_listening (BudgieSoundWidget* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp0_, "output") == 0) {
		gboolean apps_exist = FALSE;
		GHashTable* _tmp1_;
		guint _tmp2_;
		guint _tmp3_;
		GtkRevealer* _tmp4_;
		GtkRevealer* _tmp5_;
		_tmp1_ = self->priv->apps;
		_tmp2_ = g_hash_table_size (_tmp1_);
		_tmp3_ = _tmp2_;
		apps_exist = _tmp3_ != ((guint) 0);
		_tmp4_ = self->priv->listening_box_revealer;
		gtk_revealer_set_reveal_child (_tmp4_, !apps_exist);
		_tmp5_ = self->priv->apps_list_revealer;
		gtk_revealer_set_reveal_child (_tmp5_, apps_exist);
	}
}

/**
 * update_input_draw_markers will update our draw markers
 */
static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
budgie_sound_widget_update_input_draw_markers (BudgieSoundWidget* self)
{
	const gchar* _tmp0_;
	gboolean builtin_enabled = FALSE;
	GSettings* _tmp1_;
	gchar* current_theme = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gboolean supported_theme = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp0_, "input") == 0) {
		return;
	}
	_tmp1_ = self->priv->budgie_settings;
	builtin_enabled = g_settings_get_boolean (_tmp1_, "builtin-theme");
	_tmp2_ = self->priv->gnome_desktop_settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "gtk-theme");
	current_theme = _tmp3_;
	_tmp4_ = current_theme;
	supported_theme = string_index_of (_tmp4_, "Arc", 0) == -1;
	if (!builtin_enabled) {
		_tmp5_ = supported_theme;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean allow_higher_than_max = FALSE;
		GSettings* _tmp6_;
		_tmp6_ = self->priv->raven_settings;
		allow_higher_than_max = g_settings_get_boolean (_tmp6_, BUDGIE_SOUND_WIDGET_MAX_KEY);
		if (allow_higher_than_max) {
			gdouble vol_max = 0.0;
			GvcMixerControl* _tmp7_;
			GtkScale* _tmp8_;
			_tmp7_ = self->priv->mixer;
			vol_max = gvc_mixer_control_get_vol_max_norm (_tmp7_);
			_tmp8_ = self->priv->volume_slider;
			gtk_scale_add_mark (_tmp8_, vol_max, GTK_POS_BOTTOM, "");
		} else {
			GtkScale* _tmp9_;
			_tmp9_ = self->priv->volume_slider;
			gtk_scale_clear_marks (_tmp9_);
		}
	} else {
		GtkScale* _tmp10_;
		_tmp10_ = self->priv->volume_slider;
		gtk_scale_clear_marks (_tmp10_);
	}
	_g_free0 (current_theme);
}

/**
 * update_volume will handle updating our volume slider and output header during device change
 */
static void
budgie_sound_widget_update_volume (BudgieSoundWidget* self)
{
	guint32 vol = 0U;
	GvcMixerStream* _tmp0_;
	gdouble vol_max = 0.0;
	GvcMixerControl* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gint n = 0;
	gchar* image_name = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	gchar* icon_prefix = NULL;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GvcMixerStream* _tmp10_;
	BudgieHeaderWidget* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gdouble step_size = 0.0;
	GtkScale* _tmp21_;
	GtkScale* _tmp22_;
	GtkScale* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_stream;
	vol = gvc_mixer_stream_get_volume (_tmp0_);
	_tmp1_ = self->priv->mixer;
	vol_max = gvc_mixer_control_get_vol_max_norm (_tmp1_);
	_tmp3_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp3_, "output") == 0) {
		GSettings* _tmp4_;
		_tmp4_ = self->priv->raven_settings;
		_tmp2_ = g_settings_get_boolean (_tmp4_, BUDGIE_SOUND_WIDGET_MAX_KEY);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GvcMixerControl* _tmp5_;
		_tmp5_ = self->priv->mixer;
		vol_max = gvc_mixer_control_get_vol_max_amplified (_tmp5_);
	}
	n = ((gint) floor ((3 * vol) / vol_max)) + 1;
	_tmp7_ = self->priv->widget_type;
	if (g_strcmp0 (_tmp7_, "input") == 0) {
		_tmp6_ = "microphone-sensitivity-";
	} else {
		_tmp6_ = "audio-volume-";
	}
	_tmp8_ = g_strdup (_tmp6_);
	icon_prefix = _tmp8_;
	_tmp10_ = self->priv->primary_stream;
	if (gvc_mixer_stream_get_is_muted (_tmp10_)) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = vol <= ((guint32) 0);
	}
	if (_tmp9_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("muted-symbolic");
		_g_free0 (image_name);
		image_name = _tmp11_;
	} else {
		switch (n) {
			case 1:
			{
				gchar* _tmp12_;
				_tmp12_ = g_strdup ("low-symbolic");
				_g_free0 (image_name);
				image_name = _tmp12_;
				break;
			}
			case 2:
			{
				gchar* _tmp13_;
				_tmp13_ = g_strdup ("medium-symbolic");
				_g_free0 (image_name);
				image_name = _tmp13_;
				break;
			}
			default:
			{
				gchar* _tmp14_;
				_tmp14_ = g_strdup ("high-symbolic");
				_g_free0 (image_name);
				image_name = _tmp14_;
				break;
			}
		}
	}
	_tmp15_ = self->priv->header;
	_tmp16_ = icon_prefix;
	_tmp17_ = image_name;
	_tmp18_ = g_strconcat (_tmp16_, _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	budgie_header_widget_set_icon_name (_tmp15_, _tmp19_);
	_g_free0 (_tmp19_);
	step_size = vol_max / 20;
	if (self->priv->scale_id > ((gulong) 0)) {
		GtkScale* _tmp20_;
		_tmp20_ = self->priv->volume_slider;
		g_signal_handler_block (_tmp20_, self->priv->scale_id);
	}
	_tmp21_ = self->priv->volume_slider;
	gtk_range_set_increments ((GtkRange*) _tmp21_, step_size, step_size);
	_tmp22_ = self->priv->volume_slider;
	gtk_range_set_range ((GtkRange*) _tmp22_, (gdouble) 0, vol_max);
	_tmp23_ = self->priv->volume_slider;
	gtk_range_set_value ((GtkRange*) _tmp23_, (gdouble) vol);
	if (self->priv->scale_id > ((gulong) 0)) {
		GtkScale* _tmp24_;
		_tmp24_ = self->priv->volume_slider;
		g_signal_handler_unblock (_tmp24_, self->priv->scale_id);
	}
	_g_free0 (icon_prefix);
	_g_free0 (image_name);
}

static void
budgie_sound_widget_class_init (BudgieSoundWidgetClass * klass,
                                gpointer klass_data)
{
	budgie_sound_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieSoundWidget_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_sound_widget_finalize;
	/**
	 * Signals
	 */
	budgie_sound_widget_signals[BUDGIE_SOUND_WIDGET_DEVICES_STATE_CHANGED_SIGNAL] = g_signal_new ("devices-state-changed", BUDGIE_TYPE_SOUND_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_sound_widget_instance_init (BudgieSoundWidget * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	self->priv = budgie_sound_widget_get_instance_private (self);
	self->priv->scale_id = (gulong) 0;
	self->priv->mixer = NULL;
	self->priv->primary_notify_id = (gulong) 0;
	self->priv->primary_stream = NULL;
	self->priv->settings = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->widget_type = _tmp0_;
	self->priv->header = NULL;
	self->priv->apps_area = NULL;
	self->priv->apps_listbox = NULL;
	self->priv->apps_list_revealer = NULL;
	self->priv->devices_list = NULL;
	self->priv->listening_box = NULL;
	self->priv->listening_box_revealer = NULL;
	self->priv->main_layout = NULL;
	self->priv->widget_area = NULL;
	self->priv->widget_area_switch = NULL;
	self->priv->volume_slider = NULL;
}

static void
budgie_sound_widget_finalize (GObject * obj)
{
	BudgieSoundWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SOUND_WIDGET, BudgieSoundWidget);
	_g_object_unref0 (self->priv->budgie_settings);
	_g_object_unref0 (self->priv->gnome_desktop_settings);
	_g_object_unref0 (self->priv->raven_settings);
	_g_object_unref0 (self->priv->mixer);
	_g_hash_table_unref0 (self->priv->apps);
	_g_hash_table_unref0 (self->priv->derpers);
	_g_hash_table_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->primary_stream);
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->widget_type);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->apps_area);
	_g_object_unref0 (self->priv->apps_listbox);
	_g_object_unref0 (self->priv->apps_list_revealer);
	_g_object_unref0 (self->priv->devices_list);
	_g_object_unref0 (self->priv->listening_box);
	_g_object_unref0 (self->priv->listening_box_revealer);
	_g_object_unref0 (self->priv->main_layout);
	_g_object_unref0 (self->priv->widget_area);
	_g_object_unref0 (self->priv->widget_area_switch);
	_g_object_unref0 (self->priv->volume_slider);
	G_OBJECT_CLASS (budgie_sound_widget_parent_class)->finalize (obj);
}

static GType
budgie_sound_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSoundWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_sound_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSoundWidget), 0, (GInstanceInitFunc) budgie_sound_widget_instance_init, NULL };
	GType budgie_sound_widget_type_id;
	budgie_sound_widget_type_id = g_type_register_static (TYPE_RAVEN_WIDGET, "BudgieSoundWidget", &g_define_type_info, 0);
	BudgieSoundWidget_private_offset = g_type_add_instance_private (budgie_sound_widget_type_id, sizeof (BudgieSoundWidgetPrivate));
	return budgie_sound_widget_type_id;
}

GType
budgie_sound_widget_get_type (void)
{
	static volatile gsize budgie_sound_widget_type_id__once = 0;
	if (g_once_init_enter (&budgie_sound_widget_type_id__once)) {
		GType budgie_sound_widget_type_id;
		budgie_sound_widget_type_id = budgie_sound_widget_get_type_once ();
		g_once_init_leave (&budgie_sound_widget_type_id__once, budgie_sound_widget_type_id);
	}
	return budgie_sound_widget_type_id__once;
}

