"use strict";
/*
Copyright 2019 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringCrypto = void 0;
const crypto = __importStar(require("crypto"));
const fs = __importStar(require("fs"));
const logging_1 = require("../logging");
const log = (0, logging_1.getLogger)("CryptoStore");
class StringCrypto {
    load(pkeyPath) {
        try {
            this.privateKey = fs.readFileSync(pkeyPath, "utf8").toString();
            // Test whether key is a valid PEM key (publicEncrypt does internal validation)
            try {
                crypto.publicEncrypt(this.privateKey, Buffer.from("This is a test!"));
            }
            catch (err) {
                log.error(`Failed to validate private key: (${err.message})`);
                throw err;
            }
            log.info(`Private key loaded from ${pkeyPath} - IRC password encryption enabled.`);
        }
        catch (err) {
            log.error(`Could not load private key ${err.message}.`);
            throw err;
        }
    }
    encrypt(plaintext) {
        const salt = crypto.randomBytes(16).toString('base64');
        return crypto.publicEncrypt(this.privateKey, Buffer.from(salt + ' ' + plaintext)).toString('base64');
    }
    decrypt(encryptedString) {
        const decryptedPass = crypto.privateDecrypt(this.privateKey, Buffer.from(encryptedString, 'base64')).toString();
        // Extract the password by removing the prefixed salt and seperating space
        return decryptedPass.split(' ')[1];
    }
}
exports.StringCrypto = StringCrypto;
//# sourceMappingURL=StringCrypto.js.map