"use strict";

require("@testing-library/jest-dom/extend-expect");

var _react = require("@testing-library/react");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
(0, _react.configure)({
  testIdAttribute: "data-test-subj"
});
jest.mock("@elastic/eui/lib/eui_components/form/form_row/make_id", () => () => "some_make_id");
jest.mock("@elastic/eui/lib/services/accessibility/html_id_generator", () => ({
  htmlIdGenerator: () => {
    return () => "some_html_id";
  }
})); // @ts-ignore

window.Worker = function () {
  this.postMessage = () => {}; // @ts-ignore


  this.terminate = () => {};
}; // @ts-ignore


window.URL = {
  createObjectURL: () => {
    return "";
  }
}; // https://github.com/elastic/eui/issues/2530

jest.mock("@elastic/eui/lib/eui_components/icon", () => ({
  EuiIcon: () => "EuiIconMock",
  __esModule: true,
  IconPropType: require("@elastic/eui/lib/eui_components/icon/icon").IconPropType,
  ICON_TYPES: require("@elastic/eui/lib/eui_components/icon/icon").TYPES,
  ICON_SIZES: require("@elastic/eui/lib/eui_components/icon/icon").SIZES,
  ICON_COLORS: require("@elastic/eui/lib/eui_components/icon/icon").COLORS
}));
jest.setTimeout(10000); // in milliseconds
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNldHVwLmplc3QudHMiXSwibmFtZXMiOlsidGVzdElkQXR0cmlidXRlIiwiamVzdCIsIm1vY2siLCJodG1sSWRHZW5lcmF0b3IiLCJ3aW5kb3ciLCJXb3JrZXIiLCJwb3N0TWVzc2FnZSIsInRlcm1pbmF0ZSIsIlVSTCIsImNyZWF0ZU9iamVjdFVSTCIsIkV1aUljb24iLCJfX2VzTW9kdWxlIiwiSWNvblByb3BUeXBlIiwicmVxdWlyZSIsIklDT05fVFlQRVMiLCJUWVBFUyIsIklDT05fU0laRVMiLCJTSVpFUyIsIklDT05fQ09MT1JTIiwiQ09MT1JTIiwic2V0VGltZW91dCJdLCJtYXBwaW5ncyI6Ijs7QUFNQTs7QUFDQTs7QUFQQTtBQUNBO0FBQ0E7QUFDQTtBQU1BLHNCQUFVO0FBQUVBLEVBQUFBLGVBQWUsRUFBRTtBQUFuQixDQUFWO0FBRUFDLElBQUksQ0FBQ0MsSUFBTCxDQUFVLHVEQUFWLEVBQW1FLE1BQU0sTUFBTSxjQUEvRTtBQUVBRCxJQUFJLENBQUNDLElBQUwsQ0FBVSwyREFBVixFQUF1RSxPQUFPO0FBQzVFQyxFQUFBQSxlQUFlLEVBQUUsTUFBTTtBQUNyQixXQUFPLE1BQU0sY0FBYjtBQUNEO0FBSDJFLENBQVAsQ0FBdkUsRSxDQU1BOztBQUNBQyxNQUFNLENBQUNDLE1BQVAsR0FBZ0IsWUFBWTtBQUMxQixPQUFLQyxXQUFMLEdBQW1CLE1BQU0sQ0FBRSxDQUEzQixDQUQwQixDQUUxQjs7O0FBQ0EsT0FBS0MsU0FBTCxHQUFpQixNQUFNLENBQUUsQ0FBekI7QUFDRCxDQUpELEMsQ0FNQTs7O0FBQ0FILE1BQU0sQ0FBQ0ksR0FBUCxHQUFhO0FBQ1hDLEVBQUFBLGVBQWUsRUFBRSxNQUFNO0FBQ3JCLFdBQU8sRUFBUDtBQUNEO0FBSFUsQ0FBYixDLENBTUE7O0FBQ0FSLElBQUksQ0FBQ0MsSUFBTCxDQUFVLHNDQUFWLEVBQWtELE9BQU87QUFDdkRRLEVBQUFBLE9BQU8sRUFBRSxNQUFNLGFBRHdDO0FBRXZEQyxFQUFBQSxVQUFVLEVBQUUsSUFGMkM7QUFHdkRDLEVBQUFBLFlBQVksRUFBRUMsT0FBTyxDQUFDLDJDQUFELENBQVAsQ0FBcURELFlBSFo7QUFJdkRFLEVBQUFBLFVBQVUsRUFBRUQsT0FBTyxDQUFDLDJDQUFELENBQVAsQ0FBcURFLEtBSlY7QUFLdkRDLEVBQUFBLFVBQVUsRUFBRUgsT0FBTyxDQUFDLDJDQUFELENBQVAsQ0FBcURJLEtBTFY7QUFNdkRDLEVBQUFBLFdBQVcsRUFBRUwsT0FBTyxDQUFDLDJDQUFELENBQVAsQ0FBcURNO0FBTlgsQ0FBUCxDQUFsRDtBQVNBbEIsSUFBSSxDQUFDbUIsVUFBTCxDQUFnQixLQUFoQixFLENBQXdCIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgUmVhY3QgZnJvbSBcInJlYWN0XCI7XG5pbXBvcnQgXCJAdGVzdGluZy1saWJyYXJ5L2plc3QtZG9tL2V4dGVuZC1leHBlY3RcIjtcbmltcG9ydCB7IGNvbmZpZ3VyZSB9IGZyb20gXCJAdGVzdGluZy1saWJyYXJ5L3JlYWN0XCI7XG5cbmNvbmZpZ3VyZSh7IHRlc3RJZEF0dHJpYnV0ZTogXCJkYXRhLXRlc3Qtc3VialwiIH0pO1xuXG5qZXN0Lm1vY2soXCJAZWxhc3RpYy9ldWkvbGliL2V1aV9jb21wb25lbnRzL2Zvcm0vZm9ybV9yb3cvbWFrZV9pZFwiLCAoKSA9PiAoKSA9PiBcInNvbWVfbWFrZV9pZFwiKTtcblxuamVzdC5tb2NrKFwiQGVsYXN0aWMvZXVpL2xpYi9zZXJ2aWNlcy9hY2Nlc3NpYmlsaXR5L2h0bWxfaWRfZ2VuZXJhdG9yXCIsICgpID0+ICh7XG4gIGh0bWxJZEdlbmVyYXRvcjogKCkgPT4ge1xuICAgIHJldHVybiAoKSA9PiBcInNvbWVfaHRtbF9pZFwiO1xuICB9LFxufSkpO1xuXG4vLyBAdHMtaWdub3JlXG53aW5kb3cuV29ya2VyID0gZnVuY3Rpb24gKCkge1xuICB0aGlzLnBvc3RNZXNzYWdlID0gKCkgPT4ge307XG4gIC8vIEB0cy1pZ25vcmVcbiAgdGhpcy50ZXJtaW5hdGUgPSAoKSA9PiB7fTtcbn07XG5cbi8vIEB0cy1pZ25vcmVcbndpbmRvdy5VUkwgPSB7XG4gIGNyZWF0ZU9iamVjdFVSTDogKCkgPT4ge1xuICAgIHJldHVybiBcIlwiO1xuICB9LFxufTtcblxuLy8gaHR0cHM6Ly9naXRodWIuY29tL2VsYXN0aWMvZXVpL2lzc3Vlcy8yNTMwXG5qZXN0Lm1vY2soXCJAZWxhc3RpYy9ldWkvbGliL2V1aV9jb21wb25lbnRzL2ljb25cIiwgKCkgPT4gKHtcbiAgRXVpSWNvbjogKCkgPT4gXCJFdWlJY29uTW9ja1wiLFxuICBfX2VzTW9kdWxlOiB0cnVlLFxuICBJY29uUHJvcFR5cGU6IHJlcXVpcmUoXCJAZWxhc3RpYy9ldWkvbGliL2V1aV9jb21wb25lbnRzL2ljb24vaWNvblwiKS5JY29uUHJvcFR5cGUsXG4gIElDT05fVFlQRVM6IHJlcXVpcmUoXCJAZWxhc3RpYy9ldWkvbGliL2V1aV9jb21wb25lbnRzL2ljb24vaWNvblwiKS5UWVBFUyxcbiAgSUNPTl9TSVpFUzogcmVxdWlyZShcIkBlbGFzdGljL2V1aS9saWIvZXVpX2NvbXBvbmVudHMvaWNvbi9pY29uXCIpLlNJWkVTLFxuICBJQ09OX0NPTE9SUzogcmVxdWlyZShcIkBlbGFzdGljL2V1aS9saWIvZXVpX2NvbXBvbmVudHMvaWNvbi9pY29uXCIpLkNPTE9SUyxcbn0pKTtcblxuamVzdC5zZXRUaW1lb3V0KDEwMDAwKTsgLy8gaW4gbWlsbGlzZWNvbmRzXG4iXX0=