import * as React from "react";
import { HotkeyConfig, UseHotkeysOptions } from "../../hooks";
/** Identical to the return type of `useHotkeys` hook. */
export interface HotkeysTarget2RenderProps {
    handleKeyDown: React.KeyboardEventHandler<HTMLElement>;
    handleKeyUp: React.KeyboardEventHandler<HTMLElement>;
}
export interface HotkeysTarget2Props {
    /**
     * Render prop which receives the same callback handlers generated by the `useHotkeys` hook.
     * If your hotkey definitions are all global, you may supply an element instead.
     */
    children: JSX.Element | ((props: HotkeysTarget2RenderProps) => JSX.Element);
    /** Hotkey definitions. */
    hotkeys: HotkeyConfig[];
    /** Hook customization options. */
    options?: UseHotkeysOptions;
}
/**
 * Utility component which allows consumers to use the new `useHotkeys` hook inside
 * React component classes. The implementation simply passes through to the hook.
 */
export declare const HotkeysTarget2: ({ children, hotkeys, options }: HotkeysTarget2Props) => JSX.Element;
