/**
 * vis-network
 * https://visjs.github.io/vis-network/
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 9.1.0
 * @date    2021-08-29T08:43:14.666Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

var check = function (it) {
  return it && it.Math == Math && it;
}; // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028


var global$k = // eslint-disable-next-line es/no-global-this -- safe
check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || // eslint-disable-next-line no-restricted-globals -- safe
check(typeof self == 'object' && self) || check(typeof commonjsGlobal == 'object' && commonjsGlobal) || // eslint-disable-next-line no-new-func -- fallback
function () {
  return this;
}() || Function('return this')();

var objectGetOwnPropertyDescriptor = {};

var fails$m = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};

var fails$l = fails$m; // Detect IE8's incomplete defineProperty implementation

var descriptors = !fails$l(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, {
    get: function () {
      return 7;
    }
  })[1] != 7;
});

var objectPropertyIsEnumerable = {};

var $propertyIsEnumerable$1 = {}.propertyIsEnumerable; // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe

var getOwnPropertyDescriptor$7 = Object.getOwnPropertyDescriptor; // Nashorn ~ JDK8 bug

var NASHORN_BUG = getOwnPropertyDescriptor$7 && !$propertyIsEnumerable$1.call({
  1: 2
}, 1); // `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable

objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor$7(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable$1;

var createPropertyDescriptor$5 = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

var toString$a = {}.toString;

var classofRaw$1 = function (it) {
  return toString$a.call(it).slice(8, -1);
};

var fails$k = fails$m;
var classof$b = classofRaw$1;
var split = ''.split; // fallback for non-array-like ES3 and non-enumerable old V8 strings

var indexedObject = fails$k(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof$b(it) == 'String' ? split.call(it, '') : Object(it);
} : Object;

// https://tc39.es/ecma262/#sec-requireobjectcoercible

var requireObjectCoercible$5 = function (it) {
  if (it == undefined) throw TypeError("Can't call method on " + it);
  return it;
};

var IndexedObject$3 = indexedObject;
var requireObjectCoercible$4 = requireObjectCoercible$5;

var toIndexedObject$a = function (it) {
  return IndexedObject$3(requireObjectCoercible$4(it));
};

var isObject$j = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};

var path$x = {};

var path$w = path$x;
var global$j = global$k;

var aFunction$7 = function (variable) {
  return typeof variable == 'function' ? variable : undefined;
};

var getBuiltIn$8 = function (namespace, method) {
  return arguments.length < 2 ? aFunction$7(path$w[namespace]) || aFunction$7(global$j[namespace]) : path$w[namespace] && path$w[namespace][method] || global$j[namespace] && global$j[namespace][method];
};

var getBuiltIn$7 = getBuiltIn$8;
var engineUserAgent = getBuiltIn$7('navigator', 'userAgent') || '';

var global$i = global$k;
var userAgent$3 = engineUserAgent;
var process = global$i.process;
var Deno = global$i.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  version = match[0] < 4 ? 1 : match[0] + match[1];
} else if (userAgent$3) {
  match = userAgent$3.match(/Edge\/(\d+)/);

  if (!match || match[1] >= 74) {
    match = userAgent$3.match(/Chrome\/(\d+)/);
    if (match) version = match[1];
  }
}

var engineV8Version = version && +version;

/* eslint-disable es/no-symbol -- required for testing */
var V8_VERSION$2 = engineV8Version;
var fails$j = fails$m; // eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing

var nativeSymbol = !!Object.getOwnPropertySymbols && !fails$j(function () {
  var symbol = Symbol(); // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances

  return !String(symbol) || !(Object(symbol) instanceof Symbol) || // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
  !Symbol.sham && V8_VERSION$2 && V8_VERSION$2 < 41;
});

/* eslint-disable es/no-symbol -- required for testing */
var NATIVE_SYMBOL$2 = nativeSymbol;
var useSymbolAsUid = NATIVE_SYMBOL$2 && !Symbol.sham && typeof Symbol.iterator == 'symbol';

var getBuiltIn$6 = getBuiltIn$8;
var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;
var isSymbol$4 = USE_SYMBOL_AS_UID$1 ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn$6('Symbol');
  return typeof $Symbol == 'function' && Object(it) instanceof $Symbol;
};

var isObject$i = isObject$j; // `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive

var ordinaryToPrimitive$1 = function (input, pref) {
  var fn, val;
  if (pref === 'string' && typeof (fn = input.toString) == 'function' && !isObject$i(val = fn.call(input))) return val;
  if (typeof (fn = input.valueOf) == 'function' && !isObject$i(val = fn.call(input))) return val;
  if (pref !== 'string' && typeof (fn = input.toString) == 'function' && !isObject$i(val = fn.call(input))) return val;
  throw TypeError("Can't convert object to primitive value");
};

var shared$4 = {exports: {}};

var global$h = global$k;

var setGlobal$1 = function (key, value) {
  try {
    // eslint-disable-next-line es/no-object-defineproperty -- safe
    Object.defineProperty(global$h, key, {
      value: value,
      configurable: true,
      writable: true
    });
  } catch (error) {
    global$h[key] = value;
  }

  return value;
};

var global$g = global$k;
var setGlobal = setGlobal$1;
var SHARED = '__core-js_shared__';
var store$3 = global$g[SHARED] || setGlobal(SHARED, {});
var sharedStore = store$3;

var store$2 = sharedStore;
(shared$4.exports = function (key, value) {
  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.16.1',
  mode: 'pure' ,
  copyright: '© 2021 Denis Pushkarev (zloirock.ru)'
});

var requireObjectCoercible$3 = requireObjectCoercible$5; // `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject

var toObject$e = function (argument) {
  return Object(requireObjectCoercible$3(argument));
};

var toObject$d = toObject$e;
var hasOwnProperty = {}.hasOwnProperty;

var has$c = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty.call(toObject$d(it), key);
};

var id$2 = 0;
var postfix = Math.random();

var uid$4 = function (key) {
  return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id$2 + postfix).toString(36);
};

var global$f = global$k;
var shared$3 = shared$4.exports;
var has$b = has$c;
var uid$3 = uid$4;
var NATIVE_SYMBOL$1 = nativeSymbol;
var USE_SYMBOL_AS_UID = useSymbolAsUid;
var WellKnownSymbolsStore$1 = shared$3('wks');
var Symbol$1 = global$f.Symbol;
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol$1 : Symbol$1 && Symbol$1.withoutSetter || uid$3;

var wellKnownSymbol$j = function (name) {
  if (!has$b(WellKnownSymbolsStore$1, name) || !(NATIVE_SYMBOL$1 || typeof WellKnownSymbolsStore$1[name] == 'string')) {
    if (NATIVE_SYMBOL$1 && has$b(Symbol$1, name)) {
      WellKnownSymbolsStore$1[name] = Symbol$1[name];
    } else {
      WellKnownSymbolsStore$1[name] = createWellKnownSymbol('Symbol.' + name);
    }
  }

  return WellKnownSymbolsStore$1[name];
};

var isObject$h = isObject$j;
var isSymbol$3 = isSymbol$4;
var ordinaryToPrimitive = ordinaryToPrimitive$1;
var wellKnownSymbol$i = wellKnownSymbol$j;
var TO_PRIMITIVE$1 = wellKnownSymbol$i('toPrimitive'); // `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive

var toPrimitive$1 = function (input, pref) {
  if (!isObject$h(input) || isSymbol$3(input)) return input;
  var exoticToPrim = input[TO_PRIMITIVE$1];
  var result;

  if (exoticToPrim !== undefined) {
    if (pref === undefined) pref = 'default';
    result = exoticToPrim.call(input, pref);
    if (!isObject$h(result) || isSymbol$3(result)) return result;
    throw TypeError("Can't convert object to primitive value");
  }

  if (pref === undefined) pref = 'number';
  return ordinaryToPrimitive(input, pref);
};

var toPrimitive = toPrimitive$1;
var isSymbol$2 = isSymbol$4; // `ToPropertyKey` abstract operation
// https://tc39.es/ecma262/#sec-topropertykey

var toPropertyKey$4 = function (argument) {
  var key = toPrimitive(argument, 'string');
  return isSymbol$2(key) ? key : String(key);
};

var global$e = global$k;
var isObject$g = isObject$j;
var document$1 = global$e.document; // typeof document.createElement is 'object' in old IE

var EXISTS = isObject$g(document$1) && isObject$g(document$1.createElement);

var documentCreateElement$1 = function (it) {
  return EXISTS ? document$1.createElement(it) : {};
};

var DESCRIPTORS$f = descriptors;
var fails$i = fails$m;
var createElement = documentCreateElement$1; // Thank's IE8 for his funny defineProperty

var ie8DomDefine = !DESCRIPTORS$f && !fails$i(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- requied for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () {
      return 7;
    }
  }).a != 7;
});

var DESCRIPTORS$e = descriptors;
var propertyIsEnumerableModule$2 = objectPropertyIsEnumerable;
var createPropertyDescriptor$4 = createPropertyDescriptor$5;
var toIndexedObject$9 = toIndexedObject$a;
var toPropertyKey$3 = toPropertyKey$4;
var has$a = has$c;
var IE8_DOM_DEFINE$1 = ie8DomDefine; // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe

var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor; // `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor

objectGetOwnPropertyDescriptor.f = DESCRIPTORS$e ? $getOwnPropertyDescriptor$1 : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject$9(O);
  P = toPropertyKey$3(P);
  if (IE8_DOM_DEFINE$1) try {
    return $getOwnPropertyDescriptor$1(O, P);
  } catch (error) {
    /* empty */
  }
  if (has$a(O, P)) return createPropertyDescriptor$4(!propertyIsEnumerableModule$2.f.call(O, P), O[P]);
};

var fails$h = fails$m;
var replacement = /#|\.prototype\./;

var isForced$1 = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == 'function' ? fails$h(detection) : !!detection;
};

var normalize = isForced$1.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced$1.data = {};
var NATIVE = isForced$1.NATIVE = 'N';
var POLYFILL = isForced$1.POLYFILL = 'P';
var isForced_1 = isForced$1;

var aFunction$6 = function (it) {
  if (typeof it != 'function') {
    throw TypeError(String(it) + ' is not a function');
  }

  return it;
};

var aFunction$5 = aFunction$6; // optional / simple context binding

var functionBindContext = function (fn, that, length) {
  aFunction$5(fn);
  if (that === undefined) return fn;

  switch (length) {
    case 0:
      return function () {
        return fn.call(that);
      };

    case 1:
      return function (a) {
        return fn.call(that, a);
      };

    case 2:
      return function (a, b) {
        return fn.call(that, a, b);
      };

    case 3:
      return function (a, b, c) {
        return fn.call(that, a, b, c);
      };
  }

  return function () {
    return fn.apply(that, arguments);
  };
};

var objectDefineProperty = {};

var isObject$f = isObject$j;

var anObject$d = function (it) {
  if (!isObject$f(it)) {
    throw TypeError(String(it) + ' is not an object');
  }

  return it;
};

var DESCRIPTORS$d = descriptors;
var IE8_DOM_DEFINE = ie8DomDefine;
var anObject$c = anObject$d;
var toPropertyKey$2 = toPropertyKey$4; // eslint-disable-next-line es/no-object-defineproperty -- safe

var $defineProperty$1 = Object.defineProperty; // `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty

objectDefineProperty.f = DESCRIPTORS$d ? $defineProperty$1 : function defineProperty(O, P, Attributes) {
  anObject$c(O);
  P = toPropertyKey$2(P);
  anObject$c(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty$1(O, P, Attributes);
  } catch (error) {
    /* empty */
  }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

var DESCRIPTORS$c = descriptors;
var definePropertyModule$4 = objectDefineProperty;
var createPropertyDescriptor$3 = createPropertyDescriptor$5;
var createNonEnumerableProperty$9 = DESCRIPTORS$c ? function (object, key, value) {
  return definePropertyModule$4.f(object, key, createPropertyDescriptor$3(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

var global$d = global$k;
var getOwnPropertyDescriptor$6 = objectGetOwnPropertyDescriptor.f;
var isForced = isForced_1;
var path$v = path$x;
var bind$b = functionBindContext;
var createNonEnumerableProperty$8 = createNonEnumerableProperty$9;
var has$9 = has$c;

var wrapConstructor = function (NativeConstructor) {
  var Wrapper = function (a, b, c) {
    if (this instanceof NativeConstructor) {
      switch (arguments.length) {
        case 0:
          return new NativeConstructor();

        case 1:
          return new NativeConstructor(a);

        case 2:
          return new NativeConstructor(a, b);
      }

      return new NativeConstructor(a, b, c);
    }

    return NativeConstructor.apply(this, arguments);
  };

  Wrapper.prototype = NativeConstructor.prototype;
  return Wrapper;
};
/*
  options.target      - name of the target object
  options.global      - target is the global object
  options.stat        - export as static methods of target
  options.proto       - export as prototype methods of target
  options.real        - real prototype method for the `pure` version
  options.forced      - export even if the native feature is available
  options.bind        - bind methods to the target, required for the `pure` version
  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
  options.sham        - add a flag to not completely full polyfills
  options.enumerable  - export as enumerable property
  options.noTargetGet - prevent calling a getter on target
*/


var _export = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var PROTO = options.proto;
  var nativeSource = GLOBAL ? global$d : STATIC ? global$d[TARGET] : (global$d[TARGET] || {}).prototype;
  var target = GLOBAL ? path$v : path$v[TARGET] || (path$v[TARGET] = {});
  var targetPrototype = target.prototype;
  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

  for (key in source) {
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced); // contains in native

    USE_NATIVE = !FORCED && nativeSource && has$9(nativeSource, key);
    targetProperty = target[key];
    if (USE_NATIVE) if (options.noTargetGet) {
      descriptor = getOwnPropertyDescriptor$6(nativeSource, key);
      nativeProperty = descriptor && descriptor.value;
    } else nativeProperty = nativeSource[key]; // export native or implementation

    sourceProperty = USE_NATIVE && nativeProperty ? nativeProperty : source[key];
    if (USE_NATIVE && typeof targetProperty === typeof sourceProperty) continue; // bind timers to global for call from export context

    if (options.bind && USE_NATIVE) resultProperty = bind$b(sourceProperty, global$d); // wrap global constructors for prevent changs in this version
    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty); // make static versions for prototype methods
    else if (PROTO && typeof sourceProperty == 'function') resultProperty = bind$b(Function.call, sourceProperty); // default case
    else resultProperty = sourceProperty; // add a flag to not completely full polyfills

    if (options.sham || sourceProperty && sourceProperty.sham || targetProperty && targetProperty.sham) {
      createNonEnumerableProperty$8(resultProperty, 'sham', true);
    }

    target[key] = resultProperty;

    if (PROTO) {
      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';

      if (!has$9(path$v, VIRTUAL_PROTOTYPE)) {
        createNonEnumerableProperty$8(path$v, VIRTUAL_PROTOTYPE, {});
      } // export virtual prototype methods


      path$v[VIRTUAL_PROTOTYPE][key] = sourceProperty; // export real prototype methods

      if (options.real && targetPrototype && !targetPrototype[key]) {
        createNonEnumerableProperty$8(targetPrototype, key, sourceProperty);
      }
    }
  }
};

var ceil = Math.ceil;
var floor$1 = Math.floor; // `ToInteger` abstract operation
// https://tc39.es/ecma262/#sec-tointeger

var toInteger$4 = function (argument) {
  return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor$1 : ceil)(argument);
};

var toInteger$3 = toInteger$4;
var min$2 = Math.min; // `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength

var toLength$c = function (argument) {
  return argument > 0 ? min$2(toInteger$3(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};

var toInteger$2 = toInteger$4;
var max$2 = Math.max;
var min$1 = Math.min; // Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).

var toAbsoluteIndex$4 = function (index, length) {
  var integer = toInteger$2(index);
  return integer < 0 ? max$2(integer + length, 0) : min$1(integer, length);
};

var toIndexedObject$8 = toIndexedObject$a;
var toLength$b = toLength$c;
var toAbsoluteIndex$3 = toAbsoluteIndex$4; // `Array.prototype.{ indexOf, includes }` methods implementation

var createMethod$5 = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject$8($this);
    var length = toLength$b(O.length);
    var index = toAbsoluteIndex$3(fromIndex, length);
    var value; // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check

    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++]; // eslint-disable-next-line no-self-compare -- NaN check

      if (value != value) return true; // Array#indexOf ignores holes, Array#includes - not
    } else for (; length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    }
    return !IS_INCLUDES && -1;
  };
};

var arrayIncludes$1 = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod$5(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod$5(false)
};

var hiddenKeys$6 = {};

var has$8 = has$c;
var toIndexedObject$7 = toIndexedObject$a;
var indexOf$4 = arrayIncludes$1.indexOf;
var hiddenKeys$5 = hiddenKeys$6;

var objectKeysInternal = function (object, names) {
  var O = toIndexedObject$7(object);
  var i = 0;
  var result = [];
  var key;

  for (key in O) !has$8(hiddenKeys$5, key) && has$8(O, key) && result.push(key); // Don't enum bug & hidden keys


  while (names.length > i) if (has$8(O, key = names[i++])) {
    ~indexOf$4(result, key) || result.push(key);
  }

  return result;
};

var enumBugKeys$3 = ['constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf'];

var internalObjectKeys$1 = objectKeysInternal;
var enumBugKeys$2 = enumBugKeys$3; // `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es/no-object-keys -- safe

var objectKeys$4 = Object.keys || function keys(O) {
  return internalObjectKeys$1(O, enumBugKeys$2);
};

var objectGetOwnPropertySymbols = {};

objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

var DESCRIPTORS$b = descriptors;
var fails$g = fails$m;
var objectKeys$3 = objectKeys$4;
var getOwnPropertySymbolsModule$2 = objectGetOwnPropertySymbols;
var propertyIsEnumerableModule$1 = objectPropertyIsEnumerable;
var toObject$c = toObject$e;
var IndexedObject$2 = indexedObject; // eslint-disable-next-line es/no-object-assign -- safe

var $assign = Object.assign; // eslint-disable-next-line es/no-object-defineproperty -- required for testing

var defineProperty$b = Object.defineProperty; // `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign

var objectAssign = !$assign || fails$g(function () {
  // should have correct order of operations (Edge bug)
  if (DESCRIPTORS$b && $assign({
    b: 1
  }, $assign(defineProperty$b({}, 'a', {
    enumerable: true,
    get: function () {
      defineProperty$b(this, 'b', {
        value: 3,
        enumerable: false
      });
    }
  }), {
    b: 2
  })).b !== 1) return true; // should work with symbols and should have deterministic property order (V8 bug)

  var A = {};
  var B = {}; // eslint-disable-next-line es/no-symbol -- safe

  var symbol = Symbol();
  var alphabet = 'abcdefghijklmnopqrst';
  A[symbol] = 7;
  alphabet.split('').forEach(function (chr) {
    B[chr] = chr;
  });
  return $assign({}, A)[symbol] != 7 || objectKeys$3($assign({}, B)).join('') != alphabet;
}) ? function assign(target, source) {
  // eslint-disable-line no-unused-vars -- required for `.length`
  var T = toObject$c(target);
  var argumentsLength = arguments.length;
  var index = 1;
  var getOwnPropertySymbols = getOwnPropertySymbolsModule$2.f;
  var propertyIsEnumerable = propertyIsEnumerableModule$1.f;

  while (argumentsLength > index) {
    var S = IndexedObject$2(arguments[index++]);
    var keys = getOwnPropertySymbols ? objectKeys$3(S).concat(getOwnPropertySymbols(S)) : objectKeys$3(S);
    var length = keys.length;
    var j = 0;
    var key;

    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS$b || propertyIsEnumerable.call(S, key)) T[key] = S[key];
    }
  }

  return T;
} : $assign;

var $$J = _export;
var assign$5 = objectAssign; // `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
// eslint-disable-next-line es/no-object-assign -- required for testing

$$J({
  target: 'Object',
  stat: true,
  forced: Object.assign !== assign$5
}, {
  assign: assign$5
});

var path$u = path$x;
var assign$4 = path$u.Object.assign;

var parent$Z = assign$4;
var assign$3 = parent$Z;

var assign$2 = assign$3;

var aFunction$4 = aFunction$6;
var isObject$e = isObject$j;
var slice$7 = [].slice;
var factories = {};

var construct$3 = function (C, argsLength, args) {
  if (!(argsLength in factories)) {
    for (var list = [], i = 0; i < argsLength; i++) list[i] = 'a[' + i + ']'; // eslint-disable-next-line no-new-func -- we have no proper alternatives, IE8- only


    factories[argsLength] = Function('C,a', 'return new C(' + list.join(',') + ')');
  }

  return factories[argsLength](C, args);
}; // `Function.prototype.bind` method implementation
// https://tc39.es/ecma262/#sec-function.prototype.bind


var functionBind = Function.bind || function bind(that
/* , ...args */
) {
  var fn = aFunction$4(this);
  var partArgs = slice$7.call(arguments, 1);

  var boundFunction = function bound() {
    var args = partArgs.concat(slice$7.call(arguments));
    return this instanceof boundFunction ? construct$3(fn, args.length, args) : fn.apply(that, args);
  };

  if (isObject$e(fn.prototype)) boundFunction.prototype = fn.prototype;
  return boundFunction;
};

var $$I = _export;
var bind$a = functionBind; // `Function.prototype.bind` method
// https://tc39.es/ecma262/#sec-function.prototype.bind

$$I({
  target: 'Function',
  proto: true
}, {
  bind: bind$a
});

var path$t = path$x;

var entryVirtual$l = function (CONSTRUCTOR) {
  return path$t[CONSTRUCTOR + 'Prototype'];
};

var entryVirtual$k = entryVirtual$l;
var bind$9 = entryVirtual$k('Function').bind;

var bind$8 = bind$9;
var FunctionPrototype = Function.prototype;

var bind_1 = function (it) {
  var own = it.bind;
  return it === FunctionPrototype || it instanceof Function && own === FunctionPrototype.bind ? bind$8 : own;
};

var parent$Y = bind_1;
var bind$7 = parent$Y;

var bind$6 = bind$7;

/**
 * Draw a circle.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - The radius of the circle.
 */
function drawCircle(ctx, x, y, r) {
  ctx.beginPath();
  ctx.arc(x, y, r, 0, 2 * Math.PI, false);
  ctx.closePath();
}
/**
 * Draw a square.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - Half of the width and height of the square.
 */

function drawSquare(ctx, x, y, r) {
  ctx.beginPath();
  ctx.rect(x - r, y - r, r * 2, r * 2);
  ctx.closePath();
}
/**
 * Draw an equilateral triangle standing on a side.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - Half of the length of the sides.
 *
 * @remarks
 * http://en.wikipedia.org/wiki/Equilateral_triangle
 */

function drawTriangle(ctx, x, y, r) {
  ctx.beginPath(); // the change in radius and the offset is here to center the shape

  r *= 1.15;
  y += 0.275 * r;
  var s = r * 2;
  var s2 = s / 2;
  var ir = Math.sqrt(3) / 6 * s; // radius of inner circle

  var h = Math.sqrt(s * s - s2 * s2); // height

  ctx.moveTo(x, y - (h - ir));
  ctx.lineTo(x + s2, y + ir);
  ctx.lineTo(x - s2, y + ir);
  ctx.lineTo(x, y - (h - ir));
  ctx.closePath();
}
/**
 * Draw an equilateral triangle standing on a vertex.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - Half of the length of the sides.
 *
 * @remarks
 * http://en.wikipedia.org/wiki/Equilateral_triangle
 */

function drawTriangleDown(ctx, x, y, r) {
  ctx.beginPath(); // the change in radius and the offset is here to center the shape

  r *= 1.15;
  y -= 0.275 * r;
  var s = r * 2;
  var s2 = s / 2;
  var ir = Math.sqrt(3) / 6 * s; // radius of inner circle

  var h = Math.sqrt(s * s - s2 * s2); // height

  ctx.moveTo(x, y + (h - ir));
  ctx.lineTo(x + s2, y - ir);
  ctx.lineTo(x - s2, y - ir);
  ctx.lineTo(x, y + (h - ir));
  ctx.closePath();
}
/**
 * Draw a star.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - The outer radius of the star.
 */

function drawStar(ctx, x, y, r) {
  // http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
  ctx.beginPath(); // the change in radius and the offset is here to center the shape

  r *= 0.82;
  y += 0.1 * r;

  for (var n = 0; n < 10; n++) {
    var radius = n % 2 === 0 ? r * 1.3 : r * 0.5;
    ctx.lineTo(x + radius * Math.sin(n * 2 * Math.PI / 10), y - radius * Math.cos(n * 2 * Math.PI / 10));
  }

  ctx.closePath();
}
/**
 * Draw a diamond.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - Half of the width and height of the diamond.
 *
 * @remarks
 * http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
 */

function drawDiamond(ctx, x, y, r) {
  ctx.beginPath();
  ctx.lineTo(x, y + r);
  ctx.lineTo(x + r, y);
  ctx.lineTo(x, y - r);
  ctx.lineTo(x - r, y);
  ctx.closePath();
}
/**
 * Draw a rectangle with rounded corners.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param w - The width of the rectangle.
 * @param h - The height of the rectangle.
 * @param r - The radius of the corners.
 *
 * @remarks
 * http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
 */

function drawRoundRect(ctx, x, y, w, h, r) {
  var r2d = Math.PI / 180;

  if (w - 2 * r < 0) {
    r = w / 2;
  } //ensure that the radius isn't too large for x


  if (h - 2 * r < 0) {
    r = h / 2;
  } //ensure that the radius isn't too large for y


  ctx.beginPath();
  ctx.moveTo(x + r, y);
  ctx.lineTo(x + w - r, y);
  ctx.arc(x + w - r, y + r, r, r2d * 270, r2d * 360, false);
  ctx.lineTo(x + w, y + h - r);
  ctx.arc(x + w - r, y + h - r, r, 0, r2d * 90, false);
  ctx.lineTo(x + r, y + h);
  ctx.arc(x + r, y + h - r, r, r2d * 90, r2d * 180, false);
  ctx.lineTo(x, y + r);
  ctx.arc(x + r, y + r, r, r2d * 180, r2d * 270, false);
  ctx.closePath();
}
/**
 * Draw an ellipse.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param w - The width of the ellipse.
 * @param h - The height of the ellipse.
 *
 * @remarks
 * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
 *
 * Postfix '_vis' added to discern it from standard method ellipse().
 */

function drawEllipse(ctx, x, y, w, h) {
  var kappa = 0.5522848,
      ox = w / 2 * kappa,
      // control point offset horizontal
  oy = h / 2 * kappa,
      // control point offset vertical
  xe = x + w,
      // x-end
  ye = y + h,
      // y-end
  xm = x + w / 2,
      // x-middle
  ym = y + h / 2; // y-middle

  ctx.beginPath();
  ctx.moveTo(x, ym);
  ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
  ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
  ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
  ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
  ctx.closePath();
}
/**
 * Draw an isometric cylinder.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param w - The width of the database.
 * @param h - The height of the database.
 *
 * @remarks
 * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
 */

function drawDatabase(ctx, x, y, w, h) {
  var f = 1 / 3;
  var wEllipse = w;
  var hEllipse = h * f;
  var kappa = 0.5522848,
      ox = wEllipse / 2 * kappa,
      // control point offset horizontal
  oy = hEllipse / 2 * kappa,
      // control point offset vertical
  xe = x + wEllipse,
      // x-end
  ye = y + hEllipse,
      // y-end
  xm = x + wEllipse / 2,
      // x-middle
  ym = y + hEllipse / 2,
      // y-middle
  ymb = y + (h - hEllipse / 2),
      // y-midlle, bottom ellipse
  yeb = y + h; // y-end, bottom ellipse

  ctx.beginPath();
  ctx.moveTo(xe, ym);
  ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
  ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
  ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
  ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
  ctx.lineTo(xe, ymb);
  ctx.bezierCurveTo(xe, ymb + oy, xm + ox, yeb, xm, yeb);
  ctx.bezierCurveTo(xm - ox, yeb, x, ymb + oy, x, ymb);
  ctx.lineTo(x, ym);
}
/**
 * Draw a dashed line.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The start position on the x axis.
 * @param y - The start position on the y axis.
 * @param x2 - The end position on the x axis.
 * @param y2 - The end position on the y axis.
 * @param pattern - List of lengths starting with line and then alternating between space and line.
 *
 * @author David Jordan
 * @remarks
 * date 2012-08-08
 * http://stackoverflow.com/questions/4576724/dotted-stroke-in-canvas
 */

function drawDashedLine(ctx, x, y, x2, y2, pattern) {
  ctx.beginPath();
  ctx.moveTo(x, y);
  var patternLength = pattern.length;
  var dx = x2 - x;
  var dy = y2 - y;
  var slope = dy / dx;
  var distRemaining = Math.sqrt(dx * dx + dy * dy);
  var patternIndex = 0;
  var draw = true;
  var xStep = 0;
  var dashLength = +pattern[0];

  while (distRemaining >= 0.1) {
    dashLength = +pattern[patternIndex++ % patternLength];

    if (dashLength > distRemaining) {
      dashLength = distRemaining;
    }

    xStep = Math.sqrt(dashLength * dashLength / (1 + slope * slope));
    xStep = dx < 0 ? -xStep : xStep;
    x += xStep;
    y += slope * xStep;

    if (draw === true) {
      ctx.lineTo(x, y);
    } else {
      ctx.moveTo(x, y);
    }

    distRemaining -= dashLength;
    draw = !draw;
  }
}
/**
 * Draw a hexagon.
 *
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - The radius of the hexagon.
 */

function drawHexagon(ctx, x, y, r) {
  ctx.beginPath();
  var sides = 6;
  var a = Math.PI * 2 / sides;
  ctx.moveTo(x + r, y);

  for (var i = 1; i < sides; i++) {
    ctx.lineTo(x + r * Math.cos(a * i), y + r * Math.sin(a * i));
  }

  ctx.closePath();
}
var shapeMap = {
  circle: drawCircle,
  dashedLine: drawDashedLine,
  database: drawDatabase,
  diamond: drawDiamond,
  ellipse: drawEllipse,
  ellipse_vis: drawEllipse,
  hexagon: drawHexagon,
  roundRect: drawRoundRect,
  square: drawSquare,
  star: drawStar,
  triangle: drawTriangle,
  triangleDown: drawTriangleDown
};
/**
 * Returns either custom or native drawing function base on supplied name.
 *
 * @param name - The name of the function. Either the name of a
 * CanvasRenderingContext2D property or an export from shapes.ts without the
 * draw prefix.
 *
 * @returns The function that can be used for rendering. In case of native
 * CanvasRenderingContext2D function the API is normalized to
 * `(ctx: CanvasRenderingContext2D, ...originalArgs) => void`.
 */

function getShape(name) {
  if (Object.prototype.hasOwnProperty.call(shapeMap, name)) {
    return shapeMap[name];
  } else {
    return function (ctx) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      CanvasRenderingContext2D.prototype[name].call(ctx, args);
    };
  }
}

function styleInject(css, ref) {
  if (ref === void 0) ref = {};
  var insertAt = ref.insertAt;

  if (!css || typeof document === 'undefined') {
    return;
  }

  var head = document.head || document.getElementsByTagName('head')[0];
  var style = document.createElement('style');
  style.type = 'text/css';

  if (insertAt === 'top') {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }

  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}

var css_248z$6 = ".vis-overlay {\n  position: absolute;\n  top: 0px;\n  right: 0px;\n  bottom: 0px;\n  left: 0px;\n\n  /* Must be displayed above for example selected Timeline items */\n  z-index: 10;\n}\n\n.vis-active {\n  box-shadow: 0 0 10px #86d5f8;\n}\n";
styleInject(css_248z$6);

var css_248z$5 = "/* override some bootstrap styles screwing up the timelines css */\n\n.vis [class*=\"span\"] {\n  min-height: 0;\n  width: auto;\n}\n";
styleInject(css_248z$5);

var css_248z$4 = "div.vis-color-picker {\n  position: absolute;\n  top: 0px;\n  left: 30px;\n  margin-top: -140px;\n  margin-left: 30px;\n  width: 310px;\n  height: 444px;\n  z-index: 1;\n  padding: 10px;\n  border-radius: 15px;\n  background-color: #ffffff;\n  display: none;\n  box-shadow: rgba(0, 0, 0, 0.5) 0px 0px 10px 0px;\n}\n\ndiv.vis-color-picker div.vis-arrow {\n  position: absolute;\n  top: 147px;\n  left: 5px;\n}\n\ndiv.vis-color-picker div.vis-arrow::after,\ndiv.vis-color-picker div.vis-arrow::before {\n  right: 100%;\n  top: 50%;\n  border: solid transparent;\n  content: \" \";\n  height: 0;\n  width: 0;\n  position: absolute;\n  pointer-events: none;\n}\n\ndiv.vis-color-picker div.vis-arrow:after {\n  border-color: rgba(255, 255, 255, 0);\n  border-right-color: #ffffff;\n  border-width: 30px;\n  margin-top: -30px;\n}\n\ndiv.vis-color-picker div.vis-color {\n  position: absolute;\n  width: 289px;\n  height: 289px;\n  cursor: pointer;\n}\n\ndiv.vis-color-picker div.vis-brightness {\n  position: absolute;\n  top: 313px;\n}\n\ndiv.vis-color-picker div.vis-opacity {\n  position: absolute;\n  top: 350px;\n}\n\ndiv.vis-color-picker div.vis-selector {\n  position: absolute;\n  top: 137px;\n  left: 137px;\n  width: 15px;\n  height: 15px;\n  border-radius: 15px;\n  border: 1px solid #ffffff;\n  background: #4c4c4c; /* Old browsers */\n  background: -moz-linear-gradient(\n    top,\n    #4c4c4c 0%,\n    #595959 12%,\n    #666666 25%,\n    #474747 39%,\n    #2c2c2c 50%,\n    #000000 51%,\n    #111111 60%,\n    #2b2b2b 76%,\n    #1c1c1c 91%,\n    #131313 100%\n  ); /* FF3.6+ */\n  background: -webkit-gradient(\n    linear,\n    left top,\n    left bottom,\n    color-stop(0%, #4c4c4c),\n    color-stop(12%, #595959),\n    color-stop(25%, #666666),\n    color-stop(39%, #474747),\n    color-stop(50%, #2c2c2c),\n    color-stop(51%, #000000),\n    color-stop(60%, #111111),\n    color-stop(76%, #2b2b2b),\n    color-stop(91%, #1c1c1c),\n    color-stop(100%, #131313)\n  ); /* Chrome,Safari4+ */\n  background: -webkit-linear-gradient(\n    top,\n    #4c4c4c 0%,\n    #595959 12%,\n    #666666 25%,\n    #474747 39%,\n    #2c2c2c 50%,\n    #000000 51%,\n    #111111 60%,\n    #2b2b2b 76%,\n    #1c1c1c 91%,\n    #131313 100%\n  ); /* Chrome10+,Safari5.1+ */\n  background: -o-linear-gradient(\n    top,\n    #4c4c4c 0%,\n    #595959 12%,\n    #666666 25%,\n    #474747 39%,\n    #2c2c2c 50%,\n    #000000 51%,\n    #111111 60%,\n    #2b2b2b 76%,\n    #1c1c1c 91%,\n    #131313 100%\n  ); /* Opera 11.10+ */\n  background: -ms-linear-gradient(\n    top,\n    #4c4c4c 0%,\n    #595959 12%,\n    #666666 25%,\n    #474747 39%,\n    #2c2c2c 50%,\n    #000000 51%,\n    #111111 60%,\n    #2b2b2b 76%,\n    #1c1c1c 91%,\n    #131313 100%\n  ); /* IE10+ */\n  background: linear-gradient(\n    to bottom,\n    #4c4c4c 0%,\n    #595959 12%,\n    #666666 25%,\n    #474747 39%,\n    #2c2c2c 50%,\n    #000000 51%,\n    #111111 60%,\n    #2b2b2b 76%,\n    #1c1c1c 91%,\n    #131313 100%\n  ); /* W3C */\n  filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#4c4c4c', endColorstr='#131313',GradientType=0 ); /* IE6-9 */\n}\n\ndiv.vis-color-picker div.vis-new-color {\n  position: absolute;\n  width: 140px;\n  height: 20px;\n  border: 1px solid rgba(0, 0, 0, 0.1);\n  border-radius: 5px;\n  top: 380px;\n  left: 159px;\n  text-align: right;\n  padding-right: 2px;\n  font-size: 10px;\n  color: rgba(0, 0, 0, 0.4);\n  vertical-align: middle;\n  line-height: 20px;\n}\n\ndiv.vis-color-picker div.vis-initial-color {\n  position: absolute;\n  width: 140px;\n  height: 20px;\n  border: 1px solid rgba(0, 0, 0, 0.1);\n  border-radius: 5px;\n  top: 380px;\n  left: 10px;\n  text-align: left;\n  padding-left: 2px;\n  font-size: 10px;\n  color: rgba(0, 0, 0, 0.4);\n  vertical-align: middle;\n  line-height: 20px;\n}\n\ndiv.vis-color-picker div.vis-label {\n  position: absolute;\n  width: 300px;\n  left: 10px;\n}\n\ndiv.vis-color-picker div.vis-label.vis-brightness {\n  top: 300px;\n}\n\ndiv.vis-color-picker div.vis-label.vis-opacity {\n  top: 338px;\n}\n\ndiv.vis-color-picker div.vis-button {\n  position: absolute;\n  width: 68px;\n  height: 25px;\n  border-radius: 10px;\n  vertical-align: middle;\n  text-align: center;\n  line-height: 25px;\n  top: 410px;\n  border: 2px solid #d9d9d9;\n  background-color: #f7f7f7;\n  cursor: pointer;\n}\n\ndiv.vis-color-picker div.vis-button.vis-cancel {\n  /*border:2px solid #ff4e33;*/\n  /*background-color: #ff7761;*/\n  left: 5px;\n}\ndiv.vis-color-picker div.vis-button.vis-load {\n  /*border:2px solid #a153e6;*/\n  /*background-color: #cb8dff;*/\n  left: 82px;\n}\ndiv.vis-color-picker div.vis-button.vis-apply {\n  /*border:2px solid #4588e6;*/\n  /*background-color: #82b6ff;*/\n  left: 159px;\n}\ndiv.vis-color-picker div.vis-button.vis-save {\n  /*border:2px solid #45e655;*/\n  /*background-color: #6dff7c;*/\n  left: 236px;\n}\n\ndiv.vis-color-picker input.vis-range {\n  width: 290px;\n  height: 20px;\n}\n\n/* TODO: is this redundant?\ndiv.vis-color-picker input.vis-range-brightness {\n  width: 289px !important;\n}\n\n\ndiv.vis-color-picker input.vis-saturation-range {\n  width: 289px !important;\n}*/\n";
styleInject(css_248z$4);

var css_248z$3 = "div.vis-configuration {\n  position: relative;\n  display: block;\n  float: left;\n  font-size: 12px;\n}\n\ndiv.vis-configuration-wrapper {\n  display: block;\n  width: 700px;\n}\n\ndiv.vis-configuration-wrapper::after {\n  clear: both;\n  content: \"\";\n  display: block;\n}\n\ndiv.vis-configuration.vis-config-option-container {\n  display: block;\n  width: 495px;\n  background-color: #ffffff;\n  border: 2px solid #f7f8fa;\n  border-radius: 4px;\n  margin-top: 20px;\n  left: 10px;\n  padding-left: 5px;\n}\n\ndiv.vis-configuration.vis-config-button {\n  display: block;\n  width: 495px;\n  height: 25px;\n  vertical-align: middle;\n  line-height: 25px;\n  background-color: #f7f8fa;\n  border: 2px solid #ceced0;\n  border-radius: 4px;\n  margin-top: 20px;\n  left: 10px;\n  padding-left: 5px;\n  cursor: pointer;\n  margin-bottom: 30px;\n}\n\ndiv.vis-configuration.vis-config-button.hover {\n  background-color: #4588e6;\n  border: 2px solid #214373;\n  color: #ffffff;\n}\n\ndiv.vis-configuration.vis-config-item {\n  display: block;\n  float: left;\n  width: 495px;\n  height: 25px;\n  vertical-align: middle;\n  line-height: 25px;\n}\n\ndiv.vis-configuration.vis-config-item.vis-config-s2 {\n  left: 10px;\n  background-color: #f7f8fa;\n  padding-left: 5px;\n  border-radius: 3px;\n}\ndiv.vis-configuration.vis-config-item.vis-config-s3 {\n  left: 20px;\n  background-color: #e4e9f0;\n  padding-left: 5px;\n  border-radius: 3px;\n}\ndiv.vis-configuration.vis-config-item.vis-config-s4 {\n  left: 30px;\n  background-color: #cfd8e6;\n  padding-left: 5px;\n  border-radius: 3px;\n}\n\ndiv.vis-configuration.vis-config-header {\n  font-size: 18px;\n  font-weight: bold;\n}\n\ndiv.vis-configuration.vis-config-label {\n  width: 120px;\n  height: 25px;\n  line-height: 25px;\n}\n\ndiv.vis-configuration.vis-config-label.vis-config-s3 {\n  width: 110px;\n}\ndiv.vis-configuration.vis-config-label.vis-config-s4 {\n  width: 100px;\n}\n\ndiv.vis-configuration.vis-config-colorBlock {\n  top: 1px;\n  width: 30px;\n  height: 19px;\n  border: 1px solid #444444;\n  border-radius: 2px;\n  padding: 0px;\n  margin: 0px;\n  cursor: pointer;\n}\n\ninput.vis-configuration.vis-config-checkbox {\n  left: -5px;\n}\n\ninput.vis-configuration.vis-config-rangeinput {\n  position: relative;\n  top: -5px;\n  width: 60px;\n  /*height:13px;*/\n  padding: 1px;\n  margin: 0;\n  pointer-events: none;\n}\n\ninput.vis-configuration.vis-config-range {\n  /*removes default webkit styles*/\n  -webkit-appearance: none;\n\n  /*fix for FF unable to apply focus style bug */\n  border: 0px solid white;\n  background-color: rgba(0, 0, 0, 0);\n\n  /*required for proper track sizing in FF*/\n  width: 300px;\n  height: 20px;\n}\ninput.vis-configuration.vis-config-range::-webkit-slider-runnable-track {\n  width: 300px;\n  height: 5px;\n  background: #dedede; /* Old browsers */\n  background: -moz-linear-gradient(top, #dedede 0%, #c8c8c8 99%); /* FF3.6+ */\n  background: -webkit-gradient(\n    linear,\n    left top,\n    left bottom,\n    color-stop(0%, #dedede),\n    color-stop(99%, #c8c8c8)\n  ); /* Chrome,Safari4+ */\n  background: -webkit-linear-gradient(\n    top,\n    #dedede 0%,\n    #c8c8c8 99%\n  ); /* Chrome10+,Safari5.1+ */\n  background: -o-linear-gradient(\n    top,\n    #dedede 0%,\n    #c8c8c8 99%\n  ); /* Opera 11.10+ */\n  background: -ms-linear-gradient(top, #dedede 0%, #c8c8c8 99%); /* IE10+ */\n  background: linear-gradient(to bottom, #dedede 0%, #c8c8c8 99%); /* W3C */\n  filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#dedede', endColorstr='#c8c8c8',GradientType=0 ); /* IE6-9 */\n\n  border: 1px solid #999999;\n  box-shadow: #aaaaaa 0px 0px 3px 0px;\n  border-radius: 3px;\n}\ninput.vis-configuration.vis-config-range::-webkit-slider-thumb {\n  -webkit-appearance: none;\n  border: 1px solid #14334b;\n  height: 17px;\n  width: 17px;\n  border-radius: 50%;\n  background: #3876c2; /* Old browsers */\n  background: -moz-linear-gradient(top, #3876c2 0%, #385380 100%); /* FF3.6+ */\n  background: -webkit-gradient(\n    linear,\n    left top,\n    left bottom,\n    color-stop(0%, #3876c2),\n    color-stop(100%, #385380)\n  ); /* Chrome,Safari4+ */\n  background: -webkit-linear-gradient(\n    top,\n    #3876c2 0%,\n    #385380 100%\n  ); /* Chrome10+,Safari5.1+ */\n  background: -o-linear-gradient(\n    top,\n    #3876c2 0%,\n    #385380 100%\n  ); /* Opera 11.10+ */\n  background: -ms-linear-gradient(top, #3876c2 0%, #385380 100%); /* IE10+ */\n  background: linear-gradient(to bottom, #3876c2 0%, #385380 100%); /* W3C */\n  filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#3876c2', endColorstr='#385380',GradientType=0 ); /* IE6-9 */\n  box-shadow: #111927 0px 0px 1px 0px;\n  margin-top: -7px;\n}\ninput.vis-configuration.vis-config-range:focus {\n  outline: none;\n}\ninput.vis-configuration.vis-config-range:focus::-webkit-slider-runnable-track {\n  background: #9d9d9d; /* Old browsers */\n  background: -moz-linear-gradient(top, #9d9d9d 0%, #c8c8c8 99%); /* FF3.6+ */\n  background: -webkit-gradient(\n    linear,\n    left top,\n    left bottom,\n    color-stop(0%, #9d9d9d),\n    color-stop(99%, #c8c8c8)\n  ); /* Chrome,Safari4+ */\n  background: -webkit-linear-gradient(\n    top,\n    #9d9d9d 0%,\n    #c8c8c8 99%\n  ); /* Chrome10+,Safari5.1+ */\n  background: -o-linear-gradient(\n    top,\n    #9d9d9d 0%,\n    #c8c8c8 99%\n  ); /* Opera 11.10+ */\n  background: -ms-linear-gradient(top, #9d9d9d 0%, #c8c8c8 99%); /* IE10+ */\n  background: linear-gradient(to bottom, #9d9d9d 0%, #c8c8c8 99%); /* W3C */\n  filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#9d9d9d', endColorstr='#c8c8c8',GradientType=0 ); /* IE6-9 */\n}\n\ninput.vis-configuration.vis-config-range::-moz-range-track {\n  width: 300px;\n  height: 10px;\n  background: #dedede; /* Old browsers */\n  background: -moz-linear-gradient(top, #dedede 0%, #c8c8c8 99%); /* FF3.6+ */\n  background: -webkit-gradient(\n    linear,\n    left top,\n    left bottom,\n    color-stop(0%, #dedede),\n    color-stop(99%, #c8c8c8)\n  ); /* Chrome,Safari4+ */\n  background: -webkit-linear-gradient(\n    top,\n    #dedede 0%,\n    #c8c8c8 99%\n  ); /* Chrome10+,Safari5.1+ */\n  background: -o-linear-gradient(\n    top,\n    #dedede 0%,\n    #c8c8c8 99%\n  ); /* Opera 11.10+ */\n  background: -ms-linear-gradient(top, #dedede 0%, #c8c8c8 99%); /* IE10+ */\n  background: linear-gradient(to bottom, #dedede 0%, #c8c8c8 99%); /* W3C */\n  filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#dedede', endColorstr='#c8c8c8',GradientType=0 ); /* IE6-9 */\n\n  border: 1px solid #999999;\n  box-shadow: #aaaaaa 0px 0px 3px 0px;\n  border-radius: 3px;\n}\ninput.vis-configuration.vis-config-range::-moz-range-thumb {\n  border: none;\n  height: 16px;\n  width: 16px;\n\n  border-radius: 50%;\n  background: #385380;\n}\n\n/*hide the outline behind the border*/\ninput.vis-configuration.vis-config-range:-moz-focusring {\n  outline: 1px solid white;\n  outline-offset: -1px;\n}\n\ninput.vis-configuration.vis-config-range::-ms-track {\n  width: 300px;\n  height: 5px;\n\n  /*remove bg colour from the track, we'll use ms-fill-lower and ms-fill-upper instead */\n  background: transparent;\n\n  /*leave room for the larger thumb to overflow with a transparent border */\n  border-color: transparent;\n  border-width: 6px 0;\n\n  /*remove default tick marks*/\n  color: transparent;\n}\ninput.vis-configuration.vis-config-range::-ms-fill-lower {\n  background: #777;\n  border-radius: 10px;\n}\ninput.vis-configuration.vis-config-range::-ms-fill-upper {\n  background: #ddd;\n  border-radius: 10px;\n}\ninput.vis-configuration.vis-config-range::-ms-thumb {\n  border: none;\n  height: 16px;\n  width: 16px;\n  border-radius: 50%;\n  background: #385380;\n}\ninput.vis-configuration.vis-config-range:focus::-ms-fill-lower {\n  background: #888;\n}\ninput.vis-configuration.vis-config-range:focus::-ms-fill-upper {\n  background: #ccc;\n}\n\n.vis-configuration-popup {\n  position: absolute;\n  background: rgba(57, 76, 89, 0.85);\n  border: 2px solid #f2faff;\n  line-height: 30px;\n  height: 30px;\n  width: 150px;\n  text-align: center;\n  color: #ffffff;\n  font-size: 14px;\n  border-radius: 4px;\n  -webkit-transition: opacity 0.3s ease-in-out;\n  -moz-transition: opacity 0.3s ease-in-out;\n  transition: opacity 0.3s ease-in-out;\n}\n.vis-configuration-popup:after,\n.vis-configuration-popup:before {\n  left: 100%;\n  top: 50%;\n  border: solid transparent;\n  content: \" \";\n  height: 0;\n  width: 0;\n  position: absolute;\n  pointer-events: none;\n}\n\n.vis-configuration-popup:after {\n  border-color: rgba(136, 183, 213, 0);\n  border-left-color: rgba(57, 76, 89, 0.85);\n  border-width: 8px;\n  margin-top: -8px;\n}\n.vis-configuration-popup:before {\n  border-color: rgba(194, 225, 245, 0);\n  border-left-color: #f2faff;\n  border-width: 12px;\n  margin-top: -12px;\n}\n";
styleInject(css_248z$3);

var css_248z$2 = "div.vis-tooltip {\n  position: absolute;\n  visibility: hidden;\n  padding: 5px;\n  white-space: nowrap;\n\n  font-family: verdana;\n  font-size: 14px;\n  color: #000000;\n  background-color: #f5f4ed;\n\n  -moz-border-radius: 3px;\n  -webkit-border-radius: 3px;\n  border-radius: 3px;\n  border: 1px solid #808074;\n\n  box-shadow: 3px 3px 10px rgba(0, 0, 0, 0.2);\n  pointer-events: none;\n\n  z-index: 5;\n}\n";
styleInject(css_248z$2);

var componentEmitter = {exports: {}};

(function (module) {
  /**
   * Expose `Emitter`.
   */
  {
    module.exports = Emitter;
  }
  /**
   * Initialize a new `Emitter`.
   *
   * @api public
   */


  function Emitter(obj) {
    if (obj) return mixin(obj);
  }
  /**
   * Mixin the emitter properties.
   *
   * @param {Object} obj
   * @return {Object}
   * @api private
   */

  function mixin(obj) {
    for (var key in Emitter.prototype) {
      obj[key] = Emitter.prototype[key];
    }

    return obj;
  }
  /**
   * Listen on the given `event` with `fn`.
   *
   * @param {String} event
   * @param {Function} fn
   * @return {Emitter}
   * @api public
   */


  Emitter.prototype.on = Emitter.prototype.addEventListener = function (event, fn) {
    this._callbacks = this._callbacks || {};
    (this._callbacks['$' + event] = this._callbacks['$' + event] || []).push(fn);
    return this;
  };
  /**
   * Adds an `event` listener that will be invoked a single
   * time then automatically removed.
   *
   * @param {String} event
   * @param {Function} fn
   * @return {Emitter}
   * @api public
   */


  Emitter.prototype.once = function (event, fn) {
    function on() {
      this.off(event, on);
      fn.apply(this, arguments);
    }

    on.fn = fn;
    this.on(event, on);
    return this;
  };
  /**
   * Remove the given callback for `event` or all
   * registered callbacks.
   *
   * @param {String} event
   * @param {Function} fn
   * @return {Emitter}
   * @api public
   */


  Emitter.prototype.off = Emitter.prototype.removeListener = Emitter.prototype.removeAllListeners = Emitter.prototype.removeEventListener = function (event, fn) {
    this._callbacks = this._callbacks || {}; // all

    if (0 == arguments.length) {
      this._callbacks = {};
      return this;
    } // specific event


    var callbacks = this._callbacks['$' + event];
    if (!callbacks) return this; // remove all handlers

    if (1 == arguments.length) {
      delete this._callbacks['$' + event];
      return this;
    } // remove specific handler


    var cb;

    for (var i = 0; i < callbacks.length; i++) {
      cb = callbacks[i];

      if (cb === fn || cb.fn === fn) {
        callbacks.splice(i, 1);
        break;
      }
    } // Remove event specific arrays for event types that no
    // one is subscribed for to avoid memory leak.


    if (callbacks.length === 0) {
      delete this._callbacks['$' + event];
    }

    return this;
  };
  /**
   * Emit `event` with the given args.
   *
   * @param {String} event
   * @param {Mixed} ...
   * @return {Emitter}
   */


  Emitter.prototype.emit = function (event) {
    this._callbacks = this._callbacks || {};
    var args = new Array(arguments.length - 1),
        callbacks = this._callbacks['$' + event];

    for (var i = 1; i < arguments.length; i++) {
      args[i - 1] = arguments[i];
    }

    if (callbacks) {
      callbacks = callbacks.slice(0);

      for (var i = 0, len = callbacks.length; i < len; ++i) {
        callbacks[i].apply(this, args);
      }
    }

    return this;
  };
  /**
   * Return array of callbacks for `event`.
   *
   * @param {String} event
   * @return {Array}
   * @api public
   */


  Emitter.prototype.listeners = function (event) {
    this._callbacks = this._callbacks || {};
    return this._callbacks['$' + event] || [];
  };
  /**
   * Check if this emitter has `event` handlers.
   *
   * @param {String} event
   * @return {Boolean}
   * @api public
   */


  Emitter.prototype.hasListeners = function (event) {
    return !!this.listeners(event).length;
  };
})(componentEmitter);

var Emitter = componentEmitter.exports;

var isSymbol$1 = isSymbol$4;

var toString$9 = function (argument) {
  if (isSymbol$1(argument)) throw TypeError('Cannot convert a Symbol value to a string');
  return String(argument);
};

var toInteger$1 = toInteger$4;
var toString$8 = toString$9;
var requireObjectCoercible$2 = requireObjectCoercible$5; // `String.prototype.codePointAt` methods implementation

var createMethod$4 = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = toString$8(requireObjectCoercible$2($this));
    var position = toInteger$1(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = S.charCodeAt(position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = S.charCodeAt(position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? S.charAt(position) : first : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

var stringMultibyte = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod$4(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod$4(true)
};

var store$1 = sharedStore;
var functionToString = Function.toString; // this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper

if (typeof store$1.inspectSource != 'function') {
  store$1.inspectSource = function (it) {
    return functionToString.call(it);
  };
}

var inspectSource$1 = store$1.inspectSource;

var global$c = global$k;
var inspectSource = inspectSource$1;
var WeakMap$1 = global$c.WeakMap;
var nativeWeakMap = typeof WeakMap$1 === 'function' && /native code/.test(inspectSource(WeakMap$1));

var shared$2 = shared$4.exports;
var uid$2 = uid$4;
var keys$7 = shared$2('keys');

var sharedKey$4 = function (key) {
  return keys$7[key] || (keys$7[key] = uid$2(key));
};

var NATIVE_WEAK_MAP$1 = nativeWeakMap;
var global$b = global$k;
var isObject$d = isObject$j;
var createNonEnumerableProperty$7 = createNonEnumerableProperty$9;
var objectHas = has$c;
var shared$1 = sharedStore;
var sharedKey$3 = sharedKey$4;
var hiddenKeys$4 = hiddenKeys$6;
var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var WeakMap = global$b.WeakMap;
var set$3, get$5, has$7;

var enforce = function (it) {
  return has$7(it) ? get$5(it) : set$3(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;

    if (!isObject$d(it) || (state = get$5(it)).type !== TYPE) {
      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
    }

    return state;
  };
};

if (NATIVE_WEAK_MAP$1 || shared$1.state) {
  var store = shared$1.state || (shared$1.state = new WeakMap());
  var wmget = store.get;
  var wmhas = store.has;
  var wmset = store.set;

  set$3 = function (it, metadata) {
    if (wmhas.call(store, it)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    wmset.call(store, it, metadata);
    return metadata;
  };

  get$5 = function (it) {
    return wmget.call(store, it) || {};
  };

  has$7 = function (it) {
    return wmhas.call(store, it);
  };
} else {
  var STATE = sharedKey$3('state');
  hiddenKeys$4[STATE] = true;

  set$3 = function (it, metadata) {
    if (objectHas(it, STATE)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty$7(it, STATE, metadata);
    return metadata;
  };

  get$5 = function (it) {
    return objectHas(it, STATE) ? it[STATE] : {};
  };

  has$7 = function (it) {
    return objectHas(it, STATE);
  };
}

var internalState = {
  set: set$3,
  get: get$5,
  has: has$7,
  enforce: enforce,
  getterFor: getterFor
};

var fails$f = fails$m;
var correctPrototypeGetter = !fails$f(function () {
  function F() {
    /* empty */
  }

  F.prototype.constructor = null; // eslint-disable-next-line es/no-object-getprototypeof -- required for testing

  return Object.getPrototypeOf(new F()) !== F.prototype;
});

var has$6 = has$c;
var toObject$b = toObject$e;
var sharedKey$2 = sharedKey$4;
var CORRECT_PROTOTYPE_GETTER$1 = correctPrototypeGetter;
var IE_PROTO$1 = sharedKey$2('IE_PROTO');
var ObjectPrototype$1 = Object.prototype; // `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es/no-object-getprototypeof -- safe

var objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER$1 ? Object.getPrototypeOf : function (O) {
  O = toObject$b(O);
  if (has$6(O, IE_PROTO$1)) return O[IE_PROTO$1];

  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  }

  return O instanceof Object ? ObjectPrototype$1 : null;
};

var fails$e = fails$m;
var getPrototypeOf$7 = objectGetPrototypeOf;
var createNonEnumerableProperty$6 = createNonEnumerableProperty$9;
var has$5 = has$c;
var wellKnownSymbol$h = wellKnownSymbol$j;
var ITERATOR$4 = wellKnownSymbol$h('iterator');
var BUGGY_SAFARI_ITERATORS$1 = false;

var returnThis$2 = function () {
  return this;
}; // `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object


var IteratorPrototype$2, PrototypeOfArrayIteratorPrototype, arrayIterator;
/* eslint-disable es/no-array-prototype-keys -- safe */

if ([].keys) {
  arrayIterator = [].keys(); // Safari 8 has buggy iterators w/o `next`

  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf$7(getPrototypeOf$7(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$2 = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = IteratorPrototype$2 == undefined || fails$e(function () {
  var test = {}; // FF44- legacy iterators case

  return IteratorPrototype$2[ITERATOR$4].call(test) !== test;
});
if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$2 = {}; // `%IteratorPrototype%[@@iterator]()` method
// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator

if ((NEW_ITERATOR_PROTOTYPE) && !has$5(IteratorPrototype$2, ITERATOR$4)) {
  createNonEnumerableProperty$6(IteratorPrototype$2, ITERATOR$4, returnThis$2);
}

var iteratorsCore = {
  IteratorPrototype: IteratorPrototype$2,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
};

var DESCRIPTORS$a = descriptors;
var definePropertyModule$3 = objectDefineProperty;
var anObject$b = anObject$d;
var objectKeys$2 = objectKeys$4; // `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe

var objectDefineProperties = DESCRIPTORS$a ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject$b(O);
  var keys = objectKeys$2(Properties);
  var length = keys.length;
  var index = 0;
  var key;

  while (length > index) definePropertyModule$3.f(O, key = keys[index++], Properties[key]);

  return O;
};

var getBuiltIn$5 = getBuiltIn$8;
var html$1 = getBuiltIn$5('document', 'documentElement');

/* global ActiveXObject -- old IE, WSH */
var anObject$a = anObject$d;
var defineProperties$5 = objectDefineProperties;
var enumBugKeys$1 = enumBugKeys$3;
var hiddenKeys$3 = hiddenKeys$6;
var html = html$1;
var documentCreateElement = documentCreateElement$1;
var sharedKey$1 = sharedKey$4;
var GT = '>';
var LT = '<';
var PROTOTYPE$1 = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey$1('IE_PROTO');

var EmptyConstructor = function () {
  /* empty */
};

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
}; // Create object with fake `null` prototype: use ActiveX Object with cleared prototype


var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; // avoid memory leak

  return temp;
}; // Create object with fake `null` prototype: use iframe Object with cleared prototype


var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;

  if (iframe.style) {
    iframe.style.display = 'none';
    html.appendChild(iframe); // https://github.com/zloirock/core-js/issues/475

    iframe.src = String(JS);
    iframeDocument = iframe.contentWindow.document;
    iframeDocument.open();
    iframeDocument.write(scriptTag('document.F=Object'));
    iframeDocument.close();
    return iframeDocument.F;
  }
}; // Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug


var activeXDocument;

var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) {
    /* ignore */
  }

  NullProtoObject = document.domain && activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : // old IE
  NullProtoObjectViaIFrame() || NullProtoObjectViaActiveX(activeXDocument); // WSH

  var length = enumBugKeys$1.length;

  while (length--) delete NullProtoObject[PROTOTYPE$1][enumBugKeys$1[length]];

  return NullProtoObject();
};

hiddenKeys$3[IE_PROTO] = true; // `Object.create` method
// https://tc39.es/ecma262/#sec-object.create

var objectCreate = Object.create || function create(O, Properties) {
  var result;

  if (O !== null) {
    EmptyConstructor[PROTOTYPE$1] = anObject$a(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE$1] = null; // add "__proto__" for Object.getPrototypeOf polyfill

    result[IE_PROTO] = O;
  } else result = NullProtoObject();

  return Properties === undefined ? result : defineProperties$5(result, Properties);
};

var wellKnownSymbol$g = wellKnownSymbol$j;
var TO_STRING_TAG$3 = wellKnownSymbol$g('toStringTag');
var test$2 = {};
test$2[TO_STRING_TAG$3] = 'z';
var toStringTagSupport = String(test$2) === '[object z]';

var TO_STRING_TAG_SUPPORT$2 = toStringTagSupport;
var classofRaw = classofRaw$1;
var wellKnownSymbol$f = wellKnownSymbol$j;
var TO_STRING_TAG$2 = wellKnownSymbol$f('toStringTag'); // ES3 wrong here

var CORRECT_ARGUMENTS = classofRaw(function () {
  return arguments;
}()) == 'Arguments'; // fallback for IE11 Script Access Denied error

var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) {
    /* empty */
  }
}; // getting tag from ES6+ `Object.prototype.toString`


var classof$a = TO_STRING_TAG_SUPPORT$2 ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null' // @@toStringTag case
  : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG$2)) == 'string' ? tag // builtinTag case
  : CORRECT_ARGUMENTS ? classofRaw(O) // ES3 arguments fallback
  : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
};

var TO_STRING_TAG_SUPPORT$1 = toStringTagSupport;
var classof$9 = classof$a; // `Object.prototype.toString` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.tostring

var objectToString = TO_STRING_TAG_SUPPORT$1 ? {}.toString : function toString() {
  return '[object ' + classof$9(this) + ']';
};

var TO_STRING_TAG_SUPPORT = toStringTagSupport;
var defineProperty$a = objectDefineProperty.f;
var createNonEnumerableProperty$5 = createNonEnumerableProperty$9;
var has$4 = has$c;
var toString$7 = objectToString;
var wellKnownSymbol$e = wellKnownSymbol$j;
var TO_STRING_TAG$1 = wellKnownSymbol$e('toStringTag');

var setToStringTag$5 = function (it, TAG, STATIC, SET_METHOD) {
  if (it) {
    var target = STATIC ? it : it.prototype;

    if (!has$4(target, TO_STRING_TAG$1)) {
      defineProperty$a(target, TO_STRING_TAG$1, {
        configurable: true,
        value: TAG
      });
    }

    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
      createNonEnumerableProperty$5(target, 'toString', toString$7);
    }
  }
};

var iterators = {};

var IteratorPrototype$1 = iteratorsCore.IteratorPrototype;
var create$8 = objectCreate;
var createPropertyDescriptor$2 = createPropertyDescriptor$5;
var setToStringTag$4 = setToStringTag$5;
var Iterators$5 = iterators;

var returnThis$1 = function () {
  return this;
};

var createIteratorConstructor$1 = function (IteratorConstructor, NAME, next) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = create$8(IteratorPrototype$1, {
    next: createPropertyDescriptor$2(1, next)
  });
  setToStringTag$4(IteratorConstructor, TO_STRING_TAG, false, true);
  Iterators$5[TO_STRING_TAG] = returnThis$1;
  return IteratorConstructor;
};

var isObject$c = isObject$j;

var aPossiblePrototype$1 = function (it) {
  if (!isObject$c(it) && it !== null) {
    throw TypeError("Can't set " + String(it) + ' as a prototype');
  }

  return it;
};

/* eslint-disable no-proto -- safe */
var anObject$9 = anObject$d;
var aPossiblePrototype = aPossiblePrototype$1; // `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es/no-object-setprototypeof -- safe

var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;

  try {
    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
    setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
    setter.call(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) {
    /* empty */
  }

  return function setPrototypeOf(O, proto) {
    anObject$9(O);
    aPossiblePrototype(proto);
    if (CORRECT_SETTER) setter.call(O, proto);else O.__proto__ = proto;
    return O;
  };
}() : undefined);

var createNonEnumerableProperty$4 = createNonEnumerableProperty$9;

var redefine$3 = function (target, key, value, options) {
  if (options && options.enumerable) target[key] = value;else createNonEnumerableProperty$4(target, key, value);
};

var $$H = _export;
var createIteratorConstructor = createIteratorConstructor$1;
var getPrototypeOf$6 = objectGetPrototypeOf;
var setToStringTag$3 = setToStringTag$5;
var createNonEnumerableProperty$3 = createNonEnumerableProperty$9;
var redefine$2 = redefine$3;
var wellKnownSymbol$d = wellKnownSymbol$j;
var Iterators$4 = iterators;
var IteratorsCore = iteratorsCore;
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR$3 = wellKnownSymbol$d('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () {
  return this;
};

var defineIterator$3 = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];

    switch (KIND) {
      case KEYS:
        return function keys() {
          return new IteratorConstructor(this, KIND);
        };

      case VALUES:
        return function values() {
          return new IteratorConstructor(this, KIND);
        };

      case ENTRIES:
        return function entries() {
          return new IteratorConstructor(this, KIND);
        };
    }

    return function () {
      return new IteratorConstructor(this);
    };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR$3] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY; // fix native

  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf$6(anyNativeIterator.call(new Iterable()));

    if (IteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {


      setToStringTag$3(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
      Iterators$4[TO_STRING_TAG] = returnThis;
    }
  } // fix Array.prototype.{ values, @@iterator }.name in V8 / FF


  if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    INCORRECT_VALUES_NAME = true;

    defaultIterator = function values() {
      return nativeIterator.call(this);
    };
  } // define iterator


  if ((FORCED) && IterablePrototype[ITERATOR$3] !== defaultIterator) {
    createNonEnumerableProperty$3(IterablePrototype, ITERATOR$3, defaultIterator);
  }

  Iterators$4[NAME] = defaultIterator; // export additional methods

  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        redefine$2(IterablePrototype, KEY, methods[KEY]);
      }
    } else $$H({
      target: NAME,
      proto: true,
      forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME
    }, methods);
  }

  return methods;
};

var charAt = stringMultibyte.charAt;
var toString$6 = toString$9;
var InternalStateModule$5 = internalState;
var defineIterator$2 = defineIterator$3;
var STRING_ITERATOR = 'String Iterator';
var setInternalState$5 = InternalStateModule$5.set;
var getInternalState$2 = InternalStateModule$5.getterFor(STRING_ITERATOR); // `String.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-string.prototype-@@iterator

defineIterator$2(String, 'String', function (iterated) {
  setInternalState$5(this, {
    type: STRING_ITERATOR,
    string: toString$6(iterated),
    index: 0
  }); // `%StringIteratorPrototype%.next` method
  // https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
}, function next() {
  var state = getInternalState$2(this);
  var string = state.string;
  var index = state.index;
  var point;
  if (index >= string.length) return {
    value: undefined,
    done: true
  };
  point = charAt(string, index);
  state.index += point.length;
  return {
    value: point,
    done: false
  };
});

var anObject$8 = anObject$d;

var iteratorClose$2 = function (iterator) {
  var returnMethod = iterator['return'];

  if (returnMethod !== undefined) {
    return anObject$8(returnMethod.call(iterator)).value;
  }
};

var anObject$7 = anObject$d;
var iteratorClose$1 = iteratorClose$2; // call something on iterator step with safe closing on error

var callWithSafeIterationClosing$1 = function (iterator, fn, value, ENTRIES) {
  try {
    return ENTRIES ? fn(anObject$7(value)[0], value[1]) : fn(value);
  } catch (error) {
    iteratorClose$1(iterator);
    throw error;
  }
};

var wellKnownSymbol$c = wellKnownSymbol$j;
var Iterators$3 = iterators;
var ITERATOR$2 = wellKnownSymbol$c('iterator');
var ArrayPrototype$i = Array.prototype; // check on default Array iterator

var isArrayIteratorMethod$2 = function (it) {
  return it !== undefined && (Iterators$3.Array === it || ArrayPrototype$i[ITERATOR$2] === it);
};

var toPropertyKey$1 = toPropertyKey$4;
var definePropertyModule$2 = objectDefineProperty;
var createPropertyDescriptor$1 = createPropertyDescriptor$5;

var createProperty$5 = function (object, key, value) {
  var propertyKey = toPropertyKey$1(key);
  if (propertyKey in object) definePropertyModule$2.f(object, propertyKey, createPropertyDescriptor$1(0, value));else object[propertyKey] = value;
};

var classof$8 = classof$a;
var Iterators$2 = iterators;
var wellKnownSymbol$b = wellKnownSymbol$j;
var ITERATOR$1 = wellKnownSymbol$b('iterator');

var getIteratorMethod$7 = function (it) {
  if (it != undefined) return it[ITERATOR$1] || it['@@iterator'] || Iterators$2[classof$8(it)];
};

var bind$5 = functionBindContext;
var toObject$a = toObject$e;
var callWithSafeIterationClosing = callWithSafeIterationClosing$1;
var isArrayIteratorMethod$1 = isArrayIteratorMethod$2;
var toLength$a = toLength$c;
var createProperty$4 = createProperty$5;
var getIteratorMethod$6 = getIteratorMethod$7; // `Array.from` method implementation
// https://tc39.es/ecma262/#sec-array.from

var arrayFrom = function from(arrayLike
/* , mapfn = undefined, thisArg = undefined */
) {
  var O = toObject$a(arrayLike);
  var C = typeof this == 'function' ? this : Array;
  var argumentsLength = arguments.length;
  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
  var mapping = mapfn !== undefined;
  var iteratorMethod = getIteratorMethod$6(O);
  var index = 0;
  var length, result, step, iterator, next, value;
  if (mapping) mapfn = bind$5(mapfn, argumentsLength > 2 ? arguments[2] : undefined, 2); // if the target is not iterable or it's an array with the default iterator - use a simple case

  if (iteratorMethod != undefined && !(C == Array && isArrayIteratorMethod$1(iteratorMethod))) {
    iterator = iteratorMethod.call(O);
    next = iterator.next;
    result = new C();

    for (; !(step = next.call(iterator)).done; index++) {
      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
      createProperty$4(result, index, value);
    }
  } else {
    length = toLength$a(O.length);
    result = new C(length);

    for (; length > index; index++) {
      value = mapping ? mapfn(O[index], index) : O[index];
      createProperty$4(result, index, value);
    }
  }

  result.length = index;
  return result;
};

var wellKnownSymbol$a = wellKnownSymbol$j;
var ITERATOR = wellKnownSymbol$a('iterator');
var SAFE_CLOSING = false;

try {
  var called = 0;
  var iteratorWithReturn = {
    next: function () {
      return {
        done: !!called++
      };
    },
    'return': function () {
      SAFE_CLOSING = true;
    }
  };

  iteratorWithReturn[ITERATOR] = function () {
    return this;
  }; // eslint-disable-next-line es/no-array-from, no-throw-literal -- required for testing


  Array.from(iteratorWithReturn, function () {
    throw 2;
  });
} catch (error) {
  /* empty */
}

var checkCorrectnessOfIteration$1 = function (exec, SKIP_CLOSING) {
  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
  var ITERATION_SUPPORT = false;

  try {
    var object = {};

    object[ITERATOR] = function () {
      return {
        next: function () {
          return {
            done: ITERATION_SUPPORT = true
          };
        }
      };
    };

    exec(object);
  } catch (error) {
    /* empty */
  }

  return ITERATION_SUPPORT;
};

var $$G = _export;
var from$5 = arrayFrom;
var checkCorrectnessOfIteration = checkCorrectnessOfIteration$1;
var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function (iterable) {
  // eslint-disable-next-line es/no-array-from -- required for testing
  Array.from(iterable);
}); // `Array.from` method
// https://tc39.es/ecma262/#sec-array.from

$$G({
  target: 'Array',
  stat: true,
  forced: INCORRECT_ITERATION
}, {
  from: from$5
});

var path$s = path$x;
var from$4 = path$s.Array.from;

var parent$X = from$4;
var from$3 = parent$X;

var from$2 = from$3;

var toIndexedObject$6 = toIndexedObject$a;
var Iterators$1 = iterators;
var InternalStateModule$4 = internalState;
var defineIterator$1 = defineIterator$3;
var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState$4 = InternalStateModule$4.set;
var getInternalState$1 = InternalStateModule$4.getterFor(ARRAY_ITERATOR); // `Array.prototype.entries` method
// https://tc39.es/ecma262/#sec-array.prototype.entries
// `Array.prototype.keys` method
// https://tc39.es/ecma262/#sec-array.prototype.keys
// `Array.prototype.values` method
// https://tc39.es/ecma262/#sec-array.prototype.values
// `Array.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
// `CreateArrayIterator` internal method
// https://tc39.es/ecma262/#sec-createarrayiterator

defineIterator$1(Array, 'Array', function (iterated, kind) {
  setInternalState$4(this, {
    type: ARRAY_ITERATOR,
    target: toIndexedObject$6(iterated),
    // target
    index: 0,
    // next index
    kind: kind // kind

  }); // `%ArrayIteratorPrototype%.next` method
  // https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
}, function () {
  var state = getInternalState$1(this);
  var target = state.target;
  var kind = state.kind;
  var index = state.index++;

  if (!target || index >= target.length) {
    state.target = undefined;
    return {
      value: undefined,
      done: true
    };
  }

  if (kind == 'keys') return {
    value: index,
    done: false
  };
  if (kind == 'values') return {
    value: target[index],
    done: false
  };
  return {
    value: [index, target[index]],
    done: false
  };
}, 'values'); // argumentsList[@@iterator] is %ArrayProto_values%
// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
// https://tc39.es/ecma262/#sec-createmappedargumentsobject

Iterators$1.Arguments = Iterators$1.Array; // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

var getIteratorMethod$5 = getIteratorMethod$7;
var getIteratorMethod_1 = getIteratorMethod$5;

// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods

var domIterables = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};

var DOMIterables$4 = domIterables;
var global$a = global$k;
var classof$7 = classof$a;
var createNonEnumerableProperty$2 = createNonEnumerableProperty$9;
var Iterators = iterators;
var wellKnownSymbol$9 = wellKnownSymbol$j;
var TO_STRING_TAG = wellKnownSymbol$9('toStringTag');

for (var COLLECTION_NAME in DOMIterables$4) {
  var Collection = global$a[COLLECTION_NAME];
  var CollectionPrototype = Collection && Collection.prototype;

  if (CollectionPrototype && classof$7(CollectionPrototype) !== TO_STRING_TAG) {
    createNonEnumerableProperty$2(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
  }

  Iterators[COLLECTION_NAME] = Iterators.Array;
}

var parent$W = getIteratorMethod_1;
var getIteratorMethod$4 = parent$W;

var parent$V = getIteratorMethod$4;
var getIteratorMethod$3 = parent$V;

var getIteratorMethod$2 = getIteratorMethod$3;

var classof$6 = classofRaw$1; // `IsArray` abstract operation
// https://tc39.es/ecma262/#sec-isarray
// eslint-disable-next-line es/no-array-isarray -- safe

var isArray$c = Array.isArray || function isArray(arg) {
  return classof$6(arg) == 'Array';
};

var objectGetOwnPropertyNames = {};

var internalObjectKeys = objectKeysInternal;
var enumBugKeys = enumBugKeys$3;
var hiddenKeys$2 = enumBugKeys.concat('length', 'prototype'); // `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe

objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys$2);
};

var objectGetOwnPropertyNamesExternal = {};

/* eslint-disable es/no-object-getownpropertynames -- safe */
var toIndexedObject$5 = toIndexedObject$a;
var $getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
var toString$5 = {}.toString;
var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return $getOwnPropertyNames$1(it);
  } catch (error) {
    return windowNames.slice();
  }
}; // fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window


objectGetOwnPropertyNamesExternal.f = function getOwnPropertyNames(it) {
  return windowNames && toString$5.call(it) == '[object Window]' ? getWindowNames(it) : $getOwnPropertyNames$1(toIndexedObject$5(it));
};

var wellKnownSymbolWrapped = {};

var wellKnownSymbol$8 = wellKnownSymbol$j;
wellKnownSymbolWrapped.f = wellKnownSymbol$8;

var path$r = path$x;
var has$3 = has$c;
var wrappedWellKnownSymbolModule$1 = wellKnownSymbolWrapped;
var defineProperty$9 = objectDefineProperty.f;

var defineWellKnownSymbol$l = function (NAME) {
  var Symbol = path$r.Symbol || (path$r.Symbol = {});
  if (!has$3(Symbol, NAME)) defineProperty$9(Symbol, NAME, {
    value: wrappedWellKnownSymbolModule$1.f(NAME)
  });
};

var isObject$b = isObject$j;
var isArray$b = isArray$c;
var wellKnownSymbol$7 = wellKnownSymbol$j;
var SPECIES$3 = wellKnownSymbol$7('species'); // a part of `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate

var arraySpeciesConstructor$1 = function (originalArray) {
  var C;

  if (isArray$b(originalArray)) {
    C = originalArray.constructor; // cross-realm fallback

    if (typeof C == 'function' && (C === Array || isArray$b(C.prototype))) C = undefined;else if (isObject$b(C)) {
      C = C[SPECIES$3];
      if (C === null) C = undefined;
    }
  }

  return C === undefined ? Array : C;
};

var arraySpeciesConstructor = arraySpeciesConstructor$1; // `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate

var arraySpeciesCreate$4 = function (originalArray, length) {
  return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
};

var bind$4 = functionBindContext;
var IndexedObject$1 = indexedObject;
var toObject$9 = toObject$e;
var toLength$9 = toLength$c;
var arraySpeciesCreate$3 = arraySpeciesCreate$4;
var push = [].push; // `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation

var createMethod$3 = function (TYPE) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var IS_FILTER_REJECT = TYPE == 7;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = toObject$9($this);
    var self = IndexedObject$1(O);
    var boundFunction = bind$4(callbackfn, that, 3);
    var length = toLength$9(self.length);
    var index = 0;
    var create = specificCreate || arraySpeciesCreate$3;
    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
    var value, result;

    for (; length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);

      if (TYPE) {
        if (IS_MAP) target[index] = result; // map
        else if (result) switch (TYPE) {
          case 3:
            return true;
          // some

          case 5:
            return value;
          // find

          case 6:
            return index;
          // findIndex

          case 2:
            push.call(target, value);
          // filter
        } else switch (TYPE) {
          case 4:
            return false;
          // every

          case 7:
            push.call(target, value);
          // filterReject
        }
      }
    }

    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

var arrayIteration = {
  // `Array.prototype.forEach` method
  // https://tc39.es/ecma262/#sec-array.prototype.foreach
  forEach: createMethod$3(0),
  // `Array.prototype.map` method
  // https://tc39.es/ecma262/#sec-array.prototype.map
  map: createMethod$3(1),
  // `Array.prototype.filter` method
  // https://tc39.es/ecma262/#sec-array.prototype.filter
  filter: createMethod$3(2),
  // `Array.prototype.some` method
  // https://tc39.es/ecma262/#sec-array.prototype.some
  some: createMethod$3(3),
  // `Array.prototype.every` method
  // https://tc39.es/ecma262/#sec-array.prototype.every
  every: createMethod$3(4),
  // `Array.prototype.find` method
  // https://tc39.es/ecma262/#sec-array.prototype.find
  find: createMethod$3(5),
  // `Array.prototype.findIndex` method
  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
  findIndex: createMethod$3(6),
  // `Array.prototype.filterReject` method
  // https://github.com/tc39/proposal-array-filtering
  filterReject: createMethod$3(7)
};

var $$F = _export;
var global$9 = global$k;
var getBuiltIn$4 = getBuiltIn$8;
var DESCRIPTORS$9 = descriptors;
var NATIVE_SYMBOL = nativeSymbol;
var fails$d = fails$m;
var has$2 = has$c;
var isArray$a = isArray$c;
var isObject$a = isObject$j;
var isSymbol = isSymbol$4;
var anObject$6 = anObject$d;
var toObject$8 = toObject$e;
var toIndexedObject$4 = toIndexedObject$a;
var toPropertyKey = toPropertyKey$4;
var $toString = toString$9;
var createPropertyDescriptor = createPropertyDescriptor$5;
var nativeObjectCreate = objectCreate;
var objectKeys$1 = objectKeys$4;
var getOwnPropertyNamesModule$2 = objectGetOwnPropertyNames;
var getOwnPropertyNamesExternal = objectGetOwnPropertyNamesExternal;
var getOwnPropertySymbolsModule$1 = objectGetOwnPropertySymbols;
var getOwnPropertyDescriptorModule$2 = objectGetOwnPropertyDescriptor;
var definePropertyModule$1 = objectDefineProperty;
var propertyIsEnumerableModule = objectPropertyIsEnumerable;
var createNonEnumerableProperty$1 = createNonEnumerableProperty$9;
var redefine$1 = redefine$3;
var shared = shared$4.exports;
var sharedKey = sharedKey$4;
var hiddenKeys$1 = hiddenKeys$6;
var uid$1 = uid$4;
var wellKnownSymbol$6 = wellKnownSymbol$j;
var wrappedWellKnownSymbolModule = wellKnownSymbolWrapped;
var defineWellKnownSymbol$k = defineWellKnownSymbol$l;
var setToStringTag$2 = setToStringTag$5;
var InternalStateModule$3 = internalState;
var $forEach$1 = arrayIteration.forEach;
var HIDDEN = sharedKey('hidden');
var SYMBOL = 'Symbol';
var PROTOTYPE = 'prototype';
var TO_PRIMITIVE = wellKnownSymbol$6('toPrimitive');
var setInternalState$3 = InternalStateModule$3.set;
var getInternalState = InternalStateModule$3.getterFor(SYMBOL);
var ObjectPrototype = Object[PROTOTYPE];
var $Symbol = global$9.Symbol;
var $stringify$1 = getBuiltIn$4('JSON', 'stringify');
var nativeGetOwnPropertyDescriptor$1 = getOwnPropertyDescriptorModule$2.f;
var nativeDefineProperty = definePropertyModule$1.f;
var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
var nativePropertyIsEnumerable = propertyIsEnumerableModule.f;
var AllSymbols = shared('symbols');
var ObjectPrototypeSymbols = shared('op-symbols');
var StringToSymbolRegistry = shared('string-to-symbol-registry');
var SymbolToStringRegistry = shared('symbol-to-string-registry');
var WellKnownSymbolsStore = shared('wks');
var QObject = global$9.QObject; // Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173

var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild; // fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687

var setSymbolDescriptor = DESCRIPTORS$9 && fails$d(function () {
  return nativeObjectCreate(nativeDefineProperty({}, 'a', {
    get: function () {
      return nativeDefineProperty(this, 'a', {
        value: 7
      }).a;
    }
  })).a != 7;
}) ? function (O, P, Attributes) {
  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor$1(ObjectPrototype, P);
  if (ObjectPrototypeDescriptor) delete ObjectPrototype[P];
  nativeDefineProperty(O, P, Attributes);

  if (ObjectPrototypeDescriptor && O !== ObjectPrototype) {
    nativeDefineProperty(ObjectPrototype, P, ObjectPrototypeDescriptor);
  }
} : nativeDefineProperty;

var wrap$1 = function (tag, description) {
  var symbol = AllSymbols[tag] = nativeObjectCreate($Symbol[PROTOTYPE]);
  setInternalState$3(symbol, {
    type: SYMBOL,
    tag: tag,
    description: description
  });
  if (!DESCRIPTORS$9) symbol.description = description;
  return symbol;
};

var $defineProperty = function defineProperty(O, P, Attributes) {
  if (O === ObjectPrototype) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
  anObject$6(O);
  var key = toPropertyKey(P);
  anObject$6(Attributes);

  if (has$2(AllSymbols, key)) {
    if (!Attributes.enumerable) {
      if (!has$2(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor(1, {}));
      O[HIDDEN][key] = true;
    } else {
      if (has$2(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
      Attributes = nativeObjectCreate(Attributes, {
        enumerable: createPropertyDescriptor(0, false)
      });
    }

    return setSymbolDescriptor(O, key, Attributes);
  }

  return nativeDefineProperty(O, key, Attributes);
};

var $defineProperties = function defineProperties(O, Properties) {
  anObject$6(O);
  var properties = toIndexedObject$4(Properties);
  var keys = objectKeys$1(properties).concat($getOwnPropertySymbols(properties));
  $forEach$1(keys, function (key) {
    if (!DESCRIPTORS$9 || $propertyIsEnumerable.call(properties, key)) $defineProperty(O, key, properties[key]);
  });
  return O;
};

var $create = function create(O, Properties) {
  return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
};

var $propertyIsEnumerable = function propertyIsEnumerable(V) {
  var P = toPropertyKey(V);
  var enumerable = nativePropertyIsEnumerable.call(this, P);
  if (this === ObjectPrototype && has$2(AllSymbols, P) && !has$2(ObjectPrototypeSymbols, P)) return false;
  return enumerable || !has$2(this, P) || !has$2(AllSymbols, P) || has$2(this, HIDDEN) && this[HIDDEN][P] ? enumerable : true;
};

var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
  var it = toIndexedObject$4(O);
  var key = toPropertyKey(P);
  if (it === ObjectPrototype && has$2(AllSymbols, key) && !has$2(ObjectPrototypeSymbols, key)) return;
  var descriptor = nativeGetOwnPropertyDescriptor$1(it, key);

  if (descriptor && has$2(AllSymbols, key) && !(has$2(it, HIDDEN) && it[HIDDEN][key])) {
    descriptor.enumerable = true;
  }

  return descriptor;
};

var $getOwnPropertyNames = function getOwnPropertyNames(O) {
  var names = nativeGetOwnPropertyNames(toIndexedObject$4(O));
  var result = [];
  $forEach$1(names, function (key) {
    if (!has$2(AllSymbols, key) && !has$2(hiddenKeys$1, key)) result.push(key);
  });
  return result;
};

var $getOwnPropertySymbols = function getOwnPropertySymbols(O) {
  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype;
  var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject$4(O));
  var result = [];
  $forEach$1(names, function (key) {
    if (has$2(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || has$2(ObjectPrototype, key))) {
      result.push(AllSymbols[key]);
    }
  });
  return result;
}; // `Symbol` constructor
// https://tc39.es/ecma262/#sec-symbol-constructor


if (!NATIVE_SYMBOL) {
  $Symbol = function Symbol() {
    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor');
    var description = !arguments.length || arguments[0] === undefined ? undefined : $toString(arguments[0]);
    var tag = uid$1(description);

    var setter = function (value) {
      if (this === ObjectPrototype) setter.call(ObjectPrototypeSymbols, value);
      if (has$2(this, HIDDEN) && has$2(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
      setSymbolDescriptor(this, tag, createPropertyDescriptor(1, value));
    };

    if (DESCRIPTORS$9 && USE_SETTER) setSymbolDescriptor(ObjectPrototype, tag, {
      configurable: true,
      set: setter
    });
    return wrap$1(tag, description);
  };

  redefine$1($Symbol[PROTOTYPE], 'toString', function toString() {
    return getInternalState(this).tag;
  });
  redefine$1($Symbol, 'withoutSetter', function (description) {
    return wrap$1(uid$1(description), description);
  });
  propertyIsEnumerableModule.f = $propertyIsEnumerable;
  definePropertyModule$1.f = $defineProperty;
  getOwnPropertyDescriptorModule$2.f = $getOwnPropertyDescriptor;
  getOwnPropertyNamesModule$2.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
  getOwnPropertySymbolsModule$1.f = $getOwnPropertySymbols;

  wrappedWellKnownSymbolModule.f = function (name) {
    return wrap$1(wellKnownSymbol$6(name), name);
  };

  if (DESCRIPTORS$9) {
    // https://github.com/tc39/proposal-Symbol-description
    nativeDefineProperty($Symbol[PROTOTYPE], 'description', {
      configurable: true,
      get: function description() {
        return getInternalState(this).description;
      }
    });
  }
}

$$F({
  global: true,
  wrap: true,
  forced: !NATIVE_SYMBOL,
  sham: !NATIVE_SYMBOL
}, {
  Symbol: $Symbol
});
$forEach$1(objectKeys$1(WellKnownSymbolsStore), function (name) {
  defineWellKnownSymbol$k(name);
});
$$F({
  target: SYMBOL,
  stat: true,
  forced: !NATIVE_SYMBOL
}, {
  // `Symbol.for` method
  // https://tc39.es/ecma262/#sec-symbol.for
  'for': function (key) {
    var string = $toString(key);
    if (has$2(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
    var symbol = $Symbol(string);
    StringToSymbolRegistry[string] = symbol;
    SymbolToStringRegistry[symbol] = string;
    return symbol;
  },
  // `Symbol.keyFor` method
  // https://tc39.es/ecma262/#sec-symbol.keyfor
  keyFor: function keyFor(sym) {
    if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol');
    if (has$2(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
  },
  useSetter: function () {
    USE_SETTER = true;
  },
  useSimple: function () {
    USE_SETTER = false;
  }
});
$$F({
  target: 'Object',
  stat: true,
  forced: !NATIVE_SYMBOL,
  sham: !DESCRIPTORS$9
}, {
  // `Object.create` method
  // https://tc39.es/ecma262/#sec-object.create
  create: $create,
  // `Object.defineProperty` method
  // https://tc39.es/ecma262/#sec-object.defineproperty
  defineProperty: $defineProperty,
  // `Object.defineProperties` method
  // https://tc39.es/ecma262/#sec-object.defineproperties
  defineProperties: $defineProperties,
  // `Object.getOwnPropertyDescriptor` method
  // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
});
$$F({
  target: 'Object',
  stat: true,
  forced: !NATIVE_SYMBOL
}, {
  // `Object.getOwnPropertyNames` method
  // https://tc39.es/ecma262/#sec-object.getownpropertynames
  getOwnPropertyNames: $getOwnPropertyNames,
  // `Object.getOwnPropertySymbols` method
  // https://tc39.es/ecma262/#sec-object.getownpropertysymbols
  getOwnPropertySymbols: $getOwnPropertySymbols
}); // Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
// https://bugs.chromium.org/p/v8/issues/detail?id=3443

$$F({
  target: 'Object',
  stat: true,
  forced: fails$d(function () {
    getOwnPropertySymbolsModule$1.f(1);
  })
}, {
  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
    return getOwnPropertySymbolsModule$1.f(toObject$8(it));
  }
}); // `JSON.stringify` method behavior with symbols
// https://tc39.es/ecma262/#sec-json.stringify

if ($stringify$1) {
  var FORCED_JSON_STRINGIFY = !NATIVE_SYMBOL || fails$d(function () {
    var symbol = $Symbol(); // MS Edge converts symbol values to JSON as {}

    return $stringify$1([symbol]) != '[null]' // WebKit converts symbol values to JSON as null
    || $stringify$1({
      a: symbol
    }) != '{}' // V8 throws on boxed symbols
    || $stringify$1(Object(symbol)) != '{}';
  });
  $$F({
    target: 'JSON',
    stat: true,
    forced: FORCED_JSON_STRINGIFY
  }, {
    // eslint-disable-next-line no-unused-vars -- required for `.length`
    stringify: function stringify(it, replacer, space) {
      var args = [it];
      var index = 1;
      var $replacer;

      while (arguments.length > index) args.push(arguments[index++]);

      $replacer = replacer;
      if (!isObject$a(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined

      if (!isArray$a(replacer)) replacer = function (key, value) {
        if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
        if (!isSymbol(value)) return value;
      };
      args[1] = replacer;
      return $stringify$1.apply(null, args);
    }
  });
} // `Symbol.prototype[@@toPrimitive]` method
// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive


if (!$Symbol[PROTOTYPE][TO_PRIMITIVE]) {
  createNonEnumerableProperty$1($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);
} // `Symbol.prototype[@@toStringTag]` property
// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag


setToStringTag$2($Symbol, SYMBOL);
hiddenKeys$1[HIDDEN] = true;

var path$q = path$x;
var getOwnPropertySymbols$2 = path$q.Object.getOwnPropertySymbols;

var parent$U = getOwnPropertySymbols$2;
var getOwnPropertySymbols$1 = parent$U;

var getOwnPropertySymbols = getOwnPropertySymbols$1;

var getOwnPropertyDescriptor$5 = {exports: {}};

var $$E = _export;
var fails$c = fails$m;
var toIndexedObject$3 = toIndexedObject$a;
var nativeGetOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
var DESCRIPTORS$8 = descriptors;
var FAILS_ON_PRIMITIVES$3 = fails$c(function () {
  nativeGetOwnPropertyDescriptor(1);
});
var FORCED$6 = !DESCRIPTORS$8 || FAILS_ON_PRIMITIVES$3; // `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor

$$E({
  target: 'Object',
  stat: true,
  forced: FORCED$6,
  sham: !DESCRIPTORS$8
}, {
  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
    return nativeGetOwnPropertyDescriptor(toIndexedObject$3(it), key);
  }
});

var path$p = path$x;
var Object$5 = path$p.Object;

var getOwnPropertyDescriptor$4 = getOwnPropertyDescriptor$5.exports = function getOwnPropertyDescriptor(it, key) {
  return Object$5.getOwnPropertyDescriptor(it, key);
};

if (Object$5.getOwnPropertyDescriptor.sham) getOwnPropertyDescriptor$4.sham = true;

var parent$T = getOwnPropertyDescriptor$5.exports;
var getOwnPropertyDescriptor$3 = parent$T;

var getOwnPropertyDescriptor$2 = getOwnPropertyDescriptor$3;

var getBuiltIn$3 = getBuiltIn$8;
var getOwnPropertyNamesModule$1 = objectGetOwnPropertyNames;
var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
var anObject$5 = anObject$d; // all object keys, includes non-enumerable and symbols

var ownKeys$a = getBuiltIn$3('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule$1.f(anObject$5(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
};

var $$D = _export;
var DESCRIPTORS$7 = descriptors;
var ownKeys$9 = ownKeys$a;
var toIndexedObject$2 = toIndexedObject$a;
var getOwnPropertyDescriptorModule$1 = objectGetOwnPropertyDescriptor;
var createProperty$3 = createProperty$5; // `Object.getOwnPropertyDescriptors` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptors

$$D({
  target: 'Object',
  stat: true,
  sham: !DESCRIPTORS$7
}, {
  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
    var O = toIndexedObject$2(object);
    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule$1.f;
    var keys = ownKeys$9(O);
    var result = {};
    var index = 0;
    var key, descriptor;

    while (keys.length > index) {
      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
      if (descriptor !== undefined) createProperty$3(result, key, descriptor);
    }

    return result;
  }
});

var path$o = path$x;
var getOwnPropertyDescriptors$2 = path$o.Object.getOwnPropertyDescriptors;

var parent$S = getOwnPropertyDescriptors$2;
var getOwnPropertyDescriptors$1 = parent$S;

var getOwnPropertyDescriptors = getOwnPropertyDescriptors$1;

var defineProperties$4 = {exports: {}};

var $$C = _export;
var DESCRIPTORS$6 = descriptors;
var defineProperties$3 = objectDefineProperties; // `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties

$$C({
  target: 'Object',
  stat: true,
  forced: !DESCRIPTORS$6,
  sham: !DESCRIPTORS$6
}, {
  defineProperties: defineProperties$3
});

var path$n = path$x;
var Object$4 = path$n.Object;

var defineProperties$2 = defineProperties$4.exports = function defineProperties(T, D) {
  return Object$4.defineProperties(T, D);
};

if (Object$4.defineProperties.sham) defineProperties$2.sham = true;

var parent$R = defineProperties$4.exports;
var defineProperties$1 = parent$R;

var defineProperties = defineProperties$1;

var defineProperty$8 = {exports: {}};

var $$B = _export;
var DESCRIPTORS$5 = descriptors;
var objectDefinePropertyModile = objectDefineProperty; // `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty

$$B({
  target: 'Object',
  stat: true,
  forced: !DESCRIPTORS$5,
  sham: !DESCRIPTORS$5
}, {
  defineProperty: objectDefinePropertyModile.f
});

var path$m = path$x;
var Object$3 = path$m.Object;

var defineProperty$7 = defineProperty$8.exports = function defineProperty(it, key, desc) {
  return Object$3.defineProperty(it, key, desc);
};

if (Object$3.defineProperty.sham) defineProperty$7.sham = true;

var parent$Q = defineProperty$8.exports;
var defineProperty$6 = parent$Q;

var defineProperty$5 = defineProperty$6;

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

var parent$P = defineProperty$6;
var defineProperty$4 = parent$P;

var defineProperty$3 = defineProperty$4;

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;

    defineProperty$3(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    defineProperty$3(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

var $$A = _export;
var isArray$9 = isArray$c; // `Array.isArray` method
// https://tc39.es/ecma262/#sec-array.isarray

$$A({
  target: 'Array',
  stat: true
}, {
  isArray: isArray$9
});

var path$l = path$x;
var isArray$8 = path$l.Array.isArray;

var parent$O = isArray$8;
var isArray$7 = parent$O;

var parent$N = isArray$7;
var isArray$6 = parent$N;

var isArray$5 = isArray$6;

function _arrayWithHoles(arr) {
  if (isArray$5(arr)) return arr;
}

var fails$b = fails$m;
var wellKnownSymbol$5 = wellKnownSymbol$j;
var V8_VERSION$1 = engineV8Version;
var SPECIES$2 = wellKnownSymbol$5('species');

var arrayMethodHasSpeciesSupport$5 = function (METHOD_NAME) {
  // We can't use this feature detection in V8 since it causes
  // deoptimization and serious performance degradation
  // https://github.com/zloirock/core-js/issues/677
  return V8_VERSION$1 >= 51 || !fails$b(function () {
    var array = [];
    var constructor = array.constructor = {};

    constructor[SPECIES$2] = function () {
      return {
        foo: 1
      };
    };

    return array[METHOD_NAME](Boolean).foo !== 1;
  });
};

var $$z = _export;
var fails$a = fails$m;
var isArray$4 = isArray$c;
var isObject$9 = isObject$j;
var toObject$7 = toObject$e;
var toLength$8 = toLength$c;
var createProperty$2 = createProperty$5;
var arraySpeciesCreate$2 = arraySpeciesCreate$4;
var arrayMethodHasSpeciesSupport$4 = arrayMethodHasSpeciesSupport$5;
var wellKnownSymbol$4 = wellKnownSymbol$j;
var V8_VERSION = engineV8Version;
var IS_CONCAT_SPREADABLE = wellKnownSymbol$4('isConcatSpreadable');
var MAX_SAFE_INTEGER$1 = 0x1FFFFFFFFFFFFF;
var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded'; // We can't use this feature detection in V8 since it causes
// deoptimization and serious performance degradation
// https://github.com/zloirock/core-js/issues/679

var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails$a(function () {
  var array = [];
  array[IS_CONCAT_SPREADABLE] = false;
  return array.concat()[0] !== array;
});
var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport$4('concat');

var isConcatSpreadable = function (O) {
  if (!isObject$9(O)) return false;
  var spreadable = O[IS_CONCAT_SPREADABLE];
  return spreadable !== undefined ? !!spreadable : isArray$4(O);
};

var FORCED$5 = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT; // `Array.prototype.concat` method
// https://tc39.es/ecma262/#sec-array.prototype.concat
// with adding support of @@isConcatSpreadable and @@species

$$z({
  target: 'Array',
  proto: true,
  forced: FORCED$5
}, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  concat: function concat(arg) {
    var O = toObject$7(this);
    var A = arraySpeciesCreate$2(O, 0);
    var n = 0;
    var i, k, length, len, E;

    for (i = -1, length = arguments.length; i < length; i++) {
      E = i === -1 ? O : arguments[i];

      if (isConcatSpreadable(E)) {
        len = toLength$8(E.length);
        if (n + len > MAX_SAFE_INTEGER$1) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);

        for (k = 0; k < len; k++, n++) if (k in E) createProperty$2(A, n, E[k]);
      } else {
        if (n >= MAX_SAFE_INTEGER$1) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        createProperty$2(A, n++, E);
      }
    }

    A.length = n;
    return A;
  }
});

var defineWellKnownSymbol$j = defineWellKnownSymbol$l; // `Symbol.asyncIterator` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.asynciterator

defineWellKnownSymbol$j('asyncIterator');

var defineWellKnownSymbol$i = defineWellKnownSymbol$l; // `Symbol.hasInstance` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.hasinstance

defineWellKnownSymbol$i('hasInstance');

var defineWellKnownSymbol$h = defineWellKnownSymbol$l; // `Symbol.isConcatSpreadable` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.isconcatspreadable

defineWellKnownSymbol$h('isConcatSpreadable');

var defineWellKnownSymbol$g = defineWellKnownSymbol$l; // `Symbol.iterator` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.iterator

defineWellKnownSymbol$g('iterator');

var defineWellKnownSymbol$f = defineWellKnownSymbol$l; // `Symbol.match` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.match

defineWellKnownSymbol$f('match');

var defineWellKnownSymbol$e = defineWellKnownSymbol$l; // `Symbol.matchAll` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.matchall

defineWellKnownSymbol$e('matchAll');

var defineWellKnownSymbol$d = defineWellKnownSymbol$l; // `Symbol.replace` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.replace

defineWellKnownSymbol$d('replace');

var defineWellKnownSymbol$c = defineWellKnownSymbol$l; // `Symbol.search` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.search

defineWellKnownSymbol$c('search');

var defineWellKnownSymbol$b = defineWellKnownSymbol$l; // `Symbol.species` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.species

defineWellKnownSymbol$b('species');

var defineWellKnownSymbol$a = defineWellKnownSymbol$l; // `Symbol.split` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.split

defineWellKnownSymbol$a('split');

var defineWellKnownSymbol$9 = defineWellKnownSymbol$l; // `Symbol.toPrimitive` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.toprimitive

defineWellKnownSymbol$9('toPrimitive');

var defineWellKnownSymbol$8 = defineWellKnownSymbol$l; // `Symbol.toStringTag` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.tostringtag

defineWellKnownSymbol$8('toStringTag');

var defineWellKnownSymbol$7 = defineWellKnownSymbol$l; // `Symbol.unscopables` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.unscopables

defineWellKnownSymbol$7('unscopables');

var global$8 = global$k;
var setToStringTag$1 = setToStringTag$5; // JSON[@@toStringTag] property
// https://tc39.es/ecma262/#sec-json-@@tostringtag

setToStringTag$1(global$8.JSON, 'JSON', true);

var path$k = path$x;
var symbol$4 = path$k.Symbol;

var parent$M = symbol$4;
var symbol$3 = parent$M;

var defineWellKnownSymbol$6 = defineWellKnownSymbol$l; // `Symbol.asyncDispose` well-known symbol
// https://github.com/tc39/proposal-using-statement

defineWellKnownSymbol$6('asyncDispose');

var defineWellKnownSymbol$5 = defineWellKnownSymbol$l; // `Symbol.dispose` well-known symbol
// https://github.com/tc39/proposal-using-statement

defineWellKnownSymbol$5('dispose');

var defineWellKnownSymbol$4 = defineWellKnownSymbol$l; // `Symbol.matcher` well-known symbol
// https://github.com/tc39/proposal-pattern-matching

defineWellKnownSymbol$4('matcher');

var defineWellKnownSymbol$3 = defineWellKnownSymbol$l; // `Symbol.metadata` well-known symbol
// https://github.com/tc39/proposal-decorators

defineWellKnownSymbol$3('metadata');

var defineWellKnownSymbol$2 = defineWellKnownSymbol$l; // `Symbol.observable` well-known symbol
// https://github.com/tc39/proposal-observable

defineWellKnownSymbol$2('observable');

var defineWellKnownSymbol$1 = defineWellKnownSymbol$l; // `Symbol.patternMatch` well-known symbol
// https://github.com/tc39/proposal-pattern-matching

defineWellKnownSymbol$1('patternMatch');

var defineWellKnownSymbol = defineWellKnownSymbol$l;
defineWellKnownSymbol('replaceAll');

var parent$L = symbol$3; // TODO: Remove from `core-js@4`
// TODO: Remove from `core-js@4`

var symbol$2 = parent$L;

var symbol$1 = symbol$2;

function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof symbol$1 !== "undefined" && getIteratorMethod$2(arr) || arr["@@iterator"];

  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;

  var _s, _e;

  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

var $$y = _export;
var isObject$8 = isObject$j;
var isArray$3 = isArray$c;
var toAbsoluteIndex$2 = toAbsoluteIndex$4;
var toLength$7 = toLength$c;
var toIndexedObject$1 = toIndexedObject$a;
var createProperty$1 = createProperty$5;
var wellKnownSymbol$3 = wellKnownSymbol$j;
var arrayMethodHasSpeciesSupport$3 = arrayMethodHasSpeciesSupport$5;
var HAS_SPECIES_SUPPORT$3 = arrayMethodHasSpeciesSupport$3('slice');
var SPECIES$1 = wellKnownSymbol$3('species');
var nativeSlice = [].slice;
var max$1 = Math.max; // `Array.prototype.slice` method
// https://tc39.es/ecma262/#sec-array.prototype.slice
// fallback for not array-like ES3 strings and DOM objects

$$y({
  target: 'Array',
  proto: true,
  forced: !HAS_SPECIES_SUPPORT$3
}, {
  slice: function slice(start, end) {
    var O = toIndexedObject$1(this);
    var length = toLength$7(O.length);
    var k = toAbsoluteIndex$2(start, length);
    var fin = toAbsoluteIndex$2(end === undefined ? length : end, length); // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible

    var Constructor, result, n;

    if (isArray$3(O)) {
      Constructor = O.constructor; // cross-realm fallback

      if (typeof Constructor == 'function' && (Constructor === Array || isArray$3(Constructor.prototype))) {
        Constructor = undefined;
      } else if (isObject$8(Constructor)) {
        Constructor = Constructor[SPECIES$1];
        if (Constructor === null) Constructor = undefined;
      }

      if (Constructor === Array || Constructor === undefined) {
        return nativeSlice.call(O, k, fin);
      }
    }

    result = new (Constructor === undefined ? Array : Constructor)(max$1(fin - k, 0));

    for (n = 0; k < fin; k++, n++) if (k in O) createProperty$1(result, n, O[k]);

    result.length = n;
    return result;
  }
});

var entryVirtual$j = entryVirtual$l;
var slice$6 = entryVirtual$j('Array').slice;

var slice$5 = slice$6;
var ArrayPrototype$h = Array.prototype;

var slice_1 = function (it) {
  var own = it.slice;
  return it === ArrayPrototype$h || it instanceof Array && own === ArrayPrototype$h.slice ? slice$5 : own;
};

var parent$K = slice_1;
var slice$4 = parent$K;

var parent$J = slice$4;
var slice$3 = parent$J;

var slice$2 = slice$3;

var parent$I = from$3;
var from$1 = parent$I;

var from = from$1;

function _arrayLikeToArray$9(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) {
    arr2[i] = arr[i];
  }

  return arr2;
}

function _unsupportedIterableToArray$9(o, minLen) {
  var _context;

  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray$9(o, minLen);

  var n = slice$2(_context = Object.prototype.toString.call(o)).call(_context, 8, -1);

  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$9(o, minLen);
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray$9(arr, i) || _nonIterableRest();
}

var WrappedWellKnownSymbolModule = wellKnownSymbolWrapped;
var iterator$4 = WrappedWellKnownSymbolModule.f('iterator');

var parent$H = iterator$4;
var iterator$3 = parent$H;

var parent$G = iterator$3;
var iterator$2 = parent$G;

var iterator$1 = iterator$2;

function _typeof(obj) {
  "@babel/helpers - typeof";

  if (typeof symbol$1 === "function" && typeof iterator$1 === "symbol") {
    _typeof = function _typeof(obj) {
      return typeof obj;
    };
  } else {
    _typeof = function _typeof(obj) {
      return obj && typeof symbol$1 === "function" && obj.constructor === symbol$1 && obj !== symbol$1.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _arrayWithoutHoles(arr) {
  if (isArray$5(arr)) return _arrayLikeToArray$9(arr);
}

function _iterableToArray(iter) {
  if (typeof symbol$1 !== "undefined" && getIteratorMethod$2(iter) != null || iter["@@iterator"] != null) return from(iter);
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray$9(arr) || _nonIterableSpread();
}

var symbol = symbol$3;

var entryVirtual$i = entryVirtual$l;
var concat$3 = entryVirtual$i('Array').concat;

var concat$2 = concat$3;
var ArrayPrototype$g = Array.prototype;

var concat_1 = function (it) {
  var own = it.concat;
  return it === ArrayPrototype$g || it instanceof Array && own === ArrayPrototype$g.concat ? concat$2 : own;
};

var parent$F = concat_1;
var concat$1 = parent$F;

var concat = concat$1;

var slice$1 = slice$4;

var $$x = _export;
var ownKeys$8 = ownKeys$a; // `Reflect.ownKeys` method
// https://tc39.es/ecma262/#sec-reflect.ownkeys

$$x({
  target: 'Reflect',
  stat: true
}, {
  ownKeys: ownKeys$8
});

var path$j = path$x;
var ownKeys$7 = path$j.Reflect.ownKeys;

var parent$E = ownKeys$7;
var ownKeys$6 = parent$E;

var ownKeys$5 = ownKeys$6;

var isArray$2 = isArray$7;

var $$w = _export;
var $map = arrayIteration.map;
var arrayMethodHasSpeciesSupport$2 = arrayMethodHasSpeciesSupport$5;
var HAS_SPECIES_SUPPORT$2 = arrayMethodHasSpeciesSupport$2('map'); // `Array.prototype.map` method
// https://tc39.es/ecma262/#sec-array.prototype.map
// with adding support of @@species

$$w({
  target: 'Array',
  proto: true,
  forced: !HAS_SPECIES_SUPPORT$2
}, {
  map: function map(callbackfn
  /* , thisArg */
  ) {
    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$h = entryVirtual$l;
var map$6 = entryVirtual$h('Array').map;

var map$5 = map$6;
var ArrayPrototype$f = Array.prototype;

var map_1 = function (it) {
  var own = it.map;
  return it === ArrayPrototype$f || it instanceof Array && own === ArrayPrototype$f.map ? map$5 : own;
};

var parent$D = map_1;
var map$4 = parent$D;

var map$3 = map$4;

var $$v = _export;
var toObject$6 = toObject$e;
var nativeKeys = objectKeys$4;
var fails$9 = fails$m;
var FAILS_ON_PRIMITIVES$2 = fails$9(function () {
  nativeKeys(1);
}); // `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys

$$v({
  target: 'Object',
  stat: true,
  forced: FAILS_ON_PRIMITIVES$2
}, {
  keys: function keys(it) {
    return nativeKeys(toObject$6(it));
  }
});

var path$i = path$x;
var keys$6 = path$i.Object.keys;

var parent$C = keys$6;
var keys$5 = parent$C;

var keys$4 = keys$5;

var $$u = _export; // `Date.now` method
// https://tc39.es/ecma262/#sec-date.now

$$u({
  target: 'Date',
  stat: true
}, {
  now: function now() {
    return new Date().getTime();
  }
});

var path$h = path$x;
var now$3 = path$h.Date.now;

var parent$B = now$3;
var now$2 = parent$B;

var now$1 = now$2;

var fails$8 = fails$m;

var arrayMethodIsStrict$6 = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && fails$8(function () {
    // eslint-disable-next-line no-useless-call,no-throw-literal -- required for testing
    method.call(null, argument || function () {
      throw 1;
    }, 1);
  });
};

var $forEach = arrayIteration.forEach;
var arrayMethodIsStrict$5 = arrayMethodIsStrict$6;
var STRICT_METHOD$5 = arrayMethodIsStrict$5('forEach'); // `Array.prototype.forEach` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.foreach

var arrayForEach = !STRICT_METHOD$5 ? function forEach(callbackfn
/* , thisArg */
) {
  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined); // eslint-disable-next-line es/no-array-prototype-foreach -- safe
} : [].forEach;

var $$t = _export;
var forEach$6 = arrayForEach; // `Array.prototype.forEach` method
// https://tc39.es/ecma262/#sec-array.prototype.foreach
// eslint-disable-next-line es/no-array-prototype-foreach -- safe

$$t({
  target: 'Array',
  proto: true,
  forced: [].forEach != forEach$6
}, {
  forEach: forEach$6
});

var entryVirtual$g = entryVirtual$l;
var forEach$5 = entryVirtual$g('Array').forEach;

var parent$A = forEach$5;
var forEach$4 = parent$A;

var forEach$3 = forEach$4;
var classof$5 = classof$a;
var ArrayPrototype$e = Array.prototype;
var DOMIterables$3 = {
  DOMTokenList: true,
  NodeList: true
};

var forEach_1 = function (it) {
  var own = it.forEach;
  return it === ArrayPrototype$e || it instanceof Array && own === ArrayPrototype$e.forEach // eslint-disable-next-line no-prototype-builtins -- safe
  || DOMIterables$3.hasOwnProperty(classof$5(it)) ? forEach$3 : own;
};

var forEach$2 = forEach_1;

var $$s = _export;
var isArray$1 = isArray$c;
var nativeReverse = [].reverse;
var test$1 = [1, 2]; // `Array.prototype.reverse` method
// https://tc39.es/ecma262/#sec-array.prototype.reverse
// fix for Safari 12.0 bug
// https://bugs.webkit.org/show_bug.cgi?id=188794

$$s({
  target: 'Array',
  proto: true,
  forced: String(test$1) === String(test$1.reverse())
}, {
  reverse: function reverse() {
    // eslint-disable-next-line no-self-assign -- dirty hack
    if (isArray$1(this)) this.length = this.length;
    return nativeReverse.call(this);
  }
});

var entryVirtual$f = entryVirtual$l;
var reverse$3 = entryVirtual$f('Array').reverse;

var reverse$2 = reverse$3;
var ArrayPrototype$d = Array.prototype;

var reverse_1 = function (it) {
  var own = it.reverse;
  return it === ArrayPrototype$d || it instanceof Array && own === ArrayPrototype$d.reverse ? reverse$2 : own;
};

var parent$z = reverse_1;
var reverse$1 = parent$z;

var reverse = reverse$1;

var $$r = _export;
var toAbsoluteIndex$1 = toAbsoluteIndex$4;
var toInteger = toInteger$4;
var toLength$6 = toLength$c;
var toObject$5 = toObject$e;
var arraySpeciesCreate$1 = arraySpeciesCreate$4;
var createProperty = createProperty$5;
var arrayMethodHasSpeciesSupport$1 = arrayMethodHasSpeciesSupport$5;
var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport$1('splice');
var max = Math.max;
var min = Math.min;
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = 'Maximum allowed length exceeded'; // `Array.prototype.splice` method
// https://tc39.es/ecma262/#sec-array.prototype.splice
// with adding support of @@species

$$r({
  target: 'Array',
  proto: true,
  forced: !HAS_SPECIES_SUPPORT$1
}, {
  splice: function splice(start, deleteCount
  /* , ...items */
  ) {
    var O = toObject$5(this);
    var len = toLength$6(O.length);
    var actualStart = toAbsoluteIndex$1(start, len);
    var argumentsLength = arguments.length;
    var insertCount, actualDeleteCount, A, k, from, to;

    if (argumentsLength === 0) {
      insertCount = actualDeleteCount = 0;
    } else if (argumentsLength === 1) {
      insertCount = 0;
      actualDeleteCount = len - actualStart;
    } else {
      insertCount = argumentsLength - 2;
      actualDeleteCount = min(max(toInteger(deleteCount), 0), len - actualStart);
    }

    if (len + insertCount - actualDeleteCount > MAX_SAFE_INTEGER) {
      throw TypeError(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
    }

    A = arraySpeciesCreate$1(O, actualDeleteCount);

    for (k = 0; k < actualDeleteCount; k++) {
      from = actualStart + k;
      if (from in O) createProperty(A, k, O[from]);
    }

    A.length = actualDeleteCount;

    if (insertCount < actualDeleteCount) {
      for (k = actualStart; k < len - actualDeleteCount; k++) {
        from = k + actualDeleteCount;
        to = k + insertCount;
        if (from in O) O[to] = O[from];else delete O[to];
      }

      for (k = len; k > len - actualDeleteCount + insertCount; k--) delete O[k - 1];
    } else if (insertCount > actualDeleteCount) {
      for (k = len - actualDeleteCount; k > actualStart; k--) {
        from = k + actualDeleteCount - 1;
        to = k + insertCount - 1;
        if (from in O) O[to] = O[from];else delete O[to];
      }
    }

    for (k = 0; k < insertCount; k++) {
      O[k + actualStart] = arguments[k + 2];
    }

    O.length = len - actualDeleteCount + insertCount;
    return A;
  }
});

var entryVirtual$e = entryVirtual$l;
var splice$3 = entryVirtual$e('Array').splice;

var splice$2 = splice$3;
var ArrayPrototype$c = Array.prototype;

var splice_1 = function (it) {
  var own = it.splice;
  return it === ArrayPrototype$c || it instanceof Array && own === ArrayPrototype$c.splice ? splice$2 : own;
};

var parent$y = splice_1;
var splice$1 = parent$y;

var splice = splice$1;

var $$q = _export;
var $includes = arrayIncludes$1.includes;
// https://tc39.es/ecma262/#sec-array.prototype.includes

$$q({
  target: 'Array',
  proto: true
}, {
  includes: function includes(el
  /* , fromIndex = 0 */
  ) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
}); // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

var entryVirtual$d = entryVirtual$l;
var includes$4 = entryVirtual$d('Array').includes;

var isObject$7 = isObject$j;
var classof$4 = classofRaw$1;
var wellKnownSymbol$2 = wellKnownSymbol$j;
var MATCH$1 = wellKnownSymbol$2('match'); // `IsRegExp` abstract operation
// https://tc39.es/ecma262/#sec-isregexp

var isRegexp = function (it) {
  var isRegExp;
  return isObject$7(it) && ((isRegExp = it[MATCH$1]) !== undefined ? !!isRegExp : classof$4(it) == 'RegExp');
};

var isRegExp = isRegexp;

var notARegexp = function (it) {
  if (isRegExp(it)) {
    throw TypeError("The method doesn't accept regular expressions");
  }

  return it;
};

var wellKnownSymbol$1 = wellKnownSymbol$j;
var MATCH = wellKnownSymbol$1('match');

var correctIsRegexpLogic = function (METHOD_NAME) {
  var regexp = /./;

  try {
    '/./'[METHOD_NAME](regexp);
  } catch (error1) {
    try {
      regexp[MATCH] = false;
      return '/./'[METHOD_NAME](regexp);
    } catch (error2) {
      /* empty */
    }
  }

  return false;
};

var $$p = _export;
var notARegExp = notARegexp;
var requireObjectCoercible$1 = requireObjectCoercible$5;
var toString$4 = toString$9;
var correctIsRegExpLogic = correctIsRegexpLogic; // `String.prototype.includes` method
// https://tc39.es/ecma262/#sec-string.prototype.includes

$$p({
  target: 'String',
  proto: true,
  forced: !correctIsRegExpLogic('includes')
}, {
  includes: function includes(searchString
  /* , position = 0 */
  ) {
    return !!~toString$4(requireObjectCoercible$1(this)).indexOf(toString$4(notARegExp(searchString)), arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$c = entryVirtual$l;
var includes$3 = entryVirtual$c('String').includes;

var arrayIncludes = includes$4;
var stringIncludes = includes$3;
var ArrayPrototype$b = Array.prototype;
var StringPrototype = String.prototype;

var includes$2 = function (it) {
  var own = it.includes;
  if (it === ArrayPrototype$b || it instanceof Array && own === ArrayPrototype$b.includes) return arrayIncludes;

  if (typeof it === 'string' || it === StringPrototype || it instanceof String && own === StringPrototype.includes) {
    return stringIncludes;
  }

  return own;
};

var parent$x = includes$2;
var includes$1 = parent$x;

var includes = includes$1;

var $$o = _export;
var fails$7 = fails$m;
var toObject$4 = toObject$e;
var nativeGetPrototypeOf = objectGetPrototypeOf;
var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;
var FAILS_ON_PRIMITIVES$1 = fails$7(function () {
  nativeGetPrototypeOf(1);
}); // `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof

$$o({
  target: 'Object',
  stat: true,
  forced: FAILS_ON_PRIMITIVES$1,
  sham: !CORRECT_PROTOTYPE_GETTER
}, {
  getPrototypeOf: function getPrototypeOf(it) {
    return nativeGetPrototypeOf(toObject$4(it));
  }
});

var path$g = path$x;
var getPrototypeOf$5 = path$g.Object.getPrototypeOf;

var parent$w = getPrototypeOf$5;
var getPrototypeOf$4 = parent$w;

var getPrototypeOf$3 = getPrototypeOf$4;

var $$n = _export;
var $filter = arrayIteration.filter;
var arrayMethodHasSpeciesSupport = arrayMethodHasSpeciesSupport$5;
var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter'); // `Array.prototype.filter` method
// https://tc39.es/ecma262/#sec-array.prototype.filter
// with adding support of @@species

$$n({
  target: 'Array',
  proto: true,
  forced: !HAS_SPECIES_SUPPORT
}, {
  filter: function filter(callbackfn
  /* , thisArg */
  ) {
    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$b = entryVirtual$l;
var filter$3 = entryVirtual$b('Array').filter;

var filter$2 = filter$3;
var ArrayPrototype$a = Array.prototype;

var filter_1 = function (it) {
  var own = it.filter;
  return it === ArrayPrototype$a || it instanceof Array && own === ArrayPrototype$a.filter ? filter$2 : own;
};

var parent$v = filter_1;
var filter$1 = parent$v;

var filter = filter$1;

var DESCRIPTORS$4 = descriptors;
var objectKeys = objectKeys$4;
var toIndexedObject = toIndexedObject$a;
var propertyIsEnumerable = objectPropertyIsEnumerable.f; // `Object.{ entries, values }` methods implementation

var createMethod$2 = function (TO_ENTRIES) {
  return function (it) {
    var O = toIndexedObject(it);
    var keys = objectKeys(O);
    var length = keys.length;
    var i = 0;
    var result = [];
    var key;

    while (length > i) {
      key = keys[i++];

      if (!DESCRIPTORS$4 || propertyIsEnumerable.call(O, key)) {
        result.push(TO_ENTRIES ? [key, O[key]] : O[key]);
      }
    }

    return result;
  };
};

var objectToArray = {
  // `Object.entries` method
  // https://tc39.es/ecma262/#sec-object.entries
  entries: createMethod$2(true),
  // `Object.values` method
  // https://tc39.es/ecma262/#sec-object.values
  values: createMethod$2(false)
};

var $$m = _export;
var $values = objectToArray.values; // `Object.values` method
// https://tc39.es/ecma262/#sec-object.values

$$m({
  target: 'Object',
  stat: true
}, {
  values: function values(O) {
    return $values(O);
  }
});

var path$f = path$x;
path$f.Object.values;

var whitespaces$4 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' + '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

var requireObjectCoercible = requireObjectCoercible$5;
var toString$3 = toString$9;
var whitespaces$3 = whitespaces$4;
var whitespace = '[' + whitespaces$3 + ']';
var ltrim = RegExp('^' + whitespace + whitespace + '*');
var rtrim = RegExp(whitespace + whitespace + '*$'); // `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation

var createMethod$1 = function (TYPE) {
  return function ($this) {
    var string = toString$3(requireObjectCoercible($this));
    if (TYPE & 1) string = string.replace(ltrim, '');
    if (TYPE & 2) string = string.replace(rtrim, '');
    return string;
  };
};

var stringTrim = {
  // `String.prototype.{ trimLeft, trimStart }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
  start: createMethod$1(1),
  // `String.prototype.{ trimRight, trimEnd }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimend
  end: createMethod$1(2),
  // `String.prototype.trim` method
  // https://tc39.es/ecma262/#sec-string.prototype.trim
  trim: createMethod$1(3)
};

var global$7 = global$k;
var toString$2 = toString$9;
var trim$1 = stringTrim.trim;
var whitespaces$2 = whitespaces$4;
var $parseInt = global$7.parseInt;
var hex = /^[+-]?0[Xx]/;
var FORCED$4 = $parseInt(whitespaces$2 + '08') !== 8 || $parseInt(whitespaces$2 + '0x16') !== 22; // `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix

var numberParseInt = FORCED$4 ? function parseInt(string, radix) {
  var S = trim$1(toString$2(string));
  return $parseInt(S, radix >>> 0 || (hex.test(S) ? 16 : 10));
} : $parseInt;

var $$l = _export;
var parseIntImplementation = numberParseInt; // `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix

$$l({
  global: true,
  forced: parseInt != parseIntImplementation
}, {
  parseInt: parseIntImplementation
});

var path$e = path$x;
var _parseInt$2 = path$e.parseInt;

var parent$u = _parseInt$2;
var _parseInt$1 = parent$u;

var _parseInt = _parseInt$1;

/* eslint-disable es/no-array-prototype-indexof -- required for testing */


var $$k = _export;
var $indexOf = arrayIncludes$1.indexOf;
var arrayMethodIsStrict$4 = arrayMethodIsStrict$6;
var nativeIndexOf = [].indexOf;
var NEGATIVE_ZERO = !!nativeIndexOf && 1 / [1].indexOf(1, -0) < 0;
var STRICT_METHOD$4 = arrayMethodIsStrict$4('indexOf'); // `Array.prototype.indexOf` method
// https://tc39.es/ecma262/#sec-array.prototype.indexof

$$k({
  target: 'Array',
  proto: true,
  forced: NEGATIVE_ZERO || !STRICT_METHOD$4
}, {
  indexOf: function indexOf(searchElement
  /* , fromIndex = 0 */
  ) {
    return NEGATIVE_ZERO // convert -0 to +0
    ? nativeIndexOf.apply(this, arguments) || 0 : $indexOf(this, searchElement, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$a = entryVirtual$l;
var indexOf$3 = entryVirtual$a('Array').indexOf;

var indexOf$2 = indexOf$3;
var ArrayPrototype$9 = Array.prototype;

var indexOf_1 = function (it) {
  var own = it.indexOf;
  return it === ArrayPrototype$9 || it instanceof Array && own === ArrayPrototype$9.indexOf ? indexOf$2 : own;
};

var parent$t = indexOf_1;
var indexOf$1 = parent$t;

var indexOf = indexOf$1;

var fails$6 = fails$m;
var whitespaces$1 = whitespaces$4;
var non = '\u200B\u0085\u180E'; // check that a method works with the correct list
// of whitespaces and has a correct name

var stringTrimForced = function (METHOD_NAME) {
  return fails$6(function () {
    return !!whitespaces$1[METHOD_NAME]() || non[METHOD_NAME]() != non || whitespaces$1[METHOD_NAME].name !== METHOD_NAME;
  });
};

var $$j = _export;
var $trim = stringTrim.trim;
var forcedStringTrimMethod = stringTrimForced; // `String.prototype.trim` method
// https://tc39.es/ecma262/#sec-string.prototype.trim

$$j({
  target: 'String',
  proto: true,
  forced: forcedStringTrimMethod('trim')
}, {
  trim: function trim() {
    return $trim(this);
  }
});

var entryVirtual$9 = entryVirtual$l;
entryVirtual$9('String').trim;

var $$i = _export;
var DESCRIPTORS$3 = descriptors;
var create$7 = objectCreate; // `Object.create` method
// https://tc39.es/ecma262/#sec-object.create

$$i({
  target: 'Object',
  stat: true,
  sham: !DESCRIPTORS$3
}, {
  create: create$7
});

var path$d = path$x;
var Object$2 = path$d.Object;

var create$6 = function create(P, D) {
  return Object$2.create(P, D);
};

var parent$s = create$6;
var create$5 = parent$s;

var create$4 = create$5;

var $$h = _export;
var getBuiltIn$2 = getBuiltIn$8;
var fails$5 = fails$m;
var $stringify = getBuiltIn$2('JSON', 'stringify');
var re = /[\uD800-\uDFFF]/g;
var low = /^[\uD800-\uDBFF]$/;
var hi = /^[\uDC00-\uDFFF]$/;

var fix = function (match, offset, string) {
  var prev = string.charAt(offset - 1);
  var next = string.charAt(offset + 1);

  if (low.test(match) && !hi.test(next) || hi.test(match) && !low.test(prev)) {
    return '\\u' + match.charCodeAt(0).toString(16);
  }

  return match;
};

var FORCED$3 = fails$5(function () {
  return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"' || $stringify('\uDEAD') !== '"\\udead"';
});

if ($stringify) {
  // `JSON.stringify` method
  // https://tc39.es/ecma262/#sec-json.stringify
  // https://github.com/tc39/proposal-well-formed-stringify
  $$h({
    target: 'JSON',
    stat: true,
    forced: FORCED$3
  }, {
    // eslint-disable-next-line no-unused-vars -- required for `.length`
    stringify: function stringify(it, replacer, space) {
      var result = $stringify.apply(null, arguments);
      return typeof result == 'string' ? result.replace(re, fix) : result;
    }
  });
}

var core = path$x; // eslint-disable-next-line es/no-json -- safe

if (!core.JSON) core.JSON = {
  stringify: JSON.stringify
}; // eslint-disable-next-line no-unused-vars -- required for `.length`

var stringify$3 = function stringify(it, replacer, space) {
  return core.JSON.stringify.apply(null, arguments);
};

var parent$r = stringify$3;
var stringify$2 = parent$r;

var stringify$1 = stringify$2;

var $$g = _export;
var global$6 = global$k;
var userAgent$2 = engineUserAgent;
var slice = [].slice;
var MSIE = /MSIE .\./.test(userAgent$2); // <- dirty ie9- check

var wrap = function (scheduler) {
  return function (handler, timeout
  /* , ...arguments */
  ) {
    var boundArgs = arguments.length > 2;
    var args = boundArgs ? slice.call(arguments, 2) : undefined;
    return scheduler(boundArgs ? function () {
      // eslint-disable-next-line no-new-func -- spec requirement
      (typeof handler == 'function' ? handler : Function(handler)).apply(this, args);
    } : handler, timeout);
  };
}; // ie9- setTimeout & setInterval additional parameters fix
// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#timers


$$g({
  global: true,
  bind: true,
  forced: MSIE
}, {
  // `setTimeout` method
  // https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-settimeout
  setTimeout: wrap(global$6.setTimeout),
  // `setInterval` method
  // https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-setinterval
  setInterval: wrap(global$6.setInterval)
});

var path$c = path$x;
var setTimeout$2 = path$c.setTimeout;

var setTimeout$1 = setTimeout$2;

var toObject$3 = toObject$e;
var toAbsoluteIndex = toAbsoluteIndex$4;
var toLength$5 = toLength$c; // `Array.prototype.fill` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.fill

var arrayFill = function fill(value
/* , start = 0, end = @length */
) {
  var O = toObject$3(this);
  var length = toLength$5(O.length);
  var argumentsLength = arguments.length;
  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
  var end = argumentsLength > 2 ? arguments[2] : undefined;
  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);

  while (endPos > index) O[index++] = value;

  return O;
};

var $$f = _export;
var fill$4 = arrayFill;
// https://tc39.es/ecma262/#sec-array.prototype.fill

$$f({
  target: 'Array',
  proto: true
}, {
  fill: fill$4
}); // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

var entryVirtual$8 = entryVirtual$l;
var fill$3 = entryVirtual$8('Array').fill;

var fill$2 = fill$3;
var ArrayPrototype$8 = Array.prototype;

var fill_1 = function (it) {
  var own = it.fill;
  return it === ArrayPrototype$8 || it instanceof Array && own === ArrayPrototype$8.fill ? fill$2 : own;
};

var parent$q = fill_1;
var fill$1 = parent$q;

var fill = fill$1;

/*! Hammer.JS - v2.0.17-rc - 2019-12-16
 * http://naver.github.io/egjs
 *
 * Forked By Naver egjs
 * Copyright (c) hammerjs
 * Licensed under the MIT license */
function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  subClass.__proto__ = superClass;
}

function _assertThisInitialized$1(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}
/**
 * @private
 * extend object.
 * means that properties in dest will be overwritten by the ones in src.
 * @param {Object} target
 * @param {...Object} objects_to_assign
 * @returns {Object} target
 */


var assign;

if (typeof Object.assign !== 'function') {
  assign = function assign(target) {
    if (target === undefined || target === null) {
      throw new TypeError('Cannot convert undefined or null to object');
    }

    var output = Object(target);

    for (var index = 1; index < arguments.length; index++) {
      var source = arguments[index];

      if (source !== undefined && source !== null) {
        for (var nextKey in source) {
          if (source.hasOwnProperty(nextKey)) {
            output[nextKey] = source[nextKey];
          }
        }
      }
    }

    return output;
  };
} else {
  assign = Object.assign;
}

var assign$1 = assign;
var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
var TEST_ELEMENT = typeof document === "undefined" ? {
  style: {}
} : document.createElement('div');
var TYPE_FUNCTION = 'function';
var round = Math.round,
    abs$1 = Math.abs;
var now = Date.now;
/**
 * @private
 * get the prefixed property
 * @param {Object} obj
 * @param {String} property
 * @returns {String|Undefined} prefixed
 */

function prefixed(obj, property) {
  var prefix;
  var prop;
  var camelProp = property[0].toUpperCase() + property.slice(1);
  var i = 0;

  while (i < VENDOR_PREFIXES.length) {
    prefix = VENDOR_PREFIXES[i];
    prop = prefix ? prefix + camelProp : property;

    if (prop in obj) {
      return prop;
    }

    i++;
  }

  return undefined;
}
/* eslint-disable no-new-func, no-nested-ternary */


var win;

if (typeof window === "undefined") {
  // window is undefined in node.js
  win = {};
} else {
  win = window;
}

var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;

function getTouchActionProps() {
  if (!NATIVE_TOUCH_ACTION) {
    return false;
  }

  var touchMap = {};
  var cssSupports = win.CSS && win.CSS.supports;
  ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function (val) {
    // If css.supports is not supported but there is native touch-action assume it supports
    // all values. This is the case for IE 10 and 11.
    return touchMap[val] = cssSupports ? win.CSS.supports('touch-action', val) : true;
  });
  return touchMap;
}

var TOUCH_ACTION_COMPUTE = 'compute';
var TOUCH_ACTION_AUTO = 'auto';
var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented

var TOUCH_ACTION_NONE = 'none';
var TOUCH_ACTION_PAN_X = 'pan-x';
var TOUCH_ACTION_PAN_Y = 'pan-y';
var TOUCH_ACTION_MAP = getTouchActionProps();
var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
var SUPPORT_TOUCH = ('ontouchstart' in win);
var SUPPORT_POINTER_EVENTS = prefixed(win, 'PointerEvent') !== undefined;
var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
var INPUT_TYPE_TOUCH = 'touch';
var INPUT_TYPE_PEN = 'pen';
var INPUT_TYPE_MOUSE = 'mouse';
var INPUT_TYPE_KINECT = 'kinect';
var COMPUTE_INTERVAL = 25;
var INPUT_START = 1;
var INPUT_MOVE = 2;
var INPUT_END = 4;
var INPUT_CANCEL = 8;
var DIRECTION_NONE = 1;
var DIRECTION_LEFT = 2;
var DIRECTION_RIGHT = 4;
var DIRECTION_UP = 8;
var DIRECTION_DOWN = 16;
var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
var PROPS_XY = ['x', 'y'];
var PROPS_CLIENT_XY = ['clientX', 'clientY'];
/**
 * @private
 * walk objects and arrays
 * @param {Object} obj
 * @param {Function} iterator
 * @param {Object} context
 */

function each(obj, iterator, context) {
  var i;

  if (!obj) {
    return;
  }

  if (obj.forEach) {
    obj.forEach(iterator, context);
  } else if (obj.length !== undefined) {
    i = 0;

    while (i < obj.length) {
      iterator.call(context, obj[i], i, obj);
      i++;
    }
  } else {
    for (i in obj) {
      obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
    }
  }
}
/**
 * @private
 * let a boolean value also be a function that must return a boolean
 * this first item in args will be used as the context
 * @param {Boolean|Function} val
 * @param {Array} [args]
 * @returns {Boolean}
 */


function boolOrFn(val, args) {
  if (typeof val === TYPE_FUNCTION) {
    return val.apply(args ? args[0] || undefined : undefined, args);
  }

  return val;
}
/**
 * @private
 * small indexOf wrapper
 * @param {String} str
 * @param {String} find
 * @returns {Boolean} found
 */


function inStr(str, find) {
  return str.indexOf(find) > -1;
}
/**
 * @private
 * when the touchActions are collected they are not a valid value, so we need to clean things up. *
 * @param {String} actions
 * @returns {*}
 */


function cleanTouchActions(actions) {
  // none
  if (inStr(actions, TOUCH_ACTION_NONE)) {
    return TOUCH_ACTION_NONE;
  }

  var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
  var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y); // if both pan-x and pan-y are set (different recognizers
  // for different directions, e.g. horizontal pan but vertical swipe?)
  // we need none (as otherwise with pan-x pan-y combined none of these
  // recognizers will work, since the browser would handle all panning

  if (hasPanX && hasPanY) {
    return TOUCH_ACTION_NONE;
  } // pan-x OR pan-y


  if (hasPanX || hasPanY) {
    return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
  } // manipulation


  if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
    return TOUCH_ACTION_MANIPULATION;
  }

  return TOUCH_ACTION_AUTO;
}
/**
 * @private
 * Touch Action
 * sets the touchAction property or uses the js alternative
 * @param {Manager} manager
 * @param {String} value
 * @constructor
 */


var TouchAction = /*#__PURE__*/function () {
  function TouchAction(manager, value) {
    this.manager = manager;
    this.set(value);
  }
  /**
   * @private
   * set the touchAction value on the element or enable the polyfill
   * @param {String} value
   */


  var _proto = TouchAction.prototype;

  _proto.set = function set(value) {
    // find out the touch-action by the event handlers
    if (value === TOUCH_ACTION_COMPUTE) {
      value = this.compute();
    }

    if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
      this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
    }

    this.actions = value.toLowerCase().trim();
  };
  /**
   * @private
   * just re-set the touchAction value
   */


  _proto.update = function update() {
    this.set(this.manager.options.touchAction);
  };
  /**
   * @private
   * compute the value for the touchAction property based on the recognizer's settings
   * @returns {String} value
   */


  _proto.compute = function compute() {
    var actions = [];
    each(this.manager.recognizers, function (recognizer) {
      if (boolOrFn(recognizer.options.enable, [recognizer])) {
        actions = actions.concat(recognizer.getTouchAction());
      }
    });
    return cleanTouchActions(actions.join(' '));
  };
  /**
   * @private
   * this method is called on each input cycle and provides the preventing of the browser behavior
   * @param {Object} input
   */


  _proto.preventDefaults = function preventDefaults(input) {
    var srcEvent = input.srcEvent;
    var direction = input.offsetDirection; // if the touch action did prevented once this session

    if (this.manager.session.prevented) {
      srcEvent.preventDefault();
      return;
    }

    var actions = this.actions;
    var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
    var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
    var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

    if (hasNone) {
      // do not prevent defaults if this is a tap gesture
      var isTapPointer = input.pointers.length === 1;
      var isTapMovement = input.distance < 2;
      var isTapTouchTime = input.deltaTime < 250;

      if (isTapPointer && isTapMovement && isTapTouchTime) {
        return;
      }
    }

    if (hasPanX && hasPanY) {
      // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
      return;
    }

    if (hasNone || hasPanY && direction & DIRECTION_HORIZONTAL || hasPanX && direction & DIRECTION_VERTICAL) {
      return this.preventSrc(srcEvent);
    }
  };
  /**
   * @private
   * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
   * @param {Object} srcEvent
   */


  _proto.preventSrc = function preventSrc(srcEvent) {
    this.manager.session.prevented = true;
    srcEvent.preventDefault();
  };

  return TouchAction;
}();
/**
 * @private
 * find if a node is in the given parent
 * @method hasParent
 * @param {HTMLElement} node
 * @param {HTMLElement} parent
 * @return {Boolean} found
 */


function hasParent(node, parent) {
  while (node) {
    if (node === parent) {
      return true;
    }

    node = node.parentNode;
  }

  return false;
}
/**
 * @private
 * get the center of all the pointers
 * @param {Array} pointers
 * @return {Object} center contains `x` and `y` properties
 */


function getCenter(pointers) {
  var pointersLength = pointers.length; // no need to loop when only one touch

  if (pointersLength === 1) {
    return {
      x: round(pointers[0].clientX),
      y: round(pointers[0].clientY)
    };
  }

  var x = 0;
  var y = 0;
  var i = 0;

  while (i < pointersLength) {
    x += pointers[i].clientX;
    y += pointers[i].clientY;
    i++;
  }

  return {
    x: round(x / pointersLength),
    y: round(y / pointersLength)
  };
}
/**
 * @private
 * create a simple clone from the input used for storage of firstInput and firstMultiple
 * @param {Object} input
 * @returns {Object} clonedInputData
 */


function simpleCloneInputData(input) {
  // make a simple copy of the pointers because we will get a reference if we don't
  // we only need clientXY for the calculations
  var pointers = [];
  var i = 0;

  while (i < input.pointers.length) {
    pointers[i] = {
      clientX: round(input.pointers[i].clientX),
      clientY: round(input.pointers[i].clientY)
    };
    i++;
  }

  return {
    timeStamp: now(),
    pointers: pointers,
    center: getCenter(pointers),
    deltaX: input.deltaX,
    deltaY: input.deltaY
  };
}
/**
 * @private
 * calculate the absolute distance between two points
 * @param {Object} p1 {x, y}
 * @param {Object} p2 {x, y}
 * @param {Array} [props] containing x and y keys
 * @return {Number} distance
 */


function getDistance(p1, p2, props) {
  if (!props) {
    props = PROPS_XY;
  }

  var x = p2[props[0]] - p1[props[0]];
  var y = p2[props[1]] - p1[props[1]];
  return Math.sqrt(x * x + y * y);
}
/**
 * @private
 * calculate the angle between two coordinates
 * @param {Object} p1
 * @param {Object} p2
 * @param {Array} [props] containing x and y keys
 * @return {Number} angle
 */


function getAngle(p1, p2, props) {
  if (!props) {
    props = PROPS_XY;
  }

  var x = p2[props[0]] - p1[props[0]];
  var y = p2[props[1]] - p1[props[1]];
  return Math.atan2(y, x) * 180 / Math.PI;
}
/**
 * @private
 * get the direction between two points
 * @param {Number} x
 * @param {Number} y
 * @return {Number} direction
 */


function getDirection(x, y) {
  if (x === y) {
    return DIRECTION_NONE;
  }

  if (abs$1(x) >= abs$1(y)) {
    return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
  }

  return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
}

function computeDeltaXY(session, input) {
  var center = input.center; // let { offsetDelta:offset = {}, prevDelta = {}, prevInput = {} } = session;
  // jscs throwing error on defalut destructured values and without defaults tests fail

  var offset = session.offsetDelta || {};
  var prevDelta = session.prevDelta || {};
  var prevInput = session.prevInput || {};

  if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
    prevDelta = session.prevDelta = {
      x: prevInput.deltaX || 0,
      y: prevInput.deltaY || 0
    };
    offset = session.offsetDelta = {
      x: center.x,
      y: center.y
    };
  }

  input.deltaX = prevDelta.x + (center.x - offset.x);
  input.deltaY = prevDelta.y + (center.y - offset.y);
}
/**
 * @private
 * calculate the velocity between two points. unit is in px per ms.
 * @param {Number} deltaTime
 * @param {Number} x
 * @param {Number} y
 * @return {Object} velocity `x` and `y`
 */


function getVelocity(deltaTime, x, y) {
  return {
    x: x / deltaTime || 0,
    y: y / deltaTime || 0
  };
}
/**
 * @private
 * calculate the scale factor between two pointersets
 * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
 * @param {Array} start array of pointers
 * @param {Array} end array of pointers
 * @return {Number} scale
 */


function getScale(start, end) {
  return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
}
/**
 * @private
 * calculate the rotation degrees between two pointersets
 * @param {Array} start array of pointers
 * @param {Array} end array of pointers
 * @return {Number} rotation
 */


function getRotation(start, end) {
  return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
}
/**
 * @private
 * velocity is calculated every x ms
 * @param {Object} session
 * @param {Object} input
 */


function computeIntervalInputData(session, input) {
  var last = session.lastInterval || input;
  var deltaTime = input.timeStamp - last.timeStamp;
  var velocity;
  var velocityX;
  var velocityY;
  var direction;

  if (input.eventType !== INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
    var deltaX = input.deltaX - last.deltaX;
    var deltaY = input.deltaY - last.deltaY;
    var v = getVelocity(deltaTime, deltaX, deltaY);
    velocityX = v.x;
    velocityY = v.y;
    velocity = abs$1(v.x) > abs$1(v.y) ? v.x : v.y;
    direction = getDirection(deltaX, deltaY);
    session.lastInterval = input;
  } else {
    // use latest velocity info if it doesn't overtake a minimum period
    velocity = last.velocity;
    velocityX = last.velocityX;
    velocityY = last.velocityY;
    direction = last.direction;
  }

  input.velocity = velocity;
  input.velocityX = velocityX;
  input.velocityY = velocityY;
  input.direction = direction;
}
/**
* @private
 * extend the data with some usable properties like scale, rotate, velocity etc
 * @param {Object} manager
 * @param {Object} input
 */


function computeInputData(manager, input) {
  var session = manager.session;
  var pointers = input.pointers;
  var pointersLength = pointers.length; // store the first input to calculate the distance and direction

  if (!session.firstInput) {
    session.firstInput = simpleCloneInputData(input);
  } // to compute scale and rotation we need to store the multiple touches


  if (pointersLength > 1 && !session.firstMultiple) {
    session.firstMultiple = simpleCloneInputData(input);
  } else if (pointersLength === 1) {
    session.firstMultiple = false;
  }

  var firstInput = session.firstInput,
      firstMultiple = session.firstMultiple;
  var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
  var center = input.center = getCenter(pointers);
  input.timeStamp = now();
  input.deltaTime = input.timeStamp - firstInput.timeStamp;
  input.angle = getAngle(offsetCenter, center);
  input.distance = getDistance(offsetCenter, center);
  computeDeltaXY(session, input);
  input.offsetDirection = getDirection(input.deltaX, input.deltaY);
  var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
  input.overallVelocityX = overallVelocity.x;
  input.overallVelocityY = overallVelocity.y;
  input.overallVelocity = abs$1(overallVelocity.x) > abs$1(overallVelocity.y) ? overallVelocity.x : overallVelocity.y;
  input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
  input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
  input.maxPointers = !session.prevInput ? input.pointers.length : input.pointers.length > session.prevInput.maxPointers ? input.pointers.length : session.prevInput.maxPointers;
  computeIntervalInputData(session, input); // find the correct target

  var target = manager.element;
  var srcEvent = input.srcEvent;
  var srcEventTarget;

  if (srcEvent.composedPath) {
    srcEventTarget = srcEvent.composedPath()[0];
  } else if (srcEvent.path) {
    srcEventTarget = srcEvent.path[0];
  } else {
    srcEventTarget = srcEvent.target;
  }

  if (hasParent(srcEventTarget, target)) {
    target = srcEventTarget;
  }

  input.target = target;
}
/**
 * @private
 * handle input events
 * @param {Manager} manager
 * @param {String} eventType
 * @param {Object} input
 */


function inputHandler(manager, eventType, input) {
  var pointersLen = input.pointers.length;
  var changedPointersLen = input.changedPointers.length;
  var isFirst = eventType & INPUT_START && pointersLen - changedPointersLen === 0;
  var isFinal = eventType & (INPUT_END | INPUT_CANCEL) && pointersLen - changedPointersLen === 0;
  input.isFirst = !!isFirst;
  input.isFinal = !!isFinal;

  if (isFirst) {
    manager.session = {};
  } // source event is the normalized value of the domEvents
  // like 'touchstart, mouseup, pointerdown'


  input.eventType = eventType; // compute scale, rotation etc

  computeInputData(manager, input); // emit secret event

  manager.emit('hammer.input', input);
  manager.recognize(input);
  manager.session.prevInput = input;
}
/**
 * @private
 * split string on whitespace
 * @param {String} str
 * @returns {Array} words
 */


function splitStr(str) {
  return str.trim().split(/\s+/g);
}
/**
 * @private
 * addEventListener with multiple events at once
 * @param {EventTarget} target
 * @param {String} types
 * @param {Function} handler
 */


function addEventListeners(target, types, handler) {
  each(splitStr(types), function (type) {
    target.addEventListener(type, handler, false);
  });
}
/**
 * @private
 * removeEventListener with multiple events at once
 * @param {EventTarget} target
 * @param {String} types
 * @param {Function} handler
 */


function removeEventListeners(target, types, handler) {
  each(splitStr(types), function (type) {
    target.removeEventListener(type, handler, false);
  });
}
/**
 * @private
 * get the window object of an element
 * @param {HTMLElement} element
 * @returns {DocumentView|Window}
 */


function getWindowForElement(element) {
  var doc = element.ownerDocument || element;
  return doc.defaultView || doc.parentWindow || window;
}
/**
 * @private
 * create new input type manager
 * @param {Manager} manager
 * @param {Function} callback
 * @returns {Input}
 * @constructor
 */


var Input = /*#__PURE__*/function () {
  function Input(manager, callback) {
    var self = this;
    this.manager = manager;
    this.callback = callback;
    this.element = manager.element;
    this.target = manager.options.inputTarget; // smaller wrapper around the handler, for the scope and the enabled state of the manager,
    // so when disabled the input events are completely bypassed.

    this.domHandler = function (ev) {
      if (boolOrFn(manager.options.enable, [manager])) {
        self.handler(ev);
      }
    };

    this.init();
  }
  /**
   * @private
   * should handle the inputEvent data and trigger the callback
   * @virtual
   */


  var _proto = Input.prototype;

  _proto.handler = function handler() {};
  /**
   * @private
   * bind the events
   */


  _proto.init = function init() {
    this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
    this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
    this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
  };
  /**
   * @private
   * unbind the events
   */


  _proto.destroy = function destroy() {
    this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
    this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
    this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
  };

  return Input;
}();
/**
 * @private
 * find if a array contains the object using indexOf or a simple polyFill
 * @param {Array} src
 * @param {String} find
 * @param {String} [findByKey]
 * @return {Boolean|Number} false when not found, or the index
 */


function inArray(src, find, findByKey) {
  if (src.indexOf && !findByKey) {
    return src.indexOf(find);
  } else {
    var i = 0;

    while (i < src.length) {
      if (findByKey && src[i][findByKey] == find || !findByKey && src[i] === find) {
        // do not use === here, test fails
        return i;
      }

      i++;
    }

    return -1;
  }
}

var POINTER_INPUT_MAP = {
  pointerdown: INPUT_START,
  pointermove: INPUT_MOVE,
  pointerup: INPUT_END,
  pointercancel: INPUT_CANCEL,
  pointerout: INPUT_CANCEL
}; // in IE10 the pointer types is defined as an enum

var IE10_POINTER_TYPE_ENUM = {
  2: INPUT_TYPE_TOUCH,
  3: INPUT_TYPE_PEN,
  4: INPUT_TYPE_MOUSE,
  5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816

};
var POINTER_ELEMENT_EVENTS = 'pointerdown';
var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel'; // IE10 has prefixed support, and case-sensitive

if (win.MSPointerEvent && !win.PointerEvent) {
  POINTER_ELEMENT_EVENTS = 'MSPointerDown';
  POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
}
/**
 * @private
 * Pointer events input
 * @constructor
 * @extends Input
 */


var PointerEventInput = /*#__PURE__*/function (_Input) {
  _inheritsLoose(PointerEventInput, _Input);

  function PointerEventInput() {
    var _this;

    var proto = PointerEventInput.prototype;
    proto.evEl = POINTER_ELEMENT_EVENTS;
    proto.evWin = POINTER_WINDOW_EVENTS;
    _this = _Input.apply(this, arguments) || this;
    _this.store = _this.manager.session.pointerEvents = [];
    return _this;
  }
  /**
   * @private
   * handle mouse events
   * @param {Object} ev
   */


  var _proto = PointerEventInput.prototype;

  _proto.handler = function handler(ev) {
    var store = this.store;
    var removePointer = false;
    var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
    var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
    var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
    var isTouch = pointerType === INPUT_TYPE_TOUCH; // get index of the event in the store

    var storeIndex = inArray(store, ev.pointerId, 'pointerId'); // start and mouse must be down

    if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
      if (storeIndex < 0) {
        store.push(ev);
        storeIndex = store.length - 1;
      }
    } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
      removePointer = true;
    } // it not found, so the pointer hasn't been down (so it's probably a hover)


    if (storeIndex < 0) {
      return;
    } // update the event in the store


    store[storeIndex] = ev;
    this.callback(this.manager, eventType, {
      pointers: store,
      changedPointers: [ev],
      pointerType: pointerType,
      srcEvent: ev
    });

    if (removePointer) {
      // remove from the store
      store.splice(storeIndex, 1);
    }
  };

  return PointerEventInput;
}(Input);
/**
 * @private
 * convert array-like objects to real arrays
 * @param {Object} obj
 * @returns {Array}
 */


function toArray(obj) {
  return Array.prototype.slice.call(obj, 0);
}
/**
 * @private
 * unique array with objects based on a key (like 'id') or just by the array's value
 * @param {Array} src [{id:1},{id:2},{id:1}]
 * @param {String} [key]
 * @param {Boolean} [sort=False]
 * @returns {Array} [{id:1},{id:2}]
 */


function uniqueArray(src, key, sort) {
  var results = [];
  var values = [];
  var i = 0;

  while (i < src.length) {
    var val = key ? src[i][key] : src[i];

    if (inArray(values, val) < 0) {
      results.push(src[i]);
    }

    values[i] = val;
    i++;
  }

  if (sort) {
    if (!key) {
      results = results.sort();
    } else {
      results = results.sort(function (a, b) {
        return a[key] > b[key];
      });
    }
  }

  return results;
}

var TOUCH_INPUT_MAP = {
  touchstart: INPUT_START,
  touchmove: INPUT_MOVE,
  touchend: INPUT_END,
  touchcancel: INPUT_CANCEL
};
var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';
/**
 * @private
 * Multi-user touch events input
 * @constructor
 * @extends Input
 */

var TouchInput = /*#__PURE__*/function (_Input) {
  _inheritsLoose(TouchInput, _Input);

  function TouchInput() {
    var _this;

    TouchInput.prototype.evTarget = TOUCH_TARGET_EVENTS;
    _this = _Input.apply(this, arguments) || this;
    _this.targetIds = {}; // this.evTarget = TOUCH_TARGET_EVENTS;

    return _this;
  }

  var _proto = TouchInput.prototype;

  _proto.handler = function handler(ev) {
    var type = TOUCH_INPUT_MAP[ev.type];
    var touches = getTouches.call(this, ev, type);

    if (!touches) {
      return;
    }

    this.callback(this.manager, type, {
      pointers: touches[0],
      changedPointers: touches[1],
      pointerType: INPUT_TYPE_TOUCH,
      srcEvent: ev
    });
  };

  return TouchInput;
}(Input);

function getTouches(ev, type) {
  var allTouches = toArray(ev.touches);
  var targetIds = this.targetIds; // when there is only one touch, the process can be simplified

  if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
    targetIds[allTouches[0].identifier] = true;
    return [allTouches, allTouches];
  }

  var i;
  var targetTouches;
  var changedTouches = toArray(ev.changedTouches);
  var changedTargetTouches = [];
  var target = this.target; // get target touches from touches

  targetTouches = allTouches.filter(function (touch) {
    return hasParent(touch.target, target);
  }); // collect touches

  if (type === INPUT_START) {
    i = 0;

    while (i < targetTouches.length) {
      targetIds[targetTouches[i].identifier] = true;
      i++;
    }
  } // filter changed touches to only contain touches that exist in the collected target ids


  i = 0;

  while (i < changedTouches.length) {
    if (targetIds[changedTouches[i].identifier]) {
      changedTargetTouches.push(changedTouches[i]);
    } // cleanup removed touches


    if (type & (INPUT_END | INPUT_CANCEL)) {
      delete targetIds[changedTouches[i].identifier];
    }

    i++;
  }

  if (!changedTargetTouches.length) {
    return;
  }

  return [// merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
  uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true), changedTargetTouches];
}

var MOUSE_INPUT_MAP = {
  mousedown: INPUT_START,
  mousemove: INPUT_MOVE,
  mouseup: INPUT_END
};
var MOUSE_ELEMENT_EVENTS = 'mousedown';
var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';
/**
 * @private
 * Mouse events input
 * @constructor
 * @extends Input
 */

var MouseInput = /*#__PURE__*/function (_Input) {
  _inheritsLoose(MouseInput, _Input);

  function MouseInput() {
    var _this;

    var proto = MouseInput.prototype;
    proto.evEl = MOUSE_ELEMENT_EVENTS;
    proto.evWin = MOUSE_WINDOW_EVENTS;
    _this = _Input.apply(this, arguments) || this;
    _this.pressed = false; // mousedown state

    return _this;
  }
  /**
   * @private
   * handle mouse events
   * @param {Object} ev
   */


  var _proto = MouseInput.prototype;

  _proto.handler = function handler(ev) {
    var eventType = MOUSE_INPUT_MAP[ev.type]; // on start we want to have the left mouse button down

    if (eventType & INPUT_START && ev.button === 0) {
      this.pressed = true;
    }

    if (eventType & INPUT_MOVE && ev.which !== 1) {
      eventType = INPUT_END;
    } // mouse must be down


    if (!this.pressed) {
      return;
    }

    if (eventType & INPUT_END) {
      this.pressed = false;
    }

    this.callback(this.manager, eventType, {
      pointers: [ev],
      changedPointers: [ev],
      pointerType: INPUT_TYPE_MOUSE,
      srcEvent: ev
    });
  };

  return MouseInput;
}(Input);
/**
 * @private
 * Combined touch and mouse input
 *
 * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
 * This because touch devices also emit mouse events while doing a touch.
 *
 * @constructor
 * @extends Input
 */


var DEDUP_TIMEOUT = 2500;
var DEDUP_DISTANCE = 25;

function setLastTouch(eventData) {
  var _eventData$changedPoi = eventData.changedPointers,
      touch = _eventData$changedPoi[0];

  if (touch.identifier === this.primaryTouch) {
    var lastTouch = {
      x: touch.clientX,
      y: touch.clientY
    };
    var lts = this.lastTouches;
    this.lastTouches.push(lastTouch);

    var removeLastTouch = function removeLastTouch() {
      var i = lts.indexOf(lastTouch);

      if (i > -1) {
        lts.splice(i, 1);
      }
    };

    setTimeout(removeLastTouch, DEDUP_TIMEOUT);
  }
}

function recordTouches(eventType, eventData) {
  if (eventType & INPUT_START) {
    this.primaryTouch = eventData.changedPointers[0].identifier;
    setLastTouch.call(this, eventData);
  } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
    setLastTouch.call(this, eventData);
  }
}

function isSyntheticEvent(eventData) {
  var x = eventData.srcEvent.clientX;
  var y = eventData.srcEvent.clientY;

  for (var i = 0; i < this.lastTouches.length; i++) {
    var t = this.lastTouches[i];
    var dx = Math.abs(x - t.x);
    var dy = Math.abs(y - t.y);

    if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
      return true;
    }
  }

  return false;
}

var TouchMouseInput = /*#__PURE__*/function () {
  var TouchMouseInput = /*#__PURE__*/function (_Input) {
    _inheritsLoose(TouchMouseInput, _Input);

    function TouchMouseInput(_manager, callback) {
      var _this;

      _this = _Input.call(this, _manager, callback) || this;

      _this.handler = function (manager, inputEvent, inputData) {
        var isTouch = inputData.pointerType === INPUT_TYPE_TOUCH;
        var isMouse = inputData.pointerType === INPUT_TYPE_MOUSE;

        if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
          return;
        } // when we're in a touch event, record touches to  de-dupe synthetic mouse event


        if (isTouch) {
          recordTouches.call(_assertThisInitialized$1(_assertThisInitialized$1(_this)), inputEvent, inputData);
        } else if (isMouse && isSyntheticEvent.call(_assertThisInitialized$1(_assertThisInitialized$1(_this)), inputData)) {
          return;
        }

        _this.callback(manager, inputEvent, inputData);
      };

      _this.touch = new TouchInput(_this.manager, _this.handler);
      _this.mouse = new MouseInput(_this.manager, _this.handler);
      _this.primaryTouch = null;
      _this.lastTouches = [];
      return _this;
    }
    /**
     * @private
     * handle mouse and touch events
     * @param {Hammer} manager
     * @param {String} inputEvent
     * @param {Object} inputData
     */


    var _proto = TouchMouseInput.prototype;
    /**
     * @private
     * remove the event listeners
     */

    _proto.destroy = function destroy() {
      this.touch.destroy();
      this.mouse.destroy();
    };

    return TouchMouseInput;
  }(Input);

  return TouchMouseInput;
}();
/**
 * @private
 * create new input type manager
 * called by the Manager constructor
 * @param {Hammer} manager
 * @returns {Input}
 */


function createInputInstance(manager) {
  var Type; // let inputClass = manager.options.inputClass;

  var inputClass = manager.options.inputClass;

  if (inputClass) {
    Type = inputClass;
  } else if (SUPPORT_POINTER_EVENTS) {
    Type = PointerEventInput;
  } else if (SUPPORT_ONLY_TOUCH) {
    Type = TouchInput;
  } else if (!SUPPORT_TOUCH) {
    Type = MouseInput;
  } else {
    Type = TouchMouseInput;
  }

  return new Type(manager, inputHandler);
}
/**
 * @private
 * if the argument is an array, we want to execute the fn on each entry
 * if it aint an array we don't want to do a thing.
 * this is used by all the methods that accept a single and array argument.
 * @param {*|Array} arg
 * @param {String} fn
 * @param {Object} [context]
 * @returns {Boolean}
 */


function invokeArrayArg(arg, fn, context) {
  if (Array.isArray(arg)) {
    each(arg, context[fn], context);
    return true;
  }

  return false;
}

var STATE_POSSIBLE = 1;
var STATE_BEGAN = 2;
var STATE_CHANGED = 4;
var STATE_ENDED = 8;
var STATE_RECOGNIZED = STATE_ENDED;
var STATE_CANCELLED = 16;
var STATE_FAILED = 32;
/**
 * @private
 * get a unique id
 * @returns {number} uniqueId
 */

var _uniqueId = 1;

function uniqueId() {
  return _uniqueId++;
}
/**
 * @private
 * get a recognizer by name if it is bound to a manager
 * @param {Recognizer|String} otherRecognizer
 * @param {Recognizer} recognizer
 * @returns {Recognizer}
 */


function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
  var manager = recognizer.manager;

  if (manager) {
    return manager.get(otherRecognizer);
  }

  return otherRecognizer;
}
/**
 * @private
 * get a usable string, used as event postfix
 * @param {constant} state
 * @returns {String} state
 */


function stateStr(state) {
  if (state & STATE_CANCELLED) {
    return 'cancel';
  } else if (state & STATE_ENDED) {
    return 'end';
  } else if (state & STATE_CHANGED) {
    return 'move';
  } else if (state & STATE_BEGAN) {
    return 'start';
  }

  return '';
}
/**
 * @private
 * Recognizer flow explained; *
 * All recognizers have the initial state of POSSIBLE when a input session starts.
 * The definition of a input session is from the first input until the last input, with all it's movement in it. *
 * Example session for mouse-input: mousedown -> mousemove -> mouseup
 *
 * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
 * which determines with state it should be.
 *
 * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
 * POSSIBLE to give it another change on the next cycle.
 *
 *               Possible
 *                  |
 *            +-----+---------------+
 *            |                     |
 *      +-----+-----+               |
 *      |           |               |
 *   Failed      Cancelled          |
 *                          +-------+------+
 *                          |              |
 *                      Recognized       Began
 *                                         |
 *                                      Changed
 *                                         |
 *                                  Ended/Recognized
 */

/**
 * @private
 * Recognizer
 * Every recognizer needs to extend from this class.
 * @constructor
 * @param {Object} options
 */


var Recognizer = /*#__PURE__*/function () {
  function Recognizer(options) {
    if (options === void 0) {
      options = {};
    }

    this.options = _extends({
      enable: true
    }, options);
    this.id = uniqueId();
    this.manager = null; // default is enable true

    this.state = STATE_POSSIBLE;
    this.simultaneous = {};
    this.requireFail = [];
  }
  /**
   * @private
   * set options
   * @param {Object} options
   * @return {Recognizer}
   */


  var _proto = Recognizer.prototype;

  _proto.set = function set(options) {
    assign$1(this.options, options); // also update the touchAction, in case something changed about the directions/enabled state

    this.manager && this.manager.touchAction.update();
    return this;
  };
  /**
   * @private
   * recognize simultaneous with an other recognizer.
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */


  _proto.recognizeWith = function recognizeWith(otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
      return this;
    }

    var simultaneous = this.simultaneous;
    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

    if (!simultaneous[otherRecognizer.id]) {
      simultaneous[otherRecognizer.id] = otherRecognizer;
      otherRecognizer.recognizeWith(this);
    }

    return this;
  };
  /**
   * @private
   * drop the simultaneous link. it doesnt remove the link on the other recognizer.
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */


  _proto.dropRecognizeWith = function dropRecognizeWith(otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
      return this;
    }

    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
    delete this.simultaneous[otherRecognizer.id];
    return this;
  };
  /**
   * @private
   * recognizer can only run when an other is failing
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */


  _proto.requireFailure = function requireFailure(otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
      return this;
    }

    var requireFail = this.requireFail;
    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

    if (inArray(requireFail, otherRecognizer) === -1) {
      requireFail.push(otherRecognizer);
      otherRecognizer.requireFailure(this);
    }

    return this;
  };
  /**
   * @private
   * drop the requireFailure link. it does not remove the link on the other recognizer.
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */


  _proto.dropRequireFailure = function dropRequireFailure(otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
      return this;
    }

    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
    var index = inArray(this.requireFail, otherRecognizer);

    if (index > -1) {
      this.requireFail.splice(index, 1);
    }

    return this;
  };
  /**
   * @private
   * has require failures boolean
   * @returns {boolean}
   */


  _proto.hasRequireFailures = function hasRequireFailures() {
    return this.requireFail.length > 0;
  };
  /**
   * @private
   * if the recognizer can recognize simultaneous with an other recognizer
   * @param {Recognizer} otherRecognizer
   * @returns {Boolean}
   */


  _proto.canRecognizeWith = function canRecognizeWith(otherRecognizer) {
    return !!this.simultaneous[otherRecognizer.id];
  };
  /**
   * @private
   * You should use `tryEmit` instead of `emit` directly to check
   * that all the needed recognizers has failed before emitting.
   * @param {Object} input
   */


  _proto.emit = function emit(input) {
    var self = this;
    var state = this.state;

    function emit(event) {
      self.manager.emit(event, input);
    } // 'panstart' and 'panmove'


    if (state < STATE_ENDED) {
      emit(self.options.event + stateStr(state));
    }

    emit(self.options.event); // simple 'eventName' events

    if (input.additionalEvent) {
      // additional event(panleft, panright, pinchin, pinchout...)
      emit(input.additionalEvent);
    } // panend and pancancel


    if (state >= STATE_ENDED) {
      emit(self.options.event + stateStr(state));
    }
  };
  /**
   * @private
   * Check that all the require failure recognizers has failed,
   * if true, it emits a gesture event,
   * otherwise, setup the state to FAILED.
   * @param {Object} input
   */


  _proto.tryEmit = function tryEmit(input) {
    if (this.canEmit()) {
      return this.emit(input);
    } // it's failing anyway


    this.state = STATE_FAILED;
  };
  /**
   * @private
   * can we emit?
   * @returns {boolean}
   */


  _proto.canEmit = function canEmit() {
    var i = 0;

    while (i < this.requireFail.length) {
      if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
        return false;
      }

      i++;
    }

    return true;
  };
  /**
   * @private
   * update the recognizer
   * @param {Object} inputData
   */


  _proto.recognize = function recognize(inputData) {
    // make a new copy of the inputData
    // so we can change the inputData without messing up the other recognizers
    var inputDataClone = assign$1({}, inputData); // is is enabled and allow recognizing?

    if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
      this.reset();
      this.state = STATE_FAILED;
      return;
    } // reset when we've reached the end


    if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
      this.state = STATE_POSSIBLE;
    }

    this.state = this.process(inputDataClone); // the recognizer has recognized a gesture
    // so trigger an event

    if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
      this.tryEmit(inputDataClone);
    }
  };
  /**
   * @private
   * return the state of the recognizer
   * the actual recognizing happens in this method
   * @virtual
   * @param {Object} inputData
   * @returns {constant} STATE
   */

  /* jshint ignore:start */


  _proto.process = function process(inputData) {};
  /* jshint ignore:end */

  /**
   * @private
   * return the preferred touch-action
   * @virtual
   * @returns {Array}
   */


  _proto.getTouchAction = function getTouchAction() {};
  /**
   * @private
   * called when the gesture isn't allowed to recognize
   * like when another is being recognized or it is disabled
   * @virtual
   */


  _proto.reset = function reset() {};

  return Recognizer;
}();
/**
 * @private
 * A tap is recognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
 * between the given interval and position. The delay option can be used to recognize multi-taps without firing
 * a single tap.
 *
 * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
 * multi-taps being recognized.
 * @constructor
 * @extends Recognizer
 */


var TapRecognizer = /*#__PURE__*/function (_Recognizer) {
  _inheritsLoose(TapRecognizer, _Recognizer);

  function TapRecognizer(options) {
    var _this;

    if (options === void 0) {
      options = {};
    }

    _this = _Recognizer.call(this, _extends({
      event: 'tap',
      pointers: 1,
      taps: 1,
      interval: 300,
      // max time between the multi-tap taps
      time: 250,
      // max time of the pointer to be down (like finger on the screen)
      threshold: 9,
      // a minimal movement is ok, but keep it low
      posThreshold: 10
    }, options)) || this; // previous time and center,
    // used for tap counting

    _this.pTime = false;
    _this.pCenter = false;
    _this._timer = null;
    _this._input = null;
    _this.count = 0;
    return _this;
  }

  var _proto = TapRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return [TOUCH_ACTION_MANIPULATION];
  };

  _proto.process = function process(input) {
    var _this2 = this;

    var options = this.options;
    var validPointers = input.pointers.length === options.pointers;
    var validMovement = input.distance < options.threshold;
    var validTouchTime = input.deltaTime < options.time;
    this.reset();

    if (input.eventType & INPUT_START && this.count === 0) {
      return this.failTimeout();
    } // we only allow little movement
    // and we've reached an end event, so a tap is possible


    if (validMovement && validTouchTime && validPointers) {
      if (input.eventType !== INPUT_END) {
        return this.failTimeout();
      }

      var validInterval = this.pTime ? input.timeStamp - this.pTime < options.interval : true;
      var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;
      this.pTime = input.timeStamp;
      this.pCenter = input.center;

      if (!validMultiTap || !validInterval) {
        this.count = 1;
      } else {
        this.count += 1;
      }

      this._input = input; // if tap count matches we have recognized it,
      // else it has began recognizing...

      var tapCount = this.count % options.taps;

      if (tapCount === 0) {
        // no failing requirements, immediately trigger the tap event
        // or wait as long as the multitap interval to trigger
        if (!this.hasRequireFailures()) {
          return STATE_RECOGNIZED;
        } else {
          this._timer = setTimeout(function () {
            _this2.state = STATE_RECOGNIZED;

            _this2.tryEmit();
          }, options.interval);
          return STATE_BEGAN;
        }
      }
    }

    return STATE_FAILED;
  };

  _proto.failTimeout = function failTimeout() {
    var _this3 = this;

    this._timer = setTimeout(function () {
      _this3.state = STATE_FAILED;
    }, this.options.interval);
    return STATE_FAILED;
  };

  _proto.reset = function reset() {
    clearTimeout(this._timer);
  };

  _proto.emit = function emit() {
    if (this.state === STATE_RECOGNIZED) {
      this._input.tapCount = this.count;
      this.manager.emit(this.options.event, this._input);
    }
  };

  return TapRecognizer;
}(Recognizer);
/**
 * @private
 * This recognizer is just used as a base for the simple attribute recognizers.
 * @constructor
 * @extends Recognizer
 */


var AttrRecognizer = /*#__PURE__*/function (_Recognizer) {
  _inheritsLoose(AttrRecognizer, _Recognizer);

  function AttrRecognizer(options) {
    if (options === void 0) {
      options = {};
    }

    return _Recognizer.call(this, _extends({
      pointers: 1
    }, options)) || this;
  }
  /**
   * @private
   * Used to check if it the recognizer receives valid input, like input.distance > 10.
   * @memberof AttrRecognizer
   * @param {Object} input
   * @returns {Boolean} recognized
   */


  var _proto = AttrRecognizer.prototype;

  _proto.attrTest = function attrTest(input) {
    var optionPointers = this.options.pointers;
    return optionPointers === 0 || input.pointers.length === optionPointers;
  };
  /**
   * @private
   * Process the input and return the state for the recognizer
   * @memberof AttrRecognizer
   * @param {Object} input
   * @returns {*} State
   */


  _proto.process = function process(input) {
    var state = this.state;
    var eventType = input.eventType;
    var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
    var isValid = this.attrTest(input); // on cancel input and we've recognized before, return STATE_CANCELLED

    if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
      return state | STATE_CANCELLED;
    } else if (isRecognized || isValid) {
      if (eventType & INPUT_END) {
        return state | STATE_ENDED;
      } else if (!(state & STATE_BEGAN)) {
        return STATE_BEGAN;
      }

      return state | STATE_CHANGED;
    }

    return STATE_FAILED;
  };

  return AttrRecognizer;
}(Recognizer);
/**
 * @private
 * direction cons to string
 * @param {constant} direction
 * @returns {String}
 */


function directionStr(direction) {
  if (direction === DIRECTION_DOWN) {
    return 'down';
  } else if (direction === DIRECTION_UP) {
    return 'up';
  } else if (direction === DIRECTION_LEFT) {
    return 'left';
  } else if (direction === DIRECTION_RIGHT) {
    return 'right';
  }

  return '';
}
/**
 * @private
 * Pan
 * Recognized when the pointer is down and moved in the allowed direction.
 * @constructor
 * @extends AttrRecognizer
 */


var PanRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
  _inheritsLoose(PanRecognizer, _AttrRecognizer);

  function PanRecognizer(options) {
    var _this;

    if (options === void 0) {
      options = {};
    }

    _this = _AttrRecognizer.call(this, _extends({
      event: 'pan',
      threshold: 10,
      pointers: 1,
      direction: DIRECTION_ALL
    }, options)) || this;
    _this.pX = null;
    _this.pY = null;
    return _this;
  }

  var _proto = PanRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    var direction = this.options.direction;
    var actions = [];

    if (direction & DIRECTION_HORIZONTAL) {
      actions.push(TOUCH_ACTION_PAN_Y);
    }

    if (direction & DIRECTION_VERTICAL) {
      actions.push(TOUCH_ACTION_PAN_X);
    }

    return actions;
  };

  _proto.directionTest = function directionTest(input) {
    var options = this.options;
    var hasMoved = true;
    var distance = input.distance;
    var direction = input.direction;
    var x = input.deltaX;
    var y = input.deltaY; // lock to axis?

    if (!(direction & options.direction)) {
      if (options.direction & DIRECTION_HORIZONTAL) {
        direction = x === 0 ? DIRECTION_NONE : x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
        hasMoved = x !== this.pX;
        distance = Math.abs(input.deltaX);
      } else {
        direction = y === 0 ? DIRECTION_NONE : y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
        hasMoved = y !== this.pY;
        distance = Math.abs(input.deltaY);
      }
    }

    input.direction = direction;
    return hasMoved && distance > options.threshold && direction & options.direction;
  };

  _proto.attrTest = function attrTest(input) {
    return AttrRecognizer.prototype.attrTest.call(this, input) && ( // replace with a super call
    this.state & STATE_BEGAN || !(this.state & STATE_BEGAN) && this.directionTest(input));
  };

  _proto.emit = function emit(input) {
    this.pX = input.deltaX;
    this.pY = input.deltaY;
    var direction = directionStr(input.direction);

    if (direction) {
      input.additionalEvent = this.options.event + direction;
    }

    _AttrRecognizer.prototype.emit.call(this, input);
  };

  return PanRecognizer;
}(AttrRecognizer);
/**
 * @private
 * Swipe
 * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
 * @constructor
 * @extends AttrRecognizer
 */


var SwipeRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
  _inheritsLoose(SwipeRecognizer, _AttrRecognizer);

  function SwipeRecognizer(options) {
    if (options === void 0) {
      options = {};
    }

    return _AttrRecognizer.call(this, _extends({
      event: 'swipe',
      threshold: 10,
      velocity: 0.3,
      direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
      pointers: 1
    }, options)) || this;
  }

  var _proto = SwipeRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return PanRecognizer.prototype.getTouchAction.call(this);
  };

  _proto.attrTest = function attrTest(input) {
    var direction = this.options.direction;
    var velocity;

    if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
      velocity = input.overallVelocity;
    } else if (direction & DIRECTION_HORIZONTAL) {
      velocity = input.overallVelocityX;
    } else if (direction & DIRECTION_VERTICAL) {
      velocity = input.overallVelocityY;
    }

    return _AttrRecognizer.prototype.attrTest.call(this, input) && direction & input.offsetDirection && input.distance > this.options.threshold && input.maxPointers === this.options.pointers && abs$1(velocity) > this.options.velocity && input.eventType & INPUT_END;
  };

  _proto.emit = function emit(input) {
    var direction = directionStr(input.offsetDirection);

    if (direction) {
      this.manager.emit(this.options.event + direction, input);
    }

    this.manager.emit(this.options.event, input);
  };

  return SwipeRecognizer;
}(AttrRecognizer);
/**
 * @private
 * Pinch
 * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
 * @constructor
 * @extends AttrRecognizer
 */


var PinchRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
  _inheritsLoose(PinchRecognizer, _AttrRecognizer);

  function PinchRecognizer(options) {
    if (options === void 0) {
      options = {};
    }

    return _AttrRecognizer.call(this, _extends({
      event: 'pinch',
      threshold: 0,
      pointers: 2
    }, options)) || this;
  }

  var _proto = PinchRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return [TOUCH_ACTION_NONE];
  };

  _proto.attrTest = function attrTest(input) {
    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
  };

  _proto.emit = function emit(input) {
    if (input.scale !== 1) {
      var inOut = input.scale < 1 ? 'in' : 'out';
      input.additionalEvent = this.options.event + inOut;
    }

    _AttrRecognizer.prototype.emit.call(this, input);
  };

  return PinchRecognizer;
}(AttrRecognizer);
/**
 * @private
 * Rotate
 * Recognized when two or more pointer are moving in a circular motion.
 * @constructor
 * @extends AttrRecognizer
 */


var RotateRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
  _inheritsLoose(RotateRecognizer, _AttrRecognizer);

  function RotateRecognizer(options) {
    if (options === void 0) {
      options = {};
    }

    return _AttrRecognizer.call(this, _extends({
      event: 'rotate',
      threshold: 0,
      pointers: 2
    }, options)) || this;
  }

  var _proto = RotateRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return [TOUCH_ACTION_NONE];
  };

  _proto.attrTest = function attrTest(input) {
    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
  };

  return RotateRecognizer;
}(AttrRecognizer);
/**
 * @private
 * Press
 * Recognized when the pointer is down for x ms without any movement.
 * @constructor
 * @extends Recognizer
 */


var PressRecognizer = /*#__PURE__*/function (_Recognizer) {
  _inheritsLoose(PressRecognizer, _Recognizer);

  function PressRecognizer(options) {
    var _this;

    if (options === void 0) {
      options = {};
    }

    _this = _Recognizer.call(this, _extends({
      event: 'press',
      pointers: 1,
      time: 251,
      // minimal time of the pointer to be pressed
      threshold: 9
    }, options)) || this;
    _this._timer = null;
    _this._input = null;
    return _this;
  }

  var _proto = PressRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return [TOUCH_ACTION_AUTO];
  };

  _proto.process = function process(input) {
    var _this2 = this;

    var options = this.options;
    var validPointers = input.pointers.length === options.pointers;
    var validMovement = input.distance < options.threshold;
    var validTime = input.deltaTime > options.time;
    this._input = input; // we only allow little movement
    // and we've reached an end event, so a tap is possible

    if (!validMovement || !validPointers || input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime) {
      this.reset();
    } else if (input.eventType & INPUT_START) {
      this.reset();
      this._timer = setTimeout(function () {
        _this2.state = STATE_RECOGNIZED;

        _this2.tryEmit();
      }, options.time);
    } else if (input.eventType & INPUT_END) {
      return STATE_RECOGNIZED;
    }

    return STATE_FAILED;
  };

  _proto.reset = function reset() {
    clearTimeout(this._timer);
  };

  _proto.emit = function emit(input) {
    if (this.state !== STATE_RECOGNIZED) {
      return;
    }

    if (input && input.eventType & INPUT_END) {
      this.manager.emit(this.options.event + "up", input);
    } else {
      this._input.timeStamp = now();
      this.manager.emit(this.options.event, this._input);
    }
  };

  return PressRecognizer;
}(Recognizer);

var defaults = {
  /**
   * @private
   * set if DOM events are being triggered.
   * But this is slower and unused by simple implementations, so disabled by default.
   * @type {Boolean}
   * @default false
   */
  domEvents: false,

  /**
   * @private
   * The value for the touchAction property/fallback.
   * When set to `compute` it will magically set the correct value based on the added recognizers.
   * @type {String}
   * @default compute
   */
  touchAction: TOUCH_ACTION_COMPUTE,

  /**
   * @private
   * @type {Boolean}
   * @default true
   */
  enable: true,

  /**
   * @private
   * EXPERIMENTAL FEATURE -- can be removed/changed
   * Change the parent input target element.
   * If Null, then it is being set the to main element.
   * @type {Null|EventTarget}
   * @default null
   */
  inputTarget: null,

  /**
   * @private
   * force an input class
   * @type {Null|Function}
   * @default null
   */
  inputClass: null,

  /**
   * @private
   * Some CSS properties can be used to improve the working of Hammer.
   * Add them to this method and they will be set when creating a new Manager.
   * @namespace
   */
  cssProps: {
    /**
     * @private
     * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
     * @type {String}
     * @default 'none'
     */
    userSelect: "none",

    /**
     * @private
     * Disable the Windows Phone grippers when pressing an element.
     * @type {String}
     * @default 'none'
     */
    touchSelect: "none",

    /**
     * @private
     * Disables the default callout shown when you touch and hold a touch target.
     * On iOS, when you touch and hold a touch target such as a link, Safari displays
     * a callout containing information about the link. This property allows you to disable that callout.
     * @type {String}
     * @default 'none'
     */
    touchCallout: "none",

    /**
     * @private
     * Specifies whether zooming is enabled. Used by IE10>
     * @type {String}
     * @default 'none'
     */
    contentZooming: "none",

    /**
     * @private
     * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
     * @type {String}
     * @default 'none'
     */
    userDrag: "none",

    /**
     * @private
     * Overrides the highlight color shown when the user taps a link or a JavaScript
     * clickable element in iOS. This property obeys the alpha value, if specified.
     * @type {String}
     * @default 'rgba(0,0,0,0)'
     */
    tapHighlightColor: "rgba(0,0,0,0)"
  }
};
/**
 * @private
 * Default recognizer setup when calling `Hammer()`
 * When creating a new Manager these will be skipped.
 * This is separated with other defaults because of tree-shaking.
 * @type {Array}
 */

var preset = [[RotateRecognizer, {
  enable: false
}], [PinchRecognizer, {
  enable: false
}, ['rotate']], [SwipeRecognizer, {
  direction: DIRECTION_HORIZONTAL
}], [PanRecognizer, {
  direction: DIRECTION_HORIZONTAL
}, ['swipe']], [TapRecognizer], [TapRecognizer, {
  event: 'doubletap',
  taps: 2
}, ['tap']], [PressRecognizer]];
var STOP = 1;
var FORCED_STOP = 2;
/**
 * @private
 * add/remove the css properties as defined in manager.options.cssProps
 * @param {Manager} manager
 * @param {Boolean} add
 */

function toggleCssProps(manager, add) {
  var element = manager.element;

  if (!element.style) {
    return;
  }

  var prop;
  each(manager.options.cssProps, function (value, name) {
    prop = prefixed(element.style, name);

    if (add) {
      manager.oldCssProps[prop] = element.style[prop];
      element.style[prop] = value;
    } else {
      element.style[prop] = manager.oldCssProps[prop] || "";
    }
  });

  if (!add) {
    manager.oldCssProps = {};
  }
}
/**
 * @private
 * trigger dom event
 * @param {String} event
 * @param {Object} data
 */


function triggerDomEvent(event, data) {
  var gestureEvent = document.createEvent("Event");
  gestureEvent.initEvent(event, true, true);
  gestureEvent.gesture = data;
  data.target.dispatchEvent(gestureEvent);
}
/**
* @private
 * Manager
 * @param {HTMLElement} element
 * @param {Object} [options]
 * @constructor
 */


var Manager = /*#__PURE__*/function () {
  function Manager(element, options) {
    var _this = this;

    this.options = assign$1({}, defaults, options || {});
    this.options.inputTarget = this.options.inputTarget || element;
    this.handlers = {};
    this.session = {};
    this.recognizers = [];
    this.oldCssProps = {};
    this.element = element;
    this.input = createInputInstance(this);
    this.touchAction = new TouchAction(this, this.options.touchAction);
    toggleCssProps(this, true);
    each(this.options.recognizers, function (item) {
      var recognizer = _this.add(new item[0](item[1]));

      item[2] && recognizer.recognizeWith(item[2]);
      item[3] && recognizer.requireFailure(item[3]);
    }, this);
  }
  /**
   * @private
   * set options
   * @param {Object} options
   * @returns {Manager}
   */


  var _proto = Manager.prototype;

  _proto.set = function set(options) {
    assign$1(this.options, options); // Options that need a little more setup

    if (options.touchAction) {
      this.touchAction.update();
    }

    if (options.inputTarget) {
      // Clean up existing event listeners and reinitialize
      this.input.destroy();
      this.input.target = options.inputTarget;
      this.input.init();
    }

    return this;
  };
  /**
   * @private
   * stop recognizing for this session.
   * This session will be discarded, when a new [input]start event is fired.
   * When forced, the recognizer cycle is stopped immediately.
   * @param {Boolean} [force]
   */


  _proto.stop = function stop(force) {
    this.session.stopped = force ? FORCED_STOP : STOP;
  };
  /**
   * @private
   * run the recognizers!
   * called by the inputHandler function on every movement of the pointers (touches)
   * it walks through all the recognizers and tries to detect the gesture that is being made
   * @param {Object} inputData
   */


  _proto.recognize = function recognize(inputData) {
    var session = this.session;

    if (session.stopped) {
      return;
    } // run the touch-action polyfill


    this.touchAction.preventDefaults(inputData);
    var recognizer;
    var recognizers = this.recognizers; // this holds the recognizer that is being recognized.
    // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
    // if no recognizer is detecting a thing, it is set to `null`

    var curRecognizer = session.curRecognizer; // reset when the last recognizer is recognized
    // or when we're in a new session

    if (!curRecognizer || curRecognizer && curRecognizer.state & STATE_RECOGNIZED) {
      session.curRecognizer = null;
      curRecognizer = null;
    }

    var i = 0;

    while (i < recognizers.length) {
      recognizer = recognizers[i]; // find out if we are allowed try to recognize the input for this one.
      // 1.   allow if the session is NOT forced stopped (see the .stop() method)
      // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
      //      that is being recognized.
      // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
      //      this can be setup with the `recognizeWith()` method on the recognizer.

      if (session.stopped !== FORCED_STOP && ( // 1
      !curRecognizer || recognizer === curRecognizer || // 2
      recognizer.canRecognizeWith(curRecognizer))) {
        // 3
        recognizer.recognize(inputData);
      } else {
        recognizer.reset();
      } // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
      // current active recognizer. but only if we don't already have an active recognizer


      if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
        session.curRecognizer = recognizer;
        curRecognizer = recognizer;
      }

      i++;
    }
  };
  /**
   * @private
   * get a recognizer by its event name.
   * @param {Recognizer|String} recognizer
   * @returns {Recognizer|Null}
   */


  _proto.get = function get(recognizer) {
    if (recognizer instanceof Recognizer) {
      return recognizer;
    }

    var recognizers = this.recognizers;

    for (var i = 0; i < recognizers.length; i++) {
      if (recognizers[i].options.event === recognizer) {
        return recognizers[i];
      }
    }

    return null;
  };
  /**
   * @private add a recognizer to the manager
   * existing recognizers with the same event name will be removed
   * @param {Recognizer} recognizer
   * @returns {Recognizer|Manager}
   */


  _proto.add = function add(recognizer) {
    if (invokeArrayArg(recognizer, "add", this)) {
      return this;
    } // remove existing


    var existing = this.get(recognizer.options.event);

    if (existing) {
      this.remove(existing);
    }

    this.recognizers.push(recognizer);
    recognizer.manager = this;
    this.touchAction.update();
    return recognizer;
  };
  /**
   * @private
   * remove a recognizer by name or instance
   * @param {Recognizer|String} recognizer
   * @returns {Manager}
   */


  _proto.remove = function remove(recognizer) {
    if (invokeArrayArg(recognizer, "remove", this)) {
      return this;
    }

    var targetRecognizer = this.get(recognizer); // let's make sure this recognizer exists

    if (recognizer) {
      var recognizers = this.recognizers;
      var index = inArray(recognizers, targetRecognizer);

      if (index !== -1) {
        recognizers.splice(index, 1);
        this.touchAction.update();
      }
    }

    return this;
  };
  /**
   * @private
   * bind event
   * @param {String} events
   * @param {Function} handler
   * @returns {EventEmitter} this
   */


  _proto.on = function on(events, handler) {
    if (events === undefined || handler === undefined) {
      return this;
    }

    var handlers = this.handlers;
    each(splitStr(events), function (event) {
      handlers[event] = handlers[event] || [];
      handlers[event].push(handler);
    });
    return this;
  };
  /**
   * @private unbind event, leave emit blank to remove all handlers
   * @param {String} events
   * @param {Function} [handler]
   * @returns {EventEmitter} this
   */


  _proto.off = function off(events, handler) {
    if (events === undefined) {
      return this;
    }

    var handlers = this.handlers;
    each(splitStr(events), function (event) {
      if (!handler) {
        delete handlers[event];
      } else {
        handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
      }
    });
    return this;
  };
  /**
   * @private emit event to the listeners
   * @param {String} event
   * @param {Object} data
   */


  _proto.emit = function emit(event, data) {
    // we also want to trigger dom events
    if (this.options.domEvents) {
      triggerDomEvent(event, data);
    } // no handlers, so skip it all


    var handlers = this.handlers[event] && this.handlers[event].slice();

    if (!handlers || !handlers.length) {
      return;
    }

    data.type = event;

    data.preventDefault = function () {
      data.srcEvent.preventDefault();
    };

    var i = 0;

    while (i < handlers.length) {
      handlers[i](data);
      i++;
    }
  };
  /**
   * @private
   * destroy the manager and unbinds all events
   * it doesn't unbind dom events, that is the user own responsibility
   */


  _proto.destroy = function destroy() {
    this.element && toggleCssProps(this, false);
    this.handlers = {};
    this.session = {};
    this.input.destroy();
    this.element = null;
  };

  return Manager;
}();

var SINGLE_TOUCH_INPUT_MAP = {
  touchstart: INPUT_START,
  touchmove: INPUT_MOVE,
  touchend: INPUT_END,
  touchcancel: INPUT_CANCEL
};
var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';
/**
 * @private
 * Touch events input
 * @constructor
 * @extends Input
 */

var SingleTouchInput = /*#__PURE__*/function (_Input) {
  _inheritsLoose(SingleTouchInput, _Input);

  function SingleTouchInput() {
    var _this;

    var proto = SingleTouchInput.prototype;
    proto.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
    proto.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
    _this = _Input.apply(this, arguments) || this;
    _this.started = false;
    return _this;
  }

  var _proto = SingleTouchInput.prototype;

  _proto.handler = function handler(ev) {
    var type = SINGLE_TOUCH_INPUT_MAP[ev.type]; // should we handle the touch events?

    if (type === INPUT_START) {
      this.started = true;
    }

    if (!this.started) {
      return;
    }

    var touches = normalizeSingleTouches.call(this, ev, type); // when done, reset the started state

    if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
      this.started = false;
    }

    this.callback(this.manager, type, {
      pointers: touches[0],
      changedPointers: touches[1],
      pointerType: INPUT_TYPE_TOUCH,
      srcEvent: ev
    });
  };

  return SingleTouchInput;
}(Input);

function normalizeSingleTouches(ev, type) {
  var all = toArray(ev.touches);
  var changed = toArray(ev.changedTouches);

  if (type & (INPUT_END | INPUT_CANCEL)) {
    all = uniqueArray(all.concat(changed), 'identifier', true);
  }

  return [all, changed];
}
/**
 * @private
 * wrap a method with a deprecation warning and stack trace
 * @param {Function} method
 * @param {String} name
 * @param {String} message
 * @returns {Function} A new function wrapping the supplied method.
 */


function deprecate(method, name, message) {
  var deprecationMessage = "DEPRECATED METHOD: " + name + "\n" + message + " AT \n";
  return function () {
    var e = new Error('get-stack-trace');
    var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '').replace(/^\s+at\s+/gm, '').replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';
    var log = window.console && (window.console.warn || window.console.log);

    if (log) {
      log.call(window.console, deprecationMessage, stack);
    }

    return method.apply(this, arguments);
  };
}
/**
 * @private
 * extend object.
 * means that properties in dest will be overwritten by the ones in src.
 * @param {Object} dest
 * @param {Object} src
 * @param {Boolean} [merge=false]
 * @returns {Object} dest
 */


var extend = deprecate(function (dest, src, merge) {
  var keys = Object.keys(src);
  var i = 0;

  while (i < keys.length) {
    if (!merge || merge && dest[keys[i]] === undefined) {
      dest[keys[i]] = src[keys[i]];
    }

    i++;
  }

  return dest;
}, 'extend', 'Use `assign`.');
/**
 * @private
 * merge the values from src in the dest.
 * means that properties that exist in dest will not be overwritten by src
 * @param {Object} dest
 * @param {Object} src
 * @returns {Object} dest
 */

var merge$2 = deprecate(function (dest, src) {
  return extend(dest, src, true);
}, 'merge', 'Use `assign`.');
/**
 * @private
 * simple class inheritance
 * @param {Function} child
 * @param {Function} base
 * @param {Object} [properties]
 */

function inherit(child, base, properties) {
  var baseP = base.prototype;
  var childP;
  childP = child.prototype = Object.create(baseP);
  childP.constructor = child;
  childP._super = baseP;

  if (properties) {
    assign$1(childP, properties);
  }
}
/**
 * @private
 * simple function bind
 * @param {Function} fn
 * @param {Object} context
 * @returns {Function}
 */


function bindFn(fn, context) {
  return function boundFn() {
    return fn.apply(context, arguments);
  };
}
/**
 * @private
 * Simple way to create a manager with a default set of recognizers.
 * @param {HTMLElement} element
 * @param {Object} [options]
 * @constructor
 */


var Hammer$2 = /*#__PURE__*/function () {
  var Hammer =
  /**
    * @private
    * @const {string}
    */
  function Hammer(element, options) {
    if (options === void 0) {
      options = {};
    }

    return new Manager(element, _extends({
      recognizers: preset.concat()
    }, options));
  };

  Hammer.VERSION = "2.0.17-rc";
  Hammer.DIRECTION_ALL = DIRECTION_ALL;
  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
  Hammer.DIRECTION_LEFT = DIRECTION_LEFT;
  Hammer.DIRECTION_RIGHT = DIRECTION_RIGHT;
  Hammer.DIRECTION_UP = DIRECTION_UP;
  Hammer.DIRECTION_HORIZONTAL = DIRECTION_HORIZONTAL;
  Hammer.DIRECTION_VERTICAL = DIRECTION_VERTICAL;
  Hammer.DIRECTION_NONE = DIRECTION_NONE;
  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
  Hammer.INPUT_START = INPUT_START;
  Hammer.INPUT_MOVE = INPUT_MOVE;
  Hammer.INPUT_END = INPUT_END;
  Hammer.INPUT_CANCEL = INPUT_CANCEL;
  Hammer.STATE_POSSIBLE = STATE_POSSIBLE;
  Hammer.STATE_BEGAN = STATE_BEGAN;
  Hammer.STATE_CHANGED = STATE_CHANGED;
  Hammer.STATE_ENDED = STATE_ENDED;
  Hammer.STATE_RECOGNIZED = STATE_RECOGNIZED;
  Hammer.STATE_CANCELLED = STATE_CANCELLED;
  Hammer.STATE_FAILED = STATE_FAILED;
  Hammer.Manager = Manager;
  Hammer.Input = Input;
  Hammer.TouchAction = TouchAction;
  Hammer.TouchInput = TouchInput;
  Hammer.MouseInput = MouseInput;
  Hammer.PointerEventInput = PointerEventInput;
  Hammer.TouchMouseInput = TouchMouseInput;
  Hammer.SingleTouchInput = SingleTouchInput;
  Hammer.Recognizer = Recognizer;
  Hammer.AttrRecognizer = AttrRecognizer;
  Hammer.Tap = TapRecognizer;
  Hammer.Pan = PanRecognizer;
  Hammer.Swipe = SwipeRecognizer;
  Hammer.Pinch = PinchRecognizer;
  Hammer.Rotate = RotateRecognizer;
  Hammer.Press = PressRecognizer;
  Hammer.on = addEventListeners;
  Hammer.off = removeEventListeners;
  Hammer.each = each;
  Hammer.merge = merge$2;
  Hammer.extend = extend;
  Hammer.bindFn = bindFn;
  Hammer.assign = assign$1;
  Hammer.inherit = inherit;
  Hammer.bindFn = bindFn;
  Hammer.prefixed = prefixed;
  Hammer.toArray = toArray;
  Hammer.inArray = inArray;
  Hammer.uniqueArray = uniqueArray;
  Hammer.splitStr = splitStr;
  Hammer.boolOrFn = boolOrFn;
  Hammer.hasParent = hasParent;
  Hammer.addEventListeners = addEventListeners;
  Hammer.removeEventListeners = removeEventListeners;
  Hammer.defaults = assign$1({}, defaults, {
    preset: preset
  });
  return Hammer;
}(); //  style loader but by script tag, not by the loader.
var RealHammer = Hammer$2;

function _createForOfIteratorHelper$8(o, allowArrayLike) { var it = typeof symbol !== "undefined" && getIteratorMethod$2(o) || o["@@iterator"]; if (!it) { if (isArray$2(o) || (it = _unsupportedIterableToArray$8(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$8(o, minLen) { var _context21; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$8(o, minLen); var n = slice$1(_context21 = Object.prototype.toString.call(o)).call(_context21, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return from$2(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$8(o, minLen); }

function _arrayLikeToArray$8(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
/**
 * Use this symbol to delete properies in deepObjectAssign.
 */

var DELETE = symbol("DELETE");
/**
 * Pure version of deepObjectAssign, it doesn't modify any of it's arguments.
 *
 * @param base - The base object that fullfils the whole interface T.
 * @param updates - Updates that may change or delete props.
 *
 * @returns A brand new instance with all the supplied objects deeply merged.
 */


function pureDeepObjectAssign(base) {
  var _context;

  for (var _len = arguments.length, updates = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    updates[_key - 1] = arguments[_key];
  }

  return deepObjectAssign.apply(void 0, concat(_context = [{}, base]).call(_context, updates));
}
/**
 * Deep version of object assign with additional deleting by the DELETE symbol.
 *
 * @param values - Objects to be deeply merged.
 *
 * @returns The first object from values.
 */


function deepObjectAssign() {
  var merged = deepObjectAssignNonentry.apply(void 0, arguments);
  stripDelete(merged);
  return merged;
}
/**
 * Deep version of object assign with additional deleting by the DELETE symbol.
 *
 * @remarks
 * This doesn't strip the DELETE symbols so they may end up in the final object.
 *
 * @param values - Objects to be deeply merged.
 *
 * @returns The first object from values.
 */


function deepObjectAssignNonentry() {
  for (var _len2 = arguments.length, values = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
    values[_key2] = arguments[_key2];
  }

  if (values.length < 2) {
    return values[0];
  } else if (values.length > 2) {
    var _context2;

    return deepObjectAssignNonentry.apply(void 0, concat(_context2 = [deepObjectAssign(values[0], values[1])]).call(_context2, _toConsumableArray(slice$1(values).call(values, 2))));
  }

  var a = values[0];
  var b = values[1];

  var _iterator = _createForOfIteratorHelper$8(ownKeys$5(b)),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var prop = _step.value;
      if (!Object.prototype.propertyIsEnumerable.call(b, prop)) ;else if (b[prop] === DELETE) {
        delete a[prop];
      } else if (a[prop] !== null && b[prop] !== null && _typeof(a[prop]) === "object" && _typeof(b[prop]) === "object" && !isArray$2(a[prop]) && !isArray$2(b[prop])) {
        a[prop] = deepObjectAssignNonentry(a[prop], b[prop]);
      } else {
        a[prop] = clone(b[prop]);
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return a;
}
/**
 * Deep clone given object or array. In case of primitive simply return.
 *
 * @param a - Anything.
 *
 * @returns Deep cloned object/array or unchanged a.
 */


function clone(a) {
  if (isArray$2(a)) {
    return map$3(a).call(a, function (value) {
      return clone(value);
    });
  } else if (_typeof(a) === "object" && a !== null) {
    return deepObjectAssignNonentry({}, a);
  } else {
    return a;
  }
}
/**
 * Strip DELETE from given object.
 *
 * @param a - Object which may contain DELETE but won't after this is executed.
 */


function stripDelete(a) {
  for (var _i = 0, _Object$keys = keys$4(a); _i < _Object$keys.length; _i++) {
    var prop = _Object$keys[_i];

    if (a[prop] === DELETE) {
      delete a[prop];
    } else if (_typeof(a[prop]) === "object" && a[prop] !== null) {
      stripDelete(a[prop]);
    }
  }
}
/**
 * Seedable, fast and reasonably good (not crypto but more than okay for our
 * needs) random number generator.
 *
 * @remarks
 * Adapted from {@link https://web.archive.org/web/20110429100736/http://baagoe.com:80/en/RandomMusings/javascript}.
 * Original algorithm created by Johannes Baagøe \<baagoe\@baagoe.com\> in 2010.
 */

/**
 * Create a seeded pseudo random generator based on Alea by Johannes Baagøe.
 *
 * @param seed - All supplied arguments will be used as a seed. In case nothing
 * is supplied the current time will be used to seed the generator.
 *
 * @returns A ready to use seeded generator.
 */


function Alea() {
  for (var _len3 = arguments.length, seed = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
    seed[_key3] = arguments[_key3];
  }

  return AleaImplementation(seed.length ? seed : [now$1()]);
}
/**
 * An implementation of [[Alea]] without user input validation.
 *
 * @param seed - The data that will be used to seed the generator.
 *
 * @returns A ready to use seeded generator.
 */


function AleaImplementation(seed) {
  var _mashSeed = mashSeed(seed),
      _mashSeed2 = _slicedToArray(_mashSeed, 3),
      s0 = _mashSeed2[0],
      s1 = _mashSeed2[1],
      s2 = _mashSeed2[2];

  var c = 1;

  var random = function random() {
    var t = 2091639 * s0 + c * 2.3283064365386963e-10; // 2^-32

    s0 = s1;
    s1 = s2;
    return s2 = t - (c = t | 0);
  };

  random.uint32 = function () {
    return random() * 0x100000000;
  }; // 2^32


  random.fract53 = function () {
    return random() + (random() * 0x200000 | 0) * 1.1102230246251565e-16;
  }; // 2^-53


  random.algorithm = "Alea";
  random.seed = seed;
  random.version = "0.9";
  return random;
}
/**
 * Turn arbitrary data into values [[AleaImplementation]] can use to generate
 * random numbers.
 *
 * @param seed - Arbitrary data that will be used as the seed.
 *
 * @returns Three numbers to use as initial values for [[AleaImplementation]].
 */


function mashSeed() {
  var mash = Mash();
  var s0 = mash(" ");
  var s1 = mash(" ");
  var s2 = mash(" ");

  for (var i = 0; i < arguments.length; i++) {
    s0 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);

    if (s0 < 0) {
      s0 += 1;
    }

    s1 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);

    if (s1 < 0) {
      s1 += 1;
    }

    s2 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);

    if (s2 < 0) {
      s2 += 1;
    }
  }

  return [s0, s1, s2];
}
/**
 * Create a new mash function.
 *
 * @returns A nonpure function that takes arbitrary [[Mashable]] data and turns
 * them into numbers.
 */


function Mash() {
  var n = 0xefc8249d;
  return function (data) {
    var string = data.toString();

    for (var i = 0; i < string.length; i++) {
      n += string.charCodeAt(i);
      var h = 0.02519603282416938 * n;
      n = h >>> 0;
      h -= n;
      h *= n;
      n = h >>> 0;
      h -= n;
      n += h * 0x100000000; // 2^32
    }

    return (n >>> 0) * 2.3283064365386963e-10; // 2^-32
  };
}
/**
 * Setup a mock hammer.js object, for unit testing.
 *
 * Inspiration: https://github.com/uber/deck.gl/pull/658
 *
 * @returns {{on: noop, off: noop, destroy: noop, emit: noop, get: get}}
 */


function hammerMock() {
  var noop = function noop() {};

  return {
    on: noop,
    off: noop,
    destroy: noop,
    emit: noop,
    get: function get() {
      return {
        set: noop
      };
    }
  };
}

var Hammer = typeof window !== "undefined" ? window.Hammer || RealHammer : function () {
  // hammer.js is only available in a browser, not in node.js. Replacing it with a mock object.
  return hammerMock();
};
/**
 * Turn an element into an clickToUse element.
 * When not active, the element has a transparent overlay. When the overlay is
 * clicked, the mode is changed to active.
 * When active, the element is displayed with a blue border around it, and
 * the interactive contents of the element can be used. When clicked outside
 * the element, the elements mode is changed to inactive.
 *
 * @param {Element} container
 * @class Activator
 */

function Activator(container) {
  var _this = this,
      _context3;

  this._cleanupQueue = [];
  this.active = false;
  this._dom = {
    container: container,
    overlay: document.createElement("div")
  };

  this._dom.overlay.classList.add("vis-overlay");

  this._dom.container.appendChild(this._dom.overlay);

  this._cleanupQueue.push(function () {
    _this._dom.overlay.parentNode.removeChild(_this._dom.overlay);
  });

  var hammer = Hammer(this._dom.overlay);
  hammer.on("tap", bind$6(_context3 = this._onTapOverlay).call(_context3, this));

  this._cleanupQueue.push(function () {
    hammer.destroy(); // FIXME: cleaning up hammer instances doesn't work (Timeline not removed
    // from memory)
  }); // block all touch events (except tap)


  var events = ["tap", "doubletap", "press", "pinch", "pan", "panstart", "panmove", "panend"];

  forEach$2(events).call(events, function (event) {
    hammer.on(event, function (event) {
      event.srcEvent.stopPropagation();
    });
  }); // attach a click event to the window, in order to deactivate when clicking outside the timeline


  if (document && document.body) {
    this._onClick = function (event) {
      if (!_hasParent(event.target, container)) {
        _this.deactivate();
      }
    };

    document.body.addEventListener("click", this._onClick);

    this._cleanupQueue.push(function () {
      document.body.removeEventListener("click", _this._onClick);
    });
  } // prepare escape key listener for deactivating when active


  this._escListener = function (event) {
    if ("key" in event ? event.key === "Escape" : event.keyCode === 27
    /* the keyCode is for IE11 */
    ) {
      _this.deactivate();
    }
  };
} // turn into an event emitter


Emitter(Activator.prototype); // The currently active activator

Activator.current = null;
/**
 * Destroy the activator. Cleans up all created DOM and event listeners
 */

Activator.prototype.destroy = function () {
  var _context4, _context5;

  this.deactivate();

  var _iterator2 = _createForOfIteratorHelper$8(reverse(_context4 = splice(_context5 = this._cleanupQueue).call(_context5, 0)).call(_context4)),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var callback = _step2.value;
      callback();
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
};
/**
 * Activate the element
 * Overlay is hidden, element is decorated with a blue shadow border
 */


Activator.prototype.activate = function () {
  // we allow only one active activator at a time
  if (Activator.current) {
    Activator.current.deactivate();
  }

  Activator.current = this;
  this.active = true;
  this._dom.overlay.style.display = "none";

  this._dom.container.classList.add("vis-active");

  this.emit("change");
  this.emit("activate"); // ugly hack: bind ESC after emitting the events, as the Network rebinds all
  // keyboard events on a 'change' event

  document.body.addEventListener("keydown", this._escListener);
};
/**
 * Deactivate the element
 * Overlay is displayed on top of the element
 */


Activator.prototype.deactivate = function () {
  this.active = false;
  this._dom.overlay.style.display = "block";

  this._dom.container.classList.remove("vis-active");

  document.body.removeEventListener("keydown", this._escListener);
  this.emit("change");
  this.emit("deactivate");
};
/**
 * Handle a tap event: activate the container
 *
 * @param {Event}  event   The event
 * @private
 */


Activator.prototype._onTapOverlay = function (event) {
  // activate the container
  this.activate();
  event.srcEvent.stopPropagation();
};
/**
 * Test whether the element has the requested parent element somewhere in
 * its chain of parent nodes.
 *
 * @param {HTMLElement} element
 * @param {HTMLElement} parent
 * @returns {boolean} Returns true when the parent is found somewhere in the
 *                    chain of parent nodes.
 * @private
 */


function _hasParent(element, parent) {
  while (element) {
    if (element === parent) {
      return true;
    }

    element = element.parentNode;
  }

  return false;
} // utility functions

var fullHexRE = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;
var shortHexRE = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
var rgbRE = /^rgb\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *\)$/i;
var rgbaRE = /^rgba\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *([01]|0?\.\d+) *\)$/i;
/**
 * Remove everything in the DOM object.
 *
 * @param DOMobject - Node whose child nodes will be recursively deleted.
 */


function recursiveDOMDelete(DOMobject) {
  if (DOMobject) {
    while (DOMobject.hasChildNodes() === true) {
      var child = DOMobject.firstChild;

      if (child) {
        recursiveDOMDelete(child);
        DOMobject.removeChild(child);
      }
    }
  }
}
/**
 * Test whether given object is a string.
 *
 * @param value - Input value of unknown type.
 *
 * @returns True if string, false otherwise.
 */


function isString(value) {
  return value instanceof String || typeof value === "string";
}
/**
 * Test whether given object is a object (not primitive or null).
 *
 * @param value - Input value of unknown type.
 *
 * @returns True if not null object, false otherwise.
 */


function isObject$6(value) {
  return _typeof(value) === "object" && value !== null;
}
/**
 * Copy property from b to a if property present in a.
 * If property in b explicitly set to null, delete it if `allowDeletion` set.
 *
 * Internal helper routine, should not be exported. Not added to `exports` for that reason.
 *
 * @param a - Target object.
 * @param b - Source object.
 * @param prop - Name of property to copy from b to a.
 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
 */


function copyOrDelete(a, b, prop, allowDeletion) {
  var doDeletion = false;

  if (allowDeletion === true) {
    doDeletion = b[prop] === null && a[prop] !== undefined;
  }

  if (doDeletion) {
    delete a[prop];
  } else {
    a[prop] = b[prop]; // Remember, this is a reference copy!
  }
}
/**
 * Fill an object with a possibly partially defined other object.
 *
 * Only copies values for the properties already present in a.
 * That means an object is not created on a property if only the b object has it.
 *
 * @param a - The object that will have it's properties updated.
 * @param b - The object with property updates.
 * @param allowDeletion - If true, delete properties in a that are explicitly set to null in b.
 */


function fillIfDefined(a, b) {
  var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  // NOTE: iteration of properties of a
  // NOTE: prototype properties iterated over as well
  for (var prop in a) {
    if (b[prop] !== undefined) {
      if (b[prop] === null || _typeof(b[prop]) !== "object") {
        // Note: typeof null === 'object'
        copyOrDelete(a, b, prop, allowDeletion);
      } else {
        var aProp = a[prop];
        var bProp = b[prop];

        if (isObject$6(aProp) && isObject$6(bProp)) {
          fillIfDefined(aProp, bProp, allowDeletion);
        }
      }
    }
  }
}
/**
 * Extend object a with selected properties of object b.
 * Only properties with defined values are copied.
 *
 * @remarks
 * Previous version of this routine implied that multiple source objects could
 * be used; however, the implementation was **wrong**. Since multiple (\>1)
 * sources weren't used anywhere in the `vis.js` code, this has been removed
 *
 * @param props - Names of first-level properties to copy over.
 * @param a - Target object.
 * @param b - Source object.
 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
 *
 * @returns Argument a.
 */


function selectiveDeepExtend(props, a, b) {
  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  // TODO: add support for Arrays to deepExtend
  if (isArray$2(b)) {
    throw new TypeError("Arrays are not supported by deepExtend");
  }

  for (var p = 0; p < props.length; p++) {
    var prop = props[p];

    if (Object.prototype.hasOwnProperty.call(b, prop)) {
      if (b[prop] && b[prop].constructor === Object) {
        if (a[prop] === undefined) {
          a[prop] = {};
        }

        if (a[prop].constructor === Object) {
          deepExtend(a[prop], b[prop], false, allowDeletion);
        } else {
          copyOrDelete(a, b, prop, allowDeletion);
        }
      } else if (isArray$2(b[prop])) {
        throw new TypeError("Arrays are not supported by deepExtend");
      } else {
        copyOrDelete(a, b, prop, allowDeletion);
      }
    }
  }

  return a;
}
/**
 * Extend object `a` with properties of object `b`, ignoring properties which
 * are explicitly specified to be excluded.
 *
 * @remarks
 * The properties of `b` are considered for copying. Properties which are
 * themselves objects are are also extended. Only properties with defined
 * values are copied.
 *
 * @param propsToExclude - Names of properties which should *not* be copied.
 * @param a - Object to extend.
 * @param b - Object to take properties from for extension.
 * @param allowDeletion - If true, delete properties in a that are explicitly
 * set to null in b.
 *
 * @returns Argument a.
 */


function selectiveNotDeepExtend(propsToExclude, a, b) {
  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  // TODO: add support for Arrays to deepExtend
  // NOTE: array properties have an else-below; apparently, there is a problem here.
  if (isArray$2(b)) {
    throw new TypeError("Arrays are not supported by deepExtend");
  }

  for (var prop in b) {
    if (!Object.prototype.hasOwnProperty.call(b, prop)) {
      continue;
    } // Handle local properties only


    if (includes(propsToExclude).call(propsToExclude, prop)) {
      continue;
    } // In exclusion list, skip


    if (b[prop] && b[prop].constructor === Object) {
      if (a[prop] === undefined) {
        a[prop] = {};
      }

      if (a[prop].constructor === Object) {
        deepExtend(a[prop], b[prop]); // NOTE: allowDeletion not propagated!
      } else {
        copyOrDelete(a, b, prop, allowDeletion);
      }
    } else if (isArray$2(b[prop])) {
      a[prop] = [];

      for (var i = 0; i < b[prop].length; i++) {
        a[prop].push(b[prop][i]);
      }
    } else {
      copyOrDelete(a, b, prop, allowDeletion);
    }
  }

  return a;
}
/**
 * Deep extend an object a with the properties of object b.
 *
 * @param a - Target object.
 * @param b - Source object.
 * @param protoExtend - If true, the prototype values will also be extended.
 * (That is the options objects that inherit from others will also get the
 * inherited options).
 * @param allowDeletion - If true, the values of fields that are null will be deleted.
 *
 * @returns Argument a.
 */


function deepExtend(a, b) {
  var protoExtend = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

  for (var prop in b) {
    if (Object.prototype.hasOwnProperty.call(b, prop) || protoExtend === true) {
      if (_typeof(b[prop]) === "object" && b[prop] !== null && getPrototypeOf$3(b[prop]) === Object.prototype) {
        if (a[prop] === undefined) {
          a[prop] = deepExtend({}, b[prop], protoExtend); // NOTE: allowDeletion not propagated!
        } else if (_typeof(a[prop]) === "object" && a[prop] !== null && getPrototypeOf$3(a[prop]) === Object.prototype) {
          deepExtend(a[prop], b[prop], protoExtend); // NOTE: allowDeletion not propagated!
        } else {
          copyOrDelete(a, b, prop, allowDeletion);
        }
      } else if (isArray$2(b[prop])) {
        var _context6;

        a[prop] = slice$1(_context6 = b[prop]).call(_context6);
      } else {
        copyOrDelete(a, b, prop, allowDeletion);
      }
    }
  }

  return a;
}
/**
 * Used to extend an array and copy it. This is used to propagate paths recursively.
 *
 * @param arr - First part.
 * @param newValue - The value to be aadded into the array.
 *
 * @returns A new array with all items from arr and newValue (which is last).
 */


function copyAndExtendArray(arr, newValue) {
  var _context7;

  return concat(_context7 = []).call(_context7, _toConsumableArray(arr), [newValue]);
}
/**
 * Used to extend an array and copy it. This is used to propagate paths recursively.
 *
 * @param arr - The array to be copied.
 *
 * @returns Shallow copy of arr.
 */


function copyArray(arr) {
  return slice$1(arr).call(arr);
}
/**
 * Retrieve the absolute left value of a DOM element.
 *
 * @param elem - A dom element, for example a div.
 *
 * @returns The absolute left position of this element in the browser page.
 */


function getAbsoluteLeft(elem) {
  return elem.getBoundingClientRect().left;
}
/**
 * Retrieve the absolute top value of a DOM element.
 *
 * @param elem - A dom element, for example a div.
 *
 * @returns The absolute top position of this element in the browser page.
 */


function getAbsoluteTop(elem) {
  return elem.getBoundingClientRect().top;
}
/**
 * For each method for both arrays and objects.
 * In case of an array, the built-in Array.forEach() is applied (**No, it's not!**).
 * In case of an Object, the method loops over all properties of the object.
 *
 * @param object - An Object or Array to be iterated over.
 * @param callback - Array.forEach-like callback.
 */


function forEach$1(object, callback) {
  if (isArray$2(object)) {
    // array
    var len = object.length;

    for (var i = 0; i < len; i++) {
      callback(object[i], i, object);
    }
  } else {
    // object
    for (var key in object) {
      if (Object.prototype.hasOwnProperty.call(object, key)) {
        callback(object[key], key, object);
      }
    }
  }
}
/**
 * Add and event listener. Works for all browsers.
 *
 * @param element - The element to bind the event listener to.
 * @param action - Same as Element.addEventListener(action, —, —).
 * @param listener - Same as Element.addEventListener(—, listener, —).
 * @param useCapture - Same as Element.addEventListener(—, —, useCapture).
 */


function addEventListener(element, action, listener, useCapture) {
  if (element.addEventListener) {
    var _context8;

    if (useCapture === undefined) {
      useCapture = false;
    }

    if (action === "mousewheel" && includes(_context8 = navigator.userAgent).call(_context8, "Firefox")) {
      action = "DOMMouseScroll"; // For Firefox
    }

    element.addEventListener(action, listener, useCapture);
  } else {
    // @TODO: IE types? Does anyone care?
    element.attachEvent("on" + action, listener); // IE browsers
  }
}
/**
 * Remove an event listener from an element.
 *
 * @param element - The element to bind the event listener to.
 * @param action - Same as Element.removeEventListener(action, —, —).
 * @param listener - Same as Element.removeEventListener(—, listener, —).
 * @param useCapture - Same as Element.removeEventListener(—, —, useCapture).
 */


function removeEventListener(element, action, listener, useCapture) {
  if (element.removeEventListener) {
    var _context9;

    // non-IE browsers
    if (useCapture === undefined) {
      useCapture = false;
    }

    if (action === "mousewheel" && includes(_context9 = navigator.userAgent).call(_context9, "Firefox")) {
      action = "DOMMouseScroll"; // For Firefox
    }

    element.removeEventListener(action, listener, useCapture);
  } else {
    // @TODO: IE types? Does anyone care?
    element.detachEvent("on" + action, listener); // IE browsers
  }
}
/**
 * Convert hex color string into RGB color object.
 *
 * @remarks
 * {@link http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb}
 *
 * @param hex - Hex color string (3 or 6 digits, with or without #).
 *
 * @returns RGB color object.
 */

function hexToRGB(hex) {
  var result;

  switch (hex.length) {
    case 3:
    case 4:
      result = shortHexRE.exec(hex);
      return result ? {
        r: _parseInt(result[1] + result[1], 16),
        g: _parseInt(result[2] + result[2], 16),
        b: _parseInt(result[3] + result[3], 16)
      } : null;

    case 6:
    case 7:
      result = fullHexRE.exec(hex);
      return result ? {
        r: _parseInt(result[1], 16),
        g: _parseInt(result[2], 16),
        b: _parseInt(result[3], 16)
      } : null;

    default:
      return null;
  }
}
/**
 * This function takes string color in hex or RGB format and adds the opacity, RGBA is passed through unchanged.
 *
 * @param color - The color string (hex, RGB, RGBA).
 * @param opacity - The new opacity.
 *
 * @returns RGBA string, for example 'rgba(255, 0, 127, 0.3)'.
 */


function overrideOpacity(color, opacity) {
  if (includes(color).call(color, "rgba")) {
    return color;
  } else if (includes(color).call(color, "rgb")) {
    var rgb = color.substr(indexOf(color).call(color, "(") + 1).replace(")", "").split(",");
    return "rgba(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "," + opacity + ")";
  } else {
    var _rgb = hexToRGB(color);

    if (_rgb == null) {
      return color;
    } else {
      return "rgba(" + _rgb.r + "," + _rgb.g + "," + _rgb.b + "," + opacity + ")";
    }
  }
}
/**
 * Convert RGB \<0, 255\> into hex color string.
 *
 * @param red - Red channel.
 * @param green - Green channel.
 * @param blue - Blue channel.
 *
 * @returns Hex color string (for example: '#0acdc0').
 */


function RGBToHex(red, green, blue) {
  var _context10;

  return "#" + slice$1(_context10 = ((1 << 24) + (red << 16) + (green << 8) + blue).toString(16)).call(_context10, 1);
}
/**
 * Parse a color property into an object with border, background, and highlight colors.
 *
 * @param inputColor - Shorthand color string or input color object.
 * @param defaultColor - Full color object to fill in missing values in inputColor.
 *
 * @returns Color object.
 */


function parseColor(inputColor, defaultColor) {
  if (isString(inputColor)) {
    var colorStr = inputColor;

    if (isValidRGB(colorStr)) {
      var _context11;

      var rgb = map$3(_context11 = colorStr.substr(4).substr(0, colorStr.length - 5).split(",")).call(_context11, function (value) {
        return _parseInt(value);
      });

      colorStr = RGBToHex(rgb[0], rgb[1], rgb[2]);
    }

    if (isValidHex(colorStr) === true) {
      var hsv = hexToHSV(colorStr);
      var lighterColorHSV = {
        h: hsv.h,
        s: hsv.s * 0.8,
        v: Math.min(1, hsv.v * 1.02)
      };
      var darkerColorHSV = {
        h: hsv.h,
        s: Math.min(1, hsv.s * 1.25),
        v: hsv.v * 0.8
      };
      var darkerColorHex = HSVToHex(darkerColorHSV.h, darkerColorHSV.s, darkerColorHSV.v);
      var lighterColorHex = HSVToHex(lighterColorHSV.h, lighterColorHSV.s, lighterColorHSV.v);
      return {
        background: colorStr,
        border: darkerColorHex,
        highlight: {
          background: lighterColorHex,
          border: darkerColorHex
        },
        hover: {
          background: lighterColorHex,
          border: darkerColorHex
        }
      };
    } else {
      return {
        background: colorStr,
        border: colorStr,
        highlight: {
          background: colorStr,
          border: colorStr
        },
        hover: {
          background: colorStr,
          border: colorStr
        }
      };
    }
  } else {
    if (defaultColor) {
      var color = {
        background: inputColor.background || defaultColor.background,
        border: inputColor.border || defaultColor.border,
        highlight: isString(inputColor.highlight) ? {
          border: inputColor.highlight,
          background: inputColor.highlight
        } : {
          background: inputColor.highlight && inputColor.highlight.background || defaultColor.highlight.background,
          border: inputColor.highlight && inputColor.highlight.border || defaultColor.highlight.border
        },
        hover: isString(inputColor.hover) ? {
          border: inputColor.hover,
          background: inputColor.hover
        } : {
          border: inputColor.hover && inputColor.hover.border || defaultColor.hover.border,
          background: inputColor.hover && inputColor.hover.background || defaultColor.hover.background
        }
      };
      return color;
    } else {
      var _color = {
        background: inputColor.background || undefined,
        border: inputColor.border || undefined,
        highlight: isString(inputColor.highlight) ? {
          border: inputColor.highlight,
          background: inputColor.highlight
        } : {
          background: inputColor.highlight && inputColor.highlight.background || undefined,
          border: inputColor.highlight && inputColor.highlight.border || undefined
        },
        hover: isString(inputColor.hover) ? {
          border: inputColor.hover,
          background: inputColor.hover
        } : {
          border: inputColor.hover && inputColor.hover.border || undefined,
          background: inputColor.hover && inputColor.hover.background || undefined
        }
      };
      return _color;
    }
  }
}
/**
 * Convert RGB \<0, 255\> into HSV object.
 *
 * @remarks
 * {@link http://www.javascripter.net/faq/rgb2hsv.htm}
 *
 * @param red - Red channel.
 * @param green - Green channel.
 * @param blue - Blue channel.
 *
 * @returns HSV color object.
 */


function RGBToHSV(red, green, blue) {
  red = red / 255;
  green = green / 255;
  blue = blue / 255;
  var minRGB = Math.min(red, Math.min(green, blue));
  var maxRGB = Math.max(red, Math.max(green, blue)); // Black-gray-white

  if (minRGB === maxRGB) {
    return {
      h: 0,
      s: 0,
      v: minRGB
    };
  } // Colors other than black-gray-white:


  var d = red === minRGB ? green - blue : blue === minRGB ? red - green : blue - red;
  var h = red === minRGB ? 3 : blue === minRGB ? 1 : 5;
  var hue = 60 * (h - d / (maxRGB - minRGB)) / 360;
  var saturation = (maxRGB - minRGB) / maxRGB;
  var value = maxRGB;
  return {
    h: hue,
    s: saturation,
    v: value
  };
}
/**
 * Convert HSV \<0, 1\> into RGB color object.
 *
 * @remarks
 * {@link https://gist.github.com/mjijackson/5311256}
 *
 * @param h - Hue.
 * @param s - Saturation.
 * @param v - Value.
 *
 * @returns RGB color object.
 */


function HSVToRGB(h, s, v) {
  var r;
  var g;
  var b;
  var i = Math.floor(h * 6);
  var f = h * 6 - i;
  var p = v * (1 - s);
  var q = v * (1 - f * s);
  var t = v * (1 - (1 - f) * s);

  switch (i % 6) {
    case 0:
      r = v, g = t, b = p;
      break;

    case 1:
      r = q, g = v, b = p;
      break;

    case 2:
      r = p, g = v, b = t;
      break;

    case 3:
      r = p, g = q, b = v;
      break;

    case 4:
      r = t, g = p, b = v;
      break;

    case 5:
      r = v, g = p, b = q;
      break;
  }

  return {
    r: Math.floor(r * 255),
    g: Math.floor(g * 255),
    b: Math.floor(b * 255)
  };
}
/**
 * Convert HSV \<0, 1\> into hex color string.
 *
 * @param h - Hue.
 * @param s - Saturation.
 * @param v - Value.
 *
 * @returns Hex color string.
 */


function HSVToHex(h, s, v) {
  var rgb = HSVToRGB(h, s, v);
  return RGBToHex(rgb.r, rgb.g, rgb.b);
}
/**
 * Convert hex color string into HSV \<0, 1\>.
 *
 * @param hex - Hex color string.
 *
 * @returns HSV color object.
 */


function hexToHSV(hex) {
  var rgb = hexToRGB(hex);

  if (!rgb) {
    throw new TypeError("'".concat(hex, "' is not a valid color."));
  }

  return RGBToHSV(rgb.r, rgb.g, rgb.b);
}
/**
 * Validate hex color string.
 *
 * @param hex - Unknown string that may contain a color.
 *
 * @returns True if the string is valid, false otherwise.
 */


function isValidHex(hex) {
  var isOk = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
  return isOk;
}
/**
 * Validate RGB color string.
 *
 * @param rgb - Unknown string that may contain a color.
 *
 * @returns True if the string is valid, false otherwise.
 */


function isValidRGB(rgb) {
  return rgbRE.test(rgb);
}
/**
 * Validate RGBA color string.
 *
 * @param rgba - Unknown string that may contain a color.
 *
 * @returns True if the string is valid, false otherwise.
 */


function isValidRGBA(rgba) {
  return rgbaRE.test(rgba);
}
/**
 * This recursively redirects the prototype of JSON objects to the referenceObject.
 * This is used for default options.
 *
 * @param referenceObject - The original object.
 *
 * @returns The Element if the referenceObject is an Element, or a new object inheriting from the referenceObject.
 */


function bridgeObject(referenceObject) {
  if (referenceObject === null || _typeof(referenceObject) !== "object") {
    return null;
  }

  if (referenceObject instanceof Element) {
    // Avoid bridging DOM objects
    return referenceObject;
  }

  var objectTo = create$4(referenceObject);

  for (var i in referenceObject) {
    if (Object.prototype.hasOwnProperty.call(referenceObject, i)) {
      if (_typeof(referenceObject[i]) == "object") {
        objectTo[i] = bridgeObject(referenceObject[i]);
      }
    }
  }

  return objectTo;
}
/**
 * This is used to set the options of subobjects in the options object.
 *
 * A requirement of these subobjects is that they have an 'enabled' element
 * which is optional for the user but mandatory for the program.
 *
 * The added value here of the merge is that option 'enabled' is set as required.
 *
 * @param mergeTarget - Either this.options or the options used for the groups.
 * @param options - Options.
 * @param option - Option key in the options argument.
 * @param globalOptions - Global options, passed in to determine value of option 'enabled'.
 */


function mergeOptions(mergeTarget, options, option) {
  var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

  // Local helpers
  var isPresent = function isPresent(obj) {
    return obj !== null && obj !== undefined;
  };

  var isObject = function isObject(obj) {
    return obj !== null && _typeof(obj) === "object";
  }; // https://stackoverflow.com/a/34491287/1223531


  var isEmpty = function isEmpty(obj) {
    for (var x in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, x)) {
        return false;
      }
    }

    return true;
  }; // Guards


  if (!isObject(mergeTarget)) {
    throw new Error("Parameter mergeTarget must be an object");
  }

  if (!isObject(options)) {
    throw new Error("Parameter options must be an object");
  }

  if (!isPresent(option)) {
    throw new Error("Parameter option must have a value");
  }

  if (!isObject(globalOptions)) {
    throw new Error("Parameter globalOptions must be an object");
  } //
  // Actual merge routine, separated from main logic
  // Only a single level of options is merged. Deeper levels are ref'd. This may actually be an issue.
  //


  var doMerge = function doMerge(target, options, option) {
    if (!isObject(target[option])) {
      target[option] = {};
    }

    var src = options[option];
    var dst = target[option];

    for (var prop in src) {
      if (Object.prototype.hasOwnProperty.call(src, prop)) {
        dst[prop] = src[prop];
      }
    }
  }; // Local initialization


  var srcOption = options[option];
  var globalPassed = isObject(globalOptions) && !isEmpty(globalOptions);
  var globalOption = globalPassed ? globalOptions[option] : undefined;
  var globalEnabled = globalOption ? globalOption.enabled : undefined; /////////////////////////////////////////
  // Main routine
  /////////////////////////////////////////

  if (srcOption === undefined) {
    return; // Nothing to do
  }

  if (typeof srcOption === "boolean") {
    if (!isObject(mergeTarget[option])) {
      mergeTarget[option] = {};
    }

    mergeTarget[option].enabled = srcOption;
    return;
  }

  if (srcOption === null && !isObject(mergeTarget[option])) {
    // If possible, explicit copy from globals
    if (isPresent(globalOption)) {
      mergeTarget[option] = create$4(globalOption);
    } else {
      return; // Nothing to do
    }
  }

  if (!isObject(srcOption)) {
    return;
  } //
  // Ensure that 'enabled' is properly set. It is required internally
  // Note that the value from options will always overwrite the existing value
  //


  var enabled = true; // default value

  if (srcOption.enabled !== undefined) {
    enabled = srcOption.enabled;
  } else {
    // Take from globals, if present
    if (globalEnabled !== undefined) {
      enabled = globalOption.enabled;
    }
  }

  doMerge(mergeTarget, options, option);
  mergeTarget[option].enabled = enabled;
}
/*
 * Easing Functions.
 * Only considering the t value for the range [0, 1] => [0, 1].
 *
 * Inspiration: from http://gizma.com/easing/
 * https://gist.github.com/gre/1650294
 */


var easingFunctions = {
  /**
   * Provides no easing and no acceleration.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  linear: function linear(t) {
    return t;
  },

  /**
   * Accelerate from zero velocity.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeInQuad: function easeInQuad(t) {
    return t * t;
  },

  /**
   * Decelerate to zero velocity.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeOutQuad: function easeOutQuad(t) {
    return t * (2 - t);
  },

  /**
   * Accelerate until halfway, then decelerate.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeInOutQuad: function easeInOutQuad(t) {
    return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
  },

  /**
   * Accelerate from zero velocity.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeInCubic: function easeInCubic(t) {
    return t * t * t;
  },

  /**
   * Decelerate to zero velocity.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeOutCubic: function easeOutCubic(t) {
    return --t * t * t + 1;
  },

  /**
   * Accelerate until halfway, then decelerate.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeInOutCubic: function easeInOutCubic(t) {
    return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
  },

  /**
   * Accelerate from zero velocity.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeInQuart: function easeInQuart(t) {
    return t * t * t * t;
  },

  /**
   * Decelerate to zero velocity.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeOutQuart: function easeOutQuart(t) {
    return 1 - --t * t * t * t;
  },

  /**
   * Accelerate until halfway, then decelerate.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeInOutQuart: function easeInOutQuart(t) {
    return t < 0.5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t;
  },

  /**
   * Accelerate from zero velocity.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeInQuint: function easeInQuint(t) {
    return t * t * t * t * t;
  },

  /**
   * Decelerate to zero velocity.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeOutQuint: function easeOutQuint(t) {
    return 1 + --t * t * t * t * t;
  },

  /**
   * Accelerate until halfway, then decelerate.
   *
   * @param t - Time.
   *
   * @returns Value at time t.
   */
  easeInOutQuint: function easeInOutQuint(t) {
    return t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t;
  }
};
// It works only for single property objects,
// otherwise it combines all of the types in a union.
// export function topMost<K1 extends string, V1> (
//   pile: Record<K1, undefined | V1>[],
//   accessors: K1 | [K1]
// ): undefined | V1
// export function topMost<K1 extends string, K2 extends string, V1, V2> (
//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2>>[],
//   accessors: [K1, K2]
// ): undefined | V1 | V2
// export function topMost<K1 extends string, K2 extends string, K3 extends string, V1, V2, V3> (
//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2 | Record<K3, undefined | V3>>>[],
//   accessors: [K1, K2, K3]
// ): undefined | V1 | V2 | V3

/**
 * Get the top most property value from a pile of objects.
 *
 * @param pile - Array of objects, no required format.
 * @param accessors - Array of property names.
 * For example `object['foo']['bar']` → `['foo', 'bar']`.
 *
 * @returns Value of the property with given accessors path from the first pile item where it's not undefined.
 */


function topMost(pile, accessors) {
  var candidate;

  if (!isArray$2(accessors)) {
    accessors = [accessors];
  }

  var _iterator3 = _createForOfIteratorHelper$8(pile),
      _step3;

  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var member = _step3.value;

      if (member) {
        candidate = member[accessors[0]];

        for (var i = 1; i < accessors.length; i++) {
          if (candidate) {
            candidate = candidate[accessors[i]];
          }
        }

        if (typeof candidate !== "undefined") {
          break;
        }
      }
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }

  return candidate;
}

var htmlColors = {
  black: "#000000",
  navy: "#000080",
  darkblue: "#00008B",
  mediumblue: "#0000CD",
  blue: "#0000FF",
  darkgreen: "#006400",
  green: "#008000",
  teal: "#008080",
  darkcyan: "#008B8B",
  deepskyblue: "#00BFFF",
  darkturquoise: "#00CED1",
  mediumspringgreen: "#00FA9A",
  lime: "#00FF00",
  springgreen: "#00FF7F",
  aqua: "#00FFFF",
  cyan: "#00FFFF",
  midnightblue: "#191970",
  dodgerblue: "#1E90FF",
  lightseagreen: "#20B2AA",
  forestgreen: "#228B22",
  seagreen: "#2E8B57",
  darkslategray: "#2F4F4F",
  limegreen: "#32CD32",
  mediumseagreen: "#3CB371",
  turquoise: "#40E0D0",
  royalblue: "#4169E1",
  steelblue: "#4682B4",
  darkslateblue: "#483D8B",
  mediumturquoise: "#48D1CC",
  indigo: "#4B0082",
  darkolivegreen: "#556B2F",
  cadetblue: "#5F9EA0",
  cornflowerblue: "#6495ED",
  mediumaquamarine: "#66CDAA",
  dimgray: "#696969",
  slateblue: "#6A5ACD",
  olivedrab: "#6B8E23",
  slategray: "#708090",
  lightslategray: "#778899",
  mediumslateblue: "#7B68EE",
  lawngreen: "#7CFC00",
  chartreuse: "#7FFF00",
  aquamarine: "#7FFFD4",
  maroon: "#800000",
  purple: "#800080",
  olive: "#808000",
  gray: "#808080",
  skyblue: "#87CEEB",
  lightskyblue: "#87CEFA",
  blueviolet: "#8A2BE2",
  darkred: "#8B0000",
  darkmagenta: "#8B008B",
  saddlebrown: "#8B4513",
  darkseagreen: "#8FBC8F",
  lightgreen: "#90EE90",
  mediumpurple: "#9370D8",
  darkviolet: "#9400D3",
  palegreen: "#98FB98",
  darkorchid: "#9932CC",
  yellowgreen: "#9ACD32",
  sienna: "#A0522D",
  brown: "#A52A2A",
  darkgray: "#A9A9A9",
  lightblue: "#ADD8E6",
  greenyellow: "#ADFF2F",
  paleturquoise: "#AFEEEE",
  lightsteelblue: "#B0C4DE",
  powderblue: "#B0E0E6",
  firebrick: "#B22222",
  darkgoldenrod: "#B8860B",
  mediumorchid: "#BA55D3",
  rosybrown: "#BC8F8F",
  darkkhaki: "#BDB76B",
  silver: "#C0C0C0",
  mediumvioletred: "#C71585",
  indianred: "#CD5C5C",
  peru: "#CD853F",
  chocolate: "#D2691E",
  tan: "#D2B48C",
  lightgrey: "#D3D3D3",
  palevioletred: "#D87093",
  thistle: "#D8BFD8",
  orchid: "#DA70D6",
  goldenrod: "#DAA520",
  crimson: "#DC143C",
  gainsboro: "#DCDCDC",
  plum: "#DDA0DD",
  burlywood: "#DEB887",
  lightcyan: "#E0FFFF",
  lavender: "#E6E6FA",
  darksalmon: "#E9967A",
  violet: "#EE82EE",
  palegoldenrod: "#EEE8AA",
  lightcoral: "#F08080",
  khaki: "#F0E68C",
  aliceblue: "#F0F8FF",
  honeydew: "#F0FFF0",
  azure: "#F0FFFF",
  sandybrown: "#F4A460",
  wheat: "#F5DEB3",
  beige: "#F5F5DC",
  whitesmoke: "#F5F5F5",
  mintcream: "#F5FFFA",
  ghostwhite: "#F8F8FF",
  salmon: "#FA8072",
  antiquewhite: "#FAEBD7",
  linen: "#FAF0E6",
  lightgoldenrodyellow: "#FAFAD2",
  oldlace: "#FDF5E6",
  red: "#FF0000",
  fuchsia: "#FF00FF",
  magenta: "#FF00FF",
  deeppink: "#FF1493",
  orangered: "#FF4500",
  tomato: "#FF6347",
  hotpink: "#FF69B4",
  coral: "#FF7F50",
  darkorange: "#FF8C00",
  lightsalmon: "#FFA07A",
  orange: "#FFA500",
  lightpink: "#FFB6C1",
  pink: "#FFC0CB",
  gold: "#FFD700",
  peachpuff: "#FFDAB9",
  navajowhite: "#FFDEAD",
  moccasin: "#FFE4B5",
  bisque: "#FFE4C4",
  mistyrose: "#FFE4E1",
  blanchedalmond: "#FFEBCD",
  papayawhip: "#FFEFD5",
  lavenderblush: "#FFF0F5",
  seashell: "#FFF5EE",
  cornsilk: "#FFF8DC",
  lemonchiffon: "#FFFACD",
  floralwhite: "#FFFAF0",
  snow: "#FFFAFA",
  yellow: "#FFFF00",
  lightyellow: "#FFFFE0",
  ivory: "#FFFFF0",
  white: "#FFFFFF"
};
/**
 * @param {number} [pixelRatio=1]
 */

var ColorPicker = /*#__PURE__*/function () {
  /**
   * @param {number} [pixelRatio=1]
   */
  function ColorPicker() {
    var pixelRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

    _classCallCheck(this, ColorPicker);

    this.pixelRatio = pixelRatio;
    this.generated = false;
    this.centerCoordinates = {
      x: 289 / 2,
      y: 289 / 2
    };
    this.r = 289 * 0.49;
    this.color = {
      r: 255,
      g: 255,
      b: 255,
      a: 1.0
    };
    this.hueCircle = undefined;
    this.initialColor = {
      r: 255,
      g: 255,
      b: 255,
      a: 1.0
    };
    this.previousColor = undefined;
    this.applied = false; // bound by

    this.updateCallback = function () {};

    this.closeCallback = function () {}; // create all DOM elements


    this._create();
  }
  /**
   * this inserts the colorPicker into a div from the DOM
   *
   * @param {Element} container
   */


  _createClass(ColorPicker, [{
    key: "insertTo",
    value: function insertTo(container) {
      if (this.hammer !== undefined) {
        this.hammer.destroy();
        this.hammer = undefined;
      }

      this.container = container;
      this.container.appendChild(this.frame);

      this._bindHammer();

      this._setSize();
    }
    /**
     * the callback is executed on apply and save. Bind it to the application
     *
     * @param {Function} callback
     */

  }, {
    key: "setUpdateCallback",
    value: function setUpdateCallback(callback) {
      if (typeof callback === "function") {
        this.updateCallback = callback;
      } else {
        throw new Error("Function attempted to set as colorPicker update callback is not a function.");
      }
    }
    /**
     * the callback is executed on apply and save. Bind it to the application
     *
     * @param {Function} callback
     */

  }, {
    key: "setCloseCallback",
    value: function setCloseCallback(callback) {
      if (typeof callback === "function") {
        this.closeCallback = callback;
      } else {
        throw new Error("Function attempted to set as colorPicker closing callback is not a function.");
      }
    }
    /**
     *
     * @param {string} color
     * @returns {string}
     * @private
     */

  }, {
    key: "_isColorString",
    value: function _isColorString(color) {
      if (typeof color === "string") {
        return htmlColors[color];
      }
    }
    /**
     * Set the color of the colorPicker
     * Supported formats:
     * 'red'                   --> HTML color string
     * '#ffffff'               --> hex string
     * 'rgb(255,255,255)'      --> rgb string
     * 'rgba(255,255,255,1.0)' --> rgba string
     * {r:255,g:255,b:255}     --> rgb object
     * {r:255,g:255,b:255,a:1.0} --> rgba object
     *
     * @param {string | object} color
     * @param {boolean} [setInitial=true]
     */

  }, {
    key: "setColor",
    value: function setColor(color) {
      var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      if (color === "none") {
        return;
      }

      var rgba; // if a html color shorthand is used, convert to hex

      var htmlColor = this._isColorString(color);

      if (htmlColor !== undefined) {
        color = htmlColor;
      } // check format


      if (isString(color) === true) {
        if (isValidRGB(color) === true) {
          var rgbaArray = color.substr(4).substr(0, color.length - 5).split(",");
          rgba = {
            r: rgbaArray[0],
            g: rgbaArray[1],
            b: rgbaArray[2],
            a: 1.0
          };
        } else if (isValidRGBA(color) === true) {
          var _rgbaArray = color.substr(5).substr(0, color.length - 6).split(",");

          rgba = {
            r: _rgbaArray[0],
            g: _rgbaArray[1],
            b: _rgbaArray[2],
            a: _rgbaArray[3]
          };
        } else if (isValidHex(color) === true) {
          var rgbObj = hexToRGB(color);
          rgba = {
            r: rgbObj.r,
            g: rgbObj.g,
            b: rgbObj.b,
            a: 1.0
          };
        }
      } else {
        if (color instanceof Object) {
          if (color.r !== undefined && color.g !== undefined && color.b !== undefined) {
            var alpha = color.a !== undefined ? color.a : "1.0";
            rgba = {
              r: color.r,
              g: color.g,
              b: color.b,
              a: alpha
            };
          }
        }
      } // set color


      if (rgba === undefined) {
        throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: " + stringify$1(color));
      } else {
        this._setColor(rgba, setInitial);
      }
    }
    /**
     * this shows the color picker.
     * The hue circle is constructed once and stored.
     */

  }, {
    key: "show",
    value: function show() {
      if (this.closeCallback !== undefined) {
        this.closeCallback();
        this.closeCallback = undefined;
      }

      this.applied = false;
      this.frame.style.display = "block";

      this._generateHueCircle();
    } // ------------------------------------------ PRIVATE ----------------------------- //

    /**
     * Hide the picker. Is called by the cancel button.
     * Optional boolean to store the previous color for easy access later on.
     *
     * @param {boolean} [storePrevious=true]
     * @private
     */

  }, {
    key: "_hide",
    value: function _hide() {
      var _this2 = this;

      var storePrevious = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      // store the previous color for next time;
      if (storePrevious === true) {
        this.previousColor = assign$2({}, this.color);
      }

      if (this.applied === true) {
        this.updateCallback(this.initialColor);
      }

      this.frame.style.display = "none"; // call the closing callback, restoring the onclick method.
      // this is in a setTimeout because it will trigger the show again before the click is done.

      setTimeout$1(function () {
        if (_this2.closeCallback !== undefined) {
          _this2.closeCallback();

          _this2.closeCallback = undefined;
        }
      }, 0);
    }
    /**
     * bound to the save button. Saves and hides.
     *
     * @private
     */

  }, {
    key: "_save",
    value: function _save() {
      this.updateCallback(this.color);
      this.applied = false;

      this._hide();
    }
    /**
     * Bound to apply button. Saves but does not close. Is undone by the cancel button.
     *
     * @private
     */

  }, {
    key: "_apply",
    value: function _apply() {
      this.applied = true;
      this.updateCallback(this.color);

      this._updatePicker(this.color);
    }
    /**
     * load the color from the previous session.
     *
     * @private
     */

  }, {
    key: "_loadLast",
    value: function _loadLast() {
      if (this.previousColor !== undefined) {
        this.setColor(this.previousColor, false);
      } else {
        alert("There is no last color to load...");
      }
    }
    /**
     * set the color, place the picker
     *
     * @param {object} rgba
     * @param {boolean} [setInitial=true]
     * @private
     */

  }, {
    key: "_setColor",
    value: function _setColor(rgba) {
      var setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      // store the initial color
      if (setInitial === true) {
        this.initialColor = assign$2({}, rgba);
      }

      this.color = rgba;
      var hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
      var angleConvert = 2 * Math.PI;
      var radius = this.r * hsv.s;
      var x = this.centerCoordinates.x + radius * Math.sin(angleConvert * hsv.h);
      var y = this.centerCoordinates.y + radius * Math.cos(angleConvert * hsv.h);
      this.colorPickerSelector.style.left = x - 0.5 * this.colorPickerSelector.clientWidth + "px";
      this.colorPickerSelector.style.top = y - 0.5 * this.colorPickerSelector.clientHeight + "px";

      this._updatePicker(rgba);
    }
    /**
     * bound to opacity control
     *
     * @param {number} value
     * @private
     */

  }, {
    key: "_setOpacity",
    value: function _setOpacity(value) {
      this.color.a = value / 100;

      this._updatePicker(this.color);
    }
    /**
     * bound to brightness control
     *
     * @param {number} value
     * @private
     */

  }, {
    key: "_setBrightness",
    value: function _setBrightness(value) {
      var hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
      hsv.v = value / 100;
      var rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
      rgba["a"] = this.color.a;
      this.color = rgba;

      this._updatePicker();
    }
    /**
     * update the color picker. A black circle overlays the hue circle to mimic the brightness decreasing.
     *
     * @param {object} rgba
     * @private
     */

  }, {
    key: "_updatePicker",
    value: function _updatePicker() {
      var rgba = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.color;
      var hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
      var ctx = this.colorPickerCanvas.getContext("2d");

      if (this.pixelRation === undefined) {
        this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
      }

      ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0); // clear the canvas

      var w = this.colorPickerCanvas.clientWidth;
      var h = this.colorPickerCanvas.clientHeight;
      ctx.clearRect(0, 0, w, h);
      ctx.putImageData(this.hueCircle, 0, 0);
      ctx.fillStyle = "rgba(0,0,0," + (1 - hsv.v) + ")";
      ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);

      fill(ctx).call(ctx);

      this.brightnessRange.value = 100 * hsv.v;
      this.opacityRange.value = 100 * rgba.a;
      this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
      this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
    }
    /**
     * used by create to set the size of the canvas.
     *
     * @private
     */

  }, {
    key: "_setSize",
    value: function _setSize() {
      this.colorPickerCanvas.style.width = "100%";
      this.colorPickerCanvas.style.height = "100%";
      this.colorPickerCanvas.width = 289 * this.pixelRatio;
      this.colorPickerCanvas.height = 289 * this.pixelRatio;
    }
    /**
     * create all dom elements
     * TODO: cleanup, lots of similar dom elements
     *
     * @private
     */

  }, {
    key: "_create",
    value: function _create() {
      var _context16, _context17, _context18, _context19;

      this.frame = document.createElement("div");
      this.frame.className = "vis-color-picker";
      this.colorPickerDiv = document.createElement("div");
      this.colorPickerSelector = document.createElement("div");
      this.colorPickerSelector.className = "vis-selector";
      this.colorPickerDiv.appendChild(this.colorPickerSelector);
      this.colorPickerCanvas = document.createElement("canvas");
      this.colorPickerDiv.appendChild(this.colorPickerCanvas);

      if (!this.colorPickerCanvas.getContext) {
        var noCanvas = document.createElement("DIV");
        noCanvas.style.color = "red";
        noCanvas.style.fontWeight = "bold";
        noCanvas.style.padding = "10px";
        noCanvas.innerText = "Error: your browser does not support HTML canvas";
        this.colorPickerCanvas.appendChild(noCanvas);
      } else {
        var ctx = this.colorPickerCanvas.getContext("2d");
        this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
        this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);
      }

      this.colorPickerDiv.className = "vis-color";
      this.opacityDiv = document.createElement("div");
      this.opacityDiv.className = "vis-opacity";
      this.brightnessDiv = document.createElement("div");
      this.brightnessDiv.className = "vis-brightness";
      this.arrowDiv = document.createElement("div");
      this.arrowDiv.className = "vis-arrow";
      this.opacityRange = document.createElement("input");

      try {
        this.opacityRange.type = "range"; // Not supported on IE9

        this.opacityRange.min = "0";
        this.opacityRange.max = "100";
      } catch (err) {// TODO: Add some error handling.
      }

      this.opacityRange.value = "100";
      this.opacityRange.className = "vis-range";
      this.brightnessRange = document.createElement("input");

      try {
        this.brightnessRange.type = "range"; // Not supported on IE9

        this.brightnessRange.min = "0";
        this.brightnessRange.max = "100";
      } catch (err) {// TODO: Add some error handling.
      }

      this.brightnessRange.value = "100";
      this.brightnessRange.className = "vis-range";
      this.opacityDiv.appendChild(this.opacityRange);
      this.brightnessDiv.appendChild(this.brightnessRange);
      var me = this;

      this.opacityRange.onchange = function () {
        me._setOpacity(this.value);
      };

      this.opacityRange.oninput = function () {
        me._setOpacity(this.value);
      };

      this.brightnessRange.onchange = function () {
        me._setBrightness(this.value);
      };

      this.brightnessRange.oninput = function () {
        me._setBrightness(this.value);
      };

      this.brightnessLabel = document.createElement("div");
      this.brightnessLabel.className = "vis-label vis-brightness";
      this.brightnessLabel.innerText = "brightness:";
      this.opacityLabel = document.createElement("div");
      this.opacityLabel.className = "vis-label vis-opacity";
      this.opacityLabel.innerText = "opacity:";
      this.newColorDiv = document.createElement("div");
      this.newColorDiv.className = "vis-new-color";
      this.newColorDiv.innerText = "new";
      this.initialColorDiv = document.createElement("div");
      this.initialColorDiv.className = "vis-initial-color";
      this.initialColorDiv.innerText = "initial";
      this.cancelButton = document.createElement("div");
      this.cancelButton.className = "vis-button vis-cancel";
      this.cancelButton.innerText = "cancel";
      this.cancelButton.onclick = bind$6(_context16 = this._hide).call(_context16, this, false);
      this.applyButton = document.createElement("div");
      this.applyButton.className = "vis-button vis-apply";
      this.applyButton.innerText = "apply";
      this.applyButton.onclick = bind$6(_context17 = this._apply).call(_context17, this);
      this.saveButton = document.createElement("div");
      this.saveButton.className = "vis-button vis-save";
      this.saveButton.innerText = "save";
      this.saveButton.onclick = bind$6(_context18 = this._save).call(_context18, this);
      this.loadButton = document.createElement("div");
      this.loadButton.className = "vis-button vis-load";
      this.loadButton.innerText = "load last";
      this.loadButton.onclick = bind$6(_context19 = this._loadLast).call(_context19, this);
      this.frame.appendChild(this.colorPickerDiv);
      this.frame.appendChild(this.arrowDiv);
      this.frame.appendChild(this.brightnessLabel);
      this.frame.appendChild(this.brightnessDiv);
      this.frame.appendChild(this.opacityLabel);
      this.frame.appendChild(this.opacityDiv);
      this.frame.appendChild(this.newColorDiv);
      this.frame.appendChild(this.initialColorDiv);
      this.frame.appendChild(this.cancelButton);
      this.frame.appendChild(this.applyButton);
      this.frame.appendChild(this.saveButton);
      this.frame.appendChild(this.loadButton);
    }
    /**
     * bind hammer to the color picker
     *
     * @private
     */

  }, {
    key: "_bindHammer",
    value: function _bindHammer() {
      var _this3 = this;

      this.drag = {};
      this.pinch = {};
      this.hammer = new Hammer(this.colorPickerCanvas);
      this.hammer.get("pinch").set({
        enable: true
      });
      this.hammer.on("hammer.input", function (event) {
        if (event.isFirst) {
          _this3._moveSelector(event);
        }
      });
      this.hammer.on("tap", function (event) {
        _this3._moveSelector(event);
      });
      this.hammer.on("panstart", function (event) {
        _this3._moveSelector(event);
      });
      this.hammer.on("panmove", function (event) {
        _this3._moveSelector(event);
      });
      this.hammer.on("panend", function (event) {
        _this3._moveSelector(event);
      });
    }
    /**
     * generate the hue circle. This is relatively heavy (200ms) and is done only once on the first time it is shown.
     *
     * @private
     */

  }, {
    key: "_generateHueCircle",
    value: function _generateHueCircle() {
      if (this.generated === false) {
        var ctx = this.colorPickerCanvas.getContext("2d");

        if (this.pixelRation === undefined) {
          this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
        }

        ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0); // clear the canvas

        var w = this.colorPickerCanvas.clientWidth;
        var h = this.colorPickerCanvas.clientHeight;
        ctx.clearRect(0, 0, w, h); // draw hue circle

        var x, y, hue, sat;
        this.centerCoordinates = {
          x: w * 0.5,
          y: h * 0.5
        };
        this.r = 0.49 * w;
        var angleConvert = 2 * Math.PI / 360;
        var hfac = 1 / 360;
        var sfac = 1 / this.r;
        var rgb;

        for (hue = 0; hue < 360; hue++) {
          for (sat = 0; sat < this.r; sat++) {
            x = this.centerCoordinates.x + sat * Math.sin(angleConvert * hue);
            y = this.centerCoordinates.y + sat * Math.cos(angleConvert * hue);
            rgb = HSVToRGB(hue * hfac, sat * sfac, 1);
            ctx.fillStyle = "rgb(" + rgb.r + "," + rgb.g + "," + rgb.b + ")";
            ctx.fillRect(x - 0.5, y - 0.5, 2, 2);
          }
        }

        ctx.strokeStyle = "rgba(0,0,0,1)";
        ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
        ctx.stroke();
        this.hueCircle = ctx.getImageData(0, 0, w, h);
      }

      this.generated = true;
    }
    /**
     * move the selector. This is called by hammer functions.
     *
     * @param {Event}  event   The event
     * @private
     */

  }, {
    key: "_moveSelector",
    value: function _moveSelector(event) {
      var rect = this.colorPickerDiv.getBoundingClientRect();
      var left = event.center.x - rect.left;
      var top = event.center.y - rect.top;
      var centerY = 0.5 * this.colorPickerDiv.clientHeight;
      var centerX = 0.5 * this.colorPickerDiv.clientWidth;
      var x = left - centerX;
      var y = top - centerY;
      var angle = Math.atan2(x, y);
      var radius = 0.98 * Math.min(Math.sqrt(x * x + y * y), centerX);
      var newTop = Math.cos(angle) * radius + centerY;
      var newLeft = Math.sin(angle) * radius + centerX;
      this.colorPickerSelector.style.top = newTop - 0.5 * this.colorPickerSelector.clientHeight + "px";
      this.colorPickerSelector.style.left = newLeft - 0.5 * this.colorPickerSelector.clientWidth + "px"; // set color

      var h = angle / (2 * Math.PI);
      h = h < 0 ? h + 1 : h;
      var s = radius / this.r;
      var hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
      hsv.h = h;
      hsv.s = s;
      var rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
      rgba["a"] = this.color.a;
      this.color = rgba; // update previews

      this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
      this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
    }
  }]);

  return ColorPicker;
}();
/**
 * Wrap given text (last argument) in HTML elements (all preceding arguments).
 *
 * @param {...any} rest - List of tag names followed by inner text.
 *
 * @returns An element or a text node.
 */


function wrapInTag() {
  for (var _len5 = arguments.length, rest = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
    rest[_key5] = arguments[_key5];
  }

  if (rest.length < 1) {
    throw new TypeError("Invalid arguments.");
  } else if (rest.length === 1) {
    return document.createTextNode(rest[0]);
  } else {
    var element = document.createElement(rest[0]);
    element.appendChild(wrapInTag.apply(void 0, _toConsumableArray(slice$1(rest).call(rest, 1))));
    return element;
  }
}
/**
 * The way this works is for all properties of this.possible options, you can supply the property name in any form to list the options.
 * Boolean options are recognised as Boolean
 * Number options should be written as array: [default value, min value, max value, stepsize]
 * Colors should be written as array: ['color', '#ffffff']
 * Strings with should be written as array: [option1, option2, option3, ..]
 *
 * The options are matched with their counterparts in each of the modules and the values used in the configuration are
 */


var Configurator = /*#__PURE__*/function () {
  /**
   * @param {object} parentModule        | the location where parentModule.setOptions() can be called
   * @param {object} defaultContainer    | the default container of the module
   * @param {object} configureOptions    | the fully configured and predefined options set found in allOptions.js
   * @param {number} pixelRatio          | canvas pixel ratio
   * @param {Function} hideOption        | custom logic to dynamically hide options
   */
  function Configurator(parentModule, defaultContainer, configureOptions) {
    var pixelRatio = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
    var hideOption = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : function () {
      return false;
    };

    _classCallCheck(this, Configurator);

    this.parent = parentModule;
    this.changedOptions = [];
    this.container = defaultContainer;
    this.allowCreation = false;
    this.hideOption = hideOption;
    this.options = {};
    this.initialized = false;
    this.popupCounter = 0;
    this.defaultOptions = {
      enabled: false,
      filter: true,
      container: undefined,
      showButton: true
    };

    assign$2(this.options, this.defaultOptions);

    this.configureOptions = configureOptions;
    this.moduleOptions = {};
    this.domElements = [];
    this.popupDiv = {};
    this.popupLimit = 5;
    this.popupHistory = {};
    this.colorPicker = new ColorPicker(pixelRatio);
    this.wrapper = undefined;
  }
  /**
   * refresh all options.
   * Because all modules parse their options by themselves, we just use their options. We copy them here.
   *
   * @param {object} options
   */


  _createClass(Configurator, [{
    key: "setOptions",
    value: function setOptions(options) {
      if (options !== undefined) {
        // reset the popup history because the indices may have been changed.
        this.popupHistory = {};

        this._removePopup();

        var enabled = true;

        if (typeof options === "string") {
          this.options.filter = options;
        } else if (isArray$2(options)) {
          this.options.filter = options.join();
        } else if (_typeof(options) === "object") {
          if (options == null) {
            throw new TypeError("options cannot be null");
          }

          if (options.container !== undefined) {
            this.options.container = options.container;
          }

          if (filter(options) !== undefined) {
            this.options.filter = filter(options);
          }

          if (options.showButton !== undefined) {
            this.options.showButton = options.showButton;
          }

          if (options.enabled !== undefined) {
            enabled = options.enabled;
          }
        } else if (typeof options === "boolean") {
          this.options.filter = true;
          enabled = options;
        } else if (typeof options === "function") {
          this.options.filter = options;
          enabled = true;
        }

        if (filter(this.options) === false) {
          enabled = false;
        }

        this.options.enabled = enabled;
      }

      this._clean();
    }
    /**
     *
     * @param {object} moduleOptions
     */

  }, {
    key: "setModuleOptions",
    value: function setModuleOptions(moduleOptions) {
      this.moduleOptions = moduleOptions;

      if (this.options.enabled === true) {
        this._clean();

        if (this.options.container !== undefined) {
          this.container = this.options.container;
        }

        this._create();
      }
    }
    /**
     * Create all DOM elements
     *
     * @private
     */

  }, {
    key: "_create",
    value: function _create() {
      this._clean();

      this.changedOptions = [];

      var filter$1 = filter(this.options);

      var counter = 0;
      var show = false;

      for (var _option in this.configureOptions) {
        if (Object.prototype.hasOwnProperty.call(this.configureOptions, _option)) {
          this.allowCreation = false;
          show = false;

          if (typeof filter$1 === "function") {
            show = filter$1(_option, []);
            show = show || this._handleObject(this.configureOptions[_option], [_option], true);
          } else if (filter$1 === true || indexOf(filter$1).call(filter$1, _option) !== -1) {
            show = true;
          }

          if (show !== false) {
            this.allowCreation = true; // linebreak between categories

            if (counter > 0) {
              this._makeItem([]);
            } // a header for the category


            this._makeHeader(_option); // get the sub options


            this._handleObject(this.configureOptions[_option], [_option]);
          }

          counter++;
        }
      }

      this._makeButton();

      this._push(); //~ this.colorPicker.insertTo(this.container);

    }
    /**
     * draw all DOM elements on the screen
     *
     * @private
     */

  }, {
    key: "_push",
    value: function _push() {
      this.wrapper = document.createElement("div");
      this.wrapper.className = "vis-configuration-wrapper";
      this.container.appendChild(this.wrapper);

      for (var i = 0; i < this.domElements.length; i++) {
        this.wrapper.appendChild(this.domElements[i]);
      }

      this._showPopupIfNeeded();
    }
    /**
     * delete all DOM elements
     *
     * @private
     */

  }, {
    key: "_clean",
    value: function _clean() {
      for (var i = 0; i < this.domElements.length; i++) {
        this.wrapper.removeChild(this.domElements[i]);
      }

      if (this.wrapper !== undefined) {
        this.container.removeChild(this.wrapper);
        this.wrapper = undefined;
      }

      this.domElements = [];

      this._removePopup();
    }
    /**
     * get the value from the actualOptions if it exists
     *
     * @param {Array} path    | where to look for the actual option
     * @returns {*}
     * @private
     */

  }, {
    key: "_getValue",
    value: function _getValue(path) {
      var base = this.moduleOptions;

      for (var i = 0; i < path.length; i++) {
        if (base[path[i]] !== undefined) {
          base = base[path[i]];
        } else {
          base = undefined;
          break;
        }
      }

      return base;
    }
    /**
     * all option elements are wrapped in an item
     *
     * @param {Array} path    | where to look for the actual option
     * @param {Array.<Element>} domElements
     * @returns {number}
     * @private
     */

  }, {
    key: "_makeItem",
    value: function _makeItem(path) {
      if (this.allowCreation === true) {
        var item = document.createElement("div");
        item.className = "vis-configuration vis-config-item vis-config-s" + path.length;

        for (var _len6 = arguments.length, domElements = new Array(_len6 > 1 ? _len6 - 1 : 0), _key6 = 1; _key6 < _len6; _key6++) {
          domElements[_key6 - 1] = arguments[_key6];
        }

        forEach$2(domElements).call(domElements, function (element) {
          item.appendChild(element);
        });

        this.domElements.push(item);
        return this.domElements.length;
      }

      return 0;
    }
    /**
     * header for major subjects
     *
     * @param {string} name
     * @private
     */

  }, {
    key: "_makeHeader",
    value: function _makeHeader(name) {
      var div = document.createElement("div");
      div.className = "vis-configuration vis-config-header";
      div.innerText = name;

      this._makeItem([], div);
    }
    /**
     * make a label, if it is an object label, it gets different styling.
     *
     * @param {string} name
     * @param {Array} path    | where to look for the actual option
     * @param {string} objectLabel
     * @returns {HTMLElement}
     * @private
     */

  }, {
    key: "_makeLabel",
    value: function _makeLabel(name, path) {
      var objectLabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var div = document.createElement("div");
      div.className = "vis-configuration vis-config-label vis-config-s" + path.length;

      if (objectLabel === true) {
        while (div.firstChild) {
          div.removeChild(div.firstChild);
        }

        div.appendChild(wrapInTag("i", "b", name));
      } else {
        div.innerText = name + ":";
      }

      return div;
    }
    /**
     * make a dropdown list for multiple possible string optoins
     *
     * @param {Array.<number>} arr
     * @param {number} value
     * @param {Array} path    | where to look for the actual option
     * @private
     */

  }, {
    key: "_makeDropdown",
    value: function _makeDropdown(arr, value, path) {
      var select = document.createElement("select");
      select.className = "vis-configuration vis-config-select";
      var selectedValue = 0;

      if (value !== undefined) {
        if (indexOf(arr).call(arr, value) !== -1) {
          selectedValue = indexOf(arr).call(arr, value);
        }
      }

      for (var i = 0; i < arr.length; i++) {
        var _option2 = document.createElement("option");

        _option2.value = arr[i];

        if (i === selectedValue) {
          _option2.selected = "selected";
        }

        _option2.innerText = arr[i];
        select.appendChild(_option2);
      }

      var me = this;

      select.onchange = function () {
        me._update(this.value, path);
      };

      var label = this._makeLabel(path[path.length - 1], path);

      this._makeItem(path, label, select);
    }
    /**
     * make a range object for numeric options
     *
     * @param {Array.<number>} arr
     * @param {number} value
     * @param {Array} path    | where to look for the actual option
     * @private
     */

  }, {
    key: "_makeRange",
    value: function _makeRange(arr, value, path) {
      var defaultValue = arr[0];
      var min = arr[1];
      var max = arr[2];
      var step = arr[3];
      var range = document.createElement("input");
      range.className = "vis-configuration vis-config-range";

      try {
        range.type = "range"; // not supported on IE9

        range.min = min;
        range.max = max;
      } catch (err) {// TODO: Add some error handling.
      }

      range.step = step; // set up the popup settings in case they are needed.

      var popupString = "";
      var popupValue = 0;

      if (value !== undefined) {
        var factor = 1.2;

        if (value < 0 && value * factor < min) {
          range.min = Math.ceil(value * factor);
          popupValue = range.min;
          popupString = "range increased";
        } else if (value / factor < min) {
          range.min = Math.ceil(value / factor);
          popupValue = range.min;
          popupString = "range increased";
        }

        if (value * factor > max && max !== 1) {
          range.max = Math.ceil(value * factor);
          popupValue = range.max;
          popupString = "range increased";
        }

        range.value = value;
      } else {
        range.value = defaultValue;
      }

      var input = document.createElement("input");
      input.className = "vis-configuration vis-config-rangeinput";
      input.value = range.value;
      var me = this;

      range.onchange = function () {
        input.value = this.value;

        me._update(Number(this.value), path);
      };

      range.oninput = function () {
        input.value = this.value;
      };

      var label = this._makeLabel(path[path.length - 1], path);

      var itemIndex = this._makeItem(path, label, range, input); // if a popup is needed AND it has not been shown for this value, show it.


      if (popupString !== "" && this.popupHistory[itemIndex] !== popupValue) {
        this.popupHistory[itemIndex] = popupValue;

        this._setupPopup(popupString, itemIndex);
      }
    }
    /**
     * make a button object
     *
     * @private
     */

  }, {
    key: "_makeButton",
    value: function _makeButton() {
      var _this4 = this;

      if (this.options.showButton === true) {
        var generateButton = document.createElement("div");
        generateButton.className = "vis-configuration vis-config-button";
        generateButton.innerText = "generate options";

        generateButton.onclick = function () {
          _this4._printOptions();
        };

        generateButton.onmouseover = function () {
          generateButton.className = "vis-configuration vis-config-button hover";
        };

        generateButton.onmouseout = function () {
          generateButton.className = "vis-configuration vis-config-button";
        };

        this.optionsContainer = document.createElement("div");
        this.optionsContainer.className = "vis-configuration vis-config-option-container";
        this.domElements.push(this.optionsContainer);
        this.domElements.push(generateButton);
      }
    }
    /**
     * prepare the popup
     *
     * @param {string} string
     * @param {number} index
     * @private
     */

  }, {
    key: "_setupPopup",
    value: function _setupPopup(string, index) {
      var _this5 = this;

      if (this.initialized === true && this.allowCreation === true && this.popupCounter < this.popupLimit) {
        var div = document.createElement("div");
        div.id = "vis-configuration-popup";
        div.className = "vis-configuration-popup";
        div.innerText = string;

        div.onclick = function () {
          _this5._removePopup();
        };

        this.popupCounter += 1;
        this.popupDiv = {
          html: div,
          index: index
        };
      }
    }
    /**
     * remove the popup from the dom
     *
     * @private
     */

  }, {
    key: "_removePopup",
    value: function _removePopup() {
      if (this.popupDiv.html !== undefined) {
        this.popupDiv.html.parentNode.removeChild(this.popupDiv.html);
        clearTimeout(this.popupDiv.hideTimeout);
        clearTimeout(this.popupDiv.deleteTimeout);
        this.popupDiv = {};
      }
    }
    /**
     * Show the popup if it is needed.
     *
     * @private
     */

  }, {
    key: "_showPopupIfNeeded",
    value: function _showPopupIfNeeded() {
      var _this6 = this;

      if (this.popupDiv.html !== undefined) {
        var correspondingElement = this.domElements[this.popupDiv.index];
        var rect = correspondingElement.getBoundingClientRect();
        this.popupDiv.html.style.left = rect.left + "px";
        this.popupDiv.html.style.top = rect.top - 30 + "px"; // 30 is the height;

        document.body.appendChild(this.popupDiv.html);
        this.popupDiv.hideTimeout = setTimeout$1(function () {
          _this6.popupDiv.html.style.opacity = 0;
        }, 1500);
        this.popupDiv.deleteTimeout = setTimeout$1(function () {
          _this6._removePopup();
        }, 1800);
      }
    }
    /**
     * make a checkbox for boolean options.
     *
     * @param {number} defaultValue
     * @param {number} value
     * @param {Array} path    | where to look for the actual option
     * @private
     */

  }, {
    key: "_makeCheckbox",
    value: function _makeCheckbox(defaultValue, value, path) {
      var checkbox = document.createElement("input");
      checkbox.type = "checkbox";
      checkbox.className = "vis-configuration vis-config-checkbox";
      checkbox.checked = defaultValue;

      if (value !== undefined) {
        checkbox.checked = value;

        if (value !== defaultValue) {
          if (_typeof(defaultValue) === "object") {
            if (value !== defaultValue.enabled) {
              this.changedOptions.push({
                path: path,
                value: value
              });
            }
          } else {
            this.changedOptions.push({
              path: path,
              value: value
            });
          }
        }
      }

      var me = this;

      checkbox.onchange = function () {
        me._update(this.checked, path);
      };

      var label = this._makeLabel(path[path.length - 1], path);

      this._makeItem(path, label, checkbox);
    }
    /**
     * make a text input field for string options.
     *
     * @param {number} defaultValue
     * @param {number} value
     * @param {Array} path    | where to look for the actual option
     * @private
     */

  }, {
    key: "_makeTextInput",
    value: function _makeTextInput(defaultValue, value, path) {
      var checkbox = document.createElement("input");
      checkbox.type = "text";
      checkbox.className = "vis-configuration vis-config-text";
      checkbox.value = value;

      if (value !== defaultValue) {
        this.changedOptions.push({
          path: path,
          value: value
        });
      }

      var me = this;

      checkbox.onchange = function () {
        me._update(this.value, path);
      };

      var label = this._makeLabel(path[path.length - 1], path);

      this._makeItem(path, label, checkbox);
    }
    /**
     * make a color field with a color picker for color fields
     *
     * @param {Array.<number>} arr
     * @param {number} value
     * @param {Array} path    | where to look for the actual option
     * @private
     */

  }, {
    key: "_makeColorField",
    value: function _makeColorField(arr, value, path) {
      var _this7 = this;

      var defaultColor = arr[1];
      var div = document.createElement("div");
      value = value === undefined ? defaultColor : value;

      if (value !== "none") {
        div.className = "vis-configuration vis-config-colorBlock";
        div.style.backgroundColor = value;
      } else {
        div.className = "vis-configuration vis-config-colorBlock none";
      }

      value = value === undefined ? defaultColor : value;

      div.onclick = function () {
        _this7._showColorPicker(value, div, path);
      };

      var label = this._makeLabel(path[path.length - 1], path);

      this._makeItem(path, label, div);
    }
    /**
     * used by the color buttons to call the color picker.
     *
     * @param {number} value
     * @param {HTMLElement} div
     * @param {Array} path    | where to look for the actual option
     * @private
     */

  }, {
    key: "_showColorPicker",
    value: function _showColorPicker(value, div, path) {
      var _this8 = this;

      // clear the callback from this div
      div.onclick = function () {};

      this.colorPicker.insertTo(div);
      this.colorPicker.show();
      this.colorPicker.setColor(value);
      this.colorPicker.setUpdateCallback(function (color) {
        var colorString = "rgba(" + color.r + "," + color.g + "," + color.b + "," + color.a + ")";
        div.style.backgroundColor = colorString;

        _this8._update(colorString, path);
      }); // on close of the colorpicker, restore the callback.

      this.colorPicker.setCloseCallback(function () {
        div.onclick = function () {
          _this8._showColorPicker(value, div, path);
        };
      });
    }
    /**
     * parse an object and draw the correct items
     *
     * @param {object} obj
     * @param {Array} [path=[]]    | where to look for the actual option
     * @param {boolean} [checkOnly=false]
     * @returns {boolean}
     * @private
     */

  }, {
    key: "_handleObject",
    value: function _handleObject(obj) {
      var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var checkOnly = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var show = false;

      var filter$1 = filter(this.options);

      var visibleInSet = false;

      for (var subObj in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, subObj)) {
          show = true;
          var item = obj[subObj];
          var newPath = copyAndExtendArray(path, subObj);

          if (typeof filter$1 === "function") {
            show = filter$1(subObj, path); // if needed we must go deeper into the object.

            if (show === false) {
              if (!isArray$2(item) && typeof item !== "string" && typeof item !== "boolean" && item instanceof Object) {
                this.allowCreation = false;
                show = this._handleObject(item, newPath, true);
                this.allowCreation = checkOnly === false;
              }
            }
          }

          if (show !== false) {
            visibleInSet = true;

            var value = this._getValue(newPath);

            if (isArray$2(item)) {
              this._handleArray(item, value, newPath);
            } else if (typeof item === "string") {
              this._makeTextInput(item, value, newPath);
            } else if (typeof item === "boolean") {
              this._makeCheckbox(item, value, newPath);
            } else if (item instanceof Object) {
              // skip the options that are not enabled
              if (!this.hideOption(path, subObj, this.moduleOptions)) {
                // initially collapse options with an disabled enabled option.
                if (item.enabled !== undefined) {
                  var enabledPath = copyAndExtendArray(newPath, "enabled");

                  var enabledValue = this._getValue(enabledPath);

                  if (enabledValue === true) {
                    var label = this._makeLabel(subObj, newPath, true);

                    this._makeItem(newPath, label);

                    visibleInSet = this._handleObject(item, newPath) || visibleInSet;
                  } else {
                    this._makeCheckbox(item, enabledValue, newPath);
                  }
                } else {
                  var _label = this._makeLabel(subObj, newPath, true);

                  this._makeItem(newPath, _label);

                  visibleInSet = this._handleObject(item, newPath) || visibleInSet;
                }
              }
            } else {
              console.error("dont know how to handle", item, subObj, newPath);
            }
          }
        }
      }

      return visibleInSet;
    }
    /**
     * handle the array type of option
     *
     * @param {Array.<number>} arr
     * @param {number} value
     * @param {Array} path    | where to look for the actual option
     * @private
     */

  }, {
    key: "_handleArray",
    value: function _handleArray(arr, value, path) {
      if (typeof arr[0] === "string" && arr[0] === "color") {
        this._makeColorField(arr, value, path);

        if (arr[1] !== value) {
          this.changedOptions.push({
            path: path,
            value: value
          });
        }
      } else if (typeof arr[0] === "string") {
        this._makeDropdown(arr, value, path);

        if (arr[0] !== value) {
          this.changedOptions.push({
            path: path,
            value: value
          });
        }
      } else if (typeof arr[0] === "number") {
        this._makeRange(arr, value, path);

        if (arr[0] !== value) {
          this.changedOptions.push({
            path: path,
            value: Number(value)
          });
        }
      }
    }
    /**
     * called to update the network with the new settings.
     *
     * @param {number} value
     * @param {Array} path    | where to look for the actual option
     * @private
     */

  }, {
    key: "_update",
    value: function _update(value, path) {
      var options = this._constructOptions(value, path);

      if (this.parent.body && this.parent.body.emitter && this.parent.body.emitter.emit) {
        this.parent.body.emitter.emit("configChange", options);
      }

      this.initialized = true;
      this.parent.setOptions(options);
    }
    /**
     *
     * @param {string | boolean} value
     * @param {Array.<string>} path
     * @param {{}} optionsObj
     * @returns {{}}
     * @private
     */

  }, {
    key: "_constructOptions",
    value: function _constructOptions(value, path) {
      var optionsObj = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var pointer = optionsObj; // when dropdown boxes can be string or boolean, we typecast it into correct types

      value = value === "true" ? true : value;
      value = value === "false" ? false : value;

      for (var i = 0; i < path.length; i++) {
        if (path[i] !== "global") {
          if (pointer[path[i]] === undefined) {
            pointer[path[i]] = {};
          }

          if (i !== path.length - 1) {
            pointer = pointer[path[i]];
          } else {
            pointer[path[i]] = value;
          }
        }
      }

      return optionsObj;
    }
    /**
     * @private
     */

  }, {
    key: "_printOptions",
    value: function _printOptions() {
      var options = this.getOptions();

      while (this.optionsContainer.firstChild) {
        this.optionsContainer.removeChild(this.optionsContainer.firstChild);
      }

      this.optionsContainer.appendChild(wrapInTag("pre", "const options = " + stringify$1(options, null, 2)));
    }
    /**
     *
     * @returns {{}} options
     */

  }, {
    key: "getOptions",
    value: function getOptions() {
      var options = {};

      for (var i = 0; i < this.changedOptions.length; i++) {
        this._constructOptions(this.changedOptions[i].value, this.changedOptions[i].path, options);
      }

      return options;
    }
  }]);

  return Configurator;
}();
/**
 * Popup is a class to create a popup window with some text
 */


var Popup = /*#__PURE__*/function () {
  /**
   * @param {Element} container       The container object.
   * @param {string}  overflowMethod  How the popup should act to overflowing ('flip' or 'cap')
   */
  function Popup(container, overflowMethod) {
    _classCallCheck(this, Popup);

    this.container = container;
    this.overflowMethod = overflowMethod || "cap";
    this.x = 0;
    this.y = 0;
    this.padding = 5;
    this.hidden = false; // create the frame

    this.frame = document.createElement("div");
    this.frame.className = "vis-tooltip";
    this.container.appendChild(this.frame);
  }
  /**
   * @param {number} x   Horizontal position of the popup window
   * @param {number} y   Vertical position of the popup window
   */


  _createClass(Popup, [{
    key: "setPosition",
    value: function setPosition(x, y) {
      this.x = _parseInt(x);
      this.y = _parseInt(y);
    }
    /**
     * Set the content for the popup window. This can be HTML code or text.
     *
     * @param {string | Element} content
     */

  }, {
    key: "setText",
    value: function setText(content) {
      if (content instanceof Element) {
        while (this.frame.firstChild) {
          this.frame.removeChild(this.frame.firstChild);
        }

        this.frame.appendChild(content);
      } else {
        // String containing literal text, element has to be used for HTML due to
        // XSS risks associated with innerHTML (i.e. prevent XSS by accident).
        this.frame.innerText = content;
      }
    }
    /**
     * Show the popup window
     *
     * @param {boolean} [doShow]    Show or hide the window
     */

  }, {
    key: "show",
    value: function show(doShow) {
      if (doShow === undefined) {
        doShow = true;
      }

      if (doShow === true) {
        var height = this.frame.clientHeight;
        var width = this.frame.clientWidth;
        var maxHeight = this.frame.parentNode.clientHeight;
        var maxWidth = this.frame.parentNode.clientWidth;
        var left = 0,
            top = 0;

        if (this.overflowMethod == "flip") {
          var isLeft = false,
              isTop = true; // Where around the position it's located

          if (this.y - height < this.padding) {
            isTop = false;
          }

          if (this.x + width > maxWidth - this.padding) {
            isLeft = true;
          }

          if (isLeft) {
            left = this.x - width;
          } else {
            left = this.x;
          }

          if (isTop) {
            top = this.y - height;
          } else {
            top = this.y;
          }
        } else {
          top = this.y - height;

          if (top + height + this.padding > maxHeight) {
            top = maxHeight - height - this.padding;
          }

          if (top < this.padding) {
            top = this.padding;
          }

          left = this.x;

          if (left + width + this.padding > maxWidth) {
            left = maxWidth - width - this.padding;
          }

          if (left < this.padding) {
            left = this.padding;
          }
        }

        this.frame.style.left = left + "px";
        this.frame.style.top = top + "px";
        this.frame.style.visibility = "visible";
        this.hidden = false;
      } else {
        this.hide();
      }
    }
    /**
     * Hide the popup window
     */

  }, {
    key: "hide",
    value: function hide() {
      this.hidden = true;
      this.frame.style.left = "0";
      this.frame.style.top = "0";
      this.frame.style.visibility = "hidden";
    }
    /**
     * Remove the popup window
     */

  }, {
    key: "destroy",
    value: function destroy() {
      this.frame.parentNode.removeChild(this.frame); // Remove element from DOM
    }
  }]);

  return Popup;
}();

var errorFound = false;
var allOptions$1;
var VALIDATOR_PRINT_STYLE = "background: #FFeeee; color: #dd0000";
/**
 *  Used to validate options.
 */

var Validator = /*#__PURE__*/function () {
  function Validator() {
    _classCallCheck(this, Validator);
  }

  _createClass(Validator, null, [{
    key: "validate",
    value:
    /**
     * Main function to be called
     *
     * @param {object} options
     * @param {object} referenceOptions
     * @param {object} subObject
     * @returns {boolean}
     * @static
     */
    function validate(options, referenceOptions, subObject) {
      errorFound = false;
      allOptions$1 = referenceOptions;
      var usedOptions = referenceOptions;

      if (subObject !== undefined) {
        usedOptions = referenceOptions[subObject];
      }

      Validator.parse(options, usedOptions, []);
      return errorFound;
    }
    /**
     * Will traverse an object recursively and check every value
     *
     * @param {object} options
     * @param {object} referenceOptions
     * @param {Array} path    | where to look for the actual option
     * @static
     */

  }, {
    key: "parse",
    value: function parse(options, referenceOptions, path) {
      for (var _option3 in options) {
        if (Object.prototype.hasOwnProperty.call(options, _option3)) {
          Validator.check(_option3, options, referenceOptions, path);
        }
      }
    }
    /**
     * Check every value. If the value is an object, call the parse function on that object.
     *
     * @param {string} option
     * @param {object} options
     * @param {object} referenceOptions
     * @param {Array} path    | where to look for the actual option
     * @static
     */

  }, {
    key: "check",
    value: function check(option, options, referenceOptions, path) {
      if (referenceOptions[option] === undefined && referenceOptions.__any__ === undefined) {
        Validator.getSuggestion(option, referenceOptions, path);
        return;
      }

      var referenceOption = option;
      var is_object = true;

      if (referenceOptions[option] === undefined && referenceOptions.__any__ !== undefined) {
        // NOTE: This only triggers if the __any__ is in the top level of the options object.
        //       THAT'S A REALLY BAD PLACE TO ALLOW IT!!!!
        // TODO: Examine if needed, remove if possible
        // __any__ is a wildcard. Any value is accepted and will be further analysed by reference.
        referenceOption = "__any__"; // if the any-subgroup is not a predefined object in the configurator,
        // we do not look deeper into the object.

        is_object = Validator.getType(options[option]) === "object";
      }

      var refOptionObj = referenceOptions[referenceOption];

      if (is_object && refOptionObj.__type__ !== undefined) {
        refOptionObj = refOptionObj.__type__;
      }

      Validator.checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path);
    }
    /**
     *
     * @param {string}  option           | the option property
     * @param {object}  options          | The supplied options object
     * @param {object}  referenceOptions | The reference options containing all options and their allowed formats
     * @param {string}  referenceOption  | Usually this is the same as option, except when handling an __any__ tag.
     * @param {string}  refOptionObj     | This is the type object from the reference options
     * @param {Array}   path             | where in the object is the option
     * @static
     */

  }, {
    key: "checkFields",
    value: function checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path) {
      var log = function log(message) {
        console.error("%c" + message + Validator.printLocation(path, option), VALIDATOR_PRINT_STYLE);
      };

      var optionType = Validator.getType(options[option]);
      var refOptionType = refOptionObj[optionType];

      if (refOptionType !== undefined) {
        // if the type is correct, we check if it is supposed to be one of a few select values
        if (Validator.getType(refOptionType) === "array" && indexOf(refOptionType).call(refOptionType, options[option]) === -1) {
          log('Invalid option detected in "' + option + '".' + " Allowed values are:" + Validator.print(refOptionType) + ' not "' + options[option] + '". ');
          errorFound = true;
        } else if (optionType === "object" && referenceOption !== "__any__") {
          path = copyAndExtendArray(path, option);
          Validator.parse(options[option], referenceOptions[referenceOption], path);
        }
      } else if (refOptionObj["any"] === undefined) {
        // type of the field is incorrect and the field cannot be any
        log('Invalid type received for "' + option + '". Expected: ' + Validator.print(keys$4(refOptionObj)) + ". Received [" + optionType + '] "' + options[option] + '"');
        errorFound = true;
      }
    }
    /**
     *
     * @param {object | boolean | number | string | Array.<number> | Date | Node | Moment | undefined | null} object
     * @returns {string}
     * @static
     */

  }, {
    key: "getType",
    value: function getType(object) {
      var type = _typeof(object);

      if (type === "object") {
        if (object === null) {
          return "null";
        }

        if (object instanceof Boolean) {
          return "boolean";
        }

        if (object instanceof Number) {
          return "number";
        }

        if (object instanceof String) {
          return "string";
        }

        if (isArray$2(object)) {
          return "array";
        }

        if (object instanceof Date) {
          return "date";
        }

        if (object.nodeType !== undefined) {
          return "dom";
        }

        if (object._isAMomentObject === true) {
          return "moment";
        }

        return "object";
      } else if (type === "number") {
        return "number";
      } else if (type === "boolean") {
        return "boolean";
      } else if (type === "string") {
        return "string";
      } else if (type === undefined) {
        return "undefined";
      }

      return type;
    }
    /**
     * @param {string} option
     * @param {object} options
     * @param {Array.<string>} path
     * @static
     */

  }, {
    key: "getSuggestion",
    value: function getSuggestion(option, options, path) {
      var localSearch = Validator.findInOptions(option, options, path, false);
      var globalSearch = Validator.findInOptions(option, allOptions$1, [], true);
      var localSearchThreshold = 8;
      var globalSearchThreshold = 4;
      var msg;

      if (localSearch.indexMatch !== undefined) {
        msg = " in " + Validator.printLocation(localSearch.path, option, "") + 'Perhaps it was incomplete? Did you mean: "' + localSearch.indexMatch + '"?\n\n';
      } else if (globalSearch.distance <= globalSearchThreshold && localSearch.distance > globalSearch.distance) {
        msg = " in " + Validator.printLocation(localSearch.path, option, "") + "Perhaps it was misplaced? Matching option found at: " + Validator.printLocation(globalSearch.path, globalSearch.closestMatch, "");
      } else if (localSearch.distance <= localSearchThreshold) {
        msg = '. Did you mean "' + localSearch.closestMatch + '"?' + Validator.printLocation(localSearch.path, option);
      } else {
        msg = ". Did you mean one of these: " + Validator.print(keys$4(options)) + Validator.printLocation(path, option);
      }

      console.error('%cUnknown option detected: "' + option + '"' + msg, VALIDATOR_PRINT_STYLE);
      errorFound = true;
    }
    /**
     * traverse the options in search for a match.
     *
     * @param {string} option
     * @param {object} options
     * @param {Array} path    | where to look for the actual option
     * @param {boolean} [recursive=false]
     * @returns {{closestMatch: string, path: Array, distance: number}}
     * @static
     */

  }, {
    key: "findInOptions",
    value: function findInOptions(option, options, path) {
      var recursive = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      var min = 1e9;
      var closestMatch = "";
      var closestMatchPath = [];
      var lowerCaseOption = option.toLowerCase();
      var indexMatch = undefined;

      for (var op in options) {
        var distance = void 0;

        if (options[op].__type__ !== undefined && recursive === true) {
          var result = Validator.findInOptions(option, options[op], copyAndExtendArray(path, op));

          if (min > result.distance) {
            closestMatch = result.closestMatch;
            closestMatchPath = result.path;
            min = result.distance;
            indexMatch = result.indexMatch;
          }
        } else {
          var _context20;

          if (indexOf(_context20 = op.toLowerCase()).call(_context20, lowerCaseOption) !== -1) {
            indexMatch = op;
          }

          distance = Validator.levenshteinDistance(option, op);

          if (min > distance) {
            closestMatch = op;
            closestMatchPath = copyArray(path);
            min = distance;
          }
        }
      }

      return {
        closestMatch: closestMatch,
        path: closestMatchPath,
        distance: min,
        indexMatch: indexMatch
      };
    }
    /**
     * @param {Array.<string>} path
     * @param {object} option
     * @param {string} prefix
     * @returns {string}
     * @static
     */

  }, {
    key: "printLocation",
    value: function printLocation(path, option) {
      var prefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "Problem value found at: \n";
      var str = "\n\n" + prefix + "options = {\n";

      for (var i = 0; i < path.length; i++) {
        for (var j = 0; j < i + 1; j++) {
          str += "  ";
        }

        str += path[i] + ": {\n";
      }

      for (var _j = 0; _j < path.length + 1; _j++) {
        str += "  ";
      }

      str += option + "\n";

      for (var _i3 = 0; _i3 < path.length + 1; _i3++) {
        for (var _j2 = 0; _j2 < path.length - _i3; _j2++) {
          str += "  ";
        }

        str += "}\n";
      }

      return str + "\n\n";
    }
    /**
     * @param {object} options
     * @returns {string}
     * @static
     */

  }, {
    key: "print",
    value: function print(options) {
      return stringify$1(options).replace(/(")|(\[)|(\])|(,"__type__")/g, "").replace(/(,)/g, ", ");
    }
    /**
     *  Compute the edit distance between the two given strings
     * http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Levenshtein_distance#JavaScript
     *
     * Copyright (c) 2011 Andrei Mackenzie
     *
     * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
     *
     * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
     *
     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
     *
     * @param {string} a
     * @param {string} b
     * @returns {Array.<Array.<number>>}}
     * @static
     */

  }, {
    key: "levenshteinDistance",
    value: function levenshteinDistance(a, b) {
      if (a.length === 0) return b.length;
      if (b.length === 0) return a.length;
      var matrix = []; // increment along the first column of each row

      var i;

      for (i = 0; i <= b.length; i++) {
        matrix[i] = [i];
      } // increment each column in the first row


      var j;

      for (j = 0; j <= a.length; j++) {
        matrix[0][j] = j;
      } // Fill in the rest of the matrix


      for (i = 1; i <= b.length; i++) {
        for (j = 1; j <= a.length; j++) {
          if (b.charAt(i - 1) == a.charAt(j - 1)) {
            matrix[i][j] = matrix[i - 1][j - 1];
          } else {
            matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1, // substitution
            Math.min(matrix[i][j - 1] + 1, // insertion
            matrix[i - 1][j] + 1)); // deletion
          }
        }
      }

      return matrix[b.length][a.length];
    }
  }]);

  return Validator;
}();

var Activator$1 = Activator;
var Configurator$1 = Configurator;
var Hammer$1 = Hammer;
var Popup$1 = Popup;
var VALIDATOR_PRINT_STYLE$1 = VALIDATOR_PRINT_STYLE;
var Validator$1 = Validator;

/* eslint-disable no-prototype-builtins */

/* eslint-disable no-unused-vars */

/* eslint-disable no-var */

/**
 * Parse a text source containing data in DOT language into a JSON object.
 * The object contains two lists: one with nodes and one with edges.
 *
 * DOT language reference: http://www.graphviz.org/doc/info/lang.html
 *
 * DOT language attributes: http://graphviz.org/content/attrs
 *
 * @param {string} data     Text containing a graph in DOT-notation
 * @returns {object} graph   An object containing two parameters:
 *                          {Object[]} nodes
 *                          {Object[]} edges
 *
 * -------------------------------------------
 * TODO
 * ====
 *
 * For label handling, this is an incomplete implementation. From docs (quote #3015):
 *
 * > the escape sequences "\n", "\l" and "\r" divide the label into lines, centered,
 * > left-justified, and right-justified, respectively.
 *
 * Source: http://www.graphviz.org/content/attrs#kescString
 *
 * > As another aid for readability, dot allows double-quoted strings to span multiple physical
 * > lines using the standard C convention of a backslash immediately preceding a newline
 * > character
 * > In addition, double-quoted strings can be concatenated using a '+' operator.
 * > As HTML strings can contain newline characters, which are used solely for formatting,
 * > the language does not allow escaped newlines or concatenation operators to be used
 * > within them.
 *
 * - Currently, only '\\n' is handled
 * - Note that text explicitly says 'labels'; the dot parser currently handles escape
 *   sequences in **all** strings.
 */
function parseDOT(data) {
  dot = data;
  return parseGraph();
} // mapping of attributes from DOT (the keys) to vis.js (the values)

var NODE_ATTR_MAPPING = {
  fontsize: "font.size",
  fontcolor: "font.color",
  labelfontcolor: "font.color",
  fontname: "font.face",
  color: ["color.border", "color.background"],
  fillcolor: "color.background",
  tooltip: "title",
  labeltooltip: "title"
};

var EDGE_ATTR_MAPPING = create$4(NODE_ATTR_MAPPING);

EDGE_ATTR_MAPPING.color = "color.color";
EDGE_ATTR_MAPPING.style = "dashes"; // token types enumeration

var TOKENTYPE = {
  NULL: 0,
  DELIMITER: 1,
  IDENTIFIER: 2,
  UNKNOWN: 3
}; // map with all delimiters

var DELIMITERS = {
  "{": true,
  "}": true,
  "[": true,
  "]": true,
  ";": true,
  "=": true,
  ",": true,
  "->": true,
  "--": true
};
var dot = ""; // current dot file

var index$1 = 0; // current index in dot file

var c = ""; // current token character in expr

var token = ""; // current token

var tokenType = TOKENTYPE.NULL; // type of the token

/**
 * Get the first character from the dot file.
 * The character is stored into the char c. If the end of the dot file is
 * reached, the function puts an empty string in c.
 */

function first() {
  index$1 = 0;
  c = dot.charAt(0);
}
/**
 * Get the next character from the dot file.
 * The character is stored into the char c. If the end of the dot file is
 * reached, the function puts an empty string in c.
 */


function next() {
  index$1++;
  c = dot.charAt(index$1);
}
/**
 * Preview the next character from the dot file.
 *
 * @returns {string} cNext
 */


function nextPreview() {
  return dot.charAt(index$1 + 1);
}
/**
 * Test whether given character is alphabetic or numeric ( a-zA-Z_0-9.:# )
 *
 * @param {string} c
 * @returns {boolean} isAlphaNumeric
 */


function isAlphaNumeric(c) {
  var charCode = c.charCodeAt(0);

  if (charCode < 47) {
    // #.
    return charCode === 35 || charCode === 46;
  }

  if (charCode < 59) {
    // 0-9 and :
    return charCode > 47;
  }

  if (charCode < 91) {
    // A-Z
    return charCode > 64;
  }

  if (charCode < 96) {
    // _
    return charCode === 95;
  }

  if (charCode < 123) {
    // a-z
    return charCode > 96;
  }

  return false;
}
/**
 * Merge all options of object b into object b
 *
 * @param {object} a
 * @param {object} b
 * @returns {object} a
 */


function merge$1(a, b) {
  if (!a) {
    a = {};
  }

  if (b) {
    for (var name in b) {
      if (b.hasOwnProperty(name)) {
        a[name] = b[name];
      }
    }
  }

  return a;
}
/**
 * Set a value in an object, where the provided parameter name can be a
 * path with nested parameters. For example:
 *
 *     var obj = {a: 2};
 *     setValue(obj, 'b.c', 3);     // obj = {a: 2, b: {c: 3}}
 *
 * @param {object} obj
 * @param {string} path  A parameter name or dot-separated parameter path,
 *                      like "color.highlight.border".
 * @param {*} value
 */


function setValue(obj, path, value) {
  var keys = path.split(".");
  var o = obj;

  while (keys.length) {
    var key = keys.shift();

    if (keys.length) {
      // this isn't the end point
      if (!o[key]) {
        o[key] = {};
      }

      o = o[key];
    } else {
      // this is the end point
      o[key] = value;
    }
  }
}
/**
 * Add a node to a graph object. If there is already a node with
 * the same id, their attributes will be merged.
 *
 * @param {object} graph
 * @param {object} node
 */


function addNode(graph, node) {
  var i, len;
  var current = null; // find root graph (in case of subgraph)

  var graphs = [graph]; // list with all graphs from current graph to root graph

  var root = graph;

  while (root.parent) {
    graphs.push(root.parent);
    root = root.parent;
  } // find existing node (at root level) by its id


  if (root.nodes) {
    for (i = 0, len = root.nodes.length; i < len; i++) {
      if (node.id === root.nodes[i].id) {
        current = root.nodes[i];
        break;
      }
    }
  }

  if (!current) {
    // this is a new node
    current = {
      id: node.id
    };

    if (graph.node) {
      // clone default attributes
      current.attr = merge$1(current.attr, graph.node);
    }
  } // add node to this (sub)graph and all its parent graphs


  for (i = graphs.length - 1; i >= 0; i--) {
    var _context;

    var g = graphs[i];

    if (!g.nodes) {
      g.nodes = [];
    }

    if (indexOf(_context = g.nodes).call(_context, current) === -1) {
      g.nodes.push(current);
    }
  } // merge attributes


  if (node.attr) {
    current.attr = merge$1(current.attr, node.attr);
  }
}
/**
 * Add an edge to a graph object
 *
 * @param {object} graph
 * @param {object} edge
 */


function addEdge(graph, edge) {
  if (!graph.edges) {
    graph.edges = [];
  }

  graph.edges.push(edge);

  if (graph.edge) {
    var attr = merge$1({}, graph.edge); // clone default attributes

    edge.attr = merge$1(attr, edge.attr); // merge attributes
  }
}
/**
 * Create an edge to a graph object
 *
 * @param {object} graph
 * @param {string | number | object} from
 * @param {string | number | object} to
 * @param {string} type
 * @param {object | null} attr
 * @returns {object} edge
 */


function createEdge(graph, from, to, type, attr) {
  var edge = {
    from: from,
    to: to,
    type: type
  };

  if (graph.edge) {
    edge.attr = merge$1({}, graph.edge); // clone default attributes
  }

  edge.attr = merge$1(edge.attr || {}, attr); // merge attributes
  // Move arrows attribute from attr to edge temporally created in
  // parseAttributeList().

  if (attr != null) {
    if (attr.hasOwnProperty("arrows") && attr["arrows"] != null) {
      edge["arrows"] = {
        to: {
          enabled: true,
          type: attr.arrows.type
        }
      };
      attr["arrows"] = null;
    }
  }

  return edge;
}
/**
 * Get next token in the current dot file.
 * The token and token type are available as token and tokenType
 */


function getToken() {
  tokenType = TOKENTYPE.NULL;
  token = ""; // skip over whitespaces

  while (c === " " || c === "\t" || c === "\n" || c === "\r") {
    // space, tab, enter
    next();
  }

  do {
    var isComment = false; // skip comment

    if (c === "#") {
      // find the previous non-space character
      var i = index$1 - 1;

      while (dot.charAt(i) === " " || dot.charAt(i) === "\t") {
        i--;
      }

      if (dot.charAt(i) === "\n" || dot.charAt(i) === "") {
        // the # is at the start of a line, this is indeed a line comment
        while (c != "" && c != "\n") {
          next();
        }

        isComment = true;
      }
    }

    if (c === "/" && nextPreview() === "/") {
      // skip line comment
      while (c != "" && c != "\n") {
        next();
      }

      isComment = true;
    }

    if (c === "/" && nextPreview() === "*") {
      // skip block comment
      while (c != "") {
        if (c === "*" && nextPreview() === "/") {
          // end of block comment found. skip these last two characters
          next();
          next();
          break;
        } else {
          next();
        }
      }

      isComment = true;
    } // skip over whitespaces


    while (c === " " || c === "\t" || c === "\n" || c === "\r") {
      // space, tab, enter
      next();
    }
  } while (isComment); // check for end of dot file


  if (c === "") {
    // token is still empty
    tokenType = TOKENTYPE.DELIMITER;
    return;
  } // check for delimiters consisting of 2 characters


  var c2 = c + nextPreview();

  if (DELIMITERS[c2]) {
    tokenType = TOKENTYPE.DELIMITER;
    token = c2;
    next();
    next();
    return;
  } // check for delimiters consisting of 1 character


  if (DELIMITERS[c]) {
    tokenType = TOKENTYPE.DELIMITER;
    token = c;
    next();
    return;
  } // check for an identifier (number or string)
  // TODO: more precise parsing of numbers/strings (and the port separator ':')


  if (isAlphaNumeric(c) || c === "-") {
    token += c;
    next();

    while (isAlphaNumeric(c)) {
      token += c;
      next();
    }

    if (token === "false") {
      token = false; // convert to boolean
    } else if (token === "true") {
      token = true; // convert to boolean
    } else if (!isNaN(Number(token))) {
      token = Number(token); // convert to number
    }

    tokenType = TOKENTYPE.IDENTIFIER;
    return;
  } // check for a string enclosed by double quotes


  if (c === '"') {
    next();

    while (c != "" && (c != '"' || c === '"' && nextPreview() === '"')) {
      if (c === '"') {
        // skip the escape character
        token += c;
        next();
      } else if (c === "\\" && nextPreview() === "n") {
        // Honor a newline escape sequence
        token += "\n";
        next();
      } else {
        token += c;
      }

      next();
    }

    if (c != '"') {
      throw newSyntaxError('End of string " expected');
    }

    next();
    tokenType = TOKENTYPE.IDENTIFIER;
    return;
  } // something unknown is found, wrong characters, a syntax error


  tokenType = TOKENTYPE.UNKNOWN;

  while (c != "") {
    token += c;
    next();
  }

  throw new SyntaxError('Syntax error in part "' + chop(token, 30) + '"');
}
/**
 * Parse a graph.
 *
 * @returns {object} graph
 */


function parseGraph() {
  var graph = {};
  first();
  getToken(); // optional strict keyword

  if (token === "strict") {
    graph.strict = true;
    getToken();
  } // graph or digraph keyword


  if (token === "graph" || token === "digraph") {
    graph.type = token;
    getToken();
  } // optional graph id


  if (tokenType === TOKENTYPE.IDENTIFIER) {
    graph.id = token;
    getToken();
  } // open angle bracket


  if (token != "{") {
    throw newSyntaxError("Angle bracket { expected");
  }

  getToken(); // statements

  parseStatements(graph); // close angle bracket

  if (token != "}") {
    throw newSyntaxError("Angle bracket } expected");
  }

  getToken(); // end of file

  if (token !== "") {
    throw newSyntaxError("End of file expected");
  }

  getToken(); // remove temporary default options

  delete graph.node;
  delete graph.edge;
  delete graph.graph;
  return graph;
}
/**
 * Parse a list with statements.
 *
 * @param {object} graph
 */


function parseStatements(graph) {
  while (token !== "" && token != "}") {
    parseStatement(graph);

    if (token === ";") {
      getToken();
    }
  }
}
/**
 * Parse a single statement. Can be a an attribute statement, node
 * statement, a series of node statements and edge statements, or a
 * parameter.
 *
 * @param {object} graph
 */


function parseStatement(graph) {
  // parse subgraph
  var subgraph = parseSubgraph(graph);

  if (subgraph) {
    // edge statements
    parseEdge(graph, subgraph);
    return;
  } // parse an attribute statement


  var attr = parseAttributeStatement(graph);

  if (attr) {
    return;
  } // parse node


  if (tokenType != TOKENTYPE.IDENTIFIER) {
    throw newSyntaxError("Identifier expected");
  }

  var id = token; // id can be a string or a number

  getToken();

  if (token === "=") {
    // id statement
    getToken();

    if (tokenType != TOKENTYPE.IDENTIFIER) {
      throw newSyntaxError("Identifier expected");
    }

    graph[id] = token;
    getToken(); // TODO: implement comma separated list with "a_list: ID=ID [','] [a_list] "
  } else {
    parseNodeStatement(graph, id);
  }
}
/**
 * Parse a subgraph
 *
 * @param {object} graph    parent graph object
 * @returns {object | null} subgraph
 */


function parseSubgraph(graph) {
  var subgraph = null; // optional subgraph keyword

  if (token === "subgraph") {
    subgraph = {};
    subgraph.type = "subgraph";
    getToken(); // optional graph id

    if (tokenType === TOKENTYPE.IDENTIFIER) {
      subgraph.id = token;
      getToken();
    }
  } // open angle bracket


  if (token === "{") {
    getToken();

    if (!subgraph) {
      subgraph = {};
    }

    subgraph.parent = graph;
    subgraph.node = graph.node;
    subgraph.edge = graph.edge;
    subgraph.graph = graph.graph; // statements

    parseStatements(subgraph); // close angle bracket

    if (token != "}") {
      throw newSyntaxError("Angle bracket } expected");
    }

    getToken(); // remove temporary default options

    delete subgraph.node;
    delete subgraph.edge;
    delete subgraph.graph;
    delete subgraph.parent; // register at the parent graph

    if (!graph.subgraphs) {
      graph.subgraphs = [];
    }

    graph.subgraphs.push(subgraph);
  }

  return subgraph;
}
/**
 * parse an attribute statement like "node [shape=circle fontSize=16]".
 * Available keywords are 'node', 'edge', 'graph'.
 * The previous list with default attributes will be replaced
 *
 * @param {object} graph
 * @returns {string | null} keyword Returns the name of the parsed attribute
 *                                  (node, edge, graph), or null if nothing
 *                                  is parsed.
 */


function parseAttributeStatement(graph) {
  // attribute statements
  if (token === "node") {
    getToken(); // node attributes

    graph.node = parseAttributeList();
    return "node";
  } else if (token === "edge") {
    getToken(); // edge attributes

    graph.edge = parseAttributeList();
    return "edge";
  } else if (token === "graph") {
    getToken(); // graph attributes

    graph.graph = parseAttributeList();
    return "graph";
  }

  return null;
}
/**
 * parse a node statement
 *
 * @param {object} graph
 * @param {string | number} id
 */


function parseNodeStatement(graph, id) {
  // node statement
  var node = {
    id: id
  };
  var attr = parseAttributeList();

  if (attr) {
    node.attr = attr;
  }

  addNode(graph, node); // edge statements

  parseEdge(graph, id);
}
/**
 * Parse an edge or a series of edges
 *
 * @param {object} graph
 * @param {string | number} from        Id of the from node
 */


function parseEdge(graph, from) {
  while (token === "->" || token === "--") {
    var to;
    var type = token;
    getToken();
    var subgraph = parseSubgraph(graph);

    if (subgraph) {
      to = subgraph;
    } else {
      if (tokenType != TOKENTYPE.IDENTIFIER) {
        throw newSyntaxError("Identifier or subgraph expected");
      }

      to = token;
      addNode(graph, {
        id: to
      });
      getToken();
    } // parse edge attributes


    var attr = parseAttributeList(); // create edge

    var edge = createEdge(graph, from, to, type, attr);
    addEdge(graph, edge);
    from = to;
  }
}
/**
 * Parse a set with attributes,
 * for example [label="1.000", shape=solid]
 *
 * @returns {object | null} attr
 */


function parseAttributeList() {
  var i;
  var attr = null; // edge styles of dot and vis

  var edgeStyles = {
    dashed: true,
    solid: false,
    dotted: [1, 5]
  };
  /**
   * Define arrow types.
   * vis currently supports types defined in 'arrowTypes'.
   * Details of arrow shapes are described in
   * http://www.graphviz.org/content/arrow-shapes
   */

  var arrowTypes = {
    dot: "circle",
    box: "box",
    crow: "crow",
    curve: "curve",
    icurve: "inv_curve",
    normal: "triangle",
    inv: "inv_triangle",
    diamond: "diamond",
    tee: "bar",
    vee: "vee"
  };
  /**
   * 'attr_list' contains attributes for checking if some of them are affected
   * later. For instance, both of 'arrowhead' and 'dir' (edge style defined
   * in DOT) make changes to 'arrows' attribute in vis.
   */

  var attr_list = new Array();
  var attr_names = new Array(); // used for checking the case.
  // parse attributes

  while (token === "[") {
    getToken();
    attr = {};

    while (token !== "" && token != "]") {
      if (tokenType != TOKENTYPE.IDENTIFIER) {
        throw newSyntaxError("Attribute name expected");
      }

      var name = token;
      getToken();

      if (token != "=") {
        throw newSyntaxError("Equal sign = expected");
      }

      getToken();

      if (tokenType != TOKENTYPE.IDENTIFIER) {
        throw newSyntaxError("Attribute value expected");
      }

      var value = token; // convert from dot style to vis

      if (name === "style") {
        value = edgeStyles[value];
      }

      var arrowType;

      if (name === "arrowhead") {
        arrowType = arrowTypes[value];
        name = "arrows";
        value = {
          to: {
            enabled: true,
            type: arrowType
          }
        };
      }

      if (name === "arrowtail") {
        arrowType = arrowTypes[value];
        name = "arrows";
        value = {
          from: {
            enabled: true,
            type: arrowType
          }
        };
      }

      attr_list.push({
        attr: attr,
        name: name,
        value: value
      });
      attr_names.push(name);
      getToken();

      if (token == ",") {
        getToken();
      }
    }

    if (token != "]") {
      throw newSyntaxError("Bracket ] expected");
    }

    getToken();
  }
  /**
   * As explained in [1], graphviz has limitations for combination of
   * arrow[head|tail] and dir. If attribute list includes 'dir',
   * following cases just be supported.
   *   1. both or none + arrowhead, arrowtail
   *   2. forward + arrowhead (arrowtail is not affedted)
   *   3. back + arrowtail (arrowhead is not affected)
   * [1] https://www.graphviz.org/doc/info/attrs.html#h:undir_note
   */


  if (includes(attr_names).call(attr_names, "dir")) {
    var idx = {}; // get index of 'arrows' and 'dir'

    idx.arrows = {};

    for (i = 0; i < attr_list.length; i++) {
      if (attr_list[i].name === "arrows") {
        if (attr_list[i].value.to != null) {
          idx.arrows.to = i;
        } else if (attr_list[i].value.from != null) {
          idx.arrows.from = i;
        } else {
          throw newSyntaxError("Invalid value of arrows");
        }
      } else if (attr_list[i].name === "dir") {
        idx.dir = i;
      }
    } // first, add default arrow shape if it is not assigned to avoid error


    var dir_type = attr_list[idx.dir].value;

    if (!includes(attr_names).call(attr_names, "arrows")) {
      if (dir_type === "both") {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: {
            to: {
              enabled: true
            }
          }
        });
        idx.arrows.to = attr_list.length - 1;
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: {
            from: {
              enabled: true
            }
          }
        });
        idx.arrows.from = attr_list.length - 1;
      } else if (dir_type === "forward") {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: {
            to: {
              enabled: true
            }
          }
        });
        idx.arrows.to = attr_list.length - 1;
      } else if (dir_type === "back") {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: {
            from: {
              enabled: true
            }
          }
        });
        idx.arrows.from = attr_list.length - 1;
      } else if (dir_type === "none") {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: ""
        });
        idx.arrows.to = attr_list.length - 1;
      } else {
        throw newSyntaxError('Invalid dir type "' + dir_type + '"');
      }
    }

    var from_type;
    var to_type; // update 'arrows' attribute from 'dir'.

    if (dir_type === "both") {
      // both of shapes of 'from' and 'to' are given
      if (idx.arrows.to && idx.arrows.from) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };

        splice(attr_list).call(attr_list, idx.arrows.from, 1); // shape of 'to' is assigned and use default to 'from'

      } else if (idx.arrows.to) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = "arrow";
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        }; // only shape of 'from' is assigned and use default for 'to'
      } else if (idx.arrows.from) {
        to_type = "arrow";
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.from] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };
      }
    } else if (dir_type === "back") {
      // given both of shapes, but use only 'from'
      if (idx.arrows.to && idx.arrows.from) {
        to_type = "";
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.from] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        }; // given shape of 'to', but does not use it
      } else if (idx.arrows.to) {
        to_type = "";
        from_type = "arrow";
        idx.arrows.from = idx.arrows.to;
        attr_list[idx.arrows.from] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        }; // assign given 'from' shape
      } else if (idx.arrows.from) {
        to_type = "";
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };
      }

      attr_list[idx.arrows.from] = {
        attr: attr_list[idx.arrows.from].attr,
        name: attr_list[idx.arrows.from].name,
        value: {
          from: {
            enabled: true,
            type: attr_list[idx.arrows.from].value.from.type
          }
        }
      };
    } else if (dir_type === "none") {
      var idx_arrow;

      if (idx.arrows.to) {
        idx_arrow = idx.arrows.to;
      } else {
        idx_arrow = idx.arrows.from;
      }

      attr_list[idx_arrow] = {
        attr: attr_list[idx_arrow].attr,
        name: attr_list[idx_arrow].name,
        value: ""
      };
    } else if (dir_type === "forward") {
      // given both of shapes, but use only 'to'
      if (idx.arrows.to && idx.arrows.from) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = "";
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        }; // assign given 'to' shape
      } else if (idx.arrows.to) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = "";
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        }; // given shape of 'from', but does not use it
      } else if (idx.arrows.from) {
        to_type = "arrow";
        from_type = "";
        idx.arrows.to = idx.arrows.from;
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };
      }

      attr_list[idx.arrows.to] = {
        attr: attr_list[idx.arrows.to].attr,
        name: attr_list[idx.arrows.to].name,
        value: {
          to: {
            enabled: true,
            type: attr_list[idx.arrows.to].value.to.type
          }
        }
      };
    } else {
      throw newSyntaxError('Invalid dir type "' + dir_type + '"');
    } // remove 'dir' attribute no need anymore


    splice(attr_list).call(attr_list, idx.dir, 1);
  } // parse 'penwidth'


  var nof_attr_list;

  if (includes(attr_names).call(attr_names, "penwidth")) {
    var tmp_attr_list = [];
    nof_attr_list = attr_list.length;

    for (i = 0; i < nof_attr_list; i++) {
      // exclude 'width' from attr_list if 'penwidth' exists
      if (attr_list[i].name !== "width") {
        if (attr_list[i].name === "penwidth") {
          attr_list[i].name = "width";
        }

        tmp_attr_list.push(attr_list[i]);
      }
    }

    attr_list = tmp_attr_list;
  }

  nof_attr_list = attr_list.length;

  for (i = 0; i < nof_attr_list; i++) {
    setValue(attr_list[i].attr, attr_list[i].name, attr_list[i].value);
  }

  return attr;
}
/**
 * Create a syntax error with extra information on current token and index.
 *
 * @param {string} message
 * @returns {SyntaxError} err
 */


function newSyntaxError(message) {
  return new SyntaxError(message + ', got "' + chop(token, 30) + '" (char ' + index$1 + ")");
}
/**
 * Chop off text after a maximum length
 *
 * @param {string} text
 * @param {number} maxLength
 * @returns {string}
 */


function chop(text, maxLength) {
  return text.length <= maxLength ? text : text.substr(0, 27) + "...";
}
/**
 * Execute a function fn for each pair of elements in two arrays
 *
 * @param {Array | *} array1
 * @param {Array | *} array2
 * @param {Function} fn
 */


function forEach2(array1, array2, fn) {
  if (isArray$2(array1)) {
    forEach$2(array1).call(array1, function (elem1) {
      if (isArray$2(array2)) {
        forEach$2(array2).call(array2, function (elem2) {
          fn(elem1, elem2);
        });
      } else {
        fn(elem1, array2);
      }
    });
  } else {
    if (isArray$2(array2)) {
      forEach$2(array2).call(array2, function (elem2) {
        fn(array1, elem2);
      });
    } else {
      fn(array1, array2);
    }
  }
}
/**
 * Set a nested property on an object
 * When nested objects are missing, they will be created.
 * For example setProp({}, 'font.color', 'red') will return {font: {color: 'red'}}
 *
 * @param {object} object
 * @param {string} path   A dot separated string like 'font.color'
 * @param {*} value       Value for the property
 * @returns {object} Returns the original object, allows for chaining.
 */


function setProp(object, path, value) {
  var names = path.split(".");
  var prop = names.pop(); // traverse over the nested objects

  var obj = object;

  for (var i = 0; i < names.length; i++) {
    var name = names[i];

    if (!(name in obj)) {
      obj[name] = {};
    }

    obj = obj[name];
  } // set the property value


  obj[prop] = value;
  return object;
}
/**
 * Convert an object with DOT attributes to their vis.js equivalents.
 *
 * @param {object} attr     Object with DOT attributes
 * @param {object} mapping
 * @returns {object}         Returns an object with vis.js attributes
 */


function convertAttr(attr, mapping) {
  var converted = {};

  for (var prop in attr) {
    if (attr.hasOwnProperty(prop)) {
      var visProp = mapping[prop];

      if (isArray$2(visProp)) {
        forEach$2(visProp).call(visProp, function (visPropI) {
          setProp(converted, visPropI, attr[prop]);
        });
      } else if (typeof visProp === "string") {
        setProp(converted, visProp, attr[prop]);
      } else {
        setProp(converted, prop, attr[prop]);
      }
    }
  }

  return converted;
}
/**
 * Convert a string containing a graph in DOT language into a map containing
 * with nodes and edges in the format of graph.
 *
 * @param {string} data         Text containing a graph in DOT-notation
 * @returns {object} graphData
 */


function DOTToGraph(data) {
  // parse the DOT file
  var dotData = parseDOT(data);
  var graphData = {
    nodes: [],
    edges: [],
    options: {}
  }; // copy the nodes

  if (dotData.nodes) {
    var _context2;

    forEach$2(_context2 = dotData.nodes).call(_context2, function (dotNode) {
      var graphNode = {
        id: dotNode.id,
        label: String(dotNode.label || dotNode.id)
      };
      merge$1(graphNode, convertAttr(dotNode.attr, NODE_ATTR_MAPPING));

      if (graphNode.image) {
        graphNode.shape = "image";
      }

      graphData.nodes.push(graphNode);
    });
  } // copy the edges


  if (dotData.edges) {
    var _context3;

    /**
     * Convert an edge in DOT format to an edge with VisGraph format
     *
     * @param {object} dotEdge
     * @returns {object} graphEdge
     */
    var convertEdge = function convertEdge(dotEdge) {
      var graphEdge = {
        from: dotEdge.from,
        to: dotEdge.to
      };
      merge$1(graphEdge, convertAttr(dotEdge.attr, EDGE_ATTR_MAPPING)); // Add arrows attribute to default styled arrow.
      // The reason why default style is not added in parseAttributeList() is
      // because only default is cleared before here.

      if (graphEdge.arrows == null && dotEdge.type === "->") {
        graphEdge.arrows = "to";
      }

      return graphEdge;
    };

    forEach$2(_context3 = dotData.edges).call(_context3, function (dotEdge) {
      var from, to;

      if (dotEdge.from instanceof Object) {
        from = dotEdge.from.nodes;
      } else {
        from = {
          id: dotEdge.from
        };
      }

      if (dotEdge.to instanceof Object) {
        to = dotEdge.to.nodes;
      } else {
        to = {
          id: dotEdge.to
        };
      }

      if (dotEdge.from instanceof Object && dotEdge.from.edges) {
        var _context4;

        forEach$2(_context4 = dotEdge.from.edges).call(_context4, function (subEdge) {
          var graphEdge = convertEdge(subEdge);
          graphData.edges.push(graphEdge);
        });
      }

      forEach2(from, to, function (from, to) {
        var subEdge = createEdge(graphData, from.id, to.id, dotEdge.type, dotEdge.attr);
        var graphEdge = convertEdge(subEdge);
        graphData.edges.push(graphEdge);
      });

      if (dotEdge.to instanceof Object && dotEdge.to.edges) {
        var _context5;

        forEach$2(_context5 = dotEdge.to.edges).call(_context5, function (subEdge) {
          var graphEdge = convertEdge(subEdge);
          graphData.edges.push(graphEdge);
        });
      }
    });
  } // copy the options


  if (dotData.attr) {
    graphData.options = dotData.attr;
  }

  return graphData;
}
/* eslint-enable no-var */

/* eslint-enable no-unused-vars */

/* eslint-enable no-prototype-builtins */

var dotparser = /*#__PURE__*/Object.freeze({
	__proto__: null,
	parseDOT: parseDOT,
	DOTToGraph: DOTToGraph
});

/**
 * Convert Gephi to Vis.
 *
 * @param gephiJSON - The parsed JSON data in Gephi format.
 * @param optionsObj - Additional options.
 *
 * @returns The converted data ready to be used in Vis.
 */
function parseGephi(gephiJSON, optionsObj) {
  var _context;

  var options = {
    edges: {
      inheritColor: false
    },
    nodes: {
      fixed: false,
      parseColor: false
    }
  };

  if (optionsObj != null) {
    if (optionsObj.fixed != null) {
      options.nodes.fixed = optionsObj.fixed;
    }

    if (optionsObj.parseColor != null) {
      options.nodes.parseColor = optionsObj.parseColor;
    }

    if (optionsObj.inheritColor != null) {
      options.edges.inheritColor = optionsObj.inheritColor;
    }
  }

  var gEdges = gephiJSON.edges;

  var vEdges = map$3(gEdges).call(gEdges, function (gEdge) {
    var vEdge = {
      from: gEdge.source,
      id: gEdge.id,
      to: gEdge.target
    };

    if (gEdge.attributes != null) {
      vEdge.attributes = gEdge.attributes;
    }

    if (gEdge.label != null) {
      vEdge.label = gEdge.label;
    }

    if (gEdge.attributes != null && gEdge.attributes.title != null) {
      vEdge.title = gEdge.attributes.title;
    }

    if (gEdge.type === "Directed") {
      vEdge.arrows = "to";
    } // edge['value'] = gEdge.attributes != null ? gEdge.attributes.Weight : undefined;
    // edge['width'] = edge['value'] != null ? undefined : edgegEdge.size;


    if (gEdge.color && options.edges.inheritColor === false) {
      vEdge.color = gEdge.color;
    }

    return vEdge;
  });

  var vNodes = map$3(_context = gephiJSON.nodes).call(_context, function (gNode) {
    var vNode = {
      id: gNode.id,
      fixed: options.nodes.fixed && gNode.x != null && gNode.y != null
    };

    if (gNode.attributes != null) {
      vNode.attributes = gNode.attributes;
    }

    if (gNode.label != null) {
      vNode.label = gNode.label;
    }

    if (gNode.size != null) {
      vNode.size = gNode.size;
    }

    if (gNode.attributes != null && gNode.attributes.title != null) {
      vNode.title = gNode.attributes.title;
    }

    if (gNode.title != null) {
      vNode.title = gNode.title;
    }

    if (gNode.x != null) {
      vNode.x = gNode.x;
    }

    if (gNode.y != null) {
      vNode.y = gNode.y;
    }

    if (gNode.color != null) {
      if (options.nodes.parseColor === true) {
        vNode.color = gNode.color;
      } else {
        vNode.color = {
          background: gNode.color,
          border: gNode.color,
          highlight: {
            background: gNode.color,
            border: gNode.color
          },
          hover: {
            background: gNode.color,
            border: gNode.color
          }
        };
      }
    }

    return vNode;
  });

  return {
    nodes: vNodes,
    edges: vEdges
  };
}

var gephiParser = /*#__PURE__*/Object.freeze({
	__proto__: null,
	parseGephi: parseGephi
});

// English
var en = {
  addDescription: "Click in an empty space to place a new node.",
  addEdge: "Add Edge",
  addNode: "Add Node",
  back: "Back",
  close: "Close",
  createEdgeError: "Cannot link edges to a cluster.",
  del: "Delete selected",
  deleteClusterError: "Clusters cannot be deleted.",
  edgeDescription: "Click on a node and drag the edge to another node to connect them.",
  edit: "Edit",
  editClusterError: "Clusters cannot be edited.",
  editEdge: "Edit Edge",
  editEdgeDescription: "Click on the control points and drag them to a node to connect to it.",
  editNode: "Edit Node"
}; // German

var de = {
  addDescription: "Klicke auf eine freie Stelle, um einen neuen Knoten zu plazieren.",
  addEdge: "Kante hinzuf\xFCgen",
  addNode: "Knoten hinzuf\xFCgen",
  back: "Zur\xFCck",
  close: "Schließen",
  createEdgeError: "Es ist nicht m\xF6glich, Kanten mit Clustern zu verbinden.",
  del: "L\xF6sche Auswahl",
  deleteClusterError: "Cluster k\xF6nnen nicht gel\xF6scht werden.",
  edgeDescription: "Klicke auf einen Knoten und ziehe die Kante zu einem anderen Knoten, um diese zu verbinden.",
  edit: "Editieren",
  editClusterError: "Cluster k\xF6nnen nicht editiert werden.",
  editEdge: "Kante editieren",
  editEdgeDescription: "Klicke auf die Verbindungspunkte und ziehe diese auf einen Knoten, um sie zu verbinden.",
  editNode: "Knoten editieren"
}; // Spanish

var es = {
  addDescription: "Haga clic en un lugar vac\xEDo para colocar un nuevo nodo.",
  addEdge: "A\xF1adir arista",
  addNode: "A\xF1adir nodo",
  back: "Atr\xE1s",
  close: "Cerrar",
  createEdgeError: "No se puede conectar una arista a un grupo.",
  del: "Eliminar selecci\xF3n",
  deleteClusterError: "No es posible eliminar grupos.",
  edgeDescription: "Haga clic en un nodo y arrastre la arista hacia otro nodo para conectarlos.",
  edit: "Editar",
  editClusterError: "No es posible editar grupos.",
  editEdge: "Editar arista",
  editEdgeDescription: "Haga clic en un punto de control y arrastrelo a un nodo para conectarlo.",
  editNode: "Editar nodo"
}; //Italiano

var it = {
  addDescription: "Clicca per aggiungere un nuovo nodo",
  addEdge: "Aggiungi un vertice",
  addNode: "Aggiungi un nodo",
  back: "Indietro",
  close: "Chiudere",
  createEdgeError: "Non si possono collegare vertici ad un cluster",
  del: "Cancella la selezione",
  deleteClusterError: "I cluster non possono essere cancellati",
  edgeDescription: "Clicca su un nodo e trascinalo ad un altro nodo per connetterli.",
  edit: "Modifica",
  editClusterError: "I clusters non possono essere modificati.",
  editEdge: "Modifica il vertice",
  editEdgeDescription: "Clicca sui Punti di controllo e trascinali ad un nodo per connetterli.",
  editNode: "Modifica il nodo"
}; // Dutch

var nl = {
  addDescription: "Klik op een leeg gebied om een nieuwe node te maken.",
  addEdge: "Link toevoegen",
  addNode: "Node toevoegen",
  back: "Terug",
  close: "Sluiten",
  createEdgeError: "Kan geen link maken naar een cluster.",
  del: "Selectie verwijderen",
  deleteClusterError: "Clusters kunnen niet worden verwijderd.",
  edgeDescription: "Klik op een node en sleep de link naar een andere node om ze te verbinden.",
  edit: "Wijzigen",
  editClusterError: "Clusters kunnen niet worden aangepast.",
  editEdge: "Link wijzigen",
  editEdgeDescription: "Klik op de verbindingspunten en sleep ze naar een node om daarmee te verbinden.",
  editNode: "Node wijzigen"
}; // Portuguese Brazil

var pt = {
  addDescription: "Clique em um espaço em branco para adicionar um novo nó",
  addEdge: "Adicionar aresta",
  addNode: "Adicionar nó",
  back: "Voltar",
  close: "Fechar",
  createEdgeError: "Não foi possível linkar arestas a um cluster.",
  del: "Remover selecionado",
  deleteClusterError: "Clusters não puderam ser removidos.",
  edgeDescription: "Clique em um nó e arraste a aresta até outro nó para conectá-los",
  edit: "Editar",
  editClusterError: "Clusters não puderam ser editados.",
  editEdge: "Editar aresta",
  editEdgeDescription: "Clique nos pontos de controle e os arraste para um nó para conectá-los",
  editNode: "Editar nó"
}; // Russian

var ru = {
  addDescription: "Кликните в свободное место, чтобы добавить новый узел.",
  addEdge: "Добавить ребро",
  addNode: "Добавить узел",
  back: "Назад",
  close: "Закрывать",
  createEdgeError: "Невозможно соединить ребра в кластер.",
  del: "Удалить выбранное",
  deleteClusterError: "Кластеры не могут быть удалены",
  edgeDescription: "Кликните на узел и протяните ребро к другому узлу, чтобы соединить их.",
  edit: "Редактировать",
  editClusterError: "Кластеры недоступны для редактирования.",
  editEdge: "Редактировать ребро",
  editEdgeDescription: "Кликните на контрольные точки и перетащите их в узел, чтобы подключиться к нему.",
  editNode: "Редактировать узел"
}; // Chinese

var cn = {
  addDescription: "单击空白处放置新节点。",
  addEdge: "添加连接线",
  addNode: "添加节点",
  back: "返回",
  close: "關閉",
  createEdgeError: "无法将连接线连接到群集。",
  del: "删除选定",
  deleteClusterError: "无法删除群集。",
  edgeDescription: "单击某个节点并将该连接线拖动到另一个节点以连接它们。",
  edit: "编辑",
  editClusterError: "无法编辑群集。",
  editEdge: "编辑连接线",
  editEdgeDescription: "单击控制节点并将它们拖到节点上连接。",
  editNode: "编辑节点"
}; // Ukrainian

var uk = {
  addDescription: "Kлікніть на вільне місце, щоб додати новий вузол.",
  addEdge: "Додати край",
  addNode: "Додати вузол",
  back: "Назад",
  close: "Закрити",
  createEdgeError: "Не можливо об'єднати краї в групу.",
  del: "Видалити обране",
  deleteClusterError: "Групи не можуть бути видалені.",
  edgeDescription: "Клікніть на вузол і перетягніть край до іншого вузла, щоб їх з'єднати.",
  edit: "Редагувати",
  editClusterError: "Групи недоступні для редагування.",
  editEdge: "Редагувати край",
  editEdgeDescription: "Клікніть на контрольні точки і перетягніть їх у вузол, щоб підключитися до нього.",
  editNode: "Редагувати вузол"
}; // French

var fr = {
  addDescription: "Cliquez dans un endroit vide pour placer un nœud.",
  addEdge: "Ajouter un lien",
  addNode: "Ajouter un nœud",
  back: "Retour",
  close: "Fermer",
  createEdgeError: "Impossible de créer un lien vers un cluster.",
  del: "Effacer la sélection",
  deleteClusterError: "Les clusters ne peuvent pas être effacés.",
  edgeDescription: "Cliquez sur un nœud et glissez le lien vers un autre nœud pour les connecter.",
  edit: "Éditer",
  editClusterError: "Les clusters ne peuvent pas être édités.",
  editEdge: "Éditer le lien",
  editEdgeDescription: "Cliquez sur les points de contrôle et glissez-les pour connecter un nœud.",
  editNode: "Éditer le nœud"
}; // Czech

var cs = {
  addDescription: "Kluknutím do prázdného prostoru můžete přidat nový vrchol.",
  addEdge: "Přidat hranu",
  addNode: "Přidat vrchol",
  back: "Zpět",
  close: "Zavřít",
  createEdgeError: "Nelze připojit hranu ke shluku.",
  del: "Smazat výběr",
  deleteClusterError: "Nelze mazat shluky.",
  edgeDescription: "Přetažením z jednoho vrcholu do druhého můžete spojit tyto vrcholy novou hranou.",
  edit: "Upravit",
  editClusterError: "Nelze upravovat shluky.",
  editEdge: "Upravit hranu",
  editEdgeDescription: "Přetažením kontrolního vrcholu hrany ji můžete připojit k jinému vrcholu.",
  editNode: "Upravit vrchol"
};

var locales = /*#__PURE__*/Object.freeze({
	__proto__: null,
	en: en,
	de: de,
	es: es,
	it: it,
	nl: nl,
	pt: pt,
	ru: ru,
	cn: cn,
	uk: uk,
	fr: fr,
	cs: cs
});

/**
 * Normalizes language code into the format used internally.
 *
 * @param locales - All the available locales.
 * @param rawCode - The original code as supplied by the user.
 *
 * @returns Language code in the format language-COUNTRY or language, eventually
 * fallbacks to en.
 */
function normalizeLanguageCode(locales, rawCode) {
  try {
    var _rawCode$split = rawCode.split(/[-_ /]/, 2),
        _rawCode$split2 = _slicedToArray(_rawCode$split, 2),
        rawLanguage = _rawCode$split2[0],
        rawCountry = _rawCode$split2[1];

    var language = rawLanguage != null ? rawLanguage.toLowerCase() : null;
    var country = rawCountry != null ? rawCountry.toUpperCase() : null;

    if (language && country) {
      var code = language + "-" + country;

      if (Object.prototype.hasOwnProperty.call(locales, code)) {
        return code;
      } else {
        var _context;

        console.warn(concat(_context = "Unknown variant ".concat(country, " of language ")).call(_context, language, "."));
      }
    }

    if (language) {
      var _code = language;

      if (Object.prototype.hasOwnProperty.call(locales, _code)) {
        return _code;
      } else {
        console.warn("Unknown language ".concat(language));
      }
    }

    console.warn("Unknown locale ".concat(rawCode, ", falling back to English."));
    return "en";
  } catch (error) {
    console.error(error);
    console.warn("Unexpected error while normalizing locale ".concat(rawCode, ", falling back to English."));
    return "en";
  }
}

/**
 * Associates a canvas to a given image, containing a number of renderings
 * of the image at various sizes.
 *
 * This technique is known as 'mipmapping'.
 *
 * NOTE: Images can also be of type 'data:svg+xml`. This code also works
 *       for svg, but the mipmapping may not be necessary.
 *
 * @param {Image} image
 */
var CachedImage = /*#__PURE__*/function () {
  /**
   * @ignore
   */
  function CachedImage() {
    _classCallCheck(this, CachedImage);

    this.NUM_ITERATIONS = 4; // Number of items in the coordinates array

    this.image = new Image();
    this.canvas = document.createElement("canvas");
  }
  /**
   * Called when the image has been successfully loaded.
   */


  _createClass(CachedImage, [{
    key: "init",
    value: function init() {
      if (this.initialized()) return;
      this.src = this.image.src; // For same interface with Image

      var w = this.image.width;
      var h = this.image.height; // Ease external access

      this.width = w;
      this.height = h;
      var h2 = Math.floor(h / 2);
      var h4 = Math.floor(h / 4);
      var h8 = Math.floor(h / 8);
      var h16 = Math.floor(h / 16);
      var w2 = Math.floor(w / 2);
      var w4 = Math.floor(w / 4);
      var w8 = Math.floor(w / 8);
      var w16 = Math.floor(w / 16); // Make canvas as small as possible

      this.canvas.width = 3 * w4;
      this.canvas.height = h2; // Coordinates and sizes of images contained in the canvas
      // Values per row:  [top x, left y, width, height]

      this.coordinates = [[0, 0, w2, h2], [w2, 0, w4, h4], [w2, h4, w8, h8], [5 * w8, h4, w16, h16]];

      this._fillMipMap();
    }
    /**
     * @returns {boolean} true if init() has been called, false otherwise.
     */

  }, {
    key: "initialized",
    value: function initialized() {
      return this.coordinates !== undefined;
    }
    /**
     * Redraw main image in various sizes to the context.
     *
     * The rationale behind this is to reduce artefacts due to interpolation
     * at differing zoom levels.
     *
     * Source: http://stackoverflow.com/q/18761404/1223531
     *
     * This methods takes the resizing out of the drawing loop, in order to
     * reduce performance overhead.
     *
     * TODO: The code assumes that a 2D context can always be gotten. This is
     *       not necessarily true! OTOH, if not true then usage of this class
     *       is senseless.
     *
     * @private
     */

  }, {
    key: "_fillMipMap",
    value: function _fillMipMap() {
      var ctx = this.canvas.getContext("2d"); // First zoom-level comes from the image

      var to = this.coordinates[0];
      ctx.drawImage(this.image, to[0], to[1], to[2], to[3]); // The rest are copy actions internal to the canvas/context

      for (var iterations = 1; iterations < this.NUM_ITERATIONS; iterations++) {
        var from = this.coordinates[iterations - 1];
        var _to = this.coordinates[iterations];
        ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], _to[0], _to[1], _to[2], _to[3]);
      }
    }
    /**
     * Draw the image, using the mipmap if necessary.
     *
     * MipMap is only used if param factor > 2; otherwise, original bitmap
     * is resized. This is also used to skip mipmap usage, e.g. by setting factor = 1
     *
     * Credits to 'Alex de Mulder' for original implementation.
     *
     * @param {CanvasRenderingContext2D} ctx  context on which to draw zoomed image
     * @param {Float} factor scale factor at which to draw
     * @param {number} left
     * @param {number} top
     * @param {number} width
     * @param {number} height
     */

  }, {
    key: "drawImageAtPosition",
    value: function drawImageAtPosition(ctx, factor, left, top, width, height) {
      if (!this.initialized()) return; //can't draw image yet not intialized

      if (factor > 2) {
        // Determine which zoomed image to use
        factor *= 0.5;
        var iterations = 0;

        while (factor > 2 && iterations < this.NUM_ITERATIONS) {
          factor *= 0.5;
          iterations += 1;
        }

        if (iterations >= this.NUM_ITERATIONS) {
          iterations = this.NUM_ITERATIONS - 1;
        } //console.log("iterations: " + iterations);


        var from = this.coordinates[iterations];
        ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], left, top, width, height);
      } else {
        // Draw image directly
        ctx.drawImage(this.image, left, top, width, height);
      }
    }
  }]);

  return CachedImage;
}();

/**
 * This callback is a callback that accepts an Image.
 *
 * @callback ImageCallback
 * @param {Image} image
 */

/**
 * This class loads images and keeps them stored.
 *
 * @param {ImageCallback} callback
 */

var Images = /*#__PURE__*/function () {
  /**
   * @param {ImageCallback} callback
   */
  function Images(callback) {
    _classCallCheck(this, Images);

    this.images = {};
    this.imageBroken = {};
    this.callback = callback;
  }
  /**
   * @param {string} url                      The original Url that failed to load, if the broken image is successfully loaded it will be added to the cache using this Url as the key so that subsequent requests for this Url will return the broken image
   * @param {string} brokenUrl                Url the broken image to try and load
   * @param {Image} imageToLoadBrokenUrlOn   The image object
   */


  _createClass(Images, [{
    key: "_tryloadBrokenUrl",
    value: function _tryloadBrokenUrl(url, brokenUrl, imageToLoadBrokenUrlOn) {
      //If these parameters aren't specified then exit the function because nothing constructive can be done
      if (url === undefined || imageToLoadBrokenUrlOn === undefined) return;

      if (brokenUrl === undefined) {
        console.warn("No broken url image defined");
        return;
      } //Clear the old subscription to the error event and put a new in place that only handle errors in loading the brokenImageUrl


      imageToLoadBrokenUrlOn.image.onerror = function () {
        console.error("Could not load brokenImage:", brokenUrl); // cache item will contain empty image, this should be OK for default
      }; //Set the source of the image to the brokenUrl, this is actually what kicks off the loading of the broken image


      imageToLoadBrokenUrlOn.image.src = brokenUrl;
    }
    /**
     *
     * @param {vis.Image} imageToRedrawWith
     * @private
     */

  }, {
    key: "_redrawWithImage",
    value: function _redrawWithImage(imageToRedrawWith) {
      if (this.callback) {
        this.callback(imageToRedrawWith);
      }
    }
    /**
     * @param {string} url          Url of the image
     * @param {string} brokenUrl    Url of an image to use if the url image is not found
     * @returns {Image} img          The image object
     */

  }, {
    key: "load",
    value: function load(url, brokenUrl) {
      var _this = this;

      //Try and get the image from the cache, if successful then return the cached image
      var cachedImage = this.images[url];
      if (cachedImage) return cachedImage; //Create a new image

      var img = new CachedImage(); // Need to add to cache here, otherwise final return will spawn different copies of the same image,
      // Also, there will be multiple loads of the same image.

      this.images[url] = img; //Subscribe to the event that is raised if the image loads successfully

      img.image.onload = function () {
        // Properly init the cached item and then request a redraw
        _this._fixImageCoordinates(img.image);

        img.init();

        _this._redrawWithImage(img);
      }; //Subscribe to the event that is raised if the image fails to load


      img.image.onerror = function () {
        console.error("Could not load image:", url); //Try and load the image specified by the brokenUrl using

        _this._tryloadBrokenUrl(url, brokenUrl, img);
      }; //Set the source of the image to the url, this is what actually kicks off the loading of the image


      img.image.src = url; //Return the new image

      return img;
    }
    /**
     * IE11 fix -- thanks dponch!
     *
     * Local helper function
     *
     * @param {vis.Image} imageToCache
     * @private
     */

  }, {
    key: "_fixImageCoordinates",
    value: function _fixImageCoordinates(imageToCache) {
      if (imageToCache.width === 0) {
        document.body.appendChild(imageToCache);
        imageToCache.width = imageToCache.offsetWidth;
        imageToCache.height = imageToCache.offsetHeight;
        document.body.removeChild(imageToCache);
      }
    }
  }]);

  return Images;
}();

var internalMetadata = {exports: {}};

var fails$4 = fails$m;
var freezing = !fails$4(function () {
  // eslint-disable-next-line es/no-object-isextensible, es/no-object-preventextensions -- required for testing
  return Object.isExtensible(Object.preventExtensions({}));
});

var $$e = _export;
var hiddenKeys = hiddenKeys$6;
var isObject$5 = isObject$j;
var has$1 = has$c;
var defineProperty$2 = objectDefineProperty.f;
var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
var getOwnPropertyNamesExternalModule = objectGetOwnPropertyNamesExternal;
var uid = uid$4;
var FREEZING = freezing;
var REQUIRED = false;
var METADATA = uid('meta');
var id$1 = 0; // eslint-disable-next-line es/no-object-isextensible -- safe

var isExtensible$1 = Object.isExtensible || function () {
  return true;
};

var setMetadata = function (it) {
  defineProperty$2(it, METADATA, {
    value: {
      objectID: 'O' + id$1++,
      // object ID
      weakData: {} // weak collections IDs

    }
  });
};

var fastKey$1 = function (it, create) {
  // return a primitive with prefix
  if (!isObject$5(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;

  if (!has$1(it, METADATA)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible$1(it)) return 'F'; // not necessary to add metadata

    if (!create) return 'E'; // add missing metadata

    setMetadata(it); // return object ID
  }

  return it[METADATA].objectID;
};

var getWeakData$1 = function (it, create) {
  if (!has$1(it, METADATA)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible$1(it)) return true; // not necessary to add metadata

    if (!create) return false; // add missing metadata

    setMetadata(it); // return the store of weak collections IDs
  }

  return it[METADATA].weakData;
}; // add metadata on freeze-family methods calling


var onFreeze = function (it) {
  if (FREEZING && REQUIRED && isExtensible$1(it) && !has$1(it, METADATA)) setMetadata(it);
  return it;
};

var enable = function () {
  meta.enable = function () {
    /* empty */
  };

  REQUIRED = true;
  var getOwnPropertyNames = getOwnPropertyNamesModule.f;
  var splice = [].splice;
  var test = {};
  test[METADATA] = 1; // prevent exposing of metadata key

  if (getOwnPropertyNames(test).length) {
    getOwnPropertyNamesModule.f = function (it) {
      var result = getOwnPropertyNames(it);

      for (var i = 0, length = result.length; i < length; i++) {
        if (result[i] === METADATA) {
          splice.call(result, i, 1);
          break;
        }
      }

      return result;
    };

    $$e({
      target: 'Object',
      stat: true,
      forced: true
    }, {
      getOwnPropertyNames: getOwnPropertyNamesExternalModule.f
    });
  }
};

var meta = internalMetadata.exports = {
  enable: enable,
  fastKey: fastKey$1,
  getWeakData: getWeakData$1,
  onFreeze: onFreeze
};
hiddenKeys[METADATA] = true;

var anObject$4 = anObject$d;
var isArrayIteratorMethod = isArrayIteratorMethod$2;
var toLength$4 = toLength$c;
var bind$3 = functionBindContext;
var getIteratorMethod$1 = getIteratorMethod$7;
var iteratorClose = iteratorClose$2;

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

var iterate$3 = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = bind$3(unboundFunction, that, 1 + AS_ENTRIES + INTERRUPTED);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) iteratorClose(iterator);
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      anObject$4(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    }

    return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = getIteratorMethod$1(iterable);
    if (typeof iterFn != 'function') throw TypeError('Target is not iterable'); // optimisation for array iterators

    if (isArrayIteratorMethod(iterFn)) {
      for (index = 0, length = toLength$4(iterable.length); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && result instanceof Result) return result;
      }

      return new Result(false);
    }

    iterator = iterFn.call(iterable);
  }

  next = iterator.next;

  while (!(step = next.call(iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      iteratorClose(iterator);
      throw error;
    }

    if (typeof result == 'object' && result && result instanceof Result) return result;
  }

  return new Result(false);
};

var anInstance$3 = function (it, Constructor, name) {
  if (!(it instanceof Constructor)) {
    throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
  }

  return it;
};

var $$d = _export;
var global$5 = global$k;
var InternalMetadataModule$1 = internalMetadata.exports;
var fails$3 = fails$m;
var createNonEnumerableProperty = createNonEnumerableProperty$9;
var iterate$2 = iterate$3;
var anInstance$2 = anInstance$3;
var isObject$4 = isObject$j;
var setToStringTag = setToStringTag$5;
var defineProperty$1 = objectDefineProperty.f;
var forEach = arrayIteration.forEach;
var DESCRIPTORS$2 = descriptors;
var InternalStateModule$2 = internalState;
var setInternalState$2 = InternalStateModule$2.set;
var internalStateGetterFor$2 = InternalStateModule$2.getterFor;

var collection$3 = function (CONSTRUCTOR_NAME, wrapper, common) {
  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
  var ADDER = IS_MAP ? 'set' : 'add';
  var NativeConstructor = global$5[CONSTRUCTOR_NAME];
  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
  var exported = {};
  var Constructor;

  if (!DESCRIPTORS$2 || typeof NativeConstructor != 'function' || !(IS_WEAK || NativePrototype.forEach && !fails$3(function () {
    new NativeConstructor().entries().next();
  }))) {
    // create collection constructor
    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
    InternalMetadataModule$1.enable();
  } else {
    Constructor = wrapper(function (target, iterable) {
      setInternalState$2(anInstance$2(target, Constructor, CONSTRUCTOR_NAME), {
        type: CONSTRUCTOR_NAME,
        collection: new NativeConstructor()
      });
      if (iterable != undefined) iterate$2(iterable, target[ADDER], {
        that: target,
        AS_ENTRIES: IS_MAP
      });
    });
    var getInternalState = internalStateGetterFor$2(CONSTRUCTOR_NAME);
    forEach(['add', 'clear', 'delete', 'forEach', 'get', 'has', 'set', 'keys', 'values', 'entries'], function (KEY) {
      var IS_ADDER = KEY == 'add' || KEY == 'set';

      if (KEY in NativePrototype && !(IS_WEAK && KEY == 'clear')) {
        createNonEnumerableProperty(Constructor.prototype, KEY, function (a, b) {
          var collection = getInternalState(this).collection;
          if (!IS_ADDER && IS_WEAK && !isObject$4(a)) return KEY == 'get' ? undefined : false;
          var result = collection[KEY](a === 0 ? 0 : a, b);
          return IS_ADDER ? this : result;
        });
      }
    });
    IS_WEAK || defineProperty$1(Constructor.prototype, 'size', {
      configurable: true,
      get: function () {
        return getInternalState(this).collection.size;
      }
    });
  }

  setToStringTag(Constructor, CONSTRUCTOR_NAME, false, true);
  exported[CONSTRUCTOR_NAME] = Constructor;
  $$d({
    global: true,
    forced: true
  }, exported);
  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
  return Constructor;
};

var redefine = redefine$3;

var redefineAll$3 = function (target, src, options) {
  for (var key in src) {
    if (options && options.unsafe && target[key]) target[key] = src[key];else redefine(target, key, src[key], options);
  }

  return target;
};

var getBuiltIn$1 = getBuiltIn$8;
var definePropertyModule = objectDefineProperty;
var wellKnownSymbol = wellKnownSymbol$j;
var DESCRIPTORS$1 = descriptors;
var SPECIES = wellKnownSymbol('species');

var setSpecies$1 = function (CONSTRUCTOR_NAME) {
  var Constructor = getBuiltIn$1(CONSTRUCTOR_NAME);
  var defineProperty = definePropertyModule.f;

  if (DESCRIPTORS$1 && Constructor && !Constructor[SPECIES]) {
    defineProperty(Constructor, SPECIES, {
      configurable: true,
      get: function () {
        return this;
      }
    });
  }
};

var defineProperty = objectDefineProperty.f;
var create$3 = objectCreate;
var redefineAll$2 = redefineAll$3;
var bind$2 = functionBindContext;
var anInstance$1 = anInstance$3;
var iterate$1 = iterate$3;
var defineIterator = defineIterator$3;
var setSpecies = setSpecies$1;
var DESCRIPTORS = descriptors;
var fastKey = internalMetadata.exports.fastKey;
var InternalStateModule$1 = internalState;
var setInternalState$1 = InternalStateModule$1.set;
var internalStateGetterFor$1 = InternalStateModule$1.getterFor;
var collectionStrong$2 = {
  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
    var C = wrapper(function (that, iterable) {
      anInstance$1(that, C, CONSTRUCTOR_NAME);
      setInternalState$1(that, {
        type: CONSTRUCTOR_NAME,
        index: create$3(null),
        first: undefined,
        last: undefined,
        size: 0
      });
      if (!DESCRIPTORS) that.size = 0;
      if (iterable != undefined) iterate$1(iterable, that[ADDER], {
        that: that,
        AS_ENTRIES: IS_MAP
      });
    });
    var getInternalState = internalStateGetterFor$1(CONSTRUCTOR_NAME);

    var define = function (that, key, value) {
      var state = getInternalState(that);
      var entry = getEntry(that, key);
      var previous, index; // change existing entry

      if (entry) {
        entry.value = value; // create new entry
      } else {
        state.last = entry = {
          index: index = fastKey(key, true),
          key: key,
          value: value,
          previous: previous = state.last,
          next: undefined,
          removed: false
        };
        if (!state.first) state.first = entry;
        if (previous) previous.next = entry;
        if (DESCRIPTORS) state.size++;else that.size++; // add to index

        if (index !== 'F') state.index[index] = entry;
      }

      return that;
    };

    var getEntry = function (that, key) {
      var state = getInternalState(that); // fast case

      var index = fastKey(key);
      var entry;
      if (index !== 'F') return state.index[index]; // frozen object case

      for (entry = state.first; entry; entry = entry.next) {
        if (entry.key == key) return entry;
      }
    };

    redefineAll$2(C.prototype, {
      // `{ Map, Set }.prototype.clear()` methods
      // https://tc39.es/ecma262/#sec-map.prototype.clear
      // https://tc39.es/ecma262/#sec-set.prototype.clear
      clear: function clear() {
        var that = this;
        var state = getInternalState(that);
        var data = state.index;
        var entry = state.first;

        while (entry) {
          entry.removed = true;
          if (entry.previous) entry.previous = entry.previous.next = undefined;
          delete data[entry.index];
          entry = entry.next;
        }

        state.first = state.last = undefined;
        if (DESCRIPTORS) state.size = 0;else that.size = 0;
      },
      // `{ Map, Set }.prototype.delete(key)` methods
      // https://tc39.es/ecma262/#sec-map.prototype.delete
      // https://tc39.es/ecma262/#sec-set.prototype.delete
      'delete': function (key) {
        var that = this;
        var state = getInternalState(that);
        var entry = getEntry(that, key);

        if (entry) {
          var next = entry.next;
          var prev = entry.previous;
          delete state.index[entry.index];
          entry.removed = true;
          if (prev) prev.next = next;
          if (next) next.previous = prev;
          if (state.first == entry) state.first = next;
          if (state.last == entry) state.last = prev;
          if (DESCRIPTORS) state.size--;else that.size--;
        }

        return !!entry;
      },
      // `{ Map, Set }.prototype.forEach(callbackfn, thisArg = undefined)` methods
      // https://tc39.es/ecma262/#sec-map.prototype.foreach
      // https://tc39.es/ecma262/#sec-set.prototype.foreach
      forEach: function forEach(callbackfn
      /* , that = undefined */
      ) {
        var state = getInternalState(this);
        var boundFunction = bind$2(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
        var entry;

        while (entry = entry ? entry.next : state.first) {
          boundFunction(entry.value, entry.key, this); // revert to the last existing entry

          while (entry && entry.removed) entry = entry.previous;
        }
      },
      // `{ Map, Set}.prototype.has(key)` methods
      // https://tc39.es/ecma262/#sec-map.prototype.has
      // https://tc39.es/ecma262/#sec-set.prototype.has
      has: function has(key) {
        return !!getEntry(this, key);
      }
    });
    redefineAll$2(C.prototype, IS_MAP ? {
      // `Map.prototype.get(key)` method
      // https://tc39.es/ecma262/#sec-map.prototype.get
      get: function get(key) {
        var entry = getEntry(this, key);
        return entry && entry.value;
      },
      // `Map.prototype.set(key, value)` method
      // https://tc39.es/ecma262/#sec-map.prototype.set
      set: function set(key, value) {
        return define(this, key === 0 ? 0 : key, value);
      }
    } : {
      // `Set.prototype.add(value)` method
      // https://tc39.es/ecma262/#sec-set.prototype.add
      add: function add(value) {
        return define(this, value = value === 0 ? 0 : value, value);
      }
    });
    if (DESCRIPTORS) defineProperty(C.prototype, 'size', {
      get: function () {
        return getInternalState(this).size;
      }
    });
    return C;
  },
  setStrong: function (C, CONSTRUCTOR_NAME, IS_MAP) {
    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
    var getInternalCollectionState = internalStateGetterFor$1(CONSTRUCTOR_NAME);
    var getInternalIteratorState = internalStateGetterFor$1(ITERATOR_NAME); // `{ Map, Set }.prototype.{ keys, values, entries, @@iterator }()` methods
    // https://tc39.es/ecma262/#sec-map.prototype.entries
    // https://tc39.es/ecma262/#sec-map.prototype.keys
    // https://tc39.es/ecma262/#sec-map.prototype.values
    // https://tc39.es/ecma262/#sec-map.prototype-@@iterator
    // https://tc39.es/ecma262/#sec-set.prototype.entries
    // https://tc39.es/ecma262/#sec-set.prototype.keys
    // https://tc39.es/ecma262/#sec-set.prototype.values
    // https://tc39.es/ecma262/#sec-set.prototype-@@iterator

    defineIterator(C, CONSTRUCTOR_NAME, function (iterated, kind) {
      setInternalState$1(this, {
        type: ITERATOR_NAME,
        target: iterated,
        state: getInternalCollectionState(iterated),
        kind: kind,
        last: undefined
      });
    }, function () {
      var state = getInternalIteratorState(this);
      var kind = state.kind;
      var entry = state.last; // revert to the last existing entry

      while (entry && entry.removed) entry = entry.previous; // get next entry


      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
        // or finish the iteration
        state.target = undefined;
        return {
          value: undefined,
          done: true
        };
      } // return step by kind


      if (kind == 'keys') return {
        value: entry.key,
        done: false
      };
      if (kind == 'values') return {
        value: entry.value,
        done: false
      };
      return {
        value: [entry.key, entry.value],
        done: false
      };
    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true); // `{ Map, Set }.prototype[@@species]` accessors
    // https://tc39.es/ecma262/#sec-get-map-@@species
    // https://tc39.es/ecma262/#sec-get-set-@@species

    setSpecies(CONSTRUCTOR_NAME);
  }
};

var collection$2 = collection$3;
var collectionStrong$1 = collectionStrong$2; // `Map` constructor
// https://tc39.es/ecma262/#sec-map-objects

collection$2('Map', function (init) {
  return function Map() {
    return init(this, arguments.length ? arguments[0] : undefined);
  };
}, collectionStrong$1);

var path$b = path$x;
var map$2 = path$b.Map;

var parent$p = map$2;
var map$1 = parent$p;

var map = map$1;

/**
 * This class can store groups and options specific for groups.
 */
var Groups = /*#__PURE__*/function () {
  /**
   * @ignore
   */
  function Groups() {
    _classCallCheck(this, Groups);

    this.clear();
    this._defaultIndex = 0;
    this._groupIndex = 0;
    this._defaultGroups = [{
      border: "#2B7CE9",
      background: "#97C2FC",
      highlight: {
        border: "#2B7CE9",
        background: "#D2E5FF"
      },
      hover: {
        border: "#2B7CE9",
        background: "#D2E5FF"
      }
    }, // 0: blue
    {
      border: "#FFA500",
      background: "#FFFF00",
      highlight: {
        border: "#FFA500",
        background: "#FFFFA3"
      },
      hover: {
        border: "#FFA500",
        background: "#FFFFA3"
      }
    }, // 1: yellow
    {
      border: "#FA0A10",
      background: "#FB7E81",
      highlight: {
        border: "#FA0A10",
        background: "#FFAFB1"
      },
      hover: {
        border: "#FA0A10",
        background: "#FFAFB1"
      }
    }, // 2: red
    {
      border: "#41A906",
      background: "#7BE141",
      highlight: {
        border: "#41A906",
        background: "#A1EC76"
      },
      hover: {
        border: "#41A906",
        background: "#A1EC76"
      }
    }, // 3: green
    {
      border: "#E129F0",
      background: "#EB7DF4",
      highlight: {
        border: "#E129F0",
        background: "#F0B3F5"
      },
      hover: {
        border: "#E129F0",
        background: "#F0B3F5"
      }
    }, // 4: magenta
    {
      border: "#7C29F0",
      background: "#AD85E4",
      highlight: {
        border: "#7C29F0",
        background: "#D3BDF0"
      },
      hover: {
        border: "#7C29F0",
        background: "#D3BDF0"
      }
    }, // 5: purple
    {
      border: "#C37F00",
      background: "#FFA807",
      highlight: {
        border: "#C37F00",
        background: "#FFCA66"
      },
      hover: {
        border: "#C37F00",
        background: "#FFCA66"
      }
    }, // 6: orange
    {
      border: "#4220FB",
      background: "#6E6EFD",
      highlight: {
        border: "#4220FB",
        background: "#9B9BFD"
      },
      hover: {
        border: "#4220FB",
        background: "#9B9BFD"
      }
    }, // 7: darkblue
    {
      border: "#FD5A77",
      background: "#FFC0CB",
      highlight: {
        border: "#FD5A77",
        background: "#FFD1D9"
      },
      hover: {
        border: "#FD5A77",
        background: "#FFD1D9"
      }
    }, // 8: pink
    {
      border: "#4AD63A",
      background: "#C2FABC",
      highlight: {
        border: "#4AD63A",
        background: "#E6FFE3"
      },
      hover: {
        border: "#4AD63A",
        background: "#E6FFE3"
      }
    }, // 9: mint
    {
      border: "#990000",
      background: "#EE0000",
      highlight: {
        border: "#BB0000",
        background: "#FF3333"
      },
      hover: {
        border: "#BB0000",
        background: "#FF3333"
      }
    }, // 10:bright red
    {
      border: "#FF6000",
      background: "#FF6000",
      highlight: {
        border: "#FF6000",
        background: "#FF6000"
      },
      hover: {
        border: "#FF6000",
        background: "#FF6000"
      }
    }, // 12: real orange
    {
      border: "#97C2FC",
      background: "#2B7CE9",
      highlight: {
        border: "#D2E5FF",
        background: "#2B7CE9"
      },
      hover: {
        border: "#D2E5FF",
        background: "#2B7CE9"
      }
    }, // 13: blue
    {
      border: "#399605",
      background: "#255C03",
      highlight: {
        border: "#399605",
        background: "#255C03"
      },
      hover: {
        border: "#399605",
        background: "#255C03"
      }
    }, // 14: green
    {
      border: "#B70054",
      background: "#FF007E",
      highlight: {
        border: "#B70054",
        background: "#FF007E"
      },
      hover: {
        border: "#B70054",
        background: "#FF007E"
      }
    }, // 15: magenta
    {
      border: "#AD85E4",
      background: "#7C29F0",
      highlight: {
        border: "#D3BDF0",
        background: "#7C29F0"
      },
      hover: {
        border: "#D3BDF0",
        background: "#7C29F0"
      }
    }, // 16: purple
    {
      border: "#4557FA",
      background: "#000EA1",
      highlight: {
        border: "#6E6EFD",
        background: "#000EA1"
      },
      hover: {
        border: "#6E6EFD",
        background: "#000EA1"
      }
    }, // 17: darkblue
    {
      border: "#FFC0CB",
      background: "#FD5A77",
      highlight: {
        border: "#FFD1D9",
        background: "#FD5A77"
      },
      hover: {
        border: "#FFD1D9",
        background: "#FD5A77"
      }
    }, // 18: pink
    {
      border: "#C2FABC",
      background: "#74D66A",
      highlight: {
        border: "#E6FFE3",
        background: "#74D66A"
      },
      hover: {
        border: "#E6FFE3",
        background: "#74D66A"
      }
    }, // 19: mint
    {
      border: "#EE0000",
      background: "#990000",
      highlight: {
        border: "#FF3333",
        background: "#BB0000"
      },
      hover: {
        border: "#FF3333",
        background: "#BB0000"
      }
    } // 20:bright red
    ];
    this.options = {};
    this.defaultOptions = {
      useDefaultGroups: true
    };

    assign$2(this.options, this.defaultOptions);
  }
  /**
   *
   * @param {object} options
   */


  _createClass(Groups, [{
    key: "setOptions",
    value: function setOptions(options) {
      var optionFields = ["useDefaultGroups"];

      if (options !== undefined) {
        for (var groupName in options) {
          if (Object.prototype.hasOwnProperty.call(options, groupName)) {
            if (indexOf(optionFields).call(optionFields, groupName) === -1) {
              var group = options[groupName];
              this.add(groupName, group);
            }
          }
        }
      }
    }
    /**
     * Clear all groups
     */

  }, {
    key: "clear",
    value: function clear() {
      this._groups = new map();
      this._groupNames = [];
    }
    /**
     * Get group options of a groupname.
     * If groupname is not found, a new group may be created.
     *
     * @param {*}       groupname     Can be a number, string, Date, etc.
     * @param {boolean} [shouldCreate=true] If true, create a new group
     * @returns {object} The found or created group
     */

  }, {
    key: "get",
    value: function get(groupname) {
      var shouldCreate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      var group = this._groups.get(groupname);

      if (group === undefined && shouldCreate) {
        if (this.options.useDefaultGroups === false && this._groupNames.length > 0) {
          // create new group
          var index = this._groupIndex % this._groupNames.length;
          ++this._groupIndex;
          group = {};
          group.color = this._groups.get(this._groupNames[index]);

          this._groups.set(groupname, group);
        } else {
          // create new group
          var _index = this._defaultIndex % this._defaultGroups.length;

          this._defaultIndex++;
          group = {};
          group.color = this._defaultGroups[_index];

          this._groups.set(groupname, group);
        }
      }

      return group;
    }
    /**
     * Add custom group style.
     *
     * @param {string} groupName - The name of the group, a new group will be
     * created if a group with the same name doesn't exist, otherwise the old
     * groups style will be overwritten.
     * @param {object} style - An object containing borderColor, backgroundColor,
     * etc.
     * @returns {object} The created group object.
     */

  }, {
    key: "add",
    value: function add(groupName, style) {
      // Only push group name once to prevent duplicates which would consume more
      // RAM and also skew the distribution towards more often updated groups,
      // neither of which is desirable.
      if (!this._groups.has(groupName)) {
        this._groupNames.push(groupName);
      }

      this._groups.set(groupName, style);

      return style;
    }
  }]);

  return Groups;
}();

var $$c = _export; // `Number.isNaN` method
// https://tc39.es/ecma262/#sec-number.isnan

$$c({
  target: 'Number',
  stat: true
}, {
  isNaN: function isNaN(number) {
    // eslint-disable-next-line no-self-compare -- NaN check
    return number != number;
  }
});

var path$a = path$x;
var isNan$2 = path$a.Number.isNaN;

var parent$o = isNan$2;
var isNan$1 = parent$o;

var isNan = isNan$1;

var global$4 = global$k;
var globalIsFinite = global$4.isFinite; // `Number.isFinite` method
// https://tc39.es/ecma262/#sec-number.isfinite
// eslint-disable-next-line es/no-number-isfinite -- safe

var numberIsFinite$1 = Number.isFinite || function isFinite(it) {
  return typeof it == 'number' && globalIsFinite(it);
};

var $$b = _export;
var numberIsFinite = numberIsFinite$1; // `Number.isFinite` method
// https://tc39.es/ecma262/#sec-number.isfinite

$$b({
  target: 'Number',
  stat: true
}, {
  isFinite: numberIsFinite
});

var path$9 = path$x;
var _isFinite$2 = path$9.Number.isFinite;

var parent$n = _isFinite$2;
var _isFinite$1 = parent$n;

var _isFinite = _isFinite$1;

var $$a = _export;
var $some = arrayIteration.some;
var arrayMethodIsStrict$3 = arrayMethodIsStrict$6;
var STRICT_METHOD$3 = arrayMethodIsStrict$3('some'); // `Array.prototype.some` method
// https://tc39.es/ecma262/#sec-array.prototype.some

$$a({
  target: 'Array',
  proto: true,
  forced: !STRICT_METHOD$3
}, {
  some: function some(callbackfn
  /* , thisArg */
  ) {
    return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$7 = entryVirtual$l;
var some$3 = entryVirtual$7('Array').some;

var some$2 = some$3;
var ArrayPrototype$7 = Array.prototype;

var some_1 = function (it) {
  var own = it.some;
  return it === ArrayPrototype$7 || it instanceof Array && own === ArrayPrototype$7.some ? some$2 : own;
};

var parent$m = some_1;
var some$1 = parent$m;

var some = some$1;

var $$9 = _export;
var getBuiltIn = getBuiltIn$8;
var aFunction$3 = aFunction$6;
var anObject$3 = anObject$d;
var isObject$3 = isObject$j;
var create$2 = objectCreate;
var bind$1 = functionBind;
var fails$2 = fails$m;
var nativeConstruct = getBuiltIn('Reflect', 'construct'); // `Reflect.construct` method
// https://tc39.es/ecma262/#sec-reflect.construct
// MS Edge supports only 2 arguments and argumentsList argument is optional
// FF Nightly sets third argument as `new.target`, but does not create `this` from it

var NEW_TARGET_BUG = fails$2(function () {
  function F() {
    /* empty */
  }

  return !(nativeConstruct(function () {
    /* empty */
  }, [], F) instanceof F);
});
var ARGS_BUG = !fails$2(function () {
  nativeConstruct(function () {
    /* empty */
  });
});
var FORCED$2 = NEW_TARGET_BUG || ARGS_BUG;
$$9({
  target: 'Reflect',
  stat: true,
  forced: FORCED$2,
  sham: FORCED$2
}, {
  construct: function construct(Target, args
  /* , newTarget */
  ) {
    aFunction$3(Target);
    anObject$3(args);
    var newTarget = arguments.length < 3 ? Target : aFunction$3(arguments[2]);
    if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);

    if (Target == newTarget) {
      // w/o altered newTarget, optimization for 0-4 arguments
      switch (args.length) {
        case 0:
          return new Target();

        case 1:
          return new Target(args[0]);

        case 2:
          return new Target(args[0], args[1]);

        case 3:
          return new Target(args[0], args[1], args[2]);

        case 4:
          return new Target(args[0], args[1], args[2], args[3]);
      } // w/o altered newTarget, lot of arguments case


      var $args = [null];
      $args.push.apply($args, args);
      return new (bind$1.apply(Target, $args))();
    } // with altered newTarget, not support built-in constructors


    var proto = newTarget.prototype;
    var instance = create$2(isObject$3(proto) ? proto : Object.prototype);
    var result = Function.apply.call(Target, instance, args);
    return isObject$3(result) ? result : instance;
  }
});

var path$8 = path$x;
var construct$2 = path$8.Reflect.construct;

var parent$l = construct$2;
var construct$1 = parent$l;

var construct = construct$1;

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

var parent$k = create$5;
var create$1 = parent$k;

var create = create$1;

var $$8 = _export;
var setPrototypeOf$4 = objectSetPrototypeOf; // `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof

$$8({
  target: 'Object',
  stat: true
}, {
  setPrototypeOf: setPrototypeOf$4
});

var path$7 = path$x;
var setPrototypeOf$3 = path$7.Object.setPrototypeOf;

var parent$j = setPrototypeOf$3;
var setPrototypeOf$2 = parent$j;

var parent$i = setPrototypeOf$2;
var setPrototypeOf$1 = parent$i;

var setPrototypeOf = setPrototypeOf$1;

function _setPrototypeOf(o, p) {
  _setPrototypeOf = setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  } else if (call !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }

  return _assertThisInitialized(self);
}

var parent$h = getPrototypeOf$4;
var getPrototypeOf$2 = parent$h;

var getPrototypeOf$1 = getPrototypeOf$2;

function _getPrototypeOf(o) {
  _getPrototypeOf = setPrototypeOf ? getPrototypeOf$1 : function _getPrototypeOf(o) {
    return o.__proto__ || getPrototypeOf$1(o);
  };
  return _getPrototypeOf(o);
}

var runtime = {exports: {}};

/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

(function (module) {
  var runtime = function (exports) {

    var Op = Object.prototype;
    var hasOwn = Op.hasOwnProperty;
    var undefined$1; // More compressible than void 0.

    var $Symbol = typeof Symbol === "function" ? Symbol : {};
    var iteratorSymbol = $Symbol.iterator || "@@iterator";
    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

    function define(obj, key, value) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
      return obj[key];
    }

    try {
      // IE 8 has a broken Object.defineProperty that only works on DOM objects.
      define({}, "");
    } catch (err) {
      define = function (obj, key, value) {
        return obj[key] = value;
      };
    }

    function wrap(innerFn, outerFn, self, tryLocsList) {
      // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
      var generator = Object.create(protoGenerator.prototype);
      var context = new Context(tryLocsList || []); // The ._invoke method unifies the implementations of the .next,
      // .throw, and .return methods.

      generator._invoke = makeInvokeMethod(innerFn, self, context);
      return generator;
    }

    exports.wrap = wrap; // Try/catch helper to minimize deoptimizations. Returns a completion
    // record like context.tryEntries[i].completion. This interface could
    // have been (and was previously) designed to take a closure to be
    // invoked without arguments, but in all the cases we care about we
    // already have an existing method we want to call, so there's no need
    // to create a new function object. We can even get away with assuming
    // the method takes exactly one argument, since that happens to be true
    // in every case, so we don't have to touch the arguments object. The
    // only additional allocation required is the completion record, which
    // has a stable shape and so hopefully should be cheap to allocate.

    function tryCatch(fn, obj, arg) {
      try {
        return {
          type: "normal",
          arg: fn.call(obj, arg)
        };
      } catch (err) {
        return {
          type: "throw",
          arg: err
        };
      }
    }

    var GenStateSuspendedStart = "suspendedStart";
    var GenStateSuspendedYield = "suspendedYield";
    var GenStateExecuting = "executing";
    var GenStateCompleted = "completed"; // Returning this object from the innerFn has the same effect as
    // breaking out of the dispatch switch statement.

    var ContinueSentinel = {}; // Dummy constructor functions that we use as the .constructor and
    // .constructor.prototype properties for functions that return Generator
    // objects. For full spec compliance, you may wish to configure your
    // minifier not to mangle the names of these two functions.

    function Generator() {}

    function GeneratorFunction() {}

    function GeneratorFunctionPrototype() {} // This is a polyfill for %IteratorPrototype% for environments that
    // don't natively support it.


    var IteratorPrototype = {};

    IteratorPrototype[iteratorSymbol] = function () {
      return this;
    };

    var getProto = Object.getPrototypeOf;
    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));

    if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
      // This environment has a native %IteratorPrototype%; use it instead
      // of the polyfill.
      IteratorPrototype = NativeIteratorPrototype;
    }

    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
    GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
    GeneratorFunctionPrototype.constructor = GeneratorFunction;
    GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"); // Helper for defining the .next, .throw, and .return methods of the
    // Iterator interface in terms of a single ._invoke method.

    function defineIteratorMethods(prototype) {
      ["next", "throw", "return"].forEach(function (method) {
        define(prototype, method, function (arg) {
          return this._invoke(method, arg);
        });
      });
    }

    exports.isGeneratorFunction = function (genFun) {
      var ctor = typeof genFun === "function" && genFun.constructor;
      return ctor ? ctor === GeneratorFunction || // For the native GeneratorFunction constructor, the best we can
      // do is to check its .name property.
      (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
    };

    exports.mark = function (genFun) {
      if (Object.setPrototypeOf) {
        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
      } else {
        genFun.__proto__ = GeneratorFunctionPrototype;
        define(genFun, toStringTagSymbol, "GeneratorFunction");
      }

      genFun.prototype = Object.create(Gp);
      return genFun;
    }; // Within the body of any async function, `await x` is transformed to
    // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
    // `hasOwn.call(value, "__await")` to determine if the yielded value is
    // meant to be awaited.


    exports.awrap = function (arg) {
      return {
        __await: arg
      };
    };

    function AsyncIterator(generator, PromiseImpl) {
      function invoke(method, arg, resolve, reject) {
        var record = tryCatch(generator[method], generator, arg);

        if (record.type === "throw") {
          reject(record.arg);
        } else {
          var result = record.arg;
          var value = result.value;

          if (value && typeof value === "object" && hasOwn.call(value, "__await")) {
            return PromiseImpl.resolve(value.__await).then(function (value) {
              invoke("next", value, resolve, reject);
            }, function (err) {
              invoke("throw", err, resolve, reject);
            });
          }

          return PromiseImpl.resolve(value).then(function (unwrapped) {
            // When a yielded Promise is resolved, its final value becomes
            // the .value of the Promise<{value,done}> result for the
            // current iteration.
            result.value = unwrapped;
            resolve(result);
          }, function (error) {
            // If a rejected Promise was yielded, throw the rejection back
            // into the async generator function so it can be handled there.
            return invoke("throw", error, resolve, reject);
          });
        }
      }

      var previousPromise;

      function enqueue(method, arg) {
        function callInvokeWithMethodAndArg() {
          return new PromiseImpl(function (resolve, reject) {
            invoke(method, arg, resolve, reject);
          });
        }

        return previousPromise = // If enqueue has been called before, then we want to wait until
        // all previous Promises have been resolved before calling invoke,
        // so that results are always delivered in the correct order. If
        // enqueue has not been called before, then it is important to
        // call invoke immediately, without waiting on a callback to fire,
        // so that the async generator function has the opportunity to do
        // any necessary setup in a predictable way. This predictability
        // is why the Promise constructor synchronously invokes its
        // executor callback, and why async functions synchronously
        // execute code before the first await. Since we implement simple
        // async functions in terms of async generators, it is especially
        // important to get this right, even though it requires care.
        previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, // Avoid propagating failures to Promises returned by later
        // invocations of the iterator.
        callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
      } // Define the unified helper method that is used to implement .next,
      // .throw, and .return (see defineIteratorMethods).


      this._invoke = enqueue;
    }

    defineIteratorMethods(AsyncIterator.prototype);

    AsyncIterator.prototype[asyncIteratorSymbol] = function () {
      return this;
    };

    exports.AsyncIterator = AsyncIterator; // Note that simple async functions are implemented on top of
    // AsyncIterator objects; they just return a Promise for the value of
    // the final result produced by the iterator.

    exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
      if (PromiseImpl === void 0) PromiseImpl = Promise;
      var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
      return exports.isGeneratorFunction(outerFn) ? iter // If outerFn is a generator, return the full iterator.
      : iter.next().then(function (result) {
        return result.done ? result.value : iter.next();
      });
    };

    function makeInvokeMethod(innerFn, self, context) {
      var state = GenStateSuspendedStart;
      return function invoke(method, arg) {
        if (state === GenStateExecuting) {
          throw new Error("Generator is already running");
        }

        if (state === GenStateCompleted) {
          if (method === "throw") {
            throw arg;
          } // Be forgiving, per 25.3.3.3.3 of the spec:
          // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume


          return doneResult();
        }

        context.method = method;
        context.arg = arg;

        while (true) {
          var delegate = context.delegate;

          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context);

            if (delegateResult) {
              if (delegateResult === ContinueSentinel) continue;
              return delegateResult;
            }
          }

          if (context.method === "next") {
            // Setting context._sent for legacy support of Babel's
            // function.sent implementation.
            context.sent = context._sent = context.arg;
          } else if (context.method === "throw") {
            if (state === GenStateSuspendedStart) {
              state = GenStateCompleted;
              throw context.arg;
            }

            context.dispatchException(context.arg);
          } else if (context.method === "return") {
            context.abrupt("return", context.arg);
          }

          state = GenStateExecuting;
          var record = tryCatch(innerFn, self, context);

          if (record.type === "normal") {
            // If an exception is thrown from innerFn, we leave state ===
            // GenStateExecuting and loop back for another invocation.
            state = context.done ? GenStateCompleted : GenStateSuspendedYield;

            if (record.arg === ContinueSentinel) {
              continue;
            }

            return {
              value: record.arg,
              done: context.done
            };
          } else if (record.type === "throw") {
            state = GenStateCompleted; // Dispatch the exception by looping back around to the
            // context.dispatchException(context.arg) call above.

            context.method = "throw";
            context.arg = record.arg;
          }
        }
      };
    } // Call delegate.iterator[context.method](context.arg) and handle the
    // result, either by returning a { value, done } result from the
    // delegate iterator, or by modifying context.method and context.arg,
    // setting context.delegate to null, and returning the ContinueSentinel.


    function maybeInvokeDelegate(delegate, context) {
      var method = delegate.iterator[context.method];

      if (method === undefined$1) {
        // A .throw or .return when the delegate iterator has no .throw
        // method always terminates the yield* loop.
        context.delegate = null;

        if (context.method === "throw") {
          // Note: ["return"] must be used for ES3 parsing compatibility.
          if (delegate.iterator["return"]) {
            // If the delegate iterator has a return method, give it a
            // chance to clean up.
            context.method = "return";
            context.arg = undefined$1;
            maybeInvokeDelegate(delegate, context);

            if (context.method === "throw") {
              // If maybeInvokeDelegate(context) changed context.method from
              // "return" to "throw", let that override the TypeError below.
              return ContinueSentinel;
            }
          }

          context.method = "throw";
          context.arg = new TypeError("The iterator does not provide a 'throw' method");
        }

        return ContinueSentinel;
      }

      var record = tryCatch(method, delegate.iterator, context.arg);

      if (record.type === "throw") {
        context.method = "throw";
        context.arg = record.arg;
        context.delegate = null;
        return ContinueSentinel;
      }

      var info = record.arg;

      if (!info) {
        context.method = "throw";
        context.arg = new TypeError("iterator result is not an object");
        context.delegate = null;
        return ContinueSentinel;
      }

      if (info.done) {
        // Assign the result of the finished delegate to the temporary
        // variable specified by delegate.resultName (see delegateYield).
        context[delegate.resultName] = info.value; // Resume execution at the desired location (see delegateYield).

        context.next = delegate.nextLoc; // If context.method was "throw" but the delegate handled the
        // exception, let the outer generator proceed normally. If
        // context.method was "next", forget context.arg since it has been
        // "consumed" by the delegate iterator. If context.method was
        // "return", allow the original .return call to continue in the
        // outer generator.

        if (context.method !== "return") {
          context.method = "next";
          context.arg = undefined$1;
        }
      } else {
        // Re-yield the result returned by the delegate method.
        return info;
      } // The delegate iterator is finished, so forget it and continue with
      // the outer generator.


      context.delegate = null;
      return ContinueSentinel;
    } // Define Generator.prototype.{next,throw,return} in terms of the
    // unified ._invoke helper method.


    defineIteratorMethods(Gp);
    define(Gp, toStringTagSymbol, "Generator"); // A Generator should always return itself as the iterator object when the
    // @@iterator function is called on it. Some browsers' implementations of the
    // iterator prototype chain incorrectly implement this, causing the Generator
    // object to not be returned from this call. This ensures that doesn't happen.
    // See https://github.com/facebook/regenerator/issues/274 for more details.

    Gp[iteratorSymbol] = function () {
      return this;
    };

    Gp.toString = function () {
      return "[object Generator]";
    };

    function pushTryEntry(locs) {
      var entry = {
        tryLoc: locs[0]
      };

      if (1 in locs) {
        entry.catchLoc = locs[1];
      }

      if (2 in locs) {
        entry.finallyLoc = locs[2];
        entry.afterLoc = locs[3];
      }

      this.tryEntries.push(entry);
    }

    function resetTryEntry(entry) {
      var record = entry.completion || {};
      record.type = "normal";
      delete record.arg;
      entry.completion = record;
    }

    function Context(tryLocsList) {
      // The root entry object (effectively a try statement without a catch
      // or a finally block) gives us a place to store values thrown from
      // locations where there is no enclosing try statement.
      this.tryEntries = [{
        tryLoc: "root"
      }];
      tryLocsList.forEach(pushTryEntry, this);
      this.reset(true);
    }

    exports.keys = function (object) {
      var keys = [];

      for (var key in object) {
        keys.push(key);
      }

      keys.reverse(); // Rather than returning an object with a next method, we keep
      // things simple and return the next function itself.

      return function next() {
        while (keys.length) {
          var key = keys.pop();

          if (key in object) {
            next.value = key;
            next.done = false;
            return next;
          }
        } // To avoid creating an additional object, we just hang the .value
        // and .done properties off the next function object itself. This
        // also ensures that the minifier will not anonymize the function.


        next.done = true;
        return next;
      };
    };

    function values(iterable) {
      if (iterable) {
        var iteratorMethod = iterable[iteratorSymbol];

        if (iteratorMethod) {
          return iteratorMethod.call(iterable);
        }

        if (typeof iterable.next === "function") {
          return iterable;
        }

        if (!isNaN(iterable.length)) {
          var i = -1,
              next = function next() {
            while (++i < iterable.length) {
              if (hasOwn.call(iterable, i)) {
                next.value = iterable[i];
                next.done = false;
                return next;
              }
            }

            next.value = undefined$1;
            next.done = true;
            return next;
          };

          return next.next = next;
        }
      } // Return an iterator with no values.


      return {
        next: doneResult
      };
    }

    exports.values = values;

    function doneResult() {
      return {
        value: undefined$1,
        done: true
      };
    }

    Context.prototype = {
      constructor: Context,
      reset: function (skipTempReset) {
        this.prev = 0;
        this.next = 0; // Resetting context._sent for legacy support of Babel's
        // function.sent implementation.

        this.sent = this._sent = undefined$1;
        this.done = false;
        this.delegate = null;
        this.method = "next";
        this.arg = undefined$1;
        this.tryEntries.forEach(resetTryEntry);

        if (!skipTempReset) {
          for (var name in this) {
            // Not sure about the optimal order of these conditions:
            if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
              this[name] = undefined$1;
            }
          }
        }
      },
      stop: function () {
        this.done = true;
        var rootEntry = this.tryEntries[0];
        var rootRecord = rootEntry.completion;

        if (rootRecord.type === "throw") {
          throw rootRecord.arg;
        }

        return this.rval;
      },
      dispatchException: function (exception) {
        if (this.done) {
          throw exception;
        }

        var context = this;

        function handle(loc, caught) {
          record.type = "throw";
          record.arg = exception;
          context.next = loc;

          if (caught) {
            // If the dispatched exception was caught by a catch block,
            // then let that catch block handle the exception normally.
            context.method = "next";
            context.arg = undefined$1;
          }

          return !!caught;
        }

        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          var record = entry.completion;

          if (entry.tryLoc === "root") {
            // Exception thrown outside of any try block that could handle
            // it, so set the completion value of the entire function to
            // throw the exception.
            return handle("end");
          }

          if (entry.tryLoc <= this.prev) {
            var hasCatch = hasOwn.call(entry, "catchLoc");
            var hasFinally = hasOwn.call(entry, "finallyLoc");

            if (hasCatch && hasFinally) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              } else if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }
            } else if (hasCatch) {
              if (this.prev < entry.catchLoc) {
                return handle(entry.catchLoc, true);
              }
            } else if (hasFinally) {
              if (this.prev < entry.finallyLoc) {
                return handle(entry.finallyLoc);
              }
            } else {
              throw new Error("try statement without catch or finally");
            }
          }
        }
      },
      abrupt: function (type, arg) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];

          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
            var finallyEntry = entry;
            break;
          }
        }

        if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
          // Ignore the finally entry if control is not jumping to a
          // location outside the try/catch block.
          finallyEntry = null;
        }

        var record = finallyEntry ? finallyEntry.completion : {};
        record.type = type;
        record.arg = arg;

        if (finallyEntry) {
          this.method = "next";
          this.next = finallyEntry.finallyLoc;
          return ContinueSentinel;
        }

        return this.complete(record);
      },
      complete: function (record, afterLoc) {
        if (record.type === "throw") {
          throw record.arg;
        }

        if (record.type === "break" || record.type === "continue") {
          this.next = record.arg;
        } else if (record.type === "return") {
          this.rval = this.arg = record.arg;
          this.method = "return";
          this.next = "end";
        } else if (record.type === "normal" && afterLoc) {
          this.next = afterLoc;
        }

        return ContinueSentinel;
      },
      finish: function (finallyLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];

          if (entry.finallyLoc === finallyLoc) {
            this.complete(entry.completion, entry.afterLoc);
            resetTryEntry(entry);
            return ContinueSentinel;
          }
        }
      },
      "catch": function (tryLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];

          if (entry.tryLoc === tryLoc) {
            var record = entry.completion;

            if (record.type === "throw") {
              var thrown = record.arg;
              resetTryEntry(entry);
            }

            return thrown;
          }
        } // The context.catch method must only be called with a location
        // argument that corresponds to a known catch block.


        throw new Error("illegal catch attempt");
      },
      delegateYield: function (iterable, resultName, nextLoc) {
        this.delegate = {
          iterator: values(iterable),
          resultName: resultName,
          nextLoc: nextLoc
        };

        if (this.method === "next") {
          // Deliberately forget the last sent value so that we don't
          // accidentally pass it on to the delegate.
          this.arg = undefined$1;
        }

        return ContinueSentinel;
      }
    }; // Regardless of whether this script is executing as a CommonJS module
    // or not, return the runtime object so that we can declare the variable
    // regeneratorRuntime in the outer scope, which allows this module to be
    // injected easily by `bin/regenerator --include-runtime script.js`.

    return exports;
  }( // If this script is executing as a CommonJS module, use module.exports
  // as the regeneratorRuntime namespace. Otherwise create a new empty
  // object. Either way, the resulting object will be used to initialize
  // the regeneratorRuntime variable at the top of this file.
  module.exports );

  try {
    regeneratorRuntime = runtime;
  } catch (accidentalStrictMode) {
    // This module should not be running in strict mode, so the above
    // assignment should always work unless something is misconfigured. Just
    // in case runtime.js accidentally runs in strict mode, we can escape
    // strict mode using a global Function call. This could conceivably fail
    // if a Content Security Policy forbids using Function, but in that case
    // the proper solution is to fix the accidental strict mode problem. If
    // you've misconfigured your bundler to force strict mode and applied a
    // CSP to forbid Function, and you're not willing to fix either of those
    // problems, please detail your unique predicament in a GitHub issue.
    Function("r", "regeneratorRuntime = r")(runtime);
  }
})(runtime);

var regenerator = runtime.exports;

var aFunction$2 = aFunction$6;
var toObject$2 = toObject$e;
var IndexedObject = indexedObject;
var toLength$3 = toLength$c; // `Array.prototype.{ reduce, reduceRight }` methods implementation

var createMethod = function (IS_RIGHT) {
  return function (that, callbackfn, argumentsLength, memo) {
    aFunction$2(callbackfn);
    var O = toObject$2(that);
    var self = IndexedObject(O);
    var length = toLength$3(O.length);
    var index = IS_RIGHT ? length - 1 : 0;
    var i = IS_RIGHT ? -1 : 1;
    if (argumentsLength < 2) while (true) {
      if (index in self) {
        memo = self[index];
        index += i;
        break;
      }

      index += i;

      if (IS_RIGHT ? index < 0 : length <= index) {
        throw TypeError('Reduce of empty array with no initial value');
      }
    }

    for (; IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
      memo = callbackfn(memo, self[index], index, O);
    }

    return memo;
  };
};

var arrayReduce = {
  // `Array.prototype.reduce` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduce
  left: createMethod(false),
  // `Array.prototype.reduceRight` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
  right: createMethod(true)
};

var classof$3 = classofRaw$1;
var global$3 = global$k;
var engineIsNode = classof$3(global$3.process) == 'process';

var $$7 = _export;
var $reduce = arrayReduce.left;
var arrayMethodIsStrict$2 = arrayMethodIsStrict$6;
var CHROME_VERSION = engineV8Version;
var IS_NODE = engineIsNode;
var STRICT_METHOD$2 = arrayMethodIsStrict$2('reduce'); // Chrome 80-82 has a critical bug
// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982

var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83; // `Array.prototype.reduce` method
// https://tc39.es/ecma262/#sec-array.prototype.reduce

$$7({
  target: 'Array',
  proto: true,
  forced: !STRICT_METHOD$2 || CHROME_BUG
}, {
  reduce: function reduce(callbackfn
  /* , initialValue */
  ) {
    return $reduce(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$6 = entryVirtual$l;
var reduce$3 = entryVirtual$6('Array').reduce;

var reduce$2 = reduce$3;
var ArrayPrototype$6 = Array.prototype;

var reduce_1 = function (it) {
  var own = it.reduce;
  return it === ArrayPrototype$6 || it instanceof Array && own === ArrayPrototype$6.reduce ? reduce$2 : own;
};

var parent$g = reduce_1;
var reduce$1 = parent$g;

var reduce = reduce$1;

var isArray = isArray$c;
var toLength$2 = toLength$c;
var bind = functionBindContext; // `FlattenIntoArray` abstract operation
// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray

var flattenIntoArray$1 = function (target, original, source, sourceLen, start, depth, mapper, thisArg) {
  var targetIndex = start;
  var sourceIndex = 0;
  var mapFn = mapper ? bind(mapper, thisArg, 3) : false;
  var element;

  while (sourceIndex < sourceLen) {
    if (sourceIndex in source) {
      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

      if (depth > 0 && isArray(element)) {
        targetIndex = flattenIntoArray$1(target, original, element, toLength$2(element.length), targetIndex, depth - 1) - 1;
      } else {
        if (targetIndex >= 0x1FFFFFFFFFFFFF) throw TypeError('Exceed the acceptable array length');
        target[targetIndex] = element;
      }

      targetIndex++;
    }

    sourceIndex++;
  }

  return targetIndex;
};

var flattenIntoArray_1 = flattenIntoArray$1;

var $$6 = _export;
var flattenIntoArray = flattenIntoArray_1;
var toObject$1 = toObject$e;
var toLength$1 = toLength$c;
var aFunction$1 = aFunction$6;
var arraySpeciesCreate = arraySpeciesCreate$4; // `Array.prototype.flatMap` method
// https://tc39.es/ecma262/#sec-array.prototype.flatmap

$$6({
  target: 'Array',
  proto: true
}, {
  flatMap: function flatMap(callbackfn
  /* , thisArg */
  ) {
    var O = toObject$1(this);
    var sourceLen = toLength$1(O.length);
    var A;
    aFunction$1(callbackfn);
    A = arraySpeciesCreate(O, 0);
    A.length = flattenIntoArray(A, O, O, sourceLen, 0, 1, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    return A;
  }
});

var entryVirtual$5 = entryVirtual$l;
var flatMap$3 = entryVirtual$5('Array').flatMap;

var flatMap$2 = flatMap$3;
var ArrayPrototype$5 = Array.prototype;

var flatMap_1 = function (it) {
  var own = it.flatMap;
  return it === ArrayPrototype$5 || it instanceof Array && own === ArrayPrototype$5.flatMap ? flatMap$2 : own;
};

var parent$f = flatMap_1;
var flatMap$1 = parent$f;

var flatMap = flatMap$1;

var collection$1 = collection$3;
var collectionStrong = collectionStrong$2; // `Set` constructor
// https://tc39.es/ecma262/#sec-set-objects

collection$1('Set', function (init) {
  return function Set() {
    return init(this, arguments.length ? arguments[0] : undefined);
  };
}, collectionStrong);

var path$6 = path$x;
var set$2 = path$6.Set;

var parent$e = set$2;
var set$1 = parent$e;

var set = set$1;

var iterator = iterator$3;

var anObject$2 = anObject$d;
var getIteratorMethod = getIteratorMethod$7;

var getIterator$4 = function (it) {
  var iteratorMethod = getIteratorMethod(it);

  if (typeof iteratorMethod != 'function') {
    throw TypeError(String(it) + ' is not iterable');
  }

  return anObject$2(iteratorMethod.call(it));
};

var getIterator$3 = getIterator$4;
var getIterator_1 = getIterator$3;

var parent$d = getIterator_1;
var getIterator$2 = parent$d;

var parent$c = getIterator$2;
var getIterator$1 = parent$c;

var getIterator = getIterator$1;

var floor = Math.floor;

var mergeSort = function (array, comparefn) {
  var length = array.length;
  var middle = floor(length / 2);
  return length < 8 ? insertionSort(array, comparefn) : merge(mergeSort(array.slice(0, middle), comparefn), mergeSort(array.slice(middle), comparefn), comparefn);
};

var insertionSort = function (array, comparefn) {
  var length = array.length;
  var i = 1;
  var element, j;

  while (i < length) {
    j = i;
    element = array[i];

    while (j && comparefn(array[j - 1], element) > 0) {
      array[j] = array[--j];
    }

    if (j !== i++) array[j] = element;
  }

  return array;
};

var merge = function (left, right, comparefn) {
  var llength = left.length;
  var rlength = right.length;
  var lindex = 0;
  var rindex = 0;
  var result = [];

  while (lindex < llength || rindex < rlength) {
    if (lindex < llength && rindex < rlength) {
      result.push(comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++]);
    } else {
      result.push(lindex < llength ? left[lindex++] : right[rindex++]);
    }
  }

  return result;
};

var arraySort = mergeSort;

var userAgent$1 = engineUserAgent;
var firefox = userAgent$1.match(/firefox\/(\d+)/i);
var engineFfVersion = !!firefox && +firefox[1];

var UA = engineUserAgent;
var engineIsIeOrEdge = /MSIE|Trident/.test(UA);

var userAgent = engineUserAgent;
var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);
var engineWebkitVersion = !!webkit && +webkit[1];

var $$5 = _export;
var aFunction = aFunction$6;
var toObject = toObject$e;
var toLength = toLength$c;
var toString$1 = toString$9;
var fails$1 = fails$m;
var internalSort = arraySort;
var arrayMethodIsStrict$1 = arrayMethodIsStrict$6;
var FF = engineFfVersion;
var IE_OR_EDGE = engineIsIeOrEdge;
var V8 = engineV8Version;
var WEBKIT = engineWebkitVersion;
var test = [];
var nativeSort = test.sort; // IE8-

var FAILS_ON_UNDEFINED = fails$1(function () {
  test.sort(undefined);
}); // V8 bug

var FAILS_ON_NULL = fails$1(function () {
  test.sort(null);
}); // Old WebKit

var STRICT_METHOD$1 = arrayMethodIsStrict$1('sort');
var STABLE_SORT = !fails$1(function () {
  // feature detection can be too slow, so check engines versions
  if (V8) return V8 < 70;
  if (FF && FF > 3) return;
  if (IE_OR_EDGE) return true;
  if (WEBKIT) return WEBKIT < 603;
  var result = '';
  var code, chr, value, index; // generate an array with more 512 elements (Chakra and old V8 fails only in this case)

  for (code = 65; code < 76; code++) {
    chr = String.fromCharCode(code);

    switch (code) {
      case 66:
      case 69:
      case 70:
      case 72:
        value = 3;
        break;

      case 68:
      case 71:
        value = 4;
        break;

      default:
        value = 2;
    }

    for (index = 0; index < 47; index++) {
      test.push({
        k: chr + index,
        v: value
      });
    }
  }

  test.sort(function (a, b) {
    return b.v - a.v;
  });

  for (index = 0; index < test.length; index++) {
    chr = test[index].k.charAt(0);
    if (result.charAt(result.length - 1) !== chr) result += chr;
  }

  return result !== 'DGBEFHACIJK';
});
var FORCED$1 = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD$1 || !STABLE_SORT;

var getSortCompare = function (comparefn) {
  return function (x, y) {
    if (y === undefined) return -1;
    if (x === undefined) return 1;
    if (comparefn !== undefined) return +comparefn(x, y) || 0;
    return toString$1(x) > toString$1(y) ? 1 : -1;
  };
}; // `Array.prototype.sort` method
// https://tc39.es/ecma262/#sec-array.prototype.sort


$$5({
  target: 'Array',
  proto: true,
  forced: FORCED$1
}, {
  sort: function sort(comparefn) {
    if (comparefn !== undefined) aFunction(comparefn);
    var array = toObject(this);
    if (STABLE_SORT) return comparefn === undefined ? nativeSort.call(array) : nativeSort.call(array, comparefn);
    var items = [];
    var arrayLength = toLength(array.length);
    var itemsLength, index;

    for (index = 0; index < arrayLength; index++) {
      if (index in array) items.push(array[index]);
    }

    items = internalSort(items, getSortCompare(comparefn));
    itemsLength = items.length;
    index = 0;

    while (index < itemsLength) array[index] = items[index++];

    while (index < arrayLength) delete array[index++];

    return array;
  }
});

var entryVirtual$4 = entryVirtual$l;
var sort$3 = entryVirtual$4('Array').sort;

var sort$2 = sort$3;
var ArrayPrototype$4 = Array.prototype;

var sort_1 = function (it) {
  var own = it.sort;
  return it === ArrayPrototype$4 || it instanceof Array && own === ArrayPrototype$4.sort ? sort$2 : own;
};

var parent$b = sort_1;
var sort$1 = parent$b;

var sort = sort$1;

var entryVirtual$3 = entryVirtual$l;
var keys$3 = entryVirtual$3('Array').keys;

var parent$a = keys$3;
var keys$2 = parent$a;

var keys$1 = keys$2;
var classof$2 = classof$a;
var ArrayPrototype$3 = Array.prototype;
var DOMIterables$2 = {
  DOMTokenList: true,
  NodeList: true
};

var keys_1 = function (it) {
  var own = it.keys;
  return it === ArrayPrototype$3 || it instanceof Array && own === ArrayPrototype$3.keys // eslint-disable-next-line no-prototype-builtins -- safe
  || DOMIterables$2.hasOwnProperty(classof$2(it)) ? keys$1 : own;
};

var keys = keys_1;

var entryVirtual$2 = entryVirtual$l;
var values$3 = entryVirtual$2('Array').values;

var parent$9 = values$3;
var values$2 = parent$9;

var values$1 = values$2;
var classof$1 = classof$a;
var ArrayPrototype$2 = Array.prototype;
var DOMIterables$1 = {
  DOMTokenList: true,
  NodeList: true
};

var values_1 = function (it) {
  var own = it.values;
  return it === ArrayPrototype$2 || it instanceof Array && own === ArrayPrototype$2.values // eslint-disable-next-line no-prototype-builtins -- safe
  || DOMIterables$1.hasOwnProperty(classof$1(it)) ? values$1 : own;
};

var values = values_1;

var entryVirtual$1 = entryVirtual$l;
var entries$3 = entryVirtual$1('Array').entries;

var parent$8 = entries$3;
var entries$2 = parent$8;

var entries$1 = entries$2;
var classof = classof$a;
var ArrayPrototype$1 = Array.prototype;
var DOMIterables = {
  DOMTokenList: true,
  NodeList: true
};

var entries_1 = function (it) {
  var own = it.entries;
  return it === ArrayPrototype$1 || it instanceof Array && own === ArrayPrototype$1.entries // eslint-disable-next-line no-prototype-builtins -- safe
  || DOMIterables.hasOwnProperty(classof(it)) ? entries$1 : own;
};

var entries = entries_1;

// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
var getRandomValues;
var rnds8 = new Uint8Array(16);
function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation. Also,
    // find the complete implementation of crypto (msCrypto) on IE11.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto !== 'undefined' && typeof msCrypto.getRandomValues === 'function' && msCrypto.getRandomValues.bind(msCrypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}

var REGEX = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;

function validate(uuid) {
  return typeof uuid === 'string' && REGEX.test(uuid);
}

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */

var byteToHex = [];

for (var i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).substr(1));
}

function stringify(arr) {
  var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0; // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434

  var uuid = (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase(); // Consistency check for valid UUID.  If this throws, it's likely due to one
  // of the following:
  // - One or more input array values don't map to a hex octet (leading to
  // "undefined" in the uuid)
  // - Invalid input values for the RFC `version` or `variant` fields

  if (!validate(uuid)) {
    throw TypeError('Stringified UUID is invalid');
  }

  return uuid;
}

function v4(options, buf, offset) {
  options = options || {};
  var rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (var i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return stringify(rnds);
}

function ownKeys$4(object, enumerableOnly) { var keys = keys$4(object); if (getOwnPropertySymbols) { var symbols = getOwnPropertySymbols(object); if (enumerableOnly) { symbols = filter(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$2(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$4(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context32; forEach$2(_context32 = ownKeys$4(Object(source), true)).call(_context32, function (key) { _defineProperty(target, key, source[key]); }); } else if (getOwnPropertyDescriptors) { defineProperties(target, getOwnPropertyDescriptors(source)); } else { var _context33; forEach$2(_context33 = ownKeys$4(Object(source))).call(_context33, function (key) { defineProperty$5(target, key, getOwnPropertyDescriptor$2(source, key)); }); } } return target; }

function _createSuper$t(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$t(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$t() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _createForOfIteratorHelper$7(o, allowArrayLike) { var it = typeof symbol !== "undefined" && getIteratorMethod$2(o) || o["@@iterator"]; if (!it) { if (isArray$2(o) || (it = _unsupportedIterableToArray$7(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$7(o, minLen) { var _context31; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$7(o, minLen); var n = slice$1(_context31 = Object.prototype.toString.call(o)).call(_context31, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return from$2(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$7(o, minLen); }

function _arrayLikeToArray$7(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
/**
 * Create new data pipe.
 *
 * @param from - The source data set or data view.
 *
 * @remarks
 * Example usage:
 * ```typescript
 * interface AppItem {
 *   whoami: string;
 *   appData: unknown;
 *   visData: VisItem;
 * }
 * interface VisItem {
 *   id: number;
 *   label: string;
 *   color: string;
 *   x: number;
 *   y: number;
 * }
 *
 * const ds1 = new DataSet<AppItem, "whoami">([], { fieldId: "whoami" });
 * const ds2 = new DataSet<VisItem, "id">();
 *
 * const pipe = createNewDataPipeFrom(ds1)
 *   .filter((item): boolean => item.enabled === true)
 *   .map<VisItem, "id">((item): VisItem => item.visData)
 *   .to(ds2);
 *
 * pipe.start();
 * ```
 *
 * @returns A factory whose methods can be used to configure the pipe.
 */

function createNewDataPipeFrom(from) {
  return new DataPipeUnderConstruction(from);
}
/**
 * Internal implementation of the pipe. This should be accessible only through
 * `createNewDataPipeFrom` from the outside.
 *
 * @typeParam SI - Source item type.
 * @typeParam SP - Source item type's id property name.
 * @typeParam TI - Target item type.
 * @typeParam TP - Target item type's id property name.
 */


var SimpleDataPipe = /*#__PURE__*/function () {
  /**
   * Create a new data pipe.
   *
   * @param _source - The data set or data view that will be observed.
   * @param _transformers - An array of transforming functions to be used to
   * filter or transform the items in the pipe.
   * @param _target - The data set or data view that will receive the items.
   */
  function SimpleDataPipe(_source, _transformers, _target) {
    var _context, _context2, _context3;

    _classCallCheck(this, SimpleDataPipe);

    this._source = _source;
    this._transformers = _transformers;
    this._target = _target;
    /**
     * Bound listeners for use with `DataInterface['on' | 'off']`.
     */

    this._listeners = {
      add: bind$6(_context = this._add).call(_context, this),
      remove: bind$6(_context2 = this._remove).call(_context2, this),
      update: bind$6(_context3 = this._update).call(_context3, this)
    };
  }
  /** @inheritDoc */


  _createClass(SimpleDataPipe, [{
    key: "all",
    value: function all() {
      this._target.update(this._transformItems(this._source.get()));

      return this;
    }
    /** @inheritDoc */

  }, {
    key: "start",
    value: function start() {
      this._source.on("add", this._listeners.add);

      this._source.on("remove", this._listeners.remove);

      this._source.on("update", this._listeners.update);

      return this;
    }
    /** @inheritDoc */

  }, {
    key: "stop",
    value: function stop() {
      this._source.off("add", this._listeners.add);

      this._source.off("remove", this._listeners.remove);

      this._source.off("update", this._listeners.update);

      return this;
    }
    /**
     * Apply the transformers to the items.
     *
     * @param items - The items to be transformed.
     *
     * @returns The transformed items.
     */

  }, {
    key: "_transformItems",
    value: function _transformItems(items) {
      var _context4;

      return reduce(_context4 = this._transformers).call(_context4, function (items, transform) {
        return transform(items);
      }, items);
    }
    /**
     * Handle an add event.
     *
     * @param _name - Ignored.
     * @param payload - The payload containing the ids of the added items.
     */

  }, {
    key: "_add",
    value: function _add(_name, payload) {
      if (payload == null) {
        return;
      }

      this._target.add(this._transformItems(this._source.get(payload.items)));
    }
    /**
     * Handle an update event.
     *
     * @param _name - Ignored.
     * @param payload - The payload containing the ids of the updated items.
     */

  }, {
    key: "_update",
    value: function _update(_name, payload) {
      if (payload == null) {
        return;
      }

      this._target.update(this._transformItems(this._source.get(payload.items)));
    }
    /**
     * Handle a remove event.
     *
     * @param _name - Ignored.
     * @param payload - The payload containing the data of the removed items.
     */

  }, {
    key: "_remove",
    value: function _remove(_name, payload) {
      if (payload == null) {
        return;
      }

      this._target.remove(this._transformItems(payload.oldData));
    }
  }]);

  return SimpleDataPipe;
}();
/**
 * Internal implementation of the pipe factory. This should be accessible
 * only through `createNewDataPipeFrom` from the outside.
 *
 * @typeParam TI - Target item type.
 * @typeParam TP - Target item type's id property name.
 */


var DataPipeUnderConstruction = /*#__PURE__*/function () {
  /**
   * Create a new data pipe factory. This is an internal constructor that
   * should never be called from outside of this file.
   *
   * @param _source - The source data set or data view for this pipe.
   */
  function DataPipeUnderConstruction(_source) {
    _classCallCheck(this, DataPipeUnderConstruction);

    this._source = _source;
    /**
     * Array transformers used to transform items within the pipe. This is typed
     * as any for the sake of simplicity.
     */

    this._transformers = [];
  }
  /**
   * Filter the items.
   *
   * @param callback - A filtering function that returns true if given item
   * should be piped and false if not.
   *
   * @returns This factory for further configuration.
   */


  _createClass(DataPipeUnderConstruction, [{
    key: "filter",
    value: function filter$1(callback) {
      this._transformers.push(function (input) {
        return filter(input).call(input, callback);
      });

      return this;
    }
    /**
     * Map each source item to a new type.
     *
     * @param callback - A mapping function that takes a source item and returns
     * corresponding mapped item.
     *
     * @typeParam TI - Target item type.
     * @typeParam TP - Target item type's id property name.
     *
     * @returns This factory for further configuration.
     */

  }, {
    key: "map",
    value: function map(callback) {
      this._transformers.push(function (input) {
        return map$3(input).call(input, callback);
      });

      return this;
    }
    /**
     * Map each source item to zero or more items of a new type.
     *
     * @param callback - A mapping function that takes a source item and returns
     * an array of corresponding mapped items.
     *
     * @typeParam TI - Target item type.
     * @typeParam TP - Target item type's id property name.
     *
     * @returns This factory for further configuration.
     */

  }, {
    key: "flatMap",
    value: function flatMap$1(callback) {
      this._transformers.push(function (input) {
        return flatMap(input).call(input, callback);
      });

      return this;
    }
    /**
     * Connect this pipe to given data set.
     *
     * @param target - The data set that will receive the items from this pipe.
     *
     * @returns The pipe connected between given data sets and performing
     * configured transformation on the processed items.
     */

  }, {
    key: "to",
    value: function to(target) {
      return new SimpleDataPipe(this._source, this._transformers, target);
    }
  }]);

  return DataPipeUnderConstruction;
}();
/**
 * Determine whether a value can be used as an id.
 *
 * @param value - Input value of unknown type.
 *
 * @returns True if the value is valid id, false otherwise.
 */


function isId(value) {
  return typeof value === "string" || typeof value === "number";
}
/**
 * A queue.
 *
 * @typeParam T - The type of method names to be replaced by queued versions.
 */


var Queue = /*#__PURE__*/function () {
  /**
   * Construct a new Queue.
   *
   * @param options - Queue configuration.
   */
  function Queue(options) {
    _classCallCheck(this, Queue);

    this._queue = [];
    this._timeout = null;
    this._extended = null; // options

    this.delay = null;
    this.max = Infinity;
    this.setOptions(options);
  }
  /**
   * Update the configuration of the queue.
   *
   * @param options - Queue configuration.
   */


  _createClass(Queue, [{
    key: "setOptions",
    value: function setOptions(options) {
      if (options && typeof options.delay !== "undefined") {
        this.delay = options.delay;
      }

      if (options && typeof options.max !== "undefined") {
        this.max = options.max;
      }

      this._flushIfNeeded();
    }
    /**
     * Extend an object with queuing functionality.
     * The object will be extended with a function flush, and the methods provided in options.replace will be replaced with queued ones.
     *
     * @param object - The object to be extended.
     * @param options - Additional options.
     *
     * @returns The created queue.
     */

  }, {
    key: "destroy",
    value:
    /**
     * Destroy the queue. The queue will first flush all queued actions, and in case it has extended an object, will restore the original object.
     */
    function destroy() {
      this.flush();

      if (this._extended) {
        var object = this._extended.object;
        var methods = this._extended.methods;

        for (var i = 0; i < methods.length; i++) {
          var method = methods[i];

          if (method.original) {
            // @TODO: better solution?
            object[method.name] = method.original;
          } else {
            // @TODO: better solution?
            delete object[method.name];
          }
        }

        this._extended = null;
      }
    }
    /**
     * Replace a method on an object with a queued version.
     *
     * @param object - Object having the method.
     * @param method - The method name.
     */

  }, {
    key: "replace",
    value: function replace(object, method) {
      /* eslint-disable-next-line @typescript-eslint/no-this-alias -- Function this is necessary in the function bellow, so class this has to be saved into a variable here. */
      var me = this;
      var original = object[method];

      if (!original) {
        throw new Error("Method " + method + " undefined");
      }

      object[method] = function () {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        // add this call to the queue
        me.queue({
          args: args,
          fn: original,
          context: this
        });
      };
    }
    /**
     * Queue a call.
     *
     * @param entry - The function or entry to be queued.
     */

  }, {
    key: "queue",
    value: function queue(entry) {
      if (typeof entry === "function") {
        this._queue.push({
          fn: entry
        });
      } else {
        this._queue.push(entry);
      }

      this._flushIfNeeded();
    }
    /**
     * Check whether the queue needs to be flushed.
     */

  }, {
    key: "_flushIfNeeded",
    value: function _flushIfNeeded() {
      var _this = this;

      // flush when the maximum is exceeded.
      if (this._queue.length > this.max) {
        this.flush();
      } // flush after a period of inactivity when a delay is configured


      if (this._timeout != null) {
        clearTimeout(this._timeout);
        this._timeout = null;
      }

      if (this.queue.length > 0 && typeof this.delay === "number") {
        this._timeout = setTimeout$1(function () {
          _this.flush();
        }, this.delay);
      }
    }
    /**
     * Flush all queued calls
     */

  }, {
    key: "flush",
    value: function flush() {
      var _context5, _context6;

      forEach$2(_context5 = splice(_context6 = this._queue).call(_context6, 0)).call(_context5, function (entry) {
        entry.fn.apply(entry.context || entry.fn, entry.args || []);
      });
    }
  }], [{
    key: "extend",
    value: function extend(object, options) {
      var queue = new Queue(options);

      if (object.flush !== undefined) {
        throw new Error("Target object already has a property flush");
      }

      object.flush = function () {
        queue.flush();
      };

      var methods = [{
        name: "flush",
        original: undefined
      }];

      if (options && options.replace) {
        for (var i = 0; i < options.replace.length; i++) {
          var name = options.replace[i];
          methods.push({
            name: name,
            // @TODO: better solution?
            original: object[name]
          }); // @TODO: better solution?

          queue.replace(object, name);
        }
      }

      queue._extended = {
        object: object,
        methods: methods
      };
      return queue;
    }
  }]);

  return Queue;
}();
/**
 * [[DataSet]] code that can be reused in [[DataView]] or other similar implementations of [[DataInterface]].
 *
 * @typeParam Item - Item type that may or may not have an id.
 * @typeParam IdProp - Name of the property that contains the id.
 */


var DataSetPart = /*#__PURE__*/function () {
  function DataSetPart() {
    _classCallCheck(this, DataSetPart);

    this._subscribers = {
      "*": [],
      add: [],
      remove: [],
      update: []
    };
    /**
     * @deprecated Use on instead (PS: DataView.subscribe === DataView.on).
     */

    this.subscribe = DataSetPart.prototype.on;
    /**
     * @deprecated Use off instead (PS: DataView.unsubscribe === DataView.off).
     */

    this.unsubscribe = DataSetPart.prototype.off;
  }
  /**
   * Trigger an event
   *
   * @param event - Event name.
   * @param payload - Event payload.
   * @param senderId - Id of the sender.
   */


  _createClass(DataSetPart, [{
    key: "_trigger",
    value: function _trigger(event, payload, senderId) {
      var _context7, _context8;

      if (event === "*") {
        throw new Error("Cannot trigger event *");
      }

      forEach$2(_context7 = concat(_context8 = []).call(_context8, _toConsumableArray(this._subscribers[event]), _toConsumableArray(this._subscribers["*"]))).call(_context7, function (subscriber) {
        subscriber(event, payload, senderId != null ? senderId : null);
      });
    }
    /**
     * Subscribe to an event, add an event listener.
     *
     * @remarks Non-function callbacks are ignored.
     *
     * @param event - Event name.
     * @param callback - Callback method.
     */

  }, {
    key: "on",
    value: function on(event, callback) {
      if (typeof callback === "function") {
        this._subscribers[event].push(callback);
      } // @TODO: Maybe throw for invalid callbacks?

    }
    /**
     * Unsubscribe from an event, remove an event listener.
     *
     * @remarks If the same callback was subscribed more than once **all** occurences will be removed.
     *
     * @param event - Event name.
     * @param callback - Callback method.
     */

  }, {
    key: "off",
    value: function off(event, callback) {
      var _context9;

      this._subscribers[event] = filter(_context9 = this._subscribers[event]).call(_context9, function (subscriber) {
        return subscriber !== callback;
      });
    }
  }]);

  return DataSetPart;
}();
/**
 * Data stream
 *
 * @remarks
 * [[DataStream]] offers an always up to date stream of items from a [[DataSet]] or [[DataView]].
 * That means that the stream is evaluated at the time of iteration, conversion to another data type or when [[cache]] is called, not when the [[DataStream]] was created.
 * Multiple invocations of for example [[toItemArray]] may yield different results (if the data source like for example [[DataSet]] gets modified).
 *
 * @typeParam Item - The item type this stream is going to work with.
 */


var DataStream = /*#__PURE__*/function (_Symbol$iterator) {
  /**
   * Create a new data stream.
   *
   * @param pairs - The id, item pairs.
   */
  function DataStream(pairs) {
    _classCallCheck(this, DataStream);

    this._pairs = pairs;
  }
  /**
   * Return an iterable of key, value pairs for every entry in the stream.
   */


  _createClass(DataStream, [{
    key: _Symbol$iterator,
    value:
    /*#__PURE__*/
    regenerator.mark(function value() {
      var _iterator, _step, _step$value, id, item;

      return regenerator.wrap(function value$(_context10) {
        while (1) {
          switch (_context10.prev = _context10.next) {
            case 0:
              _iterator = _createForOfIteratorHelper$7(this._pairs);
              _context10.prev = 1;

              _iterator.s();

            case 3:
              if ((_step = _iterator.n()).done) {
                _context10.next = 9;
                break;
              }

              _step$value = _slicedToArray(_step.value, 2), id = _step$value[0], item = _step$value[1];
              _context10.next = 7;
              return [id, item];

            case 7:
              _context10.next = 3;
              break;

            case 9:
              _context10.next = 14;
              break;

            case 11:
              _context10.prev = 11;
              _context10.t0 = _context10["catch"](1);

              _iterator.e(_context10.t0);

            case 14:
              _context10.prev = 14;

              _iterator.f();

              return _context10.finish(14);

            case 17:
            case "end":
              return _context10.stop();
          }
        }
      }, value, this, [[1, 11, 14, 17]]);
    })
    /**
     * Return an iterable of key, value pairs for every entry in the stream.
     */

  }, {
    key: "entries",
    value:
    /*#__PURE__*/
    regenerator.mark(function entries() {
      var _iterator2, _step2, _step2$value, id, item;

      return regenerator.wrap(function entries$(_context11) {
        while (1) {
          switch (_context11.prev = _context11.next) {
            case 0:
              _iterator2 = _createForOfIteratorHelper$7(this._pairs);
              _context11.prev = 1;

              _iterator2.s();

            case 3:
              if ((_step2 = _iterator2.n()).done) {
                _context11.next = 9;
                break;
              }

              _step2$value = _slicedToArray(_step2.value, 2), id = _step2$value[0], item = _step2$value[1];
              _context11.next = 7;
              return [id, item];

            case 7:
              _context11.next = 3;
              break;

            case 9:
              _context11.next = 14;
              break;

            case 11:
              _context11.prev = 11;
              _context11.t0 = _context11["catch"](1);

              _iterator2.e(_context11.t0);

            case 14:
              _context11.prev = 14;

              _iterator2.f();

              return _context11.finish(14);

            case 17:
            case "end":
              return _context11.stop();
          }
        }
      }, entries, this, [[1, 11, 14, 17]]);
    })
    /**
     * Return an iterable of keys in the stream.
     */

  }, {
    key: "keys",
    value:
    /*#__PURE__*/
    regenerator.mark(function keys() {
      var _iterator3, _step3, _step3$value, id;

      return regenerator.wrap(function keys$(_context12) {
        while (1) {
          switch (_context12.prev = _context12.next) {
            case 0:
              _iterator3 = _createForOfIteratorHelper$7(this._pairs);
              _context12.prev = 1;

              _iterator3.s();

            case 3:
              if ((_step3 = _iterator3.n()).done) {
                _context12.next = 9;
                break;
              }

              _step3$value = _slicedToArray(_step3.value, 1), id = _step3$value[0];
              _context12.next = 7;
              return id;

            case 7:
              _context12.next = 3;
              break;

            case 9:
              _context12.next = 14;
              break;

            case 11:
              _context12.prev = 11;
              _context12.t0 = _context12["catch"](1);

              _iterator3.e(_context12.t0);

            case 14:
              _context12.prev = 14;

              _iterator3.f();

              return _context12.finish(14);

            case 17:
            case "end":
              return _context12.stop();
          }
        }
      }, keys, this, [[1, 11, 14, 17]]);
    })
    /**
     * Return an iterable of values in the stream.
     */

  }, {
    key: "values",
    value:
    /*#__PURE__*/
    regenerator.mark(function values() {
      var _iterator4, _step4, _step4$value, item;

      return regenerator.wrap(function values$(_context13) {
        while (1) {
          switch (_context13.prev = _context13.next) {
            case 0:
              _iterator4 = _createForOfIteratorHelper$7(this._pairs);
              _context13.prev = 1;

              _iterator4.s();

            case 3:
              if ((_step4 = _iterator4.n()).done) {
                _context13.next = 9;
                break;
              }

              _step4$value = _slicedToArray(_step4.value, 2), item = _step4$value[1];
              _context13.next = 7;
              return item;

            case 7:
              _context13.next = 3;
              break;

            case 9:
              _context13.next = 14;
              break;

            case 11:
              _context13.prev = 11;
              _context13.t0 = _context13["catch"](1);

              _iterator4.e(_context13.t0);

            case 14:
              _context13.prev = 14;

              _iterator4.f();

              return _context13.finish(14);

            case 17:
            case "end":
              return _context13.stop();
          }
        }
      }, values, this, [[1, 11, 14, 17]]);
    })
    /**
     * Return an array containing all the ids in this stream.
     *
     * @remarks
     * The array may contain duplicities.
     *
     * @returns The array with all ids from this stream.
     */

  }, {
    key: "toIdArray",
    value: function toIdArray() {
      var _context14;

      return map$3(_context14 = _toConsumableArray(this._pairs)).call(_context14, function (pair) {
        return pair[0];
      });
    }
    /**
     * Return an array containing all the items in this stream.
     *
     * @remarks
     * The array may contain duplicities.
     *
     * @returns The array with all items from this stream.
     */

  }, {
    key: "toItemArray",
    value: function toItemArray() {
      var _context15;

      return map$3(_context15 = _toConsumableArray(this._pairs)).call(_context15, function (pair) {
        return pair[1];
      });
    }
    /**
     * Return an array containing all the entries in this stream.
     *
     * @remarks
     * The array may contain duplicities.
     *
     * @returns The array with all entries from this stream.
     */

  }, {
    key: "toEntryArray",
    value: function toEntryArray() {
      return _toConsumableArray(this._pairs);
    }
    /**
     * Return an object map containing all the items in this stream accessible by ids.
     *
     * @remarks
     * In case of duplicate ids (coerced to string so `7 == '7'`) the last encoutered appears in the returned object.
     *
     * @returns The object map of all id → item pairs from this stream.
     */

  }, {
    key: "toObjectMap",
    value: function toObjectMap() {
      var map = create$4(null);

      var _iterator5 = _createForOfIteratorHelper$7(this._pairs),
          _step5;

      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var _step5$value = _slicedToArray(_step5.value, 2),
              id = _step5$value[0],
              item = _step5$value[1];

          map[id] = item;
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }

      return map;
    }
    /**
     * Return a map containing all the items in this stream accessible by ids.
     *
     * @returns The map of all id → item pairs from this stream.
     */

  }, {
    key: "toMap",
    value: function toMap() {
      return new map(this._pairs);
    }
    /**
     * Return a set containing all the (unique) ids in this stream.
     *
     * @returns The set of all ids from this stream.
     */

  }, {
    key: "toIdSet",
    value: function toIdSet() {
      return new set(this.toIdArray());
    }
    /**
     * Return a set containing all the (unique) items in this stream.
     *
     * @returns The set of all items from this stream.
     */

  }, {
    key: "toItemSet",
    value: function toItemSet() {
      return new set(this.toItemArray());
    }
    /**
     * Cache the items from this stream.
     *
     * @remarks
     * This method allows for items to be fetched immediatelly and used (possibly multiple times) later.
     * It can also be used to optimize performance as [[DataStream]] would otherwise reevaluate everything upon each iteration.
     *
     * ## Example
     * ```javascript
     * const ds = new DataSet([…])
     *
     * const cachedStream = ds.stream()
     *   .filter(…)
     *   .sort(…)
     *   .map(…)
     *   .cached(…) // Data are fetched, processed and cached here.
     *
     * ds.clear()
     * chachedStream // Still has all the items.
     * ```
     *
     * @returns A new [[DataStream]] with cached items (detached from the original [[DataSet]]).
     */

  }, {
    key: "cache",
    value: function cache() {
      return new DataStream(_toConsumableArray(this._pairs));
    }
    /**
     * Get the distinct values of given property.
     *
     * @param callback - The function that picks and possibly converts the property.
     *
     * @typeParam T - The type of the distinct value.
     *
     * @returns A set of all distinct properties.
     */

  }, {
    key: "distinct",
    value: function distinct(callback) {
      var set$1 = new set();

      var _iterator6 = _createForOfIteratorHelper$7(this._pairs),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var _step6$value = _slicedToArray(_step6.value, 2),
              id = _step6$value[0],
              item = _step6$value[1];

          set$1.add(callback(item, id));
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }

      return set$1;
    }
    /**
     * Filter the items of the stream.
     *
     * @param callback - The function that decides whether an item will be included.
     *
     * @returns A new data stream with the filtered items.
     */

  }, {
    key: "filter",
    value: function filter(callback) {
      var pairs = this._pairs;
      return new DataStream(_defineProperty({}, iterator, /*#__PURE__*/regenerator.mark(function _callee() {
        var _iterator7, _step7, _step7$value, id, item;

        return regenerator.wrap(function _callee$(_context16) {
          while (1) {
            switch (_context16.prev = _context16.next) {
              case 0:
                _iterator7 = _createForOfIteratorHelper$7(pairs);
                _context16.prev = 1;

                _iterator7.s();

              case 3:
                if ((_step7 = _iterator7.n()).done) {
                  _context16.next = 10;
                  break;
                }

                _step7$value = _slicedToArray(_step7.value, 2), id = _step7$value[0], item = _step7$value[1];

                if (!callback(item, id)) {
                  _context16.next = 8;
                  break;
                }

                _context16.next = 8;
                return [id, item];

              case 8:
                _context16.next = 3;
                break;

              case 10:
                _context16.next = 15;
                break;

              case 12:
                _context16.prev = 12;
                _context16.t0 = _context16["catch"](1);

                _iterator7.e(_context16.t0);

              case 15:
                _context16.prev = 15;

                _iterator7.f();

                return _context16.finish(15);

              case 18:
              case "end":
                return _context16.stop();
            }
          }
        }, _callee, null, [[1, 12, 15, 18]]);
      })));
    }
    /**
     * Execute a callback for each item of the stream.
     *
     * @param callback - The function that will be invoked for each item.
     */

  }, {
    key: "forEach",
    value: function forEach(callback) {
      var _iterator8 = _createForOfIteratorHelper$7(this._pairs),
          _step8;

      try {
        for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
          var _step8$value = _slicedToArray(_step8.value, 2),
              id = _step8$value[0],
              item = _step8$value[1];

          callback(item, id);
        }
      } catch (err) {
        _iterator8.e(err);
      } finally {
        _iterator8.f();
      }
    }
    /**
     * Map the items into a different type.
     *
     * @param callback - The function that does the conversion.
     *
     * @typeParam Mapped - The type of the item after mapping.
     *
     * @returns A new data stream with the mapped items.
     */

  }, {
    key: "map",
    value: function map(callback) {
      var pairs = this._pairs;
      return new DataStream(_defineProperty({}, iterator, /*#__PURE__*/regenerator.mark(function _callee2() {
        var _iterator9, _step9, _step9$value, id, item;

        return regenerator.wrap(function _callee2$(_context17) {
          while (1) {
            switch (_context17.prev = _context17.next) {
              case 0:
                _iterator9 = _createForOfIteratorHelper$7(pairs);
                _context17.prev = 1;

                _iterator9.s();

              case 3:
                if ((_step9 = _iterator9.n()).done) {
                  _context17.next = 9;
                  break;
                }

                _step9$value = _slicedToArray(_step9.value, 2), id = _step9$value[0], item = _step9$value[1];
                _context17.next = 7;
                return [id, callback(item, id)];

              case 7:
                _context17.next = 3;
                break;

              case 9:
                _context17.next = 14;
                break;

              case 11:
                _context17.prev = 11;
                _context17.t0 = _context17["catch"](1);

                _iterator9.e(_context17.t0);

              case 14:
                _context17.prev = 14;

                _iterator9.f();

                return _context17.finish(14);

              case 17:
              case "end":
                return _context17.stop();
            }
          }
        }, _callee2, null, [[1, 11, 14, 17]]);
      })));
    }
    /**
     * Get the item with the maximum value of given property.
     *
     * @param callback - The function that picks and possibly converts the property.
     *
     * @returns The item with the maximum if found otherwise null.
     */

  }, {
    key: "max",
    value: function max(callback) {
      var iter = getIterator(this._pairs);

      var curr = iter.next();

      if (curr.done) {
        return null;
      }

      var maxItem = curr.value[1];
      var maxValue = callback(curr.value[1], curr.value[0]);

      while (!(curr = iter.next()).done) {
        var _curr$value = _slicedToArray(curr.value, 2),
            id = _curr$value[0],
            item = _curr$value[1];

        var _value = callback(item, id);

        if (_value > maxValue) {
          maxValue = _value;
          maxItem = item;
        }
      }

      return maxItem;
    }
    /**
     * Get the item with the minimum value of given property.
     *
     * @param callback - The function that picks and possibly converts the property.
     *
     * @returns The item with the minimum if found otherwise null.
     */

  }, {
    key: "min",
    value: function min(callback) {
      var iter = getIterator(this._pairs);

      var curr = iter.next();

      if (curr.done) {
        return null;
      }

      var minItem = curr.value[1];
      var minValue = callback(curr.value[1], curr.value[0]);

      while (!(curr = iter.next()).done) {
        var _curr$value2 = _slicedToArray(curr.value, 2),
            id = _curr$value2[0],
            item = _curr$value2[1];

        var _value2 = callback(item, id);

        if (_value2 < minValue) {
          minValue = _value2;
          minItem = item;
        }
      }

      return minItem;
    }
    /**
     * Reduce the items into a single value.
     *
     * @param callback - The function that does the reduction.
     * @param accumulator - The initial value of the accumulator.
     *
     * @typeParam T - The type of the accumulated value.
     *
     * @returns The reduced value.
     */

  }, {
    key: "reduce",
    value: function reduce(callback, accumulator) {
      var _iterator10 = _createForOfIteratorHelper$7(this._pairs),
          _step10;

      try {
        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
          var _step10$value = _slicedToArray(_step10.value, 2),
              id = _step10$value[0],
              item = _step10$value[1];

          accumulator = callback(accumulator, item, id);
        }
      } catch (err) {
        _iterator10.e(err);
      } finally {
        _iterator10.f();
      }

      return accumulator;
    }
    /**
     * Sort the items.
     *
     * @param callback - Item comparator.
     *
     * @returns A new stream with sorted items.
     */

  }, {
    key: "sort",
    value: function sort$1(callback) {
      var _this2 = this;

      return new DataStream(_defineProperty({}, iterator, function () {
        var _context18;

        return getIterator(sort(_context18 = _toConsumableArray(_this2._pairs)).call(_context18, function (_ref, _ref2) {
          var _ref3 = _slicedToArray(_ref, 2),
              idA = _ref3[0],
              itemA = _ref3[1];

          var _ref4 = _slicedToArray(_ref2, 2),
              idB = _ref4[0],
              itemB = _ref4[1];

          return callback(itemA, itemB, idA, idB);
        }));
      }));
    }
  }]);

  return DataStream;
}(iterator);
/**
 * Add an id to given item if it doesn't have one already.
 *
 * @remarks
 * The item will be modified.
 *
 * @param item - The item that will have an id after a call to this function.
 * @param idProp - The key of the id property.
 *
 * @typeParam Item - Item type that may or may not have an id.
 * @typeParam IdProp - Name of the property that contains the id.
 *
 * @returns true
 */


function ensureFullItem(item, idProp) {
  if (item[idProp] == null) {
    // generate an id
    item[idProp] = v4();
  }

  return item;
}
/**
 * # DataSet
 *
 * Vis.js comes with a flexible DataSet, which can be used to hold and
 * manipulate unstructured data and listen for changes in the data. The DataSet
 * is key/value based. Data items can be added, updated and removed from the
 * DataSet, and one can subscribe to changes in the DataSet. The data in the
 * DataSet can be filtered and ordered. Data can be normalized when appending it
 * to the DataSet as well.
 *
 * ## Example
 *
 * The following example shows how to use a DataSet.
 *
 * ```javascript
 * // create a DataSet
 * var options = {};
 * var data = new vis.DataSet(options);
 *
 * // add items
 * // note that the data items can contain different properties and data formats
 * data.add([
 *   {id: 1, text: 'item 1', date: new Date(2013, 6, 20), group: 1, first: true},
 *   {id: 2, text: 'item 2', date: '2013-06-23', group: 2},
 *   {id: 3, text: 'item 3', date: '2013-06-25', group: 2},
 *   {id: 4, text: 'item 4'}
 * ]);
 *
 * // subscribe to any change in the DataSet
 * data.on('*', function (event, properties, senderId) {
 *   console.log('event', event, properties);
 * });
 *
 * // update an existing item
 * data.update({id: 2, group: 1});
 *
 * // remove an item
 * data.remove(4);
 *
 * // get all ids
 * var ids = data.getIds();
 * console.log('ids', ids);
 *
 * // get a specific item
 * var item1 = data.get(1);
 * console.log('item1', item1);
 *
 * // retrieve a filtered subset of the data
 * var items = data.get({
 *   filter: function (item) {
 *     return item.group == 1;
 *   }
 * });
 * console.log('filtered items', items);
 * ```
 *
 * @typeParam Item - Item type that may or may not have an id.
 * @typeParam IdProp - Name of the property that contains the id.
 */


var DataSet = /*#__PURE__*/function (_DataSetPart) {
  _inherits(DataSet, _DataSetPart);

  var _super = _createSuper$t(DataSet);

  /**
   * Construct a new DataSet.
   *
   * @param data - Initial data or options.
   * @param options - Options (type error if data is also options).
   */
  function DataSet(data, options) {
    var _this3;

    _classCallCheck(this, DataSet);

    _this3 = _super.call(this);
    _this3._queue = null; // correctly read optional arguments

    if (data && !isArray$2(data)) {
      options = data;
      data = [];
    }

    _this3._options = options || {};
    _this3._data = new map(); // map with data indexed by id

    _this3.length = 0; // number of items in the DataSet

    _this3._idProp = _this3._options.fieldId || "id"; // name of the field containing id
    // add initial data when provided

    if (data && data.length) {
      _this3.add(data);
    }

    _this3.setOptions(options);

    return _this3;
  }
  /** @inheritDoc */


  _createClass(DataSet, [{
    key: "idProp",
    get: function get() {
      return this._idProp;
    }
    /**
     * Set new options.
     *
     * @param options - The new options.
     */

  }, {
    key: "setOptions",
    value: function setOptions(options) {
      if (options && options.queue !== undefined) {
        if (options.queue === false) {
          // delete queue if loaded
          if (this._queue) {
            this._queue.destroy();

            this._queue = null;
          }
        } else {
          // create queue and update its options
          if (!this._queue) {
            this._queue = Queue.extend(this, {
              replace: ["add", "update", "remove"]
            });
          }

          if (options.queue && _typeof(options.queue) === "object") {
            this._queue.setOptions(options.queue);
          }
        }
      }
    }
    /**
     * Add a data item or an array with items.
     *
     * After the items are added to the DataSet, the DataSet will trigger an event `add`. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
     *
     * ## Example
     *
     * ```javascript
     * // create a DataSet
     * const data = new vis.DataSet()
     *
     * // add items
     * const ids = data.add([
     *   { id: 1, text: 'item 1' },
     *   { id: 2, text: 'item 2' },
     *   { text: 'item without an id' }
     * ])
     *
     * console.log(ids) // [1, 2, '<UUIDv4>']
     * ```
     *
     * @param data - Items to be added (ids will be generated if missing).
     * @param senderId - Sender id.
     *
     * @returns addedIds - Array with the ids (generated if not present) of the added items.
     *
     * @throws When an item with the same id as any of the added items already exists.
     */

  }, {
    key: "add",
    value: function add(data, senderId) {
      var _this4 = this;

      var addedIds = [];
      var id;

      if (isArray$2(data)) {
        // Array
        var idsToAdd = map$3(data).call(data, function (d) {
          return d[_this4._idProp];
        });

        if (some(idsToAdd).call(idsToAdd, function (id) {
          return _this4._data.has(id);
        })) {
          throw new Error("A duplicate id was found in the parameter array.");
        }

        for (var i = 0, len = data.length; i < len; i++) {
          id = this._addItem(data[i]);
          addedIds.push(id);
        }
      } else if (data && _typeof(data) === "object") {
        // Single item
        id = this._addItem(data);
        addedIds.push(id);
      } else {
        throw new Error("Unknown dataType");
      }

      if (addedIds.length) {
        this._trigger("add", {
          items: addedIds
        }, senderId);
      }

      return addedIds;
    }
    /**
     * Update existing items. When an item does not exist, it will be created.
     *
     * @remarks
     * The provided properties will be merged in the existing item. When an item does not exist, it will be created.
     *
     * After the items are updated, the DataSet will trigger an event `add` for the added items, and an event `update`. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
     *
     * ## Example
     *
     * ```javascript
     * // create a DataSet
     * const data = new vis.DataSet([
     *   { id: 1, text: 'item 1' },
     *   { id: 2, text: 'item 2' },
     *   { id: 3, text: 'item 3' }
     * ])
     *
     * // update items
     * const ids = data.update([
     *   { id: 2, text: 'item 2 (updated)' },
     *   { id: 4, text: 'item 4 (new)' }
     * ])
     *
     * console.log(ids) // [2, 4]
     * ```
     *
     * ## Warning for TypeScript users
     * This method may introduce partial items into the data set. Use add or updateOnly instead for better type safety.
     *
     * @param data - Items to be updated (if the id is already present) or added (if the id is missing).
     * @param senderId - Sender id.
     *
     * @returns updatedIds - The ids of the added (these may be newly generated if there was no id in the item from the data) or updated items.
     *
     * @throws When the supplied data is neither an item nor an array of items.
     */

  }, {
    key: "update",
    value: function update(data, senderId) {
      var _this5 = this;

      var addedIds = [];
      var updatedIds = [];
      var oldData = [];
      var updatedData = [];
      var idProp = this._idProp;

      var addOrUpdate = function addOrUpdate(item) {
        var origId = item[idProp];

        if (origId != null && _this5._data.has(origId)) {
          var fullItem = item; // it has an id, therefore it is a fullitem

          var oldItem = assign$2({}, _this5._data.get(origId)); // update item


          var id = _this5._updateItem(fullItem);

          updatedIds.push(id);
          updatedData.push(fullItem);
          oldData.push(oldItem);
        } else {
          // add new item
          var _id = _this5._addItem(item);

          addedIds.push(_id);
        }
      };

      if (isArray$2(data)) {
        // Array
        for (var i = 0, len = data.length; i < len; i++) {
          if (data[i] && _typeof(data[i]) === "object") {
            addOrUpdate(data[i]);
          } else {
            console.warn("Ignoring input item, which is not an object at index " + i);
          }
        }
      } else if (data && _typeof(data) === "object") {
        // Single item
        addOrUpdate(data);
      } else {
        throw new Error("Unknown dataType");
      }

      if (addedIds.length) {
        this._trigger("add", {
          items: addedIds
        }, senderId);
      }

      if (updatedIds.length) {
        var props = {
          items: updatedIds,
          oldData: oldData,
          data: updatedData
        }; // TODO: remove deprecated property 'data' some day
        //Object.defineProperty(props, 'data', {
        //  'get': (function() {
        //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
        //    return updatedData;
        //  }).bind(this)
        //});

        this._trigger("update", props, senderId);
      }

      return concat(addedIds).call(addedIds, updatedIds);
    }
    /**
     * Update existing items. When an item does not exist, an error will be thrown.
     *
     * @remarks
     * The provided properties will be deeply merged into the existing item.
     * When an item does not exist (id not present in the data set or absent), an error will be thrown and nothing will be changed.
     *
     * After the items are updated, the DataSet will trigger an event `update`.
     * When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
     *
     * ## Example
     *
     * ```javascript
     * // create a DataSet
     * const data = new vis.DataSet([
     *   { id: 1, text: 'item 1' },
     *   { id: 2, text: 'item 2' },
     *   { id: 3, text: 'item 3' },
     * ])
     *
     * // update items
     * const ids = data.update([
     *   { id: 2, text: 'item 2 (updated)' }, // works
     *   // { id: 4, text: 'item 4 (new)' }, // would throw
     *   // { text: 'item 4 (new)' }, // would also throw
     * ])
     *
     * console.log(ids) // [2]
     * ```
     *
     * @param data - Updates (the id and optionally other props) to the items in this data set.
     * @param senderId - Sender id.
     *
     * @returns updatedIds - The ids of the updated items.
     *
     * @throws When the supplied data is neither an item nor an array of items, when the ids are missing.
     */

  }, {
    key: "updateOnly",
    value: function updateOnly(data, senderId) {
      var _context19,
          _this6 = this;

      if (!isArray$2(data)) {
        data = [data];
      }

      var updateEventData = map$3(_context19 = map$3(data).call(data, function (update) {
        var oldData = _this6._data.get(update[_this6._idProp]);

        if (oldData == null) {
          throw new Error("Updating non-existent items is not allowed.");
        }

        return {
          oldData: oldData,
          update: update
        };
      })).call(_context19, function (_ref5) {
        var oldData = _ref5.oldData,
            update = _ref5.update;
        var id = oldData[_this6._idProp];
        var updatedData = pureDeepObjectAssign(oldData, update);

        _this6._data.set(id, updatedData);

        return {
          id: id,
          oldData: oldData,
          updatedData: updatedData
        };
      });

      if (updateEventData.length) {
        var props = {
          items: map$3(updateEventData).call(updateEventData, function (value) {
            return value.id;
          }),
          oldData: map$3(updateEventData).call(updateEventData, function (value) {
            return value.oldData;
          }),
          data: map$3(updateEventData).call(updateEventData, function (value) {
            return value.updatedData;
          })
        }; // TODO: remove deprecated property 'data' some day
        //Object.defineProperty(props, 'data', {
        //  'get': (function() {
        //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
        //    return updatedData;
        //  }).bind(this)
        //});

        this._trigger("update", props, senderId);

        return props.items;
      } else {
        return [];
      }
    }
    /** @inheritDoc */

  }, {
    key: "get",
    value: function get(first, second) {
      // @TODO: Woudn't it be better to split this into multiple methods?
      // parse the arguments
      var id = undefined;
      var ids = undefined;
      var options = undefined;

      if (isId(first)) {
        // get(id [, options])
        id = first;
        options = second;
      } else if (isArray$2(first)) {
        // get(ids [, options])
        ids = first;
        options = second;
      } else {
        // get([, options])
        options = first;
      } // determine the return type


      var returnType = options && options.returnType === "Object" ? "Object" : "Array"; // @TODO: WTF is this? Or am I missing something?
      // var returnType
      // if (options && options.returnType) {
      //   var allowedValues = ['Array', 'Object']
      //   returnType =
      //     allowedValues.indexOf(options.returnType) == -1
      //       ? 'Array'
      //       : options.returnType
      // } else {
      //   returnType = 'Array'
      // }
      // build options

      var filter$1 = options && filter(options);

      var items = [];
      var item = undefined;
      var itemIds = undefined;
      var itemId = undefined; // convert items

      if (id != null) {
        // return a single item
        item = this._data.get(id);

        if (item && filter$1 && !filter$1(item)) {
          item = undefined;
        }
      } else if (ids != null) {
        // return a subset of items
        for (var i = 0, len = ids.length; i < len; i++) {
          item = this._data.get(ids[i]);

          if (item != null && (!filter$1 || filter$1(item))) {
            items.push(item);
          }
        }
      } else {
        var _context20;

        // return all items
        itemIds = _toConsumableArray(keys(_context20 = this._data).call(_context20));

        for (var _i = 0, _len2 = itemIds.length; _i < _len2; _i++) {
          itemId = itemIds[_i];
          item = this._data.get(itemId);

          if (item != null && (!filter$1 || filter$1(item))) {
            items.push(item);
          }
        }
      } // order the results


      if (options && options.order && id == undefined) {
        this._sort(items, options.order);
      } // filter fields of the items


      if (options && options.fields) {
        var fields = options.fields;

        if (id != undefined && item != null) {
          item = this._filterFields(item, fields);
        } else {
          for (var _i2 = 0, _len3 = items.length; _i2 < _len3; _i2++) {
            items[_i2] = this._filterFields(items[_i2], fields);
          }
        }
      } // return the results


      if (returnType == "Object") {
        var result = {};

        for (var _i3 = 0, _len4 = items.length; _i3 < _len4; _i3++) {
          var resultant = items[_i3]; // @TODO: Shoudn't this be this._fieldId?
          // result[resultant.id] = resultant

          var _id2 = resultant[this._idProp];
          result[_id2] = resultant;
        }

        return result;
      } else {
        if (id != null) {
          var _item;

          // a single item
          return (_item = item) !== null && _item !== void 0 ? _item : null;
        } else {
          // just return our array
          return items;
        }
      }
    }
    /** @inheritDoc */

  }, {
    key: "getIds",
    value: function getIds(options) {
      var data = this._data;

      var filter$1 = options && filter(options);

      var order = options && options.order;

      var itemIds = _toConsumableArray(keys(data).call(data));

      var ids = [];

      if (filter$1) {
        // get filtered items
        if (order) {
          // create ordered list
          var items = [];

          for (var i = 0, len = itemIds.length; i < len; i++) {
            var id = itemIds[i];

            var item = this._data.get(id);

            if (item != null && filter$1(item)) {
              items.push(item);
            }
          }

          this._sort(items, order);

          for (var _i4 = 0, _len5 = items.length; _i4 < _len5; _i4++) {
            ids.push(items[_i4][this._idProp]);
          }
        } else {
          // create unordered list
          for (var _i5 = 0, _len6 = itemIds.length; _i5 < _len6; _i5++) {
            var _id3 = itemIds[_i5];

            var _item2 = this._data.get(_id3);

            if (_item2 != null && filter$1(_item2)) {
              ids.push(_item2[this._idProp]);
            }
          }
        }
      } else {
        // get all items
        if (order) {
          // create an ordered list
          var _items = [];

          for (var _i6 = 0, _len7 = itemIds.length; _i6 < _len7; _i6++) {
            var _id4 = itemIds[_i6];

            _items.push(data.get(_id4));
          }

          this._sort(_items, order);

          for (var _i7 = 0, _len8 = _items.length; _i7 < _len8; _i7++) {
            ids.push(_items[_i7][this._idProp]);
          }
        } else {
          // create unordered list
          for (var _i8 = 0, _len9 = itemIds.length; _i8 < _len9; _i8++) {
            var _id5 = itemIds[_i8];

            var _item3 = data.get(_id5);

            if (_item3 != null) {
              ids.push(_item3[this._idProp]);
            }
          }
        }
      }

      return ids;
    }
    /** @inheritDoc */

  }, {
    key: "getDataSet",
    value: function getDataSet() {
      return this;
    }
    /** @inheritDoc */

  }, {
    key: "forEach",
    value: function forEach(callback, options) {
      var filter$1 = options && filter(options);

      var data = this._data;

      var itemIds = _toConsumableArray(keys(data).call(data));

      if (options && options.order) {
        // execute forEach on ordered list
        var items = this.get(options);

        for (var i = 0, len = items.length; i < len; i++) {
          var item = items[i];
          var id = item[this._idProp];
          callback(item, id);
        }
      } else {
        // unordered
        for (var _i9 = 0, _len10 = itemIds.length; _i9 < _len10; _i9++) {
          var _id6 = itemIds[_i9];

          var _item4 = this._data.get(_id6);

          if (_item4 != null && (!filter$1 || filter$1(_item4))) {
            callback(_item4, _id6);
          }
        }
      }
    }
    /** @inheritDoc */

  }, {
    key: "map",
    value: function map(callback, options) {
      var filter$1 = options && filter(options);

      var mappedItems = [];
      var data = this._data;

      var itemIds = _toConsumableArray(keys(data).call(data)); // convert and filter items


      for (var i = 0, len = itemIds.length; i < len; i++) {
        var id = itemIds[i];

        var item = this._data.get(id);

        if (item != null && (!filter$1 || filter$1(item))) {
          mappedItems.push(callback(item, id));
        }
      } // order items


      if (options && options.order) {
        this._sort(mappedItems, options.order);
      }

      return mappedItems;
    }
    /**
     * Filter the fields of an item.
     *
     * @param item - The item whose fields should be filtered.
     * @param fields - The names of the fields that will be kept.
     *
     * @typeParam K - Field name type.
     *
     * @returns The item without any additional fields.
     */

  }, {
    key: "_filterFields",
    value: function _filterFields(item, fields) {
      var _context21;

      if (!item) {
        // item is null
        return item;
      }

      return reduce(_context21 = isArray$2(fields) ? // Use the supplied array
      fields : // Use the keys of the supplied object
      keys$4(fields)).call(_context21, function (filteredItem, field) {
        filteredItem[field] = item[field];
        return filteredItem;
      }, {});
    }
    /**
     * Sort the provided array with items.
     *
     * @param items - Items to be sorted in place.
     * @param order - A field name or custom sort function.
     *
     * @typeParam T - The type of the items in the items array.
     */

  }, {
    key: "_sort",
    value: function _sort(items, order) {
      if (typeof order === "string") {
        // order by provided field name
        var name = order; // field name

        sort(items).call(items, function (a, b) {
          // @TODO: How to treat missing properties?
          var av = a[name];
          var bv = b[name];
          return av > bv ? 1 : av < bv ? -1 : 0;
        });
      } else if (typeof order === "function") {
        // order by sort function
        sort(items).call(items, order);
      } else {
        // TODO: extend order by an Object {field:string, direction:string}
        //       where direction can be 'asc' or 'desc'
        throw new TypeError("Order must be a function or a string");
      }
    }
    /**
     * Remove an item or multiple items by “reference” (only the id is used) or by id.
     *
     * The method ignores removal of non-existing items, and returns an array containing the ids of the items which are actually removed from the DataSet.
     *
     * After the items are removed, the DataSet will trigger an event `remove` for the removed items. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
     *
     * ## Example
     * ```javascript
     * // create a DataSet
     * const data = new vis.DataSet([
     *   { id: 1, text: 'item 1' },
     *   { id: 2, text: 'item 2' },
     *   { id: 3, text: 'item 3' }
     * ])
     *
     * // remove items
     * const ids = data.remove([2, { id: 3 }, 4])
     *
     * console.log(ids) // [2, 3]
     * ```
     *
     * @param id - One or more items or ids of items to be removed.
     * @param senderId - Sender id.
     *
     * @returns The ids of the removed items.
     */

  }, {
    key: "remove",
    value: function remove(id, senderId) {
      var removedIds = [];
      var removedItems = []; // force everything to be an array for simplicity

      var ids = isArray$2(id) ? id : [id];

      for (var i = 0, len = ids.length; i < len; i++) {
        var item = this._remove(ids[i]);

        if (item) {
          var itemId = item[this._idProp];

          if (itemId != null) {
            removedIds.push(itemId);
            removedItems.push(item);
          }
        }
      }

      if (removedIds.length) {
        this._trigger("remove", {
          items: removedIds,
          oldData: removedItems
        }, senderId);
      }

      return removedIds;
    }
    /**
     * Remove an item by its id or reference.
     *
     * @param id - Id of an item or the item itself.
     *
     * @returns The removed item if removed, null otherwise.
     */

  }, {
    key: "_remove",
    value: function _remove(id) {
      // @TODO: It origianlly returned the item although the docs say id.
      // The code expects the item, so probably an error in the docs.
      var ident; // confirm the id to use based on the args type

      if (isId(id)) {
        ident = id;
      } else if (id && _typeof(id) === "object") {
        ident = id[this._idProp]; // look for the identifier field using ._idProp
      } // do the removing if the item is found


      if (ident != null && this._data.has(ident)) {
        var item = this._data.get(ident) || null;

        this._data.delete(ident);

        --this.length;
        return item;
      }

      return null;
    }
    /**
     * Clear the entire data set.
     *
     * After the items are removed, the [[DataSet]] will trigger an event `remove` for all removed items. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
     *
     * @param senderId - Sender id.
     *
     * @returns removedIds - The ids of all removed items.
     */

  }, {
    key: "clear",
    value: function clear(senderId) {
      var _context22;

      var ids = _toConsumableArray(keys(_context22 = this._data).call(_context22));

      var items = [];

      for (var i = 0, len = ids.length; i < len; i++) {
        items.push(this._data.get(ids[i]));
      }

      this._data.clear();

      this.length = 0;

      this._trigger("remove", {
        items: ids,
        oldData: items
      }, senderId);

      return ids;
    }
    /**
     * Find the item with maximum value of a specified field.
     *
     * @param field - Name of the property that should be searched for max value.
     *
     * @returns Item containing max value, or null if no items.
     */

  }, {
    key: "max",
    value: function max(field) {
      var _context23;

      var max = null;
      var maxField = null;

      var _iterator11 = _createForOfIteratorHelper$7(values(_context23 = this._data).call(_context23)),
          _step11;

      try {
        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
          var item = _step11.value;
          var itemField = item[field];

          if (typeof itemField === "number" && (maxField == null || itemField > maxField)) {
            max = item;
            maxField = itemField;
          }
        }
      } catch (err) {
        _iterator11.e(err);
      } finally {
        _iterator11.f();
      }

      return max || null;
    }
    /**
     * Find the item with minimum value of a specified field.
     *
     * @param field - Name of the property that should be searched for min value.
     *
     * @returns Item containing min value, or null if no items.
     */

  }, {
    key: "min",
    value: function min(field) {
      var _context24;

      var min = null;
      var minField = null;

      var _iterator12 = _createForOfIteratorHelper$7(values(_context24 = this._data).call(_context24)),
          _step12;

      try {
        for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
          var item = _step12.value;
          var itemField = item[field];

          if (typeof itemField === "number" && (minField == null || itemField < minField)) {
            min = item;
            minField = itemField;
          }
        }
      } catch (err) {
        _iterator12.e(err);
      } finally {
        _iterator12.f();
      }

      return min || null;
    }
    /**
     * Find all distinct values of a specified field
     *
     * @param prop - The property name whose distinct values should be returned.
     *
     * @returns Unordered array containing all distinct values. Items without specified property are ignored.
     */

  }, {
    key: "distinct",
    value: function distinct(prop) {
      var data = this._data;

      var itemIds = _toConsumableArray(keys(data).call(data));

      var values = [];
      var count = 0;

      for (var i = 0, len = itemIds.length; i < len; i++) {
        var id = itemIds[i];
        var item = data.get(id);
        var _value3 = item[prop];
        var exists = false;

        for (var j = 0; j < count; j++) {
          if (values[j] == _value3) {
            exists = true;
            break;
          }
        }

        if (!exists && _value3 !== undefined) {
          values[count] = _value3;
          count++;
        }
      }

      return values;
    }
    /**
     * Add a single item. Will fail when an item with the same id already exists.
     *
     * @param item - A new item to be added.
     *
     * @returns Added item's id. An id is generated when it is not present in the item.
     */

  }, {
    key: "_addItem",
    value: function _addItem(item) {
      var fullItem = ensureFullItem(item, this._idProp);
      var id = fullItem[this._idProp]; // check whether this id is already taken

      if (this._data.has(id)) {
        // item already exists
        throw new Error("Cannot add item: item with id " + id + " already exists");
      }

      this._data.set(id, fullItem);

      ++this.length;
      return id;
    }
    /**
     * Update a single item: merge with existing item.
     * Will fail when the item has no id, or when there does not exist an item with the same id.
     *
     * @param update - The new item
     *
     * @returns The id of the updated item.
     */

  }, {
    key: "_updateItem",
    value: function _updateItem(update) {
      var id = update[this._idProp];

      if (id == null) {
        throw new Error("Cannot update item: item has no id (item: " + stringify$1(update) + ")");
      }

      var item = this._data.get(id);

      if (!item) {
        // item doesn't exist
        throw new Error("Cannot update item: no item with id " + id + " found");
      }

      this._data.set(id, _objectSpread$4(_objectSpread$4({}, item), update));

      return id;
    }
    /** @inheritDoc */

  }, {
    key: "stream",
    value: function stream(ids) {
      if (ids) {
        var data = this._data;
        return new DataStream(_defineProperty({}, iterator, /*#__PURE__*/regenerator.mark(function _callee3() {
          var _iterator13, _step13, id, item;

          return regenerator.wrap(function _callee3$(_context25) {
            while (1) {
              switch (_context25.prev = _context25.next) {
                case 0:
                  _iterator13 = _createForOfIteratorHelper$7(ids);
                  _context25.prev = 1;

                  _iterator13.s();

                case 3:
                  if ((_step13 = _iterator13.n()).done) {
                    _context25.next = 11;
                    break;
                  }

                  id = _step13.value;
                  item = data.get(id);

                  if (!(item != null)) {
                    _context25.next = 9;
                    break;
                  }

                  _context25.next = 9;
                  return [id, item];

                case 9:
                  _context25.next = 3;
                  break;

                case 11:
                  _context25.next = 16;
                  break;

                case 13:
                  _context25.prev = 13;
                  _context25.t0 = _context25["catch"](1);

                  _iterator13.e(_context25.t0);

                case 16:
                  _context25.prev = 16;

                  _iterator13.f();

                  return _context25.finish(16);

                case 19:
                case "end":
                  return _context25.stop();
              }
            }
          }, _callee3, null, [[1, 13, 16, 19]]);
        })));
      } else {
        var _context26;

        return new DataStream(_defineProperty({}, iterator, bind$6(_context26 = entries(this._data)).call(_context26, this._data)));
      }
    }
  }]);

  return DataSet;
}(DataSetPart);
/**
 * DataView
 *
 * A DataView offers a filtered and/or formatted view on a DataSet. One can subscribe to changes in a DataView, and easily get filtered or formatted data without having to specify filters and field types all the time.
 *
 * ## Example
 * ```javascript
 * // create a DataSet
 * var data = new vis.DataSet();
 * data.add([
 *   {id: 1, text: 'item 1', date: new Date(2013, 6, 20), group: 1, first: true},
 *   {id: 2, text: 'item 2', date: '2013-06-23', group: 2},
 *   {id: 3, text: 'item 3', date: '2013-06-25', group: 2},
 *   {id: 4, text: 'item 4'}
 * ]);
 *
 * // create a DataView
 * // the view will only contain items having a property group with value 1,
 * // and will only output fields id, text, and date.
 * var view = new vis.DataView(data, {
 *   filter: function (item) {
 *     return (item.group == 1);
 *   },
 *   fields: ['id', 'text', 'date']
 * });
 *
 * // subscribe to any change in the DataView
 * view.on('*', function (event, properties, senderId) {
 *   console.log('event', event, properties);
 * });
 *
 * // update an item in the data set
 * data.update({id: 2, group: 1});
 *
 * // get all ids in the view
 * var ids = view.getIds();
 * console.log('ids', ids); // will output [1, 2]
 *
 * // get all items in the view
 * var items = view.get();
 * ```
 *
 * @typeParam Item - Item type that may or may not have an id.
 * @typeParam IdProp - Name of the property that contains the id.
 */


var DataView = /*#__PURE__*/function (_DataSetPart2) {
  _inherits(DataView, _DataSetPart2);

  var _super2 = _createSuper$t(DataView);

  /**
   * Create a DataView.
   *
   * @param data - The instance containing data (directly or indirectly).
   * @param options - Options to configure this data view.
   */
  function DataView(data, options) {
    var _context27;

    var _this7;

    _classCallCheck(this, DataView);

    _this7 = _super2.call(this);
    /** @inheritDoc */

    _this7.length = 0;
    _this7._ids = new set(); // ids of the items currently in memory (just contains a boolean true)

    _this7._options = options || {};
    _this7._listener = bind$6(_context27 = _this7._onEvent).call(_context27, _assertThisInitialized(_this7));

    _this7.setData(data);

    return _this7;
  }
  /** @inheritDoc */


  _createClass(DataView, [{
    key: "idProp",
    get: function get() {
      return this.getDataSet().idProp;
    } // TODO: implement a function .config() to dynamically update things like configured filter
    // and trigger changes accordingly

    /**
     * Set a data source for the view.
     *
     * @param data - The instance containing data (directly or indirectly).
     *
     * @remarks
     * Note that when the data view is bound to a data set it won't be garbage
     * collected unless the data set is too. Use `dataView.setData(null)` or
     * `dataView.dispose()` to enable garbage collection before you lose the last
     * reference.
     */

  }, {
    key: "setData",
    value: function setData(data) {
      if (this._data) {
        // unsubscribe from current dataset
        if (this._data.off) {
          this._data.off("*", this._listener);
        } // trigger a remove of all items in memory


        var ids = this._data.getIds({
          filter: filter(this._options)
        });

        var items = this._data.get(ids);

        this._ids.clear();

        this.length = 0;

        this._trigger("remove", {
          items: ids,
          oldData: items
        });
      }

      if (data != null) {
        this._data = data; // trigger an add of all added items

        var _ids = this._data.getIds({
          filter: filter(this._options)
        });

        for (var i = 0, len = _ids.length; i < len; i++) {
          var id = _ids[i];

          this._ids.add(id);
        }

        this.length = _ids.length;

        this._trigger("add", {
          items: _ids
        });
      } else {
        this._data = new DataSet();
      } // subscribe to new dataset


      if (this._data.on) {
        this._data.on("*", this._listener);
      }
    }
    /**
     * Refresh the DataView.
     * Useful when the DataView has a filter function containing a variable parameter.
     */

  }, {
    key: "refresh",
    value: function refresh() {
      var ids = this._data.getIds({
        filter: filter(this._options)
      });

      var oldIds = _toConsumableArray(this._ids);

      var newIds = {};
      var addedIds = [];
      var removedIds = [];
      var removedItems = []; // check for additions

      for (var i = 0, len = ids.length; i < len; i++) {
        var id = ids[i];
        newIds[id] = true;

        if (!this._ids.has(id)) {
          addedIds.push(id);

          this._ids.add(id);
        }
      } // check for removals


      for (var _i10 = 0, _len11 = oldIds.length; _i10 < _len11; _i10++) {
        var _id7 = oldIds[_i10];

        var item = this._data.get(_id7);

        if (item == null) {
          // @TODO: Investigate.
          // Doesn't happen during tests or examples.
          // Is it really impossible or could it eventually happen?
          // How to handle it if it does? The types guarantee non-nullable items.
          console.error("If you see this, report it please.");
        } else if (!newIds[_id7]) {
          removedIds.push(_id7);
          removedItems.push(item);

          this._ids.delete(_id7);
        }
      }

      this.length += addedIds.length - removedIds.length; // trigger events

      if (addedIds.length) {
        this._trigger("add", {
          items: addedIds
        });
      }

      if (removedIds.length) {
        this._trigger("remove", {
          items: removedIds,
          oldData: removedItems
        });
      }
    }
    /** @inheritDoc */

  }, {
    key: "get",
    value: function get(first, second) {
      if (this._data == null) {
        return null;
      } // parse the arguments


      var ids = null;
      var options;

      if (isId(first) || isArray$2(first)) {
        ids = first;
        options = second;
      } else {
        options = first;
      } // extend the options with the default options and provided options


      var viewOptions = assign$2({}, this._options, options); // create a combined filter method when needed


      var thisFilter = filter(this._options);

      var optionsFilter = options && filter(options);

      if (thisFilter && optionsFilter) {
        viewOptions.filter = function (item) {
          return thisFilter(item) && optionsFilter(item);
        };
      }

      if (ids == null) {
        return this._data.get(viewOptions);
      } else {
        return this._data.get(ids, viewOptions);
      }
    }
    /** @inheritDoc */

  }, {
    key: "getIds",
    value: function getIds(options) {
      if (this._data.length) {
        var defaultFilter = filter(this._options);

        var optionsFilter = options != null ? filter(options) : null;
        var filter$1;

        if (optionsFilter) {
          if (defaultFilter) {
            filter$1 = function filter(item) {
              return defaultFilter(item) && optionsFilter(item);
            };
          } else {
            filter$1 = optionsFilter;
          }
        } else {
          filter$1 = defaultFilter;
        }

        return this._data.getIds({
          filter: filter$1,
          order: options && options.order
        });
      } else {
        return [];
      }
    }
    /** @inheritDoc */

  }, {
    key: "forEach",
    value: function forEach(callback, options) {
      if (this._data) {
        var _context28;

        var defaultFilter = filter(this._options);

        var optionsFilter = options && filter(options);

        var filter$1;

        if (optionsFilter) {
          if (defaultFilter) {
            filter$1 = function filter(item) {
              return defaultFilter(item) && optionsFilter(item);
            };
          } else {
            filter$1 = optionsFilter;
          }
        } else {
          filter$1 = defaultFilter;
        }

        forEach$2(_context28 = this._data).call(_context28, callback, {
          filter: filter$1,
          order: options && options.order
        });
      }
    }
    /** @inheritDoc */

  }, {
    key: "map",
    value: function map(callback, options) {
      if (this._data) {
        var _context29;

        var defaultFilter = filter(this._options);

        var optionsFilter = options && filter(options);

        var filter$1;

        if (optionsFilter) {
          if (defaultFilter) {
            filter$1 = function filter(item) {
              return defaultFilter(item) && optionsFilter(item);
            };
          } else {
            filter$1 = optionsFilter;
          }
        } else {
          filter$1 = defaultFilter;
        }

        return map$3(_context29 = this._data).call(_context29, callback, {
          filter: filter$1,
          order: options && options.order
        });
      } else {
        return [];
      }
    }
    /** @inheritDoc */

  }, {
    key: "getDataSet",
    value: function getDataSet() {
      return this._data.getDataSet();
    }
    /** @inheritDoc */

  }, {
    key: "stream",
    value: function stream(ids) {
      var _context30;

      return this._data.stream(ids || _defineProperty({}, iterator, bind$6(_context30 = keys(this._ids)).call(_context30, this._ids)));
    }
    /**
     * Render the instance unusable prior to garbage collection.
     *
     * @remarks
     * The intention of this method is to help discover scenarios where the data
     * view is being used when the programmer thinks it has been garbage collected
     * already. It's stricter version of `dataView.setData(null)`.
     */

  }, {
    key: "dispose",
    value: function dispose() {
      var _this$_data;

      if ((_this$_data = this._data) !== null && _this$_data !== void 0 && _this$_data.off) {
        this._data.off("*", this._listener);
      }

      var message = "This data view has already been disposed of.";
      var replacement = {
        get: function get() {
          throw new Error(message);
        },
        set: function set() {
          throw new Error(message);
        },
        configurable: false
      };

      var _iterator14 = _createForOfIteratorHelper$7(ownKeys$5(DataView.prototype)),
          _step14;

      try {
        for (_iterator14.s(); !(_step14 = _iterator14.n()).done;) {
          var key = _step14.value;

          defineProperty$5(this, key, replacement);
        }
      } catch (err) {
        _iterator14.e(err);
      } finally {
        _iterator14.f();
      }
    }
    /**
     * Event listener. Will propagate all events from the connected data set to the subscribers of the DataView, but will filter the items and only trigger when there are changes in the filtered data set.
     *
     * @param event - The name of the event.
     * @param params - Parameters of the event.
     * @param senderId - Id supplied by the sender.
     */

  }, {
    key: "_onEvent",
    value: function _onEvent(event, params, senderId) {
      if (!params || !params.items || !this._data) {
        return;
      }

      var ids = params.items;
      var addedIds = [];
      var updatedIds = [];
      var removedIds = [];
      var oldItems = [];
      var updatedItems = [];
      var removedItems = [];

      switch (event) {
        case "add":
          // filter the ids of the added items
          for (var i = 0, len = ids.length; i < len; i++) {
            var id = ids[i];
            var item = this.get(id);

            if (item) {
              this._ids.add(id);

              addedIds.push(id);
            }
          }

          break;

        case "update":
          // determine the event from the views viewpoint: an updated
          // item can be added, updated, or removed from this view.
          for (var _i11 = 0, _len12 = ids.length; _i11 < _len12; _i11++) {
            var _id8 = ids[_i11];

            var _item5 = this.get(_id8);

            if (_item5) {
              if (this._ids.has(_id8)) {
                updatedIds.push(_id8);
                updatedItems.push(params.data[_i11]);
                oldItems.push(params.oldData[_i11]);
              } else {
                this._ids.add(_id8);

                addedIds.push(_id8);
              }
            } else {
              if (this._ids.has(_id8)) {
                this._ids.delete(_id8);

                removedIds.push(_id8);
                removedItems.push(params.oldData[_i11]);
              }
            }
          }

          break;

        case "remove":
          // filter the ids of the removed items
          for (var _i12 = 0, _len13 = ids.length; _i12 < _len13; _i12++) {
            var _id9 = ids[_i12];

            if (this._ids.has(_id9)) {
              this._ids.delete(_id9);

              removedIds.push(_id9);
              removedItems.push(params.oldData[_i12]);
            }
          }

          break;
      }

      this.length += addedIds.length - removedIds.length;

      if (addedIds.length) {
        this._trigger("add", {
          items: addedIds
        }, senderId);
      }

      if (updatedIds.length) {
        this._trigger("update", {
          items: updatedIds,
          oldData: oldItems,
          data: updatedItems
        }, senderId);
      }

      if (removedIds.length) {
        this._trigger("remove", {
          items: removedIds,
          oldData: removedItems
        }, senderId);
      }
    }
  }]);

  return DataView;
}(DataSetPart);
/**
 * Check that given value is compatible with Vis Data Set interface.
 *
 * @param idProp - The expected property to contain item id.
 * @param v - The value to be tested.
 *
 * @returns True if all expected values and methods match, false otherwise.
 */


function isDataSetLike(idProp, v) {
  return _typeof(v) === "object" && v !== null && idProp === v.idProp && typeof v.add === "function" && typeof v.clear === "function" && typeof v.distinct === "function" && typeof forEach$2(v) === "function" && typeof v.get === "function" && typeof v.getDataSet === "function" && typeof v.getIds === "function" && typeof v.length === "number" && typeof map$3(v) === "function" && typeof v.max === "function" && typeof v.min === "function" && typeof v.off === "function" && typeof v.on === "function" && typeof v.remove === "function" && typeof v.setOptions === "function" && typeof v.stream === "function" && typeof v.update === "function" && typeof v.updateOnly === "function";
}
/**
 * Check that given value is compatible with Vis Data View interface.
 *
 * @param idProp - The expected property to contain item id.
 * @param v - The value to be tested.
 *
 * @returns True if all expected values and methods match, false otherwise.
 */


function isDataViewLike(idProp, v) {
  return _typeof(v) === "object" && v !== null && idProp === v.idProp && typeof forEach$2(v) === "function" && typeof v.get === "function" && typeof v.getDataSet === "function" && typeof v.getIds === "function" && typeof v.length === "number" && typeof map$3(v) === "function" && typeof v.off === "function" && typeof v.on === "function" && typeof v.stream === "function" && isDataSetLike(idProp, v.getDataSet());
}

var index = /*#__PURE__*/Object.freeze({
	__proto__: null,
	DELETE: DELETE,
	DataSet: DataSet,
	DataStream: DataStream,
	DataView: DataView,
	Queue: Queue,
	createNewDataPipeFrom: createNewDataPipeFrom,
	isDataSetLike: isDataSetLike,
	isDataViewLike: isDataViewLike
});

var global$2 = global$k;
var toString = toString$9;
var trim = stringTrim.trim;
var whitespaces = whitespaces$4;
var $parseFloat = global$2.parseFloat;
var FORCED = 1 / $parseFloat(whitespaces + '-0') !== -Infinity; // `parseFloat` method
// https://tc39.es/ecma262/#sec-parsefloat-string

var numberParseFloat = FORCED ? function parseFloat(string) {
  var trimmedString = trim(toString(string));
  var result = $parseFloat(trimmedString);
  return result === 0 && trimmedString.charAt(0) == '-' ? -0 : result;
} : $parseFloat;

var $$4 = _export;
var parseFloatImplementation = numberParseFloat; // `parseFloat` method
// https://tc39.es/ecma262/#sec-parsefloat-string

$$4({
  global: true,
  forced: parseFloat != parseFloatImplementation
}, {
  parseFloat: parseFloatImplementation
});

var path$5 = path$x;
var _parseFloat$2 = path$5.parseFloat;

var parent$7 = _parseFloat$2;
var _parseFloat$1 = parent$7;

var _parseFloat = _parseFloat$1;

var $$3 = _export;
var fails = fails$m;
var getOwnPropertyNames$3 = objectGetOwnPropertyNamesExternal.f; // eslint-disable-next-line es/no-object-getownpropertynames -- required for testing

var FAILS_ON_PRIMITIVES = fails(function () {
  return !Object.getOwnPropertyNames(1);
}); // `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames

$$3({
  target: 'Object',
  stat: true,
  forced: FAILS_ON_PRIMITIVES
}, {
  getOwnPropertyNames: getOwnPropertyNames$3
});

var path$4 = path$x;
var Object$1 = path$4.Object;

var getOwnPropertyNames$2 = function getOwnPropertyNames(it) {
  return Object$1.getOwnPropertyNames(it);
};

var parent$6 = getOwnPropertyNames$2;
var getOwnPropertyNames$1 = parent$6;

var getOwnPropertyNames = getOwnPropertyNames$1;

/**
 * Helper functions for components
 */

/**
 * Determine values to use for (sub)options of 'chosen'.
 *
 * This option is either a boolean or an object whose values should be examined further.
 * The relevant structures are:
 *
 * - chosen: <boolean value>
 * - chosen: { subOption: <boolean or function> }
 *
 * Where subOption is 'node', 'edge' or 'label'.
 *
 * The intention of this method appears to be to set a specific priority to the options;
 * Since most properties are either bridged or merged into the local options objects, there
 * is not much point in handling them separately.
 * TODO: examine if 'most' in previous sentence can be replaced with 'all'. In that case, we
 *       should be able to get rid of this method.
 *
 * @param {string}  subOption  option within object 'chosen' to consider; either 'node', 'edge' or 'label'
 * @param {object}  pile       array of options objects to consider
 *
 * @returns {boolean | Function}  value for passed subOption of 'chosen' to use
 */

function choosify(subOption, pile) {
  // allowed values for subOption
  var allowed = ["node", "edge", "label"];
  var value = true;
  var chosen = topMost(pile, "chosen");

  if (typeof chosen === "boolean") {
    value = chosen;
  } else if (_typeof(chosen) === "object") {
    if (indexOf(allowed).call(allowed, subOption) === -1) {
      throw new Error("choosify: subOption '" + subOption + "' should be one of " + "'" + allowed.join("', '") + "'");
    }

    var chosenEdge = topMost(pile, ["chosen", subOption]);

    if (typeof chosenEdge === "boolean" || typeof chosenEdge === "function") {
      value = chosenEdge;
    }
  }

  return value;
}
/**
 * Check if the point falls within the given rectangle.
 *
 * @param {rect} rect
 * @param {point} point
 * @param {rotationPoint} [rotationPoint] if specified, the rotation that applies to the rectangle.
 * @returns {boolean}  true if point within rectangle, false otherwise
 */

function pointInRect(rect, point, rotationPoint) {
  if (rect.width <= 0 || rect.height <= 0) {
    return false; // early out
  }

  if (rotationPoint !== undefined) {
    // Rotate the point the same amount as the rectangle
    var tmp = {
      x: point.x - rotationPoint.x,
      y: point.y - rotationPoint.y
    };

    if (rotationPoint.angle !== 0) {
      // In order to get the coordinates the same, you need to
      // rotate in the reverse direction
      var angle = -rotationPoint.angle;
      var tmp2 = {
        x: Math.cos(angle) * tmp.x - Math.sin(angle) * tmp.y,
        y: Math.sin(angle) * tmp.x + Math.cos(angle) * tmp.y
      };
      point = tmp2;
    } else {
      point = tmp;
    } // Note that if a rotation is specified, the rectangle coordinates
    // are **not* the full canvas coordinates. They are relative to the
    // rotationPoint. Hence, the point coordinates need not be translated
    // back in this case.

  }

  var right = rect.x + rect.width;
  var bottom = rect.y + rect.width;
  return rect.left < point.x && right > point.x && rect.top < point.y && bottom > point.y;
}
/**
 * Check if given value is acceptable as a label text.
 *
 * @param {*} text value to check; can be anything at this point
 * @returns {boolean} true if valid label value, false otherwise
 */

function isValidLabel(text) {
  // Note that this is quite strict: types that *might* be converted to string are disallowed
  return typeof text === "string" && text !== "";
}
/**
 * Returns x, y of self reference circle based on provided angle
 *
 * @param {object} ctx
 * @param {number} angle
 * @param {number} radius
 * @param {VisNode} node
 *
 * @returns {object} x and y coordinates
 */

function getSelfRefCoordinates(ctx, angle, radius, node) {
  var x = node.x;
  var y = node.y;

  if (typeof node.distanceToBorder === "function") {
    //calculating opposite and adjacent
    //distaneToBorder becomes Hypotenuse.
    //Formulas sin(a) = Opposite / Hypotenuse and cos(a) = Adjacent / Hypotenuse
    var toBorderDist = node.distanceToBorder(ctx, angle);
    var yFromNodeCenter = Math.sin(angle) * toBorderDist;
    var xFromNodeCenter = Math.cos(angle) * toBorderDist; //xFromNodeCenter is basically x and if xFromNodeCenter equals to the distance to border then it means
    //that y does not need calculation because it is equal node.height / 2 or node.y
    //same thing with yFromNodeCenter and if yFromNodeCenter equals to the distance to border then it means
    //that x is equal node.width / 2 or node.x

    if (xFromNodeCenter === toBorderDist) {
      x += toBorderDist;
      y = node.y;
    } else if (yFromNodeCenter === toBorderDist) {
      x = node.x;
      y -= toBorderDist;
    } else {
      x += xFromNodeCenter;
      y -= yFromNodeCenter;
    }
  } else if (node.shape.width > node.shape.height) {
    x = node.x + node.shape.width * 0.5;
    y = node.y - radius;
  } else {
    x = node.x + radius;
    y = node.y - node.shape.height * 0.5;
  }

  return {
    x: x,
    y: y
  };
}

/**
 * Callback to determine text dimensions, using the parent label settings.
 *
 * @callback MeasureText
 * @param {text} text
 * @param {text} mod
 * @returns {object} { width, values} width in pixels and font attributes
 */

/**
 * Helper class for Label which collects results of splitting labels into lines and blocks.
 *
 * @private
 */
var LabelAccumulator = /*#__PURE__*/function () {
  /**
   * @param {MeasureText} measureText
   */
  function LabelAccumulator(measureText) {
    _classCallCheck(this, LabelAccumulator);

    this.measureText = measureText;
    this.current = 0;
    this.width = 0;
    this.height = 0;
    this.lines = [];
  }
  /**
   * Append given text to the given line.
   *
   * @param {number}  l    index of line to add to
   * @param {string}  text string to append to line
   * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
   * @private
   */


  _createClass(LabelAccumulator, [{
    key: "_add",
    value: function _add(l, text) {
      var mod = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "normal";

      if (this.lines[l] === undefined) {
        this.lines[l] = {
          width: 0,
          height: 0,
          blocks: []
        };
      } // We still need to set a block for undefined and empty texts, hence return at this point
      // This is necessary because we don't know at this point if we're at the
      // start of an empty line or not.
      // To compensate, empty blocks are removed in `finalize()`.
      //
      // Empty strings should still have a height


      var tmpText = text;
      if (text === undefined || text === "") tmpText = " "; // Determine width and get the font properties

      var result = this.measureText(tmpText, mod);

      var block = assign$2({}, values(result));

      block.text = text;
      block.width = result.width;
      block.mod = mod;

      if (text === undefined || text === "") {
        block.width = 0;
      }

      this.lines[l].blocks.push(block); // Update the line width. We need this for determining if a string goes over max width

      this.lines[l].width += block.width;
    }
    /**
     * Returns the width in pixels of the current line.
     *
     * @returns {number}
     */

  }, {
    key: "curWidth",
    value: function curWidth() {
      var line = this.lines[this.current];
      if (line === undefined) return 0;
      return line.width;
    }
    /**
     * Add text in block to current line
     *
     * @param {string} text
     * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
     */

  }, {
    key: "append",
    value: function append(text) {
      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "normal";

      this._add(this.current, text, mod);
    }
    /**
     * Add text in block to current line and start a new line
     *
     * @param {string} text
     * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
     */

  }, {
    key: "newLine",
    value: function newLine(text) {
      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "normal";

      this._add(this.current, text, mod);

      this.current++;
    }
    /**
     * Determine and set the heights of all the lines currently contained in this instance
     *
     * Note that width has already been set.
     *
     * @private
     */

  }, {
    key: "determineLineHeights",
    value: function determineLineHeights() {
      for (var k = 0; k < this.lines.length; k++) {
        var line = this.lines[k]; // Looking for max height of blocks in line

        var height = 0;

        if (line.blocks !== undefined) {
          // Can happen if text contains e.g. '\n '
          for (var l = 0; l < line.blocks.length; l++) {
            var block = line.blocks[l];

            if (height < block.height) {
              height = block.height;
            }
          }
        }

        line.height = height;
      }
    }
    /**
     * Determine the full size of the label text, as determined by current lines and blocks
     *
     * @private
     */

  }, {
    key: "determineLabelSize",
    value: function determineLabelSize() {
      var width = 0;
      var height = 0;

      for (var k = 0; k < this.lines.length; k++) {
        var line = this.lines[k];

        if (line.width > width) {
          width = line.width;
        }

        height += line.height;
      }

      this.width = width;
      this.height = height;
    }
    /**
     * Remove all empty blocks and empty lines we don't need
     *
     * This must be done after the width/height determination,
     * so that these are set properly for processing here.
     *
     * @returns {Array<Line>} Lines with empty blocks (and some empty lines) removed
     * @private
     */

  }, {
    key: "removeEmptyBlocks",
    value: function removeEmptyBlocks() {
      var tmpLines = [];

      for (var k = 0; k < this.lines.length; k++) {
        var line = this.lines[k]; // Note: an empty line in between text has width zero but is still relevant to layout.
        // So we can't use width for testing empty line here

        if (line.blocks.length === 0) continue; // Discard final empty line always

        if (k === this.lines.length - 1) {
          if (line.width === 0) continue;
        }

        var tmpLine = {};

        assign$2(tmpLine, line);

        tmpLine.blocks = [];
        var firstEmptyBlock = void 0;
        var tmpBlocks = [];

        for (var l = 0; l < line.blocks.length; l++) {
          var block = line.blocks[l];

          if (block.width !== 0) {
            tmpBlocks.push(block);
          } else {
            if (firstEmptyBlock === undefined) {
              firstEmptyBlock = block;
            }
          }
        } // Ensure that there is *some* text present


        if (tmpBlocks.length === 0 && firstEmptyBlock !== undefined) {
          tmpBlocks.push(firstEmptyBlock);
        }

        tmpLine.blocks = tmpBlocks;
        tmpLines.push(tmpLine);
      }

      return tmpLines;
    }
    /**
     * Set the sizes for all lines and the whole thing.
     *
     * @returns {{width: (number|*), height: (number|*), lines: Array}}
     */

  }, {
    key: "finalize",
    value: function finalize() {
      //console.log(JSON.stringify(this.lines, null, 2));
      this.determineLineHeights();
      this.determineLabelSize();
      var tmpLines = this.removeEmptyBlocks(); // Return a simple hash object for further processing.

      return {
        width: this.width,
        height: this.height,
        lines: tmpLines
      };
    }
  }]);

  return LabelAccumulator;
}();

var tagPattern = {
  // HTML
  "<b>": /<b>/,
  "<i>": /<i>/,
  "<code>": /<code>/,
  "</b>": /<\/b>/,
  "</i>": /<\/i>/,
  "</code>": /<\/code>/,
  // Markdown
  "*": /\*/,
  // bold
  _: /_/,
  // ital
  "`": /`/,
  // mono
  afterBold: /[^*]/,
  afterItal: /[^_]/,
  afterMono: /[^`]/
};
/**
 * Internal helper class for parsing the markup tags for HTML and Markdown.
 *
 * NOTE: Sequences of tabs and spaces are reduced to single space.
 *       Scan usage of `this.spacing` within method
 */

var MarkupAccumulator = /*#__PURE__*/function () {
  /**
   * Create an instance
   *
   * @param {string} text  text to parse for markup
   */
  function MarkupAccumulator(text) {
    _classCallCheck(this, MarkupAccumulator);

    this.text = text;
    this.bold = false;
    this.ital = false;
    this.mono = false;
    this.spacing = false;
    this.position = 0;
    this.buffer = "";
    this.modStack = [];
    this.blocks = [];
  }
  /**
   * Return the mod label currently on the top of the stack
   *
   * @returns {string}  label of topmost mod
   * @private
   */


  _createClass(MarkupAccumulator, [{
    key: "mod",
    value: function mod() {
      return this.modStack.length === 0 ? "normal" : this.modStack[0];
    }
    /**
     * Return the mod label currently active
     *
     * @returns {string}  label of active mod
     * @private
     */

  }, {
    key: "modName",
    value: function modName() {
      if (this.modStack.length === 0) return "normal";else if (this.modStack[0] === "mono") return "mono";else {
        if (this.bold && this.ital) {
          return "boldital";
        } else if (this.bold) {
          return "bold";
        } else if (this.ital) {
          return "ital";
        }
      }
    }
    /**
     * @private
     */

  }, {
    key: "emitBlock",
    value: function emitBlock() {
      if (this.spacing) {
        this.add(" ");
        this.spacing = false;
      }

      if (this.buffer.length > 0) {
        this.blocks.push({
          text: this.buffer,
          mod: this.modName()
        });
        this.buffer = "";
      }
    }
    /**
     * Output text to buffer
     *
     * @param {string} text  text to add
     * @private
     */

  }, {
    key: "add",
    value: function add(text) {
      if (text === " ") {
        this.spacing = true;
      }

      if (this.spacing) {
        this.buffer += " ";
        this.spacing = false;
      }

      if (text != " ") {
        this.buffer += text;
      }
    }
    /**
     * Handle parsing of whitespace
     *
     * @param {string} ch  the character to check
     * @returns {boolean} true if the character was processed as whitespace, false otherwise
     */

  }, {
    key: "parseWS",
    value: function parseWS(ch) {
      if (/[ \t]/.test(ch)) {
        if (!this.mono) {
          this.spacing = true;
        } else {
          this.add(ch);
        }

        return true;
      }

      return false;
    }
    /**
     * @param {string} tagName  label for block type to set
     * @private
     */

  }, {
    key: "setTag",
    value: function setTag(tagName) {
      this.emitBlock();
      this[tagName] = true;
      this.modStack.unshift(tagName);
    }
    /**
     * @param {string} tagName  label for block type to unset
     * @private
     */

  }, {
    key: "unsetTag",
    value: function unsetTag(tagName) {
      this.emitBlock();
      this[tagName] = false;
      this.modStack.shift();
    }
    /**
     * @param {string} tagName label for block type we are currently processing
     * @param {string|RegExp} tag string to match in text
     * @returns {boolean} true if the tag was processed, false otherwise
     */

  }, {
    key: "parseStartTag",
    value: function parseStartTag(tagName, tag) {
      // Note: if 'mono' passed as tagName, there is a double check here. This is OK
      if (!this.mono && !this[tagName] && this.match(tag)) {
        this.setTag(tagName);
        return true;
      }

      return false;
    }
    /**
     * @param {string|RegExp} tag
     * @param {number} [advance=true] if set, advance current position in text
     * @returns {boolean} true if match at given position, false otherwise
     * @private
     */

  }, {
    key: "match",
    value: function match(tag) {
      var advance = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      var _this$prepareRegExp = this.prepareRegExp(tag),
          _this$prepareRegExp2 = _slicedToArray(_this$prepareRegExp, 2),
          regExp = _this$prepareRegExp2[0],
          length = _this$prepareRegExp2[1];

      var matched = regExp.test(this.text.substr(this.position, length));

      if (matched && advance) {
        this.position += length - 1;
      }

      return matched;
    }
    /**
     * @param {string} tagName label for block type we are currently processing
     * @param {string|RegExp} tag string to match in text
     * @param {RegExp} [nextTag] regular expression to match for characters *following* the current tag
     * @returns {boolean} true if the tag was processed, false otherwise
     */

  }, {
    key: "parseEndTag",
    value: function parseEndTag(tagName, tag, nextTag) {
      var checkTag = this.mod() === tagName;

      if (tagName === "mono") {
        // special handling for 'mono'
        checkTag = checkTag && this.mono;
      } else {
        checkTag = checkTag && !this.mono;
      }

      if (checkTag && this.match(tag)) {
        if (nextTag !== undefined) {
          // Purpose of the following match is to prevent a direct unset/set of a given tag
          // E.g. '*bold **still bold*' => '*bold still bold*'
          if (this.position === this.text.length - 1 || this.match(nextTag, false)) {
            this.unsetTag(tagName);
          }
        } else {
          this.unsetTag(tagName);
        }

        return true;
      }

      return false;
    }
    /**
     * @param {string|RegExp} tag  string to match in text
     * @param {value} value  string to replace tag with, if found at current position
     * @returns {boolean} true if the tag was processed, false otherwise
     */

  }, {
    key: "replace",
    value: function replace(tag, value) {
      if (this.match(tag)) {
        this.add(value);
        this.position += length - 1;
        return true;
      }

      return false;
    }
    /**
     * Create a regular expression for the tag if it isn't already one.
     *
     * The return value is an array `[RegExp, number]`, with exactly two value, where:
     *  - RegExp is the regular expression to use
     *  - number is the lenth of the input string to match
     *
     * @param {string|RegExp} tag  string to match in text
     * @returns {Array}  regular expression to use and length of input string to match
     * @private
     */

  }, {
    key: "prepareRegExp",
    value: function prepareRegExp(tag) {
      var length;
      var regExp;

      if (tag instanceof RegExp) {
        regExp = tag;
        length = 1; // ASSUMPTION: regexp only tests one character
      } else {
        // use prepared regexp if present
        var prepared = tagPattern[tag];

        if (prepared !== undefined) {
          regExp = prepared;
        } else {
          regExp = new RegExp(tag);
        }

        length = tag.length;
      }

      return [regExp, length];
    }
  }]);

  return MarkupAccumulator;
}();
/**
 * Helper class for Label which explodes the label text into lines and blocks within lines
 *
 * @private
 */


var LabelSplitter = /*#__PURE__*/function () {
  /**
   * @param {CanvasRenderingContext2D} ctx Canvas rendering context
   * @param {Label} parent reference to the Label instance using current instance
   * @param {boolean} selected
   * @param {boolean} hover
   */
  function LabelSplitter(ctx, parent, selected, hover) {
    var _this = this;

    _classCallCheck(this, LabelSplitter);

    this.ctx = ctx;
    this.parent = parent;
    this.selected = selected;
    this.hover = hover;
    /**
     * Callback to determine text width; passed to LabelAccumulator instance
     *
     * @param  {string} text string to determine width of
     * @param  {string} mod  font type to use for this text
     * @returns {object} { width, values} width in pixels and font attributes
     */

    var textWidth = function textWidth(text, mod) {
      if (text === undefined) return 0; // TODO: This can be done more efficiently with caching
      // This will set the ctx.font correctly, depending on selected/hover and mod - so that ctx.measureText() will be accurate.

      var values = _this.parent.getFormattingValues(ctx, selected, hover, mod);

      var width = 0;

      if (text !== "") {
        var measure = _this.ctx.measureText(text);

        width = measure.width;
      }

      return {
        width: width,
        values: values
      };
    };

    this.lines = new LabelAccumulator(textWidth);
  }
  /**
   * Split passed text of a label into lines and blocks.
   *
   * # NOTE
   *
   * The handling of spacing is option dependent:
   *
   * - if `font.multi : false`, all spaces are retained
   * - if `font.multi : true`, every sequence of spaces is compressed to a single space
   *
   * This might not be the best way to do it, but this is as it has been working till now.
   * In order not to break existing functionality, for the time being this behaviour will
   * be retained in any code changes.
   *
   * @param {string} text  text to split
   * @returns {Array<line>}
   */


  _createClass(LabelSplitter, [{
    key: "process",
    value: function process(text) {
      if (!isValidLabel(text)) {
        return this.lines.finalize();
      }

      var font = this.parent.fontOptions; // Normalize the end-of-line's to a single representation - order important

      text = text.replace(/\r\n/g, "\n"); // Dos EOL's

      text = text.replace(/\r/g, "\n"); // Mac EOL's
      // Note that at this point, there can be no \r's in the text.
      // This is used later on splitStringIntoLines() to split multifont texts.

      var nlLines = String(text).split("\n");
      var lineCount = nlLines.length;

      if (font.multi) {
        // Multi-font case: styling tags active
        for (var i = 0; i < lineCount; i++) {
          var blocks = this.splitBlocks(nlLines[i], font.multi); // Post: Sequences of tabs and spaces are reduced to single space

          if (blocks === undefined) continue;

          if (blocks.length === 0) {
            this.lines.newLine("");
            continue;
          }

          if (font.maxWdt > 0) {
            // widthConstraint.maximum defined
            //console.log('Running widthConstraint multi, max: ' + this.fontOptions.maxWdt);
            for (var j = 0; j < blocks.length; j++) {
              var mod = blocks[j].mod;
              var _text = blocks[j].text;
              this.splitStringIntoLines(_text, mod, true);
            }
          } else {
            // widthConstraint.maximum NOT defined
            for (var _j = 0; _j < blocks.length; _j++) {
              var _mod = blocks[_j].mod;
              var _text2 = blocks[_j].text;
              this.lines.append(_text2, _mod);
            }
          }

          this.lines.newLine();
        }
      } else {
        // Single-font case
        if (font.maxWdt > 0) {
          // widthConstraint.maximum defined
          // console.log('Running widthConstraint normal, max: ' + this.fontOptions.maxWdt);
          for (var _i = 0; _i < lineCount; _i++) {
            this.splitStringIntoLines(nlLines[_i]);
          }
        } else {
          // widthConstraint.maximum NOT defined
          for (var _i2 = 0; _i2 < lineCount; _i2++) {
            this.lines.newLine(nlLines[_i2]);
          }
        }
      }

      return this.lines.finalize();
    }
    /**
     * normalize the markup system
     *
     * @param {boolean|'md'|'markdown'|'html'} markupSystem
     * @returns {string}
     */

  }, {
    key: "decodeMarkupSystem",
    value: function decodeMarkupSystem(markupSystem) {
      var system = "none";

      if (markupSystem === "markdown" || markupSystem === "md") {
        system = "markdown";
      } else if (markupSystem === true || markupSystem === "html") {
        system = "html";
      }

      return system;
    }
    /**
     *
     * @param {string} text
     * @returns {Array}
     */

  }, {
    key: "splitHtmlBlocks",
    value: function splitHtmlBlocks(text) {
      var s = new MarkupAccumulator(text);

      var parseEntities = function parseEntities(ch) {
        if (/&/.test(ch)) {
          var parsed = s.replace(s.text, "&lt;", "<") || s.replace(s.text, "&amp;", "&");

          if (!parsed) {
            s.add("&");
          }

          return true;
        }

        return false;
      };

      while (s.position < s.text.length) {
        var ch = s.text.charAt(s.position);
        var parsed = s.parseWS(ch) || /</.test(ch) && (s.parseStartTag("bold", "<b>") || s.parseStartTag("ital", "<i>") || s.parseStartTag("mono", "<code>") || s.parseEndTag("bold", "</b>") || s.parseEndTag("ital", "</i>") || s.parseEndTag("mono", "</code>")) || parseEntities(ch);

        if (!parsed) {
          s.add(ch);
        }

        s.position++;
      }

      s.emitBlock();
      return s.blocks;
    }
    /**
     *
     * @param {string} text
     * @returns {Array}
     */

  }, {
    key: "splitMarkdownBlocks",
    value: function splitMarkdownBlocks(text) {
      var _this2 = this;

      var s = new MarkupAccumulator(text);
      var beginable = true;

      var parseOverride = function parseOverride(ch) {
        if (/\\/.test(ch)) {
          if (s.position < _this2.text.length + 1) {
            s.position++;
            ch = _this2.text.charAt(s.position);

            if (/ \t/.test(ch)) {
              s.spacing = true;
            } else {
              s.add(ch);
              beginable = false;
            }
          }

          return true;
        }

        return false;
      };

      while (s.position < s.text.length) {
        var ch = s.text.charAt(s.position);
        var parsed = s.parseWS(ch) || parseOverride(ch) || (beginable || s.spacing) && (s.parseStartTag("bold", "*") || s.parseStartTag("ital", "_") || s.parseStartTag("mono", "`")) || s.parseEndTag("bold", "*", "afterBold") || s.parseEndTag("ital", "_", "afterItal") || s.parseEndTag("mono", "`", "afterMono");

        if (!parsed) {
          s.add(ch);
          beginable = false;
        }

        s.position++;
      }

      s.emitBlock();
      return s.blocks;
    }
    /**
     * Explodes a piece of text into single-font blocks using a given markup
     *
     * @param {string} text
     * @param {boolean|'md'|'markdown'|'html'} markupSystem
     * @returns {Array.<{text: string, mod: string}>}
     * @private
     */

  }, {
    key: "splitBlocks",
    value: function splitBlocks(text, markupSystem) {
      var system = this.decodeMarkupSystem(markupSystem);

      if (system === "none") {
        return [{
          text: text,
          mod: "normal"
        }];
      } else if (system === "markdown") {
        return this.splitMarkdownBlocks(text);
      } else if (system === "html") {
        return this.splitHtmlBlocks(text);
      }
    }
    /**
     * @param {string} text
     * @returns {boolean} true if text length over the current max with
     * @private
     */

  }, {
    key: "overMaxWidth",
    value: function overMaxWidth(text) {
      var width = this.ctx.measureText(text).width;
      return this.lines.curWidth() + width > this.parent.fontOptions.maxWdt;
    }
    /**
     * Determine the longest part of the sentence which still fits in the
     * current max width.
     *
     * @param {Array} words  Array of strings signifying a text lines
     * @returns {number}      index of first item in string making string go over max
     * @private
     */

  }, {
    key: "getLongestFit",
    value: function getLongestFit(words) {
      var text = "";
      var w = 0;

      while (w < words.length) {
        var pre = text === "" ? "" : " ";
        var newText = text + pre + words[w];
        if (this.overMaxWidth(newText)) break;
        text = newText;
        w++;
      }

      return w;
    }
    /**
     * Determine the longest part of the string which still fits in the
     * current max width.
     *
     * @param {Array} words Array of strings signifying a text lines
     * @returns {number} index of first item in string making string go over max
     */

  }, {
    key: "getLongestFitWord",
    value: function getLongestFitWord(words) {
      var w = 0;

      while (w < words.length) {
        if (this.overMaxWidth(slice$1(words).call(words, 0, w))) break;
        w++;
      }

      return w;
    }
    /**
     * Split the passed text into lines, according to width constraint (if any).
     *
     * The method assumes that the input string is a single line, i.e. without lines break.
     *
     * This method retains spaces, if still present (case `font.multi: false`).
     * A space which falls on an internal line break, will be replaced by a newline.
     * There is no special handling of tabs; these go along with the flow.
     *
     * @param {string} str
     * @param {string} [mod='normal']
     * @param {boolean} [appendLast=false]
     * @private
     */

  }, {
    key: "splitStringIntoLines",
    value: function splitStringIntoLines(str) {
      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "normal";
      var appendLast = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      // Set the canvas context font, based upon the current selected/hover state
      // and the provided mod, so the text measurement performed by getLongestFit
      // will be accurate - and not just use the font of whoever last used the canvas.
      this.parent.getFormattingValues(this.ctx, this.selected, this.hover, mod); // Still-present spaces are relevant, retain them

      str = str.replace(/^( +)/g, "$1\r");
      str = str.replace(/([^\r][^ ]*)( +)/g, "$1\r$2\r");
      var words = str.split("\r");

      while (words.length > 0) {
        var w = this.getLongestFit(words);

        if (w === 0) {
          // Special case: the first word is already larger than the max width.
          var word = words[0]; // Break the word to the largest part that fits the line

          var x = this.getLongestFitWord(word);
          this.lines.newLine(slice$1(word).call(word, 0, x), mod); // Adjust the word, so that the rest will be done next iteration

          words[0] = slice$1(word).call(word, x);
        } else {
          // skip any space that is replaced by a newline
          var newW = w;

          if (words[w - 1] === " ") {
            w--;
          } else if (words[newW] === " ") {
            newW++;
          }

          var text = slice$1(words).call(words, 0, w).join("");

          if (w == words.length && appendLast) {
            this.lines.append(text, mod);
          } else {
            this.lines.newLine(text, mod);
          } // Adjust the word, so that the rest will be done next iteration


          words = slice$1(words).call(words, newW);
        }
      }
    }
  }]);

  return LabelSplitter;
}();

/**
 * List of special styles for multi-fonts
 *
 * @private
 */

var multiFontStyle = ["bold", "ital", "boldital", "mono"];
/**
 * A Label to be used for Nodes or Edges.
 */

var Label = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {object} options
   * @param {boolean} [edgelabel=false]
   */
  function Label(body, options) {
    var edgelabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    _classCallCheck(this, Label);

    this.body = body;
    this.pointToSelf = false;
    this.baseSize = undefined;
    this.fontOptions = {}; // instance variable containing the *instance-local* font options

    this.setOptions(options);
    this.size = {
      top: 0,
      left: 0,
      width: 0,
      height: 0,
      yLine: 0
    };
    this.isEdgeLabel = edgelabel;
  }
  /**
   * @param {object} options the options of the parent Node-instance
   */


  _createClass(Label, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.elementOptions = options; // Reference to the options of the parent Node-instance

      this.initFontOptions(options.font);

      if (isValidLabel(options.label)) {
        this.labelDirty = true;
      } else {
        // Bad label! Change the option value to prevent bad stuff happening
        options.label = undefined;
      }

      if (options.font !== undefined && options.font !== null) {
        // font options can be deleted at various levels
        if (typeof options.font === "string") {
          this.baseSize = this.fontOptions.size;
        } else if (_typeof(options.font) === "object") {
          var size = options.font.size;

          if (size !== undefined) {
            this.baseSize = size;
          }
        }
      }
    }
    /**
     * Init the font Options structure.
     *
     * Member fontOptions serves as an accumulator for the current font options.
     * As such, it needs to be completely separated from the node options.
     *
     * @param {object} newFontOptions the new font options to process
     * @private
     */

  }, {
    key: "initFontOptions",
    value: function initFontOptions(newFontOptions) {
      var _this = this;

      // Prepare the multi-font option objects.
      // These will be filled in propagateFonts(), if required
      forEach$1(multiFontStyle, function (style) {
        _this.fontOptions[style] = {};
      }); // Handle shorthand option, if present

      if (Label.parseFontString(this.fontOptions, newFontOptions)) {
        this.fontOptions.vadjust = 0;
        return;
      } // Copy over the non-multifont options, if specified


      forEach$1(newFontOptions, function (prop, n) {
        if (prop !== undefined && prop !== null && _typeof(prop) !== "object") {
          _this.fontOptions[n] = prop;
        }
      });
    }
    /**
     * If in-variable is a string, parse it as a font specifier.
     *
     * Note that following is not done here and have to be done after the call:
     * - Not all font options are set (vadjust, mod)
     *
     * @param {object} outOptions  out-parameter, object in which to store the parse results (if any)
     * @param {object} inOptions  font options to parse
     * @returns {boolean} true if font parsed as string, false otherwise
     * @static
     */

  }, {
    key: "constrain",
    value:
    /**
     * Set the width and height constraints based on 'nearest' value
     *
     * @param {Array} pile array of option objects to consider
     * @returns {object} the actual constraint values to use
     * @private
     */
    function constrain(pile) {
      // NOTE: constrainWidth and  constrainHeight never set!
      // NOTE: for edge labels, only 'maxWdt' set
      // Node labels can set all the fields
      var fontOptions = {
        constrainWidth: false,
        maxWdt: -1,
        minWdt: -1,
        constrainHeight: false,
        minHgt: -1,
        valign: "middle"
      };
      var widthConstraint = topMost(pile, "widthConstraint");

      if (typeof widthConstraint === "number") {
        fontOptions.maxWdt = Number(widthConstraint);
        fontOptions.minWdt = Number(widthConstraint);
      } else if (_typeof(widthConstraint) === "object") {
        var widthConstraintMaximum = topMost(pile, ["widthConstraint", "maximum"]);

        if (typeof widthConstraintMaximum === "number") {
          fontOptions.maxWdt = Number(widthConstraintMaximum);
        }

        var widthConstraintMinimum = topMost(pile, ["widthConstraint", "minimum"]);

        if (typeof widthConstraintMinimum === "number") {
          fontOptions.minWdt = Number(widthConstraintMinimum);
        }
      }

      var heightConstraint = topMost(pile, "heightConstraint");

      if (typeof heightConstraint === "number") {
        fontOptions.minHgt = Number(heightConstraint);
      } else if (_typeof(heightConstraint) === "object") {
        var heightConstraintMinimum = topMost(pile, ["heightConstraint", "minimum"]);

        if (typeof heightConstraintMinimum === "number") {
          fontOptions.minHgt = Number(heightConstraintMinimum);
        }

        var heightConstraintValign = topMost(pile, ["heightConstraint", "valign"]);

        if (typeof heightConstraintValign === "string") {
          if (heightConstraintValign === "top" || heightConstraintValign === "bottom") {
            fontOptions.valign = heightConstraintValign;
          }
        }
      }

      return fontOptions;
    }
    /**
     * Set options and update internal state
     *
     * @param {object} options  options to set
     * @param {Array}  pile     array of option objects to consider for option 'chosen'
     */

  }, {
    key: "update",
    value: function update(options, pile) {
      this.setOptions(options, true);
      this.propagateFonts(pile);
      deepExtend(this.fontOptions, this.constrain(pile));
      this.fontOptions.chooser = choosify("label", pile);
    }
    /**
     * When margins are set in an element, adjust sizes is called to remove them
     * from the width/height constraints. This must be done prior to label sizing.
     *
     * @param {{top: number, right: number, bottom: number, left: number}} margins
     */

  }, {
    key: "adjustSizes",
    value: function adjustSizes(margins) {
      var widthBias = margins ? margins.right + margins.left : 0;

      if (this.fontOptions.constrainWidth) {
        this.fontOptions.maxWdt -= widthBias;
        this.fontOptions.minWdt -= widthBias;
      }

      var heightBias = margins ? margins.top + margins.bottom : 0;

      if (this.fontOptions.constrainHeight) {
        this.fontOptions.minHgt -= heightBias;
      }
    } /////////////////////////////////////////////////////////
    // Methods for handling options piles
    // Eventually, these will be moved to a separate class
    /////////////////////////////////////////////////////////

    /**
     * Add the font members of the passed list of option objects to the pile.
     *
     * @param {Pile} dstPile  pile of option objects add to
     * @param {Pile} srcPile  pile of option objects to take font options from
     * @private
     */

  }, {
    key: "addFontOptionsToPile",
    value: function addFontOptionsToPile(dstPile, srcPile) {
      for (var i = 0; i < srcPile.length; ++i) {
        this.addFontToPile(dstPile, srcPile[i]);
      }
    }
    /**
     * Add given font option object to the list of objects (the 'pile') to consider for determining
     * multi-font option values.
     *
     * @param {Pile} pile  pile of option objects to use
     * @param {object} options  instance to add to pile
     * @private
     */

  }, {
    key: "addFontToPile",
    value: function addFontToPile(pile, options) {
      if (options === undefined) return;
      if (options.font === undefined || options.font === null) return;
      var item = options.font;
      pile.push(item);
    }
    /**
     * Collect all own-property values from the font pile that aren't multi-font option objectss.
     *
     * @param {Pile} pile  pile of option objects to use
     * @returns {object} object with all current own basic font properties
     * @private
     */

  }, {
    key: "getBasicOptions",
    value: function getBasicOptions(pile) {
      var ret = {}; // Scans the whole pile to get all options present

      for (var n = 0; n < pile.length; ++n) {
        var fontOptions = pile[n]; // Convert shorthand if necessary

        var tmpShorthand = {};

        if (Label.parseFontString(tmpShorthand, fontOptions)) {
          fontOptions = tmpShorthand;
        }

        forEach$1(fontOptions, function (opt, name) {
          if (opt === undefined) return; // multi-font option need not be present

          if (Object.prototype.hasOwnProperty.call(ret, name)) return; // Keep first value we encounter

          if (indexOf(multiFontStyle).call(multiFontStyle, name) !== -1) {
            // Skip multi-font properties but we do need the structure
            ret[name] = {};
          } else {
            ret[name] = opt;
          }
        });
      }

      return ret;
    }
    /**
     * Return the value for given option for the given multi-font.
     *
     * All available option objects are trawled in the set order to construct the option values.
     *
     * ---------------------------------------------------------------------
     * ## Traversal of pile for multi-fonts
     *
     * The determination of multi-font option values is a special case, because any values not
     * present in the multi-font options should by definition be taken from the main font options,
     * i.e. from the current 'parent' object of the multi-font option.
     *
     * ### Search order for multi-fonts
     *
     * 'bold' used as example:
     *
     *   - search in option group 'bold' in local properties
     *   - search in main font option group in local properties
     *
     * ---------------------------------------------------------------------
     *
     * @param {Pile} pile  pile of option objects to use
     * @param {MultiFontStyle} multiName sub path for the multi-font
     * @param {string} option  the option to search for, for the given multi-font
     * @returns {string|number} the value for the given option
     * @private
     */

  }, {
    key: "getFontOption",
    value: function getFontOption(pile, multiName, option) {
      var multiFont; // Search multi font in local properties

      for (var n = 0; n < pile.length; ++n) {
        var fontOptions = pile[n];

        if (Object.prototype.hasOwnProperty.call(fontOptions, multiName)) {
          multiFont = fontOptions[multiName];
          if (multiFont === undefined || multiFont === null) continue; // Convert shorthand if necessary
          // TODO: inefficient to do this conversion every time; find a better way.

          var tmpShorthand = {};

          if (Label.parseFontString(tmpShorthand, multiFont)) {
            multiFont = tmpShorthand;
          }

          if (Object.prototype.hasOwnProperty.call(multiFont, option)) {
            return multiFont[option];
          }
        }
      } // Option is not mentioned in the multi font options; take it from the parent font options.
      // These have already been converted with getBasicOptions(), so use the converted values.


      if (Object.prototype.hasOwnProperty.call(this.fontOptions, option)) {
        return this.fontOptions[option];
      } // A value **must** be found; you should never get here.


      throw new Error("Did not find value for multi-font for property: '" + option + "'");
    }
    /**
     * Return all options values for the given multi-font.
     *
     * All available option objects are trawled in the set order to construct the option values.
     *
     * @param {Pile} pile  pile of option objects to use
     * @param {MultiFontStyle} multiName sub path for the mod-font
     * @returns {MultiFontOptions}
     * @private
     */

  }, {
    key: "getFontOptions",
    value: function getFontOptions(pile, multiName) {
      var result = {};
      var optionNames = ["color", "size", "face", "mod", "vadjust"]; // List of allowed options per multi-font

      for (var i = 0; i < optionNames.length; ++i) {
        var mod = optionNames[i];
        result[mod] = this.getFontOption(pile, multiName, mod);
      }

      return result;
    } /////////////////////////////////////////////////////////
    // End methods for handling options piles
    /////////////////////////////////////////////////////////

    /**
     * Collapse the font options for the multi-font to single objects, from
     * the chain of option objects passed (the 'pile').
     *
     * @param {Pile} pile  sequence of option objects to consider.
     *                     First item in list assumed to be the newly set options.
     */

  }, {
    key: "propagateFonts",
    value: function propagateFonts(pile) {
      var _this2 = this;

      var fontPile = []; // sequence of font objects to consider, order important
      // Note that this.elementOptions is not used here.

      this.addFontOptionsToPile(fontPile, pile);
      this.fontOptions = this.getBasicOptions(fontPile); // We set multifont values even if multi === false, for consistency (things break otherwise)

      var _loop = function _loop(i) {
        var mod = multiFontStyle[i];
        var modOptions = _this2.fontOptions[mod];

        var tmpMultiFontOptions = _this2.getFontOptions(fontPile, mod); // Copy over found values


        forEach$1(tmpMultiFontOptions, function (option, n) {
          modOptions[n] = option;
        });
        modOptions.size = Number(modOptions.size);
        modOptions.vadjust = Number(modOptions.vadjust);
      };

      for (var i = 0; i < multiFontStyle.length; ++i) {
        _loop(i);
      }
    }
    /**
     * Main function. This is called from anything that wants to draw a label.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x
     * @param {number} y
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {string} [baseline='middle']
     */

  }, {
    key: "draw",
    value: function draw(ctx, x, y, selected, hover) {
      var baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : "middle";
      // if no label, return
      if (this.elementOptions.label === undefined) return; // check if we have to render the label

      var viewFontSize = this.fontOptions.size * this.body.view.scale;
      if (this.elementOptions.label && viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) return; // This ensures that there will not be HUGE letters on screen
      // by setting an upper limit on the visible text size (regardless of zoomLevel)

      if (viewFontSize >= this.elementOptions.scaling.label.maxVisible) {
        viewFontSize = Number(this.elementOptions.scaling.label.maxVisible) / this.body.view.scale;
      } // update the size cache if required


      this.calculateLabelSize(ctx, selected, hover, x, y, baseline);

      this._drawBackground(ctx);

      this._drawText(ctx, x, this.size.yLine, baseline, viewFontSize);
    }
    /**
     * Draws the label background
     *
     * @param {CanvasRenderingContext2D} ctx
     * @private
     */

  }, {
    key: "_drawBackground",
    value: function _drawBackground(ctx) {
      if (this.fontOptions.background !== undefined && this.fontOptions.background !== "none") {
        ctx.fillStyle = this.fontOptions.background;
        var size = this.getSize();
        ctx.fillRect(size.left, size.top, size.width, size.height);
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x
     * @param {number} y
     * @param {string} [baseline='middle']
     * @param {number} viewFontSize
     * @private
     */

  }, {
    key: "_drawText",
    value: function _drawText(ctx, x, y) {
      var baseline = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "middle";
      var viewFontSize = arguments.length > 4 ? arguments[4] : undefined;

      var _this$_setAlignment = this._setAlignment(ctx, x, y, baseline);

      var _this$_setAlignment2 = _slicedToArray(_this$_setAlignment, 2);

      x = _this$_setAlignment2[0];
      y = _this$_setAlignment2[1];
      ctx.textAlign = "left";
      x = x - this.size.width / 2; // Shift label 1/2-distance to the left

      if (this.fontOptions.valign && this.size.height > this.size.labelHeight) {
        if (this.fontOptions.valign === "top") {
          y -= (this.size.height - this.size.labelHeight) / 2;
        }

        if (this.fontOptions.valign === "bottom") {
          y += (this.size.height - this.size.labelHeight) / 2;
        }
      } // draw the text


      for (var i = 0; i < this.lineCount; i++) {
        var line = this.lines[i];

        if (line && line.blocks) {
          var width = 0;

          if (this.isEdgeLabel || this.fontOptions.align === "center") {
            width += (this.size.width - line.width) / 2;
          } else if (this.fontOptions.align === "right") {
            width += this.size.width - line.width;
          }

          for (var j = 0; j < line.blocks.length; j++) {
            var block = line.blocks[j];
            ctx.font = block.font;

            var _this$_getColor = this._getColor(block.color, viewFontSize, block.strokeColor),
                _this$_getColor2 = _slicedToArray(_this$_getColor, 2),
                fontColor = _this$_getColor2[0],
                strokeColor = _this$_getColor2[1];

            if (block.strokeWidth > 0) {
              ctx.lineWidth = block.strokeWidth;
              ctx.strokeStyle = strokeColor;
              ctx.lineJoin = "round";
            }

            ctx.fillStyle = fontColor;

            if (block.strokeWidth > 0) {
              ctx.strokeText(block.text, x + width, y + block.vadjust);
            }

            ctx.fillText(block.text, x + width, y + block.vadjust);
            width += block.width;
          }

          y += line.height;
        }
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x
     * @param {number} y
     * @param {string} baseline
     * @returns {Array.<number>}
     * @private
     */

  }, {
    key: "_setAlignment",
    value: function _setAlignment(ctx, x, y, baseline) {
      // check for label alignment (for edges)
      // TODO: make alignment for nodes
      if (this.isEdgeLabel && this.fontOptions.align !== "horizontal" && this.pointToSelf === false) {
        x = 0;
        y = 0;
        var lineMargin = 2;

        if (this.fontOptions.align === "top") {
          ctx.textBaseline = "alphabetic";
          y -= 2 * lineMargin; // distance from edge, required because we use alphabetic. Alphabetic has less difference between browsers
        } else if (this.fontOptions.align === "bottom") {
          ctx.textBaseline = "hanging";
          y += 2 * lineMargin; // distance from edge, required because we use hanging. Hanging has less difference between browsers
        } else {
          ctx.textBaseline = "middle";
        }
      } else {
        ctx.textBaseline = baseline;
      }

      return [x, y];
    }
    /**
     * fade in when relative scale is between threshold and threshold - 1.
     * If the relative scale would be smaller than threshold -1 the draw function would have returned before coming here.
     *
     * @param {string} color  The font color to use
     * @param {number} viewFontSize
     * @param {string} initialStrokeColor
     * @returns {Array.<string>} An array containing the font color and stroke color
     * @private
     */

  }, {
    key: "_getColor",
    value: function _getColor(color, viewFontSize, initialStrokeColor) {
      var fontColor = color || "#000000";
      var strokeColor = initialStrokeColor || "#ffffff";

      if (viewFontSize <= this.elementOptions.scaling.label.drawThreshold) {
        var opacity = Math.max(0, Math.min(1, 1 - (this.elementOptions.scaling.label.drawThreshold - viewFontSize)));
        fontColor = overrideOpacity(fontColor, opacity);
        strokeColor = overrideOpacity(strokeColor, opacity);
      }

      return [fontColor, strokeColor];
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @returns {{width: number, height: number}}
     */

  }, {
    key: "getTextSize",
    value: function getTextSize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

      this._processLabel(ctx, selected, hover);

      return {
        width: this.size.width,
        height: this.size.height,
        lineCount: this.lineCount
      };
    }
    /**
     * Get the current dimensions of the label
     *
     * @returns {rect}
     */

  }, {
    key: "getSize",
    value: function getSize() {
      var lineMargin = 2;
      var x = this.size.left; // default values which might be overridden below

      var y = this.size.top - 0.5 * lineMargin; // idem

      if (this.isEdgeLabel) {
        var x2 = -this.size.width * 0.5;

        switch (this.fontOptions.align) {
          case "middle":
            x = x2;
            y = -this.size.height * 0.5;
            break;

          case "top":
            x = x2;
            y = -(this.size.height + lineMargin);
            break;

          case "bottom":
            x = x2;
            y = lineMargin;
            break;
        }
      }

      var ret = {
        left: x,
        top: y,
        width: this.size.width,
        height: this.size.height
      };
      return ret;
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {number} [x=0]
     * @param {number} [y=0]
     * @param {'middle'|'hanging'} [baseline='middle']
     */

  }, {
    key: "calculateLabelSize",
    value: function calculateLabelSize(ctx, selected, hover) {
      var x = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
      var y = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
      var baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : "middle";

      this._processLabel(ctx, selected, hover);

      this.size.left = x - this.size.width * 0.5;
      this.size.top = y - this.size.height * 0.5;
      this.size.yLine = y + (1 - this.lineCount) * 0.5 * this.fontOptions.size;

      if (baseline === "hanging") {
        this.size.top += 0.5 * this.fontOptions.size;
        this.size.top += 4; // distance from node, required because we use hanging. Hanging has less difference between browsers

        this.size.yLine += 4; // distance from node
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {string} mod
     * @returns {{color, size, face, mod, vadjust, strokeWidth: *, strokeColor: (*|string|allOptions.edges.font.strokeColor|{string}|allOptions.nodes.font.strokeColor|Array)}}
     */

  }, {
    key: "getFormattingValues",
    value: function getFormattingValues(ctx, selected, hover, mod) {
      var getValue = function getValue(fontOptions, mod, option) {
        if (mod === "normal") {
          if (option === "mod") return "";
          return fontOptions[option];
        }

        if (fontOptions[mod][option] !== undefined) {
          // Grumbl leaving out test on undefined equals false for ""
          return fontOptions[mod][option];
        } else {
          // Take from parent font option
          return fontOptions[option];
        }
      };

      var values = {
        color: getValue(this.fontOptions, mod, "color"),
        size: getValue(this.fontOptions, mod, "size"),
        face: getValue(this.fontOptions, mod, "face"),
        mod: getValue(this.fontOptions, mod, "mod"),
        vadjust: getValue(this.fontOptions, mod, "vadjust"),
        strokeWidth: this.fontOptions.strokeWidth,
        strokeColor: this.fontOptions.strokeColor
      };

      if (selected || hover) {
        if (mod === "normal" && this.fontOptions.chooser === true && this.elementOptions.labelHighlightBold) {
          values.mod = "bold";
        } else {
          if (typeof this.fontOptions.chooser === "function") {
            this.fontOptions.chooser(values, this.elementOptions.id, selected, hover);
          }
        }
      }

      var fontString = "";

      if (values.mod !== undefined && values.mod !== "") {
        // safeguard for undefined - this happened
        fontString += values.mod + " ";
      }

      fontString += values.size + "px " + values.face;
      ctx.font = fontString.replace(/"/g, "");
      values.font = ctx.font;
      values.height = values.size;
      return values;
    }
    /**
     *
     * @param {boolean} selected
     * @param {boolean} hover
     * @returns {boolean}
     */

  }, {
    key: "differentState",
    value: function differentState(selected, hover) {
      return selected !== this.selectedState || hover !== this.hoverState;
    }
    /**
     * This explodes the passed text into lines and determines the width, height and number of lines.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {string} inText  the text to explode
     * @returns {{width, height, lines}|*}
     * @private
     */

  }, {
    key: "_processLabelText",
    value: function _processLabelText(ctx, selected, hover, inText) {
      var splitter = new LabelSplitter(ctx, this, selected, hover);
      return splitter.process(inText);
    }
    /**
     * This explodes the label string into lines and sets the width, height and number of lines.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @private
     */

  }, {
    key: "_processLabel",
    value: function _processLabel(ctx, selected, hover) {
      if (this.labelDirty === false && !this.differentState(selected, hover)) return;

      var state = this._processLabelText(ctx, selected, hover, this.elementOptions.label);

      if (this.fontOptions.minWdt > 0 && state.width < this.fontOptions.minWdt) {
        state.width = this.fontOptions.minWdt;
      }

      this.size.labelHeight = state.height;

      if (this.fontOptions.minHgt > 0 && state.height < this.fontOptions.minHgt) {
        state.height = this.fontOptions.minHgt;
      }

      this.lines = state.lines;
      this.lineCount = state.lines.length;
      this.size.width = state.width;
      this.size.height = state.height;
      this.selectedState = selected;
      this.hoverState = hover;
      this.labelDirty = false;
    }
    /**
     * Check if this label is visible
     *
     * @returns {boolean} true if this label will be show, false otherwise
     */

  }, {
    key: "visible",
    value: function visible() {
      if (this.size.width === 0 || this.size.height === 0 || this.elementOptions.label === undefined) {
        return false; // nothing to display
      }

      var viewFontSize = this.fontOptions.size * this.body.view.scale;

      if (viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) {
        return false; // Too small or too far away to show
      }

      return true;
    }
  }], [{
    key: "parseFontString",
    value: function parseFontString(outOptions, inOptions) {
      if (!inOptions || typeof inOptions !== "string") return false;
      var newOptionsArray = inOptions.split(" ");
      outOptions.size = +newOptionsArray[0].replace("px", "");
      outOptions.face = newOptionsArray[1];
      outOptions.color = newOptionsArray[2];
      return true;
    }
  }]);

  return Label;
}();

/**
 * The Base class for all Nodes.
 */
var NodeBase = /*#__PURE__*/function () {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function NodeBase(options, body, labelModule) {
    _classCallCheck(this, NodeBase);

    this.body = body;
    this.labelModule = labelModule;
    this.setOptions(options);
    this.top = undefined;
    this.left = undefined;
    this.height = undefined;
    this.width = undefined;
    this.radius = undefined;
    this.margin = undefined;
    this.refreshNeeded = true;
    this.boundingBox = {
      top: 0,
      left: 0,
      right: 0,
      bottom: 0
    };
  }
  /**
   *
   * @param {object} options
   */


  _createClass(NodeBase, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }
    /**
     *
     * @param {Label} labelModule
     * @private
     */

  }, {
    key: "_setMargins",
    value: function _setMargins(labelModule) {
      this.margin = {};

      if (this.options.margin) {
        if (_typeof(this.options.margin) == "object") {
          this.margin.top = this.options.margin.top;
          this.margin.right = this.options.margin.right;
          this.margin.bottom = this.options.margin.bottom;
          this.margin.left = this.options.margin.left;
        } else {
          this.margin.top = this.options.margin;
          this.margin.right = this.options.margin;
          this.margin.bottom = this.options.margin;
          this.margin.left = this.options.margin;
        }
      }

      labelModule.adjustSizes(this.margin);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     * @private
     */

  }, {
    key: "_distanceToBorder",
    value: function _distanceToBorder(ctx, angle) {
      var borderWidth = this.options.borderWidth;

      if (ctx) {
        this.resize(ctx);
      }

      return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: "enableShadow",
    value: function enableShadow(ctx, values) {
      if (values.shadow) {
        ctx.shadowColor = values.shadowColor;
        ctx.shadowBlur = values.shadowSize;
        ctx.shadowOffsetX = values.shadowX;
        ctx.shadowOffsetY = values.shadowY;
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: "disableShadow",
    value: function disableShadow(ctx, values) {
      if (values.shadow) {
        ctx.shadowColor = "rgba(0,0,0,0)";
        ctx.shadowBlur = 0;
        ctx.shadowOffsetX = 0;
        ctx.shadowOffsetY = 0;
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: "enableBorderDashes",
    value: function enableBorderDashes(ctx, values) {
      if (values.borderDashes !== false) {
        if (ctx.setLineDash !== undefined) {
          var dashes = values.borderDashes;

          if (dashes === true) {
            dashes = [5, 15];
          }

          ctx.setLineDash(dashes);
        } else {
          console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used.");
          this.options.shapeProperties.borderDashes = false;
          values.borderDashes = false;
        }
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: "disableBorderDashes",
    value: function disableBorderDashes(ctx, values) {
      if (values.borderDashes !== false) {
        if (ctx.setLineDash !== undefined) {
          ctx.setLineDash([0]);
        } else {
          console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used.");
          this.options.shapeProperties.borderDashes = false;
          values.borderDashes = false;
        }
      }
    }
    /**
     * Determine if the shape of a node needs to be recalculated.
     *
     * @param {boolean} selected
     * @param {boolean} hover
     * @returns {boolean}
     * @protected
     */

  }, {
    key: "needsRefresh",
    value: function needsRefresh(selected, hover) {
      if (this.refreshNeeded === true) {
        // This is probably not the best location to reset this member.
        // However, in the current logic, it is the most convenient one.
        this.refreshNeeded = false;
        return true;
      }

      return this.width === undefined || this.labelModule.differentState(selected, hover);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: "initContextForDraw",
    value: function initContextForDraw(ctx, values) {
      var borderWidth = values.borderWidth / this.body.view.scale;
      ctx.lineWidth = Math.min(this.width, borderWidth);
      ctx.strokeStyle = values.borderColor;
      ctx.fillStyle = values.color;
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: "performStroke",
    value: function performStroke(ctx, values) {
      var borderWidth = values.borderWidth / this.body.view.scale; //draw dashed border if enabled, save and restore is required for firefox not to crash on unix.

      ctx.save(); // if borders are zero width, they will be drawn with width 1 by default. This prevents that

      if (borderWidth > 0) {
        this.enableBorderDashes(ctx, values); //draw the border

        ctx.stroke(); //disable dashed border for other elements

        this.disableBorderDashes(ctx, values);
      }

      ctx.restore();
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     */

  }, {
    key: "performFill",
    value: function performFill(ctx, values) {
      ctx.save();
      ctx.fillStyle = values.color; // draw shadow if enabled

      this.enableShadow(ctx, values); // draw the background

      fill(ctx).call(ctx); // disable shadows for other elements.


      this.disableShadow(ctx, values);
      ctx.restore();
      this.performStroke(ctx, values);
    }
    /**
     *
     * @param {number} margin
     * @private
     */

  }, {
    key: "_addBoundingBoxMargin",
    value: function _addBoundingBoxMargin(margin) {
      this.boundingBox.left -= margin;
      this.boundingBox.top -= margin;
      this.boundingBox.bottom += margin;
      this.boundingBox.right += margin;
    }
    /**
     * Actual implementation of this method call.
     *
     * Doing it like this makes it easier to override
     * in the child classes.
     *
     * @param {number} x width
     * @param {number} y height
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     * @private
     */

  }, {
    key: "_updateBoundingBox",
    value: function _updateBoundingBox(x, y, ctx, selected, hover) {
      if (ctx !== undefined) {
        this.resize(ctx, selected, hover);
      }

      this.left = x - this.width / 2;
      this.top = y - this.height / 2;
      this.boundingBox.left = this.left;
      this.boundingBox.top = this.top;
      this.boundingBox.bottom = this.top + this.height;
      this.boundingBox.right = this.left + this.width;
    }
    /**
     * Default implementation of this method call.
     * This acts as a stub which can be overridden.
     *
     * @param {number} x width
     * @param {number} y height
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     */

  }, {
    key: "updateBoundingBox",
    value: function updateBoundingBox(x, y, ctx, selected, hover) {
      this._updateBoundingBox(x, y, ctx, selected, hover);
    }
    /**
     * Determine the dimensions to use for nodes with an internal label
     *
     * Currently, these are: Circle, Ellipse, Database, Box
     * The other nodes have external labels, and will not call this method
     *
     * If there is no label, decent default values are supplied.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} [selected]
     * @param {boolean} [hover]
     * @returns {{width:number, height:number}}
     */

  }, {
    key: "getDimensionsFromLabel",
    value: function getDimensionsFromLabel(ctx, selected, hover) {
      // NOTE: previously 'textSize' was not put in 'this' for Ellipse
      // TODO: examine the consequences.
      this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
      var width = this.textSize.width;
      var height = this.textSize.height;
      var DEFAULT_SIZE = 14;

      if (width === 0) {
        // This happens when there is no label text set
        width = DEFAULT_SIZE; // use a decent default

        height = DEFAULT_SIZE; // if width zero, then height also always zero
      }

      return {
        width: width,
        height: height
      };
    }
  }]);

  return NodeBase;
}();

function _createSuper$s(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$s(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$s() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Box Node/Cluster shape.
 *
 * @augments NodeBase
 */

var Box$1 = /*#__PURE__*/function (_NodeBase) {
  _inherits(Box, _NodeBase);

  var _super = _createSuper$s(Box);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Box(options, body, labelModule) {
    var _this;

    _classCallCheck(this, Box);

    _this = _super.call(this, options, body, labelModule);

    _this._setMargins(labelModule);

    return _this;
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  _createClass(Box, [{
    key: "resize",
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

      if (this.needsRefresh(selected, hover)) {
        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
        this.width = dimensions.width + this.margin.right + this.margin.left;
        this.height = dimensions.height + this.margin.top + this.margin.bottom;
        this.radius = this.width / 2;
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;
      this.initContextForDraw(ctx, values);
      drawRoundRect(ctx, this.left, this.top, this.width, this.height, values.borderRadius);
      this.performFill(ctx, values);
      this.updateBoundingBox(x, y, ctx, selected, hover);
      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
    }
    /**
     *
     * @param {number} x width
     * @param {number} y height
     * @param {CanvasRenderingContext2D} ctx
     * @param {boolean} selected
     * @param {boolean} hover
     */

  }, {
    key: "updateBoundingBox",
    value: function updateBoundingBox(x, y, ctx, selected, hover) {
      this._updateBoundingBox(x, y, ctx, selected, hover);

      var borderRadius = this.options.shapeProperties.borderRadius; // only effective for box

      this._addBoundingBoxMargin(borderRadius);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      if (ctx) {
        this.resize(ctx);
      }

      var borderWidth = this.options.borderWidth;
      return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
    }
  }]);

  return Box;
}(NodeBase);

function _createSuper$r(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$r(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$r() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * NOTE: This is a bad base class
 *
 * Child classes are:
 *
 *   Image       - uses *only* image methods
 *   Circle      - uses *only* _drawRawCircle
 *   CircleImage - uses all
 *
 * TODO: Refactor, move _drawRawCircle to different module, derive Circle from NodeBase
 *       Rename this to ImageBase
 *       Consolidate common code in Image and CircleImage to base class
 *
 * @augments NodeBase
 */

var CircleImageBase = /*#__PURE__*/function (_NodeBase) {
  _inherits(CircleImageBase, _NodeBase);

  var _super = _createSuper$r(CircleImageBase);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function CircleImageBase(options, body, labelModule) {
    var _this;

    _classCallCheck(this, CircleImageBase);

    _this = _super.call(this, options, body, labelModule);
    _this.labelOffset = 0;
    _this.selected = false;
    return _this;
  }
  /**
   *
   * @param {object} options
   * @param {object} [imageObj]
   * @param {object} [imageObjAlt]
   */


  _createClass(CircleImageBase, [{
    key: "setOptions",
    value: function setOptions(options, imageObj, imageObjAlt) {
      this.options = options;

      if (!(imageObj === undefined && imageObjAlt === undefined)) {
        this.setImages(imageObj, imageObjAlt);
      }
    }
    /**
     * Set the images for this node.
     *
     * The images can be updated after the initial setting of options;
     * therefore, this method needs to be reentrant.
     *
     * For correct working in error cases, it is necessary to properly set
     * field 'nodes.brokenImage' in the options.
     *
     * @param {Image} imageObj  required; main image to show for this node
     * @param {Image|undefined} imageObjAlt optional; image to show when node is selected
     */

  }, {
    key: "setImages",
    value: function setImages(imageObj, imageObjAlt) {
      if (imageObjAlt && this.selected) {
        this.imageObj = imageObjAlt;
        this.imageObjAlt = imageObj;
      } else {
        this.imageObj = imageObj;
        this.imageObjAlt = imageObjAlt;
      }
    }
    /**
     * Set selection and switch between the base and the selected image.
     *
     * Do the switch only if imageObjAlt exists.
     *
     * @param {boolean} selected value of new selected state for current node
     */

  }, {
    key: "switchImages",
    value: function switchImages(selected) {
      var selection_changed = selected && !this.selected || !selected && this.selected;
      this.selected = selected; // Remember new selection

      if (this.imageObjAlt !== undefined && selection_changed) {
        var imageTmp = this.imageObj;
        this.imageObj = this.imageObjAlt;
        this.imageObjAlt = imageTmp;
      }
    }
    /**
     * Returns Image Padding from node options
     *
     * @returns {{top: number,left: number,bottom: number,right: number}} image padding inside this shape
     * @private
     */

  }, {
    key: "_getImagePadding",
    value: function _getImagePadding() {
      var imgPadding = {
        top: 0,
        right: 0,
        bottom: 0,
        left: 0
      };

      if (this.options.imagePadding) {
        var optImgPadding = this.options.imagePadding;

        if (_typeof(optImgPadding) == "object") {
          imgPadding.top = optImgPadding.top;
          imgPadding.right = optImgPadding.right;
          imgPadding.bottom = optImgPadding.bottom;
          imgPadding.left = optImgPadding.left;
        } else {
          imgPadding.top = optImgPadding;
          imgPadding.right = optImgPadding;
          imgPadding.bottom = optImgPadding;
          imgPadding.left = optImgPadding;
        }
      }

      return imgPadding;
    }
    /**
     * Adjust the node dimensions for a loaded image.
     *
     * Pre: this.imageObj is valid
     */

  }, {
    key: "_resizeImage",
    value: function _resizeImage() {
      var width, height;

      if (this.options.shapeProperties.useImageSize === false) {
        // Use the size property
        var ratio_width = 1;
        var ratio_height = 1; // Only calculate the proper ratio if both width and height not zero

        if (this.imageObj.width && this.imageObj.height) {
          if (this.imageObj.width > this.imageObj.height) {
            ratio_width = this.imageObj.width / this.imageObj.height;
          } else {
            ratio_height = this.imageObj.height / this.imageObj.width;
          }
        }

        width = this.options.size * 2 * ratio_width;
        height = this.options.size * 2 * ratio_height;
      } else {
        // Use the image size with image padding
        var imgPadding = this._getImagePadding();

        width = this.imageObj.width + imgPadding.left + imgPadding.right;
        height = this.imageObj.height + imgPadding.top + imgPadding.bottom;
      }

      this.width = width;
      this.height = height;
      this.radius = 0.5 * this.width;
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {ArrowOptions} values
     * @private
     */

  }, {
    key: "_drawRawCircle",
    value: function _drawRawCircle(ctx, x, y, values) {
      this.initContextForDraw(ctx, values);
      drawCircle(ctx, x, y, values.size);
      this.performFill(ctx, values);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {ArrowOptions} values
     * @private
     */

  }, {
    key: "_drawImageAtPosition",
    value: function _drawImageAtPosition(ctx, values) {
      if (this.imageObj.width != 0) {
        // draw the image
        ctx.globalAlpha = values.opacity !== undefined ? values.opacity : 1; // draw shadow if enabled

        this.enableShadow(ctx, values);
        var factor = 1;

        if (this.options.shapeProperties.interpolation === true) {
          factor = this.imageObj.width / this.width / this.body.view.scale;
        }

        var imgPadding = this._getImagePadding();

        var imgPosLeft = this.left + imgPadding.left;
        var imgPosTop = this.top + imgPadding.top;
        var imgWidth = this.width - imgPadding.left - imgPadding.right;
        var imgHeight = this.height - imgPadding.top - imgPadding.bottom;
        this.imageObj.drawImageAtPosition(ctx, factor, imgPosLeft, imgPosTop, imgWidth, imgHeight); // disable shadows for other elements.

        this.disableShadow(ctx, values);
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @private
     */

  }, {
    key: "_drawImageLabel",
    value: function _drawImageLabel(ctx, x, y, selected, hover) {
      var offset = 0;

      if (this.height !== undefined) {
        offset = this.height * 0.5;
        var labelDimensions = this.labelModule.getTextSize(ctx, selected, hover);

        if (labelDimensions.lineCount >= 1) {
          offset += labelDimensions.height / 2;
        }
      }

      var yLabel = y + offset;

      if (this.options.label) {
        this.labelOffset = offset;
      }

      this.labelModule.draw(ctx, x, yLabel, selected, hover, "hanging");
    }
  }]);

  return CircleImageBase;
}(NodeBase);

function _createSuper$q(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$q(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$q() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Circle Node/Cluster shape.
 *
 * @augments CircleImageBase
 */

var Circle$1 = /*#__PURE__*/function (_CircleImageBase) {
  _inherits(Circle, _CircleImageBase);

  var _super = _createSuper$q(Circle);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Circle(options, body, labelModule) {
    var _this;

    _classCallCheck(this, Circle);

    _this = _super.call(this, options, body, labelModule);

    _this._setMargins(labelModule);

    return _this;
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  _createClass(Circle, [{
    key: "resize",
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

      if (this.needsRefresh(selected, hover)) {
        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
        var diameter = Math.max(dimensions.width + this.margin.right + this.margin.left, dimensions.height + this.margin.top + this.margin.bottom);
        this.options.size = diameter / 2; // NOTE: this size field only set here, not in Ellipse, Database, Box

        this.width = diameter;
        this.height = diameter;
        this.radius = this.width / 2;
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      this._drawRawCircle(ctx, x, y, values);

      this.updateBoundingBox(x, y);
      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, y, selected, hover);
    }
    /**
     *
     * @param {number} x width
     * @param {number} y height
     */

  }, {
    key: "updateBoundingBox",
    value: function updateBoundingBox(x, y) {
      this.boundingBox.top = y - this.options.size;
      this.boundingBox.left = x - this.options.size;
      this.boundingBox.right = x + this.options.size;
      this.boundingBox.bottom = y + this.options.size;
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx) {
      if (ctx) {
        this.resize(ctx);
      }

      return this.width * 0.5;
    }
  }]);

  return Circle;
}(CircleImageBase);

function _createSuper$p(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$p(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$p() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A CircularImage Node/Cluster shape.
 *
 * @augments CircleImageBase
 */

var CircularImage = /*#__PURE__*/function (_CircleImageBase) {
  _inherits(CircularImage, _CircleImageBase);

  var _super = _createSuper$p(CircularImage);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   * @param {Image} imageObj
   * @param {Image} imageObjAlt
   */
  function CircularImage(options, body, labelModule, imageObj, imageObjAlt) {
    var _this;

    _classCallCheck(this, CircularImage);

    _this = _super.call(this, options, body, labelModule);

    _this.setImages(imageObj, imageObjAlt);

    return _this;
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  _createClass(CircularImage, [{
    key: "resize",
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
      var imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;

      if (imageAbsent) {
        var diameter = this.options.size * 2;
        this.width = diameter;
        this.height = diameter;
        this.radius = 0.5 * this.width;
        return;
      } // At this point, an image is present, i.e. this.imageObj is valid.


      if (this.needsRefresh(selected, hover)) {
        this._resizeImage();
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      this.switchImages(selected);
      this.resize();
      var labelX = x,
          labelY = y;

      if (this.options.shapeProperties.coordinateOrigin === "top-left") {
        this.left = x;
        this.top = y;
        labelX += this.width / 2;
        labelY += this.height / 2;
      } else {
        this.left = x - this.width / 2;
        this.top = y - this.height / 2;
      } // draw the background circle. IMPORTANT: the stroke in this method is used by the clip method below.


      this._drawRawCircle(ctx, labelX, labelY, values); // now we draw in the circle, we save so we can revert the clip operation after drawing.


      ctx.save(); // clip is used to use the stroke in drawRawCircle as an area that we can draw in.

      ctx.clip(); // draw the image

      this._drawImageAtPosition(ctx, values); // restore so we can again draw on the full canvas


      ctx.restore();

      this._drawImageLabel(ctx, labelX, labelY, selected, hover);

      this.updateBoundingBox(x, y);
    } // TODO: compare with Circle.updateBoundingBox(), consolidate? More stuff is happening here

    /**
     *
     * @param {number} x width
     * @param {number} y height
     */

  }, {
    key: "updateBoundingBox",
    value: function updateBoundingBox(x, y) {
      if (this.options.shapeProperties.coordinateOrigin === "top-left") {
        this.boundingBox.top = y;
        this.boundingBox.left = x;
        this.boundingBox.right = x + this.options.size * 2;
        this.boundingBox.bottom = y + this.options.size * 2;
      } else {
        this.boundingBox.top = y - this.options.size;
        this.boundingBox.left = x - this.options.size;
        this.boundingBox.right = x + this.options.size;
        this.boundingBox.bottom = y + this.options.size;
      } // TODO: compare with Image.updateBoundingBox(), consolidate?


      this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
      this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
      this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx) {
      if (ctx) {
        this.resize(ctx);
      }

      return this.width * 0.5;
    }
  }]);

  return CircularImage;
}(CircleImageBase);

function _createSuper$o(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$o(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$o() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * Base class for constructing Node/Cluster Shapes.
 *
 * @augments NodeBase
 */

var ShapeBase = /*#__PURE__*/function (_NodeBase) {
  _inherits(ShapeBase, _NodeBase);

  var _super = _createSuper$o(ShapeBase);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function ShapeBase(options, body, labelModule) {
    _classCallCheck(this, ShapeBase);

    return _super.call(this, options, body, labelModule);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   * @param {object} [values={size: this.options.size}]
   */


  _createClass(ShapeBase, [{
    key: "resize",
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
      var values = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {
        size: this.options.size
      };

      if (this.needsRefresh(selected, hover)) {
        var _this$customSizeWidth, _this$customSizeHeigh;

        this.labelModule.getTextSize(ctx, selected, hover);
        var size = 2 * values.size;
        this.width = (_this$customSizeWidth = this.customSizeWidth) !== null && _this$customSizeWidth !== void 0 ? _this$customSizeWidth : size;
        this.height = (_this$customSizeHeigh = this.customSizeHeight) !== null && _this$customSizeHeigh !== void 0 ? _this$customSizeHeigh : size;
        this.radius = 0.5 * this.width;
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {string} shape
     * @param {number} sizeMultiplier - Unused! TODO: Remove next major release
     * @param {number} x
     * @param {number} y
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     * @private
     *
     * @returns {object} Callbacks to draw later on higher layers.
     */

  }, {
    key: "_drawShape",
    value: function _drawShape(ctx, shape, sizeMultiplier, x, y, selected, hover, values) {
      var _this = this;

      this.resize(ctx, selected, hover, values);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;
      this.initContextForDraw(ctx, values);
      getShape(shape)(ctx, x, y, values.size);
      this.performFill(ctx, values);

      if (this.options.icon !== undefined) {
        if (this.options.icon.code !== undefined) {
          ctx.font = (selected ? "bold " : "") + this.height / 2 + "px " + (this.options.icon.face || "FontAwesome");
          ctx.fillStyle = this.options.icon.color || "black";
          ctx.textAlign = "center";
          ctx.textBaseline = "middle";
          ctx.fillText(this.options.icon.code, x, y);
        }
      }

      return {
        drawExternalLabel: function drawExternalLabel() {
          if (_this.options.label !== undefined) {
            // Need to call following here in order to ensure value for
            // `this.labelModule.size.height`.
            _this.labelModule.calculateLabelSize(ctx, selected, hover, x, y, "hanging");

            var yLabel = y + 0.5 * _this.height + 0.5 * _this.labelModule.size.height;

            _this.labelModule.draw(ctx, x, yLabel, selected, hover, "hanging");
          }

          _this.updateBoundingBox(x, y);
        }
      };
    }
    /**
     *
     * @param {number} x
     * @param {number} y
     */

  }, {
    key: "updateBoundingBox",
    value: function updateBoundingBox(x, y) {
      this.boundingBox.top = y - this.options.size;
      this.boundingBox.left = x - this.options.size;
      this.boundingBox.right = x + this.options.size;
      this.boundingBox.bottom = y + this.options.size;

      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height);
      }
    }
  }]);

  return ShapeBase;
}(NodeBase);

function ownKeys$3(object, enumerableOnly) { var keys = keys$4(object); if (getOwnPropertySymbols) { var symbols = getOwnPropertySymbols(object); if (enumerableOnly) { symbols = filter(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$2(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$3(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context; forEach$2(_context = ownKeys$3(Object(source), true)).call(_context, function (key) { _defineProperty(target, key, source[key]); }); } else if (getOwnPropertyDescriptors) { defineProperties(target, getOwnPropertyDescriptors(source)); } else { var _context2; forEach$2(_context2 = ownKeys$3(Object(source))).call(_context2, function (key) { defineProperty$5(target, key, getOwnPropertyDescriptor$2(source, key)); }); } } return target; }

function _createSuper$n(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$n(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$n() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A CustomShape Node/Cluster shape.
 *
 * @augments ShapeBase
 */

var CustomShape = /*#__PURE__*/function (_ShapeBase) {
  _inherits(CustomShape, _ShapeBase);

  var _super = _createSuper$n(CustomShape);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   * @param {Function} ctxRenderer
   
   */
  function CustomShape(options, body, labelModule, ctxRenderer) {
    var _this;

    _classCallCheck(this, CustomShape);

    _this = _super.call(this, options, body, labelModule, ctxRenderer);
    _this.ctxRenderer = ctxRenderer;
    return _this;
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   *
   * @returns {object} Callbacks to draw later on different layers.
   */


  _createClass(CustomShape, [{
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover, values);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2; // Guard right away because someone may just draw in the function itself.

      ctx.save();
      var drawLater = this.ctxRenderer({
        ctx: ctx,
        id: this.options.id,
        x: x,
        y: y,
        state: {
          selected: selected,
          hover: hover
        },
        style: _objectSpread$3({}, values),
        label: this.options.label
      }); // Render the node shape bellow arrows.

      if (drawLater.drawNode != null) {
        drawLater.drawNode();
      }

      ctx.restore();

      if (drawLater.drawExternalLabel) {
        // Guard the external label (above arrows) drawing function.
        var drawExternalLabel = drawLater.drawExternalLabel;

        drawLater.drawExternalLabel = function () {
          ctx.save();
          drawExternalLabel();
          ctx.restore();
        };
      }

      if (drawLater.nodeDimensions) {
        this.customSizeWidth = drawLater.nodeDimensions.width;
        this.customSizeHeight = drawLater.nodeDimensions.height;
      }

      return drawLater;
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return CustomShape;
}(ShapeBase);

function _createSuper$m(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$m(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$m() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Database Node/Cluster shape.
 *
 * @augments NodeBase
 */

var Database = /*#__PURE__*/function (_NodeBase) {
  _inherits(Database, _NodeBase);

  var _super = _createSuper$m(Database);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Database(options, body, labelModule) {
    var _this;

    _classCallCheck(this, Database);

    _this = _super.call(this, options, body, labelModule);

    _this._setMargins(labelModule);

    return _this;
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   */


  _createClass(Database, [{
    key: "resize",
    value: function resize(ctx, selected, hover) {
      if (this.needsRefresh(selected, hover)) {
        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
        var size = dimensions.width + this.margin.right + this.margin.left;
        this.width = size;
        this.height = size;
        this.radius = this.width / 2;
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;
      this.initContextForDraw(ctx, values);
      drawDatabase(ctx, x - this.width / 2, y - this.height / 2, this.width, this.height);
      this.performFill(ctx, values);
      this.updateBoundingBox(x, y, ctx, selected, hover);
      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return Database;
}(NodeBase);

function _createSuper$l(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$l(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$l() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Diamond Node/Cluster shape.
 *
 * @augments ShapeBase
 */

var Diamond$1 = /*#__PURE__*/function (_ShapeBase) {
  _inherits(Diamond, _ShapeBase);

  var _super = _createSuper$l(Diamond);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Diamond(options, body, labelModule) {
    _classCallCheck(this, Diamond);

    return _super.call(this, options, body, labelModule);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   *
   * @returns {object} Callbacks to draw later on higher layers.
   */


  _createClass(Diamond, [{
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      return this._drawShape(ctx, "diamond", 4, x, y, selected, hover, values);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return Diamond;
}(ShapeBase);

function _createSuper$k(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$k(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$k() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Dot Node/Cluster shape.
 *
 * @augments ShapeBase
 */

var Dot = /*#__PURE__*/function (_ShapeBase) {
  _inherits(Dot, _ShapeBase);

  var _super = _createSuper$k(Dot);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Dot(options, body, labelModule) {
    _classCallCheck(this, Dot);

    return _super.call(this, options, body, labelModule);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   *
   * @returns {object} Callbacks to draw later on higher layers.
   */


  _createClass(Dot, [{
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      return this._drawShape(ctx, "circle", 2, x, y, selected, hover, values);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx) {
      if (ctx) {
        this.resize(ctx);
      }

      return this.options.size;
    }
  }]);

  return Dot;
}(ShapeBase);

function _createSuper$j(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$j(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$j() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * Am Ellipse Node/Cluster shape.
 *
 * @augments NodeBase
 */

var Ellipse = /*#__PURE__*/function (_NodeBase) {
  _inherits(Ellipse, _NodeBase);

  var _super = _createSuper$j(Ellipse);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Ellipse(options, body, labelModule) {
    _classCallCheck(this, Ellipse);

    return _super.call(this, options, body, labelModule);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  _createClass(Ellipse, [{
    key: "resize",
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

      if (this.needsRefresh(selected, hover)) {
        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
        this.height = dimensions.height * 2;
        this.width = dimensions.width + dimensions.height;
        this.radius = 0.5 * this.width;
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width * 0.5;
      this.top = y - this.height * 0.5;
      this.initContextForDraw(ctx, values);
      drawEllipse(ctx, this.left, this.top, this.width, this.height);
      this.performFill(ctx, values);
      this.updateBoundingBox(x, y, ctx, selected, hover);
      this.labelModule.draw(ctx, x, y, selected, hover);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      if (ctx) {
        this.resize(ctx);
      }

      var a = this.width * 0.5;
      var b = this.height * 0.5;
      var w = Math.sin(angle) * a;
      var h = Math.cos(angle) * b;
      return a * b / Math.sqrt(w * w + h * h);
    }
  }]);

  return Ellipse;
}(NodeBase);

function _createSuper$i(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$i(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$i() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * An icon replacement for the default Node shape.
 *
 * @augments NodeBase
 */

var Icon = /*#__PURE__*/function (_NodeBase) {
  _inherits(Icon, _NodeBase);

  var _super = _createSuper$i(Icon);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Icon(options, body, labelModule) {
    var _this;

    _classCallCheck(this, Icon);

    _this = _super.call(this, options, body, labelModule);

    _this._setMargins(labelModule);

    return _this;
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx - Unused.
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  _createClass(Icon, [{
    key: "resize",
    value: function resize(ctx, selected, hover) {
      if (this.needsRefresh(selected, hover)) {
        this.iconSize = {
          width: Number(this.options.icon.size),
          height: Number(this.options.icon.size)
        };
        this.width = this.iconSize.width + this.margin.right + this.margin.left;
        this.height = this.iconSize.height + this.margin.top + this.margin.bottom;
        this.radius = 0.5 * this.width;
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     *
     * @returns {object} Callbacks to draw later on higher layers.
     */

  }, {
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      var _this2 = this;

      this.resize(ctx, selected, hover);
      this.options.icon.size = this.options.icon.size || 50;
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;

      this._icon(ctx, x, y, selected, hover, values);

      return {
        drawExternalLabel: function drawExternalLabel() {
          if (_this2.options.label !== undefined) {
            var iconTextSpacing = 5;

            _this2.labelModule.draw(ctx, _this2.left + _this2.iconSize.width / 2 + _this2.margin.left, y + _this2.height / 2 + iconTextSpacing, selected);
          }

          _this2.updateBoundingBox(x, y);
        }
      };
    }
    /**
     *
     * @param {number} x
     * @param {number} y
     */

  }, {
    key: "updateBoundingBox",
    value: function updateBoundingBox(x, y) {
      this.boundingBox.top = y - this.options.icon.size * 0.5;
      this.boundingBox.left = x - this.options.icon.size * 0.5;
      this.boundingBox.right = x + this.options.icon.size * 0.5;
      this.boundingBox.bottom = y + this.options.icon.size * 0.5;

      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
        var iconTextSpacing = 5;
        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height + iconTextSpacing);
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover - Unused
     * @param {ArrowOptions} values
     */

  }, {
    key: "_icon",
    value: function _icon(ctx, x, y, selected, hover, values) {
      var iconSize = Number(this.options.icon.size);

      if (this.options.icon.code !== undefined) {
        ctx.font = [this.options.icon.weight != null ? this.options.icon.weight : selected ? "bold" : "", // If the weight is forced (for example to make Font Awesome 5 work
        // properly) substitute slightly bigger size for bold font face.
        (this.options.icon.weight != null && selected ? 5 : 0) + iconSize + "px", this.options.icon.face].join(" "); // draw icon

        ctx.fillStyle = this.options.icon.color || "black";
        ctx.textAlign = "center";
        ctx.textBaseline = "middle"; // draw shadow if enabled

        this.enableShadow(ctx, values);
        ctx.fillText(this.options.icon.code, x, y); // disable shadows for other elements.

        this.disableShadow(ctx, values);
      } else {
        console.error("When using the icon shape, you need to define the code in the icon options object. This can be done per node or globally.");
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return Icon;
}(NodeBase);

function _createSuper$h(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$h(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$h() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * An image-based replacement for the default Node shape.
 *
 * @augments CircleImageBase
 */

var Image$2 = /*#__PURE__*/function (_CircleImageBase) {
  _inherits(Image, _CircleImageBase);

  var _super = _createSuper$h(Image);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   * @param {Image} imageObj
   * @param {Image} imageObjAlt
   */
  function Image(options, body, labelModule, imageObj, imageObjAlt) {
    var _this;

    _classCallCheck(this, Image);

    _this = _super.call(this, options, body, labelModule);

    _this.setImages(imageObj, imageObjAlt);

    return _this;
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx - Unused.
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */


  _createClass(Image, [{
    key: "resize",
    value: function resize(ctx) {
      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
      var imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;

      if (imageAbsent) {
        var side = this.options.size * 2;
        this.width = side;
        this.height = side;
        return;
      }

      if (this.needsRefresh(selected, hover)) {
        this._resizeImage();
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      ctx.save();
      this.switchImages(selected);
      this.resize();
      var labelX = x,
          labelY = y;

      if (this.options.shapeProperties.coordinateOrigin === "top-left") {
        this.left = x;
        this.top = y;
        labelX += this.width / 2;
        labelY += this.height / 2;
      } else {
        this.left = x - this.width / 2;
        this.top = y - this.height / 2;
      }

      if (this.options.shapeProperties.useBorderWithImage === true) {
        var neutralborderWidth = this.options.borderWidth;
        var selectionLineWidth = this.options.borderWidthSelected || 2 * this.options.borderWidth;
        var borderWidth = (selected ? selectionLineWidth : neutralborderWidth) / this.body.view.scale;
        ctx.lineWidth = Math.min(this.width, borderWidth);
        ctx.beginPath();
        var strokeStyle = selected ? this.options.color.highlight.border : hover ? this.options.color.hover.border : this.options.color.border;
        var fillStyle = selected ? this.options.color.highlight.background : hover ? this.options.color.hover.background : this.options.color.background;

        if (values.opacity !== undefined) {
          strokeStyle = overrideOpacity(strokeStyle, values.opacity);
          fillStyle = overrideOpacity(fillStyle, values.opacity);
        } // setup the line properties.


        ctx.strokeStyle = strokeStyle; // set a fillstyle

        ctx.fillStyle = fillStyle; // draw a rectangle to form the border around. This rectangle is filled so the opacity of a picture (in future vis releases?) can be used to tint the image

        ctx.rect(this.left - 0.5 * ctx.lineWidth, this.top - 0.5 * ctx.lineWidth, this.width + ctx.lineWidth, this.height + ctx.lineWidth);

        fill(ctx).call(ctx);

        this.performStroke(ctx, values);
        ctx.closePath();
      }

      this._drawImageAtPosition(ctx, values);

      this._drawImageLabel(ctx, labelX, labelY, selected, hover);

      this.updateBoundingBox(x, y);
      ctx.restore();
    }
    /**
     *
     * @param {number} x
     * @param {number} y
     */

  }, {
    key: "updateBoundingBox",
    value: function updateBoundingBox(x, y) {
      this.resize();

      if (this.options.shapeProperties.coordinateOrigin === "top-left") {
        this.left = x;
        this.top = y;
      } else {
        this.left = x - this.width / 2;
        this.top = y - this.height / 2;
      }

      this.boundingBox.left = this.left;
      this.boundingBox.top = this.top;
      this.boundingBox.bottom = this.top + this.height;
      this.boundingBox.right = this.left + this.width;

      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return Image;
}(CircleImageBase);

function _createSuper$g(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$g(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$g() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Square Node/Cluster shape.
 *
 * @augments ShapeBase
 */

var Square = /*#__PURE__*/function (_ShapeBase) {
  _inherits(Square, _ShapeBase);

  var _super = _createSuper$g(Square);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Square(options, body, labelModule) {
    _classCallCheck(this, Square);

    return _super.call(this, options, body, labelModule);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   *
   * @returns {object} Callbacks to draw later on higher layers.
   */


  _createClass(Square, [{
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      return this._drawShape(ctx, "square", 2, x, y, selected, hover, values);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return Square;
}(ShapeBase);

function _createSuper$f(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$f(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$f() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Hexagon Node/Cluster shape.
 *
 * @augments ShapeBase
 */

var Hexagon = /*#__PURE__*/function (_ShapeBase) {
  _inherits(Hexagon, _ShapeBase);

  var _super = _createSuper$f(Hexagon);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Hexagon(options, body, labelModule) {
    _classCallCheck(this, Hexagon);

    return _super.call(this, options, body, labelModule);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   *
   * @returns {object} Callbacks to draw later on higher layers.
   */


  _createClass(Hexagon, [{
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      return this._drawShape(ctx, "hexagon", 4, x, y, selected, hover, values);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return Hexagon;
}(ShapeBase);

function _createSuper$e(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$e(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$e() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Star Node/Cluster shape.
 *
 * @augments ShapeBase
 */

var Star = /*#__PURE__*/function (_ShapeBase) {
  _inherits(Star, _ShapeBase);

  var _super = _createSuper$e(Star);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Star(options, body, labelModule) {
    _classCallCheck(this, Star);

    return _super.call(this, options, body, labelModule);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   *
   * @returns {object} Callbacks to draw later on higher layers.
   */


  _createClass(Star, [{
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      return this._drawShape(ctx, "star", 4, x, y, selected, hover, values);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return Star;
}(ShapeBase);

function _createSuper$d(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$d(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$d() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A text-based replacement for the default Node shape.
 *
 * @augments NodeBase
 */

var Text = /*#__PURE__*/function (_NodeBase) {
  _inherits(Text, _NodeBase);

  var _super = _createSuper$d(Text);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Text(options, body, labelModule) {
    var _this;

    _classCallCheck(this, Text);

    _this = _super.call(this, options, body, labelModule);

    _this._setMargins(labelModule);

    return _this;
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   */


  _createClass(Text, [{
    key: "resize",
    value: function resize(ctx, selected, hover) {
      if (this.needsRefresh(selected, hover)) {
        this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
        this.width = this.textSize.width + this.margin.right + this.margin.left;
        this.height = this.textSize.height + this.margin.top + this.margin.bottom;
        this.radius = 0.5 * this.width;
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} x width
     * @param {number} y height
     * @param {boolean} selected
     * @param {boolean} hover
     * @param {ArrowOptions} values
     */

  }, {
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      this.resize(ctx, selected, hover);
      this.left = x - this.width / 2;
      this.top = y - this.height / 2; // draw shadow if enabled

      this.enableShadow(ctx, values);
      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover); // disable shadows for other elements.

      this.disableShadow(ctx, values);
      this.updateBoundingBox(x, y, ctx, selected, hover);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return Text;
}(NodeBase);

function _createSuper$c(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$c(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$c() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Triangle Node/Cluster shape.
 *
 * @augments ShapeBase
 */

var Triangle$1 = /*#__PURE__*/function (_ShapeBase) {
  _inherits(Triangle, _ShapeBase);

  var _super = _createSuper$c(Triangle);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function Triangle(options, body, labelModule) {
    _classCallCheck(this, Triangle);

    return _super.call(this, options, body, labelModule);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x
   * @param {number} y
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   *
   * @returns {object} Callbacks to draw later on higher layers.
   */


  _createClass(Triangle, [{
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      return this._drawShape(ctx, "triangle", 3, x, y, selected, hover, values);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return Triangle;
}(ShapeBase);

function _createSuper$b(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$b(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$b() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A downward facing Triangle Node/Cluster shape.
 *
 * @augments ShapeBase
 */

var TriangleDown = /*#__PURE__*/function (_ShapeBase) {
  _inherits(TriangleDown, _ShapeBase);

  var _super = _createSuper$b(TriangleDown);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  function TriangleDown(options, body, labelModule) {
    _classCallCheck(this, TriangleDown);

    return _super.call(this, options, body, labelModule);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x
   * @param {number} y
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   *
   * @returns {object} Callbacks to draw later on higher layers.
   */


  _createClass(TriangleDown, [{
    key: "draw",
    value: function draw(ctx, x, y, selected, hover, values) {
      return this._drawShape(ctx, "triangleDown", 3, x, y, selected, hover, values);
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {number} angle
     * @returns {number}
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this._distanceToBorder(ctx, angle);
    }
  }]);

  return TriangleDown;
}(ShapeBase);

function ownKeys$2(object, enumerableOnly) { var keys = keys$4(object); if (getOwnPropertySymbols) { var symbols = getOwnPropertySymbols(object); if (enumerableOnly) { symbols = filter(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$2(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context5; forEach$2(_context5 = ownKeys$2(Object(source), true)).call(_context5, function (key) { _defineProperty(target, key, source[key]); }); } else if (getOwnPropertyDescriptors) { defineProperties(target, getOwnPropertyDescriptors(source)); } else { var _context6; forEach$2(_context6 = ownKeys$2(Object(source))).call(_context6, function (key) { defineProperty$5(target, key, getOwnPropertyDescriptor$2(source, key)); }); } } return target; }
/**
 * A node. A node can be connected to other nodes via one or multiple edges.
 */

var Node = /*#__PURE__*/function () {
  /**
   *
   * @param {object} options An object containing options for the node. All
   *                            options are optional, except for the id.
   *                              {number} id     Id of the node. Required
   *                              {string} label  Text label for the node
   *                              {number} x      Horizontal position of the node
   *                              {number} y      Vertical position of the node
   *                              {string} shape  Node shape
   *                              {string} image  An image url
   *                              {string} title  A title text, can be HTML
   *                              {anytype} group A group name or number
   *
   * @param {object} body               Shared state of current network instance
   * @param {Network.Images} imagelist  A list with images. Only needed when the node has an image
   * @param {Groups} grouplist          A list with groups. Needed for retrieving group options
   * @param {object} globalOptions      Current global node options; these serve as defaults for the node instance
   * @param {object} defaultOptions     Global default options for nodes; note that this is also the prototype
   *                                    for parameter `globalOptions`.
   */
  function Node(options, body, imagelist, grouplist, globalOptions, defaultOptions) {
    _classCallCheck(this, Node);

    this.options = bridgeObject(globalOptions);
    this.globalOptions = globalOptions;
    this.defaultOptions = defaultOptions;
    this.body = body;
    this.edges = []; // all edges connected to this node
    // set defaults for the options

    this.id = undefined;
    this.imagelist = imagelist;
    this.grouplist = grouplist; // state options

    this.x = undefined;
    this.y = undefined;
    this.baseSize = this.options.size;
    this.baseFontSize = this.options.font.size;
    this.predefinedPosition = false; // used to check if initial fit should just take the range or approximate

    this.selected = false;
    this.hover = false;
    this.labelModule = new Label(this.body, this.options, false
    /* Not edge label */
    );
    this.setOptions(options);
  }
  /**
   * Attach a edge to the node
   *
   * @param {Edge} edge
   */


  _createClass(Node, [{
    key: "attachEdge",
    value: function attachEdge(edge) {
      var _context;

      if (indexOf(_context = this.edges).call(_context, edge) === -1) {
        this.edges.push(edge);
      }
    }
    /**
     * Detach a edge from the node
     *
     * @param {Edge} edge
     */

  }, {
    key: "detachEdge",
    value: function detachEdge(edge) {
      var _context2;

      var index = indexOf(_context2 = this.edges).call(_context2, edge);

      if (index != -1) {
        var _context3;

        splice(_context3 = this.edges).call(_context3, index, 1);
      }
    }
    /**
     * Set or overwrite options for the node
     *
     * @param {object} options an object with options
     * @returns {null|boolean}
     */

  }, {
    key: "setOptions",
    value: function setOptions(options) {
      var currentShape = this.options.shape;

      if (!options) {
        return; // Note that the return value will be 'undefined'! This is OK.
      } // Save the color for later.
      // This is necessary in order to prevent local color from being overwritten by group color.
      // TODO: To prevent such workarounds the way options are handled should be rewritten from scratch.
      // This is not the only problem with current options handling.


      if (typeof options.color !== "undefined") {
        this._localColor = options.color;
      } // basic options


      if (options.id !== undefined) {
        this.id = options.id;
      }

      if (this.id === undefined) {
        throw new Error("Node must have an id");
      }

      Node.checkMass(options, this.id); // set these options locally
      // clear x and y positions

      if (options.x !== undefined) {
        if (options.x === null) {
          this.x = undefined;
          this.predefinedPosition = false;
        } else {
          this.x = _parseInt(options.x);
          this.predefinedPosition = true;
        }
      }

      if (options.y !== undefined) {
        if (options.y === null) {
          this.y = undefined;
          this.predefinedPosition = false;
        } else {
          this.y = _parseInt(options.y);
          this.predefinedPosition = true;
        }
      }

      if (options.size !== undefined) {
        this.baseSize = options.size;
      }

      if (options.value !== undefined) {
        options.value = _parseFloat(options.value);
      } // this transforms all shorthands into fully defined options


      Node.parseOptions(this.options, options, true, this.globalOptions, this.grouplist);
      var pile = [options, this.options, this.defaultOptions];
      this.chooser = choosify("node", pile);

      this._load_images();

      this.updateLabelModule(options); // Need to set local opacity after `this.updateLabelModule(options);` because `this.updateLabelModule(options);` overrites local opacity with group opacity

      if (options.opacity !== undefined && Node.checkOpacity(options.opacity)) {
        this.options.opacity = options.opacity;
      }

      this.updateShape(currentShape);
      return options.hidden !== undefined || options.physics !== undefined;
    }
    /**
     * Load the images from the options, for the nodes that need them.
     *
     * Images are always loaded, even if they are not used in the current shape.
     * The user may switch to an image shape later on.
     *
     * @private
     */

  }, {
    key: "_load_images",
    value: function _load_images() {
      if (this.options.shape === "circularImage" || this.options.shape === "image") {
        if (this.options.image === undefined) {
          throw new Error("Option image must be defined for node type '" + this.options.shape + "'");
        }
      }

      if (this.options.image === undefined) {
        return;
      }

      if (this.imagelist === undefined) {
        throw new Error("Internal Error: No images provided");
      }

      if (typeof this.options.image === "string") {
        this.imageObj = this.imagelist.load(this.options.image, this.options.brokenImage, this.id);
      } else {
        if (this.options.image.unselected === undefined) {
          throw new Error("No unselected image provided");
        }

        this.imageObj = this.imagelist.load(this.options.image.unselected, this.options.brokenImage, this.id);

        if (this.options.image.selected !== undefined) {
          this.imageObjAlt = this.imagelist.load(this.options.image.selected, this.options.brokenImage, this.id);
        } else {
          this.imageObjAlt = undefined;
        }
      }
    }
    /**
     * Check that opacity is only between 0 and 1
     *
     * @param {number} opacity
     * @returns {boolean}
     */

  }, {
    key: "getFormattingValues",
    value:
    /**
     *
     * @returns {{color: *, borderWidth: *, borderColor: *, size: *, borderDashes: (boolean|Array|allOptions.nodes.shapeProperties.borderDashes|{boolean, array}), borderRadius: (number|allOptions.nodes.shapeProperties.borderRadius|{number}|Array), shadow: *, shadowColor: *, shadowSize: *, shadowX: *, shadowY: *}}
     */
    function getFormattingValues() {
      var values = {
        color: this.options.color.background,
        opacity: this.options.opacity,
        borderWidth: this.options.borderWidth,
        borderColor: this.options.color.border,
        size: this.options.size,
        borderDashes: this.options.shapeProperties.borderDashes,
        borderRadius: this.options.shapeProperties.borderRadius,
        shadow: this.options.shadow.enabled,
        shadowColor: this.options.shadow.color,
        shadowSize: this.options.shadow.size,
        shadowX: this.options.shadow.x,
        shadowY: this.options.shadow.y
      };

      if (this.selected || this.hover) {
        if (this.chooser === true) {
          if (this.selected) {
            if (this.options.borderWidthSelected != null) {
              values.borderWidth = this.options.borderWidthSelected;
            } else {
              values.borderWidth *= 2;
            }

            values.color = this.options.color.highlight.background;
            values.borderColor = this.options.color.highlight.border;
            values.shadow = this.options.shadow.enabled;
          } else if (this.hover) {
            values.color = this.options.color.hover.background;
            values.borderColor = this.options.color.hover.border;
            values.shadow = this.options.shadow.enabled;
          }
        } else if (typeof this.chooser === "function") {
          this.chooser(values, this.options.id, this.selected, this.hover);

          if (values.shadow === false) {
            if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
              values.shadow = true;
            }
          }
        }
      } else {
        values.shadow = this.options.shadow.enabled;
      }

      if (this.options.opacity !== undefined) {
        var opacity = this.options.opacity;
        values.borderColor = overrideOpacity(values.borderColor, opacity);
        values.color = overrideOpacity(values.color, opacity);
        values.shadowColor = overrideOpacity(values.shadowColor, opacity);
      }

      return values;
    }
    /**
     *
     * @param {object} options
     */

  }, {
    key: "updateLabelModule",
    value: function updateLabelModule(options) {
      if (this.options.label === undefined || this.options.label === null) {
        this.options.label = "";
      }

      Node.updateGroupOptions(this.options, _objectSpread$2(_objectSpread$2({}, options), {}, {
        color: options && options.color || this._localColor || undefined
      }), this.grouplist); //
      // Note:The prototype chain for this.options is:
      //
      // this.options ->    NodesHandler.options    -> NodesHandler.defaultOptions
      //                 (also: this.globalOptions)
      //
      // Note that the prototypes are mentioned explicitly in the pile list below;
      // WE DON'T WANT THE ORDER OF THE PROTOTYPES!!!! At least, not for font handling of labels.
      // This is a good indication that the prototype usage of options is deficient.
      //

      var currentGroup = this.grouplist.get(this.options.group, false);
      var pile = [options, // new options
      this.options, // current node options, see comment above for prototype
      currentGroup, // group options, if any
      this.globalOptions, // Currently set global node options
      this.defaultOptions // Default global node options
      ];
      this.labelModule.update(this.options, pile);

      if (this.labelModule.baseSize !== undefined) {
        this.baseFontSize = this.labelModule.baseSize;
      }
    }
    /**
     *
     * @param {string} currentShape
     */

  }, {
    key: "updateShape",
    value: function updateShape(currentShape) {
      if (currentShape === this.options.shape && this.shape) {
        this.shape.setOptions(this.options, this.imageObj, this.imageObjAlt);
      } else {
        // choose draw method depending on the shape
        switch (this.options.shape) {
          case "box":
            this.shape = new Box$1(this.options, this.body, this.labelModule);
            break;

          case "circle":
            this.shape = new Circle$1(this.options, this.body, this.labelModule);
            break;

          case "circularImage":
            this.shape = new CircularImage(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
            break;

          case "custom":
            this.shape = new CustomShape(this.options, this.body, this.labelModule, this.options.ctxRenderer);
            break;

          case "database":
            this.shape = new Database(this.options, this.body, this.labelModule);
            break;

          case "diamond":
            this.shape = new Diamond$1(this.options, this.body, this.labelModule);
            break;

          case "dot":
            this.shape = new Dot(this.options, this.body, this.labelModule);
            break;

          case "ellipse":
            this.shape = new Ellipse(this.options, this.body, this.labelModule);
            break;

          case "icon":
            this.shape = new Icon(this.options, this.body, this.labelModule);
            break;

          case "image":
            this.shape = new Image$2(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
            break;

          case "square":
            this.shape = new Square(this.options, this.body, this.labelModule);
            break;

          case "hexagon":
            this.shape = new Hexagon(this.options, this.body, this.labelModule);
            break;

          case "star":
            this.shape = new Star(this.options, this.body, this.labelModule);
            break;

          case "text":
            this.shape = new Text(this.options, this.body, this.labelModule);
            break;

          case "triangle":
            this.shape = new Triangle$1(this.options, this.body, this.labelModule);
            break;

          case "triangleDown":
            this.shape = new TriangleDown(this.options, this.body, this.labelModule);
            break;

          default:
            this.shape = new Ellipse(this.options, this.body, this.labelModule);
            break;
        }
      }

      this.needsRefresh();
    }
    /**
     * select this node
     */

  }, {
    key: "select",
    value: function select() {
      this.selected = true;
      this.needsRefresh();
    }
    /**
     * unselect this node
     */

  }, {
    key: "unselect",
    value: function unselect() {
      this.selected = false;
      this.needsRefresh();
    }
    /**
     * Reset the calculated size of the node, forces it to recalculate its size
     */

  }, {
    key: "needsRefresh",
    value: function needsRefresh() {
      this.shape.refreshNeeded = true;
    }
    /**
     * get the title of this node.
     *
     * @returns {string} title    The title of the node, or undefined when no title
     *                           has been set.
     */

  }, {
    key: "getTitle",
    value: function getTitle() {
      return this.options.title;
    }
    /**
     * Calculate the distance to the border of the Node
     *
     * @param {CanvasRenderingContext2D}   ctx
     * @param {number} angle        Angle in radians
     * @returns {number} distance   Distance to the border in pixels
     */

  }, {
    key: "distanceToBorder",
    value: function distanceToBorder(ctx, angle) {
      return this.shape.distanceToBorder(ctx, angle);
    }
    /**
     * Check if this node has a fixed x and y position
     *
     * @returns {boolean}      true if fixed, false if not
     */

  }, {
    key: "isFixed",
    value: function isFixed() {
      return this.options.fixed.x && this.options.fixed.y;
    }
    /**
     * check if this node is selecte
     *
     * @returns {boolean} selected   True if node is selected, else false
     */

  }, {
    key: "isSelected",
    value: function isSelected() {
      return this.selected;
    }
    /**
     * Retrieve the value of the node. Can be undefined
     *
     * @returns {number} value
     */

  }, {
    key: "getValue",
    value: function getValue() {
      return this.options.value;
    }
    /**
     * Get the current dimensions of the label
     *
     * @returns {rect}
     */

  }, {
    key: "getLabelSize",
    value: function getLabelSize() {
      return this.labelModule.size();
    }
    /**
     * Adjust the value range of the node. The node will adjust it's size
     * based on its value.
     *
     * @param {number} min
     * @param {number} max
     * @param {number} total
     */

  }, {
    key: "setValueRange",
    value: function setValueRange(min, max, total) {
      if (this.options.value !== undefined) {
        var scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
        var sizeDiff = this.options.scaling.max - this.options.scaling.min;

        if (this.options.scaling.label.enabled === true) {
          var fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
          this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
        }

        this.options.size = this.options.scaling.min + scale * sizeDiff;
      } else {
        this.options.size = this.baseSize;
        this.options.font.size = this.baseFontSize;
      }

      this.updateLabelModule();
    }
    /**
     * Draw this node in the given canvas
     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
     *
     * @param {CanvasRenderingContext2D}   ctx
     *
     * @returns {object} Callbacks to draw later on higher layers.
     */

  }, {
    key: "draw",
    value: function draw(ctx) {
      var values = this.getFormattingValues();
      return this.shape.draw(ctx, this.x, this.y, this.selected, this.hover, values) || {};
    }
    /**
     * Update the bounding box of the shape
     *
     * @param {CanvasRenderingContext2D}   ctx
     */

  }, {
    key: "updateBoundingBox",
    value: function updateBoundingBox(ctx) {
      this.shape.updateBoundingBox(this.x, this.y, ctx);
    }
    /**
     * Recalculate the size of this node in the given canvas
     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
     *
     * @param {CanvasRenderingContext2D}   ctx
     */

  }, {
    key: "resize",
    value: function resize(ctx) {
      var values = this.getFormattingValues();
      this.shape.resize(ctx, this.selected, this.hover, values);
    }
    /**
     * Determine all visual elements of this node instance, in which the given
     * point falls within the bounding shape.
     *
     * @param {point} point
     * @returns {Array.<nodeClickItem|nodeLabelClickItem>} list with the items which are on the point
     */

  }, {
    key: "getItemsOnPoint",
    value: function getItemsOnPoint(point) {
      var ret = [];

      if (this.labelModule.visible()) {
        if (pointInRect(this.labelModule.getSize(), point)) {
          ret.push({
            nodeId: this.id,
            labelId: 0
          });
        }
      }

      if (pointInRect(this.shape.boundingBox, point)) {
        ret.push({
          nodeId: this.id
        });
      }

      return ret;
    }
    /**
     * Check if this object is overlapping with the provided object
     *
     * @param {object} obj   an object with parameters left, top, right, bottom
     * @returns {boolean}     True if location is located on node
     */

  }, {
    key: "isOverlappingWith",
    value: function isOverlappingWith(obj) {
      return this.shape.left < obj.right && this.shape.left + this.shape.width > obj.left && this.shape.top < obj.bottom && this.shape.top + this.shape.height > obj.top;
    }
    /**
     * Check if this object is overlapping with the provided object
     *
     * @param {object} obj   an object with parameters left, top, right, bottom
     * @returns {boolean}     True if location is located on node
     */

  }, {
    key: "isBoundingBoxOverlappingWith",
    value: function isBoundingBoxOverlappingWith(obj) {
      return this.shape.boundingBox.left < obj.right && this.shape.boundingBox.right > obj.left && this.shape.boundingBox.top < obj.bottom && this.shape.boundingBox.bottom > obj.top;
    }
    /**
     * Check valid values for mass
     *
     * The mass may not be negative or zero. If it is, reset to 1
     *
     * @param {object} options
     * @param {Node.id} id
     * @static
     */

  }], [{
    key: "checkOpacity",
    value: function checkOpacity(opacity) {
      return 0 <= opacity && opacity <= 1;
    }
    /**
     * Check that origin is 'center' or 'top-left'
     *
     * @param {string} origin
     * @returns {boolean}
     */

  }, {
    key: "checkCoordinateOrigin",
    value: function checkCoordinateOrigin(origin) {
      return origin === undefined || origin === "center" || origin === "top-left";
    }
    /**
     * Copy group option values into the node options.
     *
     * The group options override the global node options, so the copy of group options
     *  must happen *after* the global node options have been set.
     *
     * This method must also be called also if the global node options have changed and the group options did not.
     *
     * @param {object} parentOptions
     * @param {object} newOptions  new values for the options, currently only passed in for check
     * @param {object} groupList
     */

  }, {
    key: "updateGroupOptions",
    value: function updateGroupOptions(parentOptions, newOptions, groupList) {
      var _context4;

      if (groupList === undefined) return; // No groups, nothing to do

      var group = parentOptions.group; // paranoia: the selected group is already merged into node options, check.

      if (newOptions !== undefined && newOptions.group !== undefined && group !== newOptions.group) {
        throw new Error("updateGroupOptions: group values in options don't match.");
      }

      var hasGroup = typeof group === "number" || typeof group === "string" && group != "";
      if (!hasGroup) return; // current node has no group, no need to merge

      var groupObj = groupList.get(group);

      if (groupObj.opacity !== undefined && newOptions.opacity === undefined) {
        if (!Node.checkOpacity(groupObj.opacity)) {
          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + groupObj.opacity);
          groupObj.opacity = undefined;
        }
      } // Skip any new option to avoid them being overridden by the group options.


      var skipProperties = filter(_context4 = getOwnPropertyNames(newOptions)).call(_context4, function (p) {
        return newOptions[p] != null;
      }); // Always skip merging group font options into parent; these are required to be distinct for labels


      skipProperties.push("font");
      selectiveNotDeepExtend(skipProperties, parentOptions, groupObj); // the color object needs to be completely defined.
      // Since groups can partially overwrite the colors, we parse it again, just in case.

      parentOptions.color = parseColor(parentOptions.color);
    }
    /**
     * This process all possible shorthands in the new options and makes sure that the parentOptions are fully defined.
     * Static so it can also be used by the handler.
     *
     * @param {object} parentOptions
     * @param {object} newOptions
     * @param {boolean} [allowDeletion=false]
     * @param {object} [globalOptions={}]
     * @param {object} [groupList]
     * @static
     */

  }, {
    key: "parseOptions",
    value: function parseOptions(parentOptions, newOptions) {
      var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var groupList = arguments.length > 4 ? arguments[4] : undefined;
      var fields = ["color", "fixed", "shadow"];
      selectiveNotDeepExtend(fields, parentOptions, newOptions, allowDeletion);
      Node.checkMass(newOptions);

      if (parentOptions.opacity !== undefined) {
        if (!Node.checkOpacity(parentOptions.opacity)) {
          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + parentOptions.opacity);
          parentOptions.opacity = undefined;
        }
      }

      if (newOptions.opacity !== undefined) {
        if (!Node.checkOpacity(newOptions.opacity)) {
          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + newOptions.opacity);
          newOptions.opacity = undefined;
        }
      }

      if (newOptions.shapeProperties && !Node.checkCoordinateOrigin(newOptions.shapeProperties.coordinateOrigin)) {
        console.error("Invalid option for node coordinateOrigin, found: " + newOptions.shapeProperties.coordinateOrigin);
      } // merge the shadow options into the parent.


      mergeOptions(parentOptions, newOptions, "shadow", globalOptions); // individual shape newOptions

      if (newOptions.color !== undefined && newOptions.color !== null) {
        var parsedColor = parseColor(newOptions.color);
        fillIfDefined(parentOptions.color, parsedColor);
      } else if (allowDeletion === true && newOptions.color === null) {
        parentOptions.color = bridgeObject(globalOptions.color); // set the object back to the global options
      } // handle the fixed options


      if (newOptions.fixed !== undefined && newOptions.fixed !== null) {
        if (typeof newOptions.fixed === "boolean") {
          parentOptions.fixed.x = newOptions.fixed;
          parentOptions.fixed.y = newOptions.fixed;
        } else {
          if (newOptions.fixed.x !== undefined && typeof newOptions.fixed.x === "boolean") {
            parentOptions.fixed.x = newOptions.fixed.x;
          }

          if (newOptions.fixed.y !== undefined && typeof newOptions.fixed.y === "boolean") {
            parentOptions.fixed.y = newOptions.fixed.y;
          }
        }
      }

      if (allowDeletion === true && newOptions.font === null) {
        parentOptions.font = bridgeObject(globalOptions.font); // set the object back to the global options
      }

      Node.updateGroupOptions(parentOptions, newOptions, groupList); // handle the scaling options, specifically the label part

      if (newOptions.scaling !== undefined) {
        mergeOptions(parentOptions.scaling, newOptions.scaling, "label", globalOptions.scaling);
      }
    }
  }, {
    key: "checkMass",
    value: function checkMass(options, id) {
      if (options.mass !== undefined && options.mass <= 0) {
        var strId = "";

        if (id !== undefined) {
          strId = " in node id: " + id;
        }

        console.error("%cNegative or zero mass disallowed" + strId + ", setting mass to 1.", VALIDATOR_PRINT_STYLE$1);
        options.mass = 1;
      }
    }
  }]);

  return Node;
}();

function _createForOfIteratorHelper$6(o, allowArrayLike) { var it = typeof symbol !== "undefined" && getIteratorMethod$2(o) || o["@@iterator"]; if (!it) { if (isArray$2(o) || (it = _unsupportedIterableToArray$6(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$6(o, minLen) { var _context4; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$6(o, minLen); var n = slice$1(_context4 = Object.prototype.toString.call(o)).call(_context4, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return from$2(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$6(o, minLen); }

function _arrayLikeToArray$6(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
/**
 * Handler for Nodes
 */

var NodesHandler = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {Images} images
   * @param {Array.<Group>} groups
   * @param {LayoutEngine} layoutEngine
   */
  function NodesHandler(body, images, groups, layoutEngine) {
    var _context,
        _this = this;

    _classCallCheck(this, NodesHandler);

    this.body = body;
    this.images = images;
    this.groups = groups;
    this.layoutEngine = layoutEngine; // create the node API in the body container

    this.body.functions.createNode = bind$6(_context = this.create).call(_context, this);
    this.nodesListeners = {
      add: function add(event, params) {
        _this.add(params.items);
      },
      update: function update(event, params) {
        _this.update(params.items, params.data, params.oldData);
      },
      remove: function remove(event, params) {
        _this.remove(params.items);
      }
    };
    this.defaultOptions = {
      borderWidth: 1,
      borderWidthSelected: undefined,
      brokenImage: undefined,
      color: {
        border: "#2B7CE9",
        background: "#97C2FC",
        highlight: {
          border: "#2B7CE9",
          background: "#D2E5FF"
        },
        hover: {
          border: "#2B7CE9",
          background: "#D2E5FF"
        }
      },
      opacity: undefined,
      // number between 0 and 1
      fixed: {
        x: false,
        y: false
      },
      font: {
        color: "#343434",
        size: 14,
        // px
        face: "arial",
        background: "none",
        strokeWidth: 0,
        // px
        strokeColor: "#ffffff",
        align: "center",
        vadjust: 0,
        multi: false,
        bold: {
          mod: "bold"
        },
        boldital: {
          mod: "bold italic"
        },
        ital: {
          mod: "italic"
        },
        mono: {
          mod: "",
          size: 15,
          // px
          face: "monospace",
          vadjust: 2
        }
      },
      group: undefined,
      hidden: false,
      icon: {
        face: "FontAwesome",
        //'FontAwesome',
        code: undefined,
        //'\uf007',
        size: 50,
        //50,
        color: "#2B7CE9" //'#aa00ff'

      },
      image: undefined,
      // --> URL
      imagePadding: {
        // only for image shape
        top: 0,
        right: 0,
        bottom: 0,
        left: 0
      },
      label: undefined,
      labelHighlightBold: true,
      level: undefined,
      margin: {
        top: 5,
        right: 5,
        bottom: 5,
        left: 5
      },
      mass: 1,
      physics: true,
      scaling: {
        min: 10,
        max: 30,
        label: {
          enabled: false,
          min: 14,
          max: 30,
          maxVisible: 30,
          drawThreshold: 5
        },
        customScalingFunction: function customScalingFunction(min, max, total, value) {
          if (max === min) {
            return 0.5;
          } else {
            var scale = 1 / (max - min);
            return Math.max(0, (value - min) * scale);
          }
        }
      },
      shadow: {
        enabled: false,
        color: "rgba(0,0,0,0.5)",
        size: 10,
        x: 5,
        y: 5
      },
      shape: "ellipse",
      shapeProperties: {
        borderDashes: false,
        // only for borders
        borderRadius: 6,
        // only for box shape
        interpolation: true,
        // only for image and circularImage shapes
        useImageSize: false,
        // only for image and circularImage shapes
        useBorderWithImage: false,
        // only for image shape
        coordinateOrigin: "center" // only for image and circularImage shapes

      },
      size: 25,
      title: undefined,
      value: undefined,
      x: undefined,
      y: undefined
    }; // Protect from idiocy

    if (this.defaultOptions.mass <= 0) {
      throw "Internal error: mass in defaultOptions of NodesHandler may not be zero or negative";
    }

    this.options = bridgeObject(this.defaultOptions);
    this.bindEventListeners();
  }
  /**
   * Binds event listeners
   */


  _createClass(NodesHandler, [{
    key: "bindEventListeners",
    value: function bindEventListeners() {
      var _context2,
          _context3,
          _this2 = this;

      // refresh the nodes. Used when reverting from hierarchical layout
      this.body.emitter.on("refreshNodes", bind$6(_context2 = this.refresh).call(_context2, this));
      this.body.emitter.on("refresh", bind$6(_context3 = this.refresh).call(_context3, this));
      this.body.emitter.on("destroy", function () {
        forEach$1(_this2.nodesListeners, function (callback, event) {
          if (_this2.body.data.nodes) _this2.body.data.nodes.off(event, callback);
        });
        delete _this2.body.functions.createNode;
        delete _this2.nodesListeners.add;
        delete _this2.nodesListeners.update;
        delete _this2.nodesListeners.remove;
        delete _this2.nodesListeners;
      });
    }
    /**
     *
     * @param {object} options
     */

  }, {
    key: "setOptions",
    value: function setOptions(options) {
      if (options !== undefined) {
        Node.parseOptions(this.options, options); // Need to set opacity here because Node.parseOptions is also used for groups,
        // if you set opacity in Node.parseOptions it overwrites group opacity.

        if (options.opacity !== undefined) {
          if (isNan(options.opacity) || !_isFinite(options.opacity) || options.opacity < 0 || options.opacity > 1) {
            console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + options.opacity);
          } else {
            this.options.opacity = options.opacity;
          }
        } // update the shape in all nodes


        if (options.shape !== undefined) {
          for (var nodeId in this.body.nodes) {
            if (Object.prototype.hasOwnProperty.call(this.body.nodes, nodeId)) {
              this.body.nodes[nodeId].updateShape();
            }
          }
        } // Update the labels of nodes if any relevant options changed.


        if (typeof options.font !== "undefined" || typeof options.widthConstraint !== "undefined" || typeof options.heightConstraint !== "undefined") {
          for (var _i = 0, _Object$keys = keys$4(this.body.nodes); _i < _Object$keys.length; _i++) {
            var _nodeId = _Object$keys[_i];

            this.body.nodes[_nodeId].updateLabelModule();

            this.body.nodes[_nodeId].needsRefresh();
          }
        } // update the shape size in all nodes


        if (options.size !== undefined) {
          for (var _nodeId2 in this.body.nodes) {
            if (Object.prototype.hasOwnProperty.call(this.body.nodes, _nodeId2)) {
              this.body.nodes[_nodeId2].needsRefresh();
            }
          }
        } // update the state of the variables if needed


        if (options.hidden !== undefined || options.physics !== undefined) {
          this.body.emitter.emit("_dataChanged");
        }
      }
    }
    /**
     * Set a data set with nodes for the network
     *
     * @param {Array | DataSet | DataView} nodes         The data containing the nodes.
     * @param {boolean} [doNotEmit=false] - Suppress data changed event.
     * @private
     */

  }, {
    key: "setData",
    value: function setData(nodes) {
      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var oldNodesData = this.body.data.nodes;

      if (isDataViewLike("id", nodes)) {
        this.body.data.nodes = nodes;
      } else if (isArray$2(nodes)) {
        this.body.data.nodes = new DataSet();
        this.body.data.nodes.add(nodes);
      } else if (!nodes) {
        this.body.data.nodes = new DataSet();
      } else {
        throw new TypeError("Array or DataSet expected");
      }

      if (oldNodesData) {
        // unsubscribe from old dataset
        forEach$1(this.nodesListeners, function (callback, event) {
          oldNodesData.off(event, callback);
        });
      } // remove drawn nodes


      this.body.nodes = {};

      if (this.body.data.nodes) {
        // subscribe to new dataset
        var me = this;
        forEach$1(this.nodesListeners, function (callback, event) {
          me.body.data.nodes.on(event, callback);
        }); // draw all new nodes

        var ids = this.body.data.nodes.getIds();
        this.add(ids, true);
      }

      if (doNotEmit === false) {
        this.body.emitter.emit("_dataChanged");
      }
    }
    /**
     * Add nodes
     *
     * @param {number[] | string[]} ids
     * @param {boolean} [doNotEmit=false]
     * @private
     */

  }, {
    key: "add",
    value: function add(ids) {
      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var id;
      var newNodes = [];

      for (var i = 0; i < ids.length; i++) {
        id = ids[i];
        var properties = this.body.data.nodes.get(id);
        var node = this.create(properties);
        newNodes.push(node);
        this.body.nodes[id] = node; // note: this may replace an existing node
      }

      this.layoutEngine.positionInitially(newNodes);

      if (doNotEmit === false) {
        this.body.emitter.emit("_dataChanged");
      }
    }
    /**
     * Update existing nodes, or create them when not yet existing
     *
     * @param {number[] | string[]} ids id's of changed nodes
     * @param {Array} changedData array with changed data
     * @param {Array|undefined} oldData optional; array with previous data
     * @private
     */

  }, {
    key: "update",
    value: function update(ids, changedData, oldData) {
      var nodes = this.body.nodes;
      var dataChanged = false;

      for (var i = 0; i < ids.length; i++) {
        var id = ids[i];
        var node = nodes[id];
        var data = changedData[i];

        if (node !== undefined) {
          // update node
          if (node.setOptions(data)) {
            dataChanged = true;
          }
        } else {
          dataChanged = true; // create node

          node = this.create(data);
          nodes[id] = node;
        }
      }

      if (!dataChanged && oldData !== undefined) {
        // Check for any changes which should trigger a layout recalculation
        // For now, this is just 'level' for hierarchical layout
        // Assumption: old and new data arranged in same order; at time of writing, this holds.
        dataChanged = some(changedData).call(changedData, function (newValue, index) {
          var oldValue = oldData[index];
          return oldValue && oldValue.level !== newValue.level;
        });
      }

      if (dataChanged === true) {
        this.body.emitter.emit("_dataChanged");
      } else {
        this.body.emitter.emit("_dataUpdated");
      }
    }
    /**
     * Remove existing nodes. If nodes do not exist, the method will just ignore it.
     *
     * @param {number[] | string[]} ids
     * @private
     */

  }, {
    key: "remove",
    value: function remove(ids) {
      var nodes = this.body.nodes;

      for (var i = 0; i < ids.length; i++) {
        var id = ids[i];
        delete nodes[id];
      }

      this.body.emitter.emit("_dataChanged");
    }
    /**
     * create a node
     *
     * @param {object} properties
     * @param {class} [constructorClass=Node.default]
     * @returns {*}
     */

  }, {
    key: "create",
    value: function create(properties) {
      var constructorClass = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Node;
      return new constructorClass(properties, this.body, this.images, this.groups, this.options, this.defaultOptions);
    }
    /**
     *
     * @param {boolean} [clearPositions=false]
     */

  }, {
    key: "refresh",
    value: function refresh() {
      var _this3 = this;

      var clearPositions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      forEach$1(this.body.nodes, function (node, nodeId) {
        var data = _this3.body.data.nodes.get(nodeId);

        if (data !== undefined) {
          if (clearPositions === true) {
            node.setOptions({
              x: null,
              y: null
            });
          }

          node.setOptions({
            fixed: false
          });
          node.setOptions(data);
        }
      });
    }
    /**
     * Returns the positions of the nodes.
     *
     * @param {Array.<Node.id> | string} [ids]  --> optional, can be array of nodeIds, can be string
     * @returns {{}}
     */

  }, {
    key: "getPositions",
    value: function getPositions(ids) {
      var dataArray = {};

      if (ids !== undefined) {
        if (isArray$2(ids) === true) {
          for (var i = 0; i < ids.length; i++) {
            if (this.body.nodes[ids[i]] !== undefined) {
              var node = this.body.nodes[ids[i]];
              dataArray[ids[i]] = {
                x: Math.round(node.x),
                y: Math.round(node.y)
              };
            }
          }
        } else {
          if (this.body.nodes[ids] !== undefined) {
            var _node = this.body.nodes[ids];
            dataArray[ids] = {
              x: Math.round(_node.x),
              y: Math.round(_node.y)
            };
          }
        }
      } else {
        for (var _i2 = 0; _i2 < this.body.nodeIndices.length; _i2++) {
          var _node2 = this.body.nodes[this.body.nodeIndices[_i2]];
          dataArray[this.body.nodeIndices[_i2]] = {
            x: Math.round(_node2.x),
            y: Math.round(_node2.y)
          };
        }
      }

      return dataArray;
    }
    /**
     * Retrieves the x y position of a specific id.
     *
     * @param {string} id The id to retrieve.
     *
     * @throws {TypeError} If no id is included.
     * @throws {ReferenceError} If an invalid id is provided.
     *
     * @returns {{ x: number, y: number }} Returns X, Y canvas position of the node with given id.
     */

  }, {
    key: "getPosition",
    value: function getPosition(id) {
      if (id == undefined) {
        throw new TypeError("No id was specified for getPosition method.");
      } else if (this.body.nodes[id] == undefined) {
        throw new ReferenceError("NodeId provided for getPosition does not exist. Provided: ".concat(id));
      } else {
        return {
          x: Math.round(this.body.nodes[id].x),
          y: Math.round(this.body.nodes[id].y)
        };
      }
    }
    /**
     * Load the XY positions of the nodes into the dataset.
     */

  }, {
    key: "storePositions",
    value: function storePositions() {
      // todo: add support for clusters and hierarchical.
      var dataArray = [];
      var dataset = this.body.data.nodes.getDataSet();

      var _iterator = _createForOfIteratorHelper$6(dataset.get()),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var dsNode = _step.value;
          var id = dsNode.id;
          var bodyNode = this.body.nodes[id];
          var x = Math.round(bodyNode.x);
          var y = Math.round(bodyNode.y);

          if (dsNode.x !== x || dsNode.y !== y) {
            dataArray.push({
              id: id,
              x: x,
              y: y
            });
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      dataset.update(dataArray);
    }
    /**
     * get the bounding box of a node.
     *
     * @param {Node.id} nodeId
     * @returns {j|*}
     */

  }, {
    key: "getBoundingBox",
    value: function getBoundingBox(nodeId) {
      if (this.body.nodes[nodeId] !== undefined) {
        return this.body.nodes[nodeId].shape.boundingBox;
      }
    }
    /**
     * Get the Ids of nodes connected to this node.
     *
     * @param {Node.id} nodeId
     * @param {'to'|'from'|undefined} direction values 'from' and 'to' select respectively parent and child nodes only.
     *                                          Any other value returns both parent and child nodes.
     * @returns {Array}
     */

  }, {
    key: "getConnectedNodes",
    value: function getConnectedNodes(nodeId, direction) {
      var nodeList = [];

      if (this.body.nodes[nodeId] !== undefined) {
        var node = this.body.nodes[nodeId];
        var nodeObj = {}; // used to quickly check if node already exists

        for (var i = 0; i < node.edges.length; i++) {
          var edge = node.edges[i];

          if (direction !== "to" && edge.toId == node.id) {
            // these are double equals since ids can be numeric or string
            if (nodeObj[edge.fromId] === undefined) {
              nodeList.push(edge.fromId);
              nodeObj[edge.fromId] = true;
            }
          } else if (direction !== "from" && edge.fromId == node.id) {
            // these are double equals since ids can be numeric or string
            if (nodeObj[edge.toId] === undefined) {
              nodeList.push(edge.toId);
              nodeObj[edge.toId] = true;
            }
          }
        }
      }

      return nodeList;
    }
    /**
     * Get the ids of the edges connected to this node.
     *
     * @param {Node.id} nodeId
     * @returns {*}
     */

  }, {
    key: "getConnectedEdges",
    value: function getConnectedEdges(nodeId) {
      var edgeList = [];

      if (this.body.nodes[nodeId] !== undefined) {
        var node = this.body.nodes[nodeId];

        for (var i = 0; i < node.edges.length; i++) {
          edgeList.push(node.edges[i].id);
        }
      } else {
        console.error("NodeId provided for getConnectedEdges does not exist. Provided: ", nodeId);
      }

      return edgeList;
    }
    /**
     * Move a node.
     *
     * @param {Node.id} nodeId
     * @param {number} x
     * @param {number} y
     */

  }, {
    key: "moveNode",
    value: function moveNode(nodeId, x, y) {
      var _this4 = this;

      if (this.body.nodes[nodeId] !== undefined) {
        this.body.nodes[nodeId].x = Number(x);
        this.body.nodes[nodeId].y = Number(y);

        setTimeout$1(function () {
          _this4.body.emitter.emit("startSimulation");
        }, 0);
      } else {
        console.error("Node id supplied to moveNode does not exist. Provided: ", nodeId);
      }
    }
  }]);

  return NodesHandler;
}();

var $$2 = _export;
var isObject$2 = isObject$j;
var anObject$1 = anObject$d;
var has = has$c;
var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
var getPrototypeOf = objectGetPrototypeOf; // `Reflect.get` method
// https://tc39.es/ecma262/#sec-reflect.get

function get$4(target, propertyKey
/* , receiver */
) {
  var receiver = arguments.length < 3 ? target : arguments[2];
  var descriptor, prototype;
  if (anObject$1(target) === receiver) return target[propertyKey];
  if (descriptor = getOwnPropertyDescriptorModule.f(target, propertyKey)) return has(descriptor, 'value') ? descriptor.value : descriptor.get === undefined ? undefined : descriptor.get.call(receiver);
  if (isObject$2(prototype = getPrototypeOf(target))) return get$4(prototype, propertyKey, receiver);
}

$$2({
  target: 'Reflect',
  stat: true
}, {
  get: get$4
});

var path$3 = path$x;
var get$3 = path$3.Reflect.get;

var parent$5 = get$3;
var get$2 = parent$5;

var parent$4 = get$2;
var get$1 = parent$4;

var get = get$1;

var parent$3 = getOwnPropertyDescriptor$3;
var getOwnPropertyDescriptor$1 = parent$3;

var getOwnPropertyDescriptor = getOwnPropertyDescriptor$1;

function _superPropBase(object, property) {
  while (!Object.prototype.hasOwnProperty.call(object, property)) {
    object = _getPrototypeOf(object);
    if (object === null) break;
  }

  return object;
}

function _get(target, property, receiver) {
  if (typeof Reflect !== "undefined" && get) {
    _get = get;
  } else {
    _get = function _get(target, property, receiver) {
      var base = _superPropBase(target, property);
      if (!base) return;

      var desc = getOwnPropertyDescriptor(base, property);

      if (desc.get) {
        return desc.get.call(receiver);
      }

      return desc.value;
    };
  }

  return _get(target, property, receiver || target);
}

var $$1 = _export; // eslint-disable-next-line es/no-math-hypot -- required for testing

var $hypot = Math.hypot;
var abs = Math.abs;
var sqrt = Math.sqrt; // Chrome 77 bug
// https://bugs.chromium.org/p/v8/issues/detail?id=9546

var BUGGY = !!$hypot && $hypot(Infinity, NaN) !== Infinity; // `Math.hypot` method
// https://tc39.es/ecma262/#sec-math.hypot

$$1({
  target: 'Math',
  stat: true,
  forced: BUGGY
}, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  hypot: function hypot(value1, value2) {
    var sum = 0;
    var i = 0;
    var aLen = arguments.length;
    var larg = 0;
    var arg, div;

    while (i < aLen) {
      arg = abs(arguments[i++]);

      if (larg < arg) {
        div = larg / arg;
        sum = sum * div * div + 1;
        larg = arg;
      } else if (arg > 0) {
        div = arg / larg;
        sum += div * div;
      } else sum += arg;
    }

    return larg === Infinity ? Infinity : larg * sqrt(sum);
  }
});

var path$2 = path$x;
var hypot$2 = path$2.Math.hypot;

var parent$2 = hypot$2;
var hypot$1 = parent$2;

var hypot = hypot$1;

function _createSuper$a(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$a(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$a() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * Common methods for endpoints
 *
 * @class
 */

var EndPoint = /*#__PURE__*/function () {
  function EndPoint() {
    _classCallCheck(this, EndPoint);
  }

  _createClass(EndPoint, null, [{
    key: "transform",
    value:
    /**
     * Apply transformation on points for display.
     *
     * The following is done:
     * - rotate by the specified angle
     * - multiply the (normalized) coordinates by the passed length
     * - offset by the target coordinates
     *
     * @param points - The point(s) to be transformed.
     * @param arrowData - The data determining the result of the transformation.
     */
    function transform(points, arrowData) {
      if (!isArray$2(points)) {
        points = [points];
      }

      var x = arrowData.point.x;
      var y = arrowData.point.y;
      var angle = arrowData.angle;
      var length = arrowData.length;

      for (var i = 0; i < points.length; ++i) {
        var p = points[i];
        var xt = p.x * Math.cos(angle) - p.y * Math.sin(angle);
        var yt = p.x * Math.sin(angle) + p.y * Math.cos(angle);
        p.x = x + length * xt;
        p.y = y + length * yt;
      }
    }
    /**
     * Draw a closed path using the given real coordinates.
     *
     * @param ctx - The path will be rendered into this context.
     * @param points - The points of the path.
     */

  }, {
    key: "drawPath",
    value: function drawPath(ctx, points) {
      ctx.beginPath();
      ctx.moveTo(points[0].x, points[0].y);

      for (var i = 1; i < points.length; ++i) {
        ctx.lineTo(points[i].x, points[i].y);
      }

      ctx.closePath();
    }
  }]);

  return EndPoint;
}();
/**
 * Drawing methods for the arrow endpoint.
 */


var Image$1 = /*#__PURE__*/function (_EndPoint) {
  _inherits(Image, _EndPoint);

  var _super = _createSuper$a(Image);

  function Image() {
    _classCallCheck(this, Image);

    return _super.apply(this, arguments);
  }

  _createClass(Image, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns False as there is no way to fill an image.
     */
    function draw(ctx, arrowData) {
      if (arrowData.image) {
        ctx.save();
        ctx.translate(arrowData.point.x, arrowData.point.y);
        ctx.rotate(Math.PI / 2 + arrowData.angle);
        var width = arrowData.imageWidth != null ? arrowData.imageWidth : arrowData.image.width;
        var height = arrowData.imageHeight != null ? arrowData.imageHeight : arrowData.image.height;
        arrowData.image.drawImageAtPosition(ctx, 1, // scale
        -width / 2, // x
        0, // y
        width, height);
        ctx.restore();
      }

      return false;
    }
  }]);

  return Image;
}(EndPoint);
/**
 * Drawing methods for the arrow endpoint.
 */


var Arrow = /*#__PURE__*/function (_EndPoint2) {
  _inherits(Arrow, _EndPoint2);

  var _super2 = _createSuper$a(Arrow);

  function Arrow() {
    _classCallCheck(this, Arrow);

    return _super2.apply(this, arguments);
  }

  _createClass(Arrow, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{
        x: 0,
        y: 0
      }, {
        x: -1,
        y: 0.3
      }, {
        x: -0.9,
        y: 0
      }, {
        x: -1,
        y: -0.3
      }];
      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
      return true;
    }
  }]);

  return Arrow;
}(EndPoint);
/**
 * Drawing methods for the crow endpoint.
 */


var Crow = /*#__PURE__*/function () {
  function Crow() {
    _classCallCheck(this, Crow);
  }

  _createClass(Crow, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{
        x: -1,
        y: 0
      }, {
        x: 0,
        y: 0.3
      }, {
        x: -0.4,
        y: 0
      }, {
        x: 0,
        y: -0.3
      }];
      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
      return true;
    }
  }]);

  return Crow;
}();
/**
 * Drawing methods for the curve endpoint.
 */


var Curve = /*#__PURE__*/function () {
  function Curve() {
    _classCallCheck(this, Curve);
  }

  _createClass(Curve, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var point = {
        x: -0.4,
        y: 0
      };
      EndPoint.transform(point, arrowData); // Update endpoint style for drawing transparent arc.

      ctx.strokeStyle = ctx.fillStyle;
      ctx.fillStyle = "rgba(0, 0, 0, 0)"; // Define curve endpoint as semicircle.

      var pi = Math.PI;
      var startAngle = arrowData.angle - pi / 2;
      var endAngle = arrowData.angle + pi / 2;
      ctx.beginPath();
      ctx.arc(point.x, point.y, arrowData.length * 0.4, startAngle, endAngle, false);
      ctx.stroke();
      return true;
    }
  }]);

  return Curve;
}();
/**
 * Drawing methods for the inverted curve endpoint.
 */


var InvertedCurve = /*#__PURE__*/function () {
  function InvertedCurve() {
    _classCallCheck(this, InvertedCurve);
  }

  _createClass(InvertedCurve, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var point = {
        x: -0.3,
        y: 0
      };
      EndPoint.transform(point, arrowData); // Update endpoint style for drawing transparent arc.

      ctx.strokeStyle = ctx.fillStyle;
      ctx.fillStyle = "rgba(0, 0, 0, 0)"; // Define inverted curve endpoint as semicircle.

      var pi = Math.PI;
      var startAngle = arrowData.angle + pi / 2;
      var endAngle = arrowData.angle + 3 * pi / 2;
      ctx.beginPath();
      ctx.arc(point.x, point.y, arrowData.length * 0.4, startAngle, endAngle, false);
      ctx.stroke();
      return true;
    }
  }]);

  return InvertedCurve;
}();
/**
 * Drawing methods for the trinagle endpoint.
 */


var Triangle = /*#__PURE__*/function () {
  function Triangle() {
    _classCallCheck(this, Triangle);
  }

  _createClass(Triangle, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{
        x: 0.02,
        y: 0
      }, {
        x: -1,
        y: 0.3
      }, {
        x: -1,
        y: -0.3
      }];
      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
      return true;
    }
  }]);

  return Triangle;
}();
/**
 * Drawing methods for the inverted trinagle endpoint.
 */


var InvertedTriangle = /*#__PURE__*/function () {
  function InvertedTriangle() {
    _classCallCheck(this, InvertedTriangle);
  }

  _createClass(InvertedTriangle, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{
        x: 0,
        y: 0.3
      }, {
        x: 0,
        y: -0.3
      }, {
        x: -1,
        y: 0
      }];
      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
      return true;
    }
  }]);

  return InvertedTriangle;
}();
/**
 * Drawing methods for the circle endpoint.
 */


var Circle = /*#__PURE__*/function () {
  function Circle() {
    _classCallCheck(this, Circle);
  }

  _createClass(Circle, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      var point = {
        x: -0.4,
        y: 0
      };
      EndPoint.transform(point, arrowData);
      drawCircle(ctx, point.x, point.y, arrowData.length * 0.4);
      return true;
    }
  }]);

  return Circle;
}();
/**
 * Drawing methods for the bar endpoint.
 */


var Bar = /*#__PURE__*/function () {
  function Bar() {
    _classCallCheck(this, Bar);
  }

  _createClass(Bar, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      /*
      var points = [
        {x:0, y:0.5},
        {x:0, y:-0.5}
      ];
           EndPoint.transform(points, arrowData);
      ctx.beginPath();
      ctx.moveTo(points[0].x, points[0].y);
      ctx.lineTo(points[1].x, points[1].y);
      ctx.stroke();
      */
      var points = [{
        x: 0,
        y: 0.5
      }, {
        x: 0,
        y: -0.5
      }, {
        x: -0.15,
        y: -0.5
      }, {
        x: -0.15,
        y: 0.5
      }];
      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
      return true;
    }
  }]);

  return Bar;
}();
/**
 * Drawing methods for the box endpoint.
 */


var Box = /*#__PURE__*/function () {
  function Box() {
    _classCallCheck(this, Box);
  }

  _createClass(Box, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      var points = [{
        x: 0,
        y: 0.3
      }, {
        x: 0,
        y: -0.3
      }, {
        x: -0.6,
        y: -0.3
      }, {
        x: -0.6,
        y: 0.3
      }];
      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
      return true;
    }
  }]);

  return Box;
}();
/**
 * Drawing methods for the diamond endpoint.
 */


var Diamond = /*#__PURE__*/function () {
  function Diamond() {
    _classCallCheck(this, Diamond);
  }

  _createClass(Diamond, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      var points = [{
        x: 0,
        y: 0
      }, {
        x: -0.5,
        y: -0.3
      }, {
        x: -1,
        y: 0
      }, {
        x: -0.5,
        y: 0.3
      }];
      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
      return true;
    }
  }]);

  return Diamond;
}();
/**
 * Drawing methods for the vee endpoint.
 */


var Vee = /*#__PURE__*/function () {
  function Vee() {
    _classCallCheck(this, Vee);
  }

  _createClass(Vee, null, [{
    key: "draw",
    value:
    /**
     * Draw this shape at the end of a line.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True because ctx.fill() can be used to fill the arrow.
     */
    function draw(ctx, arrowData) {
      // Normalized points of closed path, in the order that they should be drawn.
      // (0, 0) is the attachment point, and the point around which should be rotated
      var points = [{
        x: -1,
        y: 0.3
      }, {
        x: -0.5,
        y: 0
      }, {
        x: -1,
        y: -0.3
      }, {
        x: 0,
        y: 0
      }];
      EndPoint.transform(points, arrowData);
      EndPoint.drawPath(ctx, points);
      return true;
    }
  }]);

  return Vee;
}();
/**
 * Drawing methods for the endpoints.
 */


var EndPoints = /*#__PURE__*/function () {
  function EndPoints() {
    _classCallCheck(this, EndPoints);
  }

  _createClass(EndPoints, null, [{
    key: "draw",
    value:
    /**
     * Draw an endpoint.
     *
     * @param ctx - The shape will be rendered into this context.
     * @param arrowData - The data determining the shape.
     *
     * @returns True if ctx.fill() can be used to fill the arrow, false otherwise.
     */
    function draw(ctx, arrowData) {
      var type;

      if (arrowData.type) {
        type = arrowData.type.toLowerCase();
      }

      switch (type) {
        case "image":
          return Image$1.draw(ctx, arrowData);

        case "circle":
          return Circle.draw(ctx, arrowData);

        case "box":
          return Box.draw(ctx, arrowData);

        case "crow":
          return Crow.draw(ctx, arrowData);

        case "curve":
          return Curve.draw(ctx, arrowData);

        case "diamond":
          return Diamond.draw(ctx, arrowData);

        case "inv_curve":
          return InvertedCurve.draw(ctx, arrowData);

        case "triangle":
          return Triangle.draw(ctx, arrowData);

        case "inv_triangle":
          return InvertedTriangle.draw(ctx, arrowData);

        case "bar":
          return Bar.draw(ctx, arrowData);

        case "vee":
          return Vee.draw(ctx, arrowData);

        case "arrow": // fall-through

        default:
          return Arrow.draw(ctx, arrowData);
      }
    }
  }]);

  return EndPoints;
}();

function ownKeys$1(object, enumerableOnly) { var keys = keys$4(object); if (getOwnPropertySymbols) { var symbols = getOwnPropertySymbols(object); if (enumerableOnly) { symbols = filter(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$2(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$1(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context2; forEach$2(_context2 = ownKeys$1(Object(source), true)).call(_context2, function (key) { _defineProperty(target, key, source[key]); }); } else if (getOwnPropertyDescriptors) { defineProperties(target, getOwnPropertyDescriptors(source)); } else { var _context3; forEach$2(_context3 = ownKeys$1(Object(source))).call(_context3, function (key) { defineProperty$5(target, key, getOwnPropertyDescriptor$2(source, key)); }); } } return target; }
/**
 * The Base Class for all edges.
 */

var EdgeBase = /*#__PURE__*/function () {
  /**
   * Create a new instance.
   *
   * @param options - The options object of given edge.
   * @param _body - The body of the network.
   * @param _labelModule - Label module.
   */
  function EdgeBase(options, _body, _labelModule) {
    _classCallCheck(this, EdgeBase);

    this._body = _body;
    this._labelModule = _labelModule;
    this.color = {};
    this.colorDirty = true;
    this.hoverWidth = 1.5;
    this.selectionWidth = 2;
    this.setOptions(options);
    this.fromPoint = this.from;
    this.toPoint = this.to;
  }
  /** @inheritDoc */


  _createClass(EdgeBase, [{
    key: "connect",
    value: function connect() {
      this.from = this._body.nodes[this.options.from];
      this.to = this._body.nodes[this.options.to];
    }
    /** @inheritDoc */

  }, {
    key: "cleanup",
    value: function cleanup() {
      return false;
    }
    /**
     * Set new edge options.
     *
     * @param options - The new edge options object.
     */

  }, {
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
      this.from = this._body.nodes[this.options.from];
      this.to = this._body.nodes[this.options.to];
      this.id = this.options.id;
    }
    /** @inheritDoc */

  }, {
    key: "drawLine",
    value: function drawLine(ctx, values, _selected, _hover) {
      var viaNode = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : this.getViaNode();
      // set style
      ctx.strokeStyle = this.getColor(ctx, values);
      ctx.lineWidth = values.width;

      if (values.dashes !== false) {
        this._drawDashedLine(ctx, values, viaNode);
      } else {
        this._drawLine(ctx, values, viaNode);
      }
    }
    /**
     * Draw a line with given style between two nodes through supplied node(s).
     *
     * @param ctx - The context that will be used for rendering.
     * @param values - Formatting values like color, opacity or shadow.
     * @param viaNode - Additional control point(s) for the edge.
     * @param fromPoint - TODO: Seems ignored, remove?
     * @param toPoint - TODO: Seems ignored, remove?
     */

  }, {
    key: "_drawLine",
    value: function _drawLine(ctx, values, viaNode, fromPoint, toPoint) {
      if (this.from != this.to) {
        // draw line
        this._line(ctx, values, viaNode, fromPoint, toPoint);
      } else {
        var _this$_getCircleData = this._getCircleData(ctx),
            _this$_getCircleData2 = _slicedToArray(_this$_getCircleData, 3),
            x = _this$_getCircleData2[0],
            y = _this$_getCircleData2[1],
            radius = _this$_getCircleData2[2];

        this._circle(ctx, values, x, y, radius);
      }
    }
    /**
     * Draw a dashed line with given style between two nodes through supplied node(s).
     *
     * @param ctx - The context that will be used for rendering.
     * @param values - Formatting values like color, opacity or shadow.
     * @param viaNode - Additional control point(s) for the edge.
     * @param _fromPoint - Ignored (TODO: remove in the future).
     * @param _toPoint - Ignored (TODO: remove in the future).
     */

  }, {
    key: "_drawDashedLine",
    value: function _drawDashedLine(ctx, values, viaNode, _fromPoint, _toPoint) {
      ctx.lineCap = "round";
      var pattern = isArray$2(values.dashes) ? values.dashes : [5, 5]; // only firefox and chrome support this method, else we use the legacy one.

      if (ctx.setLineDash !== undefined) {
        ctx.save(); // set dash settings for chrome or firefox

        ctx.setLineDash(pattern);
        ctx.lineDashOffset = 0; // draw the line

        if (this.from != this.to) {
          // draw line
          this._line(ctx, values, viaNode);
        } else {
          var _this$_getCircleData3 = this._getCircleData(ctx),
              _this$_getCircleData4 = _slicedToArray(_this$_getCircleData3, 3),
              x = _this$_getCircleData4[0],
              y = _this$_getCircleData4[1],
              radius = _this$_getCircleData4[2];

          this._circle(ctx, values, x, y, radius);
        } // restore the dash settings.


        ctx.setLineDash([0]);
        ctx.lineDashOffset = 0;
        ctx.restore();
      } else {
        // unsupporting smooth lines
        if (this.from != this.to) {
          // draw line
          drawDashedLine(ctx, this.from.x, this.from.y, this.to.x, this.to.y, pattern);
        } else {
          var _this$_getCircleData5 = this._getCircleData(ctx),
              _this$_getCircleData6 = _slicedToArray(_this$_getCircleData5, 3),
              _x = _this$_getCircleData6[0],
              _y = _this$_getCircleData6[1],
              _radius = _this$_getCircleData6[2];

          this._circle(ctx, values, _x, _y, _radius);
        } // draw shadow if enabled


        this.enableShadow(ctx, values);
        ctx.stroke(); // disable shadows for other elements.

        this.disableShadow(ctx, values);
      }
    }
    /**
     * Find the intersection between the border of the node and the edge.
     *
     * @param node - The node (either from or to node of the edge).
     * @param ctx - The context that will be used for rendering.
     * @param options - Additional options.
     *
     * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
     */

  }, {
    key: "findBorderPosition",
    value: function findBorderPosition(node, ctx, options) {
      if (this.from != this.to) {
        return this._findBorderPosition(node, ctx, options);
      } else {
        return this._findBorderPositionCircle(node, ctx, options);
      }
    }
    /** @inheritDoc */

  }, {
    key: "findBorderPositions",
    value: function findBorderPositions(ctx) {
      if (this.from != this.to) {
        return {
          from: this._findBorderPosition(this.from, ctx),
          to: this._findBorderPosition(this.to, ctx)
        };
      } else {
        var _context;

        var _this$_getCircleData$ = slice$1(_context = this._getCircleData(ctx)).call(_context, 0, 2),
            _this$_getCircleData$2 = _slicedToArray(_this$_getCircleData$, 2),
            x = _this$_getCircleData$2[0],
            y = _this$_getCircleData$2[1];

        return {
          from: this._findBorderPositionCircle(this.from, ctx, {
            x: x,
            y: y,
            low: 0.25,
            high: 0.6,
            direction: -1
          }),
          to: this._findBorderPositionCircle(this.from, ctx, {
            x: x,
            y: y,
            low: 0.6,
            high: 0.8,
            direction: 1
          })
        };
      }
    }
    /**
     * Compute the center point and radius of an edge connected to the same node at both ends.
     *
     * @param ctx - The context that will be used for rendering.
     *
     * @returns `[x, y, radius]`
     */

  }, {
    key: "_getCircleData",
    value: function _getCircleData(ctx) {
      var radius = this.options.selfReference.size;

      if (ctx !== undefined) {
        if (this.from.shape.width === undefined) {
          this.from.shape.resize(ctx);
        }
      } // get circle coordinates


      var coordinates = getSelfRefCoordinates(ctx, this.options.selfReference.angle, radius, this.from);
      return [coordinates.x, coordinates.y, radius];
    }
    /**
     * Get a point on a circle.
     *
     * @param x - Center of the circle on the x axis.
     * @param y - Center of the circle on the y axis.
     * @param radius - Radius of the circle.
     * @param position - Value between 0 (line start) and 1 (line end).
     *
     * @returns Cartesian coordinates of requested point on the circle.
     */

  }, {
    key: "_pointOnCircle",
    value: function _pointOnCircle(x, y, radius, position) {
      var angle = position * 2 * Math.PI;
      return {
        x: x + radius * Math.cos(angle),
        y: y - radius * Math.sin(angle)
      };
    }
    /**
     * Find the intersection between the border of the node and the edge.
     *
     * @remarks
     * This function uses binary search to look for the point where the circle crosses the border of the node.
     *
     * @param nearNode - The node (either from or to node of the edge).
     * @param ctx - The context that will be used for rendering.
     * @param options - Additional options.
     *
     * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
     */

  }, {
    key: "_findBorderPositionCircle",
    value: function _findBorderPositionCircle(nearNode, ctx, options) {
      var x = options.x;
      var y = options.y;
      var low = options.low;
      var high = options.high;
      var direction = options.direction;
      var maxIterations = 10;
      var radius = this.options.selfReference.size;
      var threshold = 0.05;
      var pos;
      var middle = (low + high) * 0.5;
      var endPointOffset = 0;

      if (this.options.arrowStrikethrough === true) {
        if (direction === -1) {
          endPointOffset = this.options.endPointOffset.from;
        } else if (direction === 1) {
          endPointOffset = this.options.endPointOffset.to;
        }
      }

      var iteration = 0;

      do {
        middle = (low + high) * 0.5;
        pos = this._pointOnCircle(x, y, radius, middle);
        var angle = Math.atan2(nearNode.y - pos.y, nearNode.x - pos.x);
        var distanceToBorder = nearNode.distanceToBorder(ctx, angle) + endPointOffset;
        var distanceToPoint = Math.sqrt(Math.pow(pos.x - nearNode.x, 2) + Math.pow(pos.y - nearNode.y, 2));
        var difference = distanceToBorder - distanceToPoint;

        if (Math.abs(difference) < threshold) {
          break; // found
        } else if (difference > 0) {
          // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
          if (direction > 0) {
            low = middle;
          } else {
            high = middle;
          }
        } else {
          if (direction > 0) {
            high = middle;
          } else {
            low = middle;
          }
        }

        ++iteration;
      } while (low <= high && iteration < maxIterations);

      return _objectSpread$1(_objectSpread$1({}, pos), {}, {
        t: middle
      });
    }
    /**
     * Get the line width of the edge. Depends on width and whether one of the connected nodes is selected.
     *
     * @param selected - Determines wheter the line is selected.
     * @param hover - Determines wheter the line is being hovered, only applies if selected is false.
     *
     * @returns The width of the line.
     */

  }, {
    key: "getLineWidth",
    value: function getLineWidth(selected, hover) {
      if (selected === true) {
        return Math.max(this.selectionWidth, 0.3 / this._body.view.scale);
      } else if (hover === true) {
        return Math.max(this.hoverWidth, 0.3 / this._body.view.scale);
      } else {
        return Math.max(this.options.width, 0.3 / this._body.view.scale);
      }
    }
    /**
     * Compute the color or gradient for given edge.
     *
     * @param ctx - The context that will be used for rendering.
     * @param values - Formatting values like color, opacity or shadow.
     * @param _selected - Ignored (TODO: remove in the future).
     * @param _hover - Ignored (TODO: remove in the future).
     *
     * @returns Color string if single color is inherited or gradient if two.
     */

  }, {
    key: "getColor",
    value: function getColor(ctx, values) {
      if (values.inheritsColor !== false) {
        // when this is a loop edge, just use the 'from' method
        if (values.inheritsColor === "both" && this.from.id !== this.to.id) {
          var grd = ctx.createLinearGradient(this.from.x, this.from.y, this.to.x, this.to.y);
          var fromColor = this.from.options.color.highlight.border;
          var toColor = this.to.options.color.highlight.border;

          if (this.from.selected === false && this.to.selected === false) {
            fromColor = overrideOpacity(this.from.options.color.border, values.opacity);
            toColor = overrideOpacity(this.to.options.color.border, values.opacity);
          } else if (this.from.selected === true && this.to.selected === false) {
            toColor = this.to.options.color.border;
          } else if (this.from.selected === false && this.to.selected === true) {
            fromColor = this.from.options.color.border;
          }

          grd.addColorStop(0, fromColor);
          grd.addColorStop(1, toColor); // -------------------- this returns -------------------- //

          return grd;
        }

        if (values.inheritsColor === "to") {
          return overrideOpacity(this.to.options.color.border, values.opacity);
        } else {
          // "from"
          return overrideOpacity(this.from.options.color.border, values.opacity);
        }
      } else {
        return overrideOpacity(values.color, values.opacity);
      }
    }
    /**
     * Draw a line from a node to itself, a circle.
     *
     * @param ctx - The context that will be used for rendering.
     * @param values - Formatting values like color, opacity or shadow.
     * @param x - Center of the circle on the x axis.
     * @param y - Center of the circle on the y axis.
     * @param radius - Radius of the circle.
     */

  }, {
    key: "_circle",
    value: function _circle(ctx, values, x, y, radius) {
      // draw shadow if enabled
      this.enableShadow(ctx, values); //full circle

      var angleFrom = 0;
      var angleTo = Math.PI * 2;

      if (!this.options.selfReference.renderBehindTheNode) {
        //render only parts which are not overlaping with parent node
        //need to find x,y of from point and x,y to point
        //calculating radians
        var low = this.options.selfReference.angle;
        var high = this.options.selfReference.angle + Math.PI;

        var pointTFrom = this._findBorderPositionCircle(this.from, ctx, {
          x: x,
          y: y,
          low: low,
          high: high,
          direction: -1
        });

        var pointTTo = this._findBorderPositionCircle(this.from, ctx, {
          x: x,
          y: y,
          low: low,
          high: high,
          direction: 1
        });

        angleFrom = Math.atan2(pointTFrom.y - y, pointTFrom.x - x);
        angleTo = Math.atan2(pointTTo.y - y, pointTTo.x - x);
      } // draw a circle


      ctx.beginPath();
      ctx.arc(x, y, radius, angleFrom, angleTo, false);
      ctx.stroke(); // disable shadows for other elements.

      this.disableShadow(ctx, values);
    }
    /**
     * @inheritDoc
     *
     * @remarks
     * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
     */

  }, {
    key: "getDistanceToEdge",
    value: function getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
      if (this.from != this.to) {
        return this._getDistanceToEdge(x1, y1, x2, y2, x3, y3);
      } else {
        var _this$_getCircleData7 = this._getCircleData(undefined),
            _this$_getCircleData8 = _slicedToArray(_this$_getCircleData7, 3),
            x = _this$_getCircleData8[0],
            y = _this$_getCircleData8[1],
            radius = _this$_getCircleData8[2];

        var dx = x - x3;
        var dy = y - y3;
        return Math.abs(Math.sqrt(dx * dx + dy * dy) - radius);
      }
    }
    /**
     * Calculate the distance between a point (x3, y3) and a line segment from (x1, y1) to (x2, y2).
     *
     * @param x1 - First end of the line segment on the x axis.
     * @param y1 - First end of the line segment on the y axis.
     * @param x2 - Second end of the line segment on the x axis.
     * @param y2 - Second end of the line segment on the y axis.
     * @param x3 - Position of the point on the x axis.
     * @param y3 - Position of the point on the y axis.
     *
     * @returns The distance between the line segment and the point.
     */

  }, {
    key: "_getDistanceToLine",
    value: function _getDistanceToLine(x1, y1, x2, y2, x3, y3) {
      var px = x2 - x1;
      var py = y2 - y1;
      var something = px * px + py * py;
      var u = ((x3 - x1) * px + (y3 - y1) * py) / something;

      if (u > 1) {
        u = 1;
      } else if (u < 0) {
        u = 0;
      }

      var x = x1 + u * px;
      var y = y1 + u * py;
      var dx = x - x3;
      var dy = y - y3; //# Note: If the actual distance does not matter,
      //# if you only want to compare what this function
      //# returns to other results of this function, you
      //# can just return the squared distance instead
      //# (i.e. remove the sqrt) to gain a little performance

      return Math.sqrt(dx * dx + dy * dy);
    }
    /** @inheritDoc */

  }, {
    key: "getArrowData",
    value: function getArrowData(ctx, position, viaNode, _selected, _hover, values) {
      // set lets
      var angle;
      var arrowPoint;
      var node1;
      var node2;
      var reversed;
      var scaleFactor;
      var type;
      var lineWidth = values.width;

      if (position === "from") {
        node1 = this.from;
        node2 = this.to;
        reversed = values.fromArrowScale < 0;
        scaleFactor = Math.abs(values.fromArrowScale);
        type = values.fromArrowType;
      } else if (position === "to") {
        node1 = this.to;
        node2 = this.from;
        reversed = values.toArrowScale < 0;
        scaleFactor = Math.abs(values.toArrowScale);
        type = values.toArrowType;
      } else {
        node1 = this.to;
        node2 = this.from;
        reversed = values.middleArrowScale < 0;
        scaleFactor = Math.abs(values.middleArrowScale);
        type = values.middleArrowType;
      }

      var length = 15 * scaleFactor + 3 * lineWidth; // 3* lineWidth is the width of the edge.
      // if not connected to itself

      if (node1 != node2) {
        var approximateEdgeLength = hypot(node1.x - node2.x, node1.y - node2.y);

        var relativeLength = length / approximateEdgeLength;

        if (position !== "middle") {
          // draw arrow head
          if (this.options.smooth.enabled === true) {
            var pointT = this._findBorderPosition(node1, ctx, {
              via: viaNode
            });

            var guidePos = this.getPoint(pointT.t + relativeLength * (position === "from" ? 1 : -1), viaNode);
            angle = Math.atan2(pointT.y - guidePos.y, pointT.x - guidePos.x);
            arrowPoint = pointT;
          } else {
            angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
            arrowPoint = this._findBorderPosition(node1, ctx);
          }
        } else {
          // Negative half length reverses arrow direction.
          var halfLength = (reversed ? -relativeLength : relativeLength) / 2;
          var guidePos1 = this.getPoint(0.5 + halfLength, viaNode);
          var guidePos2 = this.getPoint(0.5 - halfLength, viaNode);
          angle = Math.atan2(guidePos1.y - guidePos2.y, guidePos1.x - guidePos2.x);
          arrowPoint = this.getPoint(0.5, viaNode);
        }
      } else {
        // draw circle
        var _this$_getCircleData9 = this._getCircleData(ctx),
            _this$_getCircleData10 = _slicedToArray(_this$_getCircleData9, 3),
            x = _this$_getCircleData10[0],
            y = _this$_getCircleData10[1],
            radius = _this$_getCircleData10[2];

        if (position === "from") {
          var low = this.options.selfReference.angle;
          var high = this.options.selfReference.angle + Math.PI;

          var _pointT = this._findBorderPositionCircle(this.from, ctx, {
            x: x,
            y: y,
            low: low,
            high: high,
            direction: -1
          });

          angle = _pointT.t * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
          arrowPoint = _pointT;
        } else if (position === "to") {
          var _low = this.options.selfReference.angle;

          var _high = this.options.selfReference.angle + Math.PI;

          var _pointT2 = this._findBorderPositionCircle(this.from, ctx, {
            x: x,
            y: y,
            low: _low,
            high: _high,
            direction: 1
          });

          angle = _pointT2.t * -2 * Math.PI + 1.5 * Math.PI - 1.1 * Math.PI;
          arrowPoint = _pointT2;
        } else {
          var pos = this.options.selfReference.angle / (2 * Math.PI);
          arrowPoint = this._pointOnCircle(x, y, radius, pos);
          angle = pos * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
        }
      }

      var xi = arrowPoint.x - length * 0.9 * Math.cos(angle);
      var yi = arrowPoint.y - length * 0.9 * Math.sin(angle);
      var arrowCore = {
        x: xi,
        y: yi
      };
      return {
        point: arrowPoint,
        core: arrowCore,
        angle: angle,
        length: length,
        type: type
      };
    }
    /** @inheritDoc */

  }, {
    key: "drawArrowHead",
    value: function drawArrowHead(ctx, values, _selected, _hover, arrowData) {
      // set style
      ctx.strokeStyle = this.getColor(ctx, values);
      ctx.fillStyle = ctx.strokeStyle;
      ctx.lineWidth = values.width;
      var canFill = EndPoints.draw(ctx, arrowData);

      if (canFill) {
        // draw shadow if enabled
        this.enableShadow(ctx, values);

        fill(ctx).call(ctx); // disable shadows for other elements.


        this.disableShadow(ctx, values);
      }
    }
    /**
     * Set the shadow formatting values in the context if enabled, do nothing otherwise.
     *
     * @param ctx - The context that will be used for rendering.
     * @param values - Formatting values for the shadow.
     */

  }, {
    key: "enableShadow",
    value: function enableShadow(ctx, values) {
      if (values.shadow === true) {
        ctx.shadowColor = values.shadowColor;
        ctx.shadowBlur = values.shadowSize;
        ctx.shadowOffsetX = values.shadowX;
        ctx.shadowOffsetY = values.shadowY;
      }
    }
    /**
     * Reset the shadow formatting values in the context if enabled, do nothing otherwise.
     *
     * @param ctx - The context that will be used for rendering.
     * @param values - Formatting values for the shadow.
     */

  }, {
    key: "disableShadow",
    value: function disableShadow(ctx, values) {
      if (values.shadow === true) {
        ctx.shadowColor = "rgba(0,0,0,0)";
        ctx.shadowBlur = 0;
        ctx.shadowOffsetX = 0;
        ctx.shadowOffsetY = 0;
      }
    }
    /**
     * Render the background according to the formatting values.
     *
     * @param ctx - The context that will be used for rendering.
     * @param values - Formatting values for the background.
     */

  }, {
    key: "drawBackground",
    value: function drawBackground(ctx, values) {
      if (values.background !== false) {
        // save original line attrs
        var origCtxAttr = {
          strokeStyle: ctx.strokeStyle,
          lineWidth: ctx.lineWidth,
          dashes: ctx.dashes
        };
        ctx.strokeStyle = values.backgroundColor;
        ctx.lineWidth = values.backgroundSize;
        this.setStrokeDashed(ctx, values.backgroundDashes);
        ctx.stroke(); // restore original line attrs

        ctx.strokeStyle = origCtxAttr.strokeStyle;
        ctx.lineWidth = origCtxAttr.lineWidth;
        ctx.dashes = origCtxAttr.dashes;
        this.setStrokeDashed(ctx, values.dashes);
      }
    }
    /**
     * Set the line dash pattern if supported. Logs a warning to the console if it isn't supported.
     *
     * @param ctx - The context that will be used for rendering.
     * @param dashes - The pattern [line, space, line…], true for default dashed line or false for normal line.
     */

  }, {
    key: "setStrokeDashed",
    value: function setStrokeDashed(ctx, dashes) {
      if (dashes !== false) {
        if (ctx.setLineDash !== undefined) {
          var pattern = isArray$2(dashes) ? dashes : [5, 5];
          ctx.setLineDash(pattern);
        } else {
          console.warn("setLineDash is not supported in this browser. The dashed stroke cannot be used.");
        }
      } else {
        if (ctx.setLineDash !== undefined) {
          ctx.setLineDash([]);
        } else {
          console.warn("setLineDash is not supported in this browser. The dashed stroke cannot be used.");
        }
      }
    }
  }]);

  return EdgeBase;
}();

function ownKeys(object, enumerableOnly) { var keys = keys$4(object); if (getOwnPropertySymbols) { var symbols = getOwnPropertySymbols(object); if (enumerableOnly) { symbols = filter(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$2(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context; forEach$2(_context = ownKeys(Object(source), true)).call(_context, function (key) { _defineProperty(target, key, source[key]); }); } else if (getOwnPropertyDescriptors) { defineProperties(target, getOwnPropertyDescriptors(source)); } else { var _context2; forEach$2(_context2 = ownKeys(Object(source))).call(_context2, function (key) { defineProperty$5(target, key, getOwnPropertyDescriptor$2(source, key)); }); } } return target; }

function _createSuper$9(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$9(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$9() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * The Base Class for all Bezier edges.
 * Bezier curves are used to model smooth gradual curves in paths between nodes.
 */

var BezierEdgeBase = /*#__PURE__*/function (_EdgeBase) {
  _inherits(BezierEdgeBase, _EdgeBase);

  var _super = _createSuper$9(BezierEdgeBase);

  /**
   * Create a new instance.
   *
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  function BezierEdgeBase(options, body, labelModule) {
    _classCallCheck(this, BezierEdgeBase);

    return _super.call(this, options, body, labelModule);
  }
  /**
   * Find the intersection between the border of the node and the edge.
   *
   * @remarks
   * This function uses binary search to look for the point where the bezier curve crosses the border of the node.
   *
   * @param nearNode - The node (either from or to node of the edge).
   * @param ctx - The context that will be used for rendering.
   * @param viaNode - Additional node(s) the edge passes through.
   *
   * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
   */


  _createClass(BezierEdgeBase, [{
    key: "_findBorderPositionBezier",
    value: function _findBorderPositionBezier(nearNode, ctx) {
      var viaNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this._getViaCoordinates();
      var maxIterations = 10;
      var threshold = 0.2;
      var from = false;
      var high = 1;
      var low = 0;
      var node = this.to;
      var pos;
      var middle;
      var endPointOffset = this.options.endPointOffset ? this.options.endPointOffset.to : 0;

      if (nearNode.id === this.from.id) {
        node = this.from;
        from = true;
        endPointOffset = this.options.endPointOffset ? this.options.endPointOffset.from : 0;
      }

      if (this.options.arrowStrikethrough === false) {
        endPointOffset = 0;
      }

      var iteration = 0;

      do {
        middle = (low + high) * 0.5;
        pos = this.getPoint(middle, viaNode);
        var angle = Math.atan2(node.y - pos.y, node.x - pos.x);
        var distanceToBorder = node.distanceToBorder(ctx, angle) + endPointOffset;
        var distanceToPoint = Math.sqrt(Math.pow(pos.x - node.x, 2) + Math.pow(pos.y - node.y, 2));
        var difference = distanceToBorder - distanceToPoint;

        if (Math.abs(difference) < threshold) {
          break; // found
        } else if (difference < 0) {
          // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
          if (from === false) {
            low = middle;
          } else {
            high = middle;
          }
        } else {
          if (from === false) {
            high = middle;
          } else {
            low = middle;
          }
        }

        ++iteration;
      } while (low <= high && iteration < maxIterations);

      return _objectSpread(_objectSpread({}, pos), {}, {
        t: middle
      });
    }
    /**
     * Calculate the distance between a point (x3,y3) and a line segment from (x1,y1) to (x2,y2).
     *
     * @remarks
     * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
     *
     * @param x1 - First end of the line segment on the x axis.
     * @param y1 - First end of the line segment on the y axis.
     * @param x2 - Second end of the line segment on the x axis.
     * @param y2 - Second end of the line segment on the y axis.
     * @param x3 - Position of the point on the x axis.
     * @param y3 - Position of the point on the y axis.
     * @param via - The control point for the edge.
     *
     * @returns The distance between the line segment and the point.
     */

  }, {
    key: "_getDistanceToBezierEdge",
    value: function _getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, via) {
      // x3,y3 is the point
      var minDistance = 1e9;
      var distance;
      var i, t, x, y;
      var lastX = x1;
      var lastY = y1;

      for (i = 1; i < 10; i++) {
        t = 0.1 * i;
        x = Math.pow(1 - t, 2) * x1 + 2 * t * (1 - t) * via.x + Math.pow(t, 2) * x2;
        y = Math.pow(1 - t, 2) * y1 + 2 * t * (1 - t) * via.y + Math.pow(t, 2) * y2;

        if (i > 0) {
          distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);
          minDistance = distance < minDistance ? distance : minDistance;
        }

        lastX = x;
        lastY = y;
      }

      return minDistance;
    }
    /**
     * Render a bezier curve between two nodes.
     *
     * @remarks
     * The method accepts zero, one or two control points.
     * Passing zero control points just draws a straight line.
     *
     * @param ctx - The context that will be used for rendering.
     * @param values - Style options for edge drawing.
     * @param viaNode1 - First control point for curve drawing.
     * @param viaNode2 - Second control point for curve drawing.
     */

  }, {
    key: "_bezierCurve",
    value: function _bezierCurve(ctx, values, viaNode1, viaNode2) {
      ctx.beginPath();
      ctx.moveTo(this.fromPoint.x, this.fromPoint.y);

      if (viaNode1 != null && viaNode1.x != null) {
        if (viaNode2 != null && viaNode2.x != null) {
          ctx.bezierCurveTo(viaNode1.x, viaNode1.y, viaNode2.x, viaNode2.y, this.toPoint.x, this.toPoint.y);
        } else {
          ctx.quadraticCurveTo(viaNode1.x, viaNode1.y, this.toPoint.x, this.toPoint.y);
        }
      } else {
        // fallback to normal straight edge
        ctx.lineTo(this.toPoint.x, this.toPoint.y);
      } // draw a background


      this.drawBackground(ctx, values); // draw shadow if enabled

      this.enableShadow(ctx, values);
      ctx.stroke();
      this.disableShadow(ctx, values);
    }
    /** @inheritDoc */

  }, {
    key: "getViaNode",
    value: function getViaNode() {
      return this._getViaCoordinates();
    }
  }]);

  return BezierEdgeBase;
}(EdgeBase);

function _createSuper$8(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$8(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$8() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Dynamic Bezier Edge. Bezier curves are used to model smooth gradual
 * curves in paths between nodes. The Dynamic piece refers to how the curve
 * reacts to physics changes.
 *
 * @augments BezierEdgeBase
 */

var BezierEdgeDynamic = /*#__PURE__*/function (_BezierEdgeBase) {
  _inherits(BezierEdgeDynamic, _BezierEdgeBase);

  var _super = _createSuper$8(BezierEdgeDynamic);

  /**
   * Create a new instance.
   *
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  function BezierEdgeDynamic(options, body, labelModule) {
    var _this;

    _classCallCheck(this, BezierEdgeDynamic);

    //this.via = undefined; // Here for completeness but not allowed to defined before super() is invoked.
    _this = _super.call(this, options, body, labelModule); // --> this calls the setOptions below

    _this.via = _this.via; // constructor → super → super → setOptions → setupSupportNode

    _this._boundFunction = function () {
      _this.positionBezierNode();
    };

    _this._body.emitter.on("_repositionBezierNodes", _this._boundFunction);

    return _this;
  }
  /** @inheritDoc */


  _createClass(BezierEdgeDynamic, [{
    key: "setOptions",
    value: function setOptions(options) {
      _get(_getPrototypeOf(BezierEdgeDynamic.prototype), "setOptions", this).call(this, options); // check if the physics has changed.


      var physicsChange = false;

      if (this.options.physics !== options.physics) {
        physicsChange = true;
      } // set the options and the to and from nodes


      this.options = options;
      this.id = this.options.id;
      this.from = this._body.nodes[this.options.from];
      this.to = this._body.nodes[this.options.to]; // setup the support node and connect

      this.setupSupportNode();
      this.connect(); // when we change the physics state of the edge, we reposition the support node.

      if (physicsChange === true) {
        this.via.setOptions({
          physics: this.options.physics
        });
        this.positionBezierNode();
      }
    }
    /** @inheritDoc */

  }, {
    key: "connect",
    value: function connect() {
      this.from = this._body.nodes[this.options.from];
      this.to = this._body.nodes[this.options.to];

      if (this.from === undefined || this.to === undefined || this.options.physics === false) {
        this.via.setOptions({
          physics: false
        });
      } else {
        // fix weird behaviour where a self referencing node has physics enabled
        if (this.from.id === this.to.id) {
          this.via.setOptions({
            physics: false
          });
        } else {
          this.via.setOptions({
            physics: true
          });
        }
      }
    }
    /** @inheritDoc */

  }, {
    key: "cleanup",
    value: function cleanup() {
      this._body.emitter.off("_repositionBezierNodes", this._boundFunction);

      if (this.via !== undefined) {
        delete this._body.nodes[this.via.id];
        this.via = undefined;
        return true;
      }

      return false;
    }
    /**
     * Create and add a support node if not already present.
     *
     * @remarks
     * Bezier curves require an anchor point to calculate the smooth flow.
     * These points are nodes.
     * These nodes are invisible but are used for the force calculation.
     *
     * The changed data is not called, if needed, it is returned by the main edge constructor.
     */

  }, {
    key: "setupSupportNode",
    value: function setupSupportNode() {
      if (this.via === undefined) {
        var nodeId = "edgeId:" + this.id;

        var node = this._body.functions.createNode({
          id: nodeId,
          shape: "circle",
          physics: true,
          hidden: true
        });

        this._body.nodes[nodeId] = node;
        this.via = node;
        this.via.parentEdgeId = this.id;
        this.positionBezierNode();
      }
    }
    /**
     * Position bezier node.
     */

  }, {
    key: "positionBezierNode",
    value: function positionBezierNode() {
      if (this.via !== undefined && this.from !== undefined && this.to !== undefined) {
        this.via.x = 0.5 * (this.from.x + this.to.x);
        this.via.y = 0.5 * (this.from.y + this.to.y);
      } else if (this.via !== undefined) {
        this.via.x = 0;
        this.via.y = 0;
      }
    }
    /** @inheritDoc */

  }, {
    key: "_line",
    value: function _line(ctx, values, viaNode) {
      this._bezierCurve(ctx, values, viaNode);
    }
    /** @inheritDoc */

  }, {
    key: "_getViaCoordinates",
    value: function _getViaCoordinates() {
      return this.via;
    }
    /** @inheritDoc */

  }, {
    key: "getViaNode",
    value: function getViaNode() {
      return this.via;
    }
    /** @inheritDoc */

  }, {
    key: "getPoint",
    value: function getPoint(position) {
      var viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.via;

      if (this.from === this.to) {
        var _this$_getCircleData = this._getCircleData(),
            _this$_getCircleData2 = _slicedToArray(_this$_getCircleData, 3),
            cx = _this$_getCircleData2[0],
            cy = _this$_getCircleData2[1],
            cr = _this$_getCircleData2[2];

        var a = 2 * Math.PI * (1 - position);
        return {
          x: cx + cr * Math.sin(a),
          y: cy + cr - cr * (1 - Math.cos(a))
        };
      } else {
        return {
          x: Math.pow(1 - position, 2) * this.fromPoint.x + 2 * position * (1 - position) * viaNode.x + Math.pow(position, 2) * this.toPoint.x,
          y: Math.pow(1 - position, 2) * this.fromPoint.y + 2 * position * (1 - position) * viaNode.y + Math.pow(position, 2) * this.toPoint.y
        };
      }
    }
    /** @inheritDoc */

  }, {
    key: "_findBorderPosition",
    value: function _findBorderPosition(nearNode, ctx) {
      return this._findBorderPositionBezier(nearNode, ctx, this.via);
    }
    /** @inheritDoc */

  }, {
    key: "_getDistanceToEdge",
    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
      // x3,y3 is the point
      return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, this.via);
    }
  }]);

  return BezierEdgeDynamic;
}(BezierEdgeBase);

function _createSuper$7(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$7(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$7() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Static Bezier Edge. Bezier curves are used to model smooth gradual curves in paths between nodes.
 */

var BezierEdgeStatic = /*#__PURE__*/function (_BezierEdgeBase) {
  _inherits(BezierEdgeStatic, _BezierEdgeBase);

  var _super = _createSuper$7(BezierEdgeStatic);

  /**
   * Create a new instance.
   *
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  function BezierEdgeStatic(options, body, labelModule) {
    _classCallCheck(this, BezierEdgeStatic);

    return _super.call(this, options, body, labelModule);
  }
  /** @inheritDoc */


  _createClass(BezierEdgeStatic, [{
    key: "_line",
    value: function _line(ctx, values, viaNode) {
      this._bezierCurve(ctx, values, viaNode);
    }
    /** @inheritDoc */

  }, {
    key: "getViaNode",
    value: function getViaNode() {
      return this._getViaCoordinates();
    }
    /**
     * Compute the coordinates of the via node.
     *
     * @remarks
     * We do not use the to and fromPoints here to make the via nodes the same as edges without arrows.
     *
     * @returns Cartesian coordinates of the via node.
     */

  }, {
    key: "_getViaCoordinates",
    value: function _getViaCoordinates() {
      // Assumption: x/y coordinates in from/to always defined
      var factor = this.options.smooth.roundness;
      var type = this.options.smooth.type;
      var dx = Math.abs(this.from.x - this.to.x);
      var dy = Math.abs(this.from.y - this.to.y);

      if (type === "discrete" || type === "diagonalCross") {
        var stepX;
        var stepY;

        if (dx <= dy) {
          stepX = stepY = factor * dy;
        } else {
          stepX = stepY = factor * dx;
        }

        if (this.from.x > this.to.x) {
          stepX = -stepX;
        }

        if (this.from.y >= this.to.y) {
          stepY = -stepY;
        }

        var xVia = this.from.x + stepX;
        var yVia = this.from.y + stepY;

        if (type === "discrete") {
          if (dx <= dy) {
            xVia = dx < factor * dy ? this.from.x : xVia;
          } else {
            yVia = dy < factor * dx ? this.from.y : yVia;
          }
        }

        return {
          x: xVia,
          y: yVia
        };
      } else if (type === "straightCross") {
        var _stepX = (1 - factor) * dx;

        var _stepY = (1 - factor) * dy;

        if (dx <= dy) {
          // up - down
          _stepX = 0;

          if (this.from.y < this.to.y) {
            _stepY = -_stepY;
          }
        } else {
          // left - right
          if (this.from.x < this.to.x) {
            _stepX = -_stepX;
          }

          _stepY = 0;
        }

        return {
          x: this.to.x + _stepX,
          y: this.to.y + _stepY
        };
      } else if (type === "horizontal") {
        var _stepX2 = (1 - factor) * dx;

        if (this.from.x < this.to.x) {
          _stepX2 = -_stepX2;
        }

        return {
          x: this.to.x + _stepX2,
          y: this.from.y
        };
      } else if (type === "vertical") {
        var _stepY2 = (1 - factor) * dy;

        if (this.from.y < this.to.y) {
          _stepY2 = -_stepY2;
        }

        return {
          x: this.from.x,
          y: this.to.y + _stepY2
        };
      } else if (type === "curvedCW") {
        dx = this.to.x - this.from.x;
        dy = this.from.y - this.to.y;
        var radius = Math.sqrt(dx * dx + dy * dy);
        var pi = Math.PI;
        var originalAngle = Math.atan2(dy, dx);
        var myAngle = (originalAngle + (factor * 0.5 + 0.5) * pi) % (2 * pi);
        return {
          x: this.from.x + (factor * 0.5 + 0.5) * radius * Math.sin(myAngle),
          y: this.from.y + (factor * 0.5 + 0.5) * radius * Math.cos(myAngle)
        };
      } else if (type === "curvedCCW") {
        dx = this.to.x - this.from.x;
        dy = this.from.y - this.to.y;

        var _radius = Math.sqrt(dx * dx + dy * dy);

        var _pi = Math.PI;

        var _originalAngle = Math.atan2(dy, dx);

        var _myAngle = (_originalAngle + (-factor * 0.5 + 0.5) * _pi) % (2 * _pi);

        return {
          x: this.from.x + (factor * 0.5 + 0.5) * _radius * Math.sin(_myAngle),
          y: this.from.y + (factor * 0.5 + 0.5) * _radius * Math.cos(_myAngle)
        };
      } else {
        // continuous
        var _stepX3;

        var _stepY3;

        if (dx <= dy) {
          _stepX3 = _stepY3 = factor * dy;
        } else {
          _stepX3 = _stepY3 = factor * dx;
        }

        if (this.from.x > this.to.x) {
          _stepX3 = -_stepX3;
        }

        if (this.from.y >= this.to.y) {
          _stepY3 = -_stepY3;
        }

        var _xVia = this.from.x + _stepX3;

        var _yVia = this.from.y + _stepY3;

        if (dx <= dy) {
          if (this.from.x <= this.to.x) {
            _xVia = this.to.x < _xVia ? this.to.x : _xVia;
          } else {
            _xVia = this.to.x > _xVia ? this.to.x : _xVia;
          }
        } else {
          if (this.from.y >= this.to.y) {
            _yVia = this.to.y > _yVia ? this.to.y : _yVia;
          } else {
            _yVia = this.to.y < _yVia ? this.to.y : _yVia;
          }
        }

        return {
          x: _xVia,
          y: _yVia
        };
      }
    }
    /** @inheritDoc */

  }, {
    key: "_findBorderPosition",
    value: function _findBorderPosition(nearNode, ctx) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      return this._findBorderPositionBezier(nearNode, ctx, options.via);
    }
    /** @inheritDoc */

  }, {
    key: "_getDistanceToEdge",
    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
      var viaNode = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates();
      // x3,y3 is the point
      return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, viaNode);
    }
    /** @inheritDoc */

  }, {
    key: "getPoint",
    value: function getPoint(position) {
      var viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates();
      var t = position;
      var x = Math.pow(1 - t, 2) * this.fromPoint.x + 2 * t * (1 - t) * viaNode.x + Math.pow(t, 2) * this.toPoint.x;
      var y = Math.pow(1 - t, 2) * this.fromPoint.y + 2 * t * (1 - t) * viaNode.y + Math.pow(t, 2) * this.toPoint.y;
      return {
        x: x,
        y: y
      };
    }
  }]);

  return BezierEdgeStatic;
}(BezierEdgeBase);

function _createSuper$6(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$6(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$6() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Base Class for all Cubic Bezier Edges. Bezier curves are used to model
 * smooth gradual curves in paths between nodes.
 *
 * @augments BezierEdgeBase
 */

var CubicBezierEdgeBase = /*#__PURE__*/function (_BezierEdgeBase) {
  _inherits(CubicBezierEdgeBase, _BezierEdgeBase);

  var _super = _createSuper$6(CubicBezierEdgeBase);

  /**
   * Create a new instance.
   *
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  function CubicBezierEdgeBase(options, body, labelModule) {
    _classCallCheck(this, CubicBezierEdgeBase);

    return _super.call(this, options, body, labelModule);
  }
  /**
   * Calculate the distance between a point (x3,y3) and a line segment from (x1,y1) to (x2,y2).
   *
   * @remarks
   * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
   * https://en.wikipedia.org/wiki/B%C3%A9zier_curve
   *
   * @param x1 - First end of the line segment on the x axis.
   * @param y1 - First end of the line segment on the y axis.
   * @param x2 - Second end of the line segment on the x axis.
   * @param y2 - Second end of the line segment on the y axis.
   * @param x3 - Position of the point on the x axis.
   * @param y3 - Position of the point on the y axis.
   * @param via1 - The first point this edge passes through.
   * @param via2 - The second point this edge passes through.
   *
   * @returns The distance between the line segment and the point.
   */


  _createClass(CubicBezierEdgeBase, [{
    key: "_getDistanceToBezierEdge2",
    value: function _getDistanceToBezierEdge2(x1, y1, x2, y2, x3, y3, via1, via2) {
      // x3,y3 is the point
      var minDistance = 1e9;
      var lastX = x1;
      var lastY = y1;
      var vec = [0, 0, 0, 0];

      for (var i = 1; i < 10; i++) {
        var t = 0.1 * i;
        vec[0] = Math.pow(1 - t, 3);
        vec[1] = 3 * t * Math.pow(1 - t, 2);
        vec[2] = 3 * Math.pow(t, 2) * (1 - t);
        vec[3] = Math.pow(t, 3);
        var x = vec[0] * x1 + vec[1] * via1.x + vec[2] * via2.x + vec[3] * x2;
        var y = vec[0] * y1 + vec[1] * via1.y + vec[2] * via2.y + vec[3] * y2;

        if (i > 0) {
          var distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);

          minDistance = distance < minDistance ? distance : minDistance;
        }

        lastX = x;
        lastY = y;
      }

      return minDistance;
    }
  }]);

  return CubicBezierEdgeBase;
}(BezierEdgeBase);

function _createSuper$5(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$5(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$5() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Cubic Bezier Edge. Bezier curves are used to model smooth gradual curves in paths between nodes.
 */

var CubicBezierEdge = /*#__PURE__*/function (_CubicBezierEdgeBase) {
  _inherits(CubicBezierEdge, _CubicBezierEdgeBase);

  var _super = _createSuper$5(CubicBezierEdge);

  /**
   * Create a new instance.
   *
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  function CubicBezierEdge(options, body, labelModule) {
    _classCallCheck(this, CubicBezierEdge);

    return _super.call(this, options, body, labelModule);
  }
  /** @inheritDoc */


  _createClass(CubicBezierEdge, [{
    key: "_line",
    value: function _line(ctx, values, viaNodes) {
      // get the coordinates of the support points.
      var via1 = viaNodes[0];
      var via2 = viaNodes[1];

      this._bezierCurve(ctx, values, via1, via2);
    }
    /**
     * Compute the additional points the edge passes through.
     *
     * @returns Cartesian coordinates of the points the edge passes through.
     */

  }, {
    key: "_getViaCoordinates",
    value: function _getViaCoordinates() {
      var dx = this.from.x - this.to.x;
      var dy = this.from.y - this.to.y;
      var x1;
      var y1;
      var x2;
      var y2;
      var roundness = this.options.smooth.roundness; // horizontal if x > y or if direction is forced or if direction is horizontal

      if ((Math.abs(dx) > Math.abs(dy) || this.options.smooth.forceDirection === true || this.options.smooth.forceDirection === "horizontal") && this.options.smooth.forceDirection !== "vertical") {
        y1 = this.from.y;
        y2 = this.to.y;
        x1 = this.from.x - roundness * dx;
        x2 = this.to.x + roundness * dx;
      } else {
        y1 = this.from.y - roundness * dy;
        y2 = this.to.y + roundness * dy;
        x1 = this.from.x;
        x2 = this.to.x;
      }

      return [{
        x: x1,
        y: y1
      }, {
        x: x2,
        y: y2
      }];
    }
    /** @inheritDoc */

  }, {
    key: "getViaNode",
    value: function getViaNode() {
      return this._getViaCoordinates();
    }
    /** @inheritDoc */

  }, {
    key: "_findBorderPosition",
    value: function _findBorderPosition(nearNode, ctx) {
      return this._findBorderPositionBezier(nearNode, ctx);
    }
    /** @inheritDoc */

  }, {
    key: "_getDistanceToEdge",
    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
      var _ref = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates(),
          _ref2 = _slicedToArray(_ref, 2),
          via1 = _ref2[0],
          via2 = _ref2[1];

      // x3,y3 is the point
      return this._getDistanceToBezierEdge2(x1, y1, x2, y2, x3, y3, via1, via2);
    }
    /** @inheritDoc */

  }, {
    key: "getPoint",
    value: function getPoint(position) {
      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates(),
          _ref4 = _slicedToArray(_ref3, 2),
          via1 = _ref4[0],
          via2 = _ref4[1];

      var t = position;
      var vec = [Math.pow(1 - t, 3), 3 * t * Math.pow(1 - t, 2), 3 * Math.pow(t, 2) * (1 - t), Math.pow(t, 3)];
      var x = vec[0] * this.fromPoint.x + vec[1] * via1.x + vec[2] * via2.x + vec[3] * this.toPoint.x;
      var y = vec[0] * this.fromPoint.y + vec[1] * via1.y + vec[2] * via2.y + vec[3] * this.toPoint.y;
      return {
        x: x,
        y: y
      };
    }
  }]);

  return CubicBezierEdge;
}(CubicBezierEdgeBase);

function _createSuper$4(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$4(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$4() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Straight Edge.
 */

var StraightEdge = /*#__PURE__*/function (_EdgeBase) {
  _inherits(StraightEdge, _EdgeBase);

  var _super = _createSuper$4(StraightEdge);

  /**
   * Create a new instance.
   *
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  function StraightEdge(options, body, labelModule) {
    _classCallCheck(this, StraightEdge);

    return _super.call(this, options, body, labelModule);
  }
  /** @inheritDoc */


  _createClass(StraightEdge, [{
    key: "_line",
    value: function _line(ctx, values) {
      // draw a straight line
      ctx.beginPath();
      ctx.moveTo(this.fromPoint.x, this.fromPoint.y);
      ctx.lineTo(this.toPoint.x, this.toPoint.y); // draw shadow if enabled

      this.enableShadow(ctx, values);
      ctx.stroke();
      this.disableShadow(ctx, values);
    }
    /** @inheritDoc */

  }, {
    key: "getViaNode",
    value: function getViaNode() {
      return undefined;
    }
    /** @inheritDoc */

  }, {
    key: "getPoint",
    value: function getPoint(position) {
      return {
        x: (1 - position) * this.fromPoint.x + position * this.toPoint.x,
        y: (1 - position) * this.fromPoint.y + position * this.toPoint.y
      };
    }
    /** @inheritDoc */

  }, {
    key: "_findBorderPosition",
    value: function _findBorderPosition(nearNode, ctx) {
      var node1 = this.to;
      var node2 = this.from;

      if (nearNode.id === this.from.id) {
        node1 = this.from;
        node2 = this.to;
      }

      var angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
      var dx = node1.x - node2.x;
      var dy = node1.y - node2.y;
      var edgeSegmentLength = Math.sqrt(dx * dx + dy * dy);
      var toBorderDist = nearNode.distanceToBorder(ctx, angle);
      var toBorderPoint = (edgeSegmentLength - toBorderDist) / edgeSegmentLength;
      return {
        x: (1 - toBorderPoint) * node2.x + toBorderPoint * node1.x,
        y: (1 - toBorderPoint) * node2.y + toBorderPoint * node1.y,
        t: 0
      };
    }
    /** @inheritDoc */

  }, {
    key: "_getDistanceToEdge",
    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
      // x3,y3 is the point
      return this._getDistanceToLine(x1, y1, x2, y2, x3, y3);
    }
  }]);

  return StraightEdge;
}(EdgeBase);

/**
 * An edge connects two nodes and has a specific direction.
 */

var Edge = /*#__PURE__*/function () {
  /**
   * @param {object} options        values specific to this edge, must contain at least 'from' and 'to'
   * @param {object} body           shared state from Network instance
   * @param {Network.Images} imagelist  A list with images. Only needed when the edge has image arrows.
   * @param {object} globalOptions  options from the EdgesHandler instance
   * @param {object} defaultOptions default options from the EdgeHandler instance. Value and reference are constant
   */
  function Edge(options, body, imagelist, globalOptions, defaultOptions) {
    _classCallCheck(this, Edge);

    if (body === undefined) {
      throw new Error("No body provided");
    } // Since globalOptions is constant in values as well as reference,
    // Following needs to be done only once.


    this.options = bridgeObject(globalOptions);
    this.globalOptions = globalOptions;
    this.defaultOptions = defaultOptions;
    this.body = body;
    this.imagelist = imagelist; // initialize variables

    this.id = undefined;
    this.fromId = undefined;
    this.toId = undefined;
    this.selected = false;
    this.hover = false;
    this.labelDirty = true;
    this.baseWidth = this.options.width;
    this.baseFontSize = this.options.font.size;
    this.from = undefined; // a node

    this.to = undefined; // a node

    this.edgeType = undefined;
    this.connected = false;
    this.labelModule = new Label(this.body, this.options, true
    /* It's an edge label */
    );
    this.setOptions(options);
  }
  /**
   * Set or overwrite options for the edge
   *
   * @param {object} options  an object with options
   * @returns {undefined|boolean} undefined if no options, true if layout affecting data changed, false otherwise.
   */


  _createClass(Edge, [{
    key: "setOptions",
    value: function setOptions(options) {
      if (!options) {
        return;
      } // Following options if changed affect the layout.


      var affectsLayout = typeof options.physics !== "undefined" && this.options.physics !== options.physics || typeof options.hidden !== "undefined" && (this.options.hidden || false) !== (options.hidden || false) || typeof options.from !== "undefined" && this.options.from !== options.from || typeof options.to !== "undefined" && this.options.to !== options.to;
      Edge.parseOptions(this.options, options, true, this.globalOptions);

      if (options.id !== undefined) {
        this.id = options.id;
      }

      if (options.from !== undefined) {
        this.fromId = options.from;
      }

      if (options.to !== undefined) {
        this.toId = options.to;
      }

      if (options.title !== undefined) {
        this.title = options.title;
      }

      if (options.value !== undefined) {
        options.value = _parseFloat(options.value);
      }

      var pile = [options, this.options, this.defaultOptions];
      this.chooser = choosify("edge", pile); // update label Module

      this.updateLabelModule(options); // Update edge type, this if changed affects the layout.

      affectsLayout = this.updateEdgeType() || affectsLayout; // if anything has been updates, reset the selection width and the hover width

      this._setInteractionWidths(); // A node is connected when it has a from and to node that both exist in the network.body.nodes.


      this.connect();
      return affectsLayout;
    }
    /**
     *
     * @param {object} parentOptions
     * @param {object} newOptions
     * @param {boolean} [allowDeletion=false]
     * @param {object} [globalOptions={}]
     * @param {boolean} [copyFromGlobals=false]
     */

  }, {
    key: "getFormattingValues",
    value:
    /**
     *
     * @returns {ArrowOptions}
     */
    function getFormattingValues() {
      var toArrow = this.options.arrows.to === true || this.options.arrows.to.enabled === true;
      var fromArrow = this.options.arrows.from === true || this.options.arrows.from.enabled === true;
      var middleArrow = this.options.arrows.middle === true || this.options.arrows.middle.enabled === true;
      var inheritsColor = this.options.color.inherit;
      var values = {
        toArrow: toArrow,
        toArrowScale: this.options.arrows.to.scaleFactor,
        toArrowType: this.options.arrows.to.type,
        toArrowSrc: this.options.arrows.to.src,
        toArrowImageWidth: this.options.arrows.to.imageWidth,
        toArrowImageHeight: this.options.arrows.to.imageHeight,
        middleArrow: middleArrow,
        middleArrowScale: this.options.arrows.middle.scaleFactor,
        middleArrowType: this.options.arrows.middle.type,
        middleArrowSrc: this.options.arrows.middle.src,
        middleArrowImageWidth: this.options.arrows.middle.imageWidth,
        middleArrowImageHeight: this.options.arrows.middle.imageHeight,
        fromArrow: fromArrow,
        fromArrowScale: this.options.arrows.from.scaleFactor,
        fromArrowType: this.options.arrows.from.type,
        fromArrowSrc: this.options.arrows.from.src,
        fromArrowImageWidth: this.options.arrows.from.imageWidth,
        fromArrowImageHeight: this.options.arrows.from.imageHeight,
        arrowStrikethrough: this.options.arrowStrikethrough,
        color: inheritsColor ? undefined : this.options.color.color,
        inheritsColor: inheritsColor,
        opacity: this.options.color.opacity,
        hidden: this.options.hidden,
        length: this.options.length,
        shadow: this.options.shadow.enabled,
        shadowColor: this.options.shadow.color,
        shadowSize: this.options.shadow.size,
        shadowX: this.options.shadow.x,
        shadowY: this.options.shadow.y,
        dashes: this.options.dashes,
        width: this.options.width,
        background: this.options.background.enabled,
        backgroundColor: this.options.background.color,
        backgroundSize: this.options.background.size,
        backgroundDashes: this.options.background.dashes
      };

      if (this.selected || this.hover) {
        if (this.chooser === true) {
          if (this.selected) {
            var selectedWidth = this.options.selectionWidth;

            if (typeof selectedWidth === "function") {
              values.width = selectedWidth(values.width);
            } else if (typeof selectedWidth === "number") {
              values.width += selectedWidth;
            }

            values.width = Math.max(values.width, 0.3 / this.body.view.scale);
            values.color = this.options.color.highlight;
            values.shadow = this.options.shadow.enabled;
          } else if (this.hover) {
            var hoverWidth = this.options.hoverWidth;

            if (typeof hoverWidth === "function") {
              values.width = hoverWidth(values.width);
            } else if (typeof hoverWidth === "number") {
              values.width += hoverWidth;
            }

            values.width = Math.max(values.width, 0.3 / this.body.view.scale);
            values.color = this.options.color.hover;
            values.shadow = this.options.shadow.enabled;
          }
        } else if (typeof this.chooser === "function") {
          this.chooser(values, this.options.id, this.selected, this.hover);

          if (values.color !== undefined) {
            values.inheritsColor = false;
          }

          if (values.shadow === false) {
            if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
              values.shadow = true;
            }
          }
        }
      } else {
        values.shadow = this.options.shadow.enabled;
        values.width = Math.max(values.width, 0.3 / this.body.view.scale);
      }

      return values;
    }
    /**
     * update the options in the label module
     *
     * @param {object} options
     */

  }, {
    key: "updateLabelModule",
    value: function updateLabelModule(options) {
      var pile = [options, this.options, this.globalOptions, // Currently set global edge options
      this.defaultOptions];
      this.labelModule.update(this.options, pile);

      if (this.labelModule.baseSize !== undefined) {
        this.baseFontSize = this.labelModule.baseSize;
      }
    }
    /**
     * update the edge type, set the options
     *
     * @returns {boolean}
     */

  }, {
    key: "updateEdgeType",
    value: function updateEdgeType() {
      var smooth = this.options.smooth;
      var dataChanged = false;
      var changeInType = true;

      if (this.edgeType !== undefined) {
        if (this.edgeType instanceof BezierEdgeDynamic && smooth.enabled === true && smooth.type === "dynamic" || this.edgeType instanceof CubicBezierEdge && smooth.enabled === true && smooth.type === "cubicBezier" || this.edgeType instanceof BezierEdgeStatic && smooth.enabled === true && smooth.type !== "dynamic" && smooth.type !== "cubicBezier" || this.edgeType instanceof StraightEdge && smooth.type.enabled === false) {
          changeInType = false;
        }

        if (changeInType === true) {
          dataChanged = this.cleanup();
        }
      }

      if (changeInType === true) {
        if (smooth.enabled === true) {
          if (smooth.type === "dynamic") {
            dataChanged = true;
            this.edgeType = new BezierEdgeDynamic(this.options, this.body, this.labelModule);
          } else if (smooth.type === "cubicBezier") {
            this.edgeType = new CubicBezierEdge(this.options, this.body, this.labelModule);
          } else {
            this.edgeType = new BezierEdgeStatic(this.options, this.body, this.labelModule);
          }
        } else {
          this.edgeType = new StraightEdge(this.options, this.body, this.labelModule);
        }
      } else {
        // if nothing changes, we just set the options.
        this.edgeType.setOptions(this.options);
      }

      return dataChanged;
    }
    /**
     * Connect an edge to its nodes
     */

  }, {
    key: "connect",
    value: function connect() {
      this.disconnect();
      this.from = this.body.nodes[this.fromId] || undefined;
      this.to = this.body.nodes[this.toId] || undefined;
      this.connected = this.from !== undefined && this.to !== undefined;

      if (this.connected === true) {
        this.from.attachEdge(this);
        this.to.attachEdge(this);
      } else {
        if (this.from) {
          this.from.detachEdge(this);
        }

        if (this.to) {
          this.to.detachEdge(this);
        }
      }

      this.edgeType.connect();
    }
    /**
     * Disconnect an edge from its nodes
     */

  }, {
    key: "disconnect",
    value: function disconnect() {
      if (this.from) {
        this.from.detachEdge(this);
        this.from = undefined;
      }

      if (this.to) {
        this.to.detachEdge(this);
        this.to = undefined;
      }

      this.connected = false;
    }
    /**
     * get the title of this edge.
     *
     * @returns {string} title    The title of the edge, or undefined when no title
     *                           has been set.
     */

  }, {
    key: "getTitle",
    value: function getTitle() {
      return this.title;
    }
    /**
     * check if this node is selecte
     *
     * @returns {boolean} selected   True if node is selected, else false
     */

  }, {
    key: "isSelected",
    value: function isSelected() {
      return this.selected;
    }
    /**
     * Retrieve the value of the edge. Can be undefined
     *
     * @returns {number} value
     */

  }, {
    key: "getValue",
    value: function getValue() {
      return this.options.value;
    }
    /**
     * Adjust the value range of the edge. The edge will adjust it's width
     * based on its value.
     *
     * @param {number} min
     * @param {number} max
     * @param {number} total
     */

  }, {
    key: "setValueRange",
    value: function setValueRange(min, max, total) {
      if (this.options.value !== undefined) {
        var scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
        var widthDiff = this.options.scaling.max - this.options.scaling.min;

        if (this.options.scaling.label.enabled === true) {
          var fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
          this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
        }

        this.options.width = this.options.scaling.min + scale * widthDiff;
      } else {
        this.options.width = this.baseWidth;
        this.options.font.size = this.baseFontSize;
      }

      this._setInteractionWidths();

      this.updateLabelModule();
    }
    /**
     *
     * @private
     */

  }, {
    key: "_setInteractionWidths",
    value: function _setInteractionWidths() {
      if (typeof this.options.hoverWidth === "function") {
        this.edgeType.hoverWidth = this.options.hoverWidth(this.options.width);
      } else {
        this.edgeType.hoverWidth = this.options.hoverWidth + this.options.width;
      }

      if (typeof this.options.selectionWidth === "function") {
        this.edgeType.selectionWidth = this.options.selectionWidth(this.options.width);
      } else {
        this.edgeType.selectionWidth = this.options.selectionWidth + this.options.width;
      }
    }
    /**
     * Redraw a edge
     * Draw this edge in the given canvas
     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
     *
     * @param {CanvasRenderingContext2D}   ctx
     */

  }, {
    key: "draw",
    value: function draw(ctx) {
      var values = this.getFormattingValues();

      if (values.hidden) {
        return;
      } // get the via node from the edge type


      var viaNode = this.edgeType.getViaNode(); // draw line and label

      this.edgeType.drawLine(ctx, values, this.selected, this.hover, viaNode);
      this.drawLabel(ctx, viaNode);
    }
    /**
     * Redraw arrows
     * Draw this arrows in the given canvas
     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
     *
     * @param {CanvasRenderingContext2D}   ctx
     */

  }, {
    key: "drawArrows",
    value: function drawArrows(ctx) {
      var values = this.getFormattingValues();

      if (values.hidden) {
        return;
      } // get the via node from the edge type


      var viaNode = this.edgeType.getViaNode();
      var arrowData = {}; // restore edge targets to defaults

      this.edgeType.fromPoint = this.edgeType.from;
      this.edgeType.toPoint = this.edgeType.to; // from and to arrows give a different end point for edges. we set them here

      if (values.fromArrow) {
        arrowData.from = this.edgeType.getArrowData(ctx, "from", viaNode, this.selected, this.hover, values);
        if (values.arrowStrikethrough === false) this.edgeType.fromPoint = arrowData.from.core;

        if (values.fromArrowSrc) {
          arrowData.from.image = this.imagelist.load(values.fromArrowSrc);
        }

        if (values.fromArrowImageWidth) {
          arrowData.from.imageWidth = values.fromArrowImageWidth;
        }

        if (values.fromArrowImageHeight) {
          arrowData.from.imageHeight = values.fromArrowImageHeight;
        }
      }

      if (values.toArrow) {
        arrowData.to = this.edgeType.getArrowData(ctx, "to", viaNode, this.selected, this.hover, values);
        if (values.arrowStrikethrough === false) this.edgeType.toPoint = arrowData.to.core;

        if (values.toArrowSrc) {
          arrowData.to.image = this.imagelist.load(values.toArrowSrc);
        }

        if (values.toArrowImageWidth) {
          arrowData.to.imageWidth = values.toArrowImageWidth;
        }

        if (values.toArrowImageHeight) {
          arrowData.to.imageHeight = values.toArrowImageHeight;
        }
      } // the middle arrow depends on the line, which can depend on the to and from arrows so we do this one lastly.


      if (values.middleArrow) {
        arrowData.middle = this.edgeType.getArrowData(ctx, "middle", viaNode, this.selected, this.hover, values);

        if (values.middleArrowSrc) {
          arrowData.middle.image = this.imagelist.load(values.middleArrowSrc);
        }

        if (values.middleArrowImageWidth) {
          arrowData.middle.imageWidth = values.middleArrowImageWidth;
        }

        if (values.middleArrowImageHeight) {
          arrowData.middle.imageHeight = values.middleArrowImageHeight;
        }
      }

      if (values.fromArrow) {
        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.from);
      }

      if (values.middleArrow) {
        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.middle);
      }

      if (values.toArrow) {
        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.to);
      }
    }
    /**
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {Node} viaNode
     */

  }, {
    key: "drawLabel",
    value: function drawLabel(ctx, viaNode) {
      if (this.options.label !== undefined) {
        // set style
        var node1 = this.from;
        var node2 = this.to;

        if (this.labelModule.differentState(this.selected, this.hover)) {
          this.labelModule.getTextSize(ctx, this.selected, this.hover);
        }

        var point;

        if (node1.id != node2.id) {
          this.labelModule.pointToSelf = false;
          point = this.edgeType.getPoint(0.5, viaNode);
          ctx.save();

          var rotationPoint = this._getRotation(ctx);

          if (rotationPoint.angle != 0) {
            ctx.translate(rotationPoint.x, rotationPoint.y);
            ctx.rotate(rotationPoint.angle);
          } // draw the label


          this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);
          /*
          // Useful debug code: draw a border around the label
          // This should **not** be enabled in production!
          var size = this.labelModule.getSize();; // ;; intentional so lint catches it
          ctx.strokeStyle = "#ff0000";
          ctx.strokeRect(size.left, size.top, size.width, size.height);
          // End  debug code
          */

          ctx.restore();
        } else {
          // Ignore the orientations.
          this.labelModule.pointToSelf = true; // get circle coordinates

          var coordinates = getSelfRefCoordinates(ctx, this.options.selfReference.angle, this.options.selfReference.size, node1);
          point = this._pointOnCircle(coordinates.x, coordinates.y, this.options.selfReference.size, this.options.selfReference.angle);
          this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);
        }
      }
    }
    /**
     * Determine all visual elements of this edge instance, in which the given
     * point falls within the bounding shape.
     *
     * @param {point} point
     * @returns {Array.<edgeClickItem|edgeLabelClickItem>} list with the items which are on the point
     */

  }, {
    key: "getItemsOnPoint",
    value: function getItemsOnPoint(point) {
      var ret = [];

      if (this.labelModule.visible()) {
        var rotationPoint = this._getRotation();

        if (pointInRect(this.labelModule.getSize(), point, rotationPoint)) {
          ret.push({
            edgeId: this.id,
            labelId: 0
          });
        }
      }

      var obj = {
        left: point.x,
        top: point.y
      };

      if (this.isOverlappingWith(obj)) {
        ret.push({
          edgeId: this.id
        });
      }

      return ret;
    }
    /**
     * Check if this object is overlapping with the provided object
     *
     * @param {object} obj   an object with parameters left, top
     * @returns {boolean}     True if location is located on the edge
     */

  }, {
    key: "isOverlappingWith",
    value: function isOverlappingWith(obj) {
      if (this.connected) {
        var distMax = 10;
        var xFrom = this.from.x;
        var yFrom = this.from.y;
        var xTo = this.to.x;
        var yTo = this.to.y;
        var xObj = obj.left;
        var yObj = obj.top;
        var dist = this.edgeType.getDistanceToEdge(xFrom, yFrom, xTo, yTo, xObj, yObj);
        return dist < distMax;
      } else {
        return false;
      }
    }
    /**
     * Determine the rotation point, if any.
     *
     * @param {CanvasRenderingContext2D} [ctx] if passed, do a recalculation of the label size
     * @returns {rotationPoint} the point to rotate around and the angle in radians to rotate
     * @private
     */

  }, {
    key: "_getRotation",
    value: function _getRotation(ctx) {
      var viaNode = this.edgeType.getViaNode();
      var point = this.edgeType.getPoint(0.5, viaNode);

      if (ctx !== undefined) {
        this.labelModule.calculateLabelSize(ctx, this.selected, this.hover, point.x, point.y);
      }

      var ret = {
        x: point.x,
        y: this.labelModule.size.yLine,
        angle: 0
      };

      if (!this.labelModule.visible()) {
        return ret; // Don't even bother doing the atan2, there's nothing to draw
      }

      if (this.options.font.align === "horizontal") {
        return ret; // No need to calculate angle
      }

      var dy = this.from.y - this.to.y;
      var dx = this.from.x - this.to.x;
      var angle = Math.atan2(dy, dx); // radians
      // rotate so that label is readable

      if (angle < -1 && dx < 0 || angle > 0 && dx < 0) {
        angle += Math.PI;
      }

      ret.angle = angle;
      return ret;
    }
    /**
     * Get a point on a circle
     *
     * @param {number} x
     * @param {number} y
     * @param {number} radius
     * @param {number} angle
     * @returns {object} point
     * @private
     */

  }, {
    key: "_pointOnCircle",
    value: function _pointOnCircle(x, y, radius, angle) {
      return {
        x: x + radius * Math.cos(angle),
        y: y - radius * Math.sin(angle)
      };
    }
    /**
     * Sets selected state to true
     */

  }, {
    key: "select",
    value: function select() {
      this.selected = true;
    }
    /**
     * Sets selected state to false
     */

  }, {
    key: "unselect",
    value: function unselect() {
      this.selected = false;
    }
    /**
     * cleans all required things on delete
     *
     * @returns {*}
     */

  }, {
    key: "cleanup",
    value: function cleanup() {
      return this.edgeType.cleanup();
    }
    /**
     * Remove edge from the list and perform necessary cleanup.
     */

  }, {
    key: "remove",
    value: function remove() {
      this.cleanup();
      this.disconnect();
      delete this.body.edges[this.id];
    }
    /**
     * Check if both connecting nodes exist
     *
     * @returns {boolean}
     */

  }, {
    key: "endPointsValid",
    value: function endPointsValid() {
      return this.body.nodes[this.fromId] !== undefined && this.body.nodes[this.toId] !== undefined;
    }
  }], [{
    key: "parseOptions",
    value: function parseOptions(parentOptions, newOptions) {
      var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var copyFromGlobals = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
      var fields = ["endPointOffset", "arrowStrikethrough", "id", "from", "hidden", "hoverWidth", "labelHighlightBold", "length", "line", "opacity", "physics", "scaling", "selectionWidth", "selfReferenceSize", "selfReference", "to", "title", "value", "width", "font", "chosen", "widthConstraint"]; // only deep extend the items in the field array. These do not have shorthand.

      selectiveDeepExtend(fields, parentOptions, newOptions, allowDeletion); // Only use endPointOffset values (from and to) if it's valid values

      if (newOptions.endPointOffset !== undefined && newOptions.endPointOffset.from !== undefined) {
        if (_isFinite(newOptions.endPointOffset.from)) {
          parentOptions.endPointOffset.from = newOptions.endPointOffset.from;
        } else {
          parentOptions.endPointOffset.from = globalOptions.endPointOffset.from !== undefined ? globalOptions.endPointOffset.from : 0;
          console.error("endPointOffset.from is not a valid number");
        }
      }

      if (newOptions.endPointOffset !== undefined && newOptions.endPointOffset.to !== undefined) {
        if (_isFinite(newOptions.endPointOffset.to)) {
          parentOptions.endPointOffset.to = newOptions.endPointOffset.to;
        } else {
          parentOptions.endPointOffset.to = globalOptions.endPointOffset.to !== undefined ? globalOptions.endPointOffset.to : 0;
          console.error("endPointOffset.to is not a valid number");
        }
      } // Only copy label if it's a legal value.


      if (isValidLabel(newOptions.label)) {
        parentOptions.label = newOptions.label;
      } else if (!isValidLabel(parentOptions.label)) {
        parentOptions.label = undefined;
      }

      mergeOptions(parentOptions, newOptions, "smooth", globalOptions);
      mergeOptions(parentOptions, newOptions, "shadow", globalOptions);
      mergeOptions(parentOptions, newOptions, "background", globalOptions);

      if (newOptions.dashes !== undefined && newOptions.dashes !== null) {
        parentOptions.dashes = newOptions.dashes;
      } else if (allowDeletion === true && newOptions.dashes === null) {
        parentOptions.dashes = create$4(globalOptions.dashes); // this sets the pointer of the option back to the global option.
      } // set the scaling newOptions


      if (newOptions.scaling !== undefined && newOptions.scaling !== null) {
        if (newOptions.scaling.min !== undefined) {
          parentOptions.scaling.min = newOptions.scaling.min;
        }

        if (newOptions.scaling.max !== undefined) {
          parentOptions.scaling.max = newOptions.scaling.max;
        }

        mergeOptions(parentOptions.scaling, newOptions.scaling, "label", globalOptions.scaling);
      } else if (allowDeletion === true && newOptions.scaling === null) {
        parentOptions.scaling = create$4(globalOptions.scaling); // this sets the pointer of the option back to the global option.
      } // handle multiple input cases for arrows


      if (newOptions.arrows !== undefined && newOptions.arrows !== null) {
        if (typeof newOptions.arrows === "string") {
          var arrows = newOptions.arrows.toLowerCase();
          parentOptions.arrows.to.enabled = indexOf(arrows).call(arrows, "to") != -1;
          parentOptions.arrows.middle.enabled = indexOf(arrows).call(arrows, "middle") != -1;
          parentOptions.arrows.from.enabled = indexOf(arrows).call(arrows, "from") != -1;
        } else if (_typeof(newOptions.arrows) === "object") {
          mergeOptions(parentOptions.arrows, newOptions.arrows, "to", globalOptions.arrows);
          mergeOptions(parentOptions.arrows, newOptions.arrows, "middle", globalOptions.arrows);
          mergeOptions(parentOptions.arrows, newOptions.arrows, "from", globalOptions.arrows);
        } else {
          throw new Error("The arrow newOptions can only be an object or a string. Refer to the documentation. You used:" + stringify$1(newOptions.arrows));
        }
      } else if (allowDeletion === true && newOptions.arrows === null) {
        parentOptions.arrows = create$4(globalOptions.arrows); // this sets the pointer of the option back to the global option.
      } // handle multiple input cases for color


      if (newOptions.color !== undefined && newOptions.color !== null) {
        var fromColor = isString(newOptions.color) ? {
          color: newOptions.color,
          highlight: newOptions.color,
          hover: newOptions.color,
          inherit: false,
          opacity: 1
        } : newOptions.color;
        var toColor = parentOptions.color; // If passed, fill in values from default options - required in the case of no prototype bridging

        if (copyFromGlobals) {
          deepExtend(toColor, globalOptions.color, false, allowDeletion);
        } else {
          // Clear local properties - need to do it like this in order to retain prototype bridges
          for (var i in toColor) {
            if (Object.prototype.hasOwnProperty.call(toColor, i)) {
              delete toColor[i];
            }
          }
        }

        if (isString(toColor)) {
          toColor.color = toColor;
          toColor.highlight = toColor;
          toColor.hover = toColor;
          toColor.inherit = false;

          if (fromColor.opacity === undefined) {
            toColor.opacity = 1.0; // set default
          }
        } else {
          var colorsDefined = false;

          if (fromColor.color !== undefined) {
            toColor.color = fromColor.color;
            colorsDefined = true;
          }

          if (fromColor.highlight !== undefined) {
            toColor.highlight = fromColor.highlight;
            colorsDefined = true;
          }

          if (fromColor.hover !== undefined) {
            toColor.hover = fromColor.hover;
            colorsDefined = true;
          }

          if (fromColor.inherit !== undefined) {
            toColor.inherit = fromColor.inherit;
          }

          if (fromColor.opacity !== undefined) {
            toColor.opacity = Math.min(1, Math.max(0, fromColor.opacity));
          }

          if (colorsDefined === true) {
            toColor.inherit = false;
          } else {
            if (toColor.inherit === undefined) {
              toColor.inherit = "from"; // Set default
            }
          }
        }
      } else if (allowDeletion === true && newOptions.color === null) {
        parentOptions.color = bridgeObject(globalOptions.color); // set the object back to the global options
      }

      if (allowDeletion === true && newOptions.font === null) {
        parentOptions.font = bridgeObject(globalOptions.font); // set the object back to the global options
      }

      if (Object.prototype.hasOwnProperty.call(newOptions, "selfReferenceSize")) {
        console.warn("The selfReferenceSize property has been deprecated. Please use selfReference property instead. The selfReference can be set like thise selfReference:{size:30, angle:Math.PI / 4}");
        parentOptions.selfReference.size = newOptions.selfReferenceSize;
      }
    }
  }]);

  return Edge;
}();

/**
 * Handler for Edges
 */

var EdgesHandler = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {Array.<Image>} images
   * @param {Array.<Group>} groups
   */
  function EdgesHandler(body, images, groups) {
    var _context,
        _this = this;

    _classCallCheck(this, EdgesHandler);

    this.body = body;
    this.images = images;
    this.groups = groups; // create the edge API in the body container

    this.body.functions.createEdge = bind$6(_context = this.create).call(_context, this);
    this.edgesListeners = {
      add: function add(event, params) {
        _this.add(params.items);
      },
      update: function update(event, params) {
        _this.update(params.items);
      },
      remove: function remove(event, params) {
        _this.remove(params.items);
      }
    };
    this.options = {};
    this.defaultOptions = {
      arrows: {
        to: {
          enabled: false,
          scaleFactor: 1,
          type: "arrow"
        },
        // boolean / {arrowScaleFactor:1} / {enabled: false, arrowScaleFactor:1}
        middle: {
          enabled: false,
          scaleFactor: 1,
          type: "arrow"
        },
        from: {
          enabled: false,
          scaleFactor: 1,
          type: "arrow"
        }
      },
      endPointOffset: {
        from: 0,
        to: 0
      },
      arrowStrikethrough: true,
      color: {
        color: "#848484",
        highlight: "#848484",
        hover: "#848484",
        inherit: "from",
        opacity: 1.0
      },
      dashes: false,
      font: {
        color: "#343434",
        size: 14,
        // px
        face: "arial",
        background: "none",
        strokeWidth: 2,
        // px
        strokeColor: "#ffffff",
        align: "horizontal",
        multi: false,
        vadjust: 0,
        bold: {
          mod: "bold"
        },
        boldital: {
          mod: "bold italic"
        },
        ital: {
          mod: "italic"
        },
        mono: {
          mod: "",
          size: 15,
          // px
          face: "courier new",
          vadjust: 2
        }
      },
      hidden: false,
      hoverWidth: 1.5,
      label: undefined,
      labelHighlightBold: true,
      length: undefined,
      physics: true,
      scaling: {
        min: 1,
        max: 15,
        label: {
          enabled: true,
          min: 14,
          max: 30,
          maxVisible: 30,
          drawThreshold: 5
        },
        customScalingFunction: function customScalingFunction(min, max, total, value) {
          if (max === min) {
            return 0.5;
          } else {
            var scale = 1 / (max - min);
            return Math.max(0, (value - min) * scale);
          }
        }
      },
      selectionWidth: 1.5,
      selfReference: {
        size: 20,
        angle: Math.PI / 4,
        renderBehindTheNode: true
      },
      shadow: {
        enabled: false,
        color: "rgba(0,0,0,0.5)",
        size: 10,
        x: 5,
        y: 5
      },
      background: {
        enabled: false,
        color: "rgba(111,111,111,1)",
        size: 10,
        dashes: false
      },
      smooth: {
        enabled: true,
        type: "dynamic",
        forceDirection: "none",
        roundness: 0.5
      },
      title: undefined,
      width: 1,
      value: undefined
    };
    deepExtend(this.options, this.defaultOptions);
    this.bindEventListeners();
  }
  /**
   * Binds event listeners
   */


  _createClass(EdgesHandler, [{
    key: "bindEventListeners",
    value: function bindEventListeners() {
      var _this2 = this,
          _context2,
          _context3;

      // this allows external modules to force all dynamic curves to turn static.
      this.body.emitter.on("_forceDisableDynamicCurves", function (type) {
        var emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

        if (type === "dynamic") {
          type = "continuous";
        }

        var dataChanged = false;

        for (var edgeId in _this2.body.edges) {
          if (Object.prototype.hasOwnProperty.call(_this2.body.edges, edgeId)) {
            var edge = _this2.body.edges[edgeId];

            var edgeData = _this2.body.data.edges.get(edgeId); // only forcibly remove the smooth curve if the data has been set of the edge has the smooth curves defined.
            // this is because a change in the global would not affect these curves.


            if (edgeData != null) {
              var smoothOptions = edgeData.smooth;

              if (smoothOptions !== undefined) {
                if (smoothOptions.enabled === true && smoothOptions.type === "dynamic") {
                  if (type === undefined) {
                    edge.setOptions({
                      smooth: false
                    });
                  } else {
                    edge.setOptions({
                      smooth: {
                        type: type
                      }
                    });
                  }

                  dataChanged = true;
                }
              }
            }
          }
        }

        if (emit === true && dataChanged === true) {
          _this2.body.emitter.emit("_dataChanged");
        }
      }); // this is called when options of EXISTING nodes or edges have changed.
      //
      // NOTE: Not true, called when options have NOT changed, for both existing as well as new nodes.
      //       See update() for logic.
      // TODO: Verify and examine the consequences of this. It might still trigger when
      //       non-option fields have changed, but then reconnecting edges is still useless.
      //       Alternatively, it might also be called when edges are removed.
      //

      this.body.emitter.on("_dataUpdated", function () {
        _this2.reconnectEdges();
      }); // refresh the edges. Used when reverting from hierarchical layout

      this.body.emitter.on("refreshEdges", bind$6(_context2 = this.refresh).call(_context2, this));
      this.body.emitter.on("refresh", bind$6(_context3 = this.refresh).call(_context3, this));
      this.body.emitter.on("destroy", function () {
        forEach$1(_this2.edgesListeners, function (callback, event) {
          if (_this2.body.data.edges) _this2.body.data.edges.off(event, callback);
        });
        delete _this2.body.functions.createEdge;
        delete _this2.edgesListeners.add;
        delete _this2.edgesListeners.update;
        delete _this2.edgesListeners.remove;
        delete _this2.edgesListeners;
      });
    }
    /**
     *
     * @param {object} options
     */

  }, {
    key: "setOptions",
    value: function setOptions(options) {
      if (options !== undefined) {
        // use the parser from the Edge class to fill in all shorthand notations
        Edge.parseOptions(this.options, options, true, this.defaultOptions, true); // update smooth settings in all edges

        var dataChanged = false;

        if (options.smooth !== undefined) {
          for (var edgeId in this.body.edges) {
            if (Object.prototype.hasOwnProperty.call(this.body.edges, edgeId)) {
              dataChanged = this.body.edges[edgeId].updateEdgeType() || dataChanged;
            }
          }
        } // update fonts in all edges


        if (options.font !== undefined) {
          for (var _edgeId in this.body.edges) {
            if (Object.prototype.hasOwnProperty.call(this.body.edges, _edgeId)) {
              this.body.edges[_edgeId].updateLabelModule();
            }
          }
        } // update the state of the variables if needed


        if (options.hidden !== undefined || options.physics !== undefined || dataChanged === true) {
          this.body.emitter.emit("_dataChanged");
        }
      }
    }
    /**
     * Load edges by reading the data table
     *
     * @param {Array | DataSet | DataView} edges    The data containing the edges.
     * @param {boolean} [doNotEmit=false] - Suppress data changed event.
     * @private
     */

  }, {
    key: "setData",
    value: function setData(edges) {
      var _this3 = this;

      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var oldEdgesData = this.body.data.edges;

      if (isDataViewLike("id", edges)) {
        this.body.data.edges = edges;
      } else if (isArray$2(edges)) {
        this.body.data.edges = new DataSet();
        this.body.data.edges.add(edges);
      } else if (!edges) {
        this.body.data.edges = new DataSet();
      } else {
        throw new TypeError("Array or DataSet expected");
      } // TODO: is this null or undefined or false?


      if (oldEdgesData) {
        // unsubscribe from old dataset
        forEach$1(this.edgesListeners, function (callback, event) {
          oldEdgesData.off(event, callback);
        });
      } // remove drawn edges


      this.body.edges = {}; // TODO: is this null or undefined or false?

      if (this.body.data.edges) {
        // subscribe to new dataset
        forEach$1(this.edgesListeners, function (callback, event) {
          _this3.body.data.edges.on(event, callback);
        }); // draw all new nodes

        var ids = this.body.data.edges.getIds();
        this.add(ids, true);
      }

      this.body.emitter.emit("_adjustEdgesForHierarchicalLayout");

      if (doNotEmit === false) {
        this.body.emitter.emit("_dataChanged");
      }
    }
    /**
     * Add edges
     *
     * @param {number[] | string[]} ids
     * @param {boolean} [doNotEmit=false]
     * @private
     */

  }, {
    key: "add",
    value: function add(ids) {
      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var edges = this.body.edges;
      var edgesData = this.body.data.edges;

      for (var i = 0; i < ids.length; i++) {
        var id = ids[i];
        var oldEdge = edges[id];

        if (oldEdge) {
          oldEdge.disconnect();
        }

        var data = edgesData.get(id, {
          showInternalIds: true
        });
        edges[id] = this.create(data);
      }

      this.body.emitter.emit("_adjustEdgesForHierarchicalLayout");

      if (doNotEmit === false) {
        this.body.emitter.emit("_dataChanged");
      }
    }
    /**
     * Update existing edges, or create them when not yet existing
     *
     * @param {number[] | string[]} ids
     * @private
     */

  }, {
    key: "update",
    value: function update(ids) {
      var edges = this.body.edges;
      var edgesData = this.body.data.edges;
      var dataChanged = false;

      for (var i = 0; i < ids.length; i++) {
        var id = ids[i];
        var data = edgesData.get(id);
        var edge = edges[id];

        if (edge !== undefined) {
          // update edge
          edge.disconnect();
          dataChanged = edge.setOptions(data) || dataChanged; // if a support node is added, data can be changed.

          edge.connect();
        } else {
          // create edge
          this.body.edges[id] = this.create(data);
          dataChanged = true;
        }
      }

      if (dataChanged === true) {
        this.body.emitter.emit("_adjustEdgesForHierarchicalLayout");
        this.body.emitter.emit("_dataChanged");
      } else {
        this.body.emitter.emit("_dataUpdated");
      }
    }
    /**
     * Remove existing edges. Non existing ids will be ignored
     *
     * @param {number[] | string[]} ids
     * @param {boolean} [emit=true]
     * @private
     */

  }, {
    key: "remove",
    value: function remove(ids) {
      var emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      if (ids.length === 0) return; // early out

      var edges = this.body.edges;
      forEach$1(ids, function (id) {
        var edge = edges[id];

        if (edge !== undefined) {
          edge.remove();
        }
      });

      if (emit) {
        this.body.emitter.emit("_dataChanged");
      }
    }
    /**
     * Refreshes Edge Handler
     */

  }, {
    key: "refresh",
    value: function refresh() {
      var _this4 = this;

      forEach$1(this.body.edges, function (edge, edgeId) {
        var data = _this4.body.data.edges.get(edgeId);

        if (data !== undefined) {
          edge.setOptions(data);
        }
      });
    }
    /**
     *
     * @param {object} properties
     * @returns {Edge}
     */

  }, {
    key: "create",
    value: function create(properties) {
      return new Edge(properties, this.body, this.images, this.options, this.defaultOptions);
    }
    /**
     * Reconnect all edges
     *
     * @private
     */

  }, {
    key: "reconnectEdges",
    value: function reconnectEdges() {
      var id;
      var nodes = this.body.nodes;
      var edges = this.body.edges;

      for (id in nodes) {
        if (Object.prototype.hasOwnProperty.call(nodes, id)) {
          nodes[id].edges = [];
        }
      }

      for (id in edges) {
        if (Object.prototype.hasOwnProperty.call(edges, id)) {
          var edge = edges[id];
          edge.from = null;
          edge.to = null;
          edge.connect();
        }
      }
    }
    /**
     *
     * @param {Edge.id} edgeId
     * @returns {Array}
     */

  }, {
    key: "getConnectedNodes",
    value: function getConnectedNodes(edgeId) {
      var nodeList = [];

      if (this.body.edges[edgeId] !== undefined) {
        var edge = this.body.edges[edgeId];

        if (edge.fromId !== undefined) {
          nodeList.push(edge.fromId);
        }

        if (edge.toId !== undefined) {
          nodeList.push(edge.toId);
        }
      }

      return nodeList;
    }
    /**
     * There is no direct relation between the nodes and the edges DataSet,
     * so the right place to do call this is in the handler for event `_dataUpdated`.
     */

  }, {
    key: "_updateState",
    value: function _updateState() {
      this._addMissingEdges();

      this._removeInvalidEdges();
    }
    /**
     * Scan for missing nodes and remove corresponding edges, if any.
     *
     * @private
     */

  }, {
    key: "_removeInvalidEdges",
    value: function _removeInvalidEdges() {
      var _this5 = this;

      var edgesToDelete = [];
      forEach$1(this.body.edges, function (edge, id) {
        var toNode = _this5.body.nodes[edge.toId];
        var fromNode = _this5.body.nodes[edge.fromId]; // Skip clustering edges here, let the Clustering module handle those

        if (toNode !== undefined && toNode.isCluster === true || fromNode !== undefined && fromNode.isCluster === true) {
          return;
        }

        if (toNode === undefined || fromNode === undefined) {
          edgesToDelete.push(id);
        }
      });
      this.remove(edgesToDelete, false);
    }
    /**
     * add all edges from dataset that are not in the cached state
     *
     * @private
     */

  }, {
    key: "_addMissingEdges",
    value: function _addMissingEdges() {
      var edgesData = this.body.data.edges;

      if (edgesData === undefined || edgesData === null) {
        return; // No edges DataSet yet; can happen on startup
      }

      var edges = this.body.edges;
      var addIds = [];

      forEach$2(edgesData).call(edgesData, function (edgeData, edgeId) {
        var edge = edges[edgeId];

        if (edge === undefined) {
          addIds.push(edgeId);
        }
      });

      this.add(addIds, true);
    }
  }]);

  return EdgesHandler;
}();

/**
 * Barnes Hut Solver
 */

var BarnesHutSolver = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  function BarnesHutSolver(body, physicsBody, options) {
    _classCallCheck(this, BarnesHutSolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.barnesHutTree;
    this.setOptions(options);
    this._rng = Alea("BARNES HUT SOLVER"); // debug: show grid
    // this.body.emitter.on("afterDrawing", (ctx) => {this._debug(ctx,'#ff0000')})
  }
  /**
   *
   * @param {object} options
   */


  _createClass(BarnesHutSolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
      this.thetaInversed = 1 / this.options.theta; // if 1 then min distance = 0.5, if 0.5 then min distance = 0.5 + 0.5*node.shape.radius

      this.overlapAvoidanceFactor = 1 - Math.max(0, Math.min(1, this.options.avoidOverlap));
    }
    /**
     * This function calculates the forces the nodes apply on each other based on a gravitational model.
     * The Barnes Hut method is used to speed up this N-body simulation.
     *
     * @private
     */

  }, {
    key: "solve",
    value: function solve() {
      if (this.options.gravitationalConstant !== 0 && this.physicsBody.physicsNodeIndices.length > 0) {
        var node;
        var nodes = this.body.nodes;
        var nodeIndices = this.physicsBody.physicsNodeIndices;
        var nodeCount = nodeIndices.length; // create the tree

        var barnesHutTree = this._formBarnesHutTree(nodes, nodeIndices); // for debugging


        this.barnesHutTree = barnesHutTree; // place the nodes one by one recursively

        for (var i = 0; i < nodeCount; i++) {
          node = nodes[nodeIndices[i]];

          if (node.options.mass > 0) {
            // starting with root is irrelevant, it never passes the BarnesHutSolver condition
            this._getForceContributions(barnesHutTree.root, node);
          }
        }
      }
    }
    /**
     * @param {object} parentBranch
     * @param {Node} node
     * @private
     */

  }, {
    key: "_getForceContributions",
    value: function _getForceContributions(parentBranch, node) {
      this._getForceContribution(parentBranch.children.NW, node);

      this._getForceContribution(parentBranch.children.NE, node);

      this._getForceContribution(parentBranch.children.SW, node);

      this._getForceContribution(parentBranch.children.SE, node);
    }
    /**
     * This function traverses the barnesHutTree. It checks when it can approximate distant nodes with their center of mass.
     * If a region contains a single node, we check if it is not itself, then we apply the force.
     *
     * @param {object} parentBranch
     * @param {Node} node
     * @private
     */

  }, {
    key: "_getForceContribution",
    value: function _getForceContribution(parentBranch, node) {
      // we get no force contribution from an empty region
      if (parentBranch.childrenCount > 0) {
        // get the distance from the center of mass to the node.
        var dx = parentBranch.centerOfMass.x - node.x;
        var dy = parentBranch.centerOfMass.y - node.y;
        var distance = Math.sqrt(dx * dx + dy * dy); // BarnesHutSolver condition
        // original condition : s/d < theta = passed  ===  d/s > 1/theta = passed
        // calcSize = 1/s --> d * 1/s > 1/theta = passed

        if (distance * parentBranch.calcSize > this.thetaInversed) {
          this._calculateForces(distance, dx, dy, node, parentBranch);
        } else {
          // Did not pass the condition, go into children if available
          if (parentBranch.childrenCount === 4) {
            this._getForceContributions(parentBranch, node);
          } else {
            // parentBranch must have only one node, if it was empty we wouldnt be here
            if (parentBranch.children.data.id != node.id) {
              // if it is not self
              this._calculateForces(distance, dx, dy, node, parentBranch);
            }
          }
        }
      }
    }
    /**
     * Calculate the forces based on the distance.
     *
     * @param {number} distance
     * @param {number} dx
     * @param {number} dy
     * @param {Node} node
     * @param {object} parentBranch
     * @private
     */

  }, {
    key: "_calculateForces",
    value: function _calculateForces(distance, dx, dy, node, parentBranch) {
      if (distance === 0) {
        distance = 0.1;
        dx = distance;
      }

      if (this.overlapAvoidanceFactor < 1 && node.shape.radius) {
        distance = Math.max(0.1 + this.overlapAvoidanceFactor * node.shape.radius, distance - node.shape.radius);
      } // the dividing by the distance cubed instead of squared allows us to get the fx and fy components without sines and cosines
      // it is shorthand for gravityforce with distance squared and fx = dx/distance * gravityForce


      var gravityForce = this.options.gravitationalConstant * parentBranch.mass * node.options.mass / Math.pow(distance, 3);
      var fx = dx * gravityForce;
      var fy = dy * gravityForce;
      this.physicsBody.forces[node.id].x += fx;
      this.physicsBody.forces[node.id].y += fy;
    }
    /**
     * This function constructs the barnesHut tree recursively. It creates the root, splits it and starts placing the nodes.
     *
     * @param {Array.<Node>} nodes
     * @param {Array.<number>} nodeIndices
     * @returns {{root: {centerOfMass: {x: number, y: number}, mass: number, range: {minX: number, maxX: number, minY: number, maxY: number}, size: number, calcSize: number, children: {data: null}, maxWidth: number, level: number, childrenCount: number}}} BarnesHutTree
     * @private
     */

  }, {
    key: "_formBarnesHutTree",
    value: function _formBarnesHutTree(nodes, nodeIndices) {
      var node;
      var nodeCount = nodeIndices.length;
      var minX = nodes[nodeIndices[0]].x;
      var minY = nodes[nodeIndices[0]].y;
      var maxX = nodes[nodeIndices[0]].x;
      var maxY = nodes[nodeIndices[0]].y; // get the range of the nodes

      for (var i = 1; i < nodeCount; i++) {
        var _node = nodes[nodeIndices[i]];
        var x = _node.x;
        var y = _node.y;

        if (_node.options.mass > 0) {
          if (x < minX) {
            minX = x;
          }

          if (x > maxX) {
            maxX = x;
          }

          if (y < minY) {
            minY = y;
          }

          if (y > maxY) {
            maxY = y;
          }
        }
      } // make the range a square


      var sizeDiff = Math.abs(maxX - minX) - Math.abs(maxY - minY); // difference between X and Y

      if (sizeDiff > 0) {
        minY -= 0.5 * sizeDiff;
        maxY += 0.5 * sizeDiff;
      } // xSize > ySize
      else {
        minX += 0.5 * sizeDiff;
        maxX -= 0.5 * sizeDiff;
      } // xSize < ySize


      var minimumTreeSize = 1e-5;
      var rootSize = Math.max(minimumTreeSize, Math.abs(maxX - minX));
      var halfRootSize = 0.5 * rootSize;
      var centerX = 0.5 * (minX + maxX),
          centerY = 0.5 * (minY + maxY); // construct the barnesHutTree

      var barnesHutTree = {
        root: {
          centerOfMass: {
            x: 0,
            y: 0
          },
          mass: 0,
          range: {
            minX: centerX - halfRootSize,
            maxX: centerX + halfRootSize,
            minY: centerY - halfRootSize,
            maxY: centerY + halfRootSize
          },
          size: rootSize,
          calcSize: 1 / rootSize,
          children: {
            data: null
          },
          maxWidth: 0,
          level: 0,
          childrenCount: 4
        }
      };

      this._splitBranch(barnesHutTree.root); // place the nodes one by one recursively


      for (var _i = 0; _i < nodeCount; _i++) {
        node = nodes[nodeIndices[_i]];

        if (node.options.mass > 0) {
          this._placeInTree(barnesHutTree.root, node);
        }
      } // make global


      return barnesHutTree;
    }
    /**
     * this updates the mass of a branch. this is increased by adding a node.
     *
     * @param {object} parentBranch
     * @param {Node} node
     * @private
     */

  }, {
    key: "_updateBranchMass",
    value: function _updateBranchMass(parentBranch, node) {
      var centerOfMass = parentBranch.centerOfMass;
      var totalMass = parentBranch.mass + node.options.mass;
      var totalMassInv = 1 / totalMass;
      centerOfMass.x = centerOfMass.x * parentBranch.mass + node.x * node.options.mass;
      centerOfMass.x *= totalMassInv;
      centerOfMass.y = centerOfMass.y * parentBranch.mass + node.y * node.options.mass;
      centerOfMass.y *= totalMassInv;
      parentBranch.mass = totalMass;
      var biggestSize = Math.max(Math.max(node.height, node.radius), node.width);
      parentBranch.maxWidth = parentBranch.maxWidth < biggestSize ? biggestSize : parentBranch.maxWidth;
    }
    /**
     * determine in which branch the node will be placed.
     *
     * @param {object} parentBranch
     * @param {Node} node
     * @param {boolean} skipMassUpdate
     * @private
     */

  }, {
    key: "_placeInTree",
    value: function _placeInTree(parentBranch, node, skipMassUpdate) {
      if (skipMassUpdate != true || skipMassUpdate === undefined) {
        // update the mass of the branch.
        this._updateBranchMass(parentBranch, node);
      }

      var range = parentBranch.children.NW.range;
      var region;

      if (range.maxX > node.x) {
        // in NW or SW
        if (range.maxY > node.y) {
          region = "NW";
        } else {
          region = "SW";
        }
      } else {
        // in NE or SE
        if (range.maxY > node.y) {
          region = "NE";
        } else {
          region = "SE";
        }
      }

      this._placeInRegion(parentBranch, node, region);
    }
    /**
     * actually place the node in a region (or branch)
     *
     * @param {object} parentBranch
     * @param {Node} node
     * @param {'NW'| 'NE' | 'SW' | 'SE'} region
     * @private
     */

  }, {
    key: "_placeInRegion",
    value: function _placeInRegion(parentBranch, node, region) {
      var children = parentBranch.children[region];

      switch (children.childrenCount) {
        case 0:
          // place node here
          children.children.data = node;
          children.childrenCount = 1;

          this._updateBranchMass(children, node);

          break;

        case 1:
          // convert into children
          // if there are two nodes exactly overlapping (on init, on opening of cluster etc.)
          // we move one node a little bit and we do not put it in the tree.
          if (children.children.data.x === node.x && children.children.data.y === node.y) {
            node.x += this._rng();
            node.y += this._rng();
          } else {
            this._splitBranch(children);

            this._placeInTree(children, node);
          }

          break;

        case 4:
          // place in branch
          this._placeInTree(children, node);

          break;
      }
    }
    /**
     * this function splits a branch into 4 sub branches. If the branch contained a node, we place it in the subbranch
     * after the split is complete.
     *
     * @param {object} parentBranch
     * @private
     */

  }, {
    key: "_splitBranch",
    value: function _splitBranch(parentBranch) {
      // if the branch is shaded with a node, replace the node in the new subset.
      var containedNode = null;

      if (parentBranch.childrenCount === 1) {
        containedNode = parentBranch.children.data;
        parentBranch.mass = 0;
        parentBranch.centerOfMass.x = 0;
        parentBranch.centerOfMass.y = 0;
      }

      parentBranch.childrenCount = 4;
      parentBranch.children.data = null;

      this._insertRegion(parentBranch, "NW");

      this._insertRegion(parentBranch, "NE");

      this._insertRegion(parentBranch, "SW");

      this._insertRegion(parentBranch, "SE");

      if (containedNode != null) {
        this._placeInTree(parentBranch, containedNode);
      }
    }
    /**
     * This function subdivides the region into four new segments.
     * Specifically, this inserts a single new segment.
     * It fills the children section of the parentBranch
     *
     * @param {object} parentBranch
     * @param {'NW'| 'NE' | 'SW' | 'SE'} region
     * @private
     */

  }, {
    key: "_insertRegion",
    value: function _insertRegion(parentBranch, region) {
      var minX, maxX, minY, maxY;
      var childSize = 0.5 * parentBranch.size;

      switch (region) {
        case "NW":
          minX = parentBranch.range.minX;
          maxX = parentBranch.range.minX + childSize;
          minY = parentBranch.range.minY;
          maxY = parentBranch.range.minY + childSize;
          break;

        case "NE":
          minX = parentBranch.range.minX + childSize;
          maxX = parentBranch.range.maxX;
          minY = parentBranch.range.minY;
          maxY = parentBranch.range.minY + childSize;
          break;

        case "SW":
          minX = parentBranch.range.minX;
          maxX = parentBranch.range.minX + childSize;
          minY = parentBranch.range.minY + childSize;
          maxY = parentBranch.range.maxY;
          break;

        case "SE":
          minX = parentBranch.range.minX + childSize;
          maxX = parentBranch.range.maxX;
          minY = parentBranch.range.minY + childSize;
          maxY = parentBranch.range.maxY;
          break;
      }

      parentBranch.children[region] = {
        centerOfMass: {
          x: 0,
          y: 0
        },
        mass: 0,
        range: {
          minX: minX,
          maxX: maxX,
          minY: minY,
          maxY: maxY
        },
        size: 0.5 * parentBranch.size,
        calcSize: 2 * parentBranch.calcSize,
        children: {
          data: null
        },
        maxWidth: 0,
        level: parentBranch.level + 1,
        childrenCount: 0
      };
    } //---------------------------  DEBUGGING BELOW  ---------------------------//

    /**
     * This function is for debugging purposed, it draws the tree.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @param {string} color
     * @private
     */

  }, {
    key: "_debug",
    value: function _debug(ctx, color) {
      if (this.barnesHutTree !== undefined) {
        ctx.lineWidth = 1;

        this._drawBranch(this.barnesHutTree.root, ctx, color);
      }
    }
    /**
     * This function is for debugging purposes. It draws the branches recursively.
     *
     * @param {object} branch
     * @param {CanvasRenderingContext2D} ctx
     * @param {string} color
     * @private
     */

  }, {
    key: "_drawBranch",
    value: function _drawBranch(branch, ctx, color) {
      if (color === undefined) {
        color = "#FF0000";
      }

      if (branch.childrenCount === 4) {
        this._drawBranch(branch.children.NW, ctx);

        this._drawBranch(branch.children.NE, ctx);

        this._drawBranch(branch.children.SE, ctx);

        this._drawBranch(branch.children.SW, ctx);
      }

      ctx.strokeStyle = color;
      ctx.beginPath();
      ctx.moveTo(branch.range.minX, branch.range.minY);
      ctx.lineTo(branch.range.maxX, branch.range.minY);
      ctx.stroke();
      ctx.beginPath();
      ctx.moveTo(branch.range.maxX, branch.range.minY);
      ctx.lineTo(branch.range.maxX, branch.range.maxY);
      ctx.stroke();
      ctx.beginPath();
      ctx.moveTo(branch.range.maxX, branch.range.maxY);
      ctx.lineTo(branch.range.minX, branch.range.maxY);
      ctx.stroke();
      ctx.beginPath();
      ctx.moveTo(branch.range.minX, branch.range.maxY);
      ctx.lineTo(branch.range.minX, branch.range.minY);
      ctx.stroke();
      /*
       if (branch.mass > 0) {
       ctx.circle(branch.centerOfMass.x, branch.centerOfMass.y, 3*branch.mass);
       ctx.stroke();
       }
       */
    }
  }]);

  return BarnesHutSolver;
}();

/**
 * Repulsion Solver
 */

var RepulsionSolver = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  function RepulsionSolver(body, physicsBody, options) {
    _classCallCheck(this, RepulsionSolver);

    this._rng = Alea("REPULSION SOLVER");
    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }
  /**
   *
   * @param {object} options
   */


  _createClass(RepulsionSolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }
    /**
     * Calculate the forces the nodes apply on each other based on a repulsion field.
     * This field is linearly approximated.
     *
     * @private
     */

  }, {
    key: "solve",
    value: function solve() {
      var dx, dy, distance, fx, fy, repulsingForce, node1, node2;
      var nodes = this.body.nodes;
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var forces = this.physicsBody.forces; // repulsing forces between nodes

      var nodeDistance = this.options.nodeDistance; // approximation constants

      var a = -2 / 3 / nodeDistance;
      var b = 4 / 3; // we loop from i over all but the last entree in the array
      // j loops from i+1 to the last. This way we do not double count any of the indices, nor i === j

      for (var i = 0; i < nodeIndices.length - 1; i++) {
        node1 = nodes[nodeIndices[i]];

        for (var j = i + 1; j < nodeIndices.length; j++) {
          node2 = nodes[nodeIndices[j]];
          dx = node2.x - node1.x;
          dy = node2.y - node1.y;
          distance = Math.sqrt(dx * dx + dy * dy); // same condition as BarnesHutSolver, making sure nodes are never 100% overlapping.

          if (distance === 0) {
            distance = 0.1 * this._rng();
            dx = distance;
          }

          if (distance < 2 * nodeDistance) {
            if (distance < 0.5 * nodeDistance) {
              repulsingForce = 1.0;
            } else {
              repulsingForce = a * distance + b; // linear approx of  1 / (1 + Math.exp((distance / nodeDistance - 1) * steepness))
            }

            repulsingForce = repulsingForce / distance;
            fx = dx * repulsingForce;
            fy = dy * repulsingForce;
            forces[node1.id].x -= fx;
            forces[node1.id].y -= fy;
            forces[node2.id].x += fx;
            forces[node2.id].y += fy;
          }
        }
      }
    }
  }]);

  return RepulsionSolver;
}();

/**
 * Hierarchical Repulsion Solver
 */
var HierarchicalRepulsionSolver = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  function HierarchicalRepulsionSolver(body, physicsBody, options) {
    _classCallCheck(this, HierarchicalRepulsionSolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }
  /**
   *
   * @param {object} options
   */


  _createClass(HierarchicalRepulsionSolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
      this.overlapAvoidanceFactor = Math.max(0, Math.min(1, this.options.avoidOverlap || 0));
    }
    /**
     * Calculate the forces the nodes apply on each other based on a repulsion field.
     * This field is linearly approximated.
     *
     * @private
     */

  }, {
    key: "solve",
    value: function solve() {
      var nodes = this.body.nodes;
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var forces = this.physicsBody.forces; // repulsing forces between nodes

      var nodeDistance = this.options.nodeDistance; // we loop from i over all but the last entree in the array
      // j loops from i+1 to the last. This way we do not double count any of the indices, nor i === j

      for (var i = 0; i < nodeIndices.length - 1; i++) {
        var node1 = nodes[nodeIndices[i]];

        for (var j = i + 1; j < nodeIndices.length; j++) {
          var node2 = nodes[nodeIndices[j]]; // nodes only affect nodes on their level

          if (node1.level === node2.level) {
            var theseNodesDistance = nodeDistance + this.overlapAvoidanceFactor * ((node1.shape.radius || 0) / 2 + (node2.shape.radius || 0) / 2);
            var dx = node2.x - node1.x;
            var dy = node2.y - node1.y;
            var distance = Math.sqrt(dx * dx + dy * dy);
            var steepness = 0.05;
            var repulsingForce = void 0;

            if (distance < theseNodesDistance) {
              repulsingForce = -Math.pow(steepness * distance, 2) + Math.pow(steepness * theseNodesDistance, 2);
            } else {
              repulsingForce = 0;
            } // normalize force with


            if (distance !== 0) {
              repulsingForce = repulsingForce / distance;
            }

            var fx = dx * repulsingForce;
            var fy = dy * repulsingForce;
            forces[node1.id].x -= fx;
            forces[node1.id].y -= fy;
            forces[node2.id].x += fx;
            forces[node2.id].y += fy;
          }
        }
      }
    }
  }]);

  return HierarchicalRepulsionSolver;
}();

/**
 * Spring Solver
 */
var SpringSolver = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  function SpringSolver(body, physicsBody, options) {
    _classCallCheck(this, SpringSolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }
  /**
   *
   * @param {object} options
   */


  _createClass(SpringSolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }
    /**
     * This function calculates the springforces on the nodes, accounting for the support nodes.
     *
     * @private
     */

  }, {
    key: "solve",
    value: function solve() {
      var edgeLength, edge;
      var edgeIndices = this.physicsBody.physicsEdgeIndices;
      var edges = this.body.edges;
      var node1, node2, node3; // forces caused by the edges, modelled as springs

      for (var i = 0; i < edgeIndices.length; i++) {
        edge = edges[edgeIndices[i]];

        if (edge.connected === true && edge.toId !== edge.fromId) {
          // only calculate forces if nodes are in the same sector
          if (this.body.nodes[edge.toId] !== undefined && this.body.nodes[edge.fromId] !== undefined) {
            if (edge.edgeType.via !== undefined) {
              edgeLength = edge.options.length === undefined ? this.options.springLength : edge.options.length;
              node1 = edge.to;
              node2 = edge.edgeType.via;
              node3 = edge.from;

              this._calculateSpringForce(node1, node2, 0.5 * edgeLength);

              this._calculateSpringForce(node2, node3, 0.5 * edgeLength);
            } else {
              // the * 1.5 is here so the edge looks as large as a smooth edge. It does not initially because the smooth edges use
              // the support nodes which exert a repulsive force on the to and from nodes, making the edge appear larger.
              edgeLength = edge.options.length === undefined ? this.options.springLength * 1.5 : edge.options.length;

              this._calculateSpringForce(edge.from, edge.to, edgeLength);
            }
          }
        }
      }
    }
    /**
     * This is the code actually performing the calculation for the function above.
     *
     * @param {Node} node1
     * @param {Node} node2
     * @param {number} edgeLength
     * @private
     */

  }, {
    key: "_calculateSpringForce",
    value: function _calculateSpringForce(node1, node2, edgeLength) {
      var dx = node1.x - node2.x;
      var dy = node1.y - node2.y;
      var distance = Math.max(Math.sqrt(dx * dx + dy * dy), 0.01); // the 1/distance is so the fx and fy can be calculated without sine or cosine.

      var springForce = this.options.springConstant * (edgeLength - distance) / distance;
      var fx = dx * springForce;
      var fy = dy * springForce; // handle the case where one node is not part of the physcis

      if (this.physicsBody.forces[node1.id] !== undefined) {
        this.physicsBody.forces[node1.id].x += fx;
        this.physicsBody.forces[node1.id].y += fy;
      }

      if (this.physicsBody.forces[node2.id] !== undefined) {
        this.physicsBody.forces[node2.id].x -= fx;
        this.physicsBody.forces[node2.id].y -= fy;
      }
    }
  }]);

  return SpringSolver;
}();

/**
 * Hierarchical Spring Solver
 */
var HierarchicalSpringSolver = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  function HierarchicalSpringSolver(body, physicsBody, options) {
    _classCallCheck(this, HierarchicalSpringSolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }
  /**
   *
   * @param {object} options
   */


  _createClass(HierarchicalSpringSolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }
    /**
     * This function calculates the springforces on the nodes, accounting for the support nodes.
     *
     * @private
     */

  }, {
    key: "solve",
    value: function solve() {
      var edgeLength, edge;
      var dx, dy, fx, fy, springForce, distance;
      var edges = this.body.edges;
      var factor = 0.5;
      var edgeIndices = this.physicsBody.physicsEdgeIndices;
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var forces = this.physicsBody.forces; // initialize the spring force counters

      for (var i = 0; i < nodeIndices.length; i++) {
        var nodeId = nodeIndices[i];
        forces[nodeId].springFx = 0;
        forces[nodeId].springFy = 0;
      } // forces caused by the edges, modelled as springs


      for (var _i = 0; _i < edgeIndices.length; _i++) {
        edge = edges[edgeIndices[_i]];

        if (edge.connected === true) {
          edgeLength = edge.options.length === undefined ? this.options.springLength : edge.options.length;
          dx = edge.from.x - edge.to.x;
          dy = edge.from.y - edge.to.y;
          distance = Math.sqrt(dx * dx + dy * dy);
          distance = distance === 0 ? 0.01 : distance; // the 1/distance is so the fx and fy can be calculated without sine or cosine.

          springForce = this.options.springConstant * (edgeLength - distance) / distance;
          fx = dx * springForce;
          fy = dy * springForce;

          if (edge.to.level != edge.from.level) {
            if (forces[edge.toId] !== undefined) {
              forces[edge.toId].springFx -= fx;
              forces[edge.toId].springFy -= fy;
            }

            if (forces[edge.fromId] !== undefined) {
              forces[edge.fromId].springFx += fx;
              forces[edge.fromId].springFy += fy;
            }
          } else {
            if (forces[edge.toId] !== undefined) {
              forces[edge.toId].x -= factor * fx;
              forces[edge.toId].y -= factor * fy;
            }

            if (forces[edge.fromId] !== undefined) {
              forces[edge.fromId].x += factor * fx;
              forces[edge.fromId].y += factor * fy;
            }
          }
        }
      } // normalize spring forces


      springForce = 1;
      var springFx, springFy;

      for (var _i2 = 0; _i2 < nodeIndices.length; _i2++) {
        var _nodeId = nodeIndices[_i2];
        springFx = Math.min(springForce, Math.max(-springForce, forces[_nodeId].springFx));
        springFy = Math.min(springForce, Math.max(-springForce, forces[_nodeId].springFy));
        forces[_nodeId].x += springFx;
        forces[_nodeId].y += springFy;
      } // retain energy balance


      var totalFx = 0;
      var totalFy = 0;

      for (var _i3 = 0; _i3 < nodeIndices.length; _i3++) {
        var _nodeId2 = nodeIndices[_i3];
        totalFx += forces[_nodeId2].x;
        totalFy += forces[_nodeId2].y;
      }

      var correctionFx = totalFx / nodeIndices.length;
      var correctionFy = totalFy / nodeIndices.length;

      for (var _i4 = 0; _i4 < nodeIndices.length; _i4++) {
        var _nodeId3 = nodeIndices[_i4];
        forces[_nodeId3].x -= correctionFx;
        forces[_nodeId3].y -= correctionFy;
      }
    }
  }]);

  return HierarchicalSpringSolver;
}();

/**
 * Central Gravity Solver
 */
var CentralGravitySolver = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  function CentralGravitySolver(body, physicsBody, options) {
    _classCallCheck(this, CentralGravitySolver);

    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }
  /**
   *
   * @param {object} options
   */


  _createClass(CentralGravitySolver, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = options;
    }
    /**
     * Calculates forces for each node
     */

  }, {
    key: "solve",
    value: function solve() {
      var dx, dy, distance, node;
      var nodes = this.body.nodes;
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var forces = this.physicsBody.forces;

      for (var i = 0; i < nodeIndices.length; i++) {
        var nodeId = nodeIndices[i];
        node = nodes[nodeId];
        dx = -node.x;
        dy = -node.y;
        distance = Math.sqrt(dx * dx + dy * dy);

        this._calculateForces(distance, dx, dy, forces, node);
      }
    }
    /**
     * Calculate the forces based on the distance.
     *
     * @param {number} distance
     * @param {number} dx
     * @param {number} dy
     * @param {object<Node.id, vis.Node>} forces
     * @param {Node} node
     * @private
     */

  }, {
    key: "_calculateForces",
    value: function _calculateForces(distance, dx, dy, forces, node) {
      var gravityForce = distance === 0 ? 0 : this.options.centralGravity / distance;
      forces[node.id].x = dx * gravityForce;
      forces[node.id].y = dy * gravityForce;
    }
  }]);

  return CentralGravitySolver;
}();

function _createSuper$3(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$3(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$3() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @augments BarnesHutSolver
 */

var ForceAtlas2BasedRepulsionSolver = /*#__PURE__*/function (_BarnesHutSolver) {
  _inherits(ForceAtlas2BasedRepulsionSolver, _BarnesHutSolver);

  var _super = _createSuper$3(ForceAtlas2BasedRepulsionSolver);

  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  function ForceAtlas2BasedRepulsionSolver(body, physicsBody, options) {
    var _this;

    _classCallCheck(this, ForceAtlas2BasedRepulsionSolver);

    _this = _super.call(this, body, physicsBody, options);
    _this._rng = Alea("FORCE ATLAS 2 BASED REPULSION SOLVER");
    return _this;
  }
  /**
   * Calculate the forces based on the distance.
   *
   * @param {number} distance
   * @param {number} dx
   * @param {number} dy
   * @param {Node} node
   * @param {object} parentBranch
   * @private
   */


  _createClass(ForceAtlas2BasedRepulsionSolver, [{
    key: "_calculateForces",
    value: function _calculateForces(distance, dx, dy, node, parentBranch) {
      if (distance === 0) {
        distance = 0.1 * this._rng();
        dx = distance;
      }

      if (this.overlapAvoidanceFactor < 1 && node.shape.radius) {
        distance = Math.max(0.1 + this.overlapAvoidanceFactor * node.shape.radius, distance - node.shape.radius);
      }

      var degree = node.edges.length + 1; // the dividing by the distance cubed instead of squared allows us to get the fx and fy components without sines and cosines
      // it is shorthand for gravityforce with distance squared and fx = dx/distance * gravityForce

      var gravityForce = this.options.gravitationalConstant * parentBranch.mass * node.options.mass * degree / Math.pow(distance, 2);
      var fx = dx * gravityForce;
      var fy = dy * gravityForce;
      this.physicsBody.forces[node.id].x += fx;
      this.physicsBody.forces[node.id].y += fy;
    }
  }]);

  return ForceAtlas2BasedRepulsionSolver;
}(BarnesHutSolver);

function _createSuper$2(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * @augments CentralGravitySolver
 */

var ForceAtlas2BasedCentralGravitySolver = /*#__PURE__*/function (_CentralGravitySolver) {
  _inherits(ForceAtlas2BasedCentralGravitySolver, _CentralGravitySolver);

  var _super = _createSuper$2(ForceAtlas2BasedCentralGravitySolver);

  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  function ForceAtlas2BasedCentralGravitySolver(body, physicsBody, options) {
    _classCallCheck(this, ForceAtlas2BasedCentralGravitySolver);

    return _super.call(this, body, physicsBody, options);
  }
  /**
   * Calculate the forces based on the distance.
   *
   * @param {number} distance
   * @param {number} dx
   * @param {number} dy
   * @param {object<Node.id, Node>} forces
   * @param {Node} node
   * @private
   */


  _createClass(ForceAtlas2BasedCentralGravitySolver, [{
    key: "_calculateForces",
    value: function _calculateForces(distance, dx, dy, forces, node) {
      if (distance > 0) {
        var degree = node.edges.length + 1;
        var gravityForce = this.options.centralGravity * degree * node.options.mass;
        forces[node.id].x = dx * gravityForce;
        forces[node.id].y = dy * gravityForce;
      }
    }
  }]);

  return ForceAtlas2BasedCentralGravitySolver;
}(CentralGravitySolver);

/**
 * The physics engine
 */

var PhysicsEngine = /*#__PURE__*/function () {
  /**
   * @param {object} body
   */
  function PhysicsEngine(body) {
    _classCallCheck(this, PhysicsEngine);

    this.body = body;
    this.physicsBody = {
      physicsNodeIndices: [],
      physicsEdgeIndices: [],
      forces: {},
      velocities: {}
    };
    this.physicsEnabled = true;
    this.simulationInterval = 1000 / 60;
    this.requiresTimeout = true;
    this.previousStates = {};
    this.referenceState = {};
    this.freezeCache = {};
    this.renderTimer = undefined; // parameters for the adaptive timestep

    this.adaptiveTimestep = false;
    this.adaptiveTimestepEnabled = false;
    this.adaptiveCounter = 0;
    this.adaptiveInterval = 3;
    this.stabilized = false;
    this.startedStabilization = false;
    this.stabilizationIterations = 0;
    this.ready = false; // will be set to true if the stabilize
    // default options

    this.options = {};
    this.defaultOptions = {
      enabled: true,
      barnesHut: {
        theta: 0.5,
        gravitationalConstant: -2000,
        centralGravity: 0.3,
        springLength: 95,
        springConstant: 0.04,
        damping: 0.09,
        avoidOverlap: 0
      },
      forceAtlas2Based: {
        theta: 0.5,
        gravitationalConstant: -50,
        centralGravity: 0.01,
        springConstant: 0.08,
        springLength: 100,
        damping: 0.4,
        avoidOverlap: 0
      },
      repulsion: {
        centralGravity: 0.2,
        springLength: 200,
        springConstant: 0.05,
        nodeDistance: 100,
        damping: 0.09,
        avoidOverlap: 0
      },
      hierarchicalRepulsion: {
        centralGravity: 0.0,
        springLength: 100,
        springConstant: 0.01,
        nodeDistance: 120,
        damping: 0.09
      },
      maxVelocity: 50,
      minVelocity: 0.75,
      // px/s
      solver: "barnesHut",
      stabilization: {
        enabled: true,
        iterations: 1000,
        // maximum number of iteration to stabilize
        updateInterval: 50,
        onlyDynamicEdges: false,
        fit: true
      },
      timestep: 0.5,
      adaptiveTimestep: true,
      wind: {
        x: 0,
        y: 0
      }
    };

    assign$2(this.options, this.defaultOptions);

    this.timestep = 0.5;
    this.layoutFailed = false;
    this.bindEventListeners();
  }
  /**
   * Binds event listeners
   */


  _createClass(PhysicsEngine, [{
    key: "bindEventListeners",
    value: function bindEventListeners() {
      var _this = this;

      this.body.emitter.on("initPhysics", function () {
        _this.initPhysics();
      });
      this.body.emitter.on("_layoutFailed", function () {
        _this.layoutFailed = true;
      });
      this.body.emitter.on("resetPhysics", function () {
        _this.stopSimulation();

        _this.ready = false;
      });
      this.body.emitter.on("disablePhysics", function () {
        _this.physicsEnabled = false;

        _this.stopSimulation();
      });
      this.body.emitter.on("restorePhysics", function () {
        _this.setOptions(_this.options);

        if (_this.ready === true) {
          _this.startSimulation();
        }
      });
      this.body.emitter.on("startSimulation", function () {
        if (_this.ready === true) {
          _this.startSimulation();
        }
      });
      this.body.emitter.on("stopSimulation", function () {
        _this.stopSimulation();
      });
      this.body.emitter.on("destroy", function () {
        _this.stopSimulation(false);

        _this.body.emitter.off();
      });
      this.body.emitter.on("_dataChanged", function () {
        // Nodes and/or edges have been added or removed, update shortcut lists.
        _this.updatePhysicsData();
      }); // debug: show forces
      // this.body.emitter.on("afterDrawing", (ctx) => {this._drawForces(ctx);});
    }
    /**
     * set the physics options
     *
     * @param {object} options
     */

  }, {
    key: "setOptions",
    value: function setOptions(options) {
      if (options !== undefined) {
        if (options === false) {
          this.options.enabled = false;
          this.physicsEnabled = false;
          this.stopSimulation();
        } else if (options === true) {
          this.options.enabled = true;
          this.physicsEnabled = true;
          this.startSimulation();
        } else {
          this.physicsEnabled = true;
          selectiveNotDeepExtend(["stabilization"], this.options, options);
          mergeOptions(this.options, options, "stabilization");

          if (options.enabled === undefined) {
            this.options.enabled = true;
          }

          if (this.options.enabled === false) {
            this.physicsEnabled = false;
            this.stopSimulation();
          }

          var wind = this.options.wind;

          if (wind) {
            if (typeof wind.x !== "number" || isNan(wind.x)) {
              wind.x = 0;
            }

            if (typeof wind.y !== "number" || isNan(wind.y)) {
              wind.y = 0;
            }
          } // set the timestep


          this.timestep = this.options.timestep;
        }
      }

      this.init();
    }
    /**
     * configure the engine.
     */

  }, {
    key: "init",
    value: function init() {
      var options;

      if (this.options.solver === "forceAtlas2Based") {
        options = this.options.forceAtlas2Based;
        this.nodesSolver = new ForceAtlas2BasedRepulsionSolver(this.body, this.physicsBody, options);
        this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
        this.gravitySolver = new ForceAtlas2BasedCentralGravitySolver(this.body, this.physicsBody, options);
      } else if (this.options.solver === "repulsion") {
        options = this.options.repulsion;
        this.nodesSolver = new RepulsionSolver(this.body, this.physicsBody, options);
        this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
        this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
      } else if (this.options.solver === "hierarchicalRepulsion") {
        options = this.options.hierarchicalRepulsion;
        this.nodesSolver = new HierarchicalRepulsionSolver(this.body, this.physicsBody, options);
        this.edgesSolver = new HierarchicalSpringSolver(this.body, this.physicsBody, options);
        this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
      } else {
        // barnesHut
        options = this.options.barnesHut;
        this.nodesSolver = new BarnesHutSolver(this.body, this.physicsBody, options);
        this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
        this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
      }

      this.modelOptions = options;
    }
    /**
     * initialize the engine
     */

  }, {
    key: "initPhysics",
    value: function initPhysics() {
      if (this.physicsEnabled === true && this.options.enabled === true) {
        if (this.options.stabilization.enabled === true) {
          this.stabilize();
        } else {
          this.stabilized = false;
          this.ready = true;
          this.body.emitter.emit("fit", {}, this.layoutFailed); // if the layout failed, we use the approximation for the zoom

          this.startSimulation();
        }
      } else {
        this.ready = true;
        this.body.emitter.emit("fit");
      }
    }
    /**
     * Start the simulation
     */

  }, {
    key: "startSimulation",
    value: function startSimulation() {
      if (this.physicsEnabled === true && this.options.enabled === true) {
        this.stabilized = false; // when visible, adaptivity is disabled.

        this.adaptiveTimestep = false; // this sets the width of all nodes initially which could be required for the avoidOverlap

        this.body.emitter.emit("_resizeNodes");

        if (this.viewFunction === undefined) {
          var _context;

          this.viewFunction = bind$6(_context = this.simulationStep).call(_context, this);
          this.body.emitter.on("initRedraw", this.viewFunction);
          this.body.emitter.emit("_startRendering");
        }
      } else {
        this.body.emitter.emit("_redraw");
      }
    }
    /**
     * Stop the simulation, force stabilization.
     *
     * @param {boolean} [emit=true]
     */

  }, {
    key: "stopSimulation",
    value: function stopSimulation() {
      var emit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      this.stabilized = true;

      if (emit === true) {
        this._emitStabilized();
      }

      if (this.viewFunction !== undefined) {
        this.body.emitter.off("initRedraw", this.viewFunction);
        this.viewFunction = undefined;

        if (emit === true) {
          this.body.emitter.emit("_stopRendering");
        }
      }
    }
    /**
     * The viewFunction inserts this step into each render loop. It calls the physics tick and handles the cleanup at stabilized.
     *
     */

  }, {
    key: "simulationStep",
    value: function simulationStep() {
      // check if the physics have settled
      var startTime = now$1();

      this.physicsTick();
      var physicsTime = now$1() - startTime; // run double speed if it is a little graph

      if ((physicsTime < 0.4 * this.simulationInterval || this.runDoubleSpeed === true) && this.stabilized === false) {
        this.physicsTick(); // this makes sure there is no jitter. The decision is taken once to run it at double speed.

        this.runDoubleSpeed = true;
      }

      if (this.stabilized === true) {
        this.stopSimulation();
      }
    }
    /**
     * trigger the stabilized event.
     *
     * @param {number} [amountOfIterations=this.stabilizationIterations]
     * @private
     */

  }, {
    key: "_emitStabilized",
    value: function _emitStabilized() {
      var _this2 = this;

      var amountOfIterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.stabilizationIterations;

      if (this.stabilizationIterations > 1 || this.startedStabilization === true) {
        setTimeout$1(function () {
          _this2.body.emitter.emit("stabilized", {
            iterations: amountOfIterations
          });

          _this2.startedStabilization = false;
          _this2.stabilizationIterations = 0;
        }, 0);
      }
    }
    /**
     * Calculate the forces for one physics iteration and move the nodes.
     *
     * @private
     */

  }, {
    key: "physicsStep",
    value: function physicsStep() {
      this.gravitySolver.solve();
      this.nodesSolver.solve();
      this.edgesSolver.solve();
      this.moveNodes();
    }
    /**
     * Make dynamic adjustments to the timestep, based on current state.
     *
     * Helper function for physicsTick().
     *
     * @private
     */

  }, {
    key: "adjustTimeStep",
    value: function adjustTimeStep() {
      var factor = 1.2; // Factor for increasing the timestep on success.
      // we compare the two steps. if it is acceptable we double the step.

      if (this._evaluateStepQuality() === true) {
        this.timestep = factor * this.timestep;
      } else {
        // if not, we decrease the step to a minimum of the options timestep.
        // if the decreased timestep is smaller than the options step, we do not reset the counter
        // we assume that the options timestep is stable enough.
        if (this.timestep / factor < this.options.timestep) {
          this.timestep = this.options.timestep;
        } else {
          // if the timestep was larger than 2 times the option one we check the adaptivity again to ensure
          // that large instabilities do not form.
          this.adaptiveCounter = -1; // check again next iteration

          this.timestep = Math.max(this.options.timestep, this.timestep / factor);
        }
      }
    }
    /**
     * A single simulation step (or 'tick') in the physics simulation
     *
     * @private
     */

  }, {
    key: "physicsTick",
    value: function physicsTick() {
      this._startStabilizing(); // this ensures that there is no start event when the network is already stable.


      if (this.stabilized === true) return; // adaptivity means the timestep adapts to the situation, only applicable for stabilization

      if (this.adaptiveTimestep === true && this.adaptiveTimestepEnabled === true) {
        // timestep remains stable for "interval" iterations.
        var doAdaptive = this.adaptiveCounter % this.adaptiveInterval === 0;

        if (doAdaptive) {
          // first the big step and revert.
          this.timestep = 2 * this.timestep;
          this.physicsStep();
          this.revert(); // saves the reference state
          // now the normal step. Since this is the last step, it is the more stable one and we will take this.

          this.timestep = 0.5 * this.timestep; // since it's half the step, we do it twice.

          this.physicsStep();
          this.physicsStep();
          this.adjustTimeStep();
        } else {
          this.physicsStep(); // normal step, keeping timestep constant
        }

        this.adaptiveCounter += 1;
      } else {
        // case for the static timestep, we reset it to the one in options and take a normal step.
        this.timestep = this.options.timestep;
        this.physicsStep();
      }

      if (this.stabilized === true) this.revert();
      this.stabilizationIterations++;
    }
    /**
     * Nodes and edges can have the physics toggles on or off. A collection of indices is created here so we can skip the check all the time.
     *
     * @private
     */

  }, {
    key: "updatePhysicsData",
    value: function updatePhysicsData() {
      this.physicsBody.forces = {};
      this.physicsBody.physicsNodeIndices = [];
      this.physicsBody.physicsEdgeIndices = [];
      var nodes = this.body.nodes;
      var edges = this.body.edges; // get node indices for physics

      for (var nodeId in nodes) {
        if (Object.prototype.hasOwnProperty.call(nodes, nodeId)) {
          if (nodes[nodeId].options.physics === true) {
            this.physicsBody.physicsNodeIndices.push(nodes[nodeId].id);
          }
        }
      } // get edge indices for physics


      for (var edgeId in edges) {
        if (Object.prototype.hasOwnProperty.call(edges, edgeId)) {
          if (edges[edgeId].options.physics === true) {
            this.physicsBody.physicsEdgeIndices.push(edges[edgeId].id);
          }
        }
      } // get the velocity and the forces vector


      for (var i = 0; i < this.physicsBody.physicsNodeIndices.length; i++) {
        var _nodeId = this.physicsBody.physicsNodeIndices[i];
        this.physicsBody.forces[_nodeId] = {
          x: 0,
          y: 0
        }; // forces can be reset because they are recalculated. Velocities have to persist.

        if (this.physicsBody.velocities[_nodeId] === undefined) {
          this.physicsBody.velocities[_nodeId] = {
            x: 0,
            y: 0
          };
        }
      } // clean deleted nodes from the velocity vector


      for (var _nodeId2 in this.physicsBody.velocities) {
        if (nodes[_nodeId2] === undefined) {
          delete this.physicsBody.velocities[_nodeId2];
        }
      }
    }
    /**
     * Revert the simulation one step. This is done so after stabilization, every new start of the simulation will also say stabilized.
     */

  }, {
    key: "revert",
    value: function revert() {
      var nodeIds = keys$4(this.previousStates);

      var nodes = this.body.nodes;
      var velocities = this.physicsBody.velocities;
      this.referenceState = {};

      for (var i = 0; i < nodeIds.length; i++) {
        var nodeId = nodeIds[i];

        if (nodes[nodeId] !== undefined) {
          if (nodes[nodeId].options.physics === true) {
            this.referenceState[nodeId] = {
              positions: {
                x: nodes[nodeId].x,
                y: nodes[nodeId].y
              }
            };
            velocities[nodeId].x = this.previousStates[nodeId].vx;
            velocities[nodeId].y = this.previousStates[nodeId].vy;
            nodes[nodeId].x = this.previousStates[nodeId].x;
            nodes[nodeId].y = this.previousStates[nodeId].y;
          }
        } else {
          delete this.previousStates[nodeId];
        }
      }
    }
    /**
     * This compares the reference state to the current state
     *
     * @returns {boolean}
     * @private
     */

  }, {
    key: "_evaluateStepQuality",
    value: function _evaluateStepQuality() {
      var dx, dy, dpos;
      var nodes = this.body.nodes;
      var reference = this.referenceState;
      var posThreshold = 0.3;

      for (var nodeId in this.referenceState) {
        if (Object.prototype.hasOwnProperty.call(this.referenceState, nodeId) && nodes[nodeId] !== undefined) {
          dx = nodes[nodeId].x - reference[nodeId].positions.x;
          dy = nodes[nodeId].y - reference[nodeId].positions.y;
          dpos = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));

          if (dpos > posThreshold) {
            return false;
          }
        }
      }

      return true;
    }
    /**
     * move the nodes one timestep and check if they are stabilized
     */

  }, {
    key: "moveNodes",
    value: function moveNodes() {
      var nodeIndices = this.physicsBody.physicsNodeIndices;
      var maxNodeVelocity = 0;
      var averageNodeVelocity = 0; // the velocity threshold (energy in the system) for the adaptivity toggle

      var velocityAdaptiveThreshold = 5;

      for (var i = 0; i < nodeIndices.length; i++) {
        var nodeId = nodeIndices[i];

        var nodeVelocity = this._performStep(nodeId); // stabilized is true if stabilized is true and velocity is smaller than vmin --> all nodes must be stabilized


        maxNodeVelocity = Math.max(maxNodeVelocity, nodeVelocity);
        averageNodeVelocity += nodeVelocity;
      } // evaluating the stabilized and adaptiveTimestepEnabled conditions


      this.adaptiveTimestepEnabled = averageNodeVelocity / nodeIndices.length < velocityAdaptiveThreshold;
      this.stabilized = maxNodeVelocity < this.options.minVelocity;
    }
    /**
     * Calculate new velocity for a coordinate direction
     *
     * @param {number} v  velocity for current coordinate
     * @param {number} f  regular force for current coordinate
     * @param {number} m  mass of current node
     * @returns {number} new velocity for current coordinate
     * @private
     */

  }, {
    key: "calculateComponentVelocity",
    value: function calculateComponentVelocity(v, f, m) {
      var df = this.modelOptions.damping * v; // damping force

      var a = (f - df) / m; // acceleration

      v += a * this.timestep; // Put a limit on the velocities if it is really high

      var maxV = this.options.maxVelocity || 1e9;

      if (Math.abs(v) > maxV) {
        v = v > 0 ? maxV : -maxV;
      }

      return v;
    }
    /**
     * Perform the actual step
     *
     * @param {Node.id} nodeId
     * @returns {number} the new velocity of given node
     * @private
     */

  }, {
    key: "_performStep",
    value: function _performStep(nodeId) {
      var node = this.body.nodes[nodeId];
      var force = this.physicsBody.forces[nodeId];

      if (this.options.wind) {
        force.x += this.options.wind.x;
        force.y += this.options.wind.y;
      }

      var velocity = this.physicsBody.velocities[nodeId]; // store the state so we can revert

      this.previousStates[nodeId] = {
        x: node.x,
        y: node.y,
        vx: velocity.x,
        vy: velocity.y
      };

      if (node.options.fixed.x === false) {
        velocity.x = this.calculateComponentVelocity(velocity.x, force.x, node.options.mass);
        node.x += velocity.x * this.timestep;
      } else {
        force.x = 0;
        velocity.x = 0;
      }

      if (node.options.fixed.y === false) {
        velocity.y = this.calculateComponentVelocity(velocity.y, force.y, node.options.mass);
        node.y += velocity.y * this.timestep;
      } else {
        force.y = 0;
        velocity.y = 0;
      }

      var totalVelocity = Math.sqrt(Math.pow(velocity.x, 2) + Math.pow(velocity.y, 2));
      return totalVelocity;
    }
    /**
     * When initializing and stabilizing, we can freeze nodes with a predefined position.
     * This greatly speeds up stabilization because only the supportnodes for the smoothCurves have to settle.
     *
     * @private
     */

  }, {
    key: "_freezeNodes",
    value: function _freezeNodes() {
      var nodes = this.body.nodes;

      for (var id in nodes) {
        if (Object.prototype.hasOwnProperty.call(nodes, id)) {
          if (nodes[id].x && nodes[id].y) {
            var fixed = nodes[id].options.fixed;
            this.freezeCache[id] = {
              x: fixed.x,
              y: fixed.y
            };
            fixed.x = true;
            fixed.y = true;
          }
        }
      }
    }
    /**
     * Unfreezes the nodes that have been frozen by _freezeDefinedNodes.
     *
     * @private
     */

  }, {
    key: "_restoreFrozenNodes",
    value: function _restoreFrozenNodes() {
      var nodes = this.body.nodes;

      for (var id in nodes) {
        if (Object.prototype.hasOwnProperty.call(nodes, id)) {
          if (this.freezeCache[id] !== undefined) {
            nodes[id].options.fixed.x = this.freezeCache[id].x;
            nodes[id].options.fixed.y = this.freezeCache[id].y;
          }
        }
      }

      this.freezeCache = {};
    }
    /**
     * Find a stable position for all nodes
     *
     * @param {number} [iterations=this.options.stabilization.iterations]
     */

  }, {
    key: "stabilize",
    value: function stabilize() {
      var _this3 = this;

      var iterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.options.stabilization.iterations;

      if (typeof iterations !== "number") {
        iterations = this.options.stabilization.iterations;
        console.error("The stabilize method needs a numeric amount of iterations. Switching to default: ", iterations);
      }

      if (this.physicsBody.physicsNodeIndices.length === 0) {
        this.ready = true;
        return;
      } // enable adaptive timesteps


      this.adaptiveTimestep = this.options.adaptiveTimestep; // this sets the width of all nodes initially which could be required for the avoidOverlap

      this.body.emitter.emit("_resizeNodes");
      this.stopSimulation(); // stop the render loop

      this.stabilized = false; // block redraw requests

      this.body.emitter.emit("_blockRedraw");
      this.targetIterations = iterations; // start the stabilization

      if (this.options.stabilization.onlyDynamicEdges === true) {
        this._freezeNodes();
      }

      this.stabilizationIterations = 0;

      setTimeout$1(function () {
        return _this3._stabilizationBatch();
      }, 0);
    }
    /**
     * If not already stabilizing, start it and emit a start event.
     *
     * @returns {boolean} true if stabilization started with this call
     * @private
     */

  }, {
    key: "_startStabilizing",
    value: function _startStabilizing() {
      if (this.startedStabilization === true) return false;
      this.body.emitter.emit("startStabilizing");
      this.startedStabilization = true;
      return true;
    }
    /**
     * One batch of stabilization
     *
     * @private
     */

  }, {
    key: "_stabilizationBatch",
    value: function _stabilizationBatch() {
      var _this4 = this;

      var running = function running() {
        return _this4.stabilized === false && _this4.stabilizationIterations < _this4.targetIterations;
      };

      var sendProgress = function sendProgress() {
        _this4.body.emitter.emit("stabilizationProgress", {
          iterations: _this4.stabilizationIterations,
          total: _this4.targetIterations
        });
      };

      if (this._startStabilizing()) {
        sendProgress(); // Ensure that there is at least one start event.
      }

      var count = 0;

      while (running() && count < this.options.stabilization.updateInterval) {
        this.physicsTick();
        count++;
      }

      sendProgress();

      if (running()) {
        var _context2;

        setTimeout$1(bind$6(_context2 = this._stabilizationBatch).call(_context2, this), 0);
      } else {
        this._finalizeStabilization();
      }
    }
    /**
     * Wrap up the stabilization, fit and emit the events.
     *
     * @private
     */

  }, {
    key: "_finalizeStabilization",
    value: function _finalizeStabilization() {
      this.body.emitter.emit("_allowRedraw");

      if (this.options.stabilization.fit === true) {
        this.body.emitter.emit("fit");
      }

      if (this.options.stabilization.onlyDynamicEdges === true) {
        this._restoreFrozenNodes();
      }

      this.body.emitter.emit("stabilizationIterationsDone");
      this.body.emitter.emit("_requestRedraw");

      if (this.stabilized === true) {
        this._emitStabilized();
      } else {
        this.startSimulation();
      }

      this.ready = true;
    } //---------------------------  DEBUGGING BELOW  ---------------------------//

    /**
     * Debug function that display arrows for the forces currently active in the network.
     *
     * Use this when debugging only.
     *
     * @param {CanvasRenderingContext2D} ctx
     * @private
     */

  }, {
    key: "_drawForces",
    value: function _drawForces(ctx) {
      for (var i = 0; i < this.physicsBody.physicsNodeIndices.length; i++) {
        var index = this.physicsBody.physicsNodeIndices[i];
        var node = this.body.nodes[index];
        var force = this.physicsBody.forces[index];
        var factor = 20;
        var colorFactor = 0.03;
        var forceSize = Math.sqrt(Math.pow(force.x, 2) + Math.pow(force.x, 2));
        var size = Math.min(Math.max(5, forceSize), 15);
        var arrowSize = 3 * size;
        var color = HSVToHex((180 - Math.min(1, Math.max(0, colorFactor * forceSize)) * 180) / 360, 1, 1);
        var point = {
          x: node.x + factor * force.x,
          y: node.y + factor * force.y
        };
        ctx.lineWidth = size;
        ctx.strokeStyle = color;
        ctx.beginPath();
        ctx.moveTo(node.x, node.y);
        ctx.lineTo(point.x, point.y);
        ctx.stroke();
        var angle = Math.atan2(force.y, force.x);
        ctx.fillStyle = color;
        EndPoints.draw(ctx, {
          type: "arrow",
          point: point,
          angle: angle,
          length: arrowSize
        });

        fill(ctx).call(ctx);
      }
    }
  }]);

  return PhysicsEngine;
}();

/**
 * Utility Class
 */

var NetworkUtil = /*#__PURE__*/function () {
  /**
   * @ignore
   */
  function NetworkUtil() {
    _classCallCheck(this, NetworkUtil);
  }
  /**
   * Find the center position of the network considering the bounding boxes
   *
   * @param {Array.<Node>} allNodes
   * @param {Array.<Node>} [specificNodes=[]]
   * @returns {{minX: number, maxX: number, minY: number, maxY: number}}
   * @static
   */


  _createClass(NetworkUtil, null, [{
    key: "getRange",
    value: function getRange(allNodes) {
      var specificNodes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var minY = 1e9,
          maxY = -1e9,
          minX = 1e9,
          maxX = -1e9,
          node;

      if (specificNodes.length > 0) {
        for (var i = 0; i < specificNodes.length; i++) {
          node = allNodes[specificNodes[i]];

          if (minX > node.shape.boundingBox.left) {
            minX = node.shape.boundingBox.left;
          }

          if (maxX < node.shape.boundingBox.right) {
            maxX = node.shape.boundingBox.right;
          }

          if (minY > node.shape.boundingBox.top) {
            minY = node.shape.boundingBox.top;
          } // top is negative, bottom is positive


          if (maxY < node.shape.boundingBox.bottom) {
            maxY = node.shape.boundingBox.bottom;
          } // top is negative, bottom is positive

        }
      }

      if (minX === 1e9 && maxX === -1e9 && minY === 1e9 && maxY === -1e9) {
        minY = 0, maxY = 0, minX = 0, maxX = 0;
      }

      return {
        minX: minX,
        maxX: maxX,
        minY: minY,
        maxY: maxY
      };
    }
    /**
     * Find the center position of the network
     *
     * @param {Array.<Node>} allNodes
     * @param {Array.<Node>} [specificNodes=[]]
     * @returns {{minX: number, maxX: number, minY: number, maxY: number}}
     * @static
     */

  }, {
    key: "getRangeCore",
    value: function getRangeCore(allNodes) {
      var specificNodes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var minY = 1e9,
          maxY = -1e9,
          minX = 1e9,
          maxX = -1e9,
          node;

      if (specificNodes.length > 0) {
        for (var i = 0; i < specificNodes.length; i++) {
          node = allNodes[specificNodes[i]];

          if (minX > node.x) {
            minX = node.x;
          }

          if (maxX < node.x) {
            maxX = node.x;
          }

          if (minY > node.y) {
            minY = node.y;
          } // top is negative, bottom is positive


          if (maxY < node.y) {
            maxY = node.y;
          } // top is negative, bottom is positive

        }
      }

      if (minX === 1e9 && maxX === -1e9 && minY === 1e9 && maxY === -1e9) {
        minY = 0, maxY = 0, minX = 0, maxX = 0;
      }

      return {
        minX: minX,
        maxX: maxX,
        minY: minY,
        maxY: maxY
      };
    }
    /**
     * @param {object} range = {minX: minX, maxX: maxX, minY: minY, maxY: maxY};
     * @returns {{x: number, y: number}}
     * @static
     */

  }, {
    key: "findCenter",
    value: function findCenter(range) {
      return {
        x: 0.5 * (range.maxX + range.minX),
        y: 0.5 * (range.maxY + range.minY)
      };
    }
    /**
     * This returns a clone of the options or options of the edge or node to be used for construction of new edges or check functions for new nodes.
     *
     * @param {vis.Item} item
     * @param {'node'|undefined} type
     * @returns {{}}
     * @static
     */

  }, {
    key: "cloneOptions",
    value: function cloneOptions(item, type) {
      var clonedOptions = {};

      if (type === undefined || type === "node") {
        deepExtend(clonedOptions, item.options, true);
        clonedOptions.x = item.x;
        clonedOptions.y = item.y;
        clonedOptions.amountOfConnections = item.edges.length;
      } else {
        deepExtend(clonedOptions, item.options, true);
      }

      return clonedOptions;
    }
  }]);

  return NetworkUtil;
}();

function _createSuper$1(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1() { if (typeof Reflect === "undefined" || !construct) return false; if (construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/**
 * A Cluster is a special Node that allows a group of Nodes positioned closely together
 * to be represented by a single Cluster Node.
 *
 * @augments Node
 */

var Cluster = /*#__PURE__*/function (_Node) {
  _inherits(Cluster, _Node);

  var _super = _createSuper$1(Cluster);

  /**
   * @param {object} options
   * @param {object} body
   * @param {Array.<HTMLImageElement>}imagelist
   * @param {Array} grouplist
   * @param {object} globalOptions
   * @param {object} defaultOptions     Global default options for nodes
   */
  function Cluster(options, body, imagelist, grouplist, globalOptions, defaultOptions) {
    var _this;

    _classCallCheck(this, Cluster);

    _this = _super.call(this, options, body, imagelist, grouplist, globalOptions, defaultOptions);
    _this.isCluster = true;
    _this.containedNodes = {};
    _this.containedEdges = {};
    return _this;
  }
  /**
   * Transfer child cluster data to current and disconnect the child cluster.
   *
   * Please consult the header comment in 'Clustering.js' for the fields set here.
   *
   * @param {string|number} childClusterId  id of child cluster to open
   */


  _createClass(Cluster, [{
    key: "_openChildCluster",
    value: function _openChildCluster(childClusterId) {
      var _this2 = this;

      var childCluster = this.body.nodes[childClusterId];

      if (this.containedNodes[childClusterId] === undefined) {
        throw new Error("node with id: " + childClusterId + " not in current cluster");
      }

      if (!childCluster.isCluster) {
        throw new Error("node with id: " + childClusterId + " is not a cluster");
      } // Disconnect child cluster from current cluster


      delete this.containedNodes[childClusterId];
      forEach$1(childCluster.edges, function (edge) {
        delete _this2.containedEdges[edge.id];
      }); // Transfer nodes and edges

      forEach$1(childCluster.containedNodes, function (node, nodeId) {
        _this2.containedNodes[nodeId] = node;
      });
      childCluster.containedNodes = {};
      forEach$1(childCluster.containedEdges, function (edge, edgeId) {
        _this2.containedEdges[edgeId] = edge;
      });
      childCluster.containedEdges = {}; // Transfer edges within cluster edges which are clustered

      forEach$1(childCluster.edges, function (clusterEdge) {
        forEach$1(_this2.edges, function (parentClusterEdge) {
          var _context, _context2;

          // Assumption: a clustered edge can only be present in a single clustering edge
          // Not tested here
          var index = indexOf(_context = parentClusterEdge.clusteringEdgeReplacingIds).call(_context, clusterEdge.id);

          if (index === -1) return;
          forEach$1(clusterEdge.clusteringEdgeReplacingIds, function (srcId) {
            parentClusterEdge.clusteringEdgeReplacingIds.push(srcId); // Maintain correct bookkeeping for transferred edge

            _this2.body.edges[srcId].edgeReplacedById = parentClusterEdge.id;
          }); // Remove cluster edge from parent cluster edge

          splice(_context2 = parentClusterEdge.clusteringEdgeReplacingIds).call(_context2, index, 1);
        });
      });
      childCluster.edges = [];
    }
  }]);

  return Cluster;
}(Node);

/**
 * The clustering engine
 */

var ClusterEngine = /*#__PURE__*/function () {
  /**
   * @param {object} body
   */
  function ClusterEngine(body) {
    var _this = this;

    _classCallCheck(this, ClusterEngine);

    this.body = body;
    this.clusteredNodes = {}; // key: node id, value: { clusterId: <id of cluster>, node: <node instance>}

    this.clusteredEdges = {}; // key: edge id, value: restore information for given edge

    this.options = {};
    this.defaultOptions = {};

    assign$2(this.options, this.defaultOptions);

    this.body.emitter.on("_resetData", function () {
      _this.clusteredNodes = {};
      _this.clusteredEdges = {};
    });
  }
  /**
   *
   * @param {number} hubsize
   * @param {object} options
   */


  _createClass(ClusterEngine, [{
    key: "clusterByHubsize",
    value: function clusterByHubsize(hubsize, options) {
      if (hubsize === undefined) {
        hubsize = this._getHubSize();
      } else if (_typeof(hubsize) === "object") {
        options = this._checkOptions(hubsize);
        hubsize = this._getHubSize();
      }

      var nodesToCluster = [];

      for (var i = 0; i < this.body.nodeIndices.length; i++) {
        var node = this.body.nodes[this.body.nodeIndices[i]];

        if (node.edges.length >= hubsize) {
          nodesToCluster.push(node.id);
        }
      }

      for (var _i = 0; _i < nodesToCluster.length; _i++) {
        this.clusterByConnection(nodesToCluster[_i], options, true);
      }

      this.body.emitter.emit("_dataChanged");
    }
    /**
     * loop over all nodes, check if they adhere to the condition and cluster if needed.
     *
     * @param {object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: "cluster",
    value: function cluster() {
      var _this2 = this;

      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var refreshData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      if (options.joinCondition === undefined) {
        throw new Error("Cannot call clusterByNodeData without a joinCondition function in the options.");
      } // check if the options object is fine, append if needed


      options = this._checkOptions(options);
      var childNodesObj = {};
      var childEdgesObj = {}; // collect the nodes that will be in the cluster

      forEach$1(this.body.nodes, function (node, nodeId) {
        if (node.options && options.joinCondition(node.options) === true) {
          childNodesObj[nodeId] = node; // collect the edges that will be in the cluster

          forEach$1(node.edges, function (edge) {
            if (_this2.clusteredEdges[edge.id] === undefined) {
              childEdgesObj[edge.id] = edge;
            }
          });
        }
      });

      this._cluster(childNodesObj, childEdgesObj, options, refreshData);
    }
    /**
     * Cluster all nodes in the network that have only X edges
     *
     * @param {number} edgeCount
     * @param {object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: "clusterByEdgeCount",
    value: function clusterByEdgeCount(edgeCount, options) {
      var _this3 = this;

      var refreshData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      options = this._checkOptions(options);
      var clusters = [];
      var usedNodes = {};
      var edge, edges, relevantEdgeCount; // collect the nodes that will be in the cluster

      var _loop = function _loop(i) {
        var childNodesObj = {};
        var childEdgesObj = {};
        var nodeId = _this3.body.nodeIndices[i];
        var node = _this3.body.nodes[nodeId]; // if this node is already used in another cluster this session, we do not have to re-evaluate it.

        if (usedNodes[nodeId] === undefined) {
          relevantEdgeCount = 0;
          edges = [];

          for (var j = 0; j < node.edges.length; j++) {
            edge = node.edges[j];

            if (_this3.clusteredEdges[edge.id] === undefined) {
              if (edge.toId !== edge.fromId) {
                relevantEdgeCount++;
              }

              edges.push(edge);
            }
          } // this node qualifies, we collect its neighbours to start the clustering process.


          if (relevantEdgeCount === edgeCount) {
            var checkJoinCondition = function checkJoinCondition(node) {
              if (options.joinCondition === undefined || options.joinCondition === null) {
                return true;
              }

              var clonedOptions = NetworkUtil.cloneOptions(node);
              return options.joinCondition(clonedOptions);
            };

            var gatheringSuccessful = true;

            for (var _j = 0; _j < edges.length; _j++) {
              edge = edges[_j];

              var childNodeId = _this3._getConnectedId(edge, nodeId); // add the nodes to the list by the join condition.


              if (checkJoinCondition(node)) {
                childEdgesObj[edge.id] = edge;
                childNodesObj[nodeId] = node;
                childNodesObj[childNodeId] = _this3.body.nodes[childNodeId];
                usedNodes[nodeId] = true;
              } else {
                // this node does not qualify after all.
                gatheringSuccessful = false;
                break;
              }
            } // add to the cluster queue


            if (keys$4(childNodesObj).length > 0 && keys$4(childEdgesObj).length > 0 && gatheringSuccessful === true) {
              /**
               * Search for cluster data that contains any of the node id's
               *
               * @returns {boolean} true if no joinCondition, otherwise return value of joinCondition
               */
              var findClusterData = function findClusterData() {
                for (var n = 0; n < clusters.length; ++n) {
                  // Search for a cluster containing any of the node id's
                  for (var m in childNodesObj) {
                    if (clusters[n].nodes[m] !== undefined) {
                      return clusters[n];
                    }
                  }
                }

                return undefined;
              }; // If any of the found nodes is part of a cluster found in this method,
              // add the current values to that cluster


              var foundCluster = findClusterData();

              if (foundCluster !== undefined) {
                // Add nodes to found cluster if not present
                for (var m in childNodesObj) {
                  if (foundCluster.nodes[m] === undefined) {
                    foundCluster.nodes[m] = childNodesObj[m];
                  }
                } // Add edges to found cluster, if not present


                for (var _m in childEdgesObj) {
                  if (foundCluster.edges[_m] === undefined) {
                    foundCluster.edges[_m] = childEdgesObj[_m];
                  }
                }
              } else {
                // Create a new cluster group
                clusters.push({
                  nodes: childNodesObj,
                  edges: childEdgesObj
                });
              }
            }
          }
        }
      };

      for (var i = 0; i < this.body.nodeIndices.length; i++) {
        _loop(i);
      }

      for (var _i2 = 0; _i2 < clusters.length; _i2++) {
        this._cluster(clusters[_i2].nodes, clusters[_i2].edges, options, false);
      }

      if (refreshData === true) {
        this.body.emitter.emit("_dataChanged");
      }
    }
    /**
     * Cluster all nodes in the network that have only 1 edge
     *
     * @param {object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: "clusterOutliers",
    value: function clusterOutliers(options) {
      var refreshData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      this.clusterByEdgeCount(1, options, refreshData);
    }
    /**
     * Cluster all nodes in the network that have only 2 edge
     *
     * @param {object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: "clusterBridges",
    value: function clusterBridges(options) {
      var refreshData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      this.clusterByEdgeCount(2, options, refreshData);
    }
    /**
     * suck all connected nodes of a node into the node.
     *
     * @param {Node.id} nodeId
     * @param {object} options
     * @param {boolean} [refreshData=true]
     */

  }, {
    key: "clusterByConnection",
    value: function clusterByConnection(nodeId, options) {
      var _context;

      var refreshData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      // kill conditions
      if (nodeId === undefined) {
        throw new Error("No nodeId supplied to clusterByConnection!");
      }

      if (this.body.nodes[nodeId] === undefined) {
        throw new Error("The nodeId given to clusterByConnection does not exist!");
      }

      var node = this.body.nodes[nodeId];
      options = this._checkOptions(options, node);

      if (options.clusterNodeProperties.x === undefined) {
        options.clusterNodeProperties.x = node.x;
      }

      if (options.clusterNodeProperties.y === undefined) {
        options.clusterNodeProperties.y = node.y;
      }

      if (options.clusterNodeProperties.fixed === undefined) {
        options.clusterNodeProperties.fixed = {};
        options.clusterNodeProperties.fixed.x = node.options.fixed.x;
        options.clusterNodeProperties.fixed.y = node.options.fixed.y;
      }

      var childNodesObj = {};
      var childEdgesObj = {};
      var parentNodeId = node.id;
      var parentClonedOptions = NetworkUtil.cloneOptions(node);
      childNodesObj[parentNodeId] = node; // collect the nodes that will be in the cluster

      for (var i = 0; i < node.edges.length; i++) {
        var edge = node.edges[i];

        if (this.clusteredEdges[edge.id] === undefined) {
          var childNodeId = this._getConnectedId(edge, parentNodeId); // if the child node is not in a cluster


          if (this.clusteredNodes[childNodeId] === undefined) {
            if (childNodeId !== parentNodeId) {
              if (options.joinCondition === undefined) {
                childEdgesObj[edge.id] = edge;
                childNodesObj[childNodeId] = this.body.nodes[childNodeId];
              } else {
                // clone the options and insert some additional parameters that could be interesting.
                var childClonedOptions = NetworkUtil.cloneOptions(this.body.nodes[childNodeId]);

                if (options.joinCondition(parentClonedOptions, childClonedOptions) === true) {
                  childEdgesObj[edge.id] = edge;
                  childNodesObj[childNodeId] = this.body.nodes[childNodeId];
                }
              }
            } else {
              // swallow the edge if it is self-referencing.
              childEdgesObj[edge.id] = edge;
            }
          }
        }
      }

      var childNodeIDs = map$3(_context = keys$4(childNodesObj)).call(_context, function (childNode) {
        return childNodesObj[childNode].id;
      });

      for (var childNodeKey in childNodesObj) {
        if (!Object.prototype.hasOwnProperty.call(childNodesObj, childNodeKey)) continue;
        var childNode = childNodesObj[childNodeKey];

        for (var y = 0; y < childNode.edges.length; y++) {
          var childEdge = childNode.edges[y];

          if (indexOf(childNodeIDs).call(childNodeIDs, this._getConnectedId(childEdge, childNode.id)) > -1) {
            childEdgesObj[childEdge.id] = childEdge;
          }
        }
      }

      this._cluster(childNodesObj, childEdgesObj, options, refreshData);
    }
    /**
     * This function creates the edges that will be attached to the cluster
     * It looks for edges that are connected to the nodes from the "outside' of the cluster.
     *
     * @param {{Node.id: vis.Node}} childNodesObj
     * @param {{vis.Edge.id: vis.Edge}} childEdgesObj
     * @param {object} clusterNodeProperties
     * @param {object} clusterEdgeProperties
     * @private
     */

  }, {
    key: "_createClusterEdges",
    value: function _createClusterEdges(childNodesObj, childEdgesObj, clusterNodeProperties, clusterEdgeProperties) {
      var edge, childNodeId, childNode, toId, fromId, otherNodeId; // loop over all child nodes and their edges to find edges going out of the cluster
      // these edges will be replaced by clusterEdges.

      var childKeys = keys$4(childNodesObj);

      var createEdges = [];

      for (var i = 0; i < childKeys.length; i++) {
        childNodeId = childKeys[i];
        childNode = childNodesObj[childNodeId]; // construct new edges from the cluster to others

        for (var j = 0; j < childNode.edges.length; j++) {
          edge = childNode.edges[j]; // we only handle edges that are visible to the system, not the disabled ones from the clustering process.

          if (this.clusteredEdges[edge.id] === undefined) {
            // self-referencing edges will be added to the "hidden" list
            if (edge.toId == edge.fromId) {
              childEdgesObj[edge.id] = edge;
            } else {
              // set up the from and to.
              if (edge.toId == childNodeId) {
                // this is a double equals because ints and strings can be interchanged here.
                toId = clusterNodeProperties.id;
                fromId = edge.fromId;
                otherNodeId = fromId;
              } else {
                toId = edge.toId;
                fromId = clusterNodeProperties.id;
                otherNodeId = toId;
              }
            } // Only edges from the cluster outwards are being replaced.


            if (childNodesObj[otherNodeId] === undefined) {
              createEdges.push({
                edge: edge,
                fromId: fromId,
                toId: toId
              });
            }
          }
        }
      } //
      // Here we actually create the replacement edges.
      //
      // We could not do this in the loop above as the creation process
      // would add an edge to the edges array we are iterating over.
      //
      // NOTE: a clustered edge can have multiple base edges!
      //


      var newEdges = [];
      /**
       * Find a cluster edge which matches the given created edge.
       *
       * @param {vis.Edge} createdEdge
       * @returns {vis.Edge}
       */

      var getNewEdge = function getNewEdge(createdEdge) {
        for (var _j2 = 0; _j2 < newEdges.length; _j2++) {
          var newEdge = newEdges[_j2]; // We replace both to and from edges with a single cluster edge

          var matchToDirection = createdEdge.fromId === newEdge.fromId && createdEdge.toId === newEdge.toId;
          var matchFromDirection = createdEdge.fromId === newEdge.toId && createdEdge.toId === newEdge.fromId;

          if (matchToDirection || matchFromDirection) {
            return newEdge;
          }
        }

        return null;
      };

      for (var _j3 = 0; _j3 < createEdges.length; _j3++) {
        var createdEdge = createEdges[_j3];
        var _edge = createdEdge.edge;
        var newEdge = getNewEdge(createdEdge);

        if (newEdge === null) {
          // Create a clustered edge for this connection
          newEdge = this._createClusteredEdge(createdEdge.fromId, createdEdge.toId, _edge, clusterEdgeProperties);
          newEdges.push(newEdge);
        } else {
          newEdge.clusteringEdgeReplacingIds.push(_edge.id);
        } // also reference the new edge in the old edge


        this.body.edges[_edge.id].edgeReplacedById = newEdge.id; // hide the replaced edge

        this._backupEdgeOptions(_edge);

        _edge.setOptions({
          physics: false
        });
      }
    }
    /**
     * This function checks the options that can be supplied to the different cluster functions
     * for certain fields and inserts defaults if needed
     *
     * @param {object} options
     * @returns {*}
     * @private
     */

  }, {
    key: "_checkOptions",
    value: function _checkOptions() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (options.clusterEdgeProperties === undefined) {
        options.clusterEdgeProperties = {};
      }

      if (options.clusterNodeProperties === undefined) {
        options.clusterNodeProperties = {};
      }

      return options;
    }
    /**
     *
     * @param {object}    childNodesObj         | object with node objects, id as keys, same as childNodes except it also contains a source node
     * @param {object}    childEdgesObj         | object with edge objects, id as keys
     * @param {Array}     options               | object with {clusterNodeProperties, clusterEdgeProperties, processProperties}
     * @param {boolean}   refreshData | when true, do not wrap up
     * @private
     */

  }, {
    key: "_cluster",
    value: function _cluster(childNodesObj, childEdgesObj, options) {
      var refreshData = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
      // Remove nodes which are already clustered
      var tmpNodesToRemove = [];

      for (var nodeId in childNodesObj) {
        if (Object.prototype.hasOwnProperty.call(childNodesObj, nodeId)) {
          if (this.clusteredNodes[nodeId] !== undefined) {
            tmpNodesToRemove.push(nodeId);
          }
        }
      }

      for (var n = 0; n < tmpNodesToRemove.length; ++n) {
        delete childNodesObj[tmpNodesToRemove[n]];
      } // kill condition: no nodes don't bother


      if (keys$4(childNodesObj).length == 0) {
        return;
      } // allow clusters of 1 if options allow


      if (keys$4(childNodesObj).length == 1 && options.clusterNodeProperties.allowSingleNodeCluster != true) {
        return;
      }

      var clusterNodeProperties = deepExtend({}, options.clusterNodeProperties); // construct the clusterNodeProperties

      if (options.processProperties !== undefined) {
        // get the childNode options
        var childNodesOptions = [];

        for (var _nodeId in childNodesObj) {
          if (Object.prototype.hasOwnProperty.call(childNodesObj, _nodeId)) {
            var clonedOptions = NetworkUtil.cloneOptions(childNodesObj[_nodeId]);
            childNodesOptions.push(clonedOptions);
          }
        } // get cluster properties based on childNodes


        var childEdgesOptions = [];

        for (var edgeId in childEdgesObj) {
          if (Object.prototype.hasOwnProperty.call(childEdgesObj, edgeId)) {
            // these cluster edges will be removed on creation of the cluster.
            if (edgeId.substr(0, 12) !== "clusterEdge:") {
              var _clonedOptions = NetworkUtil.cloneOptions(childEdgesObj[edgeId], "edge");

              childEdgesOptions.push(_clonedOptions);
            }
          }
        }

        clusterNodeProperties = options.processProperties(clusterNodeProperties, childNodesOptions, childEdgesOptions);

        if (!clusterNodeProperties) {
          throw new Error("The processProperties function does not return properties!");
        }
      } // check if we have an unique id;


      if (clusterNodeProperties.id === undefined) {
        clusterNodeProperties.id = "cluster:" + v4();
      }

      var clusterId = clusterNodeProperties.id;

      if (clusterNodeProperties.label === undefined) {
        clusterNodeProperties.label = "cluster";
      } // give the clusterNode a position if it does not have one.


      var pos = undefined;

      if (clusterNodeProperties.x === undefined) {
        pos = this._getClusterPosition(childNodesObj);
        clusterNodeProperties.x = pos.x;
      }

      if (clusterNodeProperties.y === undefined) {
        if (pos === undefined) {
          pos = this._getClusterPosition(childNodesObj);
        }

        clusterNodeProperties.y = pos.y;
      } // force the ID to remain the same


      clusterNodeProperties.id = clusterId; // create the cluster Node
      // Note that allowSingleNodeCluster, if present, is stored in the options as well

      var clusterNode = this.body.functions.createNode(clusterNodeProperties, Cluster);
      clusterNode.containedNodes = childNodesObj;
      clusterNode.containedEdges = childEdgesObj; // cache a copy from the cluster edge properties if we have to reconnect others later on

      clusterNode.clusterEdgeProperties = options.clusterEdgeProperties; // finally put the cluster node into global

      this.body.nodes[clusterNodeProperties.id] = clusterNode;

      this._clusterEdges(childNodesObj, childEdgesObj, clusterNodeProperties, options.clusterEdgeProperties); // set ID to undefined so no duplicates arise


      clusterNodeProperties.id = undefined; // wrap up

      if (refreshData === true) {
        this.body.emitter.emit("_dataChanged");
      }
    }
    /**
     *
     * @param {Edge} edge
     * @private
     */

  }, {
    key: "_backupEdgeOptions",
    value: function _backupEdgeOptions(edge) {
      if (this.clusteredEdges[edge.id] === undefined) {
        this.clusteredEdges[edge.id] = {
          physics: edge.options.physics
        };
      }
    }
    /**
     *
     * @param {Edge} edge
     * @private
     */

  }, {
    key: "_restoreEdge",
    value: function _restoreEdge(edge) {
      var originalOptions = this.clusteredEdges[edge.id];

      if (originalOptions !== undefined) {
        edge.setOptions({
          physics: originalOptions.physics
        });
        delete this.clusteredEdges[edge.id];
      }
    }
    /**
     * Check if a node is a cluster.
     *
     * @param {Node.id} nodeId
     * @returns {*}
     */

  }, {
    key: "isCluster",
    value: function isCluster(nodeId) {
      if (this.body.nodes[nodeId] !== undefined) {
        return this.body.nodes[nodeId].isCluster === true;
      } else {
        console.error("Node does not exist.");
        return false;
      }
    }
    /**
     * get the position of the cluster node based on what's inside
     *
     * @param {object} childNodesObj    | object with node objects, id as keys
     * @returns {{x: number, y: number}}
     * @private
     */

  }, {
    key: "_getClusterPosition",
    value: function _getClusterPosition(childNodesObj) {
      var childKeys = keys$4(childNodesObj);

      var minX = childNodesObj[childKeys[0]].x;
      var maxX = childNodesObj[childKeys[0]].x;
      var minY = childNodesObj[childKeys[0]].y;
      var maxY = childNodesObj[childKeys[0]].y;
      var node;

      for (var i = 1; i < childKeys.length; i++) {
        node = childNodesObj[childKeys[i]];
        minX = node.x < minX ? node.x : minX;
        maxX = node.x > maxX ? node.x : maxX;
        minY = node.y < minY ? node.y : minY;
        maxY = node.y > maxY ? node.y : maxY;
      }

      return {
        x: 0.5 * (minX + maxX),
        y: 0.5 * (minY + maxY)
      };
    }
    /**
     * Open a cluster by calling this function.
     *
     * @param {vis.Edge.id}  clusterNodeId | the ID of the cluster node
     * @param {object} options
     * @param {boolean} refreshData | wrap up afterwards if not true
     */

  }, {
    key: "openCluster",
    value: function openCluster(clusterNodeId, options) {
      var refreshData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      // kill conditions
      if (clusterNodeId === undefined) {
        throw new Error("No clusterNodeId supplied to openCluster.");
      }

      var clusterNode = this.body.nodes[clusterNodeId];

      if (clusterNode === undefined) {
        throw new Error("The clusterNodeId supplied to openCluster does not exist.");
      }

      if (clusterNode.isCluster !== true || clusterNode.containedNodes === undefined || clusterNode.containedEdges === undefined) {
        throw new Error("The node:" + clusterNodeId + " is not a valid cluster.");
      } // Check if current cluster is clustered itself


      var stack = this.findNode(clusterNodeId);
      var parentIndex = indexOf(stack).call(stack, clusterNodeId) - 1;

      if (parentIndex >= 0) {
        // Current cluster is clustered; transfer contained nodes and edges to parent
        var parentClusterNodeId = stack[parentIndex];
        var parentClusterNode = this.body.nodes[parentClusterNodeId]; // clustering.clusteredNodes and clustering.clusteredEdges remain unchanged

        parentClusterNode._openChildCluster(clusterNodeId); // All components of child cluster node have been transferred. It can die now.


        delete this.body.nodes[clusterNodeId];

        if (refreshData === true) {
          this.body.emitter.emit("_dataChanged");
        }

        return;
      } // main body


      var containedNodes = clusterNode.containedNodes;
      var containedEdges = clusterNode.containedEdges; // allow the user to position the nodes after release.

      if (options !== undefined && options.releaseFunction !== undefined && typeof options.releaseFunction === "function") {
        var positions = {};
        var clusterPosition = {
          x: clusterNode.x,
          y: clusterNode.y
        };

        for (var nodeId in containedNodes) {
          if (Object.prototype.hasOwnProperty.call(containedNodes, nodeId)) {
            var containedNode = this.body.nodes[nodeId];
            positions[nodeId] = {
              x: containedNode.x,
              y: containedNode.y
            };
          }
        }

        var newPositions = options.releaseFunction(clusterPosition, positions);

        for (var _nodeId2 in containedNodes) {
          if (Object.prototype.hasOwnProperty.call(containedNodes, _nodeId2)) {
            var _containedNode = this.body.nodes[_nodeId2];

            if (newPositions[_nodeId2] !== undefined) {
              _containedNode.x = newPositions[_nodeId2].x === undefined ? clusterNode.x : newPositions[_nodeId2].x;
              _containedNode.y = newPositions[_nodeId2].y === undefined ? clusterNode.y : newPositions[_nodeId2].y;
            }
          }
        }
      } else {
        // copy the position from the cluster
        forEach$1(containedNodes, function (containedNode) {
          // inherit position
          if (containedNode.options.fixed.x === false) {
            containedNode.x = clusterNode.x;
          }

          if (containedNode.options.fixed.y === false) {
            containedNode.y = clusterNode.y;
          }
        });
      } // release nodes


      for (var _nodeId3 in containedNodes) {
        if (Object.prototype.hasOwnProperty.call(containedNodes, _nodeId3)) {
          var _containedNode2 = this.body.nodes[_nodeId3]; // inherit speed

          _containedNode2.vx = clusterNode.vx;
          _containedNode2.vy = clusterNode.vy;

          _containedNode2.setOptions({
            physics: true
          });

          delete this.clusteredNodes[_nodeId3];
        }
      } // copy the clusterNode edges because we cannot iterate over an object that we add or remove from.


      var edgesToBeDeleted = [];

      for (var i = 0; i < clusterNode.edges.length; i++) {
        edgesToBeDeleted.push(clusterNode.edges[i]);
      } // actually handling the deleting.


      for (var _i3 = 0; _i3 < edgesToBeDeleted.length; _i3++) {
        var edge = edgesToBeDeleted[_i3];

        var otherNodeId = this._getConnectedId(edge, clusterNodeId);

        var otherNode = this.clusteredNodes[otherNodeId];

        for (var j = 0; j < edge.clusteringEdgeReplacingIds.length; j++) {
          var transferId = edge.clusteringEdgeReplacingIds[j];
          var transferEdge = this.body.edges[transferId];
          if (transferEdge === undefined) continue; // if the other node is in another cluster, we transfer ownership of this edge to the other cluster

          if (otherNode !== undefined) {
            // transfer ownership:
            var otherCluster = this.body.nodes[otherNode.clusterId];
            otherCluster.containedEdges[transferEdge.id] = transferEdge; // delete local reference

            delete containedEdges[transferEdge.id]; // get to and from

            var fromId = transferEdge.fromId;
            var toId = transferEdge.toId;

            if (transferEdge.toId == otherNodeId) {
              toId = otherNode.clusterId;
            } else {
              fromId = otherNode.clusterId;
            } // create new cluster edge from the otherCluster


            this._createClusteredEdge(fromId, toId, transferEdge, otherCluster.clusterEdgeProperties, {
              hidden: false,
              physics: true
            });
          } else {
            this._restoreEdge(transferEdge);
          }
        }

        edge.remove();
      } // handle the releasing of the edges


      for (var edgeId in containedEdges) {
        if (Object.prototype.hasOwnProperty.call(containedEdges, edgeId)) {
          this._restoreEdge(containedEdges[edgeId]);
        }
      } // remove clusterNode


      delete this.body.nodes[clusterNodeId];

      if (refreshData === true) {
        this.body.emitter.emit("_dataChanged");
      }
    }
    /**
     *
     * @param {Cluster.id} clusterId
     * @returns {Array.<Node.id>}
     */

  }, {
    key: "getNodesInCluster",
    value: function getNodesInCluster(clusterId) {
      var nodesArray = [];

      if (this.isCluster(clusterId) === true) {
        var containedNodes = this.body.nodes[clusterId].containedNodes;

        for (var nodeId in containedNodes) {
          if (Object.prototype.hasOwnProperty.call(containedNodes, nodeId)) {
            nodesArray.push(this.body.nodes[nodeId].id);
          }
        }
      }

      return nodesArray;
    }
    /**
     * Get the stack clusterId's that a certain node resides in. cluster A -> cluster B -> cluster C -> node
     *
     * If a node can't be found in the chain, return an empty array.
     *
     * @param {string|number} nodeId
     * @returns {Array}
     */

  }, {
    key: "findNode",
    value: function findNode(nodeId) {
      var stack = [];
      var max = 100;
      var counter = 0;
      var node;

      while (this.clusteredNodes[nodeId] !== undefined && counter < max) {
        node = this.body.nodes[nodeId];
        if (node === undefined) return [];
        stack.push(node.id);
        nodeId = this.clusteredNodes[nodeId].clusterId;
        counter++;
      }

      node = this.body.nodes[nodeId];
      if (node === undefined) return [];
      stack.push(node.id);

      reverse(stack).call(stack);

      return stack;
    }
    /**
     * Using a clustered nodeId, update with the new options
     *
     * @param {Node.id} clusteredNodeId
     * @param {object} newOptions
     */

  }, {
    key: "updateClusteredNode",
    value: function updateClusteredNode(clusteredNodeId, newOptions) {
      if (clusteredNodeId === undefined) {
        throw new Error("No clusteredNodeId supplied to updateClusteredNode.");
      }

      if (newOptions === undefined) {
        throw new Error("No newOptions supplied to updateClusteredNode.");
      }

      if (this.body.nodes[clusteredNodeId] === undefined) {
        throw new Error("The clusteredNodeId supplied to updateClusteredNode does not exist.");
      }

      this.body.nodes[clusteredNodeId].setOptions(newOptions);
      this.body.emitter.emit("_dataChanged");
    }
    /**
     * Using a base edgeId, update all related clustered edges with the new options
     *
     * @param {vis.Edge.id} startEdgeId
     * @param {object} newOptions
     */

  }, {
    key: "updateEdge",
    value: function updateEdge(startEdgeId, newOptions) {
      if (startEdgeId === undefined) {
        throw new Error("No startEdgeId supplied to updateEdge.");
      }

      if (newOptions === undefined) {
        throw new Error("No newOptions supplied to updateEdge.");
      }

      if (this.body.edges[startEdgeId] === undefined) {
        throw new Error("The startEdgeId supplied to updateEdge does not exist.");
      }

      var allEdgeIds = this.getClusteredEdges(startEdgeId);

      for (var i = 0; i < allEdgeIds.length; i++) {
        var edge = this.body.edges[allEdgeIds[i]];
        edge.setOptions(newOptions);
      }

      this.body.emitter.emit("_dataChanged");
    }
    /**
     * Get a stack of clusterEdgeId's (+base edgeid) that a base edge is the same as. cluster edge C -> cluster edge B -> cluster edge A -> base edge(edgeId)
     *
     * @param {vis.Edge.id} edgeId
     * @returns {Array.<vis.Edge.id>}
     */

  }, {
    key: "getClusteredEdges",
    value: function getClusteredEdges(edgeId) {
      var stack = [];
      var max = 100;
      var counter = 0;

      while (edgeId !== undefined && this.body.edges[edgeId] !== undefined && counter < max) {
        stack.push(this.body.edges[edgeId].id);
        edgeId = this.body.edges[edgeId].edgeReplacedById;
        counter++;
      }

      reverse(stack).call(stack);

      return stack;
    }
    /**
     * Get the base edge id of clusterEdgeId. cluster edge (clusteredEdgeId) -> cluster edge B -> cluster edge C -> base edge
     *
     * @param {vis.Edge.id} clusteredEdgeId
     * @returns {vis.Edge.id} baseEdgeId
     *
     * TODO: deprecate in 5.0.0. Method getBaseEdges() is the correct one to use.
     */

  }, {
    key: "getBaseEdge",
    value: function getBaseEdge(clusteredEdgeId) {
      // Just kludge this by returning the first base edge id found
      return this.getBaseEdges(clusteredEdgeId)[0];
    }
    /**
     * Get all regular edges for this clustered edge id.
     *
     * @param {vis.Edge.id} clusteredEdgeId
     * @returns {Array.<vis.Edge.id>} all baseEdgeId's under this clustered edge
     */

  }, {
    key: "getBaseEdges",
    value: function getBaseEdges(clusteredEdgeId) {
      var IdsToHandle = [clusteredEdgeId];
      var doneIds = [];
      var foundIds = [];
      var max = 100;
      var counter = 0;

      while (IdsToHandle.length > 0 && counter < max) {
        var nextId = IdsToHandle.pop();
        if (nextId === undefined) continue; // Paranoia here and onwards

        var nextEdge = this.body.edges[nextId];
        if (nextEdge === undefined) continue;
        counter++;
        var replacingIds = nextEdge.clusteringEdgeReplacingIds;

        if (replacingIds === undefined) {
          // nextId is a base id
          foundIds.push(nextId);
        } else {
          // Another cluster edge, unravel this one as well
          for (var i = 0; i < replacingIds.length; ++i) {
            var replacingId = replacingIds[i]; // Don't add if already handled
            // TODO: never triggers; find a test-case which does

            if (indexOf(IdsToHandle).call(IdsToHandle, replacingIds) !== -1 || indexOf(doneIds).call(doneIds, replacingIds) !== -1) {
              continue;
            }

            IdsToHandle.push(replacingId);
          }
        }

        doneIds.push(nextId);
      }

      return foundIds;
    }
    /**
     * Get the Id the node is connected to
     *
     * @param {vis.Edge} edge
     * @param {Node.id} nodeId
     * @returns {*}
     * @private
     */

  }, {
    key: "_getConnectedId",
    value: function _getConnectedId(edge, nodeId) {
      if (edge.toId != nodeId) {
        return edge.toId;
      } else if (edge.fromId != nodeId) {
        return edge.fromId;
      } else {
        return edge.fromId;
      }
    }
    /**
     * We determine how many connections denote an important hub.
     * We take the mean + 2*std as the important hub size. (Assuming a normal distribution of data, ~2.2%)
     *
     * @returns {number}
     * @private
     */

  }, {
    key: "_getHubSize",
    value: function _getHubSize() {
      var average = 0;
      var averageSquared = 0;
      var hubCounter = 0;
      var largestHub = 0;

      for (var i = 0; i < this.body.nodeIndices.length; i++) {
        var node = this.body.nodes[this.body.nodeIndices[i]];

        if (node.edges.length > largestHub) {
          largestHub = node.edges.length;
        }

        average += node.edges.length;
        averageSquared += Math.pow(node.edges.length, 2);
        hubCounter += 1;
      }

      average = average / hubCounter;
      averageSquared = averageSquared / hubCounter;
      var variance = averageSquared - Math.pow(average, 2);
      var standardDeviation = Math.sqrt(variance);
      var hubThreshold = Math.floor(average + 2 * standardDeviation); // always have at least one to cluster

      if (hubThreshold > largestHub) {
        hubThreshold = largestHub;
      }

      return hubThreshold;
    }
    /**
     * Create an edge for the cluster representation.
     *
     * @param {Node.id} fromId
     * @param {Node.id} toId
     * @param {vis.Edge} baseEdge
     * @param {object} clusterEdgeProperties
     * @param {object} extraOptions
     * @returns {Edge} newly created clustered edge
     * @private
     */

  }, {
    key: "_createClusteredEdge",
    value: function _createClusteredEdge(fromId, toId, baseEdge, clusterEdgeProperties, extraOptions) {
      // copy the options of the edge we will replace
      var clonedOptions = NetworkUtil.cloneOptions(baseEdge, "edge"); // make sure the properties of clusterEdges are superimposed on it

      deepExtend(clonedOptions, clusterEdgeProperties); // set up the edge

      clonedOptions.from = fromId;
      clonedOptions.to = toId;
      clonedOptions.id = "clusterEdge:" + v4(); // apply the edge specific options to it if specified

      if (extraOptions !== undefined) {
        deepExtend(clonedOptions, extraOptions);
      }

      var newEdge = this.body.functions.createEdge(clonedOptions);
      newEdge.clusteringEdgeReplacingIds = [baseEdge.id];
      newEdge.connect(); // Register the new edge

      this.body.edges[newEdge.id] = newEdge;
      return newEdge;
    }
    /**
     * Add the passed child nodes and edges to the given cluster node.
     *
     * @param {object | Node} childNodes  hash of nodes or single node to add in cluster
     * @param {object | Edge} childEdges  hash of edges or single edge to take into account when clustering
     * @param {Node} clusterNode  cluster node to add nodes and edges to
     * @param {object} [clusterEdgeProperties]
     * @private
     */

  }, {
    key: "_clusterEdges",
    value: function _clusterEdges(childNodes, childEdges, clusterNode, clusterEdgeProperties) {
      if (childEdges instanceof Edge) {
        var edge = childEdges;
        var obj = {};
        obj[edge.id] = edge;
        childEdges = obj;
      }

      if (childNodes instanceof Node) {
        var node = childNodes;
        var _obj = {};
        _obj[node.id] = node;
        childNodes = _obj;
      }

      if (clusterNode === undefined || clusterNode === null) {
        throw new Error("_clusterEdges: parameter clusterNode required");
      }

      if (clusterEdgeProperties === undefined) {
        // Take the required properties from the cluster node
        clusterEdgeProperties = clusterNode.clusterEdgeProperties;
      } // create the new edges that will connect to the cluster.
      // All self-referencing edges will be added to childEdges here.


      this._createClusterEdges(childNodes, childEdges, clusterNode, clusterEdgeProperties); // disable the childEdges


      for (var edgeId in childEdges) {
        if (Object.prototype.hasOwnProperty.call(childEdges, edgeId)) {
          if (this.body.edges[edgeId] !== undefined) {
            var _edge2 = this.body.edges[edgeId]; // cache the options before changing

            this._backupEdgeOptions(_edge2); // disable physics and hide the edge


            _edge2.setOptions({
              physics: false
            });
          }
        }
      } // disable the childNodes


      for (var nodeId in childNodes) {
        if (Object.prototype.hasOwnProperty.call(childNodes, nodeId)) {
          this.clusteredNodes[nodeId] = {
            clusterId: clusterNode.id,
            node: this.body.nodes[nodeId]
          };
          this.body.nodes[nodeId].setOptions({
            physics: false
          });
        }
      }
    }
    /**
     * Determine in which cluster given nodeId resides.
     *
     * If not in cluster, return undefined.
     *
     * NOTE: If you know a cleaner way to do this, please enlighten me (wimrijnders).
     *
     * @param {Node.id} nodeId
     * @returns {Node|undefined} Node instance for cluster, if present
     * @private
     */

  }, {
    key: "_getClusterNodeForNode",
    value: function _getClusterNodeForNode(nodeId) {
      if (nodeId === undefined) return undefined;
      var clusteredNode = this.clusteredNodes[nodeId]; // NOTE: If no cluster info found, it should actually be an error

      if (clusteredNode === undefined) return undefined;
      var clusterId = clusteredNode.clusterId;
      if (clusterId === undefined) return undefined;
      return this.body.nodes[clusterId];
    }
    /**
     * Internal helper function for conditionally removing items in array
     *
     * Done like this because Array.filter() is not fully supported by all IE's.
     *
     * @param {Array} arr
     * @param {Function} callback
     * @returns {Array}
     * @private
     */

  }, {
    key: "_filter",
    value: function _filter(arr, callback) {
      var ret = [];
      forEach$1(arr, function (item) {
        if (callback(item)) {
          ret.push(item);
        }
      });
      return ret;
    }
    /**
     * Scan all edges for changes in clustering and adjust this if necessary.
     *
     * Call this (internally) after there has been a change in node or edge data.
     *
     * Pre: States of this.body.nodes and this.body.edges consistent
     * Pre: this.clusteredNodes and this.clusteredEdge consistent with containedNodes and containedEdges
     *      of cluster nodes.
     */

  }, {
    key: "_updateState",
    value: function _updateState() {
      var _this4 = this;

      var nodeId;
      var deletedNodeIds = [];
      var deletedEdgeIds = {};
      /**
       * Utility function to iterate over clustering nodes only
       *
       * @param {Function} callback  function to call for each cluster node
       */

      var eachClusterNode = function eachClusterNode(callback) {
        forEach$1(_this4.body.nodes, function (node) {
          if (node.isCluster === true) {
            callback(node);
          }
        });
      }; //
      // Remove deleted regular nodes from clustering
      //
      // Determine the deleted nodes


      for (nodeId in this.clusteredNodes) {
        if (!Object.prototype.hasOwnProperty.call(this.clusteredNodes, nodeId)) continue;
        var node = this.body.nodes[nodeId];

        if (node === undefined) {
          deletedNodeIds.push(nodeId);
        }
      } // Remove nodes from cluster nodes


      eachClusterNode(function (clusterNode) {
        for (var n = 0; n < deletedNodeIds.length; n++) {
          delete clusterNode.containedNodes[deletedNodeIds[n]];
        }
      }); // Remove nodes from cluster list

      for (var n = 0; n < deletedNodeIds.length; n++) {
        delete this.clusteredNodes[deletedNodeIds[n]];
      } //
      // Remove deleted edges from clustering
      //
      // Add the deleted clustered edges to the list


      forEach$1(this.clusteredEdges, function (edgeId) {
        var edge = _this4.body.edges[edgeId];

        if (edge === undefined || !edge.endPointsValid()) {
          deletedEdgeIds[edgeId] = edgeId;
        }
      }); // Cluster nodes can also contain edges which are not clustered,
      // i.e. nodes 1-2 within cluster with an edge in between.
      // So the cluster nodes also need to be scanned for invalid edges

      eachClusterNode(function (clusterNode) {
        forEach$1(clusterNode.containedEdges, function (edge, edgeId) {
          if (!edge.endPointsValid() && !deletedEdgeIds[edgeId]) {
            deletedEdgeIds[edgeId] = edgeId;
          }
        });
      }); // Also scan for cluster edges which need to be removed in the active list.
      // Regular edges have been removed beforehand, so this only picks up the cluster edges.

      forEach$1(this.body.edges, function (edge, edgeId) {
        // Explicitly scan the contained edges for validity
        var isValid = true;
        var replacedIds = edge.clusteringEdgeReplacingIds;

        if (replacedIds !== undefined) {
          var numValid = 0;
          forEach$1(replacedIds, function (containedEdgeId) {
            var containedEdge = _this4.body.edges[containedEdgeId];

            if (containedEdge !== undefined && containedEdge.endPointsValid()) {
              numValid += 1;
            }
          });
          isValid = numValid > 0;
        }

        if (!edge.endPointsValid() || !isValid) {
          deletedEdgeIds[edgeId] = edgeId;
        }
      }); // Remove edges from cluster nodes

      eachClusterNode(function (clusterNode) {
        forEach$1(deletedEdgeIds, function (deletedEdgeId) {
          delete clusterNode.containedEdges[deletedEdgeId];
          forEach$1(clusterNode.edges, function (edge, m) {
            if (edge.id === deletedEdgeId) {
              clusterNode.edges[m] = null; // Don't want to directly delete here, because in the loop

              return;
            }

            edge.clusteringEdgeReplacingIds = _this4._filter(edge.clusteringEdgeReplacingIds, function (id) {
              return !deletedEdgeIds[id];
            });
          }); // Clean up the nulls

          clusterNode.edges = _this4._filter(clusterNode.edges, function (item) {
            return item !== null;
          });
        });
      }); // Remove from cluster list

      forEach$1(deletedEdgeIds, function (edgeId) {
        delete _this4.clusteredEdges[edgeId];
      }); // Remove cluster edges from active list (this.body.edges).
      // deletedEdgeIds still contains id of regular edges, but these should all
      // be gone when you reach here.

      forEach$1(deletedEdgeIds, function (edgeId) {
        delete _this4.body.edges[edgeId];
      }); //
      // Check changed cluster state of edges
      //
      // Iterating over keys here, because edges may be removed in the loop

      var ids = keys$4(this.body.edges);

      forEach$1(ids, function (edgeId) {
        var edge = _this4.body.edges[edgeId];

        var shouldBeClustered = _this4._isClusteredNode(edge.fromId) || _this4._isClusteredNode(edge.toId);

        if (shouldBeClustered === _this4._isClusteredEdge(edge.id)) {
          return; // all is well
        }

        if (shouldBeClustered) {
          // add edge to clustering
          var clusterFrom = _this4._getClusterNodeForNode(edge.fromId);

          if (clusterFrom !== undefined) {
            _this4._clusterEdges(_this4.body.nodes[edge.fromId], edge, clusterFrom);
          }

          var clusterTo = _this4._getClusterNodeForNode(edge.toId);

          if (clusterTo !== undefined) {
            _this4._clusterEdges(_this4.body.nodes[edge.toId], edge, clusterTo);
          } // TODO: check that it works for both edges clustered
          //       (This might be paranoia)

        } else {
          delete _this4._clusterEdges[edgeId];

          _this4._restoreEdge(edge); // This should not be happening, the state should
          // be properly updated at this point.
          //
          // If it *is* reached during normal operation, then we have to implement
          // undo clustering for this edge here.
          // throw new Error('remove edge from clustering not implemented!')

        }
      }); // Clusters may be nested to any level. Keep on opening until nothing to open

      var changed = false;
      var continueLoop = true;

      var _loop2 = function _loop2() {
        var clustersToOpen = []; // Determine the id's of clusters that need opening

        eachClusterNode(function (clusterNode) {
          var numNodes = keys$4(clusterNode.containedNodes).length;

          var allowSingle = clusterNode.options.allowSingleNodeCluster === true;

          if (allowSingle && numNodes < 1 || !allowSingle && numNodes < 2) {
            clustersToOpen.push(clusterNode.id);
          }
        }); // Open them

        for (var _n = 0; _n < clustersToOpen.length; ++_n) {
          _this4.openCluster(clustersToOpen[_n], {}, false
          /* Don't refresh, we're in an refresh/update already */
          );
        }

        continueLoop = clustersToOpen.length > 0;
        changed = changed || continueLoop;
      };

      while (continueLoop) {
        _loop2();
      }

      if (changed) {
        this._updateState(); // Redo this method (recursion possible! should be safe)

      }
    }
    /**
     * Determine if node with given id is part of a cluster.
     *
     * @param {Node.id} nodeId
     * @returns {boolean} true if part of a cluster.
     */

  }, {
    key: "_isClusteredNode",
    value: function _isClusteredNode(nodeId) {
      return this.clusteredNodes[nodeId] !== undefined;
    }
    /**
     * Determine if edge with given id is not visible due to clustering.
     *
     * An edge is considered clustered if:
     * - it is directly replaced by a clustering edge
     * - any of its connecting nodes is in a cluster
     *
     * @param {vis.Edge.id} edgeId
     * @returns {boolean} true if part of a cluster.
     */

  }, {
    key: "_isClusteredEdge",
    value: function _isClusteredEdge(edgeId) {
      return this.clusteredEdges[edgeId] !== undefined;
    }
  }]);

  return ClusterEngine;
}();

function _createForOfIteratorHelper$5(o, allowArrayLike) { var it = typeof symbol !== "undefined" && getIteratorMethod$2(o) || o["@@iterator"]; if (!it) { if (isArray$2(o) || (it = _unsupportedIterableToArray$5(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$5(o, minLen) { var _context4; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$5(o, minLen); var n = slice$1(_context4 = Object.prototype.toString.call(o)).call(_context4, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return from$2(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$5(o, minLen); }

function _arrayLikeToArray$5(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
/**
 * Initializes window.requestAnimationFrame() to a usable form.
 *
 * Specifically, set up this method for the case of running on node.js with jsdom enabled.
 *
 * NOTES:
 *
 * * On node.js, when calling this directly outside of this class, `window` is not defined.
 *   This happens even if jsdom is used.
 * * For node.js + jsdom, `window` is available at the moment the constructor is called.
 *   For this reason, the called is placed within the constructor.
 * * Even then, `window.requestAnimationFrame()` is not defined, so it still needs to be added.
 * * During unit testing, it happens that the window object is reset during execution, causing
 *   a runtime error due to missing `requestAnimationFrame()`. This needs to be compensated for,
 *   see `_requestNextFrame()`.
 * * Since this is a global object, it may affect other modules besides `Network`. With normal
 *   usage, this does not cause any problems. During unit testing, errors may occur. These have
 *   been compensated for, see comment block in _requestNextFrame().
 *
 * @private
 */

function _initRequestAnimationFrame() {
  var func;

  if (window !== undefined) {
    func = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
  }

  if (func === undefined) {
    // window or method not present, setting mock requestAnimationFrame
    window.requestAnimationFrame = function (callback) {
      //console.log("Called mock requestAnimationFrame");
      callback();
    };
  } else {
    window.requestAnimationFrame = func;
  }
}
/**
 * The canvas renderer
 */


var CanvasRenderer = /*#__PURE__*/function () {
  /**
   * @param {object} body
   * @param {Canvas} canvas
   */
  function CanvasRenderer(body, canvas) {
    _classCallCheck(this, CanvasRenderer);

    _initRequestAnimationFrame();

    this.body = body;
    this.canvas = canvas;
    this.redrawRequested = false;
    this.renderTimer = undefined;
    this.requiresTimeout = true;
    this.renderingActive = false;
    this.renderRequests = 0;
    this.allowRedraw = true;
    this.dragging = false;
    this.zooming = false;
    this.options = {};
    this.defaultOptions = {
      hideEdgesOnDrag: false,
      hideEdgesOnZoom: false,
      hideNodesOnDrag: false
    };

    assign$2(this.options, this.defaultOptions);

    this._determineBrowserMethod();

    this.bindEventListeners();
  }
  /**
   * Binds event listeners
   */


  _createClass(CanvasRenderer, [{
    key: "bindEventListeners",
    value: function bindEventListeners() {
      var _this = this,
          _context2;

      this.body.emitter.on("dragStart", function () {
        _this.dragging = true;
      });
      this.body.emitter.on("dragEnd", function () {
        _this.dragging = false;
      });
      this.body.emitter.on("zoom", function () {
        _this.zooming = true;
        window.clearTimeout(_this.zoomTimeoutId);
        _this.zoomTimeoutId = setTimeout$1(function () {
          var _context;

          _this.zooming = false;

          bind$6(_context = _this._requestRedraw).call(_context, _this)();
        }, 250);
      });
      this.body.emitter.on("_resizeNodes", function () {
        _this._resizeNodes();
      });
      this.body.emitter.on("_redraw", function () {
        if (_this.renderingActive === false) {
          _this._redraw();
        }
      });
      this.body.emitter.on("_blockRedraw", function () {
        _this.allowRedraw = false;
      });
      this.body.emitter.on("_allowRedraw", function () {
        _this.allowRedraw = true;
        _this.redrawRequested = false;
      });
      this.body.emitter.on("_requestRedraw", bind$6(_context2 = this._requestRedraw).call(_context2, this));
      this.body.emitter.on("_startRendering", function () {
        _this.renderRequests += 1;
        _this.renderingActive = true;

        _this._startRendering();
      });
      this.body.emitter.on("_stopRendering", function () {
        _this.renderRequests -= 1;
        _this.renderingActive = _this.renderRequests > 0;
        _this.renderTimer = undefined;
      });
      this.body.emitter.on("destroy", function () {
        _this.renderRequests = 0;
        _this.allowRedraw = false;
        _this.renderingActive = false;

        if (_this.requiresTimeout === true) {
          clearTimeout(_this.renderTimer);
        } else {
          window.cancelAnimationFrame(_this.renderTimer);
        }

        _this.body.emitter.off();
      });
    }
    /**
     *
     * @param {object} options
     */

  }, {
    key: "setOptions",
    value: function setOptions(options) {
      if (options !== undefined) {
        var fields = ["hideEdgesOnDrag", "hideEdgesOnZoom", "hideNodesOnDrag"];
        selectiveDeepExtend(fields, this.options, options);
      }
    }
    /**
     * Prepare the drawing of the next frame.
     *
     * Calls the callback when the next frame can or will be drawn.
     *
     * @param {Function} callback
     * @param {number} delay - timeout case only, wait this number of milliseconds
     * @returns {Function | undefined}
     * @private
     */

  }, {
    key: "_requestNextFrame",
    value: function _requestNextFrame(callback, delay) {
      // During unit testing, it happens that the mock window object is reset while
      // the next frame is still pending. Then, either 'window' is not present, or
      // 'requestAnimationFrame()' is not present because it is not defined on the
      // mock window object.
      //
      // As a consequence, unrelated unit tests may appear to fail, even if the problem
      // described happens in the current unit test.
      //
      // This is not something that will happen in normal operation, but we still need
      // to take it into account.
      //
      if (typeof window === "undefined") return; // Doing `if (window === undefined)` does not work here!

      var timer;
      var myWindow = window; // Grab a reference to reduce the possibility that 'window' is reset
      // while running this method.

      if (this.requiresTimeout === true) {
        // wait given number of milliseconds and perform the animation step function
        timer = setTimeout$1(callback, delay);
      } else {
        if (myWindow.requestAnimationFrame) {
          timer = myWindow.requestAnimationFrame(callback);
        }
      }

      return timer;
    }
    /**
     *
     * @private
     */

  }, {
    key: "_startRendering",
    value: function _startRendering() {
      if (this.renderingActive === true) {
        if (this.renderTimer === undefined) {
          var _context3;

          this.renderTimer = this._requestNextFrame(bind$6(_context3 = this._renderStep).call(_context3, this), this.simulationInterval);
        }
      }
    }
    /**
     *
     * @private
     */

  }, {
    key: "_renderStep",
    value: function _renderStep() {
      if (this.renderingActive === true) {
        // reset the renderTimer so a new scheduled animation step can be set
        this.renderTimer = undefined;

        if (this.requiresTimeout === true) {
          // this schedules a new simulation step
          this._startRendering();
        }

        this._redraw();

        if (this.requiresTimeout === false) {
          // this schedules a new simulation step
          this._startRendering();
        }
      }
    }
    /**
     * Redraw the network with the current data
     * chart will be resized too.
     */

  }, {
    key: "redraw",
    value: function redraw() {
      this.body.emitter.emit("setSize");

      this._redraw();
    }
    /**
     * Redraw the network with the current data
     *
     * @private
     */

  }, {
    key: "_requestRedraw",
    value: function _requestRedraw() {
      var _this2 = this;

      if (this.redrawRequested !== true && this.renderingActive === false && this.allowRedraw === true) {
        this.redrawRequested = true;

        this._requestNextFrame(function () {
          _this2._redraw(false);
        }, 0);
      }
    }
    /**
     * Redraw the network with the current data
     *
     * @param {boolean} [hidden=false] | Used to get the first estimate of the node sizes.
     *                                   Only the nodes are drawn after which they are quickly drawn over.
     * @private
     */

  }, {
    key: "_redraw",
    value: function _redraw() {
      var hidden = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

      if (this.allowRedraw === true) {
        this.body.emitter.emit("initRedraw");
        this.redrawRequested = false;
        var drawLater = {
          drawExternalLabels: null
        }; // when the container div was hidden, this fixes it back up!

        if (this.canvas.frame.canvas.width === 0 || this.canvas.frame.canvas.height === 0) {
          this.canvas.setSize();
        }

        this.canvas.setTransform();
        var ctx = this.canvas.getContext(); // clear the canvas

        var w = this.canvas.frame.canvas.clientWidth;
        var h = this.canvas.frame.canvas.clientHeight;
        ctx.clearRect(0, 0, w, h); // if the div is hidden, we stop the redraw here for performance.

        if (this.canvas.frame.clientWidth === 0) {
          return;
        } // set scaling and translation


        ctx.save();
        ctx.translate(this.body.view.translation.x, this.body.view.translation.y);
        ctx.scale(this.body.view.scale, this.body.view.scale);
        ctx.beginPath();
        this.body.emitter.emit("beforeDrawing", ctx);
        ctx.closePath();

        if (hidden === false) {
          if ((this.dragging === false || this.dragging === true && this.options.hideEdgesOnDrag === false) && (this.zooming === false || this.zooming === true && this.options.hideEdgesOnZoom === false)) {
            this._drawEdges(ctx);
          }
        }

        if (this.dragging === false || this.dragging === true && this.options.hideNodesOnDrag === false) {
          var _this$_drawNodes = this._drawNodes(ctx, hidden),
              drawExternalLabels = _this$_drawNodes.drawExternalLabels;

          drawLater.drawExternalLabels = drawExternalLabels;
        } // draw the arrows last so they will be at the top


        if (hidden === false) {
          if ((this.dragging === false || this.dragging === true && this.options.hideEdgesOnDrag === false) && (this.zooming === false || this.zooming === true && this.options.hideEdgesOnZoom === false)) {
            this._drawArrows(ctx);
          }
        }

        if (drawLater.drawExternalLabels != null) {
          drawLater.drawExternalLabels();
        }

        if (hidden === false) {
          this._drawSelectionBox(ctx);
        }

        ctx.beginPath();
        this.body.emitter.emit("afterDrawing", ctx);
        ctx.closePath(); // restore original scaling and translation

        ctx.restore();

        if (hidden === true) {
          ctx.clearRect(0, 0, w, h);
        }
      }
    }
    /**
     * Redraw all nodes
     *
     * @param {CanvasRenderingContext2D}   ctx
     * @param {boolean} [alwaysShow]
     * @private
     */

  }, {
    key: "_resizeNodes",
    value: function _resizeNodes() {
      this.canvas.setTransform();
      var ctx = this.canvas.getContext();
      ctx.save();
      ctx.translate(this.body.view.translation.x, this.body.view.translation.y);
      ctx.scale(this.body.view.scale, this.body.view.scale);
      var nodes = this.body.nodes;
      var node; // resize all nodes

      for (var nodeId in nodes) {
        if (Object.prototype.hasOwnProperty.call(nodes, nodeId)) {
          node = nodes[nodeId];
          node.resize(ctx);
          node.updateBoundingBox(ctx, node.selected);
        }
      } // restore original scaling and translation


      ctx.restore();
    }
    /**
     * Redraw all nodes
     *
     * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
     * @param {boolean} [alwaysShow]
     * @private
     *
     * @returns {object} Callbacks to draw later on higher layers.
     */

  }, {
    key: "_drawNodes",
    value: function _drawNodes(ctx) {
      var alwaysShow = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var nodes = this.body.nodes;
      var nodeIndices = this.body.nodeIndices;
      var node;
      var selected = [];
      var hovered = [];
      var margin = 20;
      var topLeft = this.canvas.DOMtoCanvas({
        x: -margin,
        y: -margin
      });
      var bottomRight = this.canvas.DOMtoCanvas({
        x: this.canvas.frame.canvas.clientWidth + margin,
        y: this.canvas.frame.canvas.clientHeight + margin
      });
      var viewableArea = {
        top: topLeft.y,
        left: topLeft.x,
        bottom: bottomRight.y,
        right: bottomRight.x
      };
      var _drawExternalLabels = []; // draw unselected nodes;

      for (var _i = 0; _i < nodeIndices.length; _i++) {
        node = nodes[nodeIndices[_i]]; // set selected and hovered nodes aside

        if (node.hover) {
          hovered.push(nodeIndices[_i]);
        } else if (node.isSelected()) {
          selected.push(nodeIndices[_i]);
        } else {
          if (alwaysShow === true) {
            var drawLater = node.draw(ctx);

            if (drawLater.drawExternalLabel != null) {
              _drawExternalLabels.push(drawLater.drawExternalLabel);
            }
          } else if (node.isBoundingBoxOverlappingWith(viewableArea) === true) {
            var _drawLater = node.draw(ctx);

            if (_drawLater.drawExternalLabel != null) {
              _drawExternalLabels.push(_drawLater.drawExternalLabel);
            }
          } else {
            node.updateBoundingBox(ctx, node.selected);
          }
        }
      }

      var i;
      var selectedLength = selected.length;
      var hoveredLength = hovered.length; // draw the selected nodes on top

      for (i = 0; i < selectedLength; i++) {
        node = nodes[selected[i]];

        var _drawLater2 = node.draw(ctx);

        if (_drawLater2.drawExternalLabel != null) {
          _drawExternalLabels.push(_drawLater2.drawExternalLabel);
        }
      } // draw hovered nodes above everything else: fixes https://github.com/visjs/vis-network/issues/226


      for (i = 0; i < hoveredLength; i++) {
        node = nodes[hovered[i]];

        var _drawLater3 = node.draw(ctx);

        if (_drawLater3.drawExternalLabel != null) {
          _drawExternalLabels.push(_drawLater3.drawExternalLabel);
        }
      }

      return {
        drawExternalLabels: function drawExternalLabels() {
          var _iterator = _createForOfIteratorHelper$5(_drawExternalLabels),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var draw = _step.value;
              draw();
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }
      };
    }
    /**
     * Redraw all edges
     *
     * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
     * @private
     */

  }, {
    key: "_drawEdges",
    value: function _drawEdges(ctx) {
      var edges = this.body.edges;
      var edgeIndices = this.body.edgeIndices;

      for (var i = 0; i < edgeIndices.length; i++) {
        var edge = edges[edgeIndices[i]];

        if (edge.connected === true) {
          edge.draw(ctx);
        }
      }
    }
    /**
     * Redraw all arrows
     *
     * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
     * @private
     */

  }, {
    key: "_drawArrows",
    value: function _drawArrows(ctx) {
      var edges = this.body.edges;
      var edgeIndices = this.body.edgeIndices;

      for (var i = 0; i < edgeIndices.length; i++) {
        var edge = edges[edgeIndices[i]];

        if (edge.connected === true) {
          edge.drawArrows(ctx);
        }
      }
    }
    /**
     * Determine if the browser requires a setTimeout or a requestAnimationFrame. This was required because
     * some implementations (safari and IE9) did not support requestAnimationFrame
     *
     * @private
     */

  }, {
    key: "_determineBrowserMethod",
    value: function _determineBrowserMethod() {
      if (typeof window !== "undefined") {
        var browserType = navigator.userAgent.toLowerCase();
        this.requiresTimeout = false;

        if (indexOf(browserType).call(browserType, "msie 9.0") != -1) {
          // IE 9
          this.requiresTimeout = true;
        } else if (indexOf(browserType).call(browserType, "safari") != -1) {
          // safari
          if (indexOf(browserType).call(browserType, "chrome") <= -1) {
            this.requiresTimeout = true;
          }
        }
      } else {
        this.requiresTimeout = true;
      }
    }
    /**
     * Redraw selection box
     *
     * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
     * @private
     */

  }, {
    key: "_drawSelectionBox",
    value: function _drawSelectionBox(ctx) {
      if (this.body.selectionBox.show) {
        ctx.beginPath();
        var width = this.body.selectionBox.position.end.x - this.body.selectionBox.position.start.x;
        var height = this.body.selectionBox.position.end.y - this.body.selectionBox.position.start.y;
        ctx.rect(this.body.selectionBox.position.start.x, this.body.selectionBox.position.start.y, width, height);
        ctx.fillStyle = "rgba(151, 194, 252, 0.2)";
        ctx.fillRect(this.body.selectionBox.position.start.x, this.body.selectionBox.position.start.y, width, height);
        ctx.strokeStyle = "rgba(151, 194, 252, 1)";
        ctx.stroke();
      } else {
        ctx.closePath();
      }
    }
  }]);

  return CanvasRenderer;
}();

var path$1 = path$x;
var setInterval$1 = path$1.setInterval;

var setInterval = setInterval$1;

/**
 * Register a touch event, taking place before a gesture
 *
 * @param {Hammer} hammer       A hammer instance
 * @param {Function} callback   Callback, called as callback(event)
 */
function onTouch(hammer, callback) {
  callback.inputHandler = function (event) {
    if (event.isFirst) {
      callback(event);
    }
  };

  hammer.on("hammer.input", callback.inputHandler);
}
/**
 * Register a release event, taking place after a gesture
 *
 * @param {Hammer} hammer       A hammer instance
 * @param {Function} callback   Callback, called as callback(event)
 * @returns {*}
 */

function onRelease(hammer, callback) {
  callback.inputHandler = function (event) {
    if (event.isFinal) {
      callback(event);
    }
  };

  return hammer.on("hammer.input", callback.inputHandler);
}

/**
 * Create the main frame for the Network.
 * This function is executed once when a Network object is created. The frame
 * contains a canvas, and this canvas contains all objects like the axis and
 * nodes.
 */

var Canvas = /*#__PURE__*/function () {
  /**
   * @param {object} body
   */
  function Canvas(body) {
    _classCallCheck(this, Canvas);

    this.body = body;
    this.pixelRatio = 1;
    this.cameraState = {};
    this.initialized = false;
    this.canvasViewCenter = {};
    this._cleanupCallbacks = [];
    this.options = {};
    this.defaultOptions = {
      autoResize: true,
      height: "100%",
      width: "100%"
    };

    assign$2(this.options, this.defaultOptions);

    this.bindEventListeners();
  }
  /**
   * Binds event listeners
   */


  _createClass(Canvas, [{
    key: "bindEventListeners",
    value: function bindEventListeners() {
      var _this = this,
          _context;

      // bind the events
      this.body.emitter.once("resize", function (obj) {
        if (obj.width !== 0) {
          _this.body.view.translation.x = obj.width * 0.5;
        }

        if (obj.height !== 0) {
          _this.body.view.translation.y = obj.height * 0.5;
        }
      });
      this.body.emitter.on("setSize", bind$6(_context = this.setSize).call(_context, this));
      this.body.emitter.on("destroy", function () {
        _this.hammerFrame.destroy();

        _this.hammer.destroy();

        _this._cleanUp();
      });
    }
    /**
     * @param {object} options
     */

  }, {
    key: "setOptions",
    value: function setOptions(options) {
      var _this2 = this;

      if (options !== undefined) {
        var fields = ["width", "height", "autoResize"];
        selectiveDeepExtend(fields, this.options, options);
      } // Automatically adapt to changing size of the container element.


      this._cleanUp();

      if (this.options.autoResize === true) {
        var _context2;

        if (window.ResizeObserver) {
          // decent browsers, immediate reactions
          var observer = new ResizeObserver(function () {
            var changed = _this2.setSize();

            if (changed === true) {
              _this2.body.emitter.emit("_requestRedraw");
            }
          });
          var frame = this.frame;
          observer.observe(frame);

          this._cleanupCallbacks.push(function () {
            observer.unobserve(frame);
          });
        } else {
          // IE11, continous polling
          var resizeTimer = setInterval(function () {
            var changed = _this2.setSize();

            if (changed === true) {
              _this2.body.emitter.emit("_requestRedraw");
            }
          }, 1000);

          this._cleanupCallbacks.push(function () {
            clearInterval(resizeTimer);
          });
        } // Automatically adapt to changing size of the browser.


        var resizeFunction = bind$6(_context2 = this._onResize).call(_context2, this);

        addEventListener(window, "resize", resizeFunction);

        this._cleanupCallbacks.push(function () {
          removeEventListener(window, "resize", resizeFunction);
        });
      }
    }
    /**
     * @private
     */

  }, {
    key: "_cleanUp",
    value: function _cleanUp() {
      var _context3, _context4, _context5;

      forEach$2(_context3 = reverse(_context4 = splice(_context5 = this._cleanupCallbacks).call(_context5, 0)).call(_context4)).call(_context3, function (callback) {
        try {
          callback();
        } catch (error) {
          console.error(error);
        }
      });
    }
    /**
     * @private
     */

  }, {
    key: "_onResize",
    value: function _onResize() {
      this.setSize();
      this.body.emitter.emit("_redraw");
    }
    /**
     * Get and store the cameraState
     *
     * @param {number} [pixelRatio=this.pixelRatio]
     * @private
     */

  }, {
    key: "_getCameraState",
    value: function _getCameraState() {
      var pixelRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.pixelRatio;

      if (this.initialized === true) {
        this.cameraState.previousWidth = this.frame.canvas.width / pixelRatio;
        this.cameraState.previousHeight = this.frame.canvas.height / pixelRatio;
        this.cameraState.scale = this.body.view.scale;
        this.cameraState.position = this.DOMtoCanvas({
          x: 0.5 * this.frame.canvas.width / pixelRatio,
          y: 0.5 * this.frame.canvas.height / pixelRatio
        });
      }
    }
    /**
     * Set the cameraState
     *
     * @private
     */

  }, {
    key: "_setCameraState",
    value: function _setCameraState() {
      if (this.cameraState.scale !== undefined && this.frame.canvas.clientWidth !== 0 && this.frame.canvas.clientHeight !== 0 && this.pixelRatio !== 0 && this.cameraState.previousWidth > 0 && this.cameraState.previousHeight > 0) {
        var widthRatio = this.frame.canvas.width / this.pixelRatio / this.cameraState.previousWidth;
        var heightRatio = this.frame.canvas.height / this.pixelRatio / this.cameraState.previousHeight;
        var newScale = this.cameraState.scale;

        if (widthRatio != 1 && heightRatio != 1) {
          newScale = this.cameraState.scale * 0.5 * (widthRatio + heightRatio);
        } else if (widthRatio != 1) {
          newScale = this.cameraState.scale * widthRatio;
        } else if (heightRatio != 1) {
          newScale = this.cameraState.scale * heightRatio;
        }

        this.body.view.scale = newScale; // this comes from the view module.

        var currentViewCenter = this.DOMtoCanvas({
          x: 0.5 * this.frame.canvas.clientWidth,
          y: 0.5 * this.frame.canvas.clientHeight
        });
        var distanceFromCenter = {
          // offset from view, distance view has to change by these x and y to center the node
          x: currentViewCenter.x - this.cameraState.position.x,
          y: currentViewCenter.y - this.cameraState.position.y
        };
        this.body.view.translation.x += distanceFromCenter.x * this.body.view.scale;
        this.body.view.translation.y += distanceFromCenter.y * this.body.view.scale;
      }
    }
    /**
     *
     * @param {number|string} value
     * @returns {string}
     * @private
     */

  }, {
    key: "_prepareValue",
    value: function _prepareValue(value) {
      if (typeof value === "number") {
        return value + "px";
      } else if (typeof value === "string") {
        if (indexOf(value).call(value, "%") !== -1 || indexOf(value).call(value, "px") !== -1) {
          return value;
        } else if (indexOf(value).call(value, "%") === -1) {
          return value + "px";
        }
      }

      throw new Error("Could not use the value supplied for width or height:" + value);
    }
    /**
     * Create the HTML
     */

  }, {
    key: "_create",
    value: function _create() {
      // remove all elements from the container element.
      while (this.body.container.hasChildNodes()) {
        this.body.container.removeChild(this.body.container.firstChild);
      }

      this.frame = document.createElement("div");
      this.frame.className = "vis-network";
      this.frame.style.position = "relative";
      this.frame.style.overflow = "hidden";
      this.frame.tabIndex = 0; // tab index is required for keycharm to bind keystrokes to the div instead of the window
      //////////////////////////////////////////////////////////////////

      this.frame.canvas = document.createElement("canvas");
      this.frame.canvas.style.position = "relative";
      this.frame.appendChild(this.frame.canvas);

      if (!this.frame.canvas.getContext) {
        var noCanvas = document.createElement("DIV");
        noCanvas.style.color = "red";
        noCanvas.style.fontWeight = "bold";
        noCanvas.style.padding = "10px";
        noCanvas.innerText = "Error: your browser does not support HTML canvas";
        this.frame.canvas.appendChild(noCanvas);
      } else {
        this._setPixelRatio();

        this.setTransform();
      } // add the frame to the container element


      this.body.container.appendChild(this.frame);
      this.body.view.scale = 1;
      this.body.view.translation = {
        x: 0.5 * this.frame.canvas.clientWidth,
        y: 0.5 * this.frame.canvas.clientHeight
      };

      this._bindHammer();
    }
    /**
     * This function binds hammer, it can be repeated over and over due to the uniqueness check.
     *
     * @private
     */

  }, {
    key: "_bindHammer",
    value: function _bindHammer() {
      var _this3 = this;

      if (this.hammer !== undefined) {
        this.hammer.destroy();
      }

      this.drag = {};
      this.pinch = {}; // init hammer

      this.hammer = new Hammer$1(this.frame.canvas);
      this.hammer.get("pinch").set({
        enable: true
      }); // enable to get better response, todo: test on mobile.

      this.hammer.get("pan").set({
        threshold: 5,
        direction: Hammer$1.DIRECTION_ALL
      });
      onTouch(this.hammer, function (event) {
        _this3.body.eventListeners.onTouch(event);
      });
      this.hammer.on("tap", function (event) {
        _this3.body.eventListeners.onTap(event);
      });
      this.hammer.on("doubletap", function (event) {
        _this3.body.eventListeners.onDoubleTap(event);
      });
      this.hammer.on("press", function (event) {
        _this3.body.eventListeners.onHold(event);
      });
      this.hammer.on("panstart", function (event) {
        _this3.body.eventListeners.onDragStart(event);
      });
      this.hammer.on("panmove", function (event) {
        _this3.body.eventListeners.onDrag(event);
      });
      this.hammer.on("panend", function (event) {
        _this3.body.eventListeners.onDragEnd(event);
      });
      this.hammer.on("pinch", function (event) {
        _this3.body.eventListeners.onPinch(event);
      }); // TODO: neatly cleanup these handlers when re-creating the Canvas, IF these are done with hammer, event.stopPropagation will not work?

      this.frame.canvas.addEventListener("wheel", function (event) {
        _this3.body.eventListeners.onMouseWheel(event);
      });
      this.frame.canvas.addEventListener("mousemove", function (event) {
        _this3.body.eventListeners.onMouseMove(event);
      });
      this.frame.canvas.addEventListener("contextmenu", function (event) {
        _this3.body.eventListeners.onContext(event);
      });
      this.hammerFrame = new Hammer$1(this.frame);
      onRelease(this.hammerFrame, function (event) {
        _this3.body.eventListeners.onRelease(event);
      });
    }
    /**
     * Set a new size for the network
     *
     * @param {string} width   Width in pixels or percentage (for example '800px'
     *                         or '50%')
     * @param {string} height  Height in pixels or percentage  (for example '400px'
     *                         or '30%')
     * @returns {boolean}
     */

  }, {
    key: "setSize",
    value: function setSize() {
      var width = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.options.width;
      var height = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.options.height;
      width = this._prepareValue(width);
      height = this._prepareValue(height);
      var emitEvent = false;
      var oldWidth = this.frame.canvas.width;
      var oldHeight = this.frame.canvas.height; // update the pixel ratio
      //
      // NOTE: Comment in following is rather inconsistent; this is the ONLY place in the code
      //       where it is assumed that the pixel ratio could change at runtime.
      //       The only way I can think of this happening is a rotating screen or tablet; but then
      //       there should be a mechanism for reloading the data (TODO: check if this is present).
      //
      //       If the assumption is true (i.e. pixel ratio can change at runtime), then *all* usage
      //       of pixel ratio must be overhauled for this.
      //
      //       For the time being, I will humor the assumption here, and in the rest of the code assume it is
      //       constant.

      var previousRatio = this.pixelRatio; // we cache this because the camera state storage needs the old value

      this._setPixelRatio();

      if (width != this.options.width || height != this.options.height || this.frame.style.width != width || this.frame.style.height != height) {
        this._getCameraState(previousRatio);

        this.frame.style.width = width;
        this.frame.style.height = height;
        this.frame.canvas.style.width = "100%";
        this.frame.canvas.style.height = "100%";
        this.frame.canvas.width = Math.round(this.frame.canvas.clientWidth * this.pixelRatio);
        this.frame.canvas.height = Math.round(this.frame.canvas.clientHeight * this.pixelRatio);
        this.options.width = width;
        this.options.height = height;
        this.canvasViewCenter = {
          x: 0.5 * this.frame.clientWidth,
          y: 0.5 * this.frame.clientHeight
        };
        emitEvent = true;
      } else {
        // this would adapt the width of the canvas to the width from 100% if and only if
        // there is a change.
        var newWidth = Math.round(this.frame.canvas.clientWidth * this.pixelRatio);
        var newHeight = Math.round(this.frame.canvas.clientHeight * this.pixelRatio); // store the camera if there is a change in size.

        if (this.frame.canvas.width !== newWidth || this.frame.canvas.height !== newHeight) {
          this._getCameraState(previousRatio);
        }

        if (this.frame.canvas.width !== newWidth) {
          this.frame.canvas.width = newWidth;
          emitEvent = true;
        }

        if (this.frame.canvas.height !== newHeight) {
          this.frame.canvas.height = newHeight;
          emitEvent = true;
        }
      }

      if (emitEvent === true) {
        this.body.emitter.emit("resize", {
          width: Math.round(this.frame.canvas.width / this.pixelRatio),
          height: Math.round(this.frame.canvas.height / this.pixelRatio),
          oldWidth: Math.round(oldWidth / this.pixelRatio),
          oldHeight: Math.round(oldHeight / this.pixelRatio)
        }); // restore the camera on change.

        this._setCameraState();
      } // set initialized so the get and set camera will work from now on.


      this.initialized = true;
      return emitEvent;
    }
    /**
     *
     * @returns {CanvasRenderingContext2D}
     */

  }, {
    key: "getContext",
    value: function getContext() {
      return this.frame.canvas.getContext("2d");
    }
    /**
     * Determine the pixel ratio for various browsers.
     *
     * @returns {number}
     * @private
     */

  }, {
    key: "_determinePixelRatio",
    value: function _determinePixelRatio() {
      var ctx = this.getContext();

      if (ctx === undefined) {
        throw new Error("Could not get canvax context");
      }

      var numerator = 1;

      if (typeof window !== "undefined") {
        // (window !== undefined) doesn't work here!
        // Protection during unit tests, where 'window' can be missing
        numerator = window.devicePixelRatio || 1;
      }

      var denominator = ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;
      return numerator / denominator;
    }
    /**
     * Lazy determination of pixel ratio.
     *
     * @private
     */

  }, {
    key: "_setPixelRatio",
    value: function _setPixelRatio() {
      this.pixelRatio = this._determinePixelRatio();
    }
    /**
     * Set the transform in the contained context, based on its pixelRatio
     */

  }, {
    key: "setTransform",
    value: function setTransform() {
      var ctx = this.getContext();

      if (ctx === undefined) {
        throw new Error("Could not get canvax context");
      }

      ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);
    }
    /**
     * Convert the X coordinate in DOM-space (coordinate point in browser relative to the container div) to
     * the X coordinate in canvas-space (the simulation sandbox, which the camera looks upon)
     *
     * @param {number} x
     * @returns {number}
     * @private
     */

  }, {
    key: "_XconvertDOMtoCanvas",
    value: function _XconvertDOMtoCanvas(x) {
      return (x - this.body.view.translation.x) / this.body.view.scale;
    }
    /**
     * Convert the X coordinate in canvas-space (the simulation sandbox, which the camera looks upon) to
     * the X coordinate in DOM-space (coordinate point in browser relative to the container div)
     *
     * @param {number} x
     * @returns {number}
     * @private
     */

  }, {
    key: "_XconvertCanvasToDOM",
    value: function _XconvertCanvasToDOM(x) {
      return x * this.body.view.scale + this.body.view.translation.x;
    }
    /**
     * Convert the Y coordinate in DOM-space (coordinate point in browser relative to the container div) to
     * the Y coordinate in canvas-space (the simulation sandbox, which the camera looks upon)
     *
     * @param {number} y
     * @returns {number}
     * @private
     */

  }, {
    key: "_YconvertDOMtoCanvas",
    value: function _YconvertDOMtoCanvas(y) {
      return (y - this.body.view.translation.y) / this.body.view.scale;
    }
    /**
     * Convert the Y coordinate in canvas-space (the simulation sandbox, which the camera looks upon) to
     * the Y coordinate in DOM-space (coordinate point in browser relative to the container div)
     *
     * @param {number} y
     * @returns {number}
     * @private
     */

  }, {
    key: "_YconvertCanvasToDOM",
    value: function _YconvertCanvasToDOM(y) {
      return y * this.body.view.scale + this.body.view.translation.y;
    }
    /**
     * @param {point} pos
     * @returns {point}
     */

  }, {
    key: "canvasToDOM",
    value: function canvasToDOM(pos) {
      return {
        x: this._XconvertCanvasToDOM(pos.x),
        y: this._YconvertCanvasToDOM(pos.y)
      };
    }
    /**
     *
     * @param {point} pos
     * @returns {point}
     */

  }, {
    key: "DOMtoCanvas",
    value: function DOMtoCanvas(pos) {
      return {
        x: this._XconvertDOMtoCanvas(pos.x),
        y: this._YconvertDOMtoCanvas(pos.y)
      };
    }
  }]);

  return Canvas;
}();

/**
 * Validate the fit options, replace missing optional values by defaults etc.
 *
 * @param rawOptions - The raw opti