/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Point2D;

class CoordinateChange {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final double vect_u_x;
    private final double vect_u_y;
    private final double vect_v_x;
    private final double vect_v_y;
    private final double len;

    public static CoordinateChange create(Point2D p1, Point2D p2) {
        return new CoordinateChange(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public CoordinateChange(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.len = Point2D.distance(x1, y1, x2, y2);
        if (this.len == 0.0) {
            throw new IllegalArgumentException();
        }
        this.vect_u_x = (x2 - x1) / this.len;
        this.vect_u_y = (y2 - y1) / this.len;
        this.vect_v_x = -this.vect_u_y;
        this.vect_v_y = this.vect_u_x;
    }

    public Point2D getTrueCoordinate(double a, double b) {
        double x = a * this.vect_u_x + b * this.vect_v_x;
        double y = a * this.vect_u_y + b * this.vect_v_y;
        return new Point2D.Double(this.x1 + x, this.y1 + y);
    }

    public final double getLength() {
        return this.len;
    }
}

