/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.functional.renderer;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatImpl;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

public class FunctionalSyntaxObjectRenderer
implements OWLObjectVisitor {
    @Nonnull
    private DefaultPrefixManager defaultPrefixManager = new DefaultPrefixManager();
    private PrefixManager prefixManager;
    protected final OWLOntology ont;
    private final Writer writer;
    private boolean writeEntitiesAsURIs = true;
    private OWLObject focusedObject;
    private boolean addMissingDeclarations = true;
    protected AnnotationValueShortFormProvider labelMaker = null;

    public FunctionalSyntaxObjectRenderer(@Nonnull OWLOntology ontology, Writer writer) {
        this.ont = ontology;
        this.writer = writer;
        this.prefixManager = this.defaultPrefixManager;
        OWLDocumentFormat ontologyFormat = ontology.getOWLOntologyManager().getOntologyFormat(ontology);
        if (ontologyFormat != null) {
            this.addMissingDeclarations = ontologyFormat.isAddMissingTypes();
        }
        if (ontologyFormat instanceof PrefixDocumentFormat) {
            this.prefixManager.copyPrefixesFrom((PrefixDocumentFormat)ontologyFormat);
            this.prefixManager.setPrefixComparator(((PrefixDocumentFormat)ontologyFormat).getPrefixComparator());
        }
        if (!ontology.isAnonymous() && this.prefixManager.getDefaultPrefix() == null) {
            String existingDefault = this.prefixManager.getDefaultPrefix();
            String ontologyIRIString = ((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString();
            if (existingDefault == null || !existingDefault.startsWith(ontologyIRIString)) {
                String defaultPrefix = ontologyIRIString;
                if (!ontologyIRIString.endsWith("/") && !ontologyIRIString.endsWith("#")) {
                    defaultPrefix = ontologyIRIString + '#';
                }
                this.prefixManager.setDefaultPrefix(defaultPrefix);
            }
        }
        HashMap<OWLAnnotationProperty, List<String>> prefLangMap = new HashMap<OWLAnnotationProperty, List<String>>();
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        OWLAnnotationProperty labelProp = df.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.labelMaker = new AnnotationValueShortFormProvider(Collections.singletonList(labelProp), prefLangMap, manager, this.defaultPrefixManager);
        this.focusedObject = ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing();
    }

    public void setAddMissingDeclarations(boolean flag) {
        this.addMissingDeclarations = flag;
    }

    public void setPrefixManager(PrefixManager prefixManager) {
        this.prefixManager = prefixManager;
        if (prefixManager instanceof DefaultPrefixManager) {
            this.defaultPrefixManager = (DefaultPrefixManager)prefixManager;
        }
    }

    protected void setFocusedObject(OWLObject focusedObject) {
        this.focusedObject = focusedObject;
    }

    protected void writePrefix(@Nonnull String prefix, @Nonnull String namespace) {
        this.write("Prefix");
        this.writeOpenBracket();
        this.write(prefix);
        this.write("=");
        this.write("<");
        this.write(namespace);
        this.write(">");
        this.writeCloseBracket();
        this.writeReturn();
    }

    protected void writePrefixes() {
        for (Map.Entry<String, String> e : this.prefixManager.getPrefixName2PrefixMap().entrySet()) {
            this.writePrefix(e.getKey(), e.getValue());
        }
    }

    private void write(@Nonnull OWLXMLVocabulary v) {
        this.write(v.getShortForm());
    }

    private void write(@Nonnull String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void write(@Nonnull IRI iri) {
        String qname = this.prefixManager.getPrefixIRIIgnoreQName(iri);
        if (qname != null) {
            boolean lastCharIsColon;
            boolean bl = lastCharIsColon = qname.charAt(qname.length() - 1) == ':';
            if (!lastCharIsColon) {
                this.write(qname);
                return;
            }
        }
        this.writeFullIRI(iri);
    }

    private void writeFullIRI(@Nonnull IRI iri) {
        this.write("<");
        this.write(iri.toString());
        this.write(">");
    }

    @Override
    public void visit(@Nonnull OWLOntology ontology) {
        this.writePrefixes();
        this.writeReturn();
        this.writeReturn();
        this.write(OWLXMLVocabulary.ONTOLOGY);
        this.writeOpenBracket();
        if (!ontology.isAnonymous()) {
            this.writeFullIRI((IRI)ontology.getOntologyID().getOntologyIRI().get());
            Optional<IRI> versionIRI = ontology.getOntologyID().getVersionIRI();
            if (versionIRI.isPresent()) {
                this.writeReturn();
                this.writeFullIRI((IRI)versionIRI.get());
            }
            this.writeReturn();
        }
        ontology.getImportsDeclarations().stream().sorted().forEach(decl -> {
            this.write(OWLXMLVocabulary.IMPORT);
            this.writeOpenBracket();
            this.writeFullIRI(decl.getIRI());
            this.writeCloseBracket();
            this.writeReturn();
        });
        for (OWLAnnotation ontologyAnnotation : FunctionalSyntaxObjectRenderer.getSortedAnnotations(ontology)) {
            ontologyAnnotation.accept(this);
            this.writeReturn();
        }
        this.writeReturn();
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        Collection<IRI> illegals = OWLDocumentFormatImpl.determineIllegalPunnings(this.addMissingDeclarations, ontology.getSignature(), this.ont.getPunnedIRIs(Imports.INCLUDED));
        for (OWLEntity ent : CollectionFactory.sortOptionally(ontology.getSignature())) {
            this.writeDeclarations(ent, writtenAxioms, illegals);
        }
        this.writeSortedEntities("Annotation Properties", "Annotation Property", ontology.getAnnotationPropertiesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Object Properties", "Object Property", ontology.getObjectPropertiesInSignature(), writtenAxioms);
        this.writeSortedEntities("Data Properties", "Data Property", ontology.getDataPropertiesInSignature(), writtenAxioms);
        this.writeSortedEntities("Datatypes", "Datatype", ontology.getDatatypesInSignature(), writtenAxioms);
        this.writeSortedEntities("Classes", "Class", ontology.getClassesInSignature(), writtenAxioms);
        this.writeSortedEntities("Named Individuals", "Individual", ontology.getIndividualsInSignature(), writtenAxioms);
        Set<OWLAxiom> otherAxioms = ontology.getAxioms();
        otherAxioms.removeAll(writtenAxioms);
        for (OWLAxiom ax : CollectionFactory.sortOptionally(otherAxioms)) {
            ax.accept(this);
            this.writeReturn();
        }
        this.writeCloseBracket();
        this.flush();
    }

    private void writeSortedEntities(String bannerComment, String entityTypeName, Set<? extends OWLEntity> entities, Set<OWLAxiom> writtenAxioms) {
        if (entities.size() > 0) {
            this.writeEntities(bannerComment, entityTypeName, CollectionFactory.sortOptionally(entities), writtenAxioms);
            this.writeln();
        }
    }

    private void writeln() {
        this.writeReturn();
    }

    private void writeln(@Nonnull String s) {
        this.write(s);
        this.writeReturn();
    }

    private void writeEntities(String comment, String entityTypeName, List<? extends OWLEntity> entities, @Nonnull Set<OWLAxiom> writtenAxioms) {
        boolean haveWrittenBanner = false;
        for (OWLEntity oWLEntity : entities) {
            Set<? extends OWLAxiom> axiomsForEntity = this.getUnsortedAxiomsForEntity(oWLEntity);
            Iterator<? extends OWLAxiom> iterator = axiomsForEntity.iterator();
            while (iterator.hasNext()) {
                OWLAxiom axiom = iterator.next();
                if (!writtenAxioms.contains(axiom)) continue;
                iterator.remove();
            }
            Set<OWLAnnotationAssertionAxiom> annotationAssertionAxioms = this.ont.getAnnotationAssertionAxioms(oWLEntity.getIRI());
            Iterator<OWLAnnotationAssertionAxiom> iterator2 = annotationAssertionAxioms.iterator();
            while (iterator2.hasNext()) {
                OWLAnnotationAssertionAxiom axiom = iterator2.next();
                if (!writtenAxioms.contains(axiom)) continue;
                iterator2.remove();
            }
            if (axiomsForEntity.size() == 0 && annotationAssertionAxioms.size() == 0) continue;
            if (!haveWrittenBanner) {
                this.writeln("############################");
                this.writeln("#   " + comment);
                this.writeln("############################");
                this.writeln();
                haveWrittenBanner = true;
            }
            this.writeEntity2(oWLEntity, entityTypeName, this.sortAxioms(axiomsForEntity), CollectionFactory.sortOptionally(annotationAssertionAxioms), writtenAxioms);
        }
    }

    @Nonnull
    private static List<OWLAnnotation> getSortedAnnotations(HasAnnotations annotationBearer) {
        return CollectionFactory.sortOptionally(annotationBearer.getAnnotations());
    }

    @Nonnull
    protected Set<OWLAxiom> writeEntity(@Nonnull OWLEntity entity) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        this.writeEntity(entity, writtenAxioms);
        return writtenAxioms;
    }

    protected void writeEntity(@Nonnull OWLEntity entity, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeEntity2(entity, "", this.sortAxioms(this.getUnsortedAxiomsForEntity(entity)), CollectionFactory.sortOptionally(this.ont.getAnnotationAssertionAxioms(entity.getIRI())), alreadyWrittenAxioms);
    }

    protected void writeEntity2(@Nonnull OWLEntity entity, String entityTypeName, @Nonnull List<? extends OWLAxiom> axiomsForEntity, @Nonnull List<OWLAnnotationAssertionAxiom> annotationAssertionAxioms, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeln("# " + entityTypeName + ": " + this.getIRIString(entity) + " (" + this.getEntityLabel(entity) + ")");
        this.writeln();
        this.setFocusedObject(entity);
        this.writeAnnotations2(entity, alreadyWrittenAxioms, annotationAssertionAxioms);
        List<? extends OWLAxiom> axs = axiomsForEntity;
        for (OWLAxiom oWLAxiom : axs) {
            if (oWLAxiom.getAxiomType().equals(AxiomType.DIFFERENT_INDIVIDUALS) || oWLAxiom.getAxiomType().equals(AxiomType.DISJOINT_CLASSES) && ((OWLDisjointClassesAxiom)oWLAxiom).getClassExpressions().size() > 2) continue;
            oWLAxiom.accept(this);
            alreadyWrittenAxioms.add(oWLAxiom);
            this.writeReturn();
        }
        this.writeln();
    }

    @Nonnull
    private Set<? extends OWLAxiom> getUnsortedAxiomsForEntity(@Nonnull OWLEntity entity) {
        return entity.accept(new OWLEntityVisitorEx<Set<? extends OWLAxiom>>(){

            @Override
            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLClass cls) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms(cls, Imports.EXCLUDED);
            }

            @Override
            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLObjectProperty property) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms((OWLObjectPropertyExpression)property, Imports.EXCLUDED);
            }

            @Override
            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLDataProperty property) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms(property, Imports.EXCLUDED);
            }

            @Override
            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLNamedIndividual individual) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms((OWLIndividual)individual, Imports.EXCLUDED);
            }

            @Override
            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLDatatype datatype) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms(datatype, Imports.EXCLUDED);
            }

            @Override
            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLAnnotationProperty property) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms(property, Imports.EXCLUDED);
            }
        });
    }

    @Nonnull
    protected List<? extends OWLAxiom> sortAxioms(@Nonnull Set<? extends OWLAxiom> axioms) {
        return CollectionFactory.sortOptionally(axioms);
    }

    @Nonnull
    private String getIRIString(@Nonnull OWLEntity entity) {
        return this.defaultPrefixManager.getShortForm(entity);
    }

    private String getEntityLabel(@Nonnull OWLEntity entity) {
        return this.labelMaker.getShortForm(entity).replace("\n", "\n# ");
    }

    @Nonnull
    protected Set<OWLAxiom> writeDeclarations(@Nonnull OWLEntity entity) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        Set<OWLDeclarationAxiom> declarationAxioms = this.ont.getDeclarationAxioms(entity);
        for (OWLAxiom oWLAxiom : CollectionFactory.sortOptionally(declarationAxioms)) {
            oWLAxiom.accept(this);
            axioms.add(oWLAxiom);
            this.writeReturn();
        }
        return axioms;
    }

    private void writeDeclarations(@Nonnull OWLEntity entity, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms, Collection<IRI> illegals) {
        Set<OWLDeclarationAxiom> axioms = this.ont.getDeclarationAxioms(entity);
        for (OWLDeclarationAxiom ax : CollectionFactory.sortOptionally(axioms)) {
            if (alreadyWrittenAxioms.contains(ax)) continue;
            ax.accept(this);
            this.writeReturn();
        }
        if (this.addMissingDeclarations && axioms.isEmpty() && !entity.isBuiltIn() && !illegals.contains(entity.getIRI()) && !this.ont.isDeclared(entity, Imports.INCLUDED)) {
            OWLDeclarationAxiom declaration = this.ont.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(entity);
            declaration.accept(this);
            this.writeReturn();
        }
        alreadyWrittenAxioms.addAll(axioms);
    }

    protected void writeAnnotations(@Nonnull OWLEntity entity, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms) {
        List<OWLAnnotationAssertionAxiom> annotationAssertionAxioms = CollectionFactory.sortOptionally(this.ont.getAnnotationAssertionAxioms(entity.getIRI()));
        this.writeAnnotations2(entity, alreadyWrittenAxioms, annotationAssertionAxioms);
    }

    protected void writeAnnotations2(@Nonnull OWLEntity entity, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms, List<OWLAnnotationAssertionAxiom> annotationAssertionAxioms) {
        for (OWLAnnotationAxiom oWLAnnotationAxiom : annotationAssertionAxioms) {
            oWLAnnotationAxiom.accept(this);
            this.writeReturn();
        }
        alreadyWrittenAxioms.addAll(annotationAssertionAxioms);
    }

    protected void write(@Nonnull OWLXMLVocabulary v, @Nonnull OWLObject o) {
        this.write(v);
        this.writeOpenBracket();
        o.accept(this);
        this.writeCloseBracket();
    }

    private void write(@Nonnull Collection<? extends OWLObject> objects) {
        if (objects.size() > 2) {
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                it.next().accept(this);
                if (!it.hasNext()) continue;
                this.writeSpace();
            }
        } else if (objects.size() == 2) {
            OWLObject rhs;
            OWLObject lhs;
            Iterator<? extends OWLObject> it = objects.iterator();
            OWLObject objA = it.next();
            OWLObject objB = it.next();
            if (objA.equals(this.focusedObject)) {
                lhs = objA;
                rhs = objB;
            } else {
                lhs = objB;
                rhs = objA;
            }
            lhs.accept(this);
            this.writeSpace();
            rhs.accept(this);
        } else if (objects.size() == 1) {
            objects.iterator().next().accept(this);
        }
    }

    private void write(@Nonnull List<? extends OWLObject> objects) {
        if (objects.size() > 1) {
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                it.next().accept(this);
                if (!it.hasNext()) continue;
                this.writeSpace();
            }
        } else if (objects.size() == 1) {
            objects.iterator().next().accept(this);
        }
    }

    protected void writeOpenBracket() {
        this.write("(");
    }

    protected void writeCloseBracket() {
        this.write(")");
    }

    protected void writeSpace() {
        this.write(" ");
    }

    protected void writeReturn() {
        this.write("\n");
    }

    protected void writeAnnotations(@Nonnull OWLAxiom ax) {
        for (OWLAnnotation anno : FunctionalSyntaxObjectRenderer.getSortedAnnotations(ax)) {
            anno.accept(this);
            this.writeSpace();
        }
    }

    protected void writeAxiomStart(@Nonnull OWLXMLVocabulary v, @Nonnull OWLAxiom axiom) {
        this.write(v);
        this.writeOpenBracket();
        this.writeAnnotations(axiom);
    }

    protected void writeAxiomEnd() {
        this.writeCloseBracket();
    }

    protected void writePropertyCharacteristic(@Nonnull OWLXMLVocabulary v, @Nonnull OWLAxiom ax, @Nonnull OWLPropertyExpression prop) {
        this.writeAxiomStart(v, ax);
        prop.accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.ASYMMETRIC_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.CLASS_ASSERTION, axiom);
        axiom.getClassExpression().accept(this);
        this.writeSpace();
        axiom.getIndividual().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION, axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN, axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getDomain().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_RANGE, axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF, axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDeclarationAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DECLARATION, axiom);
        this.writeEntitiesAsURIs = false;
        axiom.getEntity().accept(this);
        this.writeEntitiesAsURIs = true;
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
        Set<OWLIndividual> individuals = axiom.getIndividuals();
        if (individuals.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS, axiom);
        this.write(CollectionFactory.sortOptionally(individuals));
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        Set<OWLClassExpression> classExpressions = axiom.getClassExpressions();
        if (classExpressions.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_CLASSES, axiom);
        this.write(CollectionFactory.sortOptionally(classExpressions));
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
        Set properties = axiom.getProperties();
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES, axiom);
        this.write(CollectionFactory.sortOptionally(properties));
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
        Set properties = axiom.getProperties();
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES, axiom);
        this.write(CollectionFactory.sortOptionally(properties));
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDisjointUnionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_UNION, axiom);
        axiom.getOWLClass().accept(this);
        this.writeSpace();
        Set<OWLClassExpression> classExpressions = axiom.getClassExpressions();
        List<OWLClassExpression> expressionList = CollectionFactory.sortOptionally(classExpressions);
        this.write(expressionList);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_ASSERTION, axiom);
        axiom.getProperty().accept(this);
        this.writeSpace();
        axiom.getSubject().accept(this);
        this.writeSpace();
        axiom.getValue().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
        Set<OWLClassExpression> classExpressions = axiom.getClassExpressions();
        if (classExpressions.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_CLASSES, axiom);
        List<OWLClassExpression> expressionList = CollectionFactory.sortOptionally(classExpressions);
        this.write(expressionList);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
        Set properties = axiom.getProperties();
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES, axiom);
        List expressionList = CollectionFactory.sortOptionally(properties);
        this.write(expressionList);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
        Set properties = axiom.getProperties();
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES, axiom);
        List expressionList = CollectionFactory.sortOptionally(properties);
        this.write(expressionList);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES, axiom);
        axiom.getFirstProperty().accept(this);
        this.writeSpace();
        axiom.getSecondProperty().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION, axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION, axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION, axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLSubPropertyChainOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, axiom);
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_CHAIN);
        this.writeOpenBracket();
        Iterator<OWLObjectPropertyExpression> it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
        }
        this.writeCloseBracket();
        this.writeSpace();
        axiom.getSuperProperty().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN, axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        axiom.getDomain().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE, axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        ((OWLClassExpression)axiom.getRange()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
        Set<OWLIndividual> individuals = axiom.getIndividuals();
        if (individuals.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.SAME_INDIVIDUAL, axiom);
        this.write(individuals);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_CLASS_OF, axiom);
        axiom.getSubClass().accept(this);
        this.writeSpace();
        axiom.getSuperClass().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLClass ce) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.CLASS);
            this.writeOpenBracket();
        }
        ce.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    private <F extends OWLPropertyRange> void writeRestriction(@Nonnull OWLXMLVocabulary v, @Nonnull OWLCardinalityRestriction<F> restriction, @Nonnull OWLPropertyExpression p) {
        this.write(v);
        this.writeOpenBracket();
        this.write(Integer.toString(restriction.getCardinality()));
        this.writeSpace();
        p.accept(this);
        if (restriction.isQualified()) {
            this.writeSpace();
            restriction.getFiller().accept(this);
        }
        this.writeCloseBracket();
    }

    private void writeRestriction(@Nonnull OWLXMLVocabulary v, @Nonnull OWLQuantifiedDataRestriction restriction) {
        this.writeRestriction(v, restriction.getProperty(), restriction.getFiller());
    }

    private void writeRestriction(@Nonnull OWLXMLVocabulary v, @Nonnull OWLQuantifiedObjectRestriction restriction) {
        this.writeRestriction(v, restriction.getProperty(), restriction.getFiller());
    }

    private void writeRestriction(@Nonnull OWLXMLVocabulary v, @Nonnull OWLPropertyExpression prop, @Nonnull OWLObject filler) {
        this.write(v);
        this.writeOpenBracket();
        prop.accept(this);
        this.writeSpace();
        filler.accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_ALL_VALUES_FROM, ce);
    }

    @Override
    public void visit(@Nonnull OWLDataExactCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_EXACT_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLDataMaxCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MAX_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLDataMinCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MIN_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_SOME_VALUES_FROM, ce);
    }

    @Override
    public void visit(@Nonnull OWLDataHasValue ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_HAS_VALUE, ce.getProperty(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM, ce);
    }

    @Override
    public void visit(@Nonnull OWLObjectComplementOf ce) {
        this.write(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF, ce.getOperand());
    }

    @Override
    public void visit(@Nonnull OWLObjectExactCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLObjectIntersectionOf ce) {
        if (ce.getOperands().size() == 1) {
            ce.getOperands().iterator().next().accept(this);
            return;
        }
        this.write(OWLXMLVocabulary.OBJECT_INTERSECTION_OF);
        this.writeOpenBracket();
        Set<OWLClassExpression> operands = ce.getOperands();
        List<OWLClassExpression> objects = CollectionFactory.sortOptionally(operands);
        this.write(objects);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectMaxCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLObjectMinCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(@Nonnull OWLObjectOneOf ce) {
        this.write(OWLXMLVocabulary.OBJECT_ONE_OF);
        this.writeOpenBracket();
        Set<OWLIndividual> individuals = ce.getIndividuals();
        List<OWLIndividual> objects = CollectionFactory.sortOptionally(individuals);
        this.write(objects);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectHasSelf ce) {
        this.write(OWLXMLVocabulary.OBJECT_HAS_SELF, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM, ce);
    }

    @Override
    public void visit(@Nonnull OWLObjectUnionOf ce) {
        if (ce.getOperands().size() == 1) {
            ce.getOperands().iterator().next().accept(this);
            return;
        }
        this.write(OWLXMLVocabulary.OBJECT_UNION_OF);
        this.writeOpenBracket();
        Set<OWLClassExpression> operands = ce.getOperands();
        List<OWLClassExpression> objects = CollectionFactory.sortOptionally(operands);
        this.write(objects);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLObjectHasValue ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_HAS_VALUE, ce.getProperty(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(@Nonnull OWLDataComplementOf node) {
        this.write(OWLXMLVocabulary.DATA_COMPLEMENT_OF, node.getDataRange());
    }

    @Override
    public void visit(@Nonnull OWLDataOneOf node) {
        this.write(OWLXMLVocabulary.DATA_ONE_OF);
        this.writeOpenBracket();
        Set<OWLLiteral> values = node.getValues();
        this.write(CollectionFactory.sortOptionally(values));
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLDatatype node) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATATYPE);
            this.writeOpenBracket();
        }
        node.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(@Nonnull OWLDatatypeRestriction node) {
        this.write(OWLXMLVocabulary.DATATYPE_RESTRICTION);
        this.writeOpenBracket();
        node.getDatatype().accept(this);
        Set<OWLFacetRestriction> facetRestrictions = node.getFacetRestrictions();
        List<OWLFacetRestriction> restrictionList = CollectionFactory.sortOptionally(facetRestrictions);
        for (OWLFacetRestriction restriction : restrictionList) {
            this.writeSpace();
            restriction.accept(this);
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLFacetRestriction node) {
        this.write(node.getFacet().getIRI());
        this.writeSpace();
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(@Nonnull OWLLiteral node) {
        this.write("\"");
        this.write(EscapeUtils.escapeString(node.getLiteral()));
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        } else if (!node.isRDFPlainLiteral()) {
            this.write("^^");
            this.write(node.getDatatype().getIRI());
        }
    }

    @Override
    public void visit(@Nonnull OWLDataProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATA_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(@Nonnull OWLObjectProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.OBJECT_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(@Nonnull OWLObjectInverseOf property) {
        this.write(OWLXMLVocabulary.OBJECT_INVERSE_OF);
        this.writeOpenBracket();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLNamedIndividual individual) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.NAMED_INDIVIDUAL);
            this.writeOpenBracket();
        }
        individual.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(@Nonnull OWLHasKeyAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.HAS_KEY, axiom);
        axiom.getClassExpression().accept(this);
        this.writeSpace();
        this.writeOpenBracket();
        Set<OWLObjectPropertyExpression> objectPropertyExpressions = axiom.getObjectPropertyExpressions();
        List<OWLObjectPropertyExpression> expressions = CollectionFactory.sortOptionally(objectPropertyExpressions);
        Iterator<OWLObjectPropertyExpression> it = expressions.iterator();
        while (it.hasNext()) {
            OWLPropertyExpression prop = it.next();
            prop.accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
        }
        this.writeCloseBracket();
        this.writeSpace();
        this.writeOpenBracket();
        Set<OWLDataPropertyExpression> dataPropertyExpressions = axiom.getDataPropertyExpressions();
        List<OWLDataPropertyExpression> expressionList = CollectionFactory.sortOptionally(dataPropertyExpressions);
        Iterator<OWLDataPropertyExpression> it2 = expressionList.iterator();
        while (it2.hasNext()) {
            OWLPropertyExpression prop = it2.next();
            prop.accept(this);
            if (!it2.hasNext()) continue;
            this.writeSpace();
        }
        this.writeCloseBracket();
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLAnnotationPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_DOMAIN, axiom);
        axiom.getProperty().accept(this);
        this.writeSpace();
        axiom.getDomain().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLAnnotationPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_RANGE, axiom);
        axiom.getProperty().accept(this);
        this.writeSpace();
        axiom.getRange().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLSubAnnotationPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_ANNOTATION_PROPERTY_OF, axiom);
        axiom.getSubProperty().accept(this);
        this.writeSpace();
        axiom.getSuperProperty().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull OWLDataIntersectionOf node) {
        if (node.getOperands().size() == 1) {
            node.getOperands().iterator().next().accept(this);
            return;
        }
        this.write(OWLXMLVocabulary.DATA_INTERSECTION_OF);
        this.writeOpenBracket();
        Set<OWLDataRange> operands = node.getOperands();
        List<OWLDataRange> objects = CollectionFactory.sortOptionally(operands);
        this.write(objects);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLDataUnionOf node) {
        if (node.getOperands().size() == 1) {
            node.getOperands().iterator().next().accept(this);
            return;
        }
        this.write(OWLXMLVocabulary.DATA_UNION_OF);
        this.writeOpenBracket();
        Set<OWLDataRange> operands = node.getOperands();
        List<OWLDataRange> objects = CollectionFactory.sortOptionally(operands);
        this.write(objects);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLAnnotationProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.ANNOTATION_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(@Nonnull OWLAnonymousIndividual individual) {
        this.write(individual.getID().toString());
    }

    @Override
    public void visit(@Nonnull IRI iri) {
        this.write(iri);
    }

    @Override
    public void visit(@Nonnull OWLAnnotation node) {
        this.write(OWLXMLVocabulary.ANNOTATION);
        this.writeOpenBracket();
        for (OWLAnnotation anno : FunctionalSyntaxObjectRenderer.getSortedAnnotations(node)) {
            anno.accept(this);
            this.writeSpace();
        }
        node.getProperty().accept(this);
        this.writeSpace();
        node.getValue().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull OWLDatatypeDefinitionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATATYPE_DEFINITION, axiom);
        axiom.getDatatype().accept(this);
        this.writeSpace();
        axiom.getDataRange().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull SWRLRule rule) {
        this.writeAxiomStart(OWLXMLVocabulary.DL_SAFE_RULE, rule);
        this.write(OWLXMLVocabulary.BODY);
        this.writeOpenBracket();
        this.write(rule.getBody());
        this.writeCloseBracket();
        this.write(OWLXMLVocabulary.HEAD);
        this.writeOpenBracket();
        this.write(rule.getHead());
        this.writeCloseBracket();
        this.writeAxiomEnd();
    }

    @Override
    public void visit(@Nonnull SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(@Nonnull SWRLClassAtom node) {
        this.write(OWLXMLVocabulary.CLASS_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept(this);
        this.writeSpace();
        ((SWRLIArgument)node.getArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull SWRLDataRangeAtom node) {
        this.write(OWLXMLVocabulary.DATA_RANGE_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept(this);
        this.writeSpace();
        ((SWRLDArgument)node.getArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull SWRLObjectPropertyAtom node) {
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept(this);
        this.writeSpace();
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.writeSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull SWRLDataPropertyAtom node) {
        this.write(OWLXMLVocabulary.DATA_PROPERTY_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept(this);
        this.writeSpace();
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.writeSpace();
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull SWRLBuiltInAtom node) {
        this.write(OWLXMLVocabulary.BUILT_IN_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept(this);
        this.writeSpace();
        this.write(node.getArguments());
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull SWRLVariable node) {
        this.write(OWLXMLVocabulary.VARIABLE);
        this.writeOpenBracket();
        node.getIRI().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
    }

    @Override
    public void visit(@Nonnull SWRLDifferentIndividualsAtom node) {
        this.write(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS_ATOM);
        this.writeOpenBracket();
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.writeSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(@Nonnull SWRLSameIndividualAtom node) {
        this.write(OWLXMLVocabulary.SAME_INDIVIDUAL_ATOM);
        this.writeOpenBracket();
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.writeSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.writeCloseBracket();
    }
}

