from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.GeomAbs import *
from OCC.Core.TColStd import *
from OCC.Core.Geom2d import *
from OCC.Core.gp import *
from OCC.Core.MAT import *
from OCC.Core.Bisector import *

#the following typedef cannot be wrapped as is
MAT2d_Array2OfConnexion = NewType('MAT2d_Array2OfConnexion', Any)

class MAT2d_SequenceOfConnexion:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class MAT2d_SequenceOfSequenceOfCurve:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> TColGeom2d_SequenceOfCurve: ...
    def Last(self) -> TColGeom2d_SequenceOfCurve: ...
    def Length(self) -> int: ...
    def Append(self, theItem: TColGeom2d_SequenceOfCurve) -> TColGeom2d_SequenceOfCurve: ...
    def Prepend(self, theItem: TColGeom2d_SequenceOfCurve) -> TColGeom2d_SequenceOfCurve: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> TColGeom2d_SequenceOfCurve: ...
    def SetValue(self, theIndex: int, theValue: TColGeom2d_SequenceOfCurve) -> None: ...

class MAT2d_SequenceOfSequenceOfGeometry:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> TColGeom2d_SequenceOfGeometry: ...
    def Last(self) -> TColGeom2d_SequenceOfGeometry: ...
    def Length(self) -> int: ...
    def Append(self, theItem: TColGeom2d_SequenceOfGeometry) -> TColGeom2d_SequenceOfGeometry: ...
    def Prepend(self, theItem: TColGeom2d_SequenceOfGeometry) -> TColGeom2d_SequenceOfGeometry: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> TColGeom2d_SequenceOfGeometry: ...
    def SetValue(self, theIndex: int, theValue: TColGeom2d_SequenceOfGeometry) -> None: ...

class MAT2d_BiInt:
    def __init__(self, I1: int, I2: int) -> None: ...
    @overload
    def FirstIndex(self) -> int: ...
    @overload
    def FirstIndex(self, I1: int) -> None: ...
    def IsEqual(self, B: MAT2d_BiInt) -> bool: ...
    @overload
    def SecondIndex(self) -> int: ...
    @overload
    def SecondIndex(self, I2: int) -> None: ...

class MAT2d_Circuit(Standard_Transient):
    def __init__(self, aJoinType: Optional[GeomAbs_JoinType] = GeomAbs_Arc, IsOpenResult: Optional[bool] = False) -> None: ...
    def Connexion(self, Index: int) -> MAT2d_Connexion: ...
    def ConnexionOn(self, Index: int) -> bool: ...
    def LineLength(self, IndexLine: int) -> int: ...
    def NumberOfItems(self) -> int: ...
    def Perform(self, aFigure: MAT2d_SequenceOfSequenceOfGeometry, IsClosed: TColStd_SequenceOfBoolean, IndRefLine: int, Trigo: bool) -> None: ...
    def RefToEqui(self, IndLine: int, IndCurve: int) -> TColStd_SequenceOfInteger: ...
    def Value(self, Index: int) -> Geom2d_Geometry: ...

class MAT2d_Connexion(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LineA: int, LineB: int, ItemA: int, ItemB: int, Distance: float, ParameterOnA: float, ParameterOnB: float, PointA: gp_Pnt2d, PointB: gp_Pnt2d) -> None: ...
    @overload
    def Distance(self) -> float: ...
    @overload
    def Distance(self, aDistance: float) -> None: ...
    def Dump(self, Deep: Optional[int] = 0, Offset: Optional[int] = 0) -> None: ...
    @overload
    def IndexFirstLine(self) -> int: ...
    @overload
    def IndexFirstLine(self, anIndex: int) -> None: ...
    @overload
    def IndexItemOnFirst(self) -> int: ...
    @overload
    def IndexItemOnFirst(self, anIndex: int) -> None: ...
    @overload
    def IndexItemOnSecond(self) -> int: ...
    @overload
    def IndexItemOnSecond(self, anIndex: int) -> None: ...
    @overload
    def IndexSecondLine(self) -> int: ...
    @overload
    def IndexSecondLine(self, anIndex: int) -> None: ...
    def IsAfter(self, aConnexion: MAT2d_Connexion, aSense: float) -> bool: ...
    @overload
    def ParameterOnFirst(self) -> float: ...
    @overload
    def ParameterOnFirst(self, aParameter: float) -> None: ...
    @overload
    def ParameterOnSecond(self) -> float: ...
    @overload
    def ParameterOnSecond(self, aParameter: float) -> None: ...
    @overload
    def PointOnFirst(self) -> gp_Pnt2d: ...
    @overload
    def PointOnFirst(self, aPoint: gp_Pnt2d) -> None: ...
    @overload
    def PointOnSecond(self) -> gp_Pnt2d: ...
    @overload
    def PointOnSecond(self, aPoint: gp_Pnt2d) -> None: ...
    def Reverse(self) -> MAT2d_Connexion: ...

class MAT2d_MapBiIntHasher:
    @staticmethod
    def HashCode(theKey: MAT2d_BiInt, theUpperBound: int) -> int: ...
    @staticmethod
    def IsEqual(Key1: MAT2d_BiInt, Key2: MAT2d_BiInt) -> bool: ...

class MAT2d_Mat2d:
    def __init__(self, IsOpenResult: Optional[bool] = False) -> None: ...
    def Bisector(self) -> MAT_Bisector: ...
    def CreateMat(self, aTool: MAT2d_Tool2d) -> None: ...
    def CreateMatOpen(self, aTool: MAT2d_Tool2d) -> None: ...
    def Init(self) -> None: ...
    def IsDone(self) -> bool: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def NumberOfBisectors(self) -> int: ...
    def SemiInfinite(self) -> bool: ...

class MAT2d_MiniPath:
    def __init__(self) -> None: ...
    def ConnexionsFrom(self, Index: int) -> MAT2d_SequenceOfConnexion: ...
    def Father(self, Index: int) -> MAT2d_Connexion: ...
    def IsConnexionsFrom(self, Index: int) -> bool: ...
    def IsRoot(self, Index: int) -> bool: ...
    def Path(self) -> MAT2d_SequenceOfConnexion: ...
    def Perform(self, Figure: MAT2d_SequenceOfSequenceOfGeometry, IndStart: int, Sense: bool) -> None: ...
    def RunOnConnexions(self) -> None: ...

class MAT2d_Tool2d:
    def __init__(self) -> None: ...
    def BisecFusion(self, Index1: int, Index2: int) -> None: ...
    def ChangeGeomBis(self, Index: int) -> Bisector_Bisec: ...
    def Circuit(self) -> MAT2d_Circuit: ...
    def CreateBisector(self, abisector: MAT_Bisector) -> None: ...
    def Distance(self, abisector: MAT_Bisector, param1: float, param2: float) -> float: ...
    def Dump(self, bisector: int, erease: int) -> None: ...
    def FirstPoint(self, anitem: int) -> Tuple[int, float]: ...
    def GeomBis(self, Index: int) -> Bisector_Bisec: ...
    def GeomElt(self, Index: int) -> Geom2d_Geometry: ...
    def GeomPnt(self, Index: int) -> gp_Pnt2d: ...
    def GeomVec(self, Index: int) -> gp_Vec2d: ...
    def InitItems(self, aCircuit: MAT2d_Circuit) -> None: ...
    def IntersectBisector(self, bisectorone: MAT_Bisector, bisectortwo: MAT_Bisector) -> Tuple[float, int]: ...
    def NumberOfItems(self) -> int: ...
    def Sense(self, aside: MAT_Side) -> None: ...
    def SetJoinType(self, aJoinType: GeomAbs_JoinType) -> None: ...
    def Tangent(self, bisector: int) -> int: ...
    def TangentAfter(self, anitem: int, IsOpenResult: bool) -> int: ...
    def TangentBefore(self, anitem: int, IsOpenResult: bool) -> int: ...
    def ToleranceOfConfusion(self) -> float: ...
    @overload
    def TrimBisector(self, abisector: MAT_Bisector) -> bool: ...
    @overload
    def TrimBisector(self, abisector: MAT_Bisector, apoint: int) -> bool: ...

#classnotwrapped
class MAT2d_SketchExplorer: ...

#classnotwrapped
class MAT2d_CutCurve: ...

# harray1 classes
# harray2 classes
# hsequence classes

MAT2d_MapBiIntHasher_HashCode = MAT2d_MapBiIntHasher.HashCode
MAT2d_MapBiIntHasher_IsEqual = MAT2d_MapBiIntHasher.IsEqual
