/* rygel-gst-transcoding-data-source.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-gst-transcoding-data-source.vala, do not modify */

/*
 * This file is part of Rygel.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#include <glib-object.h>
#include "rygel-server.h"
#include <gee.h>
#include <glib.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gst/pbutils/pbutils.h>
#include <glib/gi18n-lib.h>
#include "rygel-media-engine-gst.h"
#include <ges/ges.h>
#include <gio/gio.h>

#define RYGEL_TRANSCODING_GST_DATA_SOURCE_DECODE_BIN "decodebin"
#define RYGEL_TRANSCODING_GST_DATA_SOURCE_ENCODE_BIN "encodebin"
#define RYGEL_TRANSCODING_GST_DATA_SOURCE_DESCRIPTION "Encoder and decoder are not " "compatible"

#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;

#define RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE (rygel_transcoding_gst_data_source_get_type ())
#define RYGEL_TRANSCODING_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE, RygelTranscodingGstDataSource))
#define RYGEL_TRANSCODING_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE, RygelTranscodingGstDataSourceClass))
#define RYGEL_IS_TRANSCODING_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE))
#define RYGEL_IS_TRANSCODING_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE))
#define RYGEL_TRANSCODING_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE, RygelTranscodingGstDataSourceClass))

typedef struct _RygelTranscodingGstDataSource RygelTranscodingGstDataSource;
typedef struct _RygelTranscodingGstDataSourceClass RygelTranscodingGstDataSourceClass;
typedef struct _RygelTranscodingGstDataSourcePrivate RygelTranscodingGstDataSourcePrivate;
enum  {
	RYGEL_TRANSCODING_GST_DATA_SOURCE_0_PROPERTY,
	RYGEL_TRANSCODING_GST_DATA_SOURCE_NUM_PROPERTIES
};
static GParamSpec* rygel_transcoding_gst_data_source_properties[RYGEL_TRANSCODING_GST_DATA_SOURCE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
	RygelMediaResource* res;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
	GeeList* (*preroll) (RygelGstDataSource* self, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error);
	gboolean (*perform_seek) (RygelGstDataSource* self);
};

struct _RygelTranscodingGstDataSource {
	RygelGstDataSource parent_instance;
	RygelTranscodingGstDataSourcePrivate * priv;
};

struct _RygelTranscodingGstDataSourceClass {
	RygelGstDataSourceClass parent_class;
};

struct _RygelTranscodingGstDataSourcePrivate {
	GstElement* decoder;
	GstElement* encoder;
	gboolean link_failed;
	RygelGstDataSource* orig_source;
};

static gint RygelTranscodingGstDataSource_private_offset;
static gpointer rygel_transcoding_gst_data_source_parent_class = NULL;

VALA_EXTERN GType rygel_gst_data_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_transcoding_gst_data_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeList* rygel_gst_data_source_preroll (RygelGstDataSource* self,
                                        RygelHTTPSeekRequest* seek_request,
                                        RygelPlaySpeedRequest* playspeed_request,
                                        GError** error);
VALA_EXTERN gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self);
VALA_EXTERN RygelTranscodingGstDataSource* rygel_transcoding_gst_data_source_new (RygelDataSource* src,
                                                                      GstEncodingProfile* profile,
                                                                      GError** error);
VALA_EXTERN RygelTranscodingGstDataSource* rygel_transcoding_gst_data_source_construct (GType object_type,
                                                                            RygelDataSource* src,
                                                                            GstEncodingProfile* profile,
                                                                            GError** error);
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
VALA_EXTERN RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type,
                                                                  GstElement* element);
VALA_EXTERN GstElement* rygel_gst_utils_create_element (const gchar* factoryname,
                                            const gchar* name,
                                            GError** error);
static GeeList* rygel_transcoding_gst_data_source_real_preroll (RygelGstDataSource* base,
                                                         RygelHTTPSeekRequest* seek_request,
                                                         RygelPlaySpeedRequest* playspeed_request,
                                                         GError** error);
VALA_EXTERN void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile,
                                            gint indent);
static gboolean rygel_transcoding_gst_data_source_on_decode_autoplug_continue (RygelTranscodingGstDataSource* self,
                                                                        GstElement* decodebin,
                                                                        GstPad* new_pad,
                                                                        GstCaps* caps);
static gboolean _rygel_transcoding_gst_data_source_on_decode_autoplug_continue_dynamic_autoplug_continue0_ (GstElement* _sender,
                                                                                                     GstPad* new_pad,
                                                                                                     GstCaps* caps,
                                                                                                     gpointer self);
static void rygel_transcoding_gst_data_source_on_decoder_pad_added (RygelTranscodingGstDataSource* self,
                                                             GstElement* decodebin,
                                                             GstPad* new_pad);
static void _rygel_transcoding_gst_data_source_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender,
                                                                                    GstPad* pad,
                                                                                    gpointer self);
static void rygel_transcoding_gst_data_source_on_no_more_pads (RygelTranscodingGstDataSource* self,
                                                        GstElement* decodebin);
static void _rygel_transcoding_gst_data_source_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender,
                                                                                  gpointer self);
VALA_EXTERN gchar* rygel_gst_data_source_get_uri (RygelGstDataSource* self);
static gboolean rygel_transcoding_gst_data_source_real_perform_seek (RygelGstDataSource* base);
static GstPad* rygel_transcoding_gst_data_source_get_compatible_sink_pad (RygelTranscodingGstDataSource* self,
                                                                   GstPad* pad,
                                                                   GstCaps* caps);
static void rygel_transcoding_gst_data_source_finalize (GObject * obj);
static GType rygel_transcoding_gst_data_source_get_type_once (void);

static inline gpointer
rygel_transcoding_gst_data_source_get_instance_private (RygelTranscodingGstDataSource* self)
{
	return G_STRUCT_MEMBER_P (self, RygelTranscodingGstDataSource_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelTranscodingGstDataSource*
rygel_transcoding_gst_data_source_construct (GType object_type,
                                             RygelDataSource* src,
                                             GstEncodingProfile* profile,
                                             GError** error)
{
	RygelTranscodingGstDataSource * self = NULL;
	GstBin* bin = NULL;
	GstBin* _tmp0_;
	GstBin* _tmp1_;
	RygelGstDataSource* _tmp2_;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_;
	GstElement* _tmp5_;
	GstElement* _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstBin* _tmp13_;
	GstElement* _tmp14_;
	GstPad* pad = NULL;
	GstElement* _tmp15_;
	GstPad* _tmp16_;
	GstGhostPad* ghost = NULL;
	GstPad* _tmp17_;
	GstGhostPad* _tmp18_;
	GstBin* _tmp19_;
	GstGhostPad* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (src != NULL, NULL);
	g_return_val_if_fail (profile != NULL, NULL);
	_tmp0_ = (GstBin*) gst_bin_new ("transcoder-source");
	g_object_ref_sink (_tmp0_);
	bin = _tmp0_;
	_tmp1_ = bin;
	self = (RygelTranscodingGstDataSource*) rygel_gst_data_source_construct_from_element (object_type, (GstElement*) _tmp1_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (src, RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource));
	_g_object_unref0 (self->priv->orig_source);
	self->priv->orig_source = _tmp2_;
	_tmp4_ = rygel_gst_utils_create_element (RYGEL_TRANSCODING_GST_DATA_SOURCE_ENCODE_BIN, RYGEL_TRANSCODING_GST_DATA_SOURCE_ENCODE_BIN, &_inner_error0_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (bin);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp5_ = _tmp3_;
	_tmp3_ = NULL;
	_g_object_unref0 (self->priv->encoder);
	self->priv->encoder = _tmp5_;
	_tmp6_ = self->priv->encoder;
	g_object_set (_tmp6_, "profile", profile, NULL);
	_tmp7_ = self->priv->encoder;
	g_object_get (_tmp7_, "profile", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		gchar* message = NULL;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
		_tmp10_ = g_strdup (_ ("Could not create a transcoder configuration. Your GStreamer installati" \
"on might be missing a plug-in"));
		message = _tmp10_;
		_tmp11_ = message;
		_tmp12_ = g_error_new_literal (RYGEL_GST_TRANSCODER_ERROR, RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE, _tmp11_);
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (message);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (bin);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp13_ = bin;
	_tmp14_ = self->priv->encoder;
	gst_bin_add (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->encoder;
	_tmp16_ = gst_element_get_static_pad (_tmp15_, "src");
	pad = _tmp16_;
	_tmp17_ = pad;
	_tmp18_ = (GstGhostPad*) gst_ghost_pad_new (NULL, _tmp17_);
	g_object_ref_sink (_tmp18_);
	ghost = _tmp18_;
	_tmp19_ = bin;
	_tmp20_ = ghost;
	gst_element_add_pad ((GstElement*) _tmp19_, (GstPad*) _tmp20_);
	_g_object_unref0 (ghost);
	_g_object_unref0 (pad);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (bin);
	return self;
}

RygelTranscodingGstDataSource*
rygel_transcoding_gst_data_source_new (RygelDataSource* src,
                                       GstEncodingProfile* profile,
                                       GError** error)
{
	return rygel_transcoding_gst_data_source_construct (RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE, src, profile, error);
}

static gboolean
_rygel_transcoding_gst_data_source_on_decode_autoplug_continue_dynamic_autoplug_continue0_ (GstElement* _sender,
                                                                                            GstPad* new_pad,
                                                                                            GstCaps* caps,
                                                                                            gpointer self)
{
	gboolean result;
	result = rygel_transcoding_gst_data_source_on_decode_autoplug_continue ((RygelTranscodingGstDataSource*) self, _sender, new_pad, caps);
	return result;
}

static void
_rygel_transcoding_gst_data_source_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender,
                                                                               GstPad* pad,
                                                                               gpointer self)
{
	rygel_transcoding_gst_data_source_on_decoder_pad_added ((RygelTranscodingGstDataSource*) self, _sender, pad);
}

static void
_rygel_transcoding_gst_data_source_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender,
                                                                             gpointer self)
{
	rygel_transcoding_gst_data_source_on_no_more_pads ((RygelTranscodingGstDataSource*) self, _sender);
}

static GeeList*
rygel_transcoding_gst_data_source_real_preroll (RygelGstDataSource* base,
                                                RygelHTTPSeekRequest* seek_request,
                                                RygelPlaySpeedRequest* playspeed_request,
                                                GError** error)
{
	RygelTranscodingGstDataSource * self;
	GstBin* bin = NULL;
	GstElement* _tmp0_;
	GstBin* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeList* _tmp48_ = NULL;
	GeeList* _tmp49_;
	GeeList* _tmp50_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	self = (RygelTranscodingGstDataSource*) base;
	_tmp0_ = ((RygelGstDataSource*) self)->src;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gst_bin_get_type (), GstBin));
	bin = _tmp1_;
	if (seek_request == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (seek_request, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST);
	}
	if (_tmp2_) {
		GstElement* _tmp3_ = NULL;
		GstElement* _tmp4_;
		GstElement* _tmp5_;
		GObjectClass* _tmp6_;
		const gchar* _tmp7_;
		GstElement* _tmp8_;
		GstEncodingProfile* _tmp9_;
		GstEncodingProfile* _tmp10_;
		GstBin* _tmp11_;
		RygelGstDataSource* _tmp12_;
		GstElement* _tmp13_;
		GstElement* _tmp14_;
		RygelGstDataSource* _tmp15_;
		GstElement* _tmp16_;
		GstElement* _tmp17_;
		RygelGstDataSource* _tmp18_;
		GstElement* _tmp19_;
		GstElement* _tmp20_;
		GstElement* _tmp21_;
		GstElement* _tmp22_;
		GstElement* _tmp23_;
		_tmp4_ = rygel_gst_utils_create_element (RYGEL_TRANSCODING_GST_DATA_SOURCE_DECODE_BIN, RYGEL_TRANSCODING_GST_DATA_SOURCE_DECODE_BIN, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (bin);
			return NULL;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->decoder);
		self->priv->decoder = _tmp5_;
		_tmp6_ = G_OBJECT_GET_CLASS ((GObject*) self);
		_tmp7_ = g_type_name (G_OBJECT_CLASS_TYPE (_tmp6_));
		g_debug ("rygel-gst-transcoding-data-source.vala:48: %s using the following enco" \
"ding profile:", _tmp7_);
		_tmp8_ = self->priv->encoder;
		g_object_get (_tmp8_, "profile", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		rygel_gst_utils_dump_encoding_profile (_tmp10_, 2);
		_tmp11_ = bin;
		_tmp12_ = self->priv->orig_source;
		_tmp13_ = _tmp12_->src;
		_tmp14_ = self->priv->decoder;
		gst_bin_add_many (_tmp11_, _tmp13_, _tmp14_, NULL);
		_tmp15_ = self->priv->orig_source;
		_tmp16_ = _tmp15_->src;
		_tmp17_ = self->priv->decoder;
		gst_element_link (_tmp16_, _tmp17_);
		_tmp18_ = self->priv->orig_source;
		_tmp19_ = _tmp18_->src;
		gst_element_sync_state_with_parent (_tmp19_);
		_tmp20_ = self->priv->decoder;
		gst_element_sync_state_with_parent (_tmp20_);
		_tmp21_ = self->priv->decoder;
		g_signal_connect_object (_tmp21_, "autoplug-continue", (GCallback) _rygel_transcoding_gst_data_source_on_decode_autoplug_continue_dynamic_autoplug_continue0_, self, 0);
		_tmp22_ = self->priv->decoder;
		g_signal_connect_object (_tmp22_, "pad-added", (GCallback) _rygel_transcoding_gst_data_source_on_decoder_pad_added_gst_element_pad_added, self, 0);
		_tmp23_ = self->priv->decoder;
		g_signal_connect_object (_tmp23_, "no-more-pads", (GCallback) _rygel_transcoding_gst_data_source_on_no_more_pads_gst_element_no_more_pads, self, 0);
		_g_object_unref0 (_tmp3_);
	} else {
		RygelHTTPTimeSeekRequest* time_seek = NULL;
		RygelHTTPTimeSeekRequest* _tmp24_;
		GESTimeline* timeline = NULL;
		GESTimeline* _tmp25_;
		GESLayer* layer = NULL;
		GESTimeline* _tmp26_;
		GESLayer* _tmp27_;
		GESLayer* _tmp28_;
		GESUriClip* clip = NULL;
		RygelGstDataSource* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GESUriClip* _tmp32_;
		GESUriClip* _tmp33_;
		GESUriClip* _tmp34_;
		RygelHTTPTimeSeekRequest* _tmp35_;
		GESUriClip* _tmp36_;
		RygelHTTPTimeSeekRequest* _tmp37_;
		GESLayer* _tmp38_;
		GESUriClip* _tmp39_;
		GESTimeline* _tmp40_;
		GstElement* gessrc = NULL;
		GstElement* _tmp41_;
		GstBin* _tmp42_;
		GstElement* _tmp43_;
		GstElement* _tmp44_;
		GstElement* _tmp45_;
		GstElement* _tmp46_;
		GESTimeline* _tmp47_;
		_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (seek_request, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest));
		time_seek = _tmp24_;
		_tmp25_ = ges_timeline_new_audio_video ();
		g_object_ref_sink (_tmp25_);
		timeline = _tmp25_;
		_tmp26_ = timeline;
		_tmp27_ = ges_timeline_append_layer (_tmp26_);
		_tmp28_ = _g_object_ref0 (_tmp27_);
		layer = _tmp28_;
		_tmp29_ = self->priv->orig_source;
		_tmp30_ = rygel_gst_data_source_get_uri (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = ges_uri_clip_new (_tmp31_);
		g_object_ref_sink (_tmp32_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		clip = _tmp33_;
		_tmp34_ = clip;
		_tmp35_ = time_seek;
		g_object_set ((GESTimelineElement*) _tmp34_, "in-point", (guint64) (_tmp35_->start_time * GST_USECOND), NULL);
		_tmp36_ = clip;
		_tmp37_ = time_seek;
		ges_timeline_element_set_duration ((GESTimelineElement*) _tmp36_, (guint64) (_tmp37_->range_duration * GST_USECOND));
		_tmp38_ = layer;
		_tmp39_ = clip;
		ges_layer_add_clip (_tmp38_, (GESClip*) _tmp39_);
		_tmp40_ = timeline;
		ges_timeline_commit (_tmp40_);
		_tmp41_ = rygel_gst_utils_create_element ("gessrc", "gessrc", &_inner_error0_);
		gessrc = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (clip);
			_g_object_unref0 (layer);
			_g_object_unref0 (timeline);
			_g_object_unref0 (time_seek);
			_g_object_unref0 (bin);
			return NULL;
		}
		_tmp42_ = bin;
		_tmp43_ = gessrc;
		gst_bin_add (_tmp42_, _tmp43_);
		_tmp44_ = gessrc;
		g_signal_connect_object (_tmp44_, "pad-added", (GCallback) _rygel_transcoding_gst_data_source_on_decoder_pad_added_gst_element_pad_added, self, 0);
		_tmp45_ = gessrc;
		g_signal_connect_object (_tmp45_, "no-more-pads", (GCallback) _rygel_transcoding_gst_data_source_on_no_more_pads_gst_element_no_more_pads, self, 0);
		_tmp46_ = gessrc;
		_tmp47_ = timeline;
		g_object_set ((GObject*) _tmp46_, "timeline", _tmp47_, NULL, NULL);
		_g_object_unref0 (gessrc);
		_g_object_unref0 (clip);
		_g_object_unref0 (layer);
		_g_object_unref0 (timeline);
		_g_object_unref0 (time_seek);
	}
	_tmp49_ = RYGEL_GST_DATA_SOURCE_CLASS (rygel_transcoding_gst_data_source_parent_class)->preroll (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource), seek_request, playspeed_request, &_inner_error0_);
	_tmp48_ = _tmp49_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (bin);
		return NULL;
	}
	_tmp50_ = _tmp48_;
	_tmp48_ = NULL;
	result = _tmp50_;
	_g_object_unref0 (_tmp48_);
	_g_object_unref0 (bin);
	return result;
}

static gboolean
rygel_transcoding_gst_data_source_real_perform_seek (RygelGstDataSource* base)
{
	RygelTranscodingGstDataSource * self;
	gboolean result;
	self = (RygelTranscodingGstDataSource*) base;
	result = TRUE;
	return result;
}

static GstPad*
rygel_transcoding_gst_data_source_get_compatible_sink_pad (RygelTranscodingGstDataSource* self,
                                                           GstPad* pad,
                                                           GstCaps* caps)
{
	GstPad* sinkpad = NULL;
	GstElement* _tmp0_;
	GstPad* _tmp1_;
	GstPad* _tmp2_;
	GstPad* _tmp5_;
	GstPad* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pad != NULL, NULL);
	g_return_val_if_fail (caps != NULL, NULL);
	_tmp0_ = self->priv->encoder;
	_tmp1_ = gst_element_get_compatible_pad (_tmp0_, pad, NULL);
	sinkpad = _tmp1_;
	_tmp2_ = sinkpad;
	if (_tmp2_ == NULL) {
		GstElement* _tmp3_;
		GstPad* _tmp4_ = NULL;
		_tmp3_ = self->priv->encoder;
		g_signal_emit_by_name (_tmp3_, "request-pad", caps, &_tmp4_, NULL);
		_g_object_unref0 (sinkpad);
		sinkpad = _tmp4_;
	}
	_tmp5_ = sinkpad;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = gst_object_get_name ((GstObject*) pad);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		g_debug ("rygel-gst-transcoding-data-source.vala:92: No compatible encodebin pad" \
" found for pad '%s', ignoring...", _tmp8_);
		_g_free0 (_tmp8_);
	}
	result = sinkpad;
	return result;
}

static gboolean
rygel_transcoding_gst_data_source_on_decode_autoplug_continue (RygelTranscodingGstDataSource* self,
                                                               GstElement* decodebin,
                                                               GstPad* new_pad,
                                                               GstCaps* caps)
{
	GstPad* _tmp0_;
	GstPad* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (decodebin != NULL, FALSE);
	g_return_val_if_fail (new_pad != NULL, FALSE);
	g_return_val_if_fail (caps != NULL, FALSE);
	_tmp0_ = rygel_transcoding_gst_data_source_get_compatible_sink_pad (self, new_pad, caps);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
rygel_transcoding_gst_data_source_on_decoder_pad_added (RygelTranscodingGstDataSource* self,
                                                        GstElement* decodebin,
                                                        GstPad* new_pad)
{
	GstPad* sinkpad = NULL;
	GstCaps* _tmp0_;
	GstCaps* _tmp1_;
	GstPad* _tmp2_;
	GstPad* _tmp3_;
	GstPad* _tmp4_;
	gboolean pad_link_ok = FALSE;
	GstPad* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (decodebin != NULL);
	g_return_if_fail (new_pad != NULL);
	_tmp0_ = gst_pad_query_caps (new_pad, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_transcoding_gst_data_source_get_compatible_sink_pad (self, new_pad, _tmp1_);
	_tmp3_ = _tmp2_;
	_gst_caps_unref0 (_tmp1_);
	sinkpad = _tmp3_;
	_tmp4_ = sinkpad;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = gst_object_get_name ((GstObject*) new_pad);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		g_debug ("rygel-gst-transcoding-data-source.vala:109: No compatible encodebin pa" \
"d found for pad '%s', ignoring...", _tmp7_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (sinkpad);
		return;
	}
	_tmp8_ = sinkpad;
	pad_link_ok = gst_pad_link_full (new_pad, _tmp8_, GST_PAD_LINK_CHECK_DEFAULT) == GST_PAD_LINK_OK;
	if (!pad_link_ok) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GstPad* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp9_ = gst_object_get_name ((GstObject*) new_pad);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = sinkpad;
		_tmp13_ = gst_object_get_name ((GstObject*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		g_warning ("rygel-gst-transcoding-data-source.vala:116: Failed to link pad '%s' to" \
" '%s'", _tmp11_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp11_);
	} else {
		self->priv->link_failed = FALSE;
	}
	_g_object_unref0 (sinkpad);
}

static gpointer
_gst_message_ref0 (gpointer self)
{
	return self ? gst_message_ref (self) : NULL;
}

static void
rygel_transcoding_gst_data_source_on_no_more_pads (RygelTranscodingGstDataSource* self,
                                                   GstElement* decodebin)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (decodebin != NULL);
	if (self->priv->link_failed) {
		GstBin* bin = NULL;
		GstElement* _tmp0_;
		GstObject* _tmp1_;
		GstBin* _tmp2_;
		GError* _error_ = NULL;
		GError* _tmp3_;
		GstMessage* message = NULL;
		GstBin* _tmp4_;
		GError* _tmp5_;
		GstMessage* _tmp6_;
		GstBus* bus = NULL;
		GstBin* _tmp7_;
		GstBus* _tmp8_;
		GstBus* _tmp9_;
		GstMessage* _tmp10_;
		GstMessage* _tmp11_;
		_tmp0_ = self->priv->encoder;
		_tmp1_ = gst_object_get_parent ((GstObject*) _tmp0_);
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gst_bin_get_type ()) ? ((GstBin*) _tmp1_) : NULL;
		if (_tmp2_ == NULL) {
			_g_object_unref0 (_tmp1_);
		}
		bin = _tmp2_;
		_tmp3_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not link");
		_error_ = _tmp3_;
		_tmp4_ = bin;
		_tmp5_ = _error_;
		_tmp6_ = gst_message_new_error ((GstObject*) _tmp4_, _tmp5_, RYGEL_TRANSCODING_GST_DATA_SOURCE_DESCRIPTION);
		message = _tmp6_;
		_tmp7_ = bin;
		_tmp8_ = gst_element_get_bus ((GstElement*) _tmp7_);
		bus = _tmp8_;
		_tmp9_ = bus;
		_tmp10_ = message;
		_tmp11_ = _gst_message_ref0 (_tmp10_);
		gst_bus_post (_tmp9_, _tmp11_);
		_g_object_unref0 (bus);
		_gst_message_unref0 (message);
		_g_error_free0 (_error_);
		_g_object_unref0 (bin);
	}
}

static void
rygel_transcoding_gst_data_source_class_init (RygelTranscodingGstDataSourceClass * klass,
                                              gpointer klass_data)
{
	rygel_transcoding_gst_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelTranscodingGstDataSource_private_offset);
	((RygelGstDataSourceClass *) klass)->preroll = (GeeList* (*) (RygelGstDataSource*, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_transcoding_gst_data_source_real_preroll;
	((RygelGstDataSourceClass *) klass)->perform_seek = (gboolean (*) (RygelGstDataSource*)) rygel_transcoding_gst_data_source_real_perform_seek;
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoding_gst_data_source_finalize;
}

static void
rygel_transcoding_gst_data_source_instance_init (RygelTranscodingGstDataSource * self,
                                                 gpointer klass)
{
	self->priv = rygel_transcoding_gst_data_source_get_instance_private (self);
	self->priv->link_failed = TRUE;
}

static void
rygel_transcoding_gst_data_source_finalize (GObject * obj)
{
	RygelTranscodingGstDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODING_GST_DATA_SOURCE, RygelTranscodingGstDataSource);
	_g_object_unref0 (self->priv->decoder);
	_g_object_unref0 (self->priv->encoder);
	_g_object_unref0 (self->priv->orig_source);
	G_OBJECT_CLASS (rygel_transcoding_gst_data_source_parent_class)->finalize (obj);
}

static GType
rygel_transcoding_gst_data_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelTranscodingGstDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoding_gst_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscodingGstDataSource), 0, (GInstanceInitFunc) rygel_transcoding_gst_data_source_instance_init, NULL };
	GType rygel_transcoding_gst_data_source_type_id;
	rygel_transcoding_gst_data_source_type_id = g_type_register_static (RYGEL_TYPE_GST_DATA_SOURCE, "RygelTranscodingGstDataSource", &g_define_type_info, 0);
	RygelTranscodingGstDataSource_private_offset = g_type_add_instance_private (rygel_transcoding_gst_data_source_type_id, sizeof (RygelTranscodingGstDataSourcePrivate));
	return rygel_transcoding_gst_data_source_type_id;
}

GType
rygel_transcoding_gst_data_source_get_type (void)
{
	static volatile gsize rygel_transcoding_gst_data_source_type_id__once = 0;
	if (g_once_init_enter (&rygel_transcoding_gst_data_source_type_id__once)) {
		GType rygel_transcoding_gst_data_source_type_id;
		rygel_transcoding_gst_data_source_type_id = rygel_transcoding_gst_data_source_get_type_once ();
		g_once_init_leave (&rygel_transcoding_gst_data_source_type_id__once, rygel_transcoding_gst_data_source_type_id);
	}
	return rygel_transcoding_gst_data_source_type_id__once;
}

