/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.mfirstuc;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.mfirstuc.CapitaliseFmtWords;
import com.dickimawbooks.texparserlib.latex.mfirstuc.CapitaliseWords;
import com.dickimawbooks.texparserlib.latex.mfirstuc.GlsMakeFirstUc;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUnocap;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUskippunc;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MFUwordbreak;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MakeFirstUc;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import com.dickimawbooks.texparserlib.primitives.Uppercase;
import java.io.IOException;

public class MfirstucSty
extends LaTeXSty {
    public MfirstucSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "mfirstuc", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        LaTeXParserListener laTeXParserListener = this.getListener();
        NewIf.createConditional(true, this.getParser(), "ifMFUhyphen", false);
        this.registerControlSequence(new GlsMakeFirstUc());
        this.registerControlSequence(new MakeFirstUc());
        this.registerControlSequence(new MakeFirstUc("xmakefirstuc", 1));
        this.registerControlSequence(new MakeFirstUc("emakefirstuc", 2));
        this.registerControlSequence(new CapitaliseWords(this));
        this.registerControlSequence(new CapitaliseWords(this, "xcapitalisewords", 1));
        this.registerControlSequence(new CapitaliseWords(this, "ecapitalisewords", 2));
        this.registerControlSequence(new CapitaliseFmtWords(this));
        this.registerControlSequence(new MakeFirstUc("MFUcapword"));
        this.registerControlSequence(new MFUnocap(this));
        this.registerControlSequence(new MFUnocap(this, "gMFUnocap", true));
        this.registerControlSequence(new MFUskippunc());
        this.registerControlSequence(new MFUwordbreak());
        if (laTeXParserListener.isStyLoaded("textcase") || laTeXParserListener.isStyLoaded("glossaries")) {
            this.registerControlSequence(new GenericCommand(true, "mfirstucMakeUppercase", null, new TeXObject[]{new TeXCsRef("MakeTextUppercase")}));
        } else {
            this.registerControlSequence(new Uppercase("mfirstucMakeUppercase"));
        }
    }

    public void addException(String string) {
        this.addException(this.getListener().createString(string), false);
    }

    public void addException(TeXObject teXObject, boolean bl) {
        ControlSequence controlSequence = this.getParser().getControlSequence("@mfu@nocaplist");
        TeXObjectList teXObjectList = controlSequence instanceof GenericCommand ? ((GenericCommand)controlSequence).getDefinition() : new TeXObjectList();
        teXObjectList.add((TeXObject)teXObject.clone());
        this.getParser().putControlSequence(!bl, new GenericCommand("@mfu@nocaplist", null, teXObjectList));
    }

    public boolean isException(TeXObject teXObject) {
        ControlSequence controlSequence = this.getParser().getControlSequence("@mfu@nocaplist");
        TeXObjectList teXObjectList = controlSequence instanceof GenericCommand ? ((GenericCommand)controlSequence).getDefinition() : new TeXObjectList();
        return teXObjectList.contains(teXObject);
    }
}

