/* tracker-sparql-scanner.c generated by valac 0.56.1, the Vala compiler
 * generated from tracker-sparql-scanner.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include "tracker-sparql-query.h"
#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <stdlib.h>
#include <string.h>

enum  {
	TRACKER_SPARQL_SCANNER_0_PROPERTY,
	TRACKER_SPARQL_SCANNER_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_scanner_properties[TRACKER_SPARQL_SCANNER_NUM_PROPERTIES];

struct _TrackerSparqlScannerPrivate {
	gchar* current;
	gchar* end;
	gint line;
	gint column;
};

static gint TrackerSparqlScanner_private_offset;
static gpointer tracker_sparql_scanner_parent_class = NULL;

static TrackerSparqlTokenType tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self,
                                                                         gchar* begin,
                                                                         gint len);
static gboolean tracker_sparql_scanner_matches (TrackerSparqlScanner* self,
                                         gchar* begin,
                                         const gchar* keyword);
static TrackerSparqlTokenType tracker_sparql_scanner_read_number (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self,
                                            gchar c);
static gboolean tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self,
                                                  gchar c);
static gboolean tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self,
                                                 gchar c);
static void tracker_sparql_scanner_space (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_comment (TrackerSparqlScanner* self);
static void tracker_sparql_scanner_finalize (GObject * obj);
static GType tracker_sparql_scanner_get_type_once (void);

static inline gpointer
tracker_sparql_scanner_get_instance_private (TrackerSparqlScanner* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerSparqlScanner_private_offset);
}

TrackerSparqlScanner*
tracker_sparql_scanner_construct (GType object_type,
                                  gchar* input,
                                  gsize len)
{
	TrackerSparqlScanner * self = NULL;
	gchar* begin = NULL;
#line 27 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self = (TrackerSparqlScanner*) g_object_new (object_type, NULL);
#line 28 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	begin = input;
#line 29 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->end = begin + len;
#line 31 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->current = begin;
#line 33 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->line = 1;
#line 34 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->column = 1;
#line 27 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return self;
#line 93 "tracker-sparql-scanner.c"
}

TrackerSparqlScanner*
tracker_sparql_scanner_new (gchar* input,
                            gsize len)
{
#line 27 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return tracker_sparql_scanner_construct (TRACKER_TYPE_SPARQL_SCANNER, input, len);
#line 102 "tracker-sparql-scanner.c"
}

void
tracker_sparql_scanner_seek (TrackerSparqlScanner* self,
                             TrackerSourceLocation* location)
{
	TrackerSourceLocation _tmp0_;
	gchar* _tmp1_;
	TrackerSourceLocation _tmp2_;
	TrackerSourceLocation _tmp3_;
#line 37 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 37 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (location != NULL);
#line 38 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = *location;
#line 38 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = _tmp0_.pos;
#line 38 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->current = _tmp1_;
#line 39 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = *location;
#line 39 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->line = _tmp2_.line;
#line 40 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = *location;
#line 40 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->column = _tmp3_.column;
#line 131 "tracker-sparql-scanner.c"
}

static TrackerSparqlTokenType
tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self,
                                                  gchar* begin,
                                                  gint len)
{
	TrackerSparqlTokenType result;
#line 43 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	switch (len) {
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 1:
#line 146 "tracker-sparql-scanner.c"
		{
			gchar _tmp0_;
#line 46 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = begin[0];
#line 46 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp0_) {
#line 46 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 46 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 157 "tracker-sparql-scanner.c"
				{
#line 49 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					result = TRACKER_SPARQL_TOKEN_TYPE_A;
#line 49 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					return result;
#line 163 "tracker-sparql-scanner.c"
				}
				default:
#line 46 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 168 "tracker-sparql-scanner.c"
			}
#line 51 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 172 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 2:
#line 176 "tracker-sparql-scanner.c"
		{
			gchar _tmp1_;
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp1_ = begin[0];
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp1_) {
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 187 "tracker-sparql-scanner.c"
				{
#line 56 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "AS")) {
#line 56 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_AS;
#line 56 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 195 "tracker-sparql-scanner.c"
					}
#line 57 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 199 "tracker-sparql-scanner.c"
				}
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 205 "tracker-sparql-scanner.c"
				{
#line 60 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "BY")) {
#line 60 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BY;
#line 60 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 213 "tracker-sparql-scanner.c"
					}
#line 61 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 217 "tracker-sparql-scanner.c"
				}
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 223 "tracker-sparql-scanner.c"
				{
					gchar _tmp2_;
#line 64 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp2_ = begin[1];
#line 64 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp2_) {
#line 64 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'F':
#line 64 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'f':
#line 234 "tracker-sparql-scanner.c"
						{
#line 67 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "IF")) {
#line 67 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_IF;
#line 67 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 242 "tracker-sparql-scanner.c"
							}
#line 68 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 246 "tracker-sparql-scanner.c"
						}
#line 64 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 64 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 252 "tracker-sparql-scanner.c"
						{
#line 71 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "IN")) {
#line 71 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_OP_IN;
#line 71 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 260 "tracker-sparql-scanner.c"
							}
#line 72 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 264 "tracker-sparql-scanner.c"
						}
						default:
#line 64 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 269 "tracker-sparql-scanner.c"
					}
#line 74 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 273 "tracker-sparql-scanner.c"
				}
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 279 "tracker-sparql-scanner.c"
				{
#line 77 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "OR")) {
#line 77 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OR;
#line 77 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 287 "tracker-sparql-scanner.c"
					}
#line 78 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 291 "tracker-sparql-scanner.c"
				}
				default:
#line 53 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 296 "tracker-sparql-scanner.c"
			}
#line 80 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 300 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 3:
#line 304 "tracker-sparql-scanner.c"
		{
			gchar _tmp3_;
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp3_ = begin[0];
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp3_) {
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 315 "tracker-sparql-scanner.c"
				{
					gchar _tmp4_;
#line 85 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp4_ = begin[1];
#line 85 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp4_) {
#line 85 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 85 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 326 "tracker-sparql-scanner.c"
						{
							gchar _tmp5_;
#line 88 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp5_ = begin[2];
#line 88 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp5_) {
#line 88 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'C':
#line 88 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'c':
#line 337 "tracker-sparql-scanner.c"
								{
#line 91 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ASC")) {
#line 91 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASC;
#line 91 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 345 "tracker-sparql-scanner.c"
									}
#line 92 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 349 "tracker-sparql-scanner.c"
								}
#line 88 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'K':
#line 88 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'k':
#line 355 "tracker-sparql-scanner.c"
								{
#line 95 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ASK")) {
#line 95 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASK;
#line 95 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 363 "tracker-sparql-scanner.c"
									}
#line 96 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 367 "tracker-sparql-scanner.c"
								}
								default:
#line 88 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 372 "tracker-sparql-scanner.c"
							}
#line 98 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 376 "tracker-sparql-scanner.c"
						}
#line 85 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'B':
#line 85 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'b':
#line 382 "tracker-sparql-scanner.c"
						{
#line 101 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "ABS")) {
#line 101 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_ABS;
#line 101 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 390 "tracker-sparql-scanner.c"
							}
#line 102 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 394 "tracker-sparql-scanner.c"
						}
#line 85 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'V':
#line 85 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'v':
#line 400 "tracker-sparql-scanner.c"
						{
#line 105 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "AVG")) {
#line 105 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_AVG;
#line 105 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 408 "tracker-sparql-scanner.c"
							}
#line 106 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 412 "tracker-sparql-scanner.c"
						}
						default:
#line 85 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 417 "tracker-sparql-scanner.c"
					}
#line 108 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 421 "tracker-sparql-scanner.c"
				}
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 427 "tracker-sparql-scanner.c"
				{
#line 111 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "DAY")) {
#line 111 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_DAY;
#line 111 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 435 "tracker-sparql-scanner.c"
					}
#line 112 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 439 "tracker-sparql-scanner.c"
				}
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 445 "tracker-sparql-scanner.c"
				{
					gchar _tmp6_;
#line 115 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp6_ = begin[1];
#line 115 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp6_) {
#line 115 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 115 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 456 "tracker-sparql-scanner.c"
						{
#line 118 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "MAX")) {
#line 118 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MAX;
#line 118 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 464 "tracker-sparql-scanner.c"
							}
#line 119 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 468 "tracker-sparql-scanner.c"
						}
#line 115 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'D':
#line 115 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'd':
#line 474 "tracker-sparql-scanner.c"
						{
#line 122 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "MD5")) {
#line 122 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MD5;
#line 122 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 482 "tracker-sparql-scanner.c"
							}
#line 123 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 486 "tracker-sparql-scanner.c"
						}
#line 115 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 115 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 492 "tracker-sparql-scanner.c"
						{
#line 126 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "MIN")) {
#line 126 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MIN;
#line 126 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 500 "tracker-sparql-scanner.c"
							}
#line 127 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 504 "tracker-sparql-scanner.c"
						}
						default:
#line 115 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 509 "tracker-sparql-scanner.c"
					}
#line 129 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 513 "tracker-sparql-scanner.c"
				}
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 519 "tracker-sparql-scanner.c"
				{
					gchar _tmp7_;
#line 132 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp7_ = begin[2];
#line 132 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp7_) {
#line 132 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 132 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 530 "tracker-sparql-scanner.c"
						{
#line 135 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "NOT")) {
#line 135 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_NOT;
#line 135 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 538 "tracker-sparql-scanner.c"
							}
#line 136 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 542 "tracker-sparql-scanner.c"
						}
#line 132 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'W':
#line 132 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'w':
#line 548 "tracker-sparql-scanner.c"
						{
#line 139 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "NOW")) {
#line 139 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_NOW;
#line 139 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 556 "tracker-sparql-scanner.c"
							}
#line 140 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 560 "tracker-sparql-scanner.c"
						}
						default:
#line 132 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 565 "tracker-sparql-scanner.c"
					}
#line 142 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 569 "tracker-sparql-scanner.c"
				}
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 575 "tracker-sparql-scanner.c"
				{
					gchar _tmp8_;
#line 145 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp8_ = begin[1];
#line 145 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp8_) {
#line 145 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 145 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 586 "tracker-sparql-scanner.c"
						{
#line 148 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STR")) {
#line 148 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STR;
#line 148 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 594 "tracker-sparql-scanner.c"
							}
#line 149 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 598 "tracker-sparql-scanner.c"
						}
#line 145 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'U':
#line 145 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'u':
#line 604 "tracker-sparql-scanner.c"
						{
#line 152 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SUM")) {
#line 152 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SUM;
#line 152 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 612 "tracker-sparql-scanner.c"
							}
#line 153 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 616 "tracker-sparql-scanner.c"
						}
						default:
#line 145 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 621 "tracker-sparql-scanner.c"
					}
#line 155 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 625 "tracker-sparql-scanner.c"
				}
				default:
#line 82 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 630 "tracker-sparql-scanner.c"
			}
#line 157 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 634 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 4:
#line 638 "tracker-sparql-scanner.c"
		{
			gchar _tmp9_;
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp9_ = begin[0];
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp9_) {
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 649 "tracker-sparql-scanner.c"
				{
					gchar _tmp10_;
#line 162 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp10_ = begin[1];
#line 162 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp10_) {
#line 162 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 162 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 660 "tracker-sparql-scanner.c"
						{
#line 165 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "BASE")) {
#line 165 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_BASE;
#line 165 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 668 "tracker-sparql-scanner.c"
							}
#line 166 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 672 "tracker-sparql-scanner.c"
						}
#line 162 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 162 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 678 "tracker-sparql-scanner.c"
						{
#line 169 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "BIND")) {
#line 169 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_BIND;
#line 169 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 686 "tracker-sparql-scanner.c"
							}
#line 170 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 690 "tracker-sparql-scanner.c"
						}
						default:
#line 162 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 695 "tracker-sparql-scanner.c"
					}
#line 172 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 699 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 705 "tracker-sparql-scanner.c"
				{
#line 175 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "CEIL")) {
#line 175 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CEIL;
#line 175 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 713 "tracker-sparql-scanner.c"
					}
#line 176 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 717 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 723 "tracker-sparql-scanner.c"
				{
					gchar _tmp11_;
#line 179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp11_ = begin[1];
#line 179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp11_) {
#line 179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 734 "tracker-sparql-scanner.c"
						{
#line 182 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DATA")) {
#line 182 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATA;
#line 182 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 742 "tracker-sparql-scanner.c"
							}
#line 183 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 746 "tracker-sparql-scanner.c"
						}
#line 179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 752 "tracker-sparql-scanner.c"
						{
#line 186 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DESC")) {
#line 186 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESC;
#line 186 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 760 "tracker-sparql-scanner.c"
							}
#line 187 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 764 "tracker-sparql-scanner.c"
						}
#line 179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'R':
#line 179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'r':
#line 770 "tracker-sparql-scanner.c"
						{
#line 190 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DROP")) {
#line 190 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DROP;
#line 190 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 778 "tracker-sparql-scanner.c"
							}
#line 191 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 782 "tracker-sparql-scanner.c"
						}
						default:
#line 179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 787 "tracker-sparql-scanner.c"
					}
#line 193 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 791 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 797 "tracker-sparql-scanner.c"
				{
#line 196 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "FROM")) {
#line 196 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FROM;
#line 196 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 805 "tracker-sparql-scanner.c"
					}
#line 197 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 809 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 815 "tracker-sparql-scanner.c"
				{
#line 200 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "INTO")) {
#line 200 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INTO;
#line 200 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 823 "tracker-sparql-scanner.c"
					}
#line 201 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 827 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'L':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'l':
#line 833 "tracker-sparql-scanner.c"
				{
#line 204 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "LANG")) {
#line 204 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_LANG;
#line 204 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 841 "tracker-sparql-scanner.c"
					}
#line 205 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 845 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 851 "tracker-sparql-scanner.c"
				{
#line 208 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "NULL")) {
#line 208 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NULL;
#line 208 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 859 "tracker-sparql-scanner.c"
					}
#line 209 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 863 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 869 "tracker-sparql-scanner.c"
				{
#line 212 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "RAND")) {
#line 212 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_RAND;
#line 212 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 877 "tracker-sparql-scanner.c"
					}
#line 213 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 881 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 887 "tracker-sparql-scanner.c"
				{
#line 216 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "SHA1")) {
#line 216 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_SHA1;
#line 216 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 895 "tracker-sparql-scanner.c"
					}
#line 217 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 899 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'T':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 't':
#line 905 "tracker-sparql-scanner.c"
				{
#line 220 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "TRUE")) {
#line 220 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_TRUE;
#line 220 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 913 "tracker-sparql-scanner.c"
					}
#line 221 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 917 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'W':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'w':
#line 923 "tracker-sparql-scanner.c"
				{
#line 224 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "WITH")) {
#line 224 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WITH;
#line 224 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 931 "tracker-sparql-scanner.c"
					}
#line 225 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 935 "tracker-sparql-scanner.c"
				}
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'Y':
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'y':
#line 941 "tracker-sparql-scanner.c"
				{
#line 228 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "YEAR")) {
#line 228 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_YEAR;
#line 228 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 949 "tracker-sparql-scanner.c"
					}
#line 229 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 953 "tracker-sparql-scanner.c"
				}
				default:
#line 159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 958 "tracker-sparql-scanner.c"
			}
#line 231 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 962 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 5:
#line 966 "tracker-sparql-scanner.c"
		{
			gchar _tmp12_;
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp12_ = begin[0];
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp12_) {
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 977 "tracker-sparql-scanner.c"
				{
#line 236 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "BOUND")) {
#line 236 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BOUND;
#line 236 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 985 "tracker-sparql-scanner.c"
					}
#line 237 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 989 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 995 "tracker-sparql-scanner.c"
				{
#line 240 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "COUNT")) {
#line 240 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_COUNT;
#line 240 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1003 "tracker-sparql-scanner.c"
					}
#line 241 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1007 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'G':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'g':
#line 1013 "tracker-sparql-scanner.c"
				{
					gchar _tmp13_;
#line 244 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp13_ = begin[2];
#line 244 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp13_) {
#line 244 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 244 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 1024 "tracker-sparql-scanner.c"
						{
#line 247 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "GRAPH")) {
#line 247 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
#line 247 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1032 "tracker-sparql-scanner.c"
							}
#line 248 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1036 "tracker-sparql-scanner.c"
						}
#line 244 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'O':
#line 244 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'o':
#line 1042 "tracker-sparql-scanner.c"
						{
#line 251 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "GROUP")) {
#line 251 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GROUP;
#line 251 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1050 "tracker-sparql-scanner.c"
							}
#line 252 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1054 "tracker-sparql-scanner.c"
						}
						default:
#line 244 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1059 "tracker-sparql-scanner.c"
					}
#line 254 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1063 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'H':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'h':
#line 1069 "tracker-sparql-scanner.c"
				{
#line 257 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "HOURS")) {
#line 257 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_HOURS;
#line 257 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1077 "tracker-sparql-scanner.c"
					}
#line 258 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1081 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'L':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'l':
#line 1087 "tracker-sparql-scanner.c"
				{
					gchar _tmp14_;
#line 261 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp14_ = begin[1];
#line 261 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp14_) {
#line 261 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'C':
#line 261 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'c':
#line 1098 "tracker-sparql-scanner.c"
						{
#line 264 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "LCASE")) {
#line 264 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_LCASE;
#line 264 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1106 "tracker-sparql-scanner.c"
							}
#line 265 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1110 "tracker-sparql-scanner.c"
						}
#line 261 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 261 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 1116 "tracker-sparql-scanner.c"
						{
#line 268 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "LIMIT")) {
#line 268 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
#line 268 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1124 "tracker-sparql-scanner.c"
							}
#line 269 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1128 "tracker-sparql-scanner.c"
						}
						default:
#line 261 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1133 "tracker-sparql-scanner.c"
					}
#line 271 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1137 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 1143 "tracker-sparql-scanner.c"
				{
#line 274 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "MONTH")) {
#line 274 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_MONTH;
#line 274 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1151 "tracker-sparql-scanner.c"
					}
#line 275 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1155 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 1161 "tracker-sparql-scanner.c"
				{
#line 278 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "NAMED")) {
#line 278 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NAMED;
#line 278 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1169 "tracker-sparql-scanner.c"
					}
#line 279 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1173 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 1179 "tracker-sparql-scanner.c"
				{
#line 282 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "ORDER")) {
#line 282 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ORDER;
#line 282 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1187 "tracker-sparql-scanner.c"
					}
#line 283 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1191 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 1197 "tracker-sparql-scanner.c"
				{
					gchar _tmp15_;
#line 286 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp15_ = begin[1];
#line 286 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp15_) {
#line 286 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 286 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 1208 "tracker-sparql-scanner.c"
						{
#line 289 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "REGEX")) {
#line 289 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REGEX;
#line 289 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1216 "tracker-sparql-scanner.c"
							}
#line 290 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1220 "tracker-sparql-scanner.c"
						}
#line 286 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'O':
#line 286 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'o':
#line 1226 "tracker-sparql-scanner.c"
						{
#line 293 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "ROUND")) {
#line 293 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_ROUND;
#line 293 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1234 "tracker-sparql-scanner.c"
							}
#line 294 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1238 "tracker-sparql-scanner.c"
						}
						default:
#line 286 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1243 "tracker-sparql-scanner.c"
					}
#line 296 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1247 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'U':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'u':
#line 1253 "tracker-sparql-scanner.c"
				{
					gchar _tmp16_;
#line 299 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp16_ = begin[1];
#line 299 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp16_) {
#line 299 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 299 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 1264 "tracker-sparql-scanner.c"
						{
#line 302 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "UNION")) {
#line 302 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_UNION;
#line 302 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1272 "tracker-sparql-scanner.c"
							}
#line 303 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1276 "tracker-sparql-scanner.c"
						}
#line 299 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'C':
#line 299 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'c':
#line 1282 "tracker-sparql-scanner.c"
						{
#line 306 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "UCASE")) {
#line 306 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_UCASE;
#line 306 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1290 "tracker-sparql-scanner.c"
							}
#line 307 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1294 "tracker-sparql-scanner.c"
						}
						default:
#line 299 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1299 "tracker-sparql-scanner.c"
					}
#line 309 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1303 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'W':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'w':
#line 1309 "tracker-sparql-scanner.c"
				{
#line 312 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "WHERE")) {
#line 312 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WHERE;
#line 312 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1317 "tracker-sparql-scanner.c"
					}
#line 313 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1321 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 1327 "tracker-sparql-scanner.c"
				{
					gchar _tmp17_;
#line 316 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp17_ = begin[1];
#line 316 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp17_) {
#line 316 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 316 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 1338 "tracker-sparql-scanner.c"
						{
#line 319 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "FALSE")) {
#line 319 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_FALSE;
#line 319 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1346 "tracker-sparql-scanner.c"
							}
#line 320 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1350 "tracker-sparql-scanner.c"
						}
#line 316 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'L':
#line 316 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'l':
#line 1356 "tracker-sparql-scanner.c"
						{
#line 323 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "FLOOR")) {
#line 323 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_FLOOR;
#line 323 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1364 "tracker-sparql-scanner.c"
							}
#line 324 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1368 "tracker-sparql-scanner.c"
						}
						default:
#line 316 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1373 "tracker-sparql-scanner.c"
					}
#line 326 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1377 "tracker-sparql-scanner.c"
				}
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1383 "tracker-sparql-scanner.c"
				{
					gchar _tmp18_;
#line 329 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp18_ = begin[1];
#line 329 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp18_) {
#line 329 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 329 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 1394 "tracker-sparql-scanner.c"
						{
							gchar _tmp19_;
#line 332 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp19_ = begin[2];
#line 332 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp19_) {
#line 332 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'I':
#line 332 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'i':
#line 1405 "tracker-sparql-scanner.c"
								{
#line 335 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ISIRI")) {
#line 335 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISIRI;
#line 335 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1413 "tracker-sparql-scanner.c"
									}
#line 336 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1417 "tracker-sparql-scanner.c"
								}
#line 332 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'U':
#line 332 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'u':
#line 1423 "tracker-sparql-scanner.c"
								{
#line 339 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ISURI")) {
#line 339 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISURI;
#line 339 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1431 "tracker-sparql-scanner.c"
									}
#line 340 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1435 "tracker-sparql-scanner.c"
								}
								default:
#line 332 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 1440 "tracker-sparql-scanner.c"
							}
#line 342 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1444 "tracker-sparql-scanner.c"
						}
						default:
#line 329 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1449 "tracker-sparql-scanner.c"
					}
#line 344 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1453 "tracker-sparql-scanner.c"
				}
				default:
#line 233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1458 "tracker-sparql-scanner.c"
			}
#line 346 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1462 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 6:
#line 1466 "tracker-sparql-scanner.c"
		{
			gchar _tmp20_;
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp20_ = begin[0];
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp20_) {
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 1477 "tracker-sparql-scanner.c"
				{
#line 351 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "CONCAT")) {
#line 351 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CONCAT;
#line 351 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1485 "tracker-sparql-scanner.c"
					}
#line 352 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1489 "tracker-sparql-scanner.c"
				}
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 1495 "tracker-sparql-scanner.c"
				{
#line 355 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "DELETE")) {
#line 355 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_DELETE;
#line 355 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1503 "tracker-sparql-scanner.c"
					}
#line 356 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1507 "tracker-sparql-scanner.c"
				}
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'E':
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'e':
#line 1513 "tracker-sparql-scanner.c"
				{
#line 359 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "EXISTS")) {
#line 359 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_EXISTS;
#line 359 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1521 "tracker-sparql-scanner.c"
					}
#line 360 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1525 "tracker-sparql-scanner.c"
				}
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 1531 "tracker-sparql-scanner.c"
				{
#line 363 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "FILTER")) {
#line 363 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FILTER;
#line 363 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1539 "tracker-sparql-scanner.c"
					}
#line 364 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1543 "tracker-sparql-scanner.c"
				}
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'H':
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'h':
#line 1549 "tracker-sparql-scanner.c"
				{
#line 367 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "HAVING")) {
#line 367 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_HAVING;
#line 367 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1557 "tracker-sparql-scanner.c"
					}
#line 368 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1561 "tracker-sparql-scanner.c"
				}
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1567 "tracker-sparql-scanner.c"
				{
#line 371 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "INSERT")) {
#line 371 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INSERT;
#line 371 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1575 "tracker-sparql-scanner.c"
					}
#line 372 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1579 "tracker-sparql-scanner.c"
				}
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 1585 "tracker-sparql-scanner.c"
				{
#line 375 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "OFFSET")) {
#line 375 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 375 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1593 "tracker-sparql-scanner.c"
					}
#line 376 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1597 "tracker-sparql-scanner.c"
				}
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'P':
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'p':
#line 1603 "tracker-sparql-scanner.c"
				{
#line 379 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "PREFIX")) {
#line 379 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_PREFIX;
#line 379 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1611 "tracker-sparql-scanner.c"
					}
#line 380 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1615 "tracker-sparql-scanner.c"
				}
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 1621 "tracker-sparql-scanner.c"
				{
					gchar _tmp21_;
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp21_ = begin[1];
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp21_) {
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 1632 "tracker-sparql-scanner.c"
						{
#line 386 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SELECT")) {
#line 386 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SELECT;
#line 386 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1640 "tracker-sparql-scanner.c"
							}
#line 387 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1644 "tracker-sparql-scanner.c"
						}
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 1650 "tracker-sparql-scanner.c"
						{
#line 390 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SILENT")) {
#line 390 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SILENT;
#line 390 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1658 "tracker-sparql-scanner.c"
							}
#line 391 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1662 "tracker-sparql-scanner.c"
						}
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 1668 "tracker-sparql-scanner.c"
						{
#line 394 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRLEN")) {
#line 394 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRLEN;
#line 394 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1676 "tracker-sparql-scanner.c"
							}
#line 395 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1680 "tracker-sparql-scanner.c"
						}
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'U':
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'u':
#line 1686 "tracker-sparql-scanner.c"
						{
#line 398 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SUBSTR")) {
#line 398 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SUBSTR;
#line 398 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1694 "tracker-sparql-scanner.c"
							}
#line 399 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1698 "tracker-sparql-scanner.c"
						}
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'H':
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'h':
#line 1704 "tracker-sparql-scanner.c"
						{
							gchar _tmp22_;
#line 402 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp22_ = begin[3];
#line 402 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp22_) {
#line 402 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '2':
#line 1713 "tracker-sparql-scanner.c"
								{
#line 404 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "SHA256")) {
#line 404 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_SHA256;
#line 404 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1721 "tracker-sparql-scanner.c"
									}
#line 405 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1725 "tracker-sparql-scanner.c"
								}
#line 402 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '5':
#line 1729 "tracker-sparql-scanner.c"
								{
#line 407 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "SHA512")) {
#line 407 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_SHA512;
#line 407 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1737 "tracker-sparql-scanner.c"
									}
#line 408 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1741 "tracker-sparql-scanner.c"
								}
								default:
#line 402 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 1746 "tracker-sparql-scanner.c"
							}
#line 410 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1750 "tracker-sparql-scanner.c"
						}
						default:
#line 383 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1755 "tracker-sparql-scanner.c"
					}
#line 412 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1759 "tracker-sparql-scanner.c"
				}
				default:
#line 348 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1764 "tracker-sparql-scanner.c"
			}
#line 414 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1768 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 7:
#line 1772 "tracker-sparql-scanner.c"
		{
			gchar _tmp23_;
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp23_ = begin[0];
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp23_) {
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 1783 "tracker-sparql-scanner.c"
				{
#line 419 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "MINUTES")) {
#line 419 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_MINUTES;
#line 419 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1791 "tracker-sparql-scanner.c"
					}
#line 420 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1795 "tracker-sparql-scanner.c"
				}
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 1801 "tracker-sparql-scanner.c"
				{
					gchar _tmp24_;
#line 423 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp24_ = begin[2];
#line 423 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp24_) {
#line 423 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'D':
#line 423 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'd':
#line 1812 "tracker-sparql-scanner.c"
						{
#line 426 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "REDUCED")) {
#line 426 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REDUCED;
#line 426 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1820 "tracker-sparql-scanner.c"
							}
#line 427 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1824 "tracker-sparql-scanner.c"
						}
#line 423 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'P':
#line 423 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'p':
#line 1830 "tracker-sparql-scanner.c"
						{
#line 430 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "REPLACE")) {
#line 430 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REPLACE;
#line 430 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1838 "tracker-sparql-scanner.c"
							}
#line 431 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1842 "tracker-sparql-scanner.c"
						}
						default:
#line 423 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1847 "tracker-sparql-scanner.c"
					}
#line 433 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1851 "tracker-sparql-scanner.c"
				}
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 1857 "tracker-sparql-scanner.c"
				{
					gchar _tmp25_;
#line 436 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp25_ = begin[1];
#line 436 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp25_) {
#line 436 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 436 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 1868 "tracker-sparql-scanner.c"
						{
#line 439 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SECONDS")) {
#line 439 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SECONDS;
#line 439 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1876 "tracker-sparql-scanner.c"
							}
#line 440 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1880 "tracker-sparql-scanner.c"
						}
#line 436 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 436 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 1886 "tracker-sparql-scanner.c"
						{
#line 443 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRENDS")) {
#line 443 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRENDS;
#line 443 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1894 "tracker-sparql-scanner.c"
							}
#line 444 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1898 "tracker-sparql-scanner.c"
						}
						default:
#line 436 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1903 "tracker-sparql-scanner.c"
					}
#line 446 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1907 "tracker-sparql-scanner.c"
				}
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1913 "tracker-sparql-scanner.c"
				{
#line 449 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "ISBLANK")) {
#line 449 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISBLANK;
#line 449 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1921 "tracker-sparql-scanner.c"
					}
#line 450 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1925 "tracker-sparql-scanner.c"
				}
				default:
#line 416 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1930 "tracker-sparql-scanner.c"
			}
#line 452 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1934 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 8:
#line 1938 "tracker-sparql-scanner.c"
		{
			gchar _tmp26_;
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp26_ = begin[0];
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp26_) {
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 1949 "tracker-sparql-scanner.c"
				{
					gchar _tmp27_;
#line 457 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp27_ = begin[2];
#line 457 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp27_) {
#line 457 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 457 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 1960 "tracker-sparql-scanner.c"
						{
#line 460 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "COALESCE")) {
#line 460 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_COALESCE;
#line 460 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1968 "tracker-sparql-scanner.c"
							}
#line 461 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1972 "tracker-sparql-scanner.c"
						}
#line 457 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 457 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 1978 "tracker-sparql-scanner.c"
						{
#line 464 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "CONTAINS")) {
#line 464 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_CONTAINS;
#line 464 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1986 "tracker-sparql-scanner.c"
							}
#line 465 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1990 "tracker-sparql-scanner.c"
						}
						default:
#line 457 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1995 "tracker-sparql-scanner.c"
					}
#line 467 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1999 "tracker-sparql-scanner.c"
				}
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 2005 "tracker-sparql-scanner.c"
				{
					gchar _tmp28_;
#line 470 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp28_ = begin[1];
#line 470 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp28_) {
#line 470 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 470 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 2016 "tracker-sparql-scanner.c"
						{
#line 473 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DATATYPE")) {
#line 473 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATATYPE;
#line 473 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2024 "tracker-sparql-scanner.c"
							}
#line 474 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2028 "tracker-sparql-scanner.c"
						}
#line 470 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 470 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 2034 "tracker-sparql-scanner.c"
						{
#line 477 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DESCRIBE")) {
#line 477 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE;
#line 477 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2042 "tracker-sparql-scanner.c"
							}
#line 478 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2046 "tracker-sparql-scanner.c"
						}
#line 470 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 470 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 2052 "tracker-sparql-scanner.c"
						{
#line 481 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DISTINCT")) {
#line 481 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DISTINCT;
#line 481 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2060 "tracker-sparql-scanner.c"
							}
#line 482 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2064 "tracker-sparql-scanner.c"
						}
						default:
#line 470 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2069 "tracker-sparql-scanner.c"
					}
#line 484 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2073 "tracker-sparql-scanner.c"
				}
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 2079 "tracker-sparql-scanner.c"
				{
#line 487 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "OPTIONAL")) {
#line 487 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL;
#line 487 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2087 "tracker-sparql-scanner.c"
					}
#line 488 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2091 "tracker-sparql-scanner.c"
				}
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 2097 "tracker-sparql-scanner.c"
				{
					gchar _tmp29_;
#line 491 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp29_ = begin[1];
#line 491 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp29_) {
#line 491 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 491 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 2108 "tracker-sparql-scanner.c"
						{
#line 494 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SAMETERM")) {
#line 494 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SAMETERM;
#line 494 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2116 "tracker-sparql-scanner.c"
							}
#line 495 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2120 "tracker-sparql-scanner.c"
						}
#line 491 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 491 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 2126 "tracker-sparql-scanner.c"
						{
#line 498 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRAFTER")) {
#line 498 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRAFTER;
#line 498 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2134 "tracker-sparql-scanner.c"
							}
#line 499 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2138 "tracker-sparql-scanner.c"
						}
						default:
#line 491 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2143 "tracker-sparql-scanner.c"
					}
#line 501 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2147 "tracker-sparql-scanner.c"
				}
				default:
#line 454 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2152 "tracker-sparql-scanner.c"
			}
#line 503 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2156 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 9:
#line 2160 "tracker-sparql-scanner.c"
		{
			gchar _tmp30_;
#line 505 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp30_ = begin[0];
#line 505 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp30_) {
#line 505 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 505 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 2171 "tracker-sparql-scanner.c"
				{
#line 508 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "CONSTRUCT")) {
#line 508 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT;
#line 508 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2179 "tracker-sparql-scanner.c"
					}
#line 509 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2183 "tracker-sparql-scanner.c"
				}
#line 505 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 505 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 2189 "tracker-sparql-scanner.c"
				{
#line 512 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "ISLITERAL")) {
#line 512 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL;
#line 512 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2197 "tracker-sparql-scanner.c"
					}
#line 513 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2201 "tracker-sparql-scanner.c"
				}
#line 505 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 505 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 2207 "tracker-sparql-scanner.c"
				{
					gchar _tmp31_;
#line 516 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp31_ = begin[3];
#line 516 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp31_) {
#line 516 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'B':
#line 516 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'b':
#line 2218 "tracker-sparql-scanner.c"
						{
#line 519 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRBEFORE")) {
#line 519 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE;
#line 519 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2226 "tracker-sparql-scanner.c"
							}
#line 520 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2230 "tracker-sparql-scanner.c"
						}
#line 516 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 516 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 2236 "tracker-sparql-scanner.c"
						{
#line 523 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRSTARTS")) {
#line 523 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS;
#line 523 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2244 "tracker-sparql-scanner.c"
							}
#line 524 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2248 "tracker-sparql-scanner.c"
						}
						default:
#line 516 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2253 "tracker-sparql-scanner.c"
					}
#line 526 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2257 "tracker-sparql-scanner.c"
				}
				default:
#line 505 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2262 "tracker-sparql-scanner.c"
			}
#line 528 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2266 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 11:
#line 2270 "tracker-sparql-scanner.c"
		{
#line 530 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (tracker_sparql_scanner_matches (self, begin, "LANGMATCHES")) {
#line 530 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES;
#line 530 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2278 "tracker-sparql-scanner.c"
			}
#line 531 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2282 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 12:
#line 2286 "tracker-sparql-scanner.c"
		{
#line 533 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (tracker_sparql_scanner_matches (self, begin, "GROUP_CONCAT")) {
#line 533 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT;
#line 533 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2294 "tracker-sparql-scanner.c"
			}
#line 534 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2298 "tracker-sparql-scanner.c"
		}
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 14:
#line 2302 "tracker-sparql-scanner.c"
		{
#line 536 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (tracker_sparql_scanner_matches (self, begin, "ENCODE_FOR_URI")) {
#line 536 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI;
#line 536 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2310 "tracker-sparql-scanner.c"
			}
#line 537 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2314 "tracker-sparql-scanner.c"
		}
		default:
#line 44 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		break;
#line 2319 "tracker-sparql-scanner.c"
	}
#line 539 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
#line 539 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2325 "tracker-sparql-scanner.c"
}

static TrackerSparqlTokenType
tracker_sparql_scanner_read_number (TrackerSparqlScanner* self)
{
	TrackerSparqlTokenType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp39_ = FALSE;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	TrackerSparqlTokenType result;
#line 542 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 543 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	type = TRACKER_SPARQL_TOKEN_TYPE_INTEGER;
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->current;
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = self->priv->end;
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp3_ < (_tmp4_ - 2)) {
#line 2357 "tracker-sparql-scanner.c"
		gchar* _tmp5_;
		gchar _tmp6_;
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = self->priv->current;
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = _tmp5_[0];
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = _tmp6_ == '0';
#line 2366 "tracker-sparql-scanner.c"
	} else {
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = FALSE;
#line 2370 "tracker-sparql-scanner.c"
	}
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 2374 "tracker-sparql-scanner.c"
		gchar* _tmp7_;
		gchar _tmp8_;
#line 547 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->current;
#line 547 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = _tmp7_[1];
#line 547 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = _tmp8_ == 'x';
#line 2383 "tracker-sparql-scanner.c"
	} else {
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = FALSE;
#line 2387 "tracker-sparql-scanner.c"
	}
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 2391 "tracker-sparql-scanner.c"
		gchar* _tmp9_;
		gchar _tmp10_;
#line 547 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp9_ = self->priv->current;
#line 547 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp10_ = _tmp9_[2];
#line 547 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = g_ascii_isxdigit (_tmp10_);
#line 2400 "tracker-sparql-scanner.c"
	} else {
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = FALSE;
#line 2404 "tracker-sparql-scanner.c"
	}
#line 546 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp0_) {
#line 2408 "tracker-sparql-scanner.c"
		gchar* _tmp11_;
#line 549 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp11_ = self->priv->current;
#line 549 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp11_ + 2;
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2416 "tracker-sparql-scanner.c"
			gboolean _tmp12_ = FALSE;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp17_;
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp13_ = self->priv->current;
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp14_ = self->priv->end;
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp13_ < _tmp14_) {
#line 2427 "tracker-sparql-scanner.c"
				gchar* _tmp15_;
				gchar _tmp16_;
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp15_ = self->priv->current;
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp16_ = _tmp15_[0];
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp12_ = g_ascii_isxdigit (_tmp16_);
#line 2436 "tracker-sparql-scanner.c"
			} else {
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp12_ = FALSE;
#line 2440 "tracker-sparql-scanner.c"
			}
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp12_) {
#line 550 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2446 "tracker-sparql-scanner.c"
			}
#line 551 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp17_ = self->priv->current;
#line 551 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp17_ + 1;
#line 2452 "tracker-sparql-scanner.c"
		}
	} else {
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2457 "tracker-sparql-scanner.c"
			gboolean _tmp18_ = FALSE;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp23_;
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp19_ = self->priv->current;
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp20_ = self->priv->end;
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp19_ < _tmp20_) {
#line 2468 "tracker-sparql-scanner.c"
				gchar* _tmp21_;
				gchar _tmp22_;
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp21_ = self->priv->current;
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp22_ = _tmp21_[0];
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp18_ = g_ascii_isdigit (_tmp22_);
#line 2477 "tracker-sparql-scanner.c"
			} else {
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp18_ = FALSE;
#line 2481 "tracker-sparql-scanner.c"
			}
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp18_) {
#line 555 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2487 "tracker-sparql-scanner.c"
			}
#line 556 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp23_ = self->priv->current;
#line 556 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp23_ + 1;
#line 2493 "tracker-sparql-scanner.c"
		}
	}
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp26_ = self->priv->current;
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp27_ = self->priv->end;
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp26_ < (_tmp27_ - 1)) {
#line 2502 "tracker-sparql-scanner.c"
		gchar* _tmp28_;
		gchar _tmp29_;
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp28_ = self->priv->current;
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp29_ = _tmp28_[0];
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp25_ = _tmp29_ == '.';
#line 2511 "tracker-sparql-scanner.c"
	} else {
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp25_ = FALSE;
#line 2515 "tracker-sparql-scanner.c"
	}
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp25_) {
#line 2519 "tracker-sparql-scanner.c"
		gchar* _tmp30_;
		gchar _tmp31_;
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp30_ = self->priv->current;
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp31_ = _tmp30_[1];
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp24_ = g_ascii_isdigit (_tmp31_);
#line 2528 "tracker-sparql-scanner.c"
	} else {
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp24_ = FALSE;
#line 2532 "tracker-sparql-scanner.c"
	}
#line 561 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp24_) {
#line 2536 "tracker-sparql-scanner.c"
		gchar* _tmp32_;
#line 562 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 563 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp32_ = self->priv->current;
#line 563 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp32_ + 1;
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2546 "tracker-sparql-scanner.c"
			gboolean _tmp33_ = FALSE;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp38_;
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp34_ = self->priv->current;
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp35_ = self->priv->end;
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp34_ < _tmp35_) {
#line 2557 "tracker-sparql-scanner.c"
				gchar* _tmp36_;
				gchar _tmp37_;
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp36_ = self->priv->current;
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp37_ = _tmp36_[0];
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp33_ = g_ascii_isdigit (_tmp37_);
#line 2566 "tracker-sparql-scanner.c"
			} else {
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp33_ = FALSE;
#line 2570 "tracker-sparql-scanner.c"
			}
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp33_) {
#line 564 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2576 "tracker-sparql-scanner.c"
			}
#line 565 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp38_ = self->priv->current;
#line 565 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp38_ + 1;
#line 2582 "tracker-sparql-scanner.c"
		}
	}
#line 570 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp40_ = self->priv->current;
#line 570 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp41_ = self->priv->end;
#line 570 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp40_ < _tmp41_) {
#line 2591 "tracker-sparql-scanner.c"
		gchar* _tmp42_;
		gchar _tmp43_;
#line 570 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp42_ = self->priv->current;
#line 570 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp43_ = _tmp42_[0];
#line 570 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp39_ = g_ascii_tolower (_tmp43_) == 'e';
#line 2600 "tracker-sparql-scanner.c"
	} else {
#line 570 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp39_ = FALSE;
#line 2604 "tracker-sparql-scanner.c"
	}
#line 570 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp39_) {
#line 2608 "tracker-sparql-scanner.c"
		gchar* _tmp44_;
		gboolean _tmp45_ = FALSE;
		gchar* _tmp46_;
		gchar* _tmp47_;
#line 571 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 572 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp44_ = self->priv->current;
#line 572 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp44_ + 1;
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp46_ = self->priv->current;
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp47_ = self->priv->end;
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp46_ < _tmp47_) {
#line 2625 "tracker-sparql-scanner.c"
			gboolean _tmp48_ = FALSE;
			gchar* _tmp49_;
			gchar _tmp50_;
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp49_ = self->priv->current;
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp50_ = _tmp49_[0];
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp50_ == '+') {
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp48_ = TRUE;
#line 2637 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp51_;
				gchar _tmp52_;
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp51_ = self->priv->current;
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp52_ = _tmp51_[0];
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp48_ = _tmp52_ == '-';
#line 2647 "tracker-sparql-scanner.c"
			}
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp45_ = _tmp48_;
#line 2651 "tracker-sparql-scanner.c"
		} else {
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp45_ = FALSE;
#line 2655 "tracker-sparql-scanner.c"
		}
#line 573 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp45_) {
#line 2659 "tracker-sparql-scanner.c"
			gchar* _tmp53_;
#line 574 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp53_ = self->priv->current;
#line 574 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp53_ + 1;
#line 2665 "tracker-sparql-scanner.c"
		}
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2669 "tracker-sparql-scanner.c"
			gboolean _tmp54_ = FALSE;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp59_;
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp55_ = self->priv->current;
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp56_ = self->priv->end;
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp55_ < _tmp56_) {
#line 2680 "tracker-sparql-scanner.c"
				gchar* _tmp57_;
				gchar _tmp58_;
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp57_ = self->priv->current;
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp58_ = _tmp57_[0];
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp54_ = g_ascii_isdigit (_tmp58_);
#line 2689 "tracker-sparql-scanner.c"
			} else {
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp54_ = FALSE;
#line 2693 "tracker-sparql-scanner.c"
			}
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp54_) {
#line 576 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2699 "tracker-sparql-scanner.c"
			}
#line 577 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp59_ = self->priv->current;
#line 577 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp59_ + 1;
#line 2705 "tracker-sparql-scanner.c"
		}
	}
#line 582 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp60_ = self->priv->current;
#line 582 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp61_ = self->priv->end;
#line 582 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp60_ < _tmp61_) {
#line 2714 "tracker-sparql-scanner.c"
		gchar* _tmp62_;
		gchar _tmp63_;
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp62_ = self->priv->current;
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp63_ = _tmp62_[0];
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		switch (_tmp63_) {
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'l':
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'L':
#line 2727 "tracker-sparql-scanner.c"
			{
#line 586 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (type == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 2731 "tracker-sparql-scanner.c"
					gchar* _tmp64_;
					gboolean _tmp65_ = FALSE;
					gchar* _tmp66_;
					gchar* _tmp67_;
#line 587 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp64_ = self->priv->current;
#line 587 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					self->priv->current = _tmp64_ + 1;
#line 588 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp66_ = self->priv->current;
#line 588 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp67_ = self->priv->end;
#line 588 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp66_ < _tmp67_) {
#line 2746 "tracker-sparql-scanner.c"
						gchar* _tmp68_;
						gchar _tmp69_;
#line 588 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp68_ = self->priv->current;
#line 588 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp69_ = _tmp68_[0];
#line 588 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp65_ = g_ascii_tolower (_tmp69_) == 'l';
#line 2755 "tracker-sparql-scanner.c"
					} else {
#line 588 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp65_ = FALSE;
#line 2759 "tracker-sparql-scanner.c"
					}
#line 588 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp65_) {
#line 2763 "tracker-sparql-scanner.c"
						gchar* _tmp70_;
#line 589 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp70_ = self->priv->current;
#line 589 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp70_ + 1;
#line 2769 "tracker-sparql-scanner.c"
					}
				}
#line 592 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2774 "tracker-sparql-scanner.c"
			}
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'u':
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'U':
#line 2780 "tracker-sparql-scanner.c"
			{
#line 595 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (type == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 2784 "tracker-sparql-scanner.c"
					gchar* _tmp71_;
					gboolean _tmp72_ = FALSE;
					gchar* _tmp73_;
					gchar* _tmp74_;
#line 596 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp71_ = self->priv->current;
#line 596 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					self->priv->current = _tmp71_ + 1;
#line 597 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp73_ = self->priv->current;
#line 597 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp74_ = self->priv->end;
#line 597 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp73_ < _tmp74_) {
#line 2799 "tracker-sparql-scanner.c"
						gchar* _tmp75_;
						gchar _tmp76_;
#line 597 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp75_ = self->priv->current;
#line 597 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp76_ = _tmp75_[0];
#line 597 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp72_ = g_ascii_tolower (_tmp76_) == 'l';
#line 2808 "tracker-sparql-scanner.c"
					} else {
#line 597 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp72_ = FALSE;
#line 2812 "tracker-sparql-scanner.c"
					}
#line 597 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp72_) {
#line 2816 "tracker-sparql-scanner.c"
						gchar* _tmp77_;
						gboolean _tmp78_ = FALSE;
						gchar* _tmp79_;
						gchar* _tmp80_;
#line 598 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp77_ = self->priv->current;
#line 598 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp77_ + 1;
#line 599 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp79_ = self->priv->current;
#line 599 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp80_ = self->priv->end;
#line 599 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp79_ < _tmp80_) {
#line 2831 "tracker-sparql-scanner.c"
							gchar* _tmp81_;
							gchar _tmp82_;
#line 599 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp81_ = self->priv->current;
#line 599 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp82_ = _tmp81_[0];
#line 599 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp78_ = g_ascii_tolower (_tmp82_) == 'l';
#line 2840 "tracker-sparql-scanner.c"
						} else {
#line 599 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp78_ = FALSE;
#line 2844 "tracker-sparql-scanner.c"
						}
#line 599 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp78_) {
#line 2848 "tracker-sparql-scanner.c"
							gchar* _tmp83_;
#line 600 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp83_ = self->priv->current;
#line 600 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp83_ + 1;
#line 2854 "tracker-sparql-scanner.c"
						}
					}
				}
#line 604 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2860 "tracker-sparql-scanner.c"
			}
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'f':
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'F':
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'd':
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'D':
#line 2870 "tracker-sparql-scanner.c"
			{
				gchar* _tmp84_;
#line 609 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 610 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp84_ = self->priv->current;
#line 610 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				self->priv->current = _tmp84_ + 1;
#line 611 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2881 "tracker-sparql-scanner.c"
			}
			default:
#line 583 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2886 "tracker-sparql-scanner.c"
		}
	}
#line 615 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = type;
#line 615 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2893 "tracker-sparql-scanner.c"
}

static gboolean
tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self,
                                   gchar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
#line 618 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 619 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (g_ascii_isalnum (c)) {
#line 619 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 2909 "tracker-sparql-scanner.c"
	} else {
#line 619 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = c == '_';
#line 2913 "tracker-sparql-scanner.c"
	}
#line 619 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 619 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 2919 "tracker-sparql-scanner.c"
	} else {
#line 619 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = c == '-';
#line 2923 "tracker-sparql-scanner.c"
	}
#line 619 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 619 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2929 "tracker-sparql-scanner.c"
}

static gboolean
tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self,
                                         gchar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
#line 622 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (g_ascii_isalnum (c)) {
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = TRUE;
#line 2946 "tracker-sparql-scanner.c"
	} else {
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = c == '_';
#line 2950 "tracker-sparql-scanner.c"
	}
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 2956 "tracker-sparql-scanner.c"
	} else {
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = c == '-';
#line 2960 "tracker-sparql-scanner.c"
	}
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 2966 "tracker-sparql-scanner.c"
	} else {
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = c == '.';
#line 2970 "tracker-sparql-scanner.c"
	}
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 623 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2976 "tracker-sparql-scanner.c"
}

static gboolean
tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self,
                                        gchar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 626 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 627 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (g_ascii_isalnum (c)) {
#line 627 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 2991 "tracker-sparql-scanner.c"
	} else {
#line 627 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = c == '_';
#line 2995 "tracker-sparql-scanner.c"
	}
#line 627 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 627 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 3001 "tracker-sparql-scanner.c"
}

TrackerSparqlTokenType
tracker_sparql_scanner_read_token (TrackerSparqlScanner* self,
                                   TrackerSourceLocation* token_begin,
                                   TrackerSourceLocation* token_end,
                                   GError** error)
{
	TrackerSourceLocation _vala_token_begin = {0};
	TrackerSourceLocation _vala_token_end = {0};
	TrackerSparqlTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint token_length_in_chars = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp250_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlTokenType result;
#line 630 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 631 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_sparql_scanner_space (self);
#line 634 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = self->priv->current;
#line 634 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	begin = _tmp0_;
#line 635 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = begin;
#line 635 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
#line 637 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	token_length_in_chars = -1;
#line 639 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->current;
#line 639 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->end;
#line 639 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp2_ >= _tmp3_) {
#line 640 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3044 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
#line 641 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp4_ = self->priv->current;
#line 641 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = _tmp4_[0];
#line 641 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (g_ascii_isalpha (_tmp5_)) {
#line 3054 "tracker-sparql-scanner.c"
			gint len = 0;
			gchar* _tmp13_;
#line 643 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			len = 0;
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			while (TRUE) {
#line 3061 "tracker-sparql-scanner.c"
				gboolean _tmp6_ = FALSE;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp11_;
				gint _tmp12_;
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp7_ = self->priv->current;
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp8_ = self->priv->end;
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp7_ < _tmp8_) {
#line 3073 "tracker-sparql-scanner.c"
					gchar* _tmp9_;
					gchar _tmp10_;
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp9_ = self->priv->current;
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp10_ = _tmp9_[0];
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp6_ = tracker_sparql_scanner_is_pn_char (self, _tmp10_);
#line 3082 "tracker-sparql-scanner.c"
				} else {
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp6_ = FALSE;
#line 3086 "tracker-sparql-scanner.c"
				}
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!_tmp6_) {
#line 644 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 3092 "tracker-sparql-scanner.c"
				}
#line 645 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp11_ = self->priv->current;
#line 645 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				self->priv->current = _tmp11_ + 1;
#line 646 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp12_ = len;
#line 646 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				len = _tmp12_ + 1;
#line 3102 "tracker-sparql-scanner.c"
			}
#line 648 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp13_ = begin;
#line 648 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			type = tracker_sparql_scanner_get_identifier_or_keyword (self, _tmp13_, len);
#line 3108 "tracker-sparql-scanner.c"
		} else {
			gchar* _tmp14_;
			gchar _tmp15_;
#line 649 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp14_ = self->priv->current;
#line 649 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp15_ = _tmp14_[0];
#line 649 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (g_ascii_isdigit (_tmp15_)) {
#line 650 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				type = tracker_sparql_scanner_read_number (self);
#line 3120 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp16_;
				gchar _tmp17_;
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp16_ = self->priv->current;
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp17_ = _tmp16_[0];
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				switch (_tmp17_) {
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '{':
#line 3132 "tracker-sparql-scanner.c"
					{
						gchar* _tmp18_;
#line 654 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE;
#line 655 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp18_ = self->priv->current;
#line 655 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp18_ + 1;
#line 656 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3143 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '}':
#line 3147 "tracker-sparql-scanner.c"
					{
						gchar* _tmp19_;
#line 658 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 659 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp19_ = self->priv->current;
#line 659 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp19_ + 1;
#line 660 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3158 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '(':
#line 3162 "tracker-sparql-scanner.c"
					{
						gchar* _tmp20_;
#line 662 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS;
#line 663 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp20_ = self->priv->current;
#line 663 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp20_ + 1;
#line 664 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3173 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ')':
#line 3177 "tracker-sparql-scanner.c"
					{
						gchar* _tmp21_;
#line 666 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 667 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp21_ = self->priv->current;
#line 667 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp21_ + 1;
#line 668 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3188 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '[':
#line 3192 "tracker-sparql-scanner.c"
					{
						gchar* _tmp22_;
#line 670 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
#line 671 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp22_ = self->priv->current;
#line 671 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp22_ + 1;
#line 672 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3203 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ']':
#line 3207 "tracker-sparql-scanner.c"
					{
						gchar* _tmp23_;
#line 674 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET;
#line 675 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp23_ = self->priv->current;
#line 675 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp23_ + 1;
#line 676 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3218 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '.':
#line 3222 "tracker-sparql-scanner.c"
					{
						gchar* _tmp24_;
#line 678 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DOT;
#line 679 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp24_ = self->priv->current;
#line 679 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp24_ + 1;
#line 680 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3233 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ':':
#line 3237 "tracker-sparql-scanner.c"
					{
						gchar* _tmp25_;
						gchar* _tmp32_;
						gchar _tmp33_;
#line 682 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COLON;
#line 683 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp25_ = self->priv->current;
#line 683 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp25_ + 1;
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 3250 "tracker-sparql-scanner.c"
							gboolean _tmp26_ = FALSE;
							gchar* _tmp27_;
							gchar* _tmp28_;
							gchar* _tmp31_;
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp27_ = self->priv->current;
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp28_ = self->priv->end;
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp27_ < _tmp28_) {
#line 3261 "tracker-sparql-scanner.c"
								gchar* _tmp29_;
								gchar _tmp30_;
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp29_ = self->priv->current;
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp30_ = _tmp29_[0];
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp26_ = tracker_sparql_scanner_is_pn_local_char (self, _tmp30_);
#line 3270 "tracker-sparql-scanner.c"
							} else {
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp26_ = FALSE;
#line 3274 "tracker-sparql-scanner.c"
							}
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp26_) {
#line 684 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3280 "tracker-sparql-scanner.c"
							}
#line 685 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp31_ = self->priv->current;
#line 685 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp31_ + 1;
#line 3286 "tracker-sparql-scanner.c"
						}
#line 687 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp32_ = self->priv->current;
#line 687 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp33_ = _tmp32_[-1];
#line 687 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp33_ == '.') {
#line 3294 "tracker-sparql-scanner.c"
							gchar* _tmp34_;
#line 689 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp34_ = self->priv->current;
#line 689 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp34_ - 1;
#line 3300 "tracker-sparql-scanner.c"
						}
#line 691 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3304 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ',':
#line 3308 "tracker-sparql-scanner.c"
					{
						gchar* _tmp35_;
#line 693 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COMMA;
#line 694 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp35_ = self->priv->current;
#line 694 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp35_ + 1;
#line 695 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3319 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ';':
#line 3323 "tracker-sparql-scanner.c"
					{
						gchar* _tmp36_;
#line 697 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON;
#line 698 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp36_ = self->priv->current;
#line 698 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp36_ + 1;
#line 699 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3334 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '?':
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '$':
#line 3340 "tracker-sparql-scanner.c"
					{
						gchar* _tmp37_;
#line 702 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 703 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp37_ = self->priv->current;
#line 703 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp37_ + 1;
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 3351 "tracker-sparql-scanner.c"
							gboolean _tmp38_ = FALSE;
							gchar* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp43_;
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp39_ = self->priv->current;
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp40_ = self->priv->end;
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp39_ < _tmp40_) {
#line 3362 "tracker-sparql-scanner.c"
								gchar* _tmp41_;
								gchar _tmp42_;
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp41_ = self->priv->current;
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp42_ = _tmp41_[0];
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp38_ = tracker_sparql_scanner_is_varname_char (self, _tmp42_);
#line 3371 "tracker-sparql-scanner.c"
							} else {
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp38_ = FALSE;
#line 3375 "tracker-sparql-scanner.c"
							}
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp38_) {
#line 704 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3381 "tracker-sparql-scanner.c"
							}
#line 705 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_VAR;
#line 706 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp43_ = self->priv->current;
#line 706 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp43_ + 1;
#line 3389 "tracker-sparql-scanner.c"
						}
#line 708 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3393 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '@':
#line 3397 "tracker-sparql-scanner.c"
					{
						gchar* _tmp44_;
						gboolean _tmp45_ = FALSE;
						gchar* _tmp46_;
						gchar* _tmp47_;
						gint _tmp48_;
						gint _tmp49_;
#line 710 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 711 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp44_ = self->priv->current;
#line 711 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp44_ + 1;
#line 712 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp46_ = self->priv->current;
#line 712 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp47_ = self->priv->end;
#line 712 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp48_ = strlen ("prefix");
#line 712 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp49_ = _tmp48_;
#line 712 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp46_ < (_tmp47_ - _tmp49_)) {
#line 3421 "tracker-sparql-scanner.c"
							gchar* _tmp50_;
#line 712 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp50_ = self->priv->current;
#line 712 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp45_ = tracker_sparql_scanner_matches (self, _tmp50_, "PREFIX");
#line 3427 "tracker-sparql-scanner.c"
						} else {
#line 712 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp45_ = FALSE;
#line 3431 "tracker-sparql-scanner.c"
						}
#line 712 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp45_) {
#line 3435 "tracker-sparql-scanner.c"
							gchar* _tmp51_;
							gint _tmp52_;
							gint _tmp53_;
#line 713 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX;
#line 714 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp51_ = self->priv->current;
#line 714 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp52_ = strlen ("prefix");
#line 714 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp53_ = _tmp52_;
#line 714 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp51_ + _tmp53_;
#line 3449 "tracker-sparql-scanner.c"
						} else {
							gboolean _tmp54_ = FALSE;
							gchar* _tmp55_;
							gchar* _tmp56_;
							gint _tmp57_;
							gint _tmp58_;
#line 715 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp55_ = self->priv->current;
#line 715 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp56_ = self->priv->end;
#line 715 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp57_ = strlen ("base");
#line 715 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp58_ = _tmp57_;
#line 715 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp55_ < (_tmp56_ - _tmp58_)) {
#line 3466 "tracker-sparql-scanner.c"
								gchar* _tmp59_;
#line 715 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp59_ = self->priv->current;
#line 715 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp54_ = tracker_sparql_scanner_matches (self, _tmp59_, "BASE");
#line 3472 "tracker-sparql-scanner.c"
							} else {
#line 715 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp54_ = FALSE;
#line 3476 "tracker-sparql-scanner.c"
							}
#line 715 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp54_) {
#line 3480 "tracker-sparql-scanner.c"
								gchar* _tmp60_;
								gint _tmp61_;
								gint _tmp62_;
#line 716 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_ATBASE;
#line 717 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp60_ = self->priv->current;
#line 717 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp61_ = strlen ("base");
#line 717 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp62_ = _tmp61_;
#line 717 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp60_ + _tmp62_;
#line 3494 "tracker-sparql-scanner.c"
							}
						}
#line 719 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3499 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '|':
#line 3503 "tracker-sparql-scanner.c"
					{
						gchar* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
#line 721 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 722 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp63_ = self->priv->current;
#line 722 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp63_ + 1;
#line 723 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp64_ = self->priv->current;
#line 723 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp65_ = self->priv->end;
#line 723 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp64_ < _tmp65_) {
#line 3520 "tracker-sparql-scanner.c"
							gchar* _tmp66_;
							gchar _tmp67_;
#line 724 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp66_ = self->priv->current;
#line 724 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp67_ = _tmp66_[0];
#line 724 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp67_) {
#line 724 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '|':
#line 3531 "tracker-sparql-scanner.c"
								{
									gchar* _tmp68_;
#line 726 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_OR;
#line 727 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp68_ = self->priv->current;
#line 727 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp68_ + 1;
#line 728 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3542 "tracker-sparql-scanner.c"
								}
								default:
#line 724 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3547 "tracker-sparql-scanner.c"
							}
						}
#line 731 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3552 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '&':
#line 3556 "tracker-sparql-scanner.c"
					{
						gchar* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
#line 733 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 734 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp69_ = self->priv->current;
#line 734 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp69_ + 1;
#line 735 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp70_ = self->priv->current;
#line 735 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp71_ = self->priv->end;
#line 735 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp70_ < _tmp71_) {
#line 3573 "tracker-sparql-scanner.c"
							gchar* _tmp72_;
							gchar _tmp73_;
#line 736 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp72_ = self->priv->current;
#line 736 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp73_ = _tmp72_[0];
#line 736 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp73_) {
#line 736 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '&':
#line 3584 "tracker-sparql-scanner.c"
								{
									gchar* _tmp74_;
#line 738 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_AND;
#line 739 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp74_ = self->priv->current;
#line 739 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp74_ + 1;
#line 740 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3595 "tracker-sparql-scanner.c"
								}
								default:
#line 736 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3600 "tracker-sparql-scanner.c"
							}
						}
#line 743 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3605 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '=':
#line 3609 "tracker-sparql-scanner.c"
					{
						gchar* _tmp75_;
#line 745 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_EQ;
#line 746 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp75_ = self->priv->current;
#line 746 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp75_ + 1;
#line 747 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3620 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '<':
#line 3624 "tracker-sparql-scanner.c"
					{
						gchar* _tmp76_;
						gchar* _tmp77_;
						gchar* _tmp78_;
#line 749 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_LT;
#line 750 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp76_ = self->priv->current;
#line 750 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp76_ + 1;
#line 751 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp77_ = self->priv->current;
#line 751 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp78_ = self->priv->end;
#line 751 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp77_ < _tmp78_) {
#line 3641 "tracker-sparql-scanner.c"
							gboolean _tmp92_ = FALSE;
							gchar* _tmp93_;
							gchar* _tmp94_;
							gchar* _tmp99_;
							gchar _tmp100_;
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							while (TRUE) {
#line 3649 "tracker-sparql-scanner.c"
								gboolean _tmp79_ = FALSE;
								gchar* _tmp80_;
								gchar* _tmp81_;
								gboolean _tmp84_ = FALSE;
								gchar* _tmp85_;
								gchar _tmp86_;
								gchar* _tmp89_;
								gchar _tmp90_;
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp80_ = self->priv->current;
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp81_ = self->priv->end;
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp80_ < _tmp81_) {
#line 3664 "tracker-sparql-scanner.c"
									gchar* _tmp82_;
									gchar _tmp83_;
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp82_ = self->priv->current;
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp83_ = _tmp82_[0];
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp79_ = _tmp83_ != '>';
#line 3673 "tracker-sparql-scanner.c"
								} else {
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp79_ = FALSE;
#line 3677 "tracker-sparql-scanner.c"
								}
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (!_tmp79_) {
#line 753 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3683 "tracker-sparql-scanner.c"
								}
#line 754 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp85_ = self->priv->current;
#line 754 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp86_ = _tmp85_[0];
#line 754 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (((gint) _tmp86_) >= 0x00) {
#line 3691 "tracker-sparql-scanner.c"
									gchar* _tmp87_;
									gchar _tmp88_;
#line 754 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp87_ = self->priv->current;
#line 754 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp88_ = _tmp87_[0];
#line 754 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp84_ = ((gint) _tmp88_) < 0x20;
#line 3700 "tracker-sparql-scanner.c"
								} else {
#line 754 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp84_ = FALSE;
#line 3704 "tracker-sparql-scanner.c"
								}
#line 754 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp84_) {
#line 756 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3710 "tracker-sparql-scanner.c"
								}
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp89_ = self->priv->current;
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp90_ = _tmp89_[0];
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								switch (_tmp90_) {
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '<':
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '>':
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '"':
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case ' ':
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '{':
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '}':
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '|':
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '^':
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '`':
#line 758 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\\':
#line 3738 "tracker-sparql-scanner.c"
									{
#line 770 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 3742 "tracker-sparql-scanner.c"
									}
									default:
									{
										gchar* _tmp91_;
#line 772 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp91_ = self->priv->current;
#line 772 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp91_ + 1;
#line 773 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										continue;
#line 3753 "tracker-sparql-scanner.c"
									}
								}
#line 775 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3758 "tracker-sparql-scanner.c"
							}
#line 777 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp93_ = self->priv->current;
#line 777 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp94_ = self->priv->end;
#line 777 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp93_ < _tmp94_) {
#line 3766 "tracker-sparql-scanner.c"
								gchar* _tmp95_;
								gchar _tmp96_;
#line 777 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp95_ = self->priv->current;
#line 777 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp96_ = _tmp95_[0];
#line 777 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp92_ = _tmp96_ == '>';
#line 3775 "tracker-sparql-scanner.c"
							} else {
#line 777 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp92_ = FALSE;
#line 3779 "tracker-sparql-scanner.c"
							}
#line 777 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp92_) {
#line 3783 "tracker-sparql-scanner.c"
								gchar* _tmp97_;
#line 778 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
#line 779 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp97_ = self->priv->current;
#line 779 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp97_ + 1;
#line 780 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3793 "tracker-sparql-scanner.c"
							} else {
								gchar* _tmp98_;
#line 782 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp98_ = begin;
#line 782 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp98_ + 1;
#line 3800 "tracker-sparql-scanner.c"
							}
#line 784 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp99_ = self->priv->current;
#line 784 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp100_ = _tmp99_[0];
#line 784 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp100_) {
#line 784 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '=':
#line 3810 "tracker-sparql-scanner.c"
								{
									gchar* _tmp101_;
#line 786 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_LE;
#line 787 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp101_ = self->priv->current;
#line 787 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp101_ + 1;
#line 788 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3821 "tracker-sparql-scanner.c"
								}
								default:
#line 784 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3826 "tracker-sparql-scanner.c"
							}
						}
#line 791 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3831 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '>':
#line 3835 "tracker-sparql-scanner.c"
					{
						gchar* _tmp102_;
						gboolean _tmp103_ = FALSE;
						gchar* _tmp104_;
						gchar* _tmp105_;
#line 793 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_GT;
#line 794 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp102_ = self->priv->current;
#line 794 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp102_ + 1;
#line 795 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp104_ = self->priv->current;
#line 795 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp105_ = self->priv->end;
#line 795 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp104_ < _tmp105_) {
#line 3853 "tracker-sparql-scanner.c"
							gchar* _tmp106_;
							gchar _tmp107_;
#line 795 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp106_ = self->priv->current;
#line 795 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp107_ = _tmp106_[0];
#line 795 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp103_ = _tmp107_ == '=';
#line 3862 "tracker-sparql-scanner.c"
						} else {
#line 795 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp103_ = FALSE;
#line 3866 "tracker-sparql-scanner.c"
						}
#line 795 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp103_) {
#line 3870 "tracker-sparql-scanner.c"
							gchar* _tmp108_;
#line 796 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_GE;
#line 797 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp108_ = self->priv->current;
#line 797 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp108_ + 1;
#line 3878 "tracker-sparql-scanner.c"
						}
#line 799 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3882 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '!':
#line 3886 "tracker-sparql-scanner.c"
					{
						gchar* _tmp109_;
						gboolean _tmp110_ = FALSE;
						gchar* _tmp111_;
						gchar* _tmp112_;
#line 801 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_NEG;
#line 802 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp109_ = self->priv->current;
#line 802 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp109_ + 1;
#line 803 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp111_ = self->priv->current;
#line 803 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp112_ = self->priv->end;
#line 803 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp111_ < _tmp112_) {
#line 3904 "tracker-sparql-scanner.c"
							gchar* _tmp113_;
							gchar _tmp114_;
#line 803 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp113_ = self->priv->current;
#line 803 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp114_ = _tmp113_[0];
#line 803 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp110_ = _tmp114_ == '=';
#line 3913 "tracker-sparql-scanner.c"
						} else {
#line 803 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp110_ = FALSE;
#line 3917 "tracker-sparql-scanner.c"
						}
#line 803 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp110_) {
#line 3921 "tracker-sparql-scanner.c"
							gchar* _tmp115_;
#line 804 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_NE;
#line 805 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp115_ = self->priv->current;
#line 805 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp115_ + 1;
#line 3929 "tracker-sparql-scanner.c"
						}
#line 807 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3933 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '+':
#line 3937 "tracker-sparql-scanner.c"
					{
						gchar* _tmp116_;
#line 809 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_PLUS;
#line 810 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp116_ = self->priv->current;
#line 810 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp116_ + 1;
#line 811 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3948 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '-':
#line 3952 "tracker-sparql-scanner.c"
					{
						gchar* _tmp117_;
#line 813 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_MINUS;
#line 814 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp117_ = self->priv->current;
#line 814 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp117_ + 1;
#line 815 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3963 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '*':
#line 3967 "tracker-sparql-scanner.c"
					{
						gchar* _tmp118_;
#line 817 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_STAR;
#line 818 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp118_ = self->priv->current;
#line 818 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp118_ + 1;
#line 819 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3978 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '/':
#line 3982 "tracker-sparql-scanner.c"
					{
						gchar* _tmp119_;
#line 821 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DIV;
#line 822 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp119_ = self->priv->current;
#line 822 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp119_ + 1;
#line 823 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3993 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '\'':
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '"':
#line 3999 "tracker-sparql-scanner.c"
					{
						gboolean _tmp120_ = FALSE;
						gboolean _tmp121_ = FALSE;
						gchar* _tmp122_;
						gchar* _tmp123_;
						gchar* _tmp181_;
						gchar _tmp182_;
						gchar* _tmp183_;
						gboolean _tmp224_ = FALSE;
						gchar* _tmp225_;
						gchar* _tmp226_;
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp122_ = self->priv->current;
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp123_ = self->priv->end;
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp122_ < (_tmp123_ - 6)) {
#line 4017 "tracker-sparql-scanner.c"
							gchar* _tmp124_;
							gchar _tmp125_;
							gchar* _tmp126_;
							gchar _tmp127_;
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp124_ = begin;
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp125_ = _tmp124_[1];
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp126_ = begin;
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp127_ = _tmp126_[0];
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp121_ = _tmp125_ == _tmp127_;
#line 4032 "tracker-sparql-scanner.c"
						} else {
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp121_ = FALSE;
#line 4036 "tracker-sparql-scanner.c"
						}
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp121_) {
#line 4040 "tracker-sparql-scanner.c"
							gchar* _tmp128_;
							gchar _tmp129_;
							gchar* _tmp130_;
							gchar _tmp131_;
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp128_ = begin;
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp129_ = _tmp128_[2];
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp130_ = begin;
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp131_ = _tmp130_[0];
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp120_ = _tmp129_ == _tmp131_;
#line 4055 "tracker-sparql-scanner.c"
						} else {
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp120_ = FALSE;
#line 4059 "tracker-sparql-scanner.c"
						}
#line 826 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp120_) {
#line 4063 "tracker-sparql-scanner.c"
							gchar* _tmp132_;
							gchar _tmp133_;
							gchar* _tmp134_;
							gboolean _tmp165_ = FALSE;
							gboolean _tmp166_ = FALSE;
							gchar* _tmp167_;
							gchar _tmp168_;
							gchar* _tmp169_;
							gchar _tmp170_;
#line 827 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp132_ = begin;
#line 827 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp133_ = _tmp132_[0];
#line 827 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp133_ == '\'') {
#line 828 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1;
#line 4081 "tracker-sparql-scanner.c"
							} else {
#line 830 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2;
#line 4085 "tracker-sparql-scanner.c"
							}
#line 833 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							token_length_in_chars = 6;
#line 834 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp134_ = self->priv->current;
#line 834 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp134_ + 3;
#line 835 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							while (TRUE) {
#line 4095 "tracker-sparql-scanner.c"
								gchar* _tmp135_;
								gchar* _tmp136_;
								gboolean _tmp137_ = FALSE;
								gboolean _tmp138_ = FALSE;
								gchar* _tmp139_;
								gchar _tmp140_;
								gchar* _tmp141_;
								gchar _tmp142_;
#line 835 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp135_ = self->priv->current;
#line 835 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp136_ = self->priv->end;
#line 835 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (!(_tmp135_ < (_tmp136_ - 4))) {
#line 835 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4112 "tracker-sparql-scanner.c"
								}
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp139_ = self->priv->current;
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp140_ = _tmp139_[0];
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp141_ = begin;
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp142_ = _tmp141_[0];
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp140_ == _tmp142_) {
#line 4124 "tracker-sparql-scanner.c"
									gchar* _tmp143_;
									gchar _tmp144_;
									gchar* _tmp145_;
									gchar _tmp146_;
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp143_ = self->priv->current;
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp144_ = _tmp143_[1];
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp145_ = begin;
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp146_ = _tmp145_[0];
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp138_ = _tmp144_ == _tmp146_;
#line 4139 "tracker-sparql-scanner.c"
								} else {
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp138_ = FALSE;
#line 4143 "tracker-sparql-scanner.c"
								}
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp138_) {
#line 4147 "tracker-sparql-scanner.c"
									gchar* _tmp147_;
									gchar _tmp148_;
									gchar* _tmp149_;
									gchar _tmp150_;
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp147_ = self->priv->current;
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp148_ = _tmp147_[2];
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp149_ = begin;
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp150_ = _tmp149_[0];
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp137_ = _tmp148_ == _tmp150_;
#line 4162 "tracker-sparql-scanner.c"
								} else {
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp137_ = FALSE;
#line 4166 "tracker-sparql-scanner.c"
								}
#line 836 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp137_) {
#line 837 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4172 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp151_;
									gchar _tmp152_;
#line 838 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp151_ = self->priv->current;
#line 838 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp152_ = _tmp151_[0];
#line 838 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp152_ == '\n') {
#line 4182 "tracker-sparql-scanner.c"
										gchar* _tmp153_;
										gint _tmp154_;
#line 839 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp153_ = self->priv->current;
#line 839 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp153_ + 1;
#line 840 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp154_ = self->priv->line;
#line 840 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->line = _tmp154_ + 1;
#line 841 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->column = 1;
#line 842 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = 3;
#line 4197 "tracker-sparql-scanner.c"
									} else {
										gchar* _tmp155_;
										gchar _tmp156_;
#line 843 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp155_ = self->priv->current;
#line 843 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp156_ = _tmp155_[0];
#line 843 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (((gint) ((guchar) _tmp156_)) <= 0x7f) {
#line 4207 "tracker-sparql-scanner.c"
											gchar* _tmp157_;
											gint _tmp158_;
#line 845 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp157_ = self->priv->current;
#line 845 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp157_ + 1;
#line 846 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp158_ = token_length_in_chars;
#line 846 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp158_ + 1;
#line 4218 "tracker-sparql-scanner.c"
										} else {
											gunichar u = 0U;
											gchar* _tmp159_;
											gchar* _tmp160_;
											gchar* _tmp161_;
#line 848 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp159_ = self->priv->current;
#line 848 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp160_ = self->priv->end;
#line 848 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp161_ = self->priv->current;
#line 848 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											u = g_utf8_get_char_validated ((const gchar*) _tmp159_, (gssize) ((glong) (_tmp160_ - _tmp161_)));
#line 849 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											if (u != ((gunichar) -1)) {
#line 4234 "tracker-sparql-scanner.c"
												gchar* _tmp162_;
												gint _tmp163_;
#line 850 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp162_ = self->priv->current;
#line 850 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												self->priv->current = _tmp162_ + g_unichar_to_utf8 (u, NULL);
#line 851 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp163_ = token_length_in_chars;
#line 851 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												token_length_in_chars = _tmp163_ + 1;
#line 4245 "tracker-sparql-scanner.c"
											} else {
												GError* _tmp164_;
#line 853 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp164_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", self->priv->line, self->priv->column + token_length_in_chars);
#line 853 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_inner_error0_ = _tmp164_;
#line 853 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 853 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_propagate_error (error, _inner_error0_);
#line 853 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													return 0;
#line 4258 "tracker-sparql-scanner.c"
												} else {
#line 853 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 853 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_clear_error (&_inner_error0_);
#line 853 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													return 0;
#line 4266 "tracker-sparql-scanner.c"
												}
											}
										}
									}
								}
							}
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp167_ = self->priv->current;
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp168_ = _tmp167_[0];
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp169_ = begin;
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp170_ = _tmp169_[0];
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp168_ == _tmp170_) {
#line 4283 "tracker-sparql-scanner.c"
								gchar* _tmp171_;
								gchar _tmp172_;
								gchar* _tmp173_;
								gchar _tmp174_;
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp171_ = self->priv->current;
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp172_ = _tmp171_[1];
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp173_ = begin;
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp174_ = _tmp173_[0];
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp166_ = _tmp172_ == _tmp174_;
#line 4298 "tracker-sparql-scanner.c"
							} else {
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp166_ = FALSE;
#line 4302 "tracker-sparql-scanner.c"
							}
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp166_) {
#line 4306 "tracker-sparql-scanner.c"
								gchar* _tmp175_;
								gchar _tmp176_;
								gchar* _tmp177_;
								gchar _tmp178_;
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp175_ = self->priv->current;
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp176_ = _tmp175_[2];
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp177_ = begin;
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp178_ = _tmp177_[0];
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp165_ = _tmp176_ == _tmp178_;
#line 4321 "tracker-sparql-scanner.c"
							} else {
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp165_ = FALSE;
#line 4325 "tracker-sparql-scanner.c"
							}
#line 857 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp165_) {
#line 4329 "tracker-sparql-scanner.c"
								gchar* _tmp179_;
#line 858 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp179_ = self->priv->current;
#line 858 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp179_ + 3;
#line 4335 "tracker-sparql-scanner.c"
							} else {
								GError* _tmp180_;
#line 860 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp180_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected \"\"\"", self->priv->line, self->priv->column + token_length_in_chars);
#line 860 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_inner_error0_ = _tmp180_;
#line 860 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 860 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_propagate_error (error, _inner_error0_);
#line 860 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									return 0;
#line 4348 "tracker-sparql-scanner.c"
								} else {
#line 860 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 860 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_clear_error (&_inner_error0_);
#line 860 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									return 0;
#line 4356 "tracker-sparql-scanner.c"
								}
							}
#line 862 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 4361 "tracker-sparql-scanner.c"
						}
#line 865 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp181_ = begin;
#line 865 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp182_ = _tmp181_[0];
#line 865 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp182_ == '\'') {
#line 866 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1;
#line 4371 "tracker-sparql-scanner.c"
						} else {
#line 868 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2;
#line 4375 "tracker-sparql-scanner.c"
						}
#line 871 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						token_length_in_chars = 2;
#line 872 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp183_ = self->priv->current;
#line 872 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp183_ + 1;
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 4385 "tracker-sparql-scanner.c"
							gboolean _tmp184_ = FALSE;
							gchar* _tmp185_;
							gchar* _tmp186_;
							gchar* _tmp191_;
							gchar _tmp192_;
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp185_ = self->priv->current;
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp186_ = self->priv->end;
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp185_ < _tmp186_) {
#line 4397 "tracker-sparql-scanner.c"
								gchar* _tmp187_;
								gchar _tmp188_;
								gchar* _tmp189_;
								gchar _tmp190_;
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp187_ = self->priv->current;
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp188_ = _tmp187_[0];
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp189_ = begin;
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp190_ = _tmp189_[0];
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp184_ = _tmp188_ != _tmp190_;
#line 4412 "tracker-sparql-scanner.c"
							} else {
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp184_ = FALSE;
#line 4416 "tracker-sparql-scanner.c"
							}
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp184_) {
#line 873 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4422 "tracker-sparql-scanner.c"
							}
#line 874 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp191_ = self->priv->current;
#line 874 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp192_ = _tmp191_[0];
#line 874 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp192_ == '\\') {
#line 4430 "tracker-sparql-scanner.c"
								gchar* _tmp193_;
								gint _tmp194_;
								gchar* _tmp195_;
								gchar* _tmp196_;
								gchar* _tmp197_;
								gchar _tmp198_;
#line 875 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp193_ = self->priv->current;
#line 875 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp193_ + 1;
#line 876 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp194_ = token_length_in_chars;
#line 876 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								token_length_in_chars = _tmp194_ + 1;
#line 877 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp195_ = self->priv->current;
#line 877 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp196_ = self->priv->end;
#line 877 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp195_ >= _tmp196_) {
#line 878 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4453 "tracker-sparql-scanner.c"
								}
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp197_ = self->priv->current;
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp198_ = _tmp197_[0];
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								switch (_tmp198_) {
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\'':
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '"':
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\\':
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'b':
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'f':
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'n':
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'r':
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 't':
#line 4477 "tracker-sparql-scanner.c"
									{
										gchar* _tmp199_;
										gint _tmp200_;
#line 890 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp199_ = self->priv->current;
#line 890 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp199_ + 1;
#line 891 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp200_ = token_length_in_chars;
#line 891 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp200_ + 1;
#line 892 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 4491 "tracker-sparql-scanner.c"
									}
#line 881 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'u':
#line 4495 "tracker-sparql-scanner.c"
									{
										gchar* _tmp209_;
										{
											gint i = 0;
#line 894 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											i = 0;
#line 4502 "tracker-sparql-scanner.c"
											{
												gboolean _tmp201_ = FALSE;
#line 894 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp201_ = TRUE;
#line 894 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												while (TRUE) {
#line 4509 "tracker-sparql-scanner.c"
													gboolean _tmp203_ = FALSE;
													gchar* _tmp204_;
													gchar* _tmp205_;
#line 894 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (!_tmp201_) {
#line 4515 "tracker-sparql-scanner.c"
														gint _tmp202_;
#line 894 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp202_ = i;
#line 894 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														i = _tmp202_ + 1;
#line 4521 "tracker-sparql-scanner.c"
													}
#line 894 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp201_ = FALSE;
#line 894 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (!(i < 4)) {
#line 894 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														break;
#line 4529 "tracker-sparql-scanner.c"
													}
#line 895 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp204_ = self->priv->current;
#line 895 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp205_ = self->priv->end;
#line 895 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (((_tmp204_ + i) + 1) >= _tmp205_) {
#line 895 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp203_ = TRUE;
#line 4539 "tracker-sparql-scanner.c"
													} else {
														gchar* _tmp206_;
														gchar _tmp207_;
#line 895 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp206_ = self->priv->current;
#line 895 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp207_ = _tmp206_[i + 1];
#line 895 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp203_ = !g_ascii_isxdigit (_tmp207_);
#line 4549 "tracker-sparql-scanner.c"
													}
#line 895 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (_tmp203_) {
#line 4553 "tracker-sparql-scanner.c"
														GError* _tmp208_;
#line 896 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp208_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", self->priv->line, self->priv->column + token_length_in_chars);
#line 896 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_inner_error0_ = _tmp208_;
#line 896 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 896 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_propagate_error (error, _inner_error0_);
#line 896 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															return 0;
#line 4565 "tracker-sparql-scanner.c"
														} else {
#line 896 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 896 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_clear_error (&_inner_error0_);
#line 896 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															return 0;
#line 4573 "tracker-sparql-scanner.c"
														}
													}
												}
											}
										}
#line 899 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp209_ = self->priv->current;
#line 899 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp209_ + 5;
#line 900 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars += 5;
#line 901 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 4587 "tracker-sparql-scanner.c"
									}
									default:
									{
										GError* _tmp210_;
#line 903 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp210_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", self->priv->line, self->priv->column + token_length_in_chars);
#line 903 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_inner_error0_ = _tmp210_;
#line 903 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 903 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_propagate_error (error, _inner_error0_);
#line 903 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											return 0;
#line 4602 "tracker-sparql-scanner.c"
										} else {
#line 903 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 903 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_clear_error (&_inner_error0_);
#line 903 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											return 0;
#line 4610 "tracker-sparql-scanner.c"
										}
									}
								}
							} else {
								gchar* _tmp211_;
								gchar _tmp212_;
#line 905 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp211_ = self->priv->current;
#line 905 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp212_ = _tmp211_[0];
#line 905 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp212_ == '\n') {
#line 906 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4625 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp213_;
									gchar _tmp214_;
#line 907 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp213_ = self->priv->current;
#line 907 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp214_ = _tmp213_[0];
#line 907 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (((gint) ((guchar) _tmp214_)) <= 0x7f) {
#line 4635 "tracker-sparql-scanner.c"
										gchar* _tmp215_;
										gint _tmp216_;
#line 909 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp215_ = self->priv->current;
#line 909 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp215_ + 1;
#line 910 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp216_ = token_length_in_chars;
#line 910 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp216_ + 1;
#line 4646 "tracker-sparql-scanner.c"
									} else {
										gunichar u = 0U;
										gchar* _tmp217_;
										gchar* _tmp218_;
										gchar* _tmp219_;
#line 912 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp217_ = self->priv->current;
#line 912 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp218_ = self->priv->end;
#line 912 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp219_ = self->priv->current;
#line 912 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										u = g_utf8_get_char_validated ((const gchar*) _tmp217_, (gssize) ((glong) (_tmp218_ - _tmp219_)));
#line 913 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (u != ((gunichar) -1)) {
#line 4662 "tracker-sparql-scanner.c"
											gchar* _tmp220_;
											gint _tmp221_;
#line 914 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp220_ = self->priv->current;
#line 914 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp220_ + g_unichar_to_utf8 (u, NULL);
#line 915 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp221_ = token_length_in_chars;
#line 915 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp221_ + 1;
#line 4673 "tracker-sparql-scanner.c"
										} else {
											gchar* _tmp222_;
											GError* _tmp223_;
#line 917 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp222_ = self->priv->current;
#line 917 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp222_ + 1;
#line 918 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp223_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", self->priv->line, self->priv->column + token_length_in_chars);
#line 918 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_inner_error0_ = _tmp223_;
#line 918 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 918 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_propagate_error (error, _inner_error0_);
#line 918 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												return 0;
#line 4691 "tracker-sparql-scanner.c"
											} else {
#line 918 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 918 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_clear_error (&_inner_error0_);
#line 918 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												return 0;
#line 4699 "tracker-sparql-scanner.c"
											}
										}
									}
								}
							}
						}
#line 922 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp225_ = self->priv->current;
#line 922 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp226_ = self->priv->end;
#line 922 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp225_ < _tmp226_) {
#line 4712 "tracker-sparql-scanner.c"
							gchar* _tmp227_;
							gchar _tmp228_;
#line 922 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp227_ = self->priv->current;
#line 922 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp228_ = _tmp227_[0];
#line 922 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp224_ = _tmp228_ != '\n';
#line 4721 "tracker-sparql-scanner.c"
						} else {
#line 922 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp224_ = FALSE;
#line 4725 "tracker-sparql-scanner.c"
						}
#line 922 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp224_) {
#line 4729 "tracker-sparql-scanner.c"
							gchar* _tmp229_;
#line 923 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp229_ = self->priv->current;
#line 923 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp229_ + 1;
#line 4735 "tracker-sparql-scanner.c"
						} else {
							gchar* _tmp230_;
							gchar _tmp231_;
							GError* _tmp232_;
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp230_ = begin;
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp231_ = _tmp230_[0];
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp232_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected %c", self->priv->line, self->priv->column + token_length_in_chars, (gint) _tmp231_);
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error0_ = _tmp232_;
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error0_);
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4754 "tracker-sparql-scanner.c"
							} else {
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error0_);
#line 925 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4762 "tracker-sparql-scanner.c"
							}
						}
#line 927 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4767 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '^':
#line 4771 "tracker-sparql-scanner.c"
					{
						gboolean _tmp233_ = FALSE;
						gchar* _tmp234_;
						gchar* _tmp235_;
#line 929 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp234_ = self->priv->current;
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp235_ = self->priv->end;
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp234_ < (_tmp235_ - 2)) {
#line 4784 "tracker-sparql-scanner.c"
							gchar* _tmp236_;
							gchar _tmp237_;
							gchar* _tmp238_;
							gchar _tmp239_;
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp236_ = self->priv->current;
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp237_ = _tmp236_[0];
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp238_ = self->priv->current;
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp239_ = _tmp238_[1];
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp233_ = _tmp237_ == _tmp239_;
#line 4799 "tracker-sparql-scanner.c"
						} else {
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp233_ = FALSE;
#line 4803 "tracker-sparql-scanner.c"
						}
#line 930 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp233_) {
#line 4807 "tracker-sparql-scanner.c"
							gchar* _tmp240_;
#line 931 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX;
#line 932 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp240_ = self->priv->current;
#line 932 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp240_ + 2;
#line 4815 "tracker-sparql-scanner.c"
						} else {
							GError* _tmp241_;
#line 934 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp241_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", self->priv->line, self->priv->column);
#line 934 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error0_ = _tmp241_;
#line 934 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 934 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error0_);
#line 934 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4828 "tracker-sparql-scanner.c"
							} else {
#line 934 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 934 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error0_);
#line 934 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4836 "tracker-sparql-scanner.c"
							}
						}
#line 936 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4841 "tracker-sparql-scanner.c"
					}
#line 652 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '_':
#line 4845 "tracker-sparql-scanner.c"
					{
						gchar* _tmp242_;
#line 938 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE;
#line 939 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp242_ = self->priv->current;
#line 939 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp242_ + 1;
#line 940 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4856 "tracker-sparql-scanner.c"
					}
					default:
					{
						gunichar u = 0U;
						gchar* _tmp243_;
						gchar* _tmp244_;
						gchar* _tmp245_;
#line 942 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp243_ = self->priv->current;
#line 942 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp244_ = self->priv->end;
#line 942 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp245_ = self->priv->current;
#line 942 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						u = g_utf8_get_char_validated ((const gchar*) _tmp243_, (gssize) ((glong) (_tmp244_ - _tmp245_)));
#line 943 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (u != ((gunichar) -1)) {
#line 4874 "tracker-sparql-scanner.c"
							GError* _tmp246_;
#line 944 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp246_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", self->priv->line, self->priv->column);
#line 944 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error0_ = _tmp246_;
#line 944 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 944 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error0_);
#line 944 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4886 "tracker-sparql-scanner.c"
							} else {
#line 944 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 944 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error0_);
#line 944 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4894 "tracker-sparql-scanner.c"
							}
						} else {
							GError* _tmp247_;
#line 946 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp247_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", self->priv->line, self->priv->column);
#line 946 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error0_ = _tmp247_;
#line 946 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 946 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error0_);
#line 946 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4908 "tracker-sparql-scanner.c"
							} else {
#line 946 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 946 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error0_);
#line 946 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 4916 "tracker-sparql-scanner.c"
							}
						}
					}
				}
			}
		}
	}
#line 951 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (token_length_in_chars < 0) {
#line 4926 "tracker-sparql-scanner.c"
		gchar* _tmp248_;
		gchar* _tmp249_;
#line 952 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp248_ = self->priv->current;
#line 952 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp249_ = begin;
#line 952 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = self->priv->column + ((gint) (_tmp248_ - _tmp249_));
#line 4935 "tracker-sparql-scanner.c"
	} else {
#line 954 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = self->priv->column + token_length_in_chars;
#line 4939 "tracker-sparql-scanner.c"
	}
#line 957 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp250_ = self->priv->current;
#line 957 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_source_location_init (&_vala_token_end, _tmp250_, self->priv->line, self->priv->column - 1);
#line 959 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = type;
#line 959 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (token_begin) {
#line 959 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		*token_begin = _vala_token_begin;
#line 4951 "tracker-sparql-scanner.c"
	}
#line 959 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (token_end) {
#line 959 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		*token_end = _vala_token_end;
#line 4957 "tracker-sparql-scanner.c"
	}
#line 959 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 4961 "tracker-sparql-scanner.c"
}

static gboolean
tracker_sparql_scanner_matches (TrackerSparqlScanner* self,
                                gchar* begin,
                                const gchar* keyword)
{
	gchar* keyword_array = NULL;
	gboolean result;
#line 962 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 962 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (keyword != NULL, FALSE);
#line 963 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	keyword_array = (gchar*) keyword;
#line 4977 "tracker-sparql-scanner.c"
	{
		gint i = 0;
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		i = 0;
#line 4982 "tracker-sparql-scanner.c"
		{
			gboolean _tmp0_ = FALSE;
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = TRUE;
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			while (TRUE) {
#line 4989 "tracker-sparql-scanner.c"
				gchar* _tmp2_;
				gchar _tmp3_;
				gchar _tmp4_;
				gchar* _tmp5_;
				gchar _tmp6_;
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!_tmp0_) {
#line 4997 "tracker-sparql-scanner.c"
					gint _tmp1_;
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp1_ = i;
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					i = _tmp1_ + 1;
#line 5003 "tracker-sparql-scanner.c"
				}
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp0_ = FALSE;
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp2_ = keyword_array;
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp3_ = _tmp2_[i];
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!(((gint) _tmp3_) != 0)) {
#line 964 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 5015 "tracker-sparql-scanner.c"
				}
#line 965 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp4_ = begin[i];
#line 965 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp5_ = keyword_array;
#line 965 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp6_ = _tmp5_[i];
#line 965 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (g_ascii_toupper (_tmp4_) != _tmp6_) {
#line 966 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					result = FALSE;
#line 966 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					return result;
#line 5029 "tracker-sparql-scanner.c"
				}
			}
		}
	}
#line 969 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRUE;
#line 969 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5038 "tracker-sparql-scanner.c"
}

static gboolean
tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self)
{
	gboolean found = FALSE;
	gboolean result;
#line 972 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 973 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	found = FALSE;
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5052 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gchar _tmp6_;
		gchar* _tmp8_;
		gint _tmp9_;
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = self->priv->current;
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = self->priv->end;
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp1_ < _tmp2_) {
#line 5066 "tracker-sparql-scanner.c"
			gchar* _tmp3_;
			gchar _tmp4_;
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp3_ = self->priv->current;
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp4_ = _tmp3_[0];
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = g_ascii_isspace (_tmp4_);
#line 5075 "tracker-sparql-scanner.c"
		} else {
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = FALSE;
#line 5079 "tracker-sparql-scanner.c"
		}
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp0_) {
#line 974 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5085 "tracker-sparql-scanner.c"
		}
#line 975 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = self->priv->current;
#line 975 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = _tmp5_[0];
#line 975 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp6_ == '\n') {
#line 5093 "tracker-sparql-scanner.c"
			gint _tmp7_;
#line 976 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp7_ = self->priv->line;
#line 976 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->line = _tmp7_ + 1;
#line 977 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->column = 0;
#line 5101 "tracker-sparql-scanner.c"
		}
#line 979 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		found = TRUE;
#line 980 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = self->priv->current;
#line 980 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp8_ + 1;
#line 981 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp9_ = self->priv->column;
#line 981 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp9_ + 1;
#line 5113 "tracker-sparql-scanner.c"
	}
#line 983 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = found;
#line 983 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5119 "tracker-sparql-scanner.c"
}

static gboolean
tracker_sparql_scanner_comment (TrackerSparqlScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result;
#line 986 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 987 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = self->priv->current;
#line 987 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->end;
#line 987 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_ >= _tmp2_) {
#line 987 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 5139 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
#line 987 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp3_ = self->priv->current;
#line 987 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp4_ = _tmp3_[0];
#line 987 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp4_ != '#';
#line 5149 "tracker-sparql-scanner.c"
	}
#line 987 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp0_) {
#line 988 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		result = FALSE;
#line 988 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		return result;
#line 5157 "tracker-sparql-scanner.c"
	}
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5161 "tracker-sparql-scanner.c"
		gboolean _tmp5_ = FALSE;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp10_;
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = self->priv->current;
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->end;
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp6_ < _tmp7_) {
#line 5172 "tracker-sparql-scanner.c"
			gchar* _tmp8_;
			gchar _tmp9_;
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp8_ = self->priv->current;
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp9_ = _tmp8_[0];
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp5_ = _tmp9_ != '\n';
#line 5181 "tracker-sparql-scanner.c"
		} else {
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp5_ = FALSE;
#line 5185 "tracker-sparql-scanner.c"
		}
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp5_) {
#line 993 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5191 "tracker-sparql-scanner.c"
		}
#line 994 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp10_ = self->priv->current;
#line 994 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp10_ + 1;
#line 5197 "tracker-sparql-scanner.c"
	}
#line 997 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRUE;
#line 997 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5203 "tracker-sparql-scanner.c"
}

static void
tracker_sparql_scanner_space (TrackerSparqlScanner* self)
{
#line 1000 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 1001 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5213 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
#line 1001 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (tracker_sparql_scanner_whitespace (self)) {
#line 1001 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = TRUE;
#line 5219 "tracker-sparql-scanner.c"
		} else {
#line 1001 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = tracker_sparql_scanner_comment (self);
#line 5223 "tracker-sparql-scanner.c"
		}
#line 1001 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp0_) {
#line 1001 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5229 "tracker-sparql-scanner.c"
		}
	}
}

static void
tracker_sparql_scanner_class_init (TrackerSparqlScannerClass * klass,
                                   gpointer klass_data)
{
#line 20 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_sparql_scanner_parent_class = g_type_class_peek_parent (klass);
#line 20 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_type_class_adjust_private_offset (klass, &TrackerSparqlScanner_private_offset);
#line 20 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_scanner_finalize;
#line 5244 "tracker-sparql-scanner.c"
}

static void
tracker_sparql_scanner_instance_init (TrackerSparqlScanner * self,
                                      gpointer klass)
{
#line 20 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv = tracker_sparql_scanner_get_instance_private (self);
#line 5253 "tracker-sparql-scanner.c"
}

static void
tracker_sparql_scanner_finalize (GObject * obj)
{
	TrackerSparqlScanner * self;
#line 20 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner);
#line 20 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (tracker_sparql_scanner_parent_class)->finalize (obj);
#line 5264 "tracker-sparql-scanner.c"
}

static GType
tracker_sparql_scanner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlScanner), 0, (GInstanceInitFunc) tracker_sparql_scanner_instance_init, NULL };
	GType tracker_sparql_scanner_type_id;
	tracker_sparql_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlScanner", &g_define_type_info, 0);
	TrackerSparqlScanner_private_offset = g_type_add_instance_private (tracker_sparql_scanner_type_id, sizeof (TrackerSparqlScannerPrivate));
	return tracker_sparql_scanner_type_id;
}

GType
tracker_sparql_scanner_get_type (void)
{
	static volatile gsize tracker_sparql_scanner_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_scanner_type_id__once)) {
		GType tracker_sparql_scanner_type_id;
		tracker_sparql_scanner_type_id = tracker_sparql_scanner_get_type_once ();
		g_once_init_leave (&tracker_sparql_scanner_type_id__once, tracker_sparql_scanner_type_id);
	}
	return tracker_sparql_scanner_type_id__once;
}

void
tracker_source_location_init (TrackerSourceLocation *self,
                              gchar* pos,
                              gint line,
                              gint column)
{
#line 1014 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	memset (self, 0, sizeof (TrackerSourceLocation));
#line 1015 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).pos = pos;
#line 1016 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).line = line;
#line 1017 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).column = column;
#line 5303 "tracker-sparql-scanner.c"
}

TrackerSourceLocation*
tracker_source_location_dup (const TrackerSourceLocation* self)
{
	TrackerSourceLocation* dup;
#line 1009 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	dup = g_new0 (TrackerSourceLocation, 1);
#line 1009 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	memcpy (dup, self, sizeof (TrackerSourceLocation));
#line 1009 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return dup;
#line 5316 "tracker-sparql-scanner.c"
}

void
tracker_source_location_free (TrackerSourceLocation* self)
{
#line 1009 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_free (self);
#line 5324 "tracker-sparql-scanner.c"
}

static GType
tracker_source_location_get_type_once (void)
{
	GType tracker_source_location_type_id;
	tracker_source_location_type_id = g_boxed_type_register_static ("TrackerSourceLocation", (GBoxedCopyFunc) tracker_source_location_dup, (GBoxedFreeFunc) tracker_source_location_free);
	return tracker_source_location_type_id;
}

GType
tracker_source_location_get_type (void)
{
	static volatile gsize tracker_source_location_type_id__once = 0;
	if (g_once_init_enter (&tracker_source_location_type_id__once)) {
		GType tracker_source_location_type_id;
		tracker_source_location_type_id = tracker_source_location_get_type_once ();
		g_once_init_leave (&tracker_source_location_type_id__once, tracker_source_location_type_id);
	}
	return tracker_source_location_type_id__once;
}

const gchar*
tracker_sparql_token_type_to_string (TrackerSparqlTokenType self)
{
	const gchar* result;
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	switch (self) {
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_A:
#line 5355 "tracker-sparql-scanner.c"
		{
#line 1151 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`a'";
#line 1151 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5361 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ABS:
#line 5365 "tracker-sparql-scanner.c"
		{
#line 1152 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ABS'";
#line 1152 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5371 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AS:
#line 5375 "tracker-sparql-scanner.c"
		{
#line 1153 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`AS'";
#line 1153 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5381 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASC:
#line 5385 "tracker-sparql-scanner.c"
		{
#line 1154 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ASC'";
#line 1154 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5391 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
#line 5395 "tracker-sparql-scanner.c"
		{
#line 1155 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ASK'";
#line 1155 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5401 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATBASE:
#line 5405 "tracker-sparql-scanner.c"
		{
#line 1156 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`@base'";
#line 1156 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5411 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX:
#line 5415 "tracker-sparql-scanner.c"
		{
#line 1157 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`@prefix'";
#line 1157 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5421 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 5425 "tracker-sparql-scanner.c"
		{
#line 1158 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`AVG'";
#line 1158 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5431 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BASE:
#line 5435 "tracker-sparql-scanner.c"
		{
#line 1159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BASE'";
#line 1159 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5441 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE:
#line 5445 "tracker-sparql-scanner.c"
		{
#line 1160 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "blank node";
#line 1160 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5451 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BIND:
#line 5455 "tracker-sparql-scanner.c"
		{
#line 1161 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BIND'";
#line 1161 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5461 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 5465 "tracker-sparql-scanner.c"
		{
#line 1162 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BOUND'";
#line 1162 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5471 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BY:
#line 5475 "tracker-sparql-scanner.c"
		{
#line 1163 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BY'";
#line 1163 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5481 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CEIL:
#line 5485 "tracker-sparql-scanner.c"
		{
#line 1164 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CEIL'";
#line 1164 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5491 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE:
#line 5495 "tracker-sparql-scanner.c"
		{
#line 1165 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`}'";
#line 1165 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5501 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET:
#line 5505 "tracker-sparql-scanner.c"
		{
#line 1166 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`]'";
#line 1166 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5511 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 5515 "tracker-sparql-scanner.c"
		{
#line 1167 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`)'";
#line 1167 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5521 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 5525 "tracker-sparql-scanner.c"
		{
#line 1168 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`COALESCE'";
#line 1168 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5531 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 5535 "tracker-sparql-scanner.c"
		{
#line 1169 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`:'";
#line 1169 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5541 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONCAT:
#line 5545 "tracker-sparql-scanner.c"
		{
#line 1170 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONCAT'";
#line 1170 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5551 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONTAINS:
#line 5555 "tracker-sparql-scanner.c"
		{
#line 1171 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONTAINS'";
#line 1171 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5561 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COMMA:
#line 5565 "tracker-sparql-scanner.c"
		{
#line 1172 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`,'";
#line 1172 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5571 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
#line 5575 "tracker-sparql-scanner.c"
		{
#line 1173 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONSTRUCT'";
#line 1173 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5581 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 5585 "tracker-sparql-scanner.c"
		{
#line 1174 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`COUNT'";
#line 1174 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5591 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 5595 "tracker-sparql-scanner.c"
		{
#line 1175 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DATATYPE'";
#line 1175 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5601 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DAY:
#line 5605 "tracker-sparql-scanner.c"
		{
#line 1176 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DAY'";
#line 1176 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5611 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 5615 "tracker-sparql-scanner.c"
		{
#line 1177 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DECIMAL'";
#line 1177 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5621 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
#line 5625 "tracker-sparql-scanner.c"
		{
#line 1178 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DELETE'";
#line 1178 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5631 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESC:
#line 5635 "tracker-sparql-scanner.c"
		{
#line 1179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DESC'";
#line 1179 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5641 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
#line 5645 "tracker-sparql-scanner.c"
		{
#line 1180 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DESCRIBE'";
#line 1180 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5651 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DISTINCT:
#line 5655 "tracker-sparql-scanner.c"
		{
#line 1181 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DISTINCT'";
#line 1181 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5661 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 5665 "tracker-sparql-scanner.c"
		{
#line 1182 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DOUBLE'";
#line 1182 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5671 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX:
#line 5675 "tracker-sparql-scanner.c"
		{
#line 1183 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`^^'";
#line 1183 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5681 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
#line 5685 "tracker-sparql-scanner.c"
		{
#line 1184 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DROP'";
#line 1184 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5691 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI:
#line 5695 "tracker-sparql-scanner.c"
		{
#line 1185 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ENCODE_FOR_URI'";
#line 1185 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5701 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 5705 "tracker-sparql-scanner.c"
		{
#line 1186 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "end of file";
#line 1186 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5711 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 5715 "tracker-sparql-scanner.c"
		{
#line 1187 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`EXISTS'";
#line 1187 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5721 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 5725 "tracker-sparql-scanner.c"
		{
#line 1188 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`false'";
#line 1188 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5731 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FILTER:
#line 5735 "tracker-sparql-scanner.c"
		{
#line 1189 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FILTER'";
#line 1189 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5741 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FLOOR:
#line 5745 "tracker-sparql-scanner.c"
		{
#line 1190 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FLOOR'";
#line 1190 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5751 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 5755 "tracker-sparql-scanner.c"
		{
#line 1191 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FROM'";
#line 1191 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5761 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GRAPH:
#line 5765 "tracker-sparql-scanner.c"
		{
#line 1192 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GRAPH'";
#line 1192 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5771 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 5775 "tracker-sparql-scanner.c"
		{
#line 1193 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GROUP'";
#line 1193 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5781 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 5785 "tracker-sparql-scanner.c"
		{
#line 1194 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GROUP_CONCAT'";
#line 1194 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5791 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HAVING:
#line 5795 "tracker-sparql-scanner.c"
		{
#line 1195 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`HAVING'";
#line 1195 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5801 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HOURS:
#line 5805 "tracker-sparql-scanner.c"
		{
#line 1196 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`HOURS'";
#line 1196 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5811 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 5815 "tracker-sparql-scanner.c"
		{
#line 1197 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`IF'";
#line 1197 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5821 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
#line 5825 "tracker-sparql-scanner.c"
		{
#line 1198 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INSERT'";
#line 1198 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5831 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 5835 "tracker-sparql-scanner.c"
		{
#line 1199 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INTEGER'";
#line 1199 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5841 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTO:
#line 5845 "tracker-sparql-scanner.c"
		{
#line 1200 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INTO'";
#line 1200 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5851 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 5855 "tracker-sparql-scanner.c"
		{
#line 1201 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "IRI reference";
#line 1201 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5861 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 5865 "tracker-sparql-scanner.c"
		{
#line 1202 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISBLANK'";
#line 1202 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5871 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 5875 "tracker-sparql-scanner.c"
		{
#line 1203 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISIRI'";
#line 1203 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5881 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 5885 "tracker-sparql-scanner.c"
		{
#line 1204 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISLITERAL'";
#line 1204 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5891 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 5895 "tracker-sparql-scanner.c"
		{
#line 1205 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISURI'";
#line 1205 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5901 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 5905 "tracker-sparql-scanner.c"
		{
#line 1206 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LANG'";
#line 1206 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5911 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 5915 "tracker-sparql-scanner.c"
		{
#line 1207 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LANGMATCHES'";
#line 1207 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5921 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LCASE:
#line 5925 "tracker-sparql-scanner.c"
		{
#line 1208 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LCASE'";
#line 1208 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5931 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 5935 "tracker-sparql-scanner.c"
		{
#line 1209 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LIMIT'";
#line 1209 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5941 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 5945 "tracker-sparql-scanner.c"
		{
#line 1210 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MAX'";
#line 1210 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5951 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MD5:
#line 5955 "tracker-sparql-scanner.c"
		{
#line 1211 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MD5'";
#line 1211 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5961 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 5965 "tracker-sparql-scanner.c"
		{
#line 1212 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MIN'";
#line 1212 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5971 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUS:
#line 5975 "tracker-sparql-scanner.c"
		{
#line 1213 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`-'";
#line 1213 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5981 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUTES:
#line 5985 "tracker-sparql-scanner.c"
		{
#line 1214 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MINUTES'";
#line 1214 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5991 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MONTH:
#line 5995 "tracker-sparql-scanner.c"
		{
#line 1215 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MONTH'";
#line 1215 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6001 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NAMED:
#line 6005 "tracker-sparql-scanner.c"
		{
#line 1216 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NAMED'";
#line 1216 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6011 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 6015 "tracker-sparql-scanner.c"
		{
#line 1217 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NOT'";
#line 1217 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6021 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOW:
#line 6025 "tracker-sparql-scanner.c"
		{
#line 1218 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NOW'";
#line 1218 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6031 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 6035 "tracker-sparql-scanner.c"
		{
#line 1219 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OFFSET'";
#line 1219 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6041 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_AND:
#line 6045 "tracker-sparql-scanner.c"
		{
#line 1220 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`&&'";
#line 1220 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6051 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_EQ:
#line 6055 "tracker-sparql-scanner.c"
		{
#line 1221 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`='";
#line 1221 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6061 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GE:
#line 6065 "tracker-sparql-scanner.c"
		{
#line 1222 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`>='";
#line 1222 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6071 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GT:
#line 6075 "tracker-sparql-scanner.c"
		{
#line 1223 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`>'";
#line 1223 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6081 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LE:
#line 6085 "tracker-sparql-scanner.c"
		{
#line 1224 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`<='";
#line 1224 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6091 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LT:
#line 6095 "tracker-sparql-scanner.c"
		{
#line 1225 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`<'";
#line 1225 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6101 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NE:
#line 6105 "tracker-sparql-scanner.c"
		{
#line 1226 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`!='";
#line 1226 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6111 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NEG:
#line 6115 "tracker-sparql-scanner.c"
		{
#line 1227 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`!'";
#line 1227 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6121 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_OR:
#line 6125 "tracker-sparql-scanner.c"
		{
#line 1228 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`||'";
#line 1228 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6131 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_IN:
#line 6135 "tracker-sparql-scanner.c"
		{
#line 1229 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`IN'";
#line 1229 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6141 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 6145 "tracker-sparql-scanner.c"
		{
#line 1230 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`{'";
#line 1230 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6151 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET:
#line 6155 "tracker-sparql-scanner.c"
		{
#line 1231 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`['";
#line 1231 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6161 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 6165 "tracker-sparql-scanner.c"
		{
#line 1232 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`('";
#line 1232 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6171 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL:
#line 6175 "tracker-sparql-scanner.c"
		{
#line 1233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OPTIONAL'";
#line 1233 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6181 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OR:
#line 6185 "tracker-sparql-scanner.c"
		{
#line 1234 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OR'";
#line 1234 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6191 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 6195 "tracker-sparql-scanner.c"
		{
#line 1235 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ORDER'";
#line 1235 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6201 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PLUS:
#line 6205 "tracker-sparql-scanner.c"
		{
#line 1236 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`+'";
#line 1236 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6211 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 6215 "tracker-sparql-scanner.c"
		{
#line 1237 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "prefixed name";
#line 1237 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6221 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PREFIX:
#line 6225 "tracker-sparql-scanner.c"
		{
#line 1238 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`PREFIX'";
#line 1238 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6231 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_RAND:
#line 6235 "tracker-sparql-scanner.c"
		{
#line 1239 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`RAND'";
#line 1239 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6241 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REDUCED:
#line 6245 "tracker-sparql-scanner.c"
		{
#line 1240 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REDUCED'";
#line 1240 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6251 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 6255 "tracker-sparql-scanner.c"
		{
#line 1241 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REGEX'";
#line 1241 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6261 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REPLACE:
#line 6265 "tracker-sparql-scanner.c"
		{
#line 1242 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REPLACE'";
#line 1242 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6271 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ROUND:
#line 6275 "tracker-sparql-scanner.c"
		{
#line 1243 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ROUND'";
#line 1243 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6281 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 6285 "tracker-sparql-scanner.c"
		{
#line 1244 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SAMETERM'";
#line 1244 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6291 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SECONDS:
#line 6295 "tracker-sparql-scanner.c"
		{
#line 1245 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SECONDS'";
#line 1245 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6301 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
#line 6305 "tracker-sparql-scanner.c"
		{
#line 1246 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SELECT'";
#line 1246 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6311 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON:
#line 6315 "tracker-sparql-scanner.c"
		{
#line 1247 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`;'";
#line 1247 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6321 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA1:
#line 6325 "tracker-sparql-scanner.c"
		{
#line 1248 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SHA1'";
#line 1248 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6331 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA256:
#line 6335 "tracker-sparql-scanner.c"
		{
#line 1249 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SHA256'";
#line 1249 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6341 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA512:
#line 6345 "tracker-sparql-scanner.c"
		{
#line 1250 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SHA512'";
#line 1250 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6351 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SILENT:
#line 6355 "tracker-sparql-scanner.c"
		{
#line 1251 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SILENT'";
#line 1251 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6361 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STAR:
#line 6365 "tracker-sparql-scanner.c"
		{
#line 1252 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`*'";
#line 1252 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6371 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 6375 "tracker-sparql-scanner.c"
		{
#line 1253 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STR'";
#line 1253 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6381 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRAFTER:
#line 6385 "tracker-sparql-scanner.c"
		{
#line 1254 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRAFTER'";
#line 1254 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6391 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE:
#line 6395 "tracker-sparql-scanner.c"
		{
#line 1255 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRBEFORE'";
#line 1255 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6401 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRENDS:
#line 6405 "tracker-sparql-scanner.c"
		{
#line 1256 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRENDS'";
#line 1256 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6411 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 6415 "tracker-sparql-scanner.c"
		{
#line 1257 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1257 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6421 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 6425 "tracker-sparql-scanner.c"
		{
#line 1258 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1258 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6431 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 6435 "tracker-sparql-scanner.c"
		{
#line 1259 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1259 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6441 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 6445 "tracker-sparql-scanner.c"
		{
#line 1260 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1260 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6451 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRLEN:
#line 6455 "tracker-sparql-scanner.c"
		{
#line 1261 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRLEN'";
#line 1261 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6461 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS:
#line 6465 "tracker-sparql-scanner.c"
		{
#line 1262 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRSTARTS'";
#line 1262 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6471 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUBSTR:
#line 6475 "tracker-sparql-scanner.c"
		{
#line 1263 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SUBSTR'";
#line 1263 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6481 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 6485 "tracker-sparql-scanner.c"
		{
#line 1264 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SUM'";
#line 1264 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6491 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 6495 "tracker-sparql-scanner.c"
		{
#line 1265 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`true'";
#line 1265 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6501 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UCASE:
#line 6505 "tracker-sparql-scanner.c"
		{
#line 1266 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`UCASE'";
#line 1266 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6511 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UNION:
#line 6515 "tracker-sparql-scanner.c"
		{
#line 1267 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`UNION'";
#line 1267 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6521 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 6525 "tracker-sparql-scanner.c"
		{
#line 1268 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "variable";
#line 1268 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6531 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 6535 "tracker-sparql-scanner.c"
		{
#line 1269 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`WHERE'";
#line 1269 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6541 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WITH:
#line 6545 "tracker-sparql-scanner.c"
		{
#line 1270 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`WITH'";
#line 1270 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6551 "tracker-sparql-scanner.c"
		}
#line 1150 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_YEAR:
#line 6555 "tracker-sparql-scanner.c"
		{
#line 1271 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`YEAR'";
#line 1271 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6561 "tracker-sparql-scanner.c"
		}
		default:
		{
#line 1272 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "unknown token";
#line 1272 "../tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6569 "tracker-sparql-scanner.c"
		}
	}
}

static GType
tracker_sparql_token_type_get_type_once (void)
{
	static const GEnumValue values[] = {{TRACKER_SPARQL_TOKEN_TYPE_NONE, "TRACKER_SPARQL_TOKEN_TYPE_NONE", "none"}, {TRACKER_SPARQL_TOKEN_TYPE_A, "TRACKER_SPARQL_TOKEN_TYPE_A", "a"}, {TRACKER_SPARQL_TOKEN_TYPE_ABS, "TRACKER_SPARQL_TOKEN_TYPE_ABS", "abs"}, {TRACKER_SPARQL_TOKEN_TYPE_AS, "TRACKER_SPARQL_TOKEN_TYPE_AS", "as"}, {TRACKER_SPARQL_TOKEN_TYPE_ASC, "TRACKER_SPARQL_TOKEN_TYPE_ASC", "asc"}, {TRACKER_SPARQL_TOKEN_TYPE_ASK, "TRACKER_SPARQL_TOKEN_TYPE_ASK", "ask"}, {TRACKER_SPARQL_TOKEN_TYPE_ATBASE, "TRACKER_SPARQL_TOKEN_TYPE_ATBASE", "atbase"}, {TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, "TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX", "atprefix"}, {TRACKER_SPARQL_TOKEN_TYPE_AVG, "TRACKER_SPARQL_TOKEN_TYPE_AVG", "avg"}, {TRACKER_SPARQL_TOKEN_TYPE_BASE, "TRACKER_SPARQL_TOKEN_TYPE_BASE", "base"}, {TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, "TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE", "blank-node"}, {TRACKER_SPARQL_TOKEN_TYPE_BIND, "TRACKER_SPARQL_TOKEN_TYPE_BIND", "bind"}, {TRACKER_SPARQL_TOKEN_TYPE_BOUND, "TRACKER_SPARQL_TOKEN_TYPE_BOUND", "bound"}, {TRACKER_SPARQL_TOKEN_TYPE_BY, "TRACKER_SPARQL_TOKEN_TYPE_BY", "by"}, {TRACKER_SPARQL_TOKEN_TYPE_CEIL, "TRACKER_SPARQL_TOKEN_TYPE_CEIL", "ceil"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_COALESCE, "TRACKER_SPARQL_TOKEN_TYPE_COALESCE", "coalesce"}, {TRACKER_SPARQL_TOKEN_TYPE_COLON, "TRACKER_SPARQL_TOKEN_TYPE_COLON", "colon"}, {TRACKER_SPARQL_TOKEN_TYPE_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_CONCAT", "concat"}, {TRACKER_SPARQL_TOKEN_TYPE_CONTAINS, "TRACKER_SPARQL_TOKEN_TYPE_CONTAINS", "contains"}, {TRACKER_SPARQL_TOKEN_TYPE_COMMA, "TRACKER_SPARQL_TOKEN_TYPE_COMMA", "comma"}, {TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT, "TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT", "construct"}, {TRACKER_SPARQL_TOKEN_TYPE_COUNT, "TRACKER_SPARQL_TOKEN_TYPE_COUNT", "count"}, {TRACKER_SPARQL_TOKEN_TYPE_DATA, "TRACKER_SPARQL_TOKEN_TYPE_DATA", "data"}, {TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, "TRACKER_SPARQL_TOKEN_TYPE_DATATYPE", "datatype"}, {TRACKER_SPARQL_TOKEN_TYPE_DAY, "TRACKER_SPARQL_TOKEN_TYPE_DAY", "day"}, {TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, "TRACKER_SPARQL_TOKEN_TYPE_DECIMAL", "decimal"}, {TRACKER_SPARQL_TOKEN_TYPE_DELETE, "TRACKER_SPARQL_TOKEN_TYPE_DELETE", "delete"}, {TRACKER_SPARQL_TOKEN_TYPE_DESC, "TRACKER_SPARQL_TOKEN_TYPE_DESC", "desc"}, {TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE, "TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE", "describe"}, {TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, "TRACKER_SPARQL_TOKEN_TYPE_DISTINCT", "distinct"}, {TRACKER_SPARQL_TOKEN_TYPE_DIV, "TRACKER_SPARQL_TOKEN_TYPE_DIV", "div"}, {TRACKER_SPARQL_TOKEN_TYPE_DOT, "TRACKER_SPARQL_TOKEN_TYPE_DOT", "dot"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE", "double"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX", "double-circumflex"}, {TRACKER_SPARQL_TOKEN_TYPE_DROP, "TRACKER_SPARQL_TOKEN_TYPE_DROP", "drop"}, {TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI, "TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI", "encode-for-uri"}, {TRACKER_SPARQL_TOKEN_TYPE_EOF, "TRACKER_SPARQL_TOKEN_TYPE_EOF", "eof"}, {TRACKER_SPARQL_TOKEN_TYPE_EXISTS, "TRACKER_SPARQL_TOKEN_TYPE_EXISTS", "exists"}, {TRACKER_SPARQL_TOKEN_TYPE_FALSE, "TRACKER_SPARQL_TOKEN_TYPE_FALSE", "false"}, {TRACKER_SPARQL_TOKEN_TYPE_FILTER, "TRACKER_SPARQL_TOKEN_TYPE_FILTER", "filter"}, {TRACKER_SPARQL_TOKEN_TYPE_FLOOR, "TRACKER_SPARQL_TOKEN_TYPE_FLOOR", "floor"}, {TRACKER_SPARQL_TOKEN_TYPE_FROM, "TRACKER_SPARQL_TOKEN_TYPE_FROM", "from"}, {TRACKER_SPARQL_TOKEN_TYPE_GRAPH, "TRACKER_SPARQL_TOKEN_TYPE_GRAPH", "graph"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP, "TRACKER_SPARQL_TOKEN_TYPE_GROUP", "group"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT", "group-concat"}, {TRACKER_SPARQL_TOKEN_TYPE_HAVING, "TRACKER_SPARQL_TOKEN_TYPE_HAVING", "having"}, {TRACKER_SPARQL_TOKEN_TYPE_HOURS, "TRACKER_SPARQL_TOKEN_TYPE_HOURS", "hours"}, {TRACKER_SPARQL_TOKEN_TYPE_IF, "TRACKER_SPARQL_TOKEN_TYPE_IF", "if"}, {TRACKER_SPARQL_TOKEN_TYPE_INSERT, "TRACKER_SPARQL_TOKEN_TYPE_INSERT", "insert"}, {TRACKER_SPARQL_TOKEN_TYPE_INTEGER, "TRACKER_SPARQL_TOKEN_TYPE_INTEGER", "integer"}, {TRACKER_SPARQL_TOKEN_TYPE_INTO, "TRACKER_SPARQL_TOKEN_TYPE_INTO", "into"}, {TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, "TRACKER_SPARQL_TOKEN_TYPE_IRI_REF", "iri-ref"}, {TRACKER_SPARQL_TOKEN_TYPE_ISBLANK, "TRACKER_SPARQL_TOKEN_TYPE_ISBLANK", "isblank"}, {TRACKER_SPARQL_TOKEN_TYPE_ISIRI, "TRACKER_SPARQL_TOKEN_TYPE_ISIRI", "isiri"}, {TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL, "TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL", "isliteral"}, {TRACKER_SPARQL_TOKEN_TYPE_ISURI, "TRACKER_SPARQL_TOKEN_TYPE_ISURI", "isuri"}, {TRACKER_SPARQL_TOKEN_TYPE_LANG, "TRACKER_SPARQL_TOKEN_TYPE_LANG", "lang"}, {TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES, "TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES", "langmatches"}, {TRACKER_SPARQL_TOKEN_TYPE_LCASE, "TRACKER_SPARQL_TOKEN_TYPE_LCASE", "lcase"}, {TRACKER_SPARQL_TOKEN_TYPE_LIMIT, "TRACKER_SPARQL_TOKEN_TYPE_LIMIT", "limit"}, {TRACKER_SPARQL_TOKEN_TYPE_MAX, "TRACKER_SPARQL_TOKEN_TYPE_MAX", "max"}, {TRACKER_SPARQL_TOKEN_TYPE_MD5, "TRACKER_SPARQL_TOKEN_TYPE_MD5", "md5"}, {TRACKER_SPARQL_TOKEN_TYPE_MIN, "TRACKER_SPARQL_TOKEN_TYPE_MIN", "min"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUS, "TRACKER_SPARQL_TOKEN_TYPE_MINUS", "minus"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUTES, "TRACKER_SPARQL_TOKEN_TYPE_MINUTES", "minutes"}, {TRACKER_SPARQL_TOKEN_TYPE_MONTH, "TRACKER_SPARQL_TOKEN_TYPE_MONTH", "month"}, {TRACKER_SPARQL_TOKEN_TYPE_NAMED, "TRACKER_SPARQL_TOKEN_TYPE_NAMED", "named"}, {TRACKER_SPARQL_TOKEN_TYPE_NOT, "TRACKER_SPARQL_TOKEN_TYPE_NOT", "not"}, {TRACKER_SPARQL_TOKEN_TYPE_NOW, "TRACKER_SPARQL_TOKEN_TYPE_NOW", "now"}, {TRACKER_SPARQL_TOKEN_TYPE_NULL, "TRACKER_SPARQL_TOKEN_TYPE_NULL", "null"}, {TRACKER_SPARQL_TOKEN_TYPE_OFFSET, "TRACKER_SPARQL_TOKEN_TYPE_OFFSET", "offset"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_AND, "TRACKER_SPARQL_TOKEN_TYPE_OP_AND", "op-and"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, "TRACKER_SPARQL_TOKEN_TYPE_OP_EQ", "op-eq"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GE, "TRACKER_SPARQL_TOKEN_TYPE_OP_GE", "op-ge"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GT, "TRACKER_SPARQL_TOKEN_TYPE_OP_GT", "op-gt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LE, "TRACKER_SPARQL_TOKEN_TYPE_OP_LE", "op-le"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LT, "TRACKER_SPARQL_TOKEN_TYPE_OP_LT", "op-lt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NE, "TRACKER_SPARQL_TOKEN_TYPE_OP_NE", "op-ne"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, "TRACKER_SPARQL_TOKEN_TYPE_OP_NEG", "op-neg"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_OR, "TRACKER_SPARQL_TOKEN_TYPE_OP_OR", "op-or"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_IN, "TRACKER_SPARQL_TOKEN_TYPE_OP_IN", "op-in"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, "TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL", "optional"}, {TRACKER_SPARQL_TOKEN_TYPE_OR, "TRACKER_SPARQL_TOKEN_TYPE_OR", "or"}, {TRACKER_SPARQL_TOKEN_TYPE_ORDER, "TRACKER_SPARQL_TOKEN_TYPE_ORDER", "order"}, {TRACKER_SPARQL_TOKEN_TYPE_PLUS, "TRACKER_SPARQL_TOKEN_TYPE_PLUS", "plus"}, {TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX", "pn-prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PREFIX", "prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_RAND, "TRACKER_SPARQL_TOKEN_TYPE_RAND", "rand"}, {TRACKER_SPARQL_TOKEN_TYPE_REDUCED, "TRACKER_SPARQL_TOKEN_TYPE_REDUCED", "reduced"}, {TRACKER_SPARQL_TOKEN_TYPE_REGEX, "TRACKER_SPARQL_TOKEN_TYPE_REGEX", "regex"}, {TRACKER_SPARQL_TOKEN_TYPE_REPLACE, "TRACKER_SPARQL_TOKEN_TYPE_REPLACE", "replace"}, {TRACKER_SPARQL_TOKEN_TYPE_ROUND, "TRACKER_SPARQL_TOKEN_TYPE_ROUND", "round"}, {TRACKER_SPARQL_TOKEN_TYPE_SAMETERM, "TRACKER_SPARQL_TOKEN_TYPE_SAMETERM", "sameterm"}, {TRACKER_SPARQL_TOKEN_TYPE_SECONDS, "TRACKER_SPARQL_TOKEN_TYPE_SECONDS", "seconds"}, {TRACKER_SPARQL_TOKEN_TYPE_SELECT, "TRACKER_SPARQL_TOKEN_TYPE_SELECT", "select"}, {TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, "TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON", "semicolon"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA1, "TRACKER_SPARQL_TOKEN_TYPE_SHA1", "sha1"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA256, "TRACKER_SPARQL_TOKEN_TYPE_SHA256", "sha256"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA512, "TRACKER_SPARQL_TOKEN_TYPE_SHA512", "sha512"}, {TRACKER_SPARQL_TOKEN_TYPE_SILENT, "TRACKER_SPARQL_TOKEN_TYPE_SILENT", "silent"}, {TRACKER_SPARQL_TOKEN_TYPE_STAR, "TRACKER_SPARQL_TOKEN_TYPE_STAR", "star"}, {TRACKER_SPARQL_TOKEN_TYPE_STR, "TRACKER_SPARQL_TOKEN_TYPE_STR", "str"}, {TRACKER_SPARQL_TOKEN_TYPE_STRAFTER, "TRACKER_SPARQL_TOKEN_TYPE_STRAFTER", "strafter"}, {TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE, "TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE", "strbefore"}, {TRACKER_SPARQL_TOKEN_TYPE_STRENDS, "TRACKER_SPARQL_TOKEN_TYPE_STRENDS", "strends"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1", "string-literal1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2", "string-literal2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1", "string-literal-long1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2", "string-literal-long2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRLEN, "TRACKER_SPARQL_TOKEN_TYPE_STRLEN", "strlen"}, {TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS, "TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS", "strstarts"}, {TRACKER_SPARQL_TOKEN_TYPE_SUBSTR, "TRACKER_SPARQL_TOKEN_TYPE_SUBSTR", "substr"}, {TRACKER_SPARQL_TOKEN_TYPE_SUM, "TRACKER_SPARQL_TOKEN_TYPE_SUM", "sum"}, {TRACKER_SPARQL_TOKEN_TYPE_TRUE, "TRACKER_SPARQL_TOKEN_TYPE_TRUE", "true"}, {TRACKER_SPARQL_TOKEN_TYPE_UCASE, "TRACKER_SPARQL_TOKEN_TYPE_UCASE", "ucase"}, {TRACKER_SPARQL_TOKEN_TYPE_UNION, "TRACKER_SPARQL_TOKEN_TYPE_UNION", "union"}, {TRACKER_SPARQL_TOKEN_TYPE_VAR, "TRACKER_SPARQL_TOKEN_TYPE_VAR", "var"}, {TRACKER_SPARQL_TOKEN_TYPE_WHERE, "TRACKER_SPARQL_TOKEN_TYPE_WHERE", "where"}, {TRACKER_SPARQL_TOKEN_TYPE_WITH, "TRACKER_SPARQL_TOKEN_TYPE_WITH", "with"}, {TRACKER_SPARQL_TOKEN_TYPE_YEAR, "TRACKER_SPARQL_TOKEN_TYPE_YEAR", "year"}, {0, NULL, NULL}};
	GType tracker_sparql_token_type_type_id;
	tracker_sparql_token_type_type_id = g_enum_register_static ("TrackerSparqlTokenType", values);
	return tracker_sparql_token_type_type_id;
}

GType
tracker_sparql_token_type_get_type (void)
{
	static volatile gsize tracker_sparql_token_type_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_token_type_type_id__once)) {
		GType tracker_sparql_token_type_type_id;
		tracker_sparql_token_type_type_id = tracker_sparql_token_type_get_type_once ();
		g_once_init_leave (&tracker_sparql_token_type_type_id__once, tracker_sparql_token_type_type_id);
	}
	return tracker_sparql_token_type_type_id__once;
}

