/* tracker-resources.c generated by valac 0.56.1, the Vala compiler
 * generated from tracker-resources.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "libtracker-data/tracker-class.h"
#include "tracker-store/tracker-events.h"
#include <stdlib.h>
#include <string.h>
#include "libtracker-common/tracker-common.h"
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-data-manager.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"

#define TRACKER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE 10000000
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;
typedef struct _TrackerResourcesPrivate TrackerResourcesPrivate;
enum  {
	TRACKER_RESOURCES_0_PROPERTY,
	TRACKER_RESOURCES_NUM_PROPERTIES
};
static GParamSpec* tracker_resources_properties[TRACKER_RESOURCES_NUM_PROPERTIES];
typedef void (*TrackerStoreSignalEmissionFunc) (GHashTable* graph_updated, GHashTable* writeback, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerResourcesLoadData TrackerResourcesLoadData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef void (*TrackerStoreSparqlQueryInThread) (TrackerSparqlCursor* cursor, gpointer user_data, GError** error);
typedef struct _TrackerResourcesSparqlQueryData TrackerResourcesSparqlQueryData;
typedef struct _TrackerResourcesSparqlUpdateData TrackerResourcesSparqlUpdateData;
typedef struct _TrackerResourcesSparqlUpdateBlankData TrackerResourcesSparqlUpdateBlankData;
typedef struct _TrackerResourcesBatchSparqlUpdateData TrackerResourcesBatchSparqlUpdateData;
typedef struct _Block4Data Block4Data;
enum  {
	TRACKER_RESOURCES_WRITEBACK_SIGNAL,
	TRACKER_RESOURCES_GRAPH_UPDATED_SIGNAL,
	TRACKER_RESOURCES_NUM_SIGNALS
};
static guint tracker_resources_signals[TRACKER_RESOURCES_NUM_SIGNALS] = {0};
typedef struct _TrackerResourcesLoadReadyData TrackerResourcesLoadReadyData;
typedef struct _TrackerResourcesSparqlQueryReadyData TrackerResourcesSparqlQueryReadyData;
typedef struct _TrackerResourcesSparqlUpdateReadyData TrackerResourcesSparqlUpdateReadyData;
typedef struct _TrackerResourcesSparqlUpdateBlankReadyData TrackerResourcesSparqlUpdateBlankReadyData;
typedef struct _TrackerResourcesBatchSparqlUpdateReadyData TrackerResourcesBatchSparqlUpdateReadyData;

struct _TrackerResources {
	GObject parent_instance;
	TrackerResourcesPrivate * priv;
};

struct _TrackerResourcesClass {
	GObjectClass parent_class;
};

struct _TrackerResourcesPrivate {
	GDBusConnection* connection;
};

struct _TrackerResourcesLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* uri;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	GFile* file;
	GFile* _tmp1_;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp2_;
	TrackerDirectConnection* _tmp3_;
	GError* ie;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError* e;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	TrackerResources* self;
	GVariantBuilder* builder;
};

struct _TrackerResourcesSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* query;
	GVariant* result;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	Block3Data* _data3_;
	GVariantBuilder* _tmp2_;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp3_;
	TrackerDirectConnection* _tmp4_;
	TrackerDirectConnection* _tmp5_;
	const gchar* _tmp6_;
	const char* _tmp7_;
	GVariant* _result_;
	GVariantBuilder* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GError* _tmp11_;
	TrackerDBusRequest* _tmp12_;
	GError* e;
	TrackerDBusRequest* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GError* _inner_error0_;
};

struct _TrackerResourcesSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp1_;
	TrackerDirectConnection* _tmp2_;
	GError* ie;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GError* e;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GError* _inner_error0_;
};

struct _TrackerResourcesSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	GVariant* result;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp2_;
	TrackerDirectConnection* _tmp3_;
	GVariant* variant;
	TrackerDirectConnection* _tmp4_;
	GVariant* _tmp5_;
	TrackerDBusRequest* _tmp6_;
	GError* ie;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	GError* e;
	TrackerDBusRequest* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	GError* _inner_error0_;
};

struct _TrackerResourcesBatchSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp1_;
	TrackerDirectConnection* _tmp2_;
	GError* ie;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GError* e;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	TrackerResources* self;
	GVariantBuilder* builder;
};

struct _TrackerResourcesLoadReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* uri;
};

struct _TrackerResourcesSparqlQueryReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* query;
};

struct _TrackerResourcesSparqlUpdateReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* update;
};

struct _TrackerResourcesSparqlUpdateBlankReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* update;
};

struct _TrackerResourcesBatchSparqlUpdateReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* update;
};

static gint TrackerResources_private_offset;
static gpointer tracker_resources_parent_class = NULL;

VALA_EXTERN GType tracker_resources_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerResources, g_object_unref)
VALA_EXTERN guint tracker_resources_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN void tracker_store_set_signal_callback (TrackerStoreSignalEmissionFunc func,
                                        gpointer func_target);
VALA_EXTERN TrackerResources* tracker_resources_new (GDBusConnection* connection);
VALA_EXTERN TrackerResources* tracker_resources_construct (GType object_type,
                                               GDBusConnection* connection);
static void tracker_resources_on_emit_signals (TrackerResources* self,
                                        GHashTable* events,
                                        GHashTable* writebacks);
static void _tracker_resources_on_emit_signals_tracker_store_signal_emission_func (GHashTable* graph_updated,
                                                                            GHashTable* writeback,
                                                                            gpointer self);
static void tracker_resources_load_data_free (gpointer _data);
VALA_EXTERN void tracker_resources_load (TrackerResources* self,
                             const char* sender,
                             const gchar* uri,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void tracker_resources_load_finish (TrackerResources* self,
                                    GAsyncResult* _res_,
                                    GError** error);
static gboolean tracker_resources_load_co (TrackerResourcesLoadData* _data_);
VALA_EXTERN TrackerDirectConnection* tracker_main_get_sparql_connection (void);
VALA_EXTERN void tracker_store_queue_turtle_import (TrackerDirectConnection* conn,
                                        GFile* file,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_,
                                               GError** error);
static void tracker_resources_load_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void tracker_resources_sparql_query_data_free (gpointer _data);
VALA_EXTERN void tracker_resources_sparql_query (TrackerResources* self,
                                     const char* sender,
                                     const gchar* query,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN GVariant* tracker_resources_sparql_query_finish (TrackerResources* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static gboolean tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN void tracker_store_sparql_query (TrackerDirectConnection* conn,
                                 const gchar* sparql,
                                 gint priority,
                                 TrackerStoreSparqlQueryInThread in_thread,
                                 gpointer in_thread_target,
                                 const gchar* client_id,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void tracker_store_sparql_query_finish (GAsyncResult* _res_,
                                        GError** error);
static void ___lambda13_ (Block3Data* _data3_,
                   TrackerSparqlCursor* cursor,
                   GError** error);
static void ____lambda13__tracker_store_sparql_query_in_thread (TrackerSparqlCursor* cursor,
                                                         gpointer self,
                                                         GError** error);
static void tracker_resources_sparql_query_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void tracker_resources_sparql_update_data_free (gpointer _data);
VALA_EXTERN void tracker_resources_sparql_update (TrackerResources* self,
                                      const char* sender,
                                      const gchar* update,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN void tracker_resources_sparql_update_finish (TrackerResources* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static gboolean tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* _data_);
VALA_EXTERN void tracker_store_sparql_update (TrackerDirectConnection* conn,
                                  const gchar* sparql,
                                  gint priority,
                                  const gchar* client_id,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void tracker_store_sparql_update_finish (GAsyncResult* _res_,
                                         GError** error);
static void tracker_resources_sparql_update_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void tracker_resources_sparql_update_blank_data_free (gpointer _data);
VALA_EXTERN void tracker_resources_sparql_update_blank (TrackerResources* self,
                                            const char* sender,
                                            const gchar* update,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN GVariant* tracker_resources_sparql_update_blank_finish (TrackerResources* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static gboolean tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* _data_);
VALA_EXTERN void tracker_store_sparql_update_blank (TrackerDirectConnection* conn,
                                        const gchar* sparql,
                                        gint priority,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_,
                                                    GError** error);
static void tracker_resources_sparql_update_blank_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
VALA_EXTERN void tracker_resources_sync (TrackerResources* self,
                             const char* sender,
                             GError** error);
VALA_EXTERN TrackerDataManager* tracker_main_get_data_manager (void);
static void tracker_resources_batch_sparql_update_data_free (gpointer _data);
VALA_EXTERN void tracker_resources_batch_sparql_update (TrackerResources* self,
                                            const char* sender,
                                            const gchar* update,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN void tracker_resources_batch_sparql_update_finish (TrackerResources* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static gboolean tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* _data_);
static void tracker_resources_batch_sparql_update_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
VALA_EXTERN void tracker_resources_batch_commit (TrackerResources* self,
                                     GError** error);
static void tracker_resources_emit_graph_updated (TrackerResources* self,
                                           TrackerClass* cl,
                                           TrackerEventBatch* events);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda11_ (Block4Data* _data4_,
                  gint graph_id,
                  gint subject_id,
                  gint pred_id,
                  gint object_id);
static void ___lambda11__tracker_event_batch_events_foreach (gint graph_id,
                                                      gint subject_id,
                                                      gint pred_id,
                                                      gint object_id,
                                                      gpointer self);
static void __lambda12_ (Block4Data* _data4_,
                  gint graph_id,
                  gint subject_id,
                  gint pred_id,
                  gint object_id);
static void ___lambda12__tracker_event_batch_events_foreach (gint graph_id,
                                                      gint subject_id,
                                                      gint pred_id,
                                                      gint object_id,
                                                      gpointer self);
static void tracker_resources_emit_writeback (TrackerResources* self,
                                       GHashTable* events);
VALA_EXTERN void tracker_resources_unreg_batches (TrackerResources* self,
                                      const gchar* old_owner);
VALA_EXTERN void tracker_store_unreg_batches (const gchar* client_id);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data);
static void tracker_resources_finalize (GObject * obj);
static GType tracker_resources_get_type_once (void);
static void _dbus_tracker_resources_load (TrackerResources* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_load_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_);
static void _dbus_tracker_resources_sparql_query (TrackerResources* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_query_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update (TrackerResources* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update_blank (TrackerResources* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object,
                                                        GAsyncResult * _res_,
                                                        gpointer _user_data_);
static void _dbus_tracker_resources_sync (TrackerResources* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update (TrackerResources* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object,
                                                        GAsyncResult * _res_,
                                                        gpointer _user_data_);
static void _dbus_tracker_resources_batch_commit (TrackerResources* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void tracker_resources_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* tracker_resources_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean tracker_resources_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _dbus_tracker_resources_writeback (GObject* _sender,
                                        GVariant* subjects,
                                        gpointer* _data);
static void _dbus_tracker_resources_graph_updated (GObject* _sender,
                                            const gchar* classname,
                                            GVariant* deletes,
                                            GVariant* inserts,
                                            gpointer* _data);
static void _tracker_resources_unregister_object (gpointer user_data);

static const GDBusArgInfo _tracker_resources_dbus_arg_info_load_uri = {-1, "uri", "s", NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_in[] = {&_tracker_resources_dbus_arg_info_load_uri, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_load = {-1, "Load", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_out), NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_query = {-1, "query", "s", NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_result = {-1, "result", "aas", NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_in[] = {&_tracker_resources_dbus_arg_info_sparql_query_query, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_out[] = {&_tracker_resources_dbus_arg_info_sparql_query_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_query = {-1, "SparqlQuery", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_out), NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_update = {-1, "update", "s", NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update = {-1, "SparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_out), NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_update = {-1, "update", "s", NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_result = {-1, "result", "aaa{ss}", NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_out[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update_blank = {-1, "SparqlUpdateBlank", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_out), NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sync = {-1, "Sync", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_out), NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_batch_sparql_update_update = {-1, "update", "s", NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_batch_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_sparql_update = {-1, "BatchSparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_out), NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_commit = {-1, "BatchCommit", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_out), NULL};
static const GDBusMethodInfo * const _tracker_resources_dbus_method_info[] = {&_tracker_resources_dbus_method_info_load, &_tracker_resources_dbus_method_info_sparql_query, &_tracker_resources_dbus_method_info_sparql_update, &_tracker_resources_dbus_method_info_sparql_update_blank, &_tracker_resources_dbus_method_info_sync, &_tracker_resources_dbus_method_info_batch_sparql_update, &_tracker_resources_dbus_method_info_batch_commit, NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_writeback_subjects = {-1, "subjects", "a{iai}", NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_writeback[] = {&_tracker_resources_dbus_arg_info_writeback_subjects, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_writeback = {-1, "Writeback", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_writeback), NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_classname = {-1, "classname", "s", NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_deletes = {-1, "deletes", "a(iiii)", NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_inserts = {-1, "inserts", "a(iiii)", NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_graph_updated[] = {&_tracker_resources_dbus_arg_info_graph_updated_classname, &_tracker_resources_dbus_arg_info_graph_updated_deletes, &_tracker_resources_dbus_arg_info_graph_updated_inserts, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_graph_updated = {-1, "GraphUpdated", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_graph_updated), NULL};
static const GDBusSignalInfo * const _tracker_resources_dbus_signal_info[] = {&_tracker_resources_dbus_signal_info_writeback, &_tracker_resources_dbus_signal_info_graph_updated, NULL};
static const GDBusPropertyInfo * const _tracker_resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_tracker_resources_dbus_method_info), (GDBusSignalInfo **) (&_tracker_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_resources_dbus_property_info), NULL};
static const GDBusInterfaceVTable _tracker_resources_dbus_interface_vtable = {tracker_resources_dbus_interface_method_call, tracker_resources_dbus_interface_get_property, tracker_resources_dbus_interface_set_property};

static inline gpointer
tracker_resources_get_instance_private (TrackerResources* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerResources_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_tracker_resources_on_emit_signals_tracker_store_signal_emission_func (GHashTable* graph_updated,
                                                                       GHashTable* writeback,
                                                                       gpointer self)
{
	tracker_resources_on_emit_signals ((TrackerResources*) self, graph_updated, writeback);
}

TrackerResources*
tracker_resources_construct (GType object_type,
                             GDBusConnection* connection)
{
	TrackerResources * self = NULL;
	GDBusConnection* _tmp0_;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (TrackerResources*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (connection);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = _tmp0_;
	tracker_store_set_signal_callback (_tracker_resources_on_emit_signals_tracker_store_signal_emission_func, self);
	return self;
}

TrackerResources*
tracker_resources_new (GDBusConnection* connection)
{
	return tracker_resources_construct (TRACKER_TYPE_RESOURCES, connection);
}

static void
tracker_resources_load_data_free (gpointer _data)
{
	TrackerResourcesLoadData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerResourcesLoadData, _data_);
}

void
tracker_resources_load (TrackerResources* self,
                        const char* sender,
                        const gchar* uri,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	TrackerResourcesLoadData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (TrackerResourcesLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp2_;
	tracker_resources_load_co (_data_);
}

void
tracker_resources_load_finish (TrackerResources* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	TrackerResourcesLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tracker_resources_load_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	TrackerResourcesLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_resources_load_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
tracker_resources_load_co (TrackerResourcesLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.Load (uri: '%s')", _data_->uri, NULL);
	_data_->request = _data_->_tmp0_;
	{
		_data_->_tmp1_ = g_file_new_for_uri (_data_->uri);
		_data_->file = _data_->_tmp1_;
		_data_->_tmp2_ = tracker_main_get_sparql_connection ();
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
		_data_->sparql_conn = _data_->_tmp3_;
		_data_->_state_ = 1;
		tracker_store_queue_turtle_import (_data_->sparql_conn, _data_->file, (const gchar*) _data_->sender, tracker_resources_load_ready, _data_);
		return FALSE;
		_state_1:
		tracker_store_queue_turtle_import_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->sparql_conn);
			_g_object_unref0 (_data_->file);
			if (g_error_matches (_data_->_inner_error0_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
				goto __catch0_tracker_db_no_space;
			}
			goto __catch0_g_error;
		}
		tracker_dbus_request_end (_data_->request, NULL);
		_g_object_unref0 (_data_->sparql_conn);
		_g_object_unref0 (_data_->file);
	}
	goto __finally0;
	__catch0_tracker_db_no_space:
	{
		_data_->ie = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->ie;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		_data_->_tmp6_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp5_);
		_data_->_inner_error0_ = _data_->_tmp6_;
		_g_error_free0 (_data_->ie);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->e;
		tracker_dbus_request_end (_data_->request, _data_->_tmp7_);
		_data_->_tmp8_ = _data_->e;
		if (_data_->_tmp8_->domain == TRACKER_SPARQL_ERROR) {
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
			_data_->_inner_error0_ = _data_->_tmp10_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		} else {
			_data_->_tmp11_ = _data_->e;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			_data_->_tmp13_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp12_);
			_data_->_inner_error0_ = _data_->_tmp13_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_resources_sparql_query_data_free (gpointer _data)
{
	TrackerResourcesSparqlQueryData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_free0 (_data_->query);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerResourcesSparqlQueryData, _data_);
}

void
tracker_resources_sparql_query (TrackerResources* self,
                                const char* sender,
                                const gchar* query,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	TrackerResourcesSparqlQueryData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (query != NULL);
	_data_ = g_slice_new0 (TrackerResourcesSparqlQueryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_sparql_query_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = g_strdup (query);
	_g_free0 (_data_->query);
	_data_->query = _tmp2_;
	tracker_resources_sparql_query_co (_data_);
}

GVariant*
tracker_resources_sparql_query_finish (TrackerResources* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GVariant* result;
	TrackerResourcesSparqlQueryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		TrackerResources* self;
		self = _data3_->self;
		_g_variant_builder_unref0 (_data3_->builder);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda13_ (Block3Data* _data3_,
              TrackerSparqlCursor* cursor,
              GError** error)
{
	TrackerResources* self;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	g_return_if_fail (cursor != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		GVariantBuilder* _tmp1_;
		GVariantBuilder* _tmp10_;
		_tmp0_ = tracker_sparql_cursor_next (cursor, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = _data3_->builder;
		g_variant_builder_open (_tmp1_, (const GVariantType*) "as");
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					gint _tmp4_;
					gint _tmp5_;
					const gchar* str = NULL;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					GVariantBuilder* _tmp8_;
					const gchar* _tmp9_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = tracker_sparql_cursor_get_n_columns (cursor);
					_tmp5_ = _tmp4_;
					if (!(i < _tmp5_)) {
						break;
					}
					_tmp6_ = tracker_sparql_cursor_get_string (cursor, i, NULL);
					str = _tmp6_;
					_tmp7_ = str;
					if (_tmp7_ == NULL) {
						str = "";
					}
					_tmp8_ = _data3_->builder;
					_tmp9_ = str;
					g_variant_builder_add (_tmp8_, "s", _tmp9_, NULL);
				}
			}
		}
		_tmp10_ = _data3_->builder;
		g_variant_builder_close (_tmp10_);
	}
}

static void
____lambda13__tracker_store_sparql_query_in_thread (TrackerSparqlCursor* cursor,
                                                    gpointer self,
                                                    GError** error)
{
	___lambda13_ (self, cursor, error);
}

static void
tracker_resources_sparql_query_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	TrackerResourcesSparqlQueryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_resources_sparql_query_co (_data_);
}

static gboolean
tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.SparqlQuery", NULL);
	_data_->request = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->request;
	tracker_dbus_request_debug (_data_->_tmp1_, "query: %s", _data_->query, NULL);
	{
		_data_->_data3_ = g_slice_new0 (Block3Data);
		_data_->_data3_->_ref_count_ = 1;
		_data_->_data3_->self = g_object_ref (_data_->self);
		_data_->_tmp2_ = g_variant_builder_new ((const GVariantType*) "aas");
		_data_->_data3_->builder = _data_->_tmp2_;
		_data_->_tmp3_ = tracker_main_get_sparql_connection ();
		_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
		_data_->sparql_conn = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->sparql_conn;
		_data_->_tmp6_ = _data_->query;
		_data_->_tmp7_ = _data_->sender;
		_data_->_state_ = 1;
		tracker_store_sparql_query (_data_->_tmp5_, _data_->_tmp6_, G_PRIORITY_HIGH, ____lambda13__tracker_store_sparql_query_in_thread, _data_->_data3_, (const gchar*) _data_->_tmp7_, tracker_resources_sparql_query_ready, _data_);
		return FALSE;
		_state_1:
		tracker_store_sparql_query_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->sparql_conn);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->_data3_->builder;
		_data_->_tmp9_ = g_variant_builder_end (_data_->_tmp8_);
		g_variant_ref_sink (_data_->_tmp9_);
		_data_->_result_ = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->_result_;
		if (g_variant_get_size (_data_->_tmp10_) > ((gsize) TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE)) {
			_data_->_tmp11_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "result set of the query is too large");
			_data_->_inner_error0_ = _data_->_tmp11_;
			_g_variant_unref0 (_data_->_result_);
			_g_object_unref0 (_data_->sparql_conn);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			goto __catch0_g_error;
		}
		_data_->_tmp12_ = _data_->request;
		tracker_dbus_request_end (_data_->_tmp12_, NULL);
		_data_->result = _data_->_result_;
		_g_object_unref0 (_data_->sparql_conn);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->request;
		_data_->_tmp14_ = _data_->e;
		tracker_dbus_request_end (_data_->_tmp13_, _data_->_tmp14_);
		_data_->_tmp15_ = _data_->e;
		if (_data_->_tmp15_->domain == TRACKER_SPARQL_ERROR) {
			_data_->_tmp16_ = _data_->e;
			_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
			_data_->_inner_error0_ = _data_->_tmp17_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		} else {
			_data_->_tmp18_ = _data_->e;
			_data_->_tmp19_ = _data_->_tmp18_->message;
			_data_->_tmp20_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp19_);
			_data_->_inner_error0_ = _data_->_tmp20_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_resources_sparql_update_data_free (gpointer _data)
{
	TrackerResourcesSparqlUpdateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_free0 (_data_->update);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerResourcesSparqlUpdateData, _data_);
}

void
tracker_resources_sparql_update (TrackerResources* self,
                                 const char* sender,
                                 const gchar* update,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (update != NULL);
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_sparql_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = g_strdup (update);
	_g_free0 (_data_->update);
	_data_->update = _tmp2_;
	tracker_resources_sparql_update_co (_data_);
}

void
tracker_resources_sparql_update_finish (TrackerResources* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	TrackerResourcesSparqlUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tracker_resources_sparql_update_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_resources_sparql_update_co (_data_);
}

static gboolean
tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.SparqlUpdate", NULL);
	_data_->request = _data_->_tmp0_;
	tracker_dbus_request_debug (_data_->request, "query: %s", _data_->update, NULL);
	{
		_data_->_tmp1_ = tracker_main_get_sparql_connection ();
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->sparql_conn = _data_->_tmp2_;
		_data_->_state_ = 1;
		tracker_store_sparql_update (_data_->sparql_conn, _data_->update, G_PRIORITY_HIGH, (const gchar*) _data_->sender, tracker_resources_sparql_update_ready, _data_);
		return FALSE;
		_state_1:
		tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->sparql_conn);
			if (g_error_matches (_data_->_inner_error0_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
				goto __catch0_tracker_db_no_space;
			}
			goto __catch0_g_error;
		}
		tracker_dbus_request_end (_data_->request, NULL);
		_g_object_unref0 (_data_->sparql_conn);
	}
	goto __finally0;
	__catch0_tracker_db_no_space:
	{
		_data_->ie = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->ie;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		_data_->_tmp5_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp4_);
		_data_->_inner_error0_ = _data_->_tmp5_;
		_g_error_free0 (_data_->ie);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		tracker_dbus_request_end (_data_->request, _data_->_tmp6_);
		_data_->_tmp7_ = _data_->e;
		if (_data_->_tmp7_->domain == TRACKER_SPARQL_ERROR) {
			_data_->_tmp8_ = _data_->e;
			_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
			_data_->_inner_error0_ = _data_->_tmp9_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		} else {
			_data_->_tmp10_ = _data_->e;
			_data_->_tmp11_ = _data_->_tmp10_->message;
			_data_->_tmp12_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp11_);
			_data_->_inner_error0_ = _data_->_tmp12_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_resources_sparql_update_blank_data_free (gpointer _data)
{
	TrackerResourcesSparqlUpdateBlankData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_free0 (_data_->update);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerResourcesSparqlUpdateBlankData, _data_);
}

void
tracker_resources_sparql_update_blank (TrackerResources* self,
                                       const char* sender,
                                       const gchar* update,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateBlankData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (update != NULL);
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateBlankData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_sparql_update_blank_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = g_strdup (update);
	_g_free0 (_data_->update);
	_data_->update = _tmp2_;
	tracker_resources_sparql_update_blank_co (_data_);
}

GVariant*
tracker_resources_sparql_update_blank_finish (TrackerResources* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GVariant* result;
	TrackerResourcesSparqlUpdateBlankData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_resources_sparql_update_blank_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateBlankData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_resources_sparql_update_blank_co (_data_);
}

static gboolean
tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.SparqlUpdateBlank", NULL);
	_data_->request = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->request;
	tracker_dbus_request_debug (_data_->_tmp1_, "query: %s", _data_->update, NULL);
	{
		_data_->_tmp2_ = tracker_main_get_sparql_connection ();
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
		_data_->sparql_conn = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->sparql_conn;
		_data_->_state_ = 1;
		tracker_store_sparql_update_blank (_data_->_tmp4_, _data_->update, G_PRIORITY_HIGH, (const gchar*) _data_->sender, tracker_resources_sparql_update_blank_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = tracker_store_sparql_update_blank_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->variant = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->sparql_conn);
			if (g_error_matches (_data_->_inner_error0_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
				goto __catch0_tracker_db_no_space;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->request;
		tracker_dbus_request_end (_data_->_tmp6_, NULL);
		_data_->result = _data_->variant;
		_g_object_unref0 (_data_->sparql_conn);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_tracker_db_no_space:
	{
		_data_->ie = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->ie;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		_data_->_tmp9_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp8_);
		_data_->_inner_error0_ = _data_->_tmp9_;
		_g_error_free0 (_data_->ie);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->request;
		_data_->_tmp11_ = _data_->e;
		tracker_dbus_request_end (_data_->_tmp10_, _data_->_tmp11_);
		_data_->_tmp12_ = _data_->e;
		if (_data_->_tmp12_->domain == TRACKER_SPARQL_ERROR) {
			_data_->_tmp13_ = _data_->e;
			_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
			_data_->_inner_error0_ = _data_->_tmp14_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		} else {
			_data_->_tmp15_ = _data_->e;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			_data_->_tmp17_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp16_);
			_data_->_inner_error0_ = _data_->_tmp17_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
tracker_resources_sync (TrackerResources* self,
                        const char* sender,
                        GError** error)
{
	TrackerDBusRequest* request = NULL;
	TrackerDBusRequest* _tmp0_;
	TrackerDataManager* data_manager = NULL;
	TrackerDataManager* _tmp1_;
	TrackerDataManager* _tmp2_;
	TrackerData* data = NULL;
	TrackerData* _tmp3_;
	TrackerData* _tmp4_;
	TrackerDirectConnection* sparql_conn = NULL;
	TrackerDirectConnection* _tmp5_;
	TrackerDirectConnection* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = tracker_dbus_request_begin ((const gchar*) sender, "Resources.Sync", NULL);
	request = _tmp0_;
	_tmp1_ = tracker_main_get_data_manager ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	data_manager = _tmp2_;
	_tmp3_ = tracker_data_manager_get_data (data_manager);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	data = _tmp4_;
	_tmp5_ = tracker_main_get_sparql_connection ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	sparql_conn = _tmp6_;
	tracker_direct_connection_sync (sparql_conn);
	tracker_data_sync (data);
	tracker_dbus_request_end (request, NULL);
	_g_object_unref0 (sparql_conn);
	_g_object_unref0 (data);
	_g_object_unref0 (data_manager);
}

static void
tracker_resources_batch_sparql_update_data_free (gpointer _data)
{
	TrackerResourcesBatchSparqlUpdateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_free0 (_data_->update);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerResourcesBatchSparqlUpdateData, _data_);
}

void
tracker_resources_batch_sparql_update (TrackerResources* self,
                                       const char* sender,
                                       const gchar* update,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	TrackerResourcesBatchSparqlUpdateData* _data_;
	TrackerResources* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (update != NULL);
	_data_ = g_slice_new0 (TrackerResourcesBatchSparqlUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_batch_sparql_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = g_strdup (update);
	_g_free0 (_data_->update);
	_data_->update = _tmp2_;
	tracker_resources_batch_sparql_update_co (_data_);
}

void
tracker_resources_batch_sparql_update_finish (TrackerResources* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	TrackerResourcesBatchSparqlUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tracker_resources_batch_sparql_update_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	TrackerResourcesBatchSparqlUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_resources_batch_sparql_update_co (_data_);
}

static gboolean
tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Resources.BatchSparqlUpdate", NULL);
	_data_->request = _data_->_tmp0_;
	tracker_dbus_request_debug (_data_->request, "query: %s", _data_->update, NULL);
	{
		_data_->_tmp1_ = tracker_main_get_sparql_connection ();
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->sparql_conn = _data_->_tmp2_;
		_data_->_state_ = 1;
		tracker_store_sparql_update (_data_->sparql_conn, _data_->update, G_PRIORITY_LOW, (const gchar*) _data_->sender, tracker_resources_batch_sparql_update_ready, _data_);
		return FALSE;
		_state_1:
		tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->sparql_conn);
			if (g_error_matches (_data_->_inner_error0_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
				goto __catch0_tracker_db_no_space;
			}
			goto __catch0_g_error;
		}
		tracker_dbus_request_end (_data_->request, NULL);
		_g_object_unref0 (_data_->sparql_conn);
	}
	goto __finally0;
	__catch0_tracker_db_no_space:
	{
		_data_->ie = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->ie;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		_data_->_tmp5_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp4_);
		_data_->_inner_error0_ = _data_->_tmp5_;
		_g_error_free0 (_data_->ie);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		tracker_dbus_request_end (_data_->request, _data_->_tmp6_);
		_data_->_tmp7_ = _data_->e;
		if (_data_->_tmp7_->domain == TRACKER_SPARQL_ERROR) {
			_data_->_tmp8_ = _data_->e;
			_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
			_data_->_inner_error0_ = _data_->_tmp9_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		} else {
			_data_->_tmp10_ = _data_->e;
			_data_->_tmp11_ = _data_->_tmp10_->message;
			_data_->_tmp12_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp11_);
			_data_->_inner_error0_ = _data_->_tmp12_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
tracker_resources_batch_commit (TrackerResources* self,
                                GError** error)
{
	g_return_if_fail (self != NULL);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		TrackerResources* self;
		self = _data4_->self;
		_g_variant_builder_unref0 (_data4_->builder);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda11_ (Block4Data* _data4_,
             gint graph_id,
             gint subject_id,
             gint pred_id,
             gint object_id)
{
	TrackerResources* self;
	GVariantBuilder* _tmp0_;
	self = _data4_->self;
	_tmp0_ = _data4_->builder;
	g_variant_builder_add (_tmp0_, "(iiii)", graph_id, subject_id, pred_id, object_id, NULL);
}

static void
___lambda11__tracker_event_batch_events_foreach (gint graph_id,
                                                 gint subject_id,
                                                 gint pred_id,
                                                 gint object_id,
                                                 gpointer self)
{
	__lambda11_ (self, graph_id, subject_id, pred_id, object_id);
}

static void
__lambda12_ (Block4Data* _data4_,
             gint graph_id,
             gint subject_id,
             gint pred_id,
             gint object_id)
{
	TrackerResources* self;
	GVariantBuilder* _tmp0_;
	self = _data4_->self;
	_tmp0_ = _data4_->builder;
	g_variant_builder_add (_tmp0_, "(iiii)", graph_id, subject_id, pred_id, object_id, NULL);
}

static void
___lambda12__tracker_event_batch_events_foreach (gint graph_id,
                                                 gint subject_id,
                                                 gint pred_id,
                                                 gint object_id,
                                                 gpointer self)
{
	__lambda12_ (self, graph_id, subject_id, pred_id, object_id);
}

static void
tracker_resources_emit_graph_updated (TrackerResources* self,
                                      TrackerClass* cl,
                                      TrackerEventBatch* events)
{
	Block4Data* _data4_;
	GVariantBuilder* _tmp0_;
	GVariant* deletes = NULL;
	GVariantBuilder* _tmp1_;
	GVariant* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariant* inserts = NULL;
	GVariantBuilder* _tmp4_;
	GVariant* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (events != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
	_data4_->builder = _tmp0_;
	tracker_event_batch_foreach_delete_event (events, ___lambda11__tracker_event_batch_events_foreach, _data4_);
	_tmp1_ = _data4_->builder;
	_tmp2_ = g_variant_builder_end (_tmp1_);
	g_variant_ref_sink (_tmp2_);
	deletes = _tmp2_;
	_tmp3_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
	_g_variant_builder_unref0 (_data4_->builder);
	_data4_->builder = _tmp3_;
	tracker_event_batch_foreach_insert_event (events, ___lambda12__tracker_event_batch_events_foreach, _data4_);
	_tmp4_ = _data4_->builder;
	_tmp5_ = g_variant_builder_end (_tmp4_);
	g_variant_ref_sink (_tmp5_);
	inserts = _tmp5_;
	_tmp6_ = tracker_class_get_uri (cl);
	_tmp7_ = _tmp6_;
	g_signal_emit (self, tracker_resources_signals[TRACKER_RESOURCES_GRAPH_UPDATED_SIGNAL], 0, _tmp7_, deletes, inserts);
	_g_variant_unref0 (inserts);
	_g_variant_unref0 (deletes);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
tracker_resources_emit_writeback (TrackerResources* self,
                                  GHashTable* events)
{
	GVariantBuilder* builder = NULL;
	GVariantBuilder* _tmp0_;
	GHashTableIter wb_iter = {0};
	gint subject_id = 0;
	GArray* types = NULL;
	GVariantBuilder* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = g_variant_builder_new ((const GVariantType*) "a{iai}");
	builder = _tmp0_;
	g_hash_table_iter_init (&wb_iter, events);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		GVariantBuilder* _tmp4_;
		GVariantBuilder* _tmp5_;
		GVariantBuilder* _tmp6_;
		GVariantBuilder* _tmp12_;
		GVariantBuilder* _tmp13_;
		_tmp3_ = g_hash_table_iter_next (&wb_iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		subject_id = _tmp1_;
		types = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = builder;
		g_variant_builder_open (_tmp4_, (const GVariantType*) "{iai}");
		_tmp5_ = builder;
		g_variant_builder_add (_tmp5_, "i", subject_id, NULL);
		_tmp6_ = builder;
		g_variant_builder_open (_tmp6_, (const GVariantType*) "ai");
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					GArray* _tmp9_;
					GVariantBuilder* _tmp10_;
					GArray* _tmp11_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = types;
					if (!(((guint) i) < _tmp9_->len)) {
						break;
					}
					_tmp10_ = builder;
					_tmp11_ = types;
					g_variant_builder_add (_tmp10_, "i", g_array_index (_tmp11_, gint, (guint) i), NULL);
				}
			}
		}
		_tmp12_ = builder;
		g_variant_builder_close (_tmp12_);
		_tmp13_ = builder;
		g_variant_builder_close (_tmp13_);
	}
	_tmp14_ = builder;
	_tmp15_ = g_variant_builder_end (_tmp14_);
	g_variant_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	g_signal_emit (self, tracker_resources_signals[TRACKER_RESOURCES_WRITEBACK_SIGNAL], 0, _tmp16_);
	_g_variant_unref0 (_tmp16_);
	_g_variant_builder_unref0 (builder);
}

static void
tracker_resources_on_emit_signals (TrackerResources* self,
                                   GHashTable* events,
                                   GHashTable* writebacks)
{
	g_return_if_fail (self != NULL);
	if (events != NULL) {
		GHashTableIter iter = {0};
		TrackerEventBatch* class_events = NULL;
		TrackerClass* cl = NULL;
		g_hash_table_iter_init (&iter, events);
		while (TRUE) {
			gconstpointer _tmp0_ = NULL;
			gconstpointer _tmp1_ = NULL;
			gboolean _tmp2_;
			TrackerClass* _tmp3_;
			TrackerEventBatch* _tmp4_;
			_tmp2_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp0_), (gpointer*) (&_tmp1_));
			cl = _tmp0_;
			class_events = _tmp1_;
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = cl;
			_tmp4_ = class_events;
			tracker_resources_emit_graph_updated (self, _tmp3_, _tmp4_);
		}
	}
	if (writebacks != NULL) {
		tracker_resources_emit_writeback (self, writebacks);
	}
}

void
tracker_resources_unreg_batches (TrackerResources* self,
                                 const gchar* old_owner)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_owner != NULL);
	tracker_store_unreg_batches (old_owner);
}

static void
g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), g_value_get_variant (param_values + 3), data2);
}

static void
tracker_resources_class_init (TrackerResourcesClass * klass,
                              gpointer klass_data)
{
	tracker_resources_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TrackerResources_private_offset);
	G_OBJECT_CLASS (klass)->finalize = tracker_resources_finalize;
	tracker_resources_signals[TRACKER_RESOURCES_WRITEBACK_SIGNAL] = g_signal_new ("writeback", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
	tracker_resources_signals[TRACKER_RESOURCES_GRAPH_UPDATED_SIGNAL] = g_signal_new ("graph-updated", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);
}

static void
tracker_resources_instance_init (TrackerResources * self,
                                 gpointer klass)
{
	self->priv = tracker_resources_get_instance_private (self);
}

static void
tracker_resources_finalize (GObject * obj)
{
	TrackerResources * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_RESOURCES, TrackerResources);
	tracker_store_set_signal_callback (NULL, NULL);
	_g_object_unref0 (self->priv->connection);
	G_OBJECT_CLASS (tracker_resources_parent_class)->finalize (obj);
}

static GType
tracker_resources_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerResourcesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_resources_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResources), 0, (GInstanceInitFunc) tracker_resources_instance_init, NULL };
	GType tracker_resources_type_id;
	tracker_resources_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResources", &g_define_type_info, 0);
	g_type_set_qdata (tracker_resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_resources_register_object);
	TrackerResources_private_offset = g_type_add_instance_private (tracker_resources_type_id, sizeof (TrackerResourcesPrivate));
	return tracker_resources_type_id;
}

GType
tracker_resources_get_type (void)
{
	static volatile gsize tracker_resources_type_id__once = 0;
	if (g_once_init_enter (&tracker_resources_type_id__once)) {
		GType tracker_resources_type_id;
		tracker_resources_type_id = tracker_resources_get_type_once ();
		g_once_init_leave (&tracker_resources_type_id__once, tracker_resources_type_id);
	}
	return tracker_resources_type_id__once;
}

static void
_dbus_tracker_resources_load (TrackerResources* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	TrackerResourcesLoadReadyData* _ready_data;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerResourcesLoadReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->uri = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	tracker_resources_load (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->uri, (GAsyncReadyCallback) _dbus_tracker_resources_load_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_resources_load_ready (GObject * source_object,
                                    GAsyncResult * _res_,
                                    gpointer _user_data_)
{
	TrackerResourcesLoadReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	tracker_resources_load_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->uri);
	g_slice_free (TrackerResourcesLoadReadyData, _ready_data);
}

static void
_dbus_tracker_resources_sparql_query (TrackerResources* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	TrackerResourcesSparqlQueryReadyData* _ready_data;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerResourcesSparqlQueryReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->query = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	tracker_resources_sparql_query (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->query, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_query_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_resources_sparql_query_ready (GObject * source_object,
                                            GAsyncResult * _res_,
                                            gpointer _user_data_)
{
	TrackerResourcesSparqlQueryReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = tracker_resources_sparql_query_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->query);
	g_slice_free (TrackerResourcesSparqlQueryReadyData, _ready_data);
}

static void
_dbus_tracker_resources_sparql_update (TrackerResources* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	TrackerResourcesSparqlUpdateReadyData* _ready_data;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerResourcesSparqlUpdateReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->update = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	tracker_resources_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_resources_sparql_update_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	tracker_resources_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->update);
	g_slice_free (TrackerResourcesSparqlUpdateReadyData, _ready_data);
}

static void
_dbus_tracker_resources_sparql_update_blank (TrackerResources* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	TrackerResourcesSparqlUpdateBlankReadyData* _ready_data;
	GVariant* _tmp5_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerResourcesSparqlUpdateBlankReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->update = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	tracker_resources_sparql_update_blank (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_blank_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object,
                                                   GAsyncResult * _res_,
                                                   gpointer _user_data_)
{
	TrackerResourcesSparqlUpdateBlankReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = tracker_resources_sparql_update_blank_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->update);
	g_slice_free (TrackerResourcesSparqlUpdateBlankReadyData, _ready_data);
}

static void
_dbus_tracker_resources_sync (TrackerResources* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	tracker_resources_sync (self, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_tracker_resources_batch_sparql_update (TrackerResources* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	TrackerResourcesBatchSparqlUpdateReadyData* _ready_data;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerResourcesBatchSparqlUpdateReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->update = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	tracker_resources_batch_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->update, (GAsyncReadyCallback) _dbus_tracker_resources_batch_sparql_update_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object,
                                                   GAsyncResult * _res_,
                                                   gpointer _user_data_)
{
	TrackerResourcesBatchSparqlUpdateReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	tracker_resources_batch_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->update);
	g_slice_free (TrackerResourcesBatchSparqlUpdateReadyData, _ready_data);
}

static void
_dbus_tracker_resources_batch_commit (TrackerResources* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	tracker_resources_batch_commit (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
tracker_resources_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Load") == 0) {
		_dbus_tracker_resources_load (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_tracker_resources_sparql_query (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdate") == 0) {
		_dbus_tracker_resources_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdateBlank") == 0) {
		_dbus_tracker_resources_sparql_update_blank (object, parameters, invocation);
	} else if (strcmp (method_name, "Sync") == 0) {
		_dbus_tracker_resources_sync (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchSparqlUpdate") == 0) {
		_dbus_tracker_resources_batch_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchCommit") == 0) {
		_dbus_tracker_resources_batch_commit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
tracker_resources_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
tracker_resources_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_tracker_resources_writeback (GObject* _sender,
                                   GVariant* subjects,
                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, subjects);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "Writeback", _arguments, NULL);
}

static void
_dbus_tracker_resources_graph_updated (GObject* _sender,
                                       const gchar* classname,
                                       GVariant* deletes,
                                       GVariant* inserts,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (classname));
	g_variant_builder_add_value (&_arguments_builder, deletes);
	g_variant_builder_add_value (&_arguments_builder, inserts);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "GraphUpdated", _arguments, NULL);
}

guint
tracker_resources_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_resources_dbus_interface_info), &_tracker_resources_dbus_interface_vtable, data, _tracker_resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "writeback", (GCallback) _dbus_tracker_resources_writeback, data);
	g_signal_connect (object, "graph-updated", (GCallback) _dbus_tracker_resources_graph_updated, data);
	return result;
}

static void
_tracker_resources_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_resources_writeback, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_resources_graph_updated, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

