"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseGenericResponse = exports.generateLockXML = void 0;
var fast_xml_parser_1 = __importStar(require("fast-xml-parser"));
function generateLockXML(ownerHREF) {
    return getParser().parse(namespace({
        lockinfo: {
            "@_xmlns:d": "DAV:",
            lockscope: {
                exclusive: {}
            },
            locktype: {
                write: {}
            },
            owner: {
                href: ownerHREF
            }
        }
    }, "d"));
}
exports.generateLockXML = generateLockXML;
function getParser() {
    return new fast_xml_parser_1.j2xParser({
        attributeNamePrefix: "@_",
        format: true,
        ignoreAttributes: false,
        supressEmptyNode: true
    });
}
function namespace(obj, ns) {
    var copy = __assign({}, obj);
    for (var key in copy) {
        if (!copy.hasOwnProperty(key)) {
            continue;
        }
        if (copy[key] && typeof copy[key] === "object" && key.indexOf(":") === -1) {
            copy["".concat(ns, ":").concat(key)] = namespace(copy[key], ns);
            delete copy[key];
        }
        else if (/^@_/.test(key) === false) {
            copy["".concat(ns, ":").concat(key)] = copy[key];
            delete copy[key];
        }
    }
    return copy;
}
function parseGenericResponse(xml) {
    return fast_xml_parser_1.default.parse(xml, {
        arrayMode: false,
        ignoreNameSpace: true,
        parseAttributeValue: true,
        parseNodeValue: true
    });
}
exports.parseGenericResponse = parseGenericResponse;
