# Microchip AY8930

a backwards-compatible successor to the AY-3-8910, with increased volume resolution, duty cycle control, three envelopes and highly configurable noise generator.

sadly, this soundchip has only ever observed minimal success, and has remained rather obscure since.
it is known for being used in the Covox Sound Master, which didn't sell well either.

while emulation of this chip is mostly complete, hardware comparison hasn't been performed yet due to its scarcity. it also was emulated in a now-abandoned tracker with similar goal as Furnace, which sparked interest on the chip.

# effects

- `12xx`: set channel duty cycle. `xx` is a value between 00 and 08.
  - `00`: 3.125%
  - `01`: 6.25%
  - `02`: 12.5%
  - `03`: 25%
  - `04`: 50%
  - `05`: 75%
  - `06`: 87.5%
  - `07`: 93.75%
  - `08`: 96.875%
- `20xx`: set channel mode. `xx` may be one of the following:
  - `00`: square
  - `01`: noise
  - `02`: square and noise
  - `03`: envelope
  - `04`: envelope and square
  - `05`: envelope and noise
  - `06`: envelope and square and noise
  - `07`: nothing
- `21xx`: set noise frequency. `xx` is a value between 00 and FF.
- `22xy`: set envelope mode.
  - `x` sets the envelope shape, which may be one of the following:
    - `0: \___` decay
    - `4: /___` attack once
    - `8: \\\\` saw
    - `9: \___` decay
    - `A: \/\/` inverse obelisco
    - `B: \¯¯¯` decay once
    - `C: ////` inverse saw
    - `D: /¯¯¯` attack
    - `E: /\/\` obelisco
    - `F: /___` attack once
  - if `y` is 1 then the envelope will affect this channel.
- `23xx`: set envelope period low byte.
- `24xx`: set envelope period high byte.
- `25xx`: slide envelope period up.
- `26xx`: slide envelope period down.
- `27xx`: set noise AND mask.
- `28xx`: set noise OR mask.
- `29xy`: enable auto-envelope mode.
  - in this mode the envelope period is set to the channel's notes, multiplied by a fraction.
  - `x` is the numerator.
  - `y` is the denominator.
  - if `x` or `y` are 0 this will disable auto-envelope mode.
