/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.openstreetmap.josm.data.ImageData;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.data.imagery.street_level.IImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ImageEntry
extends GpxImageEntry
implements IImageEntry<ImageEntry> {
    private Image thumbnail;
    private ImageData dataSet;

    public ImageEntry() {
    }

    public ImageEntry(ImageEntry other) {
        super(other);
        this.thumbnail = other.thumbnail;
        this.dataSet = other.dataSet;
    }

    public ImageEntry(File file) {
        super(file);
    }

    public boolean hasThumbnail() {
        return this.thumbnail != null;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Image thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void loadThumbnail() {
        if (this.thumbnail == null) {
            new ThumbsLoader(Collections.singleton(this)).run();
        }
    }

    @Override
    protected void tmpUpdated() {
        super.tmpUpdated();
        if (this.dataSet != null) {
            this.dataSet.fireNodeMoved(this);
        }
    }

    public void setDataSet(ImageData imageData) {
        this.dataSet = imageData;
    }

    public ImageData getDataSet() {
        return this.dataSet;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.thumbnail, this.dataSet);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageEntry other = (ImageEntry)obj;
        return Objects.equals(this.thumbnail, other.thumbnail) && Objects.equals(this.dataSet, other.dataSet);
    }

    @Override
    public ImageEntry getNextImage() {
        return this.dataSet.getNextImage();
    }

    @Override
    public ImageEntry getPreviousImage() {
        return this.dataSet.getPreviousImage();
    }

    @Override
    public ImageEntry getFirstImage() {
        return this.dataSet.getFirstImage();
    }

    @Override
    public void selectImage(ImageViewerDialog imageViewerDialog, IImageEntry<?> entry) {
        IImageEntry.super.selectImage(imageViewerDialog, entry);
        if (entry instanceof ImageEntry) {
            this.dataSet.setSelectedImage((ImageEntry)entry);
        }
    }

    @Override
    public ImageEntry getLastImage() {
        return this.dataSet.getLastImage();
    }

    @Override
    public boolean isRemoveSupported() {
        return true;
    }

    @Override
    public boolean remove() {
        this.dataSet.removeImage(this, true);
        return true;
    }

    @Override
    public boolean isDeleteSupported() {
        return true;
    }

    @Override
    public boolean delete() {
        return Utils.deleteFile(this.getFile());
    }

    @Override
    public BufferedImage read(Dimension target) throws IOException {
        URL imageUrl = this.getImageUrl();
        Logging.info(I18n.tr("Loading {0}", imageUrl));
        BufferedImage image = ImageProvider.read(imageUrl, false, false, r -> target == null ? r.getDefaultReadParam() : this.withSubsampling((ImageReader)r, target));
        if (image == null) {
            Logging.warn("Unable to load {0}", imageUrl);
            return null;
        }
        Logging.debug("Loaded {0} with dimensions {1}x{2} memoryTaken={3}m exifOrientationSwitchedDimension={4}", imageUrl, image.getWidth(), image.getHeight(), image.getWidth() * image.getHeight() * 4 / 1024 / 1024, ExifReader.orientationSwitchesDimensions(this.getExifOrientation()));
        return this.applyExifRotation(image);
    }

    protected URL getImageUrl() throws MalformedURLException {
        return this.getFile().toURI().toURL();
    }

    private ImageReadParam withSubsampling(ImageReader reader, Dimension target) {
        try {
            ImageReadParam param = reader.getDefaultReadParam();
            Dimension source = new Dimension(reader.getWidth(0), reader.getHeight(0));
            if (source.getWidth() > target.getWidth() || source.getHeight() > target.getHeight()) {
                int subsampling = (int)Math.floor(Math.max(source.getWidth() / target.getWidth(), source.getHeight() / target.getHeight()));
                param.setSourceSubsampling(subsampling, subsampling, 0, 0);
            }
            return param;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private BufferedImage applyExifRotation(BufferedImage img) {
        Integer exifOrientation = this.getExifOrientation();
        if (!ExifReader.orientationNeedsCorrection(exifOrientation)) {
            return img;
        }
        boolean switchesDimensions = ExifReader.orientationSwitchesDimensions(exifOrientation);
        int width = switchesDimensions ? img.getHeight() : img.getWidth();
        int height = switchesDimensions ? img.getWidth() : img.getHeight();
        BufferedImage rotated = new BufferedImage(width, height, 1);
        AffineTransform transform = ExifReader.getRestoreOrientationTransform(exifOrientation, img.getWidth(), img.getHeight());
        Graphics2D g = rotated.createGraphics();
        g.drawImage(img, transform, null);
        g.dispose();
        return rotated;
    }
}

