/* BackgroundManager.c generated by valac 0.56.2, the Vala compiler
 * generated from BackgroundManager.vala, do not modify */

/*
 * Copyright (c) 2011-2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include <glib-object.h>
#include <glib.h>
#include <meta/workspace.h>
#include <float.h>
#include <math.h>
#include <meta/meta-plugin.h>
#include <gio/gio.h>
#include <meta/meta-workspace-manager.h>
#include <meta/display.h>
#include <meta/common.h>
#include <meta/window.h>
#include <meta/boxes.h>
#include <string.h>
#include <stdlib.h>

#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_MINIMIZE_DURATION 200
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_SNAP_DURATION 250
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_WALLPAPER_TRANSITION_DURATION 150
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_WORKSPACE_SWITCH_DURATION 300
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_ACUTANCE_THRESHOLD ((gdouble) 8)
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_STD_THRESHOLD ((gdouble) 45)
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD ((gdouble) 180)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BACKGROUND_STATE_LIGHT,
	BACKGROUND_STATE_DARK,
	BACKGROUND_STATE_MAXIMIZED,
	BACKGROUND_STATE_TRANSLUCENT_DARK,
	BACKGROUND_STATE_TRANSLUCENT_LIGHT
} BackgroundState;

#define TYPE_BACKGROUND_STATE (background_state_get_type ())

#define GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER (greeter_compositor_background_manager_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManager))
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManagerClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER))
#define GREETER_COMPOSITOR_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER))
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManagerClass))

typedef struct _GreeterCompositorBackgroundManager GreeterCompositorBackgroundManager;
typedef struct _GreeterCompositorBackgroundManagerClass GreeterCompositorBackgroundManagerClass;
typedef struct _GreeterCompositorBackgroundManagerPrivate GreeterCompositorBackgroundManagerPrivate;

#define BACKGROUND_UTILS_TYPE_COLOR_INFORMATION (background_utils_color_information_get_type ())
typedef struct _BackgroundUtilsColorInformation BackgroundUtilsColorInformation;
enum  {
	GREETER_COMPOSITOR_BACKGROUND_MANAGER_0_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_MANAGER_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_background_manager_properties[GREETER_COMPOSITOR_BACKGROUND_MANAGER_NUM_PROPERTIES];

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _background_utils_color_information_free0(var) ((var == NULL) ? NULL : (var = (background_utils_color_information_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GreeterCompositorBackgroundManagerUpdateBkColorInfoData GreeterCompositorBackgroundManagerUpdateBkColorInfoData;
enum  {
	GREETER_COMPOSITOR_BACKGROUND_MANAGER_STATE_CHANGED_SIGNAL,
	GREETER_COMPOSITOR_BACKGROUND_MANAGER_NUM_SIGNALS
};
static guint greeter_compositor_background_manager_signals[GREETER_COMPOSITOR_BACKGROUND_MANAGER_NUM_SIGNALS] = {0};

struct _GreeterCompositorBackgroundManager {
	GObject parent_instance;
	GreeterCompositorBackgroundManagerPrivate * priv;
};

struct _GreeterCompositorBackgroundManagerClass {
	GObjectClass parent_class;
};

struct _BackgroundUtilsColorInformation {
	gdouble average_red;
	gdouble average_green;
	gdouble average_blue;
	gdouble mean_luminance;
	gdouble luminance_variance;
	gdouble mean_acutance;
};

struct _GreeterCompositorBackgroundManagerPrivate {
	gint _panel_height;
	MetaWorkspace* current_workspace;
	BackgroundState current_state;
	BackgroundUtilsColorInformation* bk_color_info;
};

struct _Block1Data {
	int _ref_count_;
	GreeterCompositorBackgroundManager* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _GreeterCompositorBackgroundManagerUpdateBkColorInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterCompositorBackgroundManager* self;
	Block1Data* _data1_;
	gint monitor;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaRectangle monitor_geometry;
	GreeterCompositorWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaRectangle _tmp4_;
	GreeterCompositorWindowManager* _tmp5_;
	MetaRectangle _tmp6_;
	gint _tmp7_;
};

static gint GreeterCompositorBackgroundManager_private_offset;
static gpointer greeter_compositor_background_manager_parent_class = NULL;
static GreeterCompositorWindowManager* greeter_compositor_background_manager_wm;
static GreeterCompositorWindowManager* greeter_compositor_background_manager_wm = NULL;

VALA_EXTERN GType background_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType greeter_compositor_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundManager, g_object_unref)
VALA_EXTERN GType background_utils_color_information_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackgroundUtilsColorInformation* background_utils_color_information_dup (const BackgroundUtilsColorInformation* self);
VALA_EXTERN void background_utils_color_information_free (BackgroundUtilsColorInformation* self);
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
VALA_EXTERN GreeterCompositorBackgroundManager* greeter_compositor_background_manager_new (GreeterCompositorWindowManager* _wm,
                                                                               gint panel_height);
VALA_EXTERN GreeterCompositorBackgroundManager* greeter_compositor_background_manager_construct (GType object_type,
                                                                                     GreeterCompositorWindowManager* _wm,
                                                                                     gint panel_height);
static void greeter_compositor_background_manager_connect_signals (GreeterCompositorBackgroundManager* self);
VALA_EXTERN void greeter_compositor_background_manager_update_bk_color_info (GreeterCompositorBackgroundManager* self,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
VALA_EXTERN void greeter_compositor_background_manager_update_bk_color_info_finish (GreeterCompositorBackgroundManager* self,
                                                                        GAsyncResult* _res_);
static void __lambda50_ (GreeterCompositorBackgroundManager* self,
                  GObject* obj,
                  GAsyncResult* res);
static void greeter_compositor_background_manager_update_current_workspace (GreeterCompositorBackgroundManager* self);
static void ___lambda50__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __lambda41_ (GreeterCompositorBackgroundManager* self);
static void ___lambda41__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                             gint object,
                                                             gint p0,
                                                             MetaMotionDirection p1,
                                                             gpointer self);
static void __lambda45_ (GreeterCompositorBackgroundManager* self);
static void __lambda49_ (GreeterCompositorBackgroundManager* self,
                  GObject* obj,
                  GAsyncResult* res);
static void greeter_compositor_background_manager_check_for_state_change (GreeterCompositorBackgroundManager* self,
                                                                   guint animation_duration);
static void ___lambda49__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ___lambda45__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void greeter_compositor_background_manager_on_window_added (GreeterCompositorBackgroundManager* self,
                                                            MetaWindow* window);
static void _greeter_compositor_background_manager_on_window_added_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                                         MetaWindow* object,
                                                                                         gpointer self);
static void greeter_compositor_background_manager_on_window_removed (GreeterCompositorBackgroundManager* self,
                                                              MetaWindow* window);
static void _greeter_compositor_background_manager_on_window_removed_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                                             MetaWindow* object,
                                                                                             gpointer self);
static void greeter_compositor_background_manager_register_window (GreeterCompositorBackgroundManager* self,
                                                            MetaWindow* window);
static void __lambda42_ (GreeterCompositorBackgroundManager* self);
static void ___lambda42__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda43_ (GreeterCompositorBackgroundManager* self);
static void ___lambda43__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda44_ (GreeterCompositorBackgroundManager* self);
static void ___lambda44__meta_window_workspace_changed (MetaWindow* _sender,
                                                 gpointer self);
static void greeter_compositor_background_manager_update_bk_color_info_data_free (gpointer _data);
static gboolean greeter_compositor_background_manager_update_bk_color_info_co (GreeterCompositorBackgroundManagerUpdateBkColorInfoData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _greeter_compositor_background_manager_update_bk_color_info_co_gsource_func (gpointer self);
VALA_EXTERN void background_utils_get_background_color_information (GreeterCompositorWindowManager* wm,
                                                        gint reference_x,
                                                        gint reference_y,
                                                        gint reference_width,
                                                        gint reference_height,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN void background_utils_get_background_color_information_finish (GAsyncResult* _res_,
                                                               BackgroundUtilsColorInformation* result,
                                                               GError** error);
static gint greeter_compositor_background_manager_get_panel_height (GreeterCompositorBackgroundManager* self);
static void __lambda48_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda48__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void greeter_compositor_background_manager_set_panel_height (GreeterCompositorBackgroundManager* self,
                                                             gint value);
static void g_cclosure_user_marshal_VOID__ENUM_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void greeter_compositor_background_manager_finalize (GObject * obj);
static GType greeter_compositor_background_manager_get_type_once (void);
static void _vala_greeter_compositor_background_manager_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_greeter_compositor_background_manager_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);

static GType
background_state_get_type_once (void)
{
	static const GEnumValue values[] = {{BACKGROUND_STATE_LIGHT, "BACKGROUND_STATE_LIGHT", "light"}, {BACKGROUND_STATE_DARK, "BACKGROUND_STATE_DARK", "dark"}, {BACKGROUND_STATE_MAXIMIZED, "BACKGROUND_STATE_MAXIMIZED", "maximized"}, {BACKGROUND_STATE_TRANSLUCENT_DARK, "BACKGROUND_STATE_TRANSLUCENT_DARK", "translucent-dark"}, {BACKGROUND_STATE_TRANSLUCENT_LIGHT, "BACKGROUND_STATE_TRANSLUCENT_LIGHT", "translucent-light"}, {0, NULL, NULL}};
	GType background_state_type_id;
	background_state_type_id = g_enum_register_static ("BackgroundState", values);
	return background_state_type_id;
}

GType
background_state_get_type (void)
{
	static volatile gsize background_state_type_id__once = 0;
	if (g_once_init_enter (&background_state_type_id__once)) {
		GType background_state_type_id;
		background_state_type_id = background_state_get_type_once ();
		g_once_init_leave (&background_state_type_id__once, background_state_type_id);
	}
	return background_state_type_id__once;
}

static inline gpointer
greeter_compositor_background_manager_get_instance_private (GreeterCompositorBackgroundManager* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorBackgroundManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda50_ (GreeterCompositorBackgroundManager* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	greeter_compositor_background_manager_update_bk_color_info_finish (self, res);
	greeter_compositor_background_manager_update_current_workspace (self);
}

static void
___lambda50__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda50_ ((GreeterCompositorBackgroundManager*) self, source_object, res);
	g_object_unref (self);
}

GreeterCompositorBackgroundManager*
greeter_compositor_background_manager_construct (GType object_type,
                                                 GreeterCompositorWindowManager* _wm,
                                                 gint panel_height)
{
	GreeterCompositorBackgroundManager * self = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	g_return_val_if_fail (_wm != NULL, NULL);
	_tmp0_ = _g_object_ref0 (_wm);
	_g_object_unref0 (greeter_compositor_background_manager_wm);
	greeter_compositor_background_manager_wm = _tmp0_;
	self = (GreeterCompositorBackgroundManager*) g_object_new (object_type, "panel-height", panel_height, NULL);
	greeter_compositor_background_manager_connect_signals (self);
	greeter_compositor_background_manager_update_bk_color_info (self, ___lambda50__gasync_ready_callback, g_object_ref (self));
	return self;
}

GreeterCompositorBackgroundManager*
greeter_compositor_background_manager_new (GreeterCompositorWindowManager* _wm,
                                           gint panel_height)
{
	return greeter_compositor_background_manager_construct (GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, _wm, panel_height);
}

static void
__lambda41_ (GreeterCompositorBackgroundManager* self)
{
	greeter_compositor_background_manager_update_current_workspace (self);
}

static void
___lambda41__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                        gint object,
                                                        gint p0,
                                                        MetaMotionDirection p1,
                                                        gpointer self)
{
	__lambda41_ ((GreeterCompositorBackgroundManager*) self);
}

static void
__lambda49_ (GreeterCompositorBackgroundManager* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	greeter_compositor_background_manager_update_bk_color_info_finish (self, res);
	greeter_compositor_background_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_BACKGROUND_MANAGER_WALLPAPER_TRANSITION_DURATION);
}

static void
___lambda49__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda49_ ((GreeterCompositorBackgroundManager*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda45_ (GreeterCompositorBackgroundManager* self)
{
	greeter_compositor_background_manager_update_bk_color_info (self, ___lambda49__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda45__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda45_ ((GreeterCompositorBackgroundManager*) self);
}

static void
greeter_compositor_background_manager_connect_signals (GreeterCompositorBackgroundManager* self)
{
	MetaWorkspaceManager* manager = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	GreeterCompositorWindowManager* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = greeter_compositor_background_manager_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	g_signal_connect_object (manager, "workspace-switched", (GCallback) ___lambda41__meta_workspace_manager_workspace_switched, self, 0);
	_tmp3_ = greeter_compositor_background_manager_wm;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::system-background", (GCallback) ___lambda45__g_object_notify, self, 0);
}

static void
_greeter_compositor_background_manager_on_window_added_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                                    MetaWindow* object,
                                                                                    gpointer self)
{
	greeter_compositor_background_manager_on_window_added ((GreeterCompositorBackgroundManager*) self, object);
}

static void
_greeter_compositor_background_manager_on_window_removed_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                                        MetaWindow* object,
                                                                                        gpointer self)
{
	greeter_compositor_background_manager_on_window_removed ((GreeterCompositorBackgroundManager*) self, object);
}

static void
greeter_compositor_background_manager_update_current_workspace (GreeterCompositorBackgroundManager* self)
{
	MetaWorkspaceManager* manager = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspace* _tmp5_;
	MetaWorkspace* _tmp6_;
	MetaWorkspace* _tmp7_;
	MetaWorkspace* _tmp12_;
	MetaWorkspace* _tmp13_;
	MetaWorkspace* _tmp14_;
	GList* _tmp15_;
	MetaWorkspace* _tmp19_;
	MetaWorkspace* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = greeter_compositor_background_manager_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = manager;
	_tmp4_ = meta_workspace_manager_get_active_workspace (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	workspace = _tmp5_;
	_tmp6_ = workspace;
	if (_tmp6_ == NULL) {
		g_warning ("BackgroundManager.vala:79: Cannot get active workspace");
		_g_object_unref0 (workspace);
		return;
	}
	_tmp7_ = self->priv->current_workspace;
	if (_tmp7_ != NULL) {
		MetaWorkspace* _tmp8_;
		guint _tmp9_;
		MetaWorkspace* _tmp10_;
		guint _tmp11_;
		_tmp8_ = self->priv->current_workspace;
		g_signal_parse_name ("window-added", meta_workspace_get_type (), &_tmp9_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _greeter_compositor_background_manager_on_window_added_meta_workspace_window_added, self);
		_tmp10_ = self->priv->current_workspace;
		g_signal_parse_name ("window-removed", meta_workspace_get_type (), &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _greeter_compositor_background_manager_on_window_removed_meta_workspace_window_removed, self);
	}
	_tmp12_ = workspace;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->current_workspace);
	self->priv->current_workspace = _tmp13_;
	_tmp14_ = self->priv->current_workspace;
	_tmp15_ = meta_workspace_list_windows (_tmp14_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp15_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* _tmp16_;
			MetaWindow* window = NULL;
			_tmp16_ = _g_object_ref0 ((MetaWindow*) window_it->data);
			window = _tmp16_;
			{
				MetaWindow* _tmp17_;
				_tmp17_ = window;
				if (meta_window_is_on_primary_monitor (_tmp17_)) {
					MetaWindow* _tmp18_;
					_tmp18_ = window;
					greeter_compositor_background_manager_register_window (self, _tmp18_);
				}
				_g_object_unref0 (window);
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	_tmp19_ = self->priv->current_workspace;
	g_signal_connect_object (_tmp19_, "window-added", (GCallback) _greeter_compositor_background_manager_on_window_added_meta_workspace_window_added, self, 0);
	_tmp20_ = self->priv->current_workspace;
	g_signal_connect_object (_tmp20_, "window-removed", (GCallback) _greeter_compositor_background_manager_on_window_removed_meta_workspace_window_removed, self, 0);
	greeter_compositor_background_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_BACKGROUND_MANAGER_WORKSPACE_SWITCH_DURATION);
	_g_object_unref0 (workspace);
}

static void
__lambda42_ (GreeterCompositorBackgroundManager* self)
{
	greeter_compositor_background_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_BACKGROUND_MANAGER_SNAP_DURATION);
}

static void
___lambda42__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda42_ ((GreeterCompositorBackgroundManager*) self);
}

static void
__lambda43_ (GreeterCompositorBackgroundManager* self)
{
	greeter_compositor_background_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_BACKGROUND_MANAGER_MINIMIZE_DURATION);
}

static void
___lambda43__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda43_ ((GreeterCompositorBackgroundManager*) self);
}

static void
__lambda44_ (GreeterCompositorBackgroundManager* self)
{
	greeter_compositor_background_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_BACKGROUND_MANAGER_WORKSPACE_SWITCH_DURATION);
}

static void
___lambda44__meta_window_workspace_changed (MetaWindow* _sender,
                                            gpointer self)
{
	__lambda44_ ((GreeterCompositorBackgroundManager*) self);
}

static void
greeter_compositor_background_manager_register_window (GreeterCompositorBackgroundManager* self,
                                                       MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_signal_connect_object ((GObject*) window, "notify::maximized-vertically", (GCallback) ___lambda42__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) window, "notify::minimized", (GCallback) ___lambda43__g_object_notify, self, 0);
	g_signal_connect_object (window, "workspace-changed", (GCallback) ___lambda44__meta_window_workspace_changed, self, 0);
}

static void
greeter_compositor_background_manager_on_window_added (GreeterCompositorBackgroundManager* self,
                                                       MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	greeter_compositor_background_manager_register_window (self, window);
	greeter_compositor_background_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_BACKGROUND_MANAGER_SNAP_DURATION);
}

static void
greeter_compositor_background_manager_on_window_removed (GreeterCompositorBackgroundManager* self,
                                                         MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	greeter_compositor_background_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_BACKGROUND_MANAGER_SNAP_DURATION);
}

static void
greeter_compositor_background_manager_update_bk_color_info_data_free (gpointer _data)
{
	GreeterCompositorBackgroundManagerUpdateBkColorInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GreeterCompositorBackgroundManagerUpdateBkColorInfoData, _data_);
}

void
greeter_compositor_background_manager_update_bk_color_info (GreeterCompositorBackgroundManager* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	GreeterCompositorBackgroundManagerUpdateBkColorInfoData* _data_;
	GreeterCompositorBackgroundManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GreeterCompositorBackgroundManagerUpdateBkColorInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_compositor_background_manager_update_bk_color_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	greeter_compositor_background_manager_update_bk_color_info_co (_data_);
}

void
greeter_compositor_background_manager_update_bk_color_info_finish (GreeterCompositorBackgroundManager* self,
                                                                   GAsyncResult* _res_)
{
	GreeterCompositorBackgroundManagerUpdateBkColorInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GreeterCompositorBackgroundManager* self;
		self = _data1_->self;
		(_data1_->callback_target_destroy_notify == NULL) ? NULL : (_data1_->callback_target_destroy_notify (_data1_->callback_target), NULL);
		_data1_->callback = NULL;
		_data1_->callback_target = NULL;
		_data1_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
_greeter_compositor_background_manager_update_bk_color_info_co_gsource_func (gpointer self)
{
	gboolean result;
	result = greeter_compositor_background_manager_update_bk_color_info_co (self);
	return result;
}

static gpointer
_background_utils_color_information_dup0 (gpointer self)
{
	return self ? background_utils_color_information_dup (self) : NULL;
}

static void
__lambda48_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* res)
{
	GreeterCompositorBackgroundManager* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		BackgroundUtilsColorInformation _tmp0_ = {0};
		BackgroundUtilsColorInformation _tmp1_ = {0};
		BackgroundUtilsColorInformation* _tmp2_;
		background_utils_get_background_color_information_finish (res, &_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _background_utils_color_information_dup0 (&_tmp0_);
		_background_utils_color_information_free0 (self->priv->bk_color_info);
		self->priv->bk_color_info = _tmp2_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("BackgroundManager.vala:137: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		_data1_->callback (_data1_->callback_target);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda48__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda48_ (self, source_object, res);
	block1_data_unref (self);
}

static gboolean
greeter_compositor_background_manager_update_bk_color_info_co (GreeterCompositorBackgroundManagerUpdateBkColorInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_data1_->callback = _greeter_compositor_background_manager_update_bk_color_info_co_gsource_func;
	_data_->_data1_->callback_target = _data_;
	_data_->_data1_->callback_target_destroy_notify = NULL;
	_data_->_tmp0_ = greeter_compositor_background_manager_wm;
	_data_->_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _data_->_tmp0_);
	_data_->monitor = meta_display_get_primary_monitor (_data_->_tmp1_);
	_data_->_tmp2_ = greeter_compositor_background_manager_wm;
	_data_->_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _data_->_tmp2_);
	memset (&_data_->_tmp4_, 0, sizeof (MetaRectangle));
	meta_display_get_monitor_geometry (_data_->_tmp3_, _data_->monitor, &_data_->_tmp4_);
	_data_->monitor_geometry = _data_->_tmp4_;
	_data_->_tmp5_ = greeter_compositor_background_manager_wm;
	_data_->_tmp6_ = _data_->monitor_geometry;
	_data_->_tmp7_ = _data_->self->priv->_panel_height;
	background_utils_get_background_color_information (_data_->_tmp5_, 0, 0, _data_->_tmp6_.width, _data_->_tmp7_, ___lambda48__gasync_ready_callback, block1_data_ref (_data_->_data1_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Check if Wingpanel's background state should change.
     *
     * The state is defined as follows:
     *  - If there's a maximized window, the state should be MAXIMIZED;
     *  - If no information about the background could be gathered, it should be TRANSLUCENT;
     *  - If there's too much contrast or sharpness, it should be TRANSLUCENT;
     *  - If the background is too bright, it should be DARK;
     *  - Else it should be LIGHT.
     */
static void
greeter_compositor_background_manager_check_for_state_change (GreeterCompositorBackgroundManager* self,
                                                              guint animation_duration)
{
	gboolean has_maximized_window = FALSE;
	MetaWorkspace* _tmp0_;
	GList* _tmp1_;
	BackgroundState new_state = 0;
	g_return_if_fail (self != NULL);
	has_maximized_window = FALSE;
	_tmp0_ = self->priv->current_workspace;
	_tmp1_ = meta_workspace_list_windows (_tmp0_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* _tmp2_;
			MetaWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((MetaWindow*) window_it->data);
			window = _tmp2_;
			{
				MetaWindow* _tmp3_;
				_tmp3_ = window;
				if (meta_window_is_on_primary_monitor (_tmp3_)) {
					gboolean _tmp4_ = FALSE;
					MetaWindow* _tmp5_;
					gboolean _tmp6_;
					gboolean _tmp7_;
					_tmp5_ = window;
					g_object_get (_tmp5_, "minimized", &_tmp6_, NULL);
					_tmp7_ = _tmp6_;
					if (!_tmp7_) {
						MetaWindow* _tmp8_;
						gboolean _tmp9_;
						gboolean _tmp10_;
						_tmp8_ = window;
						g_object_get (_tmp8_, "maximized-vertically", &_tmp9_, NULL);
						_tmp10_ = _tmp9_;
						_tmp4_ = _tmp10_;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						has_maximized_window = TRUE;
						_g_object_unref0 (window);
						break;
					}
				}
				_g_object_unref0 (window);
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	if (has_maximized_window) {
		new_state = BACKGROUND_STATE_MAXIMIZED;
	} else {
		BackgroundUtilsColorInformation* _tmp11_;
		_tmp11_ = self->priv->bk_color_info;
		if (_tmp11_ == NULL) {
			new_state = BACKGROUND_STATE_TRANSLUCENT_LIGHT;
		} else {
			gdouble luminance_std = 0.0;
			BackgroundUtilsColorInformation* _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean bg_is_busy = FALSE;
			gboolean bg_is_dark = FALSE;
			BackgroundUtilsColorInformation* _tmp19_;
			gboolean bg_is_busy_dark = FALSE;
			BackgroundUtilsColorInformation* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp12_ = self->priv->bk_color_info;
			luminance_std = sqrt ((*_tmp12_).luminance_variance);
			if (luminance_std > GREETER_COMPOSITOR_BACKGROUND_MANAGER_STD_THRESHOLD) {
				_tmp14_ = TRUE;
			} else {
				gboolean _tmp15_ = FALSE;
				BackgroundUtilsColorInformation* _tmp16_;
				_tmp16_ = self->priv->bk_color_info;
				if ((*_tmp16_).mean_luminance < GREETER_COMPOSITOR_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD) {
					BackgroundUtilsColorInformation* _tmp17_;
					_tmp17_ = self->priv->bk_color_info;
					_tmp15_ = ((*_tmp17_).mean_luminance + (1.645 * luminance_std)) > GREETER_COMPOSITOR_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD;
				} else {
					_tmp15_ = FALSE;
				}
				_tmp14_ = _tmp15_;
			}
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				BackgroundUtilsColorInformation* _tmp18_;
				_tmp18_ = self->priv->bk_color_info;
				_tmp13_ = (*_tmp18_).mean_acutance > GREETER_COMPOSITOR_BACKGROUND_MANAGER_ACUTANCE_THRESHOLD;
			}
			bg_is_busy = _tmp13_;
			_tmp19_ = self->priv->bk_color_info;
			bg_is_dark = (*_tmp19_).mean_luminance > GREETER_COMPOSITOR_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD;
			_tmp20_ = self->priv->bk_color_info;
			bg_is_busy_dark = ((*_tmp20_).mean_luminance * 1.25) > GREETER_COMPOSITOR_BACKGROUND_MANAGER_LUMINANCE_THRESHOLD;
			if (bg_is_busy) {
				_tmp21_ = bg_is_busy_dark;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				new_state = BACKGROUND_STATE_TRANSLUCENT_DARK;
			} else {
				if (bg_is_busy) {
					new_state = BACKGROUND_STATE_TRANSLUCENT_LIGHT;
				} else {
					if (bg_is_dark) {
						new_state = BACKGROUND_STATE_DARK;
					} else {
						new_state = BACKGROUND_STATE_LIGHT;
					}
				}
			}
		}
	}
	if (new_state != self->priv->current_state) {
		self->priv->current_state = new_state;
		g_signal_emit (self, greeter_compositor_background_manager_signals[GREETER_COMPOSITOR_BACKGROUND_MANAGER_STATE_CHANGED_SIGNAL], 0, self->priv->current_state, animation_duration);
	}
}

static gint
greeter_compositor_background_manager_get_panel_height (GreeterCompositorBackgroundManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_panel_height;
	return result;
}

static void
greeter_compositor_background_manager_set_panel_height (GreeterCompositorBackgroundManager* self,
                                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_manager_get_panel_height (self);
	if (old_value != value) {
		self->priv->_panel_height = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_manager_properties[GREETER_COMPOSITOR_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__ENUM_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_UINT) (gpointer data1, gint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
greeter_compositor_background_manager_class_init (GreeterCompositorBackgroundManagerClass * klass,
                                                  gpointer klass_data)
{
	greeter_compositor_background_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorBackgroundManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_background_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_background_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_background_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY, greeter_compositor_background_manager_properties[GREETER_COMPOSITOR_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY] = g_param_spec_int ("panel-height", "panel-height", "panel-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	greeter_compositor_background_manager_signals[GREETER_COMPOSITOR_BACKGROUND_MANAGER_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_UINT, G_TYPE_NONE, 2, TYPE_BACKGROUND_STATE, G_TYPE_UINT);
}

static void
greeter_compositor_background_manager_instance_init (GreeterCompositorBackgroundManager * self,
                                                     gpointer klass)
{
	self->priv = greeter_compositor_background_manager_get_instance_private (self);
	self->priv->current_workspace = NULL;
	self->priv->current_state = BACKGROUND_STATE_LIGHT;
	self->priv->bk_color_info = NULL;
}

static void
greeter_compositor_background_manager_finalize (GObject * obj)
{
	GreeterCompositorBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManager);
	_g_object_unref0 (self->priv->current_workspace);
	_background_utils_color_information_free0 (self->priv->bk_color_info);
	G_OBJECT_CLASS (greeter_compositor_background_manager_parent_class)->finalize (obj);
}

static GType
greeter_compositor_background_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorBackgroundManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_background_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorBackgroundManager), 0, (GInstanceInitFunc) greeter_compositor_background_manager_instance_init, NULL };
	GType greeter_compositor_background_manager_type_id;
	greeter_compositor_background_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorBackgroundManager", &g_define_type_info, 0);
	GreeterCompositorBackgroundManager_private_offset = g_type_add_instance_private (greeter_compositor_background_manager_type_id, sizeof (GreeterCompositorBackgroundManagerPrivate));
	return greeter_compositor_background_manager_type_id;
}

GType
greeter_compositor_background_manager_get_type (void)
{
	static volatile gsize greeter_compositor_background_manager_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_background_manager_type_id__once)) {
		GType greeter_compositor_background_manager_type_id;
		greeter_compositor_background_manager_type_id = greeter_compositor_background_manager_get_type_once ();
		g_once_init_leave (&greeter_compositor_background_manager_type_id__once, greeter_compositor_background_manager_type_id);
	}
	return greeter_compositor_background_manager_type_id__once;
}

static void
_vala_greeter_compositor_background_manager_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	GreeterCompositorBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY:
		g_value_set_int (value, greeter_compositor_background_manager_get_panel_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_background_manager_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	GreeterCompositorBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_BACKGROUND_MANAGER_PANEL_HEIGHT_PROPERTY:
		greeter_compositor_background_manager_set_panel_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

