/* pantheon-files-core.vapi generated by valac 0.56.2, do not modify. */

namespace Files {
	namespace ConnectServer {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class Operation : Gtk.MountOperation {
			public Operation (PF.ConnectServerDialog dialog);
			public override void ask_password (string message, string default_user, string default_domain, GLib.AskPasswordFlags flags);
		}
	}
	namespace FileChanges {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void consume_changes (bool consume_all);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void queue_file_added (GLib.File location);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void queue_file_changed (GLib.File location);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void queue_file_moved (GLib.File from, GLib.File to);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void queue_file_removed (GLib.File location);
	}
	[CCode (cname = "MarlinFileOperations", lower_case_cprefix = "marlin_file_operations_")]
	namespace FileOperations {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class CommonJob {
			protected weak GLib.Cancellable? cancellable;
			protected uint inhibit_cookie;
			protected weak Gtk.Window? parent_window;
			protected PF.Progress.Info progress;
			protected Files.UndoActionData? undo_redo_data;
			protected CommonJob (Gtk.Window? parent_window = null);
			protected bool aborted ();
			protected void inhibit_power_manager (string message);
		}
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class EmptyTrashJob : Files.FileOperations.CommonJob {
			public EmptyTrashJob (Gtk.Window? parent_window = null, owned GLib.List<GLib.File>? trash_dirs = null);
			public async void empty_trash ();
		}
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static async void eject_drive (GLib.Drive drive, Gtk.Window? parent);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static async bool eject_mount (GLib.Mount mount, Gtk.Window? parent);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void empty_trash_for_mount (Gtk.Widget? parent_view, GLib.Mount mount);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<GLib.File> get_trash_dirs_for_mount (GLib.Mount mount);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool has_trash_files (GLib.Mount? mount);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool mount_has_trash (GLib.Mount mount);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void mount_volume (GLib.Volume volume, Gtk.Window? parent_window = null);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static async bool mount_volume_full (GLib.Volume volume, Gtk.Window? parent_window = null);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static async void safely_remove_drive (GLib.Drive drive, Gtk.Window? parent);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static async bool unmount_mount (GLib.Mount mount, Gtk.Window? parent);
	}
	namespace FileUtils {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string CLOSING_COPY_LINK_TAG;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string COPY_TAG;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string LINK_TAG;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string OPENING_COPY_LINK_TAG;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static int compare_modification_dates (GLib.File a, GLib.File b);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string custom_basename_from_file (GLib.File location);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string? escape_uri (string uri, bool allow_utf8 = true, bool allow_single_quote = true);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.DragAction file_accepts_drop (Files.File dest, GLib.List<GLib.File> drop_file_list, Gdk.DragContext context, out Gdk.DragAction suggested_action_return);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<GLib.File> files_from_uris (string uris);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string format_time (int seconds, out int time_unit);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_afp_target_uri (string standard_target_uri, string uri);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_copy_name (string base_name, string suffix, int count, int max_length = -1);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static uint16 get_default_port_for_protocol (string protocol);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_duplicate_name (string name, int count_increment, int max_length, bool is_link = false);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.File? get_file_for_path (string? path);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static uint64 get_file_modification_time (GLib.File file);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_formatted_date_time (GLib.DateTime? dt);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_formatted_time_attribute_from_info (GLib.FileInfo info, string attr);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool get_is_tls_for_protocol (string protocol);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_link_name (string target_name, int count, int max_length = -1);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static int get_max_name_length (GLib.File file_dir);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_parent_path_from_path (string path, bool include_file_protocol = true);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string? get_path_for_symlink (GLib.File file);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void get_rename_region (string filename, out int start_offset, out int end_offset, bool select_all);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_smb_share_from_uri (string uri);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.KeyFile key_file_from_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool location_is_in_trash (GLib.File location);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool make_file_name_valid_for_dest_fs (ref string filename, string? dest_fs_type);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool path_has_parent (string new_path);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool protocol_is_supported (string protocol);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void remove_thumbnail_paths_for_uri (string uri);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void restore_files_from_trash (GLib.List<Files.File> files, Gtk.Widget? widget);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool same_location (string uri_a, string uri_b);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string sanitize_path (string? input_uri, string? input_current_uri = null, bool include_file_protocol = true);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static async GLib.File? set_file_display_name (GLib.File old_location, string new_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string shorten_utf8_string (string base_string, int reduce_by_num_bytes);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static void split_protocol_from_path (string path, out string protocol, out string new_path);
	}
	namespace Plugins {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public abstract class Base {
			public Gtk.Widget window;
			protected Base ();
			public virtual void context_menu (Gtk.Widget widget, GLib.List<Files.File> files);
			public virtual void directory_loaded (Gtk.ApplicationWindow window, Files.AbstractSlot view, Files.File directory);
			public void interface_loaded (Gtk.Widget widget);
			public virtual void sidebar_loaded (Gtk.Widget widget);
			public virtual void update_file_info (Files.File file);
			public virtual void update_sidebar (Gtk.Widget widget);
		}
	}
	namespace View {
		namespace Chrome {
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public class BasicBreadcrumbsEntry : Gtk.Entry, Files.View.Chrome.Navigatable {
				public enum TargetType {
					TEXT_URI_LIST
				}
				protected bool animation_visible;
				protected Gtk.StyleContext button_context;
				protected Gtk.StyleContext button_context_active;
				protected Files.View.Chrome.BreadcrumbElement? clicked_element;
				protected bool context_menu_showing;
				protected string? current_dir_path;
				protected Gee.ArrayList<Files.View.Chrome.BreadcrumbElement> elements;
				protected Gee.Collection<Files.View.Chrome.BreadcrumbElement>? old_elements;
				protected string placeholder;
				protected const int BREAD_SPACING;
				public const int ICON_WIDTH;
				public const double MINIMUM_BREADCRUMB_WIDTH;
				public const double MINIMUM_LOCATION_BAR_ENTRY_WIDTH;
				protected const double YPAD;
				public BasicBreadcrumbsEntry ();
				protected virtual void connect_signals ();
				public override bool draw (Cairo.Context cr);
				public string? get_action_icon_tooltip ();
				public double get_displayed_breadcrumbs_natural_width (out GLib.List<Files.View.Chrome.BreadcrumbElement> displayed_breadcrumbs);
				protected Files.View.Chrome.BreadcrumbElement? get_element_from_coordinates (int x, int y);
				public string get_first_element_icon_name ();
				protected string get_path_from_element (Files.View.Chrome.BreadcrumbElement? el, bool include_file_protocol = true);
				protected virtual void go_down ();
				protected virtual void go_up ();
				public void hide_default_action_icon ();
				protected bool is_icon_event (Gdk.EventButton event);
				protected virtual void on_activate ();
				protected virtual bool on_button_press_event (Gdk.EventButton event);
				protected virtual bool on_button_release_event (Gdk.EventButton event);
				protected virtual void on_entry_text_changed ();
				protected virtual bool on_focus_in (Gdk.EventFocus event);
				protected virtual bool on_focus_out (Gdk.EventFocus event);
				public virtual bool on_key_press_event (Gdk.EventKey event);
				public virtual void reset ();
				public void reset_elements_states ();
				protected virtual void set_default_entry_tooltip ();
				public void set_entry_cursor (string cursor_name);
			}
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public class BasicLocationBar : Gtk.Box, Files.View.Chrome.Locatable {
				protected Gtk.Widget widget;
				public BasicLocationBar (Files.View.Chrome.Navigatable? _bread = null);
				protected virtual bool after_bread_focus_in_event (Gdk.EventFocus event);
				protected virtual bool after_bread_focus_out_event (Gdk.EventFocus event);
				protected virtual void after_bread_text_changed (string txt);
				protected virtual void connect_signals ();
				public override void get_preferred_width (out int minimum_width, out int natural_width);
				protected virtual void hide_navigate_icon ();
				protected virtual void on_bread_action_icon_press ();
				protected virtual void on_bread_activate_path (string path, Files.OpenFlag flag);
				public virtual void set_display_path (string path);
				protected void show_breadcrumbs ();
				protected virtual void show_navigate_icon ();
				protected string displayed_path { get; set; }
				public new bool has_focus { get; }
				public bool with_animation { set; }
			}
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public class BreadcrumbElement : GLib.Object {
				public bool can_shrink;
				public bool display;
				public double display_width;
				public bool hidden;
				public double offset;
				public bool pressed;
				public bool text_is_displayed;
				public double x;
				public BreadcrumbElement (string text_, Gtk.Widget widget_, Gtk.StyleContext button_context);
				public double draw (Cairo.Context cr, double x, double y, double height, Gtk.Widget widget);
				public string get_icon_name ();
				public void set_icon (Files.View.Chrome.BreadcrumbIconInfo icon_info);
				public double natural_width { get; }
				public double real_width { get; }
				public string? text { get; private set; }
				public string? text_for_display { get; set; }
			}
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public class BreadcrumbIconInfo {
				public bool break_loop;
				public string[] exploded;
				public GLib.Icon gicon;
				public int icon_height;
				public int icon_width;
				public string path;
				public bool protocol;
				public string? text_displayed;
				public BreadcrumbIconInfo ();
				public BreadcrumbIconInfo.from_mount (GLib.Mount mount);
				public BreadcrumbIconInfo.protocol_directory (string scheme, string icon_name, string display_name);
				public Gdk.Pixbuf? render_icon (Gtk.StyleContext context);
				public void set_path (string path);
				public BreadcrumbIconInfo.special_directory (string path, string icon_name);
			}
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public class BreadcrumbIconList : GLib.Object {
				public BreadcrumbIconList (Gtk.StyleContext context);
				public void add_mounted_volumes ();
				public unowned Gee.ArrayList<Files.View.Chrome.BreadcrumbIconInfo> get_list ();
				public int length ();
				public void truncate_to_length (int new_length);
				public weak Gtk.StyleContext context { get; construct; }
				public int scale { get; set; }
			}
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public class ButtonWithMenu : Gtk.ToggleButton {
				public enum HMenuPosition {
					LEFT,
					CENTER,
					RIGHT,
					INSIDE_WINDOW
				}
				public enum VMenuPosition {
					TOP,
					BOTTOM
				}
				public ulong toggled_sig_id;
				public ButtonWithMenu ();
				public ButtonWithMenu.from_icon_name (string icon_name, Gtk.IconSize size);
				protected void popdown_menu ();
				protected new void popup_menu (Gdk.EventButton? ev = null);
				public override void show_all ();
				public Files.View.Chrome.ButtonWithMenu.HMenuPosition horizontal_menu_position { get; set; }
				public Gtk.Menu menu { get; set; }
				public Files.View.Chrome.ButtonWithMenu.VMenuPosition vertical_menu_position { get; set; }
				public signal void right_click (Gdk.EventButton ev);
				public signal void slow_press ();
			}
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public class ViewSwitcher : Gtk.Box {
				public ViewSwitcher (GLib.SimpleAction view_mode_action);
				public void set_mode (uint32 mode);
				public GLib.SimpleAction action { get; construct; }
			}
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public interface Locatable : Gtk.Box {
				public abstract string get_display_path ();
				public abstract void set_display_path (string path);
				public abstract bool set_focussed ();
				public signal void path_change_request (string path, Files.OpenFlag flag = Files.OpenFlag.DEFAULT);
			}
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public interface Navigatable : Gtk.Widget {
				public abstract string get_breadcrumbs_path (bool include_file_protocol = true);
				public abstract string get_entry_text ();
				public abstract int get_minimum_width ();
				public abstract void hide_action_icon ();
				public abstract void reset ();
				public abstract void set_action_icon_tooltip (string? tip);
				public virtual void set_animation_visible (bool visible);
				public abstract void set_breadcrumbs_path (string newpath);
				public abstract void set_default_action_icon_tooltip ();
				protected abstract void set_default_entry_tooltip ();
				public abstract void set_entry_text (string? txt);
				public abstract void set_placeholder (string placeholder);
				public abstract void show_default_action_icon ();
				public abstract string? action_icon_name { get; set; }
				public abstract bool hide_breadcrumbs { get; set; }
				public signal void action_icon_press ();
				public signal void activate_path (string path, Files.OpenFlag flag = Files.OpenFlag.DEFAULT);
				public signal void entry_text_changed (string txt);
				public signal void primary_icon_press ();
			}
			[CCode (cheader_filename = "pantheon-files-core.h")]
			public interface Searchable : Gtk.Widget {
				public abstract void cancel ();
				public abstract bool has_popped_up ();
				public abstract void search (string txt, GLib.File search_location);
				public signal void cursor_changed (GLib.File? file);
				public signal void exit (bool exit_navigate = true);
				public signal void file_activated (GLib.File file);
				public signal void file_selected (GLib.File file);
				public signal void first_match_found (GLib.File? file);
			}
		}
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public abstract class AbstractSlot : GLib.Object {
		protected Gtk.Box content_box;
		protected Gtk.Box extra_action_widgets;
		protected Gtk.Box extra_location_widgets;
		protected int width;
		protected AbstractSlot ();
		public void add_extra_action_widget (Gtk.Widget widget);
		public void add_extra_widget (Gtk.Widget widget);
		public void add_overlay (Gtk.Widget widget);
		public abstract void close ();
		public abstract void focus_first_for_empty_selection (bool select);
		public virtual Gtk.Widget get_content_box ();
		public abstract unowned Files.AbstractSlot? get_current_slot ();
		public virtual bool get_realized ();
		public virtual string? get_root_uri ();
		public abstract unowned GLib.List<Files.File>? get_selected_files ();
		public virtual string? get_tip_uri ();
		public abstract void grab_focus ();
		public abstract void initialize_directory ();
		public abstract GLib.FileInfo? lookup_file_info (GLib.File loc);
		protected abstract void make_view ();
		public abstract void reload (bool non_local_only = false);
		public abstract void select_glib_files (GLib.List<GLib.File> locations, GLib.File? focus_location);
		public abstract void set_active_state (bool set_active, bool animate = true);
		public virtual bool set_all_selected (bool all_selected);
		public abstract void user_path_change_request (GLib.File loc, bool make_root);
		public virtual void zoom_in ();
		public virtual void zoom_normal ();
		public virtual void zoom_out ();
		public Files.Directory? directory { get; protected set; }
		public Files.File? file { get; }
		public virtual bool is_frozen { get; set; }
		public GLib.File? location { get; }
		public virtual bool locked_focus { get; }
		public Gtk.Overlay overlay { get; protected set; }
		public int slot_number { get; protected set; }
		public string uri { get; }
		public signal void active (bool scroll = true, bool animate = true);
		public signal void directory_loaded (Files.Directory dir);
		public signal void inactive ();
		public signal void item_hovered (Files.File? file);
		public signal void new_container_request (GLib.File loc, Files.OpenFlag flag);
		public signal void path_changed ();
		public signal void selection_changed (GLib.List<Files.File> files);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Bookmark {
		public static GLib.CompareFunc<Files.Bookmark> compare_with;
		public Bookmark (Files.File gof_file, string label = "");
		public Files.Bookmark copy ();
		public Bookmark.from_uri (string uri, string label = "");
		public GLib.Icon get_icon ();
		public unowned GLib.File get_location ();
		public string get_parse_name ();
		public bool uri_known_not_to_exist ();
		public string basename { get; }
		public string custom_name { get; set; }
		public Files.File gof_file { get; private set; }
		public string uri { get; }
		public signal void contents_changed ();
		public signal void deleted ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class BookmarkList : GLib.Object {
		public bool contains (Files.Bookmark bm);
		public void delete_item_at (uint index);
		public void delete_items_with_uri (string uri);
		public static Files.BookmarkList get_instance ();
		public Files.Bookmark insert_uri (string uri, uint index, string custom_name = "");
		public Files.Bookmark insert_uri_at_end (string uri, string custom_name = "");
		public void insert_uris (GLib.List<string> uris, uint index);
		public unowned Files.Bookmark? item_at (uint index);
		public uint length ();
		public void move_item_uri (string uri, int step);
		public void rename_item_with_uri (string uri, string new_name);
		public weak GLib.List<Files.Bookmark> list { get; private set; }
		public signal void contents_changed ();
		public signal void deleted ();
		public signal void loaded ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class CallWhenReady : GLib.Object {
		public delegate void call_when_ready_func (GLib.List<Files.File> files);
		public GLib.List<Files.File> files;
		public CallWhenReady (GLib.List<Files.File> _files, Files.CallWhenReady.call_when_ready_func? _f = null);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Directory : GLib.Object {
		public enum State {
			NOT_LOADED,
			LOADING,
			LOADED,
			TIMED_OUT
		}
		public delegate void FileLoadedFunc (Files.File file);
		public int icon_size;
		public bool network_available;
		public bool permission_denied;
		public void block_monitor ();
		public static Files.Directory? cache_lookup (GLib.File? file);
		public static Files.Directory? cache_lookup_parent (GLib.File file);
		public void cancel ();
		public async bool check_network ();
		public Files.File file_cache_find_or_insert (GLib.File file, bool update_hash = false);
		public void file_hash_add_file (Files.File gof);
		public Files.File? file_hash_lookup_location (GLib.File? location);
		public static Files.Directory from_file (Files.File gof);
		public static Files.Directory from_gfile (GLib.File file);
		public GLib.List<weak Files.File> get_files ();
		public GLib.File get_parent ();
		public unowned GLib.List<weak Files.File>? get_sorted_dirs ();
		public bool has_parent ();
		public bool has_timed_out ();
		public void init (Files.Directory.FileLoadedFunc? file_loaded_func = null);
		public bool is_empty ();
		public bool is_loaded ();
		public bool is_loading ();
		public void load_hiddens ();
		public static void notify_files_added (GLib.List<GLib.File> files);
		public static void notify_files_changed (GLib.List<GLib.File> files);
		public static void notify_files_moved (GLib.List<GLib.Array<GLib.File>> files);
		public static void notify_files_removed (GLib.List<GLib.File> files);
		public static bool purge_dir_from_cache (Files.Directory dir);
		public void reload ();
		public static bool remove_dir_from_cache (Files.Directory dir);
		public void unblock_monitor ();
		public void update_desktop_files ();
		public void update_files ();
		public bool allow_user_interaction { get; set; }
		public bool can_load { get; private set; }
		public bool can_open_files { get; private set; }
		public bool can_stream_files { get; private set; }
		public GLib.File creation_key { get; construct; }
		public uint displayed_files_count { get; private set; }
		public Files.File file { get; private set; }
		public bool freeze_update { get; set; }
		public bool has_mounts { get; private set; }
		public bool has_trash_dirs { get; private set; }
		public bool is_cancelled { get; }
		public bool is_local { get; private set; }
		public bool is_network { get; private set; }
		public bool is_no_info { get; private set; }
		public bool is_recent { get; private set; }
		public bool is_trash { get; private set; }
		public string last_error_message { get; private set; }
		public bool loaded_from_cache { get; private set; }
		public GLib.File location { get; private set; }
		public string scheme { get; private set; }
		public GLib.File? selected_file { get; private set; }
		public Files.Directory.State state { get; private set; }
		public signal void done_loading ();
		public signal void file_added (Files.File? file);
		public signal void file_changed (Files.File file);
		public signal void file_deleted (Files.File file);
		public signal void file_loaded (Files.File file);
		public signal void icon_changed (Files.File file);
		public signal void need_reload (bool original_request);
		public signal void thumbs_loaded ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class DndHandler : GLib.Object {
		public DndHandler ();
		public static string data_to_string (uchar[] cdata);
		public bool dnd_perform (Gtk.Widget widget, Files.File drop_target, GLib.List<GLib.File> drop_file_list, Gdk.DragAction action);
		public Gdk.DragAction? drag_drop_action_ask (Gtk.Widget dest_widget, Gtk.ApplicationWindow win, Gdk.DragAction possible_actions);
		public string? get_source_filename (Gdk.DragContext context);
		public bool handle_file_drag_actions (Gtk.Widget dest_widget, Gdk.DragContext context, Files.File drop_target, GLib.List<GLib.File> drop_file_list, Gdk.DragAction possible_actions, Gdk.DragAction suggested_action, Gtk.ApplicationWindow win, uint32 timestamp);
		public bool handle_netscape_url (Gdk.DragContext context, Files.File drop_target, Gtk.SelectionData selection);
		public bool handle_xdnddirectsave (Gdk.DragContext context, Files.File drop_target, Gtk.SelectionData selection);
		public void on_choice (GLib.Variant? param);
		public static bool selection_data_is_uri_list (Gtk.SelectionData selection_data, uint info, out string? text);
		public static void set_selection_data_from_file_list (Gtk.SelectionData selection_data, GLib.List<Files.File> file_list, string prefix = "");
		public static void set_selection_text_from_file_list (Gtk.SelectionData selection_data, GLib.List<Files.File> file_list, string prefix = "");
		public void set_source_uri (Gdk.DragContext context, string uri);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class File : GLib.Object {
		public enum IconFlags {
			NONE,
			USE_THUMBNAILS
		}
		public enum ThumbState {
			UNKNOWN,
			NONE,
			READY,
			LOADING
		}
		[CCode (cname = "can_unmount")]
		public bool _can_unmount;
		public int color;
		public string? custom_display_name;
		public string? custom_icon_name;
		public GLib.List<string>? emblems_list;
		public bool exists;
		public GLib.FileType file_type;
		public string format_size;
		public string formated_modified;
		public string formated_type;
		public uint32 gid;
		public string group;
		public bool has_permissions;
		public int height;
		public GLib.Icon? icon;
		public GLib.FileInfo? info;
		public bool is_connected;
		public bool is_desktop;
		public bool is_directory;
		public bool is_expanded;
		public bool is_gone;
		public bool is_hidden;
		public bool is_mounted;
		public bool link_known_target;
		public uint64 modified;
		public GLib.Mount? mount;
		public uint n_emblems;
		public string owner;
		public uint32 permissions;
		public Gdk.Pixbuf? pix;
		public int pix_scale;
		public int pix_size;
		public uint64 size;
		public int sort_column_id;
		public Gtk.SortType sort_order;
		public string tagstype;
		public Files.File target_gof;
		public GLib.File target_location;
		public string thumbnail_path;
		public uint thumbstate;
		public uint32 uid;
		public string? utf8_collation_key;
		public int width;
		public const string GIO_DEFAULT_ATTRIBUTES;
		public File (GLib.File location, GLib.File? dir = null);
		public void add_emblem (string emblem);
		public static Files.File cache_lookup (GLib.File file);
		public bool can_set_group ();
		public bool can_set_owner ();
		public bool can_set_permissions ();
		public bool can_unmount ();
		public int compare_by_display_name (Files.File other);
		public int compare_for_sort (Files.File other, int sort_type, bool directories_first, bool reversed);
		public bool ensure_query_info ();
		public bool execute (GLib.List<GLib.File>? files) throws GLib.Error;
		public new static Files.File @get (GLib.File location);
		public static Files.File? get_by_commandline_arg (string arg);
		public static Files.File? get_by_uri (string uri);
		public GLib.AppInfo? get_default_handler ();
		public unowned string get_display_name ();
		public string get_display_target_uri ();
		public void get_folder_icon_from_uri_or_path ();
		public string? get_formated_time (string attr);
		public unowned string? get_ftype ();
		public Files.IconInfo? get_icon (int size, int scale, Files.File.IconFlags flags);
		public Gdk.Pixbuf? get_icon_pixbuf (int size, int scale, Files.File.IconFlags flags);
		public static GLib.Mount? get_mount_at (GLib.File location);
		public string get_permissions_as_string ();
		public GLib.List<string>? get_settable_group_names ();
		public unowned string? get_symlink_target ();
		public unowned GLib.File get_target_location ();
		public unowned string? get_thumbnail_path ();
		public bool is_desktop_file ();
		public bool is_executable ();
		public bool is_folder ();
		public bool is_image ();
		public bool is_mountable ();
		public bool is_network_uri_scheme ();
		public bool is_other_uri_scheme ();
		public bool is_readable ();
		public bool is_recent_uri_scheme ();
		public bool is_remote_uri_scheme ();
		public bool is_root_network_folder ();
		public bool is_smb_server ();
		public bool is_smb_share ();
		public bool is_smb_uri_scheme ();
		public bool is_symlink ();
		public bool is_trashed ();
		public bool is_writable ();
		public void query_thumbnail_update ();
		public void query_update ();
		public void remove_from_caches ();
		public void set_expanded (bool expanded);
		public void update ();
		public void update_desktop_file ();
		public void update_emblem ();
		public void update_icon (int size, int scale);
		public void update_type ();
		public string basename { get; construct; }
		public GLib.File directory { get; construct; }
		public GLib.File location { get; construct; }
		public string uri { get; construct; }
		public signal void changed ();
		public signal void destroy ();
		public signal void icon_changed ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class FileConflictDialog : Granite.MessageDialog {
		public enum ResponseType {
			SKIP,
			RENAME,
			REPLACE,
			NEWEST
		}
		public FileConflictDialog (Gtk.Window parent, GLib.File _source, GLib.File _destination, GLib.File _dest_dir);
		public bool apply_to_all { get; }
		public string new_name { owned get; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class IconInfo : GLib.Object {
		public IconInfo ();
		public static void clear_caches ();
		public IconInfo.for_icon_info (Gtk.IconInfo icon_info);
		public IconInfo.for_pixbuf (Gdk.Pixbuf? pixbuf);
		public static Files.IconInfo? get_generic_icon (int size, int scale);
		public static Gtk.IconTheme get_icon_theme ();
		public Gdk.Pixbuf? get_pixbuf_nodefault ();
		public bool is_fallback ();
		public static uint loadable_icon_cache_info ();
		public static Files.IconInfo? lookup (GLib.Icon icon, int size, int scale);
		public static Files.IconInfo? lookup_from_name (string icon_name, int size, int scale);
		public static Files.IconInfo? lookup_from_path (string path, int size, int scale);
		public static void remove_cache (string path, int size, int scale);
		public static void set_reap_time (uint milliseconds);
		public static uint themed_icon_cache_info ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class ListModel : Gtk.TreeStore, Gtk.TreeModel {
		public enum ColumnID {
			FILE_COLUMN,
			COLOR,
			PIXBUF,
			FILENAME,
			SIZE,
			TYPE,
			MODIFIED,
			NUM_COLUMNS;
			public static Files.ListModel.ColumnID from_string (string column_id);
			public unowned string to_string ();
		}
		public ListModel ();
		public bool add_file (Files.File file, Files.Directory dir);
		public void file_changed (Files.File file, Files.Directory dir);
		public Files.File? file_for_iter (Gtk.TreeIter iter);
		public Files.File? file_for_path (Gtk.TreePath path);
		public bool get_first_iter_for_file (Files.File file, out Gtk.TreeIter? iter);
		public uint get_length ();
		public bool get_subdirectory (Gtk.TreePath path, out Files.Directory? dir);
		public void load_subdirectory (Files.Directory dir);
		public bool remove_file (Files.File file, Files.Directory dir);
		public void set_should_sort_directories_first (bool sort_directories_first);
		public bool unload_subdirectory (Gtk.TreeIter parent_iter);
		public bool has_child { get; set; }
		public int icon_size { get; set; }
		public bool show_hidden_files { get; set; }
		public signal void subdirectory_unloaded (Files.Directory directory);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class PluginManager : GLib.Object {
		[Version (deprecated = true, deprecated_since = "0.2", replacement = "Files.PluginManager.menuitem_references")]
		public GLib.List<Gtk.Widget>? menus;
		public PluginManager (string plugin_dir, uint user_id);
		public void directory_loaded (Gtk.ApplicationWindow window, Files.AbstractSlot view, Files.File directory);
		public Gee.List<string> get_available_plugins ();
		public void hook_context_menu (Gtk.Widget menu, GLib.List<Files.File> files);
		public void interface_loaded (Gtk.Widget win);
		public void sidebar_loaded (Gtk.Widget widget);
		public void update_file_info (Files.File file);
		public void update_sidebar (Gtk.Widget widget);
		public Gee.List<Gtk.Widget> menuitem_references { get; private set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Preferences : GLib.Object {
		public const string?[] TAGS_COLORS;
		public Preferences ();
		public static Files.Preferences get_default ();
		public string clock_format { get; set; }
		public bool confirm_trash { get; set; }
		public string date_format { get; set; }
		public bool force_icon_size { get; set; }
		public bool hide_local_thumbnails { get; set; }
		public bool remember_history { get; set; }
		public bool show_hidden_files { get; set; }
		public bool show_remote_thumbnails { get; set; }
		public bool sort_directories_first { get; set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class SidebarPluginItem : GLib.Object {
		public const Files.PlaceType PLACE_TYPE;
		public SidebarPluginItem ();
		public GLib.ActionGroup? action_group { get; set; }
		public string? action_group_namespace { get; set; }
		public GLib.Icon? action_icon { get; set; }
		public bool can_eject { get; set; }
		public Files.SidebarCallbackFunc? cb { get; set; }
		public uint64 disk_size { get; set; }
		public GLib.Drive? drive { get; set; }
		public uint64 free_space { get; set; }
		public GLib.Icon? icon { get; set; }
		public uint index { get; set; }
		public GLib.MenuModel? menu_model { get; set; }
		public GLib.Mount? mount { get; set; }
		public string name { get; set; }
		public bool show_spinner { get; set; }
		public string? tooltip { get; set; }
		public string? uri { get; set; }
		public GLib.Volume? volume { get; set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Thumbnailer : GLib.Object {
		public void dequeue (int request);
		public new static Files.Thumbnailer? @get ();
		public bool queue_file (Files.File file, out int request, bool large);
		public bool queue_files (GLib.List<Files.File> files, out int request, bool large);
		public signal void finished (uint request);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class TrashMonitor : GLib.Object {
		public const string URI;
		public TrashMonitor ();
		public static unowned Files.TrashMonitor get_default ();
		public GLib.Icon get_icon ();
		public bool is_empty { get; private set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class UndoActionData {
		public Files.UndoActionType action_type;
		public uint count;
		public uint32 current_permissions;
		public GLib.File dest_dir;
		public GLib.List<string> destinations;
		public uint32 dir_mask;
		public uint32 dir_permissions;
		public uint32 file_mask;
		public uint32 file_permissions;
		public bool freed;
		public bool is_valid;
		public bool locked;
		public string new_group_name_or_id;
		public uint32 new_permissions;
		public string new_uri;
		public string new_user_name_or_id;
		public string old_uri;
		public string original_group_name_or_id;
		public GLib.HashTable<string,uint32?> original_permissions;
		public string original_user_name_or_id;
		public string redo_description;
		public string redo_label;
		public GLib.List<string> sources;
		public GLib.File src_dir;
		public string target_uri;
		public string? template;
		public GLib.HashTable<string,uint64?> trashed;
		public string undo_description;
		public string undo_label;
		public UndoActionData (Files.UndoActionType action_type, int items_count);
		public void add_file_permissions (GLib.File file, uint32 permission);
		public void add_origin_target_pair (GLib.File origin, GLib.File target);
		public void add_trashed_file (GLib.File file, uint64 mtime);
		public void set_create_data (string target_uri, string? template);
		public void set_dest_dir (GLib.File dest);
		public void set_file_permissions (string uri, uint32 current_permissions, uint32 new_permissions);
		public void set_group_change_information (string uri, string current_group, string new_group);
		public void set_owner_change_information (string uri, string current_user, string new_user);
		public void set_recursive_permissions (uint32 file_permissions, uint32 file_mask, uint32 dir_permissions, uint32 dir_mask);
		public void set_rename_information (GLib.File old_file, GLib.File new_file);
		public void set_src_dir (GLib.File src);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class UndoManager : GLib.Object {
		public UndoManager ();
		public void add_action (owned Files.UndoActionData? action);
		public void add_rename_action (GLib.File renamed_file, string original_name);
		public bool can_redo ();
		public bool can_undo ();
		public static unowned Files.UndoManager instance ();
		public async bool redo (Gtk.Widget widget, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void trash_has_emptied ();
		public async bool undo (Gtk.Widget widget, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool confirm_delete { get; set construct; }
		public uint undo_levels { get; set construct; }
		public bool undo_redo_flag { get; private set; }
		public signal void request_menu_update ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public interface SidebarInterface : Gtk.Widget {
		public abstract void add_favorite_uri (string uri, string custom_name = "");
		public abstract uint32 add_plugin_item (Files.SidebarPluginItem item, Files.PlaceType category);
		public abstract bool has_favorite_uri (string uri);
		public abstract void on_free_space_change ();
		public abstract void reload ();
		public abstract bool remove_item_by_id (uint32 item_id);
		public abstract void sync_uri (string uri);
		public abstract bool update_plugin_item (Files.SidebarPluginItem item, uint32 item_id);
		public signal void connect_server_request ();
		public signal void path_change_request (string uri, Files.OpenFlag flag);
		public signal bool request_focus ();
		public signal void request_update ();
		public signal void sync_needed ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	[DBus (name = "org.freedesktop.thumbnails.Thumbnailer1")]
	public interface ThumbnailerDaemon : GLib.DBusProxy {
		public abstract async void dequeue (uint handle) throws GLib.DBusError, GLib.IOError;
		public abstract void get_supported (out string[] uri_schemes, out string[] mime_types) throws GLib.DBusError, GLib.IOError;
		public abstract async uint queue (string[] uris, string[] mime_types, string flavor, string scheduler, uint handle_to_unqueue) throws GLib.DBusError, GLib.IOError;
		public signal void error (uint handle, string[] failed_uris, int error_code, string message);
		public signal void finished (uint handle);
		public signal void ready (uint handle, string[] uris);
		public signal void started (uint handle);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum IconSize {
		EMBLEM,
		SMALLEST,
		LARGE_EMBLEM,
		SMALLER,
		SMALL,
		NORMAL,
		LARGE,
		LARGER,
		HUGE,
		HUGER,
		LARGEST
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum OpenFlag {
		DEFAULT,
		NEW_ROOT,
		NEW_TAB,
		NEW_WINDOW,
		APP
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum PlaceType {
		BUILT_IN,
		MOUNTED_VOLUME,
		BOOKMARK,
		BOOKMARKS_CATEGORY,
		PERSONAL_CATEGORY,
		STORAGE_CATEGORY,
		NETWORK_CATEGORY,
		PLUGIN_ITEM
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum TargetType {
		STRING,
		TEXT_URI_LIST,
		XDND_DIRECT_SAVE0,
		NETSCAPE_URL,
		BOOKMARK_ROW
	}
	[CCode (cheader_filename = "pantheon-files-core.h", cprefix = "MARLIN_UNDO_")]
	public enum UndoActionType {
		COPY,
		DUPLICATE,
		MOVE,
		RENAME,
		CREATEEMPTYFILE,
		CREATEFILEFROMTEMPLATE,
		CREATEFOLDER,
		MOVETOTRASH,
		CREATELINK,
		RESTOREFROMTRASH,
		SETPERMISSIONS,
		RECURSIVESETPERMISSIONS,
		CHANGEOWNER,
		CHANGEGROUP
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum ViewMode {
		ICON,
		LIST,
		MILLER_COLUMNS,
		CURRENT,
		PREFERRED,
		INVALID
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum WindowState {
		NORMAL,
		TILED_START,
		TILED_END,
		MAXIMIZED,
		INVALID;
		public string to_string ();
		public static Files.WindowState from_gdk_window_state (Gdk.WindowState state, bool start = true);
		public bool is_tiled ();
		public bool is_maximized ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum ZoomLevel {
		SMALLEST,
		SMALLER,
		SMALL,
		NORMAL,
		LARGE,
		LARGER,
		HUGE,
		HUGER,
		LARGEST,
		N_LEVELS,
		INVALID;
		public Files.IconSize to_icon_size ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h", has_target = false)]
	public delegate void SidebarCallbackFunc (Gtk.Widget widget);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static Files.Preferences? preferences;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string AFC_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string AFP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string APP_DESKTOP;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string APP_ID;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string APP_TITLE;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string BUG_URL;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const uint BUTTON_LONG_PRESS;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string DAVS_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string DAV_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const int16 DEFAULT_POPUP_MENU_DISPLACEMENT;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string FTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string HELP_URL;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_APP_LOGO;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_DEVICE_CAMERA_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_DEVICE_PHONE_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_DEVICE_REMOVABLE_MEDIA_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FILESYSTEM;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FILESYSTEM_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER_DOCUMENTS_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER_DOWNLOADS_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER_MUSIC_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER_PICTURES_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER_PUBLICSHARE_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER_REMOTE;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER_REMOTE_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER_TEMPLATES_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_FOLDER_VIDEOS_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_GO_HOME_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_HOME;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_NETWORK;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_NETWORK_SERVER;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_NETWORK_SERVER_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_NETWORK_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_PATHBAR_PRIMARY_FIND_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_PATHBAR_SECONDARY_NAVIGATE_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_PATHBAR_SECONDARY_REFRESH_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_PATHBAR_SECONDARY_WORKING_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_RECENT;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_RECENT_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_TRASH;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_TRASH_FULL;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ICON_TRASH_SYMBOLIC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string INVALID_TAB_NAME;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const uint64 LOCATION_BAR_ANIMATION_TIME_USEC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const double MINIMUM_LOCATION_BAR_ENTRY_WIDTH;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string MTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string NETWORK_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string OPEN_IN_TERMINAL_DESKTOP_ID;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_AFC;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_AFP;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_DAV;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_DAVS;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_FILE;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_FTP;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_GPHOTO2;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_MTP;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_NETWORK;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_RECENT;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_SFTP;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_SMB;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PROTOCOL_NAME_TRASH;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string PTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string RECENT_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string ROOT_FS_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string SFTP_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string[] SKIP_IMAGES;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string SMB_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public const string TRASH_URI;
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static string protocol_to_name (string protocol);
}
namespace PF {
	namespace Dialogs {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Granite.MessageDialog show_error_dialog (string primary_text, string secondary_text, Gtk.Window? parent);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Granite.MessageDialog show_warning_dialog (string primary_text, string secondary_text, Gtk.Window? parent);
	}
	namespace PixbufUtils {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.Pixbuf colorize (Gdk.Pixbuf src, Gdk.RGBA color);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.Pixbuf darken (Gdk.Pixbuf src, uint8 saturation, uint8 darken);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.Pixbuf lighten (Gdk.Pixbuf src);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Gdk.Pixbuf lucent (Gdk.Pixbuf src, uint percent);
	}
	namespace Progress {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class Info : GLib.Object {
			public Info ();
			public void cancel ();
			public void finish ();
			public void pause ();
			public void pulse_progress ();
			public void resume ();
			public void start ();
			public void take_details (owned string _details);
			public void take_status (owned string _status);
			public void update_progress (double current, double total);
			public bool activity_mode { get; private set; }
			public GLib.Cancellable cancellable { get; construct; }
			public double current { get; private set; }
			public string details { get; set; }
			public bool is_cancelled { get; }
			public bool is_finished { get; private set; }
			public bool is_paused { get; private set; }
			public bool is_started { get; private set; }
			public double progress { get; private set; }
			public string status { get; private set; }
			public string title { get; set; }
			public double total { get; private set; }
			public signal void changed ();
			public signal void finished ();
			public signal void progress_changed ();
			public signal void started ();
		}
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class InfoManager : GLib.Object {
			public InfoManager ();
			public void add_new_info (PF.Progress.Info info);
			public unowned Gee.LinkedList<PF.Progress.Info> get_all_infos ();
			public static PF.Progress.InfoManager get_instance ();
			public void remove_finished_info (PF.Progress.Info info);
			public signal void new_progress_info (PF.Progress.Info info);
		}
	}
	namespace Sound {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string DELETE;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string EMPTY_TRASH;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public const string THEME;
	}
	namespace UserUtils {
		[CCode (cheader_filename = "pantheon-files-core.h", cname = "NGROUPS_MAX")]
		public const int NGROUPS_MAX;
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<string> get_all_group_names ();
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Posix.uid_t? get_group_id_from_group_name (string group_name);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<string> get_group_names_for_user ();
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Posix.uid_t? get_id_from_digit_string (string digit_string);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static string get_real_user_home ();
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static unowned string? get_user_home_from_user_uid (Posix.uid_t uid);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static Posix.uid_t? get_user_id_from_user_name (string user_name);
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static GLib.List<string> get_user_names ();
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public static bool user_in_group (string group_name);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class ConnectServerDialog : Granite.Dialog {
		public ConnectServerDialog (Gtk.Window window);
		public async bool fill_details_async (GLib.MountOperation mount_operation, string default_user, string default_domain, GLib.AskPasswordFlags askpassword_flags);
		public string server_uri { get; private set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class SoundManager : GLib.Object {
		public static unowned PF.SoundManager get_instance ();
		public void play_delete_sound ();
		public void play_empty_trash_sound ();
		public void play_sound (string pf_sound_id);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static int run_conflict_dialog (Gtk.Window? parent_window, GLib.Timer time, PF.Progress.Info info, GLib.File src, GLib.File dest, GLib.File dest_dir, out string? new_name, out bool apply_to_all);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static int run_error (Gtk.Window? parent_window, GLib.Timer time, PF.Progress.Info info, owned string primary_text, owned string secondary_text, string? details_text, bool show_all, ...);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static int run_question (Gtk.Window? parent_window, GLib.Timer time, PF.Progress.Info info, owned string primary_text, owned string secondary_text, string? details_text, bool show_all, ...);
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static int run_warning (Gtk.Window? parent_window, GLib.Timer time, PF.Progress.Info info, owned string primary_text, owned string secondary_text, string? details_text, bool show_all, ...);
}
namespace Sidebar {
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public interface SidebarItemInterface : Gtk.Widget {
		protected static Gee.HashMap<uint32,Sidebar.SidebarItemInterface> item_id_map;
		protected static GLib.Mutex item_map_lock;
		protected static uint32 row_id;
		public virtual void activated (Files.OpenFlag flag = Files.OpenFlag.DEFAULT);
		public virtual void add_extra_menu_items (PopupMenuBuilder menu_builder);
		public abstract void destroy_bookmark ();
		public abstract int get_index ();
		public static Sidebar.SidebarItemInterface? get_item (uint32 id);
		protected static uint32 get_next_item_id ();
		public virtual void update_icon (GLib.Icon icon);
		public virtual void update_plugin_data (Files.SidebarPluginItem item);
		public abstract GLib.ActionGroup? action_group { get; set; }
		public abstract string? action_group_namespace { get; set; }
		public abstract bool can_insert_after { get; set; }
		public abstract bool can_insert_before { get; set; }
		public abstract string custom_name { get; set; }
		public abstract GLib.Icon gicon { get; set construct; }
		public abstract uint32 id { get; construct; }
		public abstract Sidebar.SidebarListInterface list { get; construct; }
		public abstract GLib.MenuModel? menu_model { get; set; }
		public abstract bool permanent { get; construct; }
		public abstract bool pinned { get; construct; }
		public abstract string uri { get; set construct; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public interface SidebarListInterface : Gtk.Container {
		public virtual bool add_favorite (string uri, string label = "", int index = 0);
		public virtual uint32 add_plugin_item (Files.SidebarPluginItem plugin_item);
		public virtual void clear ();
		public virtual Sidebar.SidebarItemInterface? get_item_at_index (int index);
		public virtual bool has_uri (string uri, out unowned Sidebar.SidebarItemInterface? row = null);
		public virtual bool is_drop_target ();
		public virtual bool move_item_after (Sidebar.SidebarItemInterface item, int target_index);
		public virtual void open_item (Sidebar.SidebarItemInterface item, Files.OpenFlag flag = Files.OpenFlag.DEFAULT);
		public abstract void refresh ();
		public virtual void refresh_info ();
		public virtual void remove_bookmark_by_uri (string uri);
		public virtual bool remove_item_by_id (uint32 id);
		public virtual void rename_bookmark_by_uri (string uri, string new_name);
		public abstract void select_item (Sidebar.SidebarItemInterface? item);
		public virtual bool select_uri (string uri);
		public abstract void unselect_all_items ();
		public abstract Files.SidebarInterface sidebar { get; construct; }
	}
}
[CCode (cheader_filename = "pantheon-files-core.h")]
public class PopupMenuBuilder : GLib.Object {
	public delegate void MenuitemCallback (Gtk.MenuItem menu_item);
	public PopupMenuBuilder ();
	public PopupMenuBuilder add_bookmark (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_drive_property (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_eject_drive (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_empty_all_trash (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_empty_mount_trash (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_item (Gtk.MenuItem menu_item, PopupMenuBuilder.MenuitemCallback? cb = null);
	public PopupMenuBuilder add_mount (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_open (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_open_tab (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_open_window (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_remove (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_rename (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_safely_remove (PopupMenuBuilder.MenuitemCallback cb);
	public PopupMenuBuilder add_separator ();
	public PopupMenuBuilder add_unmount (PopupMenuBuilder.MenuitemCallback cb);
	public Gtk.Menu build ();
	public Gtk.Menu build_from_model (GLib.MenuModel model, string? action_group_namespace = null, GLib.ActionGroup? action_group = null);
	public uint n_items { get; }
}
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string CANCEL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string DELETE;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string SKIP;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string SKIP_ALL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string RETRY;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string DELETE_ALL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string REPLACE;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string REPLACE_ALL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string MERGE;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string MERGE_ALL;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string COPY_FORCE;
[CCode (cheader_filename = "pantheon-files-core.h")]
public const string EMPTY_TRASH;
[CCode (cheader_filename = "pantheon-files-core.h")]
public static Files.PluginManager plugins;
