/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flashcode;

import ext.plantuml.com.google.zxing.BarcodeFormat;
import ext.plantuml.com.google.zxing.EncodeHintType;
import ext.plantuml.com.google.zxing.client.j2se.MatrixToImageWriter;
import ext.plantuml.com.google.zxing.common.BitMatrix;
import ext.plantuml.com.google.zxing.qrcode.QRCodeWriter;
import ext.plantuml.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;

public class FlashCodeUtilsZxing
implements FlashCodeUtils {
    private static final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage exportFlashcode(String s, Color fore, Color back) {
        if (lock.tryLock()) {
            try {
                QRCodeWriter writer = new QRCodeWriter();
                Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                hints.put(EncodeHintType.CHARACTER_SET, "UTF8");
                boolean multiple = true;
                BitMatrix bit = writer.encode(s, BarcodeFormat.QR_CODE, 1, hints);
                BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bit, fore.getRGB() | 0xFF000000, back.getRGB() | 0xFF000000);
                return bufferedImage;
            }
            catch (Exception e) {
                Log.debug("Cannot create qrcode " + e);
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }
}

