/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseQueue
extends AbstractTextualComponent {
    private final TextBlock stickman;
    private final boolean head;

    public ComponentRoseQueue(Style style, Style stereo, Display stringsToDisplay, boolean head, ISkinSimple spriteContainer) {
        super(style, stereo, LineBreakStrategy.NONE, 3, 3, 0, spriteContainer, stringsToDisplay, false);
        SymbolContext biColor = style.getSymbolContext(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        this.head = head;
        this.stickman = USymbols.QUEUE.asSmall(TextBlockUtils.empty(0.0, 0.0), this.getTextBlock(), TextBlockUtils.empty(0.0, 0.0), biColor, HorizontalAlignment.CENTER);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        double delta = (this.getPreferredWidth(stringBounder) - dimStickman.getWidth()) / 2.0;
        ug = ug.apply(UTranslate.dx(delta));
        this.stickman.drawU(ug);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return dimStickman.getHeight();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return dimStickman.getWidth();
    }
}

