# This file has been autogenerated by the pywayland scanner

# Copyright © 2017 Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlSeat
from ..wayland import WlSurface
from .zwp_keyboard_shortcuts_inhibitor_v1 import ZwpKeyboardShortcutsInhibitorV1


class ZwpKeyboardShortcutsInhibitManagerV1(Interface):
    """Context object for keyboard grab_manager

    A global interface used for inhibiting the compositor keyboard shortcuts.
    """

    name = "zwp_keyboard_shortcuts_inhibit_manager_v1"
    version = 1

    class error(enum.IntEnum):
        already_inhibited = 0


class ZwpKeyboardShortcutsInhibitManagerV1Proxy(Proxy[ZwpKeyboardShortcutsInhibitManagerV1]):
    interface = ZwpKeyboardShortcutsInhibitManagerV1

    @ZwpKeyboardShortcutsInhibitManagerV1.request()
    def destroy(self) -> None:
        """Destroy the keyboard shortcuts inhibitor object

        Destroy the keyboard shortcuts inhibitor manager.
        """
        self._marshal(0)
        self._destroy()

    @ZwpKeyboardShortcutsInhibitManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpKeyboardShortcutsInhibitorV1),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Object, interface=WlSeat),
    )
    def inhibit_shortcuts(self, surface: WlSurface, seat: WlSeat) -> Proxy[ZwpKeyboardShortcutsInhibitorV1]:
        """Create a new keyboard shortcuts inhibitor object

        Create a new keyboard shortcuts inhibitor object associated with the
        given surface for the given seat.

        If shortcuts are already inhibited for the specified seat and surface,
        a protocol error "already_inhibited" is raised by the compositor.

        :param surface:
            the surface that inhibits the keyboard shortcuts behavior
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` for which keyboard
            shortcuts should be disabled
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :returns:
            :class:`~pywayland.protocol.keyboard_shortcuts_inhibit_unstable_v1.ZwpKeyboardShortcutsInhibitorV1`
        """
        id = self._marshal_constructor(1, ZwpKeyboardShortcutsInhibitorV1, surface, seat)
        return id


class ZwpKeyboardShortcutsInhibitManagerV1Resource(Resource):
    interface = ZwpKeyboardShortcutsInhibitManagerV1


class ZwpKeyboardShortcutsInhibitManagerV1Global(Global):
    interface = ZwpKeyboardShortcutsInhibitManagerV1


ZwpKeyboardShortcutsInhibitManagerV1._gen_c()
ZwpKeyboardShortcutsInhibitManagerV1.proxy_class = ZwpKeyboardShortcutsInhibitManagerV1Proxy
ZwpKeyboardShortcutsInhibitManagerV1.resource_class = ZwpKeyboardShortcutsInhibitManagerV1Resource
ZwpKeyboardShortcutsInhibitManagerV1.global_class = ZwpKeyboardShortcutsInhibitManagerV1Global
