// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2014 -2022, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code.


// generated by Fast Light User Interface Designer (fluid) version 1.0308

#include "ConfigUI.h"
#include "Misc/SynthEngine.h"
#include "Misc/Bank.h"
#include "MasterUI.h"
#include "Misc/FileMgrFuncs.h"
#include "Misc/NumericFuncs.h"
#include "Misc/TextMsgBuffer.h"

    namespace { // Implementation details...
        TextMsgBuffer& textMsgBuffer = TextMsgBuffer::instance();
    }
extern SynthEngine *firstSynth;

void ConfigUI::cb_configwindow_i(Fl_Double_Window*, void*) {
  close->do_callback();
}
void ConfigUI::cb_configwindow(Fl_Double_Window* o, void* v) {
  ((ConfigUI*)(o->user_data()))->cb_configwindow_i(o,v);
}

void ConfigUI::cb_Tab1_i(Fl_Button*, void*) {
  mainTab->show();
patch1->show();
patch2->hide();
patch3->hide();
patch4->hide();
patch5->hide();
switchesTab->hide();
jackTab->hide();
alsaTab->hide();
midiTab->hide();
}
void ConfigUI::cb_Tab1(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab1_i(o,v);
}

void ConfigUI::cb_Tab2_i(Fl_Button*, void*) {
  switchesTab->show();
patch2->show();
patch1->hide();
patch3->hide();
patch4->hide();
patch5->hide();mainTab->hide();
jackTab->hide();
alsaTab->hide();
midiTab->hide();
}
void ConfigUI::cb_Tab2(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab2_i(o,v);
}

void ConfigUI::cb_Tab3_i(Fl_Button*, void*) {
  jackTab->show();
patch3->show();
patch1->hide();
patch2->hide();
patch4->hide();
patch5->hide();mainTab->hide();
switchesTab->hide();
alsaTab->hide();
midiTab->hide();
}
void ConfigUI::cb_Tab3(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab3_i(o,v);
}

void ConfigUI::cb_Tab4_i(Fl_Button*, void*) {
  alsaTab->show();
patch4->show();
patch1->hide();
patch2->hide();
patch3->hide();
patch5->hide();
mainTab->hide();
switchesTab->hide();
jackTab->hide();
midiTab->hide();
}
void ConfigUI::cb_Tab4(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab4_i(o,v);
}

void ConfigUI::cb_Tab5_i(Fl_Button*, void*) {
  midiTab->show();
patch5->show();
patch1->hide();
patch2->hide();
patch3->hide();
patch4->hide();
mainTab->hide();
switchesTab->hide();
jackTab->hide();
alsaTab->hide();
}
void ConfigUI::cb_Tab5(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab5_i(o,v);
}

void ConfigUI::cb_buff_size_i(Fl_Choice* o, void*) {
  //
                        send_data(0, CONFIG::control::bufferSize, 16 << o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_buff_size(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_buff_size_i(o,v);
}

void ConfigUI::cb_osc_size_i(Fl_Choice* o, void*) {
  //
                        send_data(0, CONFIG::control::oscillatorSize, 256 << o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_osc_size(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_osc_size_i(o,v);
}

void ConfigUI::cb_pad_interpol_i(Fl_Choice* o, void*) {
  //
                        send_data(0, CONFIG::control::padSynthInterpolation, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_pad_interpol(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_pad_interpol_i(o,v);
}

void ConfigUI::cb_handlePadSynthBuild_i(Fl_Choice* o, void*) {
  //
                        send_data(0, CONFIG::control::handlePadSynthBuild, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_handlePadSynthBuild(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_handlePadSynthBuild_i(o,v);
}

void ConfigUI::cb_v_keyboard_i(Fl_Choice* o, void*) {
  //
                        send_data(0, CONFIG::control::virtualKeyboardLayout, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_v_keyboard(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_v_keyboard_i(o,v);
}

void ConfigUI::cb_reports_i(Fl_Choice* o, void*) {
  //
                        send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::reportsDestination, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_reports(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_reports_i(o,v);
}

void ConfigUI::cb_logText_i(Fl_Counter* o, void*) {
  //
                        send_data(0, CONFIG::control::logTextSize, o->value(), TOPLEVEL::type::Integer);
                        synth->getGuiMaster()->yoshiLog->setLogText(o->value());
}
void ConfigUI::cb_logText(Fl_Counter* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_logText_i(o,v);
}

void ConfigUI::cb_compression_i(Fl_Counter* o, void*) {
  //
                        send_data(0, CONFIG::control::XMLcompressionLevel, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_compression(Fl_Counter* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_compression_i(o,v);
}

void ConfigUI::cb_instrument_i(Fl_Choice* o, void*) {
  //
                        send_data(0, CONFIG::control::savedInstrumentFormat, o->value() + 1, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_instrument(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_instrument_i(o,v);
}

void ConfigUI::cb_PanelLayout_i(Fl_Choice* o, void*) {
  //
    int style = 2 - int(o->value());
    synth->getGuiMaster()->changepanelstyle(style);
}
void ConfigUI::cb_PanelLayout(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_PanelLayout_i(o,v);
}

void ConfigUI::cb_bankHighlight_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::enableHighlight, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_bankHighlight(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_bankHighlight_i(o,v);
}

void ConfigUI::cb_nonFatal_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::hideNonFatalErrors, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_nonFatal(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_nonFatal_i(o,v);
}

void ConfigUI::cb_showSplash_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::showSplash, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_showSplash(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_showSplash_i(o,v);
}

void ConfigUI::cb_logXML_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::logXMLheaders, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_logXML(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_logXML_i(o,v);
}

void ConfigUI::cb_logTimes_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::logInstrumentLoadTimes, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_logTimes(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_logTimes_i(o,v);
}

void ConfigUI::cb_saveAllXML_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::saveAllXMLdata, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_saveAllXML(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_saveAllXML_i(o,v);
}

void ConfigUI::cb_enableGUI_i(Fl_Check_Button2* o, void*) {
  //
                        int tmp = o->value();
                        int doit = true;
                        if (tmp == 0)
                            doit = choice(synth, "", "Yes", "No", "Are you sure you want to disable the GUI?\nThis can only be restored via the command line.") > 1;
                        if (doit)
                            send_data(0, CONFIG::control::enableGUI, o->value(), TOPLEVEL::type::Integer);
                        else
                            o->value(1);
}
void ConfigUI::cb_enableGUI(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_enableGUI_i(o,v);
}

void ConfigUI::cb_enableCLI_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::enableCLI, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_enableCLI(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_enableCLI_i(o,v);
}

void ConfigUI::cb_enableAuto_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::enableAutoInstance, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_enableAuto(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_enableAuto_i(o,v);
}

void ConfigUI::cb_singleMaster_i(Fl_Check_Button2* o, void*) {
  //
          send_data(0, CONFIG::control::enableSinglePath, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_singleMaster(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_singleMaster_i(o,v);
}

void ConfigUI::cb_setDefaultState_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::defaultStateStart, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_setDefaultState(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_setDefaultState_i(o,v);
}

void ConfigUI::cb_H_instrument_i(Fl_Check_Button2* o, void*) {
  //
                       send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::Instrument);
}
void ConfigUI::cb_H_instrument(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_instrument_i(o,v);
}

void ConfigUI::cb_H_patchset_i(Fl_Check_Button2* o, void*) {
  //
                       send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::Patch);
}
void ConfigUI::cb_H_patchset(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_patchset_i(o,v);
}

void ConfigUI::cb_H_scale_i(Fl_Check_Button2* o, void*) {
  //
                       send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::Scale);
}
void ConfigUI::cb_H_scale(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_scale_i(o,v);
}

void ConfigUI::cb_H_state_i(Fl_Check_Button2* o, void*) {
  //
                       send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::State);
}
void ConfigUI::cb_H_state(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_state_i(o,v);
}

void ConfigUI::cb_H_vector_i(Fl_Check_Button2* o, void*) {
  //
                       send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::Vector);
}
void ConfigUI::cb_H_vector(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_vector_i(o,v);
}

void ConfigUI::cb_H_mlearn_i(Fl_Check_Button2* o, void*) {
  //
                       send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::MLearn);
}
void ConfigUI::cb_H_mlearn(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_mlearn_i(o,v);
}

void ConfigUI::cb_jackSource_i(Fl_Input* o, void*) {
  //
                        string tmp = string(o->value());
                        send_data(TOPLEVEL::action::lowPrio, CONFIG::control::jackMidiSource, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(tmp));
}
void ConfigUI::cb_jackSource(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_jackSource_i(o,v);
}

void ConfigUI::cb_jackMidi_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::jackPreferredMidi, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_jackMidi(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_jackMidi_i(o,v);
}

void ConfigUI::cb_jackServer_i(Fl_Input* o, void*) {
  //
                        string tmp = string(o->value());
                        send_data(TOPLEVEL::action::lowPrio, CONFIG::control::jackServer, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(tmp));
}
void ConfigUI::cb_jackServer(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_jackServer_i(o,v);
}

void ConfigUI::cb_jackAudio_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::jackPreferredAudio, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_jackAudio(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_jackAudio_i(o,v);
}

void ConfigUI::cb_connectJackAudio_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::jackAutoConnectAudio, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_connectJackAudio(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_connectJackAudio_i(o,v);
}

void ConfigUI::cb_alsaType_i(Fl_Choice* o, void*) {
  if (o->value() == 0) // fixed
    alsaSource->activate();
else
     alsaSource->deactivate();


send_data (0, CONFIG::control::alsaMidiType, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config);
}
void ConfigUI::cb_alsaType(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaType_i(o,v);
}

void ConfigUI::cb_alsaSource_i(Fl_Input* o, void*) {
  //
                        string tmp = string(o->value());
                        send_data(TOPLEVEL::action::lowPrio, CONFIG::control::alsaMidiSource, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(tmp));
}
void ConfigUI::cb_alsaSource(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaSource_i(o,v);
}

void ConfigUI::cb_alsaMidi_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::alsaPreferredMidi, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_alsaMidi(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaMidi_i(o,v);
}

void ConfigUI::cb_alsaDevice_i(Fl_Input* o, void*) {
  //
                        string tmp = string(o->value());
                        send_data(TOPLEVEL::action::lowPrio, CONFIG::control::alsaAudioDevice, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(tmp));
}
void ConfigUI::cb_alsaDevice(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaDevice_i(o,v);
}

void ConfigUI::cb_alsaSamplerate_i(Fl_Choice* o, void*) {
  //
    send_data(0, CONFIG::control::alsaSampleRate, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_alsaSamplerate(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaSamplerate_i(o,v);
}

void ConfigUI::cb_alsaAudio_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::alsaPreferredAudio, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_alsaAudio(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaAudio_i(o,v);
}

void ConfigUI::cb_midiTab_i(Fl_Group*, void*) {
  //
                        EPCvalue = synth->getRuntime().midi_upper_voice_C;
                        if (EPCvalue >= 128)
                        {
                            EPCspinner->value(110);
                            EPCspinner->deactivate();
                        }
                        else
                        {
                            EPCspinner->value(EPCvalue);
                            EPCspinner->activate();
                        }
                        /*BankRootvalue = synth->getRuntime().midi_bank_root;
                        if (BankRootvalue >= 128)
                        {
                            BankRoot->value(0);
                            BankRoot->deactivate();
                        }
                        else
                        {
                            BankRoot->value(BankRootvalue);
                            BankRoot->activate();
                        }*/;
}
void ConfigUI::cb_midiTab(Fl_Group* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->user_data()))->cb_midiTab_i(o,v);
}

void ConfigUI::cb_bankrootchange_i(Fl_Choice* o, void*) {
  //
                        int candidate;
                        switch (o->value())
                        {
                            case 0:
                                candidate = 32;
                                break;
                            case 1:
                                candidate = 0;
                                break;
                            default:
                                candidate = 128;
                                break;
                        }
                        string name = testCC(candidate, CONFIG::control::bankRootCC);
                        if (!name.empty())
                        {
                            o->value(oldBank);
                            o->redraw();
                            switch(oldBank)
                            {
                                case 0:
                                    candidate = 32;
                                    break;
                                case 1:
                                    candidate = 0;
                                    break;
                                default:
                                    candidate = 128;
                                    break;
                            }
                            alert(synth, "In use for " + name);
                        }
                        send_data(0, CONFIG::control::bankRootCC, candidate, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_bankrootchange(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_bankrootchange_i(o,v);
}

void ConfigUI::cb_bankchange_i(Fl_Choice* o, void*) {
  //
                        int candidate;
                        switch (o->value())
                        {
                            case 0:
                                candidate = 32;
                                break;
                            case 1:
                                candidate = 0;
                                break;
                            default:
                                candidate = 128;
                                break;
                        }
                        string name = testCC(candidate, CONFIG::control::bankCC);
                        if (!name.empty())
                        {
                            o->value(oldBank);
                            o->redraw();
                            switch(oldBank)
                            {
                                case 0:
                                    candidate = 32;
                                    break;
                                case 1:
                                    candidate = 0;
                                    break;
                                default:
                                    candidate = 128;
                                    break;
                            }
                            alert(synth, "In use for " + name);
                        }
                        send_data(0, CONFIG::control::bankCC, candidate, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_bankchange(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_bankchange_i(o,v);
}

void ConfigUI::cb_progenable_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::enableProgramChange, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_progenable(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_progenable_i(o,v);
}

void ConfigUI::cb_EPCspinner_i(WidgetSpinner*, void*) {
  //
                        Epend->show();
}
void ConfigUI::cb_EPCspinner(WidgetSpinner* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_EPCspinner_i(o,v);
}

void ConfigUI::cb_Epend_i(Fl_Button* o, void*) {
  //
                        int candidate = EPCspinner->value();
                        if (candidate == EPCvalue)
                        {
                            o->hide();
                            return;
                        }
                        string name = testCC(candidate, CONFIG::control::extendedProgramChangeCC);
                        if (!name.empty())
                        {
                            alert(synth, "In use for " + name);
                            if (EPCvalue < 128)
                            {
                                EPCspinner->value(EPCvalue);
                                EPCspinner->redraw();
                            }
                            return;
                        }
                        EPCvalue = candidate;
                        o->hide();
                        send_data(0, CONFIG::control::extendedProgramChangeCC, EPCvalue, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_Epend(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_Epend_i(o,v);
}

void ConfigUI::cb_Epcheck_i(Fl_Check_Button2* o, void*) {
  // for some weird reason this *must* be the last item in the group
                        if (o->value() == 0)
                        {
                            EPCspinner->value(110);
                            EPCspinner->deactivate();
                            Epend->hide();
                            send_data(0, CONFIG::control::extendedProgramChangeCC, 128, TOPLEVEL::type::Integer);
                        }
                        else
                        {
                            EPCspinner->activate();
                            Epend->show();
                            EPCspinner->value(110);
                            EPCvalue = 128;
                        }
                        EPCspinner->redraw();
}
void ConfigUI::cb_Epcheck(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_Epcheck_i(o,v);
}

void ConfigUI::cb_enableNRPN_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::enableNRPNs, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_enableNRPN(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_enableNRPN_i(o,v);
}

void ConfigUI::cb_ignoreReset_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::ignoreResetAllCCs, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_ignoreReset(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_ignoreReset_i(o,v);
}

void ConfigUI::cb_midiMon_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::logIncomingCCs, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_midiMon(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_midiMon_i(o,v);
}

void ConfigUI::cb_midiLearned_i(Fl_Check_Button2* o, void*) {
  //
                        send_data(0, CONFIG::control::showLearnEditor, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_midiLearned(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_midiLearned_i(o,v);
}

void ConfigUI::cb_close_i(Fl_Button*, void*) {
  //
         configwindow->hide();
         configSeen = false;
         saveWin(synth, configwindow->w(), configwindow->h(),configwindow->x(), configwindow->y(), false, "Config");
}
void ConfigUI::cb_close(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_close_i(o,v);
}

void ConfigUI::cb_save_i(Fl_Button* o, void*) {
  //
         send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, CONFIG::control::saveCurrentConfig, o->value(), TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push("DUMMY"));
         configwindow->hide();
         configSeen = false;
         saveWin(synth, configwindow->w(), configwindow->h(),configwindow->x(), configwindow->y(), false, "Config");
}
void ConfigUI::cb_save(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_save_i(o,v);
}

void ConfigUI::cb_presets_i(Fl_Double_Window*, void*) {
  pClose->do_callback();
}
void ConfigUI::cb_presets(Fl_Double_Window* o, void* v) {
  ((ConfigUI*)(o->user_data()))->cb_presets_i(o,v);
}

void ConfigUI::cb_presetbrowse_i(Fl_Browser* o, void*) {
  //
                    activatebutton_presetdir(o->value() != 0);
}
void ConfigUI::cb_presetbrowse(Fl_Browser* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_presetbrowse_i(o,v);
}

void ConfigUI::cb_addpreset_i(Fl_Button* o, void*) {
  //
                    string dirname = setfiler(synth,"Path for Presets dir", "", false, TOPLEVEL::XML::Dir);
                    if (dirname.length() < 3)
                        return;

                    send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate,CONFIG::control::addPresetRootDir, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(dirname));
                    if (presetbrowse->size() >= MAX_PRESET_DIRS)
                        o->deactivate();
}
void ConfigUI::cb_addpreset(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_addpreset_i(o,v);
}

void ConfigUI::cb_removepresetbutton_i(Fl_Button*, void*) {
  //
                    if (presetbrowse->value() != 0)
                        send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate,CONFIG::control::removePresetRootDir, presetbrowse->value() - 1, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_removepresetbutton(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_removepresetbutton_i(o,v);
}

void ConfigUI::cb_makedefaultpresetbutton_i(Fl_Button*, void*) {
  //
                    send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate,CONFIG::control::currentPresetRoot, presetbrowse->value() - 1, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_makedefaultpresetbutton(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_makedefaultpresetbutton_i(o,v);
}

void ConfigUI::cb_pSave_i(Fl_Button*, void*) {
  //
                    synth->getRuntime().saveConfig();
                    presets->hide();
}
void ConfigUI::cb_pSave(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_pSave_i(o,v);
}

void ConfigUI::cb_pClose_i(Fl_Button*, void*) {
  //
        saveWin(synth, presets->w(), presets->h(), presets->x(), presets->y(), false, "Config-presets");
        presetsSeen = false;
        presets->hide();
}
void ConfigUI::cb_pClose(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_pClose_i(o,v);
}

Fl_Double_Window* ConfigUI::make_window() {
  { Fl_Double_Window* o = configwindow = new Fl_Double_Window(390, 330, "Yoshimi Settings");
    configwindow->callback((Fl_Callback*)cb_configwindow, (void*)(this));
    { Tab1 = new Fl_Button(5, 5, 91, 22, "&Main Settings");
      Tab1->box(FL_THIN_UP_FRAME);
      Tab1->selection_color(FL_DARK1);
      Tab1->labelsize(12);
      Tab1->callback((Fl_Callback*)cb_Tab1);
    } // Fl_Button* Tab1
    { Tab2 = new Fl_Button(98, 5, 66, 22, "&Switches");
      Tab2->box(FL_THIN_UP_FRAME);
      Tab2->selection_color(FL_DARK1);
      Tab2->labelsize(12);
      Tab2->callback((Fl_Callback*)cb_Tab2);
    } // Fl_Button* Tab2
    { Tab3 = new Fl_Button(166, 5, 38, 22, "&Jack");
      Tab3->box(FL_THIN_UP_FRAME);
      Tab3->selection_color(FL_DARK1);
      Tab3->labelsize(12);
      Tab3->callback((Fl_Callback*)cb_Tab3);
    } // Fl_Button* Tab3
    { Tab4 = new Fl_Button(206, 5, 38, 22, "&Alsa");
      Tab4->box(FL_THIN_UP_FRAME);
      Tab4->selection_color(FL_DARK1);
      Tab4->labelsize(12);
      Tab4->callback((Fl_Callback*)cb_Tab4);
    } // Fl_Button* Tab4
    { Tab5 = new Fl_Button(246, 5, 58, 22, "MIDI &CCs");
      Tab5->box(FL_THIN_UP_FRAME);
      Tab5->selection_color(FL_DARK1);
      Tab5->labelsize(12);
      Tab5->callback((Fl_Callback*)cb_Tab5);
    } // Fl_Button* Tab5
    { configTabs = new Fl_Group(5, 5, 385, 298);
      { mainTab = new Fl_Group(5, 25, 382, 277);
        mainTab->box(FL_THIN_UP_BOX);
        mainTab->labelsize(12);
        { Fl_Choice* o = buff_size = new Fl_Choice(245, 34, 105, 20, "* Internal Buffer Size");
          buff_size->tooltip("Number of samples. Smaller has more accurate internal timings but this may ch\
ange some sounds.");
          buff_size->down_box(FL_BORDER_BOX);
          buff_size->labelsize(12);
          buff_size->textfont(1);
          buff_size->textsize(12);
          buff_size->callback((Fl_Callback*)cb_buff_size);
          o->add("16");o->add("32");o->add("64");o->add("128");o->add("256");o->add("512");o->add("1024");o->add("2048");o->add("4096");o->add("8192");
          o->value(func::bitFindHigh(synth->getRuntime().Buffersize) - 4);
          //if (synth->getIsLV2Plugin()) o->deactivate();
        } // Fl_Choice* buff_size
        { Fl_Choice* o = osc_size = new Fl_Choice(245, 58, 105, 20, "* AddSynth Oscillator Size");
          osc_size->tooltip("ADSynth Oscillator Size (samples)");
          osc_size->down_box(FL_BORDER_BOX);
          osc_size->labelsize(12);
          osc_size->textfont(1);
          osc_size->textsize(12);
          osc_size->callback((Fl_Callback*)cb_osc_size);
          o->add("256");o->add("512");o->add("1024");o->add("2048");o->add("4096");o->add("8192");o->add("16384");
          o->value(func::bitFindHigh(synth->getRuntime().Oscilsize) - 8);
        } // Fl_Choice* osc_size
        { Fl_Choice* o = pad_interpol = new Fl_Choice(245, 82, 105, 20, "PadSynth Interpolation");
          pad_interpol->down_box(FL_BORDER_BOX);
          pad_interpol->labelsize(12);
          pad_interpol->textfont(1);
          pad_interpol->textsize(12);
          pad_interpol->callback((Fl_Callback*)cb_pad_interpol);
          o->add("Linear(fast)");o->add("Cubic(slow)");
          o->value(synth->getRuntime().Interpolation);
        } // Fl_Choice* pad_interpol
        { Fl_Choice* o = handlePadSynthBuild = new Fl_Choice(245, 106, 105, 20, "PadSynth Wavetable Build Mode");
          handlePadSynthBuild->tooltip("How to rebuild wavetable after changes: Trigger manually and mute part (legac\
y), build in background and activate when ready, or automatically trigger back\
ground build on each parameter change (expensive)");
          handlePadSynthBuild->down_box(FL_BORDER_BOX);
          handlePadSynthBuild->labelsize(12);
          handlePadSynthBuild->textfont(1);
          handlePadSynthBuild->textsize(12);
          handlePadSynthBuild->callback((Fl_Callback*)cb_handlePadSynthBuild);
          o->add("Muted");o->add("Background");o->add("Auto-Apply");
          o->value(synth->getRuntime().handlePadSynthBuild);
        } // Fl_Choice* handlePadSynthBuild
        { Fl_Choice* o = v_keyboard = new Fl_Choice(245, 130, 105, 20, "Virtual Keyboard Layout");
          v_keyboard->down_box(FL_BORDER_BOX);
          v_keyboard->labelsize(12);
          v_keyboard->textfont(1);
          v_keyboard->textsize(12);
          v_keyboard->callback((Fl_Callback*)cb_v_keyboard);
          o->add("QWERTY");o->add("Dvorak");o->add("QWERTZ");o->add("AZERTY");
          o->value(synth->getRuntime().VirKeybLayout);
        } // Fl_Choice* v_keyboard
        { Fl_Choice* o = reports = new Fl_Choice(200, 178, 150, 20, "Send reports to:");
          reports->tooltip("Some system errors always go to stdout");
          reports->down_box(FL_BORDER_BOX);
          reports->labelsize(12);
          reports->textfont(1);
          reports->textsize(12);
          reports->callback((Fl_Callback*)cb_reports);
          o->add("stdout");o->add("Console Window");
          o->value(synth->getRuntime().toConsole);
        } // Fl_Choice* reports
        { Fl_Counter* o = logText = new Fl_Counter(285, 202, 64, 20, "Console text Size");
          logText->tooltip("Console Font Size");
          logText->type(1);
          logText->labelsize(12);
          logText->minimum(11);
          logText->maximum(100);
          logText->step(1);
          logText->value(12);
          logText->textfont(1);
          logText->textsize(12);
          logText->callback((Fl_Callback*)cb_logText);
          logText->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(synth->getRuntime().consoleTextSize);
          if (synth->getRuntime().toConsole) o->activate(); else o->deactivate();
        } // Fl_Counter* logText
        { Fl_Counter* o = compression = new Fl_Counter(285, 154, 64, 20, "XML Compression Level");
          compression->tooltip("gzip compression level (0 - uncompressed)");
          compression->type(1);
          compression->labelsize(12);
          compression->minimum(0);
          compression->maximum(9);
          compression->step(1);
          compression->textfont(1);
          compression->textsize(12);
          compression->callback((Fl_Callback*)cb_compression);
          compression->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(synth->getRuntime().GzipCompression);
          if (synth->getUniqueId() != 0) o->hide();
        } // Fl_Counter* compression
        { Fl_Choice* o = instrument = new Fl_Choice(200, 226, 150, 20, "Saved Instrument Format");
          instrument->tooltip("Yoshimi format includes Controllers and Humanise");
          instrument->down_box(FL_BORDER_BOX);
          instrument->labelsize(12);
          instrument->textfont(1);
          instrument->textsize(12);
          instrument->callback((Fl_Callback*)cb_instrument);
          o->add("Legacy");o->add("Yoshimi");o->add("Both");
          o->value(synth->getRuntime().instrumentFormat - 1);
        } // Fl_Choice* instrument
        { Fl_Choice* o = PanelLayout = new Fl_Choice(200, 250, 150, 20, "Mixer Panel Layout");
          PanelLayout->tooltip("Select single row or compact format");
          PanelLayout->down_box(FL_BORDER_BOX);
          PanelLayout->labelsize(12);
          PanelLayout->textfont(1);
          PanelLayout->textsize(12);
          PanelLayout->callback((Fl_Callback*)cb_PanelLayout);
          o->add("2 row x 8 entries");o->add("1 row x 16 entries");
          o->value(synth->getRuntime().single_row_panel);
        } // Fl_Choice* PanelLayout
        { Fl_Box* o = settingsNote = new Fl_Box(38, 276, 306, 17, "* Changing these settings requires a restart");
          settingsNote->labelfont(1);
          settingsNote->labelsize(12);
          settingsNote->labelcolor((Fl_Color)38);
          settingsNote->align(Fl_Align(FL_ALIGN_WRAP));
          if (synth->getUniqueId() != 0) o->hide();
        } // Fl_Box* settingsNote
        mainTab->end();
      } // Fl_Group* mainTab
      { switchesTab = new Fl_Group(5, 25, 382, 277);
        switchesTab->box(FL_THIN_UP_BOX);
        switchesTab->labelsize(12);
        switchesTab->hide();
        { Fl_Check_Button2* o = bankHighlight = new Fl_Check_Button2(190, 40, 27, 25, "Enable Bank Highlight");
          bankHighlight->tooltip("Show the last patch fetched from or saved to a bank");
          bankHighlight->box(FL_NO_BOX);
          bankHighlight->down_box(FL_DOWN_BOX);
          bankHighlight->color(FL_BACKGROUND_COLOR);
          bankHighlight->selection_color(FL_FOREGROUND_COLOR);
          bankHighlight->labeltype(FL_NORMAL_LABEL);
          bankHighlight->labelfont(0);
          bankHighlight->labelsize(12);
          bankHighlight->labelcolor(FL_FOREGROUND_COLOR);
          bankHighlight->callback((Fl_Callback*)cb_bankHighlight);
          bankHighlight->align(Fl_Align(FL_ALIGN_LEFT));
          bankHighlight->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().bankHighlight);
        } // Fl_Check_Button2* bankHighlight
        { Fl_Check_Button2* o = nonFatal = new Fl_Check_Button2(190, 60, 27, 25, "Hide Non Fatal Errors");
          nonFatal->box(FL_NO_BOX);
          nonFatal->down_box(FL_DOWN_BOX);
          nonFatal->color(FL_BACKGROUND_COLOR);
          nonFatal->selection_color(FL_FOREGROUND_COLOR);
          nonFatal->labeltype(FL_NORMAL_LABEL);
          nonFatal->labelfont(0);
          nonFatal->labelsize(12);
          nonFatal->labelcolor(FL_FOREGROUND_COLOR);
          nonFatal->callback((Fl_Callback*)cb_nonFatal);
          nonFatal->align(Fl_Align(FL_ALIGN_LEFT));
          nonFatal->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().hideErrors);
          if (synth->getIsLV2Plugin()) o->deactivate();
        } // Fl_Check_Button2* nonFatal
        { Fl_Check_Button2* o = showSplash = new Fl_Check_Button2(190, 80, 27, 25, "Show Splash Screen");
          showSplash->box(FL_NO_BOX);
          showSplash->down_box(FL_DOWN_BOX);
          showSplash->color(FL_BACKGROUND_COLOR);
          showSplash->selection_color(FL_FOREGROUND_COLOR);
          showSplash->labeltype(FL_NORMAL_LABEL);
          showSplash->labelfont(0);
          showSplash->labelsize(12);
          showSplash->labelcolor(FL_FOREGROUND_COLOR);
          showSplash->callback((Fl_Callback*)cb_showSplash);
          showSplash->align(Fl_Align(FL_ALIGN_LEFT));
          showSplash->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().showSplash);
          if (synth->getUniqueId() != 0) o->hide(); else if (synth->getIsLV2Plugin()) o->deactivate();
        } // Fl_Check_Button2* showSplash
        { Fl_Check_Button2* o = logXML = new Fl_Check_Button2(190, 100, 27, 25, "Log XML Headers");
          logXML->box(FL_NO_BOX);
          logXML->down_box(FL_DOWN_BOX);
          logXML->color(FL_BACKGROUND_COLOR);
          logXML->selection_color(FL_FOREGROUND_COLOR);
          logXML->labeltype(FL_NORMAL_LABEL);
          logXML->labelfont(0);
          logXML->labelsize(12);
          logXML->labelcolor(FL_FOREGROUND_COLOR);
          logXML->callback((Fl_Callback*)cb_logXML);
          logXML->align(Fl_Align(FL_ALIGN_LEFT));
          logXML->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().logXMLheaders);
          if (synth->getIsLV2Plugin()) o->deactivate();
        } // Fl_Check_Button2* logXML
        { Fl_Check_Button2* o = logTimes = new Fl_Check_Button2(190, 120, 27, 25, "Log Load times");
          logTimes->box(FL_NO_BOX);
          logTimes->down_box(FL_DOWN_BOX);
          logTimes->color(FL_BACKGROUND_COLOR);
          logTimes->selection_color(FL_FOREGROUND_COLOR);
          logTimes->labeltype(FL_NORMAL_LABEL);
          logTimes->labelfont(0);
          logTimes->labelsize(12);
          logTimes->labelcolor(FL_FOREGROUND_COLOR);
          logTimes->callback((Fl_Callback*)cb_logTimes);
          logTimes->align(Fl_Align(FL_ALIGN_LEFT));
          logTimes->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().showTimes);
        } // Fl_Check_Button2* logTimes
        { Fl_Check_Button2* o = saveAllXML = new Fl_Check_Button2(190, 140, 27, 25, "Retain all Data");
          saveAllXML->tooltip("Include all data in XML files, even inactive settings");
          saveAllXML->box(FL_NO_BOX);
          saveAllXML->down_box(FL_DOWN_BOX);
          saveAllXML->color(FL_BACKGROUND_COLOR);
          saveAllXML->selection_color(FL_FOREGROUND_COLOR);
          saveAllXML->labeltype(FL_NORMAL_LABEL);
          saveAllXML->labelfont(0);
          saveAllXML->labelsize(12);
          saveAllXML->labelcolor(FL_FOREGROUND_COLOR);
          saveAllXML->callback((Fl_Callback*)cb_saveAllXML);
          saveAllXML->align(Fl_Align(FL_ALIGN_LEFT));
          saveAllXML->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().xmlmax);
        } // Fl_Check_Button2* saveAllXML
        { Fl_Check_Button2* o = enableGUI = new Fl_Check_Button2(190, 160, 27, 25, "* Enable GUI");
          enableGUI->tooltip("Enable starting with this graphical interface");
          enableGUI->box(FL_NO_BOX);
          enableGUI->down_box(FL_DOWN_BOX);
          enableGUI->color(FL_BACKGROUND_COLOR);
          enableGUI->selection_color(FL_FOREGROUND_COLOR);
          enableGUI->labeltype(FL_NORMAL_LABEL);
          enableGUI->labelfont(0);
          enableGUI->labelsize(12);
          enableGUI->labelcolor(FL_FOREGROUND_COLOR);
          enableGUI->callback((Fl_Callback*)cb_enableGUI);
          enableGUI->align(Fl_Align(FL_ALIGN_LEFT));
          enableGUI->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().showGui);
          if (synth->getUniqueId() != 0) o->hide(); else if (synth->getIsLV2Plugin()) o->deactivate();
        } // Fl_Check_Button2* enableGUI
        { Fl_Check_Button2* o = enableCLI = new Fl_Check_Button2(190, 180, 27, 25, "* Enable CLI");
          enableCLI->tooltip("Enable starting with interactive command line interface");
          enableCLI->box(FL_NO_BOX);
          enableCLI->down_box(FL_DOWN_BOX);
          enableCLI->color(FL_BACKGROUND_COLOR);
          enableCLI->selection_color(FL_FOREGROUND_COLOR);
          enableCLI->labeltype(FL_NORMAL_LABEL);
          enableCLI->labelfont(0);
          enableCLI->labelsize(12);
          enableCLI->labelcolor(FL_FOREGROUND_COLOR);
          enableCLI->callback((Fl_Callback*)cb_enableCLI);
          enableCLI->align(Fl_Align(FL_ALIGN_LEFT));
          enableCLI->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().showCli);
          if (synth->getUniqueId() != 0) o->hide(); else if (synth->getIsLV2Plugin()) o->deactivate();
        } // Fl_Check_Button2* enableCLI
        { Fl_Check_Button2* o = enableAuto = new Fl_Check_Button2(190, 200, 27, 25, "Enable Auto Instance");
          enableAuto->tooltip("Allow main instance to start all those open when last closed.");
          enableAuto->box(FL_NO_BOX);
          enableAuto->down_box(FL_DOWN_BOX);
          enableAuto->color(FL_BACKGROUND_COLOR);
          enableAuto->selection_color(FL_FOREGROUND_COLOR);
          enableAuto->labeltype(FL_NORMAL_LABEL);
          enableAuto->labelfont(0);
          enableAuto->labelsize(12);
          enableAuto->labelcolor(FL_FOREGROUND_COLOR);
          enableAuto->callback((Fl_Callback*)cb_enableAuto);
          enableAuto->align(Fl_Align(FL_ALIGN_LEFT));
          enableAuto->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().autoInstance);
          if (synth->getUniqueId() != 0) o->hide(); else if (synth->getIsLV2Plugin()) o->deactivate();
        } // Fl_Check_Button2* enableAuto
        { Fl_Check_Button2* o = singleMaster = new Fl_Check_Button2(190, 220, 27, 25, "* Enable Single Master");
          singleMaster->tooltip("Redirect new start from desktop to create new instance instead.");
          singleMaster->box(FL_NO_BOX);
          singleMaster->down_box(FL_DOWN_BOX);
          singleMaster->color(FL_BACKGROUND_COLOR);
          singleMaster->selection_color(FL_FOREGROUND_COLOR);
          singleMaster->labeltype(FL_NORMAL_LABEL);
          singleMaster->labelfont(0);
          singleMaster->labelsize(12);
          singleMaster->labelcolor(FL_FOREGROUND_COLOR);
          singleMaster->callback((Fl_Callback*)cb_singleMaster);
          singleMaster->align(Fl_Align(FL_ALIGN_LEFT));
          singleMaster->when(FL_WHEN_RELEASE);
          o->value(fetchData(0, CONFIG::control::enableSinglePath, TOPLEVEL::section::config));
        } // Fl_Check_Button2* singleMaster
        { Fl_Check_Button2* o = setDefaultState = new Fl_Check_Button2(190, 250, 27, 25, "* Start With Default State");
          setDefaultState->tooltip("If you change this you must re-save the default state\nor when that loads it \
will revert to the previous value");
          setDefaultState->box(FL_NO_BOX);
          setDefaultState->down_box(FL_DOWN_BOX);
          setDefaultState->color(FL_BACKGROUND_COLOR);
          setDefaultState->selection_color(FL_FOREGROUND_COLOR);
          setDefaultState->labeltype(FL_NORMAL_LABEL);
          setDefaultState->labelfont(0);
          setDefaultState->labelsize(12);
          setDefaultState->labelcolor(FL_FOREGROUND_COLOR);
          setDefaultState->callback((Fl_Callback*)cb_setDefaultState);
          setDefaultState->align(Fl_Align(FL_ALIGN_LEFT));
          setDefaultState->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().loadDefaultState);
          if (synth->getIsLV2Plugin()) o->deactivate();
        } // Fl_Check_Button2* setDefaultState
        { Fl_Group* o = new Fl_Group(230, 70, 130, 180);
          o->tooltip("When locked new entries will not not be added or change the list order");
          o->box(FL_EMBOSSED_FRAME);
          { historyLocks = new Fl_Text_Display(278, 110, 50, 1, "History Locks");
            historyLocks->box(FL_NO_BOX);
            historyLocks->labelsize(12);
            historyLocks->textsize(12);
            historyLocks->align(Fl_Align(129));
          } // Fl_Text_Display* historyLocks
          { Fl_Check_Button2* o = H_instrument = new Fl_Check_Button2(240, 120, 27, 25, "Instrument");
            H_instrument->box(FL_NO_BOX);
            H_instrument->down_box(FL_DOWN_BOX);
            H_instrument->color(FL_BACKGROUND_COLOR);
            H_instrument->selection_color(FL_FOREGROUND_COLOR);
            H_instrument->labeltype(FL_NORMAL_LABEL);
            H_instrument->labelfont(0);
            H_instrument->labelsize(12);
            H_instrument->labelcolor(FL_FOREGROUND_COLOR);
            H_instrument->callback((Fl_Callback*)cb_H_instrument);
            H_instrument->align(Fl_Align(FL_ALIGN_RIGHT));
            H_instrument->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::Instrument, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_instrument
          { Fl_Check_Button2* o = H_patchset = new Fl_Check_Button2(240, 140, 27, 25, "Patch Set");
            H_patchset->box(FL_NO_BOX);
            H_patchset->down_box(FL_DOWN_BOX);
            H_patchset->color(FL_BACKGROUND_COLOR);
            H_patchset->selection_color(FL_FOREGROUND_COLOR);
            H_patchset->labeltype(FL_NORMAL_LABEL);
            H_patchset->labelfont(0);
            H_patchset->labelsize(12);
            H_patchset->labelcolor(FL_FOREGROUND_COLOR);
            H_patchset->callback((Fl_Callback*)cb_H_patchset);
            H_patchset->align(Fl_Align(FL_ALIGN_RIGHT));
            H_patchset->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::Patch, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_patchset
          { Fl_Check_Button2* o = H_scale = new Fl_Check_Button2(240, 160, 27, 25, "Scale");
            H_scale->box(FL_NO_BOX);
            H_scale->down_box(FL_DOWN_BOX);
            H_scale->color(FL_BACKGROUND_COLOR);
            H_scale->selection_color(FL_FOREGROUND_COLOR);
            H_scale->labeltype(FL_NORMAL_LABEL);
            H_scale->labelfont(0);
            H_scale->labelsize(12);
            H_scale->labelcolor(FL_FOREGROUND_COLOR);
            H_scale->callback((Fl_Callback*)cb_H_scale);
            H_scale->align(Fl_Align(FL_ALIGN_RIGHT));
            H_scale->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::Scale, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_scale
          { Fl_Check_Button2* o = H_state = new Fl_Check_Button2(240, 180, 27, 25, "State");
            H_state->box(FL_NO_BOX);
            H_state->down_box(FL_DOWN_BOX);
            H_state->color(FL_BACKGROUND_COLOR);
            H_state->selection_color(FL_FOREGROUND_COLOR);
            H_state->labeltype(FL_NORMAL_LABEL);
            H_state->labelfont(0);
            H_state->labelsize(12);
            H_state->labelcolor(FL_FOREGROUND_COLOR);
            H_state->callback((Fl_Callback*)cb_H_state);
            H_state->align(Fl_Align(FL_ALIGN_RIGHT));
            H_state->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::State, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_state
          { Fl_Check_Button2* o = H_vector = new Fl_Check_Button2(240, 200, 27, 25, "Vector");
            H_vector->box(FL_NO_BOX);
            H_vector->down_box(FL_DOWN_BOX);
            H_vector->color(FL_BACKGROUND_COLOR);
            H_vector->selection_color(FL_FOREGROUND_COLOR);
            H_vector->labeltype(FL_NORMAL_LABEL);
            H_vector->labelfont(0);
            H_vector->labelsize(12);
            H_vector->labelcolor(FL_FOREGROUND_COLOR);
            H_vector->callback((Fl_Callback*)cb_H_vector);
            H_vector->align(Fl_Align(FL_ALIGN_RIGHT));
            H_vector->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::Vector, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_vector
          { Fl_Check_Button2* o = H_mlearn = new Fl_Check_Button2(240, 220, 27, 25, "Midi Learn");
            H_mlearn->box(FL_NO_BOX);
            H_mlearn->down_box(FL_DOWN_BOX);
            H_mlearn->color(FL_BACKGROUND_COLOR);
            H_mlearn->selection_color(FL_FOREGROUND_COLOR);
            H_mlearn->labeltype(FL_NORMAL_LABEL);
            H_mlearn->labelfont(0);
            H_mlearn->labelsize(12);
            H_mlearn->labelcolor(FL_FOREGROUND_COLOR);
            H_mlearn->callback((Fl_Callback*)cb_H_mlearn);
            H_mlearn->align(Fl_Align(FL_ALIGN_RIGHT));
            H_mlearn->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::MLearn, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_mlearn
          o->end();
        } // Fl_Group* o
        { switchesNote = new Fl_Box(38, 276, 306, 17, "* Changing these settings requires a restart");
          switchesNote->labelfont(1);
          switchesNote->labelsize(12);
          switchesNote->labelcolor((Fl_Color)38);
          switchesNote->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Box* switchesNote
        switchesTab->end();
      } // Fl_Group* switchesTab
      { jackTab = new Fl_Group(5, 25, 385, 277);
        jackTab->box(FL_THIN_UP_BOX);
        jackTab->labelsize(12);
        jackTab->hide();
        { Fl_Input* o = jackSource = new Fl_Input(195, 62, 120, 22, "Jack MIDI Source");
          jackSource->tooltip("Device Jack tries to connect to for input.");
          jackSource->labelsize(12);
          jackSource->textfont(1);
          jackSource->textsize(12);
          jackSource->callback((Fl_Callback*)cb_jackSource);
          o->value(synth->getRuntime().jackMidiDevice.c_str());
        } // Fl_Input* jackSource
        { Fl_Check_Button2* o = jackMidi = new Fl_Check_Button2(195, 88, 37, 26, "Set as preferred MIDI");
          jackMidi->box(FL_NO_BOX);
          jackMidi->down_box(FL_DOWN_BOX);
          jackMidi->color(FL_BACKGROUND_COLOR);
          jackMidi->selection_color(FL_FOREGROUND_COLOR);
          jackMidi->labeltype(FL_NORMAL_LABEL);
          jackMidi->labelfont(0);
          jackMidi->labelsize(12);
          jackMidi->labelcolor(FL_FOREGROUND_COLOR);
          jackMidi->callback((Fl_Callback*)cb_jackMidi);
          jackMidi->align(Fl_Align(FL_ALIGN_LEFT));
          jackMidi->when(FL_WHEN_RELEASE);
          if (synth->getRuntime().midiEngine == jack_midi) o->value(1);
        } // Fl_Check_Button2* jackMidi
        { Fl_Input* o = jackServer = new Fl_Input(195, 182, 120, 22, "Jack Server");
          jackServer->tooltip("Name of the jack server to connect to - default, ...");
          jackServer->labelsize(12);
          jackServer->textfont(1);
          jackServer->textsize(12);
          jackServer->callback((Fl_Callback*)cb_jackServer);
          o->value(synth->getRuntime().jackServer.c_str());
        } // Fl_Input* jackServer
        { Fl_Check_Button2* o = jackAudio = new Fl_Check_Button2(195, 209, 37, 26, "Set as preferred audio");
          jackAudio->box(FL_NO_BOX);
          jackAudio->down_box(FL_DOWN_BOX);
          jackAudio->color(FL_BACKGROUND_COLOR);
          jackAudio->selection_color(FL_FOREGROUND_COLOR);
          jackAudio->labeltype(FL_NORMAL_LABEL);
          jackAudio->labelfont(0);
          jackAudio->labelsize(12);
          jackAudio->labelcolor(FL_FOREGROUND_COLOR);
          jackAudio->callback((Fl_Callback*)cb_jackAudio);
          jackAudio->align(Fl_Align(FL_ALIGN_LEFT));
          jackAudio->when(FL_WHEN_RELEASE);
          if (synth->getRuntime().audioEngine == jack_audio) o->value(1);
        } // Fl_Check_Button2* jackAudio
        { Fl_Check_Button2* o = connectJackAudio = new Fl_Check_Button2(195, 233, 37, 26, "Autoconnect audio");
          connectJackAudio->box(FL_NO_BOX);
          connectJackAudio->down_box(FL_DOWN_BOX);
          connectJackAudio->color(FL_BACKGROUND_COLOR);
          connectJackAudio->selection_color(FL_FOREGROUND_COLOR);
          connectJackAudio->labeltype(FL_NORMAL_LABEL);
          connectJackAudio->labelfont(0);
          connectJackAudio->labelsize(12);
          connectJackAudio->labelcolor(FL_FOREGROUND_COLOR);
          connectJackAudio->callback((Fl_Callback*)cb_connectJackAudio);
          connectJackAudio->align(Fl_Align(FL_ALIGN_LEFT));
          connectJackAudio->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().connectJackaudio);
        } // Fl_Check_Button2* connectJackAudio
        { jackNote = new Fl_Box(60, 276, 267, 17, "Changing settings requires a restart");
          jackNote->labelfont(1);
          jackNote->labelsize(12);
          jackNote->labelcolor((Fl_Color)38);
          jackNote->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Box* jackNote
        jackTab->end();
      } // Fl_Group* jackTab
      { alsaTab = new Fl_Group(5, 25, 384, 277);
        alsaTab->box(FL_THIN_UP_BOX);
        alsaTab->labelsize(12);
        alsaTab->hide();
        { Fl_Choice* o = alsaType = new Fl_Choice(195, 45, 120, 22, "Alsa Connection Type");
          alsaType->box(FL_DOWN_BOX);
          alsaType->down_box(FL_BORDER_BOX);
          alsaType->labelsize(12);
          alsaType->textfont(1);
          alsaType->textsize(12);
          alsaType->callback((Fl_Callback*)cb_alsaType);
          o->add("Fixed");o->add("Search");o->add("External");
        } // Fl_Choice* alsaType
        { Fl_Input* o = alsaSource = new Fl_Input(195, 80, 120, 22, "Alsa MIDI Source");
          alsaSource->tooltip("Device Alsa tries to connect to for input.");
          alsaSource->labelsize(12);
          alsaSource->textfont(1);
          alsaSource->textsize(12);
          alsaSource->callback((Fl_Callback*)cb_alsaSource);
          o->value(synth->getRuntime().alsaMidiDevice.c_str());
        } // Fl_Input* alsaSource
        { Fl_Check_Button2* o = alsaMidi = new Fl_Check_Button2(195, 110, 37, 26, "Set as preferred MIDI");
          alsaMidi->box(FL_NO_BOX);
          alsaMidi->down_box(FL_DOWN_BOX);
          alsaMidi->color(FL_BACKGROUND_COLOR);
          alsaMidi->selection_color(FL_FOREGROUND_COLOR);
          alsaMidi->labeltype(FL_NORMAL_LABEL);
          alsaMidi->labelfont(0);
          alsaMidi->labelsize(12);
          alsaMidi->labelcolor(FL_FOREGROUND_COLOR);
          alsaMidi->callback((Fl_Callback*)cb_alsaMidi);
          alsaMidi->align(Fl_Align(FL_ALIGN_LEFT));
          alsaMidi->when(FL_WHEN_RELEASE);
          if (synth->getRuntime().midiEngine == alsa_midi) o->value(1);
        } // Fl_Check_Button2* alsaMidi
        { Fl_Input* o = alsaDevice = new Fl_Input(195, 143, 120, 22, "Alsa Audio Device");
          alsaDevice->tooltip("Alsa audio device - default, hw:0, ...");
          alsaDevice->labelsize(12);
          alsaDevice->textfont(1);
          alsaDevice->textsize(12);
          alsaDevice->callback((Fl_Callback*)cb_alsaDevice);
          o->value(synth->getRuntime().alsaAudioDevice.c_str());
        } // Fl_Input* alsaDevice
        { Fl_Choice* o = alsaSamplerate = new Fl_Choice(195, 199, 80, 22, "Sample Rate");
          alsaSamplerate->down_box(FL_BORDER_BOX);
          alsaSamplerate->labelsize(12);
          alsaSamplerate->textfont(1);
          alsaSamplerate->textsize(12);
          alsaSamplerate->callback((Fl_Callback*)cb_alsaSamplerate);
          o->add("192000");o->add("96000");o->add("48000");o->add("44100");
          o->value(convertSrate(synth->getRuntime().Samplerate));
        } // Fl_Choice* alsaSamplerate
        { Fl_Check_Button2* o = alsaAudio = new Fl_Check_Button2(195, 169, 37, 26, "Set as preferred audio");
          alsaAudio->box(FL_NO_BOX);
          alsaAudio->down_box(FL_DOWN_BOX);
          alsaAudio->color(FL_BACKGROUND_COLOR);
          alsaAudio->selection_color(FL_FOREGROUND_COLOR);
          alsaAudio->labeltype(FL_NORMAL_LABEL);
          alsaAudio->labelfont(0);
          alsaAudio->labelsize(12);
          alsaAudio->labelcolor(FL_FOREGROUND_COLOR);
          alsaAudio->callback((Fl_Callback*)cb_alsaAudio);
          alsaAudio->align(Fl_Align(FL_ALIGN_LEFT));
          alsaAudio->when(FL_WHEN_RELEASE);
          if (synth->getRuntime().audioEngine == alsa_audio) o->value(1);
        } // Fl_Check_Button2* alsaAudio
        { alsaNote = new Fl_Box(60, 276, 267, 17, "Changing settings requires a restart");
          alsaNote->labelfont(1);
          alsaNote->labelsize(12);
          alsaNote->labelcolor((Fl_Color)38);
          alsaNote->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Box* alsaNote
        alsaTab->end();
      } // Fl_Group* alsaTab
      { midiTab = new Fl_Group(5, 25, 381, 275);
        midiTab->tooltip("MIDI CC preferences");
        midiTab->box(FL_THIN_UP_BOX);
        midiTab->labelsize(12);
        midiTab->callback((Fl_Callback*)cb_midiTab);
        midiTab->hide();
        { Fl_Choice* o = bankrootchange = new Fl_Choice(234, 57, 53, 18, "Bank Root Change");
          bankrootchange->tooltip("CC0 = msb, CC32 = lsb");
          bankrootchange->down_box(FL_BORDER_BOX);
          bankrootchange->labelsize(12);
          bankrootchange->textfont(1);
          bankrootchange->textsize(12);
          bankrootchange->callback((Fl_Callback*)cb_bankrootchange);
          bankrootchange->align(Fl_Align(132));
          o->add("LSB");o->add("MSB");o->add("Off");
          int bankRoot = synth->getRuntime().midi_bank_root;
          if (bankRoot == 32) o->value(0); else if (bankRoot == 0) o->value(1); else o->value(2);
          oldBank = o->value();
        } // Fl_Choice* bankrootchange
        { Fl_Choice* o = bankchange = new Fl_Choice(235, 80, 53, 18, "Bank Change");
          bankchange->tooltip("CC0 = msb, CC32 = lsb");
          bankchange->down_box(FL_BORDER_BOX);
          bankchange->labelsize(12);
          bankchange->textfont(1);
          bankchange->textsize(12);
          bankchange->callback((Fl_Callback*)cb_bankchange);
          bankchange->align(Fl_Align(132));
          o->add("LSB");o->add("MSB");o->add("Off");
          if (synth->getRuntime().midi_bank_C == 32) o->value(0); else if (synth->getRuntime().midi_bank_C == 0) o->value(1); else o->value(2);
          oldBank = o->value();
        } // Fl_Choice* bankchange
        { Fl_Check_Button2* o = progenable = new Fl_Check_Button2(234, 110, 18, 18, "Enable Program Change");
          progenable->tooltip("MIDI program change enable/disable");
          progenable->box(FL_NO_BOX);
          progenable->down_box(FL_DOWN_BOX);
          progenable->value(1);
          progenable->color(FL_BACKGROUND_COLOR);
          progenable->selection_color(FL_FOREGROUND_COLOR);
          progenable->labeltype(FL_NORMAL_LABEL);
          progenable->labelfont(0);
          progenable->labelsize(12);
          progenable->labelcolor(FL_FOREGROUND_COLOR);
          progenable->callback((Fl_Callback*)cb_progenable);
          progenable->align(Fl_Align(FL_ALIGN_LEFT));
          progenable->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().EnableProgChange);
        } // Fl_Check_Button2* progenable
        { WidgetSpinner* o = EPCspinner = new WidgetSpinner(235, 180, 50, 18, "Extended Program Change CC");
          EPCspinner->box(FL_NO_BOX);
          EPCspinner->color(FL_BACKGROUND_COLOR);
          EPCspinner->selection_color(FL_BACKGROUND_COLOR);
          EPCspinner->labeltype(FL_NORMAL_LABEL);
          EPCspinner->labelfont(0);
          EPCspinner->labelsize(12);
          EPCspinner->labelcolor(FL_FOREGROUND_COLOR);
          EPCspinner->minimum(0);
          EPCspinner->maximum(119);
          EPCspinner->value(110);
          EPCspinner->textfont(1);
          EPCspinner->textsize(12);
          EPCspinner->callback((Fl_Callback*)cb_EPCspinner);
          EPCspinner->align(Fl_Align(FL_ALIGN_LEFT));
          EPCspinner->when(FL_WHEN_RELEASE);
          EPCvalue = synth->getRuntime().midi_upper_voice_C;
          if (EPCvalue < 128) o->value(EPCvalue); else o->value(110);
        } // WidgetSpinner* EPCspinner
        { Epend = new Fl_Button(300, 180, 70, 20, "Pending");
          Epend->tooltip("Click to set");
          Epend->box(FL_PLASTIC_UP_BOX);
          Epend->color((Fl_Color)90);
          Epend->labelsize(12);
          Epend->callback((Fl_Callback*)cb_Epend);
          Epend->hide();
        } // Fl_Button* Epend
        { Fl_Check_Button2* o = Epcheck = new Fl_Check_Button2(234, 160, 18, 18, "Enable Extended Program Change");
          Epcheck->box(FL_NO_BOX);
          Epcheck->down_box(FL_DOWN_BOX);
          Epcheck->color(FL_BACKGROUND_COLOR);
          Epcheck->selection_color(FL_FOREGROUND_COLOR);
          Epcheck->labeltype(FL_NORMAL_LABEL);
          Epcheck->labelfont(0);
          Epcheck->labelsize(12);
          Epcheck->labelcolor(FL_FOREGROUND_COLOR);
          Epcheck->callback((Fl_Callback*)cb_Epcheck);
          Epcheck->align(Fl_Align(FL_ALIGN_LEFT));
          Epcheck->when(FL_WHEN_RELEASE);
          o->value((synth->getRuntime().midi_upper_voice_C < 128));
          if (o->value() == 0) EPCspinner->deactivate();
        } // Fl_Check_Button2* Epcheck
        { Fl_Check_Button2* o = enableNRPN = new Fl_Check_Button2(234, 210, 18, 18, "Enable Incoming NRPNs");
          enableNRPN->box(FL_NO_BOX);
          enableNRPN->down_box(FL_DOWN_BOX);
          enableNRPN->color(FL_BACKGROUND_COLOR);
          enableNRPN->selection_color(FL_FOREGROUND_COLOR);
          enableNRPN->labeltype(FL_NORMAL_LABEL);
          enableNRPN->labelfont(0);
          enableNRPN->labelsize(12);
          enableNRPN->labelcolor(FL_FOREGROUND_COLOR);
          enableNRPN->callback((Fl_Callback*)cb_enableNRPN);
          enableNRPN->align(Fl_Align(FL_ALIGN_LEFT));
          enableNRPN->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().enable_NRPN);
        } // Fl_Check_Button2* enableNRPN
        { Fl_Check_Button2* o = ignoreReset = new Fl_Check_Button2(234, 230, 18, 18, "Ignore Reset all CCs");
          ignoreReset->box(FL_NO_BOX);
          ignoreReset->down_box(FL_DOWN_BOX);
          ignoreReset->color(FL_BACKGROUND_COLOR);
          ignoreReset->selection_color(FL_FOREGROUND_COLOR);
          ignoreReset->labeltype(FL_NORMAL_LABEL);
          ignoreReset->labelfont(0);
          ignoreReset->labelsize(12);
          ignoreReset->labelcolor(FL_FOREGROUND_COLOR);
          ignoreReset->callback((Fl_Callback*)cb_ignoreReset);
          ignoreReset->align(Fl_Align(FL_ALIGN_LEFT));
          ignoreReset->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().ignoreResetCCs);
        } // Fl_Check_Button2* ignoreReset
        { Fl_Check_Button2* o = midiMon = new Fl_Check_Button2(234, 250, 18, 18, "Log Incoming Events");
          midiMon->box(FL_NO_BOX);
          midiMon->down_box(FL_DOWN_BOX);
          midiMon->color(FL_BACKGROUND_COLOR);
          midiMon->selection_color(FL_FOREGROUND_COLOR);
          midiMon->labeltype(FL_NORMAL_LABEL);
          midiMon->labelfont(0);
          midiMon->labelsize(12);
          midiMon->labelcolor(FL_FOREGROUND_COLOR);
          midiMon->callback((Fl_Callback*)cb_midiMon);
          midiMon->align(Fl_Align(FL_ALIGN_LEFT));
          midiMon->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().monitorCCin);
        } // Fl_Check_Button2* midiMon
        { Fl_Check_Button2* o = midiLearned = new Fl_Check_Button2(234, 270, 18, 18, "Show Learn Editor");
          midiLearned->tooltip("Open the MIDI learn window for editing when a new CC has been learned");
          midiLearned->box(FL_NO_BOX);
          midiLearned->down_box(FL_DOWN_BOX);
          midiLearned->color(FL_BACKGROUND_COLOR);
          midiLearned->selection_color(FL_FOREGROUND_COLOR);
          midiLearned->labeltype(FL_NORMAL_LABEL);
          midiLearned->labelfont(0);
          midiLearned->labelsize(12);
          midiLearned->labelcolor(FL_FOREGROUND_COLOR);
          midiLearned->callback((Fl_Callback*)cb_midiLearned);
          midiLearned->align(Fl_Align(FL_ALIGN_LEFT));
          midiLearned->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().showLearnedCC);
        } // Fl_Check_Button2* midiLearned
        EPCvalue = synth->getRuntime().midi_upper_voice_C;
        BankRootvalue = synth->getRuntime().midi_bank_root;
        midiTab->end();
      } // Fl_Group* midiTab
      configTabs->end();
    } // Fl_Group* configTabs
    { close = new Fl_Button(275, 305, 105, 20, "Close Unsaved");
      close->box(FL_THIN_UP_BOX);
      close->labelsize(12);
      close->callback((Fl_Callback*)cb_close);
    } // Fl_Button* close
    { save = new Fl_Button(155, 305, 105, 20, "Save and Close");
      save->box(FL_THIN_UP_BOX);
      save->labelsize(12);
      save->callback((Fl_Callback*)cb_save);
    } // Fl_Button* save
    { patch1 = new Fl_Box(6, 24, 89, 3);
      patch1->box(FL_FLAT_BOX);
    } // Fl_Box* patch1
    { patch2 = new Fl_Box(98, 24, 65, 3);
      patch2->box(FL_FLAT_BOX);
    } // Fl_Box* patch2
    { patch3 = new Fl_Box(166, 24, 37, 3);
      patch3->box(FL_FLAT_BOX);
    } // Fl_Box* patch3
    { patch4 = new Fl_Box(206, 24, 37, 3);
      patch4->box(FL_FLAT_BOX);
    } // Fl_Box* patch4
    { patch5 = new Fl_Box(246, 24, 57, 3);
      patch5->box(FL_FLAT_BOX);
    } // Fl_Box* patch5
    o->copy_label(synth->makeUniqueName("Settings").c_str());
    if (synth->getIsLV2Plugin()){jackTab->deactivate();alsaTab->deactivate();}
    confDW = o->w();confDH = o->h();
    o->size_range(confDW, confDH, 0, 0, 0, 0, 1);
    configwindow->end();
    configwindow->resizable(configwindow);
  } // Fl_Double_Window* configwindow
  { Fl_Double_Window* o = presets = new Fl_Double_Window(460, 295, "Presets");
    presets->callback((Fl_Callback*)cb_presets, (void*)(this));
    { presetbrowse = new Fl_Browser(5, 5, 450, 200);
      presetbrowse->tooltip("Click on an entry to make it the readable one.");
      presetbrowse->type(2);
      presetbrowse->labelsize(12);
      presetbrowse->textsize(12);
      presetbrowse->callback((Fl_Callback*)cb_presetbrowse);
    } // Fl_Browser* presetbrowse
    { addpreset = new Fl_Button(10, 220, 85, 35, "Add preset directory...");
      addpreset->box(FL_THIN_UP_BOX);
      addpreset->labelsize(12);
      addpreset->callback((Fl_Callback*)cb_addpreset);
      addpreset->align(Fl_Align(FL_ALIGN_WRAP));
    } // Fl_Button* addpreset
    { Fl_Button* o = removepresetbutton = new Fl_Button(115, 220, 85, 35, "Remove preset dir...");
      removepresetbutton->box(FL_THIN_UP_BOX);
      removepresetbutton->labelsize(12);
      removepresetbutton->callback((Fl_Callback*)cb_removepresetbutton);
      removepresetbutton->align(Fl_Align(FL_ALIGN_WRAP));
      o->deactivate();
    } // Fl_Button* removepresetbutton
    { Fl_Button* o = makedefaultpresetbutton = new Fl_Button(220, 220, 85, 35, "Make Current");
      makedefaultpresetbutton->box(FL_THIN_UP_BOX);
      makedefaultpresetbutton->labelsize(12);
      makedefaultpresetbutton->callback((Fl_Callback*)cb_makedefaultpresetbutton);
      makedefaultpresetbutton->align(Fl_Align(FL_ALIGN_WRAP));
      o->deactivate();
    } // Fl_Button* makedefaultpresetbutton
    { pSave = new Fl_Button(208, 268, 118, 20, "Save and Close");
      pSave->box(FL_THIN_UP_BOX);
      pSave->labelsize(12);
      pSave->callback((Fl_Callback*)cb_pSave);
    } // Fl_Button* pSave
    { pClose = new Fl_Button(334, 268, 118, 20, "Close Unsaved");
      pClose->box(FL_THIN_UP_BOX);
      pClose->labelsize(12);
      pClose->callback((Fl_Callback*)cb_pClose);
    } // Fl_Button* pClose
    o->copy_label(synth->makeUniqueName("Presets").c_str());
    preDW = o->w();preDH = o->h();
    o->size_range(preDW, preDH, 0, 0, 0, 0, 1);
    presets->end();
    presets->resizable(presets);
  } // Fl_Double_Window* presets
  return presets;
}

void ConfigUI::send_data(int action, int control, float value, int type, int part , int kit , int engine , int insert , int par , int miscmsg ) {
  //
              type |= TOPLEVEL::type::Write;
              if (part == UNUSED)
                  part = TOPLEVEL::section::config;;
              collect_data(synth, value, action, type, control, part, kit, engine, insert, par, UNUSED, miscmsg);
}

float ConfigUI::fetchData(float value, int control, int part, int kititem , int engine , int insert , int parameter , int offset , int miscmsg , int request ) {
  //
          return collect_readData(synth, value, control, part, kititem, engine, insert, parameter, offset, miscmsg, request);
}

void ConfigUI::returns_update(CommandBlock *getData) {
  //
              int value_int = lrint(getData->data.value);
              bool wasFromHere = ((getData->data.source & TOPLEVEL::action::noAction) == TOPLEVEL::action::fromGUI);
              unsigned char control = getData->data.control;
              unsigned char kititem = getData->data.kit;
              unsigned char miscmsg = getData->data.miscmsg;
              string msg = textMsgBuffer.fetch(miscmsg);
  
              bool value_bool = value_int > 0;
              int tmp;
              string name;
              switch (control)
              {
                  case CONFIG::control::oscillatorSize:
                      tmp = 0;
                      while (value_int > 256)
                      {
                          value_int = value_int >> 1;
                          ++ tmp; // count the bits for switch number
                      }
                      osc_size->value(tmp);
                      break;
                  case 1:
                      tmp = CONFIG::control::bufferSize;
                      while (value_int > 16)
                      {
                          value_int = value_int >> 1;
                          ++ tmp; // count the bits for switch number
                      }
                      buff_size->value(tmp - 1);
                      break;
                  case CONFIG::control::padSynthInterpolation:
                      pad_interpol->value(value_int);
                      break;
                  case CONFIG::control::virtualKeyboardLayout:
                      v_keyboard->value(value_int);
                      break;
                  case CONFIG::control::XMLcompressionLevel:
                      compression->value(value_int);
                      break;
                  case CONFIG::control::reportsDestination:
                      if(!wasFromHere)
                          reports->value(value_bool);
                      synth->getGuiMaster()->setLogging(value_bool);
                      if (value_bool)
                          logText->activate();
                      else
                          logText->deactivate();;
                      break;
                  case CONFIG::control::logTextSize:
                      logText->value(value_int);
                      //synth->getGuiMaster()->yoshiLog->logConsole->setLogText(value_int);
                      break;
                  case CONFIG::control::savedInstrumentFormat:
                      instrument->value(value_int - 1);
                      break;
  
                  case CONFIG::control::defaultStateStart:
                      setDefaultState->value(value_bool);
                      break;
                  case CONFIG::control::handlePadSynthBuild:
                      handlePadSynthBuild->value(value_int);
                      break;
                  case CONFIG::control::hideNonFatalErrors:
                      nonFatal->value(value_bool);
                      break;
                  case CONFIG::control::showSplash:
                      showSplash->value(value_bool);
                      break;
                  case CONFIG::control::logInstrumentLoadTimes:
                      logTimes->value(value_bool);
                      break;
                  case CONFIG::control::logXMLheaders:
                      logXML->value(value_bool);
                      break;
                  case CONFIG::control::saveAllXMLdata:
                      saveAllXML->value(value_bool);
                      break;
                  case CONFIG::control::enableGUI:
                      enableGUI->value(value_bool);
                      break;
                  case CONFIG::control::enableCLI:
                      enableCLI->value(value_bool);
                      break;
                  case CONFIG::control::enableAutoInstance:
                      enableAuto->value(value_bool);
                      break;
                  case CONFIG::control::enableSinglePath:
                      singleMaster->value(value_bool);
                      break;
                  case CONFIG::control::enableHighlight:
                      bankHighlight->value(value_bool);
                      break;
  
                  case CONFIG::control::historyLock:
                      if (!wasFromHere)
                      {
                          switch (kititem)
                          {
                              case TOPLEVEL::XML::Instrument:
                                  H_instrument->value(value_int);
                                  break;
                              case TOPLEVEL::XML::Patch:
                                  H_patchset->value(value_int);
                                  break;
                              case TOPLEVEL::XML::Scale:
                                  H_scale->value(value_int);
                                  break;
                              case TOPLEVEL::XML::State:
                                  H_state->value(value_int);
                                  break;
                              case TOPLEVEL::XML::Vector:
                                  H_vector->value(value_int);
                                  break;
                              case TOPLEVEL::XML::MLearn:
                                  H_mlearn->value(value_int);
                                  break;
                              default:
                                  break;
                          }
                      }
                      break;
  
                  case CONFIG::control::jackMidiSource:
                      jackSource->value(msg.c_str());
                      break;
                  case CONFIG::control::jackPreferredMidi:
                      jackMidi->value(value_bool);
                      alsaMidi->value(!value_bool);
                      break;
                  case CONFIG::control::jackServer:
                      jackServer->value(msg.c_str());
                      break;
                  case CONFIG::control::jackPreferredAudio:
                      jackAudio->value(value_bool);
                      alsaAudio->value(!value_bool);
                      break;
                  case CONFIG::control::jackAutoConnectAudio:
                      connectJackAudio->value(value_bool);
                      break;
  
                  case CONFIG::control::alsaMidiSource:
                      alsaSource->value(msg.c_str());
                      break;
                  case CONFIG::control::alsaPreferredMidi:
                      alsaMidi->value(value_bool);
                      jackMidi->value(!value_bool);
                      break;
                  case CONFIG::control::alsaMidiType:
                      alsaType->value(value_int);
                      if (value_int == 0) // fixed
                          alsaSource->activate();
                      else
                          alsaSource->deactivate();
                      break;
                  case CONFIG::control::alsaAudioDevice:
                      alsaDevice->value(msg.c_str());
                      break;
                  case CONFIG::control::alsaPreferredAudio:
                      alsaAudio->value(value_bool);
                      jackAudio->value(!value_bool);
                      break;
                  case CONFIG::control::alsaSampleRate:
                      alsaSamplerate->value(convertSrate(value_int));
                      break;
                  case CONFIG::control::addPresetRootDir:
                  case CONFIG::control::removePresetRootDir:
                  case CONFIG::control::currentPresetRoot:
                  {
                      if (msg.find("FAILED") == 1)
                      {
                          if (wasFromHere)
                              alert(synth, msg);
                      }
                      else
                          readpresetcfg();
                      break;
                  }
                  case CONFIG::control::bankRootCC:
                      switch (value_int)
                      {
                          case 0:
                              bankrootchange->value(1);
                              break;
                          case 32:
                              bankrootchange->value(0);
                              break;
                          default:
                              bankrootchange->value(2);
                              break;
                      }
                      break;
  
                  case CONFIG::control::bankCC:
                      switch (value_int)
                      {
                          case 0:
                              bankchange->value(1);
                              break;
                          case 32:
                              bankchange->value(0);
                              break;
                          default:
                              bankchange->value(2);
                              break;
                      }
                      break;
                  case CONFIG::control::enableProgramChange:
                      progenable->value(value_bool);
                      break;
                  case CONFIG::control::extendedProgramChangeCC:
                      if (value_int > 119)
                      {
                          EPCspinner->value(110);
                          EPCspinner->deactivate();
                          Epcheck->value(0);
                      }
                      else
                      {
                          EPCspinner->value(value_int);
                          EPCspinner->activate();
                          Epcheck->value(1);
                      }
                      break;
                  case CONFIG::control::ignoreResetAllCCs:
                      ignoreReset->value(value_bool);
                      break;
                  case CONFIG::control::logIncomingCCs:
                      midiMon->value(value_bool);
                      break;
                  case CONFIG::control::showLearnEditor:
                      midiLearned->value(value_bool);
                      break;
                  case CONFIG::control::enableNRPNs:
                      enableNRPN->value(value_bool);
                      break;
  
                  case CONFIG::control::saveCurrentConfig:
                      name = msg;
                      if (wasFromHere && name.find("FAILED") == 1)
                          alert(synth, name);
                      break;
      }
}

ConfigUI::ConfigUI(SynthEngine *_synth) {
  //
              synth = _synth;
              make_window();
              readpresetcfg();
              configSeen = false;
              presetsSeen = false;
              selectedRootID = -1;
              Tab1->do_callback();
}

ConfigUI::~ConfigUI() {
  //
          if (presetsSeen)
              saveWin(synth, presets->w(), presets->h(), presets->x(), presets->y(), true, "Config-presets");
          presets->hide();
          delete presets;
  
          if (configSeen)
              saveWin(synth, configwindow->w(), configwindow->h(),configwindow->x(), configwindow->y(), true, "Config");
          configwindow->hide();
          delete configwindow;
}

void ConfigUI::activatebutton_presetdir(bool active) {
  //
              if (active)
              {
                  removepresetbutton->activate();
                  makedefaultpresetbutton->activate();
              }
              else
              {
                  removepresetbutton->deactivate();
                  makedefaultpresetbutton->deactivate();
              }
}

int ConfigUI::recoverID() {
  //
              if (selectedRootID >= 0)
              {
                  return selectedRootID;
              }
              return 0;
}

void ConfigUI::readpresetcfg() {
  //
              presetbrowse->clear();
              for (int i = 0; i < MAX_PRESET_DIRS; ++i)
                  if (firstSynth->getRuntime().presetsDirlist[i].size())
                  {
                      string name;
                      if (i == synth->getRuntime().currentPreset)
                          name = "* ";
                      else
                          name = "  ";
                      name += firstSynth->getRuntime().presetsDirlist[i];
                      presetbrowse->add(name.c_str());
                  }
}

int ConfigUI::convertSrate(int source) {
  //
      int result = 2;
      switch (source)
      {
          case 0:
              result = 192000;
              break;
          case 1:
              result = 96000;
              break;
          case 2:
              result = 48000;
              break;
          case 3:
              result = 44100;
              break;
          case 192000:
              result = 0;
              break;
          case 96000:
              result = 1;
              break;
          case 48000:
              result = 2;
              break;
          case 44100:
              result = 3;
              break;
      }
      return result;
}

void ConfigUI::update_config(int tabnumber) {
  //
              int tmp;
              switch (tabnumber)
              {
                  case 1 : // Main
                      osc_size->value( (int)(logf(synth->getRuntime().Oscilsize / 256.0f - 1.0f) / logf(2.0f)) + 1);
                      buff_size->value( (int)(logf(synth->getRuntime().Buffersize / 16.0f - 1.0f) / logf(2.0f)) + 1);
                      pad_interpol->value(synth->getRuntime().Interpolation);
                      v_keyboard->value(synth->getRuntime().VirKeybLayout);
                      compression->value(synth->getRuntime().GzipCompression);
                      reports->value(synth->getRuntime().toConsole);
                      instrument->value(synth->getRuntime().instrumentFormat - 1);
                      break;
  
                  case 2 : // Jack
                      jackSource->value(synth->getRuntime().jackMidiDevice.c_str());
                      if (synth->getRuntime().midiEngine == jack_midi)
                      {
                          jackMidi->value(1);
                          alsaMidi->value(0);
                      }
                      jackServer->value(synth->getRuntime().jackServer.c_str());
                      if (synth->getRuntime().audioEngine == jack_audio)
                      {
                          jackAudio->value(1);
                          alsaAudio->value(0);
                      }
                      break;
  
                  case 3 : // Alsa
                      {
                          alsaSource->value(synth->getRuntime().alsaMidiDevice.c_str());
                          if (synth->getRuntime().midiEngine == alsa_midi)
                          {
                              alsaMidi->value(1);
                              jackMidi->value(0);
                          }
                          alsaDevice->value(synth->getRuntime().alsaAudioDevice.c_str());
                          if (synth->getRuntime().audioEngine == alsa_audio)
                          {
                              alsaAudio->value(1);
                              jackAudio->value(0);
                          }
                          alsaSamplerate->value(convertSrate(synth->getRuntime().Samplerate));
                      }
                      break;
  
                  case 4 : // MIDI
                      switch (synth->getRuntime().midi_bank_root)
                      {
                          case 32:
                              bankrootchange->value(0);
                              break;
                          case 0:
                              bankrootchange->value(1);
                              break;
                          default:
                              bankrootchange->value(2);
                              break;
                      }
  
                      switch (synth->getRuntime().midi_bank_C)
                      {
                          case 32:
                              bankchange->value(0);
                              break;
                          case 0:
                              bankchange->value(1);
                              break;
                          default:
                              bankchange->value(2);
                              break;
                      }
                      progenable->value(synth->getRuntime().EnableProgChange);
  
                      tmp = synth->getRuntime().midi_upper_voice_C;
                      if (tmp == 128)
                      {
                          EPCspinner->value(110);
                          EPCspinner->deactivate();
                          Epcheck->value(0);
                      }
                      else
                      {
                          EPCspinner->value(tmp);
                          EPCspinner->activate();
                          Epcheck->value(1);
                      }
                      Epend->hide();
                      enableNRPN->value(synth->getRuntime().enable_NRPN);
                      ignoreReset->value(synth->getRuntime().ignoreResetCCs);
                      midiMon->value(synth->getRuntime().monitorCCin);
                      midiLearned->value(synth->getRuntime().showLearnedCC);
                      break;
  
                  case 5 : // Switches
                      handlePadSynthBuild->value(synth->getRuntime().handlePadSynthBuild);
                      setDefaultState->value(synth->getRuntime().loadDefaultState > 0);
                      nonFatal->value(synth->getRuntime().hideErrors);
                      showSplash->value(synth->getRuntime().showSplash);
                      logTimes->value(synth->getRuntime().showTimes);
                      logXML->value(synth->getRuntime().logXMLheaders);
                      saveAllXML->value(synth->getRuntime().xmlmax);
                      enableGUI->value(synth->getRuntime().showGui);
                      enableCLI->value(synth->getRuntime().showCli);
                      break;
      }
}

void ConfigUI::Show(SynthEngine *synth) {
  //
                      if (synth->getIsLV2Plugin() == false && synth->getUniqueId() == 0)
                          singleMaster->show();
                      int tmp = fetchData (0, CONFIG::control::alsaMidiType,TOPLEVEL::section::config);
                      alsaType->value(tmp);
                      if (tmp == 0)
                          alsaSource->activate();
                      else
                          alsaSource->deactivate();
  
                      int fetchW, fetchH, fetchX, fetchY, fetchO;
                      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Config");
                      if (fetchW < confDW || fetchH < confDH)
                      {
                          fetchW = confDW;
                          fetchH = confDH;
                      }
                      checkSane(fetchX, fetchY, fetchW, fetchH, confDW, confDH);
                      configwindow->resize(fetchX, fetchY, fetchW, fetchH);
                      lastconfigW = 0;
                      configSeen = true;
                      configwindow->show();
}

void ConfigUI::Showpresets(SynthEngine *synth) {
  //
                  int fetchW, fetchH, fetchX, fetchY, fetchO;
                  loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Config-presets");
  
                  if (fetchW < preDW || fetchH < preDH)
                  {
                      fetchW = preDW;
                      fetchH = preDH;
                  }
                  presets->resize(fetchX, fetchY, fetchW, fetchH);
                  presets->resizable();
                  lastpresetW = 0;
                  presetsSeen = true;
                  presets->show();
}

void ConfigUI::configRtext() {
  //
      if (lastconfigW == configwindow->w())
          return;
      lastconfigW = configwindow->w();
  
      float dScale =  configwindow->w() / confDW;
  
      int size = int(dScale * 12);
  
      Tab1->labelsize(size);
      osc_size->labelsize(size);
          osc_size->textsize(size);
  
      buff_size->labelsize(size);
          buff_size->textsize(size);
  
      pad_interpol->labelsize(size);
          pad_interpol->textsize(size);
  
      handlePadSynthBuild->labelsize(size);
          handlePadSynthBuild->textsize(size);
  
      v_keyboard->labelsize(size);
          v_keyboard->textsize(size);
  
      compression->labelsize(size);
          compression->textsize(size);
      reports->labelsize(size);
          reports->textsize(size);
      logText->labelsize(size);
          logText->textsize(size);
  
      instrument->labelsize(size);
          instrument->textsize(size);
  
      PanelLayout->labelsize(size);
          PanelLayout->textsize(size);
  
      settingsNote->labelsize(size);
  
  //
      Tab2->labelsize(size);
      handlePadSynthBuild->labelsize(size);
      bankHighlight->labelsize(size);
      setDefaultState->labelsize(size);
      nonFatal->labelsize(size);
      showSplash->labelsize(size);
      logTimes->labelsize(size);
      logXML->labelsize(size);
      saveAllXML->labelsize(size);
      enableGUI->labelsize(size);
      enableCLI->labelsize(size);
      enableAuto->labelsize(size);
      singleMaster->labelsize(size);
  
      historyLocks->labelsize(size);
      H_instrument->labelsize(size);
      H_patchset->labelsize(size);
      H_scale->labelsize(size);
      H_state->labelsize(size);
      H_vector->labelsize(size);
      H_mlearn->labelsize(size);
  
      switchesNote->labelsize(size);
  //
      Tab3->labelsize(size);
      jackSource->labelsize(size);
          jackSource->textsize(size);
      jackMidi->labelsize(size);
      jackServer->labelsize(size);
          jackServer->textsize(size);
      jackAudio->labelsize(size);
      connectJackAudio->labelsize(size);
  
      jackNote->labelsize(size);
  //
      Tab4->labelsize(size);
      alsaType->labelsize(size);
          alsaType->textsize(size);
  
      alsaSource->labelsize(size);
          alsaSource->textsize(size);
      alsaMidi->labelsize(size);
      alsaDevice->labelsize(size);
      alsaDevice->textsize(size);
  
      alsaAudio->labelsize(size);
      alsaSamplerate->labelsize(size);
          alsaSamplerate->textsize(size);
  
      alsaNote->labelsize(size);
  
  //
      Tab5->labelsize(size);
      bankrootchange->labelsize(size);
          bankrootchange->textsize(size);
  
      bankchange->labelsize(size);
          bankchange->textsize(size);
  
      progenable->labelsize(size);
      EPCspinner->labelsize(size);
          EPCspinner->textsize(size);
      Epend->labelsize(size);
      Epcheck->labelsize(size);
      enableNRPN->labelsize(size);
      ignoreReset->labelsize(size);
      midiMon->labelsize(size);
      midiLearned->labelsize(size);
  //
      close->labelsize(size);
      save->labelsize(size);
  
      configwindow->redraw();
}

void ConfigUI::presetsRtext() {
  //
      if (lastpresetW == presets->w())
          return;
  
      lastpresetW = presets->w();
  
      float dScale = presets->w() / preDW;
  
      int size = int(12 * dScale);
  
      addpreset->labelsize(size);
      removepresetbutton->labelsize(size);
      makedefaultpresetbutton->labelsize(size);
      pSave->labelsize(size);
      pClose->labelsize(size);
  
      presetbrowse->textsize(size);
  
      presets->redraw();
}

string ConfigUI::testCC(int value, int control) {
  //
              CommandBlock getData;
              getData.data.value = value;
              getData.data.control = control;
              getData.data.part = 248;
              synth->interchange.testLimits(&getData);
              return textMsgBuffer.fetch(getData.data.miscmsg);
}
