"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fixed_list = exports.WordList = exports.LVList = exports.list = exports.List = exports.LVBytes = exports.uint64_t = exports.uint32_t = exports.uint24_t = exports.uint16_t = exports.uint8_t = exports.uint_t = exports.int64s = exports.int32s = exports.int24s = exports.int16s = exports.int8s = exports.int_t = void 0;
/* istanbul ignore file */
/* eslint-disable @typescript-eslint/explicit-module-boundary-types */
class int_t {
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static serialize(cls, value) {
        const buffer = Buffer.alloc(cls._size, 0);
        if (cls._signed) {
            buffer.writeIntLE(value, 0, cls._size);
        }
        else {
            buffer.writeUIntLE(value, 0, cls._size);
        }
        return buffer;
    }
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static deserialize(cls, data) {
        return [cls._signed ? data.readIntLE(0, cls._size) : data.readUIntLE(0, cls._size), data.slice(cls._size)];
    }
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static valueToName(cls, value) {
        for (const prop of Object.getOwnPropertyNames(cls)) {
            const desc = Object.getOwnPropertyDescriptor(cls, prop);
            if (desc !== undefined && desc.enumerable && desc.writable && value == desc.value) {
                return `${cls.name}.${prop}`;
            }
        }
        return '';
    }
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static valueName(cls, value) {
        for (const prop of Object.getOwnPropertyNames(cls)) {
            const desc = Object.getOwnPropertyDescriptor(cls, prop);
            if (desc !== undefined && desc.enumerable && desc.writable && value == desc.value) {
                return `${prop}`;
            }
        }
        return '';
    }
}
exports.int_t = int_t;
int_t._signed = true;
class int8s extends int_t {
}
exports.int8s = int8s;
int8s._size = 1;
class int16s extends int_t {
}
exports.int16s = int16s;
int16s._size = 2;
class int24s extends int_t {
}
exports.int24s = int24s;
int24s._size = 3;
class int32s extends int_t {
}
exports.int32s = int32s;
int32s._size = 4;
class int64s extends int_t {
}
exports.int64s = int64s;
int64s._size = 8;
class uint_t extends int_t {
}
exports.uint_t = uint_t;
uint_t._signed = false;
class uint8_t extends uint_t {
}
exports.uint8_t = uint8_t;
uint8_t._size = 1;
class uint16_t extends uint_t {
}
exports.uint16_t = uint16_t;
uint16_t._size = 2;
class uint24_t extends uint_t {
}
exports.uint24_t = uint24_t;
uint24_t._size = 3;
class uint32_t extends uint_t {
}
exports.uint32_t = uint32_t;
uint32_t._size = 4;
class uint64_t extends uint_t {
}
exports.uint64_t = uint64_t;
uint64_t._size = 8;
class LVBytes {
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static serialize(cls, value) {
        if (Buffer.isBuffer(value)) {
            const ret = Buffer.alloc(1);
            ret.writeUInt8(value.length, 0);
            return Buffer.concat([ret, value]);
        }
        return Buffer.from([value.length].concat(value));
    }
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static deserialize(cls, data) {
        const l = data.readIntLE(0, 1);
        const s = data.slice(1, (l + 1));
        return [s, data.slice((l + 1))];
    }
}
exports.LVBytes = LVBytes;
class List {
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static serialize(cls, value) {
        console.assert(((cls._length === null) || (cls.length === cls._length)));
        return Buffer.from(value.map(i => i.serialize(cls, i)));
    }
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static deserialize(cls, data) {
        let item;
        /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
        const r = [];
        while (data) {
            [item, data] = cls.itemtype.deserialize(cls.itemtype, data);
            r.push(item);
        }
        return [r, data];
    }
}
exports.List = List;
class _LVList extends List {
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static serialize(cls, value) {
        const head = [cls.length];
        const data = super.serialize(cls, value);
        return Buffer.from(head.concat(data));
    }
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static deserialize(cls, data) {
        let item, length;
        /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
        const r = [];
        [length, data] = [data[0], data.slice(1)];
        for (let i = 0; i < length; i++) {
            [item, data] = cls.itemtype.deserialize(cls.itemtype, data);
            r.push(item);
        }
        return [r, data];
    }
}
/* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
function list(itemtype) {
    class ConreteList extends List {
    }
    ConreteList.itemtype = itemtype;
    return ConreteList;
}
exports.list = list;
/* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
function LVList(itemtype) {
    class LVList extends _LVList {
    }
    LVList.itemtype = itemtype;
    return LVList;
}
exports.LVList = LVList;
class WordList extends List {
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static serialize(cls, value) {
        const data = value.map(i => Buffer.from(uint16_t.serialize(uint16_t, i)));
        return Buffer.concat(data);
    }
}
exports.WordList = WordList;
class _FixedList extends List {
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static serialize(cls, value) {
        const data = value.map(i => cls.itemtype.serialize(cls.itemtype, i)[0]);
        return Buffer.from(data);
    }
    /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
    static deserialize(cls, data) {
        let item;
        /* eslint-disable-next-line @typescript-eslint/no-explicit-any*/
        const r = [];
        for (let i = 0; i < cls._length; i++) {
            [item, data] = cls.itemtype.deserialize(cls.itemtype, data);
            r.push(item);
        }
        return [r, data];
    }
}
/* eslint-disable @typescript-eslint/no-explicit-any*/
function fixed_list(length, itemtype) {
    class FixedList extends _FixedList {
    }
    FixedList.itemtype = itemtype;
    FixedList._length = length;
    return FixedList;
}
exports.fixed_list = fixed_list;
/* eslint-enable @typescript-eslint/no-explicit-any*/ 
//# sourceMappingURL=basic.js.map