/* dummy-persona-store.c generated by valac 0.56.0, the Vala compiler
 * generated from dummy-persona-store.vala, do not modify */

/*
 * Copyright (C) 2013 Philip Withnall
 * Copyright (C) 2013 Canonical Ltd
 * Copyright (C) 2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 *       Renato Araujo Oliveira Filho <renato@canonical.com>
 */

#include "folks/folks-dummy.h"
#include <glib.h>
#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "folks-internal.h"

enum  {
	FOLKS_DUMMY_PERSONA_STORE_0_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_TYPE_ID_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_IS_PREPARED_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_IS_QUIESCENT_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_PERSONAS_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE_PROPERTY,
	FOLKS_DUMMY_PERSONA_STORE_NUM_PROPERTIES
};
static GParamSpec* folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksDummyPersonaStoreAddPersonaFromDetailsData FolksDummyPersonaStoreAddPersonaFromDetailsData;
typedef struct _FolksDummyPersonaStoreRemovePersonaData FolksDummyPersonaStoreRemovePersonaData;
typedef struct _FolksDummyPersonaStorePrepareData FolksDummyPersonaStorePrepareData;
typedef struct _Block20Data Block20Data;
typedef struct _FolksDummyPersonaStoreImplementMockDelayData FolksDummyPersonaStoreImplementMockDelayData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksDummyPersonaStorePrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	gboolean _quiescent_on_prepare;
	gint _contact_id;
	FolksMaybeBool _can_add_personas;
	FolksMaybeBool _can_alias_personas;
	FolksMaybeBool _can_remove_personas;
	gchar** _always_writeable_properties;
	gint _always_writeable_properties_length1;
	gint __always_writeable_properties_size_;
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	GeeHashSet* _pending_persona_registrations;
	GeeHashSet* _pending_persona_unregistrations;
	guint _personas_changed_frozen;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _add_persona_from_details_mock;
	gpointer _add_persona_from_details_mock_target;
	FolksDummyPersonaStoreRemovePersonaMock _remove_persona_mock;
	gpointer _remove_persona_mock_target;
	FolksDummyPersonaStorePrepareMock _prepare_mock;
	gpointer _prepare_mock_target;
	GType _persona_type;
};

struct _FolksDummyPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksDummyPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GError* _tmp0_;
	gchar* contact_id;
	gchar* _tmp1_;
	gint _tmp2_;
	gchar* uid;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* iid;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FolksDummyPersona* persona;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GObject* _tmp17_;
	GObject* _tmp18_;
	FolksDummyPersona* _tmp19_;
	FolksDummyPersona* _tmp20_;
	FolksDummyPersona* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gint _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	GValue* v;
	const gchar* _tmp25_;
	gconstpointer _tmp26_;
	FolksNameDetails* p_name;
	FolksDummyPersona* _tmp27_;
	FolksNameDetails* _tmp28_;
	gboolean _tmp29_;
	FolksNameDetails* _tmp30_;
	GValue* _tmp31_;
	const gchar* _tmp32_;
	GValue* _tmp33_;
	GValue _tmp34_;
	const gchar* _tmp35_;
	gchar* full_name;
	gchar* _tmp36_;
	FolksNameDetails* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gconstpointer _tmp40_;
	gboolean _tmp41_;
	FolksNameDetails* _tmp42_;
	GValue* _tmp43_;
	FolksStructuredName* sname;
	GValue* _tmp44_;
	GValue _tmp45_;
	GObject* _tmp46_;
	FolksStructuredName* _tmp47_;
	FolksStructuredName* _tmp48_;
	FolksNameDetails* _tmp49_;
	FolksStructuredName* _tmp50_;
	const gchar* _tmp51_;
	gconstpointer _tmp52_;
	gboolean _tmp53_;
	FolksNameDetails* _tmp54_;
	GValue* _tmp55_;
	const gchar* _tmp56_;
	GValue* _tmp57_;
	GValue _tmp58_;
	const gchar* _tmp59_;
	gchar* nickname;
	gchar* _tmp60_;
	FolksNameDetails* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	gconstpointer _tmp64_;
	FolksEmailDetails* p_email;
	FolksDummyPersona* _tmp65_;
	FolksEmailDetails* _tmp66_;
	gboolean _tmp67_;
	FolksEmailDetails* _tmp68_;
	GValue* _tmp69_;
	GeeSet* email_addresses;
	GValue* _tmp70_;
	GValue _tmp71_;
	GObject* _tmp72_;
	GeeSet* _tmp73_;
	GeeSet* _tmp74_;
	FolksEmailDetails* _tmp75_;
	GeeSet* _tmp76_;
	const gchar* _tmp77_;
	gconstpointer _tmp78_;
	FolksAvatarDetails* p_avatar;
	FolksDummyPersona* _tmp79_;
	FolksAvatarDetails* _tmp80_;
	gboolean _tmp81_;
	FolksAvatarDetails* _tmp82_;
	GValue* _tmp83_;
	GLoadableIcon* avatar;
	GValue* _tmp84_;
	GValue _tmp85_;
	GObject* _tmp86_;
	GLoadableIcon* _tmp87_;
	GLoadableIcon* _tmp88_;
	FolksAvatarDetails* _tmp89_;
	GLoadableIcon* _tmp90_;
	const gchar* _tmp91_;
	gconstpointer _tmp92_;
	FolksImDetails* p_im;
	FolksDummyPersona* _tmp93_;
	FolksImDetails* _tmp94_;
	gboolean _tmp95_;
	FolksImDetails* _tmp96_;
	GValue* _tmp97_;
	GeeMultiMap* im_addresses;
	GValue* _tmp98_;
	GValue _tmp99_;
	GObject* _tmp100_;
	GeeMultiMap* _tmp101_;
	GeeMultiMap* _tmp102_;
	FolksImDetails* _tmp103_;
	GeeMultiMap* _tmp104_;
	const gchar* _tmp105_;
	gconstpointer _tmp106_;
	FolksPhoneDetails* p_phone;
	FolksDummyPersona* _tmp107_;
	FolksPhoneDetails* _tmp108_;
	gboolean _tmp109_;
	FolksPhoneDetails* _tmp110_;
	GValue* _tmp111_;
	GeeSet* phone_numbers;
	GValue* _tmp112_;
	GValue _tmp113_;
	GObject* _tmp114_;
	GeeSet* _tmp115_;
	GeeSet* _tmp116_;
	FolksPhoneDetails* _tmp117_;
	GeeSet* _tmp118_;
	const gchar* _tmp119_;
	gconstpointer _tmp120_;
	FolksPostalAddressDetails* p_postal;
	FolksDummyPersona* _tmp121_;
	FolksPostalAddressDetails* _tmp122_;
	gboolean _tmp123_;
	FolksPostalAddressDetails* _tmp124_;
	GValue* _tmp125_;
	GeeSet* postal_fds;
	GValue* _tmp126_;
	GValue _tmp127_;
	GObject* _tmp128_;
	GeeSet* _tmp129_;
	GeeSet* _tmp130_;
	FolksPostalAddressDetails* _tmp131_;
	GeeSet* _tmp132_;
	const gchar* _tmp133_;
	gconstpointer _tmp134_;
	FolksLocalIdDetails* p_local;
	FolksDummyPersona* _tmp135_;
	FolksLocalIdDetails* _tmp136_;
	gboolean _tmp137_;
	FolksLocalIdDetails* _tmp138_;
	GValue* _tmp139_;
	GeeSet* local_ids;
	GValue* _tmp140_;
	GValue _tmp141_;
	GObject* _tmp142_;
	GeeSet* _tmp143_;
	GeeSet* _tmp144_;
	FolksLocalIdDetails* _tmp145_;
	GeeSet* _tmp146_;
	const gchar* _tmp147_;
	gconstpointer _tmp148_;
	FolksWebServiceDetails* p_web;
	FolksDummyPersona* _tmp149_;
	FolksWebServiceDetails* _tmp150_;
	gboolean _tmp151_;
	FolksWebServiceDetails* _tmp152_;
	GValue* _tmp153_;
	GeeHashMultiMap* addrs;
	GValue* _tmp154_;
	GValue _tmp155_;
	GObject* _tmp156_;
	GeeHashMultiMap* _tmp157_;
	GeeHashMultiMap* _tmp158_;
	FolksWebServiceDetails* _tmp159_;
	GeeHashMultiMap* _tmp160_;
	const gchar* _tmp161_;
	gconstpointer _tmp162_;
	FolksNoteDetails* p_note;
	FolksDummyPersona* _tmp163_;
	FolksNoteDetails* _tmp164_;
	gboolean _tmp165_;
	FolksNoteDetails* _tmp166_;
	GValue* _tmp167_;
	GeeHashSet* notes;
	GValue* _tmp168_;
	GValue _tmp169_;
	GObject* _tmp170_;
	GeeHashSet* _tmp171_;
	GeeHashSet* _tmp172_;
	FolksNoteDetails* _tmp173_;
	GeeHashSet* _tmp174_;
	const gchar* _tmp175_;
	gconstpointer _tmp176_;
	FolksGenderDetails* p_gender;
	FolksDummyPersona* _tmp177_;
	FolksGenderDetails* _tmp178_;
	gboolean _tmp179_;
	FolksGenderDetails* _tmp180_;
	GValue* _tmp181_;
	FolksGender gender;
	GValue* _tmp182_;
	GValue _tmp183_;
	FolksGenderDetails* _tmp184_;
	const gchar* _tmp185_;
	gconstpointer _tmp186_;
	FolksUrlDetails* p_url;
	FolksDummyPersona* _tmp187_;
	FolksUrlDetails* _tmp188_;
	gboolean _tmp189_;
	FolksUrlDetails* _tmp190_;
	GValue* _tmp191_;
	GeeSet* urls;
	GValue* _tmp192_;
	GValue _tmp193_;
	GObject* _tmp194_;
	GeeSet* _tmp195_;
	GeeSet* _tmp196_;
	FolksUrlDetails* _tmp197_;
	GeeSet* _tmp198_;
	const gchar* _tmp199_;
	gconstpointer _tmp200_;
	FolksBirthdayDetails* p_birthday;
	FolksDummyPersona* _tmp201_;
	FolksBirthdayDetails* _tmp202_;
	gboolean _tmp203_;
	FolksBirthdayDetails* _tmp204_;
	GValue* _tmp205_;
	GDateTime* birthday;
	GValue* _tmp206_;
	GValue _tmp207_;
	void* _tmp208_;
	GDateTime* _tmp209_;
	GDateTime* _tmp210_;
	FolksBirthdayDetails* _tmp211_;
	GDateTime* _tmp212_;
	const gchar* _tmp213_;
	gconstpointer _tmp214_;
	FolksRoleDetails* p_role;
	FolksDummyPersona* _tmp215_;
	FolksRoleDetails* _tmp216_;
	gboolean _tmp217_;
	FolksRoleDetails* _tmp218_;
	GValue* _tmp219_;
	GeeSet* roles;
	GValue* _tmp220_;
	GValue _tmp221_;
	GObject* _tmp222_;
	GeeSet* _tmp223_;
	GeeSet* _tmp224_;
	FolksRoleDetails* _tmp225_;
	GeeSet* _tmp226_;
	const gchar* _tmp227_;
	gconstpointer _tmp228_;
	FolksFavouriteDetails* p_favourite;
	FolksDummyPersona* _tmp229_;
	FolksFavouriteDetails* _tmp230_;
	gboolean _tmp231_;
	FolksFavouriteDetails* _tmp232_;
	GValue* _tmp233_;
	gboolean is_fav;
	GValue* _tmp234_;
	GValue _tmp235_;
	FolksFavouriteDetails* _tmp236_;
	GError* e1;
	GError* _tmp237_;
	const gchar* _tmp238_;
	GError* _tmp239_;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _tmp240_;
	gpointer _tmp240__target;
	gint delay;
	FolksDummyPersonaStoreAddPersonaFromDetailsMock _tmp241_;
	gpointer _tmp241__target;
	FolksDummyPersona* _tmp242_;
	GeeHashMap* _tmp243_;
	FolksDummyPersona* _tmp244_;
	const gchar* _tmp245_;
	const gchar* _tmp246_;
	FolksDummyPersona* _tmp247_;
	GeeHashSet* added_personas;
	GeeHashSet* _tmp248_;
	GeeHashSet* _tmp249_;
	FolksDummyPersona* _tmp250_;
	GeeHashSet* _tmp251_;
	GError* _inner_error0_;
};

struct _FolksDummyPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksDummyPersonaStore* self;
	FolksPersona* persona;
	GError* _tmp0_;
	FolksDummyPersonaStoreRemovePersonaMock _tmp1_;
	gpointer _tmp1__target;
	gint delay;
	FolksDummyPersonaStoreRemovePersonaMock _tmp2_;
	gpointer _tmp2__target;
	FolksDummyPersona* _persona;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gpointer _tmp6_;
	FolksDummyPersona* _tmp7_;
	GeeHashMap* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GeeHashSet* _tmp11_;
	FolksDummyPersona* _tmp12_;
	GeeHashSet* _tmp13_;
	FolksDummyPersona* _tmp14_;
	GeeHashSet* removed_personas;
	GeeHashSet* _tmp15_;
	GeeHashSet* _tmp16_;
	GeeHashSet* _tmp17_;
	GError* _inner_error0_;
};

struct _FolksDummyPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksDummyPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	FolksDummyPersonaStorePrepareMock _tmp3_;
	gpointer _tmp3__target;
	gint delay;
	FolksDummyPersonaStorePrepareMock _tmp4_;
	gpointer _tmp4__target;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _Block20Data {
	int _ref_count_;
	FolksDummyPersonaStore* self;
	gpointer _async_data_;
};

struct _FolksDummyPersonaStoreImplementMockDelayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksDummyPersonaStore* self;
	gint delay;
	Block20Data* _data20_;
};

static gint FolksDummyPersonaStore_private_offset;
static gpointer folks_dummy_persona_store_parent_class = NULL;
static gchar** folks_dummy_persona_store__always_writeable_properties_empty;
static gint folks_dummy_persona_store__always_writeable_properties_empty_length1;
static gchar** folks_dummy_persona_store__always_writeable_properties_empty = NULL;
static gint folks_dummy_persona_store__always_writeable_properties_empty_length1 = 0;
static gint _folks_dummy_persona_store__always_writeable_properties_empty_size_ = 0;

static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void folks_dummy_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void folks_dummy_persona_store_real_add_persona_from_details (FolksPersonaStore* base,
                                                              GHashTable* details,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean folks_dummy_persona_store_real_add_persona_from_details_co (FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_);
static void folks_dummy_persona_store_add_persona_from_details_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void _folks_dummy_persona_store_implement_mock_delay (FolksDummyPersonaStore* self,
                                                      gint delay,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void _folks_dummy_persona_store_implement_mock_delay_finish (FolksDummyPersonaStore* self,
                                                             GAsyncResult* _res_);
static void folks_dummy_persona_store_real_remove_persona_data_free (gpointer _data);
static void folks_dummy_persona_store_real_remove_persona (FolksPersonaStore* base,
                                                    FolksPersona* persona,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean folks_dummy_persona_store_real_remove_persona_co (FolksDummyPersonaStoreRemovePersonaData* _data_);
static void folks_dummy_persona_store_remove_persona_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void folks_dummy_persona_store_real_prepare_data_free (gpointer _data);
static void folks_dummy_persona_store_real_prepare (FolksPersonaStore* base,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean folks_dummy_persona_store_real_prepare_co (FolksDummyPersonaStorePrepareData* _data_);
static void folks_dummy_persona_store_prepare_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void _folks_dummy_persona_store_implement_mock_delay_data_free (gpointer _data);
static gboolean _folks_dummy_persona_store_implement_mock_delay_co (FolksDummyPersonaStoreImplementMockDelayData* _data_);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static gboolean ____lambda6_ (Block20Data* _data20_);
static gboolean _____lambda6__gsource_func (gpointer self);
static gboolean ____lambda7_ (Block20Data* _data20_);
static gboolean _____lambda7__gsource_func (gpointer self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static GObject * folks_dummy_persona_store_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void folks_dummy_persona_store_finalize (GObject * obj);
static GType folks_dummy_persona_store_get_type_once (void);
static void _vala_folks_dummy_persona_store_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_folks_dummy_persona_store_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
folks_dummy_persona_store_get_instance_private (FolksDummyPersonaStore* self)
{
	return G_STRUCT_MEMBER_P (self, FolksDummyPersonaStore_private_offset);
}

/**
   * Create a new persona store.
   *
   * This store will have no personas to begin with; use
   * {@link FolksDummy.PersonaStore.register_personas} to add some, then call
   * {@link FolksDummy.PersonaStore.reach_quiescence} to signal the store
   * reaching quiescence.
   *
   * @param id The new store's ID.
   * @param display_name The new store's display name.
   * @param always_writeable_properties The set of always writeable properties.
   *
   * @since 0.9.7
   */
static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

FolksDummyPersonaStore*
folks_dummy_persona_store_construct (GType object_type,
                                     const gchar* id,
                                     const gchar* display_name,
                                     gchar** always_writeable_properties,
                                     gint always_writeable_properties_length1)
{
	FolksDummyPersonaStore * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (FolksDummyPersonaStore*) g_object_new (object_type, "id", id, "display-name", display_name, NULL);
	_tmp0_ = (always_writeable_properties != NULL) ? _vala_array_dup1 (always_writeable_properties, always_writeable_properties_length1) : always_writeable_properties;
	_tmp0__length1 = always_writeable_properties_length1;
	self->priv->_always_writeable_properties = (_vala_array_free (self->priv->_always_writeable_properties, self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_always_writeable_properties = _tmp0_;
	self->priv->_always_writeable_properties_length1 = _tmp0__length1;
	self->priv->__always_writeable_properties_size_ = self->priv->_always_writeable_properties_length1;
	return self;
}

FolksDummyPersonaStore*
folks_dummy_persona_store_new (const gchar* id,
                               const gchar* display_name,
                               gchar** always_writeable_properties,
                               gint always_writeable_properties_length1)
{
	return folks_dummy_persona_store_construct (FOLKS_DUMMY_TYPE_PERSONA_STORE, id, display_name, always_writeable_properties, always_writeable_properties_length1);
}

static void
folks_dummy_persona_store_real_add_persona_from_details_data_free (gpointer _data)
{
	FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaStoreAddPersonaFromDetailsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
folks_dummy_persona_store_real_add_persona_from_details (FolksPersonaStore* base,
                                                         GHashTable* details,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	FolksDummyPersonaStore * self;
	FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_;
	FolksDummyPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (details != NULL);
	self = (FolksDummyPersonaStore*) base;
	_data_ = g_slice_new0 (FolksDummyPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_dummy_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_hash_table_ref0 (details);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp1_;
	folks_dummy_persona_store_real_add_persona_from_details_co (_data_);
}

static FolksPersona*
folks_dummy_persona_store_add_persona_from_details_finish (FolksPersonaStore* base,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	FolksPersona* result;
	FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * Accepted keys for ``details`` are:
   * - PersonaStore.detail_key (PersonaDetail.AVATAR)
   * - PersonaStore.detail_key (PersonaDetail.BIRTHDAY)
   * - PersonaStore.detail_key (PersonaDetail.EMAIL_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.FULL_NAME)
   * - PersonaStore.detail_key (PersonaDetail.GENDER)
   * - PersonaStore.detail_key (PersonaDetail.IM_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.IS_FAVOURITE)
   * - PersonaStore.detail_key (PersonaDetail.PHONE_NUMBERS)
   * - PersonaStore.detail_key (PersonaDetail.POSTAL_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.ROLES)
   * - PersonaStore.detail_key (PersonaDetail.STRUCTURED_NAME)
   * - PersonaStore.detail_key (PersonaDetail.LOCAL_IDS)
   * - PersonaStore.detail_key (PersonaDetail.WEB_SERVICE_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.NOTES)
   * - PersonaStore.detail_key (PersonaDetail.URLS)
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @param details key–value pairs giving the new persona’s details
   * @throws Folks.PersonaStoreError.STORE_OFFLINE if the store hasn’t been
   * prepared
   * @throws Folks.PersonaStoreError.CREATE_FAILED if creating the persona in
   * the dummy store failed
   *
   * @since 0.9.7
   */
static void
folks_dummy_persona_store_add_persona_from_details_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_dummy_persona_store_real_add_persona_from_details_co (_data_);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gboolean
folks_dummy_persona_store_real_add_persona_from_details_co (FolksDummyPersonaStoreAddPersonaFromDetailsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
		case 11:
		goto _state_11;
		case 12:
		goto _state_12;
		case 13:
		goto _state_13;
		case 14:
		goto _state_14;
		case 15:
		goto _state_15;
		case 16:
		goto _state_16;
		case 17:
		goto _state_17;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!_data_->self->priv->_is_prepared) {
		_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, "Persona store has not yet been prepared.");
		_data_->_inner_error0_ = _data_->_tmp0_;
		if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = g_strdup_printf ("%i", _data_->self->priv->_contact_id);
	_data_->contact_id = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_contact_id;
	_data_->self->priv->_contact_id = _data_->_tmp2_ + 1;
	_data_->_tmp3_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->contact_id;
	_data_->_tmp6_ = folks_persona_build_uid (BACKEND_NAME, _data_->_tmp4_, _data_->_tmp5_);
	_data_->uid = _data_->_tmp6_;
	_data_->_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strconcat (_data_->_tmp8_, ":", NULL);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->contact_id;
	_data_->_tmp12_ = g_strconcat (_data_->_tmp10_, _data_->_tmp11_, NULL);
	_data_->_tmp13_ = _data_->_tmp12_;
	_g_free0 (_data_->_tmp10_);
	_data_->iid = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->contact_id;
	_data_->_tmp15_ = _data_->uid;
	_data_->_tmp16_ = _data_->iid;
	_data_->_tmp17_ = g_object_new (_data_->self->priv->_persona_type, "display-id", _data_->_tmp14_, "uid", _data_->_tmp15_, "iid", _data_->_tmp16_, "store", _data_->self, "is-user", FALSE, NULL, NULL);
	_data_->_tmp18_ = G_IS_INITIALLY_UNOWNED (_data_->_tmp17_) ? g_object_ref_sink (_data_->_tmp17_) : _data_->_tmp17_;
	_data_->_tmp19_ = FOLKS_DUMMY_IS_PERSONA (_data_->_tmp18_) ? ((FolksDummyPersona*) _data_->_tmp18_) : NULL;
	if (_data_->_tmp19_ == NULL) {
		_g_object_unref0 (_data_->_tmp18_);
	}
	_data_->persona = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->persona;
	_vala_assert (_data_->_tmp20_ != NULL, "persona != null");
	_data_->_tmp21_ = _data_->persona;
	_data_->_tmp23_ = 0;
	_data_->_tmp22_ = folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) _data_->self, &_data_->_tmp23_);
	_data_->_tmp22__length1 = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->_tmp22_;
	_data_->_tmp24__length1 = _data_->_tmp22__length1;
	folks_dummy_persona_update_writeable_properties (_data_->_tmp21_, _data_->_tmp24_, (gint) _data_->_tmp24__length1);
	{
		_data_->_tmp25_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
		_data_->_tmp26_ = g_hash_table_lookup (_data_->details, _data_->_tmp25_);
		_data_->v = (GValue*) _data_->_tmp26_;
		_data_->_tmp27_ = _data_->persona;
		_data_->_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp27_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _data_->_tmp27_) : NULL);
		_data_->p_name = _data_->_tmp28_;
		_data_->_tmp30_ = _data_->p_name;
		if (_data_->_tmp30_ != NULL) {
			_data_->_tmp31_ = _data_->v;
			_data_->_tmp29_ = ((gpointer) _data_->_tmp31_) != NULL;
		} else {
			_data_->_tmp29_ = FALSE;
		}
		if (_data_->_tmp29_) {
			_data_->_tmp33_ = _data_->v;
			_data_->_tmp34_ = (GValue) (*_data_->_tmp33_);
			_data_->_tmp35_ = g_value_get_string (&_data_->_tmp34_);
			_data_->_tmp32_ = _data_->_tmp35_;
			if (_data_->_tmp32_ == NULL) {
				_data_->_tmp32_ = "";
			}
			_data_->_tmp36_ = g_strdup (_data_->_tmp32_);
			_data_->full_name = _data_->_tmp36_;
			_data_->_tmp37_ = _data_->p_name;
			_data_->_tmp38_ = _data_->full_name;
			_data_->_state_ = 1;
			folks_name_details_change_full_name (_data_->_tmp37_, _data_->_tmp38_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_1:
			folks_name_details_change_full_name_finish (_data_->_tmp37_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->full_name);
				_g_object_unref0 (_data_->p_name);
				if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch0_folks_property_error;
				}
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->full_name);
		}
		_data_->_tmp39_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_STRUCTURED_NAME);
		_data_->_tmp40_ = g_hash_table_lookup (_data_->details, _data_->_tmp39_);
		_data_->v = (GValue*) _data_->_tmp40_;
		_data_->_tmp42_ = _data_->p_name;
		if (_data_->_tmp42_ != NULL) {
			_data_->_tmp43_ = _data_->v;
			_data_->_tmp41_ = ((gpointer) _data_->_tmp43_) != NULL;
		} else {
			_data_->_tmp41_ = FALSE;
		}
		if (_data_->_tmp41_) {
			_data_->_tmp44_ = _data_->v;
			_data_->_tmp45_ = (GValue) (*_data_->_tmp44_);
			_data_->_tmp46_ = g_value_get_object (&_data_->_tmp45_);
			_data_->_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp46_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName));
			_data_->sname = _data_->_tmp47_;
			_data_->_tmp48_ = _data_->sname;
			if (_data_->_tmp48_ != NULL) {
				_data_->_tmp49_ = _data_->p_name;
				_data_->_tmp50_ = _data_->sname;
				_data_->_state_ = 2;
				folks_name_details_change_structured_name (_data_->_tmp49_, _data_->_tmp50_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_2:
				folks_name_details_change_structured_name_finish (_data_->_tmp49_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->sname);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->sname);
		}
		_data_->_tmp51_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NICKNAME);
		_data_->_tmp52_ = g_hash_table_lookup (_data_->details, _data_->_tmp51_);
		_data_->v = (GValue*) _data_->_tmp52_;
		_data_->_tmp54_ = _data_->p_name;
		if (_data_->_tmp54_ != NULL) {
			_data_->_tmp55_ = _data_->v;
			_data_->_tmp53_ = ((gpointer) _data_->_tmp55_) != NULL;
		} else {
			_data_->_tmp53_ = FALSE;
		}
		if (_data_->_tmp53_) {
			_data_->_tmp57_ = _data_->v;
			_data_->_tmp58_ = (GValue) (*_data_->_tmp57_);
			_data_->_tmp59_ = g_value_get_string (&_data_->_tmp58_);
			_data_->_tmp56_ = _data_->_tmp59_;
			if (_data_->_tmp56_ == NULL) {
				_data_->_tmp56_ = "";
			}
			_data_->_tmp60_ = g_strdup (_data_->_tmp56_);
			_data_->nickname = _data_->_tmp60_;
			_data_->_tmp61_ = _data_->p_name;
			_data_->_tmp62_ = _data_->nickname;
			_data_->_state_ = 3;
			folks_name_details_change_nickname (_data_->_tmp61_, _data_->_tmp62_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_3:
			folks_name_details_change_nickname_finish (_data_->_tmp61_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->nickname);
				_g_object_unref0 (_data_->p_name);
				if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch0_folks_property_error;
				}
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->nickname);
		}
		_data_->_tmp63_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
		_data_->_tmp64_ = g_hash_table_lookup (_data_->details, _data_->_tmp63_);
		_data_->v = (GValue*) _data_->_tmp64_;
		_data_->_tmp65_ = _data_->persona;
		_data_->_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp65_, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) _data_->_tmp65_) : NULL);
		_data_->p_email = _data_->_tmp66_;
		_data_->_tmp68_ = _data_->p_email;
		if (_data_->_tmp68_ != NULL) {
			_data_->_tmp69_ = _data_->v;
			_data_->_tmp67_ = ((gpointer) _data_->_tmp69_) != NULL;
		} else {
			_data_->_tmp67_ = FALSE;
		}
		if (_data_->_tmp67_) {
			_data_->_tmp70_ = _data_->v;
			_data_->_tmp71_ = (GValue) (*_data_->_tmp70_);
			_data_->_tmp72_ = g_value_get_object (&_data_->_tmp71_);
			_data_->_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp72_, GEE_TYPE_SET, GeeSet));
			_data_->email_addresses = _data_->_tmp73_;
			_data_->_tmp74_ = _data_->email_addresses;
			if (_data_->_tmp74_ != NULL) {
				_data_->_tmp75_ = _data_->p_email;
				_data_->_tmp76_ = _data_->email_addresses;
				_data_->_state_ = 4;
				folks_email_details_change_email_addresses (_data_->_tmp75_, _data_->_tmp76_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_4:
				folks_email_details_change_email_addresses_finish (_data_->_tmp75_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->email_addresses);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->email_addresses);
		}
		_data_->_tmp77_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_AVATAR);
		_data_->_tmp78_ = g_hash_table_lookup (_data_->details, _data_->_tmp77_);
		_data_->v = (GValue*) _data_->_tmp78_;
		_data_->_tmp79_ = _data_->persona;
		_data_->_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp79_, FOLKS_TYPE_AVATAR_DETAILS) ? ((FolksAvatarDetails*) _data_->_tmp79_) : NULL);
		_data_->p_avatar = _data_->_tmp80_;
		_data_->_tmp82_ = _data_->p_avatar;
		if (_data_->_tmp82_ != NULL) {
			_data_->_tmp83_ = _data_->v;
			_data_->_tmp81_ = ((gpointer) _data_->_tmp83_) != NULL;
		} else {
			_data_->_tmp81_ = FALSE;
		}
		if (_data_->_tmp81_) {
			_data_->_tmp84_ = _data_->v;
			_data_->_tmp85_ = (GValue) (*_data_->_tmp84_);
			_data_->_tmp86_ = g_value_get_object (&_data_->_tmp85_);
			_data_->_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp86_, g_loadable_icon_get_type (), GLoadableIcon));
			_data_->avatar = _data_->_tmp87_;
			_data_->_tmp88_ = _data_->avatar;
			if (_data_->_tmp88_ != NULL) {
				_data_->_tmp89_ = _data_->p_avatar;
				_data_->_tmp90_ = _data_->avatar;
				_data_->_state_ = 5;
				folks_avatar_details_change_avatar (_data_->_tmp89_, _data_->_tmp90_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_5:
				folks_avatar_details_change_avatar_finish (_data_->_tmp89_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->avatar);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->avatar);
		}
		_data_->_tmp91_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IM_ADDRESSES);
		_data_->_tmp92_ = g_hash_table_lookup (_data_->details, _data_->_tmp91_);
		_data_->v = (GValue*) _data_->_tmp92_;
		_data_->_tmp93_ = _data_->persona;
		_data_->_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp93_, FOLKS_TYPE_IM_DETAILS) ? ((FolksImDetails*) _data_->_tmp93_) : NULL);
		_data_->p_im = _data_->_tmp94_;
		_data_->_tmp96_ = _data_->p_im;
		if (_data_->_tmp96_ != NULL) {
			_data_->_tmp97_ = _data_->v;
			_data_->_tmp95_ = ((gpointer) _data_->_tmp97_) != NULL;
		} else {
			_data_->_tmp95_ = FALSE;
		}
		if (_data_->_tmp95_) {
			_data_->_tmp98_ = _data_->v;
			_data_->_tmp99_ = (GValue) (*_data_->_tmp98_);
			_data_->_tmp100_ = g_value_get_object (&_data_->_tmp99_);
			_data_->_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp100_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
			_data_->im_addresses = _data_->_tmp101_;
			_data_->_tmp102_ = _data_->im_addresses;
			if (_data_->_tmp102_ != NULL) {
				_data_->_tmp103_ = _data_->p_im;
				_data_->_tmp104_ = _data_->im_addresses;
				_data_->_state_ = 6;
				folks_im_details_change_im_addresses (_data_->_tmp103_, _data_->_tmp104_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_6:
				folks_im_details_change_im_addresses_finish (_data_->_tmp103_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->im_addresses);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->im_addresses);
		}
		_data_->_tmp105_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_PHONE_NUMBERS);
		_data_->_tmp106_ = g_hash_table_lookup (_data_->details, _data_->_tmp105_);
		_data_->v = (GValue*) _data_->_tmp106_;
		_data_->_tmp107_ = _data_->persona;
		_data_->_tmp108_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp107_, FOLKS_TYPE_PHONE_DETAILS) ? ((FolksPhoneDetails*) _data_->_tmp107_) : NULL);
		_data_->p_phone = _data_->_tmp108_;
		_data_->_tmp110_ = _data_->p_phone;
		if (_data_->_tmp110_ != NULL) {
			_data_->_tmp111_ = _data_->v;
			_data_->_tmp109_ = ((gpointer) _data_->_tmp111_) != NULL;
		} else {
			_data_->_tmp109_ = FALSE;
		}
		if (_data_->_tmp109_) {
			_data_->_tmp112_ = _data_->v;
			_data_->_tmp113_ = (GValue) (*_data_->_tmp112_);
			_data_->_tmp114_ = g_value_get_object (&_data_->_tmp113_);
			_data_->_tmp115_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp114_, GEE_TYPE_SET, GeeSet));
			_data_->phone_numbers = _data_->_tmp115_;
			_data_->_tmp116_ = _data_->phone_numbers;
			if (_data_->_tmp116_ != NULL) {
				_data_->_tmp117_ = _data_->p_phone;
				_data_->_tmp118_ = _data_->phone_numbers;
				_data_->_state_ = 7;
				folks_phone_details_change_phone_numbers (_data_->_tmp117_, _data_->_tmp118_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_7:
				folks_phone_details_change_phone_numbers_finish (_data_->_tmp117_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->phone_numbers);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->phone_numbers);
		}
		_data_->_tmp119_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES);
		_data_->_tmp120_ = g_hash_table_lookup (_data_->details, _data_->_tmp119_);
		_data_->v = (GValue*) _data_->_tmp120_;
		_data_->_tmp121_ = _data_->persona;
		_data_->_tmp122_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp121_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS) ? ((FolksPostalAddressDetails*) _data_->_tmp121_) : NULL);
		_data_->p_postal = _data_->_tmp122_;
		_data_->_tmp124_ = _data_->p_postal;
		if (_data_->_tmp124_ != NULL) {
			_data_->_tmp125_ = _data_->v;
			_data_->_tmp123_ = ((gpointer) _data_->_tmp125_) != NULL;
		} else {
			_data_->_tmp123_ = FALSE;
		}
		if (_data_->_tmp123_) {
			_data_->_tmp126_ = _data_->v;
			_data_->_tmp127_ = (GValue) (*_data_->_tmp126_);
			_data_->_tmp128_ = g_value_get_object (&_data_->_tmp127_);
			_data_->_tmp129_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp128_, GEE_TYPE_SET, GeeSet));
			_data_->postal_fds = _data_->_tmp129_;
			_data_->_tmp130_ = _data_->postal_fds;
			if (_data_->_tmp130_ != NULL) {
				_data_->_tmp131_ = _data_->p_postal;
				_data_->_tmp132_ = _data_->postal_fds;
				_data_->_state_ = 8;
				folks_postal_address_details_change_postal_addresses (_data_->_tmp131_, _data_->_tmp132_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_8:
				folks_postal_address_details_change_postal_addresses_finish (_data_->_tmp131_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->postal_fds);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->postal_fds);
		}
		_data_->_tmp133_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_LOCAL_IDS);
		_data_->_tmp134_ = g_hash_table_lookup (_data_->details, _data_->_tmp133_);
		_data_->v = (GValue*) _data_->_tmp134_;
		_data_->_tmp135_ = _data_->persona;
		_data_->_tmp136_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp135_, FOLKS_TYPE_LOCAL_ID_DETAILS) ? ((FolksLocalIdDetails*) _data_->_tmp135_) : NULL);
		_data_->p_local = _data_->_tmp136_;
		_data_->_tmp138_ = _data_->p_local;
		if (_data_->_tmp138_ != NULL) {
			_data_->_tmp139_ = _data_->v;
			_data_->_tmp137_ = ((gpointer) _data_->_tmp139_) != NULL;
		} else {
			_data_->_tmp137_ = FALSE;
		}
		if (_data_->_tmp137_) {
			_data_->_tmp140_ = _data_->v;
			_data_->_tmp141_ = (GValue) (*_data_->_tmp140_);
			_data_->_tmp142_ = g_value_get_object (&_data_->_tmp141_);
			_data_->_tmp143_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp142_, GEE_TYPE_SET, GeeSet));
			_data_->local_ids = _data_->_tmp143_;
			_data_->_tmp144_ = _data_->local_ids;
			if (_data_->_tmp144_ != NULL) {
				_data_->_tmp145_ = _data_->p_local;
				_data_->_tmp146_ = _data_->local_ids;
				_data_->_state_ = 9;
				folks_local_id_details_change_local_ids (_data_->_tmp145_, _data_->_tmp146_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_9:
				folks_local_id_details_change_local_ids_finish (_data_->_tmp145_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->local_ids);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->local_ids);
		}
		_data_->_tmp147_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
		_data_->_tmp148_ = g_hash_table_lookup (_data_->details, _data_->_tmp147_);
		_data_->v = (GValue*) _data_->_tmp148_;
		_data_->_tmp149_ = _data_->persona;
		_data_->_tmp150_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp149_, FOLKS_TYPE_WEB_SERVICE_DETAILS) ? ((FolksWebServiceDetails*) _data_->_tmp149_) : NULL);
		_data_->p_web = _data_->_tmp150_;
		_data_->_tmp152_ = _data_->p_web;
		if (_data_->_tmp152_ != NULL) {
			_data_->_tmp153_ = _data_->v;
			_data_->_tmp151_ = ((gpointer) _data_->_tmp153_) != NULL;
		} else {
			_data_->_tmp151_ = FALSE;
		}
		if (_data_->_tmp151_) {
			_data_->_tmp154_ = _data_->v;
			_data_->_tmp155_ = (GValue) (*_data_->_tmp154_);
			_data_->_tmp156_ = g_value_get_object (&_data_->_tmp155_);
			_data_->_tmp157_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp156_, GEE_TYPE_HASH_MULTI_MAP, GeeHashMultiMap));
			_data_->addrs = _data_->_tmp157_;
			_data_->_tmp158_ = _data_->addrs;
			if (_data_->_tmp158_ != NULL) {
				_data_->_tmp159_ = _data_->p_web;
				_data_->_tmp160_ = _data_->addrs;
				_data_->_state_ = 10;
				folks_web_service_details_change_web_service_addresses (_data_->_tmp159_, (GeeMultiMap*) _data_->_tmp160_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_10:
				folks_web_service_details_change_web_service_addresses_finish (_data_->_tmp159_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->addrs);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->addrs);
		}
		_data_->_tmp161_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NOTES);
		_data_->_tmp162_ = g_hash_table_lookup (_data_->details, _data_->_tmp161_);
		_data_->v = (GValue*) _data_->_tmp162_;
		_data_->_tmp163_ = _data_->persona;
		_data_->_tmp164_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp163_, FOLKS_TYPE_NOTE_DETAILS) ? ((FolksNoteDetails*) _data_->_tmp163_) : NULL);
		_data_->p_note = _data_->_tmp164_;
		_data_->_tmp166_ = _data_->p_note;
		if (_data_->_tmp166_ != NULL) {
			_data_->_tmp167_ = _data_->v;
			_data_->_tmp165_ = ((gpointer) _data_->_tmp167_) != NULL;
		} else {
			_data_->_tmp165_ = FALSE;
		}
		if (_data_->_tmp165_) {
			_data_->_tmp168_ = _data_->v;
			_data_->_tmp169_ = (GValue) (*_data_->_tmp168_);
			_data_->_tmp170_ = g_value_get_object (&_data_->_tmp169_);
			_data_->_tmp171_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp170_, GEE_TYPE_HASH_SET, GeeHashSet));
			_data_->notes = _data_->_tmp171_;
			_data_->_tmp172_ = _data_->notes;
			if (_data_->_tmp172_ != NULL) {
				_data_->_tmp173_ = _data_->p_note;
				_data_->_tmp174_ = _data_->notes;
				_data_->_state_ = 11;
				folks_note_details_change_notes (_data_->_tmp173_, (GeeSet*) _data_->_tmp174_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_11:
				folks_note_details_change_notes_finish (_data_->_tmp173_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->notes);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->notes);
		}
		_data_->_tmp175_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_GENDER);
		_data_->_tmp176_ = g_hash_table_lookup (_data_->details, _data_->_tmp175_);
		_data_->v = (GValue*) _data_->_tmp176_;
		_data_->_tmp177_ = _data_->persona;
		_data_->_tmp178_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp177_, FOLKS_TYPE_GENDER_DETAILS) ? ((FolksGenderDetails*) _data_->_tmp177_) : NULL);
		_data_->p_gender = _data_->_tmp178_;
		_data_->_tmp180_ = _data_->p_gender;
		if (_data_->_tmp180_ != NULL) {
			_data_->_tmp181_ = _data_->v;
			_data_->_tmp179_ = ((gpointer) _data_->_tmp181_) != NULL;
		} else {
			_data_->_tmp179_ = FALSE;
		}
		if (_data_->_tmp179_) {
			_data_->_tmp182_ = _data_->v;
			_data_->_tmp183_ = (GValue) (*_data_->_tmp182_);
			_data_->gender = (FolksGender) g_value_get_enum (&_data_->_tmp183_);
			_data_->_tmp184_ = _data_->p_gender;
			_data_->_state_ = 12;
			folks_gender_details_change_gender (_data_->_tmp184_, _data_->gender, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_12:
			folks_gender_details_change_gender_finish (_data_->_tmp184_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->p_gender);
				_g_object_unref0 (_data_->p_note);
				_g_object_unref0 (_data_->p_web);
				_g_object_unref0 (_data_->p_local);
				_g_object_unref0 (_data_->p_postal);
				_g_object_unref0 (_data_->p_phone);
				_g_object_unref0 (_data_->p_im);
				_g_object_unref0 (_data_->p_avatar);
				_g_object_unref0 (_data_->p_email);
				_g_object_unref0 (_data_->p_name);
				if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch0_folks_property_error;
				}
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp185_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_URLS);
		_data_->_tmp186_ = g_hash_table_lookup (_data_->details, _data_->_tmp185_);
		_data_->v = (GValue*) _data_->_tmp186_;
		_data_->_tmp187_ = _data_->persona;
		_data_->_tmp188_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp187_, FOLKS_TYPE_URL_DETAILS) ? ((FolksUrlDetails*) _data_->_tmp187_) : NULL);
		_data_->p_url = _data_->_tmp188_;
		_data_->_tmp190_ = _data_->p_url;
		if (_data_->_tmp190_ != NULL) {
			_data_->_tmp191_ = _data_->v;
			_data_->_tmp189_ = ((gpointer) _data_->_tmp191_) != NULL;
		} else {
			_data_->_tmp189_ = FALSE;
		}
		if (_data_->_tmp189_) {
			_data_->_tmp192_ = _data_->v;
			_data_->_tmp193_ = (GValue) (*_data_->_tmp192_);
			_data_->_tmp194_ = g_value_get_object (&_data_->_tmp193_);
			_data_->_tmp195_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp194_, GEE_TYPE_SET, GeeSet));
			_data_->urls = _data_->_tmp195_;
			_data_->_tmp196_ = _data_->urls;
			if (_data_->_tmp196_ != NULL) {
				_data_->_tmp197_ = _data_->p_url;
				_data_->_tmp198_ = _data_->urls;
				_data_->_state_ = 13;
				folks_url_details_change_urls (_data_->_tmp197_, _data_->_tmp198_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_13:
				folks_url_details_change_urls_finish (_data_->_tmp197_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->urls);
					_g_object_unref0 (_data_->p_url);
					_g_object_unref0 (_data_->p_gender);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->urls);
		}
		_data_->_tmp199_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_BIRTHDAY);
		_data_->_tmp200_ = g_hash_table_lookup (_data_->details, _data_->_tmp199_);
		_data_->v = (GValue*) _data_->_tmp200_;
		_data_->_tmp201_ = _data_->persona;
		_data_->_tmp202_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp201_, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) _data_->_tmp201_) : NULL);
		_data_->p_birthday = _data_->_tmp202_;
		_data_->_tmp204_ = _data_->p_birthday;
		if (_data_->_tmp204_ != NULL) {
			_data_->_tmp205_ = _data_->v;
			_data_->_tmp203_ = ((gpointer) _data_->_tmp205_) != NULL;
		} else {
			_data_->_tmp203_ = FALSE;
		}
		if (_data_->_tmp203_) {
			_data_->_tmp206_ = _data_->v;
			_data_->_tmp207_ = (GValue) (*_data_->_tmp206_);
			_data_->_tmp208_ = g_value_get_boxed (&_data_->_tmp207_);
			_data_->_tmp209_ = _g_date_time_ref0 ((GDateTime*) _data_->_tmp208_);
			_data_->birthday = _data_->_tmp209_;
			_data_->_tmp210_ = _data_->birthday;
			if (_data_->_tmp210_ != NULL) {
				_data_->_tmp211_ = _data_->p_birthday;
				_data_->_tmp212_ = _data_->birthday;
				_data_->_state_ = 14;
				folks_birthday_details_change_birthday (_data_->_tmp211_, _data_->_tmp212_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_14:
				folks_birthday_details_change_birthday_finish (_data_->_tmp211_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_date_time_unref0 (_data_->birthday);
					_g_object_unref0 (_data_->p_birthday);
					_g_object_unref0 (_data_->p_url);
					_g_object_unref0 (_data_->p_gender);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_date_time_unref0 (_data_->birthday);
		}
		_data_->_tmp213_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_ROLES);
		_data_->_tmp214_ = g_hash_table_lookup (_data_->details, _data_->_tmp213_);
		_data_->v = (GValue*) _data_->_tmp214_;
		_data_->_tmp215_ = _data_->persona;
		_data_->_tmp216_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp215_, FOLKS_TYPE_ROLE_DETAILS) ? ((FolksRoleDetails*) _data_->_tmp215_) : NULL);
		_data_->p_role = _data_->_tmp216_;
		_data_->_tmp218_ = _data_->p_role;
		if (_data_->_tmp218_ != NULL) {
			_data_->_tmp219_ = _data_->v;
			_data_->_tmp217_ = ((gpointer) _data_->_tmp219_) != NULL;
		} else {
			_data_->_tmp217_ = FALSE;
		}
		if (_data_->_tmp217_) {
			_data_->_tmp220_ = _data_->v;
			_data_->_tmp221_ = (GValue) (*_data_->_tmp220_);
			_data_->_tmp222_ = g_value_get_object (&_data_->_tmp221_);
			_data_->_tmp223_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp222_, GEE_TYPE_SET, GeeSet));
			_data_->roles = _data_->_tmp223_;
			_data_->_tmp224_ = _data_->roles;
			if (_data_->_tmp224_ != NULL) {
				_data_->_tmp225_ = _data_->p_role;
				_data_->_tmp226_ = _data_->roles;
				_data_->_state_ = 15;
				folks_role_details_change_roles (_data_->_tmp225_, _data_->_tmp226_, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
				return FALSE;
				_state_15:
				folks_role_details_change_roles_finish (_data_->_tmp225_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->roles);
					_g_object_unref0 (_data_->p_role);
					_g_object_unref0 (_data_->p_birthday);
					_g_object_unref0 (_data_->p_url);
					_g_object_unref0 (_data_->p_gender);
					_g_object_unref0 (_data_->p_note);
					_g_object_unref0 (_data_->p_web);
					_g_object_unref0 (_data_->p_local);
					_g_object_unref0 (_data_->p_postal);
					_g_object_unref0 (_data_->p_phone);
					_g_object_unref0 (_data_->p_im);
					_g_object_unref0 (_data_->p_avatar);
					_g_object_unref0 (_data_->p_email);
					_g_object_unref0 (_data_->p_name);
					if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
						goto __catch0_folks_property_error;
					}
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->iid);
					_g_free0 (_data_->uid);
					_g_free0 (_data_->contact_id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->roles);
		}
		_data_->_tmp227_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IS_FAVOURITE);
		_data_->_tmp228_ = g_hash_table_lookup (_data_->details, _data_->_tmp227_);
		_data_->v = (GValue*) _data_->_tmp228_;
		_data_->_tmp229_ = _data_->persona;
		_data_->_tmp230_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp229_, FOLKS_TYPE_FAVOURITE_DETAILS) ? ((FolksFavouriteDetails*) _data_->_tmp229_) : NULL);
		_data_->p_favourite = _data_->_tmp230_;
		_data_->_tmp232_ = _data_->p_favourite;
		if (_data_->_tmp232_ != NULL) {
			_data_->_tmp233_ = _data_->v;
			_data_->_tmp231_ = ((gpointer) _data_->_tmp233_) != NULL;
		} else {
			_data_->_tmp231_ = FALSE;
		}
		if (_data_->_tmp231_) {
			_data_->_tmp234_ = _data_->v;
			_data_->_tmp235_ = (GValue) (*_data_->_tmp234_);
			_data_->is_fav = g_value_get_boolean (&_data_->_tmp235_);
			_data_->_tmp236_ = _data_->p_favourite;
			_data_->_state_ = 16;
			folks_favourite_details_change_is_favourite (_data_->_tmp236_, _data_->is_fav, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_16:
			folks_favourite_details_change_is_favourite_finish (_data_->_tmp236_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->p_favourite);
				_g_object_unref0 (_data_->p_role);
				_g_object_unref0 (_data_->p_birthday);
				_g_object_unref0 (_data_->p_url);
				_g_object_unref0 (_data_->p_gender);
				_g_object_unref0 (_data_->p_note);
				_g_object_unref0 (_data_->p_web);
				_g_object_unref0 (_data_->p_local);
				_g_object_unref0 (_data_->p_postal);
				_g_object_unref0 (_data_->p_phone);
				_g_object_unref0 (_data_->p_im);
				_g_object_unref0 (_data_->p_avatar);
				_g_object_unref0 (_data_->p_email);
				_g_object_unref0 (_data_->p_name);
				if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch0_folks_property_error;
				}
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (_data_->p_favourite);
		_g_object_unref0 (_data_->p_role);
		_g_object_unref0 (_data_->p_birthday);
		_g_object_unref0 (_data_->p_url);
		_g_object_unref0 (_data_->p_gender);
		_g_object_unref0 (_data_->p_note);
		_g_object_unref0 (_data_->p_web);
		_g_object_unref0 (_data_->p_local);
		_g_object_unref0 (_data_->p_postal);
		_g_object_unref0 (_data_->p_phone);
		_g_object_unref0 (_data_->p_im);
		_g_object_unref0 (_data_->p_avatar);
		_g_object_unref0 (_data_->p_email);
		_g_object_unref0 (_data_->p_name);
	}
	goto __finally0;
	__catch0_folks_property_error:
	{
		_data_->e1 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp237_ = _data_->e1;
		_data_->_tmp238_ = _data_->_tmp237_->message;
		_data_->_tmp239_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, "Setting a property on the new persona failed: %s", _data_->_tmp238_);
		_data_->_inner_error0_ = _data_->_tmp239_;
		_g_error_free0 (_data_->e1);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->persona);
			_g_free0 (_data_->iid);
			_g_free0 (_data_->uid);
			_g_free0 (_data_->contact_id);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->persona);
			_g_free0 (_data_->iid);
			_g_free0 (_data_->uid);
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp240_ = _data_->self->priv->_add_persona_from_details_mock;
	_data_->_tmp240__target = _data_->self->priv->_add_persona_from_details_mock_target;
	if (_data_->_tmp240_ != NULL) {
		_data_->_tmp241_ = _data_->self->priv->_add_persona_from_details_mock;
		_data_->_tmp241__target = _data_->self->priv->_add_persona_from_details_mock_target;
		_data_->_tmp242_ = _data_->persona;
		_data_->delay = _data_->_tmp241_ (_data_->_tmp242_, _data_->_tmp241__target, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->iid);
				_g_free0 (_data_->uid);
				_g_free0 (_data_->contact_id);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_state_ = 17;
		_folks_dummy_persona_store_implement_mock_delay (_data_->self, _data_->delay, folks_dummy_persona_store_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_17:
		_folks_dummy_persona_store_implement_mock_delay_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp243_ = _data_->self->priv->_personas;
	_data_->_tmp244_ = _data_->persona;
	_data_->_tmp245_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp244_);
	_data_->_tmp246_ = _data_->_tmp245_;
	_data_->_tmp247_ = _data_->persona;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp243_, _data_->_tmp246_, _data_->_tmp247_);
	_data_->_tmp248_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->added_personas = _data_->_tmp248_;
	_data_->_tmp249_ = _data_->added_personas;
	_data_->_tmp250_ = _data_->persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp249_, _data_->_tmp250_);
	_data_->_tmp251_ = _data_->added_personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->_tmp251_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_data_->result = (FolksPersona*) _data_->persona;
	_g_object_unref0 (_data_->added_personas);
	_g_free0 (_data_->iid);
	_g_free0 (_data_->uid);
	_g_free0 (_data_->contact_id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_dummy_persona_store_real_remove_persona_data_free (gpointer _data)
{
	FolksDummyPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaStoreRemovePersonaData, _data_);
}

static void
folks_dummy_persona_store_real_remove_persona (FolksPersonaStore* base,
                                               FolksPersona* persona,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	FolksDummyPersonaStore * self;
	FolksDummyPersonaStoreRemovePersonaData* _data_;
	FolksDummyPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	g_return_if_fail (persona != NULL);
	self = (FolksDummyPersonaStore*) base;
	_data_ = g_slice_new0 (FolksDummyPersonaStoreRemovePersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_dummy_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (persona);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp1_;
	folks_dummy_persona_store_real_remove_persona_co (_data_);
}

static void
folks_dummy_persona_store_remove_persona_finish (FolksPersonaStore* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	FolksDummyPersonaStoreRemovePersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   *
   * @param persona the persona that should be removed
   * @throws Folks.PersonaStoreError.STORE_OFFLINE if the store hasn’t been
   * prepared or has gone offline
   * @throws Folks.PersonaStoreError.PERMISSION_DENIED if the store denied
   * permission to delete the contact
   * @throws Folks.PersonaStoreError.READ_ONLY if the store is read only
   * @throws Folks.PersonaStoreError.REMOVE_FAILED if any other errors happened
   * in the store
   *
   * @since 0.9.7
   */
static void
folks_dummy_persona_store_remove_persona_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	FolksDummyPersonaStoreRemovePersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_dummy_persona_store_real_remove_persona_co (_data_);
}

static gboolean
folks_dummy_persona_store_real_remove_persona_co (FolksDummyPersonaStoreRemovePersonaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_vala_return_val_if_fail (FOLKS_DUMMY_IS_PERSONA (_data_->persona), "persona is FolksDummy.Persona", FALSE);
	if (!_data_->self->priv->_is_prepared) {
		_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, "Persona store has not yet been prepared.");
		_data_->_inner_error0_ = _data_->_tmp0_;
		if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = _data_->self->priv->_remove_persona_mock;
	_data_->_tmp1__target = _data_->self->priv->_remove_persona_mock_target;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->_remove_persona_mock;
		_data_->_tmp2__target = _data_->self->priv->_remove_persona_mock_target;
		_data_->delay = _data_->_tmp2_ (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona), _data_->_tmp2__target, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_state_ = 1;
		_folks_dummy_persona_store_implement_mock_delay (_data_->self, _data_->delay, folks_dummy_persona_store_remove_persona_ready, _data_);
		return FALSE;
		_state_1:
		_folks_dummy_persona_store_implement_mock_delay_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp3_ = _data_->self->priv->_personas;
	_data_->_tmp4_ = folks_persona_get_iid (_data_->persona);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp3_, _data_->_tmp5_);
	_data_->_persona = (FolksDummyPersona*) _data_->_tmp6_;
	_data_->_tmp7_ = _data_->_persona;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp8_ = _data_->self->priv->_personas;
		_data_->_tmp9_ = folks_persona_get_iid (_data_->persona);
		_data_->_tmp10_ = _data_->_tmp9_;
		gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp8_, _data_->_tmp10_, NULL);
		_data_->_tmp11_ = _data_->self->priv->_pending_persona_registrations;
		_data_->_tmp12_ = _data_->_persona;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona));
		_data_->_tmp13_ = _data_->self->priv->_pending_persona_unregistrations;
		_data_->_tmp14_ = _data_->_persona;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona));
		_data_->_tmp15_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->removed_personas = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->removed_personas;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_PERSONA, FolksPersona));
		_data_->_tmp17_ = _data_->removed_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, NULL, (GeeSet*) _data_->_tmp17_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (_data_->removed_personas);
	}
	_g_object_unref0 (_data_->_persona);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_dummy_persona_store_real_prepare_data_free (gpointer _data)
{
	FolksDummyPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaStorePrepareData, _data_);
}

static void
folks_dummy_persona_store_real_prepare (FolksPersonaStore* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	FolksDummyPersonaStore * self;
	FolksDummyPersonaStorePrepareData* _data_;
	FolksDummyPersonaStore* _tmp0_;
	self = (FolksDummyPersonaStore*) base;
	_data_ = g_slice_new0 (FolksDummyPersonaStorePrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_dummy_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_dummy_persona_store_real_prepare_co (_data_);
}

static void
folks_dummy_persona_store_prepare_finish (FolksPersonaStore* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	FolksDummyPersonaStorePrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   *
   * @throws Folks.PersonaStoreError.STORE_OFFLINE if the store is offline
   * @throws Folks.PersonaStoreError.PERMISSION_DENIED if permission was denied
   * to open the store
   * @throws Folks.PersonaStoreError.INVALID_ARGUMENT if any other error
   * occurred in the store
   *
   * @since 0.9.7
   */
static void
folks_dummy_persona_store_prepare_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	FolksDummyPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_dummy_persona_store_real_prepare_co (_data_);
}

static gboolean
folks_dummy_persona_store_real_prepare_co (FolksDummyPersonaStorePrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing Dummy.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	if (_data_->self->priv->_is_prepared == TRUE) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending == TRUE;
	}
	if (_data_->_tmp2_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp3_ = _data_->self->priv->_prepare_mock;
		_data_->_tmp3__target = _data_->self->priv->_prepare_mock_target;
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = _data_->self->priv->_prepare_mock;
			_data_->_tmp4__target = _data_->self->priv->_prepare_mock_target;
			_data_->delay = _data_->_tmp4_ (_data_->_tmp4__target, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __finally0;
			}
			_data_->_state_ = 1;
			_folks_dummy_persona_store_implement_mock_delay (_data_->self, _data_->delay, folks_dummy_persona_store_prepare_ready, _data_);
			return FALSE;
			_state_1:
			_folks_dummy_persona_store_implement_mock_delay_finish (_data_->self, _data_->_res_);
		}
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		if (_data_->self->priv->_quiescent_on_prepare == TRUE) {
			folks_dummy_persona_store_reach_quiescence (_data_->self);
		}
	}
	__finally0:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	folks_internal_profiling_end ("preparing Dummy.PersonaStore", NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_folks_dummy_persona_store_implement_mock_delay_data_free (gpointer _data)
{
	FolksDummyPersonaStoreImplementMockDelayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaStoreImplementMockDelayData, _data_);
}

static void
_folks_dummy_persona_store_implement_mock_delay (FolksDummyPersonaStore* self,
                                                 gint delay,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	FolksDummyPersonaStoreImplementMockDelayData* _data_;
	FolksDummyPersonaStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksDummyPersonaStoreImplementMockDelayData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_dummy_persona_store_implement_mock_delay_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->delay = delay;
	_folks_dummy_persona_store_implement_mock_delay_co (_data_);
}

static void
_folks_dummy_persona_store_implement_mock_delay_finish (FolksDummyPersonaStore* self,
                                                        GAsyncResult* _res_)
{
	FolksDummyPersonaStoreImplementMockDelayData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
   * Delay for the given number of milliseconds.
   *
   * This implements an asynchronous delay (which should be yielded on) until
   * the given number of milliseconds has elapsed.
   *
   * If ``delay`` is negative, this function returns immediately. If it is
   * zero, this function returns in an idle callback.
   *
   * @param delay number of milliseconds to delay for
   *
   * @since 0.9.7
   */
static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		FolksDummyPersonaStore* self;
		self = _data20_->self;
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static gboolean
____lambda6_ (Block20Data* _data20_)
{
	FolksDummyPersonaStore* self;
	gboolean result;
	self = _data20_->self;
	_folks_dummy_persona_store_implement_mock_delay_co (_data20_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
_____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda6_ (self);
	return result;
}

static gboolean
____lambda7_ (Block20Data* _data20_)
{
	FolksDummyPersonaStore* self;
	gboolean result;
	self = _data20_->self;
	_folks_dummy_persona_store_implement_mock_delay_co (_data20_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
_____lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda7_ (self);
	return result;
}

static gboolean
_folks_dummy_persona_store_implement_mock_delay_co (FolksDummyPersonaStoreImplementMockDelayData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data20_ = g_slice_new0 (Block20Data);
	_data_->_data20_->_ref_count_ = 1;
	_data_->_data20_->self = g_object_ref (_data_->self);
	_data_->_data20_->_async_data_ = _data_;
	if (_data_->delay < 0) {
		block20_data_unref (_data_->_data20_);
		_data_->_data20_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		if (_data_->delay == 0) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda6__gsource_func, block20_data_ref (_data_->_data20_), block20_data_unref);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
		} else {
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _data_->delay, _____lambda7__gsource_func, block20_data_ref (_data_->_data20_), block20_data_unref);
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
		}
	}
	block20_data_unref (_data_->_data20_);
	_data_->_data20_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Set capabilities of the persona store.
   *
   * This sets the capabilities of the store, as if they were changed on a
   * backing store somewhere. This is intended to be used for testing code which
   * depends on the values of {@link Folks.PersonaStore.can_add_personas},
   * {@link Folks.PersonaStore.can_alias_personas} and
   * {@link Folks.PersonaStore.can_remove_personas}.
   *
   * @param can_add_personas whether the store can handle adding personas
   * @param can_alias_personas whether the store can handle and update
   * user-specified persona aliases
   * @param can_remove_personas whether the store can handle removing personas
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_store_update_capabilities (FolksDummyPersonaStore* self,
                                               FolksMaybeBool can_add_personas,
                                               FolksMaybeBool can_alias_personas,
                                               FolksMaybeBool can_remove_personas)
{
	g_return_if_fail (self != NULL);
	g_object_freeze_notify ((GObject*) self);
	if (can_add_personas != self->priv->_can_add_personas) {
		self->priv->_can_add_personas = can_add_personas;
		g_object_notify ((GObject*) self, "can-add-personas");
	}
	if (can_alias_personas != self->priv->_can_alias_personas) {
		self->priv->_can_alias_personas = can_alias_personas;
		g_object_notify ((GObject*) self, "can-alias-personas");
	}
	if (can_remove_personas != self->priv->_can_remove_personas) {
		self->priv->_can_remove_personas = can_remove_personas;
		g_object_notify ((GObject*) self, "can-remove-personas");
	}
	g_object_thaw_notify ((GObject*) self);
}

/**
   * Freeze persona changes in the store.
   *
   * This freezes externally-visible changes to the set of personas in the store
   * until {@link FolksDummy.PersonaStore.thaw_personas_changed} is called, at
   * which point all pending changes are made visible in the
   * {@link Folks.PersonaStore.personas} property and by emitting
   * {@link Folks.PersonaStore.personas_changed}.
   *
   * Calls to {@link FolksDummy.PersonaStore.freeze_personas_changed} and
   * {@link FolksDummy.PersonaStore.thaw_personas_changed} must be well-nested.
   * Pending changes will only be committed after the final call to
   * {@link FolksDummy.PersonaStore.thaw_personas_changed}.
   *
   * @see PersonaStore.thaw_personas_changed
   * @since 0.9.7
   */
void
folks_dummy_persona_store_freeze_personas_changed (FolksDummyPersonaStore* self)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_personas_changed_frozen;
	self->priv->_personas_changed_frozen = _tmp0_ + 1;
}

/**
   * Thaw persona changes in the store.
   *
   * This thaws externally-visible changes to the set of personas in the store.
   * If the number of calls to
   * {@link FolksDummy.PersonaStore.thaw_personas_changed} matches the number of
   * calls to {@link FolksDummy.PersonaStore.freeze_personas_changed}, all
   * pending changes are committed and made externally-visible.
   *
   * @see PersonaStore.freeze_personas_changed
   * @since 0.9.7
   */
void
folks_dummy_persona_store_thaw_personas_changed (FolksDummyPersonaStore* self)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_assert (self->priv->_personas_changed_frozen > ((guint) 0), "this._personas_changed_frozen > 0");
	_tmp0_ = self->priv->_personas_changed_frozen;
	self->priv->_personas_changed_frozen = _tmp0_ - 1;
	if (self->priv->_personas_changed_frozen == ((guint) 0)) {
		GeeHashSet* _tmp1_;
		GeeHashSet* _tmp2_;
		GeeHashSet* _tmp3_;
		GeeHashSet* _tmp4_;
		_tmp1_ = self->priv->_pending_persona_registrations;
		_tmp2_ = self->priv->_pending_persona_unregistrations;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp1_, (GeeSet*) _tmp2_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_tmp3_ = self->priv->_pending_persona_registrations;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
		_tmp4_ = self->priv->_pending_persona_unregistrations;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
	}
}

/**
   * Register new personas with the persona store.
   *
   * This registers a set of personas as if they had just appeared in the
   * backing store. If the persona store is not frozen (see
   * {@link FolksDummy.PersonaStore.freeze_personas_changed}) the changes are
   * made externally visible on the store immediately (e.g. in the
   * {@link Folks.PersonaStore.personas} property and through a
   * {@link Folks.PersonaStore.personas_changed} signal). If the store is
   * frozen, the changes will be pending until the store is next unfrozen.
   *
   * All elements in the @personas set be of type
   * {@link FolksDummy.PersonaStore.persona_type}.
   *
   * @param personas set of personas to register
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_store_register_personas (FolksDummyPersonaStore* self,
                                             GeeSet* personas)
{
	GeeSet* added_personas = NULL;
	gboolean emit_notifications = FALSE;
	gboolean _tmp25_ = FALSE;
	GeeSet* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (personas != NULL);
	emit_notifications = self->priv->_personas_changed_frozen == ((guint) 0);
	if (emit_notifications == FALSE) {
		GeeHashSet* _tmp0_;
		GeeSet* _tmp1_;
		_tmp0_ = self->priv->_pending_persona_registrations;
		_tmp1_ = _g_object_ref0 ((GeeSet*) _tmp0_);
		_g_object_unref0 (added_personas);
		added_personas = _tmp1_;
	} else {
		GeeHashSet* _tmp2_;
		_tmp2_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (added_personas);
		added_personas = (GeeSet*) _tmp2_;
	}
	{
		GeeIterator* _persona_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) personas);
		_persona_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksDummyPersona* persona = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			FolksDummyPersona* _tmp7_;
			GeeHashSet* _tmp8_;
			FolksDummyPersona* _tmp9_;
			GeeHashMap* _tmp14_;
			FolksDummyPersona* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			GeeSet* _tmp18_;
			FolksDummyPersona* _tmp19_;
			_tmp4_ = _persona_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _persona_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			persona = (FolksDummyPersona*) _tmp6_;
			_tmp7_ = persona;
			_vala_assert (g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) _tmp7_), self->priv->_persona_type), "persona.get_type ().is_a (this._persona_type)");
			_tmp8_ = self->priv->_pending_persona_unregistrations;
			_tmp9_ = persona;
			if (gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp8_, _tmp9_)) {
				GeeHashMap* _tmp10_;
				FolksDummyPersona* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = self->priv->_personas;
				_tmp11_ = persona;
				_tmp12_ = folks_persona_get_iid ((FolksPersona*) _tmp11_);
				_tmp13_ = _tmp12_;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp10_, _tmp13_, NULL);
			}
			_tmp14_ = self->priv->_personas;
			_tmp15_ = persona;
			_tmp16_ = folks_persona_get_iid ((FolksPersona*) _tmp15_);
			_tmp17_ = _tmp16_;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp14_, _tmp17_)) {
				_g_object_unref0 (persona);
				continue;
			}
			_tmp18_ = added_personas;
			_tmp19_ = persona;
			gee_collection_add ((GeeCollection*) _tmp18_, _tmp19_);
			if (emit_notifications == TRUE) {
				GeeHashMap* _tmp20_;
				FolksDummyPersona* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				FolksDummyPersona* _tmp24_;
				_tmp20_ = self->priv->_personas;
				_tmp21_ = persona;
				_tmp22_ = folks_persona_get_iid ((FolksPersona*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = persona;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp23_, _tmp24_);
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp26_ = added_personas;
	_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ > 0) {
		_tmp25_ = emit_notifications == TRUE;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		GeeSet* _tmp29_;
		_tmp29_ = added_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, _tmp29_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (added_personas);
}

/**
   * Unregister existing personas with the persona store.
   *
   * This unregisters a set of personas as if they had just disappeared from the
   * backing store. If the persona store is not frozen (see
   * {@link FolksDummy.PersonaStore.freeze_personas_changed}) the changes are
   * made externally visible on the store immediately (e.g. in the
   * {@link Folks.PersonaStore.personas} property and through a
   * {@link Folks.PersonaStore.personas_changed} signal). If the store is
   * frozen, the changes will be pending until the store is next unfrozen.
   *
   * @param personas set of personas to unregister
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_store_unregister_personas (FolksDummyPersonaStore* self,
                                               GeeSet* personas)
{
	GeeSet* removed_personas = NULL;
	gboolean emit_notifications = FALSE;
	gboolean _tmp17_ = FALSE;
	GeeSet* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (personas != NULL);
	emit_notifications = self->priv->_personas_changed_frozen == ((guint) 0);
	if (emit_notifications == FALSE) {
		GeeHashSet* _tmp0_;
		GeeSet* _tmp1_;
		_tmp0_ = self->priv->_pending_persona_unregistrations;
		_tmp1_ = _g_object_ref0 ((GeeSet*) _tmp0_);
		_g_object_unref0 (removed_personas);
		removed_personas = _tmp1_;
	} else {
		GeeHashSet* _tmp2_;
		_tmp2_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (removed_personas);
		removed_personas = (GeeSet*) _tmp2_;
	}
	{
		GeeIterator* __persona_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) personas);
		__persona_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksDummyPersona* _persona = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeHashSet* _tmp7_;
			FolksDummyPersona* _tmp8_;
			FolksDummyPersona* persona = NULL;
			GeeHashMap* _tmp9_;
			FolksDummyPersona* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gpointer _tmp13_;
			FolksDummyPersona* _tmp14_;
			GeeSet* _tmp15_;
			FolksDummyPersona* _tmp16_;
			_tmp4_ = __persona_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = __persona_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			_persona = (FolksDummyPersona*) _tmp6_;
			_tmp7_ = self->priv->_pending_persona_registrations;
			_tmp8_ = _persona;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			_tmp9_ = self->priv->_personas;
			_tmp10_ = _persona;
			_tmp11_ = folks_persona_get_iid ((FolksPersona*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp12_);
			persona = (FolksDummyPersona*) _tmp13_;
			_tmp14_ = persona;
			if (_tmp14_ == NULL) {
				_g_object_unref0 (persona);
				_g_object_unref0 (_persona);
				continue;
			}
			_tmp15_ = removed_personas;
			_tmp16_ = persona;
			gee_collection_add ((GeeCollection*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona));
			_g_object_unref0 (persona);
			_g_object_unref0 (_persona);
		}
		_g_object_unref0 (__persona_it);
	}
	_tmp18_ = removed_personas;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ > 0) {
		_tmp17_ = emit_notifications == TRUE;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GeeSet* _tmp30_;
		{
			GeeIterator* __persona_it = NULL;
			GeeSet* _tmp21_;
			GeeIterator* _tmp22_;
			_tmp21_ = removed_personas;
			_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
			__persona_it = _tmp22_;
			while (TRUE) {
				GeeIterator* _tmp23_;
				FolksDummyPersona* _persona = NULL;
				GeeIterator* _tmp24_;
				gpointer _tmp25_;
				GeeHashMap* _tmp26_;
				FolksDummyPersona* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp23_ = __persona_it;
				if (!gee_iterator_next (_tmp23_)) {
					break;
				}
				_tmp24_ = __persona_it;
				_tmp25_ = gee_iterator_get (_tmp24_);
				_persona = (FolksDummyPersona*) _tmp25_;
				_tmp26_ = self->priv->_personas;
				_tmp27_ = _persona;
				_tmp28_ = folks_persona_get_iid ((FolksPersona*) _tmp27_);
				_tmp29_ = _tmp28_;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp26_, _tmp29_, NULL);
				_g_object_unref0 (_persona);
			}
			_g_object_unref0 (__persona_it);
		}
		_tmp30_ = removed_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, _tmp30_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (removed_personas);
}

/**
   * Reach quiescence on the store.
   *
   * If the {@link Folks.PersonaStore.prepare} method has already been called on
   * the store, this causes the store to signal that it has reached quiescence
   * immediately. If the store has not yet been prepared, this will set a flag
   * to ensure that quiescence is reached as soon as
   * {@link Folks.PersonaStore.prepare} is called.
   *
   * This must be called before the store will reach quiescence.
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_store_reach_quiescence (FolksDummyPersonaStore* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_is_prepared == FALSE) {
		self->priv->_quiescent_on_prepare = TRUE;
		return;
	}
	if (self->priv->_is_quiescent == FALSE) {
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
}

/**
   * Update the {@link Folks.PersonaStore.is_user_set_default} property.
   *
   * Backend method for use by test code to simulate a backing-store-driven
   * change in the {@link Folks.PersonaStore.is_user_set_default} property.
   *
   * @param is_user_set_default new value for the property
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_store_update_is_user_set_default (FolksDummyPersonaStore* self,
                                                      gboolean is_user_set_default)
{
	g_return_if_fail (self != NULL);
	folks_persona_store_set_is_user_set_default ((FolksPersonaStore*) self, is_user_set_default);
}

/**
   * Update the {@link Folks.PersonaStore.trust_level} property.
   *
   * Backend method for use by test code to simulate a backing-store-driven
   * change in the {@link Folks.PersonaStore.trust_level} property.
   *
   * @param trust_level new value for the property
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_store_update_trust_level (FolksDummyPersonaStore* self,
                                              FolksPersonaStoreTrust trust_level)
{
	g_return_if_fail (self != NULL);
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, trust_level);
}

/**
   * Mock function for {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * This function is called whenever this store's
   * {@link Folks.PersonaStore.add_persona_from_details} method is called. It
   * allows the caller to determine whether adding the given persona should
   * fail, by throwing an error from this mock function. If no error is thrown
   * from this function, adding the given persona will succeed. This is useful
   * for testing error handling of calls to
   * {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * The value returned by this function gives a delay which is imposed for
   * completion of the {@link Folks.PersonaStore.add_persona_from_details} call.
   * Negative or zero delays
   * result in completion in an idle callback, and positive delays result in
   * completion after that many milliseconds.
   *
   * If this is ``null``, all calls to
   * {@link Folks.PersonaStore.add_persona_from_details} will succeed.
   *
   * This mock function may be changed at any time; changes will take effect for
   * the next call to {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_store_set_add_persona_from_details_mock (FolksDummyPersonaStore* self,
                                                             FolksDummyPersonaStoreAddPersonaFromDetailsMock mock,
                                                             gpointer mock_target)
{
	g_return_if_fail (self != NULL);
	self->priv->_add_persona_from_details_mock = mock;
	self->priv->_add_persona_from_details_mock_target = mock_target;
}

/**
   * Mock function for {@link Folks.PersonaStore.remove_persona}.
   *
   * This function is called whenever this store's
   * {@link Folks.PersonaStore.remove_persona} method is called. It allows
   * the caller to determine whether removing the given persona should fail, by
   * throwing an error from this mock function. If no error is thrown from this
   * function, removing the given persona will succeed. This is useful for
   * testing error handling of calls to
   * {@link Folks.PersonaStore.remove_persona}.
   *
   * See {@link FolksDummy.PersonaStore.set_add_persona_from_details_mock}.
   *
   * This mock function may be changed at any time; changes will take effect for
   * the next call to {@link Folks.PersonaStore.remove_persona}.
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_store_set_remove_persona_mock (FolksDummyPersonaStore* self,
                                                   FolksDummyPersonaStoreRemovePersonaMock mock,
                                                   gpointer mock_target)
{
	g_return_if_fail (self != NULL);
	self->priv->_remove_persona_mock = mock;
	self->priv->_remove_persona_mock_target = mock_target;
}

/**
   * Mock function for {@link Folks.PersonaStore.prepare}.
   *
   * This function is called whenever this store's
   * {@link Folks.PersonaStore.prepare} method is called on an unprepared store.
   * It allows the caller to determine whether preparing the store should fail,
   * by throwing an error from this mock function. If no error is thrown from
   * this function, preparing the store will succeed (and all future calls to
   * {@link Folks.PersonaStore.prepare} will return immediately without calling
   * this mock function). This is useful for testing error handling of calls to
   * {@link Folks.PersonaStore.prepare}.
   *
   * See {@link FolksDummy.PersonaStore.set_add_persona_from_details_mock}.
   *
   * This mock function may be changed at any time; changes will take effect for
   * the next call to {@link Folks.PersonaStore.prepare}.
   *
   * @since 0.9.7
   */
void
folks_dummy_persona_store_set_prepare_mock (FolksDummyPersonaStore* self,
                                            FolksDummyPersonaStorePrepareMock mock,
                                            gpointer mock_target)
{
	g_return_if_fail (self != NULL);
	self->priv->_prepare_mock = mock;
	self->priv->_prepare_mock_target = mock_target;
}

static const gchar*
folks_dummy_persona_store_real_get_type_id (FolksPersonaStore* base)
{
	const gchar* result;
	FolksDummyPersonaStore* self;
	self = (FolksDummyPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}

static FolksMaybeBool
folks_dummy_persona_store_real_get_can_add_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksDummyPersonaStore* self;
	self = (FolksDummyPersonaStore*) base;
	if (!self->priv->_is_prepared) {
		result = FOLKS_MAYBE_BOOL_FALSE;
		return result;
	}
	result = self->priv->_can_add_personas;
	return result;
}

static FolksMaybeBool
folks_dummy_persona_store_real_get_can_alias_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksDummyPersonaStore* self;
	self = (FolksDummyPersonaStore*) base;
	if (!self->priv->_is_prepared) {
		result = FOLKS_MAYBE_BOOL_FALSE;
		return result;
	}
	result = self->priv->_can_alias_personas;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static FolksMaybeBool
folks_dummy_persona_store_real_get_can_group_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksDummyPersonaStore* self;
	FolksMaybeBool _tmp0_ = 0;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (FolksDummyPersonaStore*) base;
	_tmp1_ = self->priv->_always_writeable_properties;
	_tmp1__length1 = self->priv->_always_writeable_properties_length1;
	if (_vala_string_array_contains (_tmp1_, _tmp1__length1, "groups")) {
		_tmp0_ = FOLKS_MAYBE_BOOL_TRUE;
	} else {
		_tmp0_ = FOLKS_MAYBE_BOOL_FALSE;
	}
	result = _tmp0_;
	return result;
}

static FolksMaybeBool
folks_dummy_persona_store_real_get_can_remove_personas (FolksPersonaStore* base)
{
	FolksMaybeBool result;
	FolksDummyPersonaStore* self;
	self = (FolksDummyPersonaStore*) base;
	if (!self->priv->_is_prepared) {
		result = FOLKS_MAYBE_BOOL_FALSE;
		return result;
	}
	result = self->priv->_can_remove_personas;
	return result;
}

static gboolean
folks_dummy_persona_store_real_get_is_prepared (FolksPersonaStore* base)
{
	gboolean result;
	FolksDummyPersonaStore* self;
	self = (FolksDummyPersonaStore*) base;
	result = self->priv->_is_prepared;
	return result;
}

static gchar**
folks_dummy_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base,
                                                                gint* result_length1)
{
	gchar** result;
	FolksDummyPersonaStore* self;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (FolksDummyPersonaStore*) base;
	if (!self->priv->_is_prepared) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		gchar** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = folks_dummy_persona_store__always_writeable_properties_empty;
		_tmp0__length1 = folks_dummy_persona_store__always_writeable_properties_empty_length1;
		_tmp1_ = _tmp0_;
		_tmp1__length1 = _tmp0__length1;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_always_writeable_properties;
	_tmp2__length1 = self->priv->_always_writeable_properties_length1;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gboolean
folks_dummy_persona_store_real_get_is_quiescent (FolksPersonaStore* base)
{
	gboolean result;
	FolksDummyPersonaStore* self;
	self = (FolksDummyPersonaStore*) base;
	result = self->priv->_is_quiescent;
	return result;
}

static GeeMap*
folks_dummy_persona_store_real_get_personas (FolksPersonaStore* base)
{
	GeeMap* result;
	FolksDummyPersonaStore* self;
	GeeMap* _tmp0_;
	self = (FolksDummyPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}

GType
folks_dummy_persona_store_get_persona_type (FolksDummyPersonaStore* self)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_persona_type;
	return result;
}

void
folks_dummy_persona_store_set_persona_type (FolksDummyPersonaStore* self,
                                            GType value)
{
	g_return_if_fail (self != NULL);
	_vala_assert (g_type_is_a (value, FOLKS_DUMMY_TYPE_PERSONA), "value.is_a (typeof (FolksDummy.Persona))");
	if (self->priv->_persona_type != value) {
		self->priv->_persona_type = value;
		g_object_notify ((GObject*) self, "persona-type");
	}
	g_object_notify_by_pspec ((GObject *) self, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE_PROPERTY]);
}

static GObject *
folks_dummy_persona_store_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksDummyPersonaStore * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* _tmp5_;
	parent_class = G_OBJECT_CLASS (folks_dummy_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp3_;
	_tmp4_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_pending_persona_registrations);
	self->priv->_pending_persona_registrations = _tmp4_;
	_tmp5_ = gee_hash_set_new (FOLKS_DUMMY_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_pending_persona_unregistrations);
	self->priv->_pending_persona_unregistrations = _tmp5_;
	return obj;
}

static void
folks_dummy_persona_store_class_init (FolksDummyPersonaStoreClass * klass,
                                      gpointer klass_data)
{
	gchar** _tmp0_;
	folks_dummy_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksDummyPersonaStore_private_offset);
	((FolksPersonaStoreClass *) klass)->add_persona_from_details = (void (*) (FolksPersonaStore*, GHashTable*, GAsyncReadyCallback, gpointer)) folks_dummy_persona_store_real_add_persona_from_details;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details_finish = (FolksPersona* (*) (FolksPersonaStore*, GAsyncResult*, GError**)) folks_dummy_persona_store_add_persona_from_details_finish;
	((FolksPersonaStoreClass *) klass)->remove_persona = (void (*) (FolksPersonaStore*, FolksPersona*, GAsyncReadyCallback, gpointer)) folks_dummy_persona_store_real_remove_persona;
	((FolksPersonaStoreClass *) klass)->remove_persona_finish = (void (*) (FolksPersonaStore*, GAsyncResult*, GError**)) folks_dummy_persona_store_remove_persona_finish;
	((FolksPersonaStoreClass *) klass)->prepare = (void (*) (FolksPersonaStore*, GAsyncReadyCallback, gpointer)) folks_dummy_persona_store_real_prepare;
	((FolksPersonaStoreClass *) klass)->prepare_finish = (void (*) (FolksPersonaStore*, GAsyncResult*, GError**)) folks_dummy_persona_store_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = folks_dummy_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = folks_dummy_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = folks_dummy_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = folks_dummy_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = folks_dummy_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = folks_dummy_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = folks_dummy_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = folks_dummy_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = folks_dummy_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_dummy_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_dummy_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_dummy_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_dummy_persona_store_finalize;
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_TYPE_ID_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_TYPE_ID_PROPERTY] = g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY] = g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY] = g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY] = g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY] = g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_IS_PREPARED_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY] = g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_IS_QUIESCENT_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_PERSONAS_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_PERSONAS_PROPERTY] = g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Type of programmatically created personas.
	   *
	   * This is the type used to create new personas when
	   * {@link Folks.PersonaStore.add_persona_from_details} is called. It must be a
	   * subtype of {@link FolksDummy.Persona}.
	   *
	   * This may be modified at any time, with modifications taking effect for the
	   * next call to {@link Folks.PersonaStore.add_persona_from_details} or
	   * {@link FolksDummy.PersonaStore.register_personas}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE_PROPERTY, folks_dummy_persona_store_properties[FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE_PROPERTY] = g_param_spec_gtype ("persona-type", "persona-type", "persona-type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_dummy_persona_store__always_writeable_properties_empty = _tmp0_;
	folks_dummy_persona_store__always_writeable_properties_empty_length1 = 0;
}

static void
folks_dummy_persona_store_instance_init (FolksDummyPersonaStore * self,
                                         gpointer klass)
{
	gchar** _tmp0_;
	self->priv = folks_dummy_persona_store_get_instance_private (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_quiescent_on_prepare = FALSE;
	self->priv->_contact_id = 0;
	self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_FALSE;
	self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_FALSE;
	self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_FALSE;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_always_writeable_properties = _tmp0_;
	self->priv->_always_writeable_properties_length1 = 0;
	self->priv->__always_writeable_properties_size_ = self->priv->_always_writeable_properties_length1;
	self->priv->_personas_changed_frozen = (guint) 0;
	self->priv->_add_persona_from_details_mock = NULL;
	self->priv->_add_persona_from_details_mock_target = NULL;
	self->priv->_remove_persona_mock = NULL;
	self->priv->_remove_persona_mock_target = NULL;
	self->priv->_prepare_mock = NULL;
	self->priv->_prepare_mock_target = NULL;
	self->priv->_persona_type = FOLKS_DUMMY_TYPE_PERSONA;
}

static void
folks_dummy_persona_store_finalize (GObject * obj)
{
	FolksDummyPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore);
	self->priv->_always_writeable_properties = (_vala_array_free (self->priv->_always_writeable_properties, self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_pending_persona_registrations);
	_g_object_unref0 (self->priv->_pending_persona_unregistrations);
	G_OBJECT_CLASS (folks_dummy_persona_store_parent_class)->finalize (obj);
}

/**
 * A persona store which allows {@link FolksDummy.Persona}s to be
 * programmatically created and manipulated, for the purposes of testing the
 * core of libfolks itself. This should not be used in user-visible
 * applications.
 *
 * There are two sides to this class’ interface: the methods and properties
 * declared by {@link Folks.PersonaStore}, which form the normal libfolks
 * persona store API; and the mock methods and properties (see for example
 * {@link FolksDummy.PersonaStore.set_add_persona_from_details_mock}) which are
 * intended to be used by test driver code to simulate the behaviour of a real
 * backing store. Calls to these mock methods effect state changes in the store
 * which are visible in the normal libfolks API. The ``update_``, ``register_``
 * and ``unregister_`` prefixes and the ``mock`` suffix are commonly used for
 * backing store methods.
 *
 * The main action performed with a dummy persona store is to change its set of
 * personas, adding and removing them dynamically to test client-side behaviour.
 * The client-side APIs ({@link Folks.PersonaStore.add_persona_from_details} and
 * {@link Folks.PersonaStore.remove_persona}) should //not// be used for this.
 * Instead, the mock APIs should be used:
 * {@link FolksDummy.PersonaStore.freeze_personas_changed},
 * {@link FolksDummy.PersonaStore.register_personas},
 * {@link FolksDummy.PersonaStore.unregister_personas} and
 * {@link FolksDummy.PersonaStore.thaw_personas_changed}. These can be used to
 * build up complex {@link Folks.PersonaStore.personas_changed} signal
 * emissions, which are only emitted after the final call to
 * {@link FolksDummy.PersonaStore.thaw_personas_changed}.
 *
 * The API in {@link FolksDummy} is unstable and may change wildly. It is
 * designed mostly for use by libfolks unit tests.
 *
 * @since 0.9.7
 */
static GType
folks_dummy_persona_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksDummyPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_dummy_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksDummyPersonaStore), 0, (GInstanceInitFunc) folks_dummy_persona_store_instance_init, NULL };
	GType folks_dummy_persona_store_type_id;
	folks_dummy_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "FolksDummyPersonaStore", &g_define_type_info, 0);
	FolksDummyPersonaStore_private_offset = g_type_add_instance_private (folks_dummy_persona_store_type_id, sizeof (FolksDummyPersonaStorePrivate));
	return folks_dummy_persona_store_type_id;
}

GType
folks_dummy_persona_store_get_type (void)
{
	static volatile gsize folks_dummy_persona_store_type_id__once = 0;
	if (g_once_init_enter (&folks_dummy_persona_store_type_id__once)) {
		GType folks_dummy_persona_store_type_id;
		folks_dummy_persona_store_type_id = folks_dummy_persona_store_get_type_once ();
		g_once_init_leave (&folks_dummy_persona_store_type_id__once, folks_dummy_persona_store_type_id);
	}
	return folks_dummy_persona_store_type_id__once;
}

static void
_vala_folks_dummy_persona_store_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	FolksDummyPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore);
	switch (property_id) {
		case FOLKS_DUMMY_PERSONA_STORE_TYPE_ID_PROPERTY:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_CAN_ADD_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_CAN_ALIAS_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_CAN_GROUP_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_CAN_REMOVE_PERSONAS_PROPERTY:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_IS_PREPARED_PROPERTY:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case FOLKS_DUMMY_PERSONA_STORE_IS_QUIESCENT_PROPERTY:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_PERSONAS_PROPERTY:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE_PROPERTY:
		g_value_set_gtype (value, folks_dummy_persona_store_get_persona_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_dummy_persona_store_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	FolksDummyPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore);
	switch (property_id) {
		case FOLKS_DUMMY_PERSONA_STORE_PERSONA_TYPE_PROPERTY:
		folks_dummy_persona_store_set_persona_type (self, g_value_get_gtype (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

