/* chess-piece.c generated by valac 0.56.2, the Vala compiler
 * generated from chess-piece.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2016 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "libchess.h"
#include <glib.h>
#include <glib-object.h>

enum  {
	CHESS_PIECE_0_PROPERTY,
	CHESS_PIECE_COLOR_PROPERTY,
	CHESS_PIECE_SYMBOL_PROPERTY,
	CHESS_PIECE_NUM_PROPERTIES
};
static GParamSpec* chess_piece_properties[CHESS_PIECE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	CHESS_PIECE_MOVED_SIGNAL,
	CHESS_PIECE_PROMOTED_SIGNAL,
	CHESS_PIECE_DIED_SIGNAL,
	CHESS_PIECE_NUM_SIGNALS
};
static guint chess_piece_signals[CHESS_PIECE_NUM_SIGNALS] = {0};

static gpointer chess_piece_parent_class = NULL;

static void chess_piece_finalize (GObject * obj);
static GType chess_piece_get_type_once (void);
static void _vala_chess_piece_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);

static GType
piece_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PIECE_TYPE_PAWN, "PIECE_TYPE_PAWN", "pawn"}, {PIECE_TYPE_ROOK, "PIECE_TYPE_ROOK", "rook"}, {PIECE_TYPE_KNIGHT, "PIECE_TYPE_KNIGHT", "knight"}, {PIECE_TYPE_BISHOP, "PIECE_TYPE_BISHOP", "bishop"}, {PIECE_TYPE_QUEEN, "PIECE_TYPE_QUEEN", "queen"}, {PIECE_TYPE_KING, "PIECE_TYPE_KING", "king"}, {0, NULL, NULL}};
	GType piece_type_type_id;
	piece_type_type_id = g_enum_register_static ("PieceType", values);
	return piece_type_type_id;
}

GType
piece_type_get_type (void)
{
	static volatile gsize piece_type_type_id__once = 0;
	if (g_once_init_enter (&piece_type_type_id__once)) {
		GType piece_type_type_id;
		piece_type_type_id = piece_type_get_type_once ();
		g_once_init_leave (&piece_type_type_id__once, piece_type_type_id);
	}
	return piece_type_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ChessPiece*
chess_piece_construct (GType object_type,
                       ChessPlayer* player,
                       PieceType type)
{
	ChessPiece * self = NULL;
	ChessPlayer* _tmp0_;
	g_return_val_if_fail (player != NULL, NULL);
	self = (ChessPiece*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (player);
	_g_object_unref0 (self->player);
	self->player = _tmp0_;
	self->type = type;
	return self;
}

ChessPiece*
chess_piece_new (ChessPlayer* player,
                 PieceType type)
{
	return chess_piece_construct (TYPE_CHESS_PIECE, player, type);
}

Color
chess_piece_get_color (ChessPiece* self)
{
	Color result;
	ChessPlayer* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->player;
	result = _tmp0_->color;
	return result;
}

gunichar
chess_piece_get_symbol (ChessPiece* self)
{
	gunichar result;
	gunichar c = 0U;
	ChessPlayer* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	c = (gunichar) ' ';
	switch (self->type) {
		case PIECE_TYPE_PAWN:
		{
			c = (gunichar) 'p';
			break;
		}
		case PIECE_TYPE_ROOK:
		{
			c = (gunichar) 'r';
			break;
		}
		case PIECE_TYPE_KNIGHT:
		{
			c = (gunichar) 'n';
			break;
		}
		case PIECE_TYPE_BISHOP:
		{
			c = (gunichar) 'b';
			break;
		}
		case PIECE_TYPE_QUEEN:
		{
			c = (gunichar) 'q';
			break;
		}
		case PIECE_TYPE_KING:
		{
			c = (gunichar) 'k';
			break;
		}
		default:
		break;
	}
	_tmp0_ = self->player;
	if (_tmp0_->color == COLOR_WHITE) {
		c = g_unichar_toupper (c);
	}
	result = c;
	return result;
}

static void
chess_piece_class_init (ChessPieceClass * klass,
                        gpointer klass_data)
{
	chess_piece_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_piece_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_piece_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_PIECE_COLOR_PROPERTY, chess_piece_properties[CHESS_PIECE_COLOR_PROPERTY] = g_param_spec_enum ("color", "color", "color", TYPE_COLOR, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_PIECE_SYMBOL_PROPERTY, chess_piece_properties[CHESS_PIECE_SYMBOL_PROPERTY] = g_param_spec_uint ("symbol", "symbol", "symbol", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	chess_piece_signals[CHESS_PIECE_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_piece_signals[CHESS_PIECE_PROMOTED_SIGNAL] = g_signal_new ("promoted", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_piece_signals[CHESS_PIECE_DIED_SIGNAL] = g_signal_new ("died", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
chess_piece_instance_init (ChessPiece * self,
                           gpointer klass)
{
}

static void
chess_piece_finalize (GObject * obj)
{
	ChessPiece * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PIECE, ChessPiece);
	_g_object_unref0 (self->player);
	G_OBJECT_CLASS (chess_piece_parent_class)->finalize (obj);
}

static GType
chess_piece_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessPieceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_piece_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPiece), 0, (GInstanceInitFunc) chess_piece_instance_init, NULL };
	GType chess_piece_type_id;
	chess_piece_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessPiece", &g_define_type_info, 0);
	return chess_piece_type_id;
}

GType
chess_piece_get_type (void)
{
	static volatile gsize chess_piece_type_id__once = 0;
	if (g_once_init_enter (&chess_piece_type_id__once)) {
		GType chess_piece_type_id;
		chess_piece_type_id = chess_piece_get_type_once ();
		g_once_init_leave (&chess_piece_type_id__once, chess_piece_type_id);
	}
	return chess_piece_type_id__once;
}

static void
_vala_chess_piece_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	ChessPiece * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PIECE, ChessPiece);
	switch (property_id) {
		case CHESS_PIECE_COLOR_PROPERTY:
		g_value_set_enum (value, chess_piece_get_color (self));
		break;
		case CHESS_PIECE_SYMBOL_PROPERTY:
		g_value_set_uint (value, chess_piece_get_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

